#! /bin/sh

# Test fk visualisation in tables and construction ajax2 dropdown lists for fk

TMP_DIR="${TMPDIR}"

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pl)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

# Set up the testing "sandbox":
SRC_DB_DIR=db
TMP_DB_DIR=${TMP_DIR}/db
mkdir ${TMP_DB_DIR}

SRC_DB_FILE=${SRC_DB_DIR}/test4fk.db

TMP_TEST_DB=$(basename ${SRC_DB_FILE})
TMP_DB_FILE=${TMP_DB_DIR}/${TMP_TEST_DB}
TMP_DB_META=${TMP_DB_DIR}/restful.db
TMP_DB_FILE_ABS=$(cd $(dirname ${TMP_DB_FILE}); pwd)/${TMP_TEST_DB}

cp ${SRC_DB_FILE} ${TMP_DB_FILE}

mkdir ${TMP_DIR}/website
mkdir ${TMP_DIR}/website/cgi-bin
mkdir ${TMP_DIR}/tests

cp ${INPUT_SCRIPT} ${TMP_DIR}/website/cgi-bin

ln -s $(pwd)/lib ${TMP_DIR}
ln -s $(pwd)/sql ${TMP_DIR}
ln -s $(pwd)/tests/inputs ${TMP_DIR}/tests

mkdir -p ${TMP_DIR}/${BIN_DIR}

cp ${INPUT_SCRIPT} ${TMP_DIR}/${BIN_DIR}

# Change dir to the sandbox and run the test:

cd ${TMP_DIR}

sqlite3 ${TMP_DB_META} < sql/metatables.sql
sqlite3 ${TMP_DB_META} "insert into description (dbname, dbtable, dbcolumn, coltype) values ('${TMP_DB_FILE_ABS}', 'sample', 'id', 'id')"
sqlite3 ${TMP_DB_META} "insert into description (dbname, dbtable, dbcolumn, coltype, fk_target, relation) values ('${TMP_DB_FILE_ABS}', 'experiment', 'sample_id', 'fk', 1, 'N')"
sqlite3 ${TMP_DB_META} "insert into fk_format (dbname, dbtable, format) values ('${TMP_DB_FILE_ABS}', 'sample', 'ID:%(SolsaID)s, locality: %(locality)s')"

sqlite3 ${TMP_DB_FILE} "insert into sample values (4,'XX-TEST-0004','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (5,'XX-TEST-0055',NULL,NULL,'Pyrite')"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (4,5,'LIBS', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (5,4,'EXAFS','2017-12-23',18.4,0.02)"

sqlite3 ${TMP_DB_FILE} "insert into sample values (7,'XX-TEST-007','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (8,'XX-TEST-008','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (9,'XX-TEST-009','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (10,'XX-TEST-010','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (11,'XX-TEST-011','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (12,'XX-TEST-012','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (13,'XX-TEST-013','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (14,'XX-TEST-014','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (15,'XX-TEST-015','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (16,'XX-TEST-016','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (17,'XX-TEST-017','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (18,'XX-TEST-018','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (19,'XX-TEST-019','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (20,'XX-TEST-020','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (21,'XX-TEST-021','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (22,'XX-TEST-022','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (23,'XX-TEST-023','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (24,'XX-TEST-024','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (25,'XX-TEST-025','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (26,'XX-TEST-026','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (27,'XX-TEST-027','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (28,'XX-TEST-028','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (29,'XX-TEST-029','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (30,'XX-TEST-030','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (31,'XX-TEST-031','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (32,'XX-TEST-032','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (33,'XX-TEST-033','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (34,'XX-TEST-034','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (35,'XX-TEST-035','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (36,'XX-TEST-036','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (37,'XX-TEST-037','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (38,'XX-TEST-038','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (39,'XX-TEST-039','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (40,'XX-TEST-040','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (41,'XX-TEST-041','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (42,'XX-TEST-042','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (43,'XX-TEST-043','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (44,'XX-TEST-044','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (45,'XX-TEST-045','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (46,'XX-TEST-046','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (47,'XX-TEST-047','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (48,'XX-TEST-048','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (49,'XX-TEST-049','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (50,'XX-TEST-050','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (51,'XX-TEST-051','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (52,'XX-TEST-052','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (53,'XX-TEST-053','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (54,'XX-TEST-054','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (55,'XX-TEST-055','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (56,'XX-TEST-056','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (57,'XX-TEST-057','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (58,'XX-TEST-058','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (59,'XX-TEST-059','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (60,'XX-TEST-060','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (61,'XX-TEST-061','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (62,'XX-TEST-062','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (63,'XX-TEST-063','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (64,'XX-TEST-064','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (65,'XX-TEST-065','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (66,'XX-TEST-066','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (67,'XX-TEST-067','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (68,'XX-TEST-068','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (69,'XX-TEST-069','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (70,'XX-TEST-070','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (71,'XX-TEST-071','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (72,'XX-TEST-072','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (73,'XX-TEST-073','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (74,'XX-TEST-074','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (75,'XX-TEST-075','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (76,'XX-TEST-076','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (77,'XX-TEST-077','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (78,'XX-TEST-078','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (79,'XX-TEST-079','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (80,'XX-TEST-080','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (81,'XX-TEST-081','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (82,'XX-TEST-082','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (83,'XX-TEST-083','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (84,'XX-TEST-084','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (85,'XX-TEST-085','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (86,'XX-TEST-086','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (87,'XX-TEST-087','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (88,'XX-TEST-088','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (89,'XX-TEST-089','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (90,'XX-TEST-090','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (91,'XX-TEST-091','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (92,'XX-TEST-092','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (93,'XX-TEST-093','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (94,'XX-TEST-094','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (95,'XX-TEST-095','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (96,'XX-TEST-096','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (97,'XX-TEST-097','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (98,'XX-TEST-098','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (99,'XX-TEST-099','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (100,'XX-TEST-100','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (101,'XX-TEST-101','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (102,'XX-TEST-102','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (103,'XX-TEST-103','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (104,'XX-TEST-104','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (105,'XX-TEST-105','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (106,'XX-TEST-106','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (107,'XX-TEST-107','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (108,'XX-TEST-108','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (109,'XX-TEST-109','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (110,'XX-TEST-110','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (111,'XX-TEST-111','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (112,'XX-TEST-112','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (113,'XX-TEST-113','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (114,'XX-TEST-114','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (115,'XX-TEST-115','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (116,'XX-TEST-116','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (117,'XX-TEST-117','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (118,'XX-TEST-118','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (119,'XX-TEST-119','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (120,'XX-TEST-120','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (121,'XX-TEST-121','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (122,'XX-TEST-122','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (123,'XX-TEST-123','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (124,'XX-TEST-124','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (125,'XX-TEST-125','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (126,'XX-TEST-126','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (127,'XX-TEST-127','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (128,'XX-TEST-128','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (129,'XX-TEST-129','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (130,'XX-TEST-130','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (131,'XX-TEST-131','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (132,'XX-TEST-132','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (133,'XX-TEST-133','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (134,'XX-TEST-134','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (135,'XX-TEST-135','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (136,'XX-TEST-136','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (137,'XX-TEST-137','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (138,'XX-TEST-138','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (139,'XX-TEST-139','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (140,'XX-TEST-140','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (141,'XX-TEST-141','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (142,'XX-TEST-142','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (143,'XX-TEST-143','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (144,'XX-TEST-144','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (145,'XX-TEST-145','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (146,'XX-TEST-146','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (147,'XX-TEST-147','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (148,'XX-TEST-148','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (149,'XX-TEST-149','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (150,'XX-TEST-150','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (151,'XX-TEST-151','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (152,'XX-TEST-152','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (153,'XX-TEST-153','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (154,'XX-TEST-154','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (155,'XX-TEST-155','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (156,'XX-TEST-156','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (157,'XX-TEST-157','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (158,'XX-TEST-158','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (159,'XX-TEST-159','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (160,'XX-TEST-160','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (161,'XX-TEST-161','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (162,'XX-TEST-162','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (163,'XX-TEST-163','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (164,'XX-TEST-164','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (165,'XX-TEST-165','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (166,'XX-TEST-166','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (167,'XX-TEST-167','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (168,'XX-TEST-168','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (169,'XX-TEST-169','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (170,'XX-TEST-170','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (171,'XX-TEST-171','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (172,'XX-TEST-172','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (173,'XX-TEST-173','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (174,'XX-TEST-174','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (175,'XX-TEST-175','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (176,'XX-TEST-176','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (177,'XX-TEST-177','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (178,'XX-TEST-178','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (179,'XX-TEST-179','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (180,'XX-TEST-180','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (181,'XX-TEST-181','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (182,'XX-TEST-182','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (183,'XX-TEST-183','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (184,'XX-TEST-184','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (185,'XX-TEST-185','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (186,'XX-TEST-186','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (187,'XX-TEST-187','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (188,'XX-TEST-188','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (189,'XX-TEST-189','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (190,'XX-TEST-190','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (191,'XX-TEST-191','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (192,'XX-TEST-192','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (193,'XX-TEST-193','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (194,'XX-TEST-194','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (195,'XX-TEST-195','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (196,'XX-TEST-196','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (197,'XX-TEST-197','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (198,'XX-TEST-198','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into sample values (199,'XX-TEST-199','New Caledonia',NULL,'')"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (6,199,'FHKJNG', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (7,198,'FXMSIH', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (8,197,'IRJKNR', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (9,196,'KPSQHF', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (10,195,'KWFLXY', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (11,194,'GHUPNQ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (12,193,'GMPYLV', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (13,192,'KSQFFJ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (14,191,'ONVOUQ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (15,190,'KXYQQF', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (16,189,'RGSRNX', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (17,188,'GXWITM', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (18,187,'MYPYHQ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (19,186,'JXINNF', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (20,185,'VWNWIX', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (21,184,'HYWOXT', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (22,183,'FVRNMQ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (23,182,'TPJVYH', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (24,181,'NYOWJY', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (25,180,'VPXXIM', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (26,179,'FIGPQX', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (27,178,'UQSUUH', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (28,177,'SVOQIW', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (29,176,'THSTXY', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (30,175,'QYMSKX', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (31,174,'NOHKIR', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (32,173,'MIVWQK', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (33,172,'FIRHOS', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (34,171,'SJTIJR', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (35,170,'QVQTSP', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (36,169,'LKQYJX', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (37,168,'HOHSTJ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (38,167,'KFVILI', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (39,166,'FJPGYJ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (40,165,'YRYLPW', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (41,164,'TXJMNM', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (42,163,'NFGTIO', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (43,162,'GNVRIR', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (44,161,'JNSMKO', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (45,160,'TNMIMU', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (46,159,'FIJSLR', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (47,158,'SSILHH', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (48,157,'YLMQIJ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (49,156,'UPHVIJ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (50,155,'PULGYL', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (51,154,'RHPRMQ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (52,153,'SOHXKF', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (53,152,'FGUKNL', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (54,151,'YQYTLM', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (55,150,'PUPFSF', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (56,149,'TMXTOH', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (57,148,'YJIJGK', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (58,147,'ONSRWG', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (59,146,'TUOWTI', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (60,145,'JWTSYF', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (61,144,'WSXJGS', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (62,143,'LXPFNI', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (63,142,'VYTFGG', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (64,141,'RQLPTO', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (65,140,'LYQHRJ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (66,139,'TIOOOP', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (67,138,'RYWJMX', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (68,137,'IQJJWL', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (69,136,'VRYTPN', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (70,135,'TYQYGR', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (71,134,'XSOLKM', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (72,133,'KGOULQ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (73,132,'OPRSVW', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (74,131,'JUXWTI', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (75,130,'OXSUNO', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (76,129,'FKPYLX', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (77,128,'QGPIQM', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (78,127,'JYJIFW', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (79,126,'RPKSQO', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (80,125,'TOXIUO', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (81,124,'IUXYTW', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (82,123,'JUHTSF', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (83,122,'XMQMMW', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (84,121,'SQXNLW', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (85,120,'KYWLSF', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (86,119,'ITFSGI', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (87,118,'PFTKSP', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (88,117,'LXUXGN', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (89,116,'QYQKYQ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (90,115,'NVQVSJ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (91,114,'OHMXVN', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (92,113,'KKJWTK', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (93,112,'YIRWQN', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (94,111,'IRRNKK', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (95,110,'LXSUTR', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (96,109,'PVSOTN', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (97,108,'JWSGLK', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (98,107,'IHUGYJ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (99,106,'VPVLYH', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (100,105,'TGLMHR', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (101,104,'YHJVNX', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (102,103,'NPIIJI', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (103,102,'IHMMYV', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (104,101,'NFTWXQ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (105,100,'TVRNFH', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (106,99,'NSJTOG', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (107,98,'IPUIFX', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (108,97,'FFOSPS', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (109,96,'PJQPPF', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (110,95,'LVUGGF', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (111,94,'WILFKS', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (112,93,'RHOMWI', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (113,92,'PXQQQL', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (114,91,'XNKFLJ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (115,90,'PHUMJL', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (116,89,'MKFFQJ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (117,88,'KSFQHY', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (118,87,'YMSUWJ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (119,86,'LXSROF', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (120,85,'MGRWXN', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (121,84,'YFOUNH', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (122,83,'JQXLTV', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (123,82,'YIVPWK', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (124,81,'GKUWVW', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (125,80,'NHYUOY', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (126,79,'IKFGJF', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (127,78,'LIMNFT', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (128,77,'VNLNIV', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (129,76,'MKQWIG', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (130,75,'PMRIRH', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (131,74,'XVGFGV', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (132,73,'PPOUXM', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (133,72,'MOFGSI', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (134,71,'TNLPKP', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (135,70,'HYNJLS', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (136,69,'YIIOOI', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (137,68,'FNTYOJ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (138,67,'QTPUNM', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (139,66,'MYUJOV', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (140,65,'JLKWRS', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (141,64,'MJKKWL', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (142,63,'HOONWV', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (143,62,'RQRIPP', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (144,61,'HTFJKT', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (145,60,'GUVUVQ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (146,59,'RVMOWW', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (147,58,'GLLMSR', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (148,57,'LKWJGJ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (149,56,'KRQSJP', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (150,55,'LKYJQU', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (151,54,'XWJYKW', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (152,53,'THSPGT', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (153,52,'UTUSFN', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (154,51,'WWLJLX', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (155,50,'RTLKRX', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (156,49,'SLHXXQ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (157,48,'QVJQMT', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (158,47,'NGOIQT', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (159,46,'HHHIIW', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (160,45,'XNITGM', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (161,44,'HMIHPF', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (162,43,'POYGVR', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (163,42,'QOUYXG', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (164,41,'OOUXKT', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (165,40,'YIYRIS', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (166,39,'OQHUIO', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (167,38,'LJKQRX', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (168,37,'KLYLGF', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (169,36,'JWLLVK', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (170,35,'NYQVMT', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (171,34,'PHVOPX', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (172,33,'WHKQTS', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (173,32,'LVMIQR', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (174,31,'XJFNHO', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (175,30,'FOHMXK', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (176,29,'IQTNKP', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (177,28,'TWHJUH', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (178,27,'GUITYF', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (179,26,'OVNXNP', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (180,25,'OYHHSI', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (181,24,'ROFFLN', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (182,23,'NNGGPQ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (183,22,'SLJOMG', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (184,21,'XSFGGT', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (185,20,'TLHPWI', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (186,19,'NXGQOI', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (187,18,'ITKLQQ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (188,17,'OKPVTQ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (189,16,'MOPVOW', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (190,15,'THNHLT', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (191,14,'QXXRXV', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (192,13,'MHNSVJ', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (193,12,'HRUOHF', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (194,11,'LUOJNP', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (195,10,'NPSHPP', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (196,9,'RLTKTX', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (197,8,'OVOQNO', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (198,7,'XNSQLL', '2017-12-23',8.3,NULL)"
sqlite3 ${TMP_DB_FILE} "insert into experiment values (199,6,'MQMKPW', '2017-12-23',8.3,NULL)"


export REQUEST_URI='/~saulius/restful/website/test4fk.db/experiment'
export REQUEST_METHOD=get
export HTTP_HOST=test.domain.net

${INPUT_SCRIPT}

# Go back to the original directory before deleting the temporary one:
cd - > /dev/null

# Temporary directory will be deleted by the trap.
