use pipeline::Pipeline;

pub fn make_pipeline() -> Pipeline {
    Pipeline {
        queue: vec![
            ("trimmer-it".into(), trimmer),
            ("stopWordFilter-it".into(), stop_word_filter),
            ("stemmer-it".into(), stemmer),
        ],
    }
}

make_trimmer!(
    "A-Za-z\\xAA\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02B8\\u02E0-\\u02E4\\u1D00-\\u1D25\
     \\u1D2C-\\u1D5C\\u1D62-\\u1D65\\u1D6B-\\u1D77\\u1D79-\\u1DBE\\u1E00-\\u1EFF\\u2071\\u207F\
     \\u2090-\\u209C\\u212A\\u212B\\u2132\\u214E\\u2160-\\u2188\\u2C60-\\u2C7F\\uA722-\\uA787\
     \\uA78B-\\uA7AD\\uA7B0-\\uA7B7\\uA7F7-\\uA7FF\\uAB30-\\uAB5A\\uAB5C-\\uAB64\\uFB00-\\uFB06\
     \\uFF21-\\uFF3A\\uFF41-\\uFF5A"
);

make_stop_word_filter!([
    "",
    "a",
    "abbia",
    "abbiamo",
    "abbiano",
    "abbiate",
    "ad",
    "agl",
    "agli",
    "ai",
    "al",
    "all",
    "alla",
    "alle",
    "allo",
    "anche",
    "avemmo",
    "avendo",
    "avesse",
    "avessero",
    "avessi",
    "avessimo",
    "aveste",
    "avesti",
    "avete",
    "aveva",
    "avevamo",
    "avevano",
    "avevate",
    "avevi",
    "avevo",
    "avrai",
    "avranno",
    "avrebbe",
    "avrebbero",
    "avrei",
    "avremmo",
    "avremo",
    "avreste",
    "avresti",
    "avrete",
    "avrà",
    "avrò",
    "avuta",
    "avute",
    "avuti",
    "avuto",
    "c",
    "che",
    "chi",
    "ci",
    "coi",
    "col",
    "come",
    "con",
    "contro",
    "cui",
    "da",
    "dagl",
    "dagli",
    "dai",
    "dal",
    "dall",
    "dalla",
    "dalle",
    "dallo",
    "degl",
    "degli",
    "dei",
    "del",
    "dell",
    "della",
    "delle",
    "dello",
    "di",
    "dov",
    "dove",
    "e",
    "ebbe",
    "ebbero",
    "ebbi",
    "ed",
    "era",
    "erano",
    "eravamo",
    "eravate",
    "eri",
    "ero",
    "essendo",
    "faccia",
    "facciamo",
    "facciano",
    "facciate",
    "faccio",
    "facemmo",
    "facendo",
    "facesse",
    "facessero",
    "facessi",
    "facessimo",
    "faceste",
    "facesti",
    "faceva",
    "facevamo",
    "facevano",
    "facevate",
    "facevi",
    "facevo",
    "fai",
    "fanno",
    "farai",
    "faranno",
    "farebbe",
    "farebbero",
    "farei",
    "faremmo",
    "faremo",
    "fareste",
    "faresti",
    "farete",
    "farà",
    "farò",
    "fece",
    "fecero",
    "feci",
    "fosse",
    "fossero",
    "fossi",
    "fossimo",
    "foste",
    "fosti",
    "fu",
    "fui",
    "fummo",
    "furono",
    "gli",
    "ha",
    "hai",
    "hanno",
    "ho",
    "i",
    "il",
    "in",
    "io",
    "l",
    "la",
    "le",
    "lei",
    "li",
    "lo",
    "loro",
    "lui",
    "ma",
    "mi",
    "mia",
    "mie",
    "miei",
    "mio",
    "ne",
    "negl",
    "negli",
    "nei",
    "nel",
    "nell",
    "nella",
    "nelle",
    "nello",
    "noi",
    "non",
    "nostra",
    "nostre",
    "nostri",
    "nostro",
    "o",
    "per",
    "perché",
    "più",
    "quale",
    "quanta",
    "quante",
    "quanti",
    "quanto",
    "quella",
    "quelle",
    "quelli",
    "quello",
    "questa",
    "queste",
    "questi",
    "questo",
    "sarai",
    "saranno",
    "sarebbe",
    "sarebbero",
    "sarei",
    "saremmo",
    "saremo",
    "sareste",
    "saresti",
    "sarete",
    "sarà",
    "sarò",
    "se",
    "sei",
    "si",
    "sia",
    "siamo",
    "siano",
    "siate",
    "siete",
    "sono",
    "sta",
    "stai",
    "stando",
    "stanno",
    "starai",
    "staranno",
    "starebbe",
    "starebbero",
    "starei",
    "staremmo",
    "staremo",
    "stareste",
    "staresti",
    "starete",
    "starà",
    "starò",
    "stava",
    "stavamo",
    "stavano",
    "stavate",
    "stavi",
    "stavo",
    "stemmo",
    "stesse",
    "stessero",
    "stessi",
    "stessimo",
    "steste",
    "stesti",
    "stette",
    "stettero",
    "stetti",
    "stia",
    "stiamo",
    "stiano",
    "stiate",
    "sto",
    "su",
    "sua",
    "sue",
    "sugl",
    "sugli",
    "sui",
    "sul",
    "sull",
    "sulla",
    "sulle",
    "sullo",
    "suo",
    "suoi",
    "ti",
    "tra",
    "tu",
    "tua",
    "tue",
    "tuo",
    "tuoi",
    "tutti",
    "tutto",
    "un",
    "una",
    "uno",
    "vi",
    "voi",
    "vostra",
    "vostre",
    "vostri",
    "vostro",
    "è"
]);

make_stemmer!(Algorithm::Italian);
