#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include "config.h"

char compdate[]="Compiled " __DATE__ " " __TIME__ ;
char pgname[]="unisurrogate";

void
ShowVersion(void){
  fprintf(stderr,"\n%s  %s\n",pgname,PACKAGE_VERSION);
  fprintf(stderr,"%s\n",compdate);
  fprintf(stderr,"Copyright (C) 2009 William J. Poser\n");
  fprintf(stderr,"Released under the terms of the GNU General Public License, version 3.\n\n");
}

void
ShowUsage(void){
  fprintf(stderr,"Given a Unicode codepoint outside the BMP, report its surrogate decomposition\n");
  fprintf(stderr,"The codepoint may be given in raw hex or preceded by either U+ or 0x\n");
  fprintf(stderr,"Usage: %s [options] codepoint\n",pgname);
  fprintf(stderr,"       -h Print help information.\n");
  fprintf(stderr,"       -v Print version information.\n");
  putc('\n',stderr);
  fprintf(stderr,"Report bugs to: billposer@alum.mit.edu\n");
  putc('\n',stderr);
}

main(int ac, char **av) {
  u_int32_t cp, cpi, high, low;
  char *istr;
  char *endptr;

  extern int errno;

  if (ac != 2) {
    ShowUsage(); exit(1);
  }

  if (av[1][0] == '-') {
    if (av[1][1] == 'h') {ShowUsage(); exit(1);}
    else if (av[1][1] == 'v') {ShowVersion();exit(1);}
    fprintf(stderr, "Unrecognized option.\n");
    exit(2);
  }

  istr = av[1];
  if( (istr[0] == 'U') && (istr[1] == '+')) istr = istr+2;
  errno=0;
  cp = (u_int32_t) strtoull(istr,&endptr,16);
  if( (errno != 0) || (*endptr != '\0')){
    fprintf(stderr,"%s is not a valid codepoint.\n",istr);
    exit(2);
  }
  if( cp <= 0xFFFF) {
    printf("The codepoint U+%04x falls within plane 0.\n",cp);
    exit(0);
  }
  cpi = cp - 0x10000;
  high = (cpi / 0x400) + 0xD800;
  low =  (cpi % 0x400) + 0xDC00;
  printf("The surrogate representation of U+%X is U+%4X U+%4X\n",cp,high,low);
  exit(0);
}
