#!/bin/sh
#TYPEFACE=fixed
TYPEFACE=rovas
RES=100
ttF2BDf -f misc -t $TYPEFACE -w medium \
  -m $0  -p 13 -r $RES  \
  -o rovstd.bdf rovstd.ttf 
mkfontdir
xset fp rehash
xfd -fn "-misc-$TYPEFACE-medium-r-normal--18-130-$RES-$RES-p-90-iso10646-1"
exit 0
#
# Second Column: ROVSTD codes.
# First Column: Unicode PUA values. 
## 
REGISTRY ISO10646
ENCODING 1
0xEE00 0x61 #  OLD HUNGARIAN LETTER A
0xEE01 0x41 #  OLD HUNGARIAN LETTER AA
0xEE02 0x62 #  OLD HUNGARIAN LETTER EB
0xEE03 0x63 #  OLD HUNGARIAN LETTER EC
0xEE04 0x43 #  OLD HUNGARIAN LETTER ECS
0xEE05 0x64 #  OLD HUNGARIAN LETTER ED
#
# From this point on we shifted 1 from original proposal
#
0xEE06 0x48 #  OLD HUNGARIAN LETTER AE
0xEE07 0x65 #  OLD HUNGARIAN LETTER E
0xEE08 0x45 #  OLD HUNGARIAN LETTER EE
0xEE09 0x66 #  OLD HUNGARIAN LETTER EF
0xEE0A 0x67 #  OLD HUNGARIAN LETTER EG
0xEE0B 0x47 #  OLD HUNGARIAN LETTER EGY
0xEE0C 0x68 #  OLD HUNGARIAN LETTER EH
0xEE0D 0x69 #  OLD HUNGARIAN LETTER I
0xEE0E 0x49 #  OLD HUNGARIAN LETTER II
0xEE0F 0x6A #  OLD HUNGARIAN LETTER EJ
0xEE10 0x4B #  OLD HUNGARIAN LETTER AK
0xEE11 0x6B #  OLD HUNGARIAN LETTER EK
0xEE12 0x6C #  OLD HUNGARIAN LETTER EL
0xEE13 0x4C #  OLD HUNGARIAN LETTER ELY
0xEE14 0x6D #  OLD HUNGARIAN LETTER EM
0xEE15 0x6E #  OLD HUNGARIAN LETTER EN
0xEE16 0x4E #  OLD HUNGARIAN LETTER ENY
0xEE17 0x6F #  OLD HUNGARIAN LETTER O
0xEE18 0x4F #  OLD HUNGARIAN LETTER OO
0xEE19 0x71 #  OLD HUNGARIAN LETTER OE
0xEE1A 0x51 #  OLD HUNGARIAN LETTER OEE
0xEE1B 0x70 #  OLD HUNGARIAN LETTER EP
0xEE1C 0x72 #  OLD HUNGARIAN LETTER ER
0xEE1D 0x46 #  OLD HUNGARIAN LETTER AS
#
# From this point on we shifted 2 from original proposal
#
0xEE1E 0x73 #  OLD HUNGARIAN LETTER ES
0xEE1F 0x53 #  OLD HUNGARIAN LETTER ESZ
0xEE20 0x74 #  OLD HUNGARIAN LETTER ET
0xEE21 0x78 #  OLD HUNGARIAN LETTER ATY
#
# From this point on we shifted 3 from original proposal
#
0xEE22 0x54 #  OLD HUNGARIAN LETTER ETY
0xEE23 0x75 #  OLD HUNGARIAN LETTER U
0xEE24 0x55 #  OLD HUNGARIAN LETTER UU
0xEE25 0x77 #  OLD HUNGARIAN LETTER UE
0xEE26 0x57 #  OLD HUNGARIAN LETTER UEE
0xEE27 0x76 #  OLD HUNGARIAN LETTER EV
0xEE28 0x7A #  OLD HUNGARIAN LETTER EZ
0xEE29 0x5A #  OLD HUNGARIAN LETTER EZS
#
0xEE2F 0xBA # OLD HUNGARIAN SEPARATOR
#
# NUMBERS
#
0xEE31 0x79 #  OLD HUNGARIAN NUMBER ONE
0xEE35 0x59 #  OLD HUNGARIAN NUMBER FIVE
0xEE3A 0x58 #  OLD HUNGARIAN NUMBER TEN
0xEE3B 0x56 #  OLD HUNGARIAN NUMBER FIFTY
0xEE3C 0x42 #  OLD HUNGARIAN NUMBER ONE HUNDRED
0xEE3D 0x4D #  OLD HUNGARIAN NUMBER ONE THOUSAND

#
# LIGATURES
#
0xEE40 0xD8 # AB
0xEE41 0xA5 #  AD
0xEE42 0xAF #  AL
0xEE43 0x4A #  AMB
0xEE44 0xE1 #  AND
0xEE45 0xC1 #  ANT
0xEE46 0xE0 #  AR
0xEE47 0xEC #  ATT
0xEE48 0xEB #  AAR
0xEE49 0xC2 #  BA
0xEE4A 0xDC #   BE
0xEE4B 0xA1 # BET
0xEE4C 0xDA #  BI
0xEE4D 0xD3 #  BO
0xEE4E 0xB5 #  CAK
0xEE4F 0xF2 #  CK
0xEE50 0xBF #  CSA
0xEE51 0xC7 #  CSIN
0xEE52 0xCF #  DU
0xEE53 0xFB #  EMP
0xEE54 0xE9 #  ENT
0xEE55 0xE5 #  GA
0xEE56 0xCA #  GE
0xEE57 0xE6 #  GI
# rovtxt 0xEE58 0x8C #  GO
0xEE58 0x0152 #  GO
# rovtxt 0xEE59 0x9F #  HA
0xEE59 0x0178 #  HA
0xEE5A 0xDB #  HE
# rovtxt 0xEE5B 0x98 #  HI
0xEE5B 0x02DC #  HI
0xEE5C 0xF3 #  HO
# rovtxt 0xEE5D 0x85 #  IT
0xEE5D 0x2026 #  IT
0xEE5E 0xCD #  IRT
0xEE5F 0xFF #  LA

0xEE60 0xCE #  LAA
0xEE61 0xC9 #  LE
0xEE62 0xF9 #  LO
0xEE63 0xD2 #  LT
0xEE64 0xFC #  MB
0xEE65 0xC6 #  NA
0xEE66 0x50 #  NAP
0xEE67 0xED #  NB
0xEE68 0xF8 #  NE
0xEE69 0xEF #  ND
0xEE6A 0xD1 #  NGY
0xEE6B 0xA2 #  NI
0xEE6C 0xE2 #  NK
# rovtxt 0xEE6D 0x9C #  NT
0xEE6D 0x0153 #  NT
0xEE6E 0xA9 #  AR
0xEE6F 0xE4 #  RA


0xEE70 0xEE #  RE
0xEE71 0xC0 #  RI
0xEE72 0xAE #  RO
0xEE73 0xC3 #  RT
0xEE74 0xE7 #  RU
0xEE75 0xAC #  SA
0xEE76 0xDF #  SE
0xEE77 0xA3 #  SI
# rovtxt 0xEE78 0x83 #  SK
0xEE78 0x0192 #  SK
0xEE79 0xF1 #  SM
0xEE7A 0xC4 #  SO
0xEE7B 0xE3 #  SP
0xEE7C 0xE8 #  ST
0xEE7D 0xC5 #  SZT
0xEE7E 0xA8 #  TI
0xEE7F 0x52 #  TPRU

0xEE80 0x44 #  TPRUS
0xEE81 0xF4 #  TYA
0xEE82 0xEA #  UL
0xEE83 0xAA #  UM
# rovtxt 0xEE84 0x99 #  UNK
0xEE84 0x2122 #   UNK
0xEE85 0xCC #  UR
0xEE86 0xFA #  US
0xEE87 0xC8 #  VA
0xEE88 0xD4 #  VAAR
0xEE89 0xD9 #  ZA
0xEE8A 0xCB #  ZR
0xEE8B 0xB8 #  ZT
