require('./csl-validator.js');

const MLA = '<?xml version="1.0" encoding="utf-8"?><style xmlns="http://purl.org/net/xbiblio/csl" class="in-text" version="1.0" demote-non-dropping-particle="sort-only"><info><title>Modern Language Association</title><id>http://www.zotero.org/styles/mla</id><link href="http://www.zotero.org/styles/mla" rel="self"/><author><name>Ilouise S. Bradford</name><email>isbradford@gmail.com</email></author><contributor><name>Sarah Ficke</name><email>sficke@email.unc.edu</email></contributor><contributor><name>Sebastian Karcher</name><email>karcher@u.northwestern.edu</email></contributor><contributor><name>Christian Werthschulte</name><email>Christian.Werthschulte@rub.de</email></contributor><contributor><name>Simon Kornblith</name><email>simon@simonster.com</email></contributor><contributor><name>James Johnston</name><email>thejamesjohnston@gmail.com</email></contributor><category field="generic-base"/><category citation-format="author"/><link href="http://owl.english.purdue.edu/owl/section/2/11/" rel="documentation"/><updated>2011-05-28T18:16:02+00:00</updated><summary>This style adheres to the MLA 7th edition handbook and contains modifications to these types of sources: e-mail, forum posts, interviews, manuscripts, maps, presentations, TV broadcasts, and web pages.</summary><rights>This work is licensed under a Creative Commons Attribution-Share Alike 3.0 License: http://creativecommons.org/licenses/by-sa/3.0/</rights></info><locale xml:lang="en"><terms><term name="month-01" form="short">Jan.</term><term name="month-02" form="short">Feb.</term><term name="month-03" form="short">Mar.</term><term name="month-04" form="short">Apr.</term><term name="month-05" form="short">May</term><term name="month-06" form="short">June</term><term name="month-07" form="short">July</term><term name="month-08" form="short">Aug.</term><term name="month-09" form="short">Sept.</term><term name="month-10" form="short">Oct.</term><term name="month-11" form="short">Nov.</term><term name="month-12" form="short">Dec.</term><term name="volume" form="short"><single>Vol.</single><multiple>vols</multiple></term><term name="edition" form="short">ed</term></terms></locale><macro name="editor-translator"><names variable="editor translator" delimiter=". "><label form="verb-short" text-case="capitalize-first" suffix=". " strip-periods="true"/><name and="symbol" delimiter=", "/></names></macro><macro name="author"><names variable="author"><name name-as-sort-order="first" and="text" sort-separator=", " delimiter=", " delimiter-precedes-last="always"/><label form="short" prefix=", " suffix="." strip-periods="true"/><substitute><names variable="editor"/><names variable="translator"/><text macro="title"/></substitute></names></macro><macro name="author-short"><names variable="author"><name form="short" and="text" delimiter=", " initialize-with=". "/><substitute><names variable="editor"/><names variable="translator"/><text macro="title-short"/></substitute></names></macro><macro name="access"><group delimiter=" "><date variable="accessed"><date-part name="day" suffix=" "/><date-part name="month" form="short" suffix=" " strip-periods="false"/><date-part name="year"/></date></group></macro><macro name="medium"><choose><if type="motion_picture"><choose><if variable="medium"><text variable="medium" prefix=" "/></if><else><text value="Film" prefix=" "/></else></choose></if><else-if type="broadcast"><choose><if variable="medium"><text variable="medium" prefix=" "/></if><else><text value="Television" prefix=" "/></else></choose></else-if><else-if type="manuscript"><text value=""/></else-if><else-if type="personal_communication" match="any"><text value="" prefix=" "/></else-if><else-if type="speech" match="any"><text value=""/></else-if><else-if type="interview"><text variable="medium" prefix=" "/></else-if><else-if type="song"><choose><if variable="medium"><text variable="medium" prefix=" "/></if><else><text value="Audio Recording" prefix=" "/></else></choose></else-if><else><choose><if variable="URL DOI" match="any"><text variable="archive" prefix=" " suffix=". "/><text value="Web" prefix=" "/><text prefix=". " suffix="." macro="access"/></if><else><text value="Print" prefix=" "/></else></choose></else></choose></macro><macro name="title"><choose><if type="bill book graphic legal_case manuscript motion_picture report song" match="any"><text variable="title" font-style="italic" text-case="title"/></if><else-if type="interview personal_communication" match="any"><text variable="title" text-case="title" quotes="false"/></else-if><else><text variable="title" text-case="title" quotes="true"/></else></choose></macro><macro name="title-short"><choose><if type="bill book graphic legal_case manuscript motion_picture report song" match="any"><text variable="title" text-case="title" form="short" font-style="italic"/></if><else><text variable="title" text-case="title" form="short" quotes="true"/></else></choose></macro><macro name="pages"><choose><if variable="page"><text variable="page"/></if><else-if type="personal_communication interview" match="any"><text value=""/></else-if><else><text value="n. pag"/></else></choose></macro><macro name="edition"><choose><if is-numeric="edition"><group delimiter=" "><number variable="edition" form="ordinal"/><text term="edition" form="short" suffix="." strip-periods="true"/></group></if><else><text variable="edition"/></else></choose></macro><macro name="volume"><choose><if is-numeric="volume"><group delimiter=" "><text term="volume" form="short" strip-periods="false"/><number variable="volume"/></group></if><else><text variable="volume"/></else></choose></macro><macro name="number-of-volumes"><choose><if is-numeric="number-of-volumes"><group delimiter=" "><number variable="number-of-volumes"/><text term="volume" form="short" plural="true" strip-periods="true"/></group></if><else><text variable="number-of-volumes"/></else></choose></macro><macro name="collection-title"><text variable="collection-title" text-case="title" prefix=" "/></macro><macro name="collection-number"><text variable="collection-number" prefix=" " suffix="."/></macro><macro name="publisher-year"><group delimiter=", "><group delimiter=": "><text variable="publisher-place"/><text variable="publisher"/></group><date variable="issued"><date-part name="year"/></date></group></macro><citation et-al-min="4" et-al-use-first="1" disambiguate-add-names="true" disambiguate-add-givenname="true"><layout prefix="(" suffix=")" delimiter="; "><group delimiter=" "><choose><if variable="author editor translator" match="any"><group delimiter=", "><text macro="author-short"/><choose><if disambiguate="true"><text macro="title-short"/></if></choose></group></if><else><text macro="title-short"/></else></choose><text variable="locator"/></group></layout></citation><bibliography hanging-indent="true" et-al-min="4" et-al-use-first="1" line-spacing="2" entry-spacing="0" subsequent-author-substitute="---"><sort><key macro="author"/><key variable="title"/></sort><layout suffix="."><text macro="author" suffix="."/><text macro="title" prefix=" " suffix="."/><choose><if type="bill book graphic legal_case motion_picture report song" match="any"><text macro="edition" prefix=" " suffix="."/><text macro="editor-translator" prefix=" " suffix="."/><text macro="volume" prefix=" " suffix="."/><text macro="number-of-volumes" prefix=" " suffix="."/><text macro="publisher-year" prefix=" " suffix="."/></if><else-if type="chapter paper-conference" match="any"><group><text variable="container-title" text-case="title" font-style="italic" prefix=" " suffix="."/><text macro="edition" prefix=" " suffix="."/><text macro="editor-translator" prefix=" " suffix="."/><text macro="volume" prefix=" " suffix="."/><text macro="number-of-volumes" prefix=" " suffix="."/><text macro="publisher-year" prefix=" " suffix="."/></group><text variable="page" prefix=" " suffix="."/></else-if><else-if type="manuscript"><date variable="issued" prefix=" " suffix="."><date-part name="year"/></date><text variable="genre" prefix=" " suffix="."/><text variable="archive_location" prefix=" " suffix="."/><text variable="publisher-place" prefix=" "/></else-if><else-if type="personal_communication"><date variable="issued" prefix=" " suffix="."><date-part name="day" suffix=" "/><date-part name="month" form="short" suffix=" "/><date-part name="year"/></date><choose><if variable="genre"><text prefix=" " suffix="." variable="genre"/></if><else><text prefix=" " suffix="." value="E-mail"/></else></choose></else-if><else-if type="map"><text variable="genre" prefix=" " suffix="."/><text variable="publisher-place" prefix=" " suffix=":"/><text variable="publisher" prefix=" "/><date variable="issued" prefix=" " suffix=","><date-part name="year"/></date></else-if><else-if type="speech"><text variable="event" prefix=" " suffix="."/><text variable="publisher-place" prefix=" " suffix="."/><date variable="issued" prefix=" " suffix="."><date-part name="year"/></date><text variable="genre" prefix=" " suffix="."/></else-if><else-if type="webpage"><text variable="container-title" font-style="italic" prefix=" " suffix="."/><text variable="genre" prefix=" " suffix="."/><date variable="issued" prefix=" " suffix="."><date-part name="day" suffix=" "/><date-part name="month" form="short" suffix=" " strip-periods="false"/><date-part name="year"/></date></else-if><else-if type="broadcast"><text variable="container-title" font-style="italic" prefix=" " suffix="."/><text variable="publisher" prefix=" " suffix=","/><date variable="issued" prefix=" " suffix="."><date-part name="day" suffix=" "/><date-part name="month" form="short" suffix=" " strip-periods="false"/><date-part name="year"/></date></else-if><else><group prefix=" " suffix="." delimiter=": "><group delimiter=" "><text macro="editor-translator" suffix="."/><text variable="container-title" font-style="italic"/><choose><if type="article-journal"><group delimiter=" "><group delimiter="."><text variable="volume"/><text variable="issue"/></group><date variable="issued" prefix="(" suffix="):"><date-part name="year"/></date></group><text macro="pages" prefix=" "/></if><else><date variable="issued"><date-part name="day" suffix=" "/><date-part name="month" form="short" suffix=" " strip-periods="false"/><date-part name="year"/></date><choose><if variable="URL DOI" match="any"><text variable="page" prefix=": "/></if><else><text macro="pages" prefix=": "/></else></choose></else></choose></group></group></else></choose><text macro="medium" suffix="."/><text macro="collection-title"/><text macro="collection-number"/></layout></bibliography></style>';

var errors = validate(MLA);
if(errors) {
	throw "Test failed: valid style should not throw an error";
}

var errors = validate(MLA.replace("publisher-place", "blah"));
if(!errors) {
	throw "Test failed: invalid style should not throw an error";
}

console.log("Tests passed");