//  Copyright (c) 2007 John Maddock
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
   static const boost::array<boost::array<typename table_type<T>::type, 3>, 481> bessel_k_int_data = {{
      {{ SC_(0), SC_(0.177219114266335964202880859375e-2), SC_(0.6451475930592273598846015135698055330078e1) }}, 
      {{ SC_(0), SC_(0.22177286446094512939453125e-2), SC_(0.6227212142001190939808570915268231760654e1) }}, 
      {{ SC_(0), SC_(0.7444499991834163665771484375e-2), SC_(0.5016294646816679195434588077252051358532e1) }}, 
      {{ SC_(0), SC_(0.1433600485324859619140625e-1), SC_(0.4361188048817122598222684820956136285199e1) }}, 
      {{ SC_(0), SC_(0.1760916970670223236083984375e-1), SC_(0.4155666670689396106825982497779831275659e1) }}, 
      {{ SC_(0), SC_(0.6152711808681488037109375e-1), SC_(0.2907904688572973437220285912023264651352e1) }}, 
      {{ SC_(0), SC_(0.11958599090576171875e0), SC_(0.2251245456228397094716239150833833783688e1) }}, 
      {{ SC_(0), SC_(0.15262925624847412109375e0), SC_(0.2013151217079277922721039040650374928823e1) }}, 
      {{ SC_(0), SC_(0.408089816570281982421875e0), SC_(0.1097070466164341232251948278975330916289e1) }}, 
      {{ SC_(0), SC_(0.6540834903717041015625e0), SC_(0.7111296101768869724219672824880816154124e0) }}, 
      {{ SC_(0), SC_(0.1097540378570556640625e1), SC_(0.3668587200933656003255821289886727335553e0) }}, 
      {{ SC_(0), SC_(0.30944411754608154296875e1), SC_(0.3115344887529544812621292520040581803004e-1) }}, 
      {{ SC_(0), SC_(0.51139926910400390625e1), SC_(0.325805941096065330441380826151925706171e-2) }}, 
      {{ SC_(0), SC_(0.95070552825927734375e1), SC_(0.2983575249299677934623174911041338567643e-4) }}, 
      {{ SC_(0), SC_(0.24750102996826171875e2), SC_(0.4469793219985647671692938809730755521561e-11) }}, 
      {{ SC_(0), SC_(0.637722015380859375e2), SC_(0.3154890666025357981487513910165521100024e-28) }}, 
      {{ SC_(0), SC_(0.1252804412841796875e3), SC_(0.4365986153732310357450484955539750321993e-55) }}, 
      {{ SC_(0), SC_(0.25554705810546875e3), SC_(0.8155212353606568575514680314443449984517e-112) }}, 
      {{ SC_(0), SC_(0.503011474609375e3), SC_(0.1959094651632950581341362431434333187503e-219) }}, 
      {{ SC_(0), SC_(0.10074598388671875e4), SC_(0.1153834312978712202246739136605238163053e-438) }}, 
      {{ SC_(0), SC_(0.1185395751953125e4), SC_(0.5626632279469502957817365401058836530616e-516) }}, 
      {{ SC_(0), SC_(0.353451806640625e4), SC_(0.2005335541692877275070776095045572408221e-1536) }}, 
      {{ SC_(0), SC_(0.80715478515625e4), SC_(0.5198552672839385593247348234265735246569e-3507) }}, 
      {{ SC_(0), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5238258665687646932029547633274667132227e-7050)) }}, 
      {{ SC_(0), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4586477351514513511787402593637142120047e-13928)) }}, 
      {{ SC_(0), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.261839521735852199886433084148333502408e-15796)) }}, 
      {{ SC_(0.1e1), SC_(0.177219114266335964202880859375e-2), SC_(0.5642670589050394493876757991354791444425e3) }}, 
      {{ SC_(0.1e1), SC_(0.22177286446094512939453125e-2), SC_(0.4509043336519153776882032141395071321111e3) }}, 
      {{ SC_(0.1e1), SC_(0.7444499991834163665771484375e-2), SC_(0.134306823034307382114643500755390513023e3) }}, 
      {{ SC_(0.1e1), SC_(0.1433600485324859619140625e-1), SC_(0.6971959660478877278042038844910522107511e2) }}, 
      {{ SC_(0.1e1), SC_(0.1760916970670223236083984375e-1), SC_(0.5674760507791176149484792894248541539452e2) }}, 
      {{ SC_(0.1e1), SC_(0.6152711808681488037109375e-1), SC_(0.1614820987046735392831380358603921129883e2) }}, 
      {{ SC_(0.1e1), SC_(0.11958599090576171875e0), SC_(0.8197998310985025401124448473235927713019e1) }}, 
      {{ SC_(0.1e1), SC_(0.15262925624847412109375e0), SC_(0.6360645272530455596559051797225101283072e1) }}, 
      {{ SC_(0.1e1), SC_(0.408089816570281982421875e0), SC_(0.2132196083017461631334167216825680193136e1) }}, 
      {{ SC_(0.1e1), SC_(0.6540834903717041015625e0), SC_(0.1156576280544243110905012085298289192381e1) }}, 
      {{ SC_(0.1e1), SC_(0.1097540378570556640625e1), SC_(0.5118042111815067840711185047380239515098e0) }}, 
      {{ SC_(0.1e1), SC_(0.30944411754608154296875e1), SC_(0.3587084607310022256777513946093825420136e-1) }}, 
      {{ SC_(0.1e1), SC_(0.51139926910400390625e1), SC_(0.3563402139499414445927612094054750431128e-2) }}, 
      {{ SC_(0.1e1), SC_(0.95070552825927734375e1), SC_(0.3136737811772098452264479387949931309609e-4) }}, 
      {{ SC_(0.1e1), SC_(0.24750102996826171875e2), SC_(0.4559214298385623744840433425339909113277e-11) }}, 
      {{ SC_(0.1e1), SC_(0.637722015380859375e2), SC_(0.3179530807904064450989433716351000642288e-28) }}, 
      {{ SC_(0.1e1), SC_(0.1252804412841796875e3), SC_(0.4383376507619551733740470932900485417799e-55) }}, 
      {{ SC_(0.1e1), SC_(0.25554705810546875e3), SC_(0.8171153185119733731907215700781324087313e-112) }}, 
      {{ SC_(0.1e1), SC_(0.503011474609375e3), SC_(0.1961041051464076987061687841817509806692e-219) }}, 
      {{ SC_(0.1e1), SC_(0.10074598388671875e4), SC_(0.1154406816332980455168031108997781743075e-438) }}, 
      {{ SC_(0.1e1), SC_(0.1185395751953125e4), SC_(0.5629005093195648507075346585433996324305e-516) }}, 
      {{ SC_(0.1e1), SC_(0.353451806640625e4), SC_(0.2005619200413067947685927551685795058075e-1536) }}, 
      {{ SC_(0.1e1), SC_(0.80715478515625e4), SC_(0.5198874692343800657182245260803672831532e-3507) }}, 
      {{ SC_(0.1e1), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5238420046465533380647381293479454296805e-7050)) }}, 
      {{ SC_(0.1e1), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4586548866666827230215894859840049327748e-13928)) }}, 
      {{ SC_(0.1e1), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2618431215775737825097728016673681678693e-15796)) }}, 
      {{ SC_(0.4e1), SC_(0.177219114266335964202880859375e-2), SC_(0.4866299979081122714121229096210700191518e13) }}, 
      {{ SC_(0.4e1), SC_(0.22177286446094512939453125e-2), SC_(0.1984300471606527742059001282352526315267e13) }}, 
      {{ SC_(0.4e1), SC_(0.7444499991834163665771484375e-2), SC_(0.1562777308081462787649352118638441640974e11) }}, 
      {{ SC_(0.4e1), SC_(0.1433600485324859619140625e-1), SC_(0.1136373878031891372753785993664350977306e10) }}, 
      {{ SC_(0.4e1), SC_(0.1760916970670223236083984375e-1), SC_(0.4991999111548545244274999181282075933079e9) }}, 
      {{ SC_(0.4e1), SC_(0.6152711808681488037109375e-1), SC_(0.3348404754435542940391088463548015493779e7) }}, 
      {{ SC_(0.4e1), SC_(0.11958599090576171875e0), SC_(0.2344242859197388683851101586642876973144e6) }}, 
      {{ SC_(0.4e1), SC_(0.15262925624847412109375e0), SC_(0.882769652248796999251835414827424137219e5) }}, 
      {{ SC_(0.4e1), SC_(0.408089816570281982421875e0), SC_(0.1706913744135878990186254129470637633145e4) }}, 
      {{ SC_(0.4e1), SC_(0.6540834903717041015625e0), SC_(0.2531380187689981167427802188655172652219e3) }}, 
      {{ SC_(0.4e1), SC_(0.1097540378570556640625e1), SC_(0.2998821965908379171336639130797038553785e2) }}, 
      {{ SC_(0.4e1), SC_(0.30944411754608154296875e1), SC_(0.2600800540545786927103321191355308119242e0) }}, 
      {{ SC_(0.4e1), SC_(0.51139926910400390625e1), SC_(0.1310113816036379606520481730426498313864e-1) }}, 
      {{ SC_(0.4e1), SC_(0.95070552825927734375e1), SC_(0.6590536459344845745057389826071914812742e-4) }}, 
      {{ SC_(0.4e1), SC_(0.24750102996826171875e2), SC_(0.6133030556661369892325048452149519811279e-11) }}, 
      {{ SC_(0.4e1), SC_(0.637722015380859375e2), SC_(0.3572958141609371155661279310848429937317e-28) }}, 
      {{ SC_(0.4e1), SC_(0.1252804412841796875e3), SC_(0.4652677436708263229732006683514849916063e-55) }}, 
      {{ SC_(0.4e1), SC_(0.25554705810546875e3), SC_(0.8414034107282798661333568860302936388064e-112) }}, 
      {{ SC_(0.4e1), SC_(0.503011474609375e3), SC_(0.1990470027325467302112278177698801722237e-219) }}, 
      {{ SC_(0.4e1), SC_(0.10074598388671875e4), SC_(0.1163028521762409349244231951145594725638e-438) }}, 
      {{ SC_(0.4e1), SC_(0.1185395751953125e4), SC_(0.5664717578847921482243142747309256970705e-516) }}, 
      {{ SC_(0.4e1), SC_(0.353451806640625e4), SC_(0.2009878898832100717589398352424725806132e-1536) }}, 
      {{ SC_(0.4e1), SC_(0.80715478515625e4), SC_(0.5203707379166988887861124229263216602351e-3507) }}, 
      {{ SC_(0.4e1), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5240841354827504548639257799260351864794e-7050)) }}, 
      {{ SC_(0.4e1), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4587621727772824151475167382626737854669e-13928)) }}, 
      {{ SC_(0.4e1), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2618971251427177592957235690575280827847e-15796)) }}, 
      {{ SC_(0.7e1), SC_(0.177219114266335964202880859375e-2), SC_(0.8393410852610954393527641216972580532522e24) }}, 
      {{ SC_(0.7e1), SC_(0.22177286446094512939453125e-2), SC_(0.1746439477339240202017380879835593298264e24) }}, 
      {{ SC_(0.7e1), SC_(0.7444499991834163665771484375e-2), SC_(0.3636325329423526419455515218262149164257e20) }}, 
      {{ SC_(0.7e1), SC_(0.1433600485324859619140625e-1), SC_(0.3702642450648513536507007355077838785335e18) }}, 
      {{ SC_(0.7e1), SC_(0.1760916970670223236083984375e-1), SC_(0.8776769778941284214793226696145517599417e17) }}, 
      {{ SC_(0.7e1), SC_(0.6152711808681488037109375e-1), SC_(0.1380314199659804887833132363429985792775e14) }}, 
      {{ SC_(0.7e1), SC_(0.11958599090576171875e0), SC_(0.1316714319257667815497187929741473396631e12) }}, 
      {{ SC_(0.7e1), SC_(0.15262925624847412109375e0), SC_(0.2385758315216153945368410974902013750543e11) }}, 
      {{ SC_(0.7e1), SC_(0.408089816570281982421875e0), SC_(0.2427787443092239173513776098900037902893e8) }}, 
      {{ SC_(0.7e1), SC_(0.6540834903717041015625e0), SC_(0.8837961864361020779649458889083260267903e6) }}, 
      {{ SC_(0.7e1), SC_(0.1097540378570556640625e1), SC_(0.2284960408772201116356019420915711713484e5) }}, 
      {{ SC_(0.7e1), SC_(0.30944411754608154296875e1), SC_(0.115430121001405235617754789786436933495e2) }}, 
      {{ SC_(0.7e1), SC_(0.51139926910400390625e1), SC_(0.1855200551723818627257578663296940991293e0) }}, 
      {{ SC_(0.7e1), SC_(0.95070552825927734375e1), SC_(0.3209697242000963916775210833432692821492e-3) }}, 
      {{ SC_(0.7e1), SC_(0.24750102996826171875e2), SC_(0.117317638217852819641984018466983384411e-10) }}, 
      {{ SC_(0.7e1), SC_(0.637722015380859375e2), SC_(0.4617273805283495366784436206553361766215e-28) }}, 
      {{ SC_(0.7e1), SC_(0.1252804412841796875e3), SC_(0.530463977506128210095346164740795780716e-55) }}, 
      {{ SC_(0.7e1), SC_(0.25554705810546875e3), SC_(0.8974052085234798283338593957917220800683e-112) }}, 
      {{ SC_(0.7e1), SC_(0.503011474609375e3), SC_(0.2056776608251995281157685677374180807283e-219) }}, 
      {{ SC_(0.7e1), SC_(0.10074598388671875e4), SC_(0.1182223532524629470705848948269762593562e-438) }}, 
      {{ SC_(0.7e1), SC_(0.1185395751953125e4), SC_(0.5744084382473215145583083888149374566061e-516) }}, 
      {{ SC_(0.7e1), SC_(0.353451806640625e4), SC_(0.2019282105175847423689110847031244713335e-1536) }}, 
      {{ SC_(0.7e1), SC_(0.80715478515625e4), SC_(0.5214355108270690028322792158847712991209e-3507) }}, 
      {{ SC_(0.7e1), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5246172173384328966498809821165883204056e-7050)) }}, 
      {{ SC_(0.7e1), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4589982905651508483373540209643329865296e-13928)) }}, 
      {{ SC_(0.7e1), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.262015972194351617452666405333559675244e-15796)) }}, 
      {{ SC_(0.1e2), SC_(0.7444499991834163665771484375e-2), SC_(0.3553669112260589679559369394169552207558e30) }}, 
      {{ SC_(0.1e2), SC_(0.1433600485324859619140625e-1), SC_(0.5066979194966296085342168261220876180382e27) }}, 
      {{ SC_(0.1e2), SC_(0.1760916970670223236083984375e-1), SC_(0.6480976752277127998631768393896823291736e26) }}, 
      {{ SC_(0.1e2), SC_(0.6152711808681488037109375e-1), SC_(0.2389580098055959485819366060615251558358e21) }}, 
      {{ SC_(0.1e2), SC_(0.11958599090576171875e0), SC_(0.3104970025126176531421165865660207446979e18) }}, 
      {{ SC_(0.1e2), SC_(0.15262925624847412109375e0), SC_(0.2706288504370378982033987546887060486023e17) }}, 
      {{ SC_(0.1e2), SC_(0.408089816570281982421875e0), SC_(0.1443666691816396300812633872636237266303e13) }}, 
      {{ SC_(0.1e2), SC_(0.6540834903717041015625e0), SC_(0.1280984206792023020920423547804293082128e11) }}, 
      {{ SC_(0.1e2), SC_(0.1097540378570556640625e1), SC_(0.7084777398701569213628979833632335112045e8) }}, 
      {{ SC_(0.1e2), SC_(0.30944411754608154296875e1), SC_(0.1776330561989790884945591902602612974108e4) }}, 
      {{ SC_(0.1e2), SC_(0.51139926910400390625e1), SC_(0.7561612211922255925715297223843141543753e1) }}, 
      {{ SC_(0.1e2), SC_(0.95070552825927734375e1), SC_(0.3312175747188703924731868316016670207045e-2) }}, 
      {{ SC_(0.1e2), SC_(0.24750102996826171875e2), SC_(0.316549186060196510142326275566270329916e-10) }}, 
      {{ SC_(0.1e2), SC_(0.637722015380859375e2), SC_(0.6858066547220214894850727219918188844372e-28) }}, 
      {{ SC_(0.1e2), SC_(0.1252804412841796875e3), SC_(0.6495845884366965264198113958373840112253e-55) }}, 
      {{ SC_(0.1e2), SC_(0.25554705810546875e3), SC_(0.991362504515590864892065541409133961701e-112) }}, 
      {{ SC_(0.1e2), SC_(0.503011474609375e3), SC_(0.2163618208760250177914928622296114388901e-219) }}, 
      {{ SC_(0.1e2), SC_(0.10074598388671875e4), SC_(0.1212513333490346230839551955991649038227e-438) }}, 
      {{ SC_(0.1e2), SC_(0.1185395751953125e4), SC_(0.586893431857951347227749283812742380563e-516) }}, 
      {{ SC_(0.1e2), SC_(0.353451806640625e4), SC_(0.2033900929893989288120221591878316666532e-1536) }}, 
      {{ SC_(0.1e2), SC_(0.80715478515625e4), SC_(0.5230853557909669671253778230080315788384e-3507) }}, 
      {{ SC_(0.1e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5254421378336957273402254351232818867248e-7050)) }}, 
      {{ SC_(0.1e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4593634389285012411677313330998673022044e-13928)) }}, 
      {{ SC_(0.1e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2621997509993104596265028007664067440518e-15796)) }}, 
      {{ SC_(0.13e2), SC_(0.6152711808681488037109375e-1), SC_(0.1083420896102934209934115685271226154021e29) }}, 
      {{ SC_(0.13e2), SC_(0.11958599090576171875e0), SC_(0.1917447750081714212558490604491870597354e25) }}, 
      {{ SC_(0.13e2), SC_(0.15262925624847412109375e0), SC_(0.8038868021916654814587066747745710652867e23) }}, 
      {{ SC_(0.13e2), SC_(0.408089816570281982421875e0), SC_(0.2245771182455599861571897956512030500912e18) }}, 
      {{ SC_(0.13e2), SC_(0.6540834903717041015625e0), SC_(0.4848374582394250306716955498456616638777e15) }}, 
      {{ SC_(0.13e2), SC_(0.1097540378570556640625e1), SC_(0.5706157799443050405365640850248281332472e12) }}, 
      {{ SC_(0.13e2), SC_(0.30944411754608154296875e1), SC_(0.6749251426431234386462977211680293326467e6) }}, 
      {{ SC_(0.13e2), SC_(0.51139926910400390625e1), SC_(0.7041501258795245542680641070543745293868e3) }}, 
      {{ SC_(0.13e2), SC_(0.95070552825927734375e1), SC_(0.6566785551862389851044830988879804923294e-1) }}, 
      {{ SC_(0.13e2), SC_(0.24750102996826171875e2), SC_(0.1190989352639552376096560578530599056113e-9) }}, 
      {{ SC_(0.13e2), SC_(0.637722015380859375e2), SC_(0.1169819866439623248151687788769924240322e-27) }}, 
      {{ SC_(0.13e2), SC_(0.1252804412841796875e3), SC_(0.8542662489314492939710880476555839775162e-55) }}, 
      {{ SC_(0.13e2), SC_(0.25554705810546875e3), SC_(0.113430562248402032364671459657614723877e-111) }}, 
      {{ SC_(0.13e2), SC_(0.503011474609375e3), SC_(0.2317049832439488682536591053688556015713e-219) }}, 
      {{ SC_(0.13e2), SC_(0.10074598388671875e4), SC_(0.1254732183778027411039488001953049164743e-438) }}, 
      {{ SC_(0.13e2), SC_(0.1185395751953125e4), SC_(0.6042178020632144064714108224311774903492e-516) }}, 
      {{ SC_(0.13e2), SC_(0.353451806640625e4), SC_(0.2053847923636589340983297552611107216238e-1536) }}, 
      {{ SC_(0.13e2), SC_(0.80715478515625e4), SC_(0.5253258106648653014772606538228525344948e-3507) }}, 
      {{ SC_(0.13e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5265602717055656306785745402150322892879e-7050)) }}, 
      {{ SC_(0.13e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4598579255911157275391585056728721716762e-13928)) }}, 
      {{ SC_(0.13e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.262448598101299579741117867864106374998e-15796)) }}, 
      {{ SC_(0.16e2), SC_(0.15262925624847412109375e0), SC_(0.4938286945300390946800057834907625530461e30) }}, 
      {{ SC_(0.16e2), SC_(0.408089816570281982421875e0), SC_(0.7221910587714053614294800190891382604706e23) }}, 
      {{ SC_(0.16e2), SC_(0.6540834903717041015625e0), SC_(0.3790728103951616879677403904143882209845e20) }}, 
      {{ SC_(0.16e2), SC_(0.1097540378570556640625e1), SC_(0.9473457818948219028509498171217174515021e16) }}, 
      {{ SC_(0.16e2), SC_(0.30944411754608154296875e1), SC_(0.5172640843147067612769370153863372484149e9) }}, 
      {{ SC_(0.16e2), SC_(0.51139926910400390625e1), SC_(0.1274412574247354368298601805160688986152e6) }}, 
      {{ SC_(0.16e2), SC_(0.95070552825927734375e1), SC_(0.2289463448540324555979280240558825397975e1) }}, 
      {{ SC_(0.16e2), SC_(0.24750102996826171875e2), SC_(0.6161791433620408296199842329094112252448e-9) }}, 
      {{ SC_(0.16e2), SC_(0.637722015380859375e2), SC_(0.2289096435959505507418524279471155402989e-27) }}, 
      {{ SC_(0.16e2), SC_(0.1252804412841796875e3), SC_(0.1206319601397505331696773539636227844309e-54) }}, 
      {{ SC_(0.16e2), SC_(0.25554705810546875e3), SC_(0.1344229468593505419384958353266236768613e-111) }}, 
      {{ SC_(0.16e2), SC_(0.503011474609375e3), SC_(0.2526098676772882819533563375360814766944e-219) }}, 
      {{ SC_(0.16e2), SC_(0.10074598388671875e4), SC_(0.1310065508080730748782756145393107519213e-438) }}, 
      {{ SC_(0.16e2), SC_(0.1185395751953125e4), SC_(0.6267921275265713176373898233864223423493e-516) }}, 
      {{ SC_(0.16e2), SC_(0.353451806640625e4), SC_(0.2079277522540840435616081751154561226651e-1536) }}, 
      {{ SC_(0.16e2), SC_(0.80715478515625e4), SC_(0.5281644143269290804699816737306754893525e-3507) }}, 
      {{ SC_(0.16e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5279734846269774507137982122183578716906e-7050)) }}, 
      {{ SC_(0.16e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4604821675345979003854650884049215110996e-13928)) }}, 
      {{ SC_(0.16e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2627626984899885735887234170335932793558e-15796)) }}, 
      {{ SC_(0.19e2), SC_(0.408089816570281982421875e0), SC_(0.4164061026825297491148153141912721107722e29) }}, 
      {{ SC_(0.19e2), SC_(0.6540834903717041015625e0), SC_(0.5312149012796560969562933465014179856392e25) }}, 
      {{ SC_(0.19e2), SC_(0.1097540378570556640625e1), SC_(0.2815975836985008873103308168929822944327e21) }}, 
      {{ SC_(0.19e2), SC_(0.30944411754608154296875e1), SC_(0.7019132853172097465901622753543655264903e12) }}, 
      {{ SC_(0.19e2), SC_(0.51139926910400390625e1), SC_(0.4002436863438981174830416893548050617807e8) }}, 
      {{ SC_(0.19e2), SC_(0.95070552825927734375e1), SC_(0.1303525556148337020714921569926174097018e3) }}, 
      {{ SC_(0.19e2), SC_(0.24750102996826171875e2), SC_(0.4316753221562253270243758390652133294371e-8) }}, 
      {{ SC_(0.19e2), SC_(0.637722015380859375e2), SC_(0.5131631099458169754688000422673163599127e-27) }}, 
      {{ SC_(0.19e2), SC_(0.1252804412841796875e3), SC_(0.1828775305637346345086844497495530048761e-54) }}, 
      {{ SC_(0.19e2), SC_(0.25554705810546875e3), SC_(0.1649880347502512941415042788463907897061e-111) }}, 
      {{ SC_(0.19e2), SC_(0.503011474609375e3), SC_(0.2803652042513646742863659290040036426993e-219) }}, 
      {{ SC_(0.19e2), SC_(0.10074598388671875e4), SC_(0.138010548403557210998749298167785814513e-438) }}, 
      {{ SC_(0.19e2), SC_(0.1185395751953125e4), SC_(0.6551627490387305422139410554400797766277e-516) }}, 
      {{ SC_(0.19e2), SC_(0.353451806640625e4), SC_(0.2110388042455500963599125331602819247229e-1536) }}, 
      {{ SC_(0.19e2), SC_(0.80715478515625e4), SC_(0.5316107489696805817894855741449691118523e-3507) }}, 
      {{ SC_(0.19e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5296841383959242087228030140304235898501e-7050)) }}, 
      {{ SC_(0.19e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4612366915844621095505284507922443014777e-13928)) }}, 
      {{ SC_(0.19e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.263142285830226183225076299008451154768e-15796)) }}, 
      {{ SC_(0.22e2), SC_(0.1097540378570556640625e1), SC_(0.1363003388493700601216340546122016964692e26) }}, 
      {{ SC_(0.22e2), SC_(0.30944411754608154296875e1), SC_(0.154098133448113782071643725924230801023e16) }}, 
      {{ SC_(0.22e2), SC_(0.51139926910400390625e1), SC_(0.2009401025366327094151993104161788468592e11) }}, 
      {{ SC_(0.22e2), SC_(0.95070552825927734375e1), SC_(0.1141232205288225451172879420440562665501e5) }}, 
      {{ SC_(0.22e2), SC_(0.24750102996826171875e2), SC_(0.4030155296337857773583486982855348750892e-7) }}, 
      {{ SC_(0.22e2), SC_(0.637722015380859375e2), SC_(0.1315869800422107059860094317990248408429e-26) }}, 
      {{ SC_(0.22e2), SC_(0.1252804412841796875e3), SC_(0.2975692932403139304961913614199800178338e-54) }}, 
      {{ SC_(0.22e2), SC_(0.25554705810546875e3), SC_(0.2097273790995842218764900522553748654456e-111) }}, 
      {{ SC_(0.22e2), SC_(0.503011474609375e3), SC_(0.3167781215041084943465273722089298618238e-219) }}, 
      {{ SC_(0.22e2), SC_(0.10074598388671875e4), SC_(0.1466927482471510400596019243484849490977e-438) }}, 
      {{ SC_(0.22e2), SC_(0.1185395751953125e4), SC_(0.690033831413657158885992262195107209443e-516) }}, 
      {{ SC_(0.22e2), SC_(0.353451806640625e4), SC_(0.2147424258180187733063949241373893460545e-1536) }}, 
      {{ SC_(0.22e2), SC_(0.80715478515625e4), SC_(0.5356764940269015086023336440354606728087e-3507) }}, 
      {{ SC_(0.22e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5316950975149900813875721833489941300947e-7050)) }}, 
      {{ SC_(0.22e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4621221351512128995193460546474354537115e-13928)) }}, 
      {{ SC_(0.22e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2635876427517735221275210029856471898722e-15796)) }}, 
      {{ SC_(0.25e2), SC_(0.30944411754608154296875e1), SC_(0.5124414377836332997128321016932385071037e19) }}, 
      {{ SC_(0.25e2), SC_(0.51139926910400390625e1), SC_(0.1516348961613243378986004924208793378214e14) }}, 
      {{ SC_(0.25e2), SC_(0.95070552825927734375e1), SC_(0.1463234253390806624112966887873959971233e7) }}, 
      {{ SC_(0.25e2), SC_(0.24750102996826171875e2), SC_(0.4935038240665646924300882380857360493806e-6) }}, 
      {{ SC_(0.25e2), SC_(0.637722015380859375e2), SC_(0.3852729718366625645598579815228162625593e-26) }}, 
      {{ SC_(0.25e2), SC_(0.1252804412841796875e3), SC_(0.519554212251102929292422924272513966618e-54) }}, 
      {{ SC_(0.25e2), SC_(0.25554705810546875e3), SC_(0.2761006009486831921593422030279766463146e-111) }}, 
      {{ SC_(0.25e2), SC_(0.503011474609375e3), SC_(0.3643691815233768363329960382590151294279e-219) }}, 
      {{ SC_(0.25e2), SC_(0.10074598388671875e4), SC_(0.1573192504592971211195262229110325635597e-438) }}, 
      {{ SC_(0.25e2), SC_(0.1185395751953125e4), SC_(0.7322964891826955653271546226503782002346e-516) }}, 
      {{ SC_(0.25e2), SC_(0.353451806640625e4), SC_(0.2190680614711407877661687663478874228865e-1536) }}, 
      {{ SC_(0.25e2), SC_(0.80715478515625e4), SC_(0.540375492159789413152113464539956894375e-3507) }}, 
      {{ SC_(0.25e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5340097371869314934260450597251845025579e-7050)) }}, 
      {{ SC_(0.25e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4631392471278741610272692105394268251102e-13928)) }}, 
      {{ SC_(0.25e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2640991012000586747759705721429447267374e-15796)) }}, 
      {{ SC_(0.28e2), SC_(0.30944411754608154296875e1), SC_(0.2454990660613704575310526628033402392743e23) }}, 
      {{ SC_(0.28e2), SC_(0.51139926910400390625e1), SC_(0.1639932683217203236875473578868075473357e17) }}, 
      {{ SC_(0.28e2), SC_(0.95070552825927734375e1), SC_(0.2640289814156717285146398752180020136988e9) }}, 
      {{ SC_(0.28e2), SC_(0.24750102996826171875e2), SC_(0.7805016810416181144084572579288151877848e-5) }}, 
      {{ SC_(0.28e2), SC_(0.637722015380859375e2), SC_(0.1285516209168801948450375975409166892794e-25) }}, 
      {{ SC_(0.28e2), SC_(0.1252804412841796875e3), SC_(0.9731024469683355973357810021133052733266e-54) }}, 
      {{ SC_(0.28e2), SC_(0.25554705810546875e3), SC_(0.3764202686030341596545979787444019030802e-111) }}, 
      {{ SC_(0.28e2), SC_(0.503011474609375e3), SC_(0.4266594228984071730839482411557788914727e-219) }}, 
      {{ SC_(0.28e2), SC_(0.10074598388671875e4), SC_(0.1702282693037324565511443632781369578599e-438) }}, 
      {{ SC_(0.28e2), SC_(0.1185395751953125e4), SC_(0.7830666627994873419887796221376303084348e-516) }}, 
      {{ SC_(0.28e2), SC_(0.353451806640625e4), SC_(0.2240505129503384289100743163081097090796e-1536) }}, 
      {{ SC_(0.28e2), SC_(0.80715478515625e4), SC_(0.545723827824440126457849797127688848512e-3507) }}, 
      {{ SC_(0.28e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5366319527575558839162183821505900036109e-7050)) }}, 
      {{ SC_(0.28e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4642888889457374552089218805904169520701e-13928)) }}, 
      {{ SC_(0.28e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2646770428485621338192274145251868595147e-15796)) }}, 
      {{ SC_(0.31e2), SC_(0.30944411754608154296875e1), SC_(0.1628932708409575730419267561000492140589e27) }}, 
      {{ SC_(0.31e2), SC_(0.51139926910400390625e1), SC_(0.2447361910481591579571497585668547323946e20) }}, 
      {{ SC_(0.31e2), SC_(0.95070552825927734375e1), SC_(0.6488217504914699872909898484402174229942e11) }}, 
      {{ SC_(0.31e2), SC_(0.24750102996826171875e2), SC_(0.157116552966095225600444096328289206147e-3) }}, 
      {{ SC_(0.31e2), SC_(0.637722015380859375e2), SC_(0.4877866771594043520068734807669071874982e-25) }}, 
      {{ SC_(0.31e2), SC_(0.1252804412841796875e3), SC_(0.1954458676609050367778051217834443619249e-53) }}, 
      {{ SC_(0.31e2), SC_(0.25554705810546875e3), SC_(0.5314396609201908102183228568905552439644e-111) }}, 
      {{ SC_(0.31e2), SC_(0.503011474609375e3), SC_(0.5085947534007667967665404997759185910698e-219) }}, 
      {{ SC_(0.31e2), SC_(0.10074598388671875e4), SC_(0.1858479555248526512442867243821889852739e-438) }}, 
      {{ SC_(0.31e2), SC_(0.1185395751953125e4), SC_(0.8437339956894185946885168627747104414597e-516) }}, 
      {{ SC_(0.31e2), SC_(0.353451806640625e4), SC_(0.2297304058162664000801774532441891487107e-1536) }}, 
      {{ SC_(0.31e2), SC_(0.80715478515625e4), SC_(0.5517399190450953326108602755590633200343e-3507) }}, 
      {{ SC_(0.31e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5395661706428891649746508777630616770672e-7050)) }}, 
      {{ SC_(0.31e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4655720357904133390898485411309960205861e-13928)) }}, 
      {{ SC_(0.31e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.265321899573550369144774901462370895652e-15796)) }}, 
      {{ SC_(0.34e2), SC_(0.51139926910400390625e1), SC_(0.4887088419644645368260815870435027797406e23) }}, 
      {{ SC_(0.34e2), SC_(0.95070552825927734375e1), SC_(0.2112656718901935346201941347252542378941e14) }}, 
      {{ SC_(0.34e2), SC_(0.24750102996826171875e2), SC_(0.3970887365216683380607479457956643717073e-2) }}, 
      {{ SC_(0.34e2), SC_(0.637722015380859375e2), SC_(0.2100204922933819026203193295871305047884e-24) }}, 
      {{ SC_(0.34e2), SC_(0.1252804412841796875e3), SC_(0.4208002081332910915619620807159408811519e-53) }}, 
      {{ SC_(0.34e2), SC_(0.25554705810546875e3), SC_(0.7769447760252936043840779866630634408625e-111) }}, 
      {{ SC_(0.34e2), SC_(0.503011474609375e3), SC_(0.6171781631735790945543097961138060180266e-219) }}, 
      {{ SC_(0.34e2), SC_(0.10074598388671875e4), SC_(0.2047197978967706994212554896264914383123e-438) }}, 
      {{ SC_(0.34e2), SC_(0.1185395751953125e4), SC_(0.9160246977951776790315282650922051285968e-516) }}, 
      {{ SC_(0.34e2), SC_(0.353451806640625e4), SC_(0.2361547411134811710896829034902271115585e-1536) }}, 
      {{ SC_(0.34e2), SC_(0.80715478515625e4), SC_(0.5584446231263440827429886485888847485203e-3507) }}, 
      {{ SC_(0.34e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5428173607835506848491134855123714452313e-7050)) }}, 
      {{ SC_(0.34e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4669897779805891799705998126652967732775e-13928)) }}, 
      {{ SC_(0.34e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2660341539919842585511498286326720170637e-15796)) }}, 
      {{ SC_(0.37e2), SC_(0.51139926910400390625e1), SC_(0.1272972151896897826158274128583844120665e27) }}, 
      {{ SC_(0.37e2), SC_(0.95070552825927734375e1), SC_(0.8906476725223650919563577369009773338755e16) }}, 
      {{ SC_(0.37e2), SC_(0.24750102996826171875e2), SC_(0.1244083237827760336698682724048883714384e0) }}, 
      {{ SC_(0.37e2), SC_(0.637722015380859375e2), SC_(0.1023683495413380075273932600948216233739e-23) }}, 
      {{ SC_(0.37e2), SC_(0.1252804412841796875e3), SC_(0.9708114816265931540367065686128969752967e-53) }}, 
      {{ SC_(0.37e2), SC_(0.25554705810546875e3), SC_(0.1176141374265724392875749694044997803833e-110) }}, 
      {{ SC_(0.37e2), SC_(0.503011474609375e3), SC_(0.7624202295820387263571569786711706654334e-219) }}, 
      {{ SC_(0.37e2), SC_(0.10074598388671875e4), SC_(0.2275293790124175097179388212619385996485e-438) }}, 
      {{ SC_(0.37e2), SC_(0.1185395751953125e4), SC_(0.1002082350358535312449713140689845232144e-515) }}, 
      {{ SC_(0.37e2), SC_(0.353451806640625e4), SC_(0.24337754261932268167781383948202245203e-1536) }}, 
      {{ SC_(0.37e2), SC_(0.80715478515625e4), SC_(0.5658613571537489375270717392106841872519e-3507) }}, 
      {{ SC_(0.37e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5463910506753990628094528712757348439213e-7050)) }}, 
      {{ SC_(0.37e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4685433225122227131121313342266088755841e-13928)) }}, 
      {{ SC_(0.37e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2668143400635403962854802667482407460168e-15796)) }}, 
      {{ SC_(0.4e2), SC_(0.51139926910400390625e1), SC_(0.4233526621241393414692668844551104005827e30) }}, 
      {{ SC_(0.4e2), SC_(0.95070552825927734375e1), SC_(0.4766171624124769142545027018778135740885e19) }}, 
      {{ SC_(0.4e2), SC_(0.24750102996826171875e2), SC_(0.4775404961093391264918951179312101480207e1) }}, 
      {{ SC_(0.4e2), SC_(0.637722015380859375e2), SC_(0.5635106976075199703636541975335502909796e-23) }}, 
      {{ SC_(0.4e2), SC_(0.1252804412841796875e3), SC_(0.239893653947530928983971886240185066878e-52) }}, 
      {{ SC_(0.4e2), SC_(0.25554705810546875e3), SC_(0.1843478723100513534021193173428902541989e-110) }}, 
      {{ SC_(0.4e2), SC_(0.503011474609375e3), SC_(0.9587827836263030915116628042123831013541e-219) }}, 
      {{ SC_(0.4e2), SC_(0.10074598388671875e4), SC_(0.2551468993000374444638108825618092702334e-438) }}, 
      {{ SC_(0.4e2), SC_(0.1185395751953125e4), SC_(0.1104571893928413137785528611522740784998e-515) }}, 
      {{ SC_(0.4e2), SC_(0.353451806640625e4), SC_(0.2514606121350613728401996284399725441789e-1536) }}, 
      {{ SC_(0.4e2), SC_(0.80715478515625e4), SC_(0.5740162342574260629793695263133161311679e-3507) }}, 
      {{ SC_(0.4e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.550293341031905346615098885552944484108e-7050)) }}, 
      {{ SC_(0.4e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4702339947712333105841647963051289505599e-13928)) }}, 
      {{ SC_(0.4e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.267663043757796685478543436488906145159e-15796)) }}, 
      {{ SC_(0.43e2), SC_(0.95070552825927734375e1), SC_(0.3182839111836206795432282087846430344793e22) }}, 
      {{ SC_(0.43e2), SC_(0.24750102996826171875e2), SC_(0.222166790779622513904265491366185119783e3) }}, 
      {{ SC_(0.43e2), SC_(0.637722015380859375e2), SC_(0.3494683971717078896526073657684663026344e-22) }}, 
      {{ SC_(0.43e2), SC_(0.1252804412841796875e3), SC_(0.6346453085860538378657641408876460992447e-52) }}, 
      {{ SC_(0.43e2), SC_(0.25554705810546875e3), SC_(0.2991576375167378499626120269819404711331e-110) }}, 
      {{ SC_(0.43e2), SC_(0.503011474609375e3), SC_(0.1227395435880538406117125957292272846558e-218) }}, 
      {{ SC_(0.43e2), SC_(0.10074598388671875e4), SC_(0.288680763360153435580734280826972880231e-438) }}, 
      {{ SC_(0.43e2), SC_(0.1185395751953125e4), SC_(0.1226813762536213360641692402203393421902e-515) }}, 
      {{ SC_(0.43e2), SC_(0.353451806640625e4), SC_(0.2604744075705526360896827212663194081844e-1536) }}, 
      {{ SC_(0.43e2), SC_(0.80715478515625e4), SC_(0.5829382167482993254759548308025590017295e-3507) }}, 
      {{ SC_(0.43e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5545309231403848597473015547909532316757e-7050)) }}, 
      {{ SC_(0.43e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4720632404180934492767700130411170770692e-13928)) }}, 
      {{ SC_(0.43e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2685809037877493712736261189745151268036e-15796)) }}, 
      {{ SC_(0.46e2), SC_(0.95070552825927734375e1), SC_(0.2613341661852173290163593295155286429179e25) }}, 
      {{ SC_(0.46e2), SC_(0.24750102996826171875e2), SC_(0.1240356498190349854695380927506887128504e5) }}, 
      {{ SC_(0.46e2), SC_(0.637722015380859375e2), SC_(0.2435594999948560729028252282438959684734e-21) }}, 
      {{ SC_(0.46e2), SC_(0.1252804412841796875e3), SC_(0.1796653611261388450475612390490618546895e-51) }}, 
      {{ SC_(0.46e2), SC_(0.25554705810546875e3), SC_(0.5025944581419636885378338102879757870666e-110) }}, 
      {{ SC_(0.46e2), SC_(0.503011474609375e3), SC_(0.1599497182965866519989916521857648397981e-218) }}, 
      {{ SC_(0.46e2), SC_(0.10074598388671875e4), SC_(0.3295487424117437084008553230775859427088e-438) }}, 
      {{ SC_(0.46e2), SC_(0.1185395751953125e4), SC_(0.1372957440742858143071942753527722395892e-515) }}, 
      {{ SC_(0.46e2), SC_(0.353451806640625e4), SC_(0.2704990612325371082658423752252872015539e-1536) }}, 
      {{ SC_(0.46e2), SC_(0.80715478515625e4), SC_(0.5926592873835553214540488168663074957806e-3507) }}, 
      {{ SC_(0.46e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5591110979812109106321381410172006791395e-7050)) }}, 
      {{ SC_(0.46e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4740326274480720773200693383939904110369e-13928)) }}, 
      {{ SC_(0.46e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.269568612410947047471656632057047862977e-15796)) }}, 
      {{ SC_(0.49e2), SC_(0.95070552825927734375e1), SC_(0.2604110632578045074747155850476866625948e28) }}, 
      {{ SC_(0.49e2), SC_(0.24750102996826171875e2), SC_(0.8234824069434699773771302493843594365029e6) }}, 
      {{ SC_(0.49e2), SC_(0.637722015380859375e2), SC_(0.1902868412813550491062018165813668118658e-20) }}, 
      {{ SC_(0.49e2), SC_(0.1252804412841796875e3), SC_(0.5440024350673983390536795347083271518201e-51) }}, 
      {{ SC_(0.49e2), SC_(0.25554705810546875e3), SC_(0.8741004963899605307945501563203272368013e-110) }}, 
      {{ SC_(0.49e2), SC_(0.503011474609375e3), SC_(0.2121842408391232802265664912252713360049e-218) }}, 
      {{ SC_(0.49e2), SC_(0.10074598388671875e4), SC_(0.3795729266960021463783148801906243269524e-438) }}, 
      {{ SC_(0.49e2), SC_(0.1185395751953125e4), SC_(0.1548206847091165496863608044251602051314e-515) }}, 
      {{ SC_(0.49e2), SC_(0.353451806640625e4), SC_(0.2816255588282019933434542273145935388214e-1536) }}, 
      {{ SC_(0.49e2), SC_(0.80715478515625e4), SC_(0.6032146401778819934332757713494281444621e-3507) }}, 
      {{ SC_(0.49e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5640417971864792607466646129595328587678e-7050)) }}, 
      {{ SC_(0.49e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4761438484312403920622455773313824083129e-13928)) }}, 
      {{ SC_(0.49e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2706269162996484422890605196489233046553e-15796)) }}, 
      {{ SC_(0.52e2), SC_(0.24750102996826171875e2), SC_(0.6447123396076953125856501527046675224103e8) }}, 
      {{ SC_(0.52e2), SC_(0.637722015380859375e2), SC_(0.1662393009289908212041057469690821898544e-19) }}, 
      {{ SC_(0.52e2), SC_(0.1252804412841796875e3), SC_(0.176081332172933452583858832905441988789e-50) }}, 
      {{ SC_(0.52e2), SC_(0.25554705810546875e3), SC_(0.1573619547602125217418649562613363854933e-109) }}, 
      {{ SC_(0.52e2), SC_(0.503011474609375e3), SC_(0.2865293720586253316237854479684756666504e-218) }}, 
      {{ SC_(0.52e2), SC_(0.10074598388671875e4), SC_(0.4411070645207772522347055077622564971444e-438) }}, 
      {{ SC_(0.52e2), SC_(0.1185395751953125e4), SC_(0.1759114193755329124346838916667484326051e-515) }}, 
      {{ SC_(0.52e2), SC_(0.353451806640625e4), SC_(0.2939571033262660416184655688725890023946e-1536) }}, 
      {{ SC_(0.52e2), SC_(0.80715478515625e4), SC_(0.6146428923521813401837376358389093626766e-3507) }}, 
      {{ SC_(0.52e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5693316059223311384546703599902546300788e-7050)) }}, 
      {{ SC_(0.52e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4783987229367199009175316527221338478209e-13928)) }}, 
      {{ SC_(0.52e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2717566174815352378101961453286298212542e-15796)) }}, 
      {{ SC_(0.55e2), SC_(0.24750102996826171875e2), SC_(0.5906592594836486211372993494032070575815e10) }}, 
      {{ SC_(0.55e2), SC_(0.637722015380859375e2), SC_(0.1619944303887765571629298426907679553596e-18) }}, 
      {{ SC_(0.55e2), SC_(0.1252804412841796875e3), SC_(0.608927899095778107216501890100327844068e-50) }}, 
      {{ SC_(0.55e2), SC_(0.25554705810546875e3), SC_(0.2932241159906496106934751711750456582902e-109) }}, 
      {{ SC_(0.55e2), SC_(0.503011474609375e3), SC_(0.3938646387584288196973181886064586393011e-218) }}, 
      {{ SC_(0.55e2), SC_(0.10074598388671875e4), SC_(0.5172082428396249892924776411237396813495e-438) }}, 
      {{ SC_(0.55e2), SC_(0.1185395751953125e4), SC_(0.20139647659877449929188123350177500281e-515) }}, 
      {{ SC_(0.55e2), SC_(0.353451806640625e4), SC_(0.3076106920808888200634769834560394968754e-1536) }}, 
      {{ SC_(0.55e2), SC_(0.80715478515625e4), SC_(0.6269863192036053706431959465256415089858e-3507) }}, 
      {{ SC_(0.55e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.574989787787316356628191218017765776562e-7050)) }}, 
      {{ SC_(0.55e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4807992001460335134677650774814753867241e-13928)) }}, 
      {{ SC_(0.55e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2729585743526390911413799190493994340307e-15796)) }}, 
      {{ SC_(0.58e2), SC_(0.24750102996826171875e2), SC_(0.6287635183148587835682696418458586125518e12) }}, 
      {{ SC_(0.58e2), SC_(0.637722015380859375e2), SC_(0.1756460447184133594481790032905120322521e-17) }}, 
      {{ SC_(0.58e2), SC_(0.1252804412841796875e3), SC_(0.2248613108673335230509488256563758753961e-49) }}, 
      {{ SC_(0.58e2), SC_(0.25554705810546875e3), SC_(0.5654918276102973107457654592757896708566e-109) }}, 
      {{ SC_(0.58e2), SC_(0.503011474609375e3), SC_(0.551114499819172534127087841978064034342e-218) }}, 
      {{ SC_(0.58e2), SC_(0.10074598388671875e4), SC_(0.6118696230867968231394790791959663245605e-438) }}, 
      {{ SC_(0.58e2), SC_(0.1185395751953125e4), SC_(0.2323283007326067132383472547365484174206e-515) }}, 
      {{ SC_(0.58e2), SC_(0.353451806640625e4), SC_(0.3227189406425111978444678851933447583123e-1536) }}, 
      {{ SC_(0.58e2), SC_(0.80715478515625e4), SC_(0.6402911138921955267414762206159896491641e-3507) }}, 
      {{ SC_(0.58e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5810263118278312048425620492975372174571e-7050)) }}, 
      {{ SC_(0.58e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4833473616608138200363301333135367985947e-13928)) }}, 
      {{ SC_(0.58e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2742337027642737009466482947735690427217e-15796)) }}, 
      {{ SC_(0.61e2), SC_(0.24750102996826171875e2), SC_(0.7726373728796904279575416594682658176479e14) }}, 
      {{ SC_(0.61e2), SC_(0.637722015380859375e2), SC_(0.2113943823625618827883205381971301797016e-16) }}, 
      {{ SC_(0.61e2), SC_(0.1252804412841796875e3), SC_(0.8861536583313896744581182392356177857871e-49) }}, 
      {{ SC_(0.61e2), SC_(0.25554705810546875e3), SC_(0.1128608002403298136517199269445226426889e-108) }}, 
      {{ SC_(0.61e2), SC_(0.503011474609375e3), SC_(0.7849619531087268590088157170928524002912e-218) }}, 
      {{ SC_(0.61e2), SC_(0.10074598388671875e4), SC_(0.7303377267545843918467287421006799350243e-438) }}, 
      {{ SC_(0.61e2), SC_(0.1185395751953125e4), SC_(0.270050123497330419186945911647084594198e-515) }}, 
      {{ SC_(0.61e2), SC_(0.353451806640625e4), SC_(0.3394321926021289374115139121770929447286e-1536) }}, 
      {{ SC_(0.61e2), SC_(0.80715478515625e4), SC_(0.6546076743725850744311026044349057058217e-3507) }}, 
      {{ SC_(0.61e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5874518817808457402027581610496686283433e-7050)) }}, 
      {{ SC_(0.61e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4860454245105296988781115294196285058127e-13928)) }}, 
      {{ SC_(0.61e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2755829771858985092011731285441871079278e-15796)) }}, 
      {{ SC_(0.64e2), SC_(0.24750102996826171875e2), SC_(0.1089372884592778724010939074780808093656e17) }}, 
      {{ SC_(0.64e2), SC_(0.637722015380859375e2), SC_(0.2817266049671112872402662968245886024951e-15) }}, 
      {{ SC_(0.64e2), SC_(0.1252804412841796875e3), SC_(0.3724702135364801690887458310736954249975e-48) }}, 
      {{ SC_(0.64e2), SC_(0.25554705810546875e3), SC_(0.2330836717388845789360360409398297964075e-108) }}, 
      {{ SC_(0.64e2), SC_(0.503011474609375e3), SC_(0.1138051624148028381793628292491566002443e-217) }}, 
      {{ SC_(0.64e2), SC_(0.10074598388671875e4), SC_(0.8795474806187293519539998949550401264589e-438) }}, 
      {{ SC_(0.64e2), SC_(0.1185395751953125e4), SC_(0.3162847444927986736836816083125075670015e-515) }}, 
      {{ SC_(0.64e2), SC_(0.353451806640625e4), SC_(0.357920961818962588991163894939852397169e-1536) }}, 
      {{ SC_(0.64e2), SC_(0.80715478515625e4), SC_(0.669990919956916384927021910729947711597e-3507) }}, 
      {{ SC_(0.64e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5942779676638927496437891727345757504507e-7050)) }}, 
      {{ SC_(0.64e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4888957443663140543644871361643761747612e-13928)) }}, 
      {{ SC_(0.64e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2770074319459807641783655781741093857784e-15796)) }}, 
      {{ SC_(0.67e2), SC_(0.24750102996826171875e2), SC_(0.1752503956367793335591698780066945162812e19) }}, 
      {{ SC_(0.67e2), SC_(0.637722015380859375e2), SC_(0.4147864732836980467101348321415022034012e-14) }}, 
      {{ SC_(0.67e2), SC_(0.1252804412841796875e3), SC_(0.1668781473640989763113617951611659640503e-47) }}, 
      {{ SC_(0.67e2), SC_(0.25554705810546875e3), SC_(0.4980726389162882741712033067856828293759e-108) }}, 
      {{ SC_(0.67e2), SC_(0.503011474609375e3), SC_(0.167948569861795538522970935654345076463e-217) }}, 
      {{ SC_(0.67e2), SC_(0.10074598388671875e4), SC_(0.1068722229666081091973101721647873584696e-437) }}, 
      {{ SC_(0.67e2), SC_(0.1185395751953125e4), SC_(0.3732529706926917583477299343548737282551e-515) }}, 
      {{ SC_(0.67e2), SC_(0.353451806640625e4), SC_(0.3783787616795079157142852699862298530265e-1536) }}, 
      {{ SC_(0.67e2), SC_(0.80715478515625e4), SC_(0.6865006402804243398070353234801672966588e-3507) }}, 
      {{ SC_(0.67e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.6015168398426805542472282512313488150136e-7050)) }}, 
      {{ SC_(0.67e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4919008189674129617858770677394899509167e-13928)) }}, 
      {{ SC_(0.67e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2785081625530675286577295403413443334166e-15796)) }}, 
      {{ SC_(0.7e2), SC_(0.24750102996826171875e2), SC_(0.3200133529232737321115234201266326454559e21) }}, 
      {{ SC_(0.7e2), SC_(0.637722015380859375e2), SC_(0.6731146076014642148395421819876868378567e-13) }}, 
      {{ SC_(0.7e2), SC_(0.1252804412841796875e3), SC_(0.7964621054909191295512910144858209516278e-47) }}, 
      {{ SC_(0.7e2), SC_(0.25554705810546875e3), SC_(0.1101144291182637778358682346270185127938e-107) }}, 
      {{ SC_(0.7e2), SC_(0.503011474609375e3), SC_(0.2522817286419656696577388487800399007574e-217) }}, 
      {{ SC_(0.7e2), SC_(0.10074598388671875e4), SC_(0.1310206208699986118807886315832315681721e-437) }}, 
      {{ SC_(0.7e2), SC_(0.1185395751953125e4), SC_(0.4438324037790869017660048341591393207415e-515) }}, 
      {{ SC_(0.7e2), SC_(0.353451806640625e4), SC_(0.4010253858858078283335826255416157967798e-1536) }}, 
      {{ SC_(0.7e2), SC_(0.80715478515625e4), SC_(0.7042018797575106309572625922749346299401e-3507) }}, 
      {{ SC_(0.7e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.6091816057177725949783663850061790717355e-7050)) }}, 
      {{ SC_(0.7e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4950632917672309705754397226621067105838e-13928)) }}, 
      {{ SC_(0.7e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2800863270994291420518570661218980325799e-15796)) }}, 
      {{ SC_(0.73e2), SC_(0.24750102996826171875e2), SC_(0.6600974229573307442059086118768767449093e23) }}, 
      {{ SC_(0.73e2), SC_(0.637722015380859375e2), SC_(0.1201297498924823083105718685052381246325e-11) }}, 
      {{ SC_(0.73e2), SC_(0.1252804412841796875e3), SC_(0.4046845520756788077228347262642337964193e-46) }}, 
      {{ SC_(0.73e2), SC_(0.25554705810546875e3), SC_(0.2518393365952522637287348252737396942553e-107) }}, 
      {{ SC_(0.73e2), SC_(0.503011474609375e3), SC_(0.3857308045703755765391334346735015990041e-217) }}, 
      {{ SC_(0.73e2), SC_(0.10074598388671875e4), SC_(0.1620626521068011080509491031666896383943e-437) }}, 
      {{ SC_(0.73e2), SC_(0.1185395751953125e4), SC_(0.5317713886826713534838432572251814525015e-515) }}, 
      {{ SC_(0.73e2), SC_(0.353451806640625e4), SC_(0.4261107169830410931379086346743264316689e-1536) }}, 
      {{ SC_(0.73e2), SC_(0.80715478515625e4), SC_(0.7231653609674731879282356274318541000741e-3507) }}, 
      {{ SC_(0.73e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.6172862491836114717204373678657121117295e-7050)) }}, 
      {{ SC_(0.73e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.4983859558064200409817902804417896457076e-13928)) }}, 
      {{ SC_(0.73e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2817431477497909957363236959638032643128e-15796)) }}, 
      {{ SC_(0.76e2), SC_(0.24750102996826171875e2), SC_(0.1531183321100941817299267523275491292448e26) }}, 
      {{ SC_(0.76e2), SC_(0.637722015380859375e2), SC_(0.2352685186849495712347188367635010810633e-10) }}, 
      {{ SC_(0.76e2), SC_(0.1252804412841796875e3), SC_(0.2187653883215974720282435704263980509287e-45) }}, 
      {{ SC_(0.76e2), SC_(0.25554705810546875e3), SC_(0.5957804953158544567415337939041815553818e-107) }}, 
      {{ SC_(0.76e2), SC_(0.503011474609375e3), SC_(0.6002961099601760044656616805251101448532e-217) }}, 
      {{ SC_(0.76e2), SC_(0.10074598388671875e4), SC_(0.2022524994842388381712489452722204489107e-437) }}, 
      {{ SC_(0.76e2), SC_(0.1185395751953125e4), SC_(0.6419787531456505117374325893361016267861e-515) }}, 
      {{ SC_(0.76e2), SC_(0.353451806640625e4), SC_(0.4539191527866687375064734054902878636098e-1536) }}, 
      {{ SC_(0.76e2), SC_(0.80715478515625e4), SC_(0.7434679507997340046976676659450109196349e-3507) }}, 
      {{ SC_(0.76e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.625845673025821801704758202141407507098e-7050)) }}, 
      {{ SC_(0.76e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5018717578209518619159368787008041682897e-13928)) }}, 
      {{ SC_(0.76e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2834799123178316316921082908434236819708e-15796)) }}, 
      {{ SC_(0.79e2), SC_(0.24750102996826171875e2), SC_(0.3977450254611439907015094861072686143365e28) }}, 
      {{ SC_(0.79e2), SC_(0.637722015380859375e2), SC_(0.5045557998916834451345285819041530054045e-9) }}, 
      {{ SC_(0.79e2), SC_(0.1252804412841796875e3), SC_(0.1257398100175037281002031105345426585638e-44) }}, 
      {{ SC_(0.79e2), SC_(0.25554705810546875e3), SC_(0.1457761666527355876308418609616580684983e-106) }}, 
      {{ SC_(0.79e2), SC_(0.503011474609375e3), SC_(0.9508736439729252372797046089858665696247e-217) }}, 
      {{ SC_(0.79e2), SC_(0.10074598388671875e4), SC_(0.2546664153931547063082509241536182642882e-437) }}, 
      {{ SC_(0.79e2), SC_(0.1185395751953125e4), SC_(0.7809182105858958259760323416560481270815e-515) }}, 
      {{ SC_(0.79e2), SC_(0.353451806640625e4), SC_(0.4847747575121366789595217747585489900848e-1536) }}, 
      {{ SC_(0.79e2), SC_(0.80715478515625e4), SC_(0.7651931736233482793339884190747843802592e-3507) }}, 
      {{ SC_(0.79e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.634875744436278296417277623731115109911e-7050)) }}, 
      {{ SC_(0.79e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5055238025936264849903127242851811532009e-13928)) }}, 
      {{ SC_(0.79e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2852979759332925163346706705764848988845e-15796)) }}, 
      {{ SC_(0.82e2), SC_(0.637722015380859375e2), SC_(0.1182479183003843898967122682220895379283e-7) }}, 
      {{ SC_(0.82e2), SC_(0.1252804412841796875e3), SC_(0.7679246824874028855732984729868233341459e-44) }}, 
      {{ SC_(0.82e2), SC_(0.25554705810546875e3), SC_(0.3688731597877386657104803215785579078246e-106) }}, 
      {{ SC_(0.82e2), SC_(0.503011474609375e3), SC_(0.1533025263190811001855129953690241988217e-216) }}, 
      {{ SC_(0.82e2), SC_(0.10074598388671875e4), SC_(0.3235306253457630283328305165089298636569e-437) }}, 
      {{ SC_(0.82e2), SC_(0.1185395751953125e4), SC_(0.95714803641107768131549467236444623187e-515) }}, 
      {{ SC_(0.82e2), SC_(0.353451806640625e4), SC_(0.5190472642970221025902053308995793605448e-1536) }}, 
      {{ SC_(0.82e2), SC_(0.80715478515625e4), SC_(0.7884317762303207970574981219562166816935e-3507) }}, 
      {{ SC_(0.82e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.6443933438399520983914837847908697932304e-7050)) }}, 
      {{ SC_(0.82e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5093453575580057440764704712908558993787e-13928)) }}, 
      {{ SC_(0.82e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2871987628027187822900488209818201448873e-15796)) }}, 
      {{ SC_(0.85e2), SC_(0.637722015380859375e2), SC_(0.3022386458998828808890958658069437125556e-6) }}, 
      {{ SC_(0.85e2), SC_(0.1252804412841796875e3), SC_(0.4980051147455231361906632503761840466974e-43) }}, 
      {{ SC_(0.85e2), SC_(0.25554705810546875e3), SC_(0.9651821409596944246819658023453058852567e-106) }}, 
      {{ SC_(0.85e2), SC_(0.503011474609375e3), SC_(0.2515578850121789395121409417066593310199e-216) }}, 
      {{ SC_(0.85e2), SC_(0.10074598388671875e4), SC_(0.4146905619633520795687290702797802077516e-437) }}, 
      {{ SC_(0.85e2), SC_(0.1185395751953125e4), SC_(0.1182063426653318577358697854155415902088e-514) }}, 
      {{ SC_(0.85e2), SC_(0.353451806640625e4), SC_(0.5571590796064834896786127413958385484532e-1536) }}, 
      {{ SC_(0.85e2), SC_(0.80715478515625e4), SC_(0.8132823498430510533405211338608503625054e-3507) }}, 
      {{ SC_(0.85e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.6544164172431353956246831844735505709742e-7050)) }}, 
      {{ SC_(0.85e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5133398576643193156132512241768029727037e-13928)) }}, 
      {{ SC_(0.85e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2891837680670311977658996166762631480513e-15796)) }}, 
      {{ SC_(0.88e2), SC_(0.637722015380859375e2), SC_(0.8408884745537773166223428345981835442608e-5) }}, 
      {{ SC_(0.88e2), SC_(0.1252804412841796875e3), SC_(0.3427163660301187722220573043617848517407e-42) }}, 
      {{ SC_(0.88e2), SC_(0.25554705810546875e3), SC_(0.2611158848229128475717621937789423053511e-105) }}, 
      {{ SC_(0.88e2), SC_(0.503011474609375e3), SC_(0.4201277178177965425183058418537562017403e-216) }}, 
      {{ SC_(0.88e2), SC_(0.10074598388671875e4), SC_(0.5362866581825708379523263981965145477407e-437) }}, 
      {{ SC_(0.88e2), SC_(0.1185395751953125e4), SC_(0.1470923110114575284128795225669870357461e-514) }}, 
      {{ SC_(0.88e2), SC_(0.353451806640625e4), SC_(0.5995934685429881061512313674772217021537e-1536) }}, 
      {{ SC_(0.88e2), SC_(0.80715478515625e4), SC_(0.839852015080128730529999326058629197173e-3507) }}, 
      {{ SC_(0.88e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.664964032329384431282211022073156371507e-7050)) }}, 
      {{ SC_(0.88e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.5175109105174760942763088943597648303892e-13928)) }}, 
      {{ SC_(0.88e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(0.2912545597593180629046239733714231938561e-15796)) }}
   }};


