# REQUIRES: ppc
# RUN: llvm-mc -filetype=obj -triple=powerpc %s -o %t.o
# RUN: echo '.globl b; b:' | llvm-mc -filetype=obj -triple=powerpc - -o %t1.o
# RUN: ld.lld -shared %t1.o -soname=t1.so -o %t1.so

# RUN: ld.lld %t.o %t1.so -o %t
# RUN: llvm-readobj -r %t | FileCheck --check-prefix=RELOC %s
# RUN: llvm-nm %t | FileCheck --check-prefix=NM %s
# RUN: llvm-readobj -x .got %t | FileCheck --check-prefix=HEX %s
# RUN: llvm-objdump -d --no-show-raw-insn %t | FileCheck %s

## Check we can handle R_PPC_GOT16, which may be generated by -fpic code.

# SEC: .got PROGBITS 00020068 020068 000014

# RELOC:      .rela.dyn {
# RELOC-NEXT:   0x1002021C R_PPC_GLOB_DAT b 0x0
# RELOC-NEXT: }

# NM: 10030220 d a

## The GOT slot of a can be filled at link time.
# HEX: section '.got':
# HEX: 0x1002020c {{[0-9a-f]+}} 00000000 00000000 10030220

## a: &.got[3] - _GLOBAL_OFFSET_TABLE_ = 12
## b: &.got[4] - _GLOBAL_OFFSET_TABLE_ = 16
# CHECK: lwz 3, 12(30)
# CHECK: lwz 4, 16(30)

lwz 3,a@got(30)
lwz 4,b@got(30)

.data
a:
.long _GLOBAL_OFFSET_TABLE_
