; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-globals
; RUN: opt -S -mtriple=amdgcn-amd- -amdgpu-annotate-kernel-features < %s | FileCheck -check-prefixes=AKF_CHECK %s
; RUN: opt -S -mtriple=amdgcn-amd- -amdgpu-attributor < %s | FileCheck -check-prefixes=ATTRIBUTOR_CHECK %s

; Test to verify if the attribute gets propagated across nested function calls

; Added to prevent Attributor from deleting calls.
@x = global i32 0

;.
; AKF_CHECK: @[[X:[a-zA-Z0-9_$"\\.-]+]] = global i32 0
;.
; ATTRIBUTOR_CHECK: @[[X:[a-zA-Z0-9_$"\\.-]+]] = global i32 0
;.
define void @func1() #0 {
; AKF_CHECK-LABEL: define {{[^@]+}}@func1
; AKF_CHECK-SAME: () #[[ATTR0:[0-9]+]] {
; AKF_CHECK-NEXT:    store i32 0, i32* @x, align 4
; AKF_CHECK-NEXT:    ret void
;
; ATTRIBUTOR_CHECK-LABEL: define {{[^@]+}}@func1
; ATTRIBUTOR_CHECK-SAME: () #[[ATTR0:[0-9]+]] {
; ATTRIBUTOR_CHECK-NEXT:    store i32 0, i32* @x, align 4
; ATTRIBUTOR_CHECK-NEXT:    ret void
;
  store i32 0, i32* @x
  ret void
}

define void @func2() #1 {
; AKF_CHECK-LABEL: define {{[^@]+}}@func2
; AKF_CHECK-SAME: () #[[ATTR0]] {
; AKF_CHECK-NEXT:    call void @func1()
; AKF_CHECK-NEXT:    ret void
;
; ATTRIBUTOR_CHECK-LABEL: define {{[^@]+}}@func2
; ATTRIBUTOR_CHECK-SAME: () #[[ATTR0]] {
; ATTRIBUTOR_CHECK-NEXT:    call void @func1() #[[ATTR2:[0-9]+]]
; ATTRIBUTOR_CHECK-NEXT:    ret void
;
  call void @func1()
  ret void
}

define amdgpu_kernel void @kernel3() #2 {
; AKF_CHECK-LABEL: define {{[^@]+}}@kernel3
; AKF_CHECK-SAME: () #[[ATTR1:[0-9]+]] {
; AKF_CHECK-NEXT:    call void @func2()
; AKF_CHECK-NEXT:    ret void
;
; ATTRIBUTOR_CHECK-LABEL: define {{[^@]+}}@kernel3
; ATTRIBUTOR_CHECK-SAME: () #[[ATTR1:[0-9]+]] {
; ATTRIBUTOR_CHECK-NEXT:    call void @func2() #[[ATTR2]]
; ATTRIBUTOR_CHECK-NEXT:    ret void
;
  call void @func2()
  ret void
}

attributes #2 = { "uniform-work-group-size"="true" }
;.
; AKF_CHECK: attributes #[[ATTR0]] = { "uniform-work-group-size"="true" }
; AKF_CHECK: attributes #[[ATTR1]] = { "amdgpu-calls" "uniform-work-group-size"="true" }
;.
; ATTRIBUTOR_CHECK: attributes #[[ATTR0]] = { nounwind writeonly "uniform-work-group-size"="false" }
; ATTRIBUTOR_CHECK: attributes #[[ATTR1]] = { "amdgpu-calls" "uniform-work-group-size"="true" }
; ATTRIBUTOR_CHECK: attributes #[[ATTR2]] = { nounwind writeonly }
;.
