; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i32 @test(ptr %target) {
; CHECK-LABEL: @test(
; CHECK-NEXT:    store i8 1, ptr [[TARGET:%.*]], align 1
; CHECK-NEXT:    store i16 257, ptr [[TARGET]], align 2
; CHECK-NEXT:    store i32 16843009, ptr [[TARGET]], align 4
; CHECK-NEXT:    store i64 72340172838076673, ptr [[TARGET]], align 8
; CHECK-NEXT:    ret i32 0
;
  call void @llvm.memset.p0.i32(ptr %target, i8 1, i32 0, i1 false)
  call void @llvm.memset.p0.i32(ptr %target, i8 1, i32 1, i1 false)
  call void @llvm.memset.p0.i32(ptr align 2 %target, i8 1, i32 2, i1 false)
  call void @llvm.memset.p0.i32(ptr align 4 %target, i8 1, i32 4, i1 false)
  call void @llvm.memset.p0.i32(ptr align 8 %target, i8 1, i32 8, i1 false)
  ret i32 0
}

@Unknown = external constant i128

define void @memset_to_constant() {
; CHECK-LABEL: @memset_to_constant(
; CHECK-NEXT:    ret void
;
  call void @llvm.memset.p0.i32(ptr @Unknown, i8 0, i32 16, i1 false)
  ret void
}

; FIXME: This is technically incorrect because it might overwrite a poison
; value. Stop folding it once #52930 is resolved.
define void @memset_undef(ptr %p) {
; CHECK-LABEL: @memset_undef(
; CHECK-NEXT:    ret void
;
  call void @llvm.memset.p0.i32(ptr %p, i8 undef, i32 8, i1 false)
  ret void
}

define void @memset_undef_volatile(ptr %p) {
; CHECK-LABEL: @memset_undef_volatile(
; CHECK-NEXT:    call void @llvm.memset.p0.i32(ptr [[P:%.*]], i8 undef, i32 8, i1 true)
; CHECK-NEXT:    ret void
;
  call void @llvm.memset.p0.i32(ptr %p, i8 undef, i32 8, i1 true)
  ret void
}

define void @memset_poison(ptr %p) {
; CHECK-LABEL: @memset_poison(
; CHECK-NEXT:    ret void
;
  call void @llvm.memset.p0.i32(ptr %p, i8 poison, i32 8, i1 false)
  ret void
}

define void @memset_poison_volatile(ptr %p) {
; CHECK-LABEL: @memset_poison_volatile(
; CHECK-NEXT:    call void @llvm.memset.p0.i32(ptr [[P:%.*]], i8 poison, i32 8, i1 true)
; CHECK-NEXT:    ret void
;
  call void @llvm.memset.p0.i32(ptr %p, i8 poison, i32 8, i1 true)
  ret void
}

declare void @llvm.memset.p0.i32(ptr nocapture writeonly, i8, i32, i1) argmemonly nounwind
