// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#[cfg(feature = "v4_16")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_16")))]
use crate::FontRendering;
use crate::{ffi, StyleProvider};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkSettings")]
    pub struct Settings(Object<ffi::GtkSettings>) @implements StyleProvider;

    match fn {
        type_ => || ffi::gtk_settings_get_type(),
    }
}

impl Settings {
    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Settings`] objects.
    ///
    /// This method returns an instance of [`SettingsBuilder`](crate::builders::SettingsBuilder) which can be used to create [`Settings`] objects.
    pub fn builder() -> SettingsBuilder {
        SettingsBuilder::new()
    }

    #[doc(alias = "gtk_settings_reset_property")]
    pub fn reset_property(&self, name: &str) {
        unsafe {
            ffi::gtk_settings_reset_property(self.to_glib_none().0, name.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk-alternative-button-order")]
    pub fn is_gtk_alternative_button_order(&self) -> bool {
        ObjectExt::property(self, "gtk-alternative-button-order")
    }

    #[doc(alias = "gtk-alternative-button-order")]
    pub fn set_gtk_alternative_button_order(&self, gtk_alternative_button_order: bool) {
        ObjectExt::set_property(
            self,
            "gtk-alternative-button-order",
            gtk_alternative_button_order,
        )
    }

    #[doc(alias = "gtk-alternative-sort-arrows")]
    pub fn is_gtk_alternative_sort_arrows(&self) -> bool {
        ObjectExt::property(self, "gtk-alternative-sort-arrows")
    }

    #[doc(alias = "gtk-alternative-sort-arrows")]
    pub fn set_gtk_alternative_sort_arrows(&self, gtk_alternative_sort_arrows: bool) {
        ObjectExt::set_property(
            self,
            "gtk-alternative-sort-arrows",
            gtk_alternative_sort_arrows,
        )
    }

    #[doc(alias = "gtk-application-prefer-dark-theme")]
    pub fn is_gtk_application_prefer_dark_theme(&self) -> bool {
        ObjectExt::property(self, "gtk-application-prefer-dark-theme")
    }

    #[doc(alias = "gtk-application-prefer-dark-theme")]
    pub fn set_gtk_application_prefer_dark_theme(&self, gtk_application_prefer_dark_theme: bool) {
        ObjectExt::set_property(
            self,
            "gtk-application-prefer-dark-theme",
            gtk_application_prefer_dark_theme,
        )
    }

    #[doc(alias = "gtk-cursor-aspect-ratio")]
    pub fn gtk_cursor_aspect_ratio(&self) -> f64 {
        ObjectExt::property(self, "gtk-cursor-aspect-ratio")
    }

    #[doc(alias = "gtk-cursor-aspect-ratio")]
    pub fn set_gtk_cursor_aspect_ratio(&self, gtk_cursor_aspect_ratio: f64) {
        ObjectExt::set_property(self, "gtk-cursor-aspect-ratio", gtk_cursor_aspect_ratio)
    }

    #[doc(alias = "gtk-cursor-blink")]
    pub fn is_gtk_cursor_blink(&self) -> bool {
        ObjectExt::property(self, "gtk-cursor-blink")
    }

    #[doc(alias = "gtk-cursor-blink")]
    pub fn set_gtk_cursor_blink(&self, gtk_cursor_blink: bool) {
        ObjectExt::set_property(self, "gtk-cursor-blink", gtk_cursor_blink)
    }

    #[doc(alias = "gtk-cursor-blink-time")]
    pub fn gtk_cursor_blink_time(&self) -> i32 {
        ObjectExt::property(self, "gtk-cursor-blink-time")
    }

    #[doc(alias = "gtk-cursor-blink-time")]
    pub fn set_gtk_cursor_blink_time(&self, gtk_cursor_blink_time: i32) {
        ObjectExt::set_property(self, "gtk-cursor-blink-time", gtk_cursor_blink_time)
    }

    #[doc(alias = "gtk-cursor-blink-timeout")]
    pub fn gtk_cursor_blink_timeout(&self) -> i32 {
        ObjectExt::property(self, "gtk-cursor-blink-timeout")
    }

    #[doc(alias = "gtk-cursor-blink-timeout")]
    pub fn set_gtk_cursor_blink_timeout(&self, gtk_cursor_blink_timeout: i32) {
        ObjectExt::set_property(self, "gtk-cursor-blink-timeout", gtk_cursor_blink_timeout)
    }

    #[doc(alias = "gtk-cursor-theme-name")]
    pub fn gtk_cursor_theme_name(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "gtk-cursor-theme-name")
    }

    #[doc(alias = "gtk-cursor-theme-name")]
    pub fn set_gtk_cursor_theme_name(&self, gtk_cursor_theme_name: Option<&str>) {
        ObjectExt::set_property(self, "gtk-cursor-theme-name", gtk_cursor_theme_name)
    }

    #[doc(alias = "gtk-cursor-theme-size")]
    pub fn gtk_cursor_theme_size(&self) -> i32 {
        ObjectExt::property(self, "gtk-cursor-theme-size")
    }

    #[doc(alias = "gtk-cursor-theme-size")]
    pub fn set_gtk_cursor_theme_size(&self, gtk_cursor_theme_size: i32) {
        ObjectExt::set_property(self, "gtk-cursor-theme-size", gtk_cursor_theme_size)
    }

    #[doc(alias = "gtk-decoration-layout")]
    pub fn gtk_decoration_layout(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "gtk-decoration-layout")
    }

    #[doc(alias = "gtk-decoration-layout")]
    pub fn set_gtk_decoration_layout(&self, gtk_decoration_layout: Option<&str>) {
        ObjectExt::set_property(self, "gtk-decoration-layout", gtk_decoration_layout)
    }

    #[doc(alias = "gtk-dialogs-use-header")]
    pub fn is_gtk_dialogs_use_header(&self) -> bool {
        ObjectExt::property(self, "gtk-dialogs-use-header")
    }

    #[doc(alias = "gtk-dialogs-use-header")]
    pub fn set_gtk_dialogs_use_header(&self, gtk_dialogs_use_header: bool) {
        ObjectExt::set_property(self, "gtk-dialogs-use-header", gtk_dialogs_use_header)
    }

    #[doc(alias = "gtk-dnd-drag-threshold")]
    pub fn gtk_dnd_drag_threshold(&self) -> i32 {
        ObjectExt::property(self, "gtk-dnd-drag-threshold")
    }

    #[doc(alias = "gtk-dnd-drag-threshold")]
    pub fn set_gtk_dnd_drag_threshold(&self, gtk_dnd_drag_threshold: i32) {
        ObjectExt::set_property(self, "gtk-dnd-drag-threshold", gtk_dnd_drag_threshold)
    }

    #[doc(alias = "gtk-double-click-distance")]
    pub fn gtk_double_click_distance(&self) -> i32 {
        ObjectExt::property(self, "gtk-double-click-distance")
    }

    #[doc(alias = "gtk-double-click-distance")]
    pub fn set_gtk_double_click_distance(&self, gtk_double_click_distance: i32) {
        ObjectExt::set_property(self, "gtk-double-click-distance", gtk_double_click_distance)
    }

    #[doc(alias = "gtk-double-click-time")]
    pub fn gtk_double_click_time(&self) -> i32 {
        ObjectExt::property(self, "gtk-double-click-time")
    }

    #[doc(alias = "gtk-double-click-time")]
    pub fn set_gtk_double_click_time(&self, gtk_double_click_time: i32) {
        ObjectExt::set_property(self, "gtk-double-click-time", gtk_double_click_time)
    }

    #[doc(alias = "gtk-enable-accels")]
    pub fn is_gtk_enable_accels(&self) -> bool {
        ObjectExt::property(self, "gtk-enable-accels")
    }

    #[doc(alias = "gtk-enable-accels")]
    pub fn set_gtk_enable_accels(&self, gtk_enable_accels: bool) {
        ObjectExt::set_property(self, "gtk-enable-accels", gtk_enable_accels)
    }

    #[doc(alias = "gtk-enable-animations")]
    pub fn is_gtk_enable_animations(&self) -> bool {
        ObjectExt::property(self, "gtk-enable-animations")
    }

    #[doc(alias = "gtk-enable-animations")]
    pub fn set_gtk_enable_animations(&self, gtk_enable_animations: bool) {
        ObjectExt::set_property(self, "gtk-enable-animations", gtk_enable_animations)
    }

    #[doc(alias = "gtk-enable-event-sounds")]
    pub fn is_gtk_enable_event_sounds(&self) -> bool {
        ObjectExt::property(self, "gtk-enable-event-sounds")
    }

    #[doc(alias = "gtk-enable-event-sounds")]
    pub fn set_gtk_enable_event_sounds(&self, gtk_enable_event_sounds: bool) {
        ObjectExt::set_property(self, "gtk-enable-event-sounds", gtk_enable_event_sounds)
    }

    #[doc(alias = "gtk-enable-input-feedback-sounds")]
    pub fn is_gtk_enable_input_feedback_sounds(&self) -> bool {
        ObjectExt::property(self, "gtk-enable-input-feedback-sounds")
    }

    #[doc(alias = "gtk-enable-input-feedback-sounds")]
    pub fn set_gtk_enable_input_feedback_sounds(&self, gtk_enable_input_feedback_sounds: bool) {
        ObjectExt::set_property(
            self,
            "gtk-enable-input-feedback-sounds",
            gtk_enable_input_feedback_sounds,
        )
    }

    #[doc(alias = "gtk-enable-primary-paste")]
    pub fn is_gtk_enable_primary_paste(&self) -> bool {
        ObjectExt::property(self, "gtk-enable-primary-paste")
    }

    #[doc(alias = "gtk-enable-primary-paste")]
    pub fn set_gtk_enable_primary_paste(&self, gtk_enable_primary_paste: bool) {
        ObjectExt::set_property(self, "gtk-enable-primary-paste", gtk_enable_primary_paste)
    }

    #[doc(alias = "gtk-entry-password-hint-timeout")]
    pub fn gtk_entry_password_hint_timeout(&self) -> u32 {
        ObjectExt::property(self, "gtk-entry-password-hint-timeout")
    }

    #[doc(alias = "gtk-entry-password-hint-timeout")]
    pub fn set_gtk_entry_password_hint_timeout(&self, gtk_entry_password_hint_timeout: u32) {
        ObjectExt::set_property(
            self,
            "gtk-entry-password-hint-timeout",
            gtk_entry_password_hint_timeout,
        )
    }

    #[doc(alias = "gtk-entry-select-on-focus")]
    pub fn is_gtk_entry_select_on_focus(&self) -> bool {
        ObjectExt::property(self, "gtk-entry-select-on-focus")
    }

    #[doc(alias = "gtk-entry-select-on-focus")]
    pub fn set_gtk_entry_select_on_focus(&self, gtk_entry_select_on_focus: bool) {
        ObjectExt::set_property(self, "gtk-entry-select-on-focus", gtk_entry_select_on_focus)
    }

    #[doc(alias = "gtk-error-bell")]
    pub fn is_gtk_error_bell(&self) -> bool {
        ObjectExt::property(self, "gtk-error-bell")
    }

    #[doc(alias = "gtk-error-bell")]
    pub fn set_gtk_error_bell(&self, gtk_error_bell: bool) {
        ObjectExt::set_property(self, "gtk-error-bell", gtk_error_bell)
    }

    #[doc(alias = "gtk-font-name")]
    pub fn gtk_font_name(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "gtk-font-name")
    }

    #[doc(alias = "gtk-font-name")]
    pub fn set_gtk_font_name(&self, gtk_font_name: Option<&str>) {
        ObjectExt::set_property(self, "gtk-font-name", gtk_font_name)
    }

    #[cfg(feature = "v4_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_16")))]
    #[doc(alias = "gtk-font-rendering")]
    pub fn gtk_font_rendering(&self) -> FontRendering {
        ObjectExt::property(self, "gtk-font-rendering")
    }

    #[cfg(feature = "v4_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_16")))]
    #[doc(alias = "gtk-font-rendering")]
    pub fn set_gtk_font_rendering(&self, gtk_font_rendering: FontRendering) {
        ObjectExt::set_property(self, "gtk-font-rendering", gtk_font_rendering)
    }

    #[doc(alias = "gtk-fontconfig-timestamp")]
    pub fn gtk_fontconfig_timestamp(&self) -> u32 {
        ObjectExt::property(self, "gtk-fontconfig-timestamp")
    }

    #[doc(alias = "gtk-fontconfig-timestamp")]
    pub fn set_gtk_fontconfig_timestamp(&self, gtk_fontconfig_timestamp: u32) {
        ObjectExt::set_property(self, "gtk-fontconfig-timestamp", gtk_fontconfig_timestamp)
    }

    #[cfg(feature = "v4_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_6")))]
    #[doc(alias = "gtk-hint-font-metrics")]
    pub fn is_gtk_hint_font_metrics(&self) -> bool {
        ObjectExt::property(self, "gtk-hint-font-metrics")
    }

    #[cfg(feature = "v4_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_6")))]
    #[doc(alias = "gtk-hint-font-metrics")]
    pub fn set_gtk_hint_font_metrics(&self, gtk_hint_font_metrics: bool) {
        ObjectExt::set_property(self, "gtk-hint-font-metrics", gtk_hint_font_metrics)
    }

    #[doc(alias = "gtk-icon-theme-name")]
    pub fn gtk_icon_theme_name(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "gtk-icon-theme-name")
    }

    #[doc(alias = "gtk-icon-theme-name")]
    pub fn set_gtk_icon_theme_name(&self, gtk_icon_theme_name: Option<&str>) {
        ObjectExt::set_property(self, "gtk-icon-theme-name", gtk_icon_theme_name)
    }

    #[doc(alias = "gtk-im-module")]
    pub fn gtk_im_module(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "gtk-im-module")
    }

    #[doc(alias = "gtk-im-module")]
    pub fn set_gtk_im_module(&self, gtk_im_module: Option<&str>) {
        ObjectExt::set_property(self, "gtk-im-module", gtk_im_module)
    }

    #[doc(alias = "gtk-keynav-use-caret")]
    pub fn is_gtk_keynav_use_caret(&self) -> bool {
        ObjectExt::property(self, "gtk-keynav-use-caret")
    }

    #[doc(alias = "gtk-keynav-use-caret")]
    pub fn set_gtk_keynav_use_caret(&self, gtk_keynav_use_caret: bool) {
        ObjectExt::set_property(self, "gtk-keynav-use-caret", gtk_keynav_use_caret)
    }

    #[doc(alias = "gtk-label-select-on-focus")]
    pub fn is_gtk_label_select_on_focus(&self) -> bool {
        ObjectExt::property(self, "gtk-label-select-on-focus")
    }

    #[doc(alias = "gtk-label-select-on-focus")]
    pub fn set_gtk_label_select_on_focus(&self, gtk_label_select_on_focus: bool) {
        ObjectExt::set_property(self, "gtk-label-select-on-focus", gtk_label_select_on_focus)
    }

    #[doc(alias = "gtk-long-press-time")]
    pub fn gtk_long_press_time(&self) -> u32 {
        ObjectExt::property(self, "gtk-long-press-time")
    }

    #[doc(alias = "gtk-long-press-time")]
    pub fn set_gtk_long_press_time(&self, gtk_long_press_time: u32) {
        ObjectExt::set_property(self, "gtk-long-press-time", gtk_long_press_time)
    }

    #[doc(alias = "gtk-overlay-scrolling")]
    pub fn is_gtk_overlay_scrolling(&self) -> bool {
        ObjectExt::property(self, "gtk-overlay-scrolling")
    }

    #[doc(alias = "gtk-overlay-scrolling")]
    pub fn set_gtk_overlay_scrolling(&self, gtk_overlay_scrolling: bool) {
        ObjectExt::set_property(self, "gtk-overlay-scrolling", gtk_overlay_scrolling)
    }

    #[doc(alias = "gtk-primary-button-warps-slider")]
    pub fn is_gtk_primary_button_warps_slider(&self) -> bool {
        ObjectExt::property(self, "gtk-primary-button-warps-slider")
    }

    #[doc(alias = "gtk-primary-button-warps-slider")]
    pub fn set_gtk_primary_button_warps_slider(&self, gtk_primary_button_warps_slider: bool) {
        ObjectExt::set_property(
            self,
            "gtk-primary-button-warps-slider",
            gtk_primary_button_warps_slider,
        )
    }

    #[doc(alias = "gtk-print-backends")]
    pub fn gtk_print_backends(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "gtk-print-backends")
    }

    #[doc(alias = "gtk-print-backends")]
    pub fn set_gtk_print_backends(&self, gtk_print_backends: Option<&str>) {
        ObjectExt::set_property(self, "gtk-print-backends", gtk_print_backends)
    }

    #[doc(alias = "gtk-print-preview-command")]
    pub fn gtk_print_preview_command(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "gtk-print-preview-command")
    }

    #[doc(alias = "gtk-print-preview-command")]
    pub fn set_gtk_print_preview_command(&self, gtk_print_preview_command: Option<&str>) {
        ObjectExt::set_property(self, "gtk-print-preview-command", gtk_print_preview_command)
    }

    #[doc(alias = "gtk-recent-files-enabled")]
    pub fn is_gtk_recent_files_enabled(&self) -> bool {
        ObjectExt::property(self, "gtk-recent-files-enabled")
    }

    #[doc(alias = "gtk-recent-files-enabled")]
    pub fn set_gtk_recent_files_enabled(&self, gtk_recent_files_enabled: bool) {
        ObjectExt::set_property(self, "gtk-recent-files-enabled", gtk_recent_files_enabled)
    }

    #[doc(alias = "gtk-recent-files-max-age")]
    pub fn gtk_recent_files_max_age(&self) -> i32 {
        ObjectExt::property(self, "gtk-recent-files-max-age")
    }

    #[doc(alias = "gtk-recent-files-max-age")]
    pub fn set_gtk_recent_files_max_age(&self, gtk_recent_files_max_age: i32) {
        ObjectExt::set_property(self, "gtk-recent-files-max-age", gtk_recent_files_max_age)
    }

    #[doc(alias = "gtk-shell-shows-app-menu")]
    pub fn is_gtk_shell_shows_app_menu(&self) -> bool {
        ObjectExt::property(self, "gtk-shell-shows-app-menu")
    }

    #[doc(alias = "gtk-shell-shows-app-menu")]
    pub fn set_gtk_shell_shows_app_menu(&self, gtk_shell_shows_app_menu: bool) {
        ObjectExt::set_property(self, "gtk-shell-shows-app-menu", gtk_shell_shows_app_menu)
    }

    #[doc(alias = "gtk-shell-shows-desktop")]
    pub fn is_gtk_shell_shows_desktop(&self) -> bool {
        ObjectExt::property(self, "gtk-shell-shows-desktop")
    }

    #[doc(alias = "gtk-shell-shows-desktop")]
    pub fn set_gtk_shell_shows_desktop(&self, gtk_shell_shows_desktop: bool) {
        ObjectExt::set_property(self, "gtk-shell-shows-desktop", gtk_shell_shows_desktop)
    }

    #[doc(alias = "gtk-shell-shows-menubar")]
    pub fn is_gtk_shell_shows_menubar(&self) -> bool {
        ObjectExt::property(self, "gtk-shell-shows-menubar")
    }

    #[doc(alias = "gtk-shell-shows-menubar")]
    pub fn set_gtk_shell_shows_menubar(&self, gtk_shell_shows_menubar: bool) {
        ObjectExt::set_property(self, "gtk-shell-shows-menubar", gtk_shell_shows_menubar)
    }

    #[cfg(feature = "v4_14")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
    #[doc(alias = "gtk-show-status-shapes")]
    pub fn is_gtk_show_status_shapes(&self) -> bool {
        ObjectExt::property(self, "gtk-show-status-shapes")
    }

    #[cfg(feature = "v4_14")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
    #[doc(alias = "gtk-show-status-shapes")]
    pub fn set_gtk_show_status_shapes(&self, gtk_show_status_shapes: bool) {
        ObjectExt::set_property(self, "gtk-show-status-shapes", gtk_show_status_shapes)
    }

    #[doc(alias = "gtk-sound-theme-name")]
    pub fn gtk_sound_theme_name(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "gtk-sound-theme-name")
    }

    #[doc(alias = "gtk-sound-theme-name")]
    pub fn set_gtk_sound_theme_name(&self, gtk_sound_theme_name: Option<&str>) {
        ObjectExt::set_property(self, "gtk-sound-theme-name", gtk_sound_theme_name)
    }

    #[doc(alias = "gtk-split-cursor")]
    pub fn is_gtk_split_cursor(&self) -> bool {
        ObjectExt::property(self, "gtk-split-cursor")
    }

    #[doc(alias = "gtk-split-cursor")]
    pub fn set_gtk_split_cursor(&self, gtk_split_cursor: bool) {
        ObjectExt::set_property(self, "gtk-split-cursor", gtk_split_cursor)
    }

    #[doc(alias = "gtk-theme-name")]
    pub fn gtk_theme_name(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "gtk-theme-name")
    }

    #[doc(alias = "gtk-theme-name")]
    pub fn set_gtk_theme_name(&self, gtk_theme_name: Option<&str>) {
        ObjectExt::set_property(self, "gtk-theme-name", gtk_theme_name)
    }

    #[doc(alias = "gtk-titlebar-double-click")]
    pub fn gtk_titlebar_double_click(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "gtk-titlebar-double-click")
    }

    #[doc(alias = "gtk-titlebar-double-click")]
    pub fn set_gtk_titlebar_double_click(&self, gtk_titlebar_double_click: Option<&str>) {
        ObjectExt::set_property(self, "gtk-titlebar-double-click", gtk_titlebar_double_click)
    }

    #[doc(alias = "gtk-titlebar-middle-click")]
    pub fn gtk_titlebar_middle_click(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "gtk-titlebar-middle-click")
    }

    #[doc(alias = "gtk-titlebar-middle-click")]
    pub fn set_gtk_titlebar_middle_click(&self, gtk_titlebar_middle_click: Option<&str>) {
        ObjectExt::set_property(self, "gtk-titlebar-middle-click", gtk_titlebar_middle_click)
    }

    #[doc(alias = "gtk-titlebar-right-click")]
    pub fn gtk_titlebar_right_click(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "gtk-titlebar-right-click")
    }

    #[doc(alias = "gtk-titlebar-right-click")]
    pub fn set_gtk_titlebar_right_click(&self, gtk_titlebar_right_click: Option<&str>) {
        ObjectExt::set_property(self, "gtk-titlebar-right-click", gtk_titlebar_right_click)
    }

    #[doc(alias = "gtk-xft-antialias")]
    pub fn gtk_xft_antialias(&self) -> i32 {
        ObjectExt::property(self, "gtk-xft-antialias")
    }

    #[doc(alias = "gtk-xft-antialias")]
    pub fn set_gtk_xft_antialias(&self, gtk_xft_antialias: i32) {
        ObjectExt::set_property(self, "gtk-xft-antialias", gtk_xft_antialias)
    }

    #[doc(alias = "gtk-xft-dpi")]
    pub fn gtk_xft_dpi(&self) -> i32 {
        ObjectExt::property(self, "gtk-xft-dpi")
    }

    #[doc(alias = "gtk-xft-dpi")]
    pub fn set_gtk_xft_dpi(&self, gtk_xft_dpi: i32) {
        ObjectExt::set_property(self, "gtk-xft-dpi", gtk_xft_dpi)
    }

    #[doc(alias = "gtk-xft-hinting")]
    pub fn gtk_xft_hinting(&self) -> i32 {
        ObjectExt::property(self, "gtk-xft-hinting")
    }

    #[doc(alias = "gtk-xft-hinting")]
    pub fn set_gtk_xft_hinting(&self, gtk_xft_hinting: i32) {
        ObjectExt::set_property(self, "gtk-xft-hinting", gtk_xft_hinting)
    }

    #[doc(alias = "gtk-xft-hintstyle")]
    pub fn gtk_xft_hintstyle(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "gtk-xft-hintstyle")
    }

    #[doc(alias = "gtk-xft-hintstyle")]
    pub fn set_gtk_xft_hintstyle(&self, gtk_xft_hintstyle: Option<&str>) {
        ObjectExt::set_property(self, "gtk-xft-hintstyle", gtk_xft_hintstyle)
    }

    #[doc(alias = "gtk-xft-rgba")]
    pub fn gtk_xft_rgba(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "gtk-xft-rgba")
    }

    #[doc(alias = "gtk-xft-rgba")]
    pub fn set_gtk_xft_rgba(&self, gtk_xft_rgba: Option<&str>) {
        ObjectExt::set_property(self, "gtk-xft-rgba", gtk_xft_rgba)
    }

    #[doc(alias = "gtk_settings_get_default")]
    #[doc(alias = "get_default")]
    #[allow(clippy::should_implement_trait)]
    pub fn default() -> Option<Settings> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_settings_get_default()) }
    }

    #[doc(alias = "gtk_settings_get_for_display")]
    #[doc(alias = "get_for_display")]
    pub fn for_display(display: &impl IsA<gdk::Display>) -> Settings {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(ffi::gtk_settings_get_for_display(
                display.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk-alternative-button-order")]
    pub fn connect_gtk_alternative_button_order_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_alternative_button_order_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-alternative-button-order".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_alternative_button_order_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-alternative-sort-arrows")]
    pub fn connect_gtk_alternative_sort_arrows_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_alternative_sort_arrows_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-alternative-sort-arrows".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_alternative_sort_arrows_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-application-prefer-dark-theme")]
    pub fn connect_gtk_application_prefer_dark_theme_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_application_prefer_dark_theme_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-application-prefer-dark-theme".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_application_prefer_dark_theme_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-cursor-aspect-ratio")]
    pub fn connect_gtk_cursor_aspect_ratio_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_aspect_ratio_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-cursor-aspect-ratio".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_cursor_aspect_ratio_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-cursor-blink")]
    pub fn connect_gtk_cursor_blink_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_blink_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-cursor-blink".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_cursor_blink_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-cursor-blink-time")]
    pub fn connect_gtk_cursor_blink_time_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_blink_time_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-cursor-blink-time".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_cursor_blink_time_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-cursor-blink-timeout")]
    pub fn connect_gtk_cursor_blink_timeout_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_blink_timeout_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-cursor-blink-timeout".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_cursor_blink_timeout_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-cursor-theme-name")]
    pub fn connect_gtk_cursor_theme_name_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_theme_name_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-cursor-theme-name".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_cursor_theme_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-cursor-theme-size")]
    pub fn connect_gtk_cursor_theme_size_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_theme_size_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-cursor-theme-size".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_cursor_theme_size_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-decoration-layout")]
    pub fn connect_gtk_decoration_layout_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_decoration_layout_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-decoration-layout".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_decoration_layout_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-dialogs-use-header")]
    pub fn connect_gtk_dialogs_use_header_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_dialogs_use_header_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-dialogs-use-header".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_dialogs_use_header_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-dnd-drag-threshold")]
    pub fn connect_gtk_dnd_drag_threshold_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_dnd_drag_threshold_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-dnd-drag-threshold".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_dnd_drag_threshold_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-double-click-distance")]
    pub fn connect_gtk_double_click_distance_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_double_click_distance_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-double-click-distance".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_double_click_distance_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-double-click-time")]
    pub fn connect_gtk_double_click_time_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_double_click_time_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-double-click-time".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_double_click_time_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-enable-accels")]
    pub fn connect_gtk_enable_accels_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_enable_accels_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-enable-accels".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_enable_accels_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-enable-animations")]
    pub fn connect_gtk_enable_animations_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_enable_animations_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-enable-animations".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_enable_animations_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-enable-event-sounds")]
    pub fn connect_gtk_enable_event_sounds_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_enable_event_sounds_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-enable-event-sounds".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_enable_event_sounds_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-enable-input-feedback-sounds")]
    pub fn connect_gtk_enable_input_feedback_sounds_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_enable_input_feedback_sounds_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-enable-input-feedback-sounds".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_enable_input_feedback_sounds_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-enable-primary-paste")]
    pub fn connect_gtk_enable_primary_paste_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_enable_primary_paste_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-enable-primary-paste".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_enable_primary_paste_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-entry-password-hint-timeout")]
    pub fn connect_gtk_entry_password_hint_timeout_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_entry_password_hint_timeout_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-entry-password-hint-timeout".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_entry_password_hint_timeout_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-entry-select-on-focus")]
    pub fn connect_gtk_entry_select_on_focus_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_entry_select_on_focus_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-entry-select-on-focus".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_entry_select_on_focus_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-error-bell")]
    pub fn connect_gtk_error_bell_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_error_bell_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-error-bell".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_error_bell_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-font-name")]
    pub fn connect_gtk_font_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_font_name_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-font-name".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_font_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_16")))]
    #[doc(alias = "gtk-font-rendering")]
    pub fn connect_gtk_font_rendering_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_font_rendering_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-font-rendering".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_font_rendering_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-fontconfig-timestamp")]
    pub fn connect_gtk_fontconfig_timestamp_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_fontconfig_timestamp_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-fontconfig-timestamp".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_fontconfig_timestamp_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_6")))]
    #[doc(alias = "gtk-hint-font-metrics")]
    pub fn connect_gtk_hint_font_metrics_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_hint_font_metrics_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-hint-font-metrics".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_hint_font_metrics_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-icon-theme-name")]
    pub fn connect_gtk_icon_theme_name_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_icon_theme_name_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-icon-theme-name".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_icon_theme_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-im-module")]
    pub fn connect_gtk_im_module_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_im_module_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-im-module".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_im_module_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-keynav-use-caret")]
    pub fn connect_gtk_keynav_use_caret_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_keynav_use_caret_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-keynav-use-caret".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_keynav_use_caret_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-label-select-on-focus")]
    pub fn connect_gtk_label_select_on_focus_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_label_select_on_focus_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-label-select-on-focus".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_label_select_on_focus_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-long-press-time")]
    pub fn connect_gtk_long_press_time_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_long_press_time_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-long-press-time".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_long_press_time_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-overlay-scrolling")]
    pub fn connect_gtk_overlay_scrolling_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_overlay_scrolling_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-overlay-scrolling".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_overlay_scrolling_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-primary-button-warps-slider")]
    pub fn connect_gtk_primary_button_warps_slider_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_primary_button_warps_slider_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-primary-button-warps-slider".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_primary_button_warps_slider_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-print-backends")]
    pub fn connect_gtk_print_backends_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_print_backends_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-print-backends".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_print_backends_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-print-preview-command")]
    pub fn connect_gtk_print_preview_command_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_print_preview_command_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-print-preview-command".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_print_preview_command_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-recent-files-enabled")]
    pub fn connect_gtk_recent_files_enabled_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_recent_files_enabled_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-recent-files-enabled".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_recent_files_enabled_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-recent-files-max-age")]
    pub fn connect_gtk_recent_files_max_age_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_recent_files_max_age_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-recent-files-max-age".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_recent_files_max_age_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-shell-shows-app-menu")]
    pub fn connect_gtk_shell_shows_app_menu_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_shell_shows_app_menu_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-shell-shows-app-menu".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_shell_shows_app_menu_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-shell-shows-desktop")]
    pub fn connect_gtk_shell_shows_desktop_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_shell_shows_desktop_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-shell-shows-desktop".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_shell_shows_desktop_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-shell-shows-menubar")]
    pub fn connect_gtk_shell_shows_menubar_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_shell_shows_menubar_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-shell-shows-menubar".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_shell_shows_menubar_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_14")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
    #[doc(alias = "gtk-show-status-shapes")]
    pub fn connect_gtk_show_status_shapes_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_show_status_shapes_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-show-status-shapes".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_show_status_shapes_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-sound-theme-name")]
    pub fn connect_gtk_sound_theme_name_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_sound_theme_name_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-sound-theme-name".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_sound_theme_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-split-cursor")]
    pub fn connect_gtk_split_cursor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_split_cursor_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-split-cursor".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_split_cursor_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-theme-name")]
    pub fn connect_gtk_theme_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_theme_name_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-theme-name".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_theme_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-titlebar-double-click")]
    pub fn connect_gtk_titlebar_double_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_titlebar_double_click_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-titlebar-double-click".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_titlebar_double_click_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-titlebar-middle-click")]
    pub fn connect_gtk_titlebar_middle_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_titlebar_middle_click_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-titlebar-middle-click".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_titlebar_middle_click_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-titlebar-right-click")]
    pub fn connect_gtk_titlebar_right_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_titlebar_right_click_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-titlebar-right-click".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_titlebar_right_click_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-xft-antialias")]
    pub fn connect_gtk_xft_antialias_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_xft_antialias_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-xft-antialias".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_xft_antialias_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-xft-dpi")]
    pub fn connect_gtk_xft_dpi_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_xft_dpi_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-xft-dpi".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_xft_dpi_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-xft-hinting")]
    pub fn connect_gtk_xft_hinting_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_xft_hinting_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-xft-hinting".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_xft_hinting_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-xft-hintstyle")]
    pub fn connect_gtk_xft_hintstyle_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_xft_hintstyle_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-xft-hintstyle".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_xft_hintstyle_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-xft-rgba")]
    pub fn connect_gtk_xft_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_xft_rgba_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::gtk-xft-rgba".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_gtk_xft_rgba_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Settings`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct SettingsBuilder {
    builder: glib::object::ObjectBuilder<'static, Settings>,
}

impl SettingsBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn gtk_alternative_button_order(self, gtk_alternative_button_order: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-alternative-button-order", gtk_alternative_button_order),
        }
    }

    pub fn gtk_alternative_sort_arrows(self, gtk_alternative_sort_arrows: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-alternative-sort-arrows", gtk_alternative_sort_arrows),
        }
    }

    pub fn gtk_application_prefer_dark_theme(
        self,
        gtk_application_prefer_dark_theme: bool,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "gtk-application-prefer-dark-theme",
                gtk_application_prefer_dark_theme,
            ),
        }
    }

    pub fn gtk_cursor_aspect_ratio(self, gtk_cursor_aspect_ratio: f64) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-cursor-aspect-ratio", gtk_cursor_aspect_ratio),
        }
    }

    pub fn gtk_cursor_blink(self, gtk_cursor_blink: bool) -> Self {
        Self {
            builder: self.builder.property("gtk-cursor-blink", gtk_cursor_blink),
        }
    }

    pub fn gtk_cursor_blink_time(self, gtk_cursor_blink_time: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-cursor-blink-time", gtk_cursor_blink_time),
        }
    }

    pub fn gtk_cursor_blink_timeout(self, gtk_cursor_blink_timeout: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-cursor-blink-timeout", gtk_cursor_blink_timeout),
        }
    }

    pub fn gtk_cursor_theme_name(self, gtk_cursor_theme_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-cursor-theme-name", gtk_cursor_theme_name.into()),
        }
    }

    pub fn gtk_cursor_theme_size(self, gtk_cursor_theme_size: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-cursor-theme-size", gtk_cursor_theme_size),
        }
    }

    pub fn gtk_decoration_layout(self, gtk_decoration_layout: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-decoration-layout", gtk_decoration_layout.into()),
        }
    }

    pub fn gtk_dialogs_use_header(self, gtk_dialogs_use_header: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-dialogs-use-header", gtk_dialogs_use_header),
        }
    }

    pub fn gtk_dnd_drag_threshold(self, gtk_dnd_drag_threshold: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-dnd-drag-threshold", gtk_dnd_drag_threshold),
        }
    }

    pub fn gtk_double_click_distance(self, gtk_double_click_distance: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-double-click-distance", gtk_double_click_distance),
        }
    }

    pub fn gtk_double_click_time(self, gtk_double_click_time: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-double-click-time", gtk_double_click_time),
        }
    }

    pub fn gtk_enable_accels(self, gtk_enable_accels: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-enable-accels", gtk_enable_accels),
        }
    }

    pub fn gtk_enable_animations(self, gtk_enable_animations: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-enable-animations", gtk_enable_animations),
        }
    }

    pub fn gtk_enable_event_sounds(self, gtk_enable_event_sounds: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-enable-event-sounds", gtk_enable_event_sounds),
        }
    }

    pub fn gtk_enable_input_feedback_sounds(self, gtk_enable_input_feedback_sounds: bool) -> Self {
        Self {
            builder: self.builder.property(
                "gtk-enable-input-feedback-sounds",
                gtk_enable_input_feedback_sounds,
            ),
        }
    }

    pub fn gtk_enable_primary_paste(self, gtk_enable_primary_paste: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-enable-primary-paste", gtk_enable_primary_paste),
        }
    }

    pub fn gtk_entry_password_hint_timeout(self, gtk_entry_password_hint_timeout: u32) -> Self {
        Self {
            builder: self.builder.property(
                "gtk-entry-password-hint-timeout",
                gtk_entry_password_hint_timeout,
            ),
        }
    }

    pub fn gtk_entry_select_on_focus(self, gtk_entry_select_on_focus: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-entry-select-on-focus", gtk_entry_select_on_focus),
        }
    }

    pub fn gtk_error_bell(self, gtk_error_bell: bool) -> Self {
        Self {
            builder: self.builder.property("gtk-error-bell", gtk_error_bell),
        }
    }

    pub fn gtk_font_name(self, gtk_font_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("gtk-font-name", gtk_font_name.into()),
        }
    }

    #[cfg(feature = "v4_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_16")))]
    pub fn gtk_font_rendering(self, gtk_font_rendering: FontRendering) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-font-rendering", gtk_font_rendering),
        }
    }

    pub fn gtk_fontconfig_timestamp(self, gtk_fontconfig_timestamp: u32) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-fontconfig-timestamp", gtk_fontconfig_timestamp),
        }
    }

    #[cfg(feature = "v4_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_6")))]
    pub fn gtk_hint_font_metrics(self, gtk_hint_font_metrics: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-hint-font-metrics", gtk_hint_font_metrics),
        }
    }

    pub fn gtk_icon_theme_name(self, gtk_icon_theme_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-icon-theme-name", gtk_icon_theme_name.into()),
        }
    }

    pub fn gtk_im_module(self, gtk_im_module: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("gtk-im-module", gtk_im_module.into()),
        }
    }

    pub fn gtk_keynav_use_caret(self, gtk_keynav_use_caret: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-keynav-use-caret", gtk_keynav_use_caret),
        }
    }

    pub fn gtk_label_select_on_focus(self, gtk_label_select_on_focus: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-label-select-on-focus", gtk_label_select_on_focus),
        }
    }

    pub fn gtk_long_press_time(self, gtk_long_press_time: u32) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-long-press-time", gtk_long_press_time),
        }
    }

    pub fn gtk_overlay_scrolling(self, gtk_overlay_scrolling: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-overlay-scrolling", gtk_overlay_scrolling),
        }
    }

    pub fn gtk_primary_button_warps_slider(self, gtk_primary_button_warps_slider: bool) -> Self {
        Self {
            builder: self.builder.property(
                "gtk-primary-button-warps-slider",
                gtk_primary_button_warps_slider,
            ),
        }
    }

    pub fn gtk_print_backends(self, gtk_print_backends: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-print-backends", gtk_print_backends.into()),
        }
    }

    pub fn gtk_print_preview_command(
        self,
        gtk_print_preview_command: impl Into<glib::GString>,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "gtk-print-preview-command",
                gtk_print_preview_command.into(),
            ),
        }
    }

    pub fn gtk_recent_files_enabled(self, gtk_recent_files_enabled: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-recent-files-enabled", gtk_recent_files_enabled),
        }
    }

    pub fn gtk_recent_files_max_age(self, gtk_recent_files_max_age: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-recent-files-max-age", gtk_recent_files_max_age),
        }
    }

    pub fn gtk_shell_shows_app_menu(self, gtk_shell_shows_app_menu: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-shell-shows-app-menu", gtk_shell_shows_app_menu),
        }
    }

    pub fn gtk_shell_shows_desktop(self, gtk_shell_shows_desktop: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-shell-shows-desktop", gtk_shell_shows_desktop),
        }
    }

    pub fn gtk_shell_shows_menubar(self, gtk_shell_shows_menubar: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-shell-shows-menubar", gtk_shell_shows_menubar),
        }
    }

    #[cfg(feature = "v4_14")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
    pub fn gtk_show_status_shapes(self, gtk_show_status_shapes: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-show-status-shapes", gtk_show_status_shapes),
        }
    }

    pub fn gtk_sound_theme_name(self, gtk_sound_theme_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-sound-theme-name", gtk_sound_theme_name.into()),
        }
    }

    pub fn gtk_split_cursor(self, gtk_split_cursor: bool) -> Self {
        Self {
            builder: self.builder.property("gtk-split-cursor", gtk_split_cursor),
        }
    }

    pub fn gtk_theme_name(self, gtk_theme_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-theme-name", gtk_theme_name.into()),
        }
    }

    pub fn gtk_titlebar_double_click(
        self,
        gtk_titlebar_double_click: impl Into<glib::GString>,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "gtk-titlebar-double-click",
                gtk_titlebar_double_click.into(),
            ),
        }
    }

    pub fn gtk_titlebar_middle_click(
        self,
        gtk_titlebar_middle_click: impl Into<glib::GString>,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "gtk-titlebar-middle-click",
                gtk_titlebar_middle_click.into(),
            ),
        }
    }

    pub fn gtk_titlebar_right_click(
        self,
        gtk_titlebar_right_click: impl Into<glib::GString>,
    ) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-titlebar-right-click", gtk_titlebar_right_click.into()),
        }
    }

    pub fn gtk_xft_antialias(self, gtk_xft_antialias: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-xft-antialias", gtk_xft_antialias),
        }
    }

    pub fn gtk_xft_dpi(self, gtk_xft_dpi: i32) -> Self {
        Self {
            builder: self.builder.property("gtk-xft-dpi", gtk_xft_dpi),
        }
    }

    pub fn gtk_xft_hinting(self, gtk_xft_hinting: i32) -> Self {
        Self {
            builder: self.builder.property("gtk-xft-hinting", gtk_xft_hinting),
        }
    }

    pub fn gtk_xft_hintstyle(self, gtk_xft_hintstyle: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("gtk-xft-hintstyle", gtk_xft_hintstyle.into()),
        }
    }

    pub fn gtk_xft_rgba(self, gtk_xft_rgba: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("gtk-xft-rgba", gtk_xft_rgba.into()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Settings`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Settings {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
