/* book.c generated by valac 0.30.1, the Vala compiler
 * generated from book.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-ps.h>
#include <zlib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
typedef struct _BookPrivate BookPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define __g_list_free__page_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__page_unref0_ (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_PS_WRITER (ps_writer_get_type ())
#define PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PS_WRITER, PsWriter))
#define PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PS_WRITER, PsWriterClass))
#define IS_PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PS_WRITER))
#define IS_PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PS_WRITER))
#define PS_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PS_WRITER, PsWriterClass))

typedef struct _PsWriter PsWriter;
typedef struct _PsWriterClass PsWriterClass;
typedef struct _PsWriterPrivate PsWriterPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _ps_writer_unref0(var) ((var == NULL) ? NULL : (var = (ps_writer_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PDF_WRITER (pdf_writer_get_type ())
#define PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PDF_WRITER, PDFWriter))
#define PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PDF_WRITER, PDFWriterClass))
#define IS_PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PDF_WRITER))
#define IS_PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PDF_WRITER))
#define PDF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PDF_WRITER, PDFWriterClass))

typedef struct _PDFWriter PDFWriter;
typedef struct _PDFWriterClass PDFWriterClass;
typedef struct _PDFWriterPrivate PDFWriterPrivate;
#define _pdf_writer_unref0(var) ((var == NULL) ? NULL : (var = (pdf_writer_unref (var), NULL)))
typedef struct _ParamSpecBook ParamSpecBook;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _ParamSpecPDFWriter ParamSpecPDFWriter;
typedef struct _ParamSpecPsWriter ParamSpecPsWriter;

struct _Book {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookPrivate * priv;
};

struct _BookClass {
	GTypeClass parent_class;
	void (*finalize) (Book *self);
};

struct _BookPrivate {
	GList* pages;
	gboolean needs_saving_;
	GByteArray* jpeg_data;
};

struct _PsWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PsWriterPrivate * priv;
	cairo_surface_t* surface;
	GFileOutputStream* stream;
};

struct _PsWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PsWriter *self);
};

struct _PDFWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PDFWriterPrivate * priv;
	gsize offset;
	GList* object_offsets;
};

struct _PDFWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PDFWriter *self);
};

struct _ParamSpecBook {
	GParamSpec parent_instance;
};

struct _PDFWriterPrivate {
	GFileOutputStream* stream;
};

struct _ParamSpecPDFWriter {
	GParamSpec parent_instance;
};

struct _ParamSpecPsWriter {
	GParamSpec parent_instance;
};


static gpointer book_parent_class = NULL;
static gpointer pdf_writer_parent_class = NULL;
static gpointer ps_writer_parent_class = NULL;

gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
#define BOOK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BOOK, BookPrivate))
enum  {
	BOOK_DUMMY_PROPERTY
};
static void book_page_changed_cb (Book* self, Page* page);
static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self);
static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self);
static void _page_unref0_ (gpointer var);
static void _g_list_free__page_unref0_ (GList* self);
Book* book_new (void);
Book* book_construct (GType object_type);
void book_clear (Book* self);
void book_set_needs_saving (Book* self, gboolean value);
void book_append_page (Book* self, Page* page);
void book_move_page (Book* self, Page* page, guint location);
void book_delete_page (Book* self, Page* page);
Page* book_get_page (Book* self, gint page_number);
guint book_get_page_index (Book* self, Page* page);
static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i);
guint book_get_n_pages (Book* self);
static void book_save_multi_file (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error);
static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi);
static void book_save_ps (Book* self, GFile* file, GError** error);
gpointer ps_writer_ref (gpointer instance);
void ps_writer_unref (gpointer instance);
GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_ps_writer (GValue* value, gpointer v_object);
void value_take_ps_writer (GValue* value, gpointer v_object);
gpointer value_get_ps_writer (const GValue* value);
GType ps_writer_get_type (void) G_GNUC_CONST;
PsWriter* ps_writer_new (GFileOutputStream* stream);
PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
gint page_get_dpi (Page* self);
static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1);
static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gint quality, gint dpi, int* result_length1);
static gboolean book_write_pixbuf_data (Book* self, guint8* buf, int buf_length1, GError** error);
static gboolean _book_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self);
static void book_save_pdf (Book* self, GFile* file, gint quality, GError** error);
gpointer pdf_writer_ref (gpointer instance);
void pdf_writer_unref (gpointer instance);
GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pdf_writer (GValue* value, gpointer v_object);
void value_take_pdf_writer (GValue* value, gpointer v_object);
gpointer value_get_pdf_writer (const GValue* value);
GType pdf_writer_get_type (void) G_GNUC_CONST;
PDFWriter* pdf_writer_new (GFileOutputStream* stream);
PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream);
void pdf_writer_write_string (PDFWriter* self, const gchar* text);
guint pdf_writer_start_object (PDFWriter* self);
gboolean page_get_is_color (Page* self);
gint page_get_depth (Page* self);
static guint8* _vala_array_dup1 (guint8* self, int length);
static guint8* _vala_array_dup2 (guint8* self, int length);
void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1);
void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
gboolean book_get_needs_saving (Book* self);
static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void book_finalize (Book* obj);
#define PDF_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PDF_WRITER, PDFWriterPrivate))
enum  {
	PDF_WRITER_DUMMY_PROPERTY
};
static void pdf_writer_finalize (PDFWriter* obj);
enum  {
	PS_WRITER_DUMMY_PROPERTY
};
static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1);
static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1);
static void ps_writer_finalize (PsWriter* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _page_ref0 (gpointer self) {
#line 45 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return self ? page_ref (self) : NULL;
#line 244 "book.c"
}


static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self) {
#line 47 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	book_page_changed_cb ((Book*) self, _sender);
#line 251 "book.c"
}


static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self) {
#line 48 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	book_page_changed_cb ((Book*) self, _sender);
#line 258 "book.c"
}


static void _page_unref0_ (gpointer var) {
#line 14 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	(var == NULL) ? NULL : (var = (page_unref (var), NULL));
#line 265 "book.c"
}


static void _g_list_free__page_unref0_ (GList* self) {
#line 14 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_list_foreach (self, (GFunc) _page_unref0_, NULL);
#line 14 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_list_free (self);
#line 274 "book.c"
}


Book* book_construct (GType object_type) {
	Book* self = NULL;
#line 38 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self = (Book*) g_type_create_instance (object_type);
#line 40 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 40 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->priv->pages = NULL;
#line 38 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return self;
#line 288 "book.c"
}


Book* book_new (void) {
#line 38 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return book_construct (TYPE_BOOK);
#line 295 "book.c"
}


void book_clear (Book* self) {
	GList* _tmp0_ = NULL;
#line 52 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 305 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 54 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		page_collection = _tmp0_;
#line 54 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 313 "book.c"
			Page* _tmp1_ = NULL;
			Page* page = NULL;
#line 54 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 54 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			page = _tmp1_;
#line 320 "book.c"
			{
				Page* _tmp2_ = NULL;
				guint _tmp3_ = 0U;
				Page* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
#line 56 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp2_ = page;
#line 56 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 56 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 57 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp4_ = page;
#line 57 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 57 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 54 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_page_unref0 (page);
#line 340 "book.c"
			}
		}
	}
#line 59 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 59 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->priv->pages = NULL;
#line 60 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_emit_by_name (self, "cleared");
#line 350 "book.c"
}


static void book_page_changed_cb (Book* self, Page* page) {
#line 63 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (self != NULL);
#line 63 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (page != NULL);
#line 65 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 361 "book.c"
}


void book_append_page (Book* self, Page* page) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
#line 68 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (page != NULL);
#line 70 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = page;
#line 70 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_connect (_tmp0_, "pixels-changed", (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 71 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp1_ = page;
#line 71 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_connect (_tmp1_, "crop-changed", (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 73 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp2_ = page;
#line 73 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 73 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->priv->pages = g_list_append (self->priv->pages, _tmp3_);
#line 74 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp4_ = page;
#line 74 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_emit_by_name (self, "page-added", _tmp4_);
#line 75 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 395 "book.c"
}


void book_move_page (Book* self, Page* page, guint location) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
#line 78 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (page != NULL);
#line 80 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = page;
#line 80 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->priv->pages = g_list_remove (self->priv->pages, _tmp0_);
#line 81 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp1_ = page;
#line 81 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp2_ = _page_ref0 (_tmp1_);
#line 81 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp3_ = location;
#line 81 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->priv->pages = g_list_insert (self->priv->pages, _tmp2_, (gint) _tmp3_);
#line 82 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_emit_by_name (self, "reordered");
#line 83 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 424 "book.c"
}


void book_delete_page (Book* self, Page* page) {
	Page* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 86 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (self != NULL);
#line 86 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (page != NULL);
#line 88 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = page;
#line 88 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 88 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 89 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp2_ = page;
#line 89 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 89 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 90 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp4_ = page;
#line 90 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_emit_by_name (self, "page-removed", _tmp4_);
#line 91 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp5_ = page;
#line 91 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->priv->pages = g_list_remove (self->priv->pages, _tmp5_);
#line 92 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 461 "book.c"
}


Page* book_get_page (Book* self, gint page_number) {
	Page* result = NULL;
	gint _tmp0_ = 0;
	GList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gconstpointer _tmp6_ = NULL;
	Page* _tmp7_ = NULL;
#line 95 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 97 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = page_number;
#line 97 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (_tmp0_ < 0) {
#line 478 "book.c"
		GList* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		gint _tmp3_ = 0;
#line 98 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp1_ = self->priv->pages;
#line 98 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp2_ = g_list_length (_tmp1_);
#line 98 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp3_ = page_number;
#line 98 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		page_number = ((gint) _tmp2_) + _tmp3_;
#line 490 "book.c"
	}
#line 99 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp4_ = self->priv->pages;
#line 99 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp5_ = page_number;
#line 99 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp6_ = g_list_nth_data (_tmp4_, (guint) _tmp5_);
#line 99 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp7_ = _page_ref0 ((Page*) _tmp6_);
#line 99 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	result = _tmp7_;
#line 99 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return result;
#line 504 "book.c"
}


guint book_get_page_index (Book* self, Page* page) {
	guint result = 0U;
	GList* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 102 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 102 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (page != NULL, 0U);
#line 104 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 104 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp1_ = page;
#line 104 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp2_ = g_list_index (_tmp0_, _tmp1_);
#line 104 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	result = (guint) _tmp2_;
#line 104 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return result;
#line 527 "book.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 930 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 931 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 931 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 931 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
#line 931 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 933 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 933 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 552 "book.c"
		gchar* _tmp4_ = NULL;
#line 934 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 934 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 934 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 560 "book.c"
	} else {
#line 936 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		result = -1;
#line 936 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 566 "book.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1230 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1231 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1231 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1231 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1232 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1232 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 600 "book.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1233 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1233 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1233 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 609 "book.c"
	}
#line 1235 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1235 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 615 "book.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1236 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1236 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1236 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 624 "book.c"
	}
#line 1238 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1238 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 630 "book.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1238 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1238 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1238 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 639 "book.c"
	} else {
#line 1238 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 643 "book.c"
	}
#line 1238 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1239 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1239 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 651 "book.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1239 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1239 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1239 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 660 "book.c"
	} else {
#line 1239 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 664 "book.c"
	}
#line 1239 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1240 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1240 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1240 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1241 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1241 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1241 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1241 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1241 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1241 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 686 "book.c"
}


static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i) {
	GFile* result = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	gchar* basename = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* prefix = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* suffix = NULL;
	gchar* _tmp8_ = NULL;
	gint extension_index = 0;
	const gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint width = 0;
	guint _tmp26_ = 0U;
	guint _tmp27_ = 0U;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gchar* number_format = NULL;
	gint _tmp33_ = 0;
	gchar* _tmp34_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	GFile* _tmp48_ = NULL;
#line 107 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 107 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 109 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = book_get_n_pages (self);
#line 109 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp1_ = _tmp0_;
#line 109 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (_tmp1_ == ((guint) 1)) {
#line 742 "book.c"
		const gchar* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
#line 110 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp2_ = uri;
#line 110 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp3_ = g_file_new_for_uri (_tmp2_);
#line 110 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		result = _tmp3_;
#line 110 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		return result;
#line 753 "book.c"
	}
#line 113 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp4_ = uri;
#line 113 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp5_ = g_path_get_basename (_tmp4_);
#line 113 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	basename = _tmp5_;
#line 114 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp6_ = uri;
#line 114 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 114 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	prefix = _tmp7_;
#line 114 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp8_ = g_strdup ("");
#line 114 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	suffix = _tmp8_;
#line 115 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp9_ = basename;
#line 115 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp10_ = string_last_index_of_char (_tmp9_, (gunichar) '.', 0);
#line 115 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	extension_index = _tmp10_;
#line 116 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp11_ = extension_index;
#line 116 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (_tmp11_ >= 0) {
#line 781 "book.c"
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		const gchar* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		const gchar* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		gchar* _tmp25_ = NULL;
#line 118 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp12_ = basename;
#line 118 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp13_ = extension_index;
#line 118 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp14_ = basename;
#line 118 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp15_ = strlen (_tmp14_);
#line 118 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp16_ = _tmp15_;
#line 118 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp17_ = string_slice (_tmp12_, (glong) _tmp13_, (glong) _tmp16_);
#line 118 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_g_free0 (suffix);
#line 118 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		suffix = _tmp17_;
#line 119 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp18_ = uri;
#line 119 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp19_ = uri;
#line 119 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp20_ = strlen (_tmp19_);
#line 119 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp21_ = _tmp20_;
#line 119 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp22_ = suffix;
#line 119 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp23_ = strlen (_tmp22_);
#line 119 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp24_ = _tmp23_;
#line 119 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp25_ = string_slice (_tmp18_, (glong) 0, (glong) (_tmp21_ - _tmp24_));
#line 119 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_g_free0 (prefix);
#line 119 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		prefix = _tmp25_;
#line 832 "book.c"
	}
#line 121 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp26_ = book_get_n_pages (self);
#line 121 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp27_ = _tmp26_;
#line 121 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp28_ = g_strdup_printf ("%u", _tmp27_);
#line 121 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp29_ = _tmp28_;
#line 121 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp30_ = strlen (_tmp29_);
#line 121 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp31_ = _tmp30_;
#line 121 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp32_ = _tmp31_;
#line 121 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (_tmp29_);
#line 121 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	width = _tmp32_;
#line 122 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp33_ = width;
#line 122 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp34_ = g_strdup_printf ("%%0%dd", _tmp33_);
#line 122 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	number_format = _tmp34_;
#line 123 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp35_ = prefix;
#line 123 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp36_ = g_strconcat (_tmp35_, "-", NULL);
#line 123 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp37_ = _tmp36_;
#line 123 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp38_ = number_format;
#line 123 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp39_ = i;
#line 123 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp40_ = g_strdup_printf (_tmp38_, _tmp39_ + 1);
#line 123 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp41_ = _tmp40_;
#line 123 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp42_ = g_strconcat (_tmp37_, _tmp41_, NULL);
#line 123 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp43_ = _tmp42_;
#line 123 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp44_ = suffix;
#line 123 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp45_ = g_strconcat (_tmp43_, _tmp44_, NULL);
#line 123 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp46_ = _tmp45_;
#line 123 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (_tmp43_);
#line 123 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (_tmp41_);
#line 123 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (_tmp37_);
#line 123 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	filename = _tmp46_;
#line 124 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp47_ = filename;
#line 124 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp48_ = g_file_new_for_uri (_tmp47_);
#line 124 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	result = _tmp48_;
#line 124 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (filename);
#line 124 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (number_format);
#line 124 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (suffix);
#line 124 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (prefix);
#line 124 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (basename);
#line 124 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return result;
#line 908 "book.c"
}


static void book_save_multi_file (Book* self, const gchar* type, gint quality, GFile* file, GError** error) {
	GError * _inner_error_ = NULL;
#line 127 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (self != NULL);
#line 127 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (type != NULL);
#line 127 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (file != NULL);
#line 920 "book.c"
	{
		gint i = 0;
#line 129 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		i = 0;
#line 925 "book.c"
		{
			gboolean _tmp0_ = FALSE;
#line 129 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			_tmp0_ = TRUE;
#line 129 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			while (TRUE) {
#line 932 "book.c"
				gint _tmp2_ = 0;
				guint _tmp3_ = 0U;
				guint _tmp4_ = 0U;
				Page* page = NULL;
				gint _tmp5_ = 0;
				Page* _tmp6_ = NULL;
				Page* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				GFile* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				GFile* _tmp14_ = NULL;
				GFile* _tmp15_ = NULL;
				gint _tmp16_ = 0;
#line 129 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				if (!_tmp0_) {
#line 951 "book.c"
					gint _tmp1_ = 0;
#line 129 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp1_ = i;
#line 129 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					i = _tmp1_ + 1;
#line 957 "book.c"
				}
#line 129 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp0_ = FALSE;
#line 129 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp2_ = i;
#line 129 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp3_ = book_get_n_pages (self);
#line 129 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp4_ = _tmp3_;
#line 129 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				if (!(((guint) _tmp2_) < _tmp4_)) {
#line 129 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					break;
#line 971 "book.c"
				}
#line 131 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp5_ = i;
#line 131 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp6_ = book_get_page (self, _tmp5_);
#line 131 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				page = _tmp6_;
#line 132 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp7_ = page;
#line 132 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp8_ = type;
#line 132 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp9_ = quality;
#line 132 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp10_ = file;
#line 132 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp11_ = g_file_get_uri (_tmp10_);
#line 132 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp12_ = _tmp11_;
#line 132 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp13_ = i;
#line 132 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp14_ = book_make_indexed_file (self, _tmp12_, _tmp13_);
#line 132 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp15_ = _tmp14_;
#line 132 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				page_save (_tmp7_, _tmp8_, _tmp9_, _tmp15_, &_inner_error_);
#line 132 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_object_unref0 (_tmp15_);
#line 132 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (_tmp12_);
#line 132 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 132 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 132 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_page_unref0 (page);
#line 132 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					return;
#line 1011 "book.c"
				}
#line 133 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp16_ = i;
#line 133 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp16_);
#line 129 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_page_unref0 (page);
#line 1019 "book.c"
			}
		}
	}
}


static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi) {
	cairo_t* context = NULL;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GdkPixbuf* _tmp4_ = NULL;
	cairo_pattern_t* _tmp5_ = NULL;
#line 137 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (self != NULL);
#line 137 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (surface != NULL);
#line 137 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (image != NULL);
#line 139 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = surface;
#line 139 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp1_ = cairo_create (_tmp0_);
#line 139 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	context = _tmp1_;
#line 140 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp2_ = dpi;
#line 140 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp3_ = dpi;
#line 140 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	cairo_scale (context, 72.0 / _tmp2_, 72.0 / _tmp3_);
#line 141 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp4_ = image;
#line 141 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	gdk_cairo_set_source_pixbuf (context, _tmp4_, (gdouble) 0, (gdouble) 0);
#line 142 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp5_ = cairo_get_source (context);
#line 142 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	cairo_pattern_set_filter (_tmp5_, CAIRO_FILTER_BEST);
#line 143 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	cairo_paint (context);
#line 137 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_cairo_destroy0 (context);
#line 1064 "book.c"
}


static gpointer _cairo_surface_reference0 (gpointer self) {
#line 150 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return self ? cairo_surface_reference (self) : NULL;
#line 1071 "book.c"
}


static void book_save_ps (Book* self, GFile* file, GError** error) {
	GFileOutputStream* stream = NULL;
	GFile* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
	PsWriter* writer = NULL;
	PsWriter* _tmp2_ = NULL;
	cairo_surface_t* surface = NULL;
	PsWriter* _tmp3_ = NULL;
	cairo_surface_t* _tmp4_ = NULL;
	cairo_surface_t* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 146 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (self != NULL);
#line 146 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (file != NULL);
#line 148 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = file;
#line 148 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 148 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	stream = _tmp1_;
#line 148 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 148 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_propagate_error (error, _inner_error_);
#line 148 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		return;
#line 1102 "book.c"
	}
#line 149 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp2_ = ps_writer_new (stream);
#line 149 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	writer = _tmp2_;
#line 150 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp3_ = writer;
#line 150 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp4_ = _tmp3_->surface;
#line 150 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp5_ = _cairo_surface_reference0 (_tmp4_);
#line 150 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	surface = _tmp5_;
#line 1116 "book.c"
	{
		gint i = 0;
#line 152 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		i = 0;
#line 1121 "book.c"
		{
			gboolean _tmp6_ = FALSE;
#line 152 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			_tmp6_ = TRUE;
#line 152 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			while (TRUE) {
#line 1128 "book.c"
				gint _tmp8_ = 0;
				guint _tmp9_ = 0U;
				guint _tmp10_ = 0U;
				Page* page = NULL;
				gint _tmp11_ = 0;
				Page* _tmp12_ = NULL;
				GdkPixbuf* image = NULL;
				Page* _tmp13_ = NULL;
				GdkPixbuf* _tmp14_ = NULL;
				gdouble width = 0.0;
				GdkPixbuf* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				Page* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gdouble height = 0.0;
				GdkPixbuf* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				Page* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				cairo_surface_t* _tmp25_ = NULL;
				gdouble _tmp26_ = 0.0;
				gdouble _tmp27_ = 0.0;
				cairo_surface_t* _tmp28_ = NULL;
				GdkPixbuf* _tmp29_ = NULL;
				Page* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				cairo_surface_t* _tmp33_ = NULL;
				gint _tmp34_ = 0;
#line 152 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				if (!_tmp6_) {
#line 1162 "book.c"
					gint _tmp7_ = 0;
#line 152 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp7_ = i;
#line 152 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					i = _tmp7_ + 1;
#line 1168 "book.c"
				}
#line 152 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp6_ = FALSE;
#line 152 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp8_ = i;
#line 152 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp9_ = book_get_n_pages (self);
#line 152 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp10_ = _tmp9_;
#line 152 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				if (!(((guint) _tmp8_) < _tmp10_)) {
#line 152 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					break;
#line 1182 "book.c"
				}
#line 154 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp11_ = i;
#line 154 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp12_ = book_get_page (self, _tmp11_);
#line 154 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				page = _tmp12_;
#line 155 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp13_ = page;
#line 155 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp14_ = page_get_image (_tmp13_, TRUE);
#line 155 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				image = _tmp14_;
#line 156 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp15_ = image;
#line 156 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp16_ = gdk_pixbuf_get_width (_tmp15_);
#line 156 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp17_ = page;
#line 156 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp18_ = page_get_dpi (_tmp17_);
#line 156 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp19_ = _tmp18_;
#line 156 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				width = (_tmp16_ * 72.0) / _tmp19_;
#line 157 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp20_ = image;
#line 157 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp21_ = gdk_pixbuf_get_height (_tmp20_);
#line 157 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp22_ = page;
#line 157 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp23_ = page_get_dpi (_tmp22_);
#line 157 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp24_ = _tmp23_;
#line 157 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				height = (_tmp21_ * 72.0) / _tmp24_;
#line 158 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp25_ = surface;
#line 158 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp26_ = width;
#line 158 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp27_ = height;
#line 158 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				cairo_ps_surface_set_size (_tmp25_, _tmp26_, _tmp27_);
#line 159 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp28_ = surface;
#line 159 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp29_ = image;
#line 159 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp30_ = page;
#line 159 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp31_ = page_get_dpi (_tmp30_);
#line 159 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp32_ = _tmp31_;
#line 159 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				book_save_ps_pdf_surface (self, _tmp28_, _tmp29_, (gdouble) _tmp32_);
#line 160 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp33_ = surface;
#line 160 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				cairo_surface_show_page (_tmp33_);
#line 161 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp34_ = i;
#line 161 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp34_);
#line 152 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_object_unref0 (image);
#line 152 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_page_unref0 (page);
#line 1252 "book.c"
			}
		}
	}
#line 146 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_cairo_surface_destroy0 (surface);
#line 146 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_ps_writer_unref0 (writer);
#line 146 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_object_unref0 (stream);
#line 1262 "book.c"
}


static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1) {
	guint8* result = NULL;
	z_stream stream = {0};
	guint8* out_data = NULL;
	guint8* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	guint8* _tmp1_ = NULL;
	gint out_data_length1 = 0;
	gint _out_data_size_ = 0;
	guint8* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	z_stream _tmp7_ = {0};
	guint _tmp8_ = 0U;
	guint n_written = 0U;
	guint8* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	z_stream _tmp11_ = {0};
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	gint _tmp14_ = 0;
	guint8* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
#line 165 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 167 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	deflateInit (&stream, (gint) Z_BEST_COMPRESSION);
#line 168 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = data;
#line 168 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0__length1 = data_length1;
#line 168 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp1_ = g_new0 (guint8, _tmp0__length1);
#line 168 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	out_data = _tmp1_;
#line 168 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	out_data_length1 = _tmp0__length1;
#line 168 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_out_data_size_ = out_data_length1;
#line 170 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp2_ = data;
#line 170 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp2__length1 = data_length1;
#line 170 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	stream.next_in = _tmp2_;
#line 170 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	stream.avail_in = _tmp2__length1;
#line 171 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp3_ = out_data;
#line 171 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp3__length1 = out_data_length1;
#line 171 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	stream.next_out = _tmp3_;
#line 171 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	stream.avail_out = _tmp3__length1;
#line 172 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	while (TRUE) {
#line 1324 "book.c"
		z_stream _tmp4_ = {0};
		guint _tmp5_ = 0U;
		gint _tmp6_ = 0;
#line 172 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp4_ = stream;
#line 172 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp5_ = _tmp4_.avail_in;
#line 172 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		if (!(_tmp5_ > ((guint) 0))) {
#line 172 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			break;
#line 1336 "book.c"
		}
#line 174 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp6_ = deflate (&stream, (gint) Z_FINISH);
#line 174 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		if (_tmp6_ == ((gint) Z_STREAM_ERROR)) {
#line 175 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			break;
#line 1344 "book.c"
		}
	}
#line 178 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp7_ = stream;
#line 178 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp8_ = _tmp7_.avail_in;
#line 178 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (_tmp8_ > ((guint) 0)) {
#line 1353 "book.c"
		guint8* _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
#line 179 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp9_ = NULL;
#line 179 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp9__length1 = 0;
#line 179 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		if (result_length1) {
#line 179 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			*result_length1 = _tmp9__length1;
#line 1364 "book.c"
		}
#line 179 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		result = _tmp9_;
#line 179 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		out_data = (g_free (out_data), NULL);
#line 179 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		deflateEnd (&stream);
#line 179 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		return result;
#line 1374 "book.c"
	}
#line 181 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp10_ = data;
#line 181 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp10__length1 = data_length1;
#line 181 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp11_ = stream;
#line 181 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp12_ = _tmp11_.avail_out;
#line 181 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	n_written = _tmp10__length1 - _tmp12_;
#line 182 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp13_ = n_written;
#line 182 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp14_ = (gint) _tmp13_;
#line 182 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	out_data = g_renew (guint8, out_data, (gint) _tmp13_);
#line 182 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	(_tmp14_ > out_data_length1) ? memset (out_data + out_data_length1, 0, sizeof (guint8) * (_tmp14_ - out_data_length1)) : NULL;
#line 182 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	out_data_length1 = _tmp14_;
#line 182 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_out_data_size_ = _tmp14_;
#line 184 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp15_ = out_data;
#line 184 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp15__length1 = out_data_length1;
#line 184 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (result_length1) {
#line 184 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		*result_length1 = _tmp15__length1;
#line 1406 "book.c"
	}
#line 184 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	result = _tmp15_;
#line 184 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	deflateEnd (&stream);
#line 184 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return result;
#line 1414 "book.c"
}


static gboolean _book_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self) {
	gboolean result;
	result = book_write_pixbuf_data ((Book*) self, buf, buf_length1, error);
#line 196 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return result;
#line 1423 "book.c"
}


static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gint quality, gint dpi, int* result_length1) {
	guint8* result = NULL;
	GByteArray* _tmp0_ = NULL;
	gchar** keys = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint keys_length1 = 0;
	gint _keys_size_ = 0;
	gchar** values = NULL;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	guint8* data = NULL;
	GByteArray* _tmp15_ = NULL;
	guint8* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	guint8* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	GError * _inner_error_ = NULL;
#line 189 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 189 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (image != NULL, NULL);
#line 191 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = g_byte_array_new ();
#line 191 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 191 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->priv->jpeg_data = _tmp0_;
#line 192 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp1_ = g_strdup ("quality");
#line 192 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp2_ = g_strdup ("density-unit");
#line 192 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp3_ = g_strdup ("x-density");
#line 192 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp4_ = g_strdup ("y-density");
#line 192 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp5_ = g_new0 (gchar*, 5 + 1);
#line 192 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp5_[0] = _tmp1_;
#line 192 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp5_[1] = _tmp2_;
#line 192 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp5_[2] = _tmp3_;
#line 192 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp5_[3] = _tmp4_;
#line 192 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp5_[4] = NULL;
#line 192 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	keys = _tmp5_;
#line 192 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	keys_length1 = 5;
#line 192 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_keys_size_ = keys_length1;
#line 193 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp6_ = quality;
#line 193 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp7_ = g_strdup_printf ("%d", _tmp6_);
#line 193 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp8_ = g_strdup ("dots-per-inch");
#line 193 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp9_ = dpi;
#line 193 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp10_ = g_strdup_printf ("%d", _tmp9_);
#line 193 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp11_ = dpi;
#line 193 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp12_ = g_strdup_printf ("%d", _tmp11_);
#line 193 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp13_ = g_new0 (gchar*, 5 + 1);
#line 193 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp13_[0] = _tmp7_;
#line 193 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp13_[1] = _tmp8_;
#line 193 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp13_[2] = _tmp10_;
#line 193 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp13_[3] = _tmp12_;
#line 193 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp13_[4] = NULL;
#line 193 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	values = _tmp13_;
#line 193 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	values_length1 = 5;
#line 193 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_values_size_ = values_length1;
#line 1526 "book.c"
	{
		GdkPixbuf* _tmp14_ = NULL;
#line 196 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp14_ = image;
#line 196 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		gdk_pixbuf_save_to_callbackv (_tmp14_, _book_write_pixbuf_data_gdk_pixbuf_save_func, self, "jpeg", keys, values, &_inner_error_);
#line 196 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1535 "book.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
#line 194 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		e = _inner_error_;
#line 194 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_inner_error_ = NULL;
#line 194 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_g_error_free0 (e);
#line 1549 "book.c"
	}
	__finally0:
#line 194 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 194 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 194 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 194 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 194 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_clear_error (&_inner_error_);
#line 194 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		return NULL;
#line 1564 "book.c"
	}
#line 201 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp15_ = self->priv->jpeg_data;
#line 201 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp16_ = _tmp15_->data;
#line 201 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp16__length1 = _tmp15_->len;
#line 201 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp15_->data = NULL;
#line 201 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp15_->len = 0;
#line 201 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	data = _tmp16_;
#line 201 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	data_length1 = _tmp16__length1;
#line 201 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_data_size_ = data_length1;
#line 202 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 202 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->priv->jpeg_data = NULL;
#line 204 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp17_ = data;
#line 204 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp17__length1 = data_length1;
#line 204 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (result_length1) {
#line 204 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		*result_length1 = _tmp17__length1;
#line 1594 "book.c"
	}
#line 204 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	result = _tmp17_;
#line 204 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 204 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 204 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return result;
#line 1604 "book.c"
}


static gboolean book_write_pixbuf_data (Book* self, guint8* buf, int buf_length1, GError** error) {
	gboolean result = FALSE;
	GByteArray* _tmp0_ = NULL;
	guint8* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 207 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 209 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = self->priv->jpeg_data;
#line 209 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp1_ = buf;
#line 209 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp1__length1 = buf_length1;
#line 209 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_byte_array_append (_tmp0_, _tmp1_, _tmp1__length1);
#line 210 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	result = TRUE;
#line 210 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return result;
#line 1627 "book.c"
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
#line 415 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1634 "book.c"
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
#line 422 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1641 "book.c"
}


static void book_save_pdf (Book* self, GFile* file, gint quality, GError** error) {
	gchar* id = NULL;
	gchar* _tmp0_ = NULL;
	GFileOutputStream* stream = NULL;
	GFile* _tmp9_ = NULL;
	GFileOutputStream* _tmp10_ = NULL;
	PDFWriter* writer = NULL;
	PDFWriter* _tmp11_ = NULL;
	PDFWriter* _tmp12_ = NULL;
	PDFWriter* _tmp13_ = NULL;
	guint catalog_number = 0U;
	PDFWriter* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	PDFWriter* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	PDFWriter* _tmp20_ = NULL;
	PDFWriter* _tmp21_ = NULL;
	PDFWriter* _tmp22_ = NULL;
	guint _tmp23_ = 0U;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	PDFWriter* _tmp26_ = NULL;
	PDFWriter* _tmp27_ = NULL;
	PDFWriter* _tmp28_ = NULL;
	guint pages_number = 0U;
	PDFWriter* _tmp29_ = NULL;
	guint _tmp30_ = 0U;
	PDFWriter* _tmp31_ = NULL;
	guint _tmp32_ = 0U;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	PDFWriter* _tmp35_ = NULL;
	PDFWriter* _tmp36_ = NULL;
	PDFWriter* _tmp37_ = NULL;
	PDFWriter* _tmp48_ = NULL;
	PDFWriter* _tmp49_ = NULL;
	guint _tmp50_ = 0U;
	guint _tmp51_ = 0U;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	PDFWriter* _tmp54_ = NULL;
	PDFWriter* _tmp55_ = NULL;
	PDFWriter* _tmp360_ = NULL;
	guint info_number = 0U;
	PDFWriter* _tmp361_ = NULL;
	guint _tmp362_ = 0U;
	PDFWriter* _tmp363_ = NULL;
	guint _tmp364_ = 0U;
	gchar* _tmp365_ = NULL;
	gchar* _tmp366_ = NULL;
	PDFWriter* _tmp367_ = NULL;
	PDFWriter* _tmp368_ = NULL;
	gchar* _tmp369_ = NULL;
	gchar* _tmp370_ = NULL;
	PDFWriter* _tmp371_ = NULL;
	PDFWriter* _tmp372_ = NULL;
	PDFWriter* _tmp373_ = NULL;
	gsize xref_offset = 0UL;
	PDFWriter* _tmp374_ = NULL;
	gsize _tmp375_ = 0UL;
	PDFWriter* _tmp376_ = NULL;
	PDFWriter* _tmp377_ = NULL;
	PDFWriter* _tmp378_ = NULL;
	GList* _tmp379_ = NULL;
	guint _tmp380_ = 0U;
	gchar* _tmp381_ = NULL;
	gchar* _tmp382_ = NULL;
	PDFWriter* _tmp383_ = NULL;
	PDFWriter* _tmp384_ = NULL;
	GList* _tmp385_ = NULL;
	PDFWriter* _tmp390_ = NULL;
	PDFWriter* _tmp391_ = NULL;
	PDFWriter* _tmp392_ = NULL;
	PDFWriter* _tmp393_ = NULL;
	PDFWriter* _tmp394_ = NULL;
	GList* _tmp395_ = NULL;
	guint _tmp396_ = 0U;
	gchar* _tmp397_ = NULL;
	gchar* _tmp398_ = NULL;
	PDFWriter* _tmp399_ = NULL;
	guint _tmp400_ = 0U;
	gchar* _tmp401_ = NULL;
	gchar* _tmp402_ = NULL;
	PDFWriter* _tmp403_ = NULL;
	guint _tmp404_ = 0U;
	gchar* _tmp405_ = NULL;
	gchar* _tmp406_ = NULL;
	PDFWriter* _tmp407_ = NULL;
	const gchar* _tmp408_ = NULL;
	const gchar* _tmp409_ = NULL;
	gchar* _tmp410_ = NULL;
	gchar* _tmp411_ = NULL;
	PDFWriter* _tmp412_ = NULL;
	PDFWriter* _tmp413_ = NULL;
	PDFWriter* _tmp414_ = NULL;
	gsize _tmp415_ = 0UL;
	gchar* _tmp416_ = NULL;
	gchar* _tmp417_ = NULL;
	PDFWriter* _tmp418_ = NULL;
	GError * _inner_error_ = NULL;
#line 213 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (self != NULL);
#line 213 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (file != NULL);
#line 216 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = g_strdup ("");
#line 216 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	id = _tmp0_;
#line 1755 "book.c"
	{
		gint i = 0;
#line 217 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		i = 0;
#line 1760 "book.c"
		{
			gboolean _tmp1_ = FALSE;
#line 217 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			_tmp1_ = TRUE;
#line 217 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			while (TRUE) {
#line 1767 "book.c"
				gint _tmp3_ = 0;
				const gchar* _tmp4_ = NULL;
				guint32 _tmp5_ = 0U;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
#line 217 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				if (!_tmp1_) {
#line 1776 "book.c"
					gint _tmp2_ = 0;
#line 217 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp2_ = i;
#line 217 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					i = _tmp2_ + 1;
#line 1782 "book.c"
				}
#line 217 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp1_ = FALSE;
#line 217 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp3_ = i;
#line 217 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				if (!(_tmp3_ < 4)) {
#line 217 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					break;
#line 1792 "book.c"
				}
#line 218 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp4_ = id;
#line 218 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp5_ = g_random_int ();
#line 218 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp6_ = g_strdup_printf ("%08x", (guint) _tmp5_);
#line 218 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp7_ = _tmp6_;
#line 218 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp8_ = g_strconcat (_tmp4_, _tmp7_, NULL);
#line 218 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (id);
#line 218 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				id = _tmp8_;
#line 218 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (_tmp7_);
#line 1810 "book.c"
			}
		}
	}
#line 220 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp9_ = file;
#line 220 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp10_ = g_file_replace (_tmp9_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 220 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	stream = _tmp10_;
#line 220 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 220 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_propagate_error (error, _inner_error_);
#line 220 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_g_free0 (id);
#line 220 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		return;
#line 1828 "book.c"
	}
#line 221 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp11_ = pdf_writer_new (stream);
#line 221 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	writer = _tmp11_;
#line 224 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp12_ = writer;
#line 224 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp12_, "%PDF-1.3\n");
#line 227 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp13_ = writer;
#line 227 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp13_, "%\xe2\xe3\xcf\xd3\n");
#line 230 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp14_ = writer;
#line 230 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp15_ = pdf_writer_start_object (_tmp14_);
#line 230 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	catalog_number = _tmp15_;
#line 231 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp16_ = writer;
#line 231 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp17_ = catalog_number;
#line 231 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp18_ = g_strdup_printf ("%u 0 obj\n", _tmp17_);
#line 231 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp19_ = _tmp18_;
#line 231 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp16_, _tmp19_);
#line 231 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (_tmp19_);
#line 232 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp20_ = writer;
#line 232 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp20_, "<<\n");
#line 233 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp21_ = writer;
#line 233 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp21_, "/Type /Catalog\n");
#line 236 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp22_ = writer;
#line 236 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp23_ = catalog_number;
#line 236 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp24_ = g_strdup_printf ("/Pages %u 0 R\n", _tmp23_ + 1);
#line 236 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp25_ = _tmp24_;
#line 236 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp22_, _tmp25_);
#line 236 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (_tmp25_);
#line 237 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp26_ = writer;
#line 237 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp26_, ">>\n");
#line 238 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp27_ = writer;
#line 238 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp27_, "endobj\n");
#line 256 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp28_ = writer;
#line 256 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp28_, "\n");
#line 257 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp29_ = writer;
#line 257 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp30_ = pdf_writer_start_object (_tmp29_);
#line 257 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pages_number = _tmp30_;
#line 258 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp31_ = writer;
#line 258 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp32_ = pages_number;
#line 258 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp33_ = g_strdup_printf ("%u 0 obj\n", _tmp32_);
#line 258 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp34_ = _tmp33_;
#line 258 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp31_, _tmp34_);
#line 258 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (_tmp34_);
#line 259 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp35_ = writer;
#line 259 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp35_, "<<\n");
#line 260 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp36_ = writer;
#line 260 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp36_, "/Type /Pages\n");
#line 261 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp37_ = writer;
#line 261 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp37_, "/Kids [");
#line 1922 "book.c"
	{
		gint i = 0;
#line 262 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		i = 0;
#line 1927 "book.c"
		{
			gboolean _tmp38_ = FALSE;
#line 262 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			_tmp38_ = TRUE;
#line 262 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			while (TRUE) {
#line 1934 "book.c"
				gint _tmp40_ = 0;
				guint _tmp41_ = 0U;
				guint _tmp42_ = 0U;
				PDFWriter* _tmp43_ = NULL;
				guint _tmp44_ = 0U;
				gint _tmp45_ = 0;
				gchar* _tmp46_ = NULL;
				gchar* _tmp47_ = NULL;
#line 262 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				if (!_tmp38_) {
#line 1945 "book.c"
					gint _tmp39_ = 0;
#line 262 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp39_ = i;
#line 262 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					i = _tmp39_ + 1;
#line 1951 "book.c"
				}
#line 262 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp38_ = FALSE;
#line 262 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp40_ = i;
#line 262 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp41_ = book_get_n_pages (self);
#line 262 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp42_ = _tmp41_;
#line 262 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				if (!(((guint) _tmp40_) < _tmp42_)) {
#line 262 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					break;
#line 1965 "book.c"
				}
#line 263 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp43_ = writer;
#line 263 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp44_ = pages_number;
#line 263 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp45_ = i;
#line 263 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp46_ = g_strdup_printf (" %u 0 R", (_tmp44_ + 1) + (_tmp45_ * 3));
#line 263 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp47_ = _tmp46_;
#line 263 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp43_, _tmp47_);
#line 263 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (_tmp47_);
#line 1981 "book.c"
			}
		}
	}
#line 264 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp48_ = writer;
#line 264 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp48_, " ]\n");
#line 265 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp49_ = writer;
#line 265 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp50_ = book_get_n_pages (self);
#line 265 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp51_ = _tmp50_;
#line 265 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp52_ = g_strdup_printf ("/Count %u\n", _tmp51_);
#line 265 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp53_ = _tmp52_;
#line 265 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp49_, _tmp53_);
#line 265 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (_tmp53_);
#line 266 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp54_ = writer;
#line 266 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp54_, ">>\n");
#line 267 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp55_ = writer;
#line 267 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp55_, "endobj\n");
#line 2011 "book.c"
	{
		gint i = 0;
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		i = 0;
#line 2016 "book.c"
		{
			gboolean _tmp56_ = FALSE;
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			_tmp56_ = TRUE;
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			while (TRUE) {
#line 2023 "book.c"
				gint _tmp58_ = 0;
				guint _tmp59_ = 0U;
				guint _tmp60_ = 0U;
				Page* page = NULL;
				gint _tmp61_ = 0;
				Page* _tmp62_ = NULL;
				GdkPixbuf* image = NULL;
				Page* _tmp63_ = NULL;
				GdkPixbuf* _tmp64_ = NULL;
				gint width = 0;
				GdkPixbuf* _tmp65_ = NULL;
				gint _tmp66_ = 0;
				gint height = 0;
				GdkPixbuf* _tmp67_ = NULL;
				gint _tmp68_ = 0;
				guint8* pixels = NULL;
				GdkPixbuf* _tmp69_ = NULL;
				guint8* _tmp70_ = NULL;
				gint pixels_length1 = 0;
				gint _pixels_size_ = 0;
				gdouble page_width = 0.0;
				gint _tmp71_ = 0;
				Page* _tmp72_ = NULL;
				gint _tmp73_ = 0;
				gint _tmp74_ = 0;
				gdouble page_height = 0.0;
				gint _tmp75_ = 0;
				Page* _tmp76_ = NULL;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				gint depth = 0;
				gchar* color_space = NULL;
				gchar* _tmp79_ = NULL;
				gchar* filter = NULL;
				gchar* width_buffer = NULL;
				gchar* _tmp80_ = NULL;
				gint width_buffer_length1 = 0;
				gint _width_buffer_size_ = 0;
				gchar* height_buffer = NULL;
				gchar* _tmp81_ = NULL;
				gint height_buffer_length1 = 0;
				gint _height_buffer_size_ = 0;
				guint8* data = NULL;
				gint data_length1 = 0;
				gint _data_size_ = 0;
				Page* _tmp82_ = NULL;
				gboolean _tmp83_ = FALSE;
				gboolean _tmp84_ = FALSE;
				guint8* compressed_data = NULL;
				guint8* _tmp234_ = NULL;
				gint _tmp234__length1 = 0;
				gint _tmp235_ = 0;
				guint8* _tmp236_ = NULL;
				gint compressed_data_length1 = 0;
				gint _compressed_data_size_ = 0;
				guint8* _tmp237_ = NULL;
				gint _tmp237__length1 = 0;
				PDFWriter* _tmp255_ = NULL;
				guint number = 0U;
				PDFWriter* _tmp256_ = NULL;
				guint _tmp257_ = 0U;
				PDFWriter* _tmp258_ = NULL;
				guint _tmp259_ = 0U;
				gchar* _tmp260_ = NULL;
				gchar* _tmp261_ = NULL;
				PDFWriter* _tmp262_ = NULL;
				PDFWriter* _tmp263_ = NULL;
				PDFWriter* _tmp264_ = NULL;
				guint _tmp265_ = 0U;
				gchar* _tmp266_ = NULL;
				gchar* _tmp267_ = NULL;
				PDFWriter* _tmp268_ = NULL;
				gint _tmp269_ = 0;
				guint _tmp270_ = 0U;
				gchar* _tmp271_ = NULL;
				gchar* _tmp272_ = NULL;
				PDFWriter* _tmp273_ = NULL;
				gdouble _tmp274_ = 0.0;
				gchar* _tmp275_ = NULL;
				gint _tmp275__length1 = 0;
				const gchar* _tmp276_ = NULL;
				gdouble _tmp277_ = 0.0;
				gchar* _tmp278_ = NULL;
				gint _tmp278__length1 = 0;
				const gchar* _tmp279_ = NULL;
				gchar* _tmp280_ = NULL;
				gchar* _tmp281_ = NULL;
				PDFWriter* _tmp282_ = NULL;
				guint _tmp283_ = 0U;
				gchar* _tmp284_ = NULL;
				gchar* _tmp285_ = NULL;
				PDFWriter* _tmp286_ = NULL;
				PDFWriter* _tmp287_ = NULL;
				PDFWriter* _tmp288_ = NULL;
				PDFWriter* _tmp289_ = NULL;
				guint _tmp290_ = 0U;
				PDFWriter* _tmp291_ = NULL;
				guint _tmp292_ = 0U;
				gchar* _tmp293_ = NULL;
				gchar* _tmp294_ = NULL;
				PDFWriter* _tmp295_ = NULL;
				PDFWriter* _tmp296_ = NULL;
				PDFWriter* _tmp297_ = NULL;
				PDFWriter* _tmp298_ = NULL;
				gint _tmp299_ = 0;
				gchar* _tmp300_ = NULL;
				gchar* _tmp301_ = NULL;
				PDFWriter* _tmp302_ = NULL;
				gint _tmp303_ = 0;
				gchar* _tmp304_ = NULL;
				gchar* _tmp305_ = NULL;
				PDFWriter* _tmp306_ = NULL;
				const gchar* _tmp307_ = NULL;
				gchar* _tmp308_ = NULL;
				gchar* _tmp309_ = NULL;
				PDFWriter* _tmp310_ = NULL;
				gint _tmp311_ = 0;
				gchar* _tmp312_ = NULL;
				gchar* _tmp313_ = NULL;
				PDFWriter* _tmp314_ = NULL;
				guint8* _tmp315_ = NULL;
				gint _tmp315__length1 = 0;
				gchar* _tmp316_ = NULL;
				gchar* _tmp317_ = NULL;
				const gchar* _tmp318_ = NULL;
				PDFWriter* _tmp323_ = NULL;
				PDFWriter* _tmp324_ = NULL;
				PDFWriter* _tmp325_ = NULL;
				guint8* _tmp326_ = NULL;
				gint _tmp326__length1 = 0;
				PDFWriter* _tmp327_ = NULL;
				PDFWriter* _tmp328_ = NULL;
				PDFWriter* _tmp329_ = NULL;
				gchar* command = NULL;
				gdouble _tmp330_ = 0.0;
				gchar* _tmp331_ = NULL;
				gint _tmp331__length1 = 0;
				const gchar* _tmp332_ = NULL;
				gdouble _tmp333_ = 0.0;
				gchar* _tmp334_ = NULL;
				gint _tmp334__length1 = 0;
				const gchar* _tmp335_ = NULL;
				gint _tmp336_ = 0;
				gchar* _tmp337_ = NULL;
				PDFWriter* _tmp338_ = NULL;
				PDFWriter* _tmp339_ = NULL;
				guint _tmp340_ = 0U;
				PDFWriter* _tmp341_ = NULL;
				guint _tmp342_ = 0U;
				gchar* _tmp343_ = NULL;
				gchar* _tmp344_ = NULL;
				PDFWriter* _tmp345_ = NULL;
				PDFWriter* _tmp346_ = NULL;
				const gchar* _tmp347_ = NULL;
				gint _tmp348_ = 0;
				gint _tmp349_ = 0;
				gchar* _tmp350_ = NULL;
				gchar* _tmp351_ = NULL;
				PDFWriter* _tmp352_ = NULL;
				PDFWriter* _tmp353_ = NULL;
				PDFWriter* _tmp354_ = NULL;
				const gchar* _tmp355_ = NULL;
				PDFWriter* _tmp356_ = NULL;
				PDFWriter* _tmp357_ = NULL;
				PDFWriter* _tmp358_ = NULL;
				gint _tmp359_ = 0;
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				if (!_tmp56_) {
#line 2192 "book.c"
					gint _tmp57_ = 0;
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp57_ = i;
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					i = _tmp57_ + 1;
#line 2198 "book.c"
				}
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp56_ = FALSE;
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp58_ = i;
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp59_ = book_get_n_pages (self);
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp60_ = _tmp59_;
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				if (!(((guint) _tmp58_) < _tmp60_)) {
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					break;
#line 2212 "book.c"
				}
#line 271 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp61_ = i;
#line 271 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp62_ = book_get_page (self, _tmp61_);
#line 271 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				page = _tmp62_;
#line 272 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp63_ = page;
#line 272 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp64_ = page_get_image (_tmp63_, TRUE);
#line 272 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				image = _tmp64_;
#line 273 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp65_ = image;
#line 273 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp66_ = gdk_pixbuf_get_width (_tmp65_);
#line 273 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				width = _tmp66_;
#line 274 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp67_ = image;
#line 274 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp68_ = gdk_pixbuf_get_height (_tmp67_);
#line 274 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				height = _tmp68_;
#line 275 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp69_ = image;
#line 275 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp70_ = gdk_pixbuf_get_pixels (_tmp69_);
#line 275 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pixels = _tmp70_;
#line 275 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pixels_length1 = -1;
#line 275 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_pixels_size_ = pixels_length1;
#line 276 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp71_ = width;
#line 276 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp72_ = page;
#line 276 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp73_ = page_get_dpi (_tmp72_);
#line 276 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp74_ = _tmp73_;
#line 276 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				page_width = (_tmp71_ * 72.0) / _tmp74_;
#line 277 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp75_ = height;
#line 277 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp76_ = page;
#line 277 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp77_ = page_get_dpi (_tmp76_);
#line 277 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp78_ = _tmp77_;
#line 277 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				page_height = (_tmp75_ * 72.0) / _tmp78_;
#line 279 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				depth = 8;
#line 280 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp79_ = g_strdup ("DeviceRGB");
#line 280 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				color_space = _tmp79_;
#line 281 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				filter = NULL;
#line 282 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp80_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 282 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				width_buffer = _tmp80_;
#line 282 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				width_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 282 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_width_buffer_size_ = width_buffer_length1;
#line 283 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp81_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 283 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				height_buffer = _tmp81_;
#line 283 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				height_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 283 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_height_buffer_size_ = height_buffer_length1;
#line 285 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp82_ = page;
#line 285 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp83_ = page_get_is_color (_tmp82_);
#line 285 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp84_ = _tmp83_;
#line 285 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				if (_tmp84_) {
#line 2300 "book.c"
					gchar* _tmp85_ = NULL;
					gint data_length = 0;
					gint _tmp86_ = 0;
					gint _tmp87_ = 0;
					gint _tmp88_ = 0;
					guint8* _tmp89_ = NULL;
#line 287 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					depth = 8;
#line 288 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp85_ = g_strdup ("DeviceRGB");
#line 288 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_g_free0 (color_space);
#line 288 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					color_space = _tmp85_;
#line 289 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp86_ = height;
#line 289 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp87_ = width;
#line 289 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					data_length = (_tmp86_ * _tmp87_) * 3;
#line 290 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp88_ = data_length;
#line 290 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp89_ = g_new0 (guint8, _tmp88_);
#line 290 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					data = (g_free (data), NULL);
#line 290 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					data = _tmp89_;
#line 290 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					data_length1 = _tmp88_;
#line 290 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_data_size_ = data_length1;
#line 2333 "book.c"
					{
						gint row = 0;
#line 291 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						row = 0;
#line 2338 "book.c"
						{
							gboolean _tmp90_ = FALSE;
#line 291 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_tmp90_ = TRUE;
#line 291 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							while (TRUE) {
#line 2345 "book.c"
								gint _tmp92_ = 0;
								gint _tmp93_ = 0;
								gint in_offset = 0;
								gint _tmp94_ = 0;
								GdkPixbuf* _tmp95_ = NULL;
								gint _tmp96_ = 0;
								gint out_offset = 0;
								gint _tmp97_ = 0;
								gint _tmp98_ = 0;
#line 291 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
								if (!_tmp90_) {
#line 2357 "book.c"
									gint _tmp91_ = 0;
#line 291 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									_tmp91_ = row;
#line 291 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									row = _tmp91_ + 1;
#line 2363 "book.c"
								}
#line 291 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
								_tmp90_ = FALSE;
#line 291 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
								_tmp92_ = row;
#line 291 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
								_tmp93_ = height;
#line 291 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
								if (!(_tmp92_ < _tmp93_)) {
#line 291 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									break;
#line 2375 "book.c"
								}
#line 293 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
								_tmp94_ = row;
#line 293 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
								_tmp95_ = image;
#line 293 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
								_tmp96_ = gdk_pixbuf_get_rowstride (_tmp95_);
#line 293 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
								in_offset = _tmp94_ * _tmp96_;
#line 294 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
								_tmp97_ = row;
#line 294 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
								_tmp98_ = width;
#line 294 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
								out_offset = (_tmp97_ * _tmp98_) * 3;
#line 2391 "book.c"
								{
									gint x = 0;
#line 295 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									x = 0;
#line 2396 "book.c"
									{
										gboolean _tmp99_ = FALSE;
#line 295 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp99_ = TRUE;
#line 295 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										while (TRUE) {
#line 2403 "book.c"
											gint _tmp101_ = 0;
											gint _tmp102_ = 0;
											gint in_o = 0;
											gint _tmp103_ = 0;
											gint _tmp104_ = 0;
											gint out_o = 0;
											gint _tmp105_ = 0;
											gint _tmp106_ = 0;
											guint8* _tmp107_ = NULL;
											gint _tmp107__length1 = 0;
											gint _tmp108_ = 0;
											guint8* _tmp109_ = NULL;
											gint _tmp109__length1 = 0;
											gint _tmp110_ = 0;
											guint8 _tmp111_ = 0U;
											guint8 _tmp112_ = 0U;
											guint8* _tmp113_ = NULL;
											gint _tmp113__length1 = 0;
											gint _tmp114_ = 0;
											guint8* _tmp115_ = NULL;
											gint _tmp115__length1 = 0;
											gint _tmp116_ = 0;
											guint8 _tmp117_ = 0U;
											guint8 _tmp118_ = 0U;
											guint8* _tmp119_ = NULL;
											gint _tmp119__length1 = 0;
											gint _tmp120_ = 0;
											guint8* _tmp121_ = NULL;
											gint _tmp121__length1 = 0;
											gint _tmp122_ = 0;
											guint8 _tmp123_ = 0U;
											guint8 _tmp124_ = 0U;
#line 295 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											if (!_tmp99_) {
#line 2438 "book.c"
												gint _tmp100_ = 0;
#line 295 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												_tmp100_ = x;
#line 295 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												x = _tmp100_ + 1;
#line 2444 "book.c"
											}
#line 295 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp99_ = FALSE;
#line 295 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp101_ = x;
#line 295 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp102_ = width;
#line 295 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											if (!(_tmp101_ < _tmp102_)) {
#line 295 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												break;
#line 2456 "book.c"
											}
#line 297 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp103_ = in_offset;
#line 297 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp104_ = x;
#line 297 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											in_o = _tmp103_ + (_tmp104_ * 3);
#line 298 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp105_ = out_offset;
#line 298 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp106_ = x;
#line 298 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											out_o = _tmp105_ + (_tmp106_ * 3);
#line 300 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp107_ = data;
#line 300 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp107__length1 = data_length1;
#line 300 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp108_ = out_o;
#line 300 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp109_ = pixels;
#line 300 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp109__length1 = pixels_length1;
#line 300 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp110_ = in_o;
#line 300 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp111_ = _tmp109_[_tmp110_];
#line 300 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp107_[_tmp108_] = _tmp111_;
#line 300 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp112_ = _tmp107_[_tmp108_];
#line 301 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp113_ = data;
#line 301 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp113__length1 = data_length1;
#line 301 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp114_ = out_o;
#line 301 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp115_ = pixels;
#line 301 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp115__length1 = pixels_length1;
#line 301 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp116_ = in_o;
#line 301 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp117_ = _tmp115_[_tmp116_ + 1];
#line 301 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp113_[_tmp114_ + 1] = _tmp117_;
#line 301 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp118_ = _tmp113_[_tmp114_ + 1];
#line 302 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp119_ = data;
#line 302 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp119__length1 = data_length1;
#line 302 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp120_ = out_o;
#line 302 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp121_ = pixels;
#line 302 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp121__length1 = pixels_length1;
#line 302 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp122_ = in_o;
#line 302 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp123_ = _tmp121_[_tmp122_ + 2];
#line 302 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp119_[_tmp120_ + 2] = _tmp123_;
#line 302 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp124_ = _tmp119_[_tmp120_ + 2];
#line 2524 "book.c"
										}
									}
								}
							}
						}
					}
				} else {
					Page* _tmp125_ = NULL;
					gint _tmp126_ = 0;
					gint _tmp127_ = 0;
#line 306 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp125_ = page;
#line 306 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp126_ = page_get_depth (_tmp125_);
#line 306 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp127_ = _tmp126_;
#line 306 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					if (_tmp127_ == 2) {
#line 2543 "book.c"
						gint shift_count = 0;
						gchar* _tmp128_ = NULL;
						gint data_length = 0;
						gint _tmp129_ = 0;
						gint _tmp130_ = 0;
						gint _tmp131_ = 0;
						guint8* _tmp132_ = NULL;
						gint offset = 0;
#line 308 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						shift_count = 6;
#line 309 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						depth = 2;
#line 310 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp128_ = g_strdup ("DeviceGray");
#line 310 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_g_free0 (color_space);
#line 310 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						color_space = _tmp128_;
#line 311 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp129_ = height;
#line 311 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp130_ = width;
#line 311 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						data_length = _tmp129_ * (((_tmp130_ * 2) + 7) / 8);
#line 312 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp131_ = data_length;
#line 312 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp132_ = g_new0 (guint8, _tmp131_);
#line 312 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						data = (g_free (data), NULL);
#line 312 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						data = _tmp132_;
#line 312 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						data_length1 = _tmp131_;
#line 312 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_data_size_ = data_length1;
#line 313 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						offset = 0;
#line 2582 "book.c"
						{
							gint row = 0;
#line 314 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							row = 0;
#line 2587 "book.c"
							{
								gboolean _tmp133_ = FALSE;
#line 314 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
								_tmp133_ = TRUE;
#line 314 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
								while (TRUE) {
#line 2594 "book.c"
									gint _tmp135_ = 0;
									gint _tmp136_ = 0;
									gint _tmp137_ = 0;
									gint in_offset = 0;
									gint _tmp139_ = 0;
									GdkPixbuf* _tmp140_ = NULL;
									gint _tmp141_ = 0;
#line 314 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									if (!_tmp133_) {
#line 2604 "book.c"
										gint _tmp134_ = 0;
#line 314 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp134_ = row;
#line 314 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										row = _tmp134_ + 1;
#line 2610 "book.c"
									}
#line 314 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									_tmp133_ = FALSE;
#line 314 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									_tmp135_ = row;
#line 314 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									_tmp136_ = height;
#line 314 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									if (!(_tmp135_ < _tmp136_)) {
#line 314 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										break;
#line 2622 "book.c"
									}
#line 317 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									_tmp137_ = shift_count;
#line 317 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									if (_tmp137_ != 6) {
#line 2628 "book.c"
										gint _tmp138_ = 0;
#line 319 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp138_ = offset;
#line 319 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										offset = _tmp138_ + 1;
#line 320 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										shift_count = 6;
#line 2636 "book.c"
									}
#line 323 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									_tmp139_ = row;
#line 323 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									_tmp140_ = image;
#line 323 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									_tmp141_ = gdk_pixbuf_get_rowstride (_tmp140_);
#line 323 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									in_offset = _tmp139_ * _tmp141_;
#line 2646 "book.c"
									{
										gint x = 0;
#line 324 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										x = 0;
#line 2651 "book.c"
										{
											gboolean _tmp142_ = FALSE;
#line 324 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp142_ = TRUE;
#line 324 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											while (TRUE) {
#line 2658 "book.c"
												gint _tmp144_ = 0;
												gint _tmp145_ = 0;
												gint _tmp146_ = 0;
												guint8 p = 0U;
												guint8* _tmp150_ = NULL;
												gint _tmp150__length1 = 0;
												gint _tmp151_ = 0;
												gint _tmp152_ = 0;
												guint8 _tmp153_ = 0U;
												guint8 _tmp154_ = 0U;
												gint _tmp169_ = 0;
#line 324 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												if (!_tmp142_) {
#line 2672 "book.c"
													gint _tmp143_ = 0;
#line 324 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp143_ = x;
#line 324 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													x = _tmp143_ + 1;
#line 2678 "book.c"
												}
#line 324 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												_tmp142_ = FALSE;
#line 324 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												_tmp144_ = x;
#line 324 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												_tmp145_ = width;
#line 324 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												if (!(_tmp144_ < _tmp145_)) {
#line 324 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													break;
#line 2690 "book.c"
												}
#line 327 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												_tmp146_ = shift_count;
#line 327 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												if (_tmp146_ == 6) {
#line 2696 "book.c"
													guint8* _tmp147_ = NULL;
													gint _tmp147__length1 = 0;
													gint _tmp148_ = 0;
													guint8 _tmp149_ = 0U;
#line 328 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp147_ = data;
#line 328 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp147__length1 = data_length1;
#line 328 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp148_ = offset;
#line 328 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp147_[_tmp148_] = (guint8) 0;
#line 328 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp149_ = _tmp147_[_tmp148_];
#line 2711 "book.c"
												}
#line 331 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												_tmp150_ = pixels;
#line 331 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												_tmp150__length1 = pixels_length1;
#line 331 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												_tmp151_ = in_offset;
#line 331 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												_tmp152_ = x;
#line 331 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												_tmp153_ = _tmp150_[_tmp151_ + (_tmp152_ * 3)];
#line 331 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												p = _tmp153_;
#line 332 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												_tmp154_ = p;
#line 332 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												if (((gint) _tmp154_) >= 192) {
#line 2729 "book.c"
													guint8* _tmp155_ = NULL;
													gint _tmp155__length1 = 0;
													gint _tmp156_ = 0;
													gint _tmp157_ = 0;
													guint8 _tmp158_ = 0U;
#line 333 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp155_ = data;
#line 333 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp155__length1 = data_length1;
#line 333 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp156_ = offset;
#line 333 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp157_ = shift_count;
#line 333 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp155_[_tmp156_] |= (guint8) (3 << _tmp157_);
#line 333 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp158_ = _tmp155_[_tmp156_];
#line 2747 "book.c"
												} else {
													guint8 _tmp159_ = 0U;
#line 334 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp159_ = p;
#line 334 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													if (((gint) _tmp159_) >= 128) {
#line 2754 "book.c"
														guint8* _tmp160_ = NULL;
														gint _tmp160__length1 = 0;
														gint _tmp161_ = 0;
														gint _tmp162_ = 0;
														guint8 _tmp163_ = 0U;
#line 335 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp160_ = data;
#line 335 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp160__length1 = data_length1;
#line 335 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp161_ = offset;
#line 335 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp162_ = shift_count;
#line 335 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp160_[_tmp161_] |= (guint8) (2 << _tmp162_);
#line 335 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp163_ = _tmp160_[_tmp161_];
#line 2772 "book.c"
													} else {
														guint8 _tmp164_ = 0U;
#line 336 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp164_ = p;
#line 336 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														if (((gint) _tmp164_) >= 64) {
#line 2779 "book.c"
															guint8* _tmp165_ = NULL;
															gint _tmp165__length1 = 0;
															gint _tmp166_ = 0;
															gint _tmp167_ = 0;
															guint8 _tmp168_ = 0U;
#line 337 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
															_tmp165_ = data;
#line 337 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
															_tmp165__length1 = data_length1;
#line 337 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
															_tmp166_ = offset;
#line 337 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
															_tmp167_ = shift_count;
#line 337 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
															_tmp165_[_tmp166_] |= (guint8) (1 << _tmp167_);
#line 337 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
															_tmp168_ = _tmp165_[_tmp166_];
#line 2797 "book.c"
														}
													}
												}
#line 340 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												_tmp169_ = shift_count;
#line 340 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												if (_tmp169_ == 0) {
#line 2805 "book.c"
													gint _tmp170_ = 0;
#line 342 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp170_ = offset;
#line 342 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													offset = _tmp170_ + 1;
#line 343 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													shift_count = 6;
#line 2813 "book.c"
												} else {
													gint _tmp171_ = 0;
#line 346 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp171_ = shift_count;
#line 346 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													shift_count = _tmp171_ - 2;
#line 2820 "book.c"
												}
											}
										}
									}
								}
							}
						}
					} else {
						Page* _tmp172_ = NULL;
						gint _tmp173_ = 0;
						gint _tmp174_ = 0;
#line 350 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp172_ = page;
#line 350 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp173_ = page_get_depth (_tmp172_);
#line 350 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp174_ = _tmp173_;
#line 350 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						if (_tmp174_ == 1) {
#line 2840 "book.c"
							gint mask = 0;
							gchar* _tmp175_ = NULL;
							gint data_length = 0;
							gint _tmp176_ = 0;
							gint _tmp177_ = 0;
							gint _tmp178_ = 0;
							guint8* _tmp179_ = NULL;
							gint offset = 0;
#line 352 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							mask = 0x80;
#line 354 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							depth = 1;
#line 355 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_tmp175_ = g_strdup ("DeviceGray");
#line 355 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_g_free0 (color_space);
#line 355 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							color_space = _tmp175_;
#line 356 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_tmp176_ = height;
#line 356 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_tmp177_ = width;
#line 356 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							data_length = _tmp176_ * ((_tmp177_ + 7) / 8);
#line 357 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_tmp178_ = data_length;
#line 357 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_tmp179_ = g_new0 (guint8, _tmp178_);
#line 357 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							data = (g_free (data), NULL);
#line 357 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							data = _tmp179_;
#line 357 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							data_length1 = _tmp178_;
#line 357 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_data_size_ = data_length1;
#line 358 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							offset = 0;
#line 2879 "book.c"
							{
								gint row = 0;
#line 359 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
								row = 0;
#line 2884 "book.c"
								{
									gboolean _tmp180_ = FALSE;
#line 359 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									_tmp180_ = TRUE;
#line 359 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									while (TRUE) {
#line 2891 "book.c"
										gint _tmp182_ = 0;
										gint _tmp183_ = 0;
										gint _tmp184_ = 0;
										gint in_offset = 0;
										gint _tmp186_ = 0;
										GdkPixbuf* _tmp187_ = NULL;
										gint _tmp188_ = 0;
#line 359 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										if (!_tmp180_) {
#line 2901 "book.c"
											gint _tmp181_ = 0;
#line 359 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp181_ = row;
#line 359 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											row = _tmp181_ + 1;
#line 2907 "book.c"
										}
#line 359 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp180_ = FALSE;
#line 359 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp182_ = row;
#line 359 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp183_ = height;
#line 359 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										if (!(_tmp182_ < _tmp183_)) {
#line 359 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											break;
#line 2919 "book.c"
										}
#line 362 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp184_ = mask;
#line 362 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										if (_tmp184_ != 0x80) {
#line 2925 "book.c"
											gint _tmp185_ = 0;
#line 364 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp185_ = offset;
#line 364 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											offset = _tmp185_ + 1;
#line 365 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											mask = 0x80;
#line 2933 "book.c"
										}
#line 368 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp186_ = row;
#line 368 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp187_ = image;
#line 368 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp188_ = gdk_pixbuf_get_rowstride (_tmp187_);
#line 368 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										in_offset = _tmp186_ * _tmp188_;
#line 2943 "book.c"
										{
											gint x = 0;
#line 369 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											x = 0;
#line 2948 "book.c"
											{
												gboolean _tmp189_ = FALSE;
#line 369 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												_tmp189_ = TRUE;
#line 369 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												while (TRUE) {
#line 2955 "book.c"
													gint _tmp191_ = 0;
													gint _tmp192_ = 0;
													gint _tmp193_ = 0;
													guint8* _tmp197_ = NULL;
													gint _tmp197__length1 = 0;
													gint _tmp198_ = 0;
													gint _tmp199_ = 0;
													guint8 _tmp200_ = 0U;
													gint _tmp205_ = 0;
													gint _tmp206_ = 0;
#line 369 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													if (!_tmp189_) {
#line 2968 "book.c"
														gint _tmp190_ = 0;
#line 369 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp190_ = x;
#line 369 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														x = _tmp190_ + 1;
#line 2974 "book.c"
													}
#line 369 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp189_ = FALSE;
#line 369 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp191_ = x;
#line 369 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp192_ = width;
#line 369 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													if (!(_tmp191_ < _tmp192_)) {
#line 369 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														break;
#line 2986 "book.c"
													}
#line 372 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp193_ = mask;
#line 372 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													if (_tmp193_ == 0x80) {
#line 2992 "book.c"
														guint8* _tmp194_ = NULL;
														gint _tmp194__length1 = 0;
														gint _tmp195_ = 0;
														guint8 _tmp196_ = 0U;
#line 373 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp194_ = data;
#line 373 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp194__length1 = data_length1;
#line 373 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp195_ = offset;
#line 373 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp194_[_tmp195_] = (guint8) 0;
#line 373 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp196_ = _tmp194_[_tmp195_];
#line 3007 "book.c"
													}
#line 376 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp197_ = pixels;
#line 376 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp197__length1 = pixels_length1;
#line 376 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp198_ = in_offset;
#line 376 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp199_ = x;
#line 376 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp200_ = _tmp197_[_tmp198_ + (_tmp199_ * 3)];
#line 376 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													if (((gint) _tmp200_) != 0) {
#line 3021 "book.c"
														guint8* _tmp201_ = NULL;
														gint _tmp201__length1 = 0;
														gint _tmp202_ = 0;
														gint _tmp203_ = 0;
														guint8 _tmp204_ = 0U;
#line 377 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp201_ = data;
#line 377 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp201__length1 = data_length1;
#line 377 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp202_ = offset;
#line 377 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp203_ = mask;
#line 377 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp201_[_tmp202_] |= (guint8) _tmp203_;
#line 377 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp204_ = _tmp201_[_tmp202_];
#line 3039 "book.c"
													}
#line 380 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp205_ = mask;
#line 380 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													mask = _tmp205_ >> 1;
#line 381 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp206_ = mask;
#line 381 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													if (_tmp206_ == 0) {
#line 3049 "book.c"
														gint _tmp207_ = 0;
#line 383 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp207_ = offset;
#line 383 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														offset = _tmp207_ + 1;
#line 384 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														mask = 0x80;
#line 3057 "book.c"
													}
												}
											}
										}
									}
								}
							}
						} else {
							gchar* _tmp208_ = NULL;
							gint data_length = 0;
							gint _tmp209_ = 0;
							gint _tmp210_ = 0;
							gint _tmp211_ = 0;
							guint8* _tmp212_ = NULL;
#line 391 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							depth = 8;
#line 392 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_tmp208_ = g_strdup ("DeviceGray");
#line 392 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_g_free0 (color_space);
#line 392 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							color_space = _tmp208_;
#line 393 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_tmp209_ = height;
#line 393 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_tmp210_ = width;
#line 393 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							data_length = _tmp209_ * _tmp210_;
#line 394 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_tmp211_ = data_length;
#line 394 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_tmp212_ = g_new0 (guint8, _tmp211_);
#line 394 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							data = (g_free (data), NULL);
#line 394 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							data = _tmp212_;
#line 394 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							data_length1 = _tmp211_;
#line 394 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_data_size_ = data_length1;
#line 3098 "book.c"
							{
								gint row = 0;
#line 395 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
								row = 0;
#line 3103 "book.c"
								{
									gboolean _tmp213_ = FALSE;
#line 395 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									_tmp213_ = TRUE;
#line 395 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
									while (TRUE) {
#line 3110 "book.c"
										gint _tmp215_ = 0;
										gint _tmp216_ = 0;
										gint in_offset = 0;
										gint _tmp217_ = 0;
										GdkPixbuf* _tmp218_ = NULL;
										gint _tmp219_ = 0;
										gint out_offset = 0;
										gint _tmp220_ = 0;
										gint _tmp221_ = 0;
#line 395 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										if (!_tmp213_) {
#line 3122 "book.c"
											gint _tmp214_ = 0;
#line 395 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											_tmp214_ = row;
#line 395 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											row = _tmp214_ + 1;
#line 3128 "book.c"
										}
#line 395 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp213_ = FALSE;
#line 395 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp215_ = row;
#line 395 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp216_ = height;
#line 395 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										if (!(_tmp215_ < _tmp216_)) {
#line 395 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											break;
#line 3140 "book.c"
										}
#line 397 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp217_ = row;
#line 397 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp218_ = image;
#line 397 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp219_ = gdk_pixbuf_get_rowstride (_tmp218_);
#line 397 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										in_offset = _tmp217_ * _tmp219_;
#line 398 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp220_ = row;
#line 398 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										_tmp221_ = width;
#line 398 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
										out_offset = _tmp220_ * _tmp221_;
#line 3156 "book.c"
										{
											gint x = 0;
#line 399 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
											x = 0;
#line 3161 "book.c"
											{
												gboolean _tmp222_ = FALSE;
#line 399 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												_tmp222_ = TRUE;
#line 399 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
												while (TRUE) {
#line 3168 "book.c"
													gint _tmp224_ = 0;
													gint _tmp225_ = 0;
													guint8* _tmp226_ = NULL;
													gint _tmp226__length1 = 0;
													gint _tmp227_ = 0;
													gint _tmp228_ = 0;
													guint8* _tmp229_ = NULL;
													gint _tmp229__length1 = 0;
													gint _tmp230_ = 0;
													gint _tmp231_ = 0;
													guint8 _tmp232_ = 0U;
													guint8 _tmp233_ = 0U;
#line 399 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													if (!_tmp222_) {
#line 3183 "book.c"
														gint _tmp223_ = 0;
#line 399 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														_tmp223_ = x;
#line 399 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														x = _tmp223_ + 1;
#line 3189 "book.c"
													}
#line 399 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp222_ = FALSE;
#line 399 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp224_ = x;
#line 399 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp225_ = width;
#line 399 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													if (!(_tmp224_ < _tmp225_)) {
#line 399 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
														break;
#line 3201 "book.c"
													}
#line 400 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp226_ = data;
#line 400 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp226__length1 = data_length1;
#line 400 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp227_ = out_offset;
#line 400 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp228_ = x;
#line 400 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp229_ = pixels;
#line 400 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp229__length1 = pixels_length1;
#line 400 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp230_ = in_offset;
#line 400 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp231_ = x;
#line 400 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp232_ = _tmp229_[_tmp230_ + (_tmp231_ * 3)];
#line 400 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp226_[_tmp227_ + _tmp228_] = _tmp232_;
#line 400 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
													_tmp233_ = _tmp226_[_tmp227_ + _tmp228_];
#line 3225 "book.c"
												}
											}
										}
									}
								}
							}
						}
					}
				}
#line 405 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp234_ = data;
#line 405 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp234__length1 = data_length1;
#line 405 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp236_ = book_compress_zlib (self, _tmp234_, _tmp234__length1, &_tmp235_);
#line 405 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				compressed_data = _tmp236_;
#line 405 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				compressed_data_length1 = _tmp235_;
#line 405 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_compressed_data_size_ = compressed_data_length1;
#line 406 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp237_ = compressed_data;
#line 406 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp237__length1 = compressed_data_length1;
#line 406 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				if (_tmp237_ != NULL) {
#line 3253 "book.c"
					gint _tmp238_ = 0;
					const gchar* _tmp251_ = NULL;
#line 409 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp238_ = depth;
#line 409 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					if (_tmp238_ > 1) {
#line 3260 "book.c"
						guint8* jpeg_data = NULL;
						GdkPixbuf* _tmp239_ = NULL;
						gint _tmp240_ = 0;
						Page* _tmp241_ = NULL;
						gint _tmp242_ = 0;
						gint _tmp243_ = 0;
						gint _tmp244_ = 0;
						guint8* _tmp245_ = NULL;
						gint jpeg_data_length1 = 0;
						gint _jpeg_data_size_ = 0;
						guint8* _tmp246_ = NULL;
						gint _tmp246__length1 = 0;
						guint8* _tmp247_ = NULL;
						gint _tmp247__length1 = 0;
#line 411 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp239_ = image;
#line 411 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp240_ = quality;
#line 411 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp241_ = page;
#line 411 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp242_ = page_get_dpi (_tmp241_);
#line 411 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp243_ = _tmp242_;
#line 411 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp245_ = book_compress_jpeg (self, _tmp239_, _tmp240_, _tmp243_, &_tmp244_);
#line 411 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						jpeg_data = _tmp245_;
#line 411 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						jpeg_data_length1 = _tmp244_;
#line 411 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_jpeg_data_size_ = jpeg_data_length1;
#line 412 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp246_ = jpeg_data;
#line 412 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp246__length1 = jpeg_data_length1;
#line 412 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp247_ = compressed_data;
#line 412 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp247__length1 = compressed_data_length1;
#line 412 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						if (_tmp246__length1 < _tmp247__length1) {
#line 3303 "book.c"
							gchar* _tmp248_ = NULL;
							guint8* _tmp249_ = NULL;
							gint _tmp249__length1 = 0;
							guint8* _tmp250_ = NULL;
							gint _tmp250__length1 = 0;
#line 414 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_tmp248_ = g_strdup ("DCTDecode");
#line 414 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_g_free0 (filter);
#line 414 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							filter = _tmp248_;
#line 415 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_tmp249_ = jpeg_data;
#line 415 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_tmp249__length1 = jpeg_data_length1;
#line 415 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_tmp250_ = (_tmp249_ != NULL) ? _vala_array_dup1 (_tmp249_, _tmp249__length1) : ((gpointer) _tmp249_);
#line 415 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_tmp250__length1 = _tmp249__length1;
#line 415 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							data = (g_free (data), NULL);
#line 415 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							data = _tmp250_;
#line 415 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							data_length1 = _tmp250__length1;
#line 415 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
							_data_size_ = data_length1;
#line 3331 "book.c"
						}
#line 409 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						jpeg_data = (g_free (jpeg_data), NULL);
#line 3335 "book.c"
					}
#line 419 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp251_ = filter;
#line 419 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					if (_tmp251_ == NULL) {
#line 3341 "book.c"
						gchar* _tmp252_ = NULL;
						guint8* _tmp253_ = NULL;
						gint _tmp253__length1 = 0;
						guint8* _tmp254_ = NULL;
						gint _tmp254__length1 = 0;
#line 421 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp252_ = g_strdup ("FlateDecode");
#line 421 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_g_free0 (filter);
#line 421 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						filter = _tmp252_;
#line 422 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp253_ = compressed_data;
#line 422 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp253__length1 = compressed_data_length1;
#line 422 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp254_ = (_tmp253_ != NULL) ? _vala_array_dup2 (_tmp253_, _tmp253__length1) : ((gpointer) _tmp253_);
#line 422 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_tmp254__length1 = _tmp253__length1;
#line 422 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						data = (g_free (data), NULL);
#line 422 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						data = _tmp254_;
#line 422 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						data_length1 = _tmp254__length1;
#line 422 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
						_data_size_ = data_length1;
#line 3369 "book.c"
					}
				}
#line 427 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp255_ = writer;
#line 427 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp255_, "\n");
#line 428 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp256_ = writer;
#line 428 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp257_ = pdf_writer_start_object (_tmp256_);
#line 428 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				number = _tmp257_;
#line 429 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp258_ = writer;
#line 429 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp259_ = number;
#line 429 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp260_ = g_strdup_printf ("%u 0 obj\n", _tmp259_);
#line 429 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp261_ = _tmp260_;
#line 429 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp258_, _tmp261_);
#line 429 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (_tmp261_);
#line 430 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp262_ = writer;
#line 430 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp262_, "<<\n");
#line 431 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp263_ = writer;
#line 431 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp263_, "/Type /Page\n");
#line 432 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp264_ = writer;
#line 432 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp265_ = pages_number;
#line 432 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp266_ = g_strdup_printf ("/Parent %u 0 R\n", _tmp265_);
#line 432 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp267_ = _tmp266_;
#line 432 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp264_, _tmp267_);
#line 432 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (_tmp267_);
#line 433 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp268_ = writer;
#line 433 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp269_ = i;
#line 433 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp270_ = number;
#line 433 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp271_ = g_strdup_printf ("/Resources << /XObject << /Im%d %u 0 R >> >>\n", _tmp269_, _tmp270_ + 1);
#line 433 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp272_ = _tmp271_;
#line 433 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp268_, _tmp272_);
#line 433 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (_tmp272_);
#line 434 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp273_ = writer;
#line 434 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp274_ = page_width;
#line 434 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp275_ = width_buffer;
#line 434 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp275__length1 = width_buffer_length1;
#line 434 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp276_ = g_ascii_formatd (_tmp275_, _tmp275__length1, "%.2f", _tmp274_);
#line 434 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp277_ = page_height;
#line 434 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp278_ = height_buffer;
#line 434 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp278__length1 = height_buffer_length1;
#line 434 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp279_ = g_ascii_formatd (_tmp278_, _tmp278__length1, "%.2f", _tmp277_);
#line 434 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp280_ = g_strdup_printf ("/MediaBox [ 0 0 %s %s ]\n", _tmp276_, _tmp279_);
#line 434 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp281_ = _tmp280_;
#line 434 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp273_, _tmp281_);
#line 434 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (_tmp281_);
#line 435 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp282_ = writer;
#line 435 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp283_ = number;
#line 435 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp284_ = g_strdup_printf ("/Contents %u 0 R\n", _tmp283_ + 2);
#line 435 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp285_ = _tmp284_;
#line 435 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp282_, _tmp285_);
#line 435 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (_tmp285_);
#line 436 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp286_ = writer;
#line 436 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp286_, ">>\n");
#line 437 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp287_ = writer;
#line 437 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp287_, "endobj\n");
#line 440 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp288_ = writer;
#line 440 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp288_, "\n");
#line 441 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp289_ = writer;
#line 441 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp290_ = pdf_writer_start_object (_tmp289_);
#line 441 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				number = _tmp290_;
#line 442 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp291_ = writer;
#line 442 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp292_ = number;
#line 442 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp293_ = g_strdup_printf ("%u 0 obj\n", _tmp292_);
#line 442 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp294_ = _tmp293_;
#line 442 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp291_, _tmp294_);
#line 442 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (_tmp294_);
#line 443 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp295_ = writer;
#line 443 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp295_, "<<\n");
#line 444 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp296_ = writer;
#line 444 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp296_, "/Type /XObject\n");
#line 445 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp297_ = writer;
#line 445 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp297_, "/Subtype /Image\n");
#line 446 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp298_ = writer;
#line 446 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp299_ = width;
#line 446 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp300_ = g_strdup_printf ("/Width %d\n", _tmp299_);
#line 446 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp301_ = _tmp300_;
#line 446 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp298_, _tmp301_);
#line 446 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (_tmp301_);
#line 447 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp302_ = writer;
#line 447 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp303_ = height;
#line 447 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp304_ = g_strdup_printf ("/Height %d\n", _tmp303_);
#line 447 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp305_ = _tmp304_;
#line 447 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp302_, _tmp305_);
#line 447 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (_tmp305_);
#line 448 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp306_ = writer;
#line 448 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp307_ = color_space;
#line 448 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp308_ = g_strdup_printf ("/ColorSpace /%s\n", _tmp307_);
#line 448 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp309_ = _tmp308_;
#line 448 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp306_, _tmp309_);
#line 448 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (_tmp309_);
#line 449 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp310_ = writer;
#line 449 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp311_ = depth;
#line 449 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp312_ = g_strdup_printf ("/BitsPerComponent %d\n", _tmp311_);
#line 449 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp313_ = _tmp312_;
#line 449 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp310_, _tmp313_);
#line 449 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (_tmp313_);
#line 450 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp314_ = writer;
#line 450 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp315_ = data;
#line 450 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp315__length1 = data_length1;
#line 450 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp316_ = g_strdup_printf ("/Length %d\n", _tmp315__length1);
#line 450 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp317_ = _tmp316_;
#line 450 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp314_, _tmp317_);
#line 450 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (_tmp317_);
#line 451 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp318_ = filter;
#line 451 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				if (_tmp318_ != NULL) {
#line 3574 "book.c"
					PDFWriter* _tmp319_ = NULL;
					const gchar* _tmp320_ = NULL;
					gchar* _tmp321_ = NULL;
					gchar* _tmp322_ = NULL;
#line 452 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp319_ = writer;
#line 452 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp320_ = filter;
#line 452 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp321_ = g_strdup_printf ("/Filter /%s\n", _tmp320_);
#line 452 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_tmp322_ = _tmp321_;
#line 452 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					pdf_writer_write_string (_tmp319_, _tmp322_);
#line 452 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					_g_free0 (_tmp322_);
#line 3591 "book.c"
				}
#line 453 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp323_ = writer;
#line 453 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp323_, ">>\n");
#line 454 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp324_ = writer;
#line 454 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp324_, "stream\n");
#line 455 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp325_ = writer;
#line 455 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp326_ = data;
#line 455 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp326__length1 = data_length1;
#line 455 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write (_tmp325_, _tmp326_, _tmp326__length1);
#line 456 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp327_ = writer;
#line 456 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp327_, "\n");
#line 457 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp328_ = writer;
#line 457 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp328_, "endstream\n");
#line 458 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp329_ = writer;
#line 458 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp329_, "endobj\n");
#line 461 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp330_ = page_width;
#line 461 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp331_ = width_buffer;
#line 461 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp331__length1 = width_buffer_length1;
#line 461 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp332_ = g_ascii_formatd (_tmp331_, _tmp331__length1, "%f", _tmp330_);
#line 461 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp333_ = page_height;
#line 461 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp334_ = height_buffer;
#line 461 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp334__length1 = height_buffer_length1;
#line 461 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp335_ = g_ascii_formatd (_tmp334_, _tmp334__length1, "%f", _tmp333_);
#line 461 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp336_ = i;
#line 461 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp337_ = g_strdup_printf ("q\n%s 0 0 %s 0 0 cm\n/Im%d Do\nQ", _tmp332_, _tmp335_, _tmp336_);
#line 461 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				command = _tmp337_;
#line 462 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp338_ = writer;
#line 462 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp338_, "\n");
#line 463 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp339_ = writer;
#line 463 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp340_ = pdf_writer_start_object (_tmp339_);
#line 463 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				number = _tmp340_;
#line 464 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp341_ = writer;
#line 464 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp342_ = number;
#line 464 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp343_ = g_strdup_printf ("%u 0 obj\n", _tmp342_);
#line 464 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp344_ = _tmp343_;
#line 464 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp341_, _tmp344_);
#line 464 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (_tmp344_);
#line 465 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp345_ = writer;
#line 465 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp345_, "<<\n");
#line 466 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp346_ = writer;
#line 466 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp347_ = command;
#line 466 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp348_ = strlen (_tmp347_);
#line 466 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp349_ = _tmp348_;
#line 466 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp350_ = g_strdup_printf ("/Length %d\n", _tmp349_);
#line 466 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp351_ = _tmp350_;
#line 466 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp346_, _tmp351_);
#line 466 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (_tmp351_);
#line 467 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp352_ = writer;
#line 467 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp352_, ">>\n");
#line 468 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp353_ = writer;
#line 468 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp353_, "stream\n");
#line 469 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp354_ = writer;
#line 469 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp355_ = command;
#line 469 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp354_, _tmp355_);
#line 470 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp356_ = writer;
#line 470 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp356_, "\n");
#line 471 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp357_ = writer;
#line 471 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp357_, "endstream\n");
#line 472 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp358_ = writer;
#line 472 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp358_, "endobj\n");
#line 474 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp359_ = i;
#line 474 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp359_);
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (command);
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				compressed_data = (g_free (compressed_data), NULL);
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				data = (g_free (data), NULL);
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				height_buffer = (g_free (height_buffer), NULL);
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				width_buffer = (g_free (width_buffer), NULL);
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (filter);
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (color_space);
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_object_unref0 (image);
#line 269 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_page_unref0 (page);
#line 3733 "book.c"
			}
		}
	}
#line 478 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp360_ = writer;
#line 478 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp360_, "\n");
#line 479 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp361_ = writer;
#line 479 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp362_ = pdf_writer_start_object (_tmp361_);
#line 479 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	info_number = _tmp362_;
#line 480 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp363_ = writer;
#line 480 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp364_ = info_number;
#line 480 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp365_ = g_strdup_printf ("%u 0 obj\n", _tmp364_);
#line 480 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp366_ = _tmp365_;
#line 480 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp363_, _tmp366_);
#line 480 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (_tmp366_);
#line 481 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp367_ = writer;
#line 481 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp367_, "<<\n");
#line 482 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp368_ = writer;
#line 482 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp369_ = g_strdup_printf ("/Creator (Simple Scan %s)\n", VERSION);
#line 482 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp370_ = _tmp369_;
#line 482 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp368_, _tmp370_);
#line 482 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (_tmp370_);
#line 483 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp371_ = writer;
#line 483 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp371_, ">>\n");
#line 484 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp372_ = writer;
#line 484 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp372_, "endobj\n");
#line 487 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp373_ = writer;
#line 487 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp373_, "\n");
#line 488 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp374_ = writer;
#line 488 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp375_ = _tmp374_->offset;
#line 488 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	xref_offset = _tmp375_;
#line 489 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp376_ = writer;
#line 489 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp376_, "xref\n");
#line 490 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp377_ = writer;
#line 490 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp378_ = writer;
#line 490 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp379_ = _tmp378_->object_offsets;
#line 490 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp380_ = g_list_length (_tmp379_);
#line 490 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp381_ = g_strdup_printf ("0 %zu\n", (gsize) (_tmp380_ + 1));
#line 490 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp382_ = _tmp381_;
#line 490 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp377_, _tmp382_);
#line 490 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (_tmp382_);
#line 491 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp383_ = writer;
#line 491 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp383_, "0000000000 65535 f \n");
#line 492 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp384_ = writer;
#line 492 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp385_ = _tmp384_->object_offsets;
#line 3819 "book.c"
	{
		GList* offset_collection = NULL;
		GList* offset_it = NULL;
#line 492 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		offset_collection = _tmp385_;
#line 492 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		for (offset_it = offset_collection; offset_it != NULL; offset_it = offset_it->next) {
#line 3827 "book.c"
			guint offset = 0U;
#line 492 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			offset = (guint) ((guintptr) offset_it->data);
#line 3831 "book.c"
			{
				PDFWriter* _tmp386_ = NULL;
				guint _tmp387_ = 0U;
				gchar* _tmp388_ = NULL;
				gchar* _tmp389_ = NULL;
#line 493 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp386_ = writer;
#line 493 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp387_ = offset;
#line 493 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp388_ = g_strdup_printf ("%010zu 00000 n \n", (gsize) _tmp387_);
#line 493 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp389_ = _tmp388_;
#line 493 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				pdf_writer_write_string (_tmp386_, _tmp389_);
#line 493 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_g_free0 (_tmp389_);
#line 3849 "book.c"
			}
		}
	}
#line 496 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp390_ = writer;
#line 496 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp390_, "\n");
#line 497 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp391_ = writer;
#line 497 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp391_, "trailer\n");
#line 498 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp392_ = writer;
#line 498 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp392_, "<<\n");
#line 499 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp393_ = writer;
#line 499 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp394_ = writer;
#line 499 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp395_ = _tmp394_->object_offsets;
#line 499 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp396_ = g_list_length (_tmp395_);
#line 499 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp397_ = g_strdup_printf ("/Size %zu\n", (gsize) (_tmp396_ + 1));
#line 499 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp398_ = _tmp397_;
#line 499 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp393_, _tmp398_);
#line 499 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (_tmp398_);
#line 500 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp399_ = writer;
#line 500 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp400_ = info_number;
#line 500 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp401_ = g_strdup_printf ("/Info %u 0 R\n", _tmp400_);
#line 500 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp402_ = _tmp401_;
#line 500 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp399_, _tmp402_);
#line 500 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (_tmp402_);
#line 501 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp403_ = writer;
#line 501 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp404_ = catalog_number;
#line 501 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp405_ = g_strdup_printf ("/Root %u 0 R\n", _tmp404_);
#line 501 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp406_ = _tmp405_;
#line 501 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp403_, _tmp406_);
#line 501 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (_tmp406_);
#line 502 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp407_ = writer;
#line 502 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp408_ = id;
#line 502 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp409_ = id;
#line 502 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp410_ = g_strdup_printf ("/ID [<%s> <%s>]\n", _tmp408_, _tmp409_);
#line 502 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp411_ = _tmp410_;
#line 502 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp407_, _tmp411_);
#line 502 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (_tmp411_);
#line 503 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp412_ = writer;
#line 503 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp412_, ">>\n");
#line 504 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp413_ = writer;
#line 504 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp413_, "startxref\n");
#line 505 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp414_ = writer;
#line 505 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp415_ = xref_offset;
#line 505 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp416_ = g_strdup_printf ("%zu\n", _tmp415_);
#line 505 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp417_ = _tmp416_;
#line 505 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp414_, _tmp417_);
#line 505 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (_tmp417_);
#line 506 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp418_ = writer;
#line 506 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write_string (_tmp418_, "%%EOF\n");
#line 213 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_pdf_writer_unref0 (writer);
#line 213 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_object_unref0 (stream);
#line 213 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_free0 (id);
#line 3949 "book.c"
}


void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 511 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	static GQuark _tmp2_label0 = 0;
#line 511 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	static GQuark _tmp2_label1 = 0;
#line 511 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	static GQuark _tmp2_label2 = 0;
#line 511 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	static GQuark _tmp2_label3 = 0;
#line 511 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	static GQuark _tmp2_label4 = 0;
#line 3967 "book.c"
	GError * _inner_error_ = NULL;
#line 509 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (self != NULL);
#line 509 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (type != NULL);
#line 509 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (file != NULL);
#line 511 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = type;
#line 511 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp1_ = _tmp0_;
#line 511 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 511 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("jpeg")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("png"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("tiff"))))) {
#line 511 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		switch (0) {
#line 3985 "book.c"
			default:
			{
				const gchar* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				GFile* _tmp6_ = NULL;
#line 516 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp4_ = type;
#line 516 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp5_ = quality;
#line 516 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp6_ = file;
#line 516 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				book_save_multi_file (self, _tmp4_, _tmp5_, _tmp6_, &_inner_error_);
#line 516 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 516 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 516 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					return;
#line 4005 "book.c"
				}
#line 517 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				break;
#line 4009 "book.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("ps")))) {
#line 511 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		switch (0) {
#line 4015 "book.c"
			default:
			{
				GFile* _tmp7_ = NULL;
#line 519 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp7_ = file;
#line 519 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				book_save_ps (self, _tmp7_, &_inner_error_);
#line 519 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 519 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 519 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					return;
#line 4029 "book.c"
				}
#line 520 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				break;
#line 4033 "book.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("pdf")))) {
#line 511 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		switch (0) {
#line 4039 "book.c"
			default:
			{
				GFile* _tmp8_ = NULL;
				gint _tmp9_ = 0;
#line 522 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp8_ = file;
#line 522 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp9_ = quality;
#line 522 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				book_save_pdf (self, _tmp8_, _tmp9_, &_inner_error_);
#line 522 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 522 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 522 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
					return;
#line 4056 "book.c"
				}
#line 523 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				break;
#line 4060 "book.c"
			}
		}
	}
}


guint book_get_n_pages (Book* self) {
	guint result;
	GList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 16 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 16 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 16 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp1_ = g_list_length (_tmp0_);
#line 16 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	result = _tmp1_;
#line 16 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return result;
#line 4081 "book.c"
}


gboolean book_get_needs_saving (Book* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 21 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 21 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = self->priv->needs_saving_;
#line 21 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	result = _tmp0_;
#line 21 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return result;
#line 4096 "book.c"
}


void book_set_needs_saving (Book* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 22 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (self != NULL);
#line 24 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = self->priv->needs_saving_;
#line 24 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp1_ = value;
#line 24 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (_tmp0_ == _tmp1_) {
#line 25 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		return;
#line 4114 "book.c"
	}
#line 26 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp2_ = value;
#line 26 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->priv->needs_saving_ = _tmp2_;
#line 27 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_emit_by_name (self, "needs-saving-changed");
#line 4122 "book.c"
}


static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__PAGE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__PAGE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (n_param_values == 2);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		data1 = closure->data;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		data2 = param_values->data[0].v_pointer;
#line 4141 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		data2 = closure->data;
#line 4147 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	callback = (GMarshalFunc_VOID__PAGE) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	callback (data1, value_get_page (param_values + 1), data2);
#line 4153 "book.c"
}


static void value_book_init (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 4160 "book.c"
}


static void value_book_free_value (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		book_unref (value->data[0].v_pointer);
#line 4169 "book.c"
	}
}


static void value_book_copy_value (const GValue* src_value, GValue* dest_value) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		dest_value->data[0].v_pointer = book_ref (src_value->data[0].v_pointer);
#line 4179 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4183 "book.c"
	}
}


static gpointer value_book_peek_pointer (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return value->data[0].v_pointer;
#line 4191 "book.c"
}


static gchar* value_book_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 4198 "book.c"
		Book* object;
		object = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4205 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4209 "book.c"
		}
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = book_ref (object);
#line 4213 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4217 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return NULL;
#line 4221 "book.c"
}


static gchar* value_book_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Book** object_p;
	object_p = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (!object_p) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4232 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		*object_p = NULL;
#line 4238 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 4242 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		*object_p = book_ref (value->data[0].v_pointer);
#line 4246 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return NULL;
#line 4250 "book.c"
}


GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBook* spec;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BOOK), NULL);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 4264 "book.c"
}


gpointer value_get_book (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK), NULL);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return value->data[0].v_pointer;
#line 4273 "book.c"
}


void value_set_book (GValue* value, gpointer v_object) {
	Book* old;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		book_ref (value->data[0].v_pointer);
#line 4293 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4297 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		book_unref (old);
#line 4303 "book.c"
	}
}


void value_take_book (GValue* value, gpointer v_object) {
	Book* old;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 4322 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4326 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		book_unref (old);
#line 4332 "book.c"
	}
}


static void book_class_init (BookClass * klass) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	book_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	((BookClass *) klass)->finalize = book_finalize;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_type_class_add_private (klass, sizeof (BookPrivate));
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_new ("page_added", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_new ("page_removed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_new ("reordered", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_new ("cleared", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_new ("needs_saving_changed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_new ("saving", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 4356 "book.c"
}


static void book_instance_init (Book * self) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->priv = BOOK_GET_PRIVATE (self);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->ref_count = 1;
#line 4365 "book.c"
}


static void book_finalize (Book* obj) {
	Book * self;
	GList* _tmp0_ = NULL;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOK, Book);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_handlers_destroy (self);
#line 45 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 4378 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 45 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		page_collection = _tmp0_;
#line 45 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 4386 "book.c"
			Page* _tmp1_ = NULL;
			Page* page = NULL;
#line 45 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 45 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			page = _tmp1_;
#line 4393 "book.c"
			{
				Page* _tmp2_ = NULL;
				guint _tmp3_ = 0U;
				Page* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
#line 47 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp2_ = page;
#line 47 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 47 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 48 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_tmp4_ = page;
#line 48 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 48 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 45 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
				_page_unref0 (page);
#line 4413 "book.c"
			}
		}
	}
#line 14 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 187 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 4421 "book.c"
}


GType book_get_type (void) {
	static volatile gsize book_type_id__volatile = 0;
	if (g_once_init_enter (&book_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_book_init, value_book_free_value, value_book_copy_value, value_book_peek_pointer, "p", value_book_collect_value, "p", value_book_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) book_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Book), 0, (GInstanceInitFunc) book_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType book_type_id;
		book_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Book", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&book_type_id__volatile, book_type_id);
	}
	return book_type_id__volatile;
}


gpointer book_ref (gpointer instance) {
	Book* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return instance;
#line 4446 "book.c"
}


void book_unref (gpointer instance) {
	Book* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		BOOK_GET_CLASS (self)->finalize (self);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4459 "book.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 536 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return self ? g_object_ref (self) : NULL;
#line 4467 "book.c"
}


PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream) {
	PDFWriter* self = NULL;
	GFileOutputStream* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
#line 534 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 534 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self = (PDFWriter*) g_type_create_instance (object_type);
#line 536 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = stream;
#line 536 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 536 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_object_unref0 (self->priv->stream);
#line 536 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->priv->stream = _tmp1_;
#line 534 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return self;
#line 4489 "book.c"
}


PDFWriter* pdf_writer_new (GFileOutputStream* stream) {
#line 534 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return pdf_writer_construct (TYPE_PDF_WRITER, stream);
#line 4496 "book.c"
}


void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1) {
	gsize _tmp4_ = 0UL;
	guint8* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GError * _inner_error_ = NULL;
#line 539 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (self != NULL);
#line 4507 "book.c"
	{
		GFileOutputStream* _tmp0_ = NULL;
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 543 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp0_ = self->priv->stream;
#line 543 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp1_ = data;
#line 543 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp1__length1 = data_length1;
#line 543 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
#line 543 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4522 "book.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 541 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		e = _inner_error_;
#line 541 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_inner_error_ = NULL;
#line 547 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp2_ = e;
#line 547 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp3_ = _tmp2_->message;
#line 547 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_warning ("book.vala:547: Error writing PDF: %s", _tmp3_);
#line 541 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_g_error_free0 (e);
#line 4544 "book.c"
	}
	__finally1:
#line 541 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 541 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 541 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_clear_error (&_inner_error_);
#line 541 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		return;
#line 4555 "book.c"
	}
#line 549 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp4_ = self->offset;
#line 549 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp5_ = data;
#line 549 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp5__length1 = data_length1;
#line 549 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->offset = _tmp4_ + _tmp5__length1;
#line 4565 "book.c"
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 1307 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1308 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1308 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1308 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1308 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1308 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1308 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1309 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1309 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1310 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1310 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1310 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1310 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1310 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1311 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1311 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1311 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1311 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 4620 "book.c"
	}
#line 1311 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1311 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 4626 "book.c"
}


void pdf_writer_write_string (PDFWriter* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 552 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (self != NULL);
#line 552 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (text != NULL);
#line 554 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = text;
#line 554 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
#line 554 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp3_ = (guint8*) _tmp2_;
#line 554 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp3__length1 = (_tmp1_ * sizeof (gchar)) / sizeof (guint8);
#line 554 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_write (self, _tmp3_, (_tmp1_ * sizeof (gchar)) / sizeof (guint8));
#line 554 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp3_ = (g_free (_tmp3_), NULL);
#line 4652 "book.c"
}


guint pdf_writer_start_object (PDFWriter* self) {
	guint result = 0U;
	gsize _tmp0_ = 0UL;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
#line 557 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 559 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = self->offset;
#line 559 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->object_offsets = g_list_append (self->object_offsets, (gpointer) ((guintptr) ((guint) _tmp0_)));
#line 560 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp1_ = self->object_offsets;
#line 560 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp2_ = g_list_length (_tmp1_);
#line 560 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	result = _tmp2_;
#line 560 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return result;
#line 4675 "book.c"
}


static void value_pdf_writer_init (GValue* value) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 4682 "book.c"
}


static void value_pdf_writer_free_value (GValue* value) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (value->data[0].v_pointer) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		pdf_writer_unref (value->data[0].v_pointer);
#line 4691 "book.c"
	}
}


static void value_pdf_writer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		dest_value->data[0].v_pointer = pdf_writer_ref (src_value->data[0].v_pointer);
#line 4701 "book.c"
	} else {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4705 "book.c"
	}
}


static gpointer value_pdf_writer_peek_pointer (const GValue* value) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return value->data[0].v_pointer;
#line 4713 "book.c"
}


static gchar* value_pdf_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 4720 "book.c"
		PDFWriter* object;
		object = collect_values[0].v_pointer;
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4727 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4731 "book.c"
		}
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = pdf_writer_ref (object);
#line 4735 "book.c"
	} else {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4739 "book.c"
	}
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return NULL;
#line 4743 "book.c"
}


static gchar* value_pdf_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PDFWriter** object_p;
	object_p = collect_values[0].v_pointer;
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (!object_p) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4754 "book.c"
	}
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		*object_p = NULL;
#line 4760 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 4764 "book.c"
	} else {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		*object_p = pdf_writer_ref (value->data[0].v_pointer);
#line 4768 "book.c"
	}
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return NULL;
#line 4772 "book.c"
}


GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPDFWriter* spec;
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PDF_WRITER), NULL);
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 4786 "book.c"
}


gpointer value_get_pdf_writer (const GValue* value) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER), NULL);
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return value->data[0].v_pointer;
#line 4795 "book.c"
}


void value_set_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	old = value->data[0].v_pointer;
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (v_object) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		pdf_writer_ref (value->data[0].v_pointer);
#line 4815 "book.c"
	} else {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4819 "book.c"
	}
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (old) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		pdf_writer_unref (old);
#line 4825 "book.c"
	}
}


void value_take_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	old = value->data[0].v_pointer;
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (v_object) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 4844 "book.c"
	} else {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4848 "book.c"
	}
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (old) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		pdf_writer_unref (old);
#line 4854 "book.c"
	}
}


static void pdf_writer_class_init (PDFWriterClass * klass) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	pdf_writer_parent_class = g_type_class_peek_parent (klass);
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	((PDFWriterClass *) klass)->finalize = pdf_writer_finalize;
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_type_class_add_private (klass, sizeof (PDFWriterPrivate));
#line 4866 "book.c"
}


static void pdf_writer_instance_init (PDFWriter * self) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->priv = PDF_WRITER_GET_PRIVATE (self);
#line 530 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->offset = (gsize) 0;
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->ref_count = 1;
#line 4877 "book.c"
}


static void pdf_writer_finalize (PDFWriter* obj) {
	PDFWriter * self;
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PDF_WRITER, PDFWriter);
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_handlers_destroy (self);
#line 531 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_list_free0 (self->object_offsets);
#line 532 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_object_unref0 (self->priv->stream);
#line 4891 "book.c"
}


GType pdf_writer_get_type (void) {
	static volatile gsize pdf_writer_type_id__volatile = 0;
	if (g_once_init_enter (&pdf_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pdf_writer_init, value_pdf_writer_free_value, value_pdf_writer_copy_value, value_pdf_writer_peek_pointer, "p", value_pdf_writer_collect_value, "p", value_pdf_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PDFWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdf_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PDFWriter), 0, (GInstanceInitFunc) pdf_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pdf_writer_type_id;
		pdf_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PDFWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pdf_writer_type_id__volatile, pdf_writer_type_id);
	}
	return pdf_writer_type_id__volatile;
}


gpointer pdf_writer_ref (gpointer instance) {
	PDFWriter* self;
	self = instance;
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return instance;
#line 4916 "book.c"
}


void pdf_writer_unref (gpointer instance) {
	PDFWriter* self;
	self = instance;
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		PDF_WRITER_GET_CLASS (self)->finalize (self);
#line 528 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4929 "book.c"
	}
}


static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1) {
	cairo_status_t result;
	result = ps_writer_write_cairo_data ((PsWriter*) self, data, data_length1);
#line 572 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return result;
#line 4939 "book.c"
}


PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream) {
	PsWriter* self = NULL;
	GFileOutputStream* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
#line 569 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 569 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self = (PsWriter*) g_type_create_instance (object_type);
#line 571 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp0_ = stream;
#line 571 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 571 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_object_unref0 (self->stream);
#line 571 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->stream = _tmp1_;
#line 572 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_tmp2_ = cairo_ps_surface_create_for_stream (_ps_writer_write_cairo_data_cairo_write_func_t, self, (gdouble) 0, (gdouble) 0);
#line 572 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_cairo_surface_destroy0 (self->surface);
#line 572 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->surface = _tmp2_;
#line 569 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return self;
#line 4968 "book.c"
}


PsWriter* ps_writer_new (GFileOutputStream* stream) {
#line 569 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return ps_writer_construct (TYPE_PS_WRITER, stream);
#line 4975 "book.c"
}


static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1) {
	cairo_status_t result = 0;
	GError * _inner_error_ = NULL;
#line 575 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 4984 "book.c"
	{
		GFileOutputStream* _tmp0_ = NULL;
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 579 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp0_ = self->stream;
#line 579 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp1_ = data;
#line 579 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp1__length1 = data_length1;
#line 579 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
#line 579 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4999 "book.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 577 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		e = _inner_error_;
#line 577 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_inner_error_ = NULL;
#line 583 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp2_ = e;
#line 583 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_tmp3_ = _tmp2_->message;
#line 583 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_warning ("book.vala:583: Error writing data: %s", _tmp3_);
#line 584 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		result = CAIRO_STATUS_WRITE_ERROR;
#line 584 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		_g_error_free0 (e);
#line 584 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		return result;
#line 5025 "book.c"
	}
	__finally2:
#line 577 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 577 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 577 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_clear_error (&_inner_error_);
#line 577 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		return 0;
#line 5036 "book.c"
	}
#line 587 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	result = CAIRO_STATUS_SUCCESS;
#line 587 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return result;
#line 5042 "book.c"
}


static void value_ps_writer_init (GValue* value) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 5049 "book.c"
}


static void value_ps_writer_free_value (GValue* value) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (value->data[0].v_pointer) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		ps_writer_unref (value->data[0].v_pointer);
#line 5058 "book.c"
	}
}


static void value_ps_writer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		dest_value->data[0].v_pointer = ps_writer_ref (src_value->data[0].v_pointer);
#line 5068 "book.c"
	} else {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5072 "book.c"
	}
}


static gpointer value_ps_writer_peek_pointer (const GValue* value) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return value->data[0].v_pointer;
#line 5080 "book.c"
}


static gchar* value_ps_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 5087 "book.c"
		PsWriter* object;
		object = collect_values[0].v_pointer;
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5094 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5098 "book.c"
		}
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = ps_writer_ref (object);
#line 5102 "book.c"
	} else {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5106 "book.c"
	}
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return NULL;
#line 5110 "book.c"
}


static gchar* value_ps_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PsWriter** object_p;
	object_p = collect_values[0].v_pointer;
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (!object_p) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5121 "book.c"
	}
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		*object_p = NULL;
#line 5127 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 5131 "book.c"
	} else {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		*object_p = ps_writer_ref (value->data[0].v_pointer);
#line 5135 "book.c"
	}
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return NULL;
#line 5139 "book.c"
}


GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPsWriter* spec;
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PS_WRITER), NULL);
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 5153 "book.c"
}


gpointer value_get_ps_writer (const GValue* value) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER), NULL);
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return value->data[0].v_pointer;
#line 5162 "book.c"
}


void value_set_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	old = value->data[0].v_pointer;
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (v_object) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		ps_writer_ref (value->data[0].v_pointer);
#line 5182 "book.c"
	} else {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5186 "book.c"
	}
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (old) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		ps_writer_unref (old);
#line 5192 "book.c"
	}
}


void value_take_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	old = value->data[0].v_pointer;
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (v_object) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 5211 "book.c"
	} else {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5215 "book.c"
	}
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (old) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		ps_writer_unref (old);
#line 5221 "book.c"
	}
}


static void ps_writer_class_init (PsWriterClass * klass) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	ps_writer_parent_class = g_type_class_peek_parent (klass);
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	((PsWriterClass *) klass)->finalize = ps_writer_finalize;
#line 5231 "book.c"
}


static void ps_writer_instance_init (PsWriter * self) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self->ref_count = 1;
#line 5238 "book.c"
}


static void ps_writer_finalize (PsWriter* obj) {
	PsWriter * self;
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PS_WRITER, PsWriter);
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_signal_handlers_destroy (self);
#line 566 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_cairo_surface_destroy0 (self->surface);
#line 567 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	_g_object_unref0 (self->stream);
#line 5252 "book.c"
}


GType ps_writer_get_type (void) {
	static volatile gsize ps_writer_type_id__volatile = 0;
	if (g_once_init_enter (&ps_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_ps_writer_init, value_ps_writer_free_value, value_ps_writer_copy_value, value_ps_writer_peek_pointer, "p", value_ps_writer_collect_value, "p", value_ps_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PsWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ps_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PsWriter), 0, (GInstanceInitFunc) ps_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType ps_writer_type_id;
		ps_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PsWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&ps_writer_type_id__volatile, ps_writer_type_id);
	}
	return ps_writer_type_id__volatile;
}


gpointer ps_writer_ref (gpointer instance) {
	PsWriter* self;
	self = instance;
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	return instance;
#line 5277 "book.c"
}


void ps_writer_unref (gpointer instance) {
	PsWriter* self;
	self = instance;
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		PS_WRITER_GET_CLASS (self)->finalize (self);
#line 564 "/home/bob/bzr/simple-scan/3.12/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5290 "book.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



