/* $Id: tstIEMAImplDataInt-Intel.cpp $ */
/** @file
 * IEM Assembly Instruction Helper Testcase Data Intel - r150722 on Intel(R) Core(TM) i9-10980XE CPU @ 3.00GHz.
 */

/*
 * Copyright (C) 2022-2023 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#include "tstIEMAImpl.h"

BINU16_TEST_T const g_aTests_bsf_u16_intel[] =
{
    { 0x0e4817, 0x0e4046, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x297656, 0x297646, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x381f46, 0x381746, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x2d1fc6, 0x2d1746, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x1d2cc2, 0x1d2446, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x1b32c3, 0x1b3246, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x106d57, 0x106546, 0xdad5, 0xdad5, 0x0000, 0x0 }, /* #6 */
    { 0x3f4153, 0x3f4146, 0xb38e, 0xb38e, 0x0000, 0x0 }, /* #7 */
    { 0x2971c6, 0x297146, 0x40cc, 0x40cc, 0x0000, 0x0 }, /* #8 */
    { 0x022fd2, 0x022746, 0xaa4e, 0xaa4e, 0x0000, 0x0 }, /* #9 */
    { 0x254c92, 0x254446, 0x03cb, 0x03cb, 0x0000, 0x0 }, /* #10 */
    { 0x074b42, 0x074346, 0xf0b5, 0xf0b5, 0x0000, 0x0 }, /* #11 */
    { 0x3d0c92, 0x3d0402, 0x8048, 0x0002, 0xb7b4, 0x0 }, /* #12 */
    { 0x117d53, 0x117506, 0x5ca8, 0x0000, 0x97a7, 0x0 }, /* #13 */
    { 0x120306, 0x120306, 0x473b, 0x0000, 0x6b29, 0x0 }, /* #14 */
    { 0x1c7782, 0x1c7706, 0x69ae, 0x0000, 0x35e5, 0x0 }, /* #15 */
    { 0x183ac7, 0x183206, 0x0960, 0x0000, 0x160f, 0x0 }, /* #16 */
    { 0x354cd7, 0x354402, 0xae07, 0x0001, 0xb602, 0x0 }, /* #17 */
    { 0x264702, 0x264706, 0xa4fb, 0x0000, 0xc545, 0x0 }, /* #18 */
    { 0x3c4182, 0x3c4106, 0x2986, 0x0000, 0xb4a9, 0x0 }, /* #19 */
    { 0x335203, 0x335202, 0x9cfc, 0x0001, 0x411a, 0x0 }, /* #20 */
    { 0x390d53, 0x390502, 0x0530, 0x0001, 0x57e6, 0x0 }, /* #21 */
    { 0x1a6607, 0x1a6602, 0x69bb, 0x0004, 0x9e50, 0x0 }, /* #22 */
    { 0x3a0713, 0x3a0702, 0x5ed3, 0x0001, 0xd226, 0x0 }, /* #23 */
    { 0x1a1897, 0x1a1006, 0xe916, 0x0000, 0x2fe1, 0x0 }, /* #24 */
    { 0x0c7d16, 0x0c7506, 0x41f8, 0x0000, 0x70cb, 0x0 }, /* #25 */
    { 0x214e57, 0x214606, 0xf79e, 0x0000, 0x7f1f, 0x0 }, /* #26 */
    { 0x1b3f56, 0x1b3706, 0x3f36, 0x0000, 0x28d5, 0x0 }, /* #27 */
    { 0x3f2686, 0x3f2606, 0x3671, 0x0000, 0x76d1, 0x0 }, /* #28 */
    { 0x062253, 0x062206, 0xd6ec, 0x0000, 0x0157, 0x0 }, /* #29 */
    { 0x380957, 0x380106, 0xeffa, 0x0000, 0x723d, 0x0 }, /* #30 */
    { 0x3302d6, 0x330202, 0x33f5, 0x0001, 0xa032, 0x0 }, /* #31 */
    { 0x141d46, 0x141502, 0xe731, 0x0002, 0xf254, 0x0 }, /* #32 */
    { 0x2d7dc6, 0x2d7506, 0xca8b, 0x0000, 0xa08d, 0x0 }, /* #33 */
    { 0x182b97, 0x182306, 0xd218, 0x0003, 0x0ca8, 0x0 }, /* #34 */
    { 0x200193, 0x200106, 0x5f12, 0x0000, 0x40d5, 0x0 }, /* #35 */
    { 0x2922c6, 0x292202, 0xb39a, 0x0001, 0x3f72, 0x0 }, /* #36 */
    { 0x1621c6, 0x162102, 0x6379, 0x0001, 0xf672, 0x0 }, /* #37 */
    { 0x2d3d93, 0x2d3502, 0xcdb0, 0x0001, 0x9092, 0x0 }, /* #38 */
    { 0x3c0606, 0x3c0602, 0x2230, 0x0001, 0x67e2, 0x0 }, /* #39 */
    { 0x142fc3, 0x142702, 0x351c, 0x0002, 0xb72c, 0x0 }, /* #40 */
    { 0x0a7742, 0x0a7706, 0xf1b9, 0x0000, 0xcf69, 0x0 }, /* #41 */
    { 0x1e5547, 0x1e5502, 0x66e6, 0x0001, 0xfc6e, 0x0 }, /* #42 */
    { 0x226a57, 0x226202, 0xab96, 0x0001, 0xa0ba, 0x0 }, /* #43 */
    { 0x3b6342, 0x3b6306, 0x9a09, 0x0000, 0x7b6b, 0x0 }, /* #44 */
    { 0x346942, 0x346106, 0x033b, 0x0000, 0x2e39, 0x0 }, /* #45 */
    { 0x153157, 0x153106, 0x2667, 0x0003, 0xaf08, 0x0 }, /* #46 */
    { 0x1f0b02, 0x1f0306, 0xf683, 0x0000, 0x78db, 0x0 }, /* #47 */
    { 0x190117, 0x190102, 0x9997, 0x0002, 0x7e04, 0x0 }, /* #48 */
    { 0x013182, 0x013106, 0xba11, 0x0000, 0x2a49, 0x0 }, /* #49 */
    { 0x3d2ad7, 0x3d2206, 0xebe6, 0x0000, 0x25cf, 0x0 }, /* #50 */
    { 0x313142, 0x313102, 0x26f5, 0x0001, 0x8fb2, 0x0 }, /* #51 */
    { 0x357c83, 0x357402, 0x463b, 0x0001, 0x2a36, 0x0 }, /* #52 */
    { 0x367b53, 0x367302, 0xd605, 0x0002, 0x54fc, 0x0 }, /* #53 */
    { 0x0c77d7, 0x0c7702, 0x98c7, 0x0001, 0x2bf6, 0x0 }, /* #54 */
    { 0x0a7602, 0x0a7606, 0x6cca, 0x0000, 0x1b7d, 0x0 }, /* #55 */
    { 0x186097, 0x186002, 0xc677, 0x0001, 0x7e86, 0x0 }, /* #56 */
    { 0x1a1456, 0x1a1406, 0x5151, 0x0000, 0xdb1d, 0x0 }, /* #57 */
    { 0x0b0943, 0x0b0106, 0x573b, 0x0000, 0xd587, 0x0 }, /* #58 */
    { 0x252586, 0x252506, 0x448e, 0x0000, 0x3dad, 0x0 }, /* #59 */
    { 0x333612, 0x333606, 0x07f7, 0x0000, 0x4cfd, 0x0 }, /* #60 */
    { 0x146ad7, 0x146206, 0x4c24, 0x0006, 0x26c0, 0x0 }, /* #61 */
    { 0x3e7b92, 0x3e7302, 0xe5d6, 0x0002, 0x8df4, 0x0 }, /* #62 */
    { 0x0f1f02, 0x0f1702, 0x1bb4, 0x0001, 0x185e, 0x0 }, /* #63 */
    { 0x3219c3, 0x321106, 0xae30, 0x0000, 0x6ab5, 0x0 }, /* #64 */
    { 0x110f83, 0x110702, 0xee3a, 0x0001, 0xdc5e, 0x0 }, /* #65 */
    { 0x2f5116, 0x2f5106, 0xc7ed, 0x0000, 0xaf93, 0x0 }, /* #66 */
    { 0x274fd6, 0x274706, 0x6fc6, 0x0003, 0x6c28, 0x0 }, /* #67 */
    { 0x0a6a12, 0x0a6206, 0x06c7, 0x0000, 0xa347, 0x0 }, /* #68 */
    { 0x1c37c2, 0x1c3702, 0xa2c8, 0x0002, 0xc274, 0x0 }, /* #69 */
    { 0x151807, 0x151002, 0x605e, 0x0001, 0x458e, 0x0 }, /* #70 */
    { 0x2e1797, 0x2e1702, 0xd04b, 0x0001, 0xe70e, 0x0 }, /* #71 */
    { 0x2e1713, 0x2e1702, 0x8632, 0x0001, 0x2a12, 0x0 }, /* #72 */
    { 0x382847, 0x382006, 0xdde9, 0x0000, 0xb9b1, 0x0 }, /* #73 */
    { 0x244807, 0x244006, 0xfaab, 0x0000, 0x7e17, 0x0 }, /* #74 */
    { 0x2262c2, 0x226206, 0xcaa0, 0x0000, 0x46df, 0x0 }, /* #75 */
    { 0x273516, 0x273506, 0x306e, 0x0000, 0x4791, 0x0 }, /* #76 */
    { 0x1065c7, 0x106502, 0x4ac8, 0x0001, 0x95ee, 0x0 }, /* #77 */
    { 0x360797, 0x360706, 0x4c89, 0x0003, 0x7a08, 0x0 }, /* #78 */
    { 0x264d86, 0x264506, 0x0fef, 0x0000, 0xb7a7, 0x0 }, /* #79 */
    { 0x150702, 0x150702, 0x6561, 0x0004, 0x5690, 0x0 }, /* #80 */
    { 0x107217, 0x107206, 0x08b2, 0x0000, 0xa87d, 0x0 }, /* #81 */
    { 0x2832c6, 0x283206, 0x896d, 0x0005, 0xa1a0, 0x0 }, /* #82 */
    { 0x0c10d7, 0x0c1006, 0x9fad, 0x0000, 0x4497, 0x0 }, /* #83 */
    { 0x0e2492, 0x0e2406, 0x218c, 0x0000, 0x17b1, 0x0 }, /* #84 */
    { 0x280c06, 0x280406, 0x9dd1, 0x0000, 0x45b9, 0x0 }, /* #85 */
    { 0x3b00d2, 0x3b0006, 0xb74e, 0x0000, 0x8ebf, 0x0 }, /* #86 */
    { 0x195093, 0x195006, 0xa0ad, 0x0000, 0x4703, 0x0 }, /* #87 */
    { 0x111752, 0x111702, 0x41f3, 0x0002, 0xafcc, 0x0 }, /* #88 */
    { 0x253947, 0x253106, 0x0e8b, 0x0000, 0xc2c7, 0x0 }, /* #89 */
    { 0x0c5303, 0x0c5302, 0x6c73, 0x0002, 0xf1d4, 0x0 }, /* #90 */
    { 0x225306, 0x225306, 0x3533, 0x0003, 0x2508, 0x0 }, /* #91 */
    { 0x3d2d97, 0x3d2502, 0x2c12, 0x0001, 0xa1aa, 0x0 }, /* #92 */
    { 0x072397, 0x072306, 0x4d8a, 0x0000, 0x4b79, 0x0 }, /* #93 */
    { 0x123442, 0x123406, 0xf7b6, 0x0003, 0xced8, 0x0 }, /* #94 */
    { 0x0e5313, 0x0e5306, 0x6451, 0x0000, 0x5de3, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bsf_u16_intel = RT_ELEMENTS(g_aTests_bsf_u16_intel);

BINU16_TEST_T const g_aTests_bsr_u16_intel[] =
{
    { 0x3a79d3, 0x3a7146, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x352d93, 0x352546, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x205046, 0x205046, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x1c2806, 0x1c2046, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x086216, 0x086246, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x1e0296, 0x1e0246, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x122802, 0x122046, 0x2dbb, 0x2dbb, 0x0000, 0x0 }, /* #6 */
    { 0x234b83, 0x234346, 0x6ecb, 0x6ecb, 0x0000, 0x0 }, /* #7 */
    { 0x2050c6, 0x205046, 0x862a, 0x862a, 0x0000, 0x0 }, /* #8 */
    { 0x136157, 0x136146, 0x87ee, 0x87ee, 0x0000, 0x0 }, /* #9 */
    { 0x024606, 0x024646, 0x46e9, 0x46e9, 0x0000, 0x0 }, /* #10 */
    { 0x1e3f43, 0x1e3746, 0x71fb, 0x71fb, 0x0000, 0x0 }, /* #11 */
    { 0x2361d3, 0x236102, 0x7551, 0x000d, 0x2863, 0x0 }, /* #12 */
    { 0x1e5487, 0x1e5402, 0x01d1, 0x000d, 0x3d0c, 0x0 }, /* #13 */
    { 0x283706, 0x283706, 0x4901, 0x000c, 0x1246, 0x0 }, /* #14 */
    { 0x015846, 0x015006, 0x9ed4, 0x000f, 0xa036, 0x0 }, /* #15 */
    { 0x282112, 0x282106, 0x0635, 0x000f, 0xf9a1, 0x0 }, /* #16 */
    { 0x304f46, 0x304706, 0x11c1, 0x000f, 0xdebb, 0x0 }, /* #17 */
    { 0x3c5a86, 0x3c5206, 0x4ddd, 0x000f, 0xf085, 0x0 }, /* #18 */
    { 0x146756, 0x146706, 0x0e48, 0x000f, 0x9ea2, 0x0 }, /* #19 */
    { 0x361d52, 0x361502, 0xf4c9, 0x000e, 0x4dd6, 0x0 }, /* #20 */
    { 0x353f87, 0x353706, 0x933e, 0x000f, 0xd3e8, 0x0 }, /* #21 */
    { 0x036282, 0x036202, 0x08d8, 0x000e, 0x601e, 0x0 }, /* #22 */
    { 0x0b1e42, 0x0b1606, 0x1f66, 0x000f, 0xa69b, 0x0 }, /* #23 */
    { 0x040c53, 0x040406, 0x4ed1, 0x000f, 0xdd30, 0x0 }, /* #24 */
    { 0x146513, 0x146502, 0x16b2, 0x000e, 0x5f06, 0x0 }, /* #25 */
    { 0x200217, 0x200206, 0xfc46, 0x000f, 0xa434, 0x0 }, /* #26 */
    { 0x106bc7, 0x106302, 0xa5dd, 0x000e, 0x5167, 0x0 }, /* #27 */
    { 0x3913c3, 0x391306, 0x47f4, 0x000c, 0x1650, 0x0 }, /* #28 */
    { 0x1c6c53, 0x1c6406, 0xc8ca, 0x000f, 0xac4f, 0x0 }, /* #29 */
    { 0x1236d6, 0x123602, 0xafee, 0x000e, 0x6cce, 0x0 }, /* #30 */
    { 0x277b43, 0x277306, 0x684d, 0x000f, 0xcae3, 0x0 }, /* #31 */
    { 0x281492, 0x281406, 0x5223, 0x000f, 0xb296, 0x0 }, /* #32 */
    { 0x3c7213, 0x3c7202, 0x6ffd, 0x000e, 0x51d4, 0x0 }, /* #33 */
    { 0x3419c2, 0x341102, 0x4aeb, 0x000e, 0x424c, 0x0 }, /* #34 */
    { 0x2d3c96, 0x2d3406, 0x12b2, 0x000f, 0xf1ea, 0x0 }, /* #35 */
    { 0x0f44c2, 0x0f4406, 0x700b, 0x000f, 0xdb3c, 0x0 }, /* #36 */
    { 0x1f33c6, 0x1f3302, 0x483c, 0x000b, 0x0f45, 0x0 }, /* #37 */
    { 0x346897, 0x346006, 0x394d, 0x000f, 0xab97, 0x0 }, /* #38 */
    { 0x1223c2, 0x122302, 0xa603, 0x000e, 0x5d3d, 0x0 }, /* #39 */
    { 0x041213, 0x041206, 0x4210, 0x000f, 0xa733, 0x0 }, /* #40 */
    { 0x313a93, 0x313202, 0xa255, 0x0008, 0x01ab, 0x0 }, /* #41 */
    { 0x303253, 0x303202, 0xa954, 0x000d, 0x2a1e, 0x0 }, /* #42 */
    { 0x0c0552, 0x0c0506, 0x2b7c, 0x000f, 0xc4dd, 0x0 }, /* #43 */
    { 0x0a5f82, 0x0a5706, 0x39a2, 0x000f, 0xc0d8, 0x0 }, /* #44 */
    { 0x330297, 0x330206, 0xa7ae, 0x000f, 0xd45e, 0x0 }, /* #45 */
    { 0x137d13, 0x137506, 0x0756, 0x000a, 0x0431, 0x0 }, /* #46 */
    { 0x356056, 0x356002, 0x508d, 0x000e, 0x783c, 0x0 }, /* #47 */
    { 0x066686, 0x066602, 0x61c8, 0x000e, 0x7225, 0x0 }, /* #48 */
    { 0x3d0ed3, 0x3d0602, 0x9f4b, 0x000e, 0x4e6a, 0x0 }, /* #49 */
    { 0x1875d3, 0x187506, 0xd0d7, 0x000f, 0xcf88, 0x0 }, /* #50 */
    { 0x0e7987, 0x0e7106, 0x1834, 0x000f, 0x8968, 0x0 }, /* #51 */
    { 0x0b2783, 0x0b2702, 0xcecf, 0x000e, 0x6c35, 0x0 }, /* #52 */
    { 0x0b76d2, 0x0b7602, 0xe2a8, 0x000d, 0x2e55, 0x0 }, /* #53 */
    { 0x221d83, 0x221502, 0xa9cb, 0x000e, 0x67ac, 0x0 }, /* #54 */
    { 0x2e29d3, 0x2e2102, 0xed9e, 0x000d, 0x244b, 0x0 }, /* #55 */
    { 0x270957, 0x270106, 0x1285, 0x000c, 0x17f9, 0x0 }, /* #56 */
    { 0x373047, 0x373006, 0xd79c, 0x000f, 0xeea1, 0x0 }, /* #57 */
    { 0x266a42, 0x266202, 0x2a6c, 0x000e, 0x4d63, 0x0 }, /* #58 */
    { 0x2b3e86, 0x2b3602, 0xc9a3, 0x000e, 0x64c6, 0x0 }, /* #59 */
    { 0x326e07, 0x326602, 0xc66e, 0x000e, 0x6369, 0x0 }, /* #60 */
    { 0x023cd7, 0x023406, 0xb355, 0x000f, 0xc5ef, 0x0 }, /* #61 */
    { 0x003392, 0x003306, 0x1ae4, 0x000f, 0xd794, 0x0 }, /* #62 */
    { 0x221d03, 0x221502, 0xcef7, 0x000e, 0x5357, 0x0 }, /* #63 */
    { 0x184fc3, 0x184706, 0xfff2, 0x000f, 0xd375, 0x0 }, /* #64 */
    { 0x3f3992, 0x3f3106, 0x36b5, 0x000f, 0xe5fc, 0x0 }, /* #65 */
    { 0x3e2983, 0x3e2102, 0xe778, 0x000d, 0x3b47, 0x0 }, /* #66 */
    { 0x3d5993, 0x3d5106, 0x4aec, 0x000f, 0xcbc1, 0x0 }, /* #67 */
    { 0x254416, 0x254406, 0xd24e, 0x000f, 0xb50b, 0x0 }, /* #68 */
    { 0x2c7403, 0x2c7406, 0x1c3e, 0x000f, 0x8207, 0x0 }, /* #69 */
    { 0x1c7b46, 0x1c7302, 0x2761, 0x000e, 0x7654, 0x0 }, /* #70 */
    { 0x292056, 0x292002, 0xf88f, 0x000d, 0x27cf, 0x0 }, /* #71 */
    { 0x186f92, 0x186702, 0x65ad, 0x000e, 0x784f, 0x0 }, /* #72 */
    { 0x113852, 0x113002, 0x639c, 0x000e, 0x6bfe, 0x0 }, /* #73 */
    { 0x292842, 0x292002, 0xc6b8, 0x000e, 0x5e6a, 0x0 }, /* #74 */
    { 0x117852, 0x117002, 0xd9b2, 0x000d, 0x3e5f, 0x0 }, /* #75 */
    { 0x3b7d17, 0x3b7506, 0x110c, 0x000f, 0x9f18, 0x0 }, /* #76 */
    { 0x095892, 0x095006, 0xe0e3, 0x000f, 0xbfd9, 0x0 }, /* #77 */
    { 0x366bc6, 0x366302, 0xb4fb, 0x000e, 0x64e0, 0x0 }, /* #78 */
    { 0x384196, 0x384106, 0xfc69, 0x000f, 0xe336, 0x0 }, /* #79 */
    { 0x062e43, 0x062606, 0x65ea, 0x000f, 0xf857, 0x0 }, /* #80 */
    { 0x1204c7, 0x120406, 0x6978, 0x000f, 0xf267, 0x0 }, /* #81 */
    { 0x1c58d7, 0x1c5002, 0x71ca, 0x000e, 0x6040, 0x0 }, /* #82 */
    { 0x1c19d6, 0x1c1102, 0x3279, 0x000d, 0x38f5, 0x0 }, /* #83 */
    { 0x2377d3, 0x237706, 0x3a27, 0x000f, 0xf80e, 0x0 }, /* #84 */
    { 0x1a7652, 0x1a7606, 0xbb2b, 0x000f, 0xb6fd, 0x0 }, /* #85 */
    { 0x252616, 0x252602, 0xcc1a, 0x000e, 0x79cb, 0x0 }, /* #86 */
    { 0x257d97, 0x257502, 0x2e27, 0x000e, 0x7e9f, 0x0 }, /* #87 */
    { 0x321742, 0x321702, 0x187f, 0x000e, 0x617b, 0x0 }, /* #88 */
    { 0x3e6a82, 0x3e6202, 0xfbc3, 0x000e, 0x4b01, 0x0 }, /* #89 */
    { 0x320e96, 0x320606, 0x586a, 0x000f, 0xb3d4, 0x0 }, /* #90 */
    { 0x263386, 0x263302, 0x5815, 0x000e, 0x7a3e, 0x0 }, /* #91 */
    { 0x0e1c56, 0x0e1406, 0x7d72, 0x000f, 0xa441, 0x0 }, /* #92 */
    { 0x231e93, 0x231602, 0x6791, 0x000b, 0x0bff, 0x0 }, /* #93 */
    { 0x3d6646, 0x3d6602, 0x82fa, 0x000d, 0x330a, 0x0 }, /* #94 */
    { 0x2f1a07, 0x2f1202, 0xfd60, 0x000e, 0x5dbf, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bsr_u16_intel = RT_ELEMENTS(g_aTests_bsr_u16_intel);

BINU16_TEST_T const g_aTests_imul_two_u16_intel[] =
{
    { 0x2f6412, 0x2f6406, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x347f47, 0x347706, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x1a3bd7, 0x1a3306, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x196d52, 0x196506, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x115893, 0x115006, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x014c83, 0x014406, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x0c57c6, 0x0c5706, 0x32d4, 0x0000, 0x0000, 0x0 }, /* #6 */
    { 0x3d6f42, 0x3d6706, 0x3afd, 0x0000, 0x0000, 0x0 }, /* #7 */
    { 0x171a83, 0x171206, 0xece2, 0x0000, 0x0000, 0x0 }, /* #8 */
    { 0x1a1547, 0x1a1506, 0x1352, 0x0000, 0x0000, 0x0 }, /* #9 */
    { 0x0c5cd2, 0x0c5406, 0x0d46, 0x0000, 0x0000, 0x0 }, /* #10 */
    { 0x3e4242, 0x3e4206, 0xe89f, 0x0000, 0x0000, 0x0 }, /* #11 */
    { 0x1b6957, 0x1b6987, 0x01cc, 0x8ad4, 0x4e37, 0x0 }, /* #12 */
    { 0x164942, 0x164987, 0x6cc5, 0xb7ee, 0xd316, 0x0 }, /* #13 */
    { 0x061ed2, 0x061e83, 0xf8b4, 0xb908, 0xd28a, 0x0 }, /* #14 */
    { 0x043e16, 0x043e07, 0xc584, 0x64d4, 0x3455, 0x0 }, /* #15 */
    { 0x020f03, 0x020f87, 0xdaf7, 0xebbb, 0xa05d, 0x0 }, /* #16 */
    { 0x0121c6, 0x012983, 0x1824, 0xaf2c, 0x3833, 0x0 }, /* #17 */
    { 0x0e2ec3, 0x0e2e87, 0x8103, 0xd581, 0x0e2b, 0x0 }, /* #18 */
    { 0x0e53d6, 0x0e5b83, 0xfd92, 0xc75e, 0xb2b7, 0x0 }, /* #19 */
    { 0x151943, 0x151903, 0x81a3, 0x7708, 0xed58, 0x0 }, /* #20 */
    { 0x072cc3, 0x072c07, 0xbb1f, 0x4db7, 0xb269, 0x0 }, /* #21 */
    { 0x005353, 0x005b83, 0xfecf, 0xd5b9, 0x44f7, 0x0 }, /* #22 */
    { 0x094943, 0x094907, 0xe59e, 0x5ad8, 0x46d4, 0x0 }, /* #23 */
    { 0x2d5246, 0x2d5a07, 0x9c10, 0x1600, 0x3960, 0x0 }, /* #24 */
    { 0x194016, 0x194883, 0xe1c9, 0xf37c, 0xf59c, 0x0 }, /* #25 */
    { 0x117a03, 0x117a87, 0xfdf8, 0x8ee8, 0x7563, 0x0 }, /* #26 */
    { 0x390b82, 0x390b83, 0x318e, 0xf16e, 0x1091, 0x0 }, /* #27 */
    { 0x052697, 0x052e07, 0x40d4, 0x7824, 0xb905, 0x0 }, /* #28 */
    { 0x283743, 0x283f87, 0x5489, 0x9833, 0x4fdb, 0x0 }, /* #29 */
    { 0x1038c7, 0x103807, 0x072a, 0x6c72, 0x7f15, 0x0 }, /* #30 */
    { 0x033406, 0x033c03, 0x23bd, 0x7e38, 0xbe98, 0x0 }, /* #31 */
    { 0x204156, 0x204983, 0xf43b, 0xcb8f, 0xb4bd, 0x0 }, /* #32 */
    { 0x1a4852, 0x1a4887, 0x08aa, 0x89d4, 0x8b42, 0x0 }, /* #33 */
    { 0x092613, 0x092e87, 0x03b0, 0xc6a0, 0x289e, 0x0 }, /* #34 */
    { 0x240403, 0x240c03, 0xfae4, 0x5f34, 0xb7b5, 0x0 }, /* #35 */
    { 0x302a86, 0x302a83, 0x60aa, 0xfadc, 0x1db6, 0x0 }, /* #36 */
    { 0x2b1bc7, 0x2b1b87, 0xdda7, 0x8a78, 0xa0c8, 0x0 }, /* #37 */
    { 0x1a3486, 0x1a3c87, 0x0a27, 0xed1e, 0xf2b2, 0x0 }, /* #38 */
    { 0x3a6996, 0x3a6987, 0xfed2, 0xe21e, 0xd5b7, 0x0 }, /* #39 */
    { 0x003046, 0x003883, 0x2ebb, 0xff2a, 0x5bde, 0x0 }, /* #40 */
    { 0x365793, 0x365f07, 0x5852, 0x6ed2, 0x9941, 0x0 }, /* #41 */
    { 0x1d5b83, 0x1d5b87, 0x2bd1, 0xa0c9, 0xfb79, 0x0 }, /* #42 */
    { 0x1f5e57, 0x1f5e07, 0x8be9, 0x7fe7, 0xdb4f, 0x0 }, /* #43 */
    { 0x1e4242, 0x1e4a07, 0xc15d, 0x7078, 0xd2d8, 0x0 }, /* #44 */
    { 0x1e1506, 0x1e1d07, 0xc728, 0x0cc0, 0xd9b8, 0x0 }, /* #45 */
    { 0x030e17, 0x030e03, 0x03b4, 0x4508, 0x680a, 0x0 }, /* #46 */
    { 0x3b6ed2, 0x3b6e03, 0x8853, 0x14c4, 0xefac, 0x0 }, /* #47 */
    { 0x2b2e03, 0x2b2e03, 0xee4b, 0x47b0, 0x4910, 0x0 }, /* #48 */
    { 0x300953, 0x300983, 0xccd3, 0xd2c1, 0x959b, 0x0 }, /* #49 */
    { 0x115482, 0x115c87, 0x84f9, 0x8ebe, 0x7a2e, 0x0 }, /* #50 */
    { 0x090982, 0x090903, 0x47e5, 0x3a79, 0x5705, 0x0 }, /* #51 */
    { 0x3f1a87, 0x3f1a03, 0x71be, 0x5e04, 0x373e, 0x0 }, /* #52 */
    { 0x083c46, 0x083c83, 0x6b4f, 0x96a4, 0x061c, 0x0 }, /* #53 */
    { 0x3f1ac7, 0x3f1a83, 0xccab, 0xd052, 0x6cf6, 0x0 }, /* #54 */
    { 0x3644c7, 0x364c07, 0xb1d3, 0x1069, 0x5353, 0x0 }, /* #55 */
    { 0x393587, 0x393d07, 0x365f, 0x167e, 0x2e42, 0x0 }, /* #56 */
    { 0x3b4346, 0x3b4b87, 0xf862, 0xc256, 0x481b, 0x0 }, /* #57 */
    { 0x1d3c57, 0x1d3c87, 0x5b06, 0xfe06, 0xb081, 0x0 }, /* #58 */
    { 0x214292, 0x214a03, 0xb5be, 0x14a2, 0xf0cf, 0x0 }, /* #59 */
    { 0x2269d3, 0x226907, 0x8193, 0x7024, 0x75cc, 0x0 }, /* #60 */
    { 0x2e0903, 0x2e0903, 0xe9f1, 0x4e83, 0x6bb3, 0x0 }, /* #61 */
    { 0x0643d2, 0x064b03, 0xa875, 0x4d91, 0xcd2d, 0x0 }, /* #62 */
    { 0x057f46, 0x057f87, 0xfc4e, 0xb87e, 0x1829, 0x0 }, /* #63 */
    { 0x0a55c7, 0x0a5d07, 0xb663, 0x606a, 0x2d0e, 0x0 }, /* #64 */
    { 0x175247, 0x175a83, 0xf611, 0xcf19, 0x2089, 0x0 }, /* #65 */
    { 0x1d1c56, 0x1d1c87, 0xc239, 0xc60a, 0x6e5a, 0x0 }, /* #66 */
    { 0x174c56, 0x174c03, 0xd252, 0x4f52, 0x1a81, 0x0 }, /* #67 */
    { 0x186106, 0x186903, 0x64c9, 0x0c61, 0xaed9, 0x0 }, /* #68 */
    { 0x136612, 0x136e07, 0x7656, 0x7db8, 0x9e94, 0x0 }, /* #69 */
    { 0x105606, 0x105e83, 0x0a69, 0xe3c8, 0xfc88, 0x0 }, /* #70 */
    { 0x1845d2, 0x184d07, 0x7010, 0x2f90, 0xd3f9, 0x0 }, /* #71 */
    { 0x191593, 0x191d03, 0x8d3b, 0x43e3, 0x5979, 0x0 }, /* #72 */
    { 0x330453, 0x330c87, 0xb8eb, 0xc024, 0xf76c, 0x0 }, /* #73 */
    { 0x002283, 0x002a83, 0xec9a, 0xba04, 0xb60a, 0x0 }, /* #74 */
    { 0x1f5b87, 0x1f5b07, 0x692f, 0x2f8d, 0x4c03, 0x0 }, /* #75 */
    { 0x000783, 0x000f03, 0xd042, 0x2ea2, 0x0931, 0x0 }, /* #76 */
    { 0x3d2493, 0x3d2c87, 0x391c, 0xd974, 0xb43b, 0x0 }, /* #77 */
    { 0x047fc7, 0x047f87, 0xe476, 0xdb96, 0xa9b1, 0x0 }, /* #78 */
    { 0x294103, 0x294903, 0x3ae1, 0x69ce, 0xe18e, 0x0 }, /* #79 */
    { 0x3962d6, 0x396a03, 0xe02b, 0x18ef, 0x044d, 0x0 }, /* #80 */
    { 0x164842, 0x164883, 0x1786, 0xc62a, 0xe047, 0x0 }, /* #81 */
    { 0x206b57, 0x206b07, 0x8efe, 0x26ee, 0x7009, 0x0 }, /* #82 */
    { 0x1167c6, 0x116f87, 0x9ecf, 0xd44d, 0x8223, 0x0 }, /* #83 */
    { 0x350ad7, 0x350a03, 0x851d, 0x754c, 0x44bc, 0x0 }, /* #84 */
    { 0x244843, 0x244807, 0x718c, 0x1e90, 0xb10c, 0x0 }, /* #85 */
    { 0x1b3dd6, 0x1b3d07, 0x0c58, 0x0fa0, 0xbc5c, 0x0 }, /* #86 */
    { 0x1241d6, 0x124987, 0x9ca5, 0xb393, 0x81d7, 0x0 }, /* #87 */
    { 0x0c6fd3, 0x0c6f03, 0xf865, 0x05b3, 0x8837, 0x0 }, /* #88 */
    { 0x366612, 0x366e87, 0xd478, 0x8ae8, 0xdb53, 0x0 }, /* #89 */
    { 0x394a16, 0x394a03, 0x6e0f, 0x066b, 0x3de5, 0x0 }, /* #90 */
    { 0x064913, 0x064907, 0x1304, 0x64e8, 0xe5ba, 0x0 }, /* #91 */
    { 0x172a87, 0x172a03, 0x9e5c, 0x7ec8, 0xa41e, 0x0 }, /* #92 */
    { 0x086797, 0x086f07, 0x049c, 0x7474, 0x521b, 0x0 }, /* #93 */
    { 0x325602, 0x325e83, 0xd08a, 0xb326, 0x33f7, 0x0 }, /* #94 */
    { 0x3a4d82, 0x3a4d83, 0x0590, 0xf2d0, 0xeaf5, 0x0 }, /* #95 */
};
uint32_t const g_cTests_imul_two_u16_intel = RT_ELEMENTS(g_aTests_imul_two_u16_intel);

BINU32_TEST_T const g_aTests_bsf_u32_intel[] =
{
    { 0x0d6152, 0x0d6146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x287102, 0x287146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x042b46, 0x042346, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x1a5486, 0x1a5446, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x1f1492, 0x1f1446, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x141ec6, 0x141646, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x355787, 0x355746, 0x215f9e98, 0x215f9e98, 0x00000000, 0x0 }, /* #6 */
    { 0x317083, 0x317046, 0xa9eb2305, 0xa9eb2305, 0x00000000, 0x0 }, /* #7 */
    { 0x192f43, 0x192746, 0xba6d2c51, 0xba6d2c51, 0x00000000, 0x0 }, /* #8 */
    { 0x211252, 0x211246, 0x52dde604, 0x52dde604, 0x00000000, 0x0 }, /* #9 */
    { 0x364a93, 0x364246, 0x362e05c8, 0x362e05c8, 0x00000000, 0x0 }, /* #10 */
    { 0x275d93, 0x275546, 0xf9bff84f, 0xf9bff84f, 0x00000000, 0x0 }, /* #11 */
    { 0x3c65d3, 0x3c6506, 0xd865990a, 0x00000000, 0x5c51b123, 0x0 }, /* #12 */
    { 0x331553, 0x331506, 0xc84c6ae4, 0x00000000, 0xaa84673f, 0x0 }, /* #13 */
    { 0x0354d6, 0x035402, 0xf15942fa, 0x00000002, 0x525f47fc, 0x0 }, /* #14 */
    { 0x2e0b93, 0x2e0306, 0xb0a8ecf6, 0x00000000, 0x84653ad1, 0x0 }, /* #15 */
    { 0x1071d7, 0x107106, 0xc7a9d0eb, 0x00000000, 0xe88aca85, 0x0 }, /* #16 */
    { 0x017ad7, 0x017202, 0x9ec36a6e, 0x00000002, 0x3bd4585c, 0x0 }, /* #17 */
    { 0x035f57, 0x035702, 0xce870a93, 0x00000001, 0xfc91318a, 0x0 }, /* #18 */
    { 0x0b3842, 0x0b3006, 0x7b46efd2, 0x00000000, 0x2d859c8d, 0x0 }, /* #19 */
    { 0x2d5407, 0x2d5406, 0x6772d391, 0x00000006, 0x2f6740c0, 0x0 }, /* #20 */
    { 0x2818c3, 0x281002, 0x870491c4, 0x00000002, 0xa6717eec, 0x0 }, /* #21 */
    { 0x213483, 0x213406, 0xca0e2168, 0x00000000, 0x7ea7c86d, 0x0 }, /* #22 */
    { 0x186e97, 0x186602, 0xecb758ea, 0x00000001, 0xeb0df2e6, 0x0 }, /* #23 */
    { 0x3a5047, 0x3a5002, 0xc8370df2, 0x00000001, 0xe8efcdf2, 0x0 }, /* #24 */
    { 0x2b36c7, 0x2b3602, 0x9e0b9f5e, 0x00000001, 0x502e4422, 0x0 }, /* #25 */
    { 0x011d42, 0x011502, 0x1604e339, 0x00000002, 0xf935d244, 0x0 }, /* #26 */
    { 0x0c7382, 0x0c7302, 0x466adba9, 0x00000001, 0x73c90716, 0x0 }, /* #27 */
    { 0x191ec6, 0x191602, 0xb28b2d8e, 0x00000002, 0x551a0aa4, 0x0 }, /* #28 */
    { 0x3f7a43, 0x3f7202, 0xb8410a83, 0x00000001, 0x68b74796, 0x0 }, /* #29 */
    { 0x032242, 0x032206, 0x51f2da7b, 0x00000003, 0x6d07f338, 0x0 }, /* #30 */
    { 0x062053, 0x062002, 0xb29d63d7, 0x00000001, 0x7f68a1f2, 0x0 }, /* #31 */
    { 0x090286, 0x090202, 0x0739a988, 0x00000001, 0xaf080036, 0x0 }, /* #32 */
    { 0x2a7857, 0x2a7002, 0x1bddb1bc, 0x00000001, 0xf054948a, 0x0 }, /* #33 */
    { 0x0f23c6, 0x0f2302, 0xbd955d52, 0x00000002, 0x1c96d2dc, 0x0 }, /* #34 */
    { 0x216957, 0x216106, 0x518d6029, 0x00000000, 0xf04e061b, 0x0 }, /* #35 */
    { 0x2055c2, 0x205502, 0xcf2de87d, 0x00000004, 0xc63098b0, 0x0 }, /* #36 */
    { 0x310d87, 0x310506, 0x28ae1d16, 0x00000000, 0xd0f1bd09, 0x0 }, /* #37 */
    { 0x2164d2, 0x216406, 0xd3e9aa42, 0x00000003, 0x62448298, 0x0 }, /* #38 */
    { 0x1513c2, 0x151302, 0x21fadd1f, 0x00000002, 0x4e271414, 0x0 }, /* #39 */
    { 0x162ed3, 0x162606, 0x0f4df7cd, 0x00000000, 0x8b945b11, 0x0 }, /* #40 */
    { 0x224082, 0x224002, 0x40df5e6a, 0x00000001, 0xac63c7b2, 0x0 }, /* #41 */
    { 0x161cc6, 0x161402, 0x3d5dc1ca, 0x00000001, 0x41a4d042, 0x0 }, /* #42 */
    { 0x235d42, 0x235506, 0x24acb29c, 0x00000000, 0xcc4d154d, 0x0 }, /* #43 */
    { 0x2248c3, 0x224006, 0xee600f64, 0x00000000, 0x9dd1aaf3, 0x0 }, /* #44 */
    { 0x207506, 0x207502, 0x027bb583, 0x00000001, 0x5cdc557a, 0x0 }, /* #45 */
    { 0x0821d7, 0x082106, 0x180372af, 0x00000000, 0xa308c0a9, 0x0 }, /* #46 */
    { 0x2a1847, 0x2a1006, 0x5faaf61e, 0x00000000, 0x193f149b, 0x0 }, /* #47 */
    { 0x023e03, 0x023602, 0x758dc46c, 0x00000001, 0x29f1b566, 0x0 }, /* #48 */
    { 0x277106, 0x277106, 0xbad29ac3, 0x00000000, 0xff5ca14d, 0x0 }, /* #49 */
    { 0x050f12, 0x050706, 0x21ee2c60, 0x00000000, 0x708429e9, 0x0 }, /* #50 */
    { 0x063197, 0x063102, 0x8a8aeff3, 0x00000002, 0x34cc6a0c, 0x0 }, /* #51 */
    { 0x1f2617, 0x1f2606, 0xe0c61ce5, 0x00000000, 0xce77814d, 0x0 }, /* #52 */
    { 0x2c4942, 0x2c4106, 0x386a88f2, 0x00000000, 0x8dc6a1eb, 0x0 }, /* #53 */
    { 0x395d46, 0x395506, 0xcfff36ee, 0x00000000, 0xd08828f1, 0x0 }, /* #54 */
    { 0x3c3bc6, 0x3c3302, 0x7d6997a2, 0x00000002, 0x3cedad5c, 0x0 }, /* #55 */
    { 0x055a42, 0x055202, 0xe5a3eb9f, 0x00000001, 0xd417ff7e, 0x0 }, /* #56 */
    { 0x103b82, 0x103302, 0x8e90081f, 0x00000002, 0xd6eb0cec, 0x0 }, /* #57 */
    { 0x2357c7, 0x235706, 0x3baf9fd2, 0x00000000, 0x9e69dd8b, 0x0 }, /* #58 */
    { 0x3e1706, 0x3e1702, 0x61fcaf26, 0x00000001, 0x746c0d12, 0x0 }, /* #59 */
    { 0x1d6657, 0x1d6602, 0x24200f53, 0x00000002, 0x463273d4, 0x0 }, /* #60 */
    { 0x007417, 0x007406, 0x37d4389b, 0x00000000, 0xc49b7fc9, 0x0 }, /* #61 */
    { 0x111ed7, 0x111606, 0x41386ed3, 0x00000000, 0xf3847a2d, 0x0 }, /* #62 */
    { 0x225482, 0x225406, 0x74b8cbe8, 0x00000000, 0x537d0aef, 0x0 }, /* #63 */
    { 0x3401d3, 0x340102, 0x14fff9b7, 0x00000002, 0x93a2c77c, 0x0 }, /* #64 */
    { 0x3816c7, 0x381602, 0x4868e0bc, 0x00000001, 0x710b833e, 0x0 }, /* #65 */
    { 0x307517, 0x307502, 0x77fbf4dd, 0x00000002, 0x4b1a8144, 0x0 }, /* #66 */
    { 0x171412, 0x171402, 0x17adda3b, 0x00000002, 0x61aa4934, 0x0 }, /* #67 */
    { 0x263442, 0x263406, 0x04e06a22, 0x00000000, 0xce976353, 0x0 }, /* #68 */
    { 0x2e6002, 0x2e6002, 0x738f4dff, 0x00000002, 0x7ccffa3c, 0x0 }, /* #69 */
    { 0x345796, 0x345702, 0xed7003b6, 0x00000001, 0xa89e718e, 0x0 }, /* #70 */
    { 0x1773d2, 0x177306, 0x871f8ac9, 0x00000000, 0x829fd425, 0x0 }, /* #71 */
    { 0x173743, 0x173702, 0xf2d4618d, 0x00000001, 0xc196bc3e, 0x0 }, /* #72 */
    { 0x294896, 0x294002, 0x4a33725b, 0x00000002, 0xaf73e164, 0x0 }, /* #73 */
    { 0x2835d2, 0x283506, 0x9739f0c0, 0x00000000, 0x6f68cd45, 0x0 }, /* #74 */
    { 0x012886, 0x012006, 0x4dc871d9, 0x00000000, 0xc4192c5d, 0x0 }, /* #75 */
    { 0x293407, 0x293406, 0x4a2fa0b2, 0x00000000, 0x1531e85f, 0x0 }, /* #76 */
    { 0x3d5183, 0x3d5106, 0x6af699ac, 0x00000003, 0xc6aaaa98, 0x0 }, /* #77 */
    { 0x365a47, 0x365202, 0xf7376097, 0x00000001, 0x853e5d2e, 0x0 }, /* #78 */
    { 0x1f0293, 0x1f0202, 0xebcea36c, 0x00000001, 0x6a64b22a, 0x0 }, /* #79 */
    { 0x1e0703, 0x1e0706, 0x79e74240, 0x00000000, 0x40157943, 0x0 }, /* #80 */
    { 0x387002, 0x387006, 0x4c7e4805, 0x00000003, 0x1564e848, 0x0 }, /* #81 */
    { 0x2668d2, 0x266006, 0xe98694fb, 0x00000000, 0x44ae5eeb, 0x0 }, /* #82 */
    { 0x332e52, 0x332606, 0x5b524e65, 0x00000000, 0x5d0ea4c3, 0x0 }, /* #83 */
    { 0x023113, 0x023106, 0xa0b6e189, 0x00000000, 0xb6ae0ca1, 0x0 }, /* #84 */
    { 0x166a46, 0x166202, 0x185596eb, 0x00000001, 0xb7e571ee, 0x0 }, /* #85 */
    { 0x380512, 0x380502, 0x66248e7b, 0x00000001, 0xffd8b3aa, 0x0 }, /* #86 */
    { 0x2279c2, 0x227106, 0x380deb74, 0x00000000, 0xa2b7c1cd, 0x0 }, /* #87 */
    { 0x174f82, 0x174702, 0x8e402813, 0x00000001, 0x5251a776, 0x0 }, /* #88 */
    { 0x0364c2, 0x036406, 0xeb1252fa, 0x00000000, 0x98ee3fc1, 0x0 }, /* #89 */
    { 0x061413, 0x061406, 0x85f84051, 0x00000000, 0xda1bbd17, 0x0 }, /* #90 */
    { 0x1e3c12, 0x1e3406, 0x4a50b65a, 0x00000000, 0x5db86b3b, 0x0 }, /* #91 */
    { 0x2221c3, 0x222106, 0x791004a6, 0x00000000, 0xd5214199, 0x0 }, /* #92 */
    { 0x2d7d07, 0x2d7506, 0xe565ad20, 0x00000000, 0x3eb6d045, 0x0 }, /* #93 */
    { 0x130403, 0x130406, 0x2aef6c39, 0x00000000, 0xdd3e36db, 0x0 }, /* #94 */
    { 0x2e6583, 0x2e6506, 0xe39924c6, 0x00000003, 0xcd956a48, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bsf_u32_intel = RT_ELEMENTS(g_aTests_bsf_u32_intel);

BINU32_TEST_T const g_aTests_bsr_u32_intel[] =
{
    { 0x190f46, 0x190746, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x0959d3, 0x095146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x1e7803, 0x1e7046, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x030d52, 0x030546, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x374ed2, 0x374646, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x392bd3, 0x392346, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x035b86, 0x035346, 0xfc70c192, 0xfc70c192, 0x00000000, 0x0 }, /* #6 */
    { 0x071c52, 0x071446, 0x5b41de29, 0x5b41de29, 0x00000000, 0x0 }, /* #7 */
    { 0x094596, 0x094546, 0xea374e45, 0xea374e45, 0x00000000, 0x0 }, /* #8 */
    { 0x340a46, 0x340246, 0xc440fae6, 0xc440fae6, 0x00000000, 0x0 }, /* #9 */
    { 0x380a82, 0x380246, 0x8ddc9fae, 0x8ddc9fae, 0x00000000, 0x0 }, /* #10 */
    { 0x177a46, 0x177246, 0x7b40cba3, 0x7b40cba3, 0x00000000, 0x0 }, /* #11 */
    { 0x3b2906, 0x3b2106, 0x214b568d, 0x0000001e, 0x646708d1, 0x0 }, /* #12 */
    { 0x3a5193, 0x3a5102, 0x42eaee24, 0x0000001f, 0xc8fc4194, 0x0 }, /* #13 */
    { 0x2c2ec6, 0x2c2602, 0xf393a4fb, 0x0000001f, 0xfdc44ffb, 0x0 }, /* #14 */
    { 0x1a1882, 0x1a1002, 0xdce9f41d, 0x0000001f, 0x8b208cfe, 0x0 }, /* #15 */
    { 0x110752, 0x110702, 0x78aa2138, 0x0000001f, 0xdd1e9d80, 0x0 }, /* #16 */
    { 0x243c52, 0x243406, 0x5522775d, 0x0000001e, 0x5286563d, 0x0 }, /* #17 */
    { 0x047942, 0x047102, 0x2b3a3774, 0x0000001f, 0x943b1883, 0x0 }, /* #18 */
    { 0x3a2343, 0x3a2302, 0xb17ad128, 0x0000001f, 0xb009178a, 0x0 }, /* #19 */
    { 0x327bd7, 0x327306, 0xe33c9102, 0x0000001e, 0x43ca8f19, 0x0 }, /* #20 */
    { 0x0f2f53, 0x0f2702, 0x8b4229b5, 0x0000001f, 0x9d23fa04, 0x0 }, /* #21 */
    { 0x1d7786, 0x1d7706, 0x6baa3efe, 0x00000018, 0x019dedfc, 0x0 }, /* #22 */
    { 0x2e3a56, 0x2e3202, 0x3b86b567, 0x0000001f, 0x806d6b0d, 0x0 }, /* #23 */
    { 0x186c97, 0x186402, 0x251cc07b, 0x0000001f, 0xca19943e, 0x0 }, /* #24 */
    { 0x0a3b82, 0x0a3306, 0x9af173f6, 0x0000001d, 0x2026cbad, 0x0 }, /* #25 */
    { 0x3f2d46, 0x3f2502, 0xd308f1cc, 0x0000001f, 0xb4595ae6, 0x0 }, /* #26 */
    { 0x0411d6, 0x041102, 0x191566a8, 0x0000001c, 0x1e1ef1f6, 0x0 }, /* #27 */
    { 0x2f0b56, 0x2f0306, 0x8a0abf3a, 0x0000001e, 0x62b349aa, 0x0 }, /* #28 */
    { 0x023e06, 0x023602, 0x17ba1f58, 0x0000001f, 0xb4c7ca87, 0x0 }, /* #29 */
    { 0x216256, 0x216206, 0x9c7f7dbc, 0x0000001d, 0x3975eb16, 0x0 }, /* #30 */
    { 0x024743, 0x024702, 0xb08bb84b, 0x0000001f, 0xd993fdb6, 0x0 }, /* #31 */
    { 0x371dd2, 0x371506, 0xda4d477d, 0x0000001e, 0x4334f9e8, 0x0 }, /* #32 */
    { 0x153f42, 0x153702, 0x91e8c4f1, 0x0000001c, 0x13352f57, 0x0 }, /* #33 */
    { 0x1505c7, 0x150502, 0xbe061fbb, 0x0000001c, 0x1e92b38b, 0x0 }, /* #34 */
    { 0x1b2bc7, 0x1b2302, 0xa3e58185, 0x0000001f, 0x8b9d52c0, 0x0 }, /* #35 */
    { 0x3f0486, 0x3f0402, 0x89fa80fa, 0x0000001f, 0xf3aad2a9, 0x0 }, /* #36 */
    { 0x1f1507, 0x1f1502, 0x10bbb597, 0x0000001f, 0x95c16ad7, 0x0 }, /* #37 */
    { 0x135fd6, 0x135702, 0x355cc890, 0x0000001a, 0x070180f8, 0x0 }, /* #38 */
    { 0x065657, 0x065602, 0x33f5c390, 0x0000001f, 0xcdc8de2a, 0x0 }, /* #39 */
    { 0x021f57, 0x021702, 0xcb0450ac, 0x0000001f, 0x9123abf4, 0x0 }, /* #40 */
    { 0x094806, 0x094006, 0x154d7dc9, 0x0000001d, 0x3af72ae5, 0x0 }, /* #41 */
    { 0x2c2112, 0x2c2106, 0x552af356, 0x0000001e, 0x400890a1, 0x0 }, /* #42 */
    { 0x072cd3, 0x072406, 0x3984216e, 0x0000001e, 0x7f369236, 0x0 }, /* #43 */
    { 0x2d5c47, 0x2d5402, 0x67f296a1, 0x0000001f, 0xedf953ab, 0x0 }, /* #44 */
    { 0x040406, 0x040402, 0xfd82b0cd, 0x0000001f, 0xa966072b, 0x0 }, /* #45 */
    { 0x0d2797, 0x0d2706, 0x31f2bb36, 0x0000001e, 0x45bd7855, 0x0 }, /* #46 */
    { 0x082242, 0x082206, 0xe8291b5b, 0x0000001e, 0x6aeb68b0, 0x0 }, /* #47 */
    { 0x237853, 0x237002, 0x4469e886, 0x0000001c, 0x13d68b9a, 0x0 }, /* #48 */
    { 0x383f46, 0x383702, 0xbd36c828, 0x0000001f, 0xd3fd2034, 0x0 }, /* #49 */
    { 0x350e17, 0x350602, 0x1bde84ca, 0x0000001c, 0x1fc978e2, 0x0 }, /* #50 */
    { 0x203152, 0x203102, 0x19af16fa, 0x0000001f, 0xcfda9bd8, 0x0 }, /* #51 */
    { 0x361f02, 0x361706, 0x1d17aaa9, 0x0000001e, 0x725d4a58, 0x0 }, /* #52 */
    { 0x0b6fc7, 0x0b6702, 0x6419c3da, 0x0000001f, 0xb14db783, 0x0 }, /* #53 */
    { 0x193702, 0x193702, 0x8c031e88, 0x0000001f, 0x8b5aa9ef, 0x0 }, /* #54 */
    { 0x344306, 0x344302, 0xbd616178, 0x0000001f, 0xd075da24, 0x0 }, /* #55 */
    { 0x3040d7, 0x304002, 0x986782bc, 0x0000001f, 0x94f04149, 0x0 }, /* #56 */
    { 0x1a28c2, 0x1a2002, 0x3b77a707, 0x0000001f, 0xda10ee8e, 0x0 }, /* #57 */
    { 0x2644c2, 0x264402, 0xabefe441, 0x0000001f, 0x825492d3, 0x0 }, /* #58 */
    { 0x290612, 0x290602, 0xbce16fa5, 0x0000001f, 0xac2c3921, 0x0 }, /* #59 */
    { 0x2c75d6, 0x2c7502, 0x0c4dd993, 0x0000001c, 0x1f328c31, 0x0 }, /* #60 */
    { 0x3d6356, 0x3d6302, 0x3d48c57d, 0x0000001f, 0x8d43f614, 0x0 }, /* #61 */
    { 0x0349d2, 0x034102, 0x65b4b632, 0x0000001f, 0x855e4a65, 0x0 }, /* #62 */
    { 0x1f6982, 0x1f6102, 0xc81caaf1, 0x0000001f, 0xb7505efc, 0x0 }, /* #63 */
    { 0x141416, 0x141402, 0xe21e5fb7, 0x0000001f, 0x91eb8a32, 0x0 }, /* #64 */
    { 0x1c70c3, 0x1c7006, 0xcf7a30a3, 0x0000001e, 0x6011d055, 0x0 }, /* #65 */
    { 0x017616, 0x017602, 0x6a6cd12d, 0x0000001f, 0xbcf6a219, 0x0 }, /* #66 */
    { 0x300782, 0x300702, 0x6e464bd7, 0x0000001f, 0x89e8a9f8, 0x0 }, /* #67 */
    { 0x250716, 0x250706, 0x2e5c6061, 0x0000001d, 0x318a9be1, 0x0 }, /* #68 */
    { 0x0d32d2, 0x0d3202, 0xf20c31b3, 0x0000001f, 0x8f98faa5, 0x0 }, /* #69 */
    { 0x060b06, 0x060302, 0x3344b1ae, 0x0000001f, 0x8531dd71, 0x0 }, /* #70 */
    { 0x266fc2, 0x266702, 0x968bbd7e, 0x0000001f, 0x8d9355e1, 0x0 }, /* #71 */
    { 0x183e42, 0x183606, 0x8a3d885d, 0x0000001e, 0x786f788e, 0x0 }, /* #72 */
    { 0x0c4f43, 0x0c4706, 0x40c8e5b0, 0x0000001e, 0x644114b3, 0x0 }, /* #73 */
    { 0x027742, 0x027706, 0x00dec959, 0x0000001e, 0x632a332a, 0x0 }, /* #74 */
    { 0x381992, 0x381106, 0xd2e00c72, 0x0000001e, 0x4e32d32b, 0x0 }, /* #75 */
    { 0x194ed3, 0x194602, 0x88ce5582, 0x0000001f, 0xb157e9c7, 0x0 }, /* #76 */
    { 0x2b0c16, 0x2b0406, 0xcf5275a5, 0x0000001d, 0x3fb09e24, 0x0 }, /* #77 */
    { 0x1f2046, 0x1f2002, 0x62729a59, 0x0000001f, 0xa0a46977, 0x0 }, /* #78 */
    { 0x070786, 0x070702, 0xcf7adf3a, 0x0000001f, 0xa2e8771d, 0x0 }, /* #79 */
    { 0x0c0417, 0x0c0406, 0x46126281, 0x0000001b, 0x0e5aa82b, 0x0 }, /* #80 */
    { 0x0b34c6, 0x0b3406, 0xd9a54237, 0x0000001d, 0x2f9f713e, 0x0 }, /* #81 */
    { 0x1d4dc2, 0x1d4502, 0x03acf144, 0x0000001f, 0xb398534b, 0x0 }, /* #82 */
    { 0x0b7952, 0x0b7106, 0xd0a80c75, 0x0000001d, 0x2c4aabe5, 0x0 }, /* #83 */
    { 0x3e28c7, 0x3e2002, 0xc1677167, 0x0000001f, 0xce2637a6, 0x0 }, /* #84 */
    { 0x332043, 0x332002, 0xbfad8600, 0x0000001f, 0xfaae2312, 0x0 }, /* #85 */
    { 0x0a2302, 0x0a2306, 0x55789b5e, 0x0000001e, 0x577b886b, 0x0 }, /* #86 */
    { 0x2c43c6, 0x2c4302, 0xd305ab7e, 0x0000001f, 0xa126011b, 0x0 }, /* #87 */
    { 0x0039c3, 0x003106, 0x29dc8520, 0x0000001e, 0x5e20a5f1, 0x0 }, /* #88 */
    { 0x002c42, 0x002402, 0x28bce54c, 0x0000001f, 0xefea99eb, 0x0 }, /* #89 */
    { 0x2e2287, 0x2e2206, 0x7b98e3b8, 0x0000001d, 0x3182232a, 0x0 }, /* #90 */
    { 0x001743, 0x001702, 0x0db92b0e, 0x0000001f, 0x94b70851, 0x0 }, /* #91 */
    { 0x102e82, 0x102606, 0xe2682278, 0x0000001d, 0x2c77ffe3, 0x0 }, /* #92 */
    { 0x2e2d86, 0x2e2506, 0xf41ee451, 0x0000001b, 0x087f7567, 0x0 }, /* #93 */
    { 0x3c0547, 0x3c0506, 0x14045ef9, 0x0000001e, 0x51728787, 0x0 }, /* #94 */
    { 0x0d69c6, 0x0d6102, 0x7cd6d841, 0x0000001f, 0xec21416b, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bsr_u32_intel = RT_ELEMENTS(g_aTests_bsr_u32_intel);

BINU32_TEST_T const g_aTests_imul_two_u32_intel[] =
{
    { 0x001642, 0x001606, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x190287, 0x190206, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x0304d6, 0x030406, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x3f6cc3, 0x3f6406, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x334016, 0x334006, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x347c42, 0x347406, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x344e96, 0x344606, 0x54c1ddef, 0x00000000, 0x00000000, 0x0 }, /* #6 */
    { 0x1c7197, 0x1c7106, 0x20ac7242, 0x00000000, 0x00000000, 0x0 }, /* #7 */
    { 0x0455c2, 0x045506, 0x5047cbca, 0x00000000, 0x00000000, 0x0 }, /* #8 */
    { 0x3503c6, 0x350306, 0x624a75ff, 0x00000000, 0x00000000, 0x0 }, /* #9 */
    { 0x3d2283, 0x3d2206, 0x2505e4e7, 0x00000000, 0x00000000, 0x0 }, /* #10 */
    { 0x2c30c7, 0x2c3006, 0xdfb8d34a, 0x00000000, 0x00000000, 0x0 }, /* #11 */
    { 0x223d52, 0x223d83, 0x745f1499, 0xd1a62531, 0x48595c59, 0x0 }, /* #12 */
    { 0x1a75c6, 0x1a7d87, 0x781acaf4, 0x8ebdee3c, 0xc88f123b, 0x0 }, /* #13 */
    { 0x1f0d92, 0x1f0d83, 0x1c5a54de, 0xcaab4fbc, 0xa4ff5d02, 0x0 }, /* #14 */
    { 0x235f43, 0x235f83, 0xbc54c686, 0xdecf61dc, 0xec88617a, 0x0 }, /* #15 */
    { 0x147516, 0x147d83, 0xca28258d, 0xce8d2225, 0xe0360cf9, 0x0 }, /* #16 */
    { 0x1018c2, 0x101887, 0xcdf1232b, 0xa3a9d366, 0x998c5f32, 0x0 }, /* #17 */
    { 0x090b93, 0x090b03, 0xeaed7cb7, 0x2d911b67, 0xb74e06d1, 0x0 }, /* #18 */
    { 0x006313, 0x006b07, 0x3b547b4c, 0x39ceab74, 0x4370e18f, 0x0 }, /* #19 */
    { 0x186fc7, 0x186f03, 0xecc2f64c, 0x791d3620, 0xd7ef3158, 0x0 }, /* #20 */
    { 0x3f1102, 0x3f1907, 0x95200c97, 0x377aeaa3, 0x7f4437d5, 0x0 }, /* #21 */
    { 0x326193, 0x326903, 0xba1e6e7c, 0x31cc1858, 0xf39bc22a, 0x0 }, /* #22 */
    { 0x3e0987, 0x3e0987, 0x88a1d657, 0x9d2d1e87, 0x4517fb51, 0x0 }, /* #23 */
    { 0x3645c6, 0x364d03, 0x73aa57cd, 0x6ac25326, 0x601ecdbe, 0x0 }, /* #24 */
    { 0x0a5f13, 0x0a5f83, 0xa7b66ae9, 0xebf17604, 0x4e2c3b64, 0x0 }, /* #25 */
    { 0x360243, 0x360a87, 0x145699f4, 0xd0f182ac, 0xacaa4447, 0x0 }, /* #26 */
    { 0x312756, 0x312f83, 0xe484e22c, 0xb3785408, 0xcc5ebd46, 0x0 }, /* #27 */
    { 0x296247, 0x296a83, 0x18a62c3c, 0xf844f11c, 0xf4921b49, 0x0 }, /* #28 */
    { 0x162903, 0x162903, 0xff98cbcd, 0x767aa20d, 0x7a956f41, 0x0 }, /* #29 */
    { 0x221743, 0x221f03, 0x7457ef21, 0x17f941ec, 0x26b4606c, 0x0 }, /* #30 */
    { 0x1e3646, 0x1e3e03, 0x4f0dc8e6, 0x147c394c, 0xeab52d42, 0x0 }, /* #31 */
    { 0x210cc6, 0x210c07, 0x2ad96ff5, 0x6df1b73a, 0x0a597812, 0x0 }, /* #32 */
    { 0x3f4ac7, 0x3f4a07, 0x0358efef, 0x015da26f, 0xbde3f581, 0x0 }, /* #33 */
    { 0x026352, 0x026b07, 0xeb2656e4, 0x75c8ba74, 0xb8755205, 0x0 }, /* #34 */
    { 0x0263c3, 0x026b07, 0xbe6aa7c4, 0x7e07f344, 0x881ca0e1, 0x0 }, /* #35 */
    { 0x177242, 0x177a03, 0xda921a24, 0x5b57a220, 0x82ab0248, 0x0 }, /* #36 */
    { 0x217b16, 0x217b03, 0x37e645a6, 0x27b82cb6, 0x5b9c3959, 0x0 }, /* #37 */
    { 0x207456, 0x207c07, 0x6aed5547, 0x2a736a60, 0xacf7f2a0, 0x0 }, /* #38 */
    { 0x3e4a86, 0x3e4a83, 0xa5cd9553, 0xb3eea732, 0xc4c813c6, 0x0 }, /* #39 */
    { 0x1e4516, 0x1e4d07, 0x6f1724ab, 0x1afe9a0c, 0xe8445624, 0x0 }, /* #40 */
    { 0x1d2dd2, 0x1d2d87, 0x0f9efe60, 0xf3336aa0, 0x0268f997, 0x0 }, /* #41 */
    { 0x043dd2, 0x043d87, 0xc0e2f466, 0xc72de1c6, 0x97c65e91, 0x0 }, /* #42 */
    { 0x296512, 0x296d03, 0x8be53a44, 0x4c73b170, 0xccfe4c9c, 0x0 }, /* #43 */
    { 0x1f4812, 0x1f4887, 0x594e3a05, 0xfd086cd7, 0x917b562b, 0x0 }, /* #44 */
    { 0x0854d6, 0x085c03, 0xca2b1b43, 0x43521362, 0xf8be0bf6, 0x0 }, /* #45 */
    { 0x2c3c56, 0x2c3c83, 0x06f3df38, 0xe5e9d070, 0x04df63c2, 0x0 }, /* #46 */
    { 0x1836c6, 0x183e87, 0x2bcd793c, 0x869301e4, 0x481ecab7, 0x0 }, /* #47 */
    { 0x194183, 0x194907, 0xee36bc0f, 0x45650cb1, 0x9505eb3f, 0x0 }, /* #48 */
    { 0x353182, 0x353987, 0x58d5a981, 0x8f37e79a, 0x4d47f09a, 0x0 }, /* #49 */
    { 0x0b45c7, 0x0b4d03, 0x93e77199, 0x4622f58c, 0x87bef16c, 0x0 }, /* #50 */
    { 0x170346, 0x170b07, 0xab0739d9, 0x3271455c, 0xf4e0dabc, 0x0 }, /* #51 */
    { 0x0a2e97, 0x0a2e07, 0x52d823aa, 0x0f4c2dfc, 0xaf50fc06, 0x0 }, /* #52 */
    { 0x1a0fd7, 0x1a0f83, 0x3141c47d, 0x8049f12a, 0x3b5c6ff2, 0x0 }, /* #53 */
    { 0x3b5107, 0x3b5983, 0x93c9fc74, 0xad201040, 0xd6d88750, 0x0 }, /* #54 */
    { 0x2d2ec2, 0x2d2e87, 0xc30deedc, 0x954a93e8, 0xfbf496d6, 0x0 }, /* #55 */
    { 0x194f12, 0x194f03, 0x46f8b26b, 0x4e451f29, 0x4b9121bb, 0x0 }, /* #56 */
    { 0x1e4e07, 0x1e4e07, 0xd4500e57, 0x235bf58e, 0x1f31a222, 0x0 }, /* #57 */
    { 0x3e4207, 0x3e4a03, 0xabf0b103, 0x713abe7c, 0xfc3ab8d4, 0x0 }, /* #58 */
    { 0x0a12d6, 0x0a1a83, 0x5c942fc3, 0xb4fafda4, 0x6264b58c, 0x0 }, /* #59 */
    { 0x3f4813, 0x3f4887, 0xffe9b60a, 0xf0096b14, 0x39421982, 0x0 }, /* #60 */
    { 0x2b6843, 0x2b6807, 0xe234ea09, 0x2b7f5c6f, 0x718f90b7, 0x0 }, /* #61 */
    { 0x144ad3, 0x144a03, 0x4d43a021, 0x797580d0, 0xbaeea6d0, 0x0 }, /* #62 */
    { 0x197503, 0x197d03, 0xbfb9074a, 0x5b8ac0e6, 0x5ee53837, 0x0 }, /* #63 */
    { 0x026703, 0x026f83, 0xd81bbf25, 0xda515107, 0xdf979dbb, 0x0 }, /* #64 */
    { 0x1d08d7, 0x1d0803, 0x24a6da99, 0x09fd3b16, 0x5f95a786, 0x0 }, /* #65 */
    { 0x097907, 0x097903, 0xc321a22d, 0x033fc99d, 0x06a91b31, 0x0 }, /* #66 */
    { 0x2a7557, 0x2a7d87, 0x8fea03fe, 0xdcdc51a0, 0x92f03730, 0x0 }, /* #67 */
    { 0x1f1442, 0x1f1c07, 0x98f66b07, 0x49e5f318, 0x6d707628, 0x0 }, /* #68 */
    { 0x203317, 0x203b87, 0xb66dcd87, 0xac612daf, 0x0149e899, 0x0 }, /* #69 */
    { 0x096812, 0x096807, 0x1f1c6a84, 0x02b21b24, 0x565d6329, 0x0 }, /* #70 */
    { 0x1a7b46, 0x1a7b87, 0x8baa9269, 0x9470c606, 0x663e8916, 0x0 }, /* #71 */
    { 0x194907, 0x194983, 0x36892e7d, 0xb86fbd79, 0xd9aa0fad, 0x0 }, /* #72 */
    { 0x114cd2, 0x114c03, 0xbc5bf7bb, 0x64c86f80, 0xbc1f9680, 0x0 }, /* #73 */
    { 0x116297, 0x116a83, 0x956a97fc, 0xf28cdd08, 0x9a0bfcbe, 0x0 }, /* #74 */
    { 0x1a5c02, 0x1a5c07, 0x5ca29620, 0x6230eec0, 0xab1ad456, 0x0 }, /* #75 */
    { 0x257506, 0x257d83, 0x12d70361, 0xda5a84ec, 0xd3d4186c, 0x0 }, /* #76 */
    { 0x284642, 0x284e07, 0x8438c891, 0x28dcc556, 0xc3406af6, 0x0 }, /* #77 */
    { 0x337e56, 0x337e07, 0x80e14e13, 0x3a1a9dbe, 0xe89a4b0a, 0x0 }, /* #78 */
    { 0x246e92, 0x246e87, 0xdd6002fc, 0xdf26a648, 0x15cd08ee, 0x0 }, /* #79 */
    { 0x0f65c2, 0x0f6d87, 0x0ead28b7, 0xf554fda3, 0x6ea3ae75, 0x0 }, /* #80 */
    { 0x0d5447, 0x0d5c83, 0x3e0532b6, 0x98670fa2, 0xd2d83f43, 0x0 }, /* #81 */
    { 0x0b0ed7, 0x0b0e87, 0x67c4e722, 0xf03db18e, 0xcd5a2ad7, 0x0 }, /* #82 */
    { 0x2d21d7, 0x2d2983, 0x648fb6c9, 0xf9789d02, 0x8dd1bbf2, 0x0 }, /* #83 */
    { 0x163a13, 0x163a07, 0x64fdd633, 0x7ac03f0a, 0x451496ce, 0x0 }, /* #84 */
    { 0x1e4592, 0x1e4d87, 0x7a68d6a7, 0xad4892bd, 0xc5219bfb, 0x0 }, /* #85 */
    { 0x3e0cc2, 0x3e0c87, 0x01e1fe55, 0xbec8ab24, 0x66191a94, 0x0 }, /* #86 */
    { 0x0c5543, 0x0c5d03, 0xa811d9de, 0x17b961f4, 0x2db9d2a6, 0x0 }, /* #87 */
    { 0x0b5c46, 0x0b5c83, 0x760044e6, 0x9df33c92, 0xcc040153, 0x0 }, /* #88 */
    { 0x3c7796, 0x3c7f07, 0x214c9aec, 0x6ffbc1b4, 0xd38996f7, 0x0 }, /* #89 */
    { 0x0e01c3, 0x0e0983, 0xcc21a1e2, 0xdd387d54, 0xa8dd694a, 0x0 }, /* #90 */
    { 0x1b5dc7, 0x1b5d87, 0xeaef0224, 0xa41e4ffc, 0xd6b43e47, 0x0 }, /* #91 */
    { 0x2762d2, 0x276a83, 0x190993e9, 0xc390a840, 0x67077e40, 0x0 }, /* #92 */
    { 0x2e0c92, 0x2e0c07, 0x45b238a6, 0x4f5b6466, 0xc00556a1, 0x0 }, /* #93 */
    { 0x0e7e53, 0x0e7e83, 0x9b135812, 0x88b0424c, 0x724b6d76, 0x0 }, /* #94 */
    { 0x2f14d7, 0x2f1c03, 0xd2ba1074, 0x52d25934, 0x562f63f1, 0x0 }, /* #95 */
};
uint32_t const g_cTests_imul_two_u32_intel = RT_ELEMENTS(g_aTests_imul_two_u32_intel);

BINU64_TEST_T const g_aTests_bsf_u64_intel[] =
{
    { 0x396886, 0x396046, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x1c4d53, 0x1c4546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x2a3202, 0x2a3246, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x341087, 0x341046, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x2e5ac7, 0x2e5246, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x3c4993, 0x3c4146, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x1877c2, 0x187746, 0xb3c24014c01f0af0, 0xb3c24014c01f0af0, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x2a6883, 0x2a6046, 0xc6516c1ab8610dc9, 0xc6516c1ab8610dc9, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x3d6f47, 0x3d6746, 0x73adb6670bdaccc0, 0x73adb6670bdaccc0, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x0526d7, 0x052646, 0xb4fe0a71768e50b9, 0xb4fe0a71768e50b9, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x002d07, 0x002546, 0xef040de114773d29, 0xef040de114773d29, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x0c1692, 0x0c1646, 0x87ad6610e4228de4, 0x87ad6610e4228de4, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x116607, 0x116602, 0x1cbf65e98d2f32c4, 0x0000000000000002, 0x8ba22aa025980c3c, 0x0 }, /* #12 */
    { 0x0a0e82, 0x0a0606, 0x03195701f325e482, 0x0000000000000000, 0x71ea1ce575e7495f, 0x0 }, /* #13 */
    { 0x2f6d07, 0x2f6502, 0x72825b87a50d8598, 0x0000000000000004, 0xd5f293dd8f671630, 0x0 }, /* #14 */
    { 0x184f52, 0x184706, 0x2a2fa04a0c72cfa7, 0x0000000000000000, 0xe40da81963765457, 0x0 }, /* #15 */
    { 0x317257, 0x317206, 0x9794b1d25378a1a9, 0x0000000000000000, 0xdb1c9a5037ad0e93, 0x0 }, /* #16 */
    { 0x234b17, 0x234302, 0x864aa048805dcacb, 0x0000000000000002, 0x7e7e7fae1a54fa24, 0x0 }, /* #17 */
    { 0x092202, 0x092206, 0x0aabfce1f2de8147, 0x0000000000000000, 0xf9935148b35dd4bf, 0x0 }, /* #18 */
    { 0x1d4887, 0x1d4002, 0x3955e32b6e4468e0, 0x0000000000000001, 0xa03ae47ed4f1d5ce, 0x0 }, /* #19 */
    { 0x175d97, 0x175506, 0x6b6438ad30c9e4a4, 0x0000000000000000, 0xcf9146b8db106d2d, 0x0 }, /* #20 */
    { 0x196f93, 0x196702, 0xee02918190846bef, 0x0000000000000001, 0x1b5062cfadc6b4da, 0x0 }, /* #21 */
    { 0x107fc7, 0x107702, 0x60129545d834d644, 0x0000000000000002, 0xce46db71ebf244b4, 0x0 }, /* #22 */
    { 0x3701c7, 0x370106, 0x5f5e6b8f3b33a86c, 0x0000000000000000, 0x9ad8c2cc6bf98e79, 0x0 }, /* #23 */
    { 0x145606, 0x145606, 0xed811a2b0fedf1b2, 0x0000000000000000, 0x41a9ba25a0fa6f21, 0x0 }, /* #24 */
    { 0x1d22d7, 0x1d2202, 0xc3c8c58440f29bf5, 0x0000000000000001, 0x17afe976c8f13516, 0x0 }, /* #25 */
    { 0x3d7992, 0x3d7102, 0x8adc62173384f4b2, 0x0000000000000002, 0x8ff27ba3592d4eac, 0x0 }, /* #26 */
    { 0x104492, 0x104402, 0x452c063f06c6c09b, 0x0000000000000001, 0xbf5990ca279c059a, 0x0 }, /* #27 */
    { 0x263816, 0x263006, 0x7aa5e40669e2b5fb, 0x0000000000000000, 0x05cccd0c8aa3d553, 0x0 }, /* #28 */
    { 0x0e2556, 0x0e2506, 0x0e4aba307d0bea75, 0x0000000000000000, 0x8cecd10080a30187, 0x0 }, /* #29 */
    { 0x1d4357, 0x1d4306, 0x9331507b2f47d1ca, 0x0000000000000000, 0x5b6aff87a5ff0da5, 0x0 }, /* #30 */
    { 0x3b0043, 0x3b0006, 0xca1586ca801265d2, 0x0000000000000000, 0x718e879c8f6ef481, 0x0 }, /* #31 */
    { 0x3f0cc3, 0x3f0402, 0x6eda4947506d3f6c, 0x0000000000000001, 0x900caa3002440a76, 0x0 }, /* #32 */
    { 0x1b4092, 0x1b4006, 0x3675600ed6ad1147, 0x0000000000000000, 0x21dab436740dd1e1, 0x0 }, /* #33 */
    { 0x2062c6, 0x206206, 0xd74189d3da4e83d3, 0x0000000000000000, 0xa771436a2be18a75, 0x0 }, /* #34 */
    { 0x233096, 0x233002, 0xc7205a17d72333d6, 0x0000000000000001, 0xd10bfc52da65adb6, 0x0 }, /* #35 */
    { 0x176557, 0x176506, 0x90bafd450ccdaff4, 0x0000000000000000, 0x7f33c099114af7d1, 0x0 }, /* #36 */
    { 0x213fc7, 0x213706, 0x41fa8012254a7918, 0x0000000000000000, 0x7a9045ff2950a5b1, 0x0 }, /* #37 */
    { 0x162887, 0x162006, 0x3cb0bb3788afaa46, 0x0000000000000000, 0x3fdca267caeca0f3, 0x0 }, /* #38 */
    { 0x130c92, 0x130406, 0xa4e59b51e0f87ab2, 0x0000000000000000, 0xe8373de22f581f4b, 0x0 }, /* #39 */
    { 0x1d0c12, 0x1d0402, 0x4e295d882b37a07f, 0x0000000000000001, 0x24e92a59ad4b89a2, 0x0 }, /* #40 */
    { 0x381fd6, 0x381702, 0x4b5982e42860b14c, 0x0000000000000001, 0xa245a80e749e6c5a, 0x0 }, /* #41 */
    { 0x323803, 0x323006, 0x5044cff847728ec8, 0x0000000000000000, 0x3dc062406783d9bb, 0x0 }, /* #42 */
    { 0x360647, 0x360602, 0x11f95a54d6b774cf, 0x0000000000000001, 0x0d85c27f18df40de, 0x0 }, /* #43 */
    { 0x370e87, 0x370606, 0xb90443a2dd59e405, 0x0000000000000000, 0x3cae056494d590bb, 0x0 }, /* #44 */
    { 0x344d06, 0x344502, 0x665385d05f5a34cb, 0x0000000000000004, 0xe2f32609d6b77b70, 0x0 }, /* #45 */
    { 0x3e2442, 0x3e2402, 0x024fa14e3bf08c98, 0x0000000000000001, 0x643c0e8be9c37e86, 0x0 }, /* #46 */
    { 0x314847, 0x314002, 0x82b3fc06f755818c, 0x0000000000000002, 0xb901d5e8440c25a4, 0x0 }, /* #47 */
    { 0x293d16, 0x293506, 0x0573f4c0171e2756, 0x0000000000000003, 0xeee39e14c2122838, 0x0 }, /* #48 */
    { 0x2f7283, 0x2f7206, 0x9c41b7095f02c229, 0x0000000000000000, 0x1d055897b9249901, 0x0 }, /* #49 */
    { 0x251d56, 0x251506, 0x8dd376a765105673, 0x0000000000000005, 0xdbe72a2411bedca0, 0x0 }, /* #50 */
    { 0x0331c3, 0x033106, 0xde0c20307d9a6318, 0x0000000000000000, 0x1114bdc0cf613b67, 0x0 }, /* #51 */
    { 0x331302, 0x331306, 0xbcb47c40162ce619, 0x0000000000000000, 0xc86c0aaa9e0e0793, 0x0 }, /* #52 */
    { 0x3b4053, 0x3b4002, 0x09222f6b8bfb56c7, 0x0000000000000002, 0x2216c5a8a777be9c, 0x0 }, /* #53 */
    { 0x190982, 0x190106, 0xea0572969f7f76bb, 0x0000000000000000, 0x69d2bc86a19e44eb, 0x0 }, /* #54 */
    { 0x0677c7, 0x067702, 0x459dd1c250d84088, 0x0000000000000001, 0xe287488384983b16, 0x0 }, /* #55 */
    { 0x386f56, 0x386702, 0x583c9f9694c38fe8, 0x0000000000000002, 0x5b9fd5f0c6ce1774, 0x0 }, /* #56 */
    { 0x105f47, 0x105706, 0xeadee9c318207838, 0x0000000000000003, 0x3c7b41a39bb24338, 0x0 }, /* #57 */
    { 0x034a83, 0x034206, 0xc5b7fb9bd67c8a0d, 0x0000000000000000, 0xa637b9bc5bdec649, 0x0 }, /* #58 */
    { 0x005a87, 0x005202, 0x11445b0949af2406, 0x0000000000000001, 0x37c94d60b5cdf13a, 0x0 }, /* #59 */
    { 0x160582, 0x160506, 0xa39e9f8e792be48a, 0x0000000000000000, 0x6bf4aadb69faca21, 0x0 }, /* #60 */
    { 0x083cc3, 0x083406, 0x53a2a33b115151b1, 0x0000000000000000, 0x54d9b776a0673b39, 0x0 }, /* #61 */
    { 0x117e07, 0x117606, 0xf2d88ba52fd2be93, 0x0000000000000000, 0xa48c3898c43cebff, 0x0 }, /* #62 */
    { 0x064517, 0x064506, 0xa97f22c320aa916a, 0x0000000000000000, 0x240c00fb87c67835, 0x0 }, /* #63 */
    { 0x091f82, 0x091702, 0x879895f2d7fa46b4, 0x0000000000000001, 0x8dd50df78ebfdfaa, 0x0 }, /* #64 */
    { 0x0e4dc6, 0x0e4506, 0xca49ba685917a9a6, 0x0000000000000003, 0x956801eb6b887ed8, 0x0 }, /* #65 */
    { 0x2a2b42, 0x2a2306, 0x2886b571cc77b01f, 0x0000000000000000, 0x968e60f012435cd5, 0x0 }, /* #66 */
    { 0x1427c3, 0x142702, 0xafe60c96f2f7b61d, 0x0000000000000008, 0x2432f2b5fb4a7b00, 0x0 }, /* #67 */
    { 0x3a3157, 0x3a3102, 0x32b2ebbd75578176, 0x0000000000000001, 0x1b7a34ae7a74b7ae, 0x0 }, /* #68 */
    { 0x383a43, 0x383202, 0xe63ef53bc85787b1, 0x0000000000000001, 0x623f392cf66ae3d2, 0x0 }, /* #69 */
    { 0x057c93, 0x057406, 0x96e5e8d1d75ac270, 0x0000000000000000, 0xeee3086a31b28ddb, 0x0 }, /* #70 */
    { 0x267ec6, 0x267606, 0xf4cb0798c29981ba, 0x0000000000000000, 0xbaf7bccdba2f8133, 0x0 }, /* #71 */
    { 0x3b57d2, 0x3b5706, 0x130a01df7fdd9cf5, 0x0000000000000000, 0x03baa322583a3d1b, 0x0 }, /* #72 */
    { 0x0721d2, 0x072106, 0x15ee859058360c84, 0x0000000000000000, 0xfe96a03b03a67d7b, 0x0 }, /* #73 */
    { 0x0b74c6, 0x0b7402, 0xacb6208bbf5aa5dd, 0x0000000000000001, 0xdc80bfcfec19620e, 0x0 }, /* #74 */
    { 0x1217d2, 0x121706, 0x0bd76032ddef98d1, 0x0000000000000000, 0x34ed9ae99605df53, 0x0 }, /* #75 */
    { 0x365892, 0x365002, 0x019a7312a22853e0, 0x0000000000000001, 0xf8600a17c969927e, 0x0 }, /* #76 */
    { 0x0c5a56, 0x0c5206, 0x864d8c287352f46d, 0x0000000000000000, 0x8a5a992440580ddd, 0x0 }, /* #77 */
    { 0x2f3416, 0x2f3402, 0x52869cd6e1c940cd, 0x0000000000000002, 0x6e75bfc9809632cc, 0x0 }, /* #78 */
    { 0x0e2846, 0x0e2006, 0x7d5c58f9662cb503, 0x0000000000000000, 0x11d278ca3374a30b, 0x0 }, /* #79 */
    { 0x311283, 0x311206, 0x23b26e45f6868e4a, 0x0000000000000000, 0x32218296c134334b, 0x0 }, /* #80 */
    { 0x0567c7, 0x056702, 0xd40a1e939533a4d7, 0x0000000000000001, 0x4a773a571e021896, 0x0 }, /* #81 */
    { 0x3e34d6, 0x3e3402, 0xc53343a35e219e4a, 0x0000000000000001, 0x343d9253a121810a, 0x0 }, /* #82 */
    { 0x260f83, 0x260706, 0x395bc286b51334f1, 0x0000000000000000, 0x3757d5c92c5041ff, 0x0 }, /* #83 */
    { 0x305903, 0x305106, 0x0b3f081b1721f9ef, 0x0000000000000000, 0xd4394d16bf870509, 0x0 }, /* #84 */
    { 0x377842, 0x377006, 0x37841d0518453f11, 0x0000000000000000, 0x9af0dc43ef220d4d, 0x0 }, /* #85 */
    { 0x023ad6, 0x023202, 0x91b0a9ebafe90786, 0x0000000000000002, 0x0f73ec3eb7d3dc8c, 0x0 }, /* #86 */
    { 0x003183, 0x003102, 0x2ba83e6fe57887c4, 0x0000000000000001, 0xa81ba5099d8a6b6e, 0x0 }, /* #87 */
    { 0x1d03d2, 0x1d0302, 0x6c57ba16ab7e763d, 0x0000000000000002, 0x2caf66ba7268c204, 0x0 }, /* #88 */
    { 0x0d0956, 0x0d0106, 0xa49fd903f9183a9f, 0x0000000000000000, 0xd16a39d10b236665, 0x0 }, /* #89 */
    { 0x0f70d6, 0x0f7006, 0xc7a1f4f7d6126b53, 0x0000000000000000, 0x714f16566503e473, 0x0 }, /* #90 */
    { 0x0536d6, 0x053606, 0x189554b97a118d58, 0x0000000000000000, 0x7dcb39792815a29b, 0x0 }, /* #91 */
    { 0x1d7857, 0x1d7002, 0xb676d1e639ead19c, 0x0000000000000001, 0x66c2a47b703c40e6, 0x0 }, /* #92 */
    { 0x1d1787, 0x1d1706, 0x5437f0234bbface2, 0x0000000000000000, 0x245e8ba25623dd8b, 0x0 }, /* #93 */
    { 0x0d0b06, 0x0d0302, 0x5957827e10417d02, 0x0000000000000002, 0x2d33251aa5824a2c, 0x0 }, /* #94 */
    { 0x001b83, 0x001302, 0xad76b062321a5527, 0x0000000000000002, 0x69c67500008ce10c, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bsf_u64_intel = RT_ELEMENTS(g_aTests_bsf_u64_intel);

BINU64_TEST_T const g_aTests_bsr_u64_intel[] =
{
    { 0x2a6f57, 0x2a6746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x1569c6, 0x156146, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x1e2f06, 0x1e2746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x0e5803, 0x0e5046, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x311712, 0x311746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x370e92, 0x370646, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x0d2552, 0x0d2546, 0xe0a187f47c2c4c32, 0xe0a187f47c2c4c32, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x174796, 0x174746, 0xeec44795210f500b, 0xeec44795210f500b, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x286c43, 0x286446, 0xe169ca8a6adbb239, 0xe169ca8a6adbb239, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x300e83, 0x300646, 0xf8652f1e72bc3bd3, 0xf8652f1e72bc3bd3, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x0c6612, 0x0c6646, 0xebb84f7d36dc0510, 0xebb84f7d36dc0510, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x2939c7, 0x293146, 0x843f67c312e338d8, 0x843f67c312e338d8, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x1d2386, 0x1d2302, 0x786bf46ab4c8bc8a, 0x000000000000003e, 0x68e0b6db725ff619, 0x0 }, /* #12 */
    { 0x371797, 0x371702, 0x5024ce4d6a42522b, 0x000000000000003e, 0x49693837565f5ce4, 0x0 }, /* #13 */
    { 0x2e0487, 0x2e0402, 0x8582fc11f429290d, 0x000000000000003e, 0x6488fb5a47e1eb0f, 0x0 }, /* #14 */
    { 0x3a1e82, 0x3a1602, 0x12ed44cf1b85b024, 0x000000000000003e, 0x6f41860ee64baf2b, 0x0 }, /* #15 */
    { 0x3d2e53, 0x3d2606, 0x49be29b595f4bb7d, 0x000000000000003c, 0x16042338092f60b7, 0x0 }, /* #16 */
    { 0x0760c2, 0x076006, 0x82591659326c669b, 0x000000000000003f, 0xada3292d4e8ded4f, 0x0 }, /* #17 */
    { 0x315a16, 0x315206, 0x6eb799c8e230d6f9, 0x000000000000003f, 0x8d1f37a7ed28ae2f, 0x0 }, /* #18 */
    { 0x022bd7, 0x022302, 0xa8a3eb6911b24511, 0x000000000000003d, 0x30fdadb0ec2458d2, 0x0 }, /* #19 */
    { 0x0033d2, 0x003302, 0x45d1ab58965f8a61, 0x000000000000003e, 0x525b3bb62381aa71, 0x0 }, /* #20 */
    { 0x042282, 0x042202, 0x32e93d4e56f72ab4, 0x000000000000003b, 0x0ea9c65709ef64e2, 0x0 }, /* #21 */
    { 0x177687, 0x177606, 0x4e2353ce499c1621, 0x000000000000003f, 0xf9dd8da99a7a91ae, 0x0 }, /* #22 */
    { 0x085813, 0x085002, 0xcb6459186b3cf290, 0x000000000000003e, 0x7fd6c22142b715be, 0x0 }, /* #23 */
    { 0x0d32d7, 0x0d3202, 0x0f030c9c80500c4a, 0x000000000000003e, 0x4e36695258a145c7, 0x0 }, /* #24 */
    { 0x217783, 0x217702, 0x732f972df49efdac, 0x000000000000003e, 0x697ab4068ab754f8, 0x0 }, /* #25 */
    { 0x122242, 0x122202, 0xffed53aa215b20df, 0x000000000000003e, 0x50eb1688385e50f2, 0x0 }, /* #26 */
    { 0x2667d2, 0x266702, 0x5503dc334b2718c6, 0x000000000000003e, 0x672f970a7cffb948, 0x0 }, /* #27 */
    { 0x1029d6, 0x102106, 0x3f316379ba54f1d9, 0x000000000000003a, 0x06a58754e227837f, 0x0 }, /* #28 */
    { 0x246607, 0x246602, 0x60afdec14391c033, 0x000000000000003d, 0x21075db19d137219, 0x0 }, /* #29 */
    { 0x053f02, 0x053706, 0xebcd8f89f3fc9b01, 0x000000000000003f, 0x9adc2c90bc0ac20c, 0x0 }, /* #30 */
    { 0x3e6d53, 0x3e6506, 0x3604ee9d34c8c257, 0x000000000000003f, 0xa2586f7518fb25a0, 0x0 }, /* #31 */
    { 0x384453, 0x384402, 0xf0b39cc2d0c99b12, 0x000000000000003e, 0x4f4b209726b39f46, 0x0 }, /* #32 */
    { 0x3f0282, 0x3f0202, 0xe91012d4fab3b53e, 0x000000000000003e, 0x4d91b38146ed9e91, 0x0 }, /* #33 */
    { 0x085047, 0x085006, 0xd27d7591df00de89, 0x0000000000000039, 0x02011607cc4b89e5, 0x0 }, /* #34 */
    { 0x160696, 0x160602, 0x09c2665d3d3b1847, 0x000000000000003e, 0x6bff1e22865f1438, 0x0 }, /* #35 */
    { 0x3c5347, 0x3c5306, 0xed955017df223ce2, 0x000000000000003f, 0xf1c449ba610b683d, 0x0 }, /* #36 */
    { 0x2f7f03, 0x2f7706, 0x42392991c691f748, 0x000000000000003f, 0xa21cf2c8b6a7a182, 0x0 }, /* #37 */
    { 0x042486, 0x042406, 0xe6ef5a0b9cb6d729, 0x000000000000003f, 0xf49dc00a419e7d8f, 0x0 }, /* #38 */
    { 0x3c70c2, 0x3c7006, 0xe62cece8613df1e2, 0x000000000000003f, 0xc4f9a9b57cdaed0d, 0x0 }, /* #39 */
    { 0x2c3043, 0x2c3002, 0x5f07d8d91a9bc88f, 0x000000000000003e, 0x712864895845a323, 0x0 }, /* #40 */
    { 0x3a2e03, 0x3a2602, 0x92a3c8ea2d74d3c8, 0x000000000000003e, 0x6ad27ce267d951d8, 0x0 }, /* #41 */
    { 0x082747, 0x082702, 0xd5307fdfdcfdb620, 0x000000000000003e, 0x5047087504fb2981, 0x0 }, /* #42 */
    { 0x1e0dc2, 0x1e0506, 0xe01b7cf3de5b8314, 0x000000000000003a, 0x04a957bf272f8e3e, 0x0 }, /* #43 */
    { 0x212212, 0x212206, 0x00657c2ee1effdfb, 0x000000000000003f, 0xb292f7308a79b5a2, 0x0 }, /* #44 */
    { 0x214597, 0x214502, 0xccc8ce5a30702d62, 0x000000000000003e, 0x43397e3cb65507c5, 0x0 }, /* #45 */
    { 0x2e6fc2, 0x2e6702, 0xf3ca16741d213bee, 0x000000000000003b, 0x0f813078b9e49b05, 0x0 }, /* #46 */
    { 0x3e10c6, 0x3e1006, 0x3a566d0dac801b86, 0x000000000000003f, 0xaa03ceb546eab0e2, 0x0 }, /* #47 */
    { 0x0c6216, 0x0c6206, 0xfffa4d5da21bbfde, 0x000000000000003f, 0xeb42aa68d65f3fff, 0x0 }, /* #48 */
    { 0x180613, 0x180606, 0x0ca1c369f82a792d, 0x000000000000003f, 0x893796aef502cc5c, 0x0 }, /* #49 */
    { 0x171ed2, 0x171602, 0x90ecd00773835a8f, 0x000000000000003e, 0x5dcd8585d306e4cd, 0x0 }, /* #50 */
    { 0x1d7706, 0x1d7706, 0x71e636270293966c, 0x000000000000003f, 0xcb68dc54614c5657, 0x0 }, /* #51 */
    { 0x3d0206, 0x3d0206, 0xe884bbf4b1a9c990, 0x000000000000003f, 0xae5c7ffdf6e2301e, 0x0 }, /* #52 */
    { 0x0b3ec6, 0x0b3602, 0xaac02ba793874efb, 0x000000000000003d, 0x2ce15a9c28cd7963, 0x0 }, /* #53 */
    { 0x2e6303, 0x2e6302, 0xcb0aa84bd8d068e6, 0x000000000000003d, 0x202ed79d27e0f31a, 0x0 }, /* #54 */
    { 0x1c1d12, 0x1c1502, 0xa724d6e7b58d19a0, 0x000000000000003e, 0x4ede180501375605, 0x0 }, /* #55 */
    { 0x2e3897, 0x2e3006, 0xd75db0d258caca25, 0x0000000000000039, 0x022e8490fac67210, 0x0 }, /* #56 */
    { 0x395302, 0x395302, 0xf3834c54ea308aea, 0x000000000000003e, 0x4f2b27d809633ad1, 0x0 }, /* #57 */
    { 0x1501c7, 0x150102, 0xe29ec171711c0d6c, 0x000000000000003d, 0x3ebaf7da39474e84, 0x0 }, /* #58 */
    { 0x310786, 0x310706, 0xaa04dca612f17b47, 0x000000000000003f, 0xcf86a112ebfe369b, 0x0 }, /* #59 */
    { 0x031043, 0x031006, 0x73ca98d94b0c956d, 0x000000000000003f, 0xbc4bd199cd0bb7ba, 0x0 }, /* #60 */
    { 0x2902d3, 0x290206, 0x8c29aa561e902025, 0x000000000000003f, 0xf680da19621ad156, 0x0 }, /* #61 */
    { 0x3a0953, 0x3a0102, 0xe0ec9b6220c1051d, 0x000000000000003d, 0x3a1fc706bf5187b7, 0x0 }, /* #62 */
    { 0x372c07, 0x372406, 0x24e8663b172e59b3, 0x000000000000003f, 0xa4b8cdc84f3cc984, 0x0 }, /* #63 */
    { 0x386f02, 0x386702, 0xddb2c2e9c11343a5, 0x000000000000003d, 0x293a57a4f246499c, 0x0 }, /* #64 */
    { 0x1d0316, 0x1d0306, 0x1167e7ef74a86767, 0x000000000000003f, 0xfa0bde001cc5eb0c, 0x0 }, /* #65 */
    { 0x1a08c3, 0x1a0002, 0xfff38b2edd912b0c, 0x000000000000003e, 0x513c66976cf37d7f, 0x0 }, /* #66 */
    { 0x257f82, 0x257706, 0xa618a04413db3781, 0x000000000000003f, 0xdc0bbcaddbf68cb5, 0x0 }, /* #67 */
    { 0x203742, 0x203706, 0x49060f38173ce9b6, 0x000000000000003f, 0xe1868fe87c8d4928, 0x0 }, /* #68 */
    { 0x017682, 0x017606, 0x3350fc26f14d58b8, 0x000000000000003f, 0xa38cee3518d22044, 0x0 }, /* #69 */
    { 0x2f6c46, 0x2f6402, 0x010fe4040830a2a8, 0x000000000000003e, 0x4e011f0f955e8a6c, 0x0 }, /* #70 */
    { 0x216246, 0x216206, 0x41f0d212a5c67651, 0x000000000000003f, 0xace5b5116e681f1f, 0x0 }, /* #71 */
    { 0x074d57, 0x074506, 0x23e56070176a5de2, 0x000000000000003c, 0x15cafeb60d19d4f5, 0x0 }, /* #72 */
    { 0x172f96, 0x172702, 0x8089424bf0664736, 0x000000000000003e, 0x6f82cdef0316227a, 0x0 }, /* #73 */
    { 0x2f2652, 0x2f2602, 0xb4ca8b82053411c6, 0x000000000000003e, 0x410bea30c88148f1, 0x0 }, /* #74 */
    { 0x3c0407, 0x3c0406, 0x0eaac64987dc6377, 0x000000000000003f, 0xfcd9c7e1acc0044c, 0x0 }, /* #75 */
    { 0x1f4013, 0x1f4002, 0xb39a1c1502fa30f9, 0x000000000000003e, 0x5391ae9563f26d2e, 0x0 }, /* #76 */
    { 0x051617, 0x051606, 0x24c439ce564a8165, 0x000000000000003f, 0xd2e683160e84c332, 0x0 }, /* #77 */
    { 0x332ac6, 0x332206, 0xcdd4009a2494640b, 0x000000000000003c, 0x11e14bd8d0ef3dd1, 0x0 }, /* #78 */
    { 0x321ec3, 0x321602, 0x33f1205de64d6183, 0x000000000000003e, 0x78e6674413fe27de, 0x0 }, /* #79 */
    { 0x0a08c7, 0x0a0006, 0x5ec76aa3d14b4baf, 0x000000000000003f, 0xef2bafcaee2b9987, 0x0 }, /* #80 */
    { 0x313807, 0x313006, 0xdf6dc63074eed157, 0x000000000000003f, 0xf673104dc84d2dc2, 0x0 }, /* #81 */
    { 0x2d7d87, 0x2d7502, 0xb293e10c6a6d1c95, 0x000000000000003e, 0x620369ea82118cce, 0x0 }, /* #82 */
    { 0x3f39c3, 0x3f3102, 0x5b280297c7821951, 0x000000000000003b, 0x0a5f95c4eb0237a9, 0x0 }, /* #83 */
    { 0x0c25d7, 0x0c2506, 0x1253075500287851, 0x000000000000003f, 0xaca940fc2e4f97df, 0x0 }, /* #84 */
    { 0x136386, 0x136302, 0x586459af1286c62b, 0x000000000000003e, 0x56cfab6c85060f09, 0x0 }, /* #85 */
    { 0x356f12, 0x356706, 0xbffebe6daddc90f8, 0x000000000000003f, 0xd0b0a992fbf5476a, 0x0 }, /* #86 */
    { 0x380417, 0x380406, 0xab568db7aaa5a405, 0x000000000000003f, 0xe57a27951ed9184b, 0x0 }, /* #87 */
    { 0x1f0916, 0x1f0106, 0x9fee2122640fdb84, 0x000000000000003f, 0x865b2790dea4cd1f, 0x0 }, /* #88 */
    { 0x0f7692, 0x0f7606, 0x3489caf8243d1504, 0x000000000000003f, 0x8112694fb6b7ce2b, 0x0 }, /* #89 */
    { 0x374887, 0x374002, 0x48d2e5168dab47e6, 0x000000000000003e, 0x713d268baf2c6050, 0x0 }, /* #90 */
    { 0x3b2e07, 0x3b2606, 0x725bf6e3ca24649a, 0x000000000000003c, 0x1467ed7db0c77b55, 0x0 }, /* #91 */
    { 0x272993, 0x272102, 0x1be10c5aabc306f6, 0x000000000000003d, 0x22efbc4265c7b927, 0x0 }, /* #92 */
    { 0x224e43, 0x224602, 0x11755afe004a49da, 0x000000000000003d, 0x2a4488f4024b878c, 0x0 }, /* #93 */
    { 0x065b53, 0x065302, 0x4a7c95af5eddb409, 0x000000000000003e, 0x569771e2eaf9cca8, 0x0 }, /* #94 */
    { 0x2e1802, 0x2e1002, 0x4e6c599b13a42121, 0x000000000000003e, 0x7b6229a52f4daa7b, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bsr_u64_intel = RT_ELEMENTS(g_aTests_bsr_u64_intel);

BINU64_TEST_T const g_aTests_imul_two_u64_intel[] =
{
    { 0x352943, 0x352106, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x103702, 0x103706, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x142653, 0x142606, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x1536d3, 0x153606, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x190b07, 0x190306, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x072a56, 0x072206, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x071756, 0x071706, 0xda4979865219b683, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x073ed7, 0x073606, 0x5442b57b8cd90bcc, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x186e93, 0x186606, 0x442ff02737ae3af2, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x0e3287, 0x0e3206, 0x70672bc2f801f890, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x3f0913, 0x3f0106, 0xe3ccc57a1b9a773a, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x307192, 0x307106, 0x48a617feee16b607, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x130692, 0x130e07, 0x3263ace39f73b9ba, 0x4487ee543338dc22, 0xfeb3c42e64f7d8c5, 0x0 }, /* #12 */
    { 0x1d2dd7, 0x1d2d83, 0xf7eb7de434ac3298, 0xd5d3478ae5c3fe58, 0x33b16805270181a9, 0x0 }, /* #13 */
    { 0x3336d7, 0x333e83, 0xf3f640e9ed272d3f, 0x905af3a45a0720ec, 0xa37cc70d33ea6814, 0x0 }, /* #14 */
    { 0x342ed7, 0x342e87, 0xbd252589c659faac, 0xca4a343b7a4d41e4, 0x8f6bfbae6cf91d6b, 0x0 }, /* #15 */
    { 0x397e12, 0x397e03, 0x9d73414bf975c7e7, 0x6751a030312b6702, 0x22fc77f7cd2538ae, 0x0 }, /* #16 */
    { 0x1b0b42, 0x1b0b03, 0x574e894ca4a583be, 0x7ea006dde1c526f4, 0xbf9a126d2dad7fc6, 0x0 }, /* #17 */
    { 0x012b42, 0x012b07, 0x92cdce36432b09ca, 0x494d7ec5d23d3914, 0xdd279905a6a0dbc2, 0x0 }, /* #18 */
    { 0x296007, 0x296887, 0x2e90bfcdb082a95f, 0x8b02e0c95da0f9e2, 0xce0e602a5f98d75e, 0x0 }, /* #19 */
    { 0x1024c2, 0x102c83, 0x6f18c2ea899e431a, 0xb654462e64f1aefe, 0x54c2c524e5af8c3b, 0x0 }, /* #20 */
    { 0x125887, 0x125803, 0x96fbe22ef1f3aa96, 0x2c020a1ec24e4e5e, 0xb45c345857615b2d, 0x0 }, /* #21 */
    { 0x3628c6, 0x362883, 0xe730ed6638b02f6d, 0xfbdda29650f57857, 0x77c14a74a0277853, 0x0 }, /* #22 */
    { 0x125c96, 0x125c07, 0x422c7908429e607e, 0x285e597f3b54065c, 0xacd7f79711cfb152, 0x0 }, /* #23 */
    { 0x3a6183, 0x3a6907, 0xa2a86db8463fadca, 0x09f349d2b1bd8290, 0x474e63a809e41fa8, 0x0 }, /* #24 */
    { 0x2f74c6, 0x2f7c83, 0x952831b683aa020f, 0xd3beebb31dfac7b3, 0x38cc3f4fff5ab41d, 0x0 }, /* #25 */
    { 0x0e7e13, 0x0e7e07, 0x720e44336c484546, 0x1c82210e45e12fcc, 0x9361dd4641f22ce2, 0x0 }, /* #26 */
    { 0x281c12, 0x281c83, 0x347da2e5b64a2d35, 0xd089fff0607acb0b, 0xf0932681dd075f3f, 0x0 }, /* #27 */
    { 0x3e60d2, 0x3e6887, 0x333473146493c35c, 0x91dda27aec27c588, 0x800e919ec139936e, 0x0 }, /* #28 */
    { 0x124c42, 0x124c87, 0x24b3bf6dd907d05e, 0xaa0fc05876c944ac, 0xa1285a7fb3d6d78a, 0x0 }, /* #29 */
    { 0x202092, 0x202803, 0x0e34059c441c4cc7, 0x6ac44b4017cfeb49, 0x92dd24c3d1f5576f, 0x0 }, /* #30 */
    { 0x1c4fc3, 0x1c4f07, 0xc40936022cbe7a27, 0x4f2a3a0ecffb4942, 0x38315e3a70ed1fee, 0x0 }, /* #31 */
    { 0x326843, 0x326887, 0x8f81ee579e583309, 0x939f7c0a6bbcc571, 0xb8ce2dff53b11129, 0x0 }, /* #32 */
    { 0x3d4d97, 0x3d4d87, 0xb82a411f9d5ef530, 0x9623812ee4766cf0, 0x5b69105da4a28715, 0x0 }, /* #33 */
    { 0x185297, 0x185a83, 0x8a44cefa8b9bb769, 0x89471432eeb7ef64, 0xc75ef1913fee0bc4, 0x0 }, /* #34 */
    { 0x3e06c7, 0x3e0e03, 0xc4988bf6864328f7, 0x79bdd43838d3f93d, 0x030a16777120766b, 0x0 }, /* #35 */
    { 0x172f43, 0x172f87, 0x738c91052ee86fbd, 0xa04d5cbaad736b96, 0xa551e097140ce04e, 0x0 }, /* #36 */
    { 0x226f13, 0x226f87, 0xfb3e6a2ff4353300, 0xf34fc366999fb000, 0x3972beeddddf8190, 0x0 }, /* #37 */
    { 0x0a2a02, 0x0a2a87, 0x91c49bad0f2f28f0, 0xbe3492e165cb2990, 0x89a18d1f30417c57, 0x0 }, /* #38 */
    { 0x187452, 0x187c87, 0xeca82ee8e26dd70a, 0xd79e41ac41b63988, 0xc58e2576af14baf4, 0x0 }, /* #39 */
    { 0x1a0c92, 0x1a0c87, 0xd79de46db926bd9e, 0xc310354b30b7cafa, 0x148d0fef658a69f3, 0x0 }, /* #40 */
    { 0x307142, 0x307903, 0xab2c264bc1611985, 0x0354c40e6cc8ddc8, 0x7df344763946ad28, 0x0 }, /* #41 */
    { 0x127d06, 0x127d83, 0x73b8353ef8c0ba70, 0xd320b36206daedd0, 0x8181f5f83d0d71db, 0x0 }, /* #42 */
    { 0x0f1486, 0x0f1c03, 0xd1a4bff7a00b40c7, 0x7b640f5da78bc734, 0x52ee6a5a0fa3332c, 0x0 }, /* #43 */
    { 0x160307, 0x160b03, 0x70a8d233ffe1dc07, 0x76ae744a17c35904, 0x71c0c116d368e5dc, 0x0 }, /* #44 */
    { 0x1b1dd7, 0x1b1d83, 0xef8aad15f1a330af, 0xfc5f4f0054e6b88f, 0x75e4ce8461422e21, 0x0 }, /* #45 */
    { 0x286812, 0x286887, 0xb434023e91646f39, 0x955ef0a21d52ad0a, 0x5693f048e6fd2b5a, 0x0 }, /* #46 */
    { 0x220256, 0x220a87, 0x6c009a8b53002ee6, 0xf89a003f1ee7d914, 0xeed3b958486b3ace, 0x0 }, /* #47 */
    { 0x1e7446, 0x1e7c87, 0xdd2997a8dd534d3b, 0xbbdf835db85291d7, 0xe13c7dcb5693f415, 0x0 }, /* #48 */
    { 0x1c2152, 0x1c2987, 0xf33a217ec0776d0f, 0xe14a53d11087cb24, 0x90df7125b0154a9c, 0x0 }, /* #49 */
    { 0x380a17, 0x380a87, 0x7caf5fcd255cf3f5, 0xbaba3ffec84759de, 0xe6fbc986d34be5a6, 0x0 }, /* #50 */
    { 0x1f1bd2, 0x1f1b07, 0x2cff1e3c025e7a1c, 0x4f8d89e57e36843c, 0xb15f7b9e6bc24339, 0x0 }, /* #51 */
    { 0x2b5983, 0x2b5983, 0xf183ee9ec89e53da, 0x90d806fa41146808, 0x13bcd95e8ea2f394, 0x0 }, /* #52 */
    { 0x282b93, 0x282b03, 0x64189b6769b60d94, 0x5290d5254b0f5c94, 0x32f406b7e63c28c1, 0x0 }, /* #53 */
    { 0x062802, 0x062883, 0x9d73081770a6a37d, 0x842a6c6c1f8a0a16, 0x129575b65776424e, 0x0 }, /* #54 */
    { 0x042742, 0x042f07, 0x30bbf25a9467400c, 0x0277c8dff990cbe4, 0x32da2649dd0c9653, 0x0 }, /* #55 */
    { 0x253546, 0x253d87, 0x44850518cf98d9f7, 0xbc2fa7ac8ba66912, 0xf1f1b8225fb98afe, 0x0 }, /* #56 */
    { 0x207ad2, 0x207a07, 0x3c05e879f8b603dc, 0x5c14fcca1712a118, 0x47bbeba49cee4e6a, 0x0 }, /* #57 */
    { 0x241686, 0x241e87, 0x02c8c051794fa9cf, 0xe8e808968dce287b, 0x6accad6de9e63d95, 0x0 }, /* #58 */
    { 0x2b2993, 0x2b2907, 0xf924bd8918779ddb, 0x047c28636c534f71, 0x35f1d56b4e2b77a3, 0x0 }, /* #59 */
    { 0x3a6a47, 0x3a6a07, 0x5a4fe86a77923695, 0x54d4dd1ab603d14d, 0xa3a2bdedb00319d9, 0x0 }, /* #60 */
    { 0x2c2d96, 0x2c2d83, 0x2489662ee47b4d7a, 0xd197cdec780676da, 0xac453db96da24a71, 0x0 }, /* #61 */
    { 0x024817, 0x024803, 0x278019ee93df5e69, 0x2f0f249b9eb9ad34, 0x76296d7143b44514, 0x0 }, /* #62 */
    { 0x071947, 0x071983, 0xf87b3025fe980cef, 0xf33a60ead445551f, 0xdb34c4af39559ad1, 0x0 }, /* #63 */
    { 0x3d1e03, 0x3d1e83, 0x95d7765108b011ba, 0xb293c4bcc499f22c, 0xcd68aaa18c38210e, 0x0 }, /* #64 */
    { 0x1b2b52, 0x1b2b83, 0x322964cc2875327c, 0x88df38d7b3790ab0, 0x8ef0b6aa46d3d1d4, 0x0 }, /* #65 */
    { 0x0b6bd2, 0x0b6b03, 0x7290bc7f1ee9f97c, 0x190d86a337cb9ef8, 0xd2f48599ad93f502, 0x0 }, /* #66 */
    { 0x036502, 0x036d03, 0x91124100604a73c5, 0x0cbc15b529669854, 0xadfdb3277225f844, 0x0 }, /* #67 */
    { 0x076503, 0x076d07, 0x767732e67b68c077, 0x5c1648bbe546e6d4, 0xf520a3b36e48b8cc, 0x0 }, /* #68 */
    { 0x230203, 0x230a87, 0x3b8a2c01ba7e7678, 0xa1649eb678a64b90, 0x326cbf99cdee6bee, 0x0 }, /* #69 */
    { 0x042dc6, 0x042d07, 0xff346ca965466dd5, 0x44ca317123cb7e77, 0x4954d18d8ef5c51b, 0x0 }, /* #70 */
    { 0x014c17, 0x014c03, 0xe24c5e7bd7291ca9, 0x354bc0f064cf784a, 0xd15be2c20e396a3a, 0x0 }, /* #71 */
    { 0x034557, 0x034d87, 0x42dacd31cea955bf, 0xee19f2bd7d034430, 0x5cafd273cf02a7d0, 0x0 }, /* #72 */
    { 0x242542, 0x242d07, 0x5050bafe1e36634b, 0x3fb209292f84d022, 0x74b6fd06efa75926, 0x0 }, /* #73 */
    { 0x0f68c3, 0x0f6883, 0x4083919810cfcdbf, 0xae5d29bb702a3b80, 0x1e4c9d0ebecba480, 0x0 }, /* #74 */
    { 0x253a56, 0x253a07, 0x45833b7d1c1135c2, 0x4d1102d6800a65f6, 0xc7aebfbb7ba7c55b, 0x0 }, /* #75 */
    { 0x252782, 0x252f03, 0x7e7ea92b169dfaf3, 0x4b0e75e029aab586, 0x5a12562acf04e9e2, 0x0 }, /* #76 */
    { 0x260492, 0x260c87, 0x74848a94a7f7e004, 0xd456a02fdbb59bd8, 0x45794768519116f6, 0x0 }, /* #77 */
    { 0x0c6643, 0x0c6e87, 0x2cc942db4f4bd9f8, 0xdb851b8f6dfcab00, 0x30da487f2b6ff2a0, 0x0 }, /* #78 */
    { 0x314747, 0x314f07, 0xfec9bf31b96c8af0, 0x1868717dcc9db160, 0xeeb46ea8fb96cfca, 0x0 }, /* #79 */
    { 0x0929c7, 0x092987, 0xb1fbaf1b9e80f8e6, 0xd72b1a4651689a3c, 0x69d4798fb57c44ea, 0x0 }, /* #80 */
    { 0x062cd7, 0x062c03, 0x3c61b679fcf5294e, 0x69a1f8b458984d1c, 0xa9cc5acc4ccc80c2, 0x0 }, /* #81 */
    { 0x1841d6, 0x184987, 0x31e63f6be6cb1589, 0x81ea3ccd6bcc78b7, 0xb939b1aae421cc3f, 0x0 }, /* #82 */
    { 0x117603, 0x117e83, 0x0977bdde0b8a977b, 0xb4f8de47de7c52c2, 0xb2da2a1bd0a27ba6, 0x0 }, /* #83 */
    { 0x3a2857, 0x3a2803, 0x668566954cbb4135, 0x4026e767243b8b8f, 0x13bc14034b671633, 0x0 }, /* #84 */
    { 0x2705c3, 0x270d03, 0x4572db78e14718fe, 0x43b57c71ca768da4, 0x9c83f0984dc3f82e, 0x0 }, /* #85 */
    { 0x0c0bc6, 0x0c0b83, 0x27ad3b2d4ebd00ef, 0xb0e4de6248c22645, 0x2b37ba581a96a40b, 0x0 }, /* #86 */
    { 0x1f7056, 0x1f7807, 0xbc636606a1eb1265, 0x139e4219205e4817, 0x675a355b13f7cacb, 0x0 }, /* #87 */
    { 0x2147c2, 0x214f07, 0x3f84b68d300e6767, 0x0080c3ae8b9d9733, 0xd6b46fbaa9016e55, 0x0 }, /* #88 */
    { 0x063e17, 0x063e87, 0x84a33ada36653732, 0x9cd35860e77792b2, 0xa2a5b53a6f5d33c1, 0x0 }, /* #89 */
    { 0x2d6887, 0x2d6883, 0x1ff76a97d573a7d0, 0x86591ee8337486b0, 0x1b35b1201c079b07, 0x0 }, /* #90 */
    { 0x355202, 0x355a03, 0x8b876eab30ced261, 0x731eef7673656a5d, 0x47377f442cd8517d, 0x0 }, /* #91 */
    { 0x1718c3, 0x171887, 0x724f0f33135dcea0, 0xb2dad7b4e70bfba0, 0x1336a4ef9ecdcec9, 0x0 }, /* #92 */
    { 0x0f68d6, 0x0f6807, 0xb6d60c569ee17794, 0x4f94a1b517e51624, 0x3e281b9c8aa42ed5, 0x0 }, /* #93 */
    { 0x191f92, 0x191f83, 0x181335b027a2d1a7, 0x9d5a7a24f21dd479, 0xc119d3e7e1cbacdf, 0x0 }, /* #94 */
    { 0x361083, 0x361807, 0x473a64d3eef23fbd, 0x473b853d5550489c, 0x8e69125ea60c56cc, 0x0 }, /* #95 */
};
uint32_t const g_cTests_imul_two_u64_intel = RT_ELEMENTS(g_aTests_imul_two_u64_intel);

BINU16_TEST_T const g_aTests_shld_u16_intel[] =
{
    { 0x363397, 0x363346, 0x0000, 0x0000, 0x0000, 43 }, /* #0 */
    { 0x1c2dc3, 0x1c2546, 0x0000, 0x0000, 0x0000, 12 }, /* #1 */
    { 0x277c07, 0x277446, 0x0000, 0x0000, 0x0000, 63 }, /* #2 */
    { 0x383d93, 0x383546, 0x0000, 0x0000, 0x0000,  4 }, /* #3 */
    { 0x1d29d2, 0x1d2146, 0x0000, 0x0000, 0x0000, 58 }, /* #4 */
    { 0x177f12, 0x177746, 0x0000, 0x0000, 0x0000, 45 }, /* #5 */
    { 0x0a1a87, 0x0a1a87, 0x609c, 0x8000, 0x0000, 45 }, /* #6 */
    { 0x276f97, 0x276f06, 0x40e8, 0x7400, 0x0000,  7 }, /* #7 */
    { 0x3c2043, 0x3c2046, 0xf4c0, 0x0000, 0x0000, 45 }, /* #8 */
    { 0x3e5b07, 0x3e5b02, 0x7bdb, 0x0007, 0x0000, 20 }, /* #9 */
    { 0x3c7082, 0x3c7882, 0x6764, 0xec80, 0x0000,  5 }, /* #10 */
    { 0x294fc2, 0x294f06, 0x6a3d, 0x7a00, 0x0000, 41 }, /* #11 */
    { 0x1e6646, 0x1e6606, 0x2d53, 0x7f8b, 0xe1fe, 22 }, /* #12 */
    { 0x1030c6, 0x1030c6, 0x43af, 0x43af, 0xc9d4, 32 }, /* #13 */
    { 0x0e7956, 0x0e7186, 0xc9d7, 0xb89a, 0x134f, 11 }, /* #14 */
    { 0x2d72d3, 0x2d7202, 0xdbac, 0x6dd6, 0x40ac, 31 }, /* #15 */
    { 0x2504d2, 0x250c82, 0x4438, 0xd808, 0xd6c0, 53 }, /* #16 */
    { 0x3b0617, 0x3b0617, 0xaa19, 0xaa19, 0x0274, 32 }, /* #17 */
    { 0x0f10d6, 0x0f1083, 0xca13, 0xb90b, 0xee42, 18 }, /* #18 */
    { 0x106217, 0x106282, 0xc80f, 0xe96b, 0x3a5a, 50 }, /* #19 */
    { 0x2d00c2, 0x2d0802, 0x5628, 0x6d58, 0xb99b, 26 }, /* #20 */
    { 0x1c6d86, 0x1c6587, 0xc968, 0x92d1, 0x9be9,  1 }, /* #21 */
    { 0x0233c7, 0x023b03, 0xb3bd, 0x275b, 0xf275, 52 }, /* #22 */
    { 0x251e96, 0x251e87, 0x9f4a, 0xe953, 0x9d1d, 37 }, /* #23 */
    { 0x3b1c47, 0x3b1c07, 0x9de4, 0x3bc9, 0x925b,  1 }, /* #24 */
    { 0x183303, 0x183303, 0xd15f, 0x1c7a, 0x68e3, 53 }, /* #25 */
    { 0x2f4c03, 0x2f4c06, 0x6161, 0x72f6, 0xcbd8, 14 }, /* #26 */
    { 0x175606, 0x175e07, 0x8318, 0x1063, 0x44b8, 29 }, /* #27 */
    { 0x112542, 0x112d83, 0x8e58, 0x9625, 0x96a2,  6 }, /* #28 */
    { 0x2c44d6, 0x2c4c02, 0x8445, 0x1116, 0xb824, 34 }, /* #29 */
    { 0x280bc2, 0x280b87, 0x7d55, 0xeaaa, 0x5791, 35 }, /* #30 */
    { 0x2143c7, 0x214b02, 0xb322, 0x6457, 0xb992, 37 }, /* #31 */
    { 0x0d1447, 0x0d1c83, 0xb5cd, 0xed73, 0x89df, 30 }, /* #32 */
    { 0x084c43, 0x084c83, 0x5fa3, 0xd1c4, 0x896d, 39 }, /* #33 */
    { 0x3d23d6, 0x3d2386, 0x0ae7, 0xfc2b, 0x8d3f, 58 }, /* #34 */
    { 0x312217, 0x312282, 0x0f64, 0x88c1, 0xf446, 21 }, /* #35 */
    { 0x3e3d83, 0x3e3583, 0xe4c2, 0xc985, 0xde11, 33 }, /* #36 */
    { 0x2321d2, 0x232902, 0x9374, 0x404a, 0x1012, 50 }, /* #37 */
    { 0x0b0603, 0x0b0e83, 0xb2c0, 0x817f, 0xbfa9,  9 }, /* #38 */
    { 0x011403, 0x011483, 0xeee6, 0xddcd, 0x82fb,  1 }, /* #39 */
    { 0x244307, 0x244b03, 0x98fa, 0x5b64, 0xab6c, 19 }, /* #40 */
    { 0x0212d3, 0x021a07, 0x5485, 0x00e2, 0x201c, 19 }, /* #41 */
    { 0x011c46, 0x011406, 0x2670, 0x1ef9, 0x7be6, 46 }, /* #42 */
    { 0x1f6397, 0x1f6386, 0xf3c5, 0x9fe7, 0x27f9, 50 }, /* #43 */
    { 0x1e7c93, 0x1e7c06, 0x4b5f, 0x125a, 0x2402, 27 }, /* #44 */
    { 0x337812, 0x337083, 0xdcf8, 0x85df, 0x5df9, 12 }, /* #45 */
    { 0x3b2956, 0x3b2182, 0xcc81, 0x93a4, 0x2749, 47 }, /* #46 */
    { 0x2c2357, 0x2c2382, 0xd8f5, 0xf532, 0x32d4,  8 }, /* #47 */
    { 0x112f42, 0x112706, 0xda62, 0x174d, 0xc174, 20 }, /* #48 */
    { 0x357283, 0x357a06, 0x4897, 0x3a44, 0xff87, 59 }, /* #49 */
    { 0x276002, 0x276882, 0x4d6b, 0xa4d6, 0xf02a, 28 }, /* #50 */
    { 0x091bc3, 0x091b07, 0x8aee, 0x0bb1, 0x585d, 53 }, /* #51 */
    { 0x334b86, 0x334b07, 0xa710, 0x6cdd, 0x6d9b, 51 }, /* #52 */
    { 0x2b4957, 0x2b4187, 0x0b7b, 0xdb7b, 0x6f7c, 43 }, /* #53 */
    { 0x252ed6, 0x252683, 0xc755, 0xf1d5, 0xfa9f, 62 }, /* #54 */
    { 0x2f0ac6, 0x2f0a02, 0x58a0, 0x5d2c, 0x1cba, 55 }, /* #55 */
    { 0x314253, 0x314253, 0xac29, 0xac29, 0xc811, 32 }, /* #56 */
    { 0x0413d3, 0x041387, 0xfb9c, 0xdce7, 0xe3ad,  3 }, /* #57 */
    { 0x0a0442, 0x0a0c06, 0x4763, 0x763a, 0xa662,  4 }, /* #58 */
    { 0x2228c2, 0x222087, 0xe906, 0x8748, 0xa0b0, 27 }, /* #59 */
    { 0x3a0482, 0x3a0c87, 0x6a1c, 0xcb50, 0x9279, 27 }, /* #60 */
    { 0x236297, 0x236287, 0xd56f, 0xcea0, 0x3a83, 46 }, /* #61 */
    { 0x307492, 0x307c87, 0x7db1, 0xb244, 0xd922, 49 }, /* #62 */
    { 0x305bd3, 0x305383, 0xdf61, 0xc8df, 0x17c8, 56 }, /* #63 */
    { 0x0f04d7, 0x0f0c03, 0xb200, 0x16c8, 0x3745, 26 }, /* #64 */
    { 0x031082, 0x031082, 0xf91d, 0x86c4, 0x0d88, 47 }, /* #65 */
    { 0x2a7087, 0x2a7083, 0x2646, 0x804c, 0xd6c0, 25 }, /* #66 */
    { 0x2a1313, 0x2a1386, 0x1114, 0x8a42, 0x84c2, 39 }, /* #67 */
    { 0x382e87, 0x382607, 0xdab4, 0x68c0, 0x6006,  9 }, /* #68 */
    { 0x045716, 0x045703, 0xfb58, 0x7ed6, 0x46bd, 62 }, /* #69 */
    { 0x390197, 0x390106, 0xe1fe, 0x1999, 0x1999, 48 }, /* #70 */
    { 0x221f83, 0x221f03, 0x99ce, 0x6719, 0x5671, 20 }, /* #71 */
    { 0x1f5a02, 0x1f5203, 0xcd42, 0x3508, 0x0f8c,  2 }, /* #72 */
    { 0x066347, 0x066b82, 0x88b8, 0xd08c, 0x9a11, 51 }, /* #73 */
    { 0x1975d7, 0x197507, 0xec87, 0x3d90, 0xafc9, 29 }, /* #74 */
    { 0x092192, 0x092983, 0x7f8b, 0xe8bf, 0x13d1, 55 }, /* #75 */
    { 0x266686, 0x266e86, 0xaef4, 0xd5de, 0x2366, 29 }, /* #76 */
    { 0x1f6013, 0x1f6002, 0x01f4, 0x07d0, 0x2067, 34 }, /* #77 */
    { 0x0c45c6, 0x0c4d06, 0x74ea, 0x678e, 0xa33c, 21 }, /* #78 */
    { 0x092816, 0x092087, 0xdabc, 0xe7c5, 0xf8a9, 11 }, /* #79 */
    { 0x097cd7, 0x097c07, 0x6228, 0x38b1, 0x2671, 23 }, /* #80 */
    { 0x2044c3, 0x204406, 0x3236, 0x646c, 0x381b, 33 }, /* #81 */
    { 0x2e7e56, 0x2e7682, 0x2add, 0xed4f, 0xa9f8, 11 }, /* #82 */
    { 0x130fd2, 0x130706, 0xf50a, 0x14ac, 0x5622, 41 }, /* #83 */
    { 0x3e5a52, 0x3e5a02, 0xab88, 0x200b, 0x02f6, 42 }, /* #84 */
    { 0x1333d6, 0x133383, 0x2958, 0x83ab, 0x3ab6, 44 }, /* #85 */
    { 0x297857, 0x297802, 0x60d7, 0x1b98, 0x886e, 22 }, /* #86 */
    { 0x094d97, 0x094d06, 0x7189, 0x25ac, 0x6b15, 42 }, /* #87 */
    { 0x1a7bd3, 0x1a7302, 0x11b2, 0x6cba, 0xe9c7,  6 }, /* #88 */
    { 0x0727c7, 0x072f03, 0x8862, 0x10c4, 0x0a03, 33 }, /* #89 */
    { 0x023987, 0x023987, 0xa510, 0xa510, 0xf174, 32 }, /* #90 */
    { 0x351642, 0x351682, 0xc34b, 0xe93e, 0xa4fb, 46 }, /* #91 */
    { 0x1401d6, 0x140982, 0x5e61, 0xbcc2, 0x1b41,  1 }, /* #92 */
    { 0x1f10d7, 0x1f1887, 0x887d, 0xbc05, 0xe02c, 45 }, /* #93 */
    { 0x336d53, 0x336582, 0x0540, 0xa010, 0x202d,  7 }, /* #94 */
    { 0x1b31d2, 0x1b3983, 0xa374, 0xbf68, 0x26fd, 22 }, /* #95 */
    { 0x3b3b13, 0x3b3b07, 0x93ed, 0x2d27, 0x8396, 25 }, /* #96 */
    { 0x392fc7, 0x392f02, 0x825b, 0x096d, 0x443c,  2 }, /* #97 */
    { 0x064c17, 0x064c17, 0x61d6, 0x61d6, 0xe2f6,  0 }, /* #98 */
    { 0x114317, 0x114387, 0x2f30, 0xe603, 0x18c8, 37 }, /* #99 */
    { 0x383b86, 0x383b06, 0x6f96, 0x58ed, 0x3b50, 10 }, /* #100 */
    { 0x0161d7, 0x016906, 0x4040, 0x45d1, 0x1174, 50 }, /* #101 */
    { 0x1351d3, 0x135103, 0xf010, 0x3c04, 0xdb5c, 62 }, /* #102 */
    { 0x171986, 0x171987, 0xb719, 0xd0b7, 0xfdd0, 56 }, /* #103 */
    { 0x093c92, 0x093406, 0x34f4, 0x154e, 0x154e, 48 }, /* #104 */
    { 0x0c7cd2, 0x0c7407, 0x1fa3, 0x07e8, 0x8b84, 62 }, /* #105 */
    { 0x341cc7, 0x341483, 0xefec, 0xdefe, 0xf7bd, 28 }, /* #106 */
    { 0x3d73c6, 0x3d7386, 0x1ec1, 0x8f60, 0x10c1, 63 }, /* #107 */
    { 0x030687, 0x030606, 0xdc09, 0x27b1, 0xec62, 10 }, /* #108 */
    { 0x177697, 0x177e82, 0x7e22, 0xcfc4, 0x6296, 61 }, /* #109 */
    { 0x3f25d3, 0x3f2d86, 0xad7b, 0xfad7, 0x2f8f, 60 }, /* #110 */
    { 0x2e6ac6, 0x2e6a87, 0xbf63, 0xec72, 0x94cd,  5 }, /* #111 */
    { 0x371343, 0x371307, 0xea75, 0x53ac, 0x96c7, 35 }, /* #112 */
    { 0x3733c7, 0x373b82, 0x77a0, 0xc6ef, 0x5c63, 25 }, /* #113 */
    { 0x1270d6, 0x127807, 0x5e89, 0x38a6, 0x38a6, 48 }, /* #114 */
    { 0x311c57, 0x311c03, 0x4a4d, 0x24a4, 0x8af2, 60 }, /* #115 */
    { 0x2c4502, 0x2c4d87, 0x5d69, 0x975a, 0xdfbe, 30 }, /* #116 */
    { 0x227f47, 0x227f83, 0x6b1b, 0xb867, 0x8676, 44 }, /* #117 */
    { 0x0c7003, 0x0c7087, 0xd117, 0xda22, 0x5c0e, 29 }, /* #118 */
    { 0x333c07, 0x333402, 0x1779, 0x22ef, 0x87e1, 61 }, /* #119 */
    { 0x3e4443, 0x3e4486, 0xe7bb, 0xf9ee, 0x2433, 62 }, /* #120 */
    { 0x325947, 0x325947, 0x23a4, 0x23a4, 0x4f75, 32 }, /* #121 */
    { 0x233b06, 0x233b07, 0x4d0b, 0x342e, 0xb79e, 34 }, /* #122 */
    { 0x073397, 0x073397, 0xc0ae, 0xc0ae, 0xcf3d,  0 }, /* #123 */
    { 0x373e07, 0x373e87, 0xadbc, 0x8224, 0x1123, 13 }, /* #124 */
    { 0x2c2c16, 0x2c2487, 0x373e, 0xe366, 0x5f1b, 21 }, /* #125 */
    { 0x067002, 0x067006, 0x2020, 0x082b, 0xadd4,  6 }, /* #126 */
    { 0x0a5406, 0x0a5486, 0x3a20, 0xc87b, 0xc87b, 16 }, /* #127 */
};
uint32_t const g_cTests_shld_u16_intel = RT_ELEMENTS(g_aTests_shld_u16_intel);

BINU16_TEST_T const g_aTests_shrd_u16_intel[] =
{
    { 0x0e11c3, 0x0e1146, 0x0000, 0x0000, 0x0000, 41 }, /* #0 */
    { 0x3c6112, 0x3c6146, 0x0000, 0x0000, 0x0000, 55 }, /* #1 */
    { 0x257e92, 0x257646, 0x0000, 0x0000, 0x0000, 31 }, /* #2 */
    { 0x0b2292, 0x0b2246, 0x0000, 0x0000, 0x0000,  1 }, /* #3 */
    { 0x016c12, 0x016446, 0x0000, 0x0000, 0x0000, 22 }, /* #4 */
    { 0x290c43, 0x290446, 0x0000, 0x0000, 0x0000, 10 }, /* #5 */
    { 0x397fd7, 0x397f02, 0xc131, 0x0c13, 0x0000,  4 }, /* #6 */
    { 0x0b32d3, 0x0b3247, 0x6a34, 0x0000, 0x0000, 15 }, /* #7 */
    { 0x0e2d46, 0x0e2502, 0x561a, 0x0001, 0x0000, 46 }, /* #8 */
    { 0x206b46, 0x206302, 0x434e, 0x0008, 0x0000, 11 }, /* #9 */
    { 0x047217, 0x047a02, 0xb1fc, 0x58fe, 0x0000,  1 }, /* #10 */
    { 0x3a0453, 0x3a0c06, 0xa415, 0x0005, 0x0000, 13 }, /* #11 */
    { 0x026ad6, 0x026286, 0xf92b, 0xafc9, 0xf975, 37 }, /* #12 */
    { 0x336903, 0x336102, 0xc95d, 0x5746, 0x1975, 26 }, /* #13 */
    { 0x112497, 0x112c87, 0x1e56, 0xed63, 0x376b, 43 }, /* #14 */
    { 0x201786, 0x201787, 0x66cd, 0xcda5, 0xa5dc, 24 }, /* #15 */
    { 0x306007, 0x306086, 0xfa2e, 0xfd17, 0x867f,  1 }, /* #16 */
    { 0x295f82, 0x295707, 0xa67c, 0x74cf, 0xbe0b,  3 }, /* #17 */
    { 0x360997, 0x360187, 0xb8f4, 0xad2d, 0x55a5, 13 }, /* #18 */
    { 0x211c03, 0x211482, 0x90ca, 0xbc79, 0x0bc7, 44 }, /* #19 */
    { 0x1a60c3, 0x1a6002, 0x42b8, 0x0857, 0x9890,  3 }, /* #20 */
    { 0x3f6296, 0x3f6a06, 0xcbf8, 0x3159, 0xc564, 50 }, /* #21 */
    { 0x072f42, 0x072783, 0x6815, 0xac8c, 0x9196, 53 }, /* #22 */
    { 0x3f0097, 0x3f0803, 0x0404, 0x042a, 0x2a93, 56 }, /* #23 */
    { 0x3c4fc2, 0x3c4782, 0x4873, 0x873b, 0xb058, 28 }, /* #24 */
    { 0x2b4b03, 0x2b4b87, 0x5958, 0xcaca, 0x4039, 37 }, /* #25 */
    { 0x190cd3, 0x190487, 0x7f6d, 0xb517, 0xa8be, 51 }, /* #26 */
    { 0x3a7d02, 0x3a7d07, 0x09a8, 0x4d41, 0x3d7d, 61 }, /* #27 */
    { 0x382ac3, 0x382203, 0xae71, 0x5ce3, 0xd9d7, 31 }, /* #28 */
    { 0x3b0893, 0x3b0082, 0x8dc4, 0xec6e, 0xfedd, 37 }, /* #29 */
    { 0x2b14d3, 0x2b1c02, 0x3f1c, 0x4fc7, 0xc781,  2 }, /* #30 */
    { 0x083dc7, 0x083d02, 0xf032, 0x534c, 0xa698, 49 }, /* #31 */
    { 0x1453c7, 0x145307, 0x823e, 0x7cac, 0x5663, 55 }, /* #32 */
    { 0x004317, 0x004b86, 0x2272, 0xb227, 0xfb8b,  4 }, /* #33 */
    { 0x2b36d6, 0x2b3e82, 0xf220, 0xa69e, 0x0534, 43 }, /* #34 */
    { 0x3f4942, 0x3f4102, 0xdf00, 0x0ddf, 0x560d,  8 }, /* #35 */
    { 0x383082, 0x383002, 0xdfb7, 0x5dfb, 0x1de5, 36 }, /* #36 */
    { 0x0f2812, 0x0f2083, 0x67cc, 0x884c, 0x7c42, 11 }, /* #37 */
    { 0x262783, 0x262706, 0x7106, 0x379c, 0xf386, 21 }, /* #38 */
    { 0x3b3846, 0x3b3007, 0x48a6, 0x5314, 0x2968, 57 }, /* #39 */
    { 0x330302, 0x330b07, 0x7a3a, 0x3de8, 0xda4f,  6 }, /* #40 */
    { 0x332b02, 0x332382, 0xaf1a, 0xf1a8, 0x85c3, 28 }, /* #41 */
    { 0x044916, 0x044186, 0xe997, 0xffa6, 0xadbf,  6 }, /* #42 */
    { 0x275fd2, 0x275f83, 0x0dbe, 0xf475, 0x8eb5, 21 }, /* #43 */
    { 0x0b2c16, 0x0b2c07, 0x52a5, 0x46d4, 0x251b, 42 }, /* #44 */
    { 0x2d33d7, 0x2d3307, 0x12b6, 0x2b6c, 0xc9c6, 28 }, /* #45 */
    { 0x293613, 0x293e07, 0x275a, 0x105c, 0x20b9, 49 }, /* #46 */
    { 0x0855c3, 0x085d06, 0xa7db, 0x3edd, 0xa114, 29 }, /* #47 */
    { 0x2445c2, 0x244d83, 0xfa2c, 0x9f45, 0x6eec,  3 }, /* #48 */
    { 0x221953, 0x221186, 0xc5ce, 0xbca9, 0xf2a5, 50 }, /* #49 */
    { 0x0552c6, 0x055287, 0x5d53, 0xb0b2, 0x5616, 45 }, /* #50 */
    { 0x310293, 0x310a86, 0x6bf8, 0xae2d, 0xbd71, 43 }, /* #51 */
    { 0x276513, 0x276d02, 0x6f2f, 0x760b, 0x4ec1, 13 }, /* #52 */
    { 0x3d4117, 0x3d4183, 0x742b, 0xe507, 0x941e, 18 }, /* #53 */
    { 0x162b43, 0x162383, 0xe38f, 0xf8e3, 0xe61f,  2 }, /* #54 */
    { 0x111b13, 0x111302, 0x646b, 0x51dc, 0x51dc, 16 }, /* #55 */
    { 0x3a7352, 0x3a7302, 0x5092, 0x125b, 0xda7e, 27 }, /* #56 */
    { 0x136a56, 0x136a82, 0x2e02, 0xb80b, 0xce29, 62 }, /* #57 */
    { 0x194752, 0x194f07, 0x7b53, 0x4eb4, 0xad21, 22 }, /* #58 */
    { 0x000c96, 0x000c02, 0x9c05, 0x24e0, 0xeba4, 37 }, /* #59 */
    { 0x324306, 0x324b83, 0x1692, 0xb491, 0x36f3, 29 }, /* #60 */
    { 0x1c5057, 0x1c5003, 0x6931, 0x3498, 0xe5c8, 33 }, /* #61 */
    { 0x1a5407, 0x1a5c87, 0xebc7, 0x88ed, 0xc476, 15 }, /* #62 */
    { 0x344312, 0x344b86, 0xa108, 0xba84, 0xc12e,  6 }, /* #63 */
    { 0x374343, 0x374b03, 0x2310, 0x3ac4, 0x8eb1, 14 }, /* #64 */
    { 0x267a86, 0x267206, 0x3872, 0x1c39, 0xb8ea,  1 }, /* #65 */
    { 0x1b6743, 0x1b6707, 0xb79d, 0x4836, 0x6241, 43 }, /* #66 */
    { 0x3804d6, 0x380c87, 0x8bc6, 0x8d3c, 0x9e66, 55 }, /* #67 */
    { 0x2e2107, 0x2e2106, 0x3a7c, 0x3e05, 0x0aa8, 57 }, /* #68 */
    { 0x2c3a53, 0x2c3202, 0x2561, 0x0958, 0x862c,  2 }, /* #69 */
    { 0x217343, 0x217b83, 0x73df, 0xb9ef, 0x01eb,  1 }, /* #70 */
    { 0x0d7582, 0x0d7d07, 0xeaae, 0x55cf, 0x7d80, 59 }, /* #71 */
    { 0x161c57, 0x161c83, 0x2d87, 0xfe92, 0x5fe9, 12 }, /* #72 */
    { 0x242f17, 0x242f86, 0x1e24, 0x9ac5, 0x9ac5, 16 }, /* #73 */
    { 0x3620d3, 0x362803, 0xf365, 0x3652, 0x29f6, 28 }, /* #74 */
    { 0x266f02, 0x266702, 0x2171, 0x767a, 0x767a, 48 }, /* #75 */
    { 0x2f47c6, 0x2f4f02, 0x284d, 0x69e3, 0xa78d, 18 }, /* #76 */
    { 0x345186, 0x345183, 0x6cf7, 0xd4d9, 0xb4ea, 39 }, /* #77 */
    { 0x352ec6, 0x352603, 0xc63a, 0x31d6, 0xdd83, 29 }, /* #78 */
    { 0x3d2ec3, 0x3d2e82, 0x06c2, 0xffa2, 0xffd1, 47 }, /* #79 */
    { 0x183f42, 0x183f07, 0x23a7, 0x013c, 0x404f, 46 }, /* #80 */
    { 0x160bc6, 0x160302, 0xacf6, 0x67b0, 0x0515, 61 }, /* #81 */
    { 0x0e7f47, 0x0e7f03, 0xf290, 0x7767, 0x2eec, 13 }, /* #82 */
    { 0x0f5192, 0x0f5983, 0x2c57, 0xbd25, 0xa4bb, 21 }, /* #83 */
    { 0x3b54c6, 0x3b5c83, 0x64fc, 0xb72c, 0x65b9, 11 }, /* #84 */
    { 0x3971d2, 0x397902, 0x094b, 0x2cfe, 0x3f8b, 22 }, /* #85 */
    { 0x294643, 0x294683, 0x659d, 0x9d29, 0x29a0, 24 }, /* #86 */
    { 0x314117, 0x314106, 0x4154, 0x41ca, 0x1ca2, 52 }, /* #87 */
    { 0x266892, 0x266087, 0x7277, 0xa09c, 0x7682, 10 }, /* #88 */
    { 0x2078c7, 0x207806, 0x35de, 0x7d4d, 0xddf5, 10 }, /* #89 */
    { 0x116686, 0x116687, 0xf1dc, 0xc6de, 0x6ded, 52 }, /* #90 */
    { 0x0d0dc6, 0x0d0d83, 0x3ec7, 0xf3a7, 0x9d3f, 19 }, /* #91 */
    { 0x102dc2, 0x102d03, 0xdb3b, 0x46d9, 0x5c48,  5 }, /* #92 */
    { 0x197842, 0x197806, 0xbe1b, 0x485f, 0x8290, 41 }, /* #93 */
    { 0x086992, 0x086103, 0x7765, 0x4683, 0x48d0, 13 }, /* #94 */
    { 0x011f03, 0x011f82, 0xef3e, 0xcf8f, 0x3c9a, 58 }, /* #95 */
    { 0x297f53, 0x297f03, 0x0f86, 0x7143, 0x6dc5, 42 }, /* #96 */
    { 0x2c2697, 0x2c2e87, 0x8745, 0xd153, 0x4f32, 58 }, /* #97 */
    { 0x3d3753, 0x3d3f02, 0xac89, 0x4564, 0xf688, 37 }, /* #98 */
    { 0x317d43, 0x317586, 0x7ce7, 0xce74, 0x432c, 60 }, /* #99 */
    { 0x043e57, 0x043602, 0x790f, 0x3e98, 0xa616, 54 }, /* #100 */
    { 0x0f7ec7, 0x0f7602, 0x773b, 0x73b9, 0x92ce, 60 }, /* #101 */
    { 0x0a25c3, 0x0a2583, 0x5877, 0xad02, 0xb5a0, 13 }, /* #102 */
    { 0x306606, 0x306682, 0xeadb, 0xe7ab, 0x8b39,  6 }, /* #103 */
    { 0x0903c6, 0x090382, 0xfc96, 0xe8fe, 0x93d1,  9 }, /* #104 */
    { 0x350cd7, 0x350487, 0x351e, 0x8d47, 0xcf8a, 34 }, /* #105 */
    { 0x294093, 0x294086, 0xf66a, 0xecd4, 0x0801, 63 }, /* #106 */
    { 0x341d97, 0x341583, 0x17ec, 0xc2fd, 0xab0e,  3 }, /* #107 */
    { 0x0b1d17, 0x0b1507, 0x1595, 0x70ac, 0x8fee,  5 }, /* #108 */
    { 0x183412, 0x183c87, 0x3838, 0xc1c6, 0xd5f5, 61 }, /* #109 */
    { 0x1053c7, 0x105382, 0x1ca2, 0x8394, 0xefa4, 35 }, /* #110 */
    { 0x125d13, 0x125582, 0x8253, 0x94c7, 0x1d65, 26 }, /* #111 */
    { 0x2f0513, 0x2f0503, 0xffa7, 0x6ffe, 0xd11b, 38 }, /* #112 */
    { 0x052797, 0x052707, 0x74c0, 0x1227, 0x913c, 19 }, /* #113 */
    { 0x152993, 0x152906, 0xcfcd, 0x367e, 0x78a6, 37 }, /* #114 */
    { 0x177f97, 0x177f07, 0xf107, 0x1f27, 0xe3e4, 13 }, /* #115 */
    { 0x0c4082, 0x0c4007, 0xc005, 0x0014, 0x2c7d, 30 }, /* #116 */
    { 0x3a4e17, 0x3a4e86, 0xd297, 0x94bb, 0x6d30, 61 }, /* #117 */
    { 0x172192, 0x172982, 0xbb11, 0x88df, 0xbec8, 57 }, /* #118 */
    { 0x3a08d3, 0x3a0883, 0x56e7, 0xfda1, 0xed0f, 51 }, /* #119 */
    { 0x051602, 0x051e03, 0x288b, 0x45ba, 0x759d, 25 }, /* #120 */
    { 0x042fd2, 0x042f06, 0xaed3, 0x50a5, 0x6a14, 45 }, /* #121 */
    { 0x020782, 0x020706, 0xfe11, 0x3b56, 0xdab3, 19 }, /* #122 */
    { 0x112147, 0x112103, 0xa09f, 0x13ea, 0x5591, 27 }, /* #123 */
    { 0x353843, 0x353882, 0x0704, 0x824c, 0x98b9, 25 }, /* #124 */
    { 0x0c2653, 0x0c2e86, 0x0079, 0xc866, 0x0ccd, 21 }, /* #125 */
    { 0x313206, 0x313206, 0x9ca8, 0x442e, 0x85c7, 53 }, /* #126 */
    { 0x002ac7, 0x002a03, 0x1093, 0x2126, 0x653d, 31 }, /* #127 */
};
uint32_t const g_cTests_shrd_u16_intel = RT_ELEMENTS(g_aTests_shrd_u16_intel);

BINU32_TEST_T const g_aTests_shld_u32_intel[] =
{
    { 0x367813, 0x367046, 0x00000000, 0x00000000, 0x00000000, 13 }, /* #0 */
    { 0x064153, 0x064146, 0x00000000, 0x00000000, 0x00000000, 20 }, /* #1 */
    { 0x150c83, 0x150446, 0x00000000, 0x00000000, 0x00000000, 49 }, /* #2 */
    { 0x304d07, 0x304546, 0x00000000, 0x00000000, 0x00000000, 95 }, /* #3 */
    { 0x364956, 0x364146, 0x00000000, 0x00000000, 0x00000000, 81 }, /* #4 */
    { 0x1b3bc7, 0x1b3346, 0x00000000, 0x00000000, 0x00000000, 73 }, /* #5 */
    { 0x017ad3, 0x017247, 0xfde488a8, 0x00000000, 0x00000000, 93 }, /* #6 */
    { 0x040906, 0x040986, 0xb5a5c3ce, 0xb4b879c0, 0x00000000, 101 }, /* #7 */
    { 0x050746, 0x050f86, 0xa08ca01a, 0xca01a000, 0x00000000, 76 }, /* #8 */
    { 0x3a0647, 0x3a0607, 0x377ba751, 0x10000000, 0x00000000, 28 }, /* #9 */
    { 0x2a4d86, 0x2a4d02, 0x812716d4, 0x24e2da80, 0x00000000,  5 }, /* #10 */
    { 0x2f5f97, 0x2f5706, 0x2313af21, 0x40000000, 0x00000000, 126 }, /* #11 */
    { 0x210742, 0x210f06, 0x9c44ebf3, 0x7113afcc, 0x1a39853b, 98 }, /* #12 */
    { 0x0d5757, 0x0d5782, 0x37e4c7f0, 0x98fe0175, 0x0bae0210, 77 }, /* #13 */
    { 0x283213, 0x283203, 0x13fbb587, 0x6b0f7d2c, 0xbe96553a, 17 }, /* #14 */
    { 0x0a2017, 0x0a2082, 0x2778312f, 0xc4bfe252, 0xf894a515, 50 }, /* #15 */
    { 0x297742, 0x297f83, 0xa369b97e, 0xdc44fb79, 0xe227dbce, 29 }, /* #16 */
    { 0x0d0716, 0x0d0786, 0x07cd74c6, 0xe98c8afc, 0x457e21a1, 49 }, /* #17 */
    { 0x171493, 0x171482, 0x227183eb, 0xfaea6eab, 0xa9baaf24, 22 }, /* #18 */
    { 0x3e4d83, 0x3e4587, 0x34167121, 0x890aa935, 0x5526af33, 83 }, /* #19 */
    { 0x193887, 0x193007, 0x222bff3c, 0x7fe78ab2, 0x5591a34d, 45 }, /* #20 */
    { 0x062fc7, 0x062786, 0x063a8f45, 0x8f45cdac, 0xcdaca9f2, 112 }, /* #21 */
    { 0x021ec7, 0x021683, 0x2433bf7d, 0xdfbede8c, 0xbd183ec9, 111 }, /* #22 */
    { 0x164f43, 0x164703, 0xd0f6464f, 0x6464f561, 0x5614550a, 108 }, /* #23 */
    { 0x262f52, 0x262f86, 0xa8fe9dfb, 0xa3fa77ee, 0x902d36a9, 66 }, /* #24 */
    { 0x355317, 0x355b02, 0xa0c60b44, 0x305a22b5, 0x56be369e, 43 }, /* #25 */
    { 0x3d7ad3, 0x3d7a82, 0x476b2ea7, 0xa704208a, 0x04208a76, 88 }, /* #26 */
    { 0x2a7583, 0x2a7d87, 0x8378cf9d, 0xbc67cee8, 0xd04c8f3c,  7 }, /* #27 */
    { 0x036b47, 0x036307, 0x1ceb0371, 0x606e2556, 0x2ab4eb56, 45 }, /* #28 */
    { 0x192482, 0x192c02, 0x89736704, 0x086f3ccb, 0x379e6581, 25 }, /* #29 */
    { 0x236557, 0x236583, 0xfb769765, 0xf6ed2ecb, 0xc4f29ca5, 65 }, /* #30 */
    { 0x2a1b53, 0x2a1382, 0x3a9fee51, 0xa7fb945d, 0x77a4485c, 70 }, /* #31 */
    { 0x3f7a13, 0x3f7a07, 0x46b3ee08, 0x1acfb822, 0x9b854cb2, 34 }, /* #32 */
    { 0x066643, 0x066e07, 0xa6517bd5, 0x17bd5b71, 0xb71a14b8, 76 }, /* #33 */
    { 0x176252, 0x176287, 0x3b38074e, 0x8074ea5c, 0xa5c7d47d, 76 }, /* #34 */
    { 0x025092, 0x025087, 0xff927a86, 0xf24f50d4, 0xa74bf7c1, 69 }, /* #35 */
    { 0x0a1053, 0x0a1807, 0x5537df3b, 0x4df7cee4, 0x93220c42, 70 }, /* #36 */
    { 0x3a0e96, 0x3a0e06, 0x7bd58b06, 0x1969b148, 0x5a6c5234, 58 }, /* #37 */
    { 0x3a0847, 0x3a0086, 0x009596f0, 0xb780116a, 0x022d54ab, 51 }, /* #38 */
    { 0x0f1d02, 0x0f1583, 0x1ef7331d, 0xdee663a8, 0x408ed51a, 101 }, /* #39 */
    { 0x2e6507, 0x2e6d02, 0x461cb556, 0x61cb5568, 0x89443bcd, 100 }, /* #40 */
    { 0x2d2413, 0x2d2486, 0x2a4b3a71, 0xe26f0fd7, 0x3787ebb9, 121 }, /* #41 */
    { 0x1f3497, 0x1f3402, 0x246b80b5, 0x35c05af1, 0xe25d25d0,  7 }, /* #42 */
    { 0x2f7b97, 0x2f7383, 0x03e95d8c, 0xe95d8c64, 0x64c43cd6, 72 }, /* #43 */
    { 0x204217, 0x204a87, 0x84ad5e41, 0xc821232e, 0x09197211, 85 }, /* #44 */
    { 0x076c42, 0x076c03, 0x47f37606, 0x4418e7fd, 0x8831cffa, 127 }, /* #45 */
    { 0x391d42, 0x391d86, 0x76e404ea, 0x9d662653, 0x7598994f, 62 }, /* #46 */
    { 0x240617, 0x240602, 0x02353d3a, 0x7a74e6f7, 0x737b8e65, 49 }, /* #47 */
    { 0x021447, 0x021c06, 0xac2df237, 0x5be46f47, 0xa39fb040,  9 }, /* #48 */
    { 0x140d47, 0x140d83, 0x4f7a7e36, 0xe9f8dbb5, 0xed6723d3, 74 }, /* #49 */
    { 0x044f83, 0x044f03, 0x6a8975b7, 0x7664ff13, 0x664ff137, 92 }, /* #50 */
    { 0x352a13, 0x352207, 0xfab95e02, 0x5caf012e, 0x5c418f06, 103 }, /* #51 */
    { 0x146812, 0x146083, 0x3bc4af77, 0xdda8bbf4, 0x6a2efd08, 122 }, /* #52 */
    { 0x336892, 0x336806, 0x62b34ea1, 0x5669d433, 0x9c0f7ef3, 37 }, /* #53 */
    { 0x031c92, 0x031c86, 0x80f77303, 0xf773036f, 0x6f58422f, 72 }, /* #54 */
    { 0x024a06, 0x024a03, 0x494e547d, 0x4e547d70, 0x70378311, 72 }, /* #55 */
    { 0x0b7806, 0x0b7006, 0x0645dc73, 0x0c8bb8e7, 0xa051153f, 65 }, /* #56 */
    { 0x022412, 0x022412, 0x21868556, 0x21868556, 0xe375bb93, 96 }, /* #57 */
    { 0x066293, 0x066203, 0x15969517, 0x45e3eac2, 0x8fab0bd3, 86 }, /* #58 */
    { 0x250712, 0x250f87, 0x5e12a0b7, 0xc165ef53, 0x0597bd4d, 94 }, /* #59 */
    { 0x081bd7, 0x081bd7, 0xf5b85d93, 0xf5b85d93, 0x995c06e1, 32 }, /* #60 */
    { 0x072446, 0x072486, 0xc7e55d0a, 0xfcaba147, 0x3d58f9a3, 101 }, /* #61 */
    { 0x205cc6, 0x205c87, 0x7647358d, 0xcd637b6c, 0xedb29eb9, 14 }, /* #62 */
    { 0x193d52, 0x193506, 0x13baa430, 0x30096230, 0x09623088, 88 }, /* #63 */
    { 0x0c3ad7, 0x0c3a03, 0x6141d6c4, 0x626c3a19, 0xd874322b, 87 }, /* #64 */
    { 0x082407, 0x082c03, 0xb738cf0f, 0x38cf0ff1, 0xf1011694, 72 }, /* #65 */
    { 0x080c46, 0x080c07, 0xa724e6ff, 0x37fdd2b8, 0xba571bc3, 19 }, /* #66 */
    { 0x1409d6, 0x140186, 0xd8042449, 0x91241224, 0x04893329, 82 }, /* #67 */
    { 0x120e97, 0x120e86, 0x9c82b3ac, 0x82b3ac71, 0x71a755b0, 72 }, /* #68 */
    { 0x2f40c2, 0x2f4002, 0xd31df00a, 0x526f8a97, 0x4df152f1, 91 }, /* #69 */
    { 0x2b5616, 0x2b5e87, 0x8d23ac0e, 0xac0e5d78, 0x5d78f5a0, 112 }, /* #70 */
    { 0x164613, 0x164e82, 0x8c6950ec, 0xa1d883e9, 0x41f4d90e, 17 }, /* #71 */
    { 0x0c6fc3, 0x0c6fc3, 0x1a75e0b3, 0x1a75e0b3, 0xd5174638,  0 }, /* #72 */
    { 0x275487, 0x275483, 0x2f3f0aa3, 0x8551d901, 0xb2035200, 15 }, /* #73 */
    { 0x0c72d6, 0x0c7a06, 0x91cac0af, 0x0af517c5, 0x517c5d4a, 84 }, /* #74 */
    { 0x127352, 0x127b86, 0x92c75ead, 0x963af56a, 0x5c73f900, 67 }, /* #75 */
    { 0x3b2816, 0x3b2003, 0x2d4a448e, 0x22476451, 0xc8a2115d, 15 }, /* #76 */
    { 0x1c0a56, 0x1c0a87, 0x78225dc9, 0xdc932b47, 0x32b47167, 84 }, /* #77 */
    { 0x201393, 0x201b86, 0x8bf1f83d, 0xfd290b72, 0xfa5216e4, 63 }, /* #78 */
    { 0x377757, 0x377f07, 0x59847605, 0x6051eebe, 0x1eebe399, 20 }, /* #79 */
    { 0x0b61d7, 0x0b6186, 0x1ef1e5d1, 0xf2e8f166, 0xe2cc3e71, 111 }, /* #80 */
    { 0x191642, 0x191603, 0x2160bd11, 0x05e88b16, 0x62d7006a, 11 }, /* #81 */
    { 0x0a54d2, 0x0a5c86, 0x43a20a25, 0xe882896c, 0xb3a5e738,  6 }, /* #82 */
    { 0x284fd6, 0x284f03, 0xa21bea01, 0x7d402a76, 0x53b38bdd, 45 }, /* #83 */
    { 0x183a87, 0x183283, 0xfee66b4c, 0xfb99ad32, 0x82c2a846, 66 }, /* #84 */
    { 0x0b7796, 0x0b7f83, 0xbaec6aea, 0xd7635757, 0xf303bd90,  3 }, /* #85 */
    { 0x200247, 0x200206, 0x1265e19e, 0x19ee9422, 0xe9422e8f, 52 }, /* #86 */
    { 0x365503, 0x365503, 0xfb1fa94d, 0x4d818420, 0x81842004, 120 }, /* #87 */
    { 0x000e43, 0x000602, 0x19259e68, 0x2080b8b5, 0x8202e2d4, 126 }, /* #88 */
    { 0x216003, 0x216083, 0xc6302b63, 0x8eeab4f1, 0xbaad3c69, 26 }, /* #89 */
    { 0x213103, 0x213103, 0xf98c3dd5, 0x544c967f, 0x44c967fa, 92 }, /* #90 */
    { 0x2b5703, 0x2b5f87, 0x6962d512, 0x8b5449e1, 0x784f9c09, 106 }, /* #91 */
    { 0x2e0183, 0x2e0183, 0x3a49fcfe, 0x3a49fcfe, 0x8e7ff072,  0 }, /* #92 */
    { 0x3a2412, 0x3a2406, 0xe8ec3ec1, 0x1f60d196, 0xa32ccffa, 79 }, /* #93 */
    { 0x005a17, 0x005a06, 0x996a9a83, 0x0e3a7433, 0x8e9d0ce0, 122 }, /* #94 */
    { 0x146e02, 0x146e02, 0x4192e463, 0x5c8c7038, 0x81c6337e, 45 }, /* #95 */
    { 0x0a1e92, 0x0a1683, 0xca746c6b, 0xd1b1ad3d, 0x4f4a82ad, 106 }, /* #96 */
    { 0x2f6e93, 0x2f6e86, 0xabfa5418, 0xafe95060, 0x30bf6115, 98 }, /* #97 */
    { 0x226e87, 0x226e07, 0x92bb333b, 0x76667750, 0xa84020ea,  9 }, /* #98 */
    { 0x2242c7, 0x224a82, 0x84318754, 0xc61d52ef, 0xbbfde2b8, 42 }, /* #99 */
    { 0x365cd7, 0x365403, 0x3d8ea5bc, 0x63a96f3e, 0xfb0c524f, 102 }, /* #100 */
    { 0x0d1806, 0x0d1886, 0x9c77e295, 0xefc52a0f, 0x07dcd976,  9 }, /* #101 */
    { 0x0a6353, 0x0a6382, 0xe4310efc, 0x877e102c, 0x2058d89e, 47 }, /* #102 */
    { 0x395203, 0x395202, 0x01af151e, 0x0d78a8f4, 0x97d78d95, 99 }, /* #103 */
    { 0x0f6b52, 0x0f6302, 0xec8e8422, 0x2113cc4a, 0x798954ed, 83 }, /* #104 */
    { 0x243712, 0x243783, 0xe21f05c2, 0xc170a87f, 0xa1fc9409, 78 }, /* #105 */
    { 0x293813, 0x293883, 0x60d7e972, 0xf4b95a43, 0xb486a5d5, 79 }, /* #106 */
    { 0x067d52, 0x067d82, 0x963042b7, 0xadeeabe9, 0xbaafa676, 86 }, /* #107 */
    { 0x082b06, 0x082386, 0x0e8d8dc2, 0x8d8dc2bb, 0xbbf7fd91, 72 }, /* #108 */
    { 0x370ed6, 0x370682, 0x39b7e4cc, 0xcc4ace1a, 0x4ace1a3b, 120 }, /* #109 */
    { 0x2e2647, 0x2e2682, 0x1da4de96, 0x937a596e, 0x5b92b172, 106 }, /* #110 */
    { 0x044092, 0x044806, 0x4306e40b, 0x40baab63, 0xaab63d62, 116 }, /* #111 */
    { 0x253c82, 0x253483, 0xf41a9bdf, 0xdfaed097, 0xaed09787, 56 }, /* #112 */
    { 0x147ad7, 0x147203, 0xceaa8d0c, 0x1a185f37, 0x2f9b8899, 81 }, /* #113 */
    { 0x3e5346, 0x3e5b87, 0x75f3c899, 0x91335a78, 0xad3c6078, 113 }, /* #114 */
    { 0x3e4302, 0x3e4b86, 0x56e8317b, 0xc5ef3bc3, 0xcef0ca86, 18 }, /* #115 */
    { 0x0f2047, 0x0f2083, 0x0e07c66a, 0xe33535f4, 0x6be87c56, 111 }, /* #116 */
    { 0x085997, 0x085106, 0x00e0b4a6, 0x5a533dbd, 0x7b7bf901, 47 }, /* #117 */
    { 0x237b87, 0x237b87, 0x50237dc8, 0xc8eb22a5, 0xeb22a5dd, 56 }, /* #118 */
    { 0x380587, 0x380503, 0x0623a25b, 0x11d12df4, 0xe97dad8f, 39 }, /* #119 */
    { 0x060486, 0x060c03, 0x530b5be2, 0x4c2d6f89, 0x7d2a0833,  2 }, /* #120 */
    { 0x244c17, 0x244403, 0xdc98b2d4, 0x262cb519, 0x6666a213, 70 }, /* #121 */
    { 0x193687, 0x193e07, 0xb50ce7fa, 0x0ce7fa7b, 0x7b985c6a, 40 }, /* #122 */
    { 0x3a3b06, 0x3a3306, 0x2546e302, 0x371815c9, 0xb9220e1e, 43 }, /* #123 */
    { 0x3a4ec6, 0x3a4e86, 0x7c166b2a, 0xd6544009, 0x2004f4b4, 81 }, /* #124 */
    { 0x1b0513, 0x1b0d03, 0xb6f5a1c3, 0x6f5a1c37, 0x79c6d75a, 36 }, /* #125 */
    { 0x216fd2, 0x216707, 0x152d96d5, 0x6d5db088, 0xdb08807a, 84 }, /* #126 */
    { 0x202d83, 0x202d83, 0xa3affc86, 0xaffc86b9, 0xb90fe23b, 72 }, /* #127 */
};
uint32_t const g_cTests_shld_u32_intel = RT_ELEMENTS(g_aTests_shld_u32_intel);

BINU32_TEST_T const g_aTests_shrd_u32_intel[] =
{
    { 0x281dc2, 0x281546, 0x00000000, 0x00000000, 0x00000000, 65 }, /* #0 */
    { 0x066007, 0x066046, 0x00000000, 0x00000000, 0x00000000, 68 }, /* #1 */
    { 0x2a21d2, 0x2a2146, 0x00000000, 0x00000000, 0x00000000, 44 }, /* #2 */
    { 0x3f2903, 0x3f2146, 0x00000000, 0x00000000, 0x00000000,  2 }, /* #3 */
    { 0x1b5316, 0x1b5346, 0x00000000, 0x00000000, 0x00000000, 19 }, /* #4 */
    { 0x087e52, 0x087646, 0x00000000, 0x00000000, 0x00000000, 87 }, /* #5 */
    { 0x292883, 0x292802, 0xbcc37c11, 0x0000005e, 0x00000000, 121 }, /* #6 */
    { 0x2a44c7, 0x2a4c03, 0x85f89a25, 0x0000010b, 0x00000000, 119 }, /* #7 */
    { 0x1d2b07, 0x1d2307, 0x09366beb, 0x00009366, 0x00000000, 44 }, /* #8 */
    { 0x080e43, 0x080602, 0x4856f6a8, 0x0242b7b5, 0x00000000,  5 }, /* #9 */
    { 0x2c68d7, 0x2c6803, 0xddb40180, 0x0000006e, 0x00000000, 25 }, /* #10 */
    { 0x0d20d7, 0x0d2802, 0xa9791b09, 0x00000001, 0x00000000, 31 }, /* #11 */
    { 0x344b53, 0x344387, 0x407d77b6, 0x901f5ded, 0xfabb05ce, 34 }, /* #12 */
    { 0x184406, 0x184c06, 0x50c56eea, 0x1e84150c, 0xc041e841, 84 }, /* #13 */
    { 0x3b7583, 0x3b7587, 0xecf79ea2, 0xdd7b3de7, 0xcb0cf375, 74 }, /* #14 */
    { 0x1b14c2, 0x1b1482, 0x896fbb05, 0xaa769abc, 0xd54ed357, 61 }, /* #15 */
    { 0x1d2b92, 0x1d2b06, 0xd75244c7, 0x49846ba9, 0x71d29308, 17 }, /* #16 */
    { 0x062e46, 0x062686, 0xff79f69b, 0xac9ff79f, 0xaad8cac9, 12 }, /* #17 */
    { 0x263fc7, 0x263fc7, 0x2b9a341a, 0x2b9a341a, 0xaade1d2c, 64 }, /* #18 */
    { 0x236b92, 0x236b86, 0xb2d1e38f, 0x92cb478e, 0x3a9a8c64, 70 }, /* #19 */
    { 0x313147, 0x313906, 0x202fad5d, 0x3cc80beb, 0x04aa14f3, 74 }, /* #20 */
    { 0x073792, 0x073f02, 0xfc354f9f, 0x012eedf8, 0x2a009776, 55 }, /* #21 */
    { 0x2a3c47, 0x2a3c06, 0xb19de3d8, 0x2c6778f6, 0xe8d08fcc, 66 }, /* #22 */
    { 0x2a5647, 0x2a5e87, 0x50c71c23, 0xa8638e11, 0x16c5fdbd, 33 }, /* #23 */
    { 0x150996, 0x150187, 0xf3f6157b, 0xffcfd855, 0x9c8960bf, 102 }, /* #24 */
    { 0x3f3b03, 0x3f3b83, 0xb2611556, 0x9f159308, 0x3d80b3e2, 109 }, /* #25 */
    { 0x2a1f83, 0x2a1f87, 0x6e73402c, 0xedce6805, 0xb391461f, 99 }, /* #26 */
    { 0x292c92, 0x292407, 0x6a3d686c, 0x03d9a8f5, 0x96b2c0f6, 78 }, /* #27 */
    { 0x374692, 0x374e02, 0x883ca498, 0x220f2926, 0x3093ae08,  2 }, /* #28 */
    { 0x380d47, 0x380d86, 0xb0c1e3df, 0xcd16183c, 0xee532668, 11 }, /* #29 */
    { 0x1a00d6, 0x1a0807, 0xbe4cd279, 0x317897c9, 0xe5198bc4, 19 }, /* #30 */
    { 0x156313, 0x156383, 0xde6fdffb, 0xb7bcdfbf, 0x3694dd5b, 71 }, /* #31 */
    { 0x177c47, 0x177403, 0xe86b6a6b, 0x5bdfa1ad, 0x71c6d6f7, 78 }, /* #32 */
    { 0x142b16, 0x142b87, 0x6d6194ce, 0xdafcdbbd, 0xb6bf36ef, 62 }, /* #33 */
    { 0x281153, 0x281983, 0x8b430361, 0xc81362a2, 0xd7204d8a, 58 }, /* #34 */
    { 0x0e2b97, 0x0e2306, 0x90c84f2f, 0x2b0274e4, 0x24ac09d3, 26 }, /* #35 */
    { 0x336043, 0x336007, 0x10495925, 0x401d0824, 0x626a803a, 113 }, /* #36 */
    { 0x287306, 0x287307, 0xf590ff84, 0x7eb21ff0, 0xadae8833, 99 }, /* #37 */
    { 0x1b5053, 0x1b5882, 0x662025c1, 0xed988097, 0x0406f3bb, 70 }, /* #38 */
    { 0x032453, 0x032c07, 0xe580e36d, 0x05cb01c6, 0x293d3382, 39 }, /* #39 */
    { 0x170696, 0x170e03, 0xf19ae209, 0x78cd7104, 0x2b244240, 97 }, /* #40 */
    { 0x057842, 0x057882, 0xc226b988, 0x81844d73, 0x938b71c0, 39 }, /* #41 */
    { 0x0531d3, 0x053903, 0x2c8d7227, 0x6ff49646, 0xebbedfe9, 81 }, /* #42 */
    { 0x236bc7, 0x236b82, 0x3081634e, 0x9bbc9ce6, 0xf4dde4e7, 123 }, /* #43 */
    { 0x240a02, 0x240a82, 0x2320637a, 0x80186464, 0x493400c3, 51 }, /* #44 */
    { 0x0d2443, 0x0d2c83, 0x1b44699c, 0xcf91b446, 0x2d207cf9, 76 }, /* #45 */
    { 0x132ec7, 0x132ec7, 0x6506c520, 0x6506c520, 0xe14ef6b4, 96 }, /* #46 */
    { 0x180286, 0x180202, 0xde386b09, 0x778e1ac2, 0x329ee549,  2 }, /* #47 */
    { 0x050656, 0x050e87, 0x69ac3512, 0x86e8ad35, 0x56943745, 115 }, /* #48 */
    { 0x213156, 0x213903, 0x1db5da37, 0x593d5476, 0xd7564f55, 54 }, /* #49 */
    { 0x3164c6, 0x316403, 0x6eb9fd67, 0x5b351375, 0x6d6b66a2, 117 }, /* #50 */
    { 0x1619d2, 0x161903, 0xbf5119c1, 0x6e7aaeab, 0x16e7aaea, 28 }, /* #51 */
    { 0x341882, 0x341003, 0xd95dd9fd, 0x50f8b8ae, 0xca1f1715, 61 }, /* #52 */
    { 0x0c52c6, 0x0c5282, 0x525ba4d7, 0xb8de8452, 0x15b8de84, 88 }, /* #53 */
    { 0x0000d2, 0x000006, 0xfcd10346, 0x7d37fcd1, 0xf8d27d37, 112 }, /* #54 */
    { 0x3c2887, 0x3c2007, 0x1e3d31d9, 0x30f1e98e, 0x7d5e4ee6, 69 }, /* #55 */
    { 0x0f2217, 0x0f2202, 0xfece907b, 0x6adfece9, 0x3c0fa6ad, 12 }, /* #56 */
    { 0x2325d2, 0x232d83, 0x4556bf64, 0xcbbac468, 0x165dd623, 59 }, /* #57 */
    { 0x1840d3, 0x184002, 0x88cc457e, 0x3e2e2331, 0x8d6b8f8b, 46 }, /* #58 */
    { 0x2b6ac2, 0x2b6286, 0xa2ebabb0, 0xd175d5d8, 0xe1fbae57, 97 }, /* #59 */
    { 0x1f7657, 0x1f7e86, 0xf9b13fad, 0xfc4eeebe, 0xebf13bba, 122 }, /* #60 */
    { 0x1a12d2, 0x1a1a06, 0xa461933d, 0x1e142918, 0x65347850, 82 }, /* #61 */
    { 0x3257c2, 0x3257c2, 0x86e06134, 0x86e06134, 0x3a868a4d, 32 }, /* #62 */
    { 0x0705d6, 0x070d06, 0x4be0c06d, 0x5562ba5f, 0x2f4aac57, 117 }, /* #63 */
    { 0x1c08d7, 0x1c0086, 0x4ea96ebe, 0xc042754b, 0x9974b808, 45 }, /* #64 */
    { 0x170fc6, 0x170fc6, 0x7bc2770f, 0x7bc2770f, 0xd1ee4e10, 96 }, /* #65 */
    { 0x1f6093, 0x1f6087, 0xc082a446, 0x93ff020a, 0x32eb64ff, 110 }, /* #66 */
    { 0x3c23d2, 0x3c2383, 0xd22137d8, 0xdef7c2e3, 0x6f7be171, 31 }, /* #67 */
    { 0x3b0ed3, 0x3b0606, 0x84068b5d, 0x2cdd0b84, 0x732cdd0b, 120 }, /* #68 */
    { 0x077b12, 0x077b83, 0xabc1b238, 0x8f6ce2ab, 0xc38f6ce2, 120 }, /* #69 */
    { 0x386642, 0x386606, 0x4e06a81c, 0x449c0d50, 0x7f238fa2, 71 }, /* #70 */
    { 0x037a93, 0x037203, 0xaaece2e9, 0x7dafaaec, 0x9e2d7daf, 16 }, /* #71 */
    { 0x1f7012, 0x1f7083, 0xf0cfcb7c, 0xaf867e5b, 0x7bd2d8b5, 101 }, /* #72 */
    { 0x293283, 0x293207, 0x0d2bcbab, 0x43cb0695, 0x568c8796, 81 }, /* #73 */
    { 0x272ed3, 0x272e07, 0xed88ba0c, 0x3200f3dd, 0x9990079e, 123 }, /* #74 */
    { 0x2e4b16, 0x2e4386, 0x76e31b9c, 0xfa0edc63, 0x3c4477d0, 11 }, /* #75 */
    { 0x323282, 0x323287, 0x45682ccb, 0xb1645682, 0x99c1eb16, 44 }, /* #76 */
    { 0x0e2bc7, 0x0e2b86, 0xd57c45a7, 0x85aaf88b, 0x02ca02c2, 39 }, /* #77 */
    { 0x3e74d2, 0x3e7c03, 0xeaa58d98, 0x34325d54, 0x3439a192, 19 }, /* #78 */
    { 0x266d12, 0x266502, 0x6bffc1ac, 0x535ffe0d, 0x52a6568a, 101 }, /* #79 */
    { 0x2a1cd6, 0x2a1483, 0xdd186725, 0xd4377461, 0xc15fb50d, 78 }, /* #80 */
    { 0x292517, 0x292586, 0xad0ac6c5, 0xc09d6856, 0xa5979813, 13 }, /* #81 */
    { 0x3342d3, 0x334282, 0xfd18d588, 0xf2ee71fd, 0x08f2ee71, 120 }, /* #82 */
    { 0x135bc6, 0x135383, 0x01f7d6e6, 0x93585801, 0x7d935858, 56 }, /* #83 */
    { 0x187587, 0x187d86, 0xe505f5ec, 0xf5a60139, 0x93d69804, 90 }, /* #84 */
    { 0x194b92, 0x194303, 0xf408b515, 0x0c83a4fe, 0x08641d27, 27 }, /* #85 */
    { 0x0b0b43, 0x0b0382, 0xdb84e6ab, 0x8f004f6e, 0xcba3c013, 118 }, /* #86 */
    { 0x051bc6, 0x051382, 0xe9c8ce24, 0xa1e9c8ce, 0x5f4cc2a1,  8 }, /* #87 */
    { 0x117512, 0x117503, 0xa0fc9454, 0x341f928a, 0x6ebe34f9, 35 }, /* #88 */
    { 0x0a1813, 0x0a1086, 0x7f2de62c, 0xd8fe5bcc, 0x0aeb9a6c, 39 }, /* #89 */
    { 0x015602, 0x015e07, 0xf4575d2c, 0x2f4575d2, 0x41e4d1b2, 36 }, /* #90 */
    { 0x2e6417, 0x2e6486, 0x34bd8aa9, 0x8de7998d, 0xd2379e66, 26 }, /* #91 */
    { 0x301d17, 0x301502, 0xc8c326ba, 0x2220fe46, 0x40e4441f, 117 }, /* #92 */
    { 0x2336c6, 0x233e83, 0xa5f9e534, 0xa3268297, 0x7e68c9a0, 118 }, /* #93 */
    { 0x3e0803, 0x3e0007, 0xab4d249c, 0x7a971b56, 0x10bd4b8d, 23 }, /* #94 */
    { 0x3b1cc2, 0x3b1406, 0x24448a8d, 0x13597712, 0x6426b2ee, 57 }, /* #95 */
    { 0x2e4617, 0x2e4e83, 0xc3418bfc, 0x9b0d062f, 0x8409f1e6, 70 }, /* #96 */
    { 0x2220d3, 0x222807, 0x48b12afe, 0x70f03148, 0x7570f031, 88 }, /* #97 */
    { 0x3b61c3, 0x3b6907, 0x2bd69391, 0x7c744af5, 0xe695f1d1, 50 }, /* #98 */
    { 0x370606, 0x370e86, 0x84820bf4, 0xfa6fda12, 0xc7fe9bf6, 118 }, /* #99 */
    { 0x254193, 0x254182, 0x72ca4c2e, 0x862221cb, 0x5be18888, 118 }, /* #100 */
    { 0x0c4253, 0x0c4287, 0x9ac4fc5d, 0x86c00b9a, 0x4a86c00b, 120 }, /* #101 */
    { 0x2f7d46, 0x2f7507, 0x44e2e901, 0x3224dc44, 0xab3224dc, 88 }, /* #102 */
    { 0x002703, 0x002f87, 0xd7d27e7c, 0xb6be93f3, 0x909be676, 37 }, /* #103 */
    { 0x2f1287, 0x2f1a86, 0x509d5a38, 0xae48d427, 0xa8beb923, 82 }, /* #104 */
    { 0x250a46, 0x250a87, 0xbc27d168, 0xa76f5784, 0x1dc53b7a, 51 }, /* #105 */
    { 0x2d74d2, 0x2d7403, 0x4460a5fd, 0x4451eaa8, 0x2228f554, 31 }, /* #106 */
    { 0x092b96, 0x092383, 0x98b05fc9, 0x836c142c, 0xd06d8285, 29 }, /* #107 */
    { 0x0e46c7, 0x0e4e07, 0xb94310f4, 0x5728621e, 0x080200a2,  3 }, /* #108 */
    { 0x3d3596, 0x3d3586, 0xbd98557c, 0xef66155f, 0xd4e954ab, 66 }, /* #109 */
    { 0x1c3292, 0x1c3283, 0x5e23f9c9, 0xe2b85e23, 0x6765e2b8, 80 }, /* #110 */
    { 0x2861d2, 0x286982, 0x928e3783, 0xed915494, 0xe49db22a, 53 }, /* #111 */
    { 0x0201d6, 0x020986, 0xcbf0ac45, 0xeb2fc2b1, 0x98c1187a, 70 }, /* #112 */
    { 0x097c17, 0x097c07, 0xa552e976, 0x624a552e, 0x7cc46624, 76 }, /* #113 */
    { 0x2460c7, 0x246886, 0xfeba064c, 0xb23bfae8, 0x78d8ec8e, 110 }, /* #114 */
    { 0x084656, 0x084607, 0x65a9c303, 0x32d4e181, 0xc82ab060, 65 }, /* #115 */
    { 0x066056, 0x066087, 0xfb2c4a55, 0xad4e2d5f, 0x6ad4e2d5, 28 }, /* #116 */
    { 0x340903, 0x340103, 0x31b136b7, 0x18d89b5b, 0x66650640,  1 }, /* #117 */
    { 0x3d3a82, 0x3d3282, 0x8487b732, 0x97916761, 0x7e5e459d, 122 }, /* #118 */
    { 0x023b86, 0x023b83, 0x4ada7634, 0xbcd2b69d, 0xebdaeef3, 74 }, /* #119 */
    { 0x1e4c42, 0x1e4c83, 0x2eadc1ad, 0xc23dccba, 0x12308f73, 86 }, /* #120 */
    { 0x071882, 0x071883, 0x98c2815c, 0xc3b6b529, 0x7c3b6b52, 124 }, /* #121 */
    { 0x035a46, 0x035a87, 0xaa0ecac8, 0xf42a83b2, 0x43199bd0, 106 }, /* #122 */
    { 0x1c3a92, 0x1c3a07, 0xfd4d1c16, 0x348fd4d1, 0x25c33348, 76 }, /* #123 */
    { 0x2f7857, 0x2f7002, 0x1126c8b3, 0x0224d916, 0x91776a78, 99 }, /* #124 */
    { 0x2152d7, 0x215a86, 0xc6b4e808, 0xfcb1ad3a, 0x4f9bfbf2, 10 }, /* #125 */
    { 0x087397, 0x087b07, 0x317916fe, 0x698bc8b7, 0x76b77a6d, 69 }, /* #126 */
    { 0x2442c7, 0x244a83, 0x1d748cde, 0x9fb82723, 0x8cfdc139, 27 }, /* #127 */
};
uint32_t const g_cTests_shrd_u32_intel = RT_ELEMENTS(g_aTests_shrd_u32_intel);

BINU64_TEST_T const g_aTests_shld_u64_intel[] =
{
    { 0x1d3a56, 0x1d3246, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 221 }, /* #0 */
    { 0x114f12, 0x114746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 65 }, /* #1 */
    { 0x205892, 0x205046, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 142 }, /* #2 */
    { 0x290f42, 0x290746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 123 }, /* #3 */
    { 0x0f7482, 0x0f7446, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 107 }, /* #4 */
    { 0x000fd2, 0x000746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 151 }, /* #5 */
    { 0x2f73d3, 0x2f7382, 0xdee124b8b5221108, 0xf70925c5a9108840, 0x0000000000000000, 131 }, /* #6 */
    { 0x2b5516, 0x2b5586, 0x242a0b0daf7ab314, 0xf566280000000000, 0x0000000000000000, 41 }, /* #7 */
    { 0x3d5b16, 0x3d5306, 0xdd1fc950426d55ee, 0x4daabdc000000000, 0x0000000000000000, 229 }, /* #8 */
    { 0x280882, 0x280087, 0xee610fb2372470d6, 0xd91b92386b000000, 0x0000000000000000, 23 }, /* #9 */
    { 0x2023c7, 0x202b86, 0x657bf31fac58e6d0, 0xf7e63f58b1cda000, 0x0000000000000000,  9 }, /* #10 */
    { 0x375797, 0x375787, 0xe630c6753b71f94a, 0xdb8fca5000000000, 0x0000000000000000, 99 }, /* #11 */
    { 0x332592, 0x332d03, 0xae24cdf017a865c0, 0x7a865c0d20fabf73, 0xd20fabf73d997280, 100 }, /* #12 */
    { 0x390406, 0x390402, 0xd58d871f241459d8, 0x1459d830d7804623, 0x30d78046235241a9, 168 }, /* #13 */
    { 0x240396, 0x240b87, 0x45259a2fa0e01350, 0xa0e0135008ddaf90, 0x08ddaf90dfe86022, 32 }, /* #14 */
    { 0x3c3586, 0x3c3506, 0xd3b0642fd2412c95, 0x42fd2412c951a114, 0x1a1144ffe7ef5275, 148 }, /* #15 */
    { 0x1e4182, 0x1e4983, 0x7dabd37427f41097, 0xabd37427f4109704, 0x04abd7986d4ba596,  8 }, /* #16 */
    { 0x101917, 0x101186, 0x0256716782540913, 0xa81227617e3442be, 0xb0bf1a215f0d3e46, 105 }, /* #17 */
    { 0x2c25d7, 0x2c2d82, 0xb06acaa24e17524f, 0xcaa24e17524f53a7, 0x53a7f271cb6c406b, 16 }, /* #18 */
    { 0x372b83, 0x372382, 0xc45702f5d8f20280, 0xb817aec79014050e, 0xa1c56b707cf0e752, 11 }, /* #19 */
    { 0x357013, 0x357887, 0x99f68e9b4df5b634, 0xbeb6c6989a1781db, 0xc4d0bc0edea0d281, 165 }, /* #20 */
    { 0x2e3cd6, 0x2e3c87, 0x6faec2d29d68f9dc, 0xb9c41411b15ffce4, 0xe20a08d8affe7204, 57 }, /* #21 */
    { 0x0c0603, 0x0c0e07, 0x96f768398681f200, 0x0d03e40186712856, 0xc338942b4f6b3845, 225 }, /* #22 */
    { 0x145702, 0x145702, 0x076509391fc538cd, 0x29c66825e1caa840, 0x04bc3955081320ec, 107 }, /* #23 */
    { 0x2820c3, 0x282802, 0x5fdbf2f806803b11, 0x03b114fe8e12d370, 0x4fe8e12d370d8a5c, 44 }, /* #24 */
    { 0x3d4502, 0x3d4d03, 0xa91644656af843b4, 0x522c88cad5f08768, 0x05c49bdd15704fd5, 129 }, /* #25 */
    { 0x304fd2, 0x304703, 0x33e73563158531ea, 0x3563158531ea14c7, 0x14c7f3b28a58a5f4, 16 }, /* #26 */
    { 0x014356, 0x014386, 0xf93d6e12b43713ce, 0x9e768fb7055235b7, 0xd1f6e0aa46b6fd81, 51 }, /* #27 */
    { 0x184886, 0x184806, 0x496ed6e40625cd2f, 0x0625cd2fef3a337d, 0xef3a337d219390a3, 32 }, /* #28 */
    { 0x0b1f12, 0x0b1707, 0x095a410027ca0641, 0x2b482004f940c828, 0x43b68e274dcf41d4, 197 }, /* #29 */
    { 0x126412, 0x126483, 0xd0afb5f93cab2857, 0x95650aeacb696b73, 0x565b4b5b9d680ffc, 165 }, /* #30 */
    { 0x025ec3, 0x025e03, 0x63eae2360b1f98e9, 0x5711b058fcc74e0b, 0xc163e9f7c5c7690d, 139 }, /* #31 */
    { 0x234b52, 0x234b06, 0xa1e906142d651ebe, 0x7a41850b5947af8e, 0x387c1708f2777dd2, 198 }, /* #32 */
    { 0x201902, 0x201102, 0xdc54c82517b9117a, 0x517b9117ad4751bc, 0xd4751bcd0615fbda, 220 }, /* #33 */
    { 0x141f82, 0x141f86, 0x4b7235b0d0f0a5f5, 0xb7235b0d0f0a5f56, 0x68ae43e317f082d3,  4 }, /* #34 */
    { 0x3b0356, 0x3b0306, 0x0b254b4dabcaf960, 0x32f91a2c98c7406c, 0x65f23459318e80d9, 63 }, /* #35 */
    { 0x3f5fd2, 0x3f5706, 0xd21f1881c1dc61d1, 0x70771874690eca72, 0xa43b29cae48b9698, 94 }, /* #36 */
    { 0x193843, 0x193082, 0x28c01e56f2477797, 0xf2b7923bbcba1401, 0x428038972b90a1ca, 19 }, /* #37 */
    { 0x2331d3, 0x233103, 0x074c5e7155fc4052, 0x283efcd72f8a8237, 0x507df9ae5f15046f, 191 }, /* #38 */
    { 0x0e6657, 0x0e6602, 0x36f135a732d27ea1, 0x4d69ccb49fa85ce6, 0x739b6a47126090fe, 206 }, /* #39 */
    { 0x333e57, 0x333e86, 0xb9a26560c1df57bf, 0xc1df57bf69e9ce88, 0x69e9ce88fd3579ff, 32 }, /* #40 */
    { 0x353396, 0x353382, 0x362b7b1da8a806d6, 0xdd1b323d37013e98, 0xe8d991e9b809f4c6, 253 }, /* #41 */
    { 0x3c5bc2, 0x3c5383, 0x16ff29e866e8f38f, 0xca7a19ba3ce3d102, 0x440a42d2687075e6, 78 }, /* #42 */
    { 0x210787, 0x210782, 0xfb371a20d806a52c, 0x83601a94b322f45e, 0xc8bd178854b5bb02, 90 }, /* #43 */
    { 0x2e4c96, 0x2e4407, 0xef311af6b3c55181, 0x15460699449e7818, 0xa651279e0603923a, 234 }, /* #44 */
    { 0x2d4207, 0x2d4a87, 0x4c67db21b0b9a3ac, 0x9a3ac49b83d94921, 0x49b83d94921bbddd, 236 }, /* #45 */
    { 0x061616, 0x061686, 0x38319c2ab6f7071d, 0xf7071de9721693c0, 0xe9721693c006cb64, 168 }, /* #46 */
    { 0x1a3c96, 0x1a3c06, 0xafcd1bbf0407aeee, 0x203d7773da0a5aca, 0x7b414b59503119c6, 227 }, /* #47 */
    { 0x1f6786, 0x1f6f86, 0x8d086996c6192adf, 0x956fb11099563b93, 0x622132ac77264d0e, 239 }, /* #48 */
    { 0x246556, 0x246503, 0xd550bc51e46e64ac, 0x0bc51e46e64ac10e, 0x10ef4d05b6a44d77, 76 }, /* #49 */
    { 0x0236c3, 0x023e06, 0x5af19d582a981372, 0x67560aa604dcb2e4, 0xcb910fa42ed39a04, 142 }, /* #50 */
    { 0x2b5486, 0x2b5487, 0xc9d68230d1b16bc6, 0x868d8b5e331f2069, 0x63e40d32fe96b8fd, 155 }, /* #51 */
    { 0x311f97, 0x311f86, 0xa47e3e5c9813d8ae, 0xbb1023c451ba4b55, 0xc408f1146e92d554, 186 }, /* #52 */
    { 0x096ed7, 0x096687, 0x2aefae5e32bf97bd, 0xd72f195fcbdeac72, 0x58e5aa60bf507d92, 15 }, /* #53 */
    { 0x395f12, 0x395783, 0x00d9028e45c2f61f, 0xc2f61f0f6e0d5537, 0x0f6e0d5537933d02, 40 }, /* #54 */
    { 0x2913c6, 0x291303, 0x3d90df72fa4e8742, 0x3a1d0820eb7f0c46, 0x083adfc31183c5ac, 106 }, /* #55 */
    { 0x190502, 0x190d83, 0x7f63ea4bbfbb59eb, 0xbfbb59ebb3ef4226, 0xb3ef42260d09f126, 160 }, /* #56 */
    { 0x253012, 0x253886, 0xbd0ba0e4a6e27a99, 0x83929b89ea67b2e8, 0xecba38e4837a07c4, 18 }, /* #57 */
    { 0x1e5e46, 0x1e5e82, 0x594471cf7bb0aa07, 0x8e39ef761540f823, 0xc11bf6593c7c8fee, 141 }, /* #58 */
    { 0x263053, 0x263007, 0x0bc2931d922a1552, 0x498ec9150aa9151b, 0x2a363443db52a7d3, 79 }, /* #59 */
    { 0x2d5016, 0x2d5807, 0xbaa29f8ed80449ce, 0x4fc76c0224e759b1, 0xb3636fe5e21be943, 15 }, /* #60 */
    { 0x396316, 0x396b82, 0x7662951a650a10b1, 0xa34ca142162a8052, 0x540291a87e353e51, 21 }, /* #61 */
    { 0x3d5ec6, 0x3d5686, 0xffc54a3704d53adb, 0xe09aa75b7e78195a, 0xf3c0cad01d9a9f74, 157 }, /* #62 */
    { 0x103647, 0x103e06, 0x5e334ffeb1f24285, 0x7c90a1455f4d1821, 0x157d34608516a94b, 230 }, /* #63 */
    { 0x111446, 0x111403, 0x0d726d530a39cde9, 0x726d530a39cde9e9, 0xe920bf63f4a65a94, 72 }, /* #64 */
    { 0x315617, 0x315e06, 0x75de5734d5cc23e1, 0x6d003c00b1dba01e, 0xb400f002c76e807b, 254 }, /* #65 */
    { 0x0a7fc2, 0x0a7706, 0x241865e91d9a38b9, 0x38b9ea6988a7f48b, 0xea6988a7f48ba6d0, 112 }, /* #66 */
    { 0x267956, 0x267902, 0x5d281bd17a9a1764, 0x1bd17a9a1764ade6, 0xade6de606a043e54, 208 }, /* #67 */
    { 0x1933c7, 0x193b86, 0x9013ec75d991e4fc, 0x9f63aecc8f27e4d1, 0x9a3a9c061707d55a, 11 }, /* #68 */
    { 0x235503, 0x235d86, 0x418859c4392a7c80, 0xa9f202520aa9d122, 0x9482aa7448a0ac10, 170 }, /* #69 */
    { 0x130b43, 0x130382, 0xc05ac6d6c996436e, 0xddc262a3ff2434a7, 0xe13151ff921a53d0, 249 }, /* #70 */
    { 0x1d2512, 0x1d2583, 0xeb46ef42db43496f, 0xeef829df9d16e967, 0xbbe0a77e745ba59e, 190 }, /* #71 */
    { 0x011e46, 0x011606, 0xc1e62f358f3fb493, 0x79fda49f35d68dfc, 0xe6bad1bf955d8962, 35 }, /* #72 */
    { 0x244ec6, 0x244606, 0x040ee5557ad2bf90, 0x137d64d0dcfdadcf, 0x26fac9a1b9fb5b9f, 63 }, /* #73 */
    { 0x301593, 0x301582, 0x20c4ff127abc7d32, 0xfa645259ea295b26, 0x292cf514ad9304de, 113 }, /* #74 */
    { 0x1372d7, 0x137282, 0xd470ea4f551d362e, 0xaa3a6c5d525b9dda, 0xa92dceed06ef7cde, 225 }, /* #75 */
    { 0x2e2852, 0x2e2887, 0xbcae56e4f825344b, 0x93e094d12d20a5be, 0x48296f800b086270, 26 }, /* #76 */
    { 0x1137d7, 0x113787, 0xfbc852572c1701ec, 0x90a4ae582e03d818, 0x0c0cc96b2969f5f2,  9 }, /* #77 */
    { 0x306446, 0x306402, 0xdaf2c86d7945efee, 0x590daf28bdfdcfb9, 0x7dc8631e5af23f6f, 13 }, /* #78 */
    { 0x007342, 0x007b02, 0xbd5a68ff4dce9871, 0x74c38e3b499a9b57, 0xc76933536ae45935, 171 }, /* #79 */
    { 0x2e1f96, 0x2e1782, 0x33b7600c4d3c7b2b, 0xaf82ddb537a427ba, 0xe0b76d4de909eeab, 58 }, /* #80 */
    { 0x394912, 0x394187, 0xe988c98d68e244f0, 0xc33f9d2d0aaeb0be, 0xcfe74b42abac2fa7, 250 }, /* #81 */
    { 0x1c22d3, 0x1c2286, 0xe885f55968612557, 0xabe4ff4fe0983e7d, 0xc9fe9fc1307cfa8a, 119 }, /* #82 */
    { 0x2d5b86, 0x2d5382, 0xe7e9db86b4bc4553, 0xeed8d267a0ab77f7, 0xbb63499e82addfde, 190 }, /* #83 */
    { 0x0f7c16, 0x0f7c87, 0x78031a81060e88e3, 0xcd8bca72800435d8, 0x9b1794e500086bb0, 255 }, /* #84 */
    { 0x0c1102, 0x0c1106, 0x2822dbd462120f7f, 0x62120f7f7417d06f, 0x7417d06f9a5af6f2, 224 }, /* #85 */
    { 0x3a3647, 0x3a3687, 0x0fbd6eacf2770541, 0xadd59e4ee0a82659, 0x32c8321b34152c8b, 13 }, /* #86 */
    { 0x3723d3, 0x372387, 0x0d08e663d2676b8f, 0xe933b5c7f59ca118, 0xeb394230c07ccdcc, 95 }, /* #87 */
    { 0x181656, 0x181607, 0xd32f5cbfb6595eab, 0x32f5cbfb6595eabe, 0xe2cb1f1f6c5148ec,  4 }, /* #88 */
    { 0x076246, 0x076283, 0x382ae5daa1ce02ec, 0x82ae5daa1ce02ece, 0xe7a789da0dab7672, 196 }, /* #89 */
    { 0x047246, 0x047202, 0xf8ac9a6124e02223, 0x4e022231ac6186a1, 0x1ac6186a128a17a2, 36 }, /* #90 */
    { 0x293687, 0x293683, 0xd4dfe0d06288adee, 0x8a22b7bb59f1174c, 0xd67c45d32ff7d00c, 98 }, /* #91 */
    { 0x363fd6, 0x363783, 0x261e0463898bbc6b, 0x8e262ef1ae79bfa7, 0x9e6fe9eccc3eb0ca, 90 }, /* #92 */
    { 0x004e87, 0x004e02, 0xa0fb16ee190e36fe, 0x438dbf8c51de7a8a, 0x314779ea284c6689, 102 }, /* #93 */
    { 0x197503, 0x197d87, 0x52bf5c2d23ff9357, 0xfae1691ffc9abe99, 0xd3279cbfc3d7993e, 11 }, /* #94 */
    { 0x106802, 0x106882, 0x8d51e739a653b288, 0x885026f96bda6dd3, 0x5026f96bda6dd3d0, 248 }, /* #95 */
    { 0x013017, 0x013002, 0x24c18f9a53121daf, 0x3e694c4876bc3479, 0x0d1e7a91c29ddc15, 82 }, /* #96 */
    { 0x110793, 0x110706, 0xfd75098458aeac88, 0x57564451bb67e5a9, 0xa376cfcb525f3fcf, 103 }, /* #97 */
    { 0x394e53, 0x394607, 0x2697f8a2ab85cdd8, 0x145570b9bb1783ed, 0xbc1f69c8d9a2dc74, 149 }, /* #98 */
    { 0x201393, 0x201b06, 0xae320d9538587a73, 0x320d9538587a731d, 0x1d77a4feeb8ff8f3, 136 }, /* #99 */
    { 0x311406, 0x311403, 0xf058c82a3d78ca6d, 0x4db458707902712c, 0xa2c383c8138965ad, 53 }, /* #100 */
    { 0x0f7903, 0x0f7107, 0xfdcef33d495b40ba, 0x256d02eb1cad179f, 0xc72b45e7d5b456e8, 98 }, /* #101 */
    { 0x237c03, 0x237c07, 0x814d204f89f05f66, 0x06b7cbc01daf765c, 0x0d6f97803b5eecb9, 127 }, /* #102 */
    { 0x0c1807, 0x0c1883, 0x948064ffb7e3b4e1, 0xfb7e3b4e1de8e48c, 0xde8e48c122ffb2a2, 92 }, /* #103 */
    { 0x297846, 0x297807, 0xa3735ca68d3f5a25, 0x4fd6896d285c6b8b, 0xb4a171ae2f2de446, 230 }, /* #104 */
    { 0x1d0ec7, 0x1d0602, 0x18be910ea90066e1, 0x1d5200cdc2742cad, 0x3a1656a1a5bfcfe8, 25 }, /* #105 */
    { 0x0b1196, 0x0b1102, 0xff8cf2133392f300, 0x01c4a14a522eb9ea, 0xe250a529175cf532, 121 }, /* #106 */
    { 0x082cd2, 0x082402, 0xcb42c195dff55278, 0x5a160caeffaa93c4, 0x87c58aa0c058a11a,  3 }, /* #107 */
    { 0x223f87, 0x223f07, 0x665b623dbb2486a4, 0x6ec921a9287180c3, 0xa1c6030e5d41181d, 94 }, /* #108 */
    { 0x345146, 0x345182, 0xccff57ed216d757e, 0xcff57ed216d757ea, 0xa7fece92ee4ee230,  4 }, /* #109 */
    { 0x0b4293, 0x0b4206, 0x0de3e7a25f0a9d89, 0x25f0a9d89509a430, 0x509a43026176bc22, 28 }, /* #110 */
    { 0x212406, 0x212483, 0x08ce252f97ac91e1, 0x923c315f8c513061, 0x8afc6289830ef435, 237 }, /* #111 */
    { 0x103783, 0x103f82, 0x502540903cbbded8, 0xf6c3d0840c28a8d6, 0x7a108185151ac67b, 115 }, /* #112 */
    { 0x3b7942, 0x3b7983, 0x838dbfb677b72527, 0xc949d2ff5862e380, 0x4bfd618b8e03492c, 46 }, /* #113 */
    { 0x066286, 0x066a03, 0x87a7d5e14a419b2e, 0x483365df44ab47cb, 0xfa255a3e59718de5, 165 }, /* #114 */
    { 0x266cd2, 0x266403, 0x31a96444e645160c, 0x2c889cc8a2c18698, 0x34c215940c905dbd, 13 }, /* #115 */
    { 0x200883, 0x200002, 0x14f382d33020378c, 0x0378cb9e53c9da4c, 0xb9e53c9da4c87ade, 44 }, /* #116 */
    { 0x3b3ac3, 0x3b3a03, 0x833bbe6a38d49a61, 0x0b01eb032caa7115, 0x603d6065954e22be, 187 }, /* #117 */
    { 0x265907, 0x265187, 0xc21a77b1e72fdaf0, 0xed781519b6690311, 0x2a336cd2062242ea, 175 }, /* #118 */
    { 0x2a0cd3, 0x2a0c03, 0x808a1071bfa0d9f3, 0x0838dfd06cf9e29b, 0xc536396b8960f880, 15 }, /* #119 */
    { 0x3d1a12, 0x3d1a83, 0xbb1a1e65e5b6b8f8, 0x8e1a4bc8351b80d5, 0xe1a4bc8351b80d5d, 124 }, /* #120 */
    { 0x2d1657, 0x2d1602, 0xc3f0bd2c0e21458b, 0x1458b3eb37335313, 0x3eb373353134f3ca, 172 }, /* #121 */
    { 0x074386, 0x074382, 0x25cf058d01cbff84, 0xb1a0397ff09e5be0, 0xf2df0195ae27484b, 213 }, /* #122 */
    { 0x2c1153, 0x2c1187, 0xd7aafe106deac8c0, 0xeabf841b7ab2303a, 0xeae781389ce8d085, 134 }, /* #123 */
    { 0x370483, 0x370487, 0x112e6c69c66a5032, 0x9b1a719a940c8021, 0x0084061cfce3cdbc, 78 }, /* #124 */
    { 0x3a4457, 0x3a4402, 0xfcac173987ffd5f4, 0x7ffd5f425c8c0386, 0x25c8c0386978a090, 228 }, /* #125 */
    { 0x107583, 0x107d87, 0xab3736666d3e005a, 0x9b4f8016aa4f2e05, 0xa93cb81734636738, 222 }, /* #126 */
    { 0x017192, 0x017907, 0x78c6c5285c35787a, 0x18d8a50b86af0f50, 0x8675e13590edb84e,  5 }, /* #127 */
};
uint32_t const g_cTests_shld_u64_intel = RT_ELEMENTS(g_aTests_shld_u64_intel);

BINU64_TEST_T const g_aTests_shrd_u64_intel[] =
{
    { 0x1e7e86, 0x1e7646, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 159 }, /* #0 */
    { 0x1d1c96, 0x1d1446, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 173 }, /* #1 */
    { 0x020853, 0x020046, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 63 }, /* #2 */
    { 0x3d5f46, 0x3d5746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 75 }, /* #3 */
    { 0x122d47, 0x122d47, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,  0 }, /* #4 */
    { 0x1054c6, 0x105446, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 197 }, /* #5 */
    { 0x050197, 0x050107, 0x67a6f08461d569f8, 0x067a6f08461d569f, 0x0000000000000000, 196 }, /* #6 */
    { 0x3a38c3, 0x3a3002, 0x3caa81f7b4ebdf5d, 0x0000000003caa81f, 0x0000000000000000, 228 }, /* #7 */
    { 0x3a0287, 0x3a0a06, 0xc0e558ad09beb4b4, 0x0181cab15a137d69, 0x0000000000000000, 135 }, /* #8 */
    { 0x313882, 0x313003, 0x09d28c7df2e40d07, 0x04e9463ef9720683, 0x0000000000000000,  1 }, /* #9 */
    { 0x114f57, 0x114f02, 0xd1b4dbcab34a6258, 0x0000000068da6de5, 0x0000000000000000, 33 }, /* #10 */
    { 0x0633c6, 0x063b03, 0xf1153e11bcf239c8, 0x00000003c454f846, 0x0000000000000000, 222 }, /* #11 */
    { 0x050802, 0x050806, 0x6c0159382bdb83b2, 0x477e8db00564e0af, 0x1a4517468ed1dfa3, 214 }, /* #12 */
    { 0x171086, 0x171802, 0x68e2e2302f692911, 0x0c051e7a6d1c5c46, 0x33796d306028f3d3, 163 }, /* #13 */
    { 0x2d1582, 0x2d1d06, 0xe576a6eddd356d79, 0x42fdf19a20b1caed, 0x64a6a17ef8cd1058, 175 }, /* #14 */
    { 0x142306, 0x142386, 0x0819360f1c4bcca9, 0xf010326c1e389799, 0x0ed4ec173889e2f8, 199 }, /* #15 */
    { 0x370603, 0x370e02, 0x4b47ca251df5f577, 0x0c803f0646968f94, 0x16545d06401f8323, 39 }, /* #16 */
    { 0x315696, 0x315687, 0x6f530ab183069ada, 0xbb397848d275ce88, 0xdd9cbc24693ae744, 127 }, /* #17 */
    { 0x003c96, 0x003c07, 0x4131dd9891d952f8, 0x634b155701a098ee, 0x007e20c6962aae03, 105 }, /* #18 */
    { 0x140353, 0x140383, 0x258c1b23f3ee6bee, 0xae24a99244a90904, 0xad71254c92254848, 251 }, /* #19 */
    { 0x370ec7, 0x370e82, 0x9df82c07a55b8329, 0xdf93bf0580f4ab70, 0xdebea45c3e95c6fc, 11 }, /* #20 */
    { 0x3935c7, 0x393586, 0x13a4b061687bdc2e, 0xeadc43d4264409d2, 0x3d67d5b887a84c88, 177 }, /* #21 */
    { 0x060157, 0x060986, 0xdd1e17bf16cbf980, 0xb74785efc5b2fe60, 0x8048fff3b56778ba, 130 }, /* #22 */
    { 0x3e3ad3, 0x3e3a03, 0xa0781bdf4b8b2323, 0x6e5eacc7f78c4a07, 0x7506e5eacc7f78c4, 244 }, /* #23 */
    { 0x1658c2, 0x165802, 0x4f82fefd6ed1e579, 0x0c506e9522008a9d, 0x83141ba5488022a7, 254 }, /* #24 */
    { 0x372702, 0x372706, 0xfaf060d85cebe2a0, 0x0bf5e0c1b0b9d7c5, 0x136937075f194b85, 71 }, /* #25 */
    { 0x354b12, 0x354b87, 0x931cdf4bb9d201bb, 0x8cf65e07498e6fa5, 0x63afad9b19ecbc0e, 225 }, /* #26 */
    { 0x1c57d7, 0x1c5786, 0xa44be010ef6d85c1, 0xdc4e1d225f00877b, 0xbe0c8671bebb89c3, 21 }, /* #27 */
    { 0x340747, 0x340f82, 0x44507350688097e8, 0x808893299d1141cd, 0xa8296de02224ca67, 38 }, /* #28 */
    { 0x082356, 0x082b06, 0x9952c213d971e515, 0x7bbf4973c9952c21, 0x7c391727bbf4973c, 164 }, /* #29 */
    { 0x305587, 0x305507, 0x07338bd34f0ef050, 0x130c27bf4b4501cc, 0xe8e04c309efd2d14, 50 }, /* #30 */
    { 0x252a96, 0x252286, 0x359f115a77896558, 0xc4c4dca006b3e22b, 0x0b161ece2626e500, 35 }, /* #31 */
    { 0x144f06, 0x144702, 0xcfe2c97314b70a58, 0x5f3f8b25cc52dc29, 0x2c9dbec00ed1ba17,  6 }, /* #32 */
    { 0x174a92, 0x174a03, 0x434cb75e4939d815, 0x111d3e924e86996e, 0xa53927888e9f4927, 103 }, /* #33 */
    { 0x3a15c6, 0x3a1d87, 0x639a0fcc9c03018f, 0xb639a0fcc9c03018, 0x3a931f0f2cd5fc2b, 196 }, /* #34 */
    { 0x0b4806, 0x0b4087, 0xbec11f63d09801cb, 0xebe4de1e8efb047d, 0xbb96463af93787a3, 166 }, /* #35 */
    { 0x144282, 0x144203, 0xf78cf72571e4c4aa, 0x3621a24bde27f78c, 0xb3673621a24bde27, 112 }, /* #36 */
    { 0x216ed7, 0x216683, 0x1b9a13440954e67f, 0xc7957b5b7b567f10, 0x58f2af6b6f6acfe2, 189 }, /* #37 */
    { 0x2e03d7, 0x2e0306, 0xc4f07fb2efceb549, 0x559a1289b4ee52e2, 0xd0ab34251369dca5, 185 }, /* #38 */
    { 0x136897, 0x136003, 0xc7b3765bb9f7c09f, 0x210b9fba817e3d9b, 0x09ee642173f7502f, 45 }, /* #39 */
    { 0x3c2306, 0x3c2b86, 0x6a4ec310f93cdaeb, 0x9f7e7eda8f6a4ec3, 0xd95cda9f7e7eda8f, 168 }, /* #40 */
    { 0x3809d6, 0x380982, 0x7ef2ec2c08bc94b2, 0x89dfbcbb0b022f25, 0xf3b69b41ca6c9227, 10 }, /* #41 */
    { 0x3306c3, 0x330682, 0x9d9835e437e2429f, 0xed5a0acff3d9d983, 0x6632ced5a0acff3d, 172 }, /* #42 */
    { 0x110513, 0x110d83, 0xceef90df2c5ec023, 0xd9c6359ddf21be58, 0x288cfc5899ece31a, 151 }, /* #43 */
    { 0x235357, 0x235386, 0x05954a5e7bab40cb, 0xca77802caa52f3dd, 0x1e86ec837d194ef0, 21 }, /* #44 */
    { 0x2b69c6, 0x2b6182, 0x3223ab2e56052902, 0xc6447565cac0a520, 0x6d2eaddd0ccd7186, 67 }, /* #45 */
    { 0x094d83, 0x094503, 0x1b9ebc821296875f, 0x4958afabcdbf01b9, 0x00b4958afabcdbf0, 180 }, /* #46 */
    { 0x3f7e57, 0x3f7606, 0x45c04daab347fa86, 0x4e7f990bf30a45c0, 0x0d964e7f990bf30a, 240 }, /* #47 */
    { 0x042802, 0x042803, 0x4ac49ffacff36a7e, 0x710a9c3cdb03e958, 0x3dcb8854e1e6d81f, 243 }, /* #48 */
    { 0x0e5196, 0x0e5987, 0xe67b481e4cebdcfd, 0x8792625ccf6903c9, 0xefd0f9607c3c9312, 91 }, /* #49 */
    { 0x3c5992, 0x3c5106, 0x20d863a12ecac122, 0x540411566b5e106c, 0xc1f0a80822acd6bc, 241 }, /* #50 */
    { 0x2d2c07, 0x2d2c83, 0x18fc1ffa2b49bcf9, 0xf6a65fc63f07fe8a, 0x8a6c9991b7da997f, 90 }, /* #51 */
    { 0x082e02, 0x082683, 0x4d02a91424915a68, 0xb43d0adc7184d02a, 0x4391fb43d0adc718, 172 }, /* #52 */
    { 0x3b3b02, 0x3b3b06, 0xadcba50dd819b128, 0x60adcba50dd819b1, 0x1e1293b495301d60, 136 }, /* #53 */
    { 0x207186, 0x207183, 0x1f1c1cf9dd1ebd30, 0xc5f6bd03e3839f3b, 0xf8bed4cfbe2fb5e8, 219 }, /* #54 */
    { 0x175912, 0x175103, 0x683b7cea339d24b1, 0x1c51cbd8e0683b7c, 0x0c92ad1c51cbd8e0, 40 }, /* #55 */
    { 0x211e97, 0x211686, 0xf066bd3fcdefaf5d, 0xbff066bd3fcdefaf, 0x73817e84f5f5b5bf, 200 }, /* #56 */
    { 0x373346, 0x373b87, 0x55fcd9a270c82568, 0xef978e90df87755f, 0x16def978e90df877, 244 }, /* #57 */
    { 0x3b76d6, 0x3b7606, 0xd17dbc22ea3e94fe, 0x3c49b7c4f718c67d, 0x43c49b7c4f718c67, 60 }, /* #58 */
    { 0x3a7016, 0x3a7003, 0xaff6dfa424de8e4f, 0x0182d71fa84d7fb6, 0x59dd60305ae3f509, 237 }, /* #59 */
    { 0x301006, 0x301086, 0xfd3ff107fe6b3f16, 0xb7f4ffc41ff9acfc, 0xa21286e36239212d, 70 }, /* #60 */
    { 0x006513, 0x006507, 0x348793a815ca28a1, 0x1a43c9d40ae51450, 0x6a8fc33e7caeb620, 65 }, /* #61 */
    { 0x2c23d2, 0x2c2b06, 0xc657ce02c496eecd, 0x7934ec014ce2ed63, 0xfef269d80299c5da, 185 }, /* #62 */
    { 0x2f12c6, 0x2f1286, 0x605a8ab2795966e4, 0xd39c605a8ab27959, 0x20e835eeffb2d39c, 80 }, /* #63 */
    { 0x366653, 0x366687, 0x496f38c54ba9b68c, 0xe4c92de718a97536, 0xa84ba879766c8f26, 139 }, /* #64 */
    { 0x2e1a57, 0x2e1a07, 0x2a3bbadf11d4a4d6, 0x765a9e951ddd6f88, 0xbae5ff9c36ecb53d, 217 }, /* #65 */
    { 0x125916, 0x125983, 0xca2feeb175f2dd68, 0x802e2261945fdd62, 0x5e23505f40171130, 223 }, /* #66 */
    { 0x3539d3, 0x353107, 0x4a36b442316889e7, 0x251b5a2118b444f3, 0xf4895ec9ad51e32a, 129 }, /* #67 */
    { 0x243557, 0x243582, 0x062de9192f50773a, 0xe30319740c5bd232, 0x6a3e2e5471818cba, 223 }, /* #68 */
    { 0x0c5756, 0x0c5f02, 0x0037d968496731d7, 0x6dda3c12d44d6040, 0xddb768f04b513581, 250 }, /* #69 */
    { 0x0e6f52, 0x0e6f07, 0xfa9fc9d0926ea5a3, 0x3a5f53f93a124dd4, 0xba930c808d15d1d2, 75 }, /* #70 */
    { 0x2f2616, 0x2f2602, 0xce99911cc1a23857, 0x0a457e79d3322398, 0xb8a956a678522bf3, 91 }, /* #71 */
    { 0x2a3687, 0x2a3603, 0xe24cc4d79a677609, 0x299f126626bcd33b, 0x4b29eabcbb0d0533, 77 }, /* #72 */
    { 0x0c2ac6, 0x0c2207, 0x5812daffe99cd487, 0x0c245812daffe99c, 0x060399f40f460c24, 208 }, /* #73 */
    { 0x216507, 0x216d06, 0x568f102368ddf977, 0x7763dac0c5aad1e2, 0xc5f33bbb1ed6062d, 107 }, /* #74 */
    { 0x364086, 0x364006, 0x4437798a723bcfcd, 0x66bc02e6e30fb411, 0x119af00b9b8c3ed0, 250 }, /* #75 */
    { 0x312003, 0x312086, 0x8c18e01f50d5e14c, 0xc60c700fa86af0a6, 0xfa6ef4075b4d38af,  1 }, /* #76 */
    { 0x213e07, 0x213602, 0xa994f0698e5c40da, 0x65bb02e035329e0d, 0x2c2e4a832dd81701, 227 }, /* #77 */
    { 0x361292, 0x361a02, 0x5c8823e04f847a8e, 0x43d8986c35c8823e, 0x0dbebf143d8986c3, 164 }, /* #78 */
    { 0x331642, 0x331607, 0x9d5678407af999da, 0x624f3b9d706f9e39, 0x0624f3b9d706f9e3, 188 }, /* #79 */
    { 0x031c02, 0x031c83, 0x0e8903397bc9991d, 0xf03861143a240ce5, 0x30e79e75fc0e1845, 94 }, /* #80 */
    { 0x3b7347, 0x3b7303, 0x3c7291e4f0f94c79, 0x45c78e523c9e1f29, 0xe76b5e72d70d1a2e, 203 }, /* #81 */
    { 0x157957, 0x157182, 0xf6f3032b5222282c, 0x937dbcc0cad4888a, 0x9676cde9d54eca4d, 74 }, /* #82 */
    { 0x0f10c3, 0x0f1082, 0xc64392ff60596ef4, 0xbd8f6e89c0ca217c, 0x0bd8f6e89c0ca217, 124 }, /* #83 */
    { 0x327242, 0x327a82, 0xf6dc3a6cb55144f1, 0x89c5b7ef6dc3a6cb, 0x4e2f9696789c5b7e, 220 }, /* #84 */
    { 0x032503, 0x032586, 0x49a96e6a047ac412, 0xfcd926a5b9a811eb, 0x396fb1f74741ff36, 78 }, /* #85 */
    { 0x375e57, 0x375e82, 0x15a63d14e167f387, 0xb4e0caf9c5698f45, 0xb8ef3b76d3832be7, 34 }, /* #86 */
    { 0x3b0886, 0x3b0807, 0xfe070cdb013a4493, 0x3fdfc0e19b602748, 0x26c2f10b5ea551fe, 203 }, /* #87 */
    { 0x0a7086, 0x0a7803, 0xa721d38dd6710ee1, 0x6596ca948bb94e43, 0xaecd32cb654a45dc, 47 }, /* #88 */
    { 0x0b6252, 0x0b6203, 0xd246265325efb2fc, 0x363da6f6b527f491, 0xd04cd8f69bdad49f, 178 }, /* #89 */
    { 0x270217, 0x270202, 0xcda2ffd252e162c2, 0x39c03f86df26a39b, 0xad1ce01fc36f9351, 55 }, /* #90 */
    { 0x121257, 0x121a82, 0x9bb9feebb998abc8, 0x93773fdd77331579, 0xb948213a7f9c977c, 131 }, /* #91 */
    { 0x2930d7, 0x293803, 0x2f63f8c36feea6ba, 0x51d6d25ec7f186df, 0x4fd6ea616428eb69, 87 }, /* #92 */
    { 0x193287, 0x193283, 0xb72f75fd05fde47c, 0x847b36e5eebfa0bf, 0xed0317ef8e7c23d9, 19 }, /* #93 */
    { 0x1a6a86, 0x1a6a07, 0x89a96474f1cfdd1b, 0x089a96474f1cfdd1, 0x6a723ba07b440810,  4 }, /* #94 */
    { 0x214d07, 0x214d07, 0x2a41914655bf2aac, 0x2a41914655bf2aac, 0xaf22e1e4a92f9400, 192 }, /* #95 */
    { 0x190f02, 0x190f87, 0xc12fa1a506e23765, 0xf3ab04be86941b88, 0x7007b383073cbcea, 206 }, /* #96 */
    { 0x3877d7, 0x3877d7, 0xe8ec9c35586ee066, 0xe8ec9c35586ee066, 0x820ea97c2871b9dd, 192 }, /* #97 */
    { 0x383c57, 0x383c06, 0x01edc384165f11ce, 0x6067bee63a03db87, 0xbcd7cdb033df731d, 231 }, /* #98 */
    { 0x3d1416, 0x3d1c83, 0x68b496fed0a66d05, 0xb45e71785a2d25bf, 0xa792f19ed179c5e1, 98 }, /* #99 */
    { 0x1625c7, 0x162d86, 0x90979f5df6fb127a, 0xaed1b905a425e7d7, 0xe1f551e6bb46e416, 34 }, /* #100 */
    { 0x2a39c6, 0x2a3187, 0x500dbd7cd03b0a5f, 0x816804f14f8a01b7, 0x4b33640b40278a7c, 43 }, /* #101 */
    { 0x2c70c6, 0x2c7083, 0xf671d467f777956d, 0xb3ece3a8cfeeef2a, 0xa0865ed642917059,  7 }, /* #102 */
    { 0x153fc3, 0x153702, 0xba721ef907d9ba31, 0x0c2e54153aee9fba, 0xba0c2e54153aee9f, 56 }, /* #103 */
    { 0x185d16, 0x185587, 0x7201c14522a59afd, 0x8e403828a454b35f, 0xb448b10376d64dd4, 131 }, /* #104 */
    { 0x1f7f83, 0x1f7f03, 0x8df7352588c2f97d, 0x764ca153a6fda251, 0xebb2650a9d37ed12, 187 }, /* #105 */
    { 0x0631d7, 0x063183, 0xbfbff7d5d537d908, 0xb5dfdffbeaea9bec, 0x51a67616c8fc936b, 73 }, /* #106 */
    { 0x2f6e56, 0x2f6e02, 0x86c06927c45ed9f4, 0x3b514a86c06927c4, 0x330a597eab3b514a, 88 }, /* #107 */
    { 0x133246, 0x133286, 0xe024742a6d2e01a2, 0xb13f5499d3fe0247, 0x84f46b13f5499d3f, 236 }, /* #108 */
    { 0x247b92, 0x247b83, 0xd1154e86472017db, 0xcff7049a22a9d0c8, 0x6e7bb324d67fb824, 27 }, /* #109 */
    { 0x1d5257, 0x1d5a06, 0xb2e5ecf8c06b42f6, 0x2e1eeab2e5ecf8c0, 0xf4970427a02e1eea, 24 }, /* #110 */
    { 0x0f68d6, 0x0f6086, 0x0178d0673eb45816, 0x89fb20178d0673eb, 0xcbacde6991989fb2, 84 }, /* #111 */
    { 0x066b93, 0x066386, 0x7166fd0ee868672c, 0xd74e342240e2cdfa, 0x793cac6ba71a1120, 39 }, /* #112 */
    { 0x1120c7, 0x112087, 0xc775e9925dd11d09, 0xcd4f670f610f1dd7, 0x73223353d9c3d843, 110 }, /* #113 */
    { 0x1c2496, 0x1c2487, 0xd985f2b96de3705e, 0x93d1fa071ecc2f95, 0xb0d8ccf27a3f40e3, 101 }, /* #114 */
    { 0x245556, 0x245582, 0xc98708b36dbe7d57, 0xb4554d952499c726, 0x31ad155365492671, 182 }, /* #115 */
    { 0x2e1a83, 0x2e1283, 0x127b3b06046a6011, 0x815c704c9680093d, 0xbdb502b8e0992d00, 177 }, /* #116 */
    { 0x156856, 0x156086, 0x8c3b95d099c38b5e, 0xc77318772ba13387, 0x7de60b2289f063b9, 207 }, /* #117 */
    { 0x0c3a83, 0x0c3a86, 0x789ec57888255a23, 0xe6f13d8af1104ab4, 0x63286ccff0ac2873, 135 }, /* #118 */
    { 0x2d5d03, 0x2d5d03, 0xd05feb8fd2e3ecbd, 0x50d05feb8fd2e3ec, 0xcb08719a064e3250, 200 }, /* #119 */
    { 0x007796, 0x007702, 0x81d3bb8360b3e2cc, 0x0bc0e9ddc1b059f1, 0x5442bffcc2520c17, 201 }, /* #120 */
    { 0x387182, 0x387907, 0x063b27c58aedce60, 0x7e0c764f8b15db9c, 0x2b83dc42586f923f, 135 }, /* #121 */
    { 0x317ed2, 0x317e03, 0xa945f2dbb4035886, 0x6680dfdcbd063d52, 0x4933406fee5e831e, 119 }, /* #122 */
    { 0x2c7ac3, 0x2c7a86, 0x0db03cb2de9b072d, 0x847aff06e3168ac3, 0x6a11ebfc1b8c5a2b, 250 }, /* #123 */
    { 0x2b7c07, 0x2b7c07, 0x1011b5356671330b, 0x3fb2dc8a20236a6a, 0x5462a4d91fd96e45, 95 }, /* #124 */
    { 0x1a4dd6, 0x1a4d03, 0x3d485825c3ac25c2, 0x795e282425e3fa9e, 0x02f2bc50484bc7f5, 249 }, /* #125 */
    { 0x232257, 0x232203, 0x7e029df6c9648efd, 0x7eab89f80a77db25, 0x0b7dd000209faae2, 22 }, /* #126 */
    { 0x2e5a12, 0x2e5283, 0x968cfd2b2ddb86ed, 0xb859a55991432d19, 0x69555c2cd2acc8a1, 239 }, /* #127 */
};
uint32_t const g_cTests_shrd_u64_intel = RT_ELEMENTS(g_aTests_shrd_u64_intel);

BINU8_TEST_T const g_aTests_rol_u8_intel[] =
{
    { 0x280f83, 0x280782, 0x00, 0x00, 0, 31 }, /* #0 */
    { 0x177056, 0x177056, 0x00, 0x00, 0, 31 }, /* #0 b */
    { 0x1f47c3, 0x1f47c2, 0x00, 0x00, 0, 11 }, /* #1 */
    { 0x203816, 0x203016, 0x00, 0x00, 0, 11 }, /* #1 b */
    { 0x072786, 0x072786, 0x00, 0x00, 0, 30 }, /* #2 */
    { 0x385853, 0x385052, 0x00, 0x00, 0, 30 }, /* #2 b */
    { 0x2e6147, 0x2e6146, 0x00, 0x00, 0, 1  }, /* #3 */
    { 0x111e92, 0x111692, 0x00, 0x00, 0, 1  }, /* #3 b */
    { 0x2b2b03, 0x2b2302, 0x00, 0x00, 0, 5  }, /* #4 */
    { 0x1454d6, 0x1454d6, 0x00, 0x00, 0, 5  }, /* #4 b */
    { 0x131bd6, 0x1313d6, 0x00, 0x00, 0, 12 }, /* #5 */
    { 0x2c6403, 0x2c6402, 0x00, 0x00, 0, 12 }, /* #5 b */
    { 0x304bc2, 0x3043c3, 0xff, 0xff, 0, 14 }, /* #6 */
    { 0x0f3417, 0x0f3417, 0xff, 0xff, 0, 14 }, /* #6 b */
    { 0x3d1f43, 0x3d1743, 0x0f, 0xc3, 0, 6  }, /* #7 */
    { 0x026096, 0x026097, 0x0f, 0xc3, 0, 6  }, /* #7 b */
    { 0x035b42, 0x035342, 0xf3, 0xfc, 0, 22 }, /* #8 */
    { 0x3c2497, 0x3c2496, 0xf3, 0xfc, 0, 22 }, /* #8 b */
    { 0x395a57, 0x395257, 0x21, 0x09, 0, 11 }, /* #9 */
    { 0x062582, 0x062583, 0x21, 0x09, 0, 11 }, /* #9 b */
    { 0x392496, 0x392c96, 0x55, 0xaa, 0, 25 }, /* #10 */
    { 0x065b43, 0x065b42, 0x55, 0xaa, 0, 25 }, /* #10 b */
    { 0x1c0413, 0x1c0c12, 0x90, 0x84, 0, 11 }, /* #11 */
    { 0x237bc6, 0x237bc6, 0x90, 0x84, 0, 11 }, /* #11 b */
    { 0x2431c6, 0x2431c6, 0x01, 0x20, 0, 5  }, /* #12 */
    { 0x1b4e13, 0x1b4612, 0x01, 0x20, 0, 5  }, /* #12 b */
    { 0x182cd3, 0x1824d2, 0x3c, 0x1e, 0, 15 }, /* #13 */
    { 0x275306, 0x275306, 0x3c, 0x1e, 0, 15 }, /* #13 b */
    { 0x2909d2, 0x2909d3, 0x90, 0x21, 0, 9  }, /* #14 */
    { 0x167607, 0x167e07, 0x90, 0x21, 0, 9  }, /* #14 b */
    { 0x2d3213, 0x2d3a12, 0x5c, 0xe2, 0, 3  }, /* #15 */
    { 0x124dc6, 0x124dc6, 0x5c, 0xe2, 0, 3  }, /* #15 b */
    { 0x3072c2, 0x307ac3, 0x63, 0x8d, 0, 18 }, /* #16 */
    { 0x0f0d17, 0x0f0d17, 0x63, 0x8d, 0, 18 }, /* #16 b */
    { 0x2412c7, 0x241ac6, 0x88, 0x88, 0, 16 }, /* #17 */
    { 0x1b6d12, 0x1b6d12, 0x88, 0x88, 0, 16 }, /* #17 b */
    { 0x051f17, 0x051f16, 0xb0, 0xc2, 0, 2  }, /* #18 */
    { 0x3a60c2, 0x3a68c2, 0xb0, 0xc2, 0, 2  }, /* #18 b */
    { 0x262956, 0x262156, 0xdd, 0xee, 0, 31 }, /* #19 */
    { 0x195683, 0x195682, 0xdd, 0xee, 0, 31 }, /* #19 b */
    { 0x067416, 0x067416, 0x20, 0x10, 0, 15 }, /* #20 */
    { 0x390bc3, 0x3903c2, 0x20, 0x10, 0, 15 }, /* #20 b */
    { 0x2b7206, 0x2b7a07, 0x6b, 0x5b, 0, 19 }, /* #21 */
    { 0x140dd3, 0x140dd3, 0x6b, 0x5b, 0, 19 }, /* #21 b */
    { 0x023e16, 0x023e16, 0x45, 0xa2, 0, 23 }, /* #22 */
    { 0x3d41c3, 0x3d49c2, 0x45, 0xa2, 0, 23 }, /* #22 b */
    { 0x061807, 0x061807, 0x9b, 0xcd, 0, 31 }, /* #23 */
    { 0x3967d2, 0x396fd3, 0x9b, 0xcd, 0, 31 }, /* #23 b */
    { 0x1c5b03, 0x1c5303, 0x06, 0x81, 0, 14 }, /* #24 */
    { 0x2324d6, 0x2324d7, 0x06, 0x81, 0, 14 }, /* #24 b */
    { 0x2467c6, 0x2467c7, 0x3a, 0x1d, 0, 7  }, /* #25 */
    { 0x1b1813, 0x1b1013, 0x3a, 0x1d, 0, 7  }, /* #25 b */
    { 0x3655c6, 0x3655c6, 0xe2, 0x2e, 0, 12 }, /* #26 */
    { 0x092a13, 0x092212, 0xe2, 0x2e, 0, 12 }, /* #26 b */
    { 0x3a6516, 0x3a6d16, 0xbf, 0xfe, 0, 18 }, /* #27 */
    { 0x051ac3, 0x051ac2, 0xbf, 0xfe, 0, 18 }, /* #27 b */
    { 0x3b28d3, 0x3b20d2, 0x01, 0x04, 0, 2  }, /* #28 */
    { 0x045706, 0x045706, 0x01, 0x04, 0, 2  }, /* #28 b */
    { 0x306bd7, 0x306bd6, 0x82, 0x82, 0, 8  }, /* #29 */
    { 0x0f1402, 0x0f1c02, 0x82, 0x82, 0, 8  }, /* #29 b */
    { 0x136212, 0x136213, 0x3d, 0xe9, 0, 27 }, /* #30 */
    { 0x2c1dc7, 0x2c15c7, 0x3d, 0xe9, 0, 27 }, /* #30 b */
    { 0x071957, 0x071957, 0x6e, 0x37, 0, 31 }, /* #31 */
    { 0x386682, 0x386e83, 0x6e, 0x37, 0, 31 }, /* #31 b */
    { 0x2856c6, 0x2856c6, 0xc1, 0x38, 0, 13 }, /* #32 */
    { 0x172913, 0x172112, 0xc1, 0x38, 0, 13 }, /* #32 b */
    { 0x065357, 0x065b56, 0x62, 0x62, 0, 8  }, /* #33 */
    { 0x392c82, 0x392c82, 0x62, 0x62, 0, 8  }, /* #33 b */
    { 0x364a96, 0x364a97, 0x73, 0x37, 0, 28 }, /* #34 */
    { 0x093543, 0x093d43, 0x73, 0x37, 0, 28 }, /* #34 b */
    { 0x114e07, 0x114607, 0xec, 0x67, 0, 11 }, /* #35 */
    { 0x2e31d2, 0x2e31d3, 0xec, 0x67, 0, 11 }, /* #35 b */
    { 0x1f44c6, 0x1f4cc6, 0xab, 0xea, 0, 14 }, /* #36 */
    { 0x203b13, 0x203b12, 0xab, 0xea, 0, 14 }, /* #36 b */
    { 0x082d16, 0x082516, 0x37, 0xe6, 0, 29 }, /* #37 */
    { 0x3752c3, 0x3752c2, 0x37, 0xe6, 0, 29 }, /* #37 b */
    { 0x1c5507, 0x1c5d07, 0x97, 0x2f, 0, 1  }, /* #38 */
    { 0x232ad2, 0x232ad3, 0x97, 0x2f, 0, 1  }, /* #38 b */
    { 0x0b1107, 0x0b1906, 0x99, 0xcc, 0, 23 }, /* #39 */
    { 0x346ed2, 0x346ed2, 0x99, 0xcc, 0, 23 }, /* #39 b */
    { 0x1c1187, 0x1c1986, 0xa0, 0xa0, 0, 16 }, /* #40 */
    { 0x236e52, 0x236e52, 0xa0, 0xa0, 0, 16 }, /* #40 b */
    { 0x1b2012, 0x1b2812, 0x81, 0x60, 0, 14 }, /* #41 */
    { 0x245fc7, 0x245fc6, 0x81, 0x60, 0, 14 }, /* #41 b */
    { 0x3c7317, 0x3c7316, 0x04, 0x04, 0, 8  }, /* #42 */
    { 0x030cc2, 0x0304c2, 0x04, 0x04, 0, 8  }, /* #42 b */
    { 0x2b0503, 0x2b0d02, 0x55, 0xaa, 0, 23 }, /* #43 */
    { 0x147ad6, 0x147ad6, 0x55, 0xaa, 0, 23 }, /* #43 b */
    { 0x081c97, 0x081497, 0xde, 0x6f, 0, 23 }, /* #44 */
    { 0x376342, 0x376343, 0xde, 0x6f, 0, 23 }, /* #44 b */
    { 0x3e1a13, 0x3e1a12, 0x84, 0x90, 0, 13 }, /* #45 */
    { 0x0165c6, 0x016dc6, 0x84, 0x90, 0, 13 }, /* #45 b */
    { 0x322246, 0x322a46, 0x51, 0x54, 0, 22 }, /* #46 */
    { 0x0d5d93, 0x0d5d92, 0x51, 0x54, 0, 22 }, /* #46 b */
    { 0x1a57d6, 0x1a57d7, 0xcf, 0x3f, 0, 2  }, /* #47 */
    { 0x252803, 0x252003, 0xcf, 0x3f, 0, 2  }, /* #47 b */
    { 0x1b0487, 0x1b0c86, 0x77, 0xee, 0, 5  }, /* #48 */
    { 0x247b52, 0x247b52, 0x77, 0xee, 0, 5  }, /* #48 b */
    { 0x316d13, 0x316513, 0xc6, 0x1b, 0, 2  }, /* #49 */
    { 0x0e12c6, 0x0e12c7, 0xc6, 0x1b, 0, 2  }, /* #49 b */
    { 0x397757, 0x397756, 0x22, 0x88, 0, 14 }, /* #50 */
    { 0x060882, 0x060082, 0x22, 0x88, 0, 14 }, /* #50 b */
    { 0x1d5e92, 0x1d5692, 0x3d, 0x7a, 0, 1  }, /* #51 */
    { 0x222147, 0x222146, 0x3d, 0x7a, 0, 1  }, /* #51 b */
    { 0x373c92, 0x373493, 0x38, 0xc1, 0, 27 }, /* #52 */
    { 0x084347, 0x084347, 0x38, 0xc1, 0, 27 }, /* #52 b */
    { 0x3b7802, 0x3b7002, 0x02, 0x04, 0, 1  }, /* #53 */
    { 0x0407d7, 0x0407d6, 0x02, 0x04, 0, 1  }, /* #53 b */
    { 0x0a2e93, 0x0a2e93, 0x80, 0x01, 0, 17 }, /* #54 */
    { 0x355146, 0x355947, 0x80, 0x01, 0, 17 }, /* #54 b */
    { 0x1956d7, 0x195ed6, 0x94, 0x94, 0, 24 }, /* #55 */
    { 0x262902, 0x262902, 0x94, 0x94, 0, 24 }, /* #55 b */
    { 0x2e08c3, 0x2e08c2, 0x59, 0xac, 0, 23 }, /* #56 */
    { 0x117716, 0x117f16, 0x59, 0xac, 0, 23 }, /* #56 b */
    { 0x136147, 0x136946, 0x4f, 0xf4, 0, 4  }, /* #57 */
    { 0x2c1e92, 0x2c1e92, 0x4f, 0xf4, 0, 4  }, /* #57 b */
    { 0x2c1203, 0x2c1a02, 0x98, 0x62, 0, 2  }, /* #58 */
    { 0x136dd6, 0x136dd6, 0x98, 0x62, 0, 2  }, /* #58 b */
    { 0x165b97, 0x165397, 0x3b, 0xd9, 0, 27 }, /* #59 */
    { 0x292442, 0x292443, 0x3b, 0xd9, 0, 27 }, /* #59 b */
    { 0x130782, 0x130782, 0x30, 0x0c, 0, 14 }, /* #60 */
    { 0x2c7857, 0x2c7056, 0x30, 0x0c, 0, 14 }, /* #60 b */
    { 0x2a1987, 0x2a1987, 0xa7, 0xa7, 0, 8  }, /* #61 */
    { 0x156652, 0x156e53, 0xa7, 0xa7, 0, 8  }, /* #61 b */
    { 0x1d4587, 0x1d4d86, 0x64, 0x32, 0, 15 }, /* #62 */
    { 0x223a52, 0x223a52, 0x64, 0x32, 0, 15 }, /* #62 b */
    { 0x260c86, 0x260c87, 0x43, 0xa1, 0, 15 }, /* #63 */
    { 0x197353, 0x197b53, 0x43, 0xa1, 0, 15 }, /* #63 b */
    { 0x272d57, 0x272556, 0x00, 0x00, 0, 3  }, /* #64 */
    { 0x185282, 0x185282, 0x00, 0x00, 0, 3  }, /* #64 b */
    { 0x2e65d7, 0x2e65d6, 0x08, 0x10, 0, 9  }, /* #65 */
    { 0x111a02, 0x111202, 0x08, 0x10, 0, 9  }, /* #65 b */
    { 0x3f5386, 0x3f5386, 0x24, 0x84, 0, 5  }, /* #66 */
    { 0x002c53, 0x002452, 0x24, 0x84, 0, 5  }, /* #66 b */
    { 0x053f42, 0x053742, 0x09, 0x42, 0, 22 }, /* #67 */
    { 0x3a4097, 0x3a4096, 0x09, 0x42, 0, 22 }, /* #67 b */
    { 0x094ac6, 0x0942c6, 0x38, 0x70, 0, 25 }, /* #68 */
    { 0x363513, 0x363512, 0x38, 0x70, 0, 25 }, /* #68 b */
    { 0x3d1983, 0x3d1183, 0xd5, 0x57, 0, 18 }, /* #69 */
    { 0x026656, 0x026657, 0xd5, 0x57, 0, 18 }, /* #69 b */
    { 0x0b6e47, 0x0b6e46, 0x71, 0x5c, 0, 30 }, /* #70 */
    { 0x341192, 0x341992, 0x71, 0x5c, 0, 30 }, /* #70 b */
    { 0x0541c6, 0x0541c7, 0xff, 0xff, 0, 16 }, /* #71 */
    { 0x3a3e13, 0x3a3613, 0xff, 0xff, 0, 16 }, /* #71 b */
    { 0x1b7557, 0x1b7d57, 0x83, 0xc1, 0, 7  }, /* #72 */
    { 0x240a82, 0x240a83, 0x83, 0xc1, 0, 7  }, /* #72 b */
    { 0x027c86, 0x027487, 0x24, 0x09, 0, 14 }, /* #73 */
    { 0x3d0353, 0x3d0353, 0x24, 0x09, 0, 14 }, /* #73 b */
    { 0x1f49d2, 0x1f49d3, 0xae, 0xab, 0, 30 }, /* #74 */
    { 0x203607, 0x203e07, 0xae, 0xab, 0, 30 }, /* #74 b */
    { 0x0170d3, 0x0178d3, 0xa1, 0x0d, 0, 27 }, /* #75 */
    { 0x3e0f06, 0x3e0f07, 0xa1, 0x0d, 0, 27 }, /* #75 b */
    { 0x3f0f17, 0x3f0f17, 0x9e, 0x3d, 0, 25 }, /* #76 */
    { 0x0070c2, 0x0078c3, 0x9e, 0x3d, 0, 25 }, /* #76 b */
    { 0x2e45d2, 0x2e45d3, 0x35, 0x4d, 0, 30 }, /* #77 */
    { 0x113a07, 0x113207, 0x35, 0x4d, 0, 30 }, /* #77 b */
    { 0x1037d3, 0x1037d3, 0x3d, 0x3d, 0, 24 }, /* #78 */
    { 0x2f4806, 0x2f4007, 0x3d, 0x3d, 0, 24 }, /* #78 b */
    { 0x0771d2, 0x0779d3, 0x57, 0x5d, 0, 18 }, /* #79 */
    { 0x380e07, 0x380e07, 0x57, 0x5d, 0, 18 }, /* #79 b */
    { 0x0a4ac3, 0x0a42c2, 0xec, 0xec, 0, 24 }, /* #80 */
    { 0x353516, 0x353516, 0xec, 0xec, 0, 24 }, /* #80 b */
    { 0x1b2197, 0x1b2996, 0x58, 0x2c, 0, 15 }, /* #81 */
    { 0x245e42, 0x245e42, 0x58, 0x2c, 0, 15 }, /* #81 b */
    { 0x3751c2, 0x3759c2, 0xa1, 0x34, 0, 21 }, /* #82 */
    { 0x082e17, 0x082e16, 0xa1, 0x34, 0, 21 }, /* #82 b */
    { 0x080d13, 0x080512, 0x3b, 0xec, 0, 2  }, /* #83 */
    { 0x3772c6, 0x3772c6, 0x3b, 0xec, 0, 2  }, /* #83 b */
    { 0x0c5ed6, 0x0c5ed6, 0x72, 0xe4, 0, 9  }, /* #84 */
    { 0x332103, 0x332902, 0x72, 0xe4, 0, 9  }, /* #84 b */
    { 0x1b1216, 0x1b1a17, 0x5b, 0x6d, 0, 18 }, /* #85 */
    { 0x246dc3, 0x246dc3, 0x5b, 0x6d, 0, 18 }, /* #85 b */
    { 0x1d2002, 0x1d2803, 0x60, 0x03, 0, 3  }, /* #86 */
    { 0x225fd7, 0x225fd7, 0x60, 0x03, 0, 3  }, /* #86 b */
    { 0x055142, 0x055143, 0x3b, 0x9d, 0, 23 }, /* #87 */
    { 0x3a2e97, 0x3a2697, 0x3b, 0x9d, 0, 23 }, /* #87 b */
    { 0x274487, 0x274c86, 0x8c, 0x46, 0, 15 }, /* #88 */
    { 0x183b52, 0x183b52, 0x8c, 0x46, 0, 15 }, /* #88 b */
    { 0x377dc6, 0x3775c7, 0x20, 0x01, 0, 11 }, /* #89 */
    { 0x080213, 0x080213, 0x20, 0x01, 0, 11 }, /* #89 b */
    { 0x161d52, 0x161d52, 0xdd, 0xdd, 0, 0  }, /* #90 */
    { 0x296287, 0x296287, 0xdd, 0xdd, 0, 0  }, /* #90 b */
    { 0x3a4546, 0x3a4546, 0xc0, 0x30, 0, 6  }, /* #91 */
    { 0x053a93, 0x053292, 0xc0, 0x30, 0, 6  }, /* #91 b */
    { 0x394b17, 0x394316, 0x07, 0x0e, 0, 17 }, /* #92 */
    { 0x0634c2, 0x0634c2, 0x07, 0x0e, 0, 17 }, /* #92 b */
    { 0x0a1003, 0x0a1002, 0x34, 0x68, 0, 17 }, /* #93 */
    { 0x356fd6, 0x3567d6, 0x34, 0x68, 0, 17 }, /* #93 b */
    { 0x0f2313, 0x0f2b12, 0x77, 0xee, 0, 1  }, /* #94 */
    { 0x305cc6, 0x305cc6, 0x77, 0xee, 0, 1  }, /* #94 b */
    { 0x0e20c3, 0x0e28c3, 0x5e, 0xcb, 0, 5  }, /* #95 */
    { 0x315f16, 0x315f17, 0x5e, 0xcb, 0, 5  }, /* #95 b */
};
uint32_t const g_cTests_rol_u8_intel = RT_ELEMENTS(g_aTests_rol_u8_intel);

BINU8_TEST_T const g_aTests_ror_u8_intel[] =
{
    { 0x0d1e52, 0x0d1652, 0x00, 0x00, 0, 31 }, /* #0 */
    { 0x326187, 0x326186, 0x00, 0x00, 0, 31 }, /* #0 b */
    { 0x375216, 0x375216, 0x00, 0x00, 0, 19 }, /* #1 */
    { 0x082dc3, 0x0825c2, 0x00, 0x00, 0, 19 }, /* #1 b */
    { 0x2c1942, 0x2c1142, 0x00, 0x00, 0, 16 }, /* #2 */
    { 0x136697, 0x136696, 0x00, 0x00, 0, 16 }, /* #2 b */
    { 0x212457, 0x212456, 0x00, 0x00, 0, 12 }, /* #3 */
    { 0x1e5b82, 0x1e5382, 0x00, 0x00, 0, 12 }, /* #3 b */
    { 0x225486, 0x225486, 0x00, 0x00, 0, 5  }, /* #4 */
    { 0x1d2b53, 0x1d2352, 0x00, 0x00, 0, 5  }, /* #4 b */
    { 0x385f82, 0x385f82, 0x00, 0x00, 0, 0  }, /* #5 */
    { 0x072057, 0x072057, 0x00, 0x00, 0, 0  }, /* #5 b */
    { 0x387f96, 0x387f96, 0xb0, 0x58, 0, 9  }, /* #6 */
    { 0x070043, 0x070842, 0xb0, 0x58, 0, 9  }, /* #6 b */
    { 0x186983, 0x186982, 0xaa, 0x55, 0, 9  }, /* #7 */
    { 0x271656, 0x271e56, 0xaa, 0x55, 0, 9  }, /* #7 b */
    { 0x2327c6, 0x2327c7, 0xfd, 0xbf, 0, 3  }, /* #8 */
    { 0x1c5813, 0x1c5013, 0xfd, 0xbf, 0, 3  }, /* #8 b */
    { 0x330e46, 0x330646, 0xbb, 0x77, 0, 7  }, /* #9 */
    { 0x0c7193, 0x0c7192, 0xbb, 0x77, 0, 7  }, /* #9 b */
    { 0x037d02, 0x037d02, 0x05, 0x41, 0, 10 }, /* #10 */
    { 0x3c02d7, 0x3c0ad6, 0x05, 0x41, 0, 10 }, /* #10 b */
    { 0x1d0a17, 0x1d0a16, 0x07, 0x07, 0, 16 }, /* #11 */
    { 0x2275c2, 0x227dc2, 0x07, 0x07, 0, 16 }, /* #11 b */
    { 0x2e45c7, 0x2e4dc7, 0x86, 0xa1, 0, 10 }, /* #12 */
    { 0x113a12, 0x113a13, 0x86, 0xa1, 0, 10 }, /* #12 b */
    { 0x066c86, 0x066c86, 0x33, 0x66, 0, 19 }, /* #13 */
    { 0x391353, 0x391b52, 0x33, 0x66, 0, 19 }, /* #13 b */
    { 0x3d0392, 0x3d0393, 0xe9, 0xe9, 0, 24 }, /* #14 */
    { 0x027c47, 0x027447, 0xe9, 0xe9, 0, 24 }, /* #14 b */
    { 0x157082, 0x157882, 0x88, 0x44, 0, 25 }, /* #15 */
    { 0x2a0f57, 0x2a0f56, 0x88, 0x44, 0, 25 }, /* #15 b */
    { 0x1d5403, 0x1d5c03, 0xcc, 0x99, 0, 27 }, /* #16 */
    { 0x222bd6, 0x222bd7, 0xcc, 0x99, 0, 27 }, /* #16 b */
    { 0x396ac3, 0x396ac2, 0x8e, 0x47, 0, 1  }, /* #17 */
    { 0x061516, 0x061d16, 0x8e, 0x47, 0, 1  }, /* #17 b */
    { 0x004f06, 0x004f06, 0x36, 0x36, 0, 0  }, /* #18 */
    { 0x3f30d3, 0x3f30d3, 0x36, 0x36, 0, 0  }, /* #18 b */
    { 0x301b46, 0x301347, 0xcd, 0xb9, 0, 27 }, /* #19 */
    { 0x0f6493, 0x0f6493, 0xcd, 0xb9, 0, 27 }, /* #19 b */
    { 0x0d49d3, 0x0d41d2, 0x9f, 0x3f, 0, 23 }, /* #20 */
    { 0x323606, 0x323606, 0x9f, 0x3f, 0, 23 }, /* #20 b */
    { 0x106883, 0x106883, 0x0b, 0x85, 0, 25 }, /* #21 */
    { 0x2f1756, 0x2f1f57, 0x0b, 0x85, 0, 25 }, /* #21 b */
    { 0x1a6513, 0x1a6512, 0x08, 0x10, 0, 15 }, /* #22 */
    { 0x251ac6, 0x2512c6, 0x08, 0x10, 0, 15 }, /* #22 b */
    { 0x1364d6, 0x1364d6, 0x74, 0x1d, 0, 10 }, /* #23 */
    { 0x2c1b03, 0x2c1302, 0x74, 0x1d, 0, 10 }, /* #23 b */
    { 0x2c3853, 0x2c3052, 0x44, 0x44, 0, 16 }, /* #24 */
    { 0x134786, 0x134786, 0x44, 0x44, 0, 16 }, /* #24 b */
    { 0x232bd7, 0x2323d6, 0x1e, 0x0f, 0, 25 }, /* #25 */
    { 0x1c5402, 0x1c5402, 0x1e, 0x0f, 0, 25 }, /* #25 b */
    { 0x363552, 0x363d53, 0xda, 0xd6, 0, 13 }, /* #26 */
    { 0x094a87, 0x094a87, 0xda, 0xd6, 0, 13 }, /* #26 b */
    { 0x3e24d2, 0x3e2cd2, 0x90, 0x12, 0, 11 }, /* #27 */
    { 0x015b07, 0x015b06, 0x90, 0x12, 0, 11 }, /* #27 b */
    { 0x025cc6, 0x0254c7, 0x4e, 0x9c, 0, 31 }, /* #28 */
    { 0x3d2313, 0x3d2313, 0x4e, 0x9c, 0, 31 }, /* #28 b */
    { 0x3212c6, 0x3212c7, 0xbf, 0xdf, 0, 9  }, /* #29 */
    { 0x0d6d13, 0x0d6513, 0xbf, 0xdf, 0, 9  }, /* #29 b */
    { 0x064287, 0x064a87, 0x65, 0xac, 0, 27 }, /* #30 */
    { 0x393d52, 0x393d53, 0x65, 0xac, 0, 27 }, /* #30 b */
    { 0x2b1457, 0x2b1c57, 0x67, 0xd9, 0, 26 }, /* #31 */
    { 0x146b82, 0x146b83, 0x67, 0xd9, 0, 26 }, /* #31 b */
    { 0x0b2ec7, 0x0b26c6, 0xa1, 0x34, 0, 11 }, /* #32 */
    { 0x345112, 0x345112, 0xa1, 0x34, 0, 11 }, /* #32 b */
    { 0x2b64c3, 0x2b6cc3, 0x19, 0x8c, 0, 9  }, /* #33 */
    { 0x141b16, 0x141b17, 0x19, 0x8c, 0, 9  }, /* #33 b */
    { 0x240d52, 0x240553, 0xff, 0xff, 0, 17 }, /* #34 */
    { 0x1b7287, 0x1b7287, 0xff, 0xff, 0, 17 }, /* #34 b */
    { 0x0f01c6, 0x0f01c7, 0xd3, 0x9e, 0, 21 }, /* #35 */
    { 0x307e13, 0x307613, 0xd3, 0x9e, 0, 21 }, /* #35 b */
    { 0x200147, 0x200946, 0x5b, 0x6d, 0, 22 }, /* #36 */
    { 0x1f7e92, 0x1f7e92, 0x5b, 0x6d, 0, 22 }, /* #36 b */
    { 0x227956, 0x227957, 0xea, 0xd5, 0, 7  }, /* #37 */
    { 0x1d0683, 0x1d0e83, 0xea, 0xd5, 0, 7  }, /* #37 b */
    { 0x2b4493, 0x2b4c92, 0x2f, 0x2f, 0, 24 }, /* #38 */
    { 0x143b46, 0x143b46, 0x2f, 0x2f, 0, 24 }, /* #38 b */
    { 0x282803, 0x282003, 0x9b, 0xe6, 0, 10 }, /* #39 */
    { 0x1757d6, 0x1757d7, 0x9b, 0xe6, 0, 10 }, /* #39 b */
    { 0x076383, 0x076b82, 0x31, 0x62, 0, 7  }, /* #40 */
    { 0x381c56, 0x381c56, 0x31, 0x62, 0, 7  }, /* #40 b */
    { 0x1f4f42, 0x1f4f42, 0x2b, 0x65, 0, 3  }, /* #41 */
    { 0x203097, 0x203896, 0x2b, 0x65, 0, 3  }, /* #41 b */
    { 0x2f41d3, 0x2f41d2, 0xe3, 0x7c, 0, 27 }, /* #42 */
    { 0x103e06, 0x103606, 0xe3, 0x7c, 0, 27 }, /* #42 b */
    { 0x3b4847, 0x3b4046, 0x5c, 0x17, 0, 2  }, /* #43 */
    { 0x043792, 0x043792, 0x5c, 0x17, 0, 2  }, /* #43 b */
    { 0x235742, 0x235742, 0x64, 0x19, 0, 2  }, /* #44 */
    { 0x1c2897, 0x1c2096, 0x64, 0x19, 0, 2  }, /* #44 b */
    { 0x191356, 0x191356, 0x58, 0x58, 0, 0  }, /* #45 */
    { 0x266c83, 0x266c83, 0x58, 0x58, 0, 0  }, /* #45 b */
    { 0x0f3692, 0x0f3e93, 0x45, 0xa2, 0, 25 }, /* #46 */
    { 0x304947, 0x304947, 0x45, 0xa2, 0, 25 }, /* #46 b */
    { 0x327fd7, 0x3277d6, 0xbb, 0x77, 0, 19 }, /* #47 */
    { 0x0d0002, 0x0d0002, 0xbb, 0x77, 0, 19 }, /* #47 b */
    { 0x191417, 0x191c17, 0x7d, 0xfa, 0, 23 }, /* #48 */
    { 0x266bc2, 0x266bc3, 0x7d, 0xfa, 0, 23 }, /* #48 b */
    { 0x0c1207, 0x0c1207, 0x8f, 0xc7, 0, 17 }, /* #49 */
    { 0x336dd2, 0x3365d3, 0x8f, 0xc7, 0, 17 }, /* #49 b */
    { 0x3b0ad3, 0x3b0ad2, 0xfa, 0x5f, 0, 3  }, /* #50 */
    { 0x047506, 0x047d06, 0xfa, 0x5f, 0, 3  }, /* #50 b */
    { 0x301913, 0x301913, 0xf8, 0xc7, 0, 21 }, /* #51 */
    { 0x0f66c6, 0x0f6ec7, 0xf8, 0xc7, 0, 21 }, /* #51 b */
    { 0x3d3a93, 0x3d3a93, 0x8c, 0xc8, 0, 28 }, /* #52 */
    { 0x024546, 0x024d47, 0x8c, 0xc8, 0, 28 }, /* #52 b */
    { 0x0e77c6, 0x0e7fc6, 0x84, 0x09, 0, 31 }, /* #53 */
    { 0x310813, 0x310812, 0x84, 0x09, 0, 31 }, /* #53 b */
    { 0x364342, 0x364342, 0x42, 0x24, 0, 4  }, /* #54 */
    { 0x093c97, 0x093496, 0x42, 0x24, 0, 4  }, /* #54 b */
    { 0x186b96, 0x186396, 0xe9, 0x7a, 0, 2  }, /* #55 */
    { 0x271443, 0x271442, 0xe9, 0x7a, 0, 2  }, /* #55 b */
    { 0x302a92, 0x302293, 0xf7, 0xbf, 0, 21 }, /* #56 */
    { 0x0f5547, 0x0f5547, 0xf7, 0xbf, 0, 21 }, /* #56 b */
    { 0x3a2846, 0x3a2047, 0x64, 0x91, 0, 14 }, /* #57 */
    { 0x055793, 0x055793, 0x64, 0x91, 0, 14 }, /* #57 b */
    { 0x2d26d6, 0x2d26d7, 0xbd, 0xed, 0, 5  }, /* #58 */
    { 0x125903, 0x125103, 0xbd, 0xed, 0, 5  }, /* #58 b */
    { 0x0f4592, 0x0f4d93, 0x63, 0x8d, 0, 22 }, /* #59 */
    { 0x303a47, 0x303a47, 0x63, 0x8d, 0, 22 }, /* #59 b */
    { 0x1e2cd3, 0x1e2cd2, 0x0b, 0x2c, 0, 6  }, /* #60 */
    { 0x215306, 0x215b06, 0x0b, 0x2c, 0, 6  }, /* #60 b */
    { 0x155643, 0x155e43, 0x25, 0xa4, 0, 27 }, /* #61 */
    { 0x2a2996, 0x2a2997, 0x25, 0xa4, 0, 27 }, /* #61 b */
    { 0x334156, 0x334957, 0x92, 0x92, 0, 16 }, /* #62 */
    { 0x0c3e83, 0x0c3e83, 0x92, 0x92, 0, 16 }, /* #62 b */
    { 0x3c0142, 0x3c0142, 0x83, 0x38, 0, 4  }, /* #63 */
    { 0x037e97, 0x037696, 0x83, 0x38, 0, 4  }, /* #63 b */
    { 0x2b0e97, 0x2b0e96, 0x79, 0x2f, 0, 11 }, /* #64 */
    { 0x147142, 0x147942, 0x79, 0x2f, 0, 11 }, /* #64 b */
    { 0x045ad3, 0x0452d2, 0xb1, 0x63, 0, 15 }, /* #65 */
    { 0x3b2506, 0x3b2506, 0xb1, 0x63, 0, 15 }, /* #65 b */
    { 0x3f4cd7, 0x3f4cd7, 0x61, 0x85, 0, 14 }, /* #66 */
    { 0x003302, 0x003b03, 0x61, 0x85, 0, 14 }, /* #66 b */
    { 0x2c6a96, 0x2c6297, 0x46, 0x91, 0, 10 }, /* #67 */
    { 0x131543, 0x131543, 0x46, 0x91, 0, 10 }, /* #67 b */
    { 0x231253, 0x231a53, 0x96, 0xd2, 0, 27 }, /* #68 */
    { 0x1c6d86, 0x1c6d87, 0x96, 0xd2, 0, 27 }, /* #68 b */
    { 0x246356, 0x246357, 0xb5, 0xb6, 0, 27 }, /* #69 */
    { 0x1b1c83, 0x1b1483, 0xb5, 0xb6, 0, 27 }, /* #69 b */
    { 0x1100d6, 0x1108d7, 0xc4, 0xc4, 0, 8  }, /* #70 */
    { 0x2e7f03, 0x2e7f03, 0xc4, 0xc4, 0, 8  }, /* #70 b */
    { 0x0321d6, 0x0329d6, 0x84, 0x48, 0, 20 }, /* #71 */
    { 0x3c5e03, 0x3c5e02, 0x84, 0x48, 0, 20 }, /* #71 b */
    { 0x061c16, 0x061c16, 0x8c, 0x19, 0, 23 }, /* #72 */
    { 0x3963c3, 0x396bc2, 0x8c, 0x19, 0, 23 }, /* #72 b */
    { 0x0b5a46, 0x0b5a46, 0xa6, 0x4d, 0, 23 }, /* #73 */
    { 0x342593, 0x342d92, 0xa6, 0x4d, 0, 23 }, /* #73 b */
    { 0x374f12, 0x374f12, 0x8c, 0x23, 0, 2  }, /* #74 */
    { 0x0830c7, 0x0838c6, 0x8c, 0x23, 0, 2  }, /* #74 b */
    { 0x082ed7, 0x082ed7, 0x5d, 0xba, 0, 31 }, /* #75 */
    { 0x375102, 0x375903, 0x5d, 0xba, 0, 31 }, /* #75 b */
    { 0x281c86, 0x281486, 0xd5, 0x5d, 0, 20 }, /* #76 */
    { 0x176353, 0x176352, 0xd5, 0x5d, 0, 20 }, /* #76 b */
    { 0x3c6952, 0x3c6152, 0x58, 0x58, 0, 24 }, /* #77 */
    { 0x031687, 0x031686, 0x58, 0x58, 0, 24 }, /* #77 b */
    { 0x170a96, 0x170a96, 0xa0, 0x28, 0, 10 }, /* #78 */
    { 0x287543, 0x287d42, 0xa0, 0x28, 0, 10 }, /* #78 b */
    { 0x3402d7, 0x340ad7, 0xb2, 0x95, 0, 13 }, /* #79 */
    { 0x0b7d02, 0x0b7d03, 0xb2, 0x95, 0, 13 }, /* #79 b */
    { 0x363d53, 0x363d53, 0x7f, 0xef, 0, 19 }, /* #80 */
    { 0x094286, 0x094a87, 0x7f, 0xef, 0, 19 }, /* #80 b */
    { 0x334593, 0x334d92, 0xa6, 0x53, 0, 9  }, /* #81 */
    { 0x0c3a46, 0x0c3a46, 0xa6, 0x53, 0, 9  }, /* #81 b */
    { 0x2a1ed2, 0x2a16d2, 0x04, 0x40, 0, 4  }, /* #82 */
    { 0x156107, 0x156106, 0x04, 0x40, 0, 4  }, /* #82 b */
    { 0x0142c6, 0x014ac6, 0x19, 0x64, 0, 22 }, /* #83 */
    { 0x3e3d13, 0x3e3d12, 0x19, 0x64, 0, 22 }, /* #83 b */
    { 0x180a17, 0x180a17, 0x7d, 0xfa, 0, 15 }, /* #84 */
    { 0x2775c2, 0x277dc3, 0x7d, 0xfa, 0, 15 }, /* #84 b */
    { 0x0c6307, 0x0c6b06, 0xae, 0x57, 0, 17 }, /* #85 */
    { 0x331cd2, 0x331cd2, 0xae, 0x57, 0, 17 }, /* #85 b */
    { 0x1a6dd6, 0x1a6dd6, 0x31, 0x13, 0, 4  }, /* #86 */
    { 0x251203, 0x251a02, 0x31, 0x13, 0, 4  }, /* #86 b */
    { 0x1c3197, 0x1c3197, 0xd1, 0x8e, 0, 29 }, /* #87 */
    { 0x234e42, 0x234643, 0xd1, 0x8e, 0, 29 }, /* #87 b */
    { 0x167fc3, 0x167fc3, 0x2f, 0xcb, 0, 18 }, /* #88 */
    { 0x290016, 0x290817, 0x2f, 0xcb, 0, 18 }, /* #88 b */
    { 0x103d42, 0x103d42, 0xf2, 0x5e, 0, 3  }, /* #89 */
    { 0x2f4297, 0x2f4a96, 0xf2, 0x5e, 0, 3  }, /* #89 b */
    { 0x0a3952, 0x0a3953, 0x71, 0x8b, 0, 21 }, /* #90 */
    { 0x354687, 0x354e87, 0x71, 0x8b, 0, 21 }, /* #90 b */
    { 0x326607, 0x326607, 0x1c, 0xc1, 0, 4  }, /* #91 */
    { 0x0d19d2, 0x0d11d3, 0x1c, 0xc1, 0, 4  }, /* #91 b */
    { 0x256c57, 0x256c57, 0xcc, 0x99, 0, 15 }, /* #92 */
    { 0x1a1382, 0x1a1b83, 0xcc, 0x99, 0, 15 }, /* #92 b */
    { 0x3d0e56, 0x3d0e57, 0x9a, 0x9a, 0, 16 }, /* #93 */
    { 0x027183, 0x027983, 0x9a, 0x9a, 0, 16 }, /* #93 b */
    { 0x3f75c7, 0x3f75c7, 0xa1, 0x86, 0, 22 }, /* #94 */
    { 0x000a12, 0x000213, 0xa1, 0x86, 0, 22 }, /* #94 b */
    { 0x0d1243, 0x0d1a43, 0xf6, 0xf6, 0, 16 }, /* #95 */
    { 0x326d96, 0x326d97, 0xf6, 0xf6, 0, 16 }, /* #95 b */
};
uint32_t const g_cTests_ror_u8_intel = RT_ELEMENTS(g_aTests_ror_u8_intel);

BINU8_TEST_T const g_aTests_rcl_u8_intel[] =
{
    { 0x2d6083, 0x2d6083, 0x00, 0x00, 0, 27 }, /* #0 */
    { 0x121f56, 0x121f56, 0x00, 0x00, 0, 27 }, /* #0 b */
    { 0x1a6292, 0x1a6292, 0x00, 0x00, 0, 23 }, /* #1 */
    { 0x251d47, 0x251546, 0x00, 0x10, 0, 23 }, /* #1 b */
    { 0x0b1856, 0x0b1056, 0x00, 0x00, 0, 4  }, /* #2 */
    { 0x346783, 0x346782, 0x00, 0x08, 0, 4  }, /* #2 b */
    { 0x286242, 0x286242, 0x00, 0x00, 0, 8  }, /* #3 */
    { 0x171d97, 0x171596, 0x00, 0x80, 0, 8  }, /* #3 b */
    { 0x1e2196, 0x1e2196, 0x00, 0x00, 0, 13 }, /* #4 */
    { 0x215e43, 0x215642, 0x00, 0x08, 0, 13 }, /* #4 b */
    { 0x3c1206, 0x3c1206, 0x00, 0x00, 0, 25 }, /* #5 */
    { 0x036dd3, 0x0365d2, 0x00, 0x40, 0, 25 }, /* #5 b */
    { 0x1f6187, 0x1f6186, 0x00, 0x40, 0, 16 }, /* #6 */
    { 0x201e52, 0x201652, 0x00, 0x00, 0, 16 }, /* #6 b */
    { 0x304052, 0x304853, 0x6a, 0x1a, 0, 7  }, /* #7 */
    { 0x0f3f87, 0x0f3f87, 0x6a, 0x5a, 0, 7  }, /* #7 b */
    { 0x327617, 0x327e17, 0x9e, 0xd9, 0, 14 }, /* #8 */
    { 0x0d09c2, 0x0d09c3, 0x9e, 0xc9, 0, 14 }, /* #8 b */
    { 0x2063c3, 0x206bc3, 0xb3, 0x67, 0, 1  }, /* #9 */
    { 0x1f1c16, 0x1f1c17, 0xb3, 0x66, 0, 1  }, /* #9 b */
    { 0x1c25d7, 0x1c25d6, 0x25, 0x59, 0, 31 }, /* #10 */
    { 0x235a02, 0x235202, 0x25, 0x51, 0, 31 }, /* #10 b */
    { 0x395142, 0x395142, 0x03, 0x06, 0, 19 }, /* #11 */
    { 0x062e97, 0x062696, 0x03, 0x07, 0, 19 }, /* #11 b */
    { 0x2a53d7, 0x2a5bd7, 0x55, 0x5a, 0, 31 }, /* #12 */
    { 0x152c02, 0x152c03, 0x55, 0x52, 0, 31 }, /* #12 b */
    { 0x135017, 0x135817, 0xa2, 0x45, 0, 10 }, /* #13 */
    { 0x2c2fc2, 0x2c2fc3, 0xa2, 0x44, 0, 10 }, /* #13 b */
    { 0x317f03, 0x317f02, 0x6c, 0xcb, 0, 22 }, /* #14 */
    { 0x0e00d6, 0x0e08d6, 0x6c, 0xc3, 0, 22 }, /* #14 b */
    { 0x034947, 0x034947, 0x5c, 0x72, 0, 20 }, /* #15 */
    { 0x3c3692, 0x3c3e93, 0x5c, 0x70, 0, 20 }, /* #15 b */
    { 0x191dc2, 0x191dc3, 0x97, 0x74, 0, 4  }, /* #16 */
    { 0x266217, 0x266a17, 0x97, 0x7c, 0, 4  }, /* #16 b */
    { 0x284e02, 0x284e03, 0xa9, 0x54, 0, 17 }, /* #17 */
    { 0x1731d7, 0x1739d7, 0xa9, 0xd4, 0, 17 }, /* #17 b */
    { 0x2c6607, 0x2c6e06, 0x42, 0x15, 0, 12 }, /* #18 */
    { 0x1319d2, 0x1319d2, 0x42, 0x11, 0, 12 }, /* #18 b */
    { 0x1a6606, 0x1a6e07, 0x9c, 0x38, 0, 1  }, /* #19 */
    { 0x2519d3, 0x2519d3, 0x9c, 0x39, 0, 1  }, /* #19 b */
    { 0x0a7f97, 0x0a7f97, 0x62, 0x62, 0, 9  }, /* #20 */
    { 0x350042, 0x350042, 0x62, 0x62, 0, 9  }, /* #20 b */
    { 0x372287, 0x372287, 0x35, 0x9a, 0, 8  }, /* #21 */
    { 0x085d52, 0x085553, 0x35, 0x1a, 0, 8  }, /* #21 b */
    { 0x3a7d47, 0x3a7546, 0x0c, 0x64, 0, 30 }, /* #22 */
    { 0x050292, 0x050292, 0x0c, 0x60, 0, 30 }, /* #22 b */
    { 0x0e38d6, 0x0e38d6, 0x97, 0x97, 0, 18 }, /* #23 */
    { 0x314703, 0x314703, 0x97, 0x97, 0, 18 }, /* #23 b */
    { 0x3c2717, 0x3c2717, 0xf2, 0x97, 0, 21 }, /* #24 */
    { 0x0358c2, 0x0350c3, 0xf2, 0x93, 0, 21 }, /* #24 b */
    { 0x0e1282, 0x0e1a82, 0x4c, 0x26, 0, 17 }, /* #25 */
    { 0x316d57, 0x316d56, 0x4c, 0xa6, 0, 17 }, /* #25 b */
    { 0x366f43, 0x366f43, 0x96, 0x65, 0, 25 }, /* #26 */
    { 0x091096, 0x091897, 0x96, 0x25, 0, 25 }, /* #26 b */
    { 0x314397, 0x314397, 0x0d, 0x86, 0, 26 }, /* #27 */
    { 0x0e3c42, 0x0e3443, 0x0d, 0x06, 0, 26 }, /* #27 b */
    { 0x285192, 0x285992, 0x94, 0x25, 0, 7  }, /* #28 */
    { 0x172e47, 0x172e46, 0x94, 0x65, 0, 7  }, /* #28 b */
    { 0x090b93, 0x090392, 0xf6, 0xdf, 0, 23 }, /* #29 */
    { 0x367446, 0x367446, 0xf6, 0xcf, 0, 23 }, /* #29 b */
    { 0x101a43, 0x101242, 0xc9, 0x4f, 0, 3  }, /* #30 */
    { 0x2f6596, 0x2f6596, 0xc9, 0x4b, 0, 3  }, /* #30 b */
    { 0x376987, 0x376987, 0x09, 0x09, 0, 0  }, /* #31 */
    { 0x081652, 0x081652, 0x09, 0x09, 0, 0  }, /* #31 b */
    { 0x250d13, 0x250d13, 0x7e, 0x5f, 0, 25 }, /* #32 */
    { 0x1a72c6, 0x1a7ac7, 0x7e, 0x1f, 0, 25 }, /* #32 b */
    { 0x2d0b07, 0x2d0b06, 0x49, 0x93, 0, 28 }, /* #33 */
    { 0x1274d2, 0x127cd2, 0x49, 0x92, 0, 28 }, /* #33 b */
    { 0x3d2ec2, 0x3d2ec3, 0xb6, 0xb2, 0, 3  }, /* #34 */
    { 0x025117, 0x025917, 0xb6, 0xb6, 0, 3  }, /* #34 b */
    { 0x276987, 0x276987, 0xba, 0x75, 0, 1  }, /* #35 */
    { 0x181652, 0x181e53, 0xba, 0x74, 0, 1  }, /* #35 b */
    { 0x3e3c86, 0x3e3486, 0x0a, 0x50, 0, 21 }, /* #36 */
    { 0x014353, 0x014352, 0x0a, 0x54, 0, 21 }, /* #36 b */
    { 0x034753, 0x034753, 0x04, 0x20, 0, 15 }, /* #37 */
    { 0x3c3886, 0x3c3087, 0x04, 0x00, 0, 15 }, /* #37 b */
    { 0x0140d2, 0x0140d3, 0xfd, 0xfa, 0, 10 }, /* #38 */
    { 0x3e3f07, 0x3e3707, 0xfd, 0xfb, 0, 10 }, /* #38 b */
    { 0x3b0183, 0x3b0182, 0x19, 0xc6, 0, 25 }, /* #39 */
    { 0x047e56, 0x047656, 0x19, 0x86, 0, 25 }, /* #39 b */
    { 0x181516, 0x181d16, 0x7e, 0xfc, 0, 1  }, /* #40 */
    { 0x276ac3, 0x276ac2, 0x7e, 0xfd, 0, 1  }, /* #40 b */
    { 0x323493, 0x323c92, 0x92, 0xb2, 0, 6  }, /* #41 */
    { 0x0d4b46, 0x0d4b46, 0x92, 0x92, 0, 6  }, /* #41 b */
    { 0x363c43, 0x363c43, 0xaf, 0xeb, 0, 7  }, /* #42 */
    { 0x094396, 0x094b97, 0xaf, 0xab, 0, 7  }, /* #42 b */
    { 0x247e13, 0x247612, 0x3e, 0xfa, 0, 29 }, /* #43 */
    { 0x1b01c6, 0x1b01c6, 0x3e, 0xf8, 0, 29 }, /* #43 b */
    { 0x134f52, 0x134f52, 0x5f, 0xf9, 0, 3  }, /* #44 */
    { 0x2c3087, 0x2c3886, 0x5f, 0xfd, 0, 3  }, /* #44 b */
    { 0x1b7057, 0x1b7057, 0x9a, 0x9a, 0, 0  }, /* #45 */
    { 0x240f82, 0x240f82, 0x9a, 0x9a, 0, 0  }, /* #45 b */
    { 0x397693, 0x397e93, 0x4e, 0x53, 0, 25 }, /* #46 */
    { 0x060946, 0x060947, 0x4e, 0x13, 0, 25 }, /* #46 b */
    { 0x2d4a92, 0x2d4a92, 0x0b, 0x0b, 0, 0  }, /* #47 */
    { 0x123547, 0x123547, 0x0b, 0x0b, 0, 0  }, /* #47 b */
    { 0x2e7416, 0x2e7417, 0x1d, 0x0e, 0, 26 }, /* #48 */
    { 0x110bc3, 0x1103c3, 0x1d, 0x8e, 0, 26 }, /* #48 b */
    { 0x0e7186, 0x0e7987, 0x5d, 0x4b, 0, 24 }, /* #49 */
    { 0x310e53, 0x310e53, 0x5d, 0x6b, 0, 24 }, /* #49 b */
    { 0x222a97, 0x222296, 0x3d, 0xcf, 0, 25 }, /* #50 */
    { 0x1d5542, 0x1d5542, 0x3d, 0x8f, 0, 25 }, /* #50 b */
    { 0x122b06, 0x122307, 0xf8, 0xe1, 0, 29 }, /* #51 */
    { 0x2d54d3, 0x2d54d3, 0xf8, 0xe3, 0, 29 }, /* #51 b */
    { 0x1d6296, 0x1d6297, 0xfc, 0xe3, 0, 12 }, /* #52 */
    { 0x221d43, 0x221543, 0xfc, 0xe7, 0, 12 }, /* #52 b */
    { 0x043f93, 0x043f92, 0x52, 0x95, 0, 3  }, /* #53 */
    { 0x3b4046, 0x3b4846, 0x52, 0x91, 0, 3  }, /* #53 b */
    { 0x1c4386, 0x1c4b87, 0x45, 0x22, 0, 26 }, /* #54 */
    { 0x233c53, 0x233c53, 0x45, 0xa2, 0, 26 }, /* #54 b */
    { 0x2137d6, 0x213fd7, 0x7a, 0xd1, 0, 3  }, /* #55 */
    { 0x1e4803, 0x1e4803, 0x7a, 0xd5, 0, 3  }, /* #55 b */
    { 0x3f3d03, 0x3f3d03, 0x62, 0x15, 0, 30 }, /* #56 */
    { 0x0042d6, 0x004ad7, 0x62, 0x11, 0, 30 }, /* #56 b */
    { 0x1e3bc2, 0x1e33c3, 0x0d, 0x41, 0, 15 }, /* #57 */
    { 0x214417, 0x214417, 0x0d, 0x61, 0, 15 }, /* #57 b */
    { 0x2b0946, 0x2b0147, 0xff, 0xef, 0, 14 }, /* #58 */
    { 0x147693, 0x147693, 0xff, 0xff, 0, 14 }, /* #58 b */
    { 0x275307, 0x275b07, 0x8b, 0xe2, 0, 25 }, /* #59 */
    { 0x182cd2, 0x182cd3, 0x8b, 0xa2, 0, 25 }, /* #59 b */
    { 0x017f17, 0x017716, 0x18, 0x8c, 0, 26 }, /* #60 */
    { 0x3e00c2, 0x3e00c2, 0x18, 0x0c, 0, 26 }, /* #60 b */
    { 0x0461c7, 0x0461c6, 0x01, 0x03, 0, 28 }, /* #61 */
    { 0x3b1e12, 0x3b1612, 0x01, 0x02, 0, 28 }, /* #61 b */
    { 0x301a96, 0x301a96, 0x46, 0x46, 0, 0  }, /* #62 */
    { 0x0f6543, 0x0f6543, 0x46, 0x46, 0, 0  }, /* #62 b */
    { 0x061fd7, 0x0617d6, 0x20, 0x82, 0, 2  }, /* #63 */
    { 0x396002, 0x396002, 0x20, 0x80, 0, 2  }, /* #63 b */
    { 0x2d1102, 0x2d1102, 0x06, 0x18, 0, 29 }, /* #64 */
    { 0x126ed7, 0x1266d6, 0x06, 0x1a, 0, 29 }, /* #64 b */
    { 0x325f86, 0x325f86, 0x44, 0x21, 0, 12 }, /* #65 */
    { 0x0d2053, 0x0d2852, 0x44, 0x25, 0, 12 }, /* #65 b */
    { 0x237a17, 0x237a16, 0x62, 0xc5, 0, 28 }, /* #66 */
    { 0x1c05c2, 0x1c0dc2, 0x62, 0xc4, 0, 28 }, /* #66 b */
    { 0x312296, 0x312297, 0x1b, 0x86, 0, 25 }, /* #67 */
    { 0x0e5d43, 0x0e5543, 0x1b, 0xc6, 0, 25 }, /* #67 b */
    { 0x3138d6, 0x3138d6, 0x8b, 0x8b, 0, 9  }, /* #68 */
    { 0x0e4703, 0x0e4703, 0x8b, 0x8b, 0, 9  }, /* #68 b */
    { 0x373287, 0x373286, 0x2b, 0xae, 0, 11 }, /* #69 */
    { 0x084d52, 0x084552, 0x2b, 0xac, 0, 11 }, /* #69 b */
    { 0x072913, 0x072113, 0x29, 0x4c, 0, 3  }, /* #70 */
    { 0x3856c6, 0x3856c7, 0x29, 0x48, 0, 3  }, /* #70 b */
    { 0x0c5693, 0x0c5693, 0x2f, 0xf2, 0, 5  }, /* #71 */
    { 0x332946, 0x332147, 0x2f, 0xe2, 0, 5  }, /* #71 b */
    { 0x1e0f53, 0x1e0f53, 0x95, 0x2b, 0, 28 }, /* #72 */
    { 0x217086, 0x217887, 0x95, 0x2a, 0, 28 }, /* #72 b */
    { 0x081b93, 0x081392, 0x00, 0x02, 0, 11 }, /* #73 */
    { 0x376446, 0x376446, 0x00, 0x00, 0, 11 }, /* #73 b */
    { 0x144746, 0x144f46, 0x8b, 0xd1, 0, 15 }, /* #74 */
    { 0x2b3893, 0x2b3892, 0x8b, 0xf1, 0, 15 }, /* #74 b */
    { 0x174607, 0x174607, 0x2e, 0xa5, 0, 15 }, /* #75 */
    { 0x2839d2, 0x2831d3, 0x2e, 0x85, 0, 15 }, /* #75 b */
    { 0x163956, 0x163957, 0x9e, 0x3c, 0, 1  }, /* #76 */
    { 0x294683, 0x294e83, 0x9e, 0x3d, 0, 1  }, /* #76 b */
    { 0x106056, 0x106056, 0x1d, 0x3a, 0, 10 }, /* #77 */
    { 0x2f1f83, 0x2f1782, 0x1d, 0x3b, 0, 10 }, /* #77 b */
    { 0x190b57, 0x190356, 0xc4, 0x27, 0, 30 }, /* #78 */
    { 0x267482, 0x267482, 0xc4, 0x23, 0, 30 }, /* #78 b */
    { 0x2b4ac2, 0x2b42c3, 0xe0, 0x81, 0, 29 }, /* #79 */
    { 0x143517, 0x143517, 0xe0, 0x83, 0, 29 }, /* #79 b */
    { 0x305886, 0x305087, 0x12, 0x20, 0, 13 }, /* #80 */
    { 0x0f2753, 0x0f2753, 0x12, 0x28, 0, 13 }, /* #80 b */
    { 0x1a5556, 0x1a5556, 0x15, 0xa8, 0, 21 }, /* #81 */
    { 0x252a83, 0x252282, 0x15, 0xac, 0, 21 }, /* #81 b */
    { 0x1d3113, 0x1d3112, 0x02, 0x14, 0, 12 }, /* #82 */
    { 0x224ec6, 0x2246c6, 0x02, 0x10, 0, 12 }, /* #82 b */
    { 0x3b4e02, 0x3b4e03, 0x62, 0x18, 0, 7  }, /* #83 */
    { 0x0431d7, 0x0439d7, 0x62, 0x58, 0, 7  }, /* #83 b */
    { 0x3b2d97, 0x3b2d97, 0x6e, 0x6e, 0, 0  }, /* #84 */
    { 0x045242, 0x045242, 0x6e, 0x6e, 0, 0  }, /* #84 b */
    { 0x0d4886, 0x0d4086, 0xda, 0xd3, 0, 3  }, /* #85 */
    { 0x323753, 0x323752, 0xda, 0xd7, 0, 3  }, /* #85 b */
    { 0x155f87, 0x155786, 0xcd, 0x6f, 0, 12 }, /* #86 */
    { 0x2a2052, 0x2a2052, 0xcd, 0x6b, 0, 12 }, /* #86 b */
    { 0x0d4693, 0x0d4693, 0xcb, 0xcb, 0, 9  }, /* #87 */
    { 0x323946, 0x323946, 0xcb, 0xcb, 0, 9  }, /* #87 b */
    { 0x243a02, 0x243a02, 0x54, 0xa8, 0, 1  }, /* #88 */
    { 0x1b45d7, 0x1b4dd6, 0x54, 0xa9, 0, 1  }, /* #88 b */
    { 0x296293, 0x296292, 0x30, 0x26, 0, 24 }, /* #89 */
    { 0x161d46, 0x161546, 0x30, 0x06, 0, 24 }, /* #89 b */
    { 0x0c70d7, 0x0c78d7, 0x98, 0x19, 0, 5  }, /* #90 */
    { 0x330f02, 0x330f03, 0x98, 0x09, 0, 5  }, /* #90 b */
    { 0x1c47c6, 0x1c4fc6, 0x7e, 0x3f, 0, 8  }, /* #91 */
    { 0x233813, 0x233812, 0x7e, 0xbf, 0, 8  }, /* #91 b */
    { 0x391246, 0x391246, 0xd8, 0xc3, 0, 21 }, /* #92 */
    { 0x066d93, 0x066592, 0xd8, 0xc7, 0, 21 }, /* #92 b */
    { 0x2a7b86, 0x2a7b86, 0x46, 0x62, 0, 13 }, /* #93 */
    { 0x150453, 0x150c52, 0x46, 0x6a, 0, 13 }, /* #93 b */
    { 0x094e53, 0x094653, 0xe7, 0xf3, 0, 17 }, /* #94 */
    { 0x363186, 0x363187, 0xe7, 0x73, 0, 17 }, /* #94 b */
    { 0x3e4e13, 0x3e4e12, 0x8d, 0xe3, 0, 25 }, /* #95 */
    { 0x0131c6, 0x0139c6, 0x8d, 0xa3, 0, 25 }, /* #95 b */
};
uint32_t const g_cTests_rcl_u8_intel = RT_ELEMENTS(g_aTests_rcl_u8_intel);

BINU8_TEST_T const g_aTests_rcr_u8_intel[] =
{
    { 0x060f92, 0x060792, 0x00, 0x00, 0, 6  }, /* #0 */
    { 0x397047, 0x397846, 0x00, 0x04, 0, 6  }, /* #0 b */
    { 0x135352, 0x135352, 0x00, 0x00, 0, 29 }, /* #1 */
    { 0x2c2c87, 0x2c2c86, 0x00, 0x40, 0, 29 }, /* #1 b */
    { 0x341983, 0x341982, 0x00, 0x10, 0, 13 }, /* #2 */
    { 0x0b6656, 0x0b6656, 0x00, 0x00, 0, 13 }, /* #2 b */
    { 0x183157, 0x183956, 0x00, 0x04, 0, 24 }, /* #3 */
    { 0x274e82, 0x274682, 0x00, 0x00, 0, 24 }, /* #3 b */
    { 0x0642c7, 0x064ac6, 0x00, 0x02, 0, 16 }, /* #4 */
    { 0x393d12, 0x393512, 0x00, 0x00, 0, 16 }, /* #4 b */
    { 0x162b12, 0x162312, 0x00, 0x00, 0, 7  }, /* #5 */
    { 0x2954c7, 0x295cc6, 0x00, 0x02, 0, 7  }, /* #5 b */
    { 0x1c3bd2, 0x1c3bd2, 0x6f, 0x6f, 0, 27 }, /* #6 */
    { 0x234407, 0x234407, 0x6f, 0x6f, 0, 27 }, /* #6 b */
    { 0x0663d7, 0x0663d6, 0xa9, 0x75, 0, 12 }, /* #7 */
    { 0x391c02, 0x391c02, 0xa9, 0x55, 0, 12 }, /* #7 b */
    { 0x326646, 0x326e47, 0xb6, 0x2d, 0, 29 }, /* #8 */
    { 0x0d1993, 0x0d1193, 0xb6, 0x6d, 0, 29 }, /* #8 b */
    { 0x3e3696, 0x3e3697, 0x16, 0x60, 0, 5  }, /* #9 */
    { 0x014943, 0x014943, 0x16, 0x68, 0, 5  }, /* #9 b */
    { 0x274e57, 0x274657, 0x9b, 0xbc, 0, 23 }, /* #10 */
    { 0x183182, 0x183983, 0x9b, 0xb4, 0, 23 }, /* #10 b */
    { 0x2a1c12, 0x2a1412, 0x28, 0x05, 0, 21 }, /* #11 */
    { 0x1563c7, 0x156bc6, 0x28, 0x25, 0, 21 }, /* #11 b */
    { 0x2a0b92, 0x2a0b92, 0xae, 0xe5, 0, 14 }, /* #12 */
    { 0x157447, 0x157446, 0xae, 0xed, 0, 14 }, /* #12 b */
    { 0x1c2806, 0x1c2006, 0x68, 0x1a, 0, 2  }, /* #13 */
    { 0x2357d3, 0x235fd2, 0x68, 0x5a, 0, 2  }, /* #13 b */
    { 0x372156, 0x372957, 0xe2, 0x89, 0, 25 }, /* #14 */
    { 0x085e83, 0x085683, 0xe2, 0x8b, 0, 25 }, /* #14 b */
    { 0x2a4e47, 0x2a4e47, 0x5d, 0xda, 0, 14 }, /* #15 */
    { 0x153192, 0x153193, 0x5d, 0xd2, 0, 14 }, /* #15 b */
    { 0x0e3756, 0x0e3756, 0x22, 0x22, 0, 27 }, /* #16 */
    { 0x314883, 0x314883, 0x22, 0x22, 0, 27 }, /* #16 b */
    { 0x0f0bd7, 0x0f03d6, 0xa0, 0xd0, 0, 19 }, /* #17 */
    { 0x307402, 0x307c02, 0xa0, 0x50, 0, 19 }, /* #17 b */
    { 0x3b42c6, 0x3b42c6, 0x2b, 0xc5, 0, 12 }, /* #18 */
    { 0x043d13, 0x043d12, 0x2b, 0xe5, 0, 12 }, /* #18 b */
    { 0x231683, 0x231683, 0x9c, 0xcc, 0, 5  }, /* #19 */
    { 0x1c6956, 0x1c6957, 0x9c, 0xc4, 0, 5  }, /* #19 b */
    { 0x145147, 0x145947, 0x34, 0x49, 0, 5  }, /* #20 */
    { 0x2b2e92, 0x2b2693, 0x34, 0x41, 0, 5  }, /* #20 b */
    { 0x0128c7, 0x0120c7, 0xe1, 0xf0, 0, 28 }, /* #21 */
    { 0x3e5712, 0x3e5f13, 0xe1, 0x70, 0, 28 }, /* #21 b */
    { 0x054cd3, 0x054cd3, 0x17, 0x78, 0, 5  }, /* #22 */
    { 0x3a3306, 0x3a3307, 0x17, 0x70, 0, 5  }, /* #22 b */
    { 0x166757, 0x166757, 0xd2, 0x74, 0, 2  }, /* #23 */
    { 0x291882, 0x291883, 0xd2, 0x34, 0, 2  }, /* #23 b */
    { 0x2c4cc3, 0x2c4cc2, 0x4a, 0xa9, 0, 12 }, /* #24 */
    { 0x133316, 0x133316, 0x4a, 0x89, 0, 12 }, /* #24 b */
    { 0x300b57, 0x300357, 0xb9, 0xce, 0, 24 }, /* #25 */
    { 0x0f7482, 0x0f7c83, 0xb9, 0xca, 0, 24 }, /* #25 b */
    { 0x2e2397, 0x2e2397, 0x29, 0x29, 0, 9  }, /* #26 */
    { 0x115c42, 0x115c42, 0x29, 0x29, 0, 9  }, /* #26 b */
    { 0x354052, 0x354052, 0x51, 0x94, 0, 11 }, /* #27 */
    { 0x0a3f87, 0x0a3f86, 0x51, 0xd4, 0, 11 }, /* #27 b */
    { 0x3c7482, 0x3c7482, 0x52, 0x52, 0, 27 }, /* #28 */
    { 0x030b57, 0x030b57, 0x52, 0x52, 0, 27 }, /* #28 b */
    { 0x076002, 0x076002, 0x7d, 0x7d, 0, 0  }, /* #29 */
    { 0x381fd7, 0x381fd7, 0x7d, 0x7d, 0, 0  }, /* #29 b */
    { 0x1e3447, 0x1e3447, 0xae, 0x6b, 0, 2  }, /* #30 */
    { 0x214b92, 0x214b93, 0xae, 0x2b, 0, 2  }, /* #30 b */
    { 0x0800c7, 0x0808c7, 0x7b, 0x77, 0, 4  }, /* #31 */
    { 0x377f12, 0x377713, 0x7b, 0x67, 0, 4  }, /* #31 b */
    { 0x2c36d7, 0x2c3ed7, 0x20, 0x04, 0, 6  }, /* #32 */
    { 0x134902, 0x134103, 0x20, 0x00, 0, 6  }, /* #32 b */
    { 0x2b5683, 0x2b5683, 0xf4, 0x4f, 0, 23 }, /* #33 */
    { 0x142956, 0x142957, 0xf4, 0x47, 0, 23 }, /* #33 b */
    { 0x001446, 0x001446, 0x3c, 0x0f, 0, 2  }, /* #34 */
    { 0x3f6b93, 0x3f6b92, 0x3c, 0x4f, 0, 2  }, /* #34 b */
    { 0x0c6157, 0x0c6957, 0x67, 0xb3, 0, 10 }, /* #35 */
    { 0x331e82, 0x331683, 0x67, 0x33, 0, 10 }, /* #35 b */
    { 0x1418c7, 0x1410c6, 0xb6, 0xdb, 0, 7  }, /* #36 */
    { 0x2b6712, 0x2b6f12, 0xb6, 0xd9, 0, 7  }, /* #36 b */
    { 0x390e87, 0x390686, 0x84, 0x26, 0, 15 }, /* #37 */
    { 0x067152, 0x067952, 0x84, 0x22, 0, 15 }, /* #37 b */
    { 0x3b0b03, 0x3b0303, 0xb6, 0x6d, 0, 23 }, /* #38 */
    { 0x0474d6, 0x047cd7, 0xb6, 0x65, 0, 23 }, /* #38 b */
    { 0x327413, 0x327413, 0xbd, 0x7b, 0, 8  }, /* #39 */
    { 0x0d0bc6, 0x0d0bc7, 0xbd, 0x7a, 0, 8  }, /* #39 b */
    { 0x0665d6, 0x0665d6, 0x0d, 0x34, 0, 16 }, /* #40 */
    { 0x391a03, 0x391a02, 0x0d, 0x36, 0, 16 }, /* #40 b */
    { 0x186ec2, 0x186ec2, 0x77, 0x77, 0, 9  }, /* #41 */
    { 0x271117, 0x271117, 0x77, 0x77, 0, 9  }, /* #41 b */
    { 0x165cd7, 0x165cd7, 0xbb, 0xbb, 0, 9  }, /* #42 */
    { 0x292302, 0x292302, 0xbb, 0xbb, 0, 9  }, /* #42 b */
    { 0x307b96, 0x307396, 0x72, 0x8e, 0, 3  }, /* #43 */
    { 0x0f0443, 0x0f0c42, 0x72, 0xae, 0, 3  }, /* #43 b */
    { 0x0b4e52, 0x0b4653, 0x5f, 0x97, 0, 2  }, /* #44 */
    { 0x343187, 0x343987, 0x5f, 0xd7, 0, 2  }, /* #44 b */
    { 0x1b7d82, 0x1b7d82, 0xe0, 0x1c, 0, 30 }, /* #45 */
    { 0x240257, 0x240256, 0xe0, 0x3c, 0, 30 }, /* #45 b */
    { 0x2c14d2, 0x2c1cd2, 0xb9, 0xae, 0, 29 }, /* #46 */
    { 0x136b07, 0x136306, 0xb9, 0xee, 0, 29 }, /* #46 b */
    { 0x2e5486, 0x2e5486, 0x1e, 0x1e, 0, 27 }, /* #47 */
    { 0x112b53, 0x112b53, 0x1e, 0x1e, 0, 27 }, /* #47 b */
    { 0x2c3b52, 0x2c3b52, 0x8a, 0xa4, 0, 23 }, /* #48 */
    { 0x134487, 0x134486, 0x8a, 0xac, 0, 23 }, /* #48 b */
    { 0x054a17, 0x054216, 0x85, 0x2e, 0, 24 }, /* #49 */
    { 0x3a35c2, 0x3a3dc2, 0x85, 0x2a, 0, 24 }, /* #49 b */
    { 0x3c0347, 0x3c0347, 0x8c, 0x31, 0, 3  }, /* #50 */
    { 0x037c92, 0x037c93, 0x8c, 0x11, 0, 3  }, /* #50 b */
    { 0x1d1c93, 0x1d1493, 0xb3, 0x3d, 0, 5  }, /* #51 */
    { 0x226346, 0x226b47, 0xb3, 0x35, 0, 5  }, /* #51 b */
    { 0x2a7ed6, 0x2a7ed6, 0x97, 0x97, 0, 0  }, /* #52 */
    { 0x150103, 0x150103, 0x97, 0x97, 0, 0  }, /* #52 b */
    { 0x2b57d3, 0x2b57d2, 0xfd, 0xff, 0, 20 }, /* #53 */
    { 0x142806, 0x142806, 0xfd, 0xbf, 0, 20 }, /* #53 b */
    { 0x3f3ed7, 0x3f3ed7, 0x1a, 0xa8, 0, 5  }, /* #54 */
    { 0x004102, 0x004103, 0x1a, 0xa0, 0, 5  }, /* #54 b */
    { 0x1b69d7, 0x1b69d7, 0x42, 0x50, 0, 20 }, /* #55 */
    { 0x241602, 0x241603, 0x42, 0x10, 0, 20 }, /* #55 b */
    { 0x346ed2, 0x3466d3, 0x6b, 0x66, 0, 4  }, /* #56 */
    { 0x0b1107, 0x0b1907, 0x6b, 0x76, 0, 4  }, /* #56 b */
    { 0x380d56, 0x380557, 0x6e, 0x1b, 0, 11 }, /* #57 */
    { 0x077283, 0x077a83, 0x6e, 0x5b, 0, 11 }, /* #57 b */
    { 0x0b0e53, 0x0b0e53, 0x39, 0x39, 0, 0  }, /* #58 */
    { 0x347186, 0x347186, 0x39, 0x39, 0, 0  }, /* #58 b */
    { 0x113342, 0x113342, 0x6e, 0x6e, 0, 9  }, /* #59 */
    { 0x2e4c97, 0x2e4c97, 0x6e, 0x6e, 0, 9  }, /* #59 b */
    { 0x225643, 0x225e42, 0x3c, 0x4f, 0, 11 }, /* #60 */
    { 0x1d2996, 0x1d2196, 0x3c, 0x0f, 0, 11 }, /* #60 b */
    { 0x2c5c02, 0x2c5402, 0x02, 0x20, 0, 5  }, /* #61 */
    { 0x1323d7, 0x132bd6, 0x02, 0x28, 0, 5  }, /* #61 b */
    { 0x1b4b46, 0x1b4346, 0x11, 0x84, 0, 11 }, /* #62 */
    { 0x243493, 0x243c92, 0x11, 0xc4, 0, 11 }, /* #62 b */
    { 0x3b3fc6, 0x3b3fc7, 0xfc, 0xc7, 0, 23 }, /* #63 */
    { 0x044013, 0x044013, 0xfc, 0xcf, 0, 23 }, /* #63 b */
    { 0x2d2206, 0x2d2a07, 0x93, 0x26, 0, 8  }, /* #64 */
    { 0x125dd3, 0x1255d3, 0x93, 0x27, 0, 8  }, /* #64 b */
    { 0x085c97, 0x085497, 0xdd, 0xbd, 0, 31 }, /* #65 */
    { 0x372342, 0x372b43, 0xdd, 0xad, 0, 31 }, /* #65 b */
    { 0x066012, 0x066013, 0x2c, 0x82, 0, 31 }, /* #66 */
    { 0x391fc7, 0x391fc7, 0x2c, 0x92, 0, 31 }, /* #66 b */
    { 0x076902, 0x076902, 0xb1, 0xac, 0, 11 }, /* #67 */
    { 0x3816d7, 0x3816d6, 0xb1, 0xec, 0, 11 }, /* #67 b */
    { 0x345c46, 0x345446, 0x71, 0x9c, 0, 2  }, /* #68 */
    { 0x0b2393, 0x0b2b92, 0x71, 0xdc, 0, 2  }, /* #68 b */
    { 0x002b02, 0x002303, 0x1a, 0x41, 0, 31 }, /* #69 */
    { 0x3f54d7, 0x3f5cd7, 0x1a, 0x51, 0, 31 }, /* #69 b */
    { 0x1a1786, 0x1a1787, 0x33, 0x31, 0, 5  }, /* #70 */
    { 0x256853, 0x256853, 0x33, 0x39, 0, 5  }, /* #70 b */
    { 0x264102, 0x264903, 0xce, 0x33, 0, 11 }, /* #71 */
    { 0x193ed7, 0x1936d7, 0xce, 0x73, 0, 11 }, /* #71 b */
    { 0x3d7382, 0x3d7382, 0x30, 0x18, 0, 1  }, /* #72 */
    { 0x020c57, 0x020c56, 0x30, 0x98, 0, 1  }, /* #72 b */
    { 0x254a57, 0x254257, 0x96, 0x2d, 0, 26 }, /* #73 */
    { 0x1a3582, 0x1a3d83, 0x96, 0x2c, 0, 26 }, /* #73 b */
    { 0x0e4417, 0x0e4417, 0x8f, 0xe3, 0, 20 }, /* #74 */
    { 0x313bc2, 0x313bc3, 0x8f, 0xa3, 0, 20 }, /* #74 b */
    { 0x305a46, 0x305247, 0x12, 0x04, 0, 2  }, /* #75 */
    { 0x0f2593, 0x0f2d93, 0x12, 0x44, 0, 2  }, /* #75 b */
    { 0x234fc3, 0x2347c3, 0xac, 0x35, 0, 3  }, /* #76 */
    { 0x1c3016, 0x1c3817, 0xac, 0x15, 0, 3  }, /* #76 b */
    { 0x244813, 0x244812, 0x79, 0x6f, 0, 12 }, /* #77 */
    { 0x1b37c6, 0x1b37c6, 0x79, 0x4f, 0, 12 }, /* #77 b */
    { 0x006046, 0x006847, 0xaf, 0xd5, 0, 12 }, /* #78 */
    { 0x3f1f93, 0x3f1793, 0xaf, 0xf5, 0, 12 }, /* #78 b */
    { 0x123c82, 0x123483, 0x4f, 0xc9, 0, 30 }, /* #79 */
    { 0x2d4357, 0x2d4b57, 0x4f, 0xe9, 0, 30 }, /* #79 b */
    { 0x351c02, 0x351c03, 0xf9, 0xf2, 0, 26 }, /* #80 */
    { 0x0a63d7, 0x0a63d7, 0xf9, 0xf3, 0, 26 }, /* #80 b */
    { 0x3d1987, 0x3d1987, 0x3b, 0x3b, 0, 18 }, /* #81 */
    { 0x026652, 0x026652, 0x3b, 0x3b, 0, 18 }, /* #81 b */
    { 0x322686, 0x322686, 0x14, 0xa0, 0, 24 }, /* #82 */
    { 0x0d5953, 0x0d5952, 0x14, 0xa4, 0, 24 }, /* #82 b */
    { 0x2e3e16, 0x2e3616, 0x54, 0x85, 0, 22 }, /* #83 */
    { 0x1141c3, 0x1149c2, 0x54, 0x95, 0, 22 }, /* #83 b */
    { 0x373653, 0x373e52, 0x09, 0x61, 0, 3  }, /* #84 */
    { 0x084986, 0x084186, 0x09, 0x41, 0, 3  }, /* #84 b */
    { 0x3457d2, 0x345fd2, 0xc4, 0x8c, 0, 4  }, /* #85 */
    { 0x0b2807, 0x0b2006, 0xc4, 0x9c, 0, 4  }, /* #85 b */
    { 0x234283, 0x234a82, 0x1d, 0x76, 0, 16 }, /* #86 */
    { 0x1c3d56, 0x1c3556, 0x1d, 0x74, 0, 16 }, /* #86 b */
    { 0x034fd6, 0x034fd7, 0xda, 0xb4, 0, 26 }, /* #87 */
    { 0x3c3003, 0x3c3003, 0xda, 0xb5, 0, 26 }, /* #87 b */
    { 0x2a5956, 0x2a5957, 0xd6, 0xac, 0, 8  }, /* #88 */
    { 0x152683, 0x152683, 0xd6, 0xad, 0, 8  }, /* #88 b */
    { 0x205492, 0x205492, 0x14, 0x28, 0, 8  }, /* #89 */
    { 0x1f2b47, 0x1f2b46, 0x14, 0x29, 0, 8  }, /* #89 b */
    { 0x141713, 0x141f12, 0x0e, 0x1d, 0, 8  }, /* #90 */
    { 0x2b68c6, 0x2b60c6, 0x0e, 0x1c, 0, 8  }, /* #90 b */
    { 0x294013, 0x294813, 0x47, 0xe8, 0, 21 }, /* #91 */
    { 0x163fc6, 0x1637c7, 0x47, 0xc8, 0, 21 }, /* #91 b */
    { 0x364c82, 0x364483, 0x27, 0x13, 0, 19 }, /* #92 */
    { 0x093357, 0x093b57, 0x27, 0x93, 0, 19 }, /* #92 b */
    { 0x3902d6, 0x3902d6, 0x66, 0x33, 0, 19 }, /* #93 */
    { 0x067d03, 0x067d02, 0x66, 0xb3, 0, 19 }, /* #93 b */
    { 0x3804c6, 0x3804c6, 0x49, 0x92, 0, 17 }, /* #94 */
    { 0x077b13, 0x077b12, 0x49, 0x93, 0, 17 }, /* #94 b */
    { 0x277d93, 0x277592, 0x94, 0x65, 0, 11 }, /* #95 */
    { 0x180246, 0x180a46, 0x94, 0x25, 0, 11 }, /* #95 b */
};
uint32_t const g_cTests_rcr_u8_intel = RT_ELEMENTS(g_aTests_rcr_u8_intel);

BINU8_TEST_T const g_aTests_shl_u8_intel[] =
{
    { 0x364882, 0x364046, 0x00, 0x00, 0, 3  }, /* #0 */
    { 0x093757, 0x093746, 0x00, 0x00, 0, 3  }, /* #0 b */
    { 0x197296, 0x197246, 0x00, 0x00, 0, 16 }, /* #1 */
    { 0x260d43, 0x260546, 0x00, 0x00, 0, 16 }, /* #1 b */
    { 0x096d12, 0x096546, 0x00, 0x00, 0, 10 }, /* #2 */
    { 0x3612c7, 0x361246, 0x00, 0x00, 0, 10 }, /* #2 b */
    { 0x2f5592, 0x2f5546, 0x00, 0x00, 0, 8  }, /* #3 */
    { 0x102a47, 0x102246, 0x00, 0x00, 0, 8  }, /* #3 b */
    { 0x312a12, 0x312246, 0x00, 0x00, 0, 12 }, /* #4 */
    { 0x0e55c7, 0x0e5546, 0x00, 0x00, 0, 12 }, /* #4 b */
    { 0x2f3f46, 0x2f3746, 0x00, 0x00, 0, 1  }, /* #5 */
    { 0x104093, 0x104046, 0x00, 0x00, 0, 1  }, /* #5 b */
    { 0x3a4342, 0x3a4382, 0xee, 0xe0, 0, 4  }, /* #6 */
    { 0x053c97, 0x053482, 0xee, 0xe0, 0, 4  }, /* #6 b */
    { 0x074ac2, 0x074246, 0x32, 0x00, 0, 31 }, /* #7 */
    { 0x383517, 0x383546, 0x32, 0x00, 0, 31 }, /* #7 b */
    { 0x005687, 0x005646, 0xf1, 0x00, 0, 18 }, /* #8 */
    { 0x3f2952, 0x3f2146, 0xf1, 0x00, 0, 18 }, /* #8 b */
    { 0x235cd2, 0x235482, 0xc1, 0x80, 0, 7  }, /* #9 */
    { 0x1c2307, 0x1c2382, 0xc1, 0x80, 0, 7  }, /* #9 b */
    { 0x053313, 0x053b46, 0x44, 0x00, 0, 25 }, /* #10 */
    { 0x3a4cc6, 0x3a4c46, 0x44, 0x00, 0, 25 }, /* #10 b */
    { 0x2554d6, 0x255c46, 0xa2, 0x00, 0, 11 }, /* #11 */
    { 0x1a2b03, 0x1a2b46, 0xa2, 0x00, 0, 11 }, /* #11 b */
    { 0x371142, 0x371946, 0x88, 0x00, 0, 9  }, /* #12 */
    { 0x086e97, 0x086e46, 0x88, 0x00, 0, 9  }, /* #12 b */
    { 0x040b57, 0x040383, 0xd3, 0x80, 0, 7  }, /* #13 */
    { 0x3b7482, 0x3b7483, 0xd3, 0x80, 0, 7  }, /* #13 b */
    { 0x2e2b16, 0x2e2b46, 0xbc, 0x00, 0, 16 }, /* #14 */
    { 0x1154c3, 0x115c46, 0xbc, 0x00, 0, 16 }, /* #14 b */
    { 0x053912, 0x053146, 0x0a, 0x00, 0, 24 }, /* #15 */
    { 0x3a46c7, 0x3a4646, 0x0a, 0x00, 0, 24 }, /* #15 b */
    { 0x085e87, 0x085e46, 0xaf, 0x00, 0, 16 }, /* #16 */
    { 0x372152, 0x372946, 0xaf, 0x00, 0, 16 }, /* #16 b */
    { 0x076c86, 0x076483, 0xf3, 0x98, 0, 3  }, /* #17 */
    { 0x381353, 0x381383, 0xf3, 0x98, 0, 3  }, /* #17 b */
    { 0x303c17, 0x303446, 0x28, 0x00, 0, 8  }, /* #18 */
    { 0x0f43c2, 0x0f4346, 0x28, 0x00, 0, 8  }, /* #18 b */
    { 0x367e83, 0x367e46, 0x9c, 0x00, 0, 25 }, /* #19 */
    { 0x090156, 0x090946, 0x9c, 0x00, 0, 25 }, /* #19 b */
    { 0x346947, 0x346186, 0x0c, 0xc0, 0, 4  }, /* #20 */
    { 0x0b1692, 0x0b1686, 0x0c, 0xc0, 0, 4  }, /* #20 b */
    { 0x032486, 0x032c46, 0x58, 0x00, 0, 30 }, /* #21 */
    { 0x3c5b53, 0x3c5b46, 0x58, 0x00, 0, 30 }, /* #21 b */
    { 0x1b25c6, 0x1b2d46, 0xa6, 0x00, 0, 29 }, /* #22 */
    { 0x245a13, 0x245a46, 0xa6, 0x00, 0, 29 }, /* #22 b */
    { 0x347b52, 0x347b46, 0x80, 0x00, 0, 18 }, /* #23 */
    { 0x0b0487, 0x0b0c46, 0x80, 0x00, 0, 18 }, /* #23 b */
    { 0x177b42, 0x177346, 0xe8, 0x00, 0, 31 }, /* #24 */
    { 0x280497, 0x280446, 0xe8, 0x00, 0, 31 }, /* #24 b */
    { 0x2d0dd3, 0x2d0d46, 0xb9, 0x00, 0, 12 }, /* #25 */
    { 0x127206, 0x127a46, 0xb9, 0x00, 0, 12 }, /* #25 b */
    { 0x254697, 0x254e82, 0x52, 0xa4, 0, 1  }, /* #26 */
    { 0x1a3942, 0x1a3982, 0x52, 0xa4, 0, 1  }, /* #26 b */
    { 0x0159d6, 0x015946, 0x56, 0x00, 0, 11 }, /* #27 */
    { 0x3e2603, 0x3e2e46, 0x56, 0x00, 0, 11 }, /* #27 b */
    { 0x1b07d6, 0x1b0706, 0x1d, 0x74, 0, 2  }, /* #28 */
    { 0x247803, 0x247006, 0x1d, 0x74, 0, 2  }, /* #28 b */
    { 0x001996, 0x001146, 0x39, 0x00, 0, 27 }, /* #29 */
    { 0x3f6643, 0x3f6646, 0x39, 0x00, 0, 27 }, /* #29 b */
    { 0x081ed7, 0x081e46, 0x98, 0x00, 0, 19 }, /* #30 */
    { 0x376102, 0x376946, 0x98, 0x00, 0, 19 }, /* #30 b */
    { 0x033a97, 0x033a46, 0x5e, 0x00, 0, 26 }, /* #31 */
    { 0x3c4542, 0x3c4d46, 0x5e, 0x00, 0, 26 }, /* #31 b */
    { 0x2e6e86, 0x2e6646, 0x19, 0x00, 0, 24 }, /* #32 */
    { 0x111153, 0x111146, 0x19, 0x00, 0, 24 }, /* #32 b */
    { 0x0661c6, 0x066182, 0xd5, 0x80, 0, 7  }, /* #33 */
    { 0x391e13, 0x391682, 0xd5, 0x80, 0, 7  }, /* #33 b */
    { 0x1b4352, 0x1b4346, 0x25, 0x00, 0, 17 }, /* #34 */
    { 0x243c87, 0x243446, 0x25, 0x00, 0, 17 }, /* #34 b */
    { 0x347103, 0x347146, 0x28, 0x00, 0, 21 }, /* #35 */
    { 0x0b0ed6, 0x0b0646, 0x28, 0x00, 0, 21 }, /* #35 b */
    { 0x164e42, 0x164e46, 0x93, 0x00, 0, 16 }, /* #36 */
    { 0x293197, 0x293946, 0x93, 0x00, 0, 16 }, /* #36 b */
    { 0x180052, 0x180846, 0x7d, 0x00, 0, 15 }, /* #37 */
    { 0x277f87, 0x277f46, 0x7d, 0x00, 0, 15 }, /* #37 b */
    { 0x165257, 0x165247, 0xea, 0x00, 0, 7  }, /* #38 */
    { 0x292d82, 0x292547, 0xea, 0x00, 0, 7  }, /* #38 b */
    { 0x131602, 0x131e46, 0x74, 0x00, 0, 27 }, /* #39 */
    { 0x2c69d7, 0x2c6946, 0x74, 0x00, 0, 27 }, /* #39 b */
    { 0x0543c2, 0x054347, 0xf5, 0x00, 0, 8  }, /* #40 */
    { 0x3a3c17, 0x3a3447, 0xf5, 0x00, 0, 8  }, /* #40 b */
    { 0x0d5b97, 0x0d5b46, 0xb0, 0x00, 0, 18 }, /* #41 */
    { 0x322442, 0x322c46, 0xb0, 0x00, 0, 18 }, /* #41 b */
    { 0x2a4197, 0x2a4146, 0xf9, 0x00, 0, 10 }, /* #42 */
    { 0x153e42, 0x153646, 0xf9, 0x00, 0, 10 }, /* #42 b */
    { 0x323412, 0x323446, 0xc6, 0x00, 0, 9  }, /* #43 */
    { 0x0d4bc7, 0x0d4346, 0xc6, 0x00, 0, 9  }, /* #43 b */
    { 0x344016, 0x344883, 0x8f, 0x80, 0, 7  }, /* #44 */
    { 0x0b3fc3, 0x0b3f83, 0x8f, 0x80, 0, 7  }, /* #44 b */
    { 0x061083, 0x061807, 0xb0, 0x60, 0, 1  }, /* #45 */
    { 0x396f56, 0x396f07, 0xb0, 0x60, 0, 1  }, /* #45 b */
    { 0x2f4357, 0x2f4303, 0xf7, 0x70, 0, 4  }, /* #46 */
    { 0x103c82, 0x103403, 0xf7, 0x70, 0, 4  }, /* #46 b */
    { 0x3b1786, 0x3b1746, 0x13, 0x00, 0, 9  }, /* #47 */
    { 0x046853, 0x046046, 0x13, 0x00, 0, 9  }, /* #47 b */
    { 0x3e5453, 0x3e5c46, 0x8a, 0x00, 0, 10 }, /* #48 */
    { 0x012b86, 0x012b46, 0x8a, 0x00, 0, 10 }, /* #48 b */
    { 0x2a29c6, 0x2a2946, 0x88, 0x00, 0, 25 }, /* #49 */
    { 0x155613, 0x155e46, 0x88, 0x00, 0, 25 }, /* #49 b */
    { 0x3a3513, 0x3a3546, 0xe0, 0x00, 0, 25 }, /* #50 */
    { 0x054ac6, 0x054246, 0xe0, 0x00, 0, 25 }, /* #50 b */
    { 0x213a02, 0x213246, 0x28, 0x00, 0, 15 }, /* #51 */
    { 0x1e45d7, 0x1e4546, 0x28, 0x00, 0, 15 }, /* #51 b */
    { 0x3d7a87, 0x3d7202, 0x34, 0x68, 0, 1  }, /* #52 */
    { 0x020552, 0x020502, 0x34, 0x68, 0, 1  }, /* #52 b */
    { 0x074c42, 0x074c42, 0x59, 0x59, 0, 0  }, /* #53 */
    { 0x383397, 0x383397, 0x59, 0x59, 0, 0  }, /* #53 b */
    { 0x1b1016, 0x1b1046, 0x21, 0x00, 0, 14 }, /* #54 */
    { 0x246fc3, 0x246746, 0x21, 0x00, 0, 14 }, /* #54 b */
    { 0x254b42, 0x254347, 0xc6, 0x00, 0, 7  }, /* #55 */
    { 0x1a3497, 0x1a3447, 0xc6, 0x00, 0, 7  }, /* #55 b */
    { 0x086752, 0x086f46, 0x93, 0x00, 0, 14 }, /* #56 */
    { 0x371887, 0x371846, 0x93, 0x00, 0, 14 }, /* #56 b */
    { 0x014896, 0x014046, 0xe0, 0x00, 0, 19 }, /* #57 */
    { 0x3e3743, 0x3e3746, 0xe0, 0x00, 0, 19 }, /* #57 b */
    { 0x226982, 0x226146, 0x2c, 0x00, 0, 25 }, /* #58 */
    { 0x1d1657, 0x1d1646, 0x2c, 0x00, 0, 25 }, /* #58 b */
    { 0x221383, 0x221346, 0xf5, 0x00, 0, 12 }, /* #59 */
    { 0x1d6c56, 0x1d6446, 0xf5, 0x00, 0, 12 }, /* #59 b */
    { 0x047fc6, 0x047fc6, 0x3a, 0x3a, 0, 0  }, /* #60 */
    { 0x3b0013, 0x3b0013, 0x3a, 0x3a, 0, 0  }, /* #60 b */
    { 0x150857, 0x150882, 0x64, 0x80, 0, 5  }, /* #61 */
    { 0x2a7782, 0x2a7f82, 0x64, 0x80, 0, 5  }, /* #61 b */
    { 0x022a56, 0x022246, 0x1c, 0x00, 0, 19 }, /* #62 */
    { 0x3d5583, 0x3d5546, 0x1c, 0x00, 0, 19 }, /* #62 b */
    { 0x362982, 0x362946, 0x82, 0x00, 0, 29 }, /* #63 */
    { 0x095657, 0x095e46, 0x82, 0x00, 0, 29 }, /* #63 b */
    { 0x361482, 0x361402, 0x0d, 0x34, 0, 2  }, /* #64 */
    { 0x096b57, 0x096302, 0x0d, 0x34, 0, 2  }, /* #64 b */
    { 0x176217, 0x176246, 0xcb, 0x00, 0, 9  }, /* #65 */
    { 0x281dc2, 0x281546, 0xcb, 0x00, 0, 9  }, /* #65 b */
    { 0x0e39c3, 0x0e3903, 0xba, 0x40, 0, 5  }, /* #66 */
    { 0x314616, 0x314e03, 0xba, 0x40, 0, 5  }, /* #66 b */
    { 0x240342, 0x240346, 0x26, 0x00, 0, 26 }, /* #67 */
    { 0x1b7c97, 0x1b7446, 0x26, 0x00, 0, 26 }, /* #67 b */
    { 0x1d3c43, 0x1d3c46, 0x4b, 0x00, 0, 26 }, /* #68 */
    { 0x224396, 0x224b46, 0x4b, 0x00, 0, 26 }, /* #68 b */
    { 0x1a0743, 0x1a0f46, 0xbc, 0x00, 0, 11 }, /* #69 */
    { 0x257896, 0x257846, 0xbc, 0x00, 0, 11 }, /* #69 b */
    { 0x3350c7, 0x335883, 0x63, 0x8c, 0, 2  }, /* #70 */
    { 0x0c2f12, 0x0c2f83, 0x63, 0x8c, 0, 2  }, /* #70 b */
    { 0x031686, 0x031e46, 0x8e, 0x00, 0, 25 }, /* #71 */
    { 0x3c6953, 0x3c6946, 0x8e, 0x00, 0, 25 }, /* #71 b */
    { 0x205f96, 0x205f46, 0x4c, 0x00, 0, 14 }, /* #72 */
    { 0x1f2043, 0x1f2846, 0x4c, 0x00, 0, 14 }, /* #72 b */
    { 0x332353, 0x332346, 0x0c, 0x00, 0, 27 }, /* #73 */
    { 0x0c5c86, 0x0c5446, 0x0c, 0x00, 0, 27 }, /* #73 b */
    { 0x364896, 0x364002, 0x2f, 0x5e, 0, 1  }, /* #74 */
    { 0x093743, 0x093702, 0x2f, 0x5e, 0, 1  }, /* #74 b */
    { 0x1f6013, 0x1f6013, 0x19, 0x19, 0, 0  }, /* #75 */
    { 0x201fc6, 0x201fc6, 0x19, 0x19, 0, 0  }, /* #75 b */
    { 0x037042, 0x037046, 0x2d, 0x00, 0, 10 }, /* #76 */
    { 0x3c0f97, 0x3c0746, 0x2d, 0x00, 0, 10 }, /* #76 b */
    { 0x340f52, 0x340746, 0x0f, 0x00, 0, 15 }, /* #77 */
    { 0x0b7087, 0x0b7046, 0x0f, 0x00, 0, 15 }, /* #77 b */
    { 0x216c12, 0x216c46, 0x89, 0x00, 0, 28 }, /* #78 */
    { 0x1e13c7, 0x1e1b46, 0x89, 0x00, 0, 28 }, /* #78 b */
    { 0x024396, 0x024b46, 0xb6, 0x00, 0, 18 }, /* #79 */
    { 0x3d3c43, 0x3d3c46, 0xb6, 0x00, 0, 18 }, /* #79 b */
    { 0x347397, 0x347346, 0xdb, 0x00, 0, 18 }, /* #80 */
    { 0x0b0c42, 0x0b0446, 0xdb, 0x00, 0, 18 }, /* #80 b */
    { 0x187003, 0x187846, 0x91, 0x00, 0, 22 }, /* #81 */
    { 0x270fd6, 0x270f46, 0x91, 0x00, 0, 22 }, /* #81 b */
    { 0x200e13, 0x200e13, 0xb9, 0xb9, 0, 0  }, /* #82 */
    { 0x1f71c6, 0x1f71c6, 0xb9, 0xb9, 0, 0  }, /* #82 b */
    { 0x1d5293, 0x1d5a46, 0x76, 0x00, 0, 8  }, /* #83 */
    { 0x222d46, 0x222d46, 0x76, 0x00, 0, 8  }, /* #83 b */
    { 0x324303, 0x324b46, 0x7a, 0x00, 0, 29 }, /* #84 */
    { 0x0d3cd6, 0x0d3c46, 0x7a, 0x00, 0, 29 }, /* #84 b */
    { 0x314692, 0x314e06, 0x83, 0x30, 0, 4  }, /* #85 */
    { 0x0e3947, 0x0e3906, 0x83, 0x30, 0, 4  }, /* #85 b */
    { 0x357fd2, 0x357fd2, 0x2e, 0x2e, 0, 0  }, /* #86 */
    { 0x0a0007, 0x0a0007, 0x2e, 0x2e, 0, 0  }, /* #86 b */
    { 0x273942, 0x273146, 0xf5, 0x00, 0, 21 }, /* #87 */
    { 0x184697, 0x184646, 0xf5, 0x00, 0, 21 }, /* #87 b */
    { 0x0c6a17, 0x0c6246, 0xcb, 0x00, 0, 16 }, /* #88 */
    { 0x3315c2, 0x331546, 0xcb, 0x00, 0, 16 }, /* #88 b */
    { 0x071fd6, 0x071746, 0xe2, 0x00, 0, 11 }, /* #89 */
    { 0x386003, 0x386046, 0xe2, 0x00, 0, 11 }, /* #89 b */
    { 0x265fc3, 0x265746, 0xc9, 0x00, 0, 25 }, /* #90 */
    { 0x192016, 0x192046, 0xc9, 0x00, 0, 25 }, /* #90 b */
    { 0x385313, 0x385346, 0xc2, 0x00, 0, 21 }, /* #91 */
    { 0x072cc6, 0x072446, 0xc2, 0x00, 0, 21 }, /* #91 b */
    { 0x032f87, 0x032702, 0x08, 0x10, 0, 1  }, /* #92 */
    { 0x3c5052, 0x3c5002, 0x08, 0x10, 0, 1  }, /* #92 b */
    { 0x365183, 0x365146, 0xd6, 0x00, 0, 9  }, /* #93 */
    { 0x092e56, 0x092646, 0xd6, 0x00, 0, 9  }, /* #93 b */
    { 0x164cc7, 0x164c46, 0x5e, 0x00, 0, 11 }, /* #94 */
    { 0x293312, 0x293b46, 0x5e, 0x00, 0, 11 }, /* #94 b */
    { 0x126692, 0x126e46, 0xbf, 0x00, 0, 25 }, /* #95 */
    { 0x2d1947, 0x2d1946, 0xbf, 0x00, 0, 25 }, /* #95 b */
};
uint32_t const g_cTests_shl_u8_intel = RT_ELEMENTS(g_aTests_shl_u8_intel);

BINU8_TEST_T const g_aTests_shr_u8_intel[] =
{
    { 0x3827d7, 0x382746, 0x00, 0x00, 0, 10 }, /* #0 */
    { 0x075802, 0x075046, 0x00, 0x00, 0, 10 }, /* #0 b */
    { 0x044143, 0x044146, 0x00, 0x00, 0, 31 }, /* #1 */
    { 0x3b3e96, 0x3b3646, 0x00, 0x00, 0, 31 }, /* #1 b */
    { 0x1127d3, 0x112746, 0x00, 0x00, 0, 17 }, /* #2 */
    { 0x2e5806, 0x2e5046, 0x00, 0x00, 0, 17 }, /* #2 b */
    { 0x180a87, 0x180246, 0x00, 0x00, 0, 19 }, /* #3 */
    { 0x277552, 0x277546, 0x00, 0x00, 0, 19 }, /* #3 b */
    { 0x0f7852, 0x0f7046, 0x00, 0x00, 0, 6  }, /* #4 */
    { 0x300787, 0x300746, 0x00, 0x00, 0, 6  }, /* #4 b */
    { 0x224212, 0x224246, 0x00, 0x00, 0, 9  }, /* #5 */
    { 0x1d3dc7, 0x1d3546, 0x00, 0x00, 0, 9  }, /* #5 b */
    { 0x2d2cd3, 0x2d2c46, 0xd8, 0x00, 0, 17 }, /* #6 */
    { 0x125306, 0x125b46, 0xd8, 0x00, 0, 17 }, /* #6 b */
    { 0x110686, 0x110e02, 0xe4, 0x07, 0, 5  }, /* #7 */
    { 0x2e7953, 0x2e7902, 0xe4, 0x07, 0, 5  }, /* #7 b */
    { 0x3c0a86, 0x3c0247, 0x1a, 0x00, 0, 5  }, /* #8 */
    { 0x037553, 0x037547, 0x1a, 0x00, 0, 5  }, /* #8 b */
    { 0x217c52, 0x217c46, 0xa3, 0x00, 0, 14 }, /* #9 */
    { 0x1e0387, 0x1e0b46, 0xa3, 0x00, 0, 14 }, /* #9 b */
    { 0x2c5bd6, 0x2c5b47, 0xb5, 0x00, 0, 8  }, /* #10 */
    { 0x132403, 0x132c47, 0xb5, 0x00, 0, 8  }, /* #10 b */
    { 0x122246, 0x122246, 0x05, 0x00, 0, 8  }, /* #11 */
    { 0x2d5d93, 0x2d5546, 0x05, 0x00, 0, 8  }, /* #11 b */
    { 0x0a30c6, 0x0a3002, 0x45, 0x01, 0, 6  }, /* #12 */
    { 0x354f13, 0x354702, 0x45, 0x01, 0, 6  }, /* #12 b */
    { 0x0b5852, 0x0b5046, 0x5f, 0x00, 0, 28 }, /* #13 */
    { 0x342787, 0x342746, 0x5f, 0x00, 0, 28 }, /* #13 b */
    { 0x2b20d7, 0x2b2046, 0x4a, 0x00, 0, 26 }, /* #14 */
    { 0x145f02, 0x145746, 0x4a, 0x00, 0, 26 }, /* #14 b */
    { 0x240446, 0x240446, 0x1e, 0x00, 0, 6  }, /* #15 */
    { 0x1b7b93, 0x1b7346, 0x1e, 0x00, 0, 6  }, /* #15 b */
    { 0x3d4297, 0x3d4246, 0x72, 0x00, 0, 18 }, /* #16 */
    { 0x023d42, 0x023546, 0x72, 0x00, 0, 18 }, /* #16 b */
    { 0x0543c2, 0x054b46, 0xa0, 0x00, 0, 25 }, /* #17 */
    { 0x3a3c17, 0x3a3c46, 0xa0, 0x00, 0, 25 }, /* #17 b */
    { 0x257616, 0x257646, 0x57, 0x00, 0, 26 }, /* #18 */
    { 0x1a09c3, 0x1a0146, 0x57, 0x00, 0, 26 }, /* #18 b */
    { 0x2623d7, 0x262346, 0x79, 0x00, 0, 26 }, /* #19 */
    { 0x195c02, 0x195446, 0x79, 0x00, 0, 26 }, /* #19 b */
    { 0x0b5596, 0x0b5546, 0x46, 0x00, 0, 14 }, /* #20 */
    { 0x342a43, 0x342246, 0x46, 0x00, 0, 14 }, /* #20 b */
    { 0x112256, 0x112203, 0x65, 0x32, 0, 1  }, /* #21 */
    { 0x2e5d83, 0x2e5503, 0x65, 0x32, 0, 1  }, /* #21 b */
    { 0x193c46, 0x193c46, 0xb9, 0x00, 0, 26 }, /* #22 */
    { 0x264393, 0x264b46, 0xb9, 0x00, 0, 26 }, /* #22 b */
    { 0x3e4997, 0x3e4146, 0x42, 0x00, 0, 15 }, /* #23 */
    { 0x013642, 0x013646, 0x42, 0x00, 0, 15 }, /* #23 b */
    { 0x290bd2, 0x290b46, 0xd0, 0x00, 0, 30 }, /* #24 */
    { 0x167407, 0x167c46, 0xd0, 0x00, 0, 30 }, /* #24 b */
    { 0x0f4097, 0x0f4846, 0xeb, 0x00, 0, 16 }, /* #25 */
    { 0x303f42, 0x303f46, 0xeb, 0x00, 0, 16 }, /* #25 b */
    { 0x090252, 0x090a46, 0x88, 0x00, 0, 30 }, /* #26 */
    { 0x367d87, 0x367d46, 0x88, 0x00, 0, 30 }, /* #26 b */
    { 0x307356, 0x307346, 0x13, 0x00, 0, 11 }, /* #27 */
    { 0x0f0c83, 0x0f0446, 0x13, 0x00, 0, 11 }, /* #27 b */
    { 0x026856, 0x026046, 0x52, 0x00, 0, 22 }, /* #28 */
    { 0x3d1783, 0x3d1746, 0x52, 0x00, 0, 22 }, /* #28 b */
    { 0x1b0f16, 0x1b0746, 0x18, 0x00, 0, 16 }, /* #29 */
    { 0x2470c3, 0x247046, 0x18, 0x00, 0, 16 }, /* #29 b */
    { 0x384706, 0x384f46, 0xd1, 0x00, 0, 28 }, /* #30 */
    { 0x0738d3, 0x073846, 0xd1, 0x00, 0, 28 }, /* #30 b */
    { 0x0767c6, 0x076f46, 0xf6, 0x00, 0, 27 }, /* #31 */
    { 0x381813, 0x381846, 0xf6, 0x00, 0, 27 }, /* #31 b */
    { 0x151e83, 0x151e06, 0xc0, 0x18, 0, 3  }, /* #32 */
    { 0x2a6156, 0x2a6906, 0xc0, 0x18, 0, 3  }, /* #32 b */
    { 0x0b2643, 0x0b2e46, 0xfe, 0x00, 0, 24 }, /* #33 */
    { 0x345996, 0x345946, 0xfe, 0x00, 0, 24 }, /* #33 b */
    { 0x047057, 0x047846, 0xb6, 0x00, 0, 24 }, /* #34 */
    { 0x3b0f82, 0x3b0f46, 0xb6, 0x00, 0, 24 }, /* #34 b */
    { 0x3b43d7, 0x3b4346, 0x0a, 0x00, 0, 12 }, /* #35 */
    { 0x043c02, 0x043446, 0x0a, 0x00, 0, 12 }, /* #35 b */
    { 0x266003, 0x266846, 0xba, 0x00, 0, 16 }, /* #36 */
    { 0x191fd6, 0x191f46, 0xba, 0x00, 0, 16 }, /* #36 b */
    { 0x272b56, 0x272346, 0x09, 0x00, 0, 30 }, /* #37 */
    { 0x185483, 0x185446, 0x09, 0x00, 0, 30 }, /* #37 b */
    { 0x0e3a57, 0x0e3a46, 0xd4, 0x00, 0, 19 }, /* #38 */
    { 0x314582, 0x314d46, 0xd4, 0x00, 0, 19 }, /* #38 b */
    { 0x143146, 0x143146, 0x6b, 0x6b, 0, 0  }, /* #39 */
    { 0x2b4e93, 0x2b4e93, 0x6b, 0x6b, 0, 0  }, /* #39 b */
    { 0x183b56, 0x183b46, 0xc5, 0x00, 0, 27 }, /* #40 */
    { 0x274483, 0x274c46, 0xc5, 0x00, 0, 27 }, /* #40 b */
    { 0x2c1d06, 0x2c1502, 0x4b, 0x01, 0, 6  }, /* #41 */
    { 0x1362d3, 0x136202, 0x4b, 0x01, 0, 6  }, /* #41 b */
    { 0x042f93, 0x042746, 0x74, 0x00, 0, 26 }, /* #42 */
    { 0x3b5046, 0x3b5046, 0x74, 0x00, 0, 26 }, /* #42 b */
    { 0x0f0dd2, 0x0f0546, 0x15, 0x00, 0, 25 }, /* #43 */
    { 0x307207, 0x307246, 0x15, 0x00, 0, 25 }, /* #43 b */
    { 0x3524c6, 0x352c46, 0xa7, 0x00, 0, 10 }, /* #44 */
    { 0x0a5b13, 0x0a5b46, 0xa7, 0x00, 0, 10 }, /* #44 b */
    { 0x335cd3, 0x335446, 0x00, 0x00, 0, 21 }, /* #45 */
    { 0x0c2306, 0x0c2346, 0x00, 0x00, 0, 21 }, /* #45 b */
    { 0x027a07, 0x027a46, 0xb6, 0x00, 0, 14 }, /* #46 */
    { 0x3d05d2, 0x3d0d46, 0xb6, 0x00, 0, 14 }, /* #46 b */
    { 0x120dc3, 0x120d46, 0x96, 0x00, 0, 10 }, /* #47 */
    { 0x2d7216, 0x2d7a46, 0x96, 0x00, 0, 10 }, /* #47 b */
    { 0x132f16, 0x132f46, 0xe9, 0x00, 0, 29 }, /* #48 */
    { 0x2c50c3, 0x2c5846, 0xe9, 0x00, 0, 29 }, /* #48 b */
    { 0x181f96, 0x181746, 0x2a, 0x00, 0, 30 }, /* #49 */
    { 0x276043, 0x276046, 0x2a, 0x00, 0, 30 }, /* #49 b */
    { 0x060507, 0x060d46, 0xf8, 0x00, 0, 18 }, /* #50 */
    { 0x397ad2, 0x397a46, 0xf8, 0x00, 0, 18 }, /* #50 b */
    { 0x166d57, 0x166547, 0x08, 0x00, 0, 4  }, /* #51 */
    { 0x291282, 0x291247, 0x08, 0x00, 0, 4  }, /* #51 b */
    { 0x001353, 0x001302, 0x20, 0x10, 0, 1  }, /* #52 */
    { 0x3f6c86, 0x3f6402, 0x20, 0x10, 0, 1  }, /* #52 b */
    { 0x064d13, 0x064d03, 0xe2, 0x38, 0, 2  }, /* #53 */
    { 0x3932c6, 0x393a03, 0xe2, 0x38, 0, 2  }, /* #53 b */
    { 0x086b82, 0x086b07, 0xf5, 0x1e, 0, 3  }, /* #54 */
    { 0x371457, 0x371c07, 0xf5, 0x1e, 0, 3  }, /* #54 b */
    { 0x106f83, 0x106746, 0x31, 0x00, 0, 16 }, /* #55 */
    { 0x2f1056, 0x2f1046, 0x31, 0x00, 0, 16 }, /* #55 b */
    { 0x016e02, 0x016646, 0x14, 0x00, 0, 10 }, /* #56 */
    { 0x3e11d7, 0x3e1146, 0x14, 0x00, 0, 10 }, /* #56 b */
    { 0x155f07, 0x155f02, 0x9b, 0x02, 0, 6  }, /* #57 */
    { 0x2a20d2, 0x2a2802, 0x9b, 0x02, 0, 6  }, /* #57 b */
    { 0x385b87, 0x385346, 0x74, 0x00, 0, 13 }, /* #58 */
    { 0x072452, 0x072446, 0x74, 0x00, 0, 13 }, /* #58 b */
    { 0x020203, 0x020a02, 0x9b, 0x02, 0, 6  }, /* #59 */
    { 0x3d7dd6, 0x3d7d02, 0x9b, 0x02, 0, 6  }, /* #59 b */
    { 0x1f3d06, 0x1f3d46, 0xd2, 0x00, 0, 27 }, /* #60 */
    { 0x2042d3, 0x204a46, 0xd2, 0x00, 0, 27 }, /* #60 b */
    { 0x1e0117, 0x1e0947, 0xa0, 0x00, 0, 8  }, /* #61 */
    { 0x217ec2, 0x217e47, 0xa0, 0x00, 0, 8  }, /* #61 b */
    { 0x051d43, 0x051d46, 0xf5, 0x00, 0, 14 }, /* #62 */
    { 0x3a6296, 0x3a6a46, 0xf5, 0x00, 0, 14 }, /* #62 b */
    { 0x2336c7, 0x233e46, 0xfd, 0x00, 0, 27 }, /* #63 */
    { 0x1c4912, 0x1c4946, 0xfd, 0x00, 0, 27 }, /* #63 b */
    { 0x225b47, 0x225b03, 0xfe, 0x01, 0, 7  }, /* #64 */
    { 0x1d2492, 0x1d2c03, 0xfe, 0x01, 0, 7  }, /* #64 b */
    { 0x097dd2, 0x097546, 0x79, 0x00, 0, 14 }, /* #65 */
    { 0x360207, 0x360246, 0x79, 0x00, 0, 14 }, /* #65 b */
    { 0x185d87, 0x185d46, 0xb8, 0x00, 0, 13 }, /* #66 */
    { 0x272252, 0x272a46, 0xb8, 0x00, 0, 13 }, /* #66 b */
    { 0x120fc3, 0x120f46, 0xc7, 0x00, 0, 28 }, /* #67 */
    { 0x2d7016, 0x2d7846, 0xc7, 0x00, 0, 28 }, /* #67 b */
    { 0x0c7746, 0x0c7f46, 0x95, 0x00, 0, 27 }, /* #68 */
    { 0x330893, 0x330846, 0x95, 0x00, 0, 27 }, /* #68 b */
    { 0x177647, 0x177646, 0x35, 0x00, 0, 20 }, /* #69 */
    { 0x280992, 0x280146, 0x35, 0x00, 0, 20 }, /* #69 b */
    { 0x2c3387, 0x2c3b46, 0xa5, 0x00, 0, 23 }, /* #70 */
    { 0x134c52, 0x134c46, 0xa5, 0x00, 0, 23 }, /* #70 b */
    { 0x0d3196, 0x0d3102, 0x62, 0x31, 0, 1  }, /* #71 */
    { 0x324e43, 0x324602, 0x62, 0x31, 0, 1  }, /* #71 b */
    { 0x394a83, 0x394203, 0x47, 0x23, 0, 1  }, /* #72 */
    { 0x063556, 0x063503, 0x47, 0x23, 0, 1  }, /* #72 b */
    { 0x0370d6, 0x037046, 0x2c, 0x00, 0, 17 }, /* #73 */
    { 0x3c0f03, 0x3c0746, 0x2c, 0x00, 0, 17 }, /* #73 b */
    { 0x103003, 0x103846, 0x90, 0x00, 0, 21 }, /* #74 */
    { 0x2f4fd6, 0x2f4f46, 0x90, 0x00, 0, 21 }, /* #74 b */
    { 0x230752, 0x230746, 0x2d, 0x00, 0, 26 }, /* #75 */
    { 0x1c7887, 0x1c7046, 0x2d, 0x00, 0, 26 }, /* #75 b */
    { 0x224656, 0x224646, 0x4f, 0x00, 0, 27 }, /* #76 */
    { 0x1d3983, 0x1d3146, 0x4f, 0x00, 0, 27 }, /* #76 b */
    { 0x3b64c3, 0x3b6c03, 0x8e, 0x08, 0, 4  }, /* #77 */
    { 0x041b16, 0x041b03, 0x8e, 0x08, 0, 4  }, /* #77 b */
    { 0x342312, 0x342b46, 0x86, 0x00, 0, 16 }, /* #78 */
    { 0x0b5cc7, 0x0b5c46, 0x86, 0x00, 0, 16 }, /* #78 b */
    { 0x146216, 0x146203, 0x1c, 0x01, 0, 4  }, /* #79 */
    { 0x2b1dc3, 0x2b1503, 0x1c, 0x01, 0, 4  }, /* #79 b */
    { 0x181283, 0x181246, 0x4f, 0x00, 0, 20 }, /* #80 */
    { 0x276d56, 0x276546, 0x4f, 0x00, 0, 20 }, /* #80 b */
    { 0x150e13, 0x150606, 0x53, 0x05, 0, 4  }, /* #81 */
    { 0x2a71c6, 0x2a7106, 0x53, 0x05, 0, 4  }, /* #81 b */
    { 0x0228d3, 0x022846, 0xf9, 0x00, 0, 19 }, /* #82 */
    { 0x3d5706, 0x3d5f46, 0xf9, 0x00, 0, 19 }, /* #82 b */
    { 0x1068c2, 0x106046, 0x2e, 0x00, 0, 10 }, /* #83 */
    { 0x2f1717, 0x2f1746, 0x2e, 0x00, 0, 10 }, /* #83 b */
    { 0x384386, 0x384303, 0x39, 0x1c, 0, 1  }, /* #84 */
    { 0x073c53, 0x073403, 0x39, 0x1c, 0, 1  }, /* #84 b */
    { 0x2534d3, 0x253446, 0x73, 0x00, 0, 27 }, /* #85 */
    { 0x1a4b06, 0x1a4346, 0x73, 0x00, 0, 27 }, /* #85 b */
    { 0x365f12, 0x365f03, 0xe4, 0x01, 0, 7  }, /* #86 */
    { 0x0920c7, 0x092803, 0xe4, 0x01, 0, 7  }, /* #86 b */
    { 0x0e7043, 0x0e7007, 0x2b, 0x0a, 0, 2  }, /* #87 */
    { 0x310f96, 0x310707, 0x2b, 0x0a, 0, 2  }, /* #87 b */
    { 0x2a2b92, 0x2a2346, 0x11, 0x00, 0, 10 }, /* #88 */
    { 0x155447, 0x155446, 0x11, 0x00, 0, 10 }, /* #88 b */
    { 0x3929d3, 0x392946, 0x9d, 0x00, 0, 25 }, /* #89 */
    { 0x065606, 0x065e46, 0x9d, 0x00, 0, 25 }, /* #89 b */
    { 0x020293, 0x020a46, 0xf9, 0x00, 0, 27 }, /* #90 */
    { 0x3d7d46, 0x3d7d46, 0xf9, 0x00, 0, 27 }, /* #90 b */
    { 0x045e12, 0x045646, 0x35, 0x00, 0, 26 }, /* #91 */
    { 0x3b21c7, 0x3b2146, 0x35, 0x00, 0, 26 }, /* #91 b */
    { 0x001806, 0x001846, 0x83, 0x00, 0, 13 }, /* #92 */
    { 0x3f67d3, 0x3f6f46, 0x83, 0x00, 0, 13 }, /* #92 b */
    { 0x3c01c2, 0x3c0146, 0x4d, 0x00, 0, 28 }, /* #93 */
    { 0x037e17, 0x037646, 0x4d, 0x00, 0, 28 }, /* #93 b */
    { 0x0f73d6, 0x0f7346, 0x21, 0x00, 0, 25 }, /* #94 */
    { 0x300c03, 0x300446, 0x21, 0x00, 0, 25 }, /* #94 b */
    { 0x2725d2, 0x272546, 0x31, 0x00, 0, 8  }, /* #95 */
    { 0x185a07, 0x185246, 0x31, 0x00, 0, 8  }, /* #95 b */
};
uint32_t const g_cTests_shr_u8_intel = RT_ELEMENTS(g_aTests_shr_u8_intel);

BINU8_TEST_T const g_aTests_sar_u8_intel[] =
{
    { 0x3330d2, 0x333046, 0x00, 0x00, 0, 5  }, /* #0 */
    { 0x0c4f07, 0x0c4746, 0x00, 0x00, 0, 5  }, /* #0 b */
    { 0x2c5e07, 0x2c5646, 0x00, 0x00, 0, 18 }, /* #1 */
    { 0x1321d2, 0x132146, 0x00, 0x00, 0, 18 }, /* #1 b */
    { 0x205952, 0x205146, 0x00, 0x00, 0, 10 }, /* #2 */
    { 0x1f2687, 0x1f2646, 0x00, 0x00, 0, 10 }, /* #2 b */
    { 0x035402, 0x035446, 0x00, 0x00, 0, 15 }, /* #3 */
    { 0x3c2bd7, 0x3c2346, 0x00, 0x00, 0, 15 }, /* #3 b */
    { 0x217ed3, 0x217646, 0x00, 0x00, 0, 2  }, /* #4 */
    { 0x1e0106, 0x1e0146, 0x00, 0x00, 0, 2  }, /* #4 b */
    { 0x3f6352, 0x3f6346, 0x00, 0x00, 0, 3  }, /* #5 */
    { 0x001c87, 0x001446, 0x00, 0x00, 0, 3  }, /* #5 b */
    { 0x3826d3, 0x382646, 0x2d, 0x00, 0, 29 }, /* #6 */
    { 0x075906, 0x075146, 0x2d, 0x00, 0, 29 }, /* #6 b */
    { 0x1a2312, 0x1a2387, 0xf4, 0xff, 0, 26 }, /* #7 */
    { 0x255cc7, 0x255487, 0xf4, 0xff, 0, 26 }, /* #7 b */
    { 0x0841c6, 0x084103, 0x6c, 0x0d, 0, 3  }, /* #8 */
    { 0x373e13, 0x373603, 0x6c, 0x0d, 0, 3  }, /* #8 b */
    { 0x0d5406, 0x0d5487, 0xd4, 0xff, 0, 13 }, /* #9 */
    { 0x322bd3, 0x322387, 0xd4, 0xff, 0, 13 }, /* #9 b */
    { 0x2a5e13, 0x2a5646, 0x03, 0x00, 0, 4  }, /* #10 */
    { 0x1521c6, 0x152146, 0x03, 0x00, 0, 4  }, /* #10 b */
    { 0x2f5287, 0x2f5283, 0x8f, 0xc7, 0, 1  }, /* #11 */
    { 0x102d52, 0x102583, 0x8f, 0xc7, 0, 1  }, /* #11 b */
    { 0x2952d7, 0x295287, 0xfa, 0xff, 0, 23 }, /* #12 */
    { 0x162d02, 0x162587, 0xfa, 0xff, 0, 23 }, /* #12 b */
    { 0x322d03, 0x322547, 0x75, 0x00, 0, 7  }, /* #13 */
    { 0x0d52d6, 0x0d5247, 0x75, 0x00, 0, 7  }, /* #13 b */
    { 0x000c43, 0x000446, 0x2f, 0x00, 0, 25 }, /* #14 */
    { 0x3f7396, 0x3f7346, 0x2f, 0x00, 0, 25 }, /* #14 b */
    { 0x132703, 0x132703, 0x71, 0x71, 0, 0  }, /* #15 */
    { 0x2c58d6, 0x2c58d6, 0x71, 0x71, 0, 0  }, /* #15 b */
    { 0x302d53, 0x302546, 0x77, 0x00, 0, 8  }, /* #16 */
    { 0x0f5286, 0x0f5246, 0x77, 0x00, 0, 8  }, /* #16 b */
    { 0x1a1c53, 0x1a1487, 0xf7, 0xff, 0, 14 }, /* #17 */
    { 0x256386, 0x256387, 0xf7, 0xff, 0, 14 }, /* #17 b */
    { 0x2a1943, 0x2a1187, 0xcd, 0xff, 0, 19 }, /* #18 */
    { 0x156696, 0x156687, 0xcd, 0xff, 0, 19 }, /* #18 b */
    { 0x241d17, 0x241503, 0x09, 0x04, 0, 1  }, /* #19 */
    { 0x1b62c2, 0x1b6203, 0x09, 0x04, 0, 1  }, /* #19 b */
    { 0x2d23d2, 0x2d2347, 0x18, 0x00, 0, 5  }, /* #20 */
    { 0x125c07, 0x125447, 0x18, 0x00, 0, 5  }, /* #20 b */
    { 0x1e4113, 0x1e4187, 0xfa, 0xff, 0, 10 }, /* #21 */
    { 0x213ec6, 0x213687, 0xfa, 0xff, 0, 10 }, /* #21 b */
    { 0x2510c3, 0x251046, 0x7c, 0x00, 0, 20 }, /* #22 */
    { 0x1a6f16, 0x1a6746, 0x7c, 0x00, 0, 20 }, /* #22 b */
    { 0x343c97, 0x343487, 0xf7, 0xff, 0, 31 }, /* #23 */
    { 0x0b4342, 0x0b4387, 0xf7, 0xff, 0, 31 }, /* #23 b */
    { 0x091f87, 0x091746, 0x2d, 0x00, 0, 20 }, /* #24 */
    { 0x366052, 0x366046, 0x2d, 0x00, 0, 20 }, /* #24 b */
    { 0x343e43, 0x343646, 0x58, 0x00, 0, 9  }, /* #25 */
    { 0x0b4196, 0x0b4146, 0x58, 0x00, 0, 9  }, /* #25 b */
    { 0x005652, 0x005683, 0xe9, 0xf4, 0, 1  }, /* #26 */
    { 0x3f2987, 0x3f2183, 0xe9, 0xf4, 0, 1  }, /* #26 b */
    { 0x0366c6, 0x036646, 0x22, 0x00, 0, 16 }, /* #27 */
    { 0x3c1913, 0x3c1146, 0x22, 0x00, 0, 16 }, /* #27 b */
    { 0x223542, 0x223546, 0x7d, 0x00, 0, 12 }, /* #28 */
    { 0x1d4a97, 0x1d4246, 0x7d, 0x00, 0, 12 }, /* #28 b */
    { 0x2d7443, 0x2d7487, 0x80, 0xff, 0, 27 }, /* #29 */
    { 0x120b96, 0x120387, 0x80, 0xff, 0, 27 }, /* #29 b */
    { 0x093bc2, 0x093387, 0xa7, 0xff, 0, 17 }, /* #30 */
    { 0x364417, 0x364487, 0xa7, 0xff, 0, 17 }, /* #30 b */
    { 0x252343, 0x252346, 0x28, 0x00, 0, 18 }, /* #31 */
    { 0x1a5c96, 0x1a5446, 0x28, 0x00, 0, 18 }, /* #31 b */
    { 0x212d83, 0x212546, 0x6f, 0x00, 0, 14 }, /* #32 */
    { 0x1e5256, 0x1e5246, 0x6f, 0x00, 0, 14 }, /* #32 b */
    { 0x1e0002, 0x1e0046, 0x35, 0x00, 0, 24 }, /* #33 */
    { 0x217fd7, 0x217746, 0x35, 0x00, 0, 24 }, /* #33 b */
    { 0x1c7603, 0x1c7646, 0x18, 0x00, 0, 10 }, /* #34 */
    { 0x2309d6, 0x230146, 0x18, 0x00, 0, 10 }, /* #34 b */
    { 0x3d7557, 0x3d7546, 0x4b, 0x00, 0, 13 }, /* #35 */
    { 0x020a82, 0x020246, 0x4b, 0x00, 0, 13 }, /* #35 b */
    { 0x204c42, 0x204446, 0x3d, 0x00, 0, 18 }, /* #36 */
    { 0x1f3397, 0x1f3346, 0x3d, 0x00, 0, 18 }, /* #36 b */
    { 0x2e3803, 0x2e3046, 0x03, 0x00, 0, 24 }, /* #37 */
    { 0x1147d6, 0x114746, 0x03, 0x00, 0, 24 }, /* #37 b */
    { 0x3c0e97, 0x3c0687, 0xca, 0xff, 0, 21 }, /* #38 */
    { 0x037142, 0x037187, 0xca, 0xff, 0, 21 }, /* #38 b */
    { 0x3a0706, 0x3a0786, 0x90, 0xe4, 0, 2  }, /* #39 */
    { 0x0578d3, 0x057086, 0x90, 0xe4, 0, 2  }, /* #39 b */
    { 0x334e56, 0x334687, 0xc1, 0xff, 0, 10 }, /* #40 */
    { 0x0c3183, 0x0c3187, 0xc1, 0xff, 0, 10 }, /* #40 b */
    { 0x3f5903, 0x3f5183, 0xea, 0xfe, 0, 4  }, /* #41 */
    { 0x0026d6, 0x002683, 0xea, 0xfe, 0, 4  }, /* #41 b */
    { 0x364dd7, 0x364546, 0x59, 0x00, 0, 11 }, /* #42 */
    { 0x093202, 0x093246, 0x59, 0x00, 0, 11 }, /* #42 b */
    { 0x125503, 0x125546, 0x59, 0x00, 0, 23 }, /* #43 */
    { 0x2d2ad6, 0x2d2246, 0x59, 0x00, 0, 23 }, /* #43 b */
    { 0x0d28c2, 0x0d2046, 0x35, 0x00, 0, 24 }, /* #44 */
    { 0x325717, 0x325746, 0x35, 0x00, 0, 24 }, /* #44 b */
    { 0x2b4b87, 0x2b4346, 0x40, 0x00, 0, 16 }, /* #45 */
    { 0x143452, 0x143446, 0x40, 0x00, 0, 16 }, /* #45 b */
    { 0x2b5806, 0x2b5087, 0xb2, 0xff, 0, 9  }, /* #46 */
    { 0x1427d3, 0x142787, 0xb2, 0xff, 0, 9  }, /* #46 b */
    { 0x1e4f86, 0x1e4786, 0xa7, 0xfa, 0, 4  }, /* #47 */
    { 0x213053, 0x213086, 0xa7, 0xfa, 0, 4  }, /* #47 b */
    { 0x065646, 0x065646, 0x49, 0x00, 0, 11 }, /* #48 */
    { 0x392993, 0x392146, 0x49, 0x00, 0, 11 }, /* #48 b */
    { 0x2c4fd7, 0x2c4787, 0xed, 0xff, 0, 13 }, /* #49 */
    { 0x133002, 0x133087, 0xed, 0xff, 0, 13 }, /* #49 b */
    { 0x3c40c2, 0x3c4007, 0x31, 0x18, 0, 1  }, /* #50 */
    { 0x033f17, 0x033707, 0x31, 0x18, 0, 1  }, /* #50 b */
    { 0x0d6fc2, 0x0d6787, 0x8b, 0xff, 0, 21 }, /* #51 */
    { 0x321017, 0x321087, 0x8b, 0xff, 0, 21 }, /* #51 b */
    { 0x145cc7, 0x145487, 0x8b, 0xff, 0, 11 }, /* #52 */
    { 0x2b2312, 0x2b2387, 0x8b, 0xff, 0, 11 }, /* #52 b */
    { 0x320686, 0x320687, 0xe9, 0xff, 0, 29 }, /* #53 */
    { 0x0d7953, 0x0d7187, 0xe9, 0xff, 0, 29 }, /* #53 b */
    { 0x1c3d82, 0x1c3587, 0xea, 0xff, 0, 11 }, /* #54 */
    { 0x234257, 0x234287, 0xea, 0xff, 0, 11 }, /* #54 b */
    { 0x147512, 0x147546, 0x4e, 0x00, 0, 24 }, /* #55 */
    { 0x2b0ac7, 0x2b0246, 0x4e, 0x00, 0, 24 }, /* #55 b */
    { 0x271f87, 0x271746, 0x73, 0x00, 0, 30 }, /* #56 */
    { 0x186052, 0x186046, 0x73, 0x00, 0, 30 }, /* #56 b */
    { 0x3277d2, 0x327746, 0x3c, 0x00, 0, 28 }, /* #57 */
    { 0x0d0807, 0x0d0046, 0x3c, 0x00, 0, 28 }, /* #57 b */
    { 0x076283, 0x076286, 0xda, 0xff, 0, 6  }, /* #58 */
    { 0x381d56, 0x381586, 0xda, 0xff, 0, 6  }, /* #58 b */
    { 0x2c7e83, 0x2c7646, 0x5c, 0x00, 0, 16 }, /* #59 */
    { 0x130156, 0x130146, 0x5c, 0x00, 0, 16 }, /* #59 b */
    { 0x323582, 0x323502, 0x22, 0x01, 0, 5  }, /* #60 */
    { 0x0d4a57, 0x0d4202, 0x22, 0x01, 0, 5  }, /* #60 b */
    { 0x3a1482, 0x3a1446, 0x1b, 0x00, 0, 30 }, /* #61 */
    { 0x056b57, 0x056346, 0x1b, 0x00, 0, 30 }, /* #61 b */
    { 0x082a43, 0x082246, 0x2d, 0x00, 0, 8  }, /* #62 */
    { 0x375596, 0x375546, 0x2d, 0x00, 0, 8  }, /* #62 b */
    { 0x0d0113, 0x0d0187, 0xdd, 0xff, 0, 20 }, /* #63 */
    { 0x327ec6, 0x327687, 0xdd, 0xff, 0, 20 }, /* #63 b */
    { 0x150142, 0x150187, 0x82, 0xff, 0, 17 }, /* #64 */
    { 0x2a7e97, 0x2a7687, 0x82, 0xff, 0, 17 }, /* #64 b */
    { 0x157952, 0x157187, 0xbc, 0xff, 0, 25 }, /* #65 */
    { 0x2a0687, 0x2a0687, 0xbc, 0xff, 0, 25 }, /* #65 b */
    { 0x324a97, 0x324287, 0xbe, 0xff, 0, 31 }, /* #66 */
    { 0x0d3542, 0x0d3587, 0xbe, 0xff, 0, 31 }, /* #66 b */
    { 0x323786, 0x323746, 0x3a, 0x00, 0, 21 }, /* #67 */
    { 0x0d4853, 0x0d4046, 0x3a, 0x00, 0, 21 }, /* #67 b */
    { 0x231e97, 0x231646, 0x7d, 0x00, 0, 13 }, /* #68 */
    { 0x1c6142, 0x1c6146, 0x7d, 0x00, 0, 13 }, /* #68 b */
    { 0x202952, 0x202147, 0x07, 0x00, 0, 3  }, /* #69 */
    { 0x1f5687, 0x1f5647, 0x07, 0x00, 0, 3  }, /* #69 b */
    { 0x082256, 0x082246, 0x63, 0x00, 0, 26 }, /* #70 */
    { 0x375d83, 0x375546, 0x63, 0x00, 0, 26 }, /* #70 b */
    { 0x145c82, 0x145487, 0x99, 0xff, 0, 15 }, /* #71 */
    { 0x2b2357, 0x2b2387, 0x99, 0xff, 0, 15 }, /* #71 b */
    { 0x267502, 0x267546, 0x58, 0x00, 0, 27 }, /* #72 */
    { 0x190ad7, 0x190246, 0x58, 0x00, 0, 27 }, /* #72 b */
    { 0x0709c7, 0x070187, 0x92, 0xff, 0, 20 }, /* #73 */
    { 0x387612, 0x387687, 0x92, 0xff, 0, 20 }, /* #73 b */
    { 0x1a2b12, 0x1a2387, 0xd9, 0xff, 0, 16 }, /* #74 */
    { 0x2554c7, 0x255487, 0xd9, 0xff, 0, 16 }, /* #74 b */
    { 0x1c14c2, 0x1c1446, 0x34, 0x00, 0, 11 }, /* #75 */
    { 0x236b17, 0x236346, 0x34, 0x00, 0, 11 }, /* #75 b */
    { 0x335d57, 0x335587, 0xb2, 0xff, 0, 26 }, /* #76 */
    { 0x0c2282, 0x0c2287, 0xb2, 0xff, 0, 26 }, /* #76 b */
    { 0x0d2413, 0x0d2487, 0xac, 0xff, 0, 29 }, /* #77 */
    { 0x325bc6, 0x325387, 0xac, 0xff, 0, 29 }, /* #77 b */
    { 0x301357, 0x301382, 0xa5, 0xe9, 0, 2  }, /* #78 */
    { 0x0f6c82, 0x0f6482, 0xa5, 0xe9, 0, 2  }, /* #78 b */
    { 0x0e29c3, 0x0e2187, 0xb4, 0xff, 0, 12 }, /* #79 */
    { 0x315616, 0x315687, 0xb4, 0xff, 0, 12 }, /* #79 b */
    { 0x1c7417, 0x1c7487, 0xe2, 0xff, 0, 10 }, /* #80 */
    { 0x230bc2, 0x230387, 0xe2, 0xff, 0, 10 }, /* #80 b */
    { 0x0c51d6, 0x0c5146, 0x62, 0x00, 0, 13 }, /* #81 */
    { 0x332e03, 0x332646, 0x62, 0x00, 0, 13 }, /* #81 b */
    { 0x2d3807, 0x2d3087, 0x88, 0xff, 0, 22 }, /* #82 */
    { 0x1247d2, 0x124787, 0x88, 0xff, 0, 22 }, /* #82 b */
    { 0x170007, 0x170046, 0x47, 0x00, 0, 31 }, /* #83 */
    { 0x287fd2, 0x287746, 0x47, 0x00, 0, 31 }, /* #83 b */
    { 0x283c93, 0x283c93, 0x65, 0x65, 0, 0  }, /* #84 */
    { 0x174346, 0x174346, 0x65, 0x65, 0, 0  }, /* #84 b */
    { 0x284c06, 0x284c06, 0x38, 0x38, 0, 0  }, /* #85 */
    { 0x1733d3, 0x1733d3, 0x38, 0x38, 0, 0  }, /* #85 b */
    { 0x087a96, 0x087287, 0xb0, 0xff, 0, 28 }, /* #86 */
    { 0x370543, 0x370587, 0xb0, 0xff, 0, 28 }, /* #86 b */
    { 0x012a42, 0x012282, 0xe0, 0xf8, 0, 2  }, /* #87 */
    { 0x3e5597, 0x3e5582, 0xe0, 0xf8, 0, 2  }, /* #87 b */
    { 0x0621d7, 0x062186, 0xe3, 0xfc, 0, 3  }, /* #88 */
    { 0x395e02, 0x395686, 0xe3, 0xfc, 0, 3  }, /* #88 b */
    { 0x042c02, 0x042487, 0xad, 0xff, 0, 26 }, /* #89 */
    { 0x3b53d7, 0x3b5387, 0xad, 0xff, 0, 26 }, /* #89 b */
    { 0x347502, 0x347506, 0x25, 0x09, 0, 2  }, /* #90 */
    { 0x0b0ad7, 0x0b0206, 0x25, 0x09, 0, 2  }, /* #90 b */
    { 0x1a6843, 0x1a6046, 0x70, 0x00, 0, 26 }, /* #91 */
    { 0x251796, 0x251746, 0x70, 0x00, 0, 26 }, /* #91 b */
    { 0x281686, 0x281646, 0x52, 0x00, 0, 24 }, /* #92 */
    { 0x176953, 0x176146, 0x52, 0x00, 0, 24 }, /* #92 b */
    { 0x0961d7, 0x096146, 0x10, 0x00, 0, 29 }, /* #93 */
    { 0x361e02, 0x361646, 0x10, 0x00, 0, 29 }, /* #93 b */
    { 0x3c51d7, 0x3c5182, 0xc2, 0xfe, 0, 5  }, /* #94 */
    { 0x032e02, 0x032682, 0xc2, 0xfe, 0, 5  }, /* #94 b */
    { 0x166ed2, 0x166687, 0xc7, 0xff, 0, 22 }, /* #95 */
    { 0x291107, 0x291187, 0xc7, 0xff, 0, 22 }, /* #95 b */
};
uint32_t const g_cTests_sar_u8_intel = RT_ELEMENTS(g_aTests_sar_u8_intel);

BINU16_TEST_T const g_aTests_rol_u16_intel[] =
{
    { 0x2f60d3, 0x2f60d2, 0x0000, 0x0000, 0, 8  }, /* #0 */
    { 0x101f06, 0x101706, 0x0000, 0x0000, 0, 8  }, /* #0 b */
    { 0x3c7cc2, 0x3c74c2, 0x0000, 0x0000, 0, 1  }, /* #1 */
    { 0x030317, 0x030316, 0x0000, 0x0000, 0, 1  }, /* #1 b */
    { 0x095456, 0x095456, 0x0000, 0x0000, 0, 41 }, /* #2 */
    { 0x362b83, 0x362382, 0x0000, 0x0000, 0, 41 }, /* #2 b */
    { 0x2c04d2, 0x2c04d2, 0x0000, 0x0000, 0, 51 }, /* #3 */
    { 0x137b07, 0x137306, 0x0000, 0x0000, 0, 51 }, /* #3 b */
    { 0x044e03, 0x044602, 0x0000, 0x0000, 0, 54 }, /* #4 */
    { 0x3b31d6, 0x3b31d6, 0x0000, 0x0000, 0, 54 }, /* #4 b */
    { 0x1d15d3, 0x1d15d2, 0x0000, 0x0000, 0, 38 }, /* #5 */
    { 0x226a06, 0x226206, 0x0000, 0x0000, 0, 38 }, /* #5 b */
    { 0x167ec7, 0x167ec7, 0x64d9, 0x9365, 0, 2  }, /* #6 */
    { 0x290112, 0x290913, 0x64d9, 0x9365, 0, 2  }, /* #6 b */
    { 0x0e7a52, 0x0e7a53, 0x9c3b, 0xc3b9, 0, 20 }, /* #7 */
    { 0x310587, 0x310d87, 0x9c3b, 0xc3b9, 0, 20 }, /* #7 b */
    { 0x084f56, 0x084f57, 0x44ec, 0x13b1, 0, 50 }, /* #8 */
    { 0x373083, 0x373883, 0x44ec, 0x13b1, 0, 50 }, /* #8 b */
    { 0x2510d3, 0x2518d3, 0x9eb3, 0xcf59, 0, 63 }, /* #9 */
    { 0x1a6f06, 0x1a6f07, 0x9eb3, 0xcf59, 0, 63 }, /* #9 b */
    { 0x2f6d97, 0x2f6d97, 0x49fd, 0x49fd, 0, 32 }, /* #10 */
    { 0x101242, 0x101242, 0x49fd, 0x49fd, 0, 32 }, /* #10 b */
    { 0x181642, 0x181e42, 0xb85b, 0xb770, 0, 25 }, /* #11 */
    { 0x276997, 0x276996, 0xb85b, 0xb770, 0, 25 }, /* #11 b */
    { 0x292913, 0x292912, 0xa1ac, 0xca1a, 0, 12 }, /* #12 */
    { 0x1656c6, 0x165ec6, 0xa1ac, 0xca1a, 0, 12 }, /* #12 b */
    { 0x313e92, 0x313e93, 0x4c40, 0x3101, 0, 18 }, /* #13 */
    { 0x0e4147, 0x0e4947, 0x4c40, 0x3101, 0, 18 }, /* #13 b */
    { 0x252396, 0x252b96, 0x5385, 0x9c2a, 0, 19 }, /* #14 */
    { 0x1a5c43, 0x1a5c42, 0x5385, 0x9c2a, 0, 19 }, /* #14 b */
    { 0x3479d6, 0x3479d6, 0x5b8b, 0xdc5a, 0, 51 }, /* #15 */
    { 0x0b0603, 0x0b0e02, 0x5b8b, 0xdc5a, 0, 51 }, /* #15 b */
    { 0x0d4792, 0x0d4f92, 0x950d, 0xa86c, 0, 3  }, /* #16 */
    { 0x323847, 0x323846, 0x950d, 0xa86c, 0, 3  }, /* #16 b */
    { 0x251803, 0x251803, 0x9e62, 0x14f3, 0, 43 }, /* #17 */
    { 0x1a67d6, 0x1a6fd7, 0x9e62, 0x14f3, 0, 43 }, /* #17 b */
    { 0x142e13, 0x142613, 0x3fae, 0x71fd, 0, 11 }, /* #18 */
    { 0x2b51c6, 0x2b51c7, 0x3fae, 0x71fd, 0, 11 }, /* #18 b */
    { 0x226347, 0x226b47, 0x81b3, 0x9c0d, 0, 27 }, /* #19 */
    { 0x1d1c92, 0x1d1c93, 0x81b3, 0x9c0d, 0, 27 }, /* #19 b */
    { 0x1848c7, 0x1840c7, 0x1a60, 0xa601, 0, 52 }, /* #20 */
    { 0x273712, 0x273713, 0x1a60, 0xa601, 0, 52 }, /* #20 b */
    { 0x123747, 0x123f46, 0x414d, 0xa0a6, 0, 63 }, /* #21 */
    { 0x2d4892, 0x2d4892, 0x414d, 0xa0a6, 0, 63 }, /* #21 b */
    { 0x121417, 0x121417, 0xd7ff, 0xfebf, 0, 43 }, /* #22 */
    { 0x2d6bc2, 0x2d63c3, 0xd7ff, 0xfebf, 0, 43 }, /* #22 b */
    { 0x363747, 0x363f46, 0x6924, 0xd248, 0, 17 }, /* #23 */
    { 0x094892, 0x094892, 0x6924, 0xd248, 0, 17 }, /* #23 b */
    { 0x0b0092, 0x0b0093, 0xfb98, 0xf731, 0, 33 }, /* #24 */
    { 0x347f47, 0x347747, 0xfb98, 0xf731, 0, 33 }, /* #24 b */
    { 0x076953, 0x076952, 0x70c3, 0x1b86, 0, 11 }, /* #25 */
    { 0x381686, 0x381e86, 0x70c3, 0x1b86, 0, 11 }, /* #25 b */
    { 0x1739c7, 0x1731c7, 0x1b76, 0xb0db, 0, 43 }, /* #26 */
    { 0x284612, 0x284613, 0x1b76, 0xb0db, 0, 43 }, /* #26 b */
    { 0x0e7a83, 0x0e7283, 0x2f0b, 0xc2cb, 0, 38 }, /* #27 */
    { 0x310556, 0x310557, 0x2f0b, 0xc2cb, 0, 38 }, /* #27 b */
    { 0x1f00d7, 0x1f08d6, 0x83e1, 0x183e, 0, 28 }, /* #28 */
    { 0x207f02, 0x207f02, 0x83e1, 0x183e, 0, 28 }, /* #28 b */
    { 0x090bc2, 0x090bc2, 0x6f31, 0xc5bc, 0, 42 }, /* #29 */
    { 0x367417, 0x367c16, 0x6f31, 0xc5bc, 0, 42 }, /* #29 b */
    { 0x286893, 0x286093, 0xd532, 0x96a9, 0, 43 }, /* #30 */
    { 0x171746, 0x171747, 0xd532, 0x96a9, 0, 43 }, /* #30 b */
    { 0x162793, 0x162f92, 0xb0ef, 0x1df6, 0, 5  }, /* #31 */
    { 0x295846, 0x295846, 0xb0ef, 0x1df6, 0, 5  }, /* #31 b */
    { 0x1864c6, 0x186cc6, 0x88fd, 0x8fd8, 0, 36 }, /* #32 */
    { 0x271b13, 0x271b12, 0x88fd, 0x8fd8, 0, 36 }, /* #32 b */
    { 0x3b3506, 0x3b3d07, 0xb2f3, 0xe765, 0, 25 }, /* #33 */
    { 0x044ad3, 0x044ad3, 0xb2f3, 0xe765, 0, 25 }, /* #33 b */
    { 0x315bd2, 0x3153d3, 0x0c31, 0x0c31, 0, 48 }, /* #34 */
    { 0x0e2407, 0x0e2407, 0x0c31, 0x0c31, 0, 48 }, /* #34 b */
    { 0x3f2c16, 0x3f2417, 0x2f77, 0xdcbd, 0, 26 }, /* #35 */
    { 0x0053c3, 0x0053c3, 0x2f77, 0xdcbd, 0, 26 }, /* #35 b */
    { 0x2d2a47, 0x2d2246, 0x0729, 0x3948, 0, 19 }, /* #36 */
    { 0x125592, 0x125592, 0x0729, 0x3948, 0, 19 }, /* #36 b */
    { 0x2e4417, 0x2e4417, 0xc596, 0x8b2d, 0, 49 }, /* #37 */
    { 0x113bc2, 0x1133c3, 0xc596, 0x8b2d, 0, 49 }, /* #37 b */
    { 0x395882, 0x395082, 0xf8d3, 0xd3f8, 0, 24 }, /* #38 */
    { 0x062757, 0x062756, 0xf8d3, 0xd3f8, 0, 24 }, /* #38 b */
    { 0x154347, 0x154b47, 0xa3f4, 0x28fd, 0, 62 }, /* #39 */
    { 0x2a3c92, 0x2a3c93, 0xa3f4, 0x28fd, 0, 62 }, /* #39 b */
    { 0x320553, 0x320d53, 0xbdf2, 0xf2bd, 0, 56 }, /* #40 */
    { 0x0d7a86, 0x0d7a87, 0xbdf2, 0xf2bd, 0, 56 }, /* #40 b */
    { 0x0d4413, 0x0d4412, 0x03e6, 0xc07c, 0, 13 }, /* #41 */
    { 0x323bc6, 0x3233c6, 0x03e6, 0xc07c, 0, 13 }, /* #41 b */
    { 0x1a4502, 0x1a4503, 0xff65, 0xfd97, 0, 2  }, /* #42 */
    { 0x253ad7, 0x2532d7, 0xff65, 0xfd97, 0, 2  }, /* #42 b */
    { 0x313a02, 0x313a03, 0xbbf4, 0xd2ef, 0, 26 }, /* #43 */
    { 0x0e45d7, 0x0e4dd7, 0xbbf4, 0xd2ef, 0, 26 }, /* #43 b */
    { 0x1d1043, 0x1d1043, 0x3261, 0x3261, 0, 32 }, /* #44 */
    { 0x226f96, 0x226f96, 0x3261, 0x3261, 0, 32 }, /* #44 b */
    { 0x254c83, 0x254c83, 0xa432, 0x0ca9, 0, 6  }, /* #45 */
    { 0x1a3356, 0x1a3b57, 0xa432, 0x0ca9, 0, 6  }, /* #45 b */
    { 0x2504d2, 0x250cd2, 0xaf50, 0xaf50, 0, 16 }, /* #46 */
    { 0x1a7b07, 0x1a7b06, 0xaf50, 0xaf50, 0, 16 }, /* #46 b */
    { 0x094092, 0x094093, 0xedd4, 0x53b7, 0, 26 }, /* #47 */
    { 0x363f47, 0x363747, 0xedd4, 0x53b7, 0, 26 }, /* #47 b */
    { 0x0e7a93, 0x0e7a93, 0x9220, 0x1049, 0, 55 }, /* #48 */
    { 0x310546, 0x310d47, 0x9220, 0x1049, 0, 55 }, /* #48 b */
    { 0x336747, 0x336f46, 0xae6d, 0xd736, 0, 31 }, /* #49 */
    { 0x0c1892, 0x0c1892, 0xae6d, 0xd736, 0, 31 }, /* #49 b */
    { 0x181806, 0x181007, 0x1468, 0x40a3, 0, 59 }, /* #50 */
    { 0x2767d3, 0x2767d3, 0x1468, 0x40a3, 0, 59 }, /* #50 b */
    { 0x253513, 0x253d12, 0x63cc, 0x631e, 0, 11 }, /* #51 */
    { 0x1a4ac6, 0x1a4ac6, 0x63cc, 0x631e, 0, 11 }, /* #51 b */
    { 0x250986, 0x250186, 0xd206, 0x3690, 0, 11 }, /* #52 */
    { 0x1a7653, 0x1a7652, 0xd206, 0x3690, 0, 11 }, /* #52 b */
    { 0x152d12, 0x152512, 0xdfdc, 0xdfdc, 0, 48 }, /* #53 */
    { 0x2a52c7, 0x2a52c6, 0xdfdc, 0xdfdc, 0, 48 }, /* #53 b */
    { 0x235503, 0x235503, 0xd5d4, 0x3575, 0, 46 }, /* #54 */
    { 0x1c2ad6, 0x1c22d7, 0xd5d4, 0x3575, 0, 46 }, /* #54 b */
    { 0x251c53, 0x251c52, 0xab05, 0x5ab0, 0, 28 }, /* #55 */
    { 0x1a6386, 0x1a6b86, 0xab05, 0x5ab0, 0, 28 }, /* #55 b */
    { 0x081716, 0x081f17, 0x43ac, 0x0eb1, 0, 50 }, /* #56 */
    { 0x3768c3, 0x3768c3, 0x43ac, 0x0eb1, 0, 50 }, /* #56 b */
    { 0x284782, 0x284782, 0xb429, 0xb429, 0, 32 }, /* #57 */
    { 0x173857, 0x173857, 0xb429, 0xb429, 0, 32 }, /* #57 b */
    { 0x1c6842, 0x1c6842, 0x9661, 0xcb30, 0, 47 }, /* #58 */
    { 0x231797, 0x231f96, 0x9661, 0xcb30, 0, 47 }, /* #58 b */
    { 0x293e42, 0x293642, 0xed20, 0x3b48, 0, 46 }, /* #59 */
    { 0x164197, 0x164196, 0xed20, 0x3b48, 0, 46 }, /* #59 b */
    { 0x0f3fd7, 0x0f37d7, 0x317e, 0x8c5f, 0, 46 }, /* #60 */
    { 0x304002, 0x304003, 0x317e, 0x8c5f, 0, 46 }, /* #60 b */
    { 0x310bd6, 0x3103d7, 0xe5c8, 0x7239, 0, 6  }, /* #61 */
    { 0x0e7403, 0x0e7403, 0xe5c8, 0x7239, 0, 6  }, /* #61 b */
    { 0x306353, 0x306b53, 0x7359, 0x7359, 0, 16 }, /* #62 */
    { 0x0f1c86, 0x0f1c87, 0x7359, 0x7359, 0, 16 }, /* #62 b */
    { 0x034853, 0x034052, 0x11d5, 0x8ea8, 0, 35 }, /* #63 */
    { 0x3c3786, 0x3c3786, 0x11d5, 0x8ea8, 0, 35 }, /* #63 b */
    { 0x2c7543, 0x2c7543, 0x3b6e, 0x3b6e, 0, 32 }, /* #64 */
    { 0x130a96, 0x130a96, 0x3b6e, 0x3b6e, 0, 32 }, /* #64 b */
    { 0x366a07, 0x366207, 0x30b6, 0x8c2d, 0, 46 }, /* #65 */
    { 0x0915d2, 0x0915d3, 0x30b6, 0x8c2d, 0, 46 }, /* #65 b */
    { 0x2c4e17, 0x2c4e17, 0x420c, 0x0831, 0, 18 }, /* #66 */
    { 0x1331c2, 0x1339c3, 0x420c, 0x0831, 0, 18 }, /* #66 b */
    { 0x031b56, 0x031b56, 0xa1c4, 0xe250, 0, 55 }, /* #67 */
    { 0x3c6483, 0x3c6c82, 0xa1c4, 0xe250, 0, 55 }, /* #67 b */
    { 0x1a04d6, 0x1a04d6, 0xe9e3, 0xf1f4, 0, 23 }, /* #68 */
    { 0x257b03, 0x257302, 0xe9e3, 0xf1f4, 0, 23 }, /* #68 b */
    { 0x0a1242, 0x0a1a42, 0x5c0c, 0x062e, 0, 7  }, /* #69 */
    { 0x356d97, 0x356d96, 0x5c0c, 0x062e, 0, 7  }, /* #69 b */
    { 0x311896, 0x311097, 0x327e, 0x8c9f, 0, 14 }, /* #70 */
    { 0x0e6743, 0x0e6743, 0x327e, 0x8c9f, 0, 14 }, /* #70 b */
    { 0x014993, 0x014992, 0x946e, 0x946e, 0, 16 }, /* #71 */
    { 0x3e3646, 0x3e3e46, 0x946e, 0x946e, 0, 16 }, /* #71 b */
    { 0x095942, 0x095943, 0x8ae4, 0x22b9, 0, 62 }, /* #72 */
    { 0x362697, 0x362e97, 0x8ae4, 0x22b9, 0, 62 }, /* #72 b */
    { 0x227b13, 0x227312, 0x026e, 0x1370, 0, 51 }, /* #73 */
    { 0x1d04c6, 0x1d04c6, 0x026e, 0x1370, 0, 51 }, /* #73 b */
    { 0x170382, 0x170383, 0x2e63, 0xcc65, 0, 37 }, /* #74 */
    { 0x287c57, 0x287457, 0x2e63, 0xcc65, 0, 37 }, /* #74 b */
    { 0x3f3013, 0x3f3013, 0xfb82, 0x7dc1, 0, 63 }, /* #75 */
    { 0x004fc6, 0x0047c7, 0xfb82, 0x7dc1, 0, 63 }, /* #75 b */
    { 0x2e2402, 0x2e2c02, 0xa224, 0x4944, 0, 25 }, /* #76 */
    { 0x115bd7, 0x115bd6, 0xa224, 0x4944, 0, 25 }, /* #76 b */
    { 0x236ed6, 0x236ed7, 0x58db, 0xb58d, 0, 12 }, /* #77 */
    { 0x1c1103, 0x1c1903, 0x58db, 0xb58d, 0, 12 }, /* #77 b */
    { 0x240ad7, 0x240ad6, 0x6ec2, 0x26ec, 0, 60 }, /* #78 */
    { 0x1b7502, 0x1b7d02, 0x6ec2, 0x26ec, 0, 60 }, /* #78 b */
    { 0x0c2682, 0x0c2e82, 0xa3ad, 0xd1d6, 0, 15 }, /* #79 */
    { 0x335957, 0x335956, 0xa3ad, 0xd1d6, 0, 15 }, /* #79 b */
    { 0x137907, 0x137907, 0x8be7, 0xe78b, 0, 8  }, /* #80 */
    { 0x2c06d2, 0x2c0ed3, 0x8be7, 0xe78b, 0, 8  }, /* #80 b */
    { 0x037682, 0x037e83, 0xbdf2, 0xbe57, 0, 5  }, /* #81 */
    { 0x3c0957, 0x3c0957, 0xbdf2, 0xbe57, 0, 5  }, /* #81 b */
    { 0x0c2387, 0x0c2386, 0x01d0, 0x7400, 0, 38 }, /* #82 */
    { 0x335c52, 0x335452, 0x01d0, 0x7400, 0, 38 }, /* #82 b */
    { 0x094d82, 0x094d83, 0xb7d5, 0x7d5b, 0, 4  }, /* #83 */
    { 0x363257, 0x363a57, 0xb7d5, 0x7d5b, 0, 4  }, /* #83 b */
    { 0x051d87, 0x051d86, 0xb484, 0xd212, 0, 50 }, /* #84 */
    { 0x3a6252, 0x3a6a52, 0xb484, 0xd212, 0, 50 }, /* #84 b */
    { 0x0721c7, 0x0721c7, 0x0e72, 0xc839, 0, 58 }, /* #85 */
    { 0x385e12, 0x385613, 0x0e72, 0xc839, 0, 58 }, /* #85 b */
    { 0x2f0306, 0x2f0307, 0x3b7b, 0x9dbd, 0, 63 }, /* #86 */
    { 0x107cd3, 0x1074d3, 0x3b7b, 0x9dbd, 0, 63 }, /* #86 b */
    { 0x3f6583, 0x3f6d83, 0x7bdb, 0x7b6f, 0, 5  }, /* #87 */
    { 0x001a56, 0x001a57, 0x7bdb, 0x7b6f, 0, 5  }, /* #87 b */
    { 0x262b93, 0x262b93, 0xbebe, 0xf5f5, 0, 27 }, /* #88 */
    { 0x195446, 0x195c47, 0xbebe, 0xf5f5, 0, 27 }, /* #88 b */
    { 0x0f4303, 0x0f4b03, 0x5843, 0x0d61, 0, 58 }, /* #89 */
    { 0x303cd6, 0x303cd7, 0x5843, 0x0d61, 0, 58 }, /* #89 b */
    { 0x3110c7, 0x3110c7, 0x0e62, 0x1073, 0, 11 }, /* #90 */
    { 0x0e6f12, 0x0e6713, 0x0e62, 0x1073, 0, 11 }, /* #90 b */
    { 0x055f56, 0x055757, 0xe01f, 0xe01f, 0, 48 }, /* #91 */
    { 0x3a2083, 0x3a2083, 0xe01f, 0xe01f, 0, 48 }, /* #91 b */
    { 0x064116, 0x064917, 0x8935, 0x3589, 0, 8  }, /* #92 */
    { 0x393ec3, 0x393ec3, 0x8935, 0x3589, 0, 8  }, /* #92 b */
    { 0x2c5943, 0x2c5142, 0xf68a, 0x57b4, 0, 11 }, /* #93 */
    { 0x132696, 0x132696, 0xf68a, 0x57b4, 0, 11 }, /* #93 b */
    { 0x0e27c6, 0x0e27c6, 0xcca7, 0xf994, 0, 61 }, /* #94 */
    { 0x315813, 0x315012, 0xcca7, 0xf994, 0, 61 }, /* #94 b */
    { 0x042687, 0x042e86, 0xb04f, 0x9f60, 0, 41 }, /* #95 */
    { 0x3b5952, 0x3b5952, 0xb04f, 0x9f60, 0, 41 }, /* #95 b */
};
uint32_t const g_cTests_rol_u16_intel = RT_ELEMENTS(g_aTests_rol_u16_intel);

BINU16_TEST_T const g_aTests_ror_u16_intel[] =
{
    { 0x1a2782, 0x1a2782, 0x0000, 0x0000, 0, 42 }, /* #0 */
    { 0x255857, 0x255056, 0x0000, 0x0000, 0, 42 }, /* #0 b */
    { 0x3d38d6, 0x3d30d6, 0x0000, 0x0000, 0, 33 }, /* #1 */
    { 0x024703, 0x024702, 0x0000, 0x0000, 0, 33 }, /* #1 b */
    { 0x395e46, 0x395646, 0x0000, 0x0000, 0, 14 }, /* #2 */
    { 0x062193, 0x062192, 0x0000, 0x0000, 0, 14 }, /* #2 b */
    { 0x264792, 0x264792, 0x0000, 0x0000, 0, 40 }, /* #3 */
    { 0x193847, 0x193046, 0x0000, 0x0000, 0, 40 }, /* #3 b */
    { 0x2a6ed3, 0x2a6ed3, 0x0000, 0x0000, 0, 32 }, /* #4 */
    { 0x151106, 0x151106, 0x0000, 0x0000, 0, 32 }, /* #4 b */
    { 0x106992, 0x106192, 0x0000, 0x0000, 0, 31 }, /* #5 */
    { 0x2f1647, 0x2f1646, 0x0000, 0x0000, 0, 31 }, /* #5 b */
    { 0x126103, 0x126903, 0x0c5d, 0x862e, 0, 33 }, /* #6 */
    { 0x2d1ed6, 0x2d1ed7, 0x0c5d, 0x862e, 0, 33 }, /* #6 b */
    { 0x2e4616, 0x2e4616, 0x5140, 0x4051, 0, 40 }, /* #7 */
    { 0x1139c3, 0x1131c2, 0x5140, 0x4051, 0, 40 }, /* #7 b */
    { 0x1a1c83, 0x1a1483, 0x4e1e, 0x9387, 0, 18 }, /* #8 */
    { 0x256356, 0x256357, 0x4e1e, 0x9387, 0, 18 }, /* #8 b */
    { 0x2c4b07, 0x2c4b07, 0xb5e6, 0xd6bc, 0, 3  }, /* #9 */
    { 0x1334d2, 0x133cd3, 0xb5e6, 0xd6bc, 0, 3  }, /* #9 b */
    { 0x2d0517, 0x2d0d17, 0x8d78, 0xe235, 0, 38 }, /* #10 */
    { 0x127ac2, 0x127ac3, 0x8d78, 0xe235, 0, 38 }, /* #10 b */
    { 0x250c92, 0x250c93, 0x5133, 0x899a, 0, 61 }, /* #11 */
    { 0x1a7347, 0x1a7b47, 0x5133, 0x899a, 0, 61 }, /* #11 b */
    { 0x3e3517, 0x3e3516, 0x6472, 0x2647, 0, 20 }, /* #12 */
    { 0x014ac2, 0x0142c2, 0x6472, 0x2647, 0, 20 }, /* #12 b */
    { 0x1e0347, 0x1e0b47, 0xc52c, 0xcc52, 0, 4  }, /* #13 */
    { 0x217c92, 0x217c93, 0xc52c, 0xcc52, 0, 4  }, /* #13 b */
    { 0x2f3592, 0x2f3593, 0x1634, 0xd058, 0, 6  }, /* #14 */
    { 0x104a47, 0x104247, 0x1634, 0xd058, 0, 6  }, /* #14 b */
    { 0x1f44c6, 0x1f4cc7, 0xf4da, 0x9b5e, 0, 27 }, /* #15 */
    { 0x203b13, 0x203b13, 0xf4da, 0x9b5e, 0, 27 }, /* #15 b */
    { 0x3a1686, 0x3a1e86, 0x0e3f, 0x71f8, 0, 29 }, /* #16 */
    { 0x056953, 0x056952, 0x0e3f, 0x71f8, 0, 29 }, /* #16 b */
    { 0x2b0593, 0x2b0d92, 0xa088, 0x1411, 0, 51 }, /* #17 */
    { 0x147a46, 0x147a46, 0xa088, 0x1411, 0, 51 }, /* #17 b */
    { 0x077ac3, 0x077ac3, 0xd9ee, 0x9eed, 0, 12 }, /* #18 */
    { 0x380516, 0x380d17, 0xd9ee, 0x9eed, 0, 12 }, /* #18 b */
    { 0x0247c2, 0x0247c2, 0xdc8d, 0x7723, 0, 34 }, /* #19 */
    { 0x3d3817, 0x3d3016, 0xdc8d, 0x7723, 0, 34 }, /* #19 b */
    { 0x127a93, 0x127a92, 0xb404, 0x404b, 0, 28 }, /* #20 */
    { 0x2d0546, 0x2d0d46, 0xb404, 0x404b, 0, 28 }, /* #20 b */
    { 0x0f2c87, 0x0f2c86, 0x5d57, 0x75d5, 0, 52 }, /* #21 */
    { 0x305352, 0x305b52, 0x5d57, 0x75d5, 0, 52 }, /* #21 b */
    { 0x162346, 0x162347, 0x8ed7, 0xaf1d, 0, 23 }, /* #22 */
    { 0x295c93, 0x295493, 0x8ed7, 0xaf1d, 0, 23 }, /* #22 b */
    { 0x125043, 0x125843, 0xfb78, 0xf1f6, 0, 55 }, /* #23 */
    { 0x2d2f96, 0x2d2f97, 0xfb78, 0xf1f6, 0, 55 }, /* #23 b */
    { 0x0d0b46, 0x0d0347, 0xba87, 0xa87b, 0, 60 }, /* #24 */
    { 0x327493, 0x327493, 0xba87, 0xa87b, 0, 60 }, /* #24 b */
    { 0x224942, 0x224943, 0x6f75, 0xeade, 0, 39 }, /* #25 */
    { 0x1d3697, 0x1d3e97, 0x6f75, 0xeade, 0, 39 }, /* #25 b */
    { 0x323456, 0x323457, 0x5d92, 0xec92, 0, 13 }, /* #26 */
    { 0x0d4b83, 0x0d4383, 0x5d92, 0xec92, 0, 13 }, /* #26 b */
    { 0x312e16, 0x312e17, 0x965a, 0x965a, 0, 48 }, /* #27 */
    { 0x0e51c3, 0x0e59c3, 0x965a, 0x965a, 0, 48 }, /* #27 b */
    { 0x1021c7, 0x1021c7, 0xf511, 0xa88f, 0, 45 }, /* #28 */
    { 0x2f5e12, 0x2f5613, 0xf511, 0xa88f, 0, 45 }, /* #28 b */
    { 0x2864c2, 0x2864c3, 0x75aa, 0xd6a9, 0, 14 }, /* #29 */
    { 0x171b17, 0x171317, 0x75aa, 0xd6a9, 0, 14 }, /* #29 b */
    { 0x074887, 0x074086, 0x9d87, 0x61e7, 0, 26 }, /* #30 */
    { 0x383752, 0x383752, 0x9d87, 0x61e7, 0, 26 }, /* #30 b */
    { 0x330e93, 0x330692, 0x7712, 0x1277, 0, 8  }, /* #31 */
    { 0x0c7146, 0x0c7146, 0x7712, 0x1277, 0, 8  }, /* #31 b */
    { 0x2e3116, 0x2e3116, 0x1514, 0x2a28, 0, 63 }, /* #32 */
    { 0x114ec3, 0x1146c2, 0x1514, 0x2a28, 0, 63 }, /* #32 b */
    { 0x292d83, 0x292583, 0x944b, 0xe512, 0, 2  }, /* #33 */
    { 0x165256, 0x165257, 0x944b, 0xe512, 0, 2  }, /* #33 b */
    { 0x357b96, 0x357396, 0x29ea, 0x14f5, 0, 17 }, /* #34 */
    { 0x0a0443, 0x0a0442, 0x29ea, 0x14f5, 0, 17 }, /* #34 b */
    { 0x3a5057, 0x3a5057, 0x3e2c, 0xf8b0, 0, 30 }, /* #35 */
    { 0x052f82, 0x052783, 0x3e2c, 0xf8b0, 0, 30 }, /* #35 b */
    { 0x121c16, 0x121c17, 0x67f9, 0xb3fc, 0, 49 }, /* #36 */
    { 0x2d63c3, 0x2d6bc3, 0x67f9, 0xb3fc, 0, 49 }, /* #36 b */
    { 0x2164d3, 0x2164d3, 0x7b94, 0xdca3, 0, 13 }, /* #37 */
    { 0x1e1b06, 0x1e1307, 0x7b94, 0xdca3, 0, 13 }, /* #37 b */
    { 0x006703, 0x006702, 0xf553, 0x4fd5, 0, 6  }, /* #38 */
    { 0x3f18d6, 0x3f10d6, 0xf553, 0x4fd5, 0, 6  }, /* #38 b */
    { 0x210e83, 0x210e83, 0x3b1b, 0xd8d9, 0, 45 }, /* #39 */
    { 0x1e7156, 0x1e7957, 0x3b1b, 0xd8d9, 0, 45 }, /* #39 b */
    { 0x020a83, 0x020282, 0x997f, 0x5fe6, 0, 42 }, /* #40 */
    { 0x3d7556, 0x3d7556, 0x997f, 0x5fe6, 0, 42 }, /* #40 b */
    { 0x3246d3, 0x3246d2, 0x0f6c, 0x07b6, 0, 49 }, /* #41 */
    { 0x0d3906, 0x0d3106, 0x0f6c, 0x07b6, 0, 49 }, /* #41 b */
    { 0x2514d2, 0x2514d2, 0x3d16, 0x7a2c, 0, 31 }, /* #42 */
    { 0x1a6b07, 0x1a6306, 0x3d16, 0x7a2c, 0, 31 }, /* #42 b */
    { 0x1947c3, 0x194fc2, 0x9178, 0x2f12, 0, 11 }, /* #43 */
    { 0x263816, 0x263816, 0x9178, 0x2f12, 0, 11 }, /* #43 b */
    { 0x354807, 0x354806, 0xe184, 0x6138, 0, 58 }, /* #44 */
    { 0x0a37d2, 0x0a3fd2, 0xe184, 0x6138, 0, 58 }, /* #44 b */
    { 0x3b2e92, 0x3b2693, 0xcd67, 0x9acf, 0, 63 }, /* #45 */
    { 0x045147, 0x045147, 0xcd67, 0x9acf, 0, 63 }, /* #45 b */
    { 0x053c43, 0x053443, 0x9e7d, 0xf3ec, 0, 45 }, /* #46 */
    { 0x3a4396, 0x3a4397, 0x9e7d, 0xf3ec, 0, 45 }, /* #46 b */
    { 0x023046, 0x023046, 0xe767, 0x3b3f, 0, 45 }, /* #47 */
    { 0x3d4f93, 0x3d4792, 0xe767, 0x3b3f, 0, 45 }, /* #47 b */
    { 0x0a50d3, 0x0a58d3, 0x0227, 0xe044, 0, 3  }, /* #48 */
    { 0x352f06, 0x352f07, 0x0227, 0xe044, 0, 3  }, /* #48 b */
    { 0x1224c3, 0x122cc3, 0xcc30, 0xc30c, 0, 12 }, /* #49 */
    { 0x2d5b16, 0x2d5b17, 0xcc30, 0xc30c, 0, 12 }, /* #49 b */
    { 0x304b06, 0x304307, 0xde3f, 0x8ff7, 0, 26 }, /* #50 */
    { 0x0f34d3, 0x0f34d3, 0xde3f, 0x8ff7, 0, 26 }, /* #50 b */
    { 0x335697, 0x335e96, 0xd642, 0x642d, 0, 44 }, /* #51 */
    { 0x0c2942, 0x0c2942, 0xd642, 0x642d, 0, 44 }, /* #51 b */
    { 0x312942, 0x312142, 0x0540, 0x00a8, 0, 51 }, /* #52 */
    { 0x0e5697, 0x0e5696, 0x0540, 0x00a8, 0, 51 }, /* #52 b */
    { 0x124f57, 0x124757, 0x88e3, 0x8e38, 0, 12 }, /* #53 */
    { 0x2d3082, 0x2d3083, 0x88e3, 0x8e38, 0, 12 }, /* #53 b */
    { 0x184b12, 0x184312, 0xad09, 0x4d68, 0, 37 }, /* #54 */
    { 0x2734c7, 0x2734c6, 0xad09, 0x4d68, 0, 37 }, /* #54 b */
    { 0x0b4ad6, 0x0b42d6, 0x4022, 0x0890, 0, 26 }, /* #55 */
    { 0x343503, 0x343502, 0x4022, 0x0890, 0, 26 }, /* #55 b */
    { 0x377452, 0x377c52, 0xf040, 0x081e, 0, 43 }, /* #56 */
    { 0x080b87, 0x080b86, 0xf040, 0x081e, 0, 43 }, /* #56 b */
    { 0x296817, 0x296017, 0xb6ab, 0xdb55, 0, 49 }, /* #57 */
    { 0x1617c2, 0x1617c3, 0xb6ab, 0xdb55, 0, 49 }, /* #57 b */
    { 0x1b00c7, 0x1b08c7, 0x2fc1, 0xe097, 0, 25 }, /* #58 */
    { 0x247f12, 0x247f13, 0x2fc1, 0xe097, 0, 25 }, /* #58 b */
    { 0x255f16, 0x255717, 0x05e8, 0xe805, 0, 40 }, /* #59 */
    { 0x1a20c3, 0x1a20c3, 0x05e8, 0xe805, 0, 40 }, /* #59 b */
    { 0x1a5393, 0x1a5392, 0x84f1, 0x3c61, 0, 10 }, /* #60 */
    { 0x252c46, 0x252446, 0x84f1, 0x3c61, 0, 10 }, /* #60 b */
    { 0x156a02, 0x156203, 0xdfc7, 0xdfc7, 0, 16 }, /* #61 */
    { 0x2a15d7, 0x2a15d7, 0xdfc7, 0xdfc7, 0, 16 }, /* #61 b */
    { 0x0f4797, 0x0f4797, 0x46c2, 0x91b0, 0, 34 }, /* #62 */
    { 0x303842, 0x303043, 0x46c2, 0x91b0, 0, 34 }, /* #62 b */
    { 0x3260d3, 0x3268d3, 0x4f13, 0xc4d3, 0, 26 }, /* #63 */
    { 0x0d1f06, 0x0d1f07, 0x4f13, 0xc4d3, 0, 26 }, /* #63 b */
    { 0x296a96, 0x296a96, 0xc774, 0x74c7, 0, 8  }, /* #64 */
    { 0x161543, 0x161d42, 0xc774, 0x74c7, 0, 8  }, /* #64 b */
    { 0x0f5f47, 0x0f5747, 0xeabf, 0xaaff, 0, 14 }, /* #65 */
    { 0x302092, 0x302093, 0xeabf, 0xaaff, 0, 14 }, /* #65 b */
    { 0x0e38c2, 0x0e38c2, 0x50c7, 0x50c7, 0, 16 }, /* #66 */
    { 0x314717, 0x314f16, 0x50c7, 0x50c7, 0, 16 }, /* #66 b */
    { 0x0a0847, 0x0a0846, 0xfe9e, 0x7f4f, 0, 17 }, /* #67 */
    { 0x357792, 0x357f92, 0xfe9e, 0x7f4f, 0, 17 }, /* #67 b */
    { 0x0d64d3, 0x0d6cd3, 0xc3fa, 0xfd61, 0, 57 }, /* #68 */
    { 0x321b06, 0x321b07, 0xc3fa, 0xfd61, 0, 57 }, /* #68 b */
    { 0x183c86, 0x183486, 0x34ba, 0x4ba3, 0, 28 }, /* #69 */
    { 0x274353, 0x274352, 0x34ba, 0x4ba3, 0, 28 }, /* #69 b */
    { 0x3f1a03, 0x3f1a02, 0x6223, 0x446c, 0, 11 }, /* #70 */
    { 0x0065d6, 0x006dd6, 0x6223, 0x446c, 0, 11 }, /* #70 b */
    { 0x124a56, 0x124a57, 0x479d, 0xa3ce, 0, 33 }, /* #71 */
    { 0x2d3583, 0x2d3d83, 0x479d, 0xa3ce, 0, 33 }, /* #71 b */
    { 0x201006, 0x201807, 0xa242, 0xa242, 0, 48 }, /* #72 */
    { 0x1f6fd3, 0x1f6fd3, 0xa242, 0xa242, 0, 48 }, /* #72 b */
    { 0x1b1347, 0x1b1346, 0xbc8b, 0x45de, 0, 25 }, /* #73 */
    { 0x246c92, 0x246492, 0xbc8b, 0x45de, 0, 25 }, /* #73 b */
    { 0x102556, 0x102556, 0xc781, 0xc781, 0, 32 }, /* #74 */
    { 0x2f5a83, 0x2f5a83, 0xc781, 0xc781, 0, 32 }, /* #74 b */
    { 0x1b1043, 0x1b1042, 0x97d5, 0x65f5, 0, 2  }, /* #75 */
    { 0x246f96, 0x246796, 0x97d5, 0x65f5, 0, 2  }, /* #75 b */
    { 0x031a13, 0x031a12, 0xcf5a, 0x3d6b, 0, 14 }, /* #76 */
    { 0x3c65c6, 0x3c6dc6, 0xcf5a, 0x3d6b, 0, 14 }, /* #76 b */
    { 0x221e03, 0x221e03, 0x17ed, 0xa2fd, 0, 3  }, /* #77 */
    { 0x1d61d6, 0x1d69d7, 0x17ed, 0xa2fd, 0, 3  }, /* #77 b */
    { 0x2f1442, 0x2f1c43, 0x1701, 0xb808, 0, 13 }, /* #78 */
    { 0x106b97, 0x106b97, 0x1701, 0xb808, 0, 13 }, /* #78 b */
    { 0x253e13, 0x253e13, 0x5be3, 0xadf1, 0, 49 }, /* #79 */
    { 0x1a41c6, 0x1a49c7, 0x5be3, 0xadf1, 0, 49 }, /* #79 b */
    { 0x236b42, 0x236b43, 0xff24, 0xf24f, 0, 28 }, /* #80 */
    { 0x1c1497, 0x1c1c97, 0xff24, 0xf24f, 0, 28 }, /* #80 b */
    { 0x306f06, 0x306707, 0x8acb, 0xacb8, 0, 60 }, /* #81 */
    { 0x0f10d3, 0x0f10d3, 0x8acb, 0xacb8, 0, 60 }, /* #81 b */
    { 0x200a06, 0x200206, 0xba71, 0x374e, 0, 19 }, /* #82 */
    { 0x1f75d3, 0x1f75d2, 0xba71, 0x374e, 0, 19 }, /* #82 b */
    { 0x1a3a57, 0x1a3257, 0x52d4, 0xa296, 0, 5  }, /* #83 */
    { 0x254582, 0x254583, 0x52d4, 0xa296, 0, 5  }, /* #83 b */
    { 0x0a6f87, 0x0a6f86, 0x0be1, 0x217c, 0, 51 }, /* #84 */
    { 0x351052, 0x351852, 0x0be1, 0x217c, 0, 51 }, /* #84 b */
    { 0x160ad6, 0x160ad7, 0x51a3, 0xd1a8, 0, 57 }, /* #85 */
    { 0x297503, 0x297d03, 0x51a3, 0xd1a8, 0, 57 }, /* #85 b */
    { 0x115983, 0x115182, 0x3066, 0x6306, 0, 36 }, /* #86 */
    { 0x2e2656, 0x2e2656, 0x3066, 0x6306, 0, 36 }, /* #86 b */
    { 0x0a6e03, 0x0a6e03, 0x500f, 0xea01, 0, 19 }, /* #87 */
    { 0x3511d6, 0x3519d7, 0x500f, 0xea01, 0, 19 }, /* #87 b */
    { 0x3305d3, 0x3305d3, 0x74f6, 0xb3a7, 0, 53 }, /* #88 */
    { 0x0c7a06, 0x0c7207, 0x74f6, 0xb3a7, 0, 53 }, /* #88 b */
    { 0x333c46, 0x333447, 0x02f6, 0xd80b, 0, 54 }, /* #89 */
    { 0x0c4393, 0x0c4393, 0x02f6, 0xd80b, 0, 54 }, /* #89 b */
    { 0x3b0842, 0x3b0042, 0x0106, 0x0c02, 0, 23 }, /* #90 */
    { 0x047797, 0x047796, 0x0106, 0x0c02, 0, 23 }, /* #90 b */
    { 0x2b09d3, 0x2b09d3, 0x9627, 0x9627, 0, 32 }, /* #91 */
    { 0x147606, 0x147606, 0x9627, 0x9627, 0, 32 }, /* #91 b */
    { 0x345b12, 0x345312, 0xc4d5, 0x5c4d, 0, 4  }, /* #92 */
    { 0x0b24c7, 0x0b24c6, 0xc4d5, 0x5c4d, 0, 4  }, /* #92 b */
    { 0x210bc3, 0x2103c2, 0xc159, 0x382b, 0, 35 }, /* #93 */
    { 0x1e7416, 0x1e7416, 0xc159, 0x382b, 0, 35 }, /* #93 b */
    { 0x0a3c53, 0x0a3453, 0xb597, 0xf6b2, 0, 19 }, /* #94 */
    { 0x354386, 0x354387, 0xb597, 0xf6b2, 0, 19 }, /* #94 b */
    { 0x3b0d13, 0x3b0512, 0xe851, 0x28f4, 0, 41 }, /* #95 */
    { 0x0472c6, 0x0472c6, 0xe851, 0x28f4, 0, 41 }, /* #95 b */
};
uint32_t const g_cTests_ror_u16_intel = RT_ELEMENTS(g_aTests_ror_u16_intel);

BINU16_TEST_T const g_aTests_rcl_u16_intel[] =
{
    { 0x204fc3, 0x2047c2, 0x0000, 0x2000, 0, 31 }, /* #0 */
    { 0x1f3016, 0x1f3016, 0x0000, 0x0000, 0, 31 }, /* #0 b */
    { 0x123813, 0x123012, 0x0000, 0x0080, 0, 25 }, /* #1 */
    { 0x2d47c6, 0x2d47c6, 0x0000, 0x0000, 0, 25 }, /* #1 b */
    { 0x085712, 0x085712, 0x0000, 0x0000, 0, 62 }, /* #2 */
    { 0x3728c7, 0x3720c6, 0x0000, 0x1000, 0, 62 }, /* #2 b */
    { 0x075246, 0x075246, 0x0000, 0x0000, 0, 4  }, /* #3 */
    { 0x382d93, 0x382592, 0x0000, 0x0008, 0, 4  }, /* #3 b */
    { 0x282e93, 0x282692, 0x0000, 0x0008, 0, 36 }, /* #4 */
    { 0x175146, 0x175146, 0x0000, 0x0000, 0, 36 }, /* #4 b */
    { 0x097296, 0x097296, 0x0000, 0x0000, 0, 51 }, /* #5 */
    { 0x360d43, 0x360542, 0x0000, 0x0002, 0, 51 }, /* #5 b */
    { 0x274c96, 0x274496, 0x23ba, 0x11dd, 0, 48 }, /* #6 */
    { 0x183343, 0x183342, 0x23ba, 0x91dd, 0, 48 }, /* #6 b */
    { 0x035087, 0x035886, 0x95eb, 0x57af, 0, 2  }, /* #7 */
    { 0x3c2f52, 0x3c2f52, 0x95eb, 0x57ad, 0, 2  }, /* #7 b */
    { 0x055b53, 0x055b52, 0x70ba, 0xeae1, 0, 42 }, /* #8 */
    { 0x3a2486, 0x3a2c86, 0x70ba, 0xe8e1, 0, 42 }, /* #8 b */
    { 0x1b38c2, 0x1b38c3, 0x44b2, 0x2c88, 0, 55 }, /* #9 */
    { 0x244717, 0x244f17, 0x44b2, 0x2ca8, 0, 55 }, /* #9 b */
    { 0x375352, 0x375353, 0x3817, 0x02e3, 0, 37 }, /* #10 */
    { 0x082c87, 0x082487, 0x3817, 0x02f3, 0, 37 }, /* #10 b */
    { 0x1768c6, 0x1760c7, 0x08ac, 0x1580, 0, 37 }, /* #11 */
    { 0x281713, 0x281713, 0x08ac, 0x1590, 0, 37 }, /* #11 b */
    { 0x0910c3, 0x0918c2, 0x81ca, 0xac0e, 0, 29 }, /* #12 */
    { 0x366f16, 0x366f16, 0x81ca, 0xa40e, 0, 29 }, /* #12 b */
    { 0x002053, 0x002852, 0x83ea, 0x1f56, 0, 35 }, /* #13 */
    { 0x3f5f86, 0x3f5f86, 0x83ea, 0x1f52, 0, 35 }, /* #13 b */
    { 0x214d96, 0x214d97, 0x6d84, 0x086d, 0, 58 }, /* #14 */
    { 0x1e3243, 0x1e3a43, 0x6d84, 0x096d, 0, 58 }, /* #14 b */
    { 0x122512, 0x122512, 0xfcd1, 0x5f9a, 0, 31 }, /* #15 */
    { 0x2d5ac7, 0x2d52c6, 0xfcd1, 0x7f9a, 0, 31 }, /* #15 b */
    { 0x256747, 0x256f46, 0x45a3, 0x5a3a, 0, 53 }, /* #16 */
    { 0x1a1892, 0x1a1892, 0x45a3, 0x5a32, 0, 53 }, /* #16 b */
    { 0x344b83, 0x344383, 0x1e21, 0xe218, 0, 21 }, /* #17 */
    { 0x0b3456, 0x0b3457, 0x1e21, 0xe210, 0, 21 }, /* #17 b */
    { 0x066b93, 0x066392, 0xdb8e, 0x3bb7, 0, 10 }, /* #18 */
    { 0x391446, 0x391446, 0xdb8e, 0x39b7, 0, 10 }, /* #18 b */
    { 0x2b50c7, 0x2b58c7, 0x9570, 0x570c, 0, 21 }, /* #19 */
    { 0x142f12, 0x142f13, 0x9570, 0x5704, 0, 21 }, /* #19 b */
    { 0x0c4c03, 0x0c4403, 0x23bb, 0xbb91, 0, 8  }, /* #20 */
    { 0x3333d6, 0x3333d7, 0x23bb, 0xbb11, 0, 8  }, /* #20 b */
    { 0x273cc3, 0x273cc2, 0xa581, 0x0e96, 0, 60 }, /* #21 */
    { 0x184316, 0x184b16, 0xa581, 0x0a96, 0, 60 }, /* #21 b */
    { 0x0c7c46, 0x0c7c47, 0xbeda, 0xdb4b, 0, 5  }, /* #22 */
    { 0x330393, 0x330b93, 0xbeda, 0xdb5b, 0, 5  }, /* #22 b */
    { 0x252c46, 0x252447, 0xf33f, 0x3f79, 0, 25 }, /* #23 */
    { 0x1a5393, 0x1a5393, 0xf33f, 0x3ff9, 0, 25 }, /* #23 b */
    { 0x035886, 0x035886, 0x4c9b, 0x64d9, 0, 3  }, /* #24 */
    { 0x3c2753, 0x3c2f52, 0x4c9b, 0x64dd, 0, 3  }, /* #24 b */
    { 0x227792, 0x227f92, 0xa40a, 0x9481, 0, 63 }, /* #25 */
    { 0x1d0847, 0x1d0846, 0xa40a, 0xb481, 0, 63 }, /* #25 b */
    { 0x2a2897, 0x2a2097, 0x389b, 0x3738, 0, 9  }, /* #26 */
    { 0x155742, 0x155743, 0x389b, 0x3638, 0, 9  }, /* #26 b */
    { 0x2e3e82, 0x2e3682, 0x1483, 0x30a4, 0, 12 }, /* #27 */
    { 0x114157, 0x114156, 0x1483, 0x38a4, 0, 12 }, /* #27 b */
    { 0x047792, 0x047f92, 0xa591, 0x9645, 0, 2  }, /* #28 */
    { 0x3b0847, 0x3b0846, 0xa591, 0x9647, 0, 2  }, /* #28 b */
    { 0x3c4dc3, 0x3c4dc2, 0x8255, 0x12ae, 0, 3  }, /* #29 */
    { 0x033216, 0x033a16, 0x8255, 0x12aa, 0, 3  }, /* #29 b */
    { 0x151197, 0x151197, 0x9b98, 0x9b98, 0, 17 }, /* #30 */
    { 0x2a6e42, 0x2a6e42, 0x9b98, 0x9b98, 0, 17 }, /* #30 b */
    { 0x076607, 0x076607, 0x2d24, 0x25a4, 0, 31 }, /* #31 */
    { 0x3819d2, 0x3811d3, 0x2d24, 0x05a4, 0, 31 }, /* #31 b */
    { 0x3c4956, 0x3c4156, 0x0c4e, 0x189c, 0, 1  }, /* #32 */
    { 0x033683, 0x033682, 0x0c4e, 0x189d, 0, 1  }, /* #32 b */
    { 0x0a1dd7, 0x0a15d7, 0xfaa2, 0xaa2f, 0, 36 }, /* #33 */
    { 0x356202, 0x356203, 0xfaa2, 0xaa27, 0, 36 }, /* #33 b */
    { 0x1a6207, 0x1a6206, 0x1aba, 0x8d5d, 0, 16 }, /* #34 */
    { 0x251dd2, 0x2515d2, 0x1aba, 0x0d5d, 0, 16 }, /* #34 b */
    { 0x3e6256, 0x3e6a57, 0xb8e5, 0x8e55, 0, 53 }, /* #35 */
    { 0x011d83, 0x011d83, 0xb8e5, 0x8e5d, 0, 53 }, /* #35 b */
    { 0x147916, 0x147916, 0xac5a, 0xc5a5, 0, 53 }, /* #36 */
    { 0x2b06c3, 0x2b0ec2, 0xac5a, 0xc5ad, 0, 53 }, /* #36 b */
    { 0x1d3fc2, 0x1d3fc2, 0x9559, 0xaaca, 0, 20 }, /* #37 */
    { 0x224017, 0x224816, 0x9559, 0xaace, 0, 20 }, /* #37 b */
    { 0x221687, 0x221e87, 0x59ca, 0x2ab3, 0, 27 }, /* #38 */
    { 0x1d6952, 0x1d6953, 0x59ca, 0x28b3, 0, 27 }, /* #38 b */
    { 0x066446, 0x066446, 0xfce1, 0x17e7, 0, 29 }, /* #39 */
    { 0x391b93, 0x391392, 0xfce1, 0x1fe7, 0, 29 }, /* #39 b */
    { 0x3a7dd2, 0x3a7dd3, 0xb393, 0x59c9, 0, 48 }, /* #40 */
    { 0x050207, 0x050a07, 0xb393, 0xd9c9, 0, 48 }, /* #40 b */
    { 0x3f74d2, 0x3f7cd2, 0x6c70, 0x0d8e, 0, 63 }, /* #41 */
    { 0x000b07, 0x000b06, 0x6c70, 0x2d8e, 0, 63 }, /* #41 b */
    { 0x326982, 0x326182, 0x1a9e, 0x6a78, 0, 51 }, /* #42 */
    { 0x0d1657, 0x0d1656, 0x1a9e, 0x6a7a, 0, 51 }, /* #42 b */
    { 0x3a6d87, 0x3a6d87, 0xa3cc, 0x9a3c, 0, 62 }, /* #43 */
    { 0x051252, 0x051a53, 0xa3cc, 0x8a3c, 0, 62 }, /* #43 b */
    { 0x2a3197, 0x2a3996, 0x8a9d, 0x2a77, 0, 19 }, /* #44 */
    { 0x154e42, 0x154e42, 0x8a9d, 0x2a75, 0, 19 }, /* #44 b */
    { 0x2c3242, 0x2c3242, 0xe88c, 0x88c7, 0, 53 }, /* #45 */
    { 0x134d97, 0x134596, 0xe88c, 0x88cf, 0, 53 }, /* #45 b */
    { 0x0d1f52, 0x0d1f53, 0x6b52, 0xa91a, 0, 39 }, /* #46 */
    { 0x326087, 0x326887, 0x6b52, 0xa95a, 0, 39 }, /* #46 b */
    { 0x333106, 0x333907, 0x7e5d, 0xe5d3, 0, 53 }, /* #47 */
    { 0x0c4ed3, 0x0c4ed3, 0x7e5d, 0xe5db, 0, 53 }, /* #47 b */
    { 0x296a47, 0x296a47, 0x4fa6, 0xd353, 0, 24 }, /* #48 */
    { 0x161592, 0x161d93, 0x4fa6, 0xd313, 0, 24 }, /* #48 b */
    { 0x377742, 0x377f42, 0x567b, 0xcacf, 0, 63 }, /* #49 */
    { 0x080897, 0x080896, 0x567b, 0xeacf, 0, 63 }, /* #49 b */
    { 0x252c97, 0x252496, 0xccff, 0xffe6, 0, 8  }, /* #50 */
    { 0x1a5342, 0x1a5342, 0xccff, 0xff66, 0, 8  }, /* #50 b */
    { 0x3b6807, 0x3b6006, 0x1d94, 0xca47, 0, 24 }, /* #51 */
    { 0x0417d2, 0x0417d2, 0x1d94, 0xca07, 0, 24 }, /* #51 b */
    { 0x026cc6, 0x026cc7, 0x93ff, 0xfe93, 0, 41 }, /* #52 */
    { 0x3d1313, 0x3d1b13, 0x93ff, 0xff93, 0, 41 }, /* #52 b */
    { 0x123dc2, 0x1235c2, 0x3002, 0x8600, 0, 31 }, /* #53 */
    { 0x2d4217, 0x2d4216, 0x3002, 0xa600, 0, 31 }, /* #53 b */
    { 0x1242d2, 0x1242d3, 0x24f2, 0x093c, 0, 15 }, /* #54 */
    { 0x2d3d07, 0x2d3507, 0x24f2, 0x493c, 0, 15 }, /* #54 b */
    { 0x3a5392, 0x3a5392, 0xd0f2, 0xd0f2, 0, 17 }, /* #55 */
    { 0x052c47, 0x052c47, 0xd0f2, 0xd0f2, 0, 17 }, /* #55 b */
    { 0x094bd7, 0x094bd6, 0x9d2f, 0xbf3a, 0, 10 }, /* #56 */
    { 0x363402, 0x363c02, 0x9d2f, 0xbd3a, 0, 10 }, /* #56 b */
    { 0x0412d7, 0x0412d6, 0xf13b, 0x4efe, 0, 6  }, /* #57 */
    { 0x3b6d02, 0x3b6502, 0xf13b, 0x4ede, 0, 6  }, /* #57 b */
    { 0x0d7183, 0x0d7983, 0x99c0, 0x3381, 0, 33 }, /* #58 */
    { 0x320e56, 0x320e57, 0x99c0, 0x3380, 0, 33 }, /* #58 b */
    { 0x2977c6, 0x297fc7, 0x496e, 0x25b8, 0, 2  }, /* #59 */
    { 0x160813, 0x160813, 0x496e, 0x25ba, 0, 2  }, /* #59 b */
    { 0x1c6603, 0x1c6602, 0xc68a, 0xae34, 0, 29 }, /* #60 */
    { 0x2319d6, 0x2311d6, 0xc68a, 0xa634, 0, 29 }, /* #60 b */
    { 0x1c5593, 0x1c5d93, 0x8d8b, 0x1b17, 0, 1  }, /* #61 */
    { 0x232a46, 0x232a47, 0x8d8b, 0x1b16, 0, 1  }, /* #61 b */
    { 0x2b6806, 0x2b6807, 0x95b0, 0x6c12, 0, 38 }, /* #62 */
    { 0x1417d3, 0x141fd3, 0x95b0, 0x6c32, 0, 38 }, /* #62 b */
    { 0x0b0253, 0x0b0a52, 0x685f, 0x2fda, 0, 56 }, /* #63 */
    { 0x347d86, 0x347d86, 0x685f, 0x2f9a, 0, 56 }, /* #63 b */
    { 0x3c1703, 0x3c1f03, 0x632a, 0x558c, 0, 43 }, /* #64 */
    { 0x0368d6, 0x0368d7, 0x632a, 0x518c, 0, 43 }, /* #64 b */
    { 0x1b5ad2, 0x1b52d2, 0xc83d, 0xf590, 0, 59 }, /* #65 */
    { 0x242507, 0x242506, 0xc83d, 0xf790, 0, 59 }, /* #65 b */
    { 0x050f47, 0x050f47, 0x9807, 0xcc03, 0, 16 }, /* #66 */
    { 0x3a7092, 0x3a7893, 0x9807, 0x4c03, 0, 16 }, /* #66 b */
    { 0x226e43, 0x226643, 0x28ec, 0x4764, 0, 3  }, /* #67 */
    { 0x1d1196, 0x1d1197, 0x28ec, 0x4760, 0, 3  }, /* #67 b */
    { 0x182b83, 0x182b83, 0xd9cd, 0xd9cd, 0, 49 }, /* #68 */
    { 0x275456, 0x275456, 0xd9cd, 0xd9cd, 0, 49 }, /* #68 b */
    { 0x0b5156, 0x0b5157, 0xddc6, 0x719b, 0, 23 }, /* #69 */
    { 0x342e83, 0x342683, 0xddc6, 0x71bb, 0, 23 }, /* #69 b */
    { 0x145402, 0x145402, 0xee2d, 0x2d77, 0, 40 }, /* #70 */
    { 0x2b2bd7, 0x2b23d6, 0xee2d, 0x2df7, 0, 40 }, /* #70 b */
    { 0x0d73d3, 0x0d7bd3, 0xb36b, 0xecda, 0, 47 }, /* #71 */
    { 0x320c06, 0x320c07, 0xb36b, 0xacda, 0, 47 }, /* #71 b */
    { 0x2611c2, 0x2619c2, 0x6494, 0x50c9, 0, 42 }, /* #72 */
    { 0x196e17, 0x196e16, 0x6494, 0x52c9, 0, 42 }, /* #72 b */
    { 0x2966d3, 0x2966d2, 0xe7e9, 0x7cfd, 0, 31 }, /* #73 */
    { 0x161906, 0x161106, 0xe7e9, 0x5cfd, 0, 31 }, /* #73 b */
    { 0x250306, 0x250b07, 0x70a9, 0xc2a4, 0, 2  }, /* #74 */
    { 0x1a7cd3, 0x1a7cd3, 0x70a9, 0xc2a6, 0, 2  }, /* #74 b */
    { 0x084f02, 0x084703, 0xfc96, 0x259f, 0, 38 }, /* #75 */
    { 0x3730d7, 0x3730d7, 0xfc96, 0x25bf, 0, 38 }, /* #75 b */
    { 0x1e0e52, 0x1e0e53, 0x9088, 0x1090, 0, 26 }, /* #76 */
    { 0x217187, 0x217987, 0x9088, 0x1190, 0, 26 }, /* #76 b */
    { 0x305dd7, 0x3055d7, 0xc8b2, 0x9165, 0, 1  }, /* #77 */
    { 0x0f2202, 0x0f2203, 0xc8b2, 0x9164, 0, 1  }, /* #77 b */
    { 0x155297, 0x155a97, 0x6ef3, 0x9dbb, 0, 28 }, /* #78 */
    { 0x2a2d42, 0x2a2d43, 0x6ef3, 0x99bb, 0, 28 }, /* #78 b */
    { 0x341987, 0x341987, 0x81e9, 0x4e07, 0, 11 }, /* #79 */
    { 0x0b6652, 0x0b6e53, 0x81e9, 0x4a07, 0, 11 }, /* #79 b */
    { 0x2d7f13, 0x2d7712, 0x0cd2, 0x19a5, 0, 50 }, /* #80 */
    { 0x1200c6, 0x1200c6, 0x0cd2, 0x19a4, 0, 50 }, /* #80 b */
    { 0x3e3793, 0x3e3792, 0x3686, 0x34da, 0, 11 }, /* #81 */
    { 0x014846, 0x014046, 0x3686, 0x30da, 0, 11 }, /* #81 b */
    { 0x275012, 0x275813, 0xa41c, 0x0714, 0, 38 }, /* #82 */
    { 0x182fc7, 0x182fc7, 0xa41c, 0x0734, 0, 38 }, /* #82 b */
    { 0x2a2e02, 0x2a2e02, 0x6af7, 0xf735, 0, 57 }, /* #83 */
    { 0x1551d7, 0x1559d6, 0x6af7, 0xf7b5, 0, 57 }, /* #83 b */
    { 0x010913, 0x010113, 0xf4fc, 0xcfa7, 0, 29 }, /* #84 */
    { 0x3e76c6, 0x3e76c7, 0xf4fc, 0xc7a7, 0, 29 }, /* #84 b */
    { 0x090897, 0x090896, 0x85b0, 0xb618, 0, 54 }, /* #85 */
    { 0x367742, 0x367f42, 0x85b0, 0xb608, 0, 54 }, /* #85 b */
    { 0x165793, 0x165792, 0xe549, 0x9f2a, 0, 12 }, /* #86 */
    { 0x292846, 0x292046, 0xe549, 0x972a, 0, 12 }, /* #86 b */
    { 0x0764d6, 0x076cd6, 0x7db4, 0x87db, 0, 30 }, /* #87 */
    { 0x381b03, 0x381b02, 0x7db4, 0x97db, 0, 30 }, /* #87 b */
    { 0x366d93, 0x366593, 0xf8a7, 0xe29f, 0, 2  }, /* #88 */
    { 0x091246, 0x091247, 0xf8a7, 0xe29d, 0, 2  }, /* #88 b */
    { 0x315213, 0x315a12, 0x5710, 0x855c, 0, 11 }, /* #89 */
    { 0x0e2dc6, 0x0e2dc6, 0x5710, 0x815c, 0, 11 }, /* #89 b */
    { 0x0d7407, 0x0d7c07, 0x5b05, 0x05ad, 0, 8  }, /* #90 */
    { 0x320bd2, 0x320bd3, 0x5b05, 0x052d, 0, 8  }, /* #90 b */
    { 0x087e17, 0x087e17, 0x8ee1, 0xc770, 0, 48 }, /* #91 */
    { 0x3701c2, 0x3709c3, 0x8ee1, 0x4770, 0, 48 }, /* #91 b */
    { 0x0050d7, 0x0050d7, 0x2e52, 0x294b, 0, 24 }, /* #92 */
    { 0x3f2f02, 0x3f2703, 0x2e52, 0x290b, 0, 24 }, /* #92 b */
    { 0x242092, 0x242893, 0x4288, 0x0a20, 0, 51 }, /* #93 */
    { 0x1b5f47, 0x1b5f47, 0x4288, 0x0a22, 0, 51 }, /* #93 b */
    { 0x105216, 0x105217, 0xff42, 0xe84f, 0, 5  }, /* #94 */
    { 0x2f2dc3, 0x2f25c3, 0xff42, 0xe85f, 0, 5  }, /* #94 b */
    { 0x107456, 0x107457, 0x3d37, 0xe9b8, 0, 20 }, /* #95 */
    { 0x2f0b83, 0x2f0383, 0x3d37, 0xe9bc, 0, 20 }, /* #95 b */
};
uint32_t const g_cTests_rcl_u16_intel = RT_ELEMENTS(g_aTests_rcl_u16_intel);

BINU16_TEST_T const g_aTests_rcr_u16_intel[] =
{
    { 0x360393, 0x360b92, 0x0000, 0x1000, 0, 21 }, /* #0 */
    { 0x097c46, 0x097446, 0x0000, 0x0000, 0, 21 }, /* #0 b */
    { 0x345a42, 0x345242, 0x0000, 0x0000, 0, 8  }, /* #1 */
    { 0x0b2597, 0x0b2d96, 0x0000, 0x0100, 0, 8  }, /* #1 b */
    { 0x1c5983, 0x1c5982, 0x0000, 0x0200, 0, 7  }, /* #2 */
    { 0x232656, 0x232656, 0x0000, 0x0000, 0, 7  }, /* #2 b */
    { 0x3b0fc3, 0x3b0fc3, 0x0000, 0x0000, 0, 0  }, /* #3 */
    { 0x047016, 0x047016, 0x0000, 0x0000, 0, 0  }, /* #3 b */
    { 0x037102, 0x037102, 0x0000, 0x0000, 0, 12 }, /* #4 */
    { 0x3c0ed7, 0x3c0ed6, 0x0000, 0x0010, 0, 12 }, /* #4 b */
    { 0x053892, 0x053092, 0x0000, 0x0000, 0, 42 }, /* #5 */
    { 0x3a4747, 0x3a4f46, 0x0000, 0x0040, 0, 42 }, /* #5 b */
    { 0x063892, 0x063893, 0xc000, 0x0001, 0, 15 }, /* #6 */
    { 0x394747, 0x394747, 0xc000, 0x0003, 0, 15 }, /* #6 b */
    { 0x316983, 0x316982, 0x4482, 0x1512, 0, 6  }, /* #7 */
    { 0x0e1656, 0x0e1656, 0x4482, 0x1112, 0, 6  }, /* #7 b */
    { 0x0255c7, 0x025dc7, 0x0216, 0xa042, 0, 20 }, /* #8 */
    { 0x3d2a12, 0x3d2213, 0x0216, 0x8042, 0, 20 }, /* #8 b */
    { 0x2c0353, 0x2c0b53, 0x7a91, 0xbd48, 0, 33 }, /* #9 */
    { 0x137c86, 0x137487, 0x7a91, 0x3d48, 0, 33 }, /* #9 b */
    { 0x0f0302, 0x0f0302, 0x81c4, 0x81c4, 0, 32 }, /* #10 */
    { 0x307cd7, 0x307cd7, 0x81c4, 0x81c4, 0, 32 }, /* #10 b */
    { 0x2c4287, 0x2c4286, 0xd4aa, 0x955d, 0, 44 }, /* #11 */
    { 0x133d52, 0x133d52, 0xd4aa, 0x954d, 0, 44 }, /* #11 b */
    { 0x285e46, 0x285e46, 0xb67c, 0xcf8b, 0, 29 }, /* #12 */
    { 0x172193, 0x172192, 0xb67c, 0xcf9b, 0, 29 }, /* #12 b */
    { 0x370c96, 0x370c96, 0xbb7e, 0xedf9, 0, 15 }, /* #13 */
    { 0x087343, 0x087342, 0xbb7e, 0xedfb, 0, 15 }, /* #13 b */
    { 0x0d5d83, 0x0d5d83, 0x28c8, 0x9128, 0, 40 }, /* #14 */
    { 0x322256, 0x322257, 0x28c8, 0x9028, 0, 40 }, /* #14 b */
    { 0x177083, 0x177882, 0x2d33, 0xd339, 0, 62 }, /* #15 */
    { 0x280f56, 0x280756, 0x2d33, 0xd331, 0, 62 }, /* #15 b */
    { 0x157997, 0x157197, 0xaaef, 0xfaae, 0, 53 }, /* #16 */
    { 0x2a0642, 0x2a0e43, 0xaaef, 0xeaae, 0, 53 }, /* #16 b */
    { 0x116857, 0x116856, 0x2591, 0x464b, 0, 56 }, /* #17 */
    { 0x2e1782, 0x2e1782, 0x2591, 0x444b, 0, 56 }, /* #17 b */
    { 0x126d97, 0x126597, 0x9400, 0x2801, 0, 48 }, /* #18 */
    { 0x2d1242, 0x2d1a43, 0x9400, 0x2800, 0, 48 }, /* #18 b */
    { 0x213213, 0x213a12, 0x7d87, 0x3df6, 0, 38 }, /* #19 */
    { 0x1e4dc6, 0x1e45c6, 0x7d87, 0x39f6, 0, 38 }, /* #19 b */
    { 0x380943, 0x380142, 0xa919, 0xea46, 0, 19 }, /* #20 */
    { 0x077696, 0x077e96, 0xa919, 0xaa46, 0, 19 }, /* #20 b */
    { 0x143816, 0x143816, 0xee7a, 0x773d, 0, 18 }, /* #21 */
    { 0x2b47c3, 0x2b47c2, 0xee7a, 0xf73d, 0, 18 }, /* #21 b */
    { 0x0e3056, 0x0e3057, 0x197c, 0xe065, 0, 6  }, /* #22 */
    { 0x314f83, 0x314f83, 0x197c, 0xe465, 0, 6  }, /* #22 b */
    { 0x266207, 0x266207, 0x4e3e, 0x4e3e, 0, 17 }, /* #23 */
    { 0x191dd2, 0x191dd2, 0x4e3e, 0x4e3e, 0, 17 }, /* #23 b */
    { 0x2e0586, 0x2e0d87, 0xeb88, 0xc43a, 0, 42 }, /* #24 */
    { 0x117a53, 0x117253, 0xeb88, 0xc47a, 0, 42 }, /* #24 b */
    { 0x362d92, 0x362592, 0x71c4, 0x38e2, 0, 33 }, /* #25 */
    { 0x095247, 0x095a46, 0x71c4, 0xb8e2, 0, 33 }, /* #25 b */
    { 0x290a02, 0x290202, 0x6cfb, 0xcfb3, 0, 13 }, /* #26 */
    { 0x1675d7, 0x167dd6, 0x6cfb, 0xcfbb, 0, 13 }, /* #26 b */
    { 0x234256, 0x234257, 0x061b, 0x030d, 0, 1  }, /* #27 */
    { 0x1c3d83, 0x1c3d83, 0x061b, 0x830d, 0, 1  }, /* #27 b */
    { 0x034692, 0x034e93, 0xc555, 0x62aa, 0, 33 }, /* #28 */
    { 0x3c3947, 0x3c3147, 0xc555, 0xe2aa, 0, 33 }, /* #28 b */
    { 0x101ec2, 0x101ec2, 0xc2d3, 0x169b, 0, 63 }, /* #29 */
    { 0x2f6117, 0x2f6116, 0xc2d3, 0x169f, 0, 63 }, /* #29 b */
    { 0x227d82, 0x227582, 0x1853, 0x6185, 0, 4  }, /* #30 */
    { 0x1d0257, 0x1d0a56, 0x1853, 0x7185, 0, 4  }, /* #30 b */
    { 0x2a3492, 0x2a3493, 0x7d07, 0xcfa0, 0, 35 }, /* #31 */
    { 0x154b47, 0x154b47, 0x7d07, 0xefa0, 0, 35 }, /* #31 b */
    { 0x167f52, 0x167f52, 0x9902, 0x4990, 0, 53 }, /* #32 */
    { 0x290087, 0x290086, 0x9902, 0x5990, 0, 53 }, /* #32 b */
    { 0x086cc2, 0x0864c3, 0x7a5c, 0x0f4b, 0, 20 }, /* #33 */
    { 0x371317, 0x371b17, 0x7a5c, 0x2f4b, 0, 20 }, /* #33 b */
    { 0x3224d3, 0x3224d3, 0x68ca, 0x68ca, 0, 0  }, /* #34 */
    { 0x0d5b06, 0x0d5b06, 0x68ca, 0x68ca, 0, 0  }, /* #34 b */
    { 0x1663c2, 0x166bc3, 0x8da7, 0x4e8d, 0, 8  }, /* #35 */
    { 0x291c17, 0x291417, 0x8da7, 0x4f8d, 0, 8  }, /* #35 b */
    { 0x1d72c6, 0x1d72c6, 0x0071, 0x2007, 0, 4  }, /* #36 */
    { 0x220d13, 0x220d12, 0x0071, 0x3007, 0, 4  }, /* #36 b */
    { 0x3e4043, 0x3e4043, 0xa993, 0x5327, 0, 48 }, /* #37 */
    { 0x013f96, 0x013f97, 0xa993, 0x5326, 0, 48 }, /* #37 b */
    { 0x0c4e06, 0x0c4606, 0x063b, 0x7606, 0, 57 }, /* #38 */
    { 0x3331d3, 0x3339d2, 0x063b, 0x7706, 0, 57 }, /* #38 b */
    { 0x3c7447, 0x3c7446, 0xb519, 0x76a3, 0, 20 }, /* #39 */
    { 0x030b92, 0x030b92, 0xb519, 0x56a3, 0, 20 }, /* #39 b */
    { 0x0905d7, 0x090dd6, 0x3473, 0xd1ce, 0, 15 }, /* #40 */
    { 0x367a02, 0x367202, 0x3473, 0xd1cc, 0, 15 }, /* #40 b */
    { 0x287352, 0x287352, 0x4a31, 0x4946, 0, 52 }, /* #41 */
    { 0x170c87, 0x170c86, 0x4a31, 0x6946, 0, 52 }, /* #41 b */
    { 0x1b3f83, 0x1b3783, 0xca49, 0x493c, 0, 12 }, /* #42 */
    { 0x244056, 0x244857, 0xca49, 0x492c, 0, 12 }, /* #42 b */
    { 0x154406, 0x154c06, 0xddd4, 0xa377, 0, 38 }, /* #43 */
    { 0x2a3bd3, 0x2a33d2, 0xddd4, 0xa777, 0, 38 }, /* #43 b */
    { 0x382757, 0x382756, 0xb3ec, 0xcfb3, 0, 47 }, /* #44 */
    { 0x075882, 0x075882, 0xb3ec, 0xcfb1, 0, 47 }, /* #44 b */
    { 0x0f2886, 0x0f2087, 0x6fe4, 0xfc86, 0, 44 }, /* #45 */
    { 0x305753, 0x305f53, 0x6fe4, 0xfc96, 0, 44 }, /* #45 b */
    { 0x3d6b17, 0x3d6316, 0xebc6, 0xbc6f, 0, 13 }, /* #46 */
    { 0x0214c2, 0x021cc2, 0xebc6, 0xbc67, 0, 13 }, /* #46 b */
    { 0x3f1153, 0x3f1153, 0xd6f9, 0x3d6f, 0, 53 }, /* #47 */
    { 0x006e86, 0x006e87, 0xd6f9, 0x2d6f, 0, 53 }, /* #47 b */
    { 0x3f0e96, 0x3f0e97, 0xfc99, 0xc997, 0, 13 }, /* #48 */
    { 0x007143, 0x007143, 0xfc99, 0xc99f, 0, 13 }, /* #48 b */
    { 0x090bc6, 0x090bc6, 0x6649, 0x6649, 0, 0  }, /* #49 */
    { 0x367413, 0x367413, 0x6649, 0x6649, 0, 0  }, /* #49 b */
    { 0x0551d3, 0x0551d3, 0xc15e, 0xb82b, 0, 20 }, /* #50 */
    { 0x3a2e06, 0x3a2e07, 0xc15e, 0x982b, 0, 20 }, /* #50 b */
    { 0x366c96, 0x366c96, 0xef73, 0xddee, 0, 20 }, /* #51 */
    { 0x091343, 0x091342, 0xef73, 0xfdee, 0, 20 }, /* #51 b */
    { 0x210bd6, 0x210bd6, 0xa6b8, 0xe14d, 0, 7  }, /* #52 */
    { 0x1e7403, 0x1e7402, 0xa6b8, 0xe34d, 0, 7  }, /* #52 b */
    { 0x0d6587, 0x0d6587, 0xbc0d, 0x0377, 0, 28 }, /* #53 */
    { 0x321a52, 0x321a53, 0xbc0d, 0x0357, 0, 28 }, /* #53 b */
    { 0x091fc6, 0x0917c7, 0x5a06, 0x40c5, 0, 61 }, /* #54 */
    { 0x366013, 0x366813, 0x5a06, 0x40d5, 0, 61 }, /* #54 b */
    { 0x3a2f13, 0x3a2f13, 0x518c, 0x1951, 0, 8  }, /* #55 */
    { 0x0550c6, 0x0550c7, 0x518c, 0x1851, 0, 8  }, /* #55 b */
    { 0x1a4402, 0x1a4c03, 0xea9e, 0x53ce, 0, 61 }, /* #56 */
    { 0x253bd7, 0x2533d7, 0xea9e, 0x53de, 0, 61 }, /* #56 b */
    { 0x0f59d2, 0x0f51d3, 0x0296, 0x4b00, 0, 59 }, /* #57 */
    { 0x302607, 0x302e07, 0x0296, 0x4b40, 0, 59 }, /* #57 b */
    { 0x1546c3, 0x1546c3, 0xae23, 0xae23, 0, 17 }, /* #58 */
    { 0x2a3916, 0x2a3916, 0xae23, 0xae23, 0, 17 }, /* #58 b */
    { 0x2f5f53, 0x2f5f52, 0x7df1, 0x6fbe, 0, 35 }, /* #59 */
    { 0x102086, 0x102086, 0x7df1, 0x4fbe, 0, 35 }, /* #59 b */
    { 0x3352d3, 0x3352d3, 0xcafd, 0x95fb, 0, 48 }, /* #60 */
    { 0x0c2d06, 0x0c2d07, 0xcafd, 0x95fa, 0, 48 }, /* #60 b */
    { 0x084a52, 0x084a53, 0xbe97, 0xd2eb, 0, 29 }, /* #61 */
    { 0x373587, 0x373587, 0xbe97, 0xd2fb, 0, 29 }, /* #61 b */
    { 0x343f87, 0x343f86, 0x42f0, 0xf0a1, 0, 9  }, /* #62 */
    { 0x0b4052, 0x0b4052, 0x42f0, 0xf021, 0, 9  }, /* #62 b */
    { 0x385ac7, 0x385ac7, 0x5109, 0x5109, 0, 32 }, /* #63 */
    { 0x072512, 0x072512, 0x5109, 0x5109, 0, 32 }, /* #63 b */
    { 0x202cd6, 0x202cd6, 0x816d, 0x16d4, 0, 13 }, /* #64 */
    { 0x1f5303, 0x1f5302, 0x816d, 0x16dc, 0, 13 }, /* #64 b */
    { 0x306886, 0x306087, 0x2137, 0xc426, 0, 3  }, /* #65 */
    { 0x0f1753, 0x0f1f53, 0x2137, 0xe426, 0, 3  }, /* #65 b */
    { 0x151252, 0x151a52, 0xf72d, 0xd7b9, 0, 5  }, /* #66 */
    { 0x2a6d87, 0x2a6586, 0xf72d, 0xdfb9, 0, 5  }, /* #66 b */
    { 0x100e47, 0x100647, 0xbdee, 0xef76, 0, 31 }, /* #67 */
    { 0x2f7192, 0x2f7993, 0xbdee, 0xef72, 0, 31 }, /* #67 b */
    { 0x3d4d03, 0x3d4d02, 0x1700, 0x08b8, 0, 37 }, /* #68 */
    { 0x0232d6, 0x0232d6, 0x1700, 0x00b8, 0, 37 }, /* #68 b */
    { 0x224957, 0x224156, 0x9015, 0x5720, 0, 7  }, /* #69 */
    { 0x1d3682, 0x1d3e82, 0x9015, 0x5520, 0, 7  }, /* #69 b */
    { 0x022fc2, 0x0227c2, 0x1358, 0x6b01, 0, 44 }, /* #70 */
    { 0x3d5017, 0x3d5816, 0x1358, 0x6b11, 0, 44 }, /* #70 b */
    { 0x191b53, 0x191353, 0xe56e, 0x7795, 0, 38 }, /* #71 */
    { 0x266486, 0x266c87, 0xe56e, 0x7395, 0, 38 }, /* #71 b */
    { 0x3824c2, 0x382cc3, 0xbdad, 0x5abd, 0, 57 }, /* #72 */
    { 0x075b17, 0x075317, 0xbdad, 0x5bbd, 0, 57 }, /* #72 b */
    { 0x2a2e06, 0x2a2e07, 0xb8d8, 0x1b0b, 0, 12 }, /* #73 */
    { 0x1551d3, 0x1551d3, 0xb8d8, 0x1b1b, 0, 12 }, /* #73 b */
    { 0x3214d6, 0x321cd7, 0xa419, 0x9520, 0, 22 }, /* #74 */
    { 0x0d6b03, 0x0d6303, 0xa419, 0x9d20, 0, 22 }, /* #74 b */
    { 0x195253, 0x195252, 0xb5a6, 0x9b6b, 0, 7  }, /* #75 */
    { 0x262d86, 0x262d86, 0xb5a6, 0x996b, 0, 7  }, /* #75 b */
    { 0x2c7b06, 0x2c7b07, 0x8437, 0x0dd0, 0, 43 }, /* #76 */
    { 0x1304d3, 0x1304d3, 0x8437, 0x0df0, 0, 43 }, /* #76 b */
    { 0x3c4313, 0x3c4313, 0xecfb, 0x9f7e, 0, 61 }, /* #77 */
    { 0x033cc6, 0x033cc7, 0xecfb, 0x9f6e, 0, 61 }, /* #77 b */
    { 0x272983, 0x272182, 0x8506, 0x1b0a, 0, 39 }, /* #78 */
    { 0x185656, 0x185e56, 0x8506, 0x190a, 0, 39 }, /* #78 b */
    { 0x337f13, 0x337713, 0x9c9c, 0x3939, 0, 48 }, /* #79 */
    { 0x0c00c6, 0x0c08c7, 0x9c9c, 0x3938, 0, 48 }, /* #79 b */
    { 0x204553, 0x204552, 0x9139, 0x9ce4, 0, 10 }, /* #80 */
    { 0x1f3a86, 0x1f3a86, 0x9139, 0x9ca4, 0, 10 }, /* #80 b */
    { 0x320397, 0x320b97, 0x1045, 0x6208, 0, 20 }, /* #81 */
    { 0x0d7c42, 0x0d7443, 0x1045, 0x4208, 0, 20 }, /* #81 b */
    { 0x150202, 0x150a03, 0xdc43, 0xb710, 0, 51 }, /* #82 */
    { 0x2a7dd7, 0x2a75d7, 0xdc43, 0xf710, 0, 51 }, /* #82 b */
    { 0x0d2a42, 0x0d2243, 0x5d98, 0xb305, 0, 12 }, /* #83 */
    { 0x325597, 0x325d97, 0x5d98, 0xb315, 0, 12 }, /* #83 b */
    { 0x201112, 0x201912, 0xb713, 0xd6e2, 0, 20 }, /* #84 */
    { 0x1f6ec7, 0x1f66c6, 0xb713, 0xf6e2, 0, 20 }, /* #84 b */
    { 0x240217, 0x240a17, 0x223f, 0x1fc8, 0, 42 }, /* #85 */
    { 0x1b7dc2, 0x1b75c3, 0x223f, 0x1f88, 0, 42 }, /* #85 b */
    { 0x100097, 0x100896, 0x2f43, 0x72f4, 0, 4  }, /* #86 */
    { 0x2f7f42, 0x2f7742, 0x2f43, 0x62f4, 0, 4  }, /* #86 b */
    { 0x186d16, 0x186d16, 0xc42e, 0xb988, 0, 56 }, /* #87 */
    { 0x2712c3, 0x2712c2, 0xc42e, 0xbb88, 0, 56 }, /* #87 b */
    { 0x3a6c93, 0x3a6c92, 0x1dcf, 0x7c77, 0, 55 }, /* #88 */
    { 0x051346, 0x051346, 0x1dcf, 0x7877, 0, 55 }, /* #88 b */
    { 0x052e56, 0x052e56, 0xcb0a, 0xa658, 0, 5  }, /* #89 */
    { 0x3a5183, 0x3a5182, 0xcb0a, 0xae58, 0, 5  }, /* #89 b */
    { 0x1c5956, 0x1c5157, 0x4cf4, 0x3d09, 0, 43 }, /* #90 */
    { 0x232683, 0x232e83, 0x4cf4, 0x3d29, 0, 43 }, /* #90 b */
    { 0x3c78d6, 0x3c70d6, 0x42b4, 0xad08, 0, 11 }, /* #91 */
    { 0x030703, 0x030f02, 0x42b4, 0xad28, 0, 11 }, /* #91 b */
    { 0x0700c2, 0x0708c3, 0xb2f1, 0x78ac, 0, 59 }, /* #92 */
    { 0x387f17, 0x387717, 0xb2f1, 0x78ec, 0, 59 }, /* #92 b */
    { 0x063b13, 0x063b12, 0x457e, 0x57ea, 0, 45 }, /* #93 */
    { 0x3944c6, 0x3944c6, 0x457e, 0x57e2, 0, 45 }, /* #93 b */
    { 0x397a42, 0x397a42, 0xfa8b, 0x8b7d, 0, 26 }, /* #94 */
    { 0x060597, 0x060596, 0xfa8b, 0x8bfd, 0, 26 }, /* #94 b */
    { 0x263117, 0x263117, 0xf421, 0x087e, 0, 11 }, /* #95 */
    { 0x194ec2, 0x194ec3, 0xf421, 0x085e, 0, 11 }, /* #95 b */
};
uint32_t const g_cTests_rcr_u16_intel = RT_ELEMENTS(g_aTests_rcr_u16_intel);

BINU16_TEST_T const g_aTests_shl_u16_intel[] =
{
    { 0x3a7717, 0x3a7746, 0x0000, 0x0000, 0, 60 }, /* #0 */
    { 0x0508c2, 0x050046, 0x0000, 0x0000, 0, 60 }, /* #0 b */
    { 0x337903, 0x337146, 0x0000, 0x0000, 0, 62 }, /* #1 */
    { 0x0c06d6, 0x0c0646, 0x0000, 0x0000, 0, 62 }, /* #1 b */
    { 0x2f2a53, 0x2f2246, 0x0000, 0x0000, 0, 15 }, /* #2 */
    { 0x105586, 0x105546, 0x0000, 0x0000, 0, 15 }, /* #2 b */
    { 0x162856, 0x162046, 0x0000, 0x0000, 0, 28 }, /* #3 */
    { 0x295783, 0x295746, 0x0000, 0x0000, 0, 28 }, /* #3 b */
    { 0x283493, 0x283446, 0x0000, 0x0000, 0, 31 }, /* #4 */
    { 0x174b46, 0x174346, 0x0000, 0x0000, 0, 31 }, /* #4 b */
    { 0x0f1ac7, 0x0f1246, 0x0000, 0x0000, 0, 17 }, /* #5 */
    { 0x306512, 0x306546, 0x0000, 0x0000, 0, 17 }, /* #5 b */
    { 0x1b1d16, 0x1b1d46, 0x7f0a, 0x0000, 0, 19 }, /* #6 */
    { 0x2462c3, 0x246a46, 0x7f0a, 0x0000, 0, 19 }, /* #6 b */
    { 0x314006, 0x314846, 0x5e98, 0x0000, 0, 20 }, /* #7 */
    { 0x0e3fd3, 0x0e3f46, 0x5e98, 0x0000, 0, 20 }, /* #7 b */
    { 0x257056, 0x257006, 0xe867, 0x7000, 0, 44 }, /* #8 */
    { 0x1a0f83, 0x1a0706, 0xe867, 0x7000, 0, 44 }, /* #8 b */
    { 0x0a4653, 0x0a4646, 0xd5f4, 0x0000, 0, 50 }, /* #9 */
    { 0x353986, 0x353146, 0xd5f4, 0x0000, 0, 50 }, /* #9 b */
    { 0x044642, 0x044646, 0x3947, 0x0000, 0, 28 }, /* #10 */
    { 0x3b3997, 0x3b3146, 0x3947, 0x0000, 0, 28 }, /* #10 b */
    { 0x0b1113, 0x0b1903, 0x66e1, 0x3708, 0, 3  }, /* #11 */
    { 0x346ec6, 0x346e03, 0x66e1, 0x3708, 0, 3  }, /* #11 b */
    { 0x261d17, 0x261d07, 0x8ad5, 0x5000, 0, 12 }, /* #12 */
    { 0x1962c2, 0x196a07, 0x8ad5, 0x5000, 0, 12 }, /* #12 b */
    { 0x090252, 0x090a46, 0x5eba, 0x0000, 0, 59 }, /* #13 */
    { 0x367d87, 0x367d46, 0x5eba, 0x0000, 0, 59 }, /* #13 b */
    { 0x171b52, 0x171386, 0xd2fd, 0x8000, 0, 47 }, /* #14 */
    { 0x286487, 0x286486, 0xd2fd, 0x8000, 0, 47 }, /* #14 b */
    { 0x125d53, 0x125d53, 0x6a69, 0x6a69, 0, 32 }, /* #15 */
    { 0x2d2286, 0x2d2286, 0x6a69, 0x6a69, 0, 32 }, /* #15 b */
    { 0x204a97, 0x204246, 0x2e1d, 0x0000, 0, 31 }, /* #16 */
    { 0x1f3542, 0x1f3546, 0x2e1d, 0x0000, 0, 31 }, /* #16 b */
    { 0x245b57, 0x245b46, 0x47a8, 0x0000, 0, 58 }, /* #17 */
    { 0x1b2482, 0x1b2c46, 0x47a8, 0x0000, 0, 58 }, /* #17 b */
    { 0x011192, 0x011146, 0xfa8a, 0x0000, 0, 55 }, /* #18 */
    { 0x3e6e47, 0x3e6646, 0xfa8a, 0x0000, 0, 55 }, /* #18 b */
    { 0x0b2f96, 0x0b2707, 0x3568, 0x6800, 0, 8  }, /* #19 */
    { 0x345043, 0x345007, 0x3568, 0x6800, 0, 8  }, /* #19 b */
    { 0x3578c3, 0x357847, 0xbec9, 0x0000, 0, 16 }, /* #20 */
    { 0x0a0716, 0x0a0f47, 0xbec9, 0x0000, 0, 16 }, /* #20 b */
    { 0x0b6092, 0x0b6886, 0xa4f9, 0x8000, 0, 15 }, /* #21 */
    { 0x341f47, 0x341f86, 0xa4f9, 0x8000, 0, 15 }, /* #21 b */
    { 0x250742, 0x250786, 0x331b, 0xc000, 0, 14 }, /* #22 */
    { 0x1a7897, 0x1a7086, 0x331b, 0xc000, 0, 14 }, /* #22 b */
    { 0x296547, 0x296d87, 0x664c, 0x9300, 0, 38 }, /* #23 */
    { 0x161a92, 0x161a87, 0x664c, 0x9300, 0, 38 }, /* #23 b */
    { 0x387782, 0x387746, 0xfbba, 0x0000, 0, 52 }, /* #24 */
    { 0x070857, 0x070046, 0xfbba, 0x0000, 0, 52 }, /* #24 b */
    { 0x093a56, 0x093206, 0xfe52, 0x4000, 0, 45 }, /* #25 */
    { 0x364583, 0x364506, 0xfe52, 0x4000, 0, 45 }, /* #25 b */
    { 0x396b03, 0x396307, 0xcba0, 0x4000, 0, 9  }, /* #26 */
    { 0x0614d6, 0x061407, 0xcba0, 0x4000, 0, 9  }, /* #26 b */
    { 0x350713, 0x350746, 0xeb1c, 0x0000, 0, 27 }, /* #27 */
    { 0x0a78c6, 0x0a7046, 0xeb1c, 0x0000, 0, 27 }, /* #27 b */
    { 0x232717, 0x232746, 0x00f5, 0x0000, 0, 53 }, /* #28 */
    { 0x1c58c2, 0x1c5046, 0x00f5, 0x0000, 0, 53 }, /* #28 b */
    { 0x2311c6, 0x231146, 0xd2f0, 0x0000, 0, 52 }, /* #29 */
    { 0x1c6e13, 0x1c6646, 0xd2f0, 0x0000, 0, 52 }, /* #29 b */
    { 0x042a02, 0x042246, 0x2f75, 0x0000, 0, 56 }, /* #30 */
    { 0x3b55d7, 0x3b5546, 0x2f75, 0x0000, 0, 56 }, /* #30 b */
    { 0x3c0a52, 0x3c0283, 0xeb48, 0xad20, 0, 2  }, /* #31 */
    { 0x037587, 0x037583, 0xeb48, 0xad20, 0, 2  }, /* #31 b */
    { 0x065bc6, 0x065383, 0x1aa7, 0xaa70, 0, 4  }, /* #32 */
    { 0x392413, 0x392483, 0x1aa7, 0xaa70, 0, 4  }, /* #32 b */
    { 0x1227d3, 0x1227d3, 0x6770, 0x6770, 0, 32 }, /* #33 */
    { 0x2d5806, 0x2d5806, 0x6770, 0x6770, 0, 32 }, /* #33 b */
    { 0x035a93, 0x035a03, 0x94ac, 0x2958, 0, 1  }, /* #34 */
    { 0x3c2546, 0x3c2d03, 0x94ac, 0x2958, 0, 1  }, /* #34 b */
    { 0x382e42, 0x382646, 0x099a, 0x0000, 0, 52 }, /* #35 */
    { 0x075197, 0x075146, 0x099a, 0x0000, 0, 52 }, /* #35 b */
    { 0x095542, 0x095546, 0xc1f2, 0x0000, 0, 18 }, /* #36 */
    { 0x362a97, 0x362246, 0xc1f2, 0x0000, 0, 18 }, /* #36 b */
    { 0x375f46, 0x375f46, 0x71ef, 0x0000, 0, 30 }, /* #37 */
    { 0x082093, 0x082846, 0x71ef, 0x0000, 0, 30 }, /* #37 b */
    { 0x2e30d7, 0x2e3807, 0x439b, 0x6000, 0, 13 }, /* #38 */
    { 0x114f02, 0x114f07, 0x439b, 0x6000, 0, 13 }, /* #38 b */
    { 0x3916c6, 0x391e47, 0xbb16, 0x0000, 0, 15 }, /* #39 */
    { 0x066913, 0x066947, 0xbb16, 0x0000, 0, 15 }, /* #39 b */
    { 0x2b5dd6, 0x2b5547, 0x0385, 0x0000, 0, 48 }, /* #40 */
    { 0x142203, 0x142247, 0x0385, 0x0000, 0, 48 }, /* #40 b */
    { 0x307e82, 0x307687, 0xd28e, 0xc000, 0, 45 }, /* #41 */
    { 0x0f0157, 0x0f0187, 0xd28e, 0xc000, 0, 45 }, /* #41 b */
    { 0x130ed7, 0x130646, 0x3fb4, 0x0000, 0, 62 }, /* #42 */
    { 0x2c7102, 0x2c7146, 0x3fb4, 0x0000, 0, 62 }, /* #42 b */
    { 0x1b2ec6, 0x1b2e46, 0xbc5e, 0x0000, 0, 23 }, /* #43 */
    { 0x245113, 0x245946, 0xbc5e, 0x0000, 0, 23 }, /* #43 b */
    { 0x161c07, 0x161c46, 0x4a40, 0x0000, 0, 61 }, /* #44 */
    { 0x2963d2, 0x296b46, 0x4a40, 0x0000, 0, 61 }, /* #44 b */
    { 0x0507c7, 0x050746, 0x3335, 0x0000, 0, 18 }, /* #45 */
    { 0x3a7812, 0x3a7046, 0x3335, 0x0000, 0, 18 }, /* #45 b */
    { 0x246717, 0x246f87, 0xb38a, 0x9c50, 0, 35 }, /* #46 */
    { 0x1b18c2, 0x1b1887, 0xb38a, 0x9c50, 0, 35 }, /* #46 b */
    { 0x334c47, 0x334446, 0xd702, 0x0000, 0, 48 }, /* #47 */
    { 0x0c3392, 0x0c3346, 0xd702, 0x0000, 0, 48 }, /* #47 b */
    { 0x2117d2, 0x211f46, 0x6f5a, 0x0000, 0, 56 }, /* #48 */
    { 0x1e6807, 0x1e6846, 0x6f5a, 0x0000, 0, 56 }, /* #48 b */
    { 0x3e2c57, 0x3e2406, 0x3c96, 0x5800, 0, 10 }, /* #49 */
    { 0x015382, 0x015306, 0x3c96, 0x5800, 0, 10 }, /* #49 b */
    { 0x3f6642, 0x3f6e46, 0xba08, 0x0000, 0, 31 }, /* #50 */
    { 0x001997, 0x001946, 0xba08, 0x0000, 0, 31 }, /* #50 b */
    { 0x326b57, 0x326b02, 0x903c, 0x0780, 0, 37 }, /* #51 */
    { 0x0d1482, 0x0d1c02, 0x903c, 0x0780, 0, 37 }, /* #51 b */
    { 0x193286, 0x193246, 0x23a6, 0x0000, 0, 62 }, /* #52 */
    { 0x264d53, 0x264546, 0x23a6, 0x0000, 0, 62 }, /* #52 b */
    { 0x335557, 0x335d46, 0xa41e, 0x0000, 0, 30 }, /* #53 */
    { 0x0c2a82, 0x0c2a46, 0xa41e, 0x0000, 0, 30 }, /* #53 b */
    { 0x086852, 0x086846, 0x981d, 0x0000, 0, 30 }, /* #54 */
    { 0x371787, 0x371f46, 0x981d, 0x0000, 0, 30 }, /* #54 b */
    { 0x010997, 0x010946, 0x7f8b, 0x0000, 0, 56 }, /* #55 */
    { 0x3e7642, 0x3e7e46, 0x7f8b, 0x0000, 0, 56 }, /* #55 b */
    { 0x286cc6, 0x286447, 0x3796, 0x0000, 0, 47 }, /* #56 */
    { 0x171313, 0x171347, 0x3796, 0x0000, 0, 47 }, /* #56 b */
    { 0x137f42, 0x137746, 0xc23f, 0x0000, 0, 51 }, /* #57 */
    { 0x2c0097, 0x2c0046, 0xc23f, 0x0000, 0, 51 }, /* #57 b */
    { 0x2a0992, 0x2a0146, 0xd2b1, 0x0000, 0, 25 }, /* #58 */
    { 0x157647, 0x157646, 0xd2b1, 0x0000, 0, 25 }, /* #58 b */
    { 0x0c6212, 0x0c6a02, 0xa3f4, 0x7e80, 0, 5  }, /* #59 */
    { 0x331dc7, 0x331d02, 0xa3f4, 0x7e80, 0, 5  }, /* #59 b */
    { 0x0e2f83, 0x0e2f82, 0xa63c, 0xc780, 0, 37 }, /* #60 */
    { 0x315056, 0x315882, 0xa63c, 0xc780, 0, 37 }, /* #60 b */
    { 0x395d57, 0x395546, 0xfe30, 0x0000, 0, 62 }, /* #61 */
    { 0x062282, 0x062246, 0xfe30, 0x0000, 0, 62 }, /* #61 b */
    { 0x237e52, 0x237e46, 0x6cb9, 0x0000, 0, 63 }, /* #62 */
    { 0x1c0187, 0x1c0946, 0x6cb9, 0x0000, 0, 63 }, /* #62 b */
    { 0x1c0293, 0x1c0246, 0x282b, 0x0000, 0, 29 }, /* #63 */
    { 0x237d46, 0x237546, 0x282b, 0x0000, 0, 29 }, /* #63 b */
    { 0x347c56, 0x347c87, 0x98fb, 0x8000, 0, 47 }, /* #64 */
    { 0x0b0383, 0x0b0b87, 0x98fb, 0x8000, 0, 47 }, /* #64 b */
    { 0x3b4043, 0x3b4046, 0x1a5f, 0x0000, 0, 29 }, /* #65 */
    { 0x043f96, 0x043746, 0x1a5f, 0x0000, 0, 29 }, /* #65 b */
    { 0x111c97, 0x111c06, 0x6216, 0x1600, 0, 8  }, /* #66 */
    { 0x2e6342, 0x2e6b06, 0x6216, 0x1600, 0, 8  }, /* #66 b */
    { 0x0a1d02, 0x0a1546, 0x3fb6, 0x0000, 0, 55 }, /* #67 */
    { 0x3562d7, 0x356246, 0x3fb6, 0x0000, 0, 55 }, /* #67 b */
    { 0x331a13, 0x331a46, 0xb723, 0x0000, 0, 56 }, /* #68 */
    { 0x0c65c6, 0x0c6d46, 0xb723, 0x0000, 0, 56 }, /* #68 b */
    { 0x3c0686, 0x3c0e46, 0x4300, 0x0000, 0, 42 }, /* #69 */
    { 0x037953, 0x037946, 0x4300, 0x0000, 0, 42 }, /* #69 b */
    { 0x2f4b92, 0x2f4b03, 0x92d1, 0x25a2, 0, 33 }, /* #70 */
    { 0x103447, 0x103c03, 0x92d1, 0x25a2, 0, 33 }, /* #70 b */
    { 0x114cd3, 0x114446, 0x3d49, 0x0000, 0, 27 }, /* #71 */
    { 0x2e3306, 0x2e3346, 0x3d49, 0x0000, 0, 27 }, /* #71 b */
    { 0x1900d7, 0x190846, 0x9be9, 0x0000, 0, 62 }, /* #72 */
    { 0x267f02, 0x267f46, 0x9be9, 0x0000, 0, 62 }, /* #72 b */
    { 0x0f3a16, 0x0f3a46, 0x77e8, 0x0000, 0, 26 }, /* #73 */
    { 0x3045c3, 0x304d46, 0x77e8, 0x0000, 0, 26 }, /* #73 b */
    { 0x045182, 0x045146, 0xf32e, 0x0000, 0, 55 }, /* #74 */
    { 0x3b2e57, 0x3b2646, 0xf32e, 0x0000, 0, 55 }, /* #74 b */
    { 0x2d6dc3, 0x2d6587, 0xdf7c, 0xdf00, 0, 6  }, /* #75 */
    { 0x121216, 0x121287, 0xdf7c, 0xdf00, 0, 6  }, /* #75 b */
    { 0x341702, 0x341707, 0x3680, 0x6800, 0, 4  }, /* #76 */
    { 0x0b68d7, 0x0b6007, 0x3680, 0x6800, 0, 4  }, /* #76 b */
    { 0x2a3396, 0x2a3b46, 0x70d4, 0x0000, 0, 25 }, /* #77 */
    { 0x154c43, 0x154c46, 0x70d4, 0x0000, 0, 25 }, /* #77 b */
    { 0x0f6517, 0x0f6506, 0xe32a, 0x5400, 0, 41 }, /* #78 */
    { 0x301ac2, 0x301206, 0xe32a, 0x5400, 0, 41 }, /* #78 b */
    { 0x357fc3, 0x357f46, 0x403c, 0x0000, 0, 55 }, /* #79 */
    { 0x0a0016, 0x0a0846, 0x403c, 0x0000, 0, 55 }, /* #79 b */
    { 0x1c1156, 0x1c1946, 0x7fa9, 0x0000, 0, 54 }, /* #80 */
    { 0x236e83, 0x236e46, 0x7fa9, 0x0000, 0, 54 }, /* #80 b */
    { 0x304752, 0x304f46, 0x765c, 0x0000, 0, 53 }, /* #81 */
    { 0x0f3887, 0x0f3846, 0x765c, 0x0000, 0, 53 }, /* #81 b */
    { 0x0264d3, 0x026403, 0xd94f, 0x29e0, 0, 5  }, /* #82 */
    { 0x3d1b06, 0x3d1303, 0xd94f, 0x29e0, 0, 5  }, /* #82 b */
    { 0x2e72c3, 0x2e7a06, 0x910f, 0x443c, 0, 2  }, /* #83 */
    { 0x110d16, 0x110d06, 0x910f, 0x443c, 0, 2  }, /* #83 b */
    { 0x110c17, 0x110446, 0x1be6, 0x0000, 0, 24 }, /* #84 */
    { 0x2e73c2, 0x2e7346, 0x1be6, 0x0000, 0, 24 }, /* #84 b */
    { 0x170bd7, 0x170b46, 0x86b4, 0x0000, 0, 50 }, /* #85 */
    { 0x287402, 0x287c46, 0x86b4, 0x0000, 0, 50 }, /* #85 b */
    { 0x212502, 0x212583, 0xfed4, 0xed40, 0, 4  }, /* #86 */
    { 0x1e5ad7, 0x1e5283, 0xfed4, 0xed40, 0, 4  }, /* #86 b */
    { 0x0f3747, 0x0f3747, 0x11ae, 0x0000, 0, 47 }, /* #87 */
    { 0x304892, 0x304047, 0x11ae, 0x0000, 0, 47 }, /* #87 b */
    { 0x284943, 0x284146, 0xe792, 0x0000, 0, 18 }, /* #88 */
    { 0x173696, 0x173646, 0xe792, 0x0000, 0, 18 }, /* #88 b */
    { 0x0b7d83, 0x0b7d46, 0x5d44, 0x0000, 0, 30 }, /* #89 */
    { 0x340256, 0x340a46, 0x5d44, 0x0000, 0, 30 }, /* #89 b */
    { 0x370317, 0x370306, 0x3123, 0x6000, 0, 45 }, /* #90 */
    { 0x087cc2, 0x087406, 0x3123, 0x6000, 0, 45 }, /* #90 b */
    { 0x214b03, 0x214b87, 0x89f6, 0xb000, 0, 11 }, /* #91 */
    { 0x1e34d6, 0x1e3c87, 0x89f6, 0xb000, 0, 11 }, /* #91 b */
    { 0x084cc3, 0x084446, 0x37a1, 0x0000, 0, 22 }, /* #92 */
    { 0x373316, 0x373346, 0x37a1, 0x0000, 0, 22 }, /* #92 b */
    { 0x0238d2, 0x0238d2, 0x5e1b, 0x5e1b, 0, 32 }, /* #93 */
    { 0x3d4707, 0x3d4707, 0x5e1b, 0x5e1b, 0, 32 }, /* #93 b */
    { 0x2a50c3, 0x2a5846, 0xb0d4, 0x0000, 0, 20 }, /* #94 */
    { 0x152f16, 0x152f46, 0xb0d4, 0x0000, 0, 20 }, /* #94 b */
    { 0x021593, 0x021546, 0xcc3e, 0x0000, 0, 56 }, /* #95 */
    { 0x3d6a46, 0x3d6246, 0xcc3e, 0x0000, 0, 56 }, /* #95 b */
};
uint32_t const g_cTests_shl_u16_intel = RT_ELEMENTS(g_aTests_shl_u16_intel);

BINU16_TEST_T const g_aTests_shr_u16_intel[] =
{
    { 0x134242, 0x134246, 0x0000, 0x0000, 0, 39 }, /* #0 */
    { 0x2c3d97, 0x2c3546, 0x0000, 0x0000, 0, 39 }, /* #0 b */
    { 0x320e47, 0x320646, 0x0000, 0x0000, 0, 14 }, /* #1 */
    { 0x0d7192, 0x0d7146, 0x0000, 0x0000, 0, 14 }, /* #1 b */
    { 0x2e5303, 0x2e5346, 0x0000, 0x0000, 0, 49 }, /* #2 */
    { 0x112cd6, 0x112446, 0x0000, 0x0000, 0, 49 }, /* #2 b */
    { 0x215607, 0x215646, 0x0000, 0x0000, 0, 15 }, /* #3 */
    { 0x1e29d2, 0x1e2146, 0x0000, 0x0000, 0, 15 }, /* #3 b */
    { 0x036656, 0x036646, 0x0000, 0x0000, 0, 38 }, /* #4 */
    { 0x3c1983, 0x3c1146, 0x0000, 0x0000, 0, 38 }, /* #4 b */
    { 0x2e7846, 0x2e7046, 0x0000, 0x0000, 0, 39 }, /* #5 */
    { 0x110793, 0x110746, 0x0000, 0x0000, 0, 39 }, /* #5 b */
    { 0x3e7b07, 0x3e7346, 0x2021, 0x0000, 0, 59 }, /* #6 */
    { 0x0104d2, 0x010446, 0x2021, 0x0000, 0, 59 }, /* #6 b */
    { 0x2b1ad2, 0x2b1a03, 0xd384, 0x1a70, 0, 3  }, /* #7 */
    { 0x146507, 0x146d03, 0xd384, 0x1a70, 0, 3  }, /* #7 b */
    { 0x352953, 0x352902, 0xd4d1, 0x000d, 0, 44 }, /* #8 */
    { 0x0a5686, 0x0a5e02, 0xd4d1, 0x000d, 0, 44 }, /* #8 b */
    { 0x3b7816, 0x3b7803, 0x9db1, 0x0004, 0, 45 }, /* #9 */
    { 0x0407c3, 0x040f03, 0x9db1, 0x0004, 0, 45 }, /* #9 b */
    { 0x3c0253, 0x3c0a46, 0x9d83, 0x0000, 0, 58 }, /* #10 */
    { 0x037d86, 0x037d46, 0x9d83, 0x0000, 0, 58 }, /* #10 b */
    { 0x025502, 0x025503, 0x0917, 0x0245, 0, 34 }, /* #11 */
    { 0x3d2ad7, 0x3d2203, 0x0917, 0x0245, 0, 34 }, /* #11 b */
    { 0x3b3b56, 0x3b3b02, 0xe883, 0x1d10, 0, 35 }, /* #12 */
    { 0x044483, 0x044c02, 0xe883, 0x1d10, 0, 35 }, /* #12 b */
    { 0x105186, 0x105102, 0x2b93, 0x00ae, 0, 38 }, /* #13 */
    { 0x2f2e53, 0x2f2602, 0x2b93, 0x00ae, 0, 38 }, /* #13 b */
    { 0x266053, 0x266803, 0x9b59, 0x0026, 0, 10 }, /* #14 */
    { 0x191f86, 0x191f03, 0x9b59, 0x0026, 0, 10 }, /* #14 b */
    { 0x1d6097, 0x1d6803, 0x9425, 0x0004, 0, 45 }, /* #15 */
    { 0x221f42, 0x221f03, 0x9425, 0x0004, 0, 45 }, /* #15 b */
    { 0x090707, 0x090f47, 0xa629, 0x0000, 0, 48 }, /* #16 */
    { 0x3678d2, 0x367847, 0xa629, 0x0000, 0, 48 }, /* #16 b */
    { 0x151216, 0x151a06, 0xc26c, 0x0018, 0, 11 }, /* #17 */
    { 0x2a6dc3, 0x2a6d06, 0xc26c, 0x0018, 0, 11 }, /* #17 b */
    { 0x101ed2, 0x101646, 0x63e5, 0x0000, 0, 50 }, /* #18 */
    { 0x2f6107, 0x2f6146, 0x63e5, 0x0000, 0, 50 }, /* #18 b */
    { 0x373447, 0x373403, 0x7614, 0x0001, 0, 46 }, /* #19 */
    { 0x084b92, 0x084303, 0x7614, 0x0001, 0, 46 }, /* #19 b */
    { 0x2a2803, 0x2a2847, 0x879c, 0x0000, 0, 48 }, /* #20 */
    { 0x1557d6, 0x155f47, 0x879c, 0x0000, 0, 48 }, /* #20 b */
    { 0x2e63d7, 0x2e6b02, 0xb19a, 0x000b, 0, 12 }, /* #21 */
    { 0x111c02, 0x111c02, 0xb19a, 0x000b, 0, 12 }, /* #21 b */
    { 0x1c28d7, 0x1c2846, 0xfc29, 0x0000, 0, 21 }, /* #22 */
    { 0x235702, 0x235f46, 0xfc29, 0x0000, 0, 21 }, /* #22 b */
    { 0x060c43, 0x060c46, 0xac2e, 0x0000, 0, 28 }, /* #23 */
    { 0x397396, 0x397b46, 0xac2e, 0x0000, 0, 28 }, /* #23 b */
    { 0x211c03, 0x211c06, 0xd3e6, 0x69f3, 0, 1  }, /* #24 */
    { 0x1e63d6, 0x1e6b06, 0xd3e6, 0x69f3, 0, 1  }, /* #24 b */
    { 0x3d0f07, 0x3d0f06, 0xf041, 0x0782, 0, 5  }, /* #25 */
    { 0x0270d2, 0x027806, 0xf041, 0x0782, 0, 5  }, /* #25 b */
    { 0x356e03, 0x356602, 0x34a8, 0x000d, 0, 10 }, /* #26 */
    { 0x0a11d6, 0x0a1102, 0x34a8, 0x000d, 0, 10 }, /* #26 b */
    { 0x0c7e86, 0x0c7646, 0x4854, 0x0000, 0, 50 }, /* #27 */
    { 0x330153, 0x330146, 0x4854, 0x0000, 0, 50 }, /* #27 b */
    { 0x2b2712, 0x2b2702, 0x4254, 0x0002, 0, 13 }, /* #28 */
    { 0x1458c7, 0x145002, 0x4254, 0x0002, 0, 13 }, /* #28 b */
    { 0x0a6582, 0x0a6d47, 0xd21c, 0x0000, 0, 16 }, /* #29 */
    { 0x351a57, 0x351a47, 0xd21c, 0x0000, 0, 16 }, /* #29 b */
    { 0x3b2c12, 0x3b2446, 0x6e0c, 0x0000, 0, 25 }, /* #30 */
    { 0x0453c7, 0x045346, 0x6e0c, 0x0000, 0, 25 }, /* #30 b */
    { 0x3b4516, 0x3b4d06, 0x914f, 0x0009, 0, 44 }, /* #31 */
    { 0x043ac3, 0x043a06, 0x914f, 0x0009, 0, 44 }, /* #31 b */
    { 0x3a2bd2, 0x3a2302, 0x6e63, 0x06e6, 0, 4  }, /* #32 */
    { 0x055407, 0x055402, 0x6e63, 0x06e6, 0, 4  }, /* #32 b */
    { 0x2c4cc2, 0x2c4403, 0x23da, 0x023d, 0, 4  }, /* #33 */
    { 0x133317, 0x133303, 0x23da, 0x023d, 0, 4  }, /* #33 b */
    { 0x172257, 0x172246, 0x627a, 0x0000, 0, 23 }, /* #34 */
    { 0x285d82, 0x285546, 0x627a, 0x0000, 0, 23 }, /* #34 b */
    { 0x3c0192, 0x3c0946, 0xcf82, 0x0000, 0, 28 }, /* #35 */
    { 0x037e47, 0x037e46, 0xcf82, 0x0000, 0, 28 }, /* #35 b */
    { 0x3f1713, 0x3f1746, 0x397c, 0x0000, 0, 27 }, /* #36 */
    { 0x0068c6, 0x006046, 0x397c, 0x0000, 0, 27 }, /* #36 b */
    { 0x227b02, 0x227b46, 0xf50a, 0x0000, 0, 61 }, /* #37 */
    { 0x1d04d7, 0x1d0c46, 0xf50a, 0x0000, 0, 61 }, /* #37 b */
    { 0x011b83, 0x011346, 0x44cf, 0x0000, 0, 17 }, /* #38 */
    { 0x3e6456, 0x3e6446, 0x44cf, 0x0000, 0, 17 }, /* #38 b */
    { 0x175286, 0x175202, 0x1787, 0x002f, 0, 7  }, /* #39 */
    { 0x282d53, 0x282502, 0x1787, 0x002f, 0, 7  }, /* #39 b */
    { 0x3d4493, 0x3d4c46, 0xf1ae, 0x0000, 0, 23 }, /* #40 */
    { 0x023b46, 0x023b46, 0xf1ae, 0x0000, 0, 23 }, /* #40 b */
    { 0x1547d3, 0x154f02, 0x9440, 0x0002, 0, 14 }, /* #41 */
    { 0x2a3806, 0x2a3802, 0x9440, 0x0002, 0, 14 }, /* #41 b */
    { 0x1e25d2, 0x1e2d47, 0xe704, 0x0000, 0, 16 }, /* #42 */
    { 0x215a07, 0x215a47, 0xe704, 0x0000, 0, 16 }, /* #42 b */
    { 0x195846, 0x195047, 0x711a, 0x0000, 0, 47 }, /* #43 */
    { 0x262793, 0x262747, 0x711a, 0x0000, 0, 47 }, /* #43 b */
    { 0x215046, 0x215806, 0xc4b2, 0x0003, 0, 14 }, /* #44 */
    { 0x1e2f93, 0x1e2f06, 0xc4b2, 0x0003, 0, 14 }, /* #44 b */
    { 0x045ec2, 0x045e46, 0x852c, 0x0000, 0, 50 }, /* #45 */
    { 0x3b2117, 0x3b2946, 0x852c, 0x0000, 0, 50 }, /* #45 b */
    { 0x3f78d3, 0x3f7803, 0xce76, 0x0673, 0, 5  }, /* #46 */
    { 0x000706, 0x000f03, 0xce76, 0x0673, 0, 5  }, /* #46 b */
    { 0x252902, 0x252946, 0xc44e, 0x0000, 0, 31 }, /* #47 */
    { 0x1a56d7, 0x1a5e46, 0xc44e, 0x0000, 0, 31 }, /* #47 b */
    { 0x173943, 0x173146, 0x5a5d, 0x0000, 0, 23 }, /* #48 */
    { 0x284696, 0x284646, 0x5a5d, 0x0000, 0, 23 }, /* #48 b */
    { 0x074d12, 0x074507, 0x7d71, 0x01f5, 0, 6  }, /* #49 */
    { 0x3832c7, 0x383207, 0x7d71, 0x01f5, 0, 6  }, /* #49 b */
    { 0x0f3f07, 0x0f3703, 0x1cde, 0x001c, 0, 8  }, /* #50 */
    { 0x3040d2, 0x304003, 0x1cde, 0x001c, 0, 8  }, /* #50 b */
    { 0x340647, 0x340e02, 0xb8f5, 0x0b8f, 0, 4  }, /* #51 */
    { 0x0b7992, 0x0b7902, 0xb8f5, 0x0b8f, 0, 4  }, /* #51 b */
    { 0x093696, 0x093603, 0x70f4, 0x0070, 0, 40 }, /* #52 */
    { 0x364943, 0x364103, 0x70f4, 0x0070, 0, 40 }, /* #52 b */
    { 0x137057, 0x137002, 0x51fa, 0x0001, 0, 46 }, /* #53 */
    { 0x2c0f82, 0x2c0702, 0x51fa, 0x0001, 0, 46 }, /* #53 b */
    { 0x070192, 0x070106, 0x6f6d, 0x1bdb, 0, 2  }, /* #54 */
    { 0x387e47, 0x387606, 0x6f6d, 0x1bdb, 0, 2  }, /* #54 b */
    { 0x117807, 0x117807, 0xd5b7, 0x0006, 0, 13 }, /* #55 */
    { 0x2e07d2, 0x2e0f07, 0xd5b7, 0x0006, 0, 13 }, /* #55 b */
    { 0x1243c2, 0x124346, 0x5092, 0x0000, 0, 18 }, /* #56 */
    { 0x2d3c17, 0x2d3446, 0x5092, 0x0000, 0, 18 }, /* #56 b */
    { 0x2767d2, 0x276702, 0x72aa, 0x00e5, 0, 39 }, /* #57 */
    { 0x181807, 0x181002, 0x72aa, 0x00e5, 0, 39 }, /* #57 b */
    { 0x3b6117, 0x3b6946, 0xeb4d, 0x0000, 0, 61 }, /* #58 */
    { 0x041ec2, 0x041e46, 0xeb4d, 0x0000, 0, 61 }, /* #58 b */
    { 0x3d3487, 0x3d3c07, 0xf96b, 0x3e5a, 0, 2  }, /* #59 */
    { 0x024b52, 0x024b07, 0xf96b, 0x3e5a, 0, 2  }, /* #59 b */
    { 0x050f53, 0x050f03, 0xed13, 0x0001, 0, 47 }, /* #60 */
    { 0x3a7086, 0x3a7803, 0xed13, 0x0001, 0, 47 }, /* #60 b */
    { 0x237dd2, 0x237d03, 0xb6b7, 0x02da, 0, 6  }, /* #61 */
    { 0x1c0207, 0x1c0a03, 0xb6b7, 0x02da, 0, 6  }, /* #61 b */
    { 0x213193, 0x213146, 0x09f0, 0x0000, 0, 23 }, /* #62 */
    { 0x1e4e46, 0x1e4646, 0x09f0, 0x0000, 0, 23 }, /* #62 b */
    { 0x1b26c3, 0x1b2e46, 0xa7ac, 0x0000, 0, 22 }, /* #63 */
    { 0x245916, 0x245946, 0xa7ac, 0x0000, 0, 22 }, /* #63 b */
    { 0x334352, 0x334346, 0x0b83, 0x0000, 0, 54 }, /* #64 */
    { 0x0c3c87, 0x0c3446, 0x0b83, 0x0000, 0, 54 }, /* #64 b */
    { 0x2a2d87, 0x2a2d46, 0xda7d, 0x0000, 0, 53 }, /* #65 */
    { 0x155252, 0x155a46, 0xda7d, 0x0000, 0, 53 }, /* #65 b */
    { 0x0e3756, 0x0e3703, 0x5d76, 0x000b, 0, 11 }, /* #66 */
    { 0x314883, 0x314003, 0x5d76, 0x000b, 0, 11 }, /* #66 b */
    { 0x1f5a53, 0x1f5246, 0x7c7a, 0x0000, 0, 28 }, /* #67 */
    { 0x202586, 0x202546, 0x7c7a, 0x0000, 0, 28 }, /* #67 b */
    { 0x012246, 0x012a46, 0x84ba, 0x0000, 0, 23 }, /* #68 */
    { 0x3e5d93, 0x3e5d46, 0x84ba, 0x0000, 0, 23 }, /* #68 b */
    { 0x266e43, 0x266e02, 0xfe15, 0x00fe, 0, 8  }, /* #69 */
    { 0x191196, 0x191902, 0xfe15, 0x00fe, 0, 8  }, /* #69 b */
    { 0x1c78c2, 0x1c7846, 0xf582, 0x0000, 0, 56 }, /* #70 */
    { 0x230717, 0x230f46, 0xf582, 0x0000, 0, 56 }, /* #70 b */
    { 0x340212, 0x340246, 0x3d36, 0x0000, 0, 60 }, /* #71 */
    { 0x0b7dc7, 0x0b7546, 0x3d36, 0x0000, 0, 60 }, /* #71 b */
    { 0x017cc7, 0x017cc7, 0x885f, 0x885f, 0, 0  }, /* #72 */
    { 0x3e0312, 0x3e0312, 0x885f, 0x885f, 0, 0  }, /* #72 b */
    { 0x3e5016, 0x3e5846, 0xbfec, 0x0000, 0, 25 }, /* #73 */
    { 0x012fc3, 0x012f46, 0xbfec, 0x0000, 0, 25 }, /* #73 b */
    { 0x240412, 0x240446, 0x3071, 0x0000, 0, 55 }, /* #74 */
    { 0x1b7bc7, 0x1b7346, 0x3071, 0x0000, 0, 55 }, /* #74 b */
    { 0x3c0896, 0x3c0046, 0x4964, 0x0000, 0, 28 }, /* #75 */
    { 0x037743, 0x037746, 0x4964, 0x0000, 0, 28 }, /* #75 b */
    { 0x2f21c3, 0x2f2946, 0x8b3a, 0x0000, 0, 58 }, /* #76 */
    { 0x105e16, 0x105e46, 0x8b3a, 0x0000, 0, 58 }, /* #76 b */
    { 0x396997, 0x396907, 0xbda5, 0x00bd, 0, 40 }, /* #77 */
    { 0x061642, 0x061e07, 0xbda5, 0x00bd, 0, 40 }, /* #77 b */
    { 0x011d53, 0x011546, 0x585b, 0x0000, 0, 58 }, /* #78 */
    { 0x3e6286, 0x3e6246, 0x585b, 0x0000, 0, 58 }, /* #78 b */
    { 0x3147d6, 0x314702, 0x24cc, 0x0002, 0, 44 }, /* #79 */
    { 0x0e3803, 0x0e3002, 0x24cc, 0x0002, 0, 44 }, /* #79 b */
    { 0x3c75d7, 0x3c7d46, 0xc757, 0x0000, 0, 62 }, /* #80 */
    { 0x030a02, 0x030a46, 0xc757, 0x0000, 0, 62 }, /* #80 b */
    { 0x356cd3, 0x356446, 0x527e, 0x0000, 0, 48 }, /* #81 */
    { 0x0a1306, 0x0a1346, 0x527e, 0x0000, 0, 48 }, /* #81 b */
    { 0x0629d3, 0x062907, 0xf6ff, 0x0003, 0, 46 }, /* #82 */
    { 0x395606, 0x395e07, 0xf6ff, 0x0003, 0, 46 }, /* #82 b */
    { 0x194557, 0x194d06, 0xb720, 0x0b72, 0, 36 }, /* #83 */
    { 0x263a82, 0x263a06, 0xb720, 0x0b72, 0, 36 }, /* #83 b */
    { 0x272697, 0x272e46, 0xbe3f, 0x0000, 0, 49 }, /* #84 */
    { 0x185942, 0x185946, 0xbe3f, 0x0000, 0, 49 }, /* #84 b */
    { 0x172a16, 0x172a47, 0xcbfe, 0x0000, 0, 16 }, /* #85 */
    { 0x2855c3, 0x285d47, 0xcbfe, 0x0000, 0, 16 }, /* #85 b */
    { 0x143e16, 0x143646, 0x52c5, 0x0000, 0, 19 }, /* #86 */
    { 0x2b41c3, 0x2b4146, 0x52c5, 0x0000, 0, 19 }, /* #86 b */
    { 0x1e0496, 0x1e0446, 0x0a55, 0x0000, 0, 16 }, /* #87 */
    { 0x217b43, 0x217346, 0x0a55, 0x0000, 0, 16 }, /* #87 b */
    { 0x037347, 0x037306, 0x7fa6, 0x07fa, 0, 36 }, /* #88 */
    { 0x3c0c92, 0x3c0406, 0x7fa6, 0x07fa, 0, 36 }, /* #88 b */
    { 0x306106, 0x306107, 0x36d2, 0x0036, 0, 40 }, /* #89 */
    { 0x0f1ed3, 0x0f1607, 0x36d2, 0x0036, 0, 40 }, /* #89 b */
    { 0x2e1452, 0x2e1446, 0x0d2a, 0x0000, 0, 28 }, /* #90 */
    { 0x116b87, 0x116346, 0x0d2a, 0x0000, 0, 28 }, /* #90 b */
    { 0x3a1597, 0x3a1d03, 0xdf48, 0x0001, 0, 15 }, /* #91 */
    { 0x056a42, 0x056a03, 0xdf48, 0x0001, 0, 15 }, /* #91 b */
    { 0x006d57, 0x006546, 0x69f6, 0x0000, 0, 18 }, /* #92 */
    { 0x3f1282, 0x3f1246, 0x69f6, 0x0000, 0, 18 }, /* #92 b */
    { 0x3d17d7, 0x3d1746, 0x2d9a, 0x0000, 0, 57 }, /* #93 */
    { 0x026802, 0x026046, 0x2d9a, 0x0000, 0, 57 }, /* #93 b */
    { 0x3804d7, 0x380c46, 0xe904, 0x0000, 0, 56 }, /* #94 */
    { 0x077b02, 0x077b46, 0xe904, 0x0000, 0, 56 }, /* #94 b */
    { 0x195296, 0x195a06, 0xf3a5, 0x001e, 0, 43 }, /* #95 */
    { 0x262d43, 0x262d06, 0xf3a5, 0x001e, 0, 43 }, /* #95 b */
};
uint32_t const g_cTests_shr_u16_intel = RT_ELEMENTS(g_aTests_shr_u16_intel);

BINU16_TEST_T const g_aTests_sar_u16_intel[] =
{
    { 0x2b0f43, 0x2b0746, 0x0000, 0x0000, 0, 26 }, /* #0 */
    { 0x147096, 0x147046, 0x0000, 0x0000, 0, 26 }, /* #0 b */
    { 0x1f0f12, 0x1f0746, 0x0000, 0x0000, 0, 27 }, /* #1 */
    { 0x2070c7, 0x207046, 0x0000, 0x0000, 0, 27 }, /* #1 b */
    { 0x3e5896, 0x3e5046, 0x0000, 0x0000, 0, 40 }, /* #2 */
    { 0x012743, 0x012746, 0x0000, 0x0000, 0, 40 }, /* #2 b */
    { 0x1e1047, 0x1e1046, 0x0000, 0x0000, 0, 51 }, /* #3 */
    { 0x216f92, 0x216746, 0x0000, 0x0000, 0, 51 }, /* #3 b */
    { 0x363b56, 0x363346, 0x0000, 0x0000, 0, 57 }, /* #4 */
    { 0x094483, 0x094446, 0x0000, 0x0000, 0, 57 }, /* #4 b */
    { 0x2e6b17, 0x2e6346, 0x0000, 0x0000, 0, 46 }, /* #5 */
    { 0x1114c2, 0x111446, 0x0000, 0x0000, 0, 46 }, /* #5 b */
    { 0x0c4456, 0x0c4456, 0xcdff, 0xcdff, 0, 32 }, /* #6 */
    { 0x333b83, 0x333b83, 0xcdff, 0xcdff, 0, 32 }, /* #6 b */
    { 0x3c7a46, 0x3c7206, 0x7b5e, 0x000f, 0, 11 }, /* #7 */
    { 0x030593, 0x030506, 0x7b5e, 0x000f, 0, 11 }, /* #7 b */
    { 0x196ed6, 0x196687, 0x9e84, 0xfff9, 0, 12 }, /* #8 */
    { 0x261103, 0x261187, 0x9e84, 0xfff9, 0, 12 }, /* #8 b */
    { 0x134593, 0x134587, 0xa334, 0xffff, 0, 17 }, /* #9 */
    { 0x2c3a46, 0x2c3287, 0xa334, 0xffff, 0, 17 }, /* #9 b */
    { 0x2905d7, 0x290587, 0x9cc4, 0xffff, 0, 22 }, /* #10 */
    { 0x167a02, 0x167287, 0x9cc4, 0xffff, 0, 22 }, /* #10 b */
    { 0x391f56, 0x391702, 0x0ec1, 0x003b, 0, 6  }, /* #11 */
    { 0x066083, 0x066002, 0x0ec1, 0x003b, 0, 6  }, /* #11 b */
    { 0x372957, 0x372187, 0xc059, 0xffff, 0, 56 }, /* #12 */
    { 0x085682, 0x085687, 0xc059, 0xffff, 0, 56 }, /* #12 b */
    { 0x396882, 0x396007, 0x3886, 0x0e21, 0, 34 }, /* #13 */
    { 0x061757, 0x061707, 0x3886, 0x0e21, 0, 34 }, /* #13 b */
    { 0x212997, 0x212147, 0x40cb, 0x0000, 0, 15 }, /* #14 */
    { 0x1e5642, 0x1e5647, 0x40cb, 0x0000, 0, 15 }, /* #14 b */
    { 0x215812, 0x215087, 0xd3e3, 0xffff, 0, 15 }, /* #15 */
    { 0x1e27c7, 0x1e2787, 0xd3e3, 0xffff, 0, 15 }, /* #15 b */
    { 0x0a2012, 0x0a2087, 0x94e1, 0xffff, 0, 28 }, /* #16 */
    { 0x355fc7, 0x355787, 0x94e1, 0xffff, 0, 28 }, /* #16 b */
    { 0x167443, 0x167446, 0x1782, 0x0000, 0, 23 }, /* #17 */
    { 0x290b96, 0x290346, 0x1782, 0x0000, 0, 23 }, /* #17 b */
    { 0x1c4982, 0x1c4146, 0x18b0, 0x0000, 0, 31 }, /* #18 */
    { 0x233657, 0x233646, 0x18b0, 0x0000, 0, 31 }, /* #18 b */
    { 0x1e42d2, 0x1e4246, 0x2550, 0x0000, 0, 61 }, /* #19 */
    { 0x213d07, 0x213546, 0x2550, 0x0000, 0, 61 }, /* #19 b */
    { 0x2c6093, 0x2c6083, 0xd2aa, 0xff4a, 0, 38 }, /* #20 */
    { 0x131f46, 0x131783, 0xd2aa, 0xff4a, 0, 38 }, /* #20 b */
    { 0x172913, 0x172913, 0xf49d, 0xf49d, 0, 32 }, /* #21 */
    { 0x2856c6, 0x2856c6, 0xf49d, 0xf49d, 0, 32 }, /* #21 b */
    { 0x275b92, 0x275382, 0xf982, 0xfffe, 0, 10 }, /* #22 */
    { 0x182447, 0x182482, 0xf982, 0xfffe, 0, 10 }, /* #22 b */
    { 0x223513, 0x223503, 0x7f68, 0x0007, 0, 44 }, /* #23 */
    { 0x1d4ac6, 0x1d4203, 0x7f68, 0x0007, 0, 44 }, /* #23 b */
    { 0x0275c2, 0x027546, 0x2c3c, 0x0000, 0, 54 }, /* #24 */
    { 0x3d0a17, 0x3d0246, 0x2c3c, 0x0000, 0, 54 }, /* #24 b */
    { 0x0c3006, 0x0c3086, 0x9a30, 0xf9a3, 0, 36 }, /* #25 */
    { 0x334fd3, 0x334786, 0x9a30, 0xf9a3, 0, 36 }, /* #25 b */
    { 0x2f7096, 0x2f7046, 0x0c4c, 0x0000, 0, 27 }, /* #26 */
    { 0x100f43, 0x100746, 0x0c4c, 0x0000, 0, 27 }, /* #26 b */
    { 0x2470d3, 0x247046, 0x58ed, 0x0000, 0, 16 }, /* #27 */
    { 0x1b0f06, 0x1b0746, 0x58ed, 0x0000, 0, 16 }, /* #27 b */
    { 0x2929d6, 0x292186, 0xeddb, 0xffb7, 0, 38 }, /* #28 */
    { 0x165603, 0x165686, 0xeddb, 0xffb7, 0, 38 }, /* #28 b */
    { 0x180e86, 0x180687, 0xabbf, 0xffff, 0, 63 }, /* #29 */
    { 0x277153, 0x277187, 0xabbf, 0xffff, 0, 63 }, /* #29 b */
    { 0x001652, 0x001687, 0x9063, 0xffff, 0, 19 }, /* #30 */
    { 0x3f6987, 0x3f6187, 0x9063, 0xffff, 0, 19 }, /* #30 b */
    { 0x186846, 0x186046, 0x7554, 0x0000, 0, 29 }, /* #31 */
    { 0x271793, 0x271746, 0x7554, 0x0000, 0, 29 }, /* #31 b */
    { 0x001a83, 0x001206, 0x639a, 0x018e, 0, 38 }, /* #32 */
    { 0x3f6556, 0x3f6506, 0x639a, 0x018e, 0, 38 }, /* #32 b */
    { 0x0754c6, 0x075487, 0xfbdd, 0xffde, 0, 5  }, /* #33 */
    { 0x382b13, 0x382387, 0xfbdd, 0xffde, 0, 5  }, /* #33 b */
    { 0x3305d3, 0x330587, 0xbba0, 0xffff, 0, 23 }, /* #34 */
    { 0x0c7a06, 0x0c7287, 0xbba0, 0xffff, 0, 23 }, /* #34 b */
    { 0x1b1397, 0x1b1387, 0xe0bb, 0xffff, 0, 28 }, /* #35 */
    { 0x246c42, 0x246487, 0xe0bb, 0xffff, 0, 28 }, /* #35 b */
    { 0x154e93, 0x154607, 0x54cf, 0x00a9, 0, 39 }, /* #36 */
    { 0x2a3146, 0x2a3107, 0x54cf, 0x00a9, 0, 39 }, /* #36 b */
    { 0x3f6113, 0x3f6103, 0x62c1, 0x0062, 0, 8  }, /* #37 */
    { 0x001ec6, 0x001603, 0x62c1, 0x0062, 0, 8  }, /* #37 b */
    { 0x2f5657, 0x2f5646, 0x1f88, 0x0000, 0, 60 }, /* #38 */
    { 0x102982, 0x102146, 0x1f88, 0x0000, 0, 60 }, /* #38 b */
    { 0x216452, 0x216446, 0x43b8, 0x0000, 0, 28 }, /* #39 */
    { 0x1e1b87, 0x1e1346, 0x43b8, 0x0000, 0, 28 }, /* #39 b */
    { 0x151f53, 0x151787, 0x991b, 0xffff, 0, 18 }, /* #40 */
    { 0x2a6086, 0x2a6087, 0x991b, 0xffff, 0, 18 }, /* #40 b */
    { 0x1f7387, 0x1f7387, 0xebea, 0xffff, 0, 27 }, /* #41 */
    { 0x200c52, 0x200487, 0xebea, 0xffff, 0, 27 }, /* #41 b */
    { 0x1138c2, 0x113087, 0xde2d, 0xffff, 0, 60 }, /* #42 */
    { 0x2e4717, 0x2e4787, 0xde2d, 0xffff, 0, 60 }, /* #42 b */
    { 0x0c6c82, 0x0c6487, 0x9fc2, 0xfffc, 0, 13 }, /* #43 */
    { 0x331357, 0x331387, 0x9fc2, 0xfffc, 0, 13 }, /* #43 b */
    { 0x382642, 0x382646, 0x5ed9, 0x0000, 0, 61 }, /* #44 */
    { 0x075997, 0x075146, 0x5ed9, 0x0000, 0, 61 }, /* #44 b */
    { 0x355583, 0x355587, 0xcfa9, 0xffff, 0, 53 }, /* #45 */
    { 0x0a2a56, 0x0a2287, 0xcfa9, 0xffff, 0, 53 }, /* #45 b */
    { 0x294bc6, 0x294346, 0x4bce, 0x0000, 0, 55 }, /* #46 */
    { 0x163413, 0x163446, 0x4bce, 0x0000, 0, 55 }, /* #46 b */
    { 0x313013, 0x313087, 0xa872, 0xffff, 0, 29 }, /* #47 */
    { 0x0e4fc6, 0x0e4787, 0xa872, 0xffff, 0, 29 }, /* #47 b */
    { 0x1e56d2, 0x1e5646, 0x05b0, 0x0000, 0, 59 }, /* #48 */
    { 0x212907, 0x212146, 0x05b0, 0x0000, 0, 59 }, /* #48 b */
    { 0x3c6352, 0x3c6306, 0x33b8, 0x0003, 0, 44 }, /* #49 */
    { 0x031c87, 0x031406, 0x33b8, 0x0003, 0, 44 }, /* #49 b */
    { 0x0b5b87, 0x0b5387, 0xc124, 0xffff, 0, 47 }, /* #50 */
    { 0x342452, 0x342487, 0xc124, 0xffff, 0, 47 }, /* #50 b */
    { 0x1a7f97, 0x1a7707, 0x4a27, 0x0944, 0, 3  }, /* #51 */
    { 0x250042, 0x250007, 0x4a27, 0x0944, 0, 3  }, /* #51 b */
    { 0x172dc6, 0x172546, 0x79cf, 0x0000, 0, 62 }, /* #52 */
    { 0x285213, 0x285246, 0x79cf, 0x0000, 0, 62 }, /* #52 b */
    { 0x3220c3, 0x322047, 0x1b7c, 0x0000, 0, 13 }, /* #53 */
    { 0x0d5f16, 0x0d5747, 0x1b7c, 0x0000, 0, 13 }, /* #53 b */
    { 0x1d7dd7, 0x1d7586, 0xc9e3, 0xfff9, 0, 11 }, /* #54 */
    { 0x220202, 0x220286, 0xc9e3, 0xfff9, 0, 11 }, /* #54 b */
    { 0x052597, 0x052582, 0xe200, 0xfff1, 0, 9  }, /* #55 */
    { 0x3a5a42, 0x3a5282, 0xe200, 0xfff1, 0, 9  }, /* #55 b */
    { 0x3f7c07, 0x3f7487, 0xa118, 0xfa11, 0, 36 }, /* #56 */
    { 0x0003d2, 0x000387, 0xa118, 0xfa11, 0, 36 }, /* #56 b */
    { 0x152c42, 0x152487, 0xacec, 0xffff, 0, 26 }, /* #57 */
    { 0x2a5397, 0x2a5387, 0xacec, 0xffff, 0, 26 }, /* #57 b */
    { 0x014d57, 0x014503, 0x064b, 0x0325, 0, 1  }, /* #58 */
    { 0x3e3282, 0x3e3203, 0x064b, 0x0325, 0, 1  }, /* #58 b */
    { 0x086253, 0x086287, 0xac4d, 0xffff, 0, 49 }, /* #59 */
    { 0x371d86, 0x371587, 0xac4d, 0xffff, 0, 49 }, /* #59 b */
    { 0x117693, 0x117646, 0x26ea, 0x0000, 0, 23 }, /* #60 */
    { 0x2e0946, 0x2e0146, 0x26ea, 0x0000, 0, 23 }, /* #60 b */
    { 0x060946, 0x060187, 0xaa91, 0xffff, 0, 27 }, /* #61 */
    { 0x397693, 0x397687, 0xaa91, 0xffff, 0, 27 }, /* #61 b */
    { 0x383943, 0x383146, 0x2818, 0x0000, 0, 47 }, /* #62 */
    { 0x074696, 0x074646, 0x2818, 0x0000, 0, 47 }, /* #62 b */
    { 0x0b7146, 0x0b7182, 0xe481, 0xff92, 0, 38 }, /* #63 */
    { 0x340e93, 0x340682, 0xe481, 0xff92, 0, 38 }, /* #63 b */
    { 0x1733d2, 0x173346, 0x316c, 0x0000, 0, 63 }, /* #64 */
    { 0x284c07, 0x284446, 0x316c, 0x0000, 0, 63 }, /* #64 b */
    { 0x187982, 0x187146, 0x1974, 0x0000, 0, 25 }, /* #65 */
    { 0x270657, 0x270646, 0x1974, 0x0000, 0, 25 }, /* #65 b */
    { 0x395a42, 0x395246, 0x7023, 0x0000, 0, 62 }, /* #66 */
    { 0x062597, 0x062546, 0x7023, 0x0000, 0, 62 }, /* #66 b */
    { 0x177006, 0x177046, 0x36cf, 0x0000, 0, 48 }, /* #67 */
    { 0x280fd3, 0x280746, 0x36cf, 0x0000, 0, 48 }, /* #67 b */
    { 0x356606, 0x356606, 0x3c04, 0x003c, 0, 40 }, /* #68 */
    { 0x0a19d3, 0x0a1106, 0x3c04, 0x003c, 0, 40 }, /* #68 b */
    { 0x0c7082, 0x0c7046, 0x2272, 0x0000, 0, 31 }, /* #69 */
    { 0x330f57, 0x330746, 0x2272, 0x0000, 0, 31 }, /* #69 b */
    { 0x1f2f46, 0x1f2782, 0xae14, 0xeb85, 0, 34 }, /* #70 */
    { 0x205093, 0x205082, 0xae14, 0xeb85, 0, 34 }, /* #70 b */
    { 0x1a3b47, 0x1a3386, 0xc171, 0xfc17, 0, 36 }, /* #71 */
    { 0x254492, 0x254486, 0xc171, 0xfc17, 0, 36 }, /* #71 b */
    { 0x086cd3, 0x086487, 0x9e22, 0xffff, 0, 18 }, /* #72 */
    { 0x371306, 0x371387, 0x9e22, 0xffff, 0, 18 }, /* #72 b */
    { 0x3a4247, 0x3a4203, 0x738f, 0x0073, 0, 40 }, /* #73 */
    { 0x053d92, 0x053503, 0x738f, 0x0073, 0, 40 }, /* #73 b */
    { 0x272206, 0x272287, 0x8d2f, 0xffff, 0, 24 }, /* #74 */
    { 0x185dd3, 0x185587, 0x8d2f, 0xffff, 0, 24 }, /* #74 b */
    { 0x061003, 0x061087, 0xf47f, 0xffff, 0, 56 }, /* #75 */
    { 0x396fd6, 0x396787, 0xf47f, 0xffff, 0, 56 }, /* #75 b */
    { 0x2d0d13, 0x2d0502, 0x7320, 0x0e64, 0, 35 }, /* #76 */
    { 0x1272c6, 0x127202, 0x7320, 0x0e64, 0, 35 }, /* #76 b */
    { 0x366453, 0x366446, 0x1965, 0x0000, 0, 57 }, /* #77 */
    { 0x091b86, 0x091346, 0x1965, 0x0000, 0, 57 }, /* #77 b */
    { 0x3340c3, 0x334047, 0x115a, 0x0000, 0, 45 }, /* #78 */
    { 0x0c3f16, 0x0c3747, 0x115a, 0x0000, 0, 45 }, /* #78 b */
    { 0x053683, 0x053687, 0x9bf5, 0xffff, 0, 58 }, /* #79 */
    { 0x3a4956, 0x3a4187, 0x9bf5, 0xffff, 0, 58 }, /* #79 b */
    { 0x282d53, 0x282546, 0x7291, 0x0000, 0, 61 }, /* #80 */
    { 0x175286, 0x175246, 0x7291, 0x0000, 0, 61 }, /* #80 b */
    { 0x184f17, 0x184787, 0xe368, 0xffff, 0, 31 }, /* #81 */
    { 0x2730c2, 0x273087, 0xe368, 0xffff, 0, 31 }, /* #81 b */
    { 0x3d2c82, 0x3d2402, 0x7555, 0x0007, 0, 44 }, /* #82 */
    { 0x025357, 0x025302, 0x7555, 0x0007, 0, 44 }, /* #82 b */
    { 0x266703, 0x266746, 0x0fef, 0x0000, 0, 51 }, /* #83 */
    { 0x1918d6, 0x191046, 0x0fef, 0x0000, 0, 51 }, /* #83 b */
    { 0x040583, 0x040587, 0xd06b, 0xfd06, 0, 36 }, /* #84 */
    { 0x3b7a56, 0x3b7287, 0xd06b, 0xfd06, 0, 36 }, /* #84 b */
    { 0x3c2257, 0x3c2287, 0xe1eb, 0xffff, 0, 27 }, /* #85 */
    { 0x035d82, 0x035587, 0xe1eb, 0xffff, 0, 27 }, /* #85 b */
    { 0x2b12d3, 0x2b1287, 0x9c0b, 0xffff, 0, 50 }, /* #86 */
    { 0x146d06, 0x146587, 0x9c0b, 0xffff, 0, 50 }, /* #86 b */
    { 0x0e4f02, 0x0e4746, 0x40d7, 0x0000, 0, 53 }, /* #87 */
    { 0x3130d7, 0x313046, 0x40d7, 0x0000, 0, 53 }, /* #87 b */
    { 0x333556, 0x333546, 0x1eba, 0x0000, 0, 26 }, /* #88 */
    { 0x0c4a83, 0x0c4246, 0x1eba, 0x0000, 0, 26 }, /* #88 b */
    { 0x077287, 0x077246, 0x1870, 0x0000, 0, 54 }, /* #89 */
    { 0x380d52, 0x380546, 0x1870, 0x0000, 0, 54 }, /* #89 b */
    { 0x116a82, 0x116287, 0xa96a, 0xffd4, 0, 41 }, /* #90 */
    { 0x2e1557, 0x2e1587, 0xa96a, 0xffd4, 0, 41 }, /* #90 b */
    { 0x253743, 0x253703, 0x1823, 0x0001, 0, 44 }, /* #91 */
    { 0x1a4896, 0x1a4003, 0x1823, 0x0001, 0, 44 }, /* #91 b */
    { 0x137e87, 0x137602, 0x790b, 0x00f2, 0, 39 }, /* #92 */
    { 0x2c0152, 0x2c0102, 0x790b, 0x00f2, 0, 39 }, /* #92 b */
    { 0x3c7853, 0x3c7046, 0x7dd1, 0x0000, 0, 55 }, /* #93 */
    { 0x030786, 0x030746, 0x7dd1, 0x0000, 0, 55 }, /* #93 b */
    { 0x3b7752, 0x3b7786, 0xce69, 0xffe7, 0, 41 }, /* #94 */
    { 0x040887, 0x040086, 0xce69, 0xffe7, 0, 41 }, /* #94 b */
    { 0x1b03d7, 0x1b0383, 0x8e02, 0xfff8, 0, 12 }, /* #95 */
    { 0x247c02, 0x247483, 0x8e02, 0xfff8, 0, 12 }, /* #95 b */
};
uint32_t const g_cTests_sar_u16_intel = RT_ELEMENTS(g_aTests_sar_u16_intel);

BINU32_TEST_T const g_aTests_rol_u32_intel[] =
{
    { 0x035283, 0x035282, 0x00000000, 0x00000000, 0, 54 }, /* #0 */
    { 0x3c2d56, 0x3c2556, 0x00000000, 0x00000000, 0, 54 }, /* #0 b */
    { 0x0707d7, 0x0707d6, 0x00000000, 0x00000000, 0, 105 }, /* #1 */
    { 0x387802, 0x387002, 0x00000000, 0x00000000, 0, 105 }, /* #1 b */
    { 0x1c5652, 0x1c5652, 0x00000000, 0x00000000, 0, 9  }, /* #2 */
    { 0x232987, 0x232186, 0x00000000, 0x00000000, 0, 9  }, /* #2 b */
    { 0x044b02, 0x044302, 0x00000000, 0x00000000, 0, 108 }, /* #3 */
    { 0x3b34d7, 0x3b34d6, 0x00000000, 0x00000000, 0, 108 }, /* #3 b */
    { 0x272703, 0x272702, 0x00000000, 0x00000000, 0, 35 }, /* #4 */
    { 0x1858d6, 0x1850d6, 0x00000000, 0x00000000, 0, 35 }, /* #4 b */
    { 0x0d7796, 0x0d7796, 0x00000000, 0x00000000, 0, 0  }, /* #5 */
    { 0x320843, 0x320843, 0x00000000, 0x00000000, 0, 0  }, /* #5 b */
    { 0x1967c6, 0x196fc7, 0xa8351955, 0x46556a0d, 0, 14 }, /* #6 */
    { 0x261813, 0x261813, 0xa8351955, 0x46556a0d, 0, 14 }, /* #6 b */
    { 0x005946, 0x005146, 0x1483846e, 0x6e148384, 0, 120 }, /* #7 */
    { 0x3f2693, 0x3f2692, 0x1483846e, 0x6e148384, 0, 120 }, /* #7 b */
    { 0x046fc3, 0x046fc2, 0x4b88f32b, 0x5c47995a, 0, 35 }, /* #8 */
    { 0x3b1016, 0x3b1816, 0x4b88f32b, 0x5c47995a, 0, 35 }, /* #8 b */
    { 0x395506, 0x395d07, 0x5ec7eea6, 0x2f63f753, 0, 95 }, /* #9 */
    { 0x062ad3, 0x062ad3, 0x5ec7eea6, 0x2f63f753, 0, 95 }, /* #9 b */
    { 0x255996, 0x255196, 0x3982bf92, 0x91cc15fc, 0, 27 }, /* #10 */
    { 0x1a2643, 0x1a2642, 0x3982bf92, 0x91cc15fc, 0, 27 }, /* #10 b */
    { 0x3a6cd2, 0x3a64d3, 0x3e946513, 0x28ca267d, 0, 105 }, /* #11 */
    { 0x051307, 0x051307, 0x3e946513, 0x28ca267d, 0, 105 }, /* #11 b */
    { 0x385dc2, 0x3855c2, 0xc29b8114, 0x08a614dc, 0, 83 }, /* #12 */
    { 0x072217, 0x072216, 0xc29b8114, 0x08a614dc, 0, 83 }, /* #12 b */
    { 0x141693, 0x141693, 0x2737c54c, 0x309cdf15, 0, 122 }, /* #13 */
    { 0x2b6946, 0x2b6147, 0x2737c54c, 0x309cdf15, 0, 122 }, /* #13 b */
    { 0x2c0557, 0x2c0557, 0x1688e3ed, 0xed1688e3, 0, 56 }, /* #14 */
    { 0x137a82, 0x137283, 0x1688e3ed, 0xed1688e3, 0, 56 }, /* #14 b */
    { 0x370cc3, 0x370cc2, 0x8e703c13, 0x09c7381e, 0, 119 }, /* #15 */
    { 0x087316, 0x087b16, 0x8e703c13, 0x09c7381e, 0, 119 }, /* #15 b */
    { 0x106187, 0x106986, 0x9a23ce3d, 0x688f38f6, 0, 98 }, /* #16 */
    { 0x2f1e52, 0x2f1e52, 0x9a23ce3d, 0x688f38f6, 0, 98 }, /* #16 b */
    { 0x1242c7, 0x1242c7, 0x232baf41, 0xa09195d7, 0, 119 }, /* #17 */
    { 0x2d3d12, 0x2d3513, 0x232baf41, 0xa09195d7, 0, 119 }, /* #17 b */
    { 0x0a2507, 0x0a2506, 0xc29c3b19, 0x76338538, 0, 113 }, /* #18 */
    { 0x355ad2, 0x3552d2, 0xc29c3b19, 0x76338538, 0, 113 }, /* #18 b */
    { 0x3a3007, 0x3a3007, 0xfe8adca7, 0xfe8adca7, 0, 0  }, /* #19 */
    { 0x054fd2, 0x054fd2, 0xfe8adca7, 0xfe8adca7, 0, 0  }, /* #19 b */
    { 0x0d02c3, 0x0d02c3, 0x05697d48, 0x7d480569, 0, 16 }, /* #20 */
    { 0x327d16, 0x327517, 0x05697d48, 0x7d480569, 0, 16 }, /* #20 b */
    { 0x037b16, 0x037316, 0x302d166f, 0x6f302d16, 0, 120 }, /* #21 */
    { 0x3c04c3, 0x3c04c2, 0x302d166f, 0x6f302d16, 0, 120 }, /* #21 b */
    { 0x223217, 0x223a16, 0xa1c4fd25, 0xb4389fa4, 0, 61 }, /* #22 */
    { 0x1d4dc2, 0x1d4dc2, 0xa1c4fd25, 0xb4389fa4, 0, 61 }, /* #22 b */
    { 0x250957, 0x250157, 0x328e8493, 0xa124cca3, 0, 14 }, /* #23 */
    { 0x1a7682, 0x1a7683, 0x328e8493, 0xa124cca3, 0, 14 }, /* #23 b */
    { 0x090817, 0x090817, 0x4f8c1996, 0x3e306659, 0, 66 }, /* #24 */
    { 0x3677c2, 0x367fc3, 0x4f8c1996, 0x3e306659, 0, 66 }, /* #24 b */
    { 0x033e86, 0x033686, 0x28749568, 0x1d255a0a, 0, 38 }, /* #25 */
    { 0x3c4153, 0x3c4152, 0x28749568, 0x1d255a0a, 0, 38 }, /* #25 b */
    { 0x076f83, 0x076f83, 0x7ca5ed6e, 0x9f297b5b, 0, 94 }, /* #26 */
    { 0x381056, 0x381857, 0x7ca5ed6e, 0x9f297b5b, 0, 94 }, /* #26 b */
    { 0x3d5112, 0x3d5113, 0xdfc81e57, 0x95f7f207, 0, 118 }, /* #27 */
    { 0x022ec7, 0x0226c7, 0xdfc81e57, 0x95f7f207, 0, 118 }, /* #27 b */
    { 0x316952, 0x316153, 0x2783dbac, 0xac2783db, 0, 88 }, /* #28 */
    { 0x0e1687, 0x0e1687, 0x2783dbac, 0xac2783db, 0, 88 }, /* #28 b */
    { 0x0a7ad6, 0x0a72d6, 0x0680f250, 0x1a03c940, 0, 2  }, /* #29 */
    { 0x350503, 0x350502, 0x0680f250, 0x1a03c940, 0, 2  }, /* #29 b */
    { 0x3458d6, 0x3450d6, 0xf1371703, 0x4dc5c0fc, 0, 6  }, /* #30 */
    { 0x0b2703, 0x0b2702, 0xf1371703, 0x4dc5c0fc, 0, 6  }, /* #30 b */
    { 0x191096, 0x191897, 0x61f230fd, 0xe461fac3, 0, 73 }, /* #31 */
    { 0x266f43, 0x266f43, 0x61f230fd, 0xe461fac3, 0, 73 }, /* #31 b */
    { 0x301613, 0x301e12, 0x8154ea66, 0x154ea668, 0, 68 }, /* #32 */
    { 0x0f69c6, 0x0f69c6, 0x8154ea66, 0x154ea668, 0, 68 }, /* #32 b */
    { 0x110b97, 0x110b97, 0x8e692e79, 0xcd25cf31, 0, 37 }, /* #33 */
    { 0x2e7442, 0x2e7c43, 0x8e692e79, 0xcd25cf31, 0, 37 }, /* #33 b */
    { 0x3b40c6, 0x3b48c7, 0x5ca0c2eb, 0x75ae5061, 0, 55 }, /* #34 */
    { 0x043f13, 0x043f13, 0x5ca0c2eb, 0x75ae5061, 0, 55 }, /* #34 b */
    { 0x332ac7, 0x3322c7, 0xc3b7cc12, 0xcc12c3b7, 0, 80 }, /* #35 */
    { 0x0c5512, 0x0c5513, 0xc3b7cc12, 0xcc12c3b7, 0, 80 }, /* #35 b */
    { 0x144056, 0x144856, 0x93ae40e7, 0x73c9d720, 0, 87 }, /* #36 */
    { 0x2b3f83, 0x2b3f82, 0x93ae40e7, 0x73c9d720, 0, 87 }, /* #36 b */
    { 0x263207, 0x263a07, 0x42b6ec2a, 0x5215b761, 0, 123 }, /* #37 */
    { 0x194dd2, 0x194dd3, 0x42b6ec2a, 0x5215b761, 0, 123 }, /* #37 b */
    { 0x151e47, 0x151646, 0xdf8996e3, 0xdc7bf132, 0, 85 }, /* #38 */
    { 0x2a6192, 0x2a6192, 0xdf8996e3, 0xdc7bf132, 0, 85 }, /* #38 b */
    { 0x121017, 0x121017, 0x1959a6a8, 0x959a6a81, 0, 36 }, /* #39 */
    { 0x2d6fc2, 0x2d67c3, 0x1959a6a8, 0x959a6a81, 0, 36 }, /* #39 b */
    { 0x0c5313, 0x0c5b13, 0xad20aae2, 0x05571569, 0, 75 }, /* #40 */
    { 0x332cc6, 0x332cc7, 0xad20aae2, 0x05571569, 0, 75 }, /* #40 b */
    { 0x1070c7, 0x1078c6, 0xb49cc04e, 0x4e60275a, 0, 71 }, /* #41 */
    { 0x2f0f12, 0x2f0f12, 0xb49cc04e, 0x4e60275a, 0, 71 }, /* #41 b */
    { 0x1452c7, 0x145ac7, 0x78b94f24, 0x29e48f17, 0, 13 }, /* #42 */
    { 0x2b2d12, 0x2b2d13, 0x78b94f24, 0x29e48f17, 0, 13 }, /* #42 b */
    { 0x3d2bd6, 0x3d2bd6, 0x686a69a8, 0x6a1a1a9a, 0, 118 }, /* #43 */
    { 0x025403, 0x025c02, 0x686a69a8, 0x6a1a1a9a, 0, 118 }, /* #43 b */
    { 0x114746, 0x114f47, 0x5af6a276, 0xda89d96b, 0, 74 }, /* #44 */
    { 0x2e3893, 0x2e3893, 0x5af6a276, 0xda89d96b, 0, 74 }, /* #44 b */
    { 0x025953, 0x025152, 0x0d386853, 0xa61a70d0, 0, 25 }, /* #45 */
    { 0x3d2686, 0x3d2686, 0x0d386853, 0xa61a70d0, 0, 25 }, /* #45 b */
    { 0x0b7392, 0x0b7b92, 0x4f4b08a6, 0x114c9e96, 0, 49 }, /* #46 */
    { 0x340c47, 0x340c46, 0x4f4b08a6, 0x114c9e96, 0, 49 }, /* #46 b */
    { 0x1a5143, 0x1a5143, 0x2e21a2a0, 0x501710d1, 0, 55 }, /* #47 */
    { 0x252e96, 0x252697, 0x2e21a2a0, 0x501710d1, 0, 55 }, /* #47 b */
    { 0x1c5697, 0x1c5697, 0x07d90eb1, 0xac41f643, 0, 54 }, /* #48 */
    { 0x232942, 0x232143, 0x07d90eb1, 0xac41f643, 0, 54 }, /* #48 b */
    { 0x220cd7, 0x220cd7, 0x51c9bda9, 0x7b52a393, 0, 113 }, /* #49 */
    { 0x1d7302, 0x1d7b03, 0x51c9bda9, 0x7b52a393, 0, 113 }, /* #49 b */
    { 0x216213, 0x216a12, 0x48c8c129, 0xa5232304, 0, 122 }, /* #50 */
    { 0x1e1dc6, 0x1e1dc6, 0x48c8c129, 0xa5232304, 0, 122 }, /* #50 b */
    { 0x266b07, 0x266b06, 0xa7f923cb, 0x7f923cba, 0, 4  }, /* #51 */
    { 0x1914d2, 0x191cd2, 0xa7f923cb, 0x7f923cba, 0, 4  }, /* #51 b */
    { 0x096003, 0x096003, 0xfe7c8014, 0xf3e400a7, 0, 35 }, /* #52 */
    { 0x361fd6, 0x3617d7, 0xfe7c8014, 0xf3e400a7, 0, 35 }, /* #52 b */
    { 0x1c57d2, 0x1c5fd3, 0x4dbeaddd, 0xbeaddd4d, 0, 72 }, /* #53 */
    { 0x232807, 0x232807, 0x4dbeaddd, 0xbeaddd4d, 0, 72 }, /* #53 b */
    { 0x226807, 0x226807, 0xf09a2d1f, 0xf09a2d1f, 0, 64 }, /* #54 */
    { 0x1d17d2, 0x1d17d2, 0xf09a2d1f, 0xf09a2d1f, 0, 64 }, /* #54 b */
    { 0x0e20d3, 0x0e20d3, 0xee432e45, 0xb90cb917, 0, 66 }, /* #55 */
    { 0x315f06, 0x315707, 0xee432e45, 0xb90cb917, 0, 66 }, /* #55 b */
    { 0x051087, 0x051887, 0x8bb7e7f3, 0xf38bb7e7, 0, 24 }, /* #56 */
    { 0x3a6f52, 0x3a6f53, 0x8bb7e7f3, 0xf38bb7e7, 0, 24 }, /* #56 b */
    { 0x1d5d57, 0x1d5d56, 0x878aadbb, 0xaadbb878, 0, 108 }, /* #57 */
    { 0x222282, 0x222a82, 0x878aadbb, 0xaadbb878, 0, 108 }, /* #57 b */
    { 0x2e6482, 0x2e6482, 0x2267272f, 0xe4e5e44c, 0, 77 }, /* #58 */
    { 0x111b57, 0x111356, 0x2267272f, 0xe4e5e44c, 0, 77 }, /* #58 b */
    { 0x325b83, 0x325383, 0x05e84eb4, 0xa02f4275, 0, 91 }, /* #59 */
    { 0x0d2456, 0x0d2457, 0x05e84eb4, 0xa02f4275, 0, 91 }, /* #59 b */
    { 0x3f4383, 0x3f4b82, 0x4c073e99, 0x73e994c0, 0, 12 }, /* #60 */
    { 0x003c56, 0x003c56, 0x4c073e99, 0x73e994c0, 0, 12 }, /* #60 b */
    { 0x2d3993, 0x2d3193, 0x363afaf4, 0x7d7a1b1d, 0, 79 }, /* #61 */
    { 0x124646, 0x124647, 0x363afaf4, 0x7d7a1b1d, 0, 79 }, /* #61 b */
    { 0x0d73d7, 0x0d73d7, 0x006be2ee, 0x0035f177, 0, 63 }, /* #62 */
    { 0x320c02, 0x320403, 0x006be2ee, 0x0035f177, 0, 63 }, /* #62 b */
    { 0x2d03c7, 0x2d03c6, 0xd283582b, 0xc15e941a, 0, 51 }, /* #63 */
    { 0x127c12, 0x127412, 0xd283582b, 0xc15e941a, 0, 51 }, /* #63 b */
    { 0x097b16, 0x097b16, 0x9c086327, 0x63279c08, 0, 112 }, /* #64 */
    { 0x3604c3, 0x360cc2, 0x9c086327, 0x63279c08, 0, 112 }, /* #64 b */
    { 0x0e4582, 0x0e4d82, 0xaf206c66, 0xbc81b19a, 0, 34 }, /* #65 */
    { 0x313a57, 0x313a56, 0xaf206c66, 0xbc81b19a, 0, 34 }, /* #65 b */
    { 0x297252, 0x297a53, 0x48bcedfe, 0xbfc9179d, 0, 21 }, /* #66 */
    { 0x160d87, 0x160d87, 0x48bcedfe, 0xbfc9179d, 0, 21 }, /* #66 b */
    { 0x142b47, 0x142346, 0x3a6dbd9e, 0x9b6f678e, 0, 102 }, /* #67 */
    { 0x2b5492, 0x2b5492, 0x3a6dbd9e, 0x9b6f678e, 0, 102 }, /* #67 b */
    { 0x1677d6, 0x1677d6, 0x4731a978, 0x4731a978, 0, 32 }, /* #68 */
    { 0x290803, 0x290803, 0x4731a978, 0x4731a978, 0, 32 }, /* #68 b */
    { 0x285882, 0x285882, 0x91808182, 0x60a46020, 0, 54 }, /* #69 */
    { 0x172757, 0x172f56, 0x91808182, 0x60a46020, 0, 54 }, /* #69 b */
    { 0x323982, 0x323982, 0xa504f56f, 0xdf4a09ea, 0, 89 }, /* #70 */
    { 0x0d4657, 0x0d4e56, 0xa504f56f, 0xdf4a09ea, 0, 89 }, /* #70 b */
    { 0x3d0b87, 0x3d0b87, 0xade4ada1, 0xc95b435b, 0, 41 }, /* #71 */
    { 0x027452, 0x027c53, 0xade4ada1, 0xc95b435b, 0, 41 }, /* #71 b */
    { 0x370893, 0x370093, 0x055aad33, 0x56ab4cc1, 0, 38 }, /* #72 */
    { 0x087746, 0x087747, 0x055aad33, 0x56ab4cc1, 0, 38 }, /* #72 b */
    { 0x3619d6, 0x3611d6, 0x118b6106, 0xc20c2316, 0, 49 }, /* #73 */
    { 0x096603, 0x096602, 0x118b6106, 0xc20c2316, 0, 49 }, /* #73 b */
    { 0x2f2407, 0x2f2406, 0x0e85fa69, 0x690e85fa, 0, 56 }, /* #74 */
    { 0x105bd2, 0x1053d2, 0x0e85fa69, 0x690e85fa, 0, 56 }, /* #74 b */
    { 0x073997, 0x073996, 0xb9061e5c, 0x7972e418, 0, 18 }, /* #75 */
    { 0x384642, 0x384e42, 0xb9061e5c, 0x7972e418, 0, 18 }, /* #75 b */
    { 0x0455c7, 0x045dc6, 0xa6805735, 0xd00ae6b4, 0, 5  }, /* #76 */
    { 0x3b2a12, 0x3b2a12, 0xa6805735, 0xd00ae6b4, 0, 5  }, /* #76 b */
    { 0x0145c7, 0x0145c7, 0xe6e2f5c7, 0xc5eb8fcd, 0, 105 }, /* #77 */
    { 0x3e3a12, 0x3e3213, 0xe6e2f5c7, 0xc5eb8fcd, 0, 105 }, /* #77 b */
    { 0x0f2ec2, 0x0f2ec2, 0x68731e4a, 0x9a1cc792, 0, 94 }, /* #78 */
    { 0x305117, 0x305916, 0x68731e4a, 0x9a1cc792, 0, 94 }, /* #78 b */
    { 0x3a6716, 0x3a6f17, 0x5fe3f63d, 0xe3f63d5f, 0, 8  }, /* #79 */
    { 0x0518c3, 0x0518c3, 0x5fe3f63d, 0xe3f63d5f, 0, 8  }, /* #79 b */
    { 0x2f59c3, 0x2f59c2, 0x4cbefb9e, 0xbefb9e4c, 0, 40 }, /* #80 */
    { 0x102616, 0x102e16, 0x4cbefb9e, 0xbefb9e4c, 0, 40 }, /* #80 b */
    { 0x3f6252, 0x3f6253, 0x230167ac, 0x08c059eb, 0, 126 }, /* #81 */
    { 0x001d87, 0x001587, 0x230167ac, 0x08c059eb, 0, 126 }, /* #81 b */
    { 0x3a6f83, 0x3a6782, 0x00adc9eb, 0xf58056e4, 0, 87 }, /* #82 */
    { 0x051056, 0x051056, 0x00adc9eb, 0xf58056e4, 0, 87 }, /* #82 b */
    { 0x054747, 0x054f47, 0xaf73694b, 0xee6d2975, 0, 69 }, /* #83 */
    { 0x3a3892, 0x3a3893, 0xaf73694b, 0xee6d2975, 0, 69 }, /* #83 b */
    { 0x200a52, 0x200252, 0xdf473c63, 0x78c7be8e, 0, 17 }, /* #84 */
    { 0x1f7587, 0x1f7586, 0xdf473c63, 0x78c7be8e, 0, 17 }, /* #84 b */
    { 0x174802, 0x174002, 0xc32ca71e, 0xcb29c7b0, 0, 6  }, /* #85 */
    { 0x2837d7, 0x2837d6, 0xc32ca71e, 0xcb29c7b0, 0, 6  }, /* #85 b */
    { 0x171d97, 0x171d97, 0x6b0aa7cd, 0x54f9ad61, 0, 77 }, /* #86 */
    { 0x286242, 0x286a43, 0x6b0aa7cd, 0x54f9ad61, 0, 77 }, /* #86 b */
    { 0x2a6b43, 0x2a6b43, 0x788edc64, 0x1db8c8f1, 0, 9  }, /* #87 */
    { 0x151496, 0x151c97, 0x788edc64, 0x1db8c8f1, 0, 9  }, /* #87 b */
    { 0x344fc3, 0x344fc3, 0x68056ed1, 0x6ed16805, 0, 16 }, /* #88 */
    { 0x0b3016, 0x0b3817, 0x68056ed1, 0x6ed16805, 0, 16 }, /* #88 b */
    { 0x3d1016, 0x3d1016, 0xdcd42b46, 0x8568db9a, 0, 13 }, /* #89 */
    { 0x026fc3, 0x0267c2, 0xdcd42b46, 0x8568db9a, 0, 13 }, /* #89 b */
    { 0x186dc3, 0x1865c3, 0x048ec915, 0xd922a091, 0, 13 }, /* #90 */
    { 0x271216, 0x271217, 0x048ec915, 0xd922a091, 0, 13 }, /* #90 b */
    { 0x2c5cc3, 0x2c5cc3, 0x90d2871e, 0x8f486943, 0, 55 }, /* #91 */
    { 0x132316, 0x132b17, 0x90d2871e, 0x8f486943, 0, 55 }, /* #91 b */
    { 0x3f5846, 0x3f5846, 0x4ba2098a, 0x41314974, 0, 109 }, /* #92 */
    { 0x002793, 0x002f92, 0x4ba2098a, 0x41314974, 0, 109 }, /* #92 b */
    { 0x3e3403, 0x3e3402, 0x2e2d6af5, 0x9716b57a, 0, 63 }, /* #93 */
    { 0x014bd6, 0x0143d6, 0x2e2d6af5, 0x9716b57a, 0, 63 }, /* #93 b */
    { 0x0c0cd3, 0x0c04d3, 0xea0ad5ec, 0x415abd9d, 0, 101 }, /* #94 */
    { 0x337306, 0x337307, 0xea0ad5ec, 0x415abd9d, 0, 101 }, /* #94 b */
    { 0x3f5292, 0x3f5a93, 0x7a9f6e6f, 0xea7db9bd, 0, 98 }, /* #95 */
    { 0x002d47, 0x002d47, 0x7a9f6e6f, 0xea7db9bd, 0, 98 }, /* #95 b */
};
uint32_t const g_cTests_rol_u32_intel = RT_ELEMENTS(g_aTests_rol_u32_intel);

BINU32_TEST_T const g_aTests_ror_u32_intel[] =
{
    { 0x337dd6, 0x3375d6, 0x00000000, 0x00000000, 0, 104 }, /* #0 */
    { 0x0c0203, 0x0c0202, 0x00000000, 0x00000000, 0, 104 }, /* #0 b */
    { 0x3e1c12, 0x3e1412, 0x00000000, 0x00000000, 0, 24 }, /* #1 */
    { 0x0163c7, 0x0163c6, 0x00000000, 0x00000000, 0, 24 }, /* #1 b */
    { 0x2506d2, 0x2506d2, 0x00000000, 0x00000000, 0, 27 }, /* #2 */
    { 0x1a7907, 0x1a7106, 0x00000000, 0x00000000, 0, 27 }, /* #2 b */
    { 0x1605c2, 0x1605c2, 0x00000000, 0x00000000, 0, 0  }, /* #3 */
    { 0x297a17, 0x297a17, 0x00000000, 0x00000000, 0, 0  }, /* #3 b */
    { 0x130f12, 0x130712, 0x00000000, 0x00000000, 0, 83 }, /* #4 */
    { 0x2c70c7, 0x2c70c6, 0x00000000, 0x00000000, 0, 83 }, /* #4 b */
    { 0x033fd2, 0x0337d2, 0x00000000, 0x00000000, 0, 42 }, /* #5 */
    { 0x3c4007, 0x3c4006, 0x00000000, 0x00000000, 0, 42 }, /* #5 b */
    { 0x337412, 0x337c13, 0xe78f9ef0, 0xf9ef0e78, 0, 20 }, /* #6 */
    { 0x0c0bc7, 0x0c0bc7, 0xe78f9ef0, 0xf9ef0e78, 0, 20 }, /* #6 b */
    { 0x0c5112, 0x0c5112, 0x6645845a, 0x69991611, 0, 102 }, /* #7 */
    { 0x332ec7, 0x3326c6, 0x6645845a, 0x69991611, 0, 102 }, /* #7 b */
    { 0x002856, 0x002056, 0x937ae7f5, 0x73fac9bd, 0, 113 }, /* #8 */
    { 0x3f5783, 0x3f5782, 0x937ae7f5, 0x73fac9bd, 0, 113 }, /* #8 b */
    { 0x155193, 0x155193, 0x159d5a58, 0xd2c0acea, 0, 45 }, /* #9 */
    { 0x2a2e46, 0x2a2647, 0x159d5a58, 0xd2c0acea, 0, 45 }, /* #9 b */
    { 0x0f07d7, 0x0f0fd7, 0x556ce7f7, 0xab673fba, 0, 61 }, /* #10 */
    { 0x307802, 0x307803, 0x556ce7f7, 0xab673fba, 0, 61 }, /* #10 b */
    { 0x272a86, 0x272286, 0xe89d4959, 0x13a92b3d, 0, 27 }, /* #11 */
    { 0x185553, 0x185552, 0xe89d4959, 0x13a92b3d, 0, 27 }, /* #11 b */
    { 0x3d6a87, 0x3d6287, 0x17e7f1a4, 0xc6905f9f, 0, 78 }, /* #12 */
    { 0x021552, 0x021553, 0x17e7f1a4, 0xc6905f9f, 0, 78 }, /* #12 b */
    { 0x1e7613, 0x1e7e13, 0x593a68c1, 0x93a68c15, 0, 28 }, /* #13 */
    { 0x2109c6, 0x2109c7, 0x593a68c1, 0x93a68c15, 0, 28 }, /* #13 b */
    { 0x192753, 0x192f53, 0x0d218a9b, 0xb0d218a9, 0, 100 }, /* #14 */
    { 0x265886, 0x265887, 0x0d218a9b, 0xb0d218a9, 0, 100 }, /* #14 b */
    { 0x1d7387, 0x1d7b87, 0x018b70cf, 0x86780c5b, 0, 13 }, /* #15 */
    { 0x220c52, 0x220c53, 0x018b70cf, 0x86780c5b, 0, 13 }, /* #15 b */
    { 0x247ad7, 0x2472d6, 0xe1b2a4cd, 0x33786ca9, 0, 42 }, /* #16 */
    { 0x1b0502, 0x1b0502, 0xe1b2a4cd, 0x33786ca9, 0, 42 }, /* #16 b */
    { 0x0c5386, 0x0c5b87, 0x7421ccc3, 0x8439986e, 0, 59 }, /* #17 */
    { 0x332c53, 0x332c53, 0x7421ccc3, 0x8439986e, 0, 59 }, /* #17 b */
    { 0x127187, 0x127187, 0xfac2db43, 0xb687f585, 0, 79 }, /* #18 */
    { 0x2d0e52, 0x2d0653, 0xfac2db43, 0xb687f585, 0, 79 }, /* #18 b */
    { 0x2f6046, 0x2f6847, 0x0c4c95f1, 0xc4313257, 0, 6  }, /* #19 */
    { 0x101f93, 0x101f93, 0x0c4c95f1, 0xc4313257, 0, 6  }, /* #19 b */
    { 0x112b47, 0x112346, 0xdb2239e9, 0x4473d3b6, 0, 23 }, /* #20 */
    { 0x2e5492, 0x2e5492, 0xdb2239e9, 0x4473d3b6, 0, 23 }, /* #20 b */
    { 0x1c4782, 0x1c4783, 0x3cbe3fb2, 0xb23cbe3f, 0, 104 }, /* #21 */
    { 0x233857, 0x233057, 0x3cbe3fb2, 0xb23cbe3f, 0, 104 }, /* #21 b */
    { 0x004c07, 0x004c06, 0x94055366, 0x53669405, 0, 16 }, /* #22 */
    { 0x3f33d2, 0x3f3bd2, 0x94055366, 0x53669405, 0, 16 }, /* #22 b */
    { 0x033856, 0x033856, 0x170c9db3, 0x3276cc5c, 0, 118 }, /* #23 */
    { 0x3c4783, 0x3c4f82, 0x170c9db3, 0x3276cc5c, 0, 118 }, /* #23 b */
    { 0x1e2816, 0x1e2816, 0xa7e38eac, 0x653f1c75, 0, 101 }, /* #24 */
    { 0x2157c3, 0x215fc2, 0xa7e38eac, 0x653f1c75, 0, 101 }, /* #24 b */
    { 0x247cd6, 0x247cd7, 0x5c5ad93f, 0xb8b5b27e, 0, 95 }, /* #25 */
    { 0x1b0303, 0x1b0b03, 0x5c5ad93f, 0xb8b5b27e, 0, 95 }, /* #25 b */
    { 0x213846, 0x213047, 0xfc01f3a7, 0xfe00f9d3, 0, 65 }, /* #26 */
    { 0x1e4793, 0x1e4793, 0xfc01f3a7, 0xfe00f9d3, 0, 65 }, /* #26 b */
    { 0x3e3b07, 0x3e3306, 0x26fedaec, 0x4dfdb5d8, 0, 63 }, /* #27 */
    { 0x0144d2, 0x0144d2, 0x26fedaec, 0x4dfdb5d8, 0, 63 }, /* #27 b */
    { 0x3a22d2, 0x3a2ad2, 0xceb55fd0, 0x675aafe8, 0, 65 }, /* #28 */
    { 0x055d07, 0x055d06, 0xceb55fd0, 0x675aafe8, 0, 65 }, /* #28 b */
    { 0x103412, 0x103c13, 0x69a0ca27, 0xca2769a0, 0, 48 }, /* #29 */
    { 0x2f4bc7, 0x2f4bc7, 0x69a0ca27, 0xca2769a0, 0, 48 }, /* #29 b */
    { 0x110c82, 0x110483, 0x5eef9722, 0xbbe5c897, 0, 26 }, /* #30 */
    { 0x2e7357, 0x2e7357, 0x5eef9722, 0xbbe5c897, 0, 26 }, /* #30 b */
    { 0x164792, 0x164792, 0x89c42f8f, 0x4e217c7c, 0, 61 }, /* #31 */
    { 0x293847, 0x293046, 0x89c42f8f, 0x4e217c7c, 0, 61 }, /* #31 b */
    { 0x394c52, 0x394453, 0x3a5e83f6, 0xe83f63a5, 0, 52 }, /* #32 */
    { 0x063387, 0x063387, 0x3a5e83f6, 0xe83f63a5, 0, 52 }, /* #32 b */
    { 0x094e57, 0x094656, 0xff813761, 0x09bb0ffc, 0, 21 }, /* #33 */
    { 0x363182, 0x363182, 0xff813761, 0x09bb0ffc, 0, 21 }, /* #33 b */
    { 0x3b4e02, 0x3b4e02, 0xfa612eb4, 0x4bad3e98, 0, 82 }, /* #34 */
    { 0x0431d7, 0x0439d6, 0xfa612eb4, 0x4bad3e98, 0, 82 }, /* #34 b */
    { 0x302013, 0x302012, 0x7dba0558, 0x561f6e81, 0, 10 }, /* #35 */
    { 0x0f5fc6, 0x0f57c6, 0x7dba0558, 0x561f6e81, 0, 10 }, /* #35 b */
    { 0x117892, 0x117893, 0x2f7304f9, 0x9f25ee60, 0, 107 }, /* #36 */
    { 0x2e0747, 0x2e0f47, 0x2f7304f9, 0x9f25ee60, 0, 107 }, /* #36 b */
    { 0x076417, 0x076c16, 0xe069ab64, 0x4d5b2703, 0, 117 }, /* #37 */
    { 0x381bc2, 0x381bc2, 0xe069ab64, 0x4d5b2703, 0, 117 }, /* #37 b */
    { 0x1a5292, 0x1a5292, 0x7e9507c8, 0x3e43f4a8, 0, 109 }, /* #38 */
    { 0x252d47, 0x252546, 0x7e9507c8, 0x3e43f4a8, 0, 109 }, /* #38 b */
    { 0x1c0b56, 0x1c0357, 0xc1c85771, 0x85771c1c, 0, 84 }, /* #39 */
    { 0x237483, 0x237483, 0xc1c85771, 0x85771c1c, 0, 84 }, /* #39 b */
    { 0x271717, 0x271f16, 0x17e99fd1, 0x67f445fa, 0, 82 }, /* #40 */
    { 0x1868c2, 0x1868c2, 0x17e99fd1, 0x67f445fa, 0, 82 }, /* #40 b */
    { 0x077087, 0x077887, 0xa56b31e0, 0x98f052b5, 0, 17 }, /* #41 */
    { 0x380f52, 0x380f53, 0xa56b31e0, 0x98f052b5, 0, 17 }, /* #41 b */
    { 0x086fd2, 0x0867d3, 0x57f01c7c, 0xfc071f15, 0, 90 }, /* #42 */
    { 0x371007, 0x371007, 0x57f01c7c, 0xfc071f15, 0, 90 }, /* #42 b */
    { 0x352f82, 0x352782, 0x456d34c6, 0x15b4d319, 0, 126 }, /* #43 */
    { 0x0a5057, 0x0a5056, 0x456d34c6, 0x15b4d319, 0, 126 }, /* #43 b */
    { 0x2b0657, 0x2b0e56, 0x3f247467, 0x673f2474, 0, 8  }, /* #44 */
    { 0x147982, 0x147982, 0x3f247467, 0x673f2474, 0, 8  }, /* #44 b */
    { 0x1d0e57, 0x1d0e57, 0xdb97452e, 0xd14bb6e5, 0, 82 }, /* #45 */
    { 0x227182, 0x227983, 0xdb97452e, 0xd14bb6e5, 0, 82 }, /* #45 b */
    { 0x203c53, 0x203c53, 0xcc0d7aa2, 0xbd516606, 0, 113 }, /* #46 */
    { 0x1f4386, 0x1f4b87, 0xcc0d7aa2, 0xbd516606, 0, 113 }, /* #46 b */
    { 0x113343, 0x113b42, 0x7827665f, 0x3b32fbc1, 0, 21 }, /* #47 */
    { 0x2e4c96, 0x2e4c96, 0x7827665f, 0x3b32fbc1, 0, 21 }, /* #47 b */
    { 0x0f32d6, 0x0f32d7, 0x3b296992, 0xd94b4c91, 0, 61 }, /* #48 */
    { 0x304d03, 0x304503, 0x3b296992, 0xd94b4c91, 0, 61 }, /* #48 b */
    { 0x213812, 0x213813, 0x4fdb0d4f, 0xa7a7ed86, 0, 73 }, /* #49 */
    { 0x1e47c7, 0x1e4fc7, 0x4fdb0d4f, 0xa7a7ed86, 0, 73 }, /* #49 b */
    { 0x335497, 0x335496, 0x6645c086, 0x17021999, 0, 118 }, /* #50 */
    { 0x0c2b42, 0x0c2342, 0x6645c086, 0x17021999, 0, 118 }, /* #50 b */
    { 0x221686, 0x221e87, 0xd1d77aa8, 0xbd5468eb, 0, 17 }, /* #51 */
    { 0x1d6953, 0x1d6953, 0xd1d77aa8, 0xbd5468eb, 0, 17 }, /* #51 b */
    { 0x0b3a16, 0x0b3a16, 0xf7e02f48, 0x02f48f7e, 0, 84 }, /* #52 */
    { 0x3445c3, 0x344dc2, 0xf7e02f48, 0x02f48f7e, 0, 84 }, /* #52 b */
    { 0x3c08d3, 0x3c08d2, 0x169ed5dd, 0x69ed5dd1, 0, 92 }, /* #53 */
    { 0x037706, 0x037f06, 0x169ed5dd, 0x69ed5dd1, 0, 92 }, /* #53 b */
    { 0x3809c2, 0x3809c3, 0x4e1bf5df, 0xbf5df4e1, 0, 20 }, /* #54 */
    { 0x077617, 0x077e17, 0x4e1bf5df, 0xbf5df4e1, 0, 20 }, /* #54 b */
    { 0x000a86, 0x000a86, 0x2df90a16, 0x2df90a16, 0, 0  }, /* #55 */
    { 0x3f7553, 0x3f7553, 0x2df90a16, 0x2df90a16, 0, 0  }, /* #55 b */
    { 0x213243, 0x213a43, 0x286bb71f, 0xa1aedc7c, 0, 94 }, /* #56 */
    { 0x1e4d96, 0x1e4d97, 0x286bb71f, 0xa1aedc7c, 0, 94 }, /* #56 b */
    { 0x261443, 0x261c43, 0x14a8ee41, 0x822951dc, 0, 7  }, /* #57 */
    { 0x196b96, 0x196b97, 0x14a8ee41, 0x822951dc, 0, 7  }, /* #57 b */
    { 0x0e4386, 0x0e4b87, 0xf53170d6, 0x98b86b7a, 0, 57 }, /* #58 */
    { 0x313c53, 0x313c53, 0xf53170d6, 0x98b86b7a, 0, 57 }, /* #58 b */
    { 0x231046, 0x231847, 0x7de45945, 0xbc8b28af, 0, 59 }, /* #59 */
    { 0x1c6f93, 0x1c6f93, 0x7de45945, 0xbc8b28af, 0, 59 }, /* #59 b */
    { 0x2845d3, 0x284dd2, 0x7abbe201, 0x0bd5df10, 0, 37 }, /* #60 */
    { 0x173a06, 0x173a06, 0x7abbe201, 0x0bd5df10, 0, 37 }, /* #60 b */
    { 0x2348c6, 0x2348c6, 0x49b9c59f, 0x7167d26e, 0, 82 }, /* #61 */
    { 0x1c3713, 0x1c3f12, 0x49b9c59f, 0x7167d26e, 0, 82 }, /* #61 b */
    { 0x263247, 0x263246, 0xe1ac9e31, 0x0d64f18f, 0, 93 }, /* #62 */
    { 0x194d92, 0x194592, 0xe1ac9e31, 0x0d64f18f, 0, 93 }, /* #62 b */
    { 0x140547, 0x140547, 0xfdb4765f, 0x8ecbffb6, 0, 83 }, /* #63 */
    { 0x2b7a92, 0x2b7293, 0xfdb4765f, 0x8ecbffb6, 0, 83 }, /* #63 b */
    { 0x1d1806, 0x1d1007, 0x3c3f812a, 0xfc0951e1, 0, 53 }, /* #64 */
    { 0x2267d3, 0x2267d3, 0x3c3f812a, 0xfc0951e1, 0, 53 }, /* #64 b */
    { 0x0775d6, 0x077dd6, 0x82610620, 0x31041308, 0, 109 }, /* #65 */
    { 0x380a03, 0x380a02, 0x82610620, 0x31041308, 0, 109 }, /* #65 b */
    { 0x363097, 0x363897, 0x2ab36731, 0xd9cc4aac, 0, 18 }, /* #66 */
    { 0x094f42, 0x094f43, 0x2ab36731, 0xd9cc4aac, 0, 18 }, /* #66 b */
    { 0x1c5752, 0x1c5753, 0xa46afaa5, 0xea9691ab, 0, 110 }, /* #67 */
    { 0x232887, 0x232087, 0xa46afaa5, 0xea9691ab, 0, 110 }, /* #67 b */
    { 0x064353, 0x064353, 0x48925e64, 0x89124bcc, 0, 99 }, /* #68 */
    { 0x393c86, 0x393487, 0x48925e64, 0x89124bcc, 0, 99 }, /* #68 b */
    { 0x235986, 0x235186, 0xbcd7e4d3, 0x34ef35f9, 0, 10 }, /* #69 */
    { 0x1c2653, 0x1c2652, 0xbcd7e4d3, 0x34ef35f9, 0, 10 }, /* #69 b */
    { 0x203e87, 0x203e87, 0xc1b0a702, 0xc0b06c29, 0, 106 }, /* #70 */
    { 0x1f4152, 0x1f4953, 0xc1b0a702, 0xc0b06c29, 0, 106 }, /* #70 b */
    { 0x015247, 0x015246, 0x918d1195, 0x5918d119, 0, 100 }, /* #71 */
    { 0x3e2d92, 0x3e2592, 0x918d1195, 0x5918d119, 0, 100 }, /* #71 b */
    { 0x357f46, 0x357746, 0x961ea809, 0x6587aa02, 0, 2  }, /* #72 */
    { 0x0a0093, 0x0a0092, 0x961ea809, 0x6587aa02, 0, 2  }, /* #72 b */
    { 0x2c28c7, 0x2c20c6, 0x360b6e1c, 0x0d82db87, 0, 66 }, /* #73 */
    { 0x135712, 0x135712, 0x360b6e1c, 0x0d82db87, 0, 66 }, /* #73 b */
    { 0x200753, 0x200f53, 0xb5ecb1a0, 0xbd963416, 0, 27 }, /* #74 */
    { 0x1f7886, 0x1f7887, 0xb5ecb1a0, 0xbd963416, 0, 27 }, /* #74 b */
    { 0x1d6f02, 0x1d6702, 0x3da8e450, 0x7b51c8a0, 0, 95 }, /* #75 */
    { 0x2210d7, 0x2210d6, 0x3da8e450, 0x7b51c8a0, 0, 95 }, /* #75 b */
    { 0x360c13, 0x360413, 0xe0e05a4d, 0xa4de0e05, 0, 44 }, /* #76 */
    { 0x0973c6, 0x0973c7, 0xe0e05a4d, 0xa4de0e05, 0, 44 }, /* #76 b */
    { 0x014f43, 0x014f43, 0x7aa582b8, 0x7aa582b8, 0, 64 }, /* #77 */
    { 0x3e3096, 0x3e3096, 0x7aa582b8, 0x7aa582b8, 0, 64 }, /* #77 b */
    { 0x386583, 0x386d82, 0x3ae06a15, 0x0a9d7035, 0, 41 }, /* #78 */
    { 0x071a56, 0x071a56, 0x3ae06a15, 0x0a9d7035, 0, 41 }, /* #78 b */
    { 0x246946, 0x246947, 0x51128097, 0x889404ba, 0, 125 }, /* #79 */
    { 0x1b1693, 0x1b1e93, 0x51128097, 0x889404ba, 0, 125 }, /* #79 b */
    { 0x2e4556, 0x2e4d57, 0xfab0bf40, 0xb0bf40fa, 0, 56 }, /* #80 */
    { 0x113a83, 0x113a83, 0xfab0bf40, 0xb0bf40fa, 0, 56 }, /* #80 b */
    { 0x367403, 0x367c03, 0xfea878d0, 0x8d0fea87, 0, 44 }, /* #81 */
    { 0x090bd6, 0x090bd7, 0xfea878d0, 0x8d0fea87, 0, 44 }, /* #81 b */
    { 0x310146, 0x310147, 0xae94b7d9, 0x96fb35d2, 0, 115 }, /* #82 */
    { 0x0e7e93, 0x0e7693, 0xae94b7d9, 0x96fb35d2, 0, 115 }, /* #82 b */
    { 0x3742d2, 0x3742d2, 0x72671bf4, 0x72671bf4, 0, 64 }, /* #83 */
    { 0x083d07, 0x083d07, 0x72671bf4, 0x72671bf4, 0, 64 }, /* #83 b */
    { 0x377752, 0x377753, 0x22454a5e, 0x91529788, 0, 26 }, /* #84 */
    { 0x080887, 0x080087, 0x22454a5e, 0x91529788, 0, 26 }, /* #84 b */
    { 0x2e1417, 0x2e1417, 0x5e9c5fc8, 0xfc85e9c5, 0, 44 }, /* #85 */
    { 0x116bc2, 0x1163c3, 0x5e9c5fc8, 0xfc85e9c5, 0, 44 }, /* #85 b */
    { 0x065cc6, 0x065cc7, 0x10e8ada7, 0xda710e8a, 0, 12 }, /* #86 */
    { 0x392313, 0x392b13, 0x10e8ada7, 0xda710e8a, 0, 12 }, /* #86 b */
    { 0x005703, 0x005702, 0x36578566, 0x6caf0acc, 0, 63 }, /* #87 */
    { 0x3f28d6, 0x3f20d6, 0x36578566, 0x6caf0acc, 0, 63 }, /* #87 b */
    { 0x351fd6, 0x3517d7, 0x72f9aa7c, 0xd53e397c, 0, 17 }, /* #88 */
    { 0x0a6003, 0x0a6003, 0x72f9aa7c, 0xd53e397c, 0, 17 }, /* #88 b */
    { 0x1b56d2, 0x1b56d2, 0x599672f5, 0x599672f5, 0, 0  }, /* #89 */
    { 0x242907, 0x242907, 0x599672f5, 0x599672f5, 0, 0  }, /* #89 b */
    { 0x1f7cd7, 0x1f74d6, 0xbb9315d9, 0x6ee4c576, 0, 34 }, /* #90 */
    { 0x200302, 0x200302, 0xbb9315d9, 0x6ee4c576, 0, 34 }, /* #90 b */
    { 0x357b57, 0x357356, 0xfea06ca9, 0x53fd40d9, 0, 7  }, /* #91 */
    { 0x0a0482, 0x0a0482, 0xfea06ca9, 0x53fd40d9, 0, 7  }, /* #91 b */
    { 0x395dc2, 0x3955c2, 0x7ed04808, 0x12021fb4, 0, 50 }, /* #92 */
    { 0x062217, 0x062216, 0x7ed04808, 0x12021fb4, 0, 50 }, /* #92 b */
    { 0x2953c7, 0x295bc7, 0xc79d1804, 0xc0263ce8, 0, 13 }, /* #93 */
    { 0x162c12, 0x162c13, 0xc79d1804, 0xc0263ce8, 0, 13 }, /* #93 b */
    { 0x351656, 0x351656, 0x18d9dacf, 0x18d9dacf, 0, 96 }, /* #94 */
    { 0x0a6983, 0x0a6983, 0x18d9dacf, 0x18d9dacf, 0, 96 }, /* #94 b */
    { 0x2c73c2, 0x2c7bc3, 0x7fc0e885, 0x857fc0e8, 0, 40 }, /* #95 */
    { 0x130c17, 0x130c17, 0x7fc0e885, 0x857fc0e8, 0, 40 }, /* #95 b */
};
uint32_t const g_cTests_ror_u32_intel = RT_ELEMENTS(g_aTests_ror_u32_intel);

BINU32_TEST_T const g_aTests_rcl_u32_intel[] =
{
    { 0x132f17, 0x132716, 0x00000000, 0x00000800, 0, 12 }, /* #0 */
    { 0x2c50c2, 0x2c50c2, 0x00000000, 0x00000000, 0, 12 }, /* #0 b */
    { 0x2c47d3, 0x2c47d2, 0x00000000, 0x00000100, 0, 9  }, /* #1 */
    { 0x133806, 0x133006, 0x00000000, 0x00000000, 0, 9  }, /* #1 b */
    { 0x116c82, 0x116482, 0x00000000, 0x00000000, 0, 14 }, /* #2 */
    { 0x2e1357, 0x2e1356, 0x00000000, 0x00002000, 0, 14 }, /* #2 b */
    { 0x070002, 0x070002, 0x00000000, 0x00000000, 0, 58 }, /* #3 */
    { 0x387fd7, 0x3877d6, 0x00000000, 0x02000000, 0, 58 }, /* #3 b */
    { 0x1a01d6, 0x1a01d6, 0x00000000, 0x00000000, 0, 81 }, /* #4 */
    { 0x257e03, 0x257602, 0x00000000, 0x00010000, 0, 81 }, /* #4 b */
    { 0x060957, 0x060156, 0x00000000, 0x00008000, 0, 112 }, /* #5 */
    { 0x397682, 0x397682, 0x00000000, 0x00000000, 0, 112 }, /* #5 b */
    { 0x114b56, 0x114b57, 0x505f413a, 0xa282fa09, 0, 60 }, /* #6 */
    { 0x2e3483, 0x2e3c83, 0x505f413a, 0xaa82fa09, 0, 60 }, /* #6 b */
    { 0x1d3a53, 0x1d3252, 0xc442142f, 0x210a17f1, 0, 71 }, /* #7 */
    { 0x224586, 0x224586, 0xc442142f, 0x210a17b1, 0, 71 }, /* #7 b */
    { 0x1e5383, 0x1e5b82, 0x56822e67, 0xd045ccf5, 0, 69 }, /* #8 */
    { 0x212c56, 0x212c56, 0x56822e67, 0xd045cce5, 0, 69 }, /* #8 b */
    { 0x324287, 0x324a87, 0x8b68d69e, 0xb46b4f62, 0, 103 }, /* #9 */
    { 0x0d3d52, 0x0d3d53, 0x8b68d69e, 0xb46b4f22, 0, 103 }, /* #9 b */
    { 0x285ad3, 0x285ad2, 0x73e07882, 0x3c415cf8, 0, 15 }, /* #10 */
    { 0x172506, 0x172d06, 0x73e07882, 0x3c411cf8, 0, 15 }, /* #10 b */
    { 0x123217, 0x123a17, 0x748cf535, 0xd4d6e919, 0, 50 }, /* #11 */
    { 0x2d4dc2, 0x2d4dc3, 0x748cf535, 0xd4d4e919, 0, 50 }, /* #11 b */
    { 0x2f5413, 0x2f5413, 0xea338a33, 0x4671467e, 0, 37 }, /* #12 */
    { 0x102bc6, 0x1023c7, 0xea338a33, 0x4671466e, 0, 37 }, /* #12 b */
    { 0x2d39c6, 0x2d39c6, 0x483b5014, 0x120ed405, 0, 63 }, /* #13 */
    { 0x124613, 0x124e12, 0x483b5014, 0x520ed405, 0, 63 }, /* #13 b */
    { 0x0637d6, 0x063fd7, 0x42a9a892, 0x2442a9a8, 0, 121 }, /* #14 */
    { 0x394803, 0x394803, 0x42a9a892, 0x2542a9a8, 0, 121 }, /* #14 b */
    { 0x156913, 0x156112, 0x17c5e0a3, 0x0a38be2f, 0, 52 }, /* #15 */
    { 0x2a16c6, 0x2a16c6, 0x17c5e0a3, 0x0a30be2f, 0, 52 }, /* #15 b */
    { 0x0d5682, 0x0d5e83, 0x96ad70d2, 0x6b86925a, 0, 107 }, /* #16 */
    { 0x322957, 0x322957, 0x96ad70d2, 0x6b86965a, 0, 107 }, /* #16 b */
    { 0x320557, 0x320557, 0x39825aad, 0x9825aad9, 0, 4  }, /* #17 */
    { 0x0d7a82, 0x0d7283, 0x39825aad, 0x9825aad1, 0, 4  }, /* #17 b */
    { 0x230dd3, 0x2305d3, 0xf244d695, 0xc9135a57, 0, 98 }, /* #18 */
    { 0x1c7206, 0x1c7207, 0xf244d695, 0xc9135a55, 0, 98 }, /* #18 b */
    { 0x200b97, 0x200397, 0xe1a39b00, 0x9b00f0d1, 0, 112 }, /* #19 */
    { 0x1f7442, 0x1f7443, 0xe1a39b00, 0x9b0070d1, 0, 112 }, /* #19 b */
    { 0x3f4243, 0x3f4242, 0x2fcd2df7, 0xfcd2df79, 0, 68 }, /* #20 */
    { 0x003d96, 0x003596, 0x2fcd2df7, 0xfcd2df71, 0, 68 }, /* #20 b */
    { 0x3f47c3, 0x3f4fc3, 0x49d2c13f, 0x4b04fe93, 0, 106 }, /* #21 */
    { 0x003816, 0x003817, 0x49d2c13f, 0x4b04fc93, 0, 106 }, /* #21 b */
    { 0x000a87, 0x000a86, 0x87d1eb7d, 0xdf70fa3d, 0, 86 }, /* #22 */
    { 0x3f7552, 0x3f7d52, 0x87d1eb7d, 0xdf50fa3d, 0, 86 }, /* #22 b */
    { 0x325683, 0x325683, 0xd1f6a364, 0xb2747da8, 0, 87 }, /* #23 */
    { 0x0d2956, 0x0d2157, 0xd1f6a364, 0xb2347da8, 0, 87 }, /* #23 b */
    { 0x246ad7, 0x2462d7, 0xea28be24, 0xd4517c49, 0, 33 }, /* #24 */
    { 0x1b1502, 0x1b1503, 0xea28be24, 0xd4517c48, 0, 33 }, /* #24 b */
    { 0x0a1912, 0x0a1913, 0x8c9bdd1d, 0x37ba3a8c, 0, 41 }, /* #25 */
    { 0x3566c7, 0x356ec7, 0x8c9bdd1d, 0x37ba3b8c, 0, 41 }, /* #25 b */
    { 0x276503, 0x276d02, 0x9ce3951d, 0xe547739c, 0, 46 }, /* #26 */
    { 0x181ad6, 0x181ad6, 0x9ce3951d, 0xe547539c, 0, 46 }, /* #26 b */
    { 0x143793, 0x143792, 0x2f05da7b, 0x9ee5e0bb, 0, 86 }, /* #27 */
    { 0x2b4846, 0x2b4046, 0x2f05da7b, 0x9ec5e0bb, 0, 86 }, /* #27 b */
    { 0x272953, 0x272953, 0x6af87e6e, 0x0fcdd6af, 0, 109 }, /* #28 */
    { 0x185686, 0x185e87, 0x6af87e6e, 0x0fcdc6af, 0, 109 }, /* #28 b */
    { 0x144c86, 0x144c87, 0x75251bf8, 0x1bf83a92, 0, 80 }, /* #29 */
    { 0x2b3353, 0x2b3b53, 0x75251bf8, 0x1bf8ba92, 0, 80 }, /* #29 b */
    { 0x266596, 0x266d97, 0x93bef86e, 0xc93bef86, 0, 125 }, /* #30 */
    { 0x191a43, 0x191a43, 0x93bef86e, 0xd93bef86, 0, 125 }, /* #30 b */
    { 0x1274c3, 0x127cc3, 0xbbb9d5b0, 0xb0dddcea, 0, 24 }, /* #31 */
    { 0x2d0b16, 0x2d0b17, 0xbbb9d5b0, 0xb05ddcea, 0, 24 }, /* #31 b */
    { 0x1408d6, 0x1408d6, 0x6a0c3f67, 0xd4187ece, 0, 97 }, /* #32 */
    { 0x2b7703, 0x2b7f02, 0x6a0c3f67, 0xd4187ecf, 0, 97 }, /* #32 b */
    { 0x177543, 0x177d42, 0xb2394d5a, 0x9ab5b239, 0, 49 }, /* #33 */
    { 0x280a96, 0x280a96, 0xb2394d5a, 0x9ab4b239, 0, 49 }, /* #33 b */
    { 0x0741d6, 0x0741d7, 0xcef42dfa, 0x3bd0b7e9, 0, 66 }, /* #34 */
    { 0x383e03, 0x383603, 0xcef42dfa, 0x3bd0b7eb, 0, 66 }, /* #34 b */
    { 0x3402d6, 0x340ad6, 0x8272fc95, 0xe5f92a82, 0, 9  }, /* #35 */
    { 0x0b7d03, 0x0b7d02, 0x8272fc95, 0xe5f92b82, 0, 9  }, /* #35 b */
    { 0x145856, 0x145056, 0xed99a249, 0xd124bb66, 0, 79 }, /* #36 */
    { 0x2b2783, 0x2b2782, 0xed99a249, 0xd124fb66, 0, 79 }, /* #36 b */
    { 0x345e83, 0x345682, 0x32f920c4, 0x4997c906, 0, 28 }, /* #37 */
    { 0x0b2156, 0x0b2156, 0x32f920c4, 0x4197c906, 0, 28 }, /* #37 b */
    { 0x1f3d97, 0x1f3596, 0xeb64d036, 0x06deb64d, 0, 85 }, /* #38 */
    { 0x204242, 0x204242, 0xeb64d036, 0x06ceb64d, 0, 85 }, /* #38 b */
    { 0x0a0ed3, 0x0a06d2, 0xe54889ac, 0x6b3ca911, 0, 54 }, /* #39 */
    { 0x357106, 0x357106, 0xe54889ac, 0x6b1ca911, 0, 54 }, /* #39 b */
    { 0x1e5d96, 0x1e5d96, 0xe4a0ab94, 0xe4a0ab94, 0, 96 }, /* #40 */
    { 0x212243, 0x212243, 0xe4a0ab94, 0xe4a0ab94, 0, 96 }, /* #40 b */
    { 0x3e7596, 0x3e7596, 0x0875d675, 0xeb3a821d, 0, 79 }, /* #41 */
    { 0x010a43, 0x010242, 0x0875d675, 0xeb3ac21d, 0, 79 }, /* #41 b */
    { 0x0a31c6, 0x0a39c7, 0x6a7df2b0, 0xf2b0353e, 0, 16 }, /* #42 */
    { 0x354e13, 0x354e13, 0x6a7df2b0, 0xf2b0b53e, 0, 16 }, /* #42 b */
    { 0x015287, 0x015286, 0x16a5c084, 0x48b52e04, 0, 124 }, /* #43 */
    { 0x3e2d52, 0x3e2552, 0x16a5c084, 0x40b52e04, 0, 124 }, /* #43 b */
    { 0x203fd6, 0x2037d7, 0xf1958d13, 0x2b1a26f1, 0, 105 }, /* #44 */
    { 0x1f4003, 0x1f4003, 0xf1958d13, 0x2b1a27f1, 0, 105 }, /* #44 b */
    { 0x050312, 0x050313, 0xe9aee833, 0x374d7741, 0, 60 }, /* #45 */
    { 0x3a7cc7, 0x3a74c7, 0xe9aee833, 0x3f4d7741, 0, 60 }, /* #45 b */
    { 0x2c1352, 0x2c1b53, 0x6ac4bbb9, 0xc9ab12ee, 0, 59 }, /* #46 */
    { 0x136c87, 0x136c87, 0x6ac4bbb9, 0xcdab12ee, 0, 59 }, /* #46 b */
    { 0x0e7516, 0x0e7d17, 0x4bf0957d, 0x84abe92f, 0, 75 }, /* #47 */
    { 0x310ac3, 0x310ac3, 0x4bf0957d, 0x84abed2f, 0, 75 }, /* #47 b */
    { 0x2e1257, 0x2e1256, 0xcd46a3a6, 0xd46a3a6e, 0, 4  }, /* #48 */
    { 0x116d82, 0x116582, 0xcd46a3a6, 0xd46a3a66, 0, 4  }, /* #48 b */
    { 0x285487, 0x285486, 0x1aedbfa6, 0x35db7f4d, 0, 65 }, /* #49 */
    { 0x172b52, 0x172352, 0x1aedbfa6, 0x35db7f4c, 0, 65 }, /* #49 b */
    { 0x2f2086, 0x2f2086, 0x227cf247, 0x44f9e48e, 0, 97 }, /* #50 */
    { 0x105f53, 0x105752, 0x227cf247, 0x44f9e48f, 0, 97 }, /* #50 b */
    { 0x170c13, 0x170c13, 0x49c741e5, 0x38e83cb4, 0, 69 }, /* #51 */
    { 0x2873c6, 0x287bc7, 0x49c741e5, 0x38e83ca4, 0, 69 }, /* #51 b */
    { 0x166597, 0x166d97, 0x62ab124a, 0x58aac492, 0, 95 }, /* #52 */
    { 0x291a42, 0x291a43, 0x62ab124a, 0x18aac492, 0, 95 }, /* #52 b */
    { 0x1a76d7, 0x1a7ed6, 0x962c6072, 0x72cb1630, 0, 88 }, /* #53 */
    { 0x250902, 0x250902, 0x962c6072, 0x724b1630, 0, 88 }, /* #53 b */
    { 0x357753, 0x357752, 0x23564247, 0x48f23564, 0, 85 }, /* #54 */
    { 0x0a0886, 0x0a0086, 0x23564247, 0x48e23564, 0, 85 }, /* #54 b */
    { 0x064bd7, 0x0643d7, 0x1d5b6b9a, 0xb5cd4756, 0, 79 }, /* #55 */
    { 0x393402, 0x393403, 0x1d5b6b9a, 0xb5cd0756, 0, 79 }, /* #55 b */
    { 0x2d7357, 0x2d7b56, 0xaaa57058, 0xaa57058d, 0, 100 }, /* #56 */
    { 0x120c82, 0x120c82, 0xaaa57058, 0xaa570585, 0, 100 }, /* #56 b */
    { 0x3e2c57, 0x3e2c57, 0x56a64d4b, 0xa99352ea, 0, 6  }, /* #57 */
    { 0x015382, 0x015b83, 0x56a64d4b, 0xa99352ca, 0, 6  }, /* #57 b */
    { 0x2703d2, 0x2703d3, 0x343ca76e, 0xc343ca76, 0, 125 }, /* #58 */
    { 0x187c07, 0x187407, 0x343ca76e, 0xd343ca76, 0, 125 }, /* #58 b */
    { 0x040513, 0x040512, 0xf9e3caf9, 0x3caf9fcf, 0, 76 }, /* #59 */
    { 0x3b7ac6, 0x3b72c6, 0xf9e3caf9, 0x3caf97cf, 0, 76 }, /* #59 b */
    { 0x326812, 0x326012, 0xc5e63126, 0x624cc5e6, 0, 49 }, /* #60 */
    { 0x0d17c7, 0x0d17c6, 0xc5e63126, 0x624dc5e6, 0, 49 }, /* #60 b */
    { 0x3a07d7, 0x3a0fd6, 0xa70c1259, 0x1259d386, 0, 48 }, /* #61 */
    { 0x057802, 0x057802, 0xa70c1259, 0x12595386, 0, 48 }, /* #61 b */
    { 0x391342, 0x391b43, 0x9e9ad848, 0xd35b0909, 0, 37 }, /* #62 */
    { 0x066c97, 0x066c97, 0x9e9ad848, 0xd35b0919, 0, 37 }, /* #62 b */
    { 0x0d3d17, 0x0d3d17, 0x7448e468, 0xc8d17448, 0, 81 }, /* #63 */
    { 0x3242c2, 0x324ac3, 0x7448e468, 0xc8d07448, 0, 81 }, /* #63 b */
    { 0x305b16, 0x305316, 0xd173f7b0, 0xe7ef60d1, 0, 41 }, /* #64 */
    { 0x0f24c3, 0x0f24c2, 0xd173f7b0, 0xe7ef61d1, 0, 41 }, /* #64 b */
    { 0x016fd6, 0x016fd7, 0xad2ae777, 0xceeead2a, 0, 49 }, /* #65 */
    { 0x3e1003, 0x3e1803, 0xad2ae777, 0xceefad2a, 0, 49 }, /* #65 b */
    { 0x334ec2, 0x334ec2, 0xa6a1441c, 0xe29a8510, 0, 59 }, /* #66 */
    { 0x0c3117, 0x0c3916, 0xa6a1441c, 0xe69a8510, 0, 59 }, /* #66 b */
    { 0x096656, 0x096e56, 0x929a2181, 0xc0a4a688, 0, 55 }, /* #67 */
    { 0x361983, 0x361982, 0x929a2181, 0xc0e4a688, 0, 55 }, /* #67 b */
    { 0x1c51c2, 0x1c51c2, 0x3ad590c7, 0x8638eb56, 0, 51 }, /* #68 */
    { 0x232e17, 0x232616, 0x3ad590c7, 0x863ceb56, 0, 51 }, /* #68 b */
    { 0x043a47, 0x043a46, 0x9cab149d, 0xee72ac52, 0, 91 }, /* #69 */
    { 0x3b4592, 0x3b4d92, 0x9cab149d, 0xea72ac52, 0, 91 }, /* #69 b */
    { 0x1f5296, 0x1f5a96, 0x7d91ea21, 0x427d91ea, 0, 57 }, /* #70 */
    { 0x202d43, 0x202d42, 0x7d91ea21, 0x437d91ea, 0, 57 }, /* #70 b */
    { 0x1d5f96, 0x1d5796, 0x396a0c51, 0x72d418a2, 0, 33 }, /* #71 */
    { 0x222043, 0x222042, 0x396a0c51, 0x72d418a3, 0, 33 }, /* #71 b */
    { 0x105fd6, 0x1057d7, 0xe70916d5, 0x22daae70, 0, 109 }, /* #72 */
    { 0x2f2003, 0x2f2003, 0xe70916d5, 0x22dabe70, 0, 109 }, /* #72 b */
    { 0x1e0253, 0x1e0253, 0xd8ed73db, 0x6fb1dae7, 0, 58 }, /* #73 */
    { 0x217d86, 0x217587, 0xd8ed73db, 0x6db1dae7, 0, 58 }, /* #73 b */
    { 0x2674d2, 0x2674d3, 0x3a0548a2, 0x52288740, 0, 46 }, /* #74 */
    { 0x190b07, 0x190307, 0x3a0548a2, 0x5228a740, 0, 46 }, /* #74 b */
    { 0x016197, 0x016996, 0x8114afd3, 0x452bf4f0, 0, 38 }, /* #75 */
    { 0x3e1e42, 0x3e1e42, 0x8114afd3, 0x452bf4d0, 0, 38 }, /* #75 b */
    { 0x087f87, 0x087f87, 0x9d1b0088, 0x46c02233, 0, 70 }, /* #76 */
    { 0x370052, 0x370853, 0x9d1b0088, 0x46c02213, 0, 70 }, /* #76 b */
    { 0x354583, 0x354d83, 0x61f5b105, 0x5b105b0f, 0, 108 }, /* #77 */
    { 0x0a3a56, 0x0a3a57, 0x61f5b105, 0x5b10530f, 0, 108 }, /* #77 b */
    { 0x2e7a92, 0x2e7292, 0xe38f4e8a, 0x74538e3d, 0, 115 }, /* #78 */
    { 0x110547, 0x110546, 0xe38f4e8a, 0x74578e3d, 0, 115 }, /* #78 b */
    { 0x256dd2, 0x2565d3, 0x341bd09f, 0xe341bd09, 0, 29 }, /* #79 */
    { 0x1a1207, 0x1a1207, 0x341bd09f, 0xf341bd09, 0, 29 }, /* #79 b */
    { 0x3d6f52, 0x3d6f53, 0x4b4b3908, 0x90825a59, 0, 52 }, /* #80 */
    { 0x021087, 0x021887, 0x4b4b3908, 0x908a5a59, 0, 52 }, /* #80 b */
    { 0x292057, 0x292857, 0x6ca32433, 0x3b651921, 0, 28 }, /* #81 */
    { 0x165f82, 0x165f83, 0x6ca32433, 0x33651921, 0, 28 }, /* #81 b */
    { 0x3b1bd3, 0x3b13d2, 0x165fd1d0, 0x4597f474, 0, 95 }, /* #82 */
    { 0x046406, 0x046406, 0x165fd1d0, 0x0597f474, 0, 95 }, /* #82 b */
    { 0x243ec7, 0x2436c7, 0xfa2f6b83, 0xed707fa2, 0, 13 }, /* #83 */
    { 0x1b4112, 0x1b4113, 0xfa2f6b83, 0xed706fa2, 0, 13 }, /* #83 b */
    { 0x053093, 0x053093, 0x20a131d7, 0x4263af20, 0, 9  }, /* #84 */
    { 0x3a4f46, 0x3a4747, 0x20a131d7, 0x4263ae20, 0, 9  }, /* #84 b */
    { 0x166513, 0x166d13, 0xaf553afe, 0x4ebfb5ea, 0, 46 }, /* #85 */
    { 0x291ac6, 0x291ac7, 0xaf553afe, 0x4ebf95ea, 0, 46 }, /* #85 b */
    { 0x1f48c3, 0x1f48c2, 0x5095454a, 0xaa12a8a9, 0, 94 }, /* #86 */
    { 0x203716, 0x203f16, 0x5095454a, 0x8a12a8a9, 0, 94 }, /* #86 b */
    { 0x2767d7, 0x2767d7, 0xe50a01a0, 0xca140341, 0, 97 }, /* #87 */
    { 0x181802, 0x181003, 0xe50a01a0, 0xca140340, 0, 97 }, /* #87 b */
    { 0x263693, 0x263692, 0xc3ec521b, 0xc521be1f, 0, 108 }, /* #88 */
    { 0x194946, 0x194146, 0xc3ec521b, 0xc521b61f, 0, 108 }, /* #88 b */
    { 0x224186, 0x224986, 0x8d8366a5, 0xd4a8d836, 0, 85 }, /* #89 */
    { 0x1d3e53, 0x1d3e52, 0x8d8366a5, 0xd4b8d836, 0, 85 }, /* #89 b */
    { 0x366d13, 0x366d13, 0x92cab8e7, 0x8e7c9655, 0, 20 }, /* #90 */
    { 0x0912c6, 0x091ac7, 0x92cab8e7, 0x8e749655, 0, 20 }, /* #90 b */
    { 0x296786, 0x296f87, 0xa2f84278, 0xc28be109, 0, 91 }, /* #91 */
    { 0x161853, 0x161853, 0xa2f84278, 0xc68be109, 0, 91 }, /* #91 b */
    { 0x2133c7, 0x2133c7, 0xf5fc9db5, 0xafe4edaf, 0, 67 }, /* #92 */
    { 0x1e4c12, 0x1e4413, 0xf5fc9db5, 0xafe4edab, 0, 67 }, /* #92 b */
    { 0x017006, 0x017006, 0xc42e5624, 0x56246217, 0, 16 }, /* #93 */
    { 0x3e0fd3, 0x3e07d2, 0xc42e5624, 0x5624e217, 0, 16 }, /* #93 b */
    { 0x1920d2, 0x1920d3, 0xef8f1991, 0xe3322ef8, 0, 45 }, /* #94 */
    { 0x265f07, 0x265707, 0xef8f1991, 0xe3323ef8, 0, 45 }, /* #94 b */
    { 0x0d1696, 0x0d1697, 0xc05b5e02, 0x80980b6b, 0, 54 }, /* #95 */
    { 0x326943, 0x326143, 0xc05b5e02, 0x80b80b6b, 0, 54 }, /* #95 b */
};
uint32_t const g_cTests_rcl_u32_intel = RT_ELEMENTS(g_aTests_rcl_u32_intel);

BINU32_TEST_T const g_aTests_rcr_u32_intel[] =
{
    { 0x2e4087, 0x2e4886, 0x00000000, 0x00000800, 0, 21 }, /* #0 */
    { 0x113f52, 0x113752, 0x00000000, 0x00000000, 0, 21 }, /* #0 b */
    { 0x024bd6, 0x0243d6, 0x00000000, 0x00000000, 0, 25 }, /* #1 */
    { 0x3d3403, 0x3d3c02, 0x00000000, 0x00000080, 0, 25 }, /* #1 b */
    { 0x270646, 0x270646, 0x00000000, 0x00000000, 0, 64 }, /* #2 */
    { 0x187993, 0x187993, 0x00000000, 0x00000000, 0, 64 }, /* #2 b */
    { 0x032702, 0x032702, 0x00000000, 0x00000000, 0, 89 }, /* #3 */
    { 0x3c58d7, 0x3c58d6, 0x00000000, 0x00000080, 0, 89 }, /* #3 b */
    { 0x3c7717, 0x3c7f16, 0x00000000, 0x00010000, 0, 112 }, /* #4 */
    { 0x0308c2, 0x0300c2, 0x00000000, 0x00000000, 0, 112 }, /* #4 b */
    { 0x293f56, 0x293756, 0x00000000, 0x00000000, 0, 92 }, /* #5 */
    { 0x164083, 0x164882, 0x00000000, 0x00000010, 0, 92 }, /* #5 b */
    { 0x284243, 0x284a42, 0x7cf2b4a0, 0x569417cf, 0, 20 }, /* #6 */
    { 0x173d96, 0x173596, 0x7cf2b4a0, 0x569407cf, 0, 20 }, /* #6 b */
    { 0x0406c3, 0x0406c3, 0xa9bbcc6f, 0x7ea6ef31, 0, 6  }, /* #7 */
    { 0x3b7916, 0x3b7917, 0xa9bbcc6f, 0x7aa6ef31, 0, 6  }, /* #7 b */
    { 0x1c0f86, 0x1c0f87, 0x94677506, 0x3ba83251, 0, 22 }, /* #8 */
    { 0x237053, 0x237053, 0x94677506, 0x3ba83651, 0, 22 }, /* #8 b */
    { 0x0a6a47, 0x0a6247, 0xe18bbfde, 0xf7bc3177, 0, 107 }, /* #9 */
    { 0x351592, 0x351d93, 0xe18bbfde, 0xf79c3177, 0, 107 }, /* #9 b */
    { 0x393c57, 0x393456, 0xf68eb702, 0x2fb475b8, 0, 101 }, /* #10 */
    { 0x064382, 0x064b82, 0xf68eb702, 0x27b475b8, 0, 101 }, /* #10 b */
    { 0x261f07, 0x261707, 0xc8980299, 0x80299e44, 0, 53 }, /* #11 */
    { 0x1960d2, 0x1968d3, 0xc8980299, 0x80299644, 0, 53 }, /* #11 b */
    { 0x056187, 0x056186, 0xd9e37993, 0xde64fb3c, 0, 83 }, /* #12 */
    { 0x3a1e52, 0x3a1e52, 0xd9e37993, 0xde64db3c, 0, 83 }, /* #12 b */
    { 0x2f05d3, 0x2f0dd3, 0x764767b7, 0xdd91d9ed, 0, 34 }, /* #13 */
    { 0x107a06, 0x107207, 0x764767b7, 0x9d91d9ed, 0, 34 }, /* #13 b */
    { 0x042e52, 0x042e53, 0xdbbeee8a, 0xddd14dbb, 0, 20 }, /* #14 */
    { 0x3b5187, 0x3b5187, 0xdbbeee8a, 0xddd15dbb, 0, 20 }, /* #14 b */
    { 0x162807, 0x162806, 0x4e04e188, 0x70c45381, 0, 18 }, /* #15 */
    { 0x2957d2, 0x2957d2, 0x4e04e188, 0x70c41381, 0, 18 }, /* #15 b */
    { 0x330302, 0x330302, 0x61339773, 0xe6613397, 0, 72 }, /* #16 */
    { 0x0c7cd7, 0x0c7cd6, 0x61339773, 0xe7613397, 0, 72 }, /* #16 b */
    { 0x0516d2, 0x051ed3, 0xe1058569, 0x841615a5, 0, 63 }, /* #17 */
    { 0x3a6907, 0x3a6107, 0xe1058569, 0x841615a7, 0, 63 }, /* #17 b */
    { 0x155386, 0x155387, 0x287d6a0b, 0x43eb5058, 0, 62 }, /* #18 */
    { 0x2a2c53, 0x2a2c53, 0x287d6a0b, 0x43eb505c, 0, 62 }, /* #18 b */
    { 0x354812, 0x354812, 0x9e732050, 0xf3990282, 0, 126 }, /* #19 */
    { 0x0a37c7, 0x0a37c6, 0x9e732050, 0xf3990286, 0, 126 }, /* #19 b */
    { 0x187012, 0x187012, 0x3a5786c7, 0x3638e95e, 0, 78 }, /* #20 */
    { 0x270fc7, 0x270fc6, 0x3a5786c7, 0x363ce95e, 0, 78 }, /* #20 b */
    { 0x3a3612, 0x3a3e13, 0xcf3d498e, 0xea4c733c, 0, 54 }, /* #21 */
    { 0x0549c7, 0x0541c7, 0xcf3d498e, 0xea4c773c, 0, 54 }, /* #21 b */
    { 0x2c1a97, 0x2c1a96, 0x247dd507, 0xa0f247dd, 0, 108 }, /* #22 */
    { 0x136542, 0x136542, 0x247dd507, 0xa0e247dd, 0, 108 }, /* #22 b */
    { 0x045b92, 0x045393, 0x5e0bc272, 0x391782f0, 0, 74 }, /* #23 */
    { 0x3b2447, 0x3b2c47, 0x5e0bc272, 0x395782f0, 0, 74 }, /* #23 b */
    { 0x1213d6, 0x1213d7, 0x2d19ed40, 0x19ed4016, 0, 121 }, /* #24 */
    { 0x2d6c03, 0x2d6c03, 0x2d19ed40, 0x19ed4096, 0, 121 }, /* #24 b */
    { 0x091402, 0x091c02, 0xaf9b5862, 0x312be6d6, 0, 10 }, /* #25 */
    { 0x366bd7, 0x3663d6, 0xaf9b5862, 0x316be6d6, 0, 10 }, /* #25 b */
    { 0x160057, 0x160057, 0xbfbc8b02, 0x816fef22, 0, 74 }, /* #26 */
    { 0x297f82, 0x297f83, 0xbfbc8b02, 0x812fef22, 0, 74 }, /* #26 b */
    { 0x0a5d96, 0x0a5596, 0x18e89b29, 0x863a26ca, 0, 2  }, /* #27 */
    { 0x352243, 0x352a42, 0x18e89b29, 0xc63a26ca, 0, 2  }, /* #27 b */
    { 0x3111d2, 0x3111d2, 0x0a68c9b9, 0x9a326e41, 0, 91 }, /* #28 */
    { 0x0e6e07, 0x0e6e06, 0x0a68c9b9, 0x9a326e61, 0, 91 }, /* #28 b */
    { 0x0e66c7, 0x0e6ec7, 0x187886bd, 0x7b187886, 0, 72 }, /* #29 */
    { 0x311912, 0x311113, 0x187886bd, 0x7a187886, 0, 72 }, /* #29 b */
    { 0x360647, 0x360647, 0x86f14d46, 0x1b0de29a, 0, 39 }, /* #30 */
    { 0x097992, 0x097993, 0x86f14d46, 0x190de29a, 0, 39 }, /* #30 b */
    { 0x2f5916, 0x2f5917, 0xf19e7a12, 0xa1278cf3, 0, 77 }, /* #31 */
    { 0x1026c3, 0x1026c3, 0xf19e7a12, 0xa12f8cf3, 0, 77 }, /* #31 b */
    { 0x237353, 0x237353, 0xd1cd5ab5, 0x56bd1cd5, 0, 108 }, /* #32 */
    { 0x1c0c86, 0x1c0c87, 0xd1cd5ab5, 0x56ad1cd5, 0, 108 }, /* #32 b */
    { 0x287853, 0x287852, 0x15ae4944, 0xd724a245, 0, 26 }, /* #33 */
    { 0x170786, 0x170786, 0x15ae4944, 0xd724a205, 0, 26 }, /* #33 b */
    { 0x124886, 0x124886, 0xa67655e4, 0xcecabc8a, 0, 60 }, /* #34 */
    { 0x2d3753, 0x2d3752, 0xa67655e4, 0xcecabc9a, 0, 60 }, /* #34 b */
    { 0x0f28d3, 0x0f20d2, 0xc6673727, 0xcce6e4fc, 0, 124 }, /* #35 */
    { 0x305706, 0x305f06, 0xc6673727, 0xcce6e4ec, 0, 124 }, /* #35 b */
    { 0x3d2b83, 0x3d2b83, 0x4bb60f69, 0xdb07b4d2, 0, 26 }, /* #36 */
    { 0x025456, 0x025457, 0x4bb60f69, 0xdb07b492, 0, 26 }, /* #36 b */
    { 0x015c97, 0x015c97, 0x78dd1c80, 0x90178dd1, 0, 76 }, /* #37 */
    { 0x3e2342, 0x3e2343, 0x78dd1c80, 0x90078dd1, 0, 76 }, /* #37 b */
    { 0x2a1b97, 0x2a1396, 0x84730933, 0x24cf08e6, 0, 79 }, /* #38 */
    { 0x156442, 0x156c42, 0x84730933, 0x24cd08e6, 0, 79 }, /* #38 b */
    { 0x295846, 0x295046, 0x3afb1d64, 0x0ebec759, 0, 2  }, /* #39 */
    { 0x162793, 0x162f92, 0x3afb1d64, 0x4ebec759, 0, 2  }, /* #39 b */
    { 0x1d5293, 0x1d5292, 0xfd4d35ab, 0xaffa9a6b, 0, 7  }, /* #40 */
    { 0x222d46, 0x222d46, 0xfd4d35ab, 0xadfa9a6b, 0, 7  }, /* #40 b */
    { 0x0110d3, 0x0118d2, 0x0bc62d60, 0xd6085e31, 0, 45 }, /* #41 */
    { 0x3e6f06, 0x3e6706, 0x0bc62d60, 0xd6005e31, 0, 45 }, /* #41 b */
    { 0x0c1c56, 0x0c1457, 0x19aa7925, 0x0cd53c92, 0, 97 }, /* #42 */
    { 0x336383, 0x336b83, 0x19aa7925, 0x8cd53c92, 0, 97 }, /* #42 b */
    { 0x245e83, 0x245682, 0xd625b15a, 0x5b15aeb1, 0, 21 }, /* #43 */
    { 0x1b2156, 0x1b2956, 0xd625b15a, 0x5b15a6b1, 0, 21 }, /* #43 b */
    { 0x1e0997, 0x1e0196, 0xf4f762a1, 0x9eec543f, 0, 60 }, /* #44 */
    { 0x217642, 0x217e42, 0xf4f762a1, 0x9eec542f, 0, 60 }, /* #44 b */
    { 0x344a93, 0x344292, 0xd213ebf2, 0x27d7e5d2, 0, 88 }, /* #45 */
    { 0x0b3546, 0x0b3d46, 0xd213ebf2, 0x27d7e4d2, 0, 88 }, /* #45 b */
    { 0x0052d7, 0x005ad6, 0x018f4e16, 0x7a70b406, 0, 86 }, /* #46 */
    { 0x3f2d02, 0x3f2502, 0x018f4e16, 0x7a70b006, 0, 86 }, /* #46 b */
    { 0x3f6fd3, 0x3f67d3, 0xc0128320, 0x907004a0, 0, 42 }, /* #47 */
    { 0x001006, 0x001807, 0xc0128320, 0x903004a0, 0, 42 }, /* #47 b */
    { 0x377703, 0x377f03, 0x53ff2503, 0x40ea7fe4, 0, 107 }, /* #48 */
    { 0x0808d6, 0x0800d7, 0x53ff2503, 0x40ca7fe4, 0, 107 }, /* #48 b */
    { 0x0c2b86, 0x0c2387, 0x70365c91, 0xc0d97244, 0, 31 }, /* #49 */
    { 0x335453, 0x335c53, 0x70365c91, 0xc0d97246, 0, 31 }, /* #49 b */
    { 0x203e97, 0x203e97, 0x43e1bc6d, 0xbc6da1f0, 0, 81 }, /* #50 */
    { 0x1f4142, 0x1f4143, 0x43e1bc6d, 0xbc6d21f0, 0, 81 }, /* #50 b */
    { 0x2978d3, 0x2970d3, 0xa967d0d0, 0xa1a1a967, 0, 16 }, /* #51 */
    { 0x160706, 0x160f07, 0xa967d0d0, 0xa1a0a967, 0, 16 }, /* #51 b */
    { 0x100592, 0x100d93, 0xbdb8eb24, 0x6e3ac917, 0, 27 }, /* #52 */
    { 0x2f7a47, 0x2f7247, 0xbdb8eb24, 0x6e3ac937, 0, 27 }, /* #52 b */
    { 0x3d73d3, 0x3d73d3, 0x82a34844, 0x30546908, 0, 35 }, /* #53 */
    { 0x020c06, 0x020c07, 0x82a34844, 0x10546908, 0, 35 }, /* #53 b */
    { 0x3265d7, 0x3265d7, 0xb50f99e5, 0x2ed43e67, 0, 38 }, /* #54 */
    { 0x0d1a02, 0x0d1a03, 0xb50f99e5, 0x2ad43e67, 0, 38 }, /* #54 b */
    { 0x3d7383, 0x3d7382, 0xe62f1258, 0x62f1258f, 0, 125 }, /* #55 */
    { 0x020c56, 0x020c56, 0xe62f1258, 0x62f12587, 0, 125 }, /* #55 b */
    { 0x0b6e56, 0x0b6e56, 0x96165718, 0xb0b2b8c2, 0, 94 }, /* #56 */
    { 0x341183, 0x341182, 0x96165718, 0xb0b2b8c6, 0, 94 }, /* #56 b */
    { 0x037386, 0x037b87, 0x95ae627e, 0xcc4fc95a, 0, 52 }, /* #57 */
    { 0x3c0c53, 0x3c0453, 0x95ae627e, 0xcc4fd95a, 0, 52 }, /* #57 b */
    { 0x341603, 0x341602, 0x8897d4c4, 0x98897d4c, 0, 36 }, /* #58 */
    { 0x0b69d6, 0x0b69d6, 0x8897d4c4, 0x88897d4c, 0, 36 }, /* #58 b */
    { 0x250687, 0x250686, 0xb74cb006, 0x06dba658, 0, 105 }, /* #59 */
    { 0x1a7952, 0x1a7952, 0xb74cb006, 0x065ba658, 0, 105 }, /* #59 b */
    { 0x251642, 0x251642, 0x521d04e9, 0x74948741, 0, 74 }, /* #60 */
    { 0x1a6997, 0x1a6996, 0x521d04e9, 0x74d48741, 0, 74 }, /* #60 b */
    { 0x2616c6, 0x2616c6, 0x4e4c3864, 0x61c32139, 0, 22 }, /* #61 */
    { 0x196913, 0x196912, 0x4e4c3864, 0x61c32539, 0, 22 }, /* #61 b */
    { 0x0a15c2, 0x0a15c3, 0x6f4aa8a2, 0x2aa288de, 0, 23 }, /* #62 */
    { 0x356a17, 0x356a17, 0x6f4aa8a2, 0x2aa28ade, 0, 23 }, /* #62 b */
    { 0x287e17, 0x287e17, 0x03ce2fde, 0xce2fde81, 0, 121 }, /* #63 */
    { 0x1701c2, 0x1701c3, 0x03ce2fde, 0xce2fde01, 0, 121 }, /* #63 b */
    { 0x306017, 0x306816, 0x098b2fd1, 0xc262cbf4, 0, 66 }, /* #64 */
    { 0x0f1fc2, 0x0f17c2, 0x098b2fd1, 0x8262cbf4, 0, 66 }, /* #64 b */
    { 0x015747, 0x015747, 0xc84994db, 0xb7c84994, 0, 40 }, /* #65 */
    { 0x3e2892, 0x3e2893, 0xc84994db, 0xb6c84994, 0, 40 }, /* #65 b */
    { 0x2d7103, 0x2d7103, 0xa4b792fd, 0xba4b792f, 0, 68 }, /* #66 */
    { 0x120ed6, 0x120ed7, 0xa4b792fd, 0xaa4b792f, 0, 68 }, /* #66 b */
    { 0x161f02, 0x161f03, 0xbb490c3c, 0x21878bb4, 0, 52 }, /* #67 */
    { 0x2960d7, 0x2960d7, 0xbb490c3c, 0x21879bb4, 0, 52 }, /* #67 b */
    { 0x0b7592, 0x0b7593, 0x67436a17, 0xd0da85cc, 0, 91 }, /* #68 */
    { 0x340a47, 0x340a47, 0x67436a17, 0xd0da85ec, 0, 91 }, /* #68 b */
    { 0x211382, 0x211b82, 0xeb96a508, 0x50875cb5, 0, 109 }, /* #69 */
    { 0x1e6c57, 0x1e6456, 0xeb96a508, 0x508f5cb5, 0, 109 }, /* #69 b */
    { 0x3f3106, 0x3f3907, 0xfb07b77b, 0xeddedf60, 0, 83 }, /* #70 */
    { 0x004ed3, 0x0046d3, 0xfb07b77b, 0xeddeff60, 0, 83 }, /* #70 b */
    { 0x240303, 0x240302, 0xa6e09278, 0xd370493c, 0, 65 }, /* #71 */
    { 0x1b7cd6, 0x1b7cd6, 0xa6e09278, 0x5370493c, 0, 65 }, /* #71 b */
    { 0x3c2496, 0x3c2497, 0x73c29f0a, 0x4f851cf0, 0, 18 }, /* #72 */
    { 0x035b43, 0x035b43, 0x73c29f0a, 0x4f855cf0, 0, 18 }, /* #72 b */
    { 0x313a42, 0x313242, 0x7800f04f, 0xf04f3c00, 0, 113 }, /* #73 */
    { 0x0e4597, 0x0e4d96, 0x7800f04f, 0xf04fbc00, 0, 113 }, /* #73 b */
    { 0x360ed6, 0x3606d7, 0x41b8987a, 0xe8837130, 0, 39 }, /* #74 */
    { 0x097103, 0x097903, 0x41b8987a, 0xea837130, 0, 39 }, /* #74 b */
    { 0x192707, 0x192706, 0xc378d3d5, 0xbc378d3d, 0, 68 }, /* #75 */
    { 0x2658d2, 0x2658d2, 0xc378d3d5, 0xac378d3d, 0, 68 }, /* #75 b */
    { 0x2c3dd3, 0x2c3dd3, 0x232f6f4b, 0xede97232, 0, 20 }, /* #76 */
    { 0x134206, 0x134207, 0x232f6f4b, 0xede96232, 0, 20 }, /* #76 b */
    { 0x030c93, 0x030c93, 0x35095d10, 0x5095d109, 0, 61 }, /* #77 */
    { 0x3c7346, 0x3c7347, 0x35095d10, 0x5095d101, 0, 61 }, /* #77 b */
    { 0x0a7043, 0x0a7042, 0xe3262cc6, 0x2cc6f193, 0, 81 }, /* #78 */
    { 0x350f96, 0x350f96, 0xe3262cc6, 0x2cc67193, 0, 81 }, /* #78 b */
    { 0x181c97, 0x181496, 0x926f8a21, 0x724df144, 0, 35 }, /* #79 */
    { 0x276342, 0x276b42, 0x926f8a21, 0x524df144, 0, 35 }, /* #79 b */
    { 0x0b2182, 0x0b2183, 0x2dcf2594, 0x05b9e4b2, 0, 67 }, /* #80 */
    { 0x345e57, 0x345e57, 0x2dcf2594, 0x25b9e4b2, 0, 67 }, /* #80 b */
    { 0x0c1c47, 0x0c1446, 0x95f8e294, 0xafc714a6, 0, 30 }, /* #81 */
    { 0x336392, 0x336b92, 0x95f8e294, 0xafc714a2, 0, 30 }, /* #81 b */
    { 0x1f09c2, 0x1f01c3, 0x3a5e4080, 0xe40801d2, 0, 85 }, /* #82 */
    { 0x207617, 0x207e17, 0x3a5e4080, 0xe40809d2, 0, 85 }, /* #82 b */
    { 0x170d07, 0x170d06, 0x40e1f183, 0xe1f183a0, 0, 121 }, /* #83 */
    { 0x2872d2, 0x2872d2, 0x40e1f183, 0xe1f18320, 0, 121 }, /* #83 b */
    { 0x2802c3, 0x2802c3, 0xaef477df, 0x477dfd77, 0, 53 }, /* #84 */
    { 0x177d16, 0x177d17, 0xaef477df, 0x477df577, 0, 53 }, /* #84 b */
    { 0x387f03, 0x387f03, 0x51f08841, 0x1f08841a, 0, 29 }, /* #85 */
    { 0x0700d6, 0x0700d7, 0x51f08841, 0x1f088412, 0, 29 }, /* #85 b */
    { 0x2041d3, 0x2041d3, 0x952455fd, 0xdca922af, 0, 69 }, /* #86 */
    { 0x1f3e06, 0x1f3e07, 0x952455fd, 0xd4a922af, 0, 69 }, /* #86 b */
    { 0x2d2253, 0x2d2a53, 0x71382374, 0xc11ba5c4, 0, 86 }, /* #87 */
    { 0x125d86, 0x125587, 0x71382374, 0xc11ba1c4, 0, 86 }, /* #87 b */
    { 0x370e57, 0x370656, 0xd1c8beb6, 0xbeb6e8e4, 0, 81 }, /* #88 */
    { 0x087182, 0x087982, 0xd1c8beb6, 0xbeb668e4, 0, 81 }, /* #88 b */
    { 0x3c61c3, 0x3c69c3, 0x2c3f697a, 0x697a961f, 0, 81 }, /* #89 */
    { 0x031e16, 0x031617, 0x2c3f697a, 0x697a161f, 0, 81 }, /* #89 b */
    { 0x2a69d3, 0x2a69d2, 0x5db459eb, 0xcf5d76d1, 0, 110 }, /* #90 */
    { 0x151606, 0x151606, 0x5db459eb, 0xcf5976d1, 0, 110 }, /* #90 b */
    { 0x365512, 0x365512, 0x227faae8, 0x8113fd57, 0, 5  }, /* #91 */
    { 0x092ac7, 0x092ac6, 0x227faae8, 0x8913fd57, 0, 5  }, /* #91 b */
    { 0x0a1b93, 0x0a1392, 0xee028201, 0x403ee028, 0, 108 }, /* #92 */
    { 0x356446, 0x356c46, 0xee028201, 0x402ee028, 0, 108 }, /* #92 b */
    { 0x093497, 0x093c96, 0x54141a57, 0x1a57aa0a, 0, 113 }, /* #93 */
    { 0x364b42, 0x364342, 0x54141a57, 0x1a572a0a, 0, 113 }, /* #93 b */
    { 0x354152, 0x354153, 0x6abf00bb, 0xb355f805, 0, 5  }, /* #94 */
    { 0x0a3e87, 0x0a3e87, 0x6abf00bb, 0xbb55f805, 0, 5  }, /* #94 b */
    { 0x267293, 0x267a92, 0x7566abfe, 0xbab355ff, 0, 97 }, /* #95 */
    { 0x190d46, 0x190546, 0x7566abfe, 0x3ab355ff, 0, 97 }, /* #95 b */
};
uint32_t const g_cTests_rcr_u32_intel = RT_ELEMENTS(g_aTests_rcr_u32_intel);

BINU32_TEST_T const g_aTests_shl_u32_intel[] =
{
    { 0x141f83, 0x141746, 0x00000000, 0x00000000, 0, 45 }, /* #0 */
    { 0x2b6056, 0x2b6046, 0x00000000, 0x00000000, 0, 45 }, /* #0 b */
    { 0x047c86, 0x047446, 0x00000000, 0x00000000, 0, 57 }, /* #1 */
    { 0x3b0353, 0x3b0346, 0x00000000, 0x00000000, 0, 57 }, /* #1 b */
    { 0x2a7dc6, 0x2a7546, 0x00000000, 0x00000000, 0, 75 }, /* #2 */
    { 0x150213, 0x150246, 0x00000000, 0x00000000, 0, 75 }, /* #2 b */
    { 0x010947, 0x010146, 0x00000000, 0x00000000, 0, 16 }, /* #3 */
    { 0x3e7692, 0x3e7646, 0x00000000, 0x00000000, 0, 16 }, /* #3 b */
    { 0x314b53, 0x314346, 0x00000000, 0x00000000, 0, 99 }, /* #4 */
    { 0x0e3486, 0x0e3446, 0x00000000, 0x00000000, 0, 99 }, /* #4 b */
    { 0x1772c7, 0x177246, 0x00000000, 0x00000000, 0, 90 }, /* #5 */
    { 0x280d12, 0x280546, 0x00000000, 0x00000000, 0, 90 }, /* #5 b */
    { 0x397c42, 0x397402, 0xf1a711b2, 0x34e23640, 0, 69 }, /* #6 */
    { 0x060397, 0x060302, 0xf1a711b2, 0x34e23640, 0, 69 }, /* #6 b */
    { 0x276c46, 0x276486, 0x0908d173, 0x8b980000, 0, 19 }, /* #7 */
    { 0x181393, 0x181386, 0x0908d173, 0x8b980000, 0, 19 }, /* #7 b */
    { 0x354c52, 0x354c82, 0xb9d4b504, 0xe752d410, 0, 66 }, /* #8 */
    { 0x0a3387, 0x0a3b82, 0xb9d4b504, 0xe752d410, 0, 66 }, /* #8 b */
    { 0x0e4b02, 0x0e4b87, 0x74300856, 0x8042b000, 0, 11 }, /* #9 */
    { 0x3134d7, 0x313c87, 0x74300856, 0x8042b000, 0, 11 }, /* #9 b */
    { 0x027382, 0x027386, 0xc44ba073, 0x9740e600, 0, 9  }, /* #10 */
    { 0x3d0c57, 0x3d0486, 0xc44ba073, 0x9740e600, 0, 9  }, /* #10 b */
    { 0x216b46, 0x216386, 0xfd286c21, 0x84000000, 0, 58 }, /* #11 */
    { 0x1e1493, 0x1e1486, 0xfd286c21, 0x84000000, 0, 58 }, /* #11 b */
    { 0x1d5a92, 0x1d5a86, 0x4e9b05eb, 0x9b05eb00, 0, 8  }, /* #12 */
    { 0x222547, 0x222d86, 0x4e9b05eb, 0x9b05eb00, 0, 8  }, /* #12 b */
    { 0x1a6583, 0x1a6d06, 0x6fc4b50b, 0x5a858000, 0, 111 }, /* #13 */
    { 0x251a56, 0x251a06, 0x6fc4b50b, 0x5a858000, 0, 111 }, /* #13 b */
    { 0x0b5a57, 0x0b5286, 0xe79b7f56, 0xdbfab000, 0, 107 }, /* #14 */
    { 0x342582, 0x342586, 0xe79b7f56, 0xdbfab000, 0, 107 }, /* #14 b */
    { 0x292607, 0x292686, 0x1041820c, 0x820c1060, 0, 3  }, /* #15 */
    { 0x1659d2, 0x165186, 0x1041820c, 0x820c1060, 0, 3  }, /* #15 b */
    { 0x0e5692, 0x0e5692, 0x7411011d, 0x7411011d, 0, 0  }, /* #16 */
    { 0x312947, 0x312947, 0x7411011d, 0x7411011d, 0, 0  }, /* #16 b */
    { 0x316407, 0x316c46, 0x4761bfc8, 0x00000000, 0, 126 }, /* #17 */
    { 0x0e1bd2, 0x0e1b46, 0x4761bfc8, 0x00000000, 0, 126 }, /* #17 b */
    { 0x012487, 0x012c83, 0x5928b467, 0x928b4670, 0, 68 }, /* #18 */
    { 0x3e5b52, 0x3e5b83, 0x5928b467, 0x928b4670, 0, 68 }, /* #18 b */
    { 0x3b20c6, 0x3b2046, 0x24ec83a0, 0x00000000, 0, 30 }, /* #19 */
    { 0x045f13, 0x045746, 0x24ec83a0, 0x00000000, 0, 30 }, /* #19 b */
    { 0x3e2e46, 0x3e2603, 0x13bee952, 0x3bee9520, 0, 68 }, /* #20 */
    { 0x015193, 0x015103, 0x13bee952, 0x3bee9520, 0, 68 }, /* #20 b */
    { 0x340e13, 0x340603, 0x1091ee5b, 0x091ee5b0, 0, 100 }, /* #21 */
    { 0x0b71c6, 0x0b7103, 0x1091ee5b, 0x091ee5b0, 0, 100 }, /* #21 b */
    { 0x313b96, 0x313387, 0x1c147a67, 0xd3380000, 0, 83 }, /* #22 */
    { 0x0e4443, 0x0e4487, 0x1c147a67, 0xd3380000, 0, 83 }, /* #22 b */
    { 0x022fc2, 0x022f87, 0x7b04059a, 0xb04059a0, 0, 4  }, /* #23 */
    { 0x3d5017, 0x3d5887, 0x7b04059a, 0xb04059a0, 0, 4  }, /* #23 b */
    { 0x1245d2, 0x124d06, 0xbea0940b, 0x16000000, 0, 89 }, /* #24 */
    { 0x2d3a07, 0x2d3a06, 0xbea0940b, 0x16000000, 0, 89 }, /* #24 b */
    { 0x022217, 0x022202, 0x12de4b4d, 0x4b792d34, 0, 66 }, /* #25 */
    { 0x3d5dc2, 0x3d5502, 0x12de4b4d, 0x4b792d34, 0, 66 }, /* #25 b */
    { 0x1727c7, 0x172786, 0x10a78ff7, 0x9e3fdc00, 0, 106 }, /* #26 */
    { 0x285812, 0x285086, 0x10a78ff7, 0x9e3fdc00, 0, 106 }, /* #26 b */
    { 0x224103, 0x224183, 0x3f058001, 0x82c00080, 0, 71 }, /* #27 */
    { 0x1d3ed6, 0x1d3683, 0x3f058001, 0x82c00080, 0, 71 }, /* #27 b */
    { 0x3b0fc2, 0x3b0f83, 0xbfc1bc93, 0xe0de4980, 0, 39 }, /* #28 */
    { 0x047017, 0x047883, 0xbfc1bc93, 0xe0de4980, 0, 39 }, /* #28 b */
    { 0x324083, 0x324086, 0xd1c60aeb, 0xb0000000, 0, 28 }, /* #29 */
    { 0x0d3f56, 0x0d3786, 0xd1c60aeb, 0xb0000000, 0, 28 }, /* #29 b */
    { 0x0503c3, 0x050307, 0x15440ac0, 0x60000000, 0, 87 }, /* #30 */
    { 0x3a7c16, 0x3a7407, 0x15440ac0, 0x60000000, 0, 87 }, /* #30 b */
    { 0x321b47, 0x321307, 0xc1b1225d, 0x74000000, 0, 122 }, /* #31 */
    { 0x0d6492, 0x0d6407, 0xc1b1225d, 0x74000000, 0, 122 }, /* #31 b */
    { 0x091b43, 0x091387, 0x3c23e510, 0xe5100000, 0, 112 }, /* #32 */
    { 0x366496, 0x366487, 0x3c23e510, 0xe5100000, 0, 112 }, /* #32 b */
    { 0x0477c6, 0x047f86, 0x620b64de, 0xd9378000, 0, 14 }, /* #33 */
    { 0x3b0813, 0x3b0886, 0x620b64de, 0xd9378000, 0, 14 }, /* #33 b */
    { 0x024d06, 0x024587, 0xcf56ca99, 0x95320000, 0, 113 }, /* #34 */
    { 0x3d32d3, 0x3d3287, 0xcf56ca99, 0x95320000, 0, 113 }, /* #34 b */
    { 0x0f6643, 0x0f6e07, 0xa844d552, 0x54800000, 0, 22 }, /* #35 */
    { 0x301996, 0x301907, 0xa844d552, 0x54800000, 0, 22 }, /* #35 b */
    { 0x275bc3, 0x275b06, 0x51d3e602, 0x60200000, 0, 20 }, /* #36 */
    { 0x182416, 0x182c06, 0x51d3e602, 0x60200000, 0, 20 }, /* #36 b */
    { 0x0443c3, 0x044b87, 0x7f6efee3, 0xdbbfb8c0, 0, 102 }, /* #37 */
    { 0x3b3c16, 0x3b3c87, 0x7f6efee3, 0xdbbfb8c0, 0, 102 }, /* #37 b */
    { 0x0e7317, 0x0e7387, 0xef73246f, 0xc0000000, 0, 30 }, /* #38 */
    { 0x310cc2, 0x310487, 0xef73246f, 0xc0000000, 0, 30 }, /* #38 b */
    { 0x311556, 0x311586, 0x34ebec67, 0xce000000, 0, 121 }, /* #39 */
    { 0x0e6a83, 0x0e6286, 0x34ebec67, 0xce000000, 0, 121 }, /* #39 b */
    { 0x042ac7, 0x042287, 0x1f7f8de2, 0xfe378800, 0, 42 }, /* #40 */
    { 0x3b5512, 0x3b5587, 0x1f7f8de2, 0xfe378800, 0, 42 }, /* #40 b */
    { 0x0d11d2, 0x0d1186, 0xcc4d1a90, 0x80000000, 0, 91 }, /* #41 */
    { 0x326e07, 0x326686, 0xcc4d1a90, 0x80000000, 0, 91 }, /* #41 b */
    { 0x2c73c2, 0x2c7386, 0x0fb4b233, 0xd2c8cc00, 0, 10 }, /* #42 */
    { 0x130c17, 0x130486, 0x0fb4b233, 0xd2c8cc00, 0, 10 }, /* #42 b */
    { 0x193716, 0x193f07, 0x95ad15cc, 0x6b457300, 0, 6  }, /* #43 */
    { 0x2648c3, 0x264807, 0x95ad15cc, 0x6b457300, 0, 6  }, /* #43 b */
    { 0x210e42, 0x210603, 0xd36fc6af, 0x4dbf1abc, 0, 66 }, /* #44 */
    { 0x1e7197, 0x1e7103, 0xd36fc6af, 0x4dbf1abc, 0, 66 }, /* #44 b */
    { 0x106e47, 0x106e03, 0x55c6db60, 0x571b6d80, 0, 66 }, /* #45 */
    { 0x2f1192, 0x2f1903, 0x55c6db60, 0x571b6d80, 0, 66 }, /* #45 b */
    { 0x144c57, 0x144c86, 0x4bde4976, 0xbde49760, 0, 4  }, /* #46 */
    { 0x2b3382, 0x2b3b86, 0x4bde4976, 0xbde49760, 0, 4  }, /* #46 b */
    { 0x061716, 0x061716, 0xb574d8bc, 0xb574d8bc, 0, 0  }, /* #47 */
    { 0x3968c3, 0x3968c3, 0xb574d8bc, 0xb574d8bc, 0, 0  }, /* #47 b */
    { 0x2a05d6, 0x2a0506, 0x1c41051b, 0x41051b00, 0, 104 }, /* #48 */
    { 0x157a03, 0x157206, 0x1c41051b, 0x41051b00, 0, 104 }, /* #48 b */
    { 0x053497, 0x053c86, 0x4b1ce575, 0xb1ce5750, 0, 4  }, /* #49 */
    { 0x3a4b42, 0x3a4b86, 0x4b1ce575, 0xb1ce5750, 0, 4  }, /* #49 b */
    { 0x165b12, 0x165386, 0xcb18e999, 0x80000000, 0, 63 }, /* #50 */
    { 0x2924c7, 0x292486, 0xcb18e999, 0x80000000, 0, 63 }, /* #50 b */
    { 0x091303, 0x091386, 0x24b72d75, 0xdcb5d400, 0, 74 }, /* #51 */
    { 0x366cd6, 0x366486, 0x24b72d75, 0xdcb5d400, 0, 74 }, /* #51 b */
    { 0x1977d6, 0x197786, 0xcd584c4d, 0xd0000000, 0, 92 }, /* #52 */
    { 0x260803, 0x260086, 0xcd584c4d, 0xd0000000, 0, 92 }, /* #52 b */
    { 0x3f23d7, 0x3f2387, 0xc4c7879f, 0xe1e7c000, 0, 14 }, /* #53 */
    { 0x005c02, 0x005487, 0xc4c7879f, 0xe1e7c000, 0, 14 }, /* #53 b */
    { 0x156642, 0x156e06, 0xb318326b, 0x3064d600, 0, 41 }, /* #54 */
    { 0x2a1997, 0x2a1906, 0xb318326b, 0x3064d600, 0, 41 }, /* #54 b */
    { 0x335613, 0x335686, 0xdd63d4d3, 0x98000000, 0, 123 }, /* #55 */
    { 0x0c29c6, 0x0c2186, 0xdd63d4d3, 0x98000000, 0, 123 }, /* #55 b */
    { 0x044503, 0x044507, 0x0f25e20e, 0x2f107000, 0, 75 }, /* #56 */
    { 0x3b3ad6, 0x3b3207, 0x0f25e20e, 0x2f107000, 0, 75 }, /* #56 b */
    { 0x2f0596, 0x2f0d87, 0x79cbb8ae, 0x97715c00, 0, 41 }, /* #57 */
    { 0x107a43, 0x107a87, 0x79cbb8ae, 0x97715c00, 0, 41 }, /* #57 b */
    { 0x397dd7, 0x397d86, 0xa29571d8, 0xc0000000, 0, 91 }, /* #58 */
    { 0x060202, 0x060a86, 0xa29571d8, 0xc0000000, 0, 91 }, /* #58 b */
    { 0x143a96, 0x143a07, 0x824c8a4c, 0x22930000, 0, 110 }, /* #59 */
    { 0x2b4543, 0x2b4d07, 0x824c8a4c, 0x22930000, 0, 110 }, /* #59 b */
    { 0x0749c7, 0x074182, 0xd1fbe079, 0x8fdf03c8, 0, 99 }, /* #60 */
    { 0x383612, 0x383682, 0xd1fbe079, 0x8fdf03c8, 0, 99 }, /* #60 b */
    { 0x250683, 0x250e86, 0x7eb08a27, 0xb08a2700, 0, 8  }, /* #61 */
    { 0x1a7956, 0x1a7986, 0x7eb08a27, 0xb08a2700, 0, 8  }, /* #61 b */
    { 0x231383, 0x231b06, 0x440200d7, 0x06b80000, 0, 115 }, /* #62 */
    { 0x1c6c56, 0x1c6c06, 0x440200d7, 0x06b80000, 0, 115 }, /* #62 b */
    { 0x163fd6, 0x163f87, 0xa038fdcc, 0x80000000, 0, 29 }, /* #63 */
    { 0x294003, 0x294887, 0xa038fdcc, 0x80000000, 0, 29 }, /* #63 b */
    { 0x371dd7, 0x371506, 0x0a24cf41, 0x40000000, 0, 94 }, /* #64 */
    { 0x086202, 0x086206, 0x0a24cf41, 0x40000000, 0, 94 }, /* #64 b */
    { 0x286556, 0x286586, 0x19ddb0ca, 0xed865000, 0, 11 }, /* #65 */
    { 0x171a83, 0x171286, 0x19ddb0ca, 0xed865000, 0, 11 }, /* #65 b */
    { 0x396fc2, 0x396786, 0x36ab8ed4, 0xdaae3b50, 0, 34 }, /* #66 */
    { 0x061017, 0x061086, 0x36ab8ed4, 0xdaae3b50, 0, 34 }, /* #66 b */
    { 0x3e1253, 0x3e1207, 0xc4151a36, 0x105468d8, 0, 66 }, /* #67 */
    { 0x016d86, 0x016507, 0xc4151a36, 0x105468d8, 0, 66 }, /* #67 b */
    { 0x343ec3, 0x343686, 0xe4bc69ac, 0xd3580000, 0, 49 }, /* #68 */
    { 0x0b4116, 0x0b4186, 0xe4bc69ac, 0xd3580000, 0, 49 }, /* #68 b */
    { 0x166fc7, 0x166787, 0xfb7ac541, 0x8a820000, 0, 81 }, /* #69 */
    { 0x291012, 0x291087, 0xfb7ac541, 0x8a820000, 0, 81 }, /* #69 b */
    { 0x085c47, 0x085c03, 0x4a1f03ef, 0x287c0fbc, 0, 2  }, /* #70 */
    { 0x372392, 0x372b03, 0x4a1f03ef, 0x287c0fbc, 0, 2  }, /* #70 b */
    { 0x1036c7, 0x103e86, 0x6d13a46d, 0x80000000, 0, 95 }, /* #71 */
    { 0x2f4912, 0x2f4986, 0x6d13a46d, 0x80000000, 0, 95 }, /* #71 b */
    { 0x2b6182, 0x2b6187, 0xc8ee3128, 0xb8c4a000, 0, 74 }, /* #72 */
    { 0x141e57, 0x141687, 0xc8ee3128, 0xb8c4a000, 0, 74 }, /* #72 b */
    { 0x0d6112, 0x0d6907, 0x742196bb, 0x5d800000, 0, 23 }, /* #73 */
    { 0x321ec7, 0x321e07, 0x742196bb, 0x5d800000, 0, 23 }, /* #73 b */
    { 0x385092, 0x385086, 0x3de8d32f, 0x8d32f000, 0, 12 }, /* #74 */
    { 0x072f47, 0x072786, 0x3de8d32f, 0x8d32f000, 0, 12 }, /* #74 b */
    { 0x247152, 0x247907, 0xa2ade6e8, 0x74000000, 0, 55 }, /* #75 */
    { 0x1b0e87, 0x1b0e07, 0xa2ade6e8, 0x74000000, 0, 55 }, /* #75 b */
    { 0x311357, 0x311307, 0x05543880, 0x54388000, 0, 72 }, /* #76 */
    { 0x0e6c82, 0x0e6407, 0x05543880, 0x54388000, 0, 72 }, /* #76 b */
    { 0x1e5802, 0x1e5087, 0xdecab59f, 0xacf80000, 0, 115 }, /* #77 */
    { 0x2127d7, 0x212787, 0xdecab59f, 0xacf80000, 0, 115 }, /* #77 b */
    { 0x0c36d6, 0x0c3e07, 0x55d3d1aa, 0x3d1aa000, 0, 44 }, /* #78 */
    { 0x334903, 0x334907, 0x55d3d1aa, 0x3d1aa000, 0, 44 }, /* #78 b */
    { 0x3f18d7, 0x3f1806, 0x7aab7091, 0x40000000, 0, 126 }, /* #79 */
    { 0x006702, 0x006f06, 0x7aab7091, 0x40000000, 0, 126 }, /* #79 b */
    { 0x0f1e97, 0x0f1e87, 0x4eef17f6, 0xbc5fd800, 0, 42 }, /* #80 */
    { 0x306142, 0x306987, 0x4eef17f6, 0xbc5fd800, 0, 42 }, /* #80 b */
    { 0x0e5657, 0x0e5e87, 0x83bfb332, 0xdfd99900, 0, 7  }, /* #81 */
    { 0x312982, 0x312987, 0x83bfb332, 0xdfd99900, 0, 7  }, /* #81 b */
    { 0x180cd7, 0x180c87, 0x41c634ff, 0xf8000000, 0, 27 }, /* #82 */
    { 0x277302, 0x277b87, 0x41c634ff, 0xf8000000, 0, 27 }, /* #82 b */
    { 0x035296, 0x035a86, 0x88bbfb69, 0x8bbfb690, 0, 4  }, /* #83 */
    { 0x3c2d43, 0x3c2d86, 0x88bbfb69, 0x8bbfb690, 0, 4  }, /* #83 b */
    { 0x3f3196, 0x3f3106, 0xf2655981, 0x20000000, 0, 93 }, /* #84 */
    { 0x004e43, 0x004606, 0xf2655981, 0x20000000, 0, 93 }, /* #84 b */
    { 0x233c96, 0x233487, 0x3df087d5, 0xc21f5400, 0, 74 }, /* #85 */
    { 0x1c4343, 0x1c4387, 0x3df087d5, 0xc21f5400, 0, 74 }, /* #85 b */
    { 0x3b4456, 0x3b4406, 0x1ce7a220, 0x44000000, 0, 53 }, /* #86 */
    { 0x043b83, 0x043306, 0x1ce7a220, 0x44000000, 0, 53 }, /* #86 b */
    { 0x165402, 0x165c07, 0x8e9be614, 0x0a000000, 0, 23 }, /* #87 */
    { 0x292bd7, 0x292b07, 0x8e9be614, 0x0a000000, 0, 23 }, /* #87 b */
    { 0x1c5907, 0x1c5106, 0x1d3eb89d, 0x27400000, 0, 118 }, /* #88 */
    { 0x2326d2, 0x232606, 0x1d3eb89d, 0x27400000, 0, 118 }, /* #88 b */
    { 0x0a2992, 0x0a2992, 0xde6d6a63, 0xde6d6a63, 0, 32 }, /* #89 */
    { 0x355647, 0x355647, 0xde6d6a63, 0xde6d6a63, 0, 32 }, /* #89 b */
    { 0x2f1407, 0x2f1407, 0x2ea511bf, 0x11bf0000, 0, 16 }, /* #90 */
    { 0x106bd2, 0x106307, 0x2ea511bf, 0x11bf0000, 0, 16 }, /* #90 b */
    { 0x145a12, 0x145a12, 0x04f79be3, 0x04f79be3, 0, 0  }, /* #91 */
    { 0x2b25c7, 0x2b25c7, 0x04f79be3, 0x04f79be3, 0, 0  }, /* #91 b */
    { 0x186586, 0x186587, 0xf09848c7, 0x80000000, 0, 95 }, /* #92 */
    { 0x271a53, 0x271287, 0xf09848c7, 0x80000000, 0, 95 }, /* #92 b */
    { 0x123007, 0x123887, 0x5ece4746, 0xd9c8e8c0, 0, 101 }, /* #93 */
    { 0x2d4fd2, 0x2d4f87, 0x5ece4746, 0xd9c8e8c0, 0, 101 }, /* #93 b */
    { 0x2d4e06, 0x2d4e07, 0x67cf92e2, 0x10000000, 0, 59 }, /* #94 */
    { 0x1231d3, 0x123907, 0x67cf92e2, 0x10000000, 0, 59 }, /* #94 b */
    { 0x183e03, 0x183e87, 0xad5ae6b6, 0xae6b6000, 0, 12 }, /* #95 */
    { 0x2741d6, 0x274987, 0xad5ae6b6, 0xae6b6000, 0, 12 }, /* #95 b */
};
uint32_t const g_cTests_shl_u32_intel = RT_ELEMENTS(g_aTests_shl_u32_intel);

BINU32_TEST_T const g_aTests_shr_u32_intel[] =
{
    { 0x1531d3, 0x153146, 0x00000000, 0x00000000, 0, 15 }, /* #0 */
    { 0x2a4e06, 0x2a4646, 0x00000000, 0x00000000, 0, 15 }, /* #0 b */
    { 0x275192, 0x275146, 0x00000000, 0x00000000, 0, 79 }, /* #1 */
    { 0x182e47, 0x182646, 0x00000000, 0x00000000, 0, 79 }, /* #1 b */
    { 0x1b5946, 0x1b5146, 0x00000000, 0x00000000, 0, 127 }, /* #2 */
    { 0x242693, 0x242646, 0x00000000, 0x00000000, 0, 127 }, /* #2 b */
    { 0x1b3796, 0x1b3746, 0x00000000, 0x00000000, 0, 77 }, /* #3 */
    { 0x244843, 0x244046, 0x00000000, 0x00000000, 0, 77 }, /* #3 b */
    { 0x195746, 0x195746, 0x00000000, 0x00000000, 0, 62 }, /* #4 */
    { 0x262893, 0x262046, 0x00000000, 0x00000000, 0, 62 }, /* #4 b */
    { 0x1f1087, 0x1f1046, 0x00000000, 0x00000000, 0, 25 }, /* #5 */
    { 0x206f52, 0x206746, 0x00000000, 0x00000000, 0, 25 }, /* #5 b */
    { 0x3b7f02, 0x3b7707, 0x08bc3595, 0x000022f0, 0, 46 }, /* #6 */
    { 0x0400d7, 0x040007, 0x08bc3595, 0x000022f0, 0, 46 }, /* #6 b */
    { 0x3f4146, 0x3f4903, 0x90bf183d, 0x00090bf1, 0, 108 }, /* #7 */
    { 0x003e93, 0x003e03, 0x90bf183d, 0x00090bf1, 0, 108 }, /* #7 b */
    { 0x361d83, 0x361d03, 0xa7ac4ece, 0x0000029e, 0, 86 }, /* #8 */
    { 0x096256, 0x096a03, 0xa7ac4ece, 0x0000029e, 0, 86 }, /* #8 b */
    { 0x0a2002, 0x0a2803, 0xf3d11106, 0x00000007, 0, 61 }, /* #9 */
    { 0x355fd7, 0x355f03, 0xf3d11106, 0x00000007, 0, 61 }, /* #9 b */
    { 0x1027d7, 0x102f03, 0xdd6dc422, 0x0000000d, 0, 92 }, /* #10 */
    { 0x2f5802, 0x2f5803, 0xdd6dc422, 0x0000000d, 0, 92 }, /* #10 b */
    { 0x3513c2, 0x351b03, 0xdc2e9ebb, 0x0000000d, 0, 60 }, /* #11 */
    { 0x0a6c17, 0x0a6c03, 0xdc2e9ebb, 0x0000000d, 0, 60 }, /* #11 b */
    { 0x063143, 0x063106, 0x47170da3, 0x000238b8, 0, 13 }, /* #12 */
    { 0x394e96, 0x394606, 0x47170da3, 0x000238b8, 0, 13 }, /* #12 b */
    { 0x0a0757, 0x0a0f03, 0xcfa69bd7, 0x00067d34, 0, 77 }, /* #13 */
    { 0x357882, 0x357803, 0xcfa69bd7, 0x00067d34, 0, 77 }, /* #13 b */
    { 0x2d2fc7, 0x2d2747, 0x11fb028d, 0x00000000, 0, 61 }, /* #14 */
    { 0x125012, 0x125047, 0x11fb028d, 0x00000000, 0, 61 }, /* #14 b */
    { 0x344d92, 0x344507, 0x5c32bddf, 0x0000170c, 0, 50 }, /* #15 */
    { 0x0b3247, 0x0b3207, 0x5c32bddf, 0x0000170c, 0, 50 }, /* #15 b */
    { 0x395852, 0x395006, 0x7d370d58, 0x1f4dc356, 0, 34 }, /* #16 */
    { 0x062787, 0x062706, 0x7d370d58, 0x1f4dc356, 0, 34 }, /* #16 b */
    { 0x3458c2, 0x345806, 0xd669787d, 0x00000003, 0, 126 }, /* #17 */
    { 0x0b2717, 0x0b2f06, 0xd669787d, 0x00000003, 0, 126 }, /* #17 b */
    { 0x2c4c86, 0x2c4406, 0x42c52653, 0x0858a4ca, 0, 35 }, /* #18 */
    { 0x133353, 0x133306, 0x42c52653, 0x0858a4ca, 0, 35 }, /* #18 b */
    { 0x1165c7, 0x116d02, 0xe02fb935, 0x0000001c, 0, 123 }, /* #19 */
    { 0x2e1a12, 0x2e1a02, 0xe02fb935, 0x0000001c, 0, 123 }, /* #19 b */
    { 0x2c0716, 0x2c0707, 0x6e9fcd95, 0x00000006, 0, 92 }, /* #20 */
    { 0x1378c3, 0x137007, 0x6e9fcd95, 0x00000006, 0, 92 }, /* #20 b */
    { 0x0b1e46, 0x0b1602, 0x0895072b, 0x00000001, 0, 27 }, /* #21 */
    { 0x346193, 0x346102, 0x0895072b, 0x00000001, 0, 27 }, /* #21 b */
    { 0x2f45c7, 0x2f45c7, 0x038dcc95, 0x038dcc95, 0, 0  }, /* #22 */
    { 0x103a12, 0x103a12, 0x038dcc95, 0x038dcc95, 0, 0  }, /* #22 b */
    { 0x257197, 0x257103, 0x2aeea752, 0x0000002a, 0, 88 }, /* #23 */
    { 0x1a0e42, 0x1a0603, 0x2aeea752, 0x0000002a, 0, 88 }, /* #23 b */
    { 0x0d3093, 0x0d3802, 0xb6701a6a, 0x05b380d3, 0, 5  }, /* #24 */
    { 0x324f46, 0x324f02, 0xb6701a6a, 0x05b380d3, 0, 5  }, /* #24 b */
    { 0x1a3113, 0x1a3902, 0xccddfaaf, 0x00666efd, 0, 9  }, /* #25 */
    { 0x254ec6, 0x254e02, 0xccddfaaf, 0x00666efd, 0, 9  }, /* #25 b */
    { 0x162703, 0x162f06, 0xee30c6ae, 0x0003b8c3, 0, 46 }, /* #26 */
    { 0x2958d6, 0x295806, 0xee30c6ae, 0x0003b8c3, 0, 46 }, /* #26 b */
    { 0x291e56, 0x291606, 0x6a3a9bbb, 0x0000006a, 0, 120 }, /* #27 */
    { 0x166183, 0x166106, 0x6a3a9bbb, 0x0000006a, 0, 120 }, /* #27 b */
    { 0x153fd2, 0x153f03, 0xda2f090f, 0x00000da2, 0, 52 }, /* #28 */
    { 0x2a4007, 0x2a4803, 0xda2f090f, 0x00000da2, 0, 52 }, /* #28 b */
    { 0x311607, 0x311e02, 0xdc2610d2, 0x0000dc26, 0, 112 }, /* #29 */
    { 0x0e69d2, 0x0e6902, 0xdc2610d2, 0x0000dc26, 0, 112 }, /* #29 b */
    { 0x207192, 0x207107, 0x0edb4c7d, 0x0000001d, 0, 87 }, /* #30 */
    { 0x1f0e47, 0x1f0607, 0x0edb4c7d, 0x0000001d, 0, 87 }, /* #30 b */
    { 0x225ed3, 0x225e02, 0x84644bd6, 0x00000001, 0, 127 }, /* #31 */
    { 0x1d2106, 0x1d2902, 0x84644bd6, 0x00000001, 0, 127 }, /* #31 b */
    { 0x106952, 0x106902, 0xb0ebf20f, 0x02c3afc8, 0, 70 }, /* #32 */
    { 0x2f1687, 0x2f1e02, 0xb0ebf20f, 0x02c3afc8, 0, 70 }, /* #32 b */
    { 0x243b53, 0x243b06, 0xe0657e89, 0x00000703, 0, 85 }, /* #33 */
    { 0x1b4486, 0x1b4c06, 0xe0657e89, 0x00000703, 0, 85 }, /* #33 b */
    { 0x0c4993, 0x0c4106, 0x33443a57, 0x00000033, 0, 56 }, /* #34 */
    { 0x333646, 0x333606, 0x33443a57, 0x00000033, 0, 56 }, /* #34 b */
    { 0x1801d3, 0x180907, 0xac4b88c2, 0x0000000a, 0, 124 }, /* #35 */
    { 0x277e06, 0x277e07, 0xac4b88c2, 0x0000000a, 0, 124 }, /* #35 b */
    { 0x195ed3, 0x195e03, 0xff6ee1e8, 0x000001fe, 0, 55 }, /* #36 */
    { 0x262106, 0x262903, 0xff6ee1e8, 0x000001fe, 0, 55 }, /* #36 b */
    { 0x1309c3, 0x130107, 0x1b5e1ff7, 0x00036bc3, 0, 75 }, /* #37 */
    { 0x2c7616, 0x2c7607, 0x1b5e1ff7, 0x00036bc3, 0, 75 }, /* #37 b */
    { 0x0e4316, 0x0e4307, 0x1fa48dc6, 0x0000000f, 0, 89 }, /* #38 */
    { 0x313cc3, 0x313407, 0x1fa48dc6, 0x0000000f, 0, 89 }, /* #38 b */
    { 0x3f6442, 0x3f6402, 0x74492118, 0x0000e892, 0, 47 }, /* #39 */
    { 0x001b97, 0x001302, 0x74492118, 0x0000e892, 0, 47 }, /* #39 b */
    { 0x030dd3, 0x030547, 0x08edbe91, 0x00000000, 0, 60 }, /* #40 */
    { 0x3c7206, 0x3c7247, 0x08edbe91, 0x00000000, 0, 60 }, /* #40 b */
    { 0x134d42, 0x134503, 0x1d573616, 0x0755cd85, 0, 98 }, /* #41 */
    { 0x2c3297, 0x2c3203, 0x1d573616, 0x0755cd85, 0, 98 }, /* #41 b */
    { 0x3c4007, 0x3c4803, 0x82bcb80c, 0x00000415, 0, 21 }, /* #42 */
    { 0x033fd2, 0x033f03, 0x82bcb80c, 0x00000415, 0, 21 }, /* #42 b */
    { 0x0e3857, 0x0e3806, 0xf218400a, 0x790c2005, 0, 97 }, /* #43 */
    { 0x314782, 0x314f06, 0xf218400a, 0x790c2005, 0, 97 }, /* #43 b */
    { 0x146442, 0x146c07, 0xc0395de4, 0x00000300, 0, 86 }, /* #44 */
    { 0x2b1b97, 0x2b1b07, 0xc0395de4, 0x00000300, 0, 86 }, /* #44 b */
    { 0x143886, 0x143002, 0x42e2c490, 0x00021716, 0, 109 }, /* #45 */
    { 0x2b4753, 0x2b4702, 0x42e2c490, 0x00021716, 0, 109 }, /* #45 b */
    { 0x3e6656, 0x3e6e06, 0xf5c3111c, 0x0003d70c, 0, 46 }, /* #46 */
    { 0x011983, 0x011906, 0xf5c3111c, 0x0003d70c, 0, 46 }, /* #46 b */
    { 0x171716, 0x171747, 0x42acee6a, 0x00000000, 0, 31 }, /* #47 */
    { 0x2868c3, 0x286047, 0x42acee6a, 0x00000000, 0, 31 }, /* #47 b */
    { 0x113d56, 0x113d03, 0x9bbfae7b, 0x026efeb9, 0, 102 }, /* #48 */
    { 0x2e4283, 0x2e4a03, 0x9bbfae7b, 0x026efeb9, 0, 102 }, /* #48 b */
    { 0x291b47, 0x291b47, 0x9f732aab, 0x9f732aab, 0, 96 }, /* #49 */
    { 0x166492, 0x166492, 0x9f732aab, 0x9f732aab, 0, 96 }, /* #49 b */
    { 0x3312c2, 0x331203, 0x5b382d9d, 0x002d9c16, 0, 41 }, /* #50 */
    { 0x0c6d17, 0x0c6503, 0x5b382d9d, 0x002d9c16, 0, 41 }, /* #50 b */
    { 0x326b53, 0x326b03, 0xbdfc737a, 0x0002f7f1, 0, 46 }, /* #51 */
    { 0x0d1486, 0x0d1c03, 0xbdfc737a, 0x0002f7f1, 0, 46 }, /* #51 b */
    { 0x2755c2, 0x275502, 0x6fb92c93, 0x00000df7, 0, 115 }, /* #52 */
    { 0x182a17, 0x182202, 0x6fb92c93, 0x00000df7, 0, 115 }, /* #52 b */
    { 0x0c6c17, 0x0c6403, 0x44c730b7, 0x0898e616, 0, 67 }, /* #53 */
    { 0x3313c2, 0x331303, 0x44c730b7, 0x0898e616, 0, 67 }, /* #53 b */
    { 0x3e45c7, 0x3e4503, 0x7f965f90, 0x0000001f, 0, 90 }, /* #54 */
    { 0x013a12, 0x013203, 0x7f965f90, 0x0000001f, 0, 90 }, /* #54 b */
    { 0x0b7812, 0x0b7003, 0x165f833d, 0x02cbf067, 0, 3  }, /* #55 */
    { 0x3407c7, 0x340703, 0x165f833d, 0x02cbf067, 0, 3  }, /* #55 b */
    { 0x2058d3, 0x205046, 0x16f91aa6, 0x00000000, 0, 62 }, /* #56 */
    { 0x1f2706, 0x1f2746, 0x16f91aa6, 0x00000000, 0, 62 }, /* #56 b */
    { 0x3649d6, 0x364907, 0xdb95cda0, 0x00000006, 0, 29 }, /* #57 */
    { 0x093603, 0x093e07, 0xdb95cda0, 0x00000006, 0, 29 }, /* #57 b */
    { 0x295717, 0x295702, 0x1005b452, 0x00000004, 0, 26 }, /* #58 */
    { 0x1628c2, 0x162002, 0x1005b452, 0x00000004, 0, 26 }, /* #58 b */
    { 0x2d3dc6, 0x2d3d03, 0xbdc18094, 0x00005ee0, 0, 113 }, /* #59 */
    { 0x124213, 0x124a03, 0xbdc18094, 0x00005ee0, 0, 113 }, /* #59 b */
    { 0x325dc6, 0x325507, 0x7d4726d0, 0x0000000f, 0, 27 }, /* #60 */
    { 0x0d2213, 0x0d2207, 0x7d4726d0, 0x0000000f, 0, 27 }, /* #60 b */
    { 0x282956, 0x282903, 0xfea9cb6b, 0x000000fe, 0, 56 }, /* #61 */
    { 0x175683, 0x175e03, 0xfea9cb6b, 0x000000fe, 0, 56 }, /* #61 b */
    { 0x295113, 0x295103, 0x3bf5643b, 0x03bf5643, 0, 4  }, /* #62 */
    { 0x162ec6, 0x162603, 0x3bf5643b, 0x03bf5643, 0, 4  }, /* #62 b */
    { 0x306042, 0x306002, 0x4e3168e9, 0x00000002, 0, 61 }, /* #63 */
    { 0x0f1f97, 0x0f1702, 0x4e3168e9, 0x00000002, 0, 61 }, /* #63 b */
    { 0x1855c2, 0x185d06, 0xe3791dcd, 0x071bc8ee, 0, 101 }, /* #64 */
    { 0x272a17, 0x272a06, 0xe3791dcd, 0x071bc8ee, 0, 101 }, /* #64 b */
    { 0x012c52, 0x012c52, 0xb6706226, 0xb6706226, 0, 64 }, /* #65 */
    { 0x3e5387, 0x3e5387, 0xb6706226, 0xb6706226, 0, 64 }, /* #65 b */
    { 0x026056, 0x026803, 0xe6007d53, 0x39801f54, 0, 98 }, /* #66 */
    { 0x3d1f83, 0x3d1f03, 0xe6007d53, 0x39801f54, 0, 98 }, /* #66 b */
    { 0x284447, 0x284c03, 0x93768872, 0x24dda21c, 0, 98 }, /* #67 */
    { 0x173b92, 0x173b03, 0x93768872, 0x24dda21c, 0, 98 }, /* #67 b */
    { 0x083b83, 0x083b02, 0xae6f8d55, 0x000000ae, 0, 120 }, /* #68 */
    { 0x374456, 0x374c02, 0xae6f8d55, 0x000000ae, 0, 120 }, /* #68 b */
    { 0x2d1ec6, 0x2d1607, 0x6867ad5b, 0x03433d6a, 0, 101 }, /* #69 */
    { 0x126113, 0x126107, 0x6867ad5b, 0x03433d6a, 0, 101 }, /* #69 b */
    { 0x044f86, 0x044f07, 0xf66a8880, 0x00000003, 0, 126 }, /* #70 */
    { 0x3b3053, 0x3b3807, 0xf66a8880, 0x00000003, 0, 126 }, /* #70 b */
    { 0x1a5e86, 0x1a5603, 0x0735e45d, 0x00000001, 0, 58 }, /* #71 */
    { 0x252153, 0x252103, 0x0735e45d, 0x00000001, 0, 58 }, /* #71 b */
    { 0x223a47, 0x223203, 0x4b3d692a, 0x0000012c, 0, 54 }, /* #72 */
    { 0x1d4592, 0x1d4503, 0x4b3d692a, 0x0000012c, 0, 54 }, /* #72 b */
    { 0x3f0297, 0x3f0a07, 0xeccb7439, 0x00007665, 0, 49 }, /* #73 */
    { 0x007d42, 0x007d07, 0xeccb7439, 0x00007665, 0, 49 }, /* #73 b */
    { 0x396606, 0x396e02, 0xbc6b6d0d, 0x000005e3, 0, 117 }, /* #74 */
    { 0x0619d3, 0x061902, 0xbc6b6d0d, 0x000005e3, 0, 117 }, /* #74 b */
    { 0x157f03, 0x157f07, 0xcb43ffed, 0x00000065, 0, 25 }, /* #75 */
    { 0x2a00d6, 0x2a0807, 0xcb43ffed, 0x00000065, 0, 25 }, /* #75 b */
    { 0x186583, 0x186d06, 0xc1e25465, 0x0000c1e2, 0, 48 }, /* #76 */
    { 0x271a56, 0x271a06, 0xc1e25465, 0x0000c1e2, 0, 48 }, /* #76 b */
    { 0x3d1816, 0x3d1807, 0xef8bc875, 0x0001df17, 0, 15 }, /* #77 */
    { 0x0267c3, 0x026f07, 0xef8bc875, 0x0001df17, 0, 15 }, /* #77 b */
    { 0x380512, 0x380503, 0x10711d4c, 0x00020e23, 0, 107 }, /* #78 */
    { 0x077ac7, 0x077203, 0x10711d4c, 0x00020e23, 0, 107 }, /* #78 b */
    { 0x246043, 0x246002, 0x48ced59c, 0x00000246, 0, 85 }, /* #79 */
    { 0x1b1f96, 0x1b1702, 0x48ced59c, 0x00000246, 0, 85 }, /* #79 b */
    { 0x0e65c2, 0x0e6d03, 0xc487be8c, 0x0006243d, 0, 45 }, /* #80 */
    { 0x311a17, 0x311a03, 0xc487be8c, 0x0006243d, 0, 45 }, /* #80 b */
    { 0x0a1d53, 0x0a1507, 0x32ff963d, 0x197fcb1e, 0, 97 }, /* #81 */
    { 0x356286, 0x356207, 0x32ff963d, 0x197fcb1e, 0, 97 }, /* #81 b */
    { 0x0534d6, 0x053c06, 0xf3f34141, 0x03cfcd05, 0, 70 }, /* #82 */
    { 0x3a4b03, 0x3a4b06, 0xf3f34141, 0x03cfcd05, 0, 70 }, /* #82 b */
    { 0x3159c7, 0x315107, 0x0c600d4d, 0x063006a6, 0, 97 }, /* #83 */
    { 0x0e2612, 0x0e2607, 0x0c600d4d, 0x063006a6, 0, 97 }, /* #83 b */
    { 0x2e0bd2, 0x2e0303, 0x0ba28e9f, 0x00000002, 0, 58 }, /* #84 */
    { 0x117407, 0x117403, 0x0ba28e9f, 0x00000002, 0, 58 }, /* #84 b */
    { 0x1f3347, 0x1f3b03, 0xb5ef3f7e, 0x02d7bcfd, 0, 70 }, /* #85 */
    { 0x204c92, 0x204c03, 0xb5ef3f7e, 0x02d7bcfd, 0, 70 }, /* #85 b */
    { 0x1e3f12, 0x1e3f07, 0x97c63eca, 0x0000004b, 0, 57 }, /* #86 */
    { 0x2140c7, 0x214807, 0x97c63eca, 0x0000004b, 0, 57 }, /* #86 b */
    { 0x061916, 0x061146, 0x012ac158, 0x00000000, 0, 59 }, /* #87 */
    { 0x3966c3, 0x396646, 0x012ac158, 0x00000000, 0, 59 }, /* #87 b */
    { 0x183757, 0x183706, 0x72d84ac4, 0x072d84ac, 0, 36 }, /* #88 */
    { 0x274882, 0x274006, 0x72d84ac4, 0x072d84ac, 0, 36 }, /* #88 b */
    { 0x2e3652, 0x2e3e06, 0xc042fdd9, 0x00000003, 0, 30 }, /* #89 */
    { 0x114987, 0x114906, 0xc042fdd9, 0x00000003, 0, 30 }, /* #89 b */
    { 0x290c17, 0x290407, 0x73396a64, 0x01cce5a9, 0, 38 }, /* #90 */
    { 0x1673c2, 0x167307, 0x73396a64, 0x01cce5a9, 0, 38 }, /* #90 b */
    { 0x193347, 0x193306, 0x65a164f2, 0x0000032d, 0, 53 }, /* #91 */
    { 0x264c92, 0x264406, 0x65a164f2, 0x0000032d, 0, 53 }, /* #91 b */
    { 0x1776d6, 0x177602, 0x5a52cead, 0x00000001, 0, 126 }, /* #92 */
    { 0x280903, 0x280102, 0x5a52cead, 0x00000001, 0, 126 }, /* #92 b */
    { 0x367383, 0x367b06, 0xeb1bebe0, 0x758df5f0, 0, 65 }, /* #93 */
    { 0x090c56, 0x090c06, 0xeb1bebe0, 0x758df5f0, 0, 65 }, /* #93 b */
    { 0x0c0342, 0x0c0b03, 0xd2bec3f2, 0x00695f61, 0, 41 }, /* #94 */
    { 0x337c97, 0x337c03, 0xd2bec3f2, 0x00695f61, 0, 41 }, /* #94 b */
    { 0x377f12, 0x377703, 0x270aa15c, 0x000009c2, 0, 18 }, /* #95 */
    { 0x0800c7, 0x080003, 0x270aa15c, 0x000009c2, 0, 18 }, /* #95 b */
};
uint32_t const g_cTests_shr_u32_intel = RT_ELEMENTS(g_aTests_shr_u32_intel);

BINU32_TEST_T const g_aTests_sar_u32_intel[] =
{
    { 0x072fd7, 0x072746, 0x00000000, 0x00000000, 0, 19 }, /* #0 */
    { 0x385002, 0x385046, 0x00000000, 0x00000000, 0, 19 }, /* #0 b */
    { 0x280917, 0x280146, 0x00000000, 0x00000000, 0, 35 }, /* #1 */
    { 0x1776c2, 0x177646, 0x00000000, 0x00000000, 0, 35 }, /* #1 b */
    { 0x0a79c6, 0x0a7146, 0x00000000, 0x00000000, 0, 91 }, /* #2 */
    { 0x350613, 0x350646, 0x00000000, 0x00000000, 0, 91 }, /* #2 b */
    { 0x130b47, 0x130346, 0x00000000, 0x00000000, 0, 40 }, /* #3 */
    { 0x2c7492, 0x2c7446, 0x00000000, 0x00000000, 0, 40 }, /* #3 b */
    { 0x184c86, 0x184446, 0x00000000, 0x00000000, 0, 122 }, /* #4 */
    { 0x273353, 0x273346, 0x00000000, 0x00000000, 0, 122 }, /* #4 b */
    { 0x300fd3, 0x300746, 0x00000000, 0x00000000, 0, 127 }, /* #5 */
    { 0x0f7006, 0x0f7046, 0x00000000, 0x00000000, 0, 127 }, /* #5 b */
    { 0x2b3d06, 0x2b3583, 0xabd9c65d, 0xffffffea, 0, 26 }, /* #6 */
    { 0x1442d3, 0x144283, 0xabd9c65d, 0xffffffea, 0, 26 }, /* #6 b */
    { 0x381806, 0x381806, 0x7b9c42a9, 0x7b9c42a9, 0, 0  }, /* #7 */
    { 0x0767d3, 0x0767d3, 0x7b9c42a9, 0x7b9c42a9, 0, 0  }, /* #7 b */
    { 0x0f2147, 0x0f2182, 0x90d11460, 0xfffffff2, 0, 59 }, /* #8 */
    { 0x305e92, 0x305682, 0x90d11460, 0xfffffff2, 0, 59 }, /* #8 b */
    { 0x305947, 0x305107, 0x1b95444a, 0x0000001b, 0, 120 }, /* #9 */
    { 0x0f2692, 0x0f2607, 0x1b95444a, 0x0000001b, 0, 120 }, /* #9 b */
    { 0x2f6942, 0x2f6183, 0x9097846f, 0xff212f08, 0, 39 }, /* #10 */
    { 0x101697, 0x101683, 0x9097846f, 0xff212f08, 0, 39 }, /* #10 b */
    { 0x392d17, 0x392587, 0xd65ac9d3, 0xfffffffa, 0, 123 }, /* #11 */
    { 0x0652c2, 0x065287, 0xd65ac9d3, 0xfffffffa, 0, 123 }, /* #11 b */
    { 0x3810c3, 0x381082, 0xf244358a, 0xfffffffe, 0, 91 }, /* #12 */
    { 0x076f16, 0x076782, 0xf244358a, 0xfffffffe, 0, 91 }, /* #12 b */
    { 0x382013, 0x382086, 0xcf87dfb7, 0xffffff9f, 0, 23 }, /* #13 */
    { 0x075fc6, 0x075786, 0xcf87dfb7, 0xffffff9f, 0, 23 }, /* #13 b */
    { 0x021083, 0x021007, 0x4fcc311e, 0x00013f30, 0, 14 }, /* #14 */
    { 0x3d6f56, 0x3d6707, 0x4fcc311e, 0x00013f30, 0, 14 }, /* #14 b */
    { 0x384142, 0x384147, 0x30320208, 0x00000000, 0, 62 }, /* #15 */
    { 0x073e97, 0x073647, 0x30320208, 0x00000000, 0, 62 }, /* #15 b */
    { 0x3e4313, 0x3e4302, 0x3941f7af, 0x000000e5, 0, 86 }, /* #16 */
    { 0x013cc6, 0x013402, 0x3941f7af, 0x000000e5, 0, 86 }, /* #16 b */
    { 0x275d87, 0x275587, 0xf8adf091, 0xffffffe2, 0, 86 }, /* #17 */
    { 0x182252, 0x182287, 0xf8adf091, 0xffffffe2, 0, 86 }, /* #17 b */
    { 0x224dc6, 0x224506, 0x551a8c95, 0x001546a3, 0, 42 }, /* #18 */
    { 0x1d3213, 0x1d3206, 0x551a8c95, 0x001546a3, 0, 42 }, /* #18 b */
    { 0x0b5342, 0x0b5306, 0x3ab14667, 0x0000001d, 0, 57 }, /* #19 */
    { 0x342c97, 0x342406, 0x3ab14667, 0x0000001d, 0, 57 }, /* #19 b */
    { 0x323306, 0x323303, 0x797e3025, 0x000001e5, 0, 86 }, /* #20 */
    { 0x0d4cd3, 0x0d4403, 0x797e3025, 0x000001e5, 0, 86 }, /* #20 b */
    { 0x362942, 0x362103, 0x7e38152f, 0x000fc702, 0, 11 }, /* #21 */
    { 0x095697, 0x095603, 0x7e38152f, 0x000fc702, 0, 11 }, /* #21 b */
    { 0x0231c2, 0x023106, 0x6da1331c, 0x01b684cc, 0, 102 }, /* #22 */
    { 0x3d4e17, 0x3d4606, 0x6da1331c, 0x01b684cc, 0, 102 }, /* #22 b */
    { 0x072dd6, 0x072506, 0x28b49875, 0x00005169, 0, 47 }, /* #23 */
    { 0x385203, 0x385206, 0x28b49875, 0x00005169, 0, 47 }, /* #23 b */
    { 0x046ad7, 0x046202, 0x2cd8b488, 0x059b1691, 0, 99 }, /* #24 */
    { 0x3b1502, 0x3b1502, 0x2cd8b488, 0x059b1691, 0, 99 }, /* #24 b */
    { 0x041a93, 0x041206, 0x04afe507, 0x00095fca, 0, 103 }, /* #25 */
    { 0x3b6546, 0x3b6506, 0x04afe507, 0x00095fca, 0, 103 }, /* #25 b */
    { 0x1866d2, 0x186682, 0xb4b16b23, 0xffb4b16b, 0, 8  }, /* #26 */
    { 0x271907, 0x271182, 0xb4b16b23, 0xffb4b16b, 0, 8  }, /* #26 b */
    { 0x3545c2, 0x354583, 0xd5dbd39d, 0xfffff576, 0, 114 }, /* #27 */
    { 0x0a3a17, 0x0a3283, 0xd5dbd39d, 0xfffff576, 0, 114 }, /* #27 b */
    { 0x3e5286, 0x3e5286, 0x8d5a370e, 0xfffffffc, 0, 61 }, /* #28 */
    { 0x012d53, 0x012586, 0x8d5a370e, 0xfffffffc, 0, 61 }, /* #28 b */
    { 0x300483, 0x300402, 0x68acf198, 0x00000034, 0, 25 }, /* #29 */
    { 0x0f7b56, 0x0f7302, 0x68acf198, 0x00000034, 0, 25 }, /* #29 b */
    { 0x097002, 0x097006, 0x66faf0ac, 0x00066faf, 0, 108 }, /* #30 */
    { 0x360fd7, 0x360706, 0x66faf0ac, 0x00066faf, 0, 108 }, /* #30 b */
    { 0x0e54c6, 0x0e5402, 0x434780a9, 0x00000043, 0, 88 }, /* #31 */
    { 0x312b13, 0x312302, 0x434780a9, 0x00000043, 0, 88 }, /* #31 b */
    { 0x2f5d92, 0x2f5586, 0xcd47817e, 0xfffffff3, 0, 26 }, /* #32 */
    { 0x102247, 0x102286, 0xcd47817e, 0xfffffff3, 0, 26 }, /* #32 b */
    { 0x0e2f57, 0x0e2703, 0x5f13d6a4, 0x0000000b, 0, 123 }, /* #33 */
    { 0x315082, 0x315003, 0x5f13d6a4, 0x0000000b, 0, 123 }, /* #33 b */
    { 0x264e07, 0x264683, 0x929faaed, 0xfffff929, 0, 84 }, /* #34 */
    { 0x1931d2, 0x193183, 0x929faaed, 0xfffff929, 0, 84 }, /* #34 b */
    { 0x096747, 0x096747, 0xc709d430, 0xc709d430, 0, 64 }, /* #35 */
    { 0x361892, 0x361892, 0xc709d430, 0xc709d430, 0, 64 }, /* #35 b */
    { 0x1e1686, 0x1e1687, 0xd3a27085, 0xfffff4e8, 0, 82 }, /* #36 */
    { 0x216953, 0x216187, 0xd3a27085, 0xfffff4e8, 0, 82 }, /* #36 b */
    { 0x106fd2, 0x106783, 0xc7d56460, 0xfffffe3e, 0, 53 }, /* #37 */
    { 0x2f1007, 0x2f1083, 0xc7d56460, 0xfffffe3e, 0, 53 }, /* #37 b */
    { 0x1b0e87, 0x1b0683, 0xa33eac41, 0xfffff467, 0, 83 }, /* #38 */
    { 0x247152, 0x247183, 0xa33eac41, 0xfffff467, 0, 83 }, /* #38 b */
    { 0x194116, 0x194182, 0xa61f107e, 0xffa61f10, 0, 8  }, /* #39 */
    { 0x263ec3, 0x263682, 0xa61f107e, 0xffa61f10, 0, 8  }, /* #39 b */
    { 0x0f0fc2, 0x0f0fc2, 0x4e596dc1, 0x4e596dc1, 0, 0  }, /* #40 */
    { 0x307017, 0x307017, 0x4e596dc1, 0x4e596dc1, 0, 0  }, /* #40 b */
    { 0x181047, 0x181083, 0x86f1dbaf, 0xf86f1dba, 0, 100 }, /* #41 */
    { 0x276f92, 0x276783, 0x86f1dbaf, 0xf86f1dba, 0, 100 }, /* #41 b */
    { 0x2b7f57, 0x2b7786, 0xea3cb2dc, 0xfff51e59, 0, 41 }, /* #42 */
    { 0x140082, 0x140086, 0xea3cb2dc, 0xfff51e59, 0, 41 }, /* #42 b */
    { 0x0e6743, 0x0e6786, 0xa17ae82a, 0xfffffffa, 0, 60 }, /* #43 */
    { 0x311896, 0x311086, 0xa17ae82a, 0xfffffffa, 0, 60 }, /* #43 b */
    { 0x3f5796, 0x3f5786, 0xf3bad142, 0xffffffe7, 0, 119 }, /* #44 */
    { 0x002843, 0x002086, 0xf3bad142, 0xffffffe7, 0, 119 }, /* #44 b */
    { 0x203306, 0x203306, 0x66b12f83, 0x000066b1, 0, 48 }, /* #45 */
    { 0x1f4cd3, 0x1f4406, 0x66b12f83, 0x000066b1, 0, 48 }, /* #45 b */
    { 0x0d0107, 0x0d0183, 0x968fdba6, 0xfff968fd, 0, 12 }, /* #46 */
    { 0x327ed2, 0x327683, 0x968fdba6, 0xfff968fd, 0, 12 }, /* #46 b */
    { 0x3e32c2, 0x3e32c2, 0xdabe77db, 0xdabe77db, 0, 96 }, /* #47 */
    { 0x014d17, 0x014d17, 0xdabe77db, 0xdabe77db, 0, 96 }, /* #47 b */
    { 0x1d5cc2, 0x1d5403, 0x7400ab39, 0x001d002a, 0, 10 }, /* #48 */
    { 0x222317, 0x222303, 0x7400ab39, 0x001d002a, 0, 10 }, /* #48 b */
    { 0x006f92, 0x006707, 0x22361f57, 0x00088d87, 0, 10 }, /* #49 */
    { 0x3f1047, 0x3f1007, 0x22361f57, 0x00088d87, 0, 10 }, /* #49 b */
    { 0x3b0306, 0x3b0303, 0x7dda6efb, 0x000000fb, 0, 119 }, /* #50 */
    { 0x047cd3, 0x047403, 0x7dda6efb, 0x000000fb, 0, 119 }, /* #50 b */
    { 0x352113, 0x352183, 0xced86f27, 0xffff9db0, 0, 47 }, /* #51 */
    { 0x0a5ec6, 0x0a5683, 0xced86f27, 0xffff9db0, 0, 47 }, /* #51 b */
    { 0x320e43, 0x320682, 0xc4b05afe, 0xfffffffe, 0, 61 }, /* #52 */
    { 0x0d7196, 0x0d7182, 0xc4b05afe, 0xfffffffe, 0, 61 }, /* #52 b */
    { 0x267bd6, 0x267382, 0xe464b062, 0xfffff232, 0, 17 }, /* #53 */
    { 0x190403, 0x190482, 0xe464b062, 0xfffff232, 0, 17 }, /* #53 b */
    { 0x2d4213, 0x2d4286, 0xdfad9781, 0xfbf5b2f0, 0, 35 }, /* #54 */
    { 0x123dc6, 0x123586, 0xdfad9781, 0xfbf5b2f0, 0, 35 }, /* #54 b */
    { 0x147416, 0x147407, 0x0b935cb0, 0x002e4d72, 0, 70 }, /* #55 */
    { 0x2b0bc3, 0x2b0307, 0x0b935cb0, 0x002e4d72, 0, 70 }, /* #55 b */
    { 0x162cd3, 0x162407, 0x274d36c8, 0x0000004e, 0, 55 }, /* #56 */
    { 0x295306, 0x295307, 0x274d36c8, 0x0000004e, 0, 55 }, /* #56 b */
    { 0x071fc3, 0x071706, 0x2edfd486, 0x005dbfa9, 0, 39 }, /* #57 */
    { 0x386016, 0x386006, 0x2edfd486, 0x005dbfa9, 0, 39 }, /* #57 b */
    { 0x0a5306, 0x0a5347, 0x24789d1a, 0x00000000, 0, 62 }, /* #58 */
    { 0x352cd3, 0x352447, 0x24789d1a, 0x00000000, 0, 62 }, /* #58 b */
    { 0x2e2313, 0x2e2382, 0x904d3443, 0xfc8269a2, 0, 37 }, /* #59 */
    { 0x115cc6, 0x115482, 0x904d3443, 0xfc8269a2, 0, 37 }, /* #59 b */
    { 0x2e1386, 0x2e1383, 0xa3fb38ca, 0xffffd1fd, 0, 113 }, /* #60 */
    { 0x116c53, 0x116483, 0xa3fb38ca, 0xffffd1fd, 0, 113 }, /* #60 b */
    { 0x1e7687, 0x1e7606, 0x4c96987d, 0x00000099, 0, 23 }, /* #61 */
    { 0x210952, 0x210106, 0x4c96987d, 0x00000099, 0, 23 }, /* #61 b */
    { 0x350f42, 0x350706, 0x28123468, 0x00000014, 0, 25 }, /* #62 */
    { 0x0a7097, 0x0a7006, 0x28123468, 0x00000014, 0, 25 }, /* #62 b */
    { 0x1e4203, 0x1e4286, 0xea597c4c, 0xffffffa9, 0, 22 }, /* #63 */
    { 0x213dd6, 0x213586, 0xea597c4c, 0xffffffa9, 0, 22 }, /* #63 b */
    { 0x3b19c6, 0x3b1183, 0x87239c9a, 0xffffc391, 0, 81 }, /* #64 */
    { 0x046613, 0x046683, 0x87239c9a, 0xffffc391, 0, 81 }, /* #64 b */
    { 0x213e82, 0x213607, 0x78d7352b, 0x00000078, 0, 88 }, /* #65 */
    { 0x1e4157, 0x1e4107, 0x78d7352b, 0x00000078, 0, 88 }, /* #65 b */
    { 0x0e3482, 0x0e3487, 0xb19621bd, 0xfb19621b, 0, 100 }, /* #66 */
    { 0x314b57, 0x314387, 0xb19621bd, 0xfb19621b, 0, 100 }, /* #66 b */
    { 0x1d5f82, 0x1d5703, 0x3b1cbda1, 0x0000000e, 0, 90 }, /* #67 */
    { 0x222057, 0x222003, 0x3b1cbda1, 0x0000000e, 0, 90 }, /* #67 b */
    { 0x234847, 0x234086, 0xfa4ffbe6, 0xffffffd2, 0, 53 }, /* #68 */
    { 0x1c3792, 0x1c3786, 0xfa4ffbe6, 0xffffffd2, 0, 53 }, /* #68 b */
    { 0x2046c6, 0x204682, 0xfd0603f9, 0xffffffd0, 0, 52 }, /* #69 */
    { 0x1f3913, 0x1f3182, 0xfd0603f9, 0xffffffd0, 0, 52 }, /* #69 b */
    { 0x1c5556, 0x1c5587, 0xe73af860, 0xffffff9c, 0, 118 }, /* #70 */
    { 0x232a83, 0x232287, 0xe73af860, 0xffffff9c, 0, 118 }, /* #70 b */
    { 0x313706, 0x313783, 0x94b2effe, 0xfffffff2, 0, 59 }, /* #71 */
    { 0x0e48d3, 0x0e4083, 0x94b2effe, 0xfffffff2, 0, 59 }, /* #71 b */
    { 0x2b6296, 0x2b6202, 0x129d69e8, 0x0094eb4f, 0, 69 }, /* #72 */
    { 0x141d43, 0x141502, 0x129d69e8, 0x0094eb4f, 0, 69 }, /* #72 b */
    { 0x156c57, 0x156403, 0x2243079b, 0x00112183, 0, 73 }, /* #73 */
    { 0x2a1382, 0x2a1303, 0x2243079b, 0x00112183, 0, 73 }, /* #73 b */
    { 0x302043, 0x302082, 0xb3645e6e, 0xffb3645e, 0, 104 }, /* #74 */
    { 0x0f5f96, 0x0f5782, 0xb3645e6e, 0xffb3645e, 0, 104 }, /* #74 b */
    { 0x3c6187, 0x3c6107, 0x1b08c4e4, 0x0361189c, 0, 35 }, /* #75 */
    { 0x031e52, 0x031607, 0x1b08c4e4, 0x0361189c, 0, 35 }, /* #75 b */
    { 0x270842, 0x270087, 0x9c8d53a7, 0xfe72354e, 0, 38 }, /* #76 */
    { 0x187797, 0x187787, 0x9c8d53a7, 0xfe72354e, 0, 38 }, /* #76 b */
    { 0x367dc7, 0x367587, 0xf9cbf3e7, 0xfff397e7, 0, 7  }, /* #77 */
    { 0x090212, 0x090287, 0xf9cbf3e7, 0xfff397e7, 0, 7  }, /* #77 b */
    { 0x1843d2, 0x184303, 0x111ec057, 0x0000223d, 0, 111 }, /* #78 */
    { 0x273c07, 0x273403, 0x111ec057, 0x0000223d, 0, 111 }, /* #78 b */
    { 0x394492, 0x394402, 0x47f46af9, 0x000047f4, 0, 48 }, /* #79 */
    { 0x063b47, 0x063302, 0x47f46af9, 0x000047f4, 0, 48 }, /* #79 b */
    { 0x284507, 0x284503, 0x1c50edfc, 0x000038a1, 0, 47 }, /* #80 */
    { 0x173ad2, 0x173203, 0x1c50edfc, 0x000038a1, 0, 47 }, /* #80 b */
    { 0x160bc6, 0x160386, 0xd3add7bc, 0xfffffffa, 0, 91 }, /* #81 */
    { 0x297413, 0x297486, 0xd3add7bc, 0xfffffffa, 0, 91 }, /* #81 b */
    { 0x387e12, 0x387e12, 0x8d1ae736, 0x8d1ae736, 0, 96 }, /* #82 */
    { 0x0701c7, 0x0701c7, 0x8d1ae736, 0x8d1ae736, 0, 96 }, /* #82 b */
    { 0x2a4ed3, 0x2a4606, 0x080a3a08, 0x01014741, 0, 35 }, /* #83 */
    { 0x153106, 0x153106, 0x080a3a08, 0x01014741, 0, 35 }, /* #83 b */
    { 0x3768c2, 0x376083, 0xbcc088e9, 0xfffffffb, 0, 92 }, /* #84 */
    { 0x081717, 0x081783, 0xbcc088e9, 0xfffffffb, 0, 92 }, /* #84 b */
    { 0x375187, 0x375187, 0xf2df3d42, 0xfffff96f, 0, 49 }, /* #85 */
    { 0x082e52, 0x082687, 0xf2df3d42, 0xfffff96f, 0, 49 }, /* #85 b */
    { 0x297582, 0x297582, 0xae3ea17c, 0xfffae3ea, 0, 12 }, /* #86 */
    { 0x160a57, 0x160282, 0xae3ea17c, 0xfffae3ea, 0, 12 }, /* #86 b */
    { 0x3f0c87, 0x3f0487, 0xa88cb236, 0xfffffa88, 0, 52 }, /* #87 */
    { 0x007352, 0x007387, 0xa88cb236, 0xfffffa88, 0, 52 }, /* #87 b */
    { 0x2b3dd3, 0x2b3582, 0xf75565a2, 0xfffffdd5, 0, 18 }, /* #88 */
    { 0x144206, 0x144282, 0xf75565a2, 0xfffffdd5, 0, 18 }, /* #88 b */
    { 0x3c5493, 0x3c5482, 0xd5332d5a, 0xff54ccb5, 0, 70 }, /* #89 */
    { 0x032b46, 0x032382, 0xd5332d5a, 0xff54ccb5, 0, 70 }, /* #89 b */
    { 0x0e6557, 0x0e6503, 0x55d10161, 0x00000002, 0, 61 }, /* #90 */
    { 0x311a82, 0x311203, 0x55d10161, 0x00000002, 0, 61 }, /* #90 b */
    { 0x350716, 0x350707, 0x0a13d326, 0x0284f4c9, 0, 98 }, /* #91 */
    { 0x0a78c3, 0x0a7007, 0x0a13d326, 0x0284f4c9, 0, 98 }, /* #91 b */
    { 0x111112, 0x111112, 0x1a15b2e4, 0x1a15b2e4, 0, 64 }, /* #92 */
    { 0x2e6ec7, 0x2e6ec7, 0x1a15b2e4, 0x1a15b2e4, 0, 64 }, /* #92 b */
    { 0x267956, 0x267182, 0xa54e409c, 0xffd2a720, 0, 105 }, /* #93 */
    { 0x190683, 0x190682, 0xa54e409c, 0xffd2a720, 0, 105 }, /* #93 b */
    { 0x1a28c3, 0x1a2003, 0x43ff34f8, 0x0000087f, 0, 51 }, /* #94 */
    { 0x255716, 0x255703, 0x43ff34f8, 0x0000087f, 0, 51 }, /* #94 b */
    { 0x1e3957, 0x1e3102, 0x21901a4a, 0x00000004, 0, 59 }, /* #95 */
    { 0x214682, 0x214602, 0x21901a4a, 0x00000004, 0, 59 }, /* #95 b */
};
uint32_t const g_cTests_sar_u32_intel = RT_ELEMENTS(g_aTests_sar_u32_intel);

BINU64_TEST_T const g_aTests_rol_u64_intel[] =
{
    { 0x3f7b97, 0x3f7396, 0x0000000000000000, 0x0000000000000000, 0, 43 }, /* #0 */
    { 0x000442, 0x000442, 0x0000000000000000, 0x0000000000000000, 0, 43 }, /* #0 b */
    { 0x337cc3, 0x3374c2, 0x0000000000000000, 0x0000000000000000, 0, 185 }, /* #1 */
    { 0x0c0316, 0x0c0316, 0x0000000000000000, 0x0000000000000000, 0, 185 }, /* #1 b */
    { 0x3a68d7, 0x3a60d6, 0x0000000000000000, 0x0000000000000000, 0, 105 }, /* #2 */
    { 0x051702, 0x051702, 0x0000000000000000, 0x0000000000000000, 0, 105 }, /* #2 b */
    { 0x252957, 0x252156, 0x0000000000000000, 0x0000000000000000, 0, 156 }, /* #3 */
    { 0x1a5682, 0x1a5682, 0x0000000000000000, 0x0000000000000000, 0, 156 }, /* #3 b */
    { 0x192a97, 0x192296, 0x0000000000000000, 0x0000000000000000, 0, 222 }, /* #4 */
    { 0x265542, 0x265542, 0x0000000000000000, 0x0000000000000000, 0, 222 }, /* #4 b */
    { 0x365d02, 0x365502, 0x0000000000000000, 0x0000000000000000, 0, 241 }, /* #5 */
    { 0x0922d7, 0x0922d6, 0x0000000000000000, 0x0000000000000000, 0, 241 }, /* #5 b */
    { 0x0c7b97, 0x0c7b97, 0x4cca33a77e06701a, 0x94674efc0ce03499, 0, 201 }, /* #6 */
    { 0x330442, 0x330c43, 0x4cca33a77e06701a, 0x94674efc0ce03499, 0, 201 }, /* #6 b */
    { 0x0c12d7, 0x0c1ad7, 0x982d7319f23f166b, 0x7305ae633e47e2cd, 0, 253 }, /* #7 */
    { 0x336d02, 0x336d03, 0x982d7319f23f166b, 0x7305ae633e47e2cd, 0, 253 }, /* #7 b */
    { 0x1938c3, 0x1938c2, 0xb364797a35bd6ddf, 0xdbbf66c8f2f46b7a, 0, 241 }, /* #8 */
    { 0x264716, 0x264f16, 0xb364797a35bd6ddf, 0xdbbf66c8f2f46b7a, 0, 241 }, /* #8 b */
    { 0x007f47, 0x007f47, 0xbff5a8c329dbcac4, 0x6a30ca76f2b12ffd, 0, 142 }, /* #9 */
    { 0x3f0092, 0x3f0893, 0xbff5a8c329dbcac4, 0x6a30ca76f2b12ffd, 0, 142 }, /* #9 b */
    { 0x020412, 0x020412, 0xd64afaa65e2a421b, 0x8437ac95f54cbc54, 0, 177 }, /* #10 */
    { 0x3d7bc7, 0x3d73c6, 0xd64afaa65e2a421b, 0x8437ac95f54cbc54, 0, 177 }, /* #10 b */
    { 0x2f3e56, 0x2f3656, 0x31760db671ff178c, 0xce3fe2f1862ec1b6, 0, 221 }, /* #11 */
    { 0x104183, 0x104182, 0x31760db671ff178c, 0xce3fe2f1862ec1b6, 0, 221 }, /* #11 b */
    { 0x044e07, 0x044e07, 0x9cff83b3d70883df, 0x9ff0767ae1107bf3, 0, 5  }, /* #12 */
    { 0x3b31d2, 0x3b39d3, 0x9cff83b3d70883df, 0x9ff0767ae1107bf3, 0, 5  }, /* #12 b */
    { 0x193487, 0x193c86, 0x955e6abd5ce0b30b, 0xbcd57ab9c166172a, 0, 9  }, /* #13 */
    { 0x264b52, 0x264b52, 0x955e6abd5ce0b30b, 0xbcd57ab9c166172a, 0, 9  }, /* #13 b */
    { 0x224e12, 0x224612, 0x2a4d7de5f3fb4bf7, 0xbe7f697ee549afbc, 0, 93 }, /* #14 */
    { 0x1d31c7, 0x1d31c6, 0x2a4d7de5f3fb4bf7, 0xbe7f697ee549afbc, 0, 93 }, /* #14 b */
    { 0x327bd2, 0x327bd3, 0x9ae2b11d89d485ee, 0x217ba6b8ac476275, 0, 46 }, /* #15 */
    { 0x0d0407, 0x0d0c07, 0x9ae2b11d89d485ee, 0x217ba6b8ac476275, 0, 46 }, /* #15 b */
    { 0x010ac7, 0x0102c7, 0x026422552e8c2c03, 0x74616018132112a9, 0, 99 }, /* #16 */
    { 0x3e7512, 0x3e7513, 0x026422552e8c2c03, 0x74616018132112a9, 0, 99 }, /* #16 b */
    { 0x2b3bd2, 0x2b33d2, 0xdb3085ec286b4282, 0xb6cc217b0a1ad0a0, 0, 190 }, /* #17 */
    { 0x144407, 0x144406, 0xdb3085ec286b4282, 0xb6cc217b0a1ad0a0, 0, 190 }, /* #17 b */
    { 0x3b4047, 0x3b4047, 0xccb8be11692e4dcd, 0xccb8be11692e4dcd, 0, 128 }, /* #18 */
    { 0x043f92, 0x043f92, 0xccb8be11692e4dcd, 0xccb8be11692e4dcd, 0, 128 }, /* #18 b */
    { 0x2067c2, 0x206fc3, 0x48ee62d60e77f547, 0x839dfd51d23b98b5, 0, 222 }, /* #19 */
    { 0x1f1817, 0x1f1817, 0x48ee62d60e77f547, 0x839dfd51d23b98b5, 0, 222 }, /* #19 b */
    { 0x3c6747, 0x3c6746, 0x12b832d118ccbd71, 0x0cb446332f5c44ae, 0, 206 }, /* #20 */
    { 0x031892, 0x031092, 0x12b832d118ccbd71, 0x0cb446332f5c44ae, 0, 206 }, /* #20 b */
    { 0x046c97, 0x046c97, 0xacb078131322b25d, 0x6b2c1e04c4c8ac97, 0, 126 }, /* #21 */
    { 0x3b1342, 0x3b1b43, 0xacb078131322b25d, 0x6b2c1e04c4c8ac97, 0, 126 }, /* #21 b */
    { 0x3b5d02, 0x3b5502, 0x114e9984929f8f49, 0xa7e3d24453a66124, 0, 102 }, /* #22 */
    { 0x0422d7, 0x0422d6, 0x114e9984929f8f49, 0xa7e3d24453a66124, 0, 102 }, /* #22 b */
    { 0x1e1ad2, 0x1e1ad3, 0x9cc17d87c0c18608, 0x13982fb0f81830c1, 0, 125 }, /* #23 */
    { 0x216507, 0x216d07, 0x9cc17d87c0c18608, 0x13982fb0f81830c1, 0, 125 }, /* #23 b */
    { 0x055997, 0x055197, 0x2f274e631ef76fd3, 0x318f7bb7e99793a7, 0, 87 }, /* #24 */
    { 0x3a2642, 0x3a2643, 0x2f274e631ef76fd3, 0x318f7bb7e99793a7, 0, 87 }, /* #24 b */
    { 0x344a47, 0x344246, 0xcdc5bd0ce785370e, 0xecdc5bd0ce785370, 0, 252 }, /* #25 */
    { 0x0b3592, 0x0b3592, 0xcdc5bd0ce785370e, 0xecdc5bd0ce785370, 0, 252 }, /* #25 b */
    { 0x0033d2, 0x0033d3, 0xf71ea47ba1a6e862, 0x4317b8f523dd0d37, 0, 179 }, /* #26 */
    { 0x3f4c07, 0x3f4407, 0xf71ea47ba1a6e862, 0x4317b8f523dd0d37, 0, 179 }, /* #26 b */
    { 0x114116, 0x114917, 0x507c6ecdce76303d, 0xd9b9cec607aa0f8d, 0, 213 }, /* #27 */
    { 0x2e3ec3, 0x2e3ec3, 0x507c6ecdce76303d, 0xd9b9cec607aa0f8d, 0, 213 }, /* #27 b */
    { 0x020b43, 0x020342, 0xdb0477564ee59a5d, 0xeeac9dcb34bbb608, 0, 145 }, /* #28 */
    { 0x3d7496, 0x3d7496, 0xdb0477564ee59a5d, 0xeeac9dcb34bbb608, 0, 145 }, /* #28 b */
    { 0x0c52c6, 0x0c52c7, 0x2605edcb0073093a, 0xdb9600e612744c0b, 0, 81 }, /* #29 */
    { 0x332d13, 0x332513, 0x2605edcb0073093a, 0xdb9600e612744c0b, 0, 81 }, /* #29 b */
    { 0x2a7986, 0x2a7986, 0x6981e173b003028d, 0x6051ad303c2e7600, 0, 173 }, /* #30 */
    { 0x150653, 0x150e52, 0x6981e173b003028d, 0x6051ad303c2e7600, 0, 173 }, /* #30 b */
    { 0x1b1997, 0x1b1196, 0x186d51d98def9eb9, 0x461b5476637be7ae, 0, 254 }, /* #31 */
    { 0x246642, 0x246642, 0x186d51d98def9eb9, 0x461b5476637be7ae, 0, 254 }, /* #31 b */
    { 0x262453, 0x262453, 0xd42e44980a5f82b9, 0x80a5f82b9d42e449, 0, 156 }, /* #32 */
    { 0x195b86, 0x195387, 0xd42e44980a5f82b9, 0x80a5f82b9d42e449, 0, 156 }, /* #32 b */
    { 0x147e13, 0x147e12, 0x84ce538ba567a19a, 0x567a19a84ce538ba, 0, 100 }, /* #33 */
    { 0x2b01c6, 0x2b09c6, 0x84ce538ba567a19a, 0x567a19a84ce538ba, 0, 100 }, /* #33 b */
    { 0x1b1bc6, 0x1b13c7, 0x174074da474e4164, 0x4da474e416417407, 0, 148 }, /* #34 */
    { 0x246413, 0x246413, 0x174074da474e4164, 0x4da474e416417407, 0, 148 }, /* #34 b */
    { 0x116b57, 0x116357, 0x21ed7295629a995e, 0xdae52ac53532bc43, 0, 9  }, /* #35 */
    { 0x2e1482, 0x2e1483, 0x21ed7295629a995e, 0xdae52ac53532bc43, 0, 9  }, /* #35 b */
    { 0x390b97, 0x390b97, 0x4dc4c04e05fc8fdb, 0x3713013817f23f6d, 0, 66 }, /* #36 */
    { 0x067442, 0x067c43, 0x4dc4c04e05fc8fdb, 0x3713013817f23f6d, 0, 66 }, /* #36 b */
    { 0x1529d7, 0x1529d7, 0xbbbb28bad48214a9, 0x75a9042953777651, 0, 153 }, /* #37 */
    { 0x2a5602, 0x2a5e03, 0xbbbb28bad48214a9, 0x75a9042953777651, 0, 153 }, /* #37 b */
    { 0x077756, 0x077f57, 0x76304a8ae590b261, 0x15cb2164c2ec6095, 0, 153 }, /* #38 */
    { 0x380883, 0x380883, 0x76304a8ae590b261, 0x15cb2164c2ec6095, 0, 153 }, /* #38 b */
    { 0x365e96, 0x365e96, 0x530d766c04e04faf, 0x4faf530d766c04e0, 0, 240 }, /* #39 */
    { 0x092143, 0x092942, 0x530d766c04e04faf, 0x4faf530d766c04e0, 0, 240 }, /* #39 b */
    { 0x056913, 0x056913, 0x7bacdbefc239b57c, 0x36fbf08e6d5f1eeb, 0, 206 }, /* #40 */
    { 0x3a16c6, 0x3a1ec7, 0x7bacdbefc239b57c, 0x36fbf08e6d5f1eeb, 0, 206 }, /* #40 b */
    { 0x0f6917, 0x0f6916, 0x71b2b1b3770adc25, 0x3656366ee15b84ae, 0, 5  }, /* #41 */
    { 0x3016c2, 0x301ec2, 0x71b2b1b3770adc25, 0x3656366ee15b84ae, 0, 5  }, /* #41 b */
    { 0x262352, 0x262353, 0x0e832d087f68fe0a, 0x0fed1fc141d065a1, 0, 93 }, /* #42 */
    { 0x195c87, 0x195487, 0x0e832d087f68fe0a, 0x0fed1fc141d065a1, 0, 93 }, /* #42 b */
    { 0x381992, 0x381992, 0x48561aaae449a4ce, 0x99c90ac3555c8934, 0, 181 }, /* #43 */
    { 0x076647, 0x076e46, 0x48561aaae449a4ce, 0x99c90ac3555c8934, 0, 181 }, /* #43 b */
    { 0x372313, 0x372313, 0x08ee45d4f273e0d2, 0x047722ea7939f069, 0, 255 }, /* #44 */
    { 0x085cc6, 0x0854c7, 0x08ee45d4f273e0d2, 0x047722ea7939f069, 0, 255 }, /* #44 b */
    { 0x0e4317, 0x0e4316, 0x13482ad6e7995ddf, 0xb5b9e65777c4d20a, 0, 86 }, /* #45 */
    { 0x313cc2, 0x3134c2, 0x13482ad6e7995ddf, 0xb5b9e65777c4d20a, 0, 86 }, /* #45 b */
    { 0x330c43, 0x330442, 0xfd08336ed736c8d8, 0x6ddae6d91b1fa106, 0, 21 }, /* #46 */
    { 0x0c7396, 0x0c7396, 0xfd08336ed736c8d8, 0x6ddae6d91b1fa106, 0, 21 }, /* #46 b */
    { 0x120c83, 0x120482, 0x2a814af84a4c17d0, 0xa814af84a4c17d02, 0, 132 }, /* #47 */
    { 0x2d7356, 0x2d7356, 0x2a814af84a4c17d0, 0xa814af84a4c17d02, 0, 132 }, /* #47 b */
    { 0x2a1b43, 0x2a1b42, 0x6949c69a84a9ec92, 0xc926949c69a84a9e, 0, 244 }, /* #48 */
    { 0x156496, 0x156c96, 0x6949c69a84a9ec92, 0xc926949c69a84a9e, 0, 244 }, /* #48 b */
    { 0x1e52d3, 0x1e52d3, 0x197405376d3875fd, 0x197405376d3875fd, 0, 64 }, /* #49 */
    { 0x212d06, 0x212d06, 0x197405376d3875fd, 0x197405376d3875fd, 0, 64 }, /* #49 b */
    { 0x314606, 0x314e06, 0x9a62794d50c4034a, 0x86201a54d313ca6a, 0, 99 }, /* #50 */
    { 0x0e39d3, 0x0e39d2, 0x9a62794d50c4034a, 0x86201a54d313ca6a, 0, 99 }, /* #50 b */
    { 0x141116, 0x141917, 0x60c6625e7949d9e0, 0xe527678183198979, 0, 226 }, /* #51 */
    { 0x2b6ec3, 0x2b6ec3, 0x60c6625e7949d9e0, 0xe527678183198979, 0, 226 }, /* #51 b */
    { 0x186992, 0x186192, 0x39c64b162756e5e0, 0x738c962c4eadcbc0, 0, 193 }, /* #52 */
    { 0x271647, 0x271646, 0x39c64b162756e5e0, 0x738c962c4eadcbc0, 0, 193 }, /* #52 b */
    { 0x361746, 0x361f47, 0xaf1d1aabd8564fb9, 0x64fb9af1d1aabd85, 0, 236 }, /* #53 */
    { 0x096893, 0x096893, 0xaf1d1aabd8564fb9, 0x64fb9af1d1aabd85, 0, 236 }, /* #53 b */
    { 0x0e44c6, 0x0e4cc6, 0x501a67a1824ccb1f, 0x58fa80d33d0c1266, 0, 51 }, /* #54 */
    { 0x313b13, 0x313b12, 0x501a67a1824ccb1f, 0x58fa80d33d0c1266, 0, 51 }, /* #54 b */
    { 0x1e2b12, 0x1e2313, 0x1bc019dfce0fb3f3, 0xb3f31bc019dfce0f, 0, 176 }, /* #55 */
    { 0x2154c7, 0x2154c7, 0x1bc019dfce0fb3f3, 0xb3f31bc019dfce0f, 0, 176 }, /* #55 b */
    { 0x314e12, 0x314612, 0xe219131ed57402d5, 0x805abc432263daae, 0, 237 }, /* #56 */
    { 0x0e31c7, 0x0e31c6, 0xe219131ed57402d5, 0x805abc432263daae, 0, 237 }, /* #56 b */
    { 0x051856, 0x051057, 0xe9872c1168350f5e, 0x822d06a1ebdd30e5, 0, 213 }, /* #57 */
    { 0x3a6783, 0x3a6783, 0xe9872c1168350f5e, 0x822d06a1ebdd30e5, 0, 213 }, /* #57 b */
    { 0x3a2843, 0x3a2042, 0xff3f47627aa77d6d, 0xfd1d89ea9df5b7fc, 0, 10 }, /* #58 */
    { 0x055796, 0x055796, 0xff3f47627aa77d6d, 0xfd1d89ea9df5b7fc, 0, 10 }, /* #58 b */
    { 0x2f2497, 0x2f2c96, 0x66361299848947e4, 0x947e466361299848, 0, 172 }, /* #59 */
    { 0x105b42, 0x105b42, 0x66361299848947e4, 0x947e466361299848, 0, 172 }, /* #59 b */
    { 0x136e46, 0x136647, 0xf543ef8af4f3b8ef, 0x1dfea87df15e9e77, 0, 53 }, /* #60 */
    { 0x2c1193, 0x2c1193, 0xf543ef8af4f3b8ef, 0x1dfea87df15e9e77, 0, 53 }, /* #60 b */
    { 0x042253, 0x042253, 0x0c120c16740b1061, 0x9d02c41843048305, 0, 158 }, /* #61 */
    { 0x3b5d86, 0x3b5587, 0x0c120c16740b1061, 0x9d02c41843048305, 0, 158 }, /* #61 b */
    { 0x2502d6, 0x2502d7, 0x1726ae43c7e4dd4d, 0x5721e3f26ea68b93, 0, 143 }, /* #62 */
    { 0x1a7d03, 0x1a7503, 0x1726ae43c7e4dd4d, 0x5721e3f26ea68b93, 0, 143 }, /* #62 b */
    { 0x063bc3, 0x0633c2, 0x1fed25f549350a88, 0xa15103fda4bea926, 0, 173 }, /* #63 */
    { 0x394416, 0x394416, 0x1fed25f549350a88, 0xa15103fda4bea926, 0, 173 }, /* #63 b */
    { 0x007043, 0x007042, 0xccc2b2f0d14879d2, 0x96661597868a43ce, 0, 123 }, /* #64 */
    { 0x3f0f96, 0x3f0796, 0xccc2b2f0d14879d2, 0x96661597868a43ce, 0, 123 }, /* #64 b */
    { 0x3a7696, 0x3a7697, 0x22dd73fb6fadacad, 0xf6df5b595a45bae7, 0, 153 }, /* #65 */
    { 0x050943, 0x050143, 0x22dd73fb6fadacad, 0xf6df5b595a45bae7, 0, 153 }, /* #65 b */
    { 0x114ac2, 0x114ac3, 0x73423a454a59a6db, 0x34db6e684748a94b, 0, 173 }, /* #66 */
    { 0x2e3517, 0x2e3d17, 0x73423a454a59a6db, 0x34db6e684748a94b, 0, 173 }, /* #66 b */
    { 0x330197, 0x330196, 0x2d041c79fc88f7b2, 0x7f223dec8b41071e, 0, 30 }, /* #67 */
    { 0x0c7e42, 0x0c7642, 0x2d041c79fc88f7b2, 0x7f223dec8b41071e, 0, 30 }, /* #67 b */
    { 0x2b38d7, 0x2b38d6, 0x7429321a68658fd2, 0x69a1963f49d0a4c8, 0, 154 }, /* #68 */
    { 0x144702, 0x144f02, 0x7429321a68658fd2, 0x69a1963f49d0a4c8, 0, 154 }, /* #68 b */
    { 0x030846, 0x030847, 0xaa5936f1117379da, 0x4b26de222e6f3b55, 0, 133 }, /* #69 */
    { 0x3c7793, 0x3c7f93, 0xaa5936f1117379da, 0x4b26de222e6f3b55, 0, 133 }, /* #69 b */
    { 0x0b3087, 0x0b3887, 0xbb67f7ebbaece4eb, 0xaeebb393aeed9fdf, 0, 154 }, /* #70 */
    { 0x344f52, 0x344f53, 0xbb67f7ebbaece4eb, 0xaeebb393aeed9fdf, 0, 154 }, /* #70 b */
    { 0x3d7d13, 0x3d7512, 0x25e520d8f5676a0f, 0xb3b50792f2906c7a, 0, 103 }, /* #71 */
    { 0x0202c6, 0x0202c6, 0x25e520d8f5676a0f, 0xb3b50792f2906c7a, 0, 103 }, /* #71 b */
    { 0x165356, 0x165357, 0xed42ca2601886a41, 0x651300c43520f6a1, 0, 207 }, /* #72 */
    { 0x292c83, 0x292483, 0xed42ca2601886a41, 0x651300c43520f6a1, 0, 207 }, /* #72 b */
    { 0x076f52, 0x076f52, 0x45deb6a9f88fd3db, 0xda2ef5b54fc47e9e, 0, 59 }, /* #73 */
    { 0x381087, 0x381886, 0x45deb6a9f88fd3db, 0xda2ef5b54fc47e9e, 0, 59 }, /* #73 b */
    { 0x077283, 0x077282, 0xe35331caefc8699b, 0xd4cc72bbf21a66f8, 0, 134 }, /* #74 */
    { 0x380d56, 0x380556, 0xe35331caefc8699b, 0xd4cc72bbf21a66f8, 0, 134 }, /* #74 b */
    { 0x3704c2, 0x3704c2, 0x24cfddc7c7f6ff5c, 0x7eee3e3fb7fae126, 0, 203 }, /* #75 */
    { 0x087b17, 0x087316, 0x24cfddc7c7f6ff5c, 0x7eee3e3fb7fae126, 0, 203 }, /* #75 b */
    { 0x051746, 0x051746, 0x2a080e17835c3580, 0xd70d600a820385e0, 0, 230 }, /* #76 */
    { 0x3a6893, 0x3a6092, 0x2a080e17835c3580, 0xd70d600a820385e0, 0, 230 }, /* #76 b */
    { 0x034943, 0x034143, 0xe4f0b94ba2a7bc93, 0xd153de49f2785ca5, 0, 95 }, /* #77 */
    { 0x3c3696, 0x3c3697, 0xe4f0b94ba2a7bc93, 0xd153de49f2785ca5, 0, 95 }, /* #77 b */
    { 0x2b7fc6, 0x2b77c6, 0x1c3ba1ee85f7523e, 0x91f0e1dd0f742fba, 0, 115 }, /* #78 */
    { 0x140013, 0x140012, 0x1c3ba1ee85f7523e, 0x91f0e1dd0f742fba, 0, 115 }, /* #78 b */
    { 0x2209c2, 0x2201c2, 0x273ca430a1213593, 0x521850909ac9939e, 0, 207 }, /* #79 */
    { 0x1d7617, 0x1d7616, 0x273ca430a1213593, 0x521850909ac9939e, 0, 207 }, /* #79 b */
    { 0x290312, 0x290b12, 0x5f65ba1bbfaf2c65, 0xcabecb74377f5e58, 0, 249 }, /* #80 */
    { 0x167cc7, 0x167cc6, 0x5f65ba1bbfaf2c65, 0xcabecb74377f5e58, 0, 249 }, /* #80 b */
    { 0x082e12, 0x082e12, 0xa29a646370b5d04c, 0x1328a69918dc2d74, 0, 182 }, /* #81 */
    { 0x3751c7, 0x3759c6, 0xa29a646370b5d04c, 0x1328a69918dc2d74, 0, 182 }, /* #81 b */
    { 0x291286, 0x291a87, 0x8d25e257f09d7849, 0xf84ebc24c692f12b, 0, 95 }, /* #82 */
    { 0x166d53, 0x166d53, 0x8d25e257f09d7849, 0xf84ebc24c692f12b, 0, 95 }, /* #82 b */
    { 0x087057, 0x087056, 0x022a037103c323bd, 0x40f0c8ef408a80dc, 0, 94 }, /* #83 */
    { 0x370f82, 0x370782, 0x022a037103c323bd, 0x40f0c8ef408a80dc, 0, 94 }, /* #83 b */
    { 0x054ad7, 0x054ad7, 0xb171999ee024e228, 0xdc049c45162e3333, 0, 157 }, /* #84 */
    { 0x3a3502, 0x3a3d03, 0xb171999ee024e228, 0xdc049c45162e3333, 0, 157 }, /* #84 b */
    { 0x1d5d52, 0x1d5553, 0x1b343f43b95272ed, 0x46cd0fd0ee549cbb, 0, 254 }, /* #85 */
    { 0x222287, 0x222287, 0x1b343f43b95272ed, 0x46cd0fd0ee549cbb, 0, 254 }, /* #85 b */
    { 0x2b67d6, 0x2b6fd7, 0x4d50d762f887f8e2, 0x8935435d8be21fe3, 0, 122 }, /* #86 */
    { 0x141803, 0x141803, 0x4d50d762f887f8e2, 0x8935435d8be21fe3, 0, 122 }, /* #86 b */
    { 0x161352, 0x161b52, 0xa03227e97abf16ae, 0x7e97abf16aea0322, 0, 148 }, /* #87 */
    { 0x296c87, 0x296c86, 0xa03227e97abf16ae, 0x7e97abf16aea0322, 0, 148 }, /* #87 b */
    { 0x2a4c02, 0x2a4403, 0x3d77a1c8b9e19a62, 0xc8b9e19a623d77a1, 0, 152 }, /* #88 */
    { 0x1533d7, 0x1533d7, 0x3d77a1c8b9e19a62, 0xc8b9e19a623d77a1, 0, 152 }, /* #88 b */
    { 0x2e6087, 0x2e6887, 0x445d73f961d38019, 0xf961d38019445d73, 0, 24 }, /* #89 */
    { 0x111f52, 0x111f53, 0x445d73f961d38019, 0xf961d38019445d73, 0, 24 }, /* #89 b */
    { 0x167216, 0x167216, 0xe1c414a187e95796, 0x9430fd2af2dc3882, 0, 85 }, /* #90 */
    { 0x290dc3, 0x2905c2, 0xe1c414a187e95796, 0x9430fd2af2dc3882, 0, 85 }, /* #90 b */
    { 0x324487, 0x324486, 0xcc98080f47144453, 0x98080f47144453cc, 0, 8  }, /* #91 */
    { 0x0d3b52, 0x0d3352, 0xcc98080f47144453, 0x98080f47144453cc, 0, 8  }, /* #91 b */
    { 0x376043, 0x376042, 0xf07192252622584b, 0x3244a4c44b097e0e, 0, 77 }, /* #92 */
    { 0x081f96, 0x081796, 0xf07192252622584b, 0x3244a4c44b097e0e, 0, 77 }, /* #92 b */
    { 0x154447, 0x154447, 0xc097fa3d46479ffa, 0xe8f5191e7feb025f, 0, 210 }, /* #93 */
    { 0x2a3b92, 0x2a3393, 0xc097fa3d46479ffa, 0xe8f5191e7feb025f, 0, 210 }, /* #93 b */
    { 0x1a43d3, 0x1a4bd3, 0x67c68b1e9ac09f71, 0x9f1a2c7a6b027dc5, 0, 66 }, /* #94 */
    { 0x253c06, 0x253c07, 0x67c68b1e9ac09f71, 0x9f1a2c7a6b027dc5, 0, 66 }, /* #94 b */
    { 0x391f86, 0x391786, 0x08244231cd894ce8, 0x04122118e6c4a674, 0, 127 }, /* #95 */
    { 0x066053, 0x066052, 0x08244231cd894ce8, 0x04122118e6c4a674, 0, 127 }, /* #95 b */
};
uint32_t const g_cTests_rol_u64_intel = RT_ELEMENTS(g_aTests_rol_u64_intel);

BINU64_TEST_T const g_aTests_ror_u64_intel[] =
{
    { 0x215dc2, 0x2155c2, 0x0000000000000000, 0x0000000000000000, 0, 11 }, /* #0 */
    { 0x1e2217, 0x1e2216, 0x0000000000000000, 0x0000000000000000, 0, 11 }, /* #0 b */
    { 0x345ec2, 0x3456c2, 0x0000000000000000, 0x0000000000000000, 0, 79 }, /* #1 */
    { 0x0b2117, 0x0b2116, 0x0000000000000000, 0x0000000000000000, 0, 79 }, /* #1 b */
    { 0x1b2686, 0x1b2686, 0x0000000000000000, 0x0000000000000000, 0, 123 }, /* #2 */
    { 0x245953, 0x245152, 0x0000000000000000, 0x0000000000000000, 0, 123 }, /* #2 b */
    { 0x0d7657, 0x0d7656, 0x0000000000000000, 0x0000000000000000, 0, 73 }, /* #3 */
    { 0x320982, 0x320182, 0x0000000000000000, 0x0000000000000000, 0, 73 }, /* #3 b */
    { 0x022402, 0x022402, 0x0000000000000000, 0x0000000000000000, 0, 98 }, /* #4 */
    { 0x3d5bd7, 0x3d53d6, 0x0000000000000000, 0x0000000000000000, 0, 98 }, /* #4 b */
    { 0x2c15c2, 0x2c15c2, 0x0000000000000000, 0x0000000000000000, 0, 177 }, /* #5 */
    { 0x136a17, 0x136216, 0x0000000000000000, 0x0000000000000000, 0, 177 }, /* #5 b */
    { 0x061e07, 0x061606, 0x6c15baacbf4bc3ea, 0x4d82b75597e9787d, 0, 3  }, /* #6 */
    { 0x3961d2, 0x3961d2, 0x6c15baacbf4bc3ea, 0x4d82b75597e9787d, 0, 3  }, /* #6 b */
    { 0x116ed7, 0x116ed6, 0x9f49750f8e76d1c8, 0x13e92ea1f1ceda39, 0, 195 }, /* #7 */
    { 0x2e1102, 0x2e1902, 0x9f49750f8e76d1c8, 0x13e92ea1f1ceda39, 0, 195 }, /* #7 b */
    { 0x2c3b42, 0x2c3342, 0x354509bb4d156648, 0x20d51426ed345599, 0, 198 }, /* #8 */
    { 0x134497, 0x134496, 0x354509bb4d156648, 0x20d51426ed345599, 0, 198 }, /* #8 b */
    { 0x0b3f56, 0x0b3f56, 0x8ecd8881da72ae72, 0x4766c440ed395739, 0, 65 }, /* #9 */
    { 0x344083, 0x344882, 0x8ecd8881da72ae72, 0x4766c440ed395739, 0, 65 }, /* #9 b */
    { 0x140216, 0x140a17, 0x476173114f23e431, 0xf218a3b0b988a791, 0, 17 }, /* #10 */
    { 0x2b7dc3, 0x2b7dc3, 0x476173114f23e431, 0xf218a3b0b988a791, 0, 17 }, /* #10 b */
    { 0x081a07, 0x081206, 0x806712347b24a985, 0x0ce2468f649530b0, 0, 187 }, /* #11 */
    { 0x3765d2, 0x3765d2, 0x806712347b24a985, 0x0ce2468f649530b0, 0, 187 }, /* #11 b */
    { 0x376ec2, 0x376ec2, 0x984dbf85f7dc91fe, 0x6136fe17df7247fa, 0, 126 }, /* #12 */
    { 0x081117, 0x081916, 0x984dbf85f7dc91fe, 0x6136fe17df7247fa, 0, 126 }, /* #12 b */
    { 0x133192, 0x133993, 0x2352293ba9b6729b, 0x9dd4db394d91a914, 0, 41 }, /* #13 */
    { 0x2c4e47, 0x2c4e47, 0x2352293ba9b6729b, 0x9dd4db394d91a914, 0, 41 }, /* #13 b */
    { 0x2442d2, 0x244ad3, 0x3b3632fc3485be4f, 0x9b197e1a42df279d, 0, 57 }, /* #14 */
    { 0x1b3d07, 0x1b3d07, 0x3b3632fc3485be4f, 0x9b197e1a42df279d, 0, 57 }, /* #14 b */
    { 0x0b7783, 0x0b7f83, 0xb3b45b9bd0c933d0, 0xa19267a16768b737, 0, 31 }, /* #15 */
    { 0x340856, 0x340857, 0xb3b45b9bd0c933d0, 0xa19267a16768b737, 0, 31 }, /* #15 b */
    { 0x3c4247, 0x3c4246, 0x1b8e186b49f234d6, 0x371c30d693e469ac, 0, 127 }, /* #16 */
    { 0x033d92, 0x033592, 0x1b8e186b49f234d6, 0x371c30d693e469ac, 0, 127 }, /* #16 b */
    { 0x0328d7, 0x0320d7, 0xb1b3ab40f05c6637, 0xe331bd8d9d5a0782, 0, 213 }, /* #17 */
    { 0x3c5702, 0x3c5703, 0xb1b3ab40f05c6637, 0xe331bd8d9d5a0782, 0, 213 }, /* #17 b */
    { 0x0d3b52, 0x0d3b52, 0x99102a5d610d85b2, 0x40a975843616ca64, 0, 246 }, /* #18 */
    { 0x324487, 0x324c86, 0x99102a5d610d85b2, 0x40a975843616ca64, 0, 246 }, /* #18 b */
    { 0x3a0ec7, 0x3a0ec6, 0x453d6c8116367dc5, 0x367dc5453d6c8116, 0, 216 }, /* #19 */
    { 0x057112, 0x057912, 0x453d6c8116367dc5, 0x367dc5453d6c8116, 0, 216 }, /* #19 b */
    { 0x0e3846, 0x0e3847, 0xbc1a8d065d0a0cdc, 0xa0cdcbc1a8d065d0, 0, 148 }, /* #20 */
    { 0x314793, 0x314f93, 0xbc1a8d065d0a0cdc, 0xa0cdcbc1a8d065d0, 0, 148 }, /* #20 b */
    { 0x3c7c87, 0x3c7487, 0xc186b120e4d67f43, 0xc35890726b3fa1e0, 0, 185 }, /* #21 */
    { 0x030352, 0x030353, 0xc186b120e4d67f43, 0xc35890726b3fa1e0, 0, 185 }, /* #21 b */
    { 0x176946, 0x176946, 0xb3c4ff3299d1c066, 0x533a380cd6789fe6, 0, 227 }, /* #22 */
    { 0x281693, 0x281e92, 0xb3c4ff3299d1c066, 0x533a380cd6789fe6, 0, 227 }, /* #22 b */
    { 0x0d4306, 0x0d4306, 0x44ff1c7f8a76003e, 0x1f227f8e3fc53b00, 0, 73 }, /* #23 */
    { 0x323cd3, 0x3234d2, 0x44ff1c7f8a76003e, 0x1f227f8e3fc53b00, 0, 73 }, /* #23 b */
    { 0x224b56, 0x224b57, 0x6f5d3a4bd3341271, 0xa66824e2deba7497, 0, 223 }, /* #24 */
    { 0x1d3483, 0x1d3c83, 0x6f5d3a4bd3341271, 0xa66824e2deba7497, 0, 223 }, /* #24 b */
    { 0x1a5712, 0x1a5712, 0x2e01f384da4e360c, 0x07ce136938d830b8, 0, 182 }, /* #25 */
    { 0x2528c7, 0x2520c6, 0x2e01f384da4e360c, 0x07ce136938d830b8, 0, 182 }, /* #25 b */
    { 0x296a07, 0x296206, 0xde6f208201a01f3b, 0x10403403e77bcde4, 0, 43 }, /* #26 */
    { 0x1615d2, 0x1615d2, 0xde6f208201a01f3b, 0x10403403e77bcde4, 0, 43 }, /* #26 b */
    { 0x081c12, 0x081412, 0x26c6b8e3bc1112e2, 0x782225c44d8d71c7, 0, 159 }, /* #27 */
    { 0x3763c7, 0x3763c6, 0x26c6b8e3bc1112e2, 0x782225c44d8d71c7, 0, 159 }, /* #27 b */
    { 0x0f1c43, 0x0f1443, 0x6e95f15dd00dfdbe, 0xcdd2be2bba01bfb7, 0, 3  }, /* #28 */
    { 0x306396, 0x306397, 0x6e95f15dd00dfdbe, 0xcdd2be2bba01bfb7, 0, 3  }, /* #28 b */
    { 0x1757d6, 0x1757d6, 0xb6a8481e1685c0eb, 0xb6a8481e1685c0eb, 0, 64 }, /* #29 */
    { 0x282803, 0x282803, 0xb6a8481e1685c0eb, 0xb6a8481e1685c0eb, 0, 64 }, /* #29 b */
    { 0x0822d7, 0x082ad7, 0x965cd0c1af3e4e60, 0xe6860d79f27304b2, 0, 245 }, /* #30 */
    { 0x375d02, 0x375d03, 0x965cd0c1af3e4e60, 0xe6860d79f27304b2, 0, 245 }, /* #30 b */
    { 0x244e12, 0x244612, 0xbc893dd11b99ab01, 0x560379127ba23733, 0, 143 }, /* #31 */
    { 0x1b31c7, 0x1b31c6, 0xbc893dd11b99ab01, 0x560379127ba23733, 0, 143 }, /* #31 b */
    { 0x3f6757, 0x3f6757, 0x35e5d0168f332086, 0x8d797405a3ccc821, 0, 2  }, /* #32 */
    { 0x001882, 0x001083, 0x35e5d0168f332086, 0x8d797405a3ccc821, 0, 2  }, /* #32 b */
    { 0x106507, 0x106507, 0xae94ac93a5d8fc61, 0xae94ac93a5d8fc61, 0, 192 }, /* #33 */
    { 0x2f1ad2, 0x2f1ad2, 0xae94ac93a5d8fc61, 0xae94ac93a5d8fc61, 0, 192 }, /* #33 b */
    { 0x2b0c93, 0x2b0c92, 0x5ef3c05c106c84f9, 0x36427caf79e02e08, 0, 25 }, /* #34 */
    { 0x147346, 0x147b46, 0x5ef3c05c106c84f9, 0x36427caf79e02e08, 0, 25 }, /* #34 b */
    { 0x3e4892, 0x3e4093, 0xfb20dd03bd58d809, 0xac6c04fd906e81de, 0, 89 }, /* #35 */
    { 0x013747, 0x013747, 0xfb20dd03bd58d809, 0xac6c04fd906e81de, 0, 89 }, /* #35 b */
    { 0x283496, 0x283497, 0x07326e0574c6124a, 0x993702ba63092503, 0, 121 }, /* #36 */
    { 0x174b43, 0x174343, 0x07326e0574c6124a, 0x993702ba63092503, 0, 121 }, /* #36 b */
    { 0x153903, 0x153903, 0x2e7e4b5e738dd1f9, 0x96bce71ba3f25cfc, 0, 111 }, /* #37 */
    { 0x2a46d6, 0x2a4ed7, 0x2e7e4b5e738dd1f9, 0x96bce71ba3f25cfc, 0, 111 }, /* #37 b */
    { 0x351086, 0x351087, 0xc51bbe4c464b6d3d, 0xbe4c464b6d3dc51b, 0, 240 }, /* #38 */
    { 0x0a6f53, 0x0a6753, 0xc51bbe4c464b6d3d, 0xbe4c464b6d3dc51b, 0, 240 }, /* #38 b */
    { 0x3a1406, 0x3a1407, 0x9a79b43baa11138f, 0x8444e3e69e6d0eea, 0, 154 }, /* #39 */
    { 0x056bd3, 0x0563d3, 0x9a79b43baa11138f, 0x8444e3e69e6d0eea, 0, 154 }, /* #39 b */
    { 0x1d0bd3, 0x1d03d2, 0x8fba9849151bd2a7, 0x6f4a9e3eea612454, 0, 214 }, /* #40 */
    { 0x227406, 0x227406, 0x8fba9849151bd2a7, 0x6f4a9e3eea612454, 0, 214 }, /* #40 b */
    { 0x035006, 0x035806, 0x456e9e371d3a09cb, 0x5a2b74f1b8e9d04e, 0, 133 }, /* #41 */
    { 0x3c2fd3, 0x3c2fd2, 0x456e9e371d3a09cb, 0x5a2b74f1b8e9d04e, 0, 133 }, /* #41 b */
    { 0x0a2516, 0x0a2517, 0xc8bafd3da6394349, 0xe9ed31ca1a4e45d7, 0, 173 }, /* #42 */
    { 0x355ac3, 0x3552c3, 0xc8bafd3da6394349, 0xe9ed31ca1a4e45d7, 0, 173 }, /* #42 b */
    { 0x2b74d2, 0x2b7cd3, 0x35cdfb735c7ce875, 0xea6b9bf6e6b8f9d0, 0, 71 }, /* #43 */
    { 0x140b07, 0x140b07, 0x35cdfb735c7ce875, 0xea6b9bf6e6b8f9d0, 0, 71 }, /* #43 b */
    { 0x084ec7, 0x0846c6, 0xb5aa2864f7b09615, 0x0c9ef612c2b6b545, 0, 107 }, /* #44 */
    { 0x373112, 0x373112, 0xb5aa2864f7b09615, 0x0c9ef612c2b6b545, 0, 107 }, /* #44 b */
    { 0x096a03, 0x096a03, 0xc1b0bd0ec176a45a, 0x916b06c2f43b05da, 0, 206 }, /* #45 */
    { 0x3615d6, 0x361dd7, 0xc1b0bd0ec176a45a, 0x916b06c2f43b05da, 0, 206 }, /* #45 b */
    { 0x0e46d2, 0x0e4ed3, 0xb6ddcfc818a3f9cc, 0xe7e40c51fce65b6e, 0, 177 }, /* #46 */
    { 0x313907, 0x313907, 0xb6ddcfc818a3f9cc, 0xe7e40c51fce65b6e, 0, 177 }, /* #46 b */
    { 0x2a2756, 0x2a2f56, 0x4af613034499371f, 0x4dc7d2bd84c0d126, 0, 146 }, /* #47 */
    { 0x155883, 0x155882, 0x4af613034499371f, 0x4dc7d2bd84c0d126, 0, 146 }, /* #47 b */
    { 0x267596, 0x267597, 0xb62a80d97ac3f3b9, 0x9dcdb15406cbd61f, 0, 205 }, /* #48 */
    { 0x190a43, 0x190243, 0xb62a80d97ac3f3b9, 0x9dcdb15406cbd61f, 0, 205 }, /* #48 b */
    { 0x133296, 0x133a96, 0xbaf1a51ce8374bb8, 0x1a51ce8374bb8baf, 0, 180 }, /* #49 */
    { 0x2c4d43, 0x2c4d42, 0xbaf1a51ce8374bb8, 0x1a51ce8374bb8baf, 0, 180 }, /* #49 b */
    { 0x076257, 0x076a57, 0x9538e5ee0fb214f0, 0x97b83ec853c254e3, 0, 174 }, /* #50 */
    { 0x381d82, 0x381d83, 0x9538e5ee0fb214f0, 0x97b83ec853c254e3, 0, 174 }, /* #50 b */
    { 0x174f12, 0x174f13, 0xf0a363caa201a980, 0x80f0a363caa201a9, 0, 136 }, /* #51 */
    { 0x2830c7, 0x2838c7, 0xf0a363caa201a980, 0x80f0a363caa201a9, 0, 136 }, /* #51 b */
    { 0x315282, 0x315a83, 0x567498eef6228915, 0xb3a4c777b11448aa, 0, 189 }, /* #52 */
    { 0x0e2d57, 0x0e2d57, 0x567498eef6228915, 0xb3a4c777b11448aa, 0, 189 }, /* #52 b */
    { 0x380316, 0x380b16, 0x989e6ba25f9c632c, 0x32c989e6ba25f9c6, 0, 76 }, /* #53 */
    { 0x077cc3, 0x077cc2, 0x989e6ba25f9c632c, 0x32c989e6ba25f9c6, 0, 76 }, /* #53 b */
    { 0x3b4e53, 0x3b4653, 0xcfd7203be5c7c5f1, 0xe2f8e7eb901df2e3, 0, 81 }, /* #54 */
    { 0x043186, 0x043187, 0xcfd7203be5c7c5f1, 0xe2f8e7eb901df2e3, 0, 81 }, /* #54 b */
    { 0x320987, 0x320187, 0x2c3f61c8b9dfb520, 0x9dfb5202c3f61c8b, 0, 156 }, /* #55 */
    { 0x0d7652, 0x0d7653, 0x2c3f61c8b9dfb520, 0x9dfb5202c3f61c8b, 0, 156 }, /* #55 b */
    { 0x2279c6, 0x2279c6, 0x31dfbc48775e1802, 0x31dfbc48775e1802, 0, 128 }, /* #56 */
    { 0x1d0613, 0x1d0613, 0x31dfbc48775e1802, 0x31dfbc48775e1802, 0, 128 }, /* #56 b */
    { 0x271117, 0x271117, 0x9640d0cb816ed560, 0x9640d0cb816ed560, 0, 192 }, /* #57 */
    { 0x186ec2, 0x186ec2, 0x9640d0cb816ed560, 0x9640d0cb816ed560, 0, 192 }, /* #57 b */
    { 0x020856, 0x020856, 0x34afe73575cf0acf, 0x7f39abae785679a5, 0, 53 }, /* #58 */
    { 0x3d7783, 0x3d7f82, 0x34afe73575cf0acf, 0x7f39abae785679a5, 0, 53 }, /* #58 b */
    { 0x050006, 0x050807, 0x71af2898513435c9, 0xd0d725c6bca26144, 0, 214 }, /* #59 */
    { 0x3a7fd3, 0x3a7fd3, 0x71af2898513435c9, 0xd0d725c6bca26144, 0, 214 }, /* #59 b */
    { 0x3d5482, 0x3d5483, 0x3e827be9488f3706, 0xf37063e827be9488, 0, 148 }, /* #60 */
    { 0x022b57, 0x022357, 0x3e827be9488f3706, 0xf37063e827be9488, 0, 148 }, /* #60 b */
    { 0x085a96, 0x085a97, 0x6b983f084d4d84dd, 0xdd6b983f084d4d84, 0, 8  }, /* #61 */
    { 0x372543, 0x372d43, 0x6b983f084d4d84dd, 0xdd6b983f084d4d84, 0, 8  }, /* #61 b */
    { 0x262006, 0x262806, 0x7b1f79de708c1fab, 0x3ef3bce1183f56f6, 0, 55 }, /* #62 */
    { 0x195fd3, 0x195fd2, 0x7b1f79de708c1fab, 0x3ef3bce1183f56f6, 0, 55 }, /* #62 b */
    { 0x001743, 0x001f42, 0x982e7183a2165e72, 0x60b9c60e885979ca, 0, 190 }, /* #63 */
    { 0x3f6896, 0x3f6896, 0x982e7183a2165e72, 0x60b9c60e885979ca, 0, 190 }, /* #63 b */
    { 0x007c13, 0x007c13, 0x9adcd8f3f4d6e288, 0xb9b1e7e9adc51135, 0, 55 }, /* #64 */
    { 0x3f03c6, 0x3f0bc7, 0x9adcd8f3f4d6e288, 0xb9b1e7e9adc51135, 0, 55 }, /* #64 b */
    { 0x2b4957, 0x2b4157, 0x37840f728abff416, 0xd058de103dca2aff, 0, 142 }, /* #65 */
    { 0x143682, 0x143683, 0x37840f728abff416, 0xd058de103dca2aff, 0, 142 }, /* #65 b */
    { 0x187e57, 0x187657, 0x749f99ac83504a82, 0xac83504a82749f99, 0, 168 }, /* #66 */
    { 0x270182, 0x270183, 0x749f99ac83504a82, 0xac83504a82749f99, 0, 168 }, /* #66 b */
    { 0x252457, 0x252c56, 0x59bcf9c90bc675a7, 0x33ad3acde7ce485e, 0, 21 }, /* #67 */
    { 0x1a5b82, 0x1a5b82, 0x59bcf9c90bc675a7, 0x33ad3acde7ce485e, 0, 21 }, /* #67 b */
    { 0x182892, 0x182093, 0xf6ce9bfb10f2f737, 0xec43cbdcdfdb3a6f, 0, 102 }, /* #68 */
    { 0x275747, 0x275747, 0xf6ce9bfb10f2f737, 0xec43cbdcdfdb3a6f, 0, 102 }, /* #68 b */
    { 0x2f0d93, 0x2f0d92, 0xa2eb81246148a26e, 0x148a26ea2eb81246, 0, 156 }, /* #69 */
    { 0x107246, 0x107a46, 0xa2eb81246148a26e, 0x148a26ea2eb81246, 0, 156 }, /* #69 b */
    { 0x011806, 0x011006, 0x89368310223285d9, 0x3285d98936831022, 0, 216 }, /* #70 */
    { 0x3e67d3, 0x3e67d2, 0x89368310223285d9, 0x3285d98936831022, 0, 216 }, /* #70 b */
    { 0x2621c7, 0x2629c6, 0x3b885ee74917e56f, 0x17b9d245f95bcee2, 0, 242 }, /* #71 */
    { 0x195e12, 0x195e12, 0x3b885ee74917e56f, 0x17b9d245f95bcee2, 0, 242 }, /* #71 b */
    { 0x024d83, 0x024d82, 0x816fc75f0c049fb6, 0x0c049fb6816fc75f, 0, 32 }, /* #72 */
    { 0x3d3256, 0x3d3a56, 0x816fc75f0c049fb6, 0x0c049fb6816fc75f, 0, 32 }, /* #72 b */
    { 0x274807, 0x274807, 0x17be31df47187705, 0xa2f7c63be8e30ee0, 0, 67 }, /* #73 */
    { 0x1837d2, 0x183fd3, 0x17be31df47187705, 0xa2f7c63be8e30ee0, 0, 67 }, /* #73 b */
    { 0x3a4986, 0x3a4986, 0x94000c3a446f7ffe, 0x6f7ffe94000c3a44, 0, 24 }, /* #74 */
    { 0x053653, 0x053e52, 0x94000c3a446f7ffe, 0x6f7ffe94000c3a44, 0, 24 }, /* #74 b */
    { 0x3f7d56, 0x3f7557, 0x9794dbcdbfeff9a7, 0xca6de6dff7fcd3cb, 0, 57 }, /* #75 */
    { 0x000283, 0x000283, 0x9794dbcdbfeff9a7, 0xca6de6dff7fcd3cb, 0, 57 }, /* #75 b */
    { 0x161342, 0x161b42, 0x5b87ec110d49a8f7, 0x7ec110d49a8f75b8, 0, 52 }, /* #76 */
    { 0x296c97, 0x296c96, 0x5b87ec110d49a8f7, 0x7ec110d49a8f75b8, 0, 52 }, /* #76 b */
    { 0x3a30c3, 0x3a38c2, 0xe3c68a3355811bd2, 0x519aac08de971e34, 0, 109 }, /* #77 */
    { 0x054f16, 0x054f16, 0xe3c68a3355811bd2, 0x519aac08de971e34, 0, 109 }, /* #77 b */
    { 0x123003, 0x123802, 0x2e6c5713cd681191, 0x13cd6811912e6c57, 0, 168 }, /* #78 */
    { 0x2d4fd6, 0x2d4fd6, 0x2e6c5713cd681191, 0x13cd6811912e6c57, 0, 168 }, /* #78 b */
    { 0x273e17, 0x273e16, 0x1d60a8b631319fc7, 0x19fc71d60a8b6313, 0, 20 }, /* #79 */
    { 0x1841c2, 0x1849c2, 0x1d60a8b631319fc7, 0x19fc71d60a8b6313, 0, 20 }, /* #79 b */
    { 0x2a6012, 0x2a6012, 0x0ae64350f1a66e56, 0x560ae64350f1a66e, 0, 136 }, /* #80 */
    { 0x151fc7, 0x1517c6, 0x0ae64350f1a66e56, 0x560ae64350f1a66e, 0, 136 }, /* #80 b */
    { 0x3c7702, 0x3c7702, 0xc9e0fd4c6a4d0077, 0x6803be4f07ea6352, 0, 85 }, /* #81 */
    { 0x0308d7, 0x0300d6, 0xc9e0fd4c6a4d0077, 0x6803be4f07ea6352, 0, 85 }, /* #81 b */
    { 0x365653, 0x365e53, 0xb85bd698afcb01a8, 0xc06a2e16f5a62bf2, 0, 210 }, /* #82 */
    { 0x092986, 0x092987, 0xb85bd698afcb01a8, 0xc06a2e16f5a62bf2, 0, 210 }, /* #82 b */
    { 0x2170c7, 0x2170c6, 0x009f50df77332a8a, 0x665514013ea1beee, 0, 87 }, /* #83 */
    { 0x1e0f12, 0x1e0712, 0x009f50df77332a8a, 0x665514013ea1beee, 0, 87 }, /* #83 b */
    { 0x143e17, 0x143617, 0xfbca9a3209ef77f9, 0xa3209ef77f9fbca9, 0, 44 }, /* #84 */
    { 0x2b41c2, 0x2b41c3, 0xfbca9a3209ef77f9, 0xa3209ef77f9fbca9, 0, 44 }, /* #84 b */
    { 0x341e46, 0x341e46, 0xc99f1c172a5a107c, 0x52d083e64cf8e0b9, 0, 157 }, /* #85 */
    { 0x0b6193, 0x0b6992, 0xc99f1c172a5a107c, 0x52d083e64cf8e0b9, 0, 157 }, /* #85 b */
    { 0x0e6247, 0x0e6a47, 0xb36bbce22d97ff78, 0x88b65ffde2cdaef3, 0, 102 }, /* #86 */
    { 0x311d92, 0x311d93, 0xb36bbce22d97ff78, 0x88b65ffde2cdaef3, 0, 102 }, /* #86 b */
    { 0x1f6a53, 0x1f6a53, 0x2c97a03907def047, 0x8e592f40720fbde0, 0, 199 }, /* #87 */
    { 0x201586, 0x201d87, 0x2c97a03907def047, 0x8e592f40720fbde0, 0, 199 }, /* #87 b */
    { 0x0d3696, 0x0d3696, 0x42fc9baf513c4ad7, 0x42fc9baf513c4ad7, 0, 128 }, /* #88 */
    { 0x324943, 0x324943, 0x42fc9baf513c4ad7, 0x42fc9baf513c4ad7, 0, 128 }, /* #88 b */
    { 0x0a65d6, 0x0a65d6, 0xc52e2e9657fbd19d, 0x297174b2bfde8cee, 0, 125 }, /* #89 */
    { 0x351a03, 0x351202, 0xc52e2e9657fbd19d, 0x297174b2bfde8cee, 0, 125 }, /* #89 b */
    { 0x074c93, 0x074c93, 0x1be7dc4a4442409f, 0x8884813e37cfb894, 0, 95 }, /* #90 */
    { 0x383346, 0x383b47, 0x1be7dc4a4442409f, 0x8884813e37cfb894, 0, 95 }, /* #90 b */
    { 0x0e4152, 0x0e4952, 0xdc55c05b68bd3e44, 0x2db45e9f226e2ae0, 0, 41 }, /* #91 */
    { 0x313e87, 0x313e86, 0xdc55c05b68bd3e44, 0x2db45e9f226e2ae0, 0, 41 }, /* #91 b */
    { 0x004807, 0x004007, 0x17a7d2be851abef8, 0xbe851abef817a7d2, 0, 40 }, /* #92 */
    { 0x3f37d2, 0x3f37d3, 0x17a7d2be851abef8, 0xbe851abef817a7d2, 0, 40 }, /* #92 b */
    { 0x2c6b52, 0x2c6353, 0x15292237cee7eaba, 0xa94911be773f55d0, 0, 125 }, /* #93 */
    { 0x131487, 0x131487, 0x15292237cee7eaba, 0xa94911be773f55d0, 0, 125 }, /* #93 b */
    { 0x3c6382, 0x3c6b83, 0x862a7fcd05f0b3de, 0xf0b3de862a7fcd05, 0, 24 }, /* #94 */
    { 0x031c57, 0x031c57, 0x862a7fcd05f0b3de, 0xf0b3de862a7fcd05, 0, 24 }, /* #94 b */
    { 0x105b02, 0x105b03, 0x83675bc4558b3f7c, 0xbc4558b3f7c83675, 0, 172 }, /* #95 */
    { 0x2f24d7, 0x2f2cd7, 0x83675bc4558b3f7c, 0xbc4558b3f7c83675, 0, 172 }, /* #95 b */
};
uint32_t const g_cTests_ror_u64_intel = RT_ELEMENTS(g_aTests_ror_u64_intel);

BINU64_TEST_T const g_aTests_rcl_u64_intel[] =
{
    { 0x201857, 0x201056, 0x0000000000000000, 0x0000001000000000, 0, 229 }, /* #0 */
    { 0x1f6782, 0x1f6782, 0x0000000000000000, 0x0000000000000000, 0, 229 }, /* #0 b */
    { 0x3b5b93, 0x3b5392, 0x0000000000000000, 0x0008000000000000, 0, 244 }, /* #1 */
    { 0x042446, 0x042446, 0x0000000000000000, 0x0000000000000000, 0, 244 }, /* #1 b */
    { 0x197a16, 0x197216, 0x0000000000000000, 0x0000000000000000, 0, 97 }, /* #2 */
    { 0x2605c3, 0x2605c2, 0x0000000000000000, 0x0000000100000000, 0, 97 }, /* #2 b */
    { 0x2415c3, 0x2415c2, 0x0000000000000000, 0x0400000000000000, 0, 123 }, /* #3 */
    { 0x1b6a16, 0x1b6216, 0x0000000000000000, 0x0000000000000000, 0, 123 }, /* #3 b */
    { 0x324652, 0x324652, 0x0000000000000000, 0x0000000000000000, 0, 75 }, /* #4 */
    { 0x0d3987, 0x0d3186, 0x0000000000000000, 0x0000000000000400, 0, 75 }, /* #4 b */
    { 0x236b92, 0x236392, 0x0000000000000000, 0x0000000000000000, 0, 37 }, /* #5 */
    { 0x1c1447, 0x1c1446, 0x0000000000000000, 0x0000001000000000, 0, 37 }, /* #5 b */
    { 0x397113, 0x397913, 0x4ffdb4ee71981d3f, 0x6d3b9c66074fe9ff, 0, 206 }, /* #6 */
    { 0x060ec6, 0x060ec7, 0x4ffdb4ee71981d3f, 0x6d3b9c66074fc9ff, 0, 206 }, /* #6 b */
    { 0x144893, 0x144093, 0x33773e59e54bb708, 0x0899bb9f2cf2a5db, 0, 120 }, /* #7 */
    { 0x2b3746, 0x2b3747, 0x33773e59e54bb708, 0x0819bb9f2cf2a5db, 0, 120 }, /* #7 b */
    { 0x374412, 0x374413, 0x3839994c80f36a55, 0x01e6d4aa3839994c, 0, 225 }, /* #8 */
    { 0x083bc7, 0x0833c7, 0x3839994c80f36a55, 0x01e6d4ab3839994c, 0, 225 }, /* #8 b */
    { 0x0d0297, 0x0d0a97, 0xb470116c9dd01604, 0x740581368e022d93, 0, 38 }, /* #9 */
    { 0x327d42, 0x327d43, 0xb470116c9dd01604, 0x740581168e022d93, 0, 38 }, /* #9 b */
    { 0x1f4183, 0x1f4183, 0x117619a90403be17, 0x17619a90403be178, 0, 132 }, /* #10 */
    { 0x203e56, 0x203657, 0x117619a90403be17, 0x17619a90403be170, 0, 132 }, /* #10 b */
    { 0x1e6a12, 0x1e6a13, 0x611e35162eb7455e, 0xc611e35162eb7455, 0, 125 }, /* #11 */
    { 0x2115c7, 0x211dc7, 0x611e35162eb7455e, 0xd611e35162eb7455, 0, 125 }, /* #11 b */
    { 0x154f87, 0x154786, 0x060c2fc74282c659, 0x60c2fc74282c6598, 0, 4  }, /* #12 */
    { 0x2a3052, 0x2a3052, 0x060c2fc74282c659, 0x60c2fc74282c6590, 0, 4  }, /* #12 b */
    { 0x123d07, 0x123506, 0xca47707068896517, 0xca2fca4770706889, 0, 177 }, /* #13 */
    { 0x2d42d2, 0x2d42d2, 0xca47707068896517, 0xca2eca4770706889, 0, 177 }, /* #13 b */
    { 0x043593, 0x043593, 0x3596536166f663c6, 0x6166f663c69acb29, 0, 216 }, /* #14 */
    { 0x3b4a46, 0x3b4247, 0x3596536166f663c6, 0x6166f663c61acb29, 0, 216 }, /* #14 b */
    { 0x2a47c3, 0x2a4fc2, 0xa93de11e8338a968, 0x338a968d49ef08f4, 0, 36 }, /* #15 */
    { 0x153816, 0x153816, 0xa93de11e8338a968, 0x338a968549ef08f4, 0, 36 }, /* #15 b */
    { 0x110f86, 0x110f87, 0x7c8837e1d147129e, 0x129e3e441bf0e8a3, 0, 48 }, /* #16 */
    { 0x2e7053, 0x2e7853, 0x7c8837e1d147129e, 0x129ebe441bf0e8a3, 0, 48 }, /* #16 b */
    { 0x0e5fd2, 0x0e57d2, 0xe0f31ce44cb7c15a, 0xad383cc739132df0, 0, 55 }, /* #17 */
    { 0x312007, 0x312006, 0xe0f31ce44cb7c15a, 0xad783cc739132df0, 0, 55 }, /* #17 b */
    { 0x332243, 0x332a43, 0x5e6f996eeb56f746, 0xba3579be65bbad5b, 0, 115 }, /* #18 */
    { 0x0c5d96, 0x0c5d97, 0x5e6f996eeb56f746, 0xba3179be65bbad5b, 0, 115 }, /* #18 b */
    { 0x3a6b92, 0x3a6b93, 0x613b01f58ba0c8ee, 0x06477184ec07d62e, 0, 43 }, /* #19 */
    { 0x051447, 0x051c47, 0x613b01f58ba0c8ee, 0x06477584ec07d62e, 0, 43 }, /* #19 b */
    { 0x0b3113, 0x0b3912, 0xa039bce5be4f61ca, 0x39bce5be4f61cad0, 0, 72 }, /* #20 */
    { 0x344ec6, 0x344ec6, 0xa039bce5be4f61ca, 0x39bce5be4f61ca50, 0, 72 }, /* #20 b */
    { 0x3d10c2, 0x3d18c3, 0x7dd2a4c275cdf04c, 0xae6f8261f74a9309, 0, 227 }, /* #21 */
    { 0x026f17, 0x026f17, 0x7dd2a4c275cdf04c, 0xae6f8265f74a9309, 0, 227 }, /* #21 b */
    { 0x135312, 0x135313, 0xf0aa8fc2894458a3, 0x85547e144a22c51b, 0, 3  }, /* #22 */
    { 0x2c2cc7, 0x2c24c7, 0xf0aa8fc2894458a3, 0x85547e144a22c51f, 0, 3  }, /* #22 b */
    { 0x211947, 0x211947, 0x778e2b50fc3a41a4, 0x49778e2b50fc3a41, 0, 121 }, /* #23 */
    { 0x1e6692, 0x1e6e93, 0x778e2b50fc3a41a4, 0x48778e2b50fc3a41, 0, 121 }, /* #23 b */
    { 0x162c52, 0x162c53, 0xb92480e7d952b899, 0x24073eca95c4cae4, 0, 75 }, /* #24 */
    { 0x295387, 0x295b87, 0xb92480e7d952b899, 0x24073eca95c4cee4, 0, 75 }, /* #24 b */
    { 0x3a4187, 0x3a4186, 0x0fe5e79cfcda210b, 0xf3ce7e6d1085c3f9, 0, 79 }, /* #25 */
    { 0x053e52, 0x053652, 0x0fe5e79cfcda210b, 0xf3ce7e6d108583f9, 0, 79 }, /* #25 b */
    { 0x0d6e57, 0x0d6e57, 0x6f4833d91e98bef2, 0x647a62fbcade9067, 0, 26 }, /* #26 */
    { 0x321182, 0x321983, 0x6f4833d91e98bef2, 0x647a62fbc8de9067, 0, 26 }, /* #26 b */
    { 0x1b3ac3, 0x1b3ac3, 0x7e4ca328f63b9b44, 0xa25f9328ca3d8ee6, 0, 247 }, /* #27 */
    { 0x244516, 0x244d17, 0x7e4ca328f63b9b44, 0xa21f9328ca3d8ee6, 0, 247 }, /* #27 b */
    { 0x052796, 0x052f97, 0x7dee05899d17d640, 0xdc0b133a2fac807d, 0, 73 }, /* #28 */
    { 0x3a5843, 0x3a5843, 0x7dee05899d17d640, 0xdc0b133a2fac817d, 0, 73 }, /* #28 b */
    { 0x3f7c96, 0x3f7497, 0xdb4440ca9e92dc01, 0x496e00b6d11032a7, 0, 103 }, /* #29 */
    { 0x000343, 0x000343, 0xdb4440ca9e92dc01, 0x496e00f6d11032a7, 0, 103 }, /* #29 b */
    { 0x264447, 0x264447, 0xf80881076a575453, 0x076a575453fc0440, 0, 216 }, /* #30 */
    { 0x193b92, 0x193393, 0xf80881076a575453, 0x076a5754537c0440, 0, 216 }, /* #30 b */
    { 0x202993, 0x202192, 0x379e4b0ab8ec69e2, 0x2ae3b1a78a6f3c96, 0, 154 }, /* #31 */
    { 0x1f5646, 0x1f5646, 0x379e4b0ab8ec69e2, 0x2ae3b1a7886f3c96, 0, 154 }, /* #31 b */
    { 0x241687, 0x241686, 0x03f9f3d7c2c98d0a, 0xc98d0a81fcf9ebe1, 0, 104 }, /* #32 */
    { 0x1b6952, 0x1b6152, 0x03f9f3d7c2c98d0a, 0xc98d0a01fcf9ebe1, 0, 104 }, /* #32 b */
    { 0x396593, 0x396593, 0x373714a21612f376, 0xda6e6e29442c25e6, 0, 186 }, /* #33 */
    { 0x061a46, 0x061247, 0x373714a21612f376, 0xd86e6e29442c25e6, 0, 186 }, /* #33 b */
    { 0x237193, 0x237193, 0x3c890c13628b080f, 0x01f3c890c13628b0, 0, 117 }, /* #34 */
    { 0x1c0e46, 0x1c0647, 0x3c890c13628b080f, 0x01e3c890c13628b0, 0, 117 }, /* #34 b */
    { 0x103f86, 0x103f87, 0x483f3a5e149b2f0d, 0xc29365e1a483f3a5, 0, 157 }, /* #35 */
    { 0x2f4053, 0x2f4853, 0x483f3a5e149b2f0d, 0xc29365e1b483f3a5, 0, 157 }, /* #35 b */
    { 0x073397, 0x073b96, 0x9f5f602f56a5ee70, 0xbec05ead4bdce19f, 0, 73 }, /* #36 */
    { 0x384c42, 0x384c42, 0x9f5f602f56a5ee70, 0xbec05ead4bdce09f, 0, 73 }, /* #36 b */
    { 0x274dd2, 0x274dd3, 0x654123e8c2d1e9e8, 0xd185a3d3d0654123, 0, 25 }, /* #37 */
    { 0x183207, 0x183a07, 0x654123e8c2d1e9e8, 0xd185a3d3d1654123, 0, 25 }, /* #37 b */
    { 0x1d5e47, 0x1d5e47, 0xa00a344a7fc94e91, 0x44a7fc94e91d0051, 0, 148 }, /* #38 */
    { 0x222192, 0x222993, 0xa00a344a7fc94e91, 0x44a7fc94e9150051, 0, 148 }, /* #38 b */
    { 0x3966d3, 0x396ed3, 0x980a46158b1b7131, 0x8db898e602918562, 0, 231 }, /* #39 */
    { 0x061906, 0x061907, 0x980a46158b1b7131, 0x8db898a602918562, 0, 231 }, /* #39 b */
    { 0x0f2a17, 0x0f2217, 0x3d936279ae91296e, 0x89e6ba44a5ba7b26, 0, 18 }, /* #40 */
    { 0x3055c2, 0x3055c3, 0x3d936279ae91296e, 0x89e6ba44a5b87b26, 0, 18 }, /* #40 b */
    { 0x2b3382, 0x2b3383, 0xe4a7bc511a1ec45a, 0x44687b1169c94f78, 0, 218 }, /* #41 */
    { 0x144c57, 0x144457, 0xe4a7bc511a1ec45a, 0x44687b116bc94f78, 0, 218 }, /* #41 b */
    { 0x1e7752, 0x1e7753, 0xf588036eb46192a6, 0x1006dd68c3254cf5, 0, 201 }, /* #42 */
    { 0x210887, 0x210087, 0xf588036eb46192a6, 0x1006dd68c3254df5, 0, 201 }, /* #42 b */
    { 0x223282, 0x223a82, 0x6440658730f876be, 0xbe322032c3987c3b, 0, 248 }, /* #43 */
    { 0x1d4d57, 0x1d4d56, 0x6440658730f876be, 0xbeb22032c3987c3b, 0, 248 }, /* #43 b */
    { 0x2b4e56, 0x2b4e57, 0x81dca6867e382c56, 0x3433f1c162b20772, 0, 83 }, /* #44 */
    { 0x143183, 0x143983, 0x81dca6867e382c56, 0x3433f1c162b60772, 0, 83 }, /* #44 b */
    { 0x127786, 0x127787, 0x1b4cd765d4574aba, 0x06d335d97515d2ae, 0, 127 }, /* #45 */
    { 0x2d0853, 0x2d0053, 0x1b4cd765d4574aba, 0x46d335d97515d2ae, 0, 127 }, /* #45 b */
    { 0x186d86, 0x186d86, 0x523dc2a662322068, 0xa662322068291ee1, 0, 152 }, /* #46 */
    { 0x271253, 0x271a52, 0x523dc2a662322068, 0xa662322068a91ee1, 0, 152 }, /* #46 b */
    { 0x270c57, 0x270457, 0x1be08da559e3e50c, 0x8f943237c11b4ab3, 0, 170 }, /* #47 */
    { 0x187382, 0x187383, 0x1be08da559e3e50c, 0x8f943037c11b4ab3, 0, 170 }, /* #47 b */
    { 0x0274c6, 0x027cc7, 0xa23cfa93ddf03bb5, 0x3ea4f77c0eed5447, 0, 14 }, /* #48 */
    { 0x3d0b13, 0x3d0b13, 0xa23cfa93ddf03bb5, 0x3ea4f77c0eed7447, 0, 14 }, /* #48 b */
    { 0x340a56, 0x340257, 0xd2a15acaca15e77d, 0xf5a542b595942bce, 0, 186 }, /* #49 */
    { 0x0b7583, 0x0b7583, 0xd2a15acaca15e77d, 0xf7a542b595942bce, 0, 186 }, /* #49 b */
    { 0x0b6d46, 0x0b6d46, 0x2c02e1ccce0f28f8, 0x2c02e1ccce0f28f8, 0, 128 }, /* #50 */
    { 0x341293, 0x341293, 0x2c02e1ccce0f28f8, 0x2c02e1ccce0f28f8, 0, 128 }, /* #50 b */
    { 0x0607d2, 0x0607d3, 0xe3c9ee9a948ee3d8, 0x27ba6a523b8f61c7, 0, 10 }, /* #51 */
    { 0x397807, 0x397007, 0xe3c9ee9a948ee3d8, 0x27ba6a523b8f63c7, 0, 10 }, /* #51 b */
    { 0x1131c3, 0x1139c2, 0x88598998f010ddef, 0xf010ddefc42cc4cc, 0, 32 }, /* #52 */
    { 0x2e4e16, 0x2e4e16, 0x88598998f010ddef, 0xf010ddef442cc4cc, 0, 32 }, /* #52 b */
    { 0x161557, 0x161557, 0x16682cfe44c0c02a, 0xf22606015459a0b3, 0, 219 }, /* #53 */
    { 0x296a82, 0x296283, 0x16682cfe44c0c02a, 0xf22606015059a0b3, 0, 219 }, /* #53 b */
    { 0x3d7812, 0x3d7812, 0x4c4f3835a218e9fb, 0xf3835a218e9fb262, 0, 140 }, /* #54 */
    { 0x0207c7, 0x020fc6, 0x4c4f3835a218e9fb, 0xf3835a218e9fba62, 0, 140 }, /* #54 b */
    { 0x293a02, 0x293203, 0xe0942668be556e0f, 0x6e0f704a13345f2a, 0, 176 }, /* #55 */
    { 0x1645d7, 0x1645d7, 0xe0942668be556e0f, 0x6e0ff04a13345f2a, 0, 176 }, /* #55 b */
    { 0x0148d6, 0x0148d7, 0x6bfb8d3894b65fbd, 0xdc69c4a5b2fde9af, 0, 203 }, /* #56 */
    { 0x3e3703, 0x3e3f03, 0x6bfb8d3894b65fbd, 0xdc69c4a5b2fdedaf, 0, 203 }, /* #56 b */
    { 0x093642, 0x093e43, 0x47dfa06e31073ff6, 0xf623efd03718839f, 0, 120 }, /* #57 */
    { 0x364997, 0x364997, 0x47dfa06e31073ff6, 0xf6a3efd03718839f, 0, 120 }, /* #57 b */
    { 0x230816, 0x230816, 0x76dedee2918c4c80, 0x00edbdbdc5231899, 0, 250 }, /* #58 */
    { 0x1c77c3, 0x1c7fc2, 0x76dedee2918c4c80, 0x02edbdbdc5231899, 0, 250 }, /* #58 b */
    { 0x2a2b52, 0x2a2b53, 0xb9e48b79faf6ff89, 0xebdbfe2573c916f3, 0, 98 }, /* #59 */
    { 0x155487, 0x155c87, 0xb9e48b79faf6ff89, 0xebdbfe2773c916f3, 0, 98 }, /* #59 b */
    { 0x150742, 0x150f42, 0x9eb2bab9982f7d20, 0x13d657573305efa4, 0, 126 }, /* #60 */
    { 0x2a7897, 0x2a7896, 0x9eb2bab9982f7d20, 0x33d657573305efa4, 0, 126 }, /* #60 b */
    { 0x361d82, 0x361583, 0x1c62c30c613d00d6, 0x84f4035838c58618, 0, 162 }, /* #61 */
    { 0x096257, 0x096257, 0x1c62c30c613d00d6, 0x84f4035a38c58618, 0, 162 }, /* #61 b */
    { 0x190892, 0x190892, 0x5e46a2b497f76338, 0xbfbb19c1791a8ad2, 0, 163 }, /* #62 */
    { 0x267747, 0x267f46, 0x5e46a2b497f76338, 0xbfbb19c5791a8ad2, 0, 163 }, /* #62 b */
    { 0x3f3e92, 0x3f3e92, 0x57d39e3d52a53a6b, 0x6b2be9cf1ea9529d, 0, 184 }, /* #63 */
    { 0x004147, 0x004946, 0x57d39e3d52a53a6b, 0x6babe9cf1ea9529d, 0, 184 }, /* #63 b */
    { 0x2c1442, 0x2c1c43, 0x44e8f8eacd8d815f, 0x3a3e3ab3636057c8, 0, 198 }, /* #64 */
    { 0x136b97, 0x136b97, 0x44e8f8eacd8d815f, 0x3a3e3ab3636057e8, 0, 198 }, /* #64 b */
    { 0x345d86, 0x345586, 0x146abbc86187c6f7, 0xd57790c30f8dee14, 0, 73 }, /* #65 */
    { 0x0b2253, 0x0b2252, 0x146abbc86187c6f7, 0xd57790c30f8def14, 0, 73 }, /* #65 b */
    { 0x371f86, 0x371786, 0x29fd9273a839e401, 0x453fb24e75073c80, 0, 254 }, /* #66 */
    { 0x086053, 0x086052, 0x29fd9273a839e401, 0x653fb24e75073c80, 0, 254 }, /* #66 b */
    { 0x3c3787, 0x3c3787, 0xc84075fa377f8cb8, 0x1c84075fa377f8cb, 0, 253 }, /* #67 */
    { 0x034852, 0x034053, 0xc84075fa377f8cb8, 0x0c84075fa377f8cb, 0, 253 }, /* #67 b */
    { 0x3264d6, 0x326cd6, 0x4f681a0fdc585553, 0xaa993da0683f7161, 0, 51 }, /* #68 */
    { 0x0d1b03, 0x0d1b02, 0x4f681a0fdc585553, 0xaa9d3da0683f7161, 0, 51 }, /* #68 b */
    { 0x283713, 0x283713, 0xf56e2b0f613e4274, 0xc561ec27c84e9f56, 0, 205 }, /* #69 */
    { 0x1748c6, 0x1740c7, 0xf56e2b0f613e4274, 0xc561ec27c84e8f56, 0, 205 }, /* #69 b */
    { 0x214d93, 0x214592, 0xe34726d921e00506, 0x34726d921e00506f, 0, 4  }, /* #70 */
    { 0x1e3246, 0x1e3246, 0xe34726d921e00506, 0x34726d921e005067, 0, 4  }, /* #70 b */
    { 0x245e17, 0x245e17, 0x751866976a8034b4, 0xb5401a5a5d4619a5, 0, 31 }, /* #71 */
    { 0x1b21c2, 0x1b29c3, 0x751866976a8034b4, 0xb5401a5a1d4619a5, 0, 31 }, /* #71 b */
    { 0x326c57, 0x326456, 0x080076e7ab3d9532, 0x003b73d59eca9942, 0, 199 }, /* #72 */
    { 0x0d1382, 0x0d1382, 0x080076e7ab3d9532, 0x003b73d59eca9902, 0, 199 }, /* #72 b */
    { 0x167653, 0x167e52, 0xa26f3ba02fed35f3, 0x80bfb4d7cf44de77, 0, 218 }, /* #73 */
    { 0x290986, 0x290986, 0xa26f3ba02fed35f3, 0x80bfb4d7cd44de77, 0, 218 }, /* #73 b */
    { 0x270a53, 0x270a53, 0xa773bdcff6638e50, 0x3b9dee7fb31c7286, 0, 131 }, /* #74 */
    { 0x187586, 0x187d87, 0xa773bdcff6638e50, 0x3b9dee7fb31c7282, 0, 131 }, /* #74 b */
    { 0x282292, 0x282293, 0x1d2e692d0b9f4331, 0x7349685cfa198874, 0, 11 }, /* #75 */
    { 0x175d47, 0x175547, 0x1d2e692d0b9f4331, 0x7349685cfa198c74, 0, 11 }, /* #75 b */
    { 0x2c7792, 0x2c7793, 0xd3e71925dfe5dbfc, 0x76ff1a7ce324bbfc, 0, 174 }, /* #76 */
    { 0x130847, 0x130047, 0xd3e71925dfe5dbfc, 0x76ff3a7ce324bbfc, 0, 174 }, /* #76 b */
    { 0x3e5483, 0x3e5c83, 0x5d6d84d23fe4f4e7, 0x93d39ebadb09a47f, 0, 42 }, /* #77 */
    { 0x012b56, 0x012b57, 0x5d6d84d23fe4f4e7, 0x93d39cbadb09a47f, 0, 42 }, /* #77 b */
    { 0x237782, 0x237f82, 0xa20f6d7c4fa67a61, 0x99e985441edaf89f, 0, 106 }, /* #78 */
    { 0x1c0857, 0x1c0856, 0xa20f6d7c4fa67a61, 0x99e987441edaf89f, 0, 106 }, /* #78 b */
    { 0x0d4813, 0x0d4013, 0xef61b3e7c4060052, 0x67cf880c00a5ef61, 0, 17 }, /* #79 */
    { 0x3237c6, 0x3237c7, 0xef61b3e7c4060052, 0x67cf880c00a4ef61, 0, 17 }, /* #79 b */
    { 0x3246c2, 0x324ec3, 0xb8fa14c5872da761, 0x2da7615c7d0a62c3, 0, 232 }, /* #80 */
    { 0x0d3917, 0x0d3917, 0xb8fa14c5872da761, 0x2da761dc7d0a62c3, 0, 232 }, /* #80 b */
    { 0x342043, 0x342043, 0x27f8e7d2479157a8, 0xf491e455ea24ff1c, 0, 86 }, /* #81 */
    { 0x0b5f96, 0x0b5797, 0x27f8e7d2479157a8, 0xf491e455ea04ff1c, 0, 86 }, /* #81 b */
    { 0x126103, 0x126902, 0x4c6a591e9576f315, 0x352c8f4abb798ad3, 0, 199 }, /* #82 */
    { 0x2d1ed6, 0x2d1ed6, 0x4c6a591e9576f315, 0x352c8f4abb798a93, 0, 199 }, /* #82 b */
    { 0x217bc2, 0x217bc3, 0x75cb136384c9fc0a, 0x0993f81475cb1363, 0, 33 }, /* #83 */
    { 0x1e0417, 0x1e0c17, 0x75cb136384c9fc0a, 0x0993f81575cb1363, 0, 33 }, /* #83 b */
    { 0x2067c7, 0x206fc6, 0xb29af0cf55f822d5, 0x7aafc116aeca6bc3, 0, 27 }, /* #84 */
    { 0x1f1812, 0x1f1812, 0xb29af0cf55f822d5, 0x7aafc116aaca6bc3, 0, 27 }, /* #84 b */
    { 0x0a6c17, 0x0a6416, 0x174176b12ea42c11, 0x2e82ed625d485823, 0, 129 }, /* #85 */
    { 0x3513c2, 0x3513c2, 0x174176b12ea42c11, 0x2e82ed625d485822, 0, 129 }, /* #85 b */
    { 0x150d53, 0x150d52, 0x998e94b2764c96f2, 0x992de5998e94b276, 0, 105 }, /* #86 */
    { 0x2a7286, 0x2a7a86, 0x998e94b2764c96f2, 0x992de4998e94b276, 0, 105 }, /* #86 b */
    { 0x3f4356, 0x3f4356, 0x34f90078f100f00d, 0x201e01a34f90078f, 0, 165 }, /* #87 */
    { 0x003c83, 0x003482, 0x34f90078f100f00d, 0x201e01b34f90078f, 0, 165 }, /* #87 b */
    { 0x331f02, 0x331703, 0xe565afb75474394e, 0xf6ea8e8729ce565a, 0, 21 }, /* #88 */
    { 0x0c60d7, 0x0c60d7, 0xe565afb75474394e, 0xf6ea8e8729de565a, 0, 21 }, /* #88 b */
    { 0x111097, 0x111897, 0x69e0b3637dd737d1, 0xdd737d1b4f059b1b, 0, 100 }, /* #89 */
    { 0x2e6f42, 0x2e6f43, 0x69e0b3637dd737d1, 0xdd737d134f059b1b, 0, 100 }, /* #89 b */
    { 0x211416, 0x211c17, 0x63db9d22309a437f, 0x486fe63db9d22309, 0, 173 }, /* #90 */
    { 0x1e6bc3, 0x1e6bc3, 0x63db9d22309a437f, 0x486ff63db9d22309, 0, 173 }, /* #90 b */
    { 0x123757, 0x123f56, 0x95a133be26728c18, 0xc65684cef899ca30, 0, 59 }, /* #91 */
    { 0x2d4882, 0x2d4882, 0x95a133be26728c18, 0xc25684cef899ca30, 0, 59 }, /* #91 b */
    { 0x112593, 0x112d93, 0x819e6002da0703c3, 0xe1e0679800b681c0, 0, 183 }, /* #92 */
    { 0x2e5a46, 0x2e5a47, 0x819e6002da0703c3, 0xe1a0679800b681c0, 0, 183 }, /* #92 b */
    { 0x2a2d06, 0x2a2d06, 0xb0c4703bfa0432bf, 0x381dfd02195fac31, 0, 143 }, /* #93 */
    { 0x1552d3, 0x155ad2, 0xb0c4703bfa0432bf, 0x381dfd02195fec31, 0, 143 }, /* #93 b */
    { 0x187a03, 0x187203, 0x36970e2780014682, 0x46829b4b8713c000, 0, 176 }, /* #94 */
    { 0x2705d6, 0x2705d7, 0x36970e2780014682, 0x46821b4b8713c000, 0, 176 }, /* #94 b */
    { 0x3f6e82, 0x3f6e83, 0x498220f4988db8d0, 0x6e340930441e9311, 0, 174 }, /* #95 */
    { 0x001157, 0x001957, 0x498220f4988db8d0, 0x6e342930441e9311, 0, 174 }, /* #95 b */
};
uint32_t const g_cTests_rcl_u64_intel = RT_ELEMENTS(g_aTests_rcl_u64_intel);

BINU64_TEST_T const g_aTests_rcr_u64_intel[] =
{
    { 0x1e0ad2, 0x1e02d2, 0x0000000000000000, 0x0000000000000000, 0, 68 }, /* #0 */
    { 0x217507, 0x217d06, 0x0000000000000000, 0x1000000000000000, 0, 68 }, /* #0 b */
    { 0x036ec6, 0x0366c6, 0x0000000000000000, 0x0000000000000000, 0, 25 }, /* #1 */
    { 0x3c1113, 0x3c1912, 0x0000000000000000, 0x0000008000000000, 0, 25 }, /* #1 b */
    { 0x2e5f83, 0x2e5f82, 0x0000000000000000, 0x0080000000000000, 0, 9  }, /* #2 */
    { 0x112056, 0x112056, 0x0000000000000000, 0x0000000000000000, 0, 9  }, /* #2 b */
    { 0x1652d7, 0x165ad6, 0x0000000000000000, 0x0000004000000000, 0, 154 }, /* #3 */
    { 0x292d02, 0x292502, 0x0000000000000000, 0x0000000000000000, 0, 154 }, /* #3 b */
    { 0x335b17, 0x335b16, 0x0000000000000000, 0x0000000000010000, 0, 176 }, /* #4 */
    { 0x0c24c2, 0x0c24c2, 0x0000000000000000, 0x0000000000000000, 0, 176 }, /* #4 b */
    { 0x382643, 0x382e42, 0x0000000000000000, 0x0000200000000000, 0, 83 }, /* #5 */
    { 0x075996, 0x075196, 0x0000000000000000, 0x0000000000000000, 0, 83 }, /* #5 b */
    { 0x2e4112, 0x2e4112, 0x292ba4ec7fb04dfa, 0xfd0a4ae93b1fec13, 0, 202 }, /* #6 */
    { 0x113ec7, 0x113ec6, 0x292ba4ec7fb04dfa, 0xfd4a4ae93b1fec13, 0, 202 }, /* #6 b */
    { 0x2503d2, 0x2503d2, 0x02828a7acebe9340, 0x4d00050514f59d7d, 0, 15 }, /* #7 */
    { 0x1a7c07, 0x1a7c06, 0x02828a7acebe9340, 0x4d02050514f59d7d, 0, 15 }, /* #7 b */
    { 0x253997, 0x253196, 0xb73c4d737bf0c3ef, 0x26b9bdf861f7edcf, 0, 242 }, /* #8 */
    { 0x1a4642, 0x1a4e42, 0xb73c4d737bf0c3ef, 0x26b9bdf861f7adcf, 0, 242 }, /* #8 b */
    { 0x2804d6, 0x2804d6, 0x6f4871f7376f95fb, 0x1c7dcddbe57ecde9, 0, 115 }, /* #9 */
    { 0x177b03, 0x177b02, 0x6f4871f7376f95fb, 0x1c7dcddbe57eede9, 0, 115 }, /* #9 b */
    { 0x0b2d97, 0x0b2596, 0xee8ab86b0b25c772, 0xe3b97ba2ae1ac2c9, 0, 210 }, /* #10 */
    { 0x345242, 0x345a42, 0xee8ab86b0b25c772, 0xe3b93ba2ae1ac2c9, 0, 210 }, /* #10 b */
    { 0x040202, 0x040a02, 0xd6189192a78b71e5, 0xc48c953c5b8f2b58, 0, 54 }, /* #11 */
    { 0x3b7dd7, 0x3b75d6, 0xd6189192a78b71e5, 0xc48c953c5b8f2f58, 0, 54 }, /* #11 b */
    { 0x014c86, 0x014486, 0x0e79caa738516b43, 0xa738516b43073ce5, 0, 105 }, /* #12 */
    { 0x3e3353, 0x3e3b52, 0x0e79caa738516b43, 0xa738516b43873ce5, 0, 105 }, /* #12 b */
    { 0x0e3292, 0x0e3293, 0x03933e981cf61ad8, 0xad801c99f4c0e7b0, 0, 141 }, /* #13 */
    { 0x314d47, 0x314d47, 0x03933e981cf61ad8, 0xad881c99f4c0e7b0, 0, 141 }, /* #13 b */
    { 0x2157c3, 0x215fc3, 0x5749bf4142022376, 0xaae937e82840446e, 0, 195 }, /* #14 */
    { 0x1e2816, 0x1e2017, 0x5749bf4142022376, 0x8ae937e82840446e, 0, 195 }, /* #14 b */
    { 0x0e2fc7, 0x0e2fc7, 0x58522c77b9d8d3e3, 0x1a7c758522c77b9d, 0, 84 }, /* #15 */
    { 0x315012, 0x315013, 0x58522c77b9d8d3e3, 0x1a7c658522c77b9d, 0, 84 }, /* #15 b */
    { 0x232ac6, 0x232ac7, 0xb3f0922798765234, 0x6523459f84913cc3, 0, 85 }, /* #16 */
    { 0x1c5513, 0x1c5513, 0xb3f0922798765234, 0x65234d9f84913cc3, 0, 85 }, /* #16 b */
    { 0x053453, 0x053c53, 0x1c8d71033c913952, 0x9528e46b8819e489, 0, 77 }, /* #17 */
    { 0x3a4b86, 0x3a4387, 0x1c8d71033c913952, 0x9520e46b8819e489, 0, 77 }, /* #17 b */
    { 0x1a7813, 0x1a7813, 0x2d48921d998a2ed1, 0x8a2ed196a4490ecc, 0, 25 }, /* #18 */
    { 0x2507c6, 0x2507c7, 0x2d48921d998a2ed1, 0x8a2ed116a4490ecc, 0, 25 }, /* #18 b */
    { 0x341312, 0x341b13, 0xba16fe7eafa22c83, 0x7d11641ae85bf9fa, 0, 30 }, /* #19 */
    { 0x0b6cc7, 0x0b64c7, 0xba16fe7eafa22c83, 0x7d11641ee85bf9fa, 0, 30 }, /* #19 b */
    { 0x0f6006, 0x0f6007, 0x4d8a87a7c22cfb65, 0x3e1167db29362a1e, 0, 38 }, /* #20 */
    { 0x301fd3, 0x301fd3, 0x4d8a87a7c22cfb65, 0x3e1167db2d362a1e, 0, 38 }, /* #20 b */
    { 0x367c82, 0x367482, 0x4f525d2b0f8a0cc7, 0xc727a92e9587c506, 0, 137 }, /* #21 */
    { 0x090357, 0x090b56, 0x4f525d2b0f8a0cc7, 0xc7a7a92e9587c506, 0, 137 }, /* #21 b */
    { 0x004186, 0x004987, 0xbe647329c1aa2cfe, 0x3835459fcbe64732, 0, 228 }, /* #22 */
    { 0x3f3e53, 0x3f3653, 0xbe647329c1aa2cfe, 0x3835459fdbe64732, 0, 228 }, /* #22 b */
    { 0x3a4982, 0x3a4182, 0x350a80af1b2ad65b, 0x0578d956b2d8d42a, 0, 174 }, /* #23 */
    { 0x053657, 0x053e56, 0x350a80af1b2ad65b, 0x0578d956b2dcd42a, 0, 174 }, /* #23 b */
    { 0x137b03, 0x137b02, 0x381d504c7c1e11ee, 0x1e11ee9c0ea8263e, 0, 153 }, /* #24 */
    { 0x2c04d6, 0x2c04d6, 0x381d504c7c1e11ee, 0x1e11ee1c0ea8263e, 0, 153 }, /* #24 b */
    { 0x2c3492, 0x2c3c93, 0x96bc56a950e90203, 0xd2040696bc56a950, 0, 152 }, /* #25 */
    { 0x134b47, 0x134347, 0x96bc56a950e90203, 0xd2040796bc56a950, 0, 152 }, /* #25 b */
    { 0x1858d6, 0x1858d6, 0xde21cf43eec8e8f5, 0x7a1f764747ab7887, 0, 174 }, /* #26 */
    { 0x272703, 0x272702, 0xde21cf43eec8e8f5, 0x7a1f764747af7887, 0, 174 }, /* #26 b */
    { 0x057797, 0x057796, 0xadaf79a2946b7a06, 0xb6bde68a51ade81b, 0, 191 }, /* #27 */
    { 0x3a0842, 0x3a0842, 0xadaf79a2946b7a06, 0xb6bde68a51ade819, 0, 191 }, /* #27 b */
    { 0x083b92, 0x083b92, 0xd4f6aa0f70313e3f, 0x1ee0627c7ed4f6aa, 0, 40 }, /* #28 */
    { 0x374447, 0x374446, 0xd4f6aa0f70313e3f, 0x1ee0627c7fd4f6aa, 0, 40 }, /* #28 b */
    { 0x336917, 0x336116, 0xb6ed4d3650770f96, 0x83b87cb6dbb534d9, 0, 158 }, /* #29 */
    { 0x0c16c2, 0x0c1ec2, 0xb6ed4d3650770f96, 0x83b87cb2dbb534d9, 0, 158 }, /* #29 b */
    { 0x030e03, 0x030e02, 0x10de49e2165b6055, 0x8596d815621bc93c, 0, 35 }, /* #30 */
    { 0x3c71d6, 0x3c71d6, 0x10de49e2165b6055, 0x8596d815421bc93c, 0, 35 }, /* #30 b */
    { 0x335b83, 0x335b82, 0x181e322c74ad067e, 0xd067e8c0f19163a5, 0, 149 }, /* #31 */
    { 0x0c2456, 0x0c2456, 0x181e322c74ad067e, 0xd067e0c0f19163a5, 0, 149 }, /* #31 b */
    { 0x0e2652, 0x0e2e53, 0xa0f91ba882495c98, 0x10492b930a0f91ba, 0, 164 }, /* #32 */
    { 0x315987, 0x315187, 0xa0f91ba882495c98, 0x10492b931a0f91ba, 0, 164 }, /* #32 b */
    { 0x351082, 0x351882, 0xc49336b5e072f153, 0xbc0e5e2a6c49336b, 0, 36 }, /* #33 */
    { 0x0a6f57, 0x0a6756, 0xc49336b5e072f153, 0xbc0e5e2a7c49336b, 0, 36 }, /* #33 b */
    { 0x381202, 0x381203, 0x7732d6fe227d7dc7, 0x9dccb5bf889f5f71, 0, 2  }, /* #34 */
    { 0x076dd7, 0x076dd7, 0x7732d6fe227d7dc7, 0xddccb5bf889f5f71, 0, 2  }, /* #34 b */
    { 0x237816, 0x237817, 0x995aada8e8135e7c, 0x5e7c4cad56d47409, 0, 17 }, /* #35 */
    { 0x1c07c3, 0x1c07c3, 0x995aada8e8135e7c, 0x5e7cccad56d47409, 0, 17 }, /* #35 b */
    { 0x0c6816, 0x0c6816, 0xc1994a1a7685605d, 0xca50d3b42b02eb06, 0, 54 }, /* #36 */
    { 0x3317c3, 0x3317c2, 0xc1994a1a7685605d, 0xca50d3b42b02ef06, 0, 54 }, /* #36 b */
    { 0x087bd2, 0x087bd3, 0xbe769a1973936a19, 0xe769a1973936a195, 0, 61 }, /* #37 */
    { 0x370407, 0x370407, 0xbe769a1973936a19, 0xe769a1973936a19d, 0, 61 }, /* #37 b */
    { 0x3b7943, 0x3b7942, 0x6492a580ff5f9578, 0x54b01febf2af1649, 0, 180 }, /* #38 */
    { 0x040696, 0x040696, 0x6492a580ff5f9578, 0x54b01febf2af0649, 0, 180 }, /* #38 b */
    { 0x144403, 0x144c03, 0x6de11a56a128309a, 0x08d2b5094184d5b7, 0, 182 }, /* #39 */
    { 0x2b3bd6, 0x2b33d7, 0x6de11a56a128309a, 0x08d2b5094184d1b7, 0, 182 }, /* #39 b */
    { 0x231307, 0x231306, 0xc8b4ab65f28aee4c, 0xf9457726722d2ad9, 0, 34 }, /* #40 */
    { 0x1c6cd2, 0x1c6cd2, 0xc8b4ab65f28aee4c, 0xf9457726322d2ad9, 0, 34 }, /* #40 b */
    { 0x3c4b03, 0x3c4b02, 0x5595539577b23ccd, 0xf64799b559553957, 0, 156 }, /* #41 */
    { 0x0334d6, 0x0334d6, 0x5595539577b23ccd, 0xf64799a559553957, 0, 156 }, /* #41 b */
    { 0x004393, 0x004b93, 0x08a5cd41ce93d949, 0xa4f6526114b9a839, 0, 91 }, /* #42 */
    { 0x3f3c46, 0x3f3447, 0x08a5cd41ce93d949, 0xa4f6524114b9a839, 0, 91 }, /* #42 b */
    { 0x2519d3, 0x2519d2, 0x2a128fc02c837da4, 0x0b20df69254251f8, 0, 99 }, /* #43 */
    { 0x1a6606, 0x1a6606, 0x2a128fc02c837da4, 0x0b20df69054251f8, 0, 99 }, /* #43 b */
    { 0x2d0d46, 0x2d0547, 0x5e7fc365cb2ab0bd, 0x0bd2f3fe1b2e5955, 0, 141 }, /* #44 */
    { 0x127293, 0x127a93, 0x5e7fc365cb2ab0bd, 0x0bdaf3fe1b2e5955, 0, 141 }, /* #44 b */
    { 0x173fd2, 0x173fd3, 0xd51512edd0647252, 0x6e8323929354544b, 0, 166 }, /* #45 */
    { 0x284007, 0x284007, 0xd51512edd0647252, 0x6e8323929754544b, 0, 166 }, /* #45 b */
    { 0x1a1583, 0x1a1583, 0xbd602e43c76a2b94, 0xbd602e43c76a2b94, 0, 128 }, /* #46 */
    { 0x256a56, 0x256a56, 0xbd602e43c76a2b94, 0xbd602e43c76a2b94, 0, 128 }, /* #46 b */
    { 0x180612, 0x180612, 0x52b18011e12715ee, 0x4e2bdc52b18011e1, 0, 88 }, /* #47 */
    { 0x2779c7, 0x2779c6, 0x52b18011e12715ee, 0x4e2bdd52b18011e1, 0, 88 }, /* #47 b */
    { 0x2c5fc3, 0x2c57c3, 0xabd19ea309c3a50c, 0x0e943357a33d4613, 0, 87 }, /* #48 */
    { 0x132016, 0x132817, 0xabd19ea309c3a50c, 0x0e943157a33d4613, 0, 87 }, /* #48 b */
    { 0x334903, 0x334102, 0x9046095654f43d80, 0x2304ab2a7a1ec064, 0, 186 }, /* #49 */
    { 0x0c36d6, 0x0c3ed6, 0x9046095654f43d80, 0x2304ab2a7a1ec024, 0, 186 }, /* #49 b */
    { 0x387f56, 0x387756, 0x7d69d850e10c9cd2, 0x7348fad3b0a1c219, 0, 15 }, /* #50 */
    { 0x070083, 0x070882, 0x7d69d850e10c9cd2, 0x734afad3b0a1c219, 0, 15 }, /* #50 b */
    { 0x224386, 0x224b87, 0x97c9f00ed3a6c86c, 0xe01da74d90d897c9, 0, 112 }, /* #51 */
    { 0x1d3c53, 0x1d3453, 0x97c9f00ed3a6c86c, 0xe01da74d90d997c9, 0, 112 }, /* #51 b */
    { 0x0710d6, 0x0710d7, 0x354d346ccac0d182, 0x821aa69a36656068, 0, 9  }, /* #52 */
    { 0x386f03, 0x386f03, 0x354d346ccac0d182, 0x829aa69a36656068, 0, 9  }, /* #52 b */
    { 0x297cd7, 0x2974d6, 0x959b94e11dfeeb46, 0x77fbad1b2b3729c2, 0, 159 }, /* #53 */
    { 0x160302, 0x160b02, 0x959b94e11dfeeb46, 0x77fbad192b3729c2, 0, 159 }, /* #53 b */
    { 0x344947, 0x344947, 0x485696abdf667a8b, 0xefb33d45d215a5aa, 0, 226 }, /* #54 */
    { 0x0b3692, 0x0b3693, 0x485696abdf667a8b, 0xefb33d459215a5aa, 0, 226 }, /* #54 b */
    { 0x006513, 0x006d13, 0x47e367ea840a034b, 0xf5420501a5d1f8d9, 0, 234 }, /* #55 */
    { 0x3f1ac6, 0x3f12c7, 0x47e367ea840a034b, 0xf5420501a591f8d9, 0, 234 }, /* #55 b */
    { 0x002e17, 0x002616, 0xf27a584a131be21b, 0x637c437f27a584a1, 0, 28 }, /* #56 */
    { 0x3f51c2, 0x3f59c2, 0xf27a584a131be21b, 0x637c436f27a584a1, 0, 28 }, /* #56 b */
    { 0x2c1842, 0x2c1842, 0xf2821686f2491ff4, 0x5042d0de4923fe8f, 0, 124 }, /* #57 */
    { 0x136797, 0x136796, 0xf2821686f2491ff4, 0x5042d0de4923fe9f, 0, 124 }, /* #57 b */
    { 0x115403, 0x115402, 0xef2d1dbddd8dca1d, 0xdca1df7968edeeec, 0, 85 }, /* #58 */
    { 0x2e2bd6, 0x2e2bd6, 0xef2d1dbddd8dca1d, 0xdca1d77968edeeec, 0, 85 }, /* #58 b */
    { 0x312947, 0x312147, 0xbbad602e7dc287a9, 0xd6b0173ee143d4ee, 0, 122 }, /* #59 */
    { 0x0e5692, 0x0e5e93, 0xbbad602e7dc287a9, 0xd6b0173ee143d4ae, 0, 122 }, /* #59 b */
    { 0x141302, 0x141b03, 0xc892a4de07d9b3da, 0x03ecd9ed3224a937, 0, 34 }, /* #60 */
    { 0x2b6cd7, 0x2b64d7, 0xc892a4de07d9b3da, 0x03ecd9ed7224a937, 0, 34 }, /* #60 b */
    { 0x032ad6, 0x032ad6, 0xabf93b70353cf7e2, 0xabf93b70353cf7e2, 0, 0  }, /* #61 */
    { 0x3c5503, 0x3c5503, 0xabf93b70353cf7e2, 0xabf93b70353cf7e2, 0, 0  }, /* #61 b */
    { 0x0f5b46, 0x0f5b46, 0x91d02e52272dbaed, 0x740b9489cb6ebb52, 0, 59 }, /* #62 */
    { 0x302493, 0x302492, 0x91d02e52272dbaed, 0x740b9489cb6ebb72, 0, 59 }, /* #62 b */
    { 0x2e2616, 0x2e2e17, 0x8c00684c70f72c38, 0x846003426387b961, 0, 133 }, /* #63 */
    { 0x1159c3, 0x1151c3, 0x8c00684c70f72c38, 0x8c6003426387b961, 0, 133 }, /* #63 b */
    { 0x143a46, 0x143a47, 0xdbda25f1e4fb2077, 0x6ded12f8f27d903b, 0, 65 }, /* #64 */
    { 0x2b4593, 0x2b4593, 0xdbda25f1e4fb2077, 0xeded12f8f27d903b, 0, 65 }, /* #64 b */
    { 0x334d07, 0x334506, 0xee9a0bcb8c381311, 0x1c0988fba682f2e3, 0, 154 }, /* #65 */
    { 0x0c32d2, 0x0c3ad2, 0xee9a0bcb8c381311, 0x1c0988bba682f2e3, 0, 154 }, /* #65 b */
    { 0x160102, 0x160102, 0xb878aa11762002d6, 0xb878aa11762002d6, 0, 192 }, /* #66 */
    { 0x297ed7, 0x297ed7, 0xb878aa11762002d6, 0xb878aa11762002d6, 0, 192 }, /* #66 b */
    { 0x1f6002, 0x1f6003, 0x3b047949c46bfaa9, 0x047949c46bfaa91d, 0, 185 }, /* #67 */
    { 0x201fd7, 0x201fd7, 0x3b047949c46bfaa9, 0x047949c46bfaa99d, 0, 185 }, /* #67 b */
    { 0x2c2402, 0x2c2c02, 0x9b501b7fb194f51f, 0x7a8fa6d406dfec65, 0, 146 }, /* #68 */
    { 0x135bd7, 0x1353d6, 0x9b501b7fb194f51f, 0x7a8fe6d406dfec65, 0, 146 }, /* #68 b */
    { 0x184546, 0x184d46, 0xeaae639c765ef43d, 0xb98e71d97bd0f5d5, 0, 55 }, /* #69 */
    { 0x273a93, 0x273292, 0xeaae639c765ef43d, 0xb98e71d97bd0f7d5, 0, 55 }, /* #69 b */
    { 0x1906d7, 0x1906d6, 0xa1fa1c648349d2c7, 0xfa1fa1c648349d2c, 0, 196 }, /* #70 */
    { 0x267902, 0x267902, 0xa1fa1c648349d2c7, 0xea1fa1c648349d2c, 0, 196 }, /* #70 b */
    { 0x1d7952, 0x1d7952, 0x9973c2c2209436eb, 0x88250dbad32e7858, 0, 99 }, /* #71 */
    { 0x220687, 0x220686, 0x9973c2c2209436eb, 0x88250dbaf32e7858, 0, 99 }, /* #71 b */
    { 0x235203, 0x235202, 0xd8a292082b9a5ea7, 0xbd4fd8a292082b9a, 0, 208 }, /* #72 */
    { 0x1c2dd6, 0x1c2dd6, 0xd8a292082b9a5ea7, 0xbd4ed8a292082b9a, 0, 208 }, /* #72 b */
    { 0x3272c6, 0x327ac6, 0xd2644533cc8f5735, 0x6ad2644533cc8f57, 0, 136 }, /* #73 */
    { 0x0d0d13, 0x0d0512, 0xd2644533cc8f5735, 0x6bd2644533cc8f57, 0, 136 }, /* #73 b */
    { 0x2e6cd7, 0x2e64d6, 0x8570c87bbbdf4dee, 0xc87bbbdf4deec2b8, 0, 49 }, /* #74 */
    { 0x111302, 0x111b02, 0x8570c87bbbdf4dee, 0xc87bbbdf4dee42b8, 0, 49 }, /* #74 b */
    { 0x3c6913, 0x3c6912, 0x74804398c928c3ec, 0xa30fb2e900873192, 0, 23 }, /* #75 */
    { 0x0316c6, 0x0316c6, 0x74804398c928c3ec, 0xa30fb0e900873192, 0, 23 }, /* #75 b */
    { 0x384e12, 0x384613, 0x734a2f190ef03630, 0x8c0e6945e321de06, 0, 203 }, /* #76 */
    { 0x0731c7, 0x0739c7, 0x734a2f190ef03630, 0x8c2e6945e321de06, 0, 203 }, /* #76 b */
    { 0x031803, 0x031802, 0x23f2ec753a326567, 0xea7464cacf23f2ec, 0, 104 }, /* #77 */
    { 0x3c67d6, 0x3c67d6, 0x23f2ec753a326567, 0xea7464cace23f2ec, 0, 104 }, /* #77 b */
    { 0x031e07, 0x031607, 0x87b5f6fc2f509ae5, 0xe17a84d72e1ed7db, 0, 166 }, /* #78 */
    { 0x3c61d2, 0x3c69d3, 0x87b5f6fc2f509ae5, 0xe17a84d72a1ed7db, 0, 166 }, /* #78 b */
    { 0x162487, 0x162c86, 0x28410b98a43ebf35, 0x410b98a43ebf3594, 0, 121 }, /* #79 */
    { 0x295b52, 0x295352, 0x28410b98a43ebf35, 0x410b98a43ebf3514, 0, 121 }, /* #79 b */
    { 0x0e1646, 0x0e1e46, 0xf0ea299f9ba18acb, 0x2b2de1d4533f3743, 0, 207 }, /* #80 */
    { 0x316993, 0x316192, 0xf0ea299f9ba18acb, 0x2b2fe1d4533f3743, 0, 207 }, /* #80 b */
    { 0x164697, 0x164e96, 0x6335e81060efaea1, 0x083077d750d8cd7a, 0, 42 }, /* #81 */
    { 0x293942, 0x293142, 0x6335e81060efaea1, 0x083077d75098cd7a, 0, 42 }, /* #81 b */
    { 0x125346, 0x125346, 0x06ec48e8cdad60f3, 0xcdad60f303762474, 0, 225 }, /* #82 */
    { 0x2d2c93, 0x2d2c92, 0x06ec48e8cdad60f3, 0xcdad60f383762474, 0, 225 }, /* #82 b */
    { 0x0d1bc2, 0x0d13c3, 0x36519c0b3544e8de, 0xaa2746f0d946702c, 0, 30 }, /* #83 */
    { 0x326417, 0x326c17, 0x36519c0b3544e8de, 0xaa2746f4d946702c, 0, 30 }, /* #83 b */
    { 0x007713, 0x007712, 0xc1c38f0147b893e4, 0xe3c051ee24f93838, 0, 51 }, /* #84 */
    { 0x3f08c6, 0x3f08c6, 0xc1c38f0147b893e4, 0xe3c051ee24f91838, 0, 51 }, /* #84 b */
    { 0x223d96, 0x223596, 0x51b01bd6d83b53a6, 0x28d80deb6c1da9d3, 0, 129 }, /* #85 */
    { 0x1d4243, 0x1d4a42, 0x51b01bd6d83b53a6, 0xa8d80deb6c1da9d3, 0, 129 }, /* #85 b */
    { 0x3f32d3, 0x3f3ad2, 0x3aaff3550b31484f, 0x2909f3aaff3550b3, 0, 20 }, /* #86 */
    { 0x004d06, 0x004506, 0x3aaff3550b31484f, 0x2909e3aaff3550b3, 0, 20 }, /* #86 b */
    { 0x1e0086, 0x1e0087, 0x2062b8491dfc31d7, 0x10315c248efe18eb, 0, 65 }, /* #87 */
    { 0x217f53, 0x217f53, 0x2062b8491dfc31d7, 0x90315c248efe18eb, 0, 65 }, /* #87 b */
    { 0x0b00d7, 0x0b08d6, 0x681dcfad204a38a5, 0x52da0773eb48128e, 0, 202 }, /* #88 */
    { 0x347f02, 0x347702, 0x681dcfad204a38a5, 0x529a0773eb48128e, 0, 202 }, /* #88 b */
    { 0x310553, 0x310553, 0xace27b72302faf8b, 0xe2f59c4f6e4605f5, 0, 203 }, /* #89 */
    { 0x0e7a86, 0x0e7a87, 0xace27b72302faf8b, 0xe2d59c4f6e4605f5, 0, 203 }, /* #89 b */
    { 0x136643, 0x136643, 0xad70ea5252adf18c, 0xc3a9494ab7c6335a, 0, 247 }, /* #90 */
    { 0x2c1996, 0x2c1997, 0xad70ea5252adf18c, 0xc3a9494ab7c6315a, 0, 247 }, /* #90 b */
    { 0x2b6192, 0x2b6993, 0xe6a6029b114011da, 0x1da7353014d88a00, 0, 13 }, /* #91 */
    { 0x141e47, 0x141647, 0xe6a6029b114011da, 0x1daf353014d88a00, 0, 13 }, /* #91 b */
    { 0x153dc7, 0x153dc6, 0x52e26d7594ccf83f, 0xe26d7594ccf83fa9, 0, 249 }, /* #92 */
    { 0x2a4212, 0x2a4212, 0x52e26d7594ccf83f, 0xe26d7594ccf83f29, 0, 249 }, /* #92 b */
    { 0x0b1d93, 0x0b1d92, 0x2b8c9319b609e9df, 0x98cdb04f4efcae32, 0, 46 }, /* #93 */
    { 0x346246, 0x346246, 0x2b8c9319b609e9df, 0x98cdb04f4ef8ae32, 0, 46 }, /* #93 b */
    { 0x103302, 0x103303, 0x7e3c404a33095c70, 0x46612b8e07e3c404, 0, 100 }, /* #94 */
    { 0x2f4cd7, 0x2f4cd7, 0x7e3c404a33095c70, 0x46612b8e17e3c404, 0, 100 }, /* #94 b */
    { 0x2462d2, 0x2462d3, 0x2f8215f13d91e16b, 0x0af89ec8f0b58be0, 0, 50 }, /* #95 */
    { 0x1b1d07, 0x1b1d07, 0x2f8215f13d91e16b, 0x0af89ec8f0b5cbe0, 0, 50 }, /* #95 b */
};
uint32_t const g_cTests_rcr_u64_intel = RT_ELEMENTS(g_aTests_rcr_u64_intel);

BINU64_TEST_T const g_aTests_shl_u64_intel[] =
{
    { 0x2b4b16, 0x2b4346, 0x0000000000000000, 0x0000000000000000, 0, 59 }, /* #0 */
    { 0x1434c3, 0x143446, 0x0000000000000000, 0x0000000000000000, 0, 59 }, /* #0 b */
    { 0x374482, 0x374446, 0x0000000000000000, 0x0000000000000000, 0, 41 }, /* #1 */
    { 0x083b57, 0x083346, 0x0000000000000000, 0x0000000000000000, 0, 41 }, /* #1 b */
    { 0x141c42, 0x141446, 0x0000000000000000, 0x0000000000000000, 0, 197 }, /* #2 */
    { 0x2b6397, 0x2b6346, 0x0000000000000000, 0x0000000000000000, 0, 197 }, /* #2 b */
    { 0x032d03, 0x032546, 0x0000000000000000, 0x0000000000000000, 0, 37 }, /* #3 */
    { 0x3c52d6, 0x3c5246, 0x0000000000000000, 0x0000000000000000, 0, 37 }, /* #3 b */
    { 0x2c4316, 0x2c4346, 0x0000000000000000, 0x0000000000000000, 0, 226 }, /* #4 */
    { 0x133cc3, 0x133446, 0x0000000000000000, 0x0000000000000000, 0, 226 }, /* #4 b */
    { 0x1d5002, 0x1d5046, 0x0000000000000000, 0x0000000000000000, 0, 209 }, /* #5 */
    { 0x222fd7, 0x222746, 0x0000000000000000, 0x0000000000000000, 0, 209 }, /* #5 b */
    { 0x1f6717, 0x1f6f07, 0x7d985719fb3be247, 0x19fb3be247000000, 0, 24 }, /* #6 */
    { 0x2018c2, 0x201807, 0x7d985719fb3be247, 0x19fb3be247000000, 0, 24 }, /* #6 b */
    { 0x252343, 0x252b87, 0x78bff9cccf8284be, 0xcccf8284be000000, 0, 88 }, /* #7 */
    { 0x1a5c96, 0x1a5c87, 0x78bff9cccf8284be, 0xcccf8284be000000, 0, 88 }, /* #7 b */
    { 0x0f6e47, 0x0f6606, 0xc96f3d4bbca4ec2e, 0x7617000000000000, 0, 239 }, /* #8 */
    { 0x301192, 0x301106, 0xc96f3d4bbca4ec2e, 0x7617000000000000, 0, 239 }, /* #8 b */
    { 0x384253, 0x384a86, 0x9ec5d34620faa950, 0xe9a3107d54a80000, 0, 15 }, /* #9 */
    { 0x073d86, 0x073d86, 0x9ec5d34620faa950, 0xe9a3107d54a80000, 0, 15 }, /* #9 b */
    { 0x147193, 0x147106, 0xf0c6cdc90382c9ee, 0x6e481c164f700000, 0, 211 }, /* #10 */
    { 0x2b0e46, 0x2b0606, 0xf0c6cdc90382c9ee, 0x6e481c164f700000, 0, 211 }, /* #10 b */
    { 0x0c7952, 0x0c7986, 0x45a8576fa9b1a575, 0xaea0000000000000, 0, 245 }, /* #11 */
    { 0x330687, 0x330e86, 0x45a8576fa9b1a575, 0xaea0000000000000, 0, 245 }, /* #11 b */
    { 0x134156, 0x134186, 0xf4df154ec122e5ca, 0xe5ca000000000000, 0, 240 }, /* #12 */
    { 0x2c3e83, 0x2c3686, 0xf4df154ec122e5ca, 0xe5ca000000000000, 0, 240 }, /* #12 b */
    { 0x196203, 0x196a06, 0x7916884481e32750, 0x7500000000000000, 0, 244 }, /* #13 */
    { 0x261dd6, 0x261d06, 0x7916884481e32750, 0x7500000000000000, 0, 244 }, /* #13 b */
    { 0x216957, 0x216186, 0xc4206a9d2dbfa51c, 0xb6fe947000000000, 0, 34 }, /* #14 */
    { 0x1e1682, 0x1e1686, 0xc4206a9d2dbfa51c, 0xb6fe947000000000, 0, 34 }, /* #14 b */
    { 0x0a1247, 0x0a1206, 0xc821311e9184f70a, 0x7a4613dc28000000, 0, 90 }, /* #15 */
    { 0x356d92, 0x356506, 0xc821311e9184f70a, 0x7a4613dc28000000, 0, 90 }, /* #15 b */
    { 0x023f07, 0x023f86, 0x440bf82a9f6a22be, 0x9f6a22be00000000, 0, 160 }, /* #16 */
    { 0x3d40d2, 0x3d4886, 0x440bf82a9f6a22be, 0x9f6a22be00000000, 0, 160 }, /* #16 b */
    { 0x003cd2, 0x003c86, 0x46d41a1f6ebcb607, 0xf2d81c0000000000, 0, 170 }, /* #17 */
    { 0x3f4307, 0x3f4b86, 0x46d41a1f6ebcb607, 0xf2d81c0000000000, 0, 170 }, /* #17 b */
    { 0x097a97, 0x097a86, 0x7ec5dff0caf35c08, 0x8000000000000000, 0, 252 }, /* #18 */
    { 0x360542, 0x360d86, 0x7ec5dff0caf35c08, 0x8000000000000000, 0, 252 }, /* #18 b */
    { 0x194617, 0x194e07, 0x54304a0538149da1, 0x49da100000000000, 0, 172 }, /* #19 */
    { 0x2639c2, 0x263907, 0x54304a0538149da1, 0x49da100000000000, 0, 172 }, /* #19 b */
    { 0x3d4bd6, 0x3d4387, 0xf6e1085a779489fe, 0xc210b4ef2913fc00, 0, 73 }, /* #20 */
    { 0x023403, 0x023487, 0xf6e1085a779489fe, 0xc210b4ef2913fc00, 0, 73 }, /* #20 b */
    { 0x1b5117, 0x1b5906, 0x45a3e3497fa50d08, 0x3e3497fa50d08000, 0, 76 }, /* #21 */
    { 0x242ec2, 0x242e06, 0x45a3e3497fa50d08, 0x3e3497fa50d08000, 0, 76 }, /* #21 b */
    { 0x3a39d6, 0x3a3186, 0x0a5d67e3bddef9c6, 0xb3f1deef7ce30000, 0, 143 }, /* #22 */
    { 0x054603, 0x054686, 0x0a5d67e3bddef9c6, 0xb3f1deef7ce30000, 0, 143 }, /* #22 b */
    { 0x3f2d03, 0x3f2d86, 0x74b479c24b82bc5e, 0x92e0af1780000000, 0, 158 }, /* #23 */
    { 0x0052d6, 0x005a86, 0x74b479c24b82bc5e, 0x92e0af1780000000, 0, 158 }, /* #23 b */
    { 0x2601c3, 0x260986, 0x4f2b8586a562fef6, 0xfef6000000000000, 0, 112 }, /* #24 */
    { 0x197e16, 0x197e86, 0x4f2b8586a562fef6, 0xfef6000000000000, 0, 112 }, /* #24 b */
    { 0x061012, 0x061006, 0xc783cb623bd5331b, 0x23bd5331b0000000, 0, 28 }, /* #25 */
    { 0x396fc7, 0x396706, 0xc783cb623bd5331b, 0x23bd5331b0000000, 0, 28 }, /* #25 b */
    { 0x364707, 0x364707, 0x250d943bea0a9883, 0x3106000000000000, 0, 241 }, /* #26 */
    { 0x0938d2, 0x093007, 0x250d943bea0a9883, 0x3106000000000000, 0, 241 }, /* #26 b */
    { 0x195082, 0x195803, 0x6a27c7c26790dabf, 0x513e3e133c86d5f8, 0, 195 }, /* #27 */
    { 0x262f57, 0x262f03, 0x6a27c7c26790dabf, 0x513e3e133c86d5f8, 0, 195 }, /* #27 b */
    { 0x3b59d3, 0x3b5186, 0xe732204ad2b05b06, 0xb05b060000000000, 0, 40 }, /* #28 */
    { 0x042606, 0x042686, 0xe732204ad2b05b06, 0xb05b060000000000, 0, 40 }, /* #28 b */
    { 0x090f03, 0x090707, 0x2c9ae849a619db91, 0x6e44000000000000, 0, 178 }, /* #29 */
    { 0x3670d6, 0x367007, 0x2c9ae849a619db91, 0x6e44000000000000, 0, 178 }, /* #29 b */
    { 0x304842, 0x304007, 0xef32a8162426067f, 0x02c484c0cfe00000, 0, 21 }, /* #30 */
    { 0x0f3797, 0x0f3707, 0xef32a8162426067f, 0x02c484c0cfe00000, 0, 21 }, /* #30 b */
    { 0x315b47, 0x315307, 0x058a9c59cdc8c9b6, 0x38b39b91936c0000, 0, 145 }, /* #31 */
    { 0x0e2492, 0x0e2407, 0x058a9c59cdc8c9b6, 0x38b39b91936c0000, 0, 145 }, /* #31 b */
    { 0x2a1ac3, 0x2a1a07, 0xad3056c1a627d560, 0x5800000000000000, 0, 54 }, /* #32 */
    { 0x156516, 0x156d07, 0xad3056c1a627d560, 0x5800000000000000, 0, 54 }, /* #32 b */
    { 0x271ad3, 0x271a07, 0x5d51b616794124ce, 0x0493380000000000, 0, 106 }, /* #33 */
    { 0x186506, 0x186d07, 0x5d51b616794124ce, 0x0493380000000000, 0, 106 }, /* #33 b */
    { 0x2f5f43, 0x2f5787, 0xefab6735bd234942, 0xe91a4a1000000000, 0, 163 }, /* #34 */
    { 0x102096, 0x102087, 0xefab6735bd234942, 0xe91a4a1000000000, 0, 163 }, /* #34 b */
    { 0x157406, 0x157406, 0x2b3ac8eceb30aad6, 0x6155ac0000000000, 0, 169 }, /* #35 */
    { 0x2a0bd3, 0x2a0306, 0x2b3ac8eceb30aad6, 0x6155ac0000000000, 0, 169 }, /* #35 b */
    { 0x3f5e83, 0x3f5686, 0x0da04474c44125f5, 0x8111d3110497d400, 0, 10 }, /* #36 */
    { 0x002156, 0x002186, 0x0da04474c44125f5, 0x8111d3110497d400, 0, 10 }, /* #36 b */
    { 0x124f17, 0x124706, 0x3d52c5f365e4a85e, 0x4a85e00000000000, 0, 108 }, /* #37 */
    { 0x2d30c2, 0x2d3006, 0x3d52c5f365e4a85e, 0x4a85e00000000000, 0, 108 }, /* #37 b */
    { 0x295397, 0x295b06, 0x7d69b38f159b0fda, 0x566c3f6800000000, 0, 34 }, /* #38 */
    { 0x162c42, 0x162c06, 0x7d69b38f159b0fda, 0x566c3f6800000000, 0, 34 }, /* #38 b */
    { 0x292902, 0x292183, 0xf3ce435263f3900d, 0x9e721a931f9c8068, 0, 195 }, /* #39 */
    { 0x1656d7, 0x165683, 0xf3ce435263f3900d, 0x9e721a931f9c8068, 0, 195 }, /* #39 b */
    { 0x3822d3, 0x382207, 0x07d462f0552d7de6, 0x1782a96bef300000, 0, 211 }, /* #40 */
    { 0x075d06, 0x075507, 0x07d462f0552d7de6, 0x1782a96bef300000, 0, 211 }, /* #40 b */
    { 0x1e6256, 0x1e6287, 0xc48b2e5bd8716ea0, 0x96f61c5ba8000000, 0, 214 }, /* #41 */
    { 0x211d83, 0x211587, 0xc48b2e5bd8716ea0, 0x96f61c5ba8000000, 0, 214 }, /* #41 b */
    { 0x093343, 0x093b86, 0x4dd06ec644571a82, 0xa080000000000000, 0, 54 }, /* #42 */
    { 0x364c96, 0x364c86, 0x4dd06ec644571a82, 0xa080000000000000, 0, 54 }, /* #42 b */
    { 0x3d1c47, 0x3d1407, 0xf8cad6a56230b6b8, 0x2b1185b5c0000000, 0, 155 }, /* #43 */
    { 0x026392, 0x026307, 0xf8cad6a56230b6b8, 0x2b1185b5c0000000, 0, 155 }, /* #43 b */
    { 0x3249c3, 0x324107, 0xe5cd79a9031e05f7, 0x7000000000000000, 0, 188 }, /* #44 */
    { 0x0d3616, 0x0d3607, 0xe5cd79a9031e05f7, 0x7000000000000000, 0, 188 }, /* #44 b */
    { 0x0c1606, 0x0c1686, 0xec5f9b6a66b58828, 0xa000000000000000, 0, 250 }, /* #45 */
    { 0x3369d3, 0x336186, 0xec5f9b6a66b58828, 0xa000000000000000, 0, 250 }, /* #45 b */
    { 0x016fc3, 0x016783, 0xdf1d77af8480bc54, 0xe3aef5f090178a80, 0, 133 }, /* #46 */
    { 0x3e1016, 0x3e1083, 0xdf1d77af8480bc54, 0xe3aef5f090178a80, 0, 133 }, /* #46 b */
    { 0x0a2452, 0x0a2c87, 0x4f7a0f7d0856a0e1, 0xefa10ad41c200000, 0, 85 }, /* #47 */
    { 0x355b87, 0x355b87, 0x4f7a0f7d0856a0e1, 0xefa10ad41c200000, 0, 85 }, /* #47 b */
    { 0x356046, 0x356806, 0x63630a3cb26635a8, 0x28f2c998d6a00000, 0, 18 }, /* #48 */
    { 0x0a1f93, 0x0a1f06, 0x63630a3cb26635a8, 0x28f2c998d6a00000, 0, 18 }, /* #48 b */
    { 0x287086, 0x287887, 0x7ffe747d12dd75dc, 0xaee0000000000000, 0, 115 }, /* #49 */
    { 0x170f53, 0x170f87, 0x7ffe747d12dd75dc, 0xaee0000000000000, 0, 115 }, /* #49 b */
    { 0x1b13c2, 0x1b1b06, 0x98fe1a0b3dd483c5, 0x7ba9078a00000000, 0, 161 }, /* #50 */
    { 0x246c17, 0x246c06, 0x98fe1a0b3dd483c5, 0x7ba9078a00000000, 0, 161 }, /* #50 b */
    { 0x2d2ac7, 0x2d2286, 0xe6437307777f95b1, 0xeeeff2b620000000, 0, 93 }, /* #51 */
    { 0x125512, 0x125586, 0xe6437307777f95b1, 0xeeeff2b620000000, 0, 93 }, /* #51 b */
    { 0x1877d2, 0x187f06, 0x8adc0dde9bf0c07b, 0x377a6fc301ec0000, 0, 82 }, /* #52 */
    { 0x270807, 0x270806, 0x8adc0dde9bf0c07b, 0x377a6fc301ec0000, 0, 82 }, /* #52 b */
    { 0x297217, 0x297a07, 0x5566b7047c6efaca, 0x4000000000000000, 0, 61 }, /* #53 */
    { 0x160dc2, 0x160d07, 0x5566b7047c6efaca, 0x4000000000000000, 0, 61 }, /* #53 b */
    { 0x3279c6, 0x327187, 0x1113b9147d6eafe3, 0xf8c0000000000000, 0, 118 }, /* #54 */
    { 0x0d0613, 0x0d0687, 0x1113b9147d6eafe3, 0xf8c0000000000000, 0, 118 }, /* #54 b */
    { 0x077146, 0x077187, 0x29c3115afa686f65, 0xb280000000000000, 0, 183 }, /* #55 */
    { 0x380e93, 0x380687, 0x29c3115afa686f65, 0xb280000000000000, 0, 183 }, /* #55 b */
    { 0x331012, 0x331807, 0xb9fa6f70c38305ed, 0x4000000000000000, 0, 190 }, /* #56 */
    { 0x0c6fc7, 0x0c6f07, 0xb9fa6f70c38305ed, 0x4000000000000000, 0, 190 }, /* #56 b */
    { 0x280086, 0x280882, 0x706695597957c7af, 0xe0cd2ab2f2af8f5e, 0, 65 }, /* #57 */
    { 0x177f53, 0x177f82, 0x706695597957c7af, 0xe0cd2ab2f2af8f5e, 0, 65 }, /* #57 b */
    { 0x3c5697, 0x3c5686, 0x1dd27b95972917ab, 0xc000000000000000, 0, 62 }, /* #58 */
    { 0x032942, 0x032186, 0x1dd27b95972917ab, 0xc000000000000000, 0, 62 }, /* #58 b */
    { 0x015bc3, 0x015383, 0xc4f221920da4a915, 0x89e443241b49522a, 0, 65 }, /* #59 */
    { 0x3e2416, 0x3e2483, 0xc4f221920da4a915, 0x89e443241b49522a, 0, 65 }, /* #59 b */
    { 0x1f5847, 0x1f5806, 0x7036c47ca72ee8e3, 0x5397747180000000, 0, 223 }, /* #60 */
    { 0x202792, 0x202f06, 0x7036c47ca72ee8e3, 0x5397747180000000, 0, 223 }, /* #60 b */
    { 0x394792, 0x394f87, 0xbbbea45cc8a3e264, 0x9000000000000000, 0, 122 }, /* #61 */
    { 0x063847, 0x063887, 0xbbbea45cc8a3e264, 0x9000000000000000, 0, 122 }, /* #61 b */
    { 0x1e2747, 0x1e2f06, 0x6de0c0bdf800e1e4, 0x0c0bdf800e1e4000, 0, 76 }, /* #62 */
    { 0x215892, 0x215806, 0x6de0c0bdf800e1e4, 0x0c0bdf800e1e4000, 0, 76 }, /* #62 b */
    { 0x1d5557, 0x1d5d07, 0x473133a12a8ba937, 0x526e000000000000, 0, 177 }, /* #63 */
    { 0x222a82, 0x222a07, 0x473133a12a8ba937, 0x526e000000000000, 0, 177 }, /* #63 b */
    { 0x350a42, 0x350a82, 0x7b1056820fe6b275, 0xc415a083f9ac9d40, 0, 198 }, /* #64 */
    { 0x0a7597, 0x0a7d82, 0x7b1056820fe6b275, 0xc415a083f9ac9d40, 0, 198 }, /* #64 b */
    { 0x1c6306, 0x1c6307, 0x21aea6405fbf595e, 0x3202fdfacaf00000, 0, 211 }, /* #65 */
    { 0x231cd3, 0x231407, 0x21aea6405fbf595e, 0x3202fdfacaf00000, 0, 211 }, /* #65 b */
    { 0x1c2a07, 0x1c2a86, 0x77a6187197ef2fa6, 0xf2fa600000000000, 0, 44 }, /* #66 */
    { 0x2355d2, 0x235d86, 0x77a6187197ef2fa6, 0xf2fa600000000000, 0, 44 }, /* #66 b */
    { 0x136806, 0x136887, 0x7b26cb875b5f8d96, 0x9600000000000000, 0, 120 }, /* #67 */
    { 0x2c17d3, 0x2c1f87, 0x7b26cb875b5f8d96, 0x9600000000000000, 0, 120 }, /* #67 b */
    { 0x045c52, 0x045c06, 0x836c5470f7044684, 0x2000000000000000, 0, 59 }, /* #68 */
    { 0x3b2387, 0x3b2b06, 0x836c5470f7044684, 0x2000000000000000, 0, 59 }, /* #68 b */
    { 0x3977c6, 0x397f87, 0x933c14f149ac673c, 0xac673c0000000000, 0, 168 }, /* #69 */
    { 0x060813, 0x060887, 0x933c14f149ac673c, 0xac673c0000000000, 0, 168 }, /* #69 b */
    { 0x2549d3, 0x254987, 0x452865bb852a40db, 0xdc295206d8000000, 0, 91 }, /* #70 */
    { 0x1a3606, 0x1a3e87, 0x452865bb852a40db, 0xdc295206d8000000, 0, 91 }, /* #70 b */
    { 0x2f3383, 0x2f3383, 0x95d75163a770ab02, 0x95d75163a770ab02, 0, 0  }, /* #71 */
    { 0x104c56, 0x104c56, 0x95d75163a770ab02, 0x95d75163a770ab02, 0, 0  }, /* #71 b */
    { 0x262d82, 0x262d86, 0x43d178c1212973b0, 0xe760000000000000, 0, 177 }, /* #72 */
    { 0x195257, 0x195a86, 0x43d178c1212973b0, 0xe760000000000000, 0, 177 }, /* #72 b */
    { 0x3f3407, 0x3f3407, 0xf110c53701595753, 0x4c00000000000000, 0, 58 }, /* #73 */
    { 0x004bd2, 0x004307, 0xf110c53701595753, 0x4c00000000000000, 0, 58 }, /* #73 b */
    { 0x0650d2, 0x065006, 0xd5674cef678a087d, 0x2821f40000000000, 0, 234 }, /* #74 */
    { 0x392f07, 0x392706, 0xd5674cef678a087d, 0x2821f40000000000, 0, 234 }, /* #74 b */
    { 0x243f07, 0x243f06, 0x561e583c004b2258, 0x7960f0012c896000, 0, 202 }, /* #75 */
    { 0x1b40d2, 0x1b4806, 0x561e583c004b2258, 0x7960f0012c896000, 0, 202 }, /* #75 b */
    { 0x2e3f53, 0x2e3f87, 0x59d472b6388b059b, 0xc4582cd800000000, 0, 35 }, /* #76 */
    { 0x114086, 0x114887, 0x59d472b6388b059b, 0xc4582cd800000000, 0, 35 }, /* #76 b */
    { 0x0b6257, 0x0b6a86, 0x548d76ff783852b4, 0xa46bb7fbc1c295a0, 0, 67 }, /* #77 */
    { 0x341d82, 0x341d86, 0x548d76ff783852b4, 0xa46bb7fbc1c295a0, 0, 67 }, /* #77 b */
    { 0x083fc2, 0x083787, 0xeee0e9f6ef75c5b8, 0xc000000000000000, 0, 123 }, /* #78 */
    { 0x374017, 0x374087, 0xeee0e9f6ef75c5b8, 0xc000000000000000, 0, 123 }, /* #78 b */
    { 0x292c57, 0x292c87, 0xa132cef6c96da971, 0xb25b6a5c40000000, 0, 222 }, /* #79 */
    { 0x165382, 0x165b87, 0xa132cef6c96da971, 0xb25b6a5c40000000, 0, 222 }, /* #79 b */
    { 0x2d1957, 0x2d1107, 0x0579da90d821f7e7, 0x7e70000000000000, 0, 52 }, /* #80 */
    { 0x126682, 0x126607, 0x0579da90d821f7e7, 0x7e70000000000000, 0, 52 }, /* #80 b */
    { 0x245bd2, 0x245b06, 0xa6b0660a18f226ce, 0x3c89b38000000000, 0, 166 }, /* #81 */
    { 0x1b2407, 0x1b2c06, 0xa6b0660a18f226ce, 0x3c89b38000000000, 0, 166 }, /* #81 b */
    { 0x2301d3, 0x230987, 0xb06b732c0491f999, 0xe664000000000000, 0, 178 }, /* #82 */
    { 0x1c7e06, 0x1c7e87, 0xb06b732c0491f999, 0xe664000000000000, 0, 178 }, /* #82 b */
    { 0x1e08d6, 0x1e0087, 0xecff7d1838cfe8a5, 0x9fefa30719fd14a0, 0, 5  }, /* #83 */
    { 0x217703, 0x217787, 0xecff7d1838cfe8a5, 0x9fefa30719fd14a0, 0, 5  }, /* #83 b */
    { 0x137317, 0x137b06, 0xaf8470931b7eb58f, 0x12636fd6b1e00000, 0, 213 }, /* #84 */
    { 0x2c0cc2, 0x2c0c06, 0xaf8470931b7eb58f, 0x12636fd6b1e00000, 0, 213 }, /* #84 b */
    { 0x350696, 0x350e06, 0x42514a7dac85874b, 0x2c3a580000000000, 0, 171 }, /* #85 */
    { 0x0a7943, 0x0a7906, 0x42514a7dac85874b, 0x2c3a580000000000, 0, 171 }, /* #85 b */
    { 0x343ec3, 0x343e87, 0xbb1ac41e885b8890, 0xd10b711200000000, 0, 93 }, /* #86 */
    { 0x0b4116, 0x0b4987, 0xbb1ac41e885b8890, 0xd10b711200000000, 0, 93 }, /* #86 b */
    { 0x057893, 0x057807, 0x8a1ab80bae01a2d2, 0x0175c0345a400000, 0, 85 }, /* #87 */
    { 0x3a0746, 0x3a0f07, 0x8a1ab80bae01a2d2, 0x0175c0345a400000, 0, 85 }, /* #87 b */
    { 0x106652, 0x106e82, 0x69b6d679f88302f4, 0x9b6d679f88302f40, 0, 68 }, /* #88 */
    { 0x2f1987, 0x2f1982, 0x69b6d679f88302f4, 0x9b6d679f88302f40, 0, 68 }, /* #88 b */
    { 0x1e5642, 0x1e5687, 0x053f51e9cdb2749e, 0x8000000000000000, 0, 190 }, /* #89 */
    { 0x212997, 0x212187, 0x053f51e9cdb2749e, 0x8000000000000000, 0, 190 }, /* #89 b */
    { 0x013287, 0x013a87, 0x9ff5c48da6bfa8e8, 0x891b4d7f51d00000, 0, 209 }, /* #90 */
    { 0x3e4d52, 0x3e4d87, 0x9ff5c48da6bfa8e8, 0x891b4d7f51d00000, 0, 209 }, /* #90 b */
    { 0x053543, 0x053506, 0xf103db8d63cad93a, 0x795b274000000000, 0, 37 }, /* #91 */
    { 0x3a4a96, 0x3a4206, 0xf103db8d63cad93a, 0x795b274000000000, 0, 37 }, /* #91 b */
    { 0x2e7902, 0x2e7106, 0xee3954a1faf4a760, 0x3f5e94ec00000000, 0, 157 }, /* #92 */
    { 0x1106d7, 0x110606, 0xee3954a1faf4a760, 0x3f5e94ec00000000, 0, 157 }, /* #92 b */
    { 0x3220c3, 0x322007, 0x199664dce8975dc2, 0x326e744baee10000, 0, 15 }, /* #93 */
    { 0x0d5f16, 0x0d5707, 0x199664dce8975dc2, 0x326e744baee10000, 0, 15 }, /* #93 b */
    { 0x3e10d2, 0x3e1886, 0x4ddd97e92260e92f, 0x9130749780000000, 0, 31 }, /* #94 */
    { 0x016f07, 0x016f86, 0x4ddd97e92260e92f, 0x9130749780000000, 0, 31 }, /* #94 b */
    { 0x0c0557, 0x0c0d07, 0x410cc7981e20772b, 0x5800000000000000, 0, 59 }, /* #95 */
    { 0x337a82, 0x337a07, 0x410cc7981e20772b, 0x5800000000000000, 0, 59 }, /* #95 b */
};
uint32_t const g_cTests_shl_u64_intel = RT_ELEMENTS(g_aTests_shl_u64_intel);

BINU64_TEST_T const g_aTests_shr_u64_intel[] =
{
    { 0x2a1806, 0x2a1046, 0x0000000000000000, 0x0000000000000000, 0, 250 }, /* #0 */
    { 0x1567d3, 0x156746, 0x0000000000000000, 0x0000000000000000, 0, 250 }, /* #0 b */
    { 0x100813, 0x100046, 0x0000000000000000, 0x0000000000000000, 0, 206 }, /* #1 */
    { 0x2f77c6, 0x2f7746, 0x0000000000000000, 0x0000000000000000, 0, 206 }, /* #1 b */
    { 0x225916, 0x225146, 0x0000000000000000, 0x0000000000000000, 0, 171 }, /* #2 */
    { 0x1d26c3, 0x1d2646, 0x0000000000000000, 0x0000000000000000, 0, 171 }, /* #2 b */
    { 0x212b12, 0x212346, 0x0000000000000000, 0x0000000000000000, 0, 57 }, /* #3 */
    { 0x1e54c7, 0x1e5446, 0x0000000000000000, 0x0000000000000000, 0, 57 }, /* #3 b */
    { 0x015702, 0x015746, 0x0000000000000000, 0x0000000000000000, 0, 121 }, /* #4 */
    { 0x3e28d7, 0x3e2046, 0x0000000000000000, 0x0000000000000000, 0, 121 }, /* #4 b */
    { 0x3a2d47, 0x3a2546, 0x0000000000000000, 0x0000000000000000, 0, 48 }, /* #5 */
    { 0x055292, 0x055246, 0x0000000000000000, 0x0000000000000000, 0, 48 }, /* #5 b */
    { 0x206147, 0x206107, 0x48f8e44e3abaf356, 0x0247c72271d5d79a, 0, 69 }, /* #6 */
    { 0x1f1e92, 0x1f1607, 0x48f8e44e3abaf356, 0x0247c72271d5d79a, 0, 69 }, /* #6 b */
    { 0x0823d3, 0x082302, 0x262cdb02668a65e0, 0x0000000000000001, 0, 125 }, /* #7 */
    { 0x375c06, 0x375402, 0x262cdb02668a65e0, 0x0000000000000001, 0, 125 }, /* #7 b */
    { 0x221e96, 0x221607, 0x3f93fa6516d8ccd1, 0x0000000000001fc9, 0, 113 }, /* #8 */
    { 0x1d6143, 0x1d6107, 0x3f93fa6516d8ccd1, 0x0000000000001fc9, 0, 113 }, /* #8 b */
    { 0x3b27d7, 0x3b2f02, 0xdb70b942b433d75f, 0x00001b6e17285686, 0, 83 }, /* #9 */
    { 0x045802, 0x045802, 0xdb70b942b433d75f, 0x00001b6e17285686, 0, 83 }, /* #9 b */
    { 0x244996, 0x244907, 0x8bbe362e28bf431d, 0x000000000000022e, 0, 54 }, /* #10 */
    { 0x1b3643, 0x1b3e07, 0x8bbe362e28bf431d, 0x000000000000022e, 0, 54 }, /* #10 b */
    { 0x222b42, 0x222306, 0x3e6d3093539c1a34, 0x00000007cda6126a, 0, 155 }, /* #11 */
    { 0x1d5497, 0x1d5406, 0x3e6d3093539c1a34, 0x00000007cda6126a, 0, 155 }, /* #11 b */
    { 0x352247, 0x352a07, 0xf15d9aff67e535af, 0x0f15d9aff67e535a, 0, 4  }, /* #12 */
    { 0x0a5d92, 0x0a5d07, 0xf15d9aff67e535af, 0x0f15d9aff67e535a, 0, 4  }, /* #12 b */
    { 0x3622c2, 0x362206, 0x623f2b48b5bc3222, 0x000000000311f95a, 0, 101 }, /* #13 */
    { 0x095d17, 0x095506, 0x623f2b48b5bc3222, 0x000000000311f95a, 0, 101 }, /* #13 b */
    { 0x027396, 0x027b03, 0xd445d2cd3dcb18b2, 0x000000000000001a, 0, 251 }, /* #14 */
    { 0x3d0c43, 0x3d0c03, 0xd445d2cd3dcb18b2, 0x000000000000001a, 0, 251 }, /* #14 b */
    { 0x3e3697, 0x3e3603, 0x7c82493c80f3619c, 0x07c82493c80f3619, 0, 132 }, /* #15 */
    { 0x014942, 0x014103, 0x7c82493c80f3619c, 0x07c82493c80f3619, 0, 132 }, /* #15 b */
    { 0x086393, 0x086303, 0x5679e16798b315c6, 0x0000000000000015, 0, 250 }, /* #16 */
    { 0x371c46, 0x371403, 0x5679e16798b315c6, 0x0000000000000015, 0, 250 }, /* #16 b */
    { 0x384b16, 0x384306, 0x6eca373791759442, 0x000006eca3737917, 0, 84 }, /* #17 */
    { 0x0734c3, 0x073406, 0x6eca373791759442, 0x000006eca3737917, 0, 84 }, /* #17 b */
    { 0x1b5f52, 0x1b5702, 0x3e1176151b80e8e5, 0x00000000000000f8, 0, 54 }, /* #18 */
    { 0x242087, 0x242002, 0x3e1176151b80e8e5, 0x00000000000000f8, 0, 54 }, /* #18 b */
    { 0x0f4512, 0x0f4506, 0x61cac9a92021f3d4, 0x01872b26a48087cf, 0, 198 }, /* #19 */
    { 0x303ac7, 0x303206, 0x61cac9a92021f3d4, 0x01872b26a48087cf, 0, 198 }, /* #19 b */
    { 0x002c16, 0x002402, 0x7aea081ca7170f84, 0x0000000000000f5d, 0, 51 }, /* #20 */
    { 0x3f53c3, 0x3f5302, 0x7aea081ca7170f84, 0x0000000000000f5d, 0, 51 }, /* #20 b */
    { 0x130b43, 0x130b07, 0xc73e04ac51c93663, 0x0000000018e7c095, 0, 163 }, /* #21 */
    { 0x2c7496, 0x2c7c07, 0xc73e04ac51c93663, 0x0000000018e7c095, 0, 163 }, /* #21 b */
    { 0x0d7887, 0x0d7006, 0x2c8efabec2d61f72, 0x000000016477d5f6, 0, 157 }, /* #22 */
    { 0x320752, 0x320706, 0x2c8efabec2d61f72, 0x000000016477d5f6, 0, 157 }, /* #22 b */
    { 0x1f0183, 0x1f0106, 0x51be09ec676cf773, 0x0000146f827b19db, 0, 210 }, /* #23 */
    { 0x207e56, 0x207606, 0x51be09ec676cf773, 0x0000146f827b19db, 0, 210 }, /* #23 b */
    { 0x0803c3, 0x080303, 0x43225e0a7d1f791c, 0x00043225e0a7d1f7, 0, 76 }, /* #24 */
    { 0x377c16, 0x377403, 0x43225e0a7d1f791c, 0x00043225e0a7d1f7, 0, 76 }, /* #24 b */
    { 0x213a83, 0x213206, 0x543e9580d58cea33, 0x000000002a1f4ac0, 0, 97 }, /* #25 */
    { 0x1e4556, 0x1e4506, 0x543e9580d58cea33, 0x000000002a1f4ac0, 0, 97 }, /* #25 b */
    { 0x120ad3, 0x120203, 0x5ff6eff593a631bd, 0x000000000000017f, 0, 246 }, /* #26 */
    { 0x2d7506, 0x2d7503, 0x5ff6eff593a631bd, 0x000000000000017f, 0, 246 }, /* #26 b */
    { 0x0b2893, 0x0b2003, 0x68b60dddae5908be, 0x0000000d16c1bbb5, 0, 27 }, /* #27 */
    { 0x345746, 0x345703, 0x68b60dddae5908be, 0x0000000d16c1bbb5, 0, 27 }, /* #27 b */
    { 0x1d5956, 0x1d5103, 0x3796315857329518, 0x0000000000000001, 0, 125 }, /* #28 */
    { 0x222683, 0x222603, 0x3796315857329518, 0x0000000000000001, 0, 125 }, /* #28 b */
    { 0x181986, 0x181907, 0x85d21e826d8eca1c, 0x000000000000042e, 0, 245 }, /* #29 */
    { 0x276653, 0x276e07, 0x85d21e826d8eca1c, 0x000000000000042e, 0, 245 }, /* #29 b */
    { 0x3c3687, 0x3c3603, 0x7e508444cceae93f, 0x0000fca1088999d5, 0, 207 }, /* #30 */
    { 0x034952, 0x034103, 0x7e508444cceae93f, 0x0000fca1088999d5, 0, 207 }, /* #30 b */
    { 0x011b96, 0x011b96, 0xb3cc41fe40635964, 0xb3cc41fe40635964, 0, 64 }, /* #31 */
    { 0x3e6443, 0x3e6443, 0xb3cc41fe40635964, 0xb3cc41fe40635964, 0, 64 }, /* #31 b */
    { 0x3f5cd6, 0x3f5c06, 0xf38295f60c4999c8, 0x00000000f38295f6, 0, 160 }, /* #32 */
    { 0x002303, 0x002b06, 0xf38295f60c4999c8, 0x00000000f38295f6, 0, 160 }, /* #32 b */
    { 0x2a1d03, 0x2a1503, 0x775baab7c06203e4, 0x003badd55be03101, 0, 73 }, /* #33 */
    { 0x1562d6, 0x156203, 0x775baab7c06203e4, 0x003badd55be03101, 0, 73 }, /* #33 b */
    { 0x0e73d6, 0x0e7306, 0x18839b2eea5ce2ed, 0x000c41cd97752e71, 0, 73 }, /* #34 */
    { 0x310c03, 0x310406, 0x18839b2eea5ce2ed, 0x000c41cd97752e71, 0, 73 }, /* #34 b */
    { 0x0b4a13, 0x0b4a03, 0xa79f0613e71e3ede, 0x00000000a79f0613, 0, 160 }, /* #35 */
    { 0x3435c6, 0x343d03, 0xa79f0613e71e3ede, 0x00000000a79f0613, 0, 160 }, /* #35 b */
    { 0x201002, 0x201807, 0x8f68af41f4a9e16c, 0x0000000000000047, 0, 121 }, /* #36 */
    { 0x1f6fd7, 0x1f6f07, 0x8f68af41f4a9e16c, 0x0000000000000047, 0, 121 }, /* #36 b */
    { 0x3d55d7, 0x3d5503, 0x55fa7ccf9b2e28df, 0x00000002afd3e67c, 0, 157 }, /* #37 */
    { 0x022a02, 0x022203, 0x55fa7ccf9b2e28df, 0x00000002afd3e67c, 0, 157 }, /* #37 b */
    { 0x254247, 0x254a03, 0xcbf4a3fc4c073a2c, 0x0000000000000001, 0, 255 }, /* #38 */
    { 0x1a3d92, 0x1a3d03, 0xcbf4a3fc4c073a2c, 0x0000000000000001, 0, 255 }, /* #38 b */
    { 0x106b82, 0x106b03, 0xa75129e0e0079945, 0x000029d44a783801, 0, 210 }, /* #39 */
    { 0x2f1457, 0x2f1c03, 0xa75129e0e0079945, 0x000029d44a783801, 0, 210 }, /* #39 b */
    { 0x294313, 0x294b07, 0xd65ca7cfabe1e81a, 0x000000001acb94f9, 0, 35 }, /* #40 */
    { 0x163cc6, 0x163c07, 0xd65ca7cfabe1e81a, 0x000000001acb94f9, 0, 35 }, /* #40 b */
    { 0x092297, 0x092a03, 0x8b43251719a1d861, 0x00000045a1928b8c, 0, 217 }, /* #41 */
    { 0x365d42, 0x365d03, 0x8b43251719a1d861, 0x00000045a1928b8c, 0, 217 }, /* #41 b */
    { 0x233087, 0x233002, 0x7e9111f15159932a, 0x000000007e9111f1, 0, 32 }, /* #42 */
    { 0x1c4f52, 0x1c4702, 0x7e9111f15159932a, 0x000000007e9111f1, 0, 32 }, /* #42 b */
    { 0x1b3092, 0x1b3003, 0x17bf96181b74987b, 0x0000000000000bdf, 0, 177 }, /* #43 */
    { 0x244f47, 0x244703, 0x17bf96181b74987b, 0x0000000000000bdf, 0, 177 }, /* #43 b */
    { 0x0c5206, 0x0c5207, 0x5c1e437ca8beda05, 0x000005c1e437ca8b, 0, 148 }, /* #44 */
    { 0x332dd3, 0x332507, 0x5c1e437ca8beda05, 0x000005c1e437ca8b, 0, 148 }, /* #44 b */
    { 0x2c7202, 0x2c7206, 0x7c49df5a9a521b09, 0x01f1277d6a69486c, 0, 198 }, /* #45 */
    { 0x130dd7, 0x130506, 0x7c49df5a9a521b09, 0x01f1277d6a69486c, 0, 198 }, /* #45 b */
    { 0x3222c2, 0x322a07, 0xdb7d7203d1c5e88c, 0x0001b6fae407a38b, 0, 79 }, /* #46 */
    { 0x0d5d17, 0x0d5d07, 0xdb7d7203d1c5e88c, 0x0001b6fae407a38b, 0, 79 }, /* #46 b */
    { 0x325f12, 0x325f07, 0xeb13dc902b1562a1, 0x000000000000003a, 0, 186 }, /* #47 */
    { 0x0d20c7, 0x0d2807, 0xeb13dc902b1562a1, 0x000000000000003a, 0, 186 }, /* #47 b */
    { 0x192e56, 0x192e06, 0x8bcb2d2db071a916, 0x0000000000045e59, 0, 237 }, /* #48 */
    { 0x265183, 0x265906, 0x8bcb2d2db071a916, 0x0000000000045e59, 0, 237 }, /* #48 b */
    { 0x324fd2, 0x324f07, 0x8eb89e7662aa14e6, 0x023ae279d98aa853, 0, 70 }, /* #49 */
    { 0x0d3007, 0x0d3807, 0x8eb89e7662aa14e6, 0x023ae279d98aa853, 0, 70 }, /* #49 b */
    { 0x1e2fd2, 0x1e2703, 0x2a08c5342bf0ee8e, 0x0000000000150462, 0, 233 }, /* #50 */
    { 0x215007, 0x215003, 0x2a08c5342bf0ee8e, 0x0000000000150462, 0, 233 }, /* #50 b */
    { 0x0c5343, 0x0c5b03, 0xc8048aa0cda85cbe, 0x320122a8336a172f, 0, 130 }, /* #51 */
    { 0x332c96, 0x332c03, 0xc8048aa0cda85cbe, 0x320122a8336a172f, 0, 130 }, /* #51 b */
    { 0x1038c2, 0x103802, 0xff28c819ffe67f5a, 0x0000000000007f94, 0, 49 }, /* #52 */
    { 0x2f4717, 0x2f4f02, 0xff28c819ffe67f5a, 0x0000000000007f94, 0, 49 }, /* #52 b */
    { 0x006c12, 0x006407, 0x49319a2feb553be4, 0x00000000124c668b, 0, 226 }, /* #53 */
    { 0x3f13c7, 0x3f1307, 0x49319a2feb553be4, 0x00000000124c668b, 0, 226 }, /* #53 b */
    { 0x226a16, 0x226206, 0x252718c8caeb8302, 0x00000000000949c6, 0, 42 }, /* #54 */
    { 0x1d15c3, 0x1d1506, 0x252718c8caeb8302, 0x00000000000949c6, 0, 42 }, /* #54 b */
    { 0x060d57, 0x060d03, 0xb8349871a31f0f41, 0x00000000000002e0, 0, 118 }, /* #55 */
    { 0x397282, 0x397a03, 0xb8349871a31f0f41, 0x00000000000002e0, 0, 118 }, /* #55 b */
    { 0x071216, 0x071a02, 0x86cc353393dfc03b, 0x0000000000000043, 0, 185 }, /* #56 */
    { 0x386dc3, 0x386d02, 0x86cc353393dfc03b, 0x0000000000000043, 0, 185 }, /* #56 b */
    { 0x076cc2, 0x076c07, 0xf2159e2d0a413097, 0x0000000000001e42, 0, 179 }, /* #57 */
    { 0x381317, 0x381b07, 0xf2159e2d0a413097, 0x0000000000001e42, 0, 179 }, /* #57 b */
    { 0x176f93, 0x176703, 0x1929722c2958066e, 0x0000000064a5c8b0, 0, 30 }, /* #58 */
    { 0x281046, 0x281003, 0x1929722c2958066e, 0x0000000064a5c8b0, 0, 30 }, /* #58 b */
    { 0x077b87, 0x077b06, 0x87e22f124c54e09c, 0x00000021f88bc493, 0, 90 }, /* #59 */
    { 0x380452, 0x380c06, 0x87e22f124c54e09c, 0x00000021f88bc493, 0, 90 }, /* #59 b */
    { 0x2275c6, 0x227d02, 0x89535bbc43410776, 0x0000000000000001, 0, 191 }, /* #60 */
    { 0x1d0a13, 0x1d0a02, 0x89535bbc43410776, 0x0000000000000001, 0, 191 }, /* #60 b */
    { 0x1b4483, 0x1b4403, 0x6a71a999a48e702d, 0x0000006a71a999a4, 0, 88 }, /* #61 */
    { 0x243b56, 0x243303, 0x6a71a999a48e702d, 0x0000006a71a999a4, 0, 88 }, /* #61 b */
    { 0x3a6b53, 0x3a6b02, 0xc7e94bac495cc118, 0x000000063f4a5d62, 0, 157 }, /* #62 */
    { 0x051486, 0x051c02, 0xc7e94bac495cc118, 0x000000063f4a5d62, 0, 157 }, /* #62 b */
    { 0x2b1517, 0x2b1517, 0x435eb8c6f410ed70, 0x435eb8c6f410ed70, 0, 128 }, /* #63 */
    { 0x146ac2, 0x146ac2, 0x435eb8c6f410ed70, 0x435eb8c6f410ed70, 0, 128 }, /* #63 b */
    { 0x063e57, 0x063e02, 0xbfa899a6c2f73b29, 0x00000002fea2669b, 0, 222 }, /* #64 */
    { 0x394182, 0x394902, 0xbfa899a6c2f73b29, 0x00000002fea2669b, 0, 222 }, /* #64 b */
    { 0x032546, 0x032507, 0x3b91dd5c545e1db5, 0x01dc8eeae2a2f0ed, 0, 5  }, /* #65 */
    { 0x3c5a93, 0x3c5207, 0x3b91dd5c545e1db5, 0x01dc8eeae2a2f0ed, 0, 5  }, /* #65 b */
    { 0x170b47, 0x170306, 0x422aa476064dcad3, 0x0000000422aa4760, 0, 28 }, /* #66 */
    { 0x287492, 0x287406, 0x422aa476064dcad3, 0x0000000422aa4760, 0, 28 }, /* #66 b */
    { 0x1068c3, 0x106002, 0x269a254954608bbd, 0x09a68952551822ef, 0, 130 }, /* #67 */
    { 0x2f1716, 0x2f1702, 0x269a254954608bbd, 0x09a68952551822ef, 0, 130 }, /* #67 b */
    { 0x246c02, 0x246c02, 0x90cecaf6f1789818, 0x004867657b78bc4c, 0, 73 }, /* #68 */
    { 0x1b13d7, 0x1b1b02, 0x90cecaf6f1789818, 0x004867657b78bc4c, 0, 73 }, /* #68 b */
    { 0x311782, 0x311707, 0x2041580defddf631, 0x00002041580defdd, 0, 16 }, /* #69 */
    { 0x0e6857, 0x0e6007, 0x2041580defddf631, 0x00002041580defdd, 0, 16 }, /* #69 b */
    { 0x0a73c7, 0x0a7302, 0x47b07b286c61aef8, 0x00000000000047b0, 0, 112 }, /* #70 */
    { 0x350c12, 0x350402, 0x47b07b286c61aef8, 0x00000000000047b0, 0, 112 }, /* #70 b */
    { 0x310dd6, 0x310d07, 0xfeb4e28b3cbd5a85, 0x000000000001fd69, 0, 111 }, /* #71 */
    { 0x0e7203, 0x0e7a07, 0xfeb4e28b3cbd5a85, 0x000000000001fd69, 0, 111 }, /* #71 b */
    { 0x3f3606, 0x3f3e03, 0x88aa22b1e3e765ce, 0x000222a88ac78f9d, 0, 142 }, /* #72 */
    { 0x0049d3, 0x004903, 0x88aa22b1e3e765ce, 0x000222a88ac78f9d, 0, 142 }, /* #72 b */
    { 0x3b0b07, 0x3b0b02, 0xd42dbbd4490f5e4a, 0x0000001a85b77a89, 0, 91 }, /* #73 */
    { 0x0474d2, 0x047c02, 0xd42dbbd4490f5e4a, 0x0000001a85b77a89, 0, 91 }, /* #73 b */
    { 0x346016, 0x346802, 0xb355ef2553ef5e19, 0x0000000000b355ef, 0, 232 }, /* #74 */
    { 0x0b1fc3, 0x0b1f02, 0xb355ef2553ef5e19, 0x0000000000b355ef, 0, 232 }, /* #74 b */
    { 0x043a07, 0x043a06, 0xe3845ef0f0b4a6c0, 0x0071c22f78785a53, 0, 9  }, /* #75 */
    { 0x3b45d2, 0x3b4d06, 0xe3845ef0f0b4a6c0, 0x0071c22f78785a53, 0, 9  }, /* #75 b */
    { 0x354a16, 0x354207, 0x589ab80f6a74ca03, 0x0000000000000005, 0, 124 }, /* #76 */
    { 0x0a35c3, 0x0a3507, 0x589ab80f6a74ca03, 0x0000000000000005, 0, 124 }, /* #76 b */
    { 0x0d35d2, 0x0d35d2, 0x59088daa16acb67d, 0x59088daa16acb67d, 0, 0  }, /* #77 */
    { 0x324a07, 0x324a07, 0x59088daa16acb67d, 0x59088daa16acb67d, 0, 0  }, /* #77 b */
    { 0x2a71d6, 0x2a7102, 0x13c9626575439ce8, 0x0009e4b132baa1ce, 0, 201 }, /* #78 */
    { 0x150e03, 0x150602, 0x13c9626575439ce8, 0x0009e4b132baa1ce, 0, 201 }, /* #78 b */
    { 0x1f0252, 0x1f0207, 0x408c9053ed522b65, 0x0000020464829f6a, 0, 213 }, /* #79 */
    { 0x207d87, 0x207507, 0x408c9053ed522b65, 0x0000020464829f6a, 0, 213 }, /* #79 b */
    { 0x370057, 0x370007, 0x1d4327bb1cb2697d, 0x00000001d4327bb1, 0, 220 }, /* #80 */
    { 0x087f82, 0x087707, 0x1d4327bb1cb2697d, 0x00000001d4327bb1, 0, 220 }, /* #80 b */
    { 0x297f42, 0x297707, 0x6118b17828fd6ef0, 0x0000000006118b17, 0, 228 }, /* #81 */
    { 0x160097, 0x160007, 0x6118b17828fd6ef0, 0x0000000006118b17, 0, 228 }, /* #81 b */
    { 0x106483, 0x106407, 0x0f587ff3e4daaa2c, 0x000000003d61ffcf, 0, 94 }, /* #82 */
    { 0x2f1b56, 0x2f1307, 0x0f587ff3e4daaa2c, 0x000000003d61ffcf, 0, 94 }, /* #82 b */
    { 0x1453c6, 0x145302, 0x0ba2ba421890ad20, 0x000000000000005d, 0, 181 }, /* #83 */
    { 0x2b2c13, 0x2b2402, 0x0ba2ba421890ad20, 0x000000000000005d, 0, 181 }, /* #83 b */
    { 0x2c4792, 0x2c4792, 0xf3a9f543bc1ff825, 0xf3a9f543bc1ff825, 0, 0  }, /* #84 */
    { 0x133847, 0x133847, 0xf3a9f543bc1ff825, 0xf3a9f543bc1ff825, 0, 0  }, /* #84 b */
    { 0x0b2413, 0x0b2c02, 0x82ce404776cf7b80, 0x0000000000000002, 0, 254 }, /* #85 */
    { 0x345bc6, 0x345b02, 0x82ce404776cf7b80, 0x0000000000000002, 0, 254 }, /* #85 b */
    { 0x0f32c7, 0x0f3a06, 0xeadad7e6c6e3e03d, 0x0000000eadad7e6c, 0, 220 }, /* #86 */
    { 0x304d12, 0x304d06, 0xeadad7e6c6e3e03d, 0x0000000eadad7e6c, 0, 220 }, /* #86 b */
    { 0x286ac7, 0x286207, 0x798765ecd8a669d0, 0x0000000000003cc3, 0, 49 }, /* #87 */
    { 0x171512, 0x171507, 0x798765ecd8a669d0, 0x0000000000003cc3, 0, 49 }, /* #87 b */
    { 0x3d4746, 0x3d4f06, 0x939a4aab27775b59, 0x0000939a4aab2777, 0, 16 }, /* #88 */
    { 0x023893, 0x023806, 0x939a4aab27775b59, 0x0000939a4aab2777, 0, 16 }, /* #88 b */
    { 0x0e3f96, 0x0e3703, 0x49b54707b1f73320, 0x0000000000126d51, 0, 106 }, /* #89 */
    { 0x314043, 0x314003, 0x49b54707b1f73320, 0x0000000000126d51, 0, 106 }, /* #89 b */
    { 0x176297, 0x176a07, 0xc3a2319f89e2e7d0, 0x00030e88c67e278b, 0, 78 }, /* #90 */
    { 0x281d42, 0x281d07, 0xc3a2319f89e2e7d0, 0x00030e88c67e278b, 0, 78 }, /* #90 b */
    { 0x311352, 0x311b06, 0xd8a7766ef94dde1b, 0x00000000000001b1, 0, 247 }, /* #91 */
    { 0x0e6c87, 0x0e6c06, 0xd8a7766ef94dde1b, 0x00000000000001b1, 0, 247 }, /* #91 b */
    { 0x251057, 0x251006, 0x0647e0d098d58a5e, 0x000323f0684c6ac5, 0, 73 }, /* #92 */
    { 0x1a6f82, 0x1a6706, 0x0647e0d098d58a5e, 0x000323f0684c6ac5, 0, 73 }, /* #92 b */
    { 0x0f0c42, 0x0f0446, 0x0f0a1c5ae5b4916f, 0x0000000000000000, 0, 61 }, /* #93 */
    { 0x307397, 0x307346, 0x0f0a1c5ae5b4916f, 0x0000000000000000, 0, 61 }, /* #93 b */
    { 0x360b16, 0x360302, 0x435f2d19617d4742, 0x00021af968cb0bea, 0, 13 }, /* #94 */
    { 0x0974c3, 0x097402, 0x435f2d19617d4742, 0x00021af968cb0bea, 0, 13 }, /* #94 b */
    { 0x0f4e97, 0x0f4606, 0x5352c2e23fd45824, 0x00000000029a9617, 0, 37 }, /* #95 */
    { 0x303142, 0x303106, 0x5352c2e23fd45824, 0x00000000029a9617, 0, 37 }, /* #95 b */
};
uint32_t const g_cTests_shr_u64_intel = RT_ELEMENTS(g_aTests_shr_u64_intel);

BINU64_TEST_T const g_aTests_sar_u64_intel[] =
{
    { 0x042c47, 0x042446, 0x0000000000000000, 0x0000000000000000, 0, 224 }, /* #0 */
    { 0x3b5392, 0x3b5346, 0x0000000000000000, 0x0000000000000000, 0, 224 }, /* #0 b */
    { 0x195486, 0x195446, 0x0000000000000000, 0x0000000000000000, 0, 59 }, /* #1 */
    { 0x262b53, 0x262346, 0x0000000000000000, 0x0000000000000000, 0, 59 }, /* #1 b */
    { 0x260b57, 0x260346, 0x0000000000000000, 0x0000000000000000, 0, 140 }, /* #2 */
    { 0x197482, 0x197446, 0x0000000000000000, 0x0000000000000000, 0, 140 }, /* #2 b */
    { 0x3f2e17, 0x3f2646, 0x0000000000000000, 0x0000000000000000, 0, 172 }, /* #3 */
    { 0x0051c2, 0x005146, 0x0000000000000000, 0x0000000000000000, 0, 172 }, /* #3 b */
    { 0x075913, 0x075146, 0x0000000000000000, 0x0000000000000000, 0, 213 }, /* #4 */
    { 0x3826c6, 0x382646, 0x0000000000000000, 0x0000000000000000, 0, 213 }, /* #4 b */
    { 0x164647, 0x164646, 0x0000000000000000, 0x0000000000000000, 0, 158 }, /* #5 */
    { 0x293992, 0x293146, 0x0000000000000000, 0x0000000000000000, 0, 158 }, /* #5 b */
    { 0x133517, 0x133586, 0x91a88603c888bb5d, 0xfffffffffe46a218, 0, 166 }, /* #6 */
    { 0x2c4ac2, 0x2c4286, 0x91a88603c888bb5d, 0xfffffffffe46a218, 0, 166 }, /* #6 b */
    { 0x223607, 0x223602, 0x0509fca8779c758d, 0x000000000284fe54, 0, 225 }, /* #7 */
    { 0x1d49d2, 0x1d4102, 0x0509fca8779c758d, 0x000000000284fe54, 0, 225 }, /* #7 b */
    { 0x0425c7, 0x042582, 0x81125b81d918ad5c, 0xc0892dc0ec8c56ae, 0, 193 }, /* #8 */
    { 0x3b5a12, 0x3b5282, 0x81125b81d918ad5c, 0xc0892dc0ec8c56ae, 0, 193 }, /* #8 b */
    { 0x074153, 0x074183, 0xcdc4aa5f9836463a, 0xfffff3712a97e60d, 0, 146 }, /* #9 */
    { 0x383e86, 0x383683, 0xcdc4aa5f9836463a, 0xfffff3712a97e60d, 0, 146 }, /* #9 b */
    { 0x150743, 0x150706, 0x21445e818c4a0e99, 0x0000000000000021, 0, 56 }, /* #10 */
    { 0x2a7896, 0x2a7006, 0x21445e818c4a0e99, 0x0000000000000021, 0, 56 }, /* #10 b */
    { 0x365517, 0x365506, 0x6f23633892991b4d, 0x000000000003791b, 0, 173 }, /* #11 */
    { 0x092ac2, 0x092206, 0x6f23633892991b4d, 0x000000000003791b, 0, 173 }, /* #11 b */
    { 0x2b7e46, 0x2b7686, 0xf8318765e5a163d3, 0xffffffffffffe0c6, 0, 46 }, /* #12 */
    { 0x140193, 0x140186, 0xf8318765e5a163d3, 0xffffffffffffe0c6, 0, 46 }, /* #12 b */
    { 0x051b87, 0x051382, 0xd99cbe804d9f3319, 0xfffffff6672fa013, 0, 90 }, /* #13 */
    { 0x3a6452, 0x3a6482, 0xd99cbe804d9f3319, 0xfffffff6672fa013, 0, 90 }, /* #13 b */
    { 0x3d1353, 0x3d1386, 0x847a0acadf5f9e25, 0xffc23d05656fafcf, 0, 9  }, /* #14 */
    { 0x026c86, 0x026486, 0x847a0acadf5f9e25, 0xffc23d05656fafcf, 0, 9  }, /* #14 b */
    { 0x1f4d03, 0x1f4502, 0x6c4aebdf01e4da74, 0x000000006c4aebdf, 0, 96 }, /* #15 */
    { 0x2032d6, 0x203202, 0x6c4aebdf01e4da74, 0x000000006c4aebdf, 0, 96 }, /* #15 b */
    { 0x191442, 0x191482, 0xf7f6bcad5c40e619, 0xfffffffbfb5e56ae, 0, 153 }, /* #16 */
    { 0x266b97, 0x266382, 0xf7f6bcad5c40e619, 0xfffffffbfb5e56ae, 0, 153 }, /* #16 b */
    { 0x0b56d7, 0x0b5686, 0xec22d6d7f0907154, 0xfffffffffffffd84, 0, 243 }, /* #17 */
    { 0x342902, 0x342186, 0xec22d6d7f0907154, 0xfffffffffffffd84, 0, 243 }, /* #17 b */
    { 0x302a43, 0x302282, 0xed5f4d42def9f1a5, 0xffdabe9a85bdf3e3, 0, 71 }, /* #18 */
    { 0x0f5596, 0x0f5582, 0xed5f4d42def9f1a5, 0xffdabe9a85bdf3e3, 0, 71 }, /* #18 b */
    { 0x174ec3, 0x174686, 0xdd0ef6e9d2ef5168, 0xfffffffffba1dedd, 0, 163 }, /* #19 */
    { 0x283116, 0x283186, 0xdd0ef6e9d2ef5168, 0xfffffffffba1dedd, 0, 163 }, /* #19 b */
    { 0x217f96, 0x217703, 0x0f13a7f392863076, 0x0000000000000001, 0, 123 }, /* #20 */
    { 0x1e0043, 0x1e0003, 0x0f13a7f392863076, 0x0000000000000001, 0, 123 }, /* #20 b */
    { 0x0b1083, 0x0b1083, 0xfbfa21cbcd5efd28, 0xfffffbfa21cbcd5e, 0, 208 }, /* #21 */
    { 0x346f56, 0x346783, 0xfbfa21cbcd5efd28, 0xfffffbfa21cbcd5e, 0, 208 }, /* #21 b */
    { 0x005597, 0x005582, 0xa317ff1c620bf465, 0xfa317ff1c620bf46, 0, 196 }, /* #22 */
    { 0x3f2a42, 0x3f2282, 0xa317ff1c620bf465, 0xfa317ff1c620bf46, 0, 196 }, /* #22 b */
    { 0x207e83, 0x207603, 0x6eb70783e83ec55a, 0x0000000000000dd6, 0, 179 }, /* #23 */
    { 0x1f0156, 0x1f0103, 0x6eb70783e83ec55a, 0x0000000000000dd6, 0, 179 }, /* #23 b */
    { 0x3e2c03, 0x3e2487, 0x90d8d1cfbb55463b, 0xfffff21b1a39f76a, 0, 83 }, /* #24 */
    { 0x0153d6, 0x015387, 0x90d8d1cfbb55463b, 0xfffff21b1a39f76a, 0, 83 }, /* #24 b */
    { 0x201146, 0x201103, 0x3763f9219e4eadf8, 0x03763f9219e4eadf, 0, 196 }, /* #25 */
    { 0x1f6e93, 0x1f6603, 0x3763f9219e4eadf8, 0x03763f9219e4eadf, 0, 196 }, /* #25 b */
    { 0x261a86, 0x261283, 0xd0e21249c9619e82, 0xffffffffffffffd0, 0, 184 }, /* #26 */
    { 0x196553, 0x196583, 0xd0e21249c9619e82, 0xffffffffffffffd0, 0, 184 }, /* #26 b */
    { 0x175092, 0x175007, 0x2d95102b63c3d633, 0x000000000000016c, 0, 245 }, /* #27 */
    { 0x282f47, 0x282707, 0x2d95102b63c3d633, 0x000000000000016c, 0, 245 }, /* #27 b */
    { 0x1178c3, 0x117003, 0x51b591c4e1254f3e, 0x028dac8e27092a79, 0, 197 }, /* #28 */
    { 0x2e0716, 0x2e0703, 0x51b591c4e1254f3e, 0x028dac8e27092a79, 0, 197 }, /* #28 b */
    { 0x176a06, 0x176286, 0x945d21d90786431c, 0xfffff945d21d9078, 0, 20 }, /* #29 */
    { 0x2815d3, 0x281586, 0x945d21d90786431c, 0xfffff945d21d9078, 0, 20 }, /* #29 b */
    { 0x1e3753, 0x1e3782, 0xa22ead2eff7d338c, 0xfffffffffffffffd, 0, 189 }, /* #30 */
    { 0x214886, 0x214082, 0xa22ead2eff7d338c, 0xfffffffffffffffd, 0, 189 }, /* #30 b */
    { 0x127f42, 0x127706, 0x388213866b50c39f, 0x0000000000001c41, 0, 177 }, /* #31 */
    { 0x2d0097, 0x2d0006, 0x388213866b50c39f, 0x0000000000001c41, 0, 177 }, /* #31 b */
    { 0x2645d7, 0x264502, 0x731e2cb52209671d, 0x00000000000398f1, 0, 173 }, /* #32 */
    { 0x193a02, 0x193202, 0x731e2cb52209671d, 0x00000000000398f1, 0, 173 }, /* #32 b */
    { 0x3b7f12, 0x3b7782, 0x907dc4c905d4c767, 0xffffffff20fb8992, 0, 223 }, /* #33 */
    { 0x0400c7, 0x040082, 0x907dc4c905d4c767, 0xffffffff20fb8992, 0, 223 }, /* #33 b */
    { 0x0c7657, 0x0c7646, 0x0638e4b64cd4d9a0, 0x0000000000000000, 0, 60 }, /* #34 */
    { 0x330982, 0x330146, 0x0638e4b64cd4d9a0, 0x0000000000000000, 0, 60 }, /* #34 b */
    { 0x365a42, 0x365203, 0x30a094aed615e98c, 0x00000000030a094a, 0, 36 }, /* #35 */
    { 0x092597, 0x092503, 0x30a094aed615e98c, 0x00000000030a094a, 0, 36 }, /* #35 b */
    { 0x1a3e97, 0x1a3607, 0x29fb78b6c6a14e82, 0x0a7ede2db1a853a0, 0, 66 }, /* #36 */
    { 0x254142, 0x254107, 0x29fb78b6c6a14e82, 0x0a7ede2db1a853a0, 0, 66 }, /* #36 b */
    { 0x1e0716, 0x1e0706, 0x5c05439b460fb744, 0x000000000000005c, 0, 184 }, /* #37 */
    { 0x2178c3, 0x217006, 0x5c05439b460fb744, 0x000000000000005c, 0, 184 }, /* #37 b */
    { 0x036bd3, 0x036386, 0xd57522555d325929, 0xfff55d4895574c96, 0, 202 }, /* #38 */
    { 0x3c1406, 0x3c1486, 0xd57522555d325929, 0xfff55d4895574c96, 0, 202 }, /* #38 b */
    { 0x2e2f13, 0x2e2707, 0x4e9b41098b27ebb9, 0x00000000274da084, 0, 161 }, /* #39 */
    { 0x1150c6, 0x115007, 0x4e9b41098b27ebb9, 0x00000000274da084, 0, 161 }, /* #39 b */
    { 0x0a5007, 0x0a5003, 0x70e81eeb3121fbcc, 0x000001c3a07bacc4, 0, 22 }, /* #40 */
    { 0x352fd2, 0x352703, 0x70e81eeb3121fbcc, 0x000001c3a07bacc4, 0, 22 }, /* #40 b */
    { 0x3f6642, 0x3f6603, 0x057374a5a11e83bb, 0x0000000000ae6e94, 0, 227 }, /* #41 */
    { 0x001997, 0x001103, 0x057374a5a11e83bb, 0x0000000000ae6e94, 0, 227 }, /* #41 b */
    { 0x004d43, 0x004583, 0x888d4943316e308b, 0xffffff111a928662, 0, 215 }, /* #42 */
    { 0x3f3296, 0x3f3283, 0x888d4943316e308b, 0xffffff111a928662, 0, 215 }, /* #42 b */
    { 0x1d7842, 0x1d7007, 0x1869547f947190ce, 0x00000000000030d2, 0, 239 }, /* #43 */
    { 0x220797, 0x220707, 0x1869547f947190ce, 0x00000000000030d2, 0, 239 }, /* #43 b */
    { 0x007402, 0x007482, 0xc9a189dcfb129d52, 0xff26862773ec4a75, 0, 134 }, /* #44 */
    { 0x3f0bd7, 0x3f0382, 0xc9a189dcfb129d52, 0xff26862773ec4a75, 0, 134 }, /* #44 b */
    { 0x2d5643, 0x2d5607, 0x5b366554a2c40df7, 0x0b66ccaa945881be, 0, 195 }, /* #45 */
    { 0x122996, 0x122107, 0x5b366554a2c40df7, 0x0b66ccaa945881be, 0, 195 }, /* #45 b */
    { 0x026692, 0x026606, 0x2d295f7c5ffd9057, 0x00000000002d295f, 0, 104 }, /* #46 */
    { 0x3d1947, 0x3d1106, 0x2d295f7c5ffd9057, 0x00000000002d295f, 0, 104 }, /* #46 b */
    { 0x3b2c43, 0x3b2482, 0xfa47e6bf7ef7f1db, 0xffff48fcd7efdefe, 0, 203 }, /* #47 */
    { 0x045396, 0x045382, 0xfa47e6bf7ef7f1db, 0xffff48fcd7efdefe, 0, 203 }, /* #47 b */
    { 0x210c57, 0x210486, 0xd29379174add61d1, 0xffffffffffffd293, 0, 240 }, /* #48 */
    { 0x1e7382, 0x1e7386, 0xd29379174add61d1, 0xffffffffffffd293, 0, 240 }, /* #48 b */
    { 0x3944c6, 0x394483, 0x84a5f1fcaafb2813, 0xfffffe1297c7f2ab, 0, 22 }, /* #49 */
    { 0x063b13, 0x063383, 0x84a5f1fcaafb2813, 0xfffffe1297c7f2ab, 0, 22 }, /* #49 b */
    { 0x2e13c2, 0x2e1387, 0xb36bfb681387b666, 0xfffffffffffffb36, 0, 52 }, /* #50 */
    { 0x116c17, 0x116487, 0xb36bfb681387b666, 0xfffffffffffffb36, 0, 52 }, /* #50 b */
    { 0x376bd3, 0x376386, 0xbd77ce2679a6a5b6, 0xfffbd77ce2679a6a, 0, 140 }, /* #51 */
    { 0x081406, 0x081486, 0xbd77ce2679a6a5b6, 0xfffbd77ce2679a6a, 0, 140 }, /* #51 b */
    { 0x087fd6, 0x087783, 0xae4ac5ba74604fb6, 0xfffffffffff5c958, 0, 43 }, /* #52 */
    { 0x370003, 0x370083, 0xae4ac5ba74604fb6, 0xfffffffffff5c958, 0, 43 }, /* #52 b */
    { 0x0e1c96, 0x0e1486, 0xf7408bbf3d5bf8b2, 0xffffffffffffff74, 0, 244 }, /* #53 */
    { 0x316343, 0x316386, 0xf7408bbf3d5bf8b2, 0xffffffffffffff74, 0, 244 }, /* #53 b */
    { 0x094a42, 0x094206, 0x11de5038d010a6a9, 0x008ef281c6808535, 0, 133 }, /* #54 */
    { 0x363597, 0x363506, 0x11de5038d010a6a9, 0x008ef281c6808535, 0, 133 }, /* #54 b */
    { 0x1b6c43, 0x1b6403, 0x35b147428723c9b3, 0x00001ad8a3a14391, 0, 17 }, /* #55 */
    { 0x241396, 0x241303, 0x35b147428723c9b3, 0x00001ad8a3a14391, 0, 17 }, /* #55 b */
    { 0x356bd6, 0x356302, 0x7c67002cb7a74c2d, 0x000007c67002cb7a, 0, 20 }, /* #56 */
    { 0x0a1403, 0x0a1402, 0x7c67002cb7a74c2d, 0x000007c67002cb7a, 0, 20 }, /* #56 b */
    { 0x1c5e06, 0x1c5603, 0x37cced4aa985765f, 0x0000001be676a554, 0, 25 }, /* #57 */
    { 0x2321d3, 0x232103, 0x37cced4aa985765f, 0x0000001be676a554, 0, 25 }, /* #57 b */
    { 0x1031c2, 0x103187, 0x9bdc301853a129bd, 0xffffff9bdc301853, 0, 216 }, /* #58 */
    { 0x2f4e17, 0x2f4687, 0x9bdc301853a129bd, 0xffffff9bdc301853, 0, 216 }, /* #58 b */
    { 0x255947, 0x255186, 0xe7280ef68637718a, 0xfffffffffffff9ca, 0, 50 }, /* #59 */
    { 0x1a2692, 0x1a2686, 0xe7280ef68637718a, 0xfffffffffffff9ca, 0, 50 }, /* #59 b */
    { 0x1a0a93, 0x1a0202, 0x425056be3b25b294, 0x0000000000000001, 0, 190 }, /* #60 */
    { 0x257546, 0x257502, 0x425056be3b25b294, 0x0000000000000001, 0, 190 }, /* #60 b */
    { 0x3716d2, 0x371606, 0x0bac632fe9710efd, 0x000001758c65fd2e, 0, 19 }, /* #61 */
    { 0x086907, 0x086106, 0x0bac632fe9710efd, 0x000001758c65fd2e, 0, 19 }, /* #61 b */
    { 0x2f12d6, 0x2f1283, 0xfbb0d657dc7eea62, 0xfffffffffffff761, 0, 239 }, /* #62 */
    { 0x106d03, 0x106583, 0xfbb0d657dc7eea62, 0xfffffffffffff761, 0, 239 }, /* #62 b */
    { 0x337396, 0x337387, 0x97b47e38ecf62877, 0xfffffffffff97b47, 0, 44 }, /* #63 */
    { 0x0c0c43, 0x0c0487, 0x97b47e38ecf62877, 0xfffffffffff97b47, 0, 44 }, /* #63 b */
    { 0x126f17, 0x126783, 0x8bd362c82e104f7c, 0xf17a6c5905c209ef, 0, 67 }, /* #64 */
    { 0x2d10c2, 0x2d1083, 0x8bd362c82e104f7c, 0xf17a6c5905c209ef, 0, 67 }, /* #64 b */
    { 0x221642, 0x221686, 0xe826a1b49c9815b5, 0xfffa09a86d272605, 0, 202 }, /* #65 */
    { 0x1d6997, 0x1d6186, 0xe826a1b49c9815b5, 0xfffa09a86d272605, 0, 202 }, /* #65 b */
    { 0x084356, 0x084306, 0x10009ade73ad0a78, 0x000000200135bce7, 0, 23 }, /* #66 */
    { 0x373c83, 0x373406, 0x10009ade73ad0a78, 0x000000200135bce7, 0, 23 }, /* #66 b */
    { 0x3e0fd3, 0x3e0706, 0x4cbb1ca1d72d5f46, 0x004cbb1ca1d72d5f, 0, 136 }, /* #67 */
    { 0x017006, 0x017006, 0x4cbb1ca1d72d5f46, 0x004cbb1ca1d72d5f, 0, 136 }, /* #67 b */
    { 0x3e7306, 0x3e7387, 0xc12b1c537440e27c, 0xfffffffffffffc12, 0, 244 }, /* #68 */
    { 0x010cd3, 0x010487, 0xc12b1c537440e27c, 0xfffffffffffffc12, 0, 244 }, /* #68 b */
    { 0x3c0813, 0x3c0083, 0x8f0ed3d010ded00d, 0xffffffffffff8f0e, 0, 176 }, /* #69 */
    { 0x0377c6, 0x037783, 0x8f0ed3d010ded00d, 0xffffffffffff8f0e, 0, 176 }, /* #69 b */
    { 0x330b93, 0x330303, 0x68388b2edb28db2d, 0x0000000341c45976, 0, 29 }, /* #70 */
    { 0x0c7446, 0x0c7403, 0x68388b2edb28db2d, 0x0000000341c45976, 0, 29 }, /* #70 b */
    { 0x267547, 0x267502, 0x45f52b88cd54febb, 0x00000045f52b88cd, 0, 152 }, /* #71 */
    { 0x190a92, 0x190202, 0x45f52b88cd54febb, 0x00000045f52b88cd, 0, 152 }, /* #71 b */
    { 0x1e16c3, 0x1e1606, 0x4ec1e8e7117bda2f, 0x0000000002760f47, 0, 101 }, /* #72 */
    { 0x216916, 0x216106, 0x4ec1e8e7117bda2f, 0x0000000002760f47, 0, 101 }, /* #72 b */
    { 0x0d76c7, 0x0d7603, 0x2440a424fbdfe24d, 0x00000048814849f7, 0, 23 }, /* #73 */
    { 0x320912, 0x320103, 0x2440a424fbdfe24d, 0x00000048814849f7, 0, 23 }, /* #73 b */
    { 0x303046, 0x303007, 0x586d7634d54535f7, 0x000000000b0daec6, 0, 227 }, /* #74 */
    { 0x0f4f93, 0x0f4707, 0x586d7634d54535f7, 0x000000000b0daec6, 0, 227 }, /* #74 b */
    { 0x095e52, 0x095687, 0xd2daf6a7bf778f7b, 0xfffffffffff4b6bd, 0, 170 }, /* #75 */
    { 0x362187, 0x362187, 0xd2daf6a7bf778f7b, 0xfffffffffff4b6bd, 0, 170 }, /* #75 b */
    { 0x310f83, 0x310782, 0xa955475b6750fbd7, 0xffffffa955475b67, 0, 152 }, /* #76 */
    { 0x0e7056, 0x0e7082, 0xa955475b6750fbd7, 0xffffffa955475b67, 0, 152 }, /* #76 b */
    { 0x0f4b96, 0x0f4306, 0x20068dbd10925714, 0x0000000801a36f44, 0, 154 }, /* #77 */
    { 0x303443, 0x303406, 0x20068dbd10925714, 0x0000000801a36f44, 0, 154 }, /* #77 b */
    { 0x1e1843, 0x1e1002, 0x76e37711dbe22ce0, 0x00000000000076e3, 0, 48 }, /* #78 */
    { 0x216796, 0x216702, 0x76e37711dbe22ce0, 0x00000000000076e3, 0, 48 }, /* #78 b */
    { 0x046b83, 0x046383, 0x88e688e0ea610913, 0xfffffff88e688e0e, 0, 28 }, /* #79 */
    { 0x3b1456, 0x3b1483, 0x88e688e0ea610913, 0xfffffff88e688e0e, 0, 28 }, /* #79 b */
    { 0x340d47, 0x340503, 0x078d6688ae249f4b, 0x0000000000000001, 0, 58 }, /* #80 */
    { 0x0b7292, 0x0b7203, 0x078d6688ae249f4b, 0x0000000000000001, 0, 58 }, /* #80 b */
    { 0x0811c7, 0x081187, 0x81c5f897f0145083, 0xffff038bf12fe028, 0, 207 }, /* #81 */
    { 0x376e12, 0x376687, 0x81c5f897f0145083, 0xffff038bf12fe028, 0, 207 }, /* #81 b */
    { 0x3d7482, 0x3d7407, 0x77905df73c6db2be, 0x000000ef20bbee78, 0, 151 }, /* #82 */
    { 0x020b57, 0x020307, 0x77905df73c6db2be, 0x000000ef20bbee78, 0, 151 }, /* #82 b */
    { 0x2577d7, 0x257782, 0x8de6a9eef587e205, 0xff1bcd53ddeb0fc4, 0, 199 }, /* #83 */
    { 0x1a0802, 0x1a0082, 0x8de6a9eef587e205, 0xff1bcd53ddeb0fc4, 0, 199 }, /* #83 b */
    { 0x1d04d2, 0x1d0407, 0x0978f5f70ab707ca, 0x0000000000012f1e, 0, 43 }, /* #84 */
    { 0x227b07, 0x227307, 0x0978f5f70ab707ca, 0x0000000000012f1e, 0, 43 }, /* #84 b */
    { 0x220083, 0x220003, 0x72ba1f7bf93cd696, 0x0000000000001cae, 0, 242 }, /* #85 */
    { 0x1d7f56, 0x1d7703, 0x72ba1f7bf93cd696, 0x0000000000001cae, 0, 242 }, /* #85 b */
    { 0x247b57, 0x247383, 0xcc8c29f3a0e86230, 0xfffffffffffffcc8, 0, 180 }, /* #86 */
    { 0x1b0482, 0x1b0483, 0xcc8c29f3a0e86230, 0xfffffffffffffcc8, 0, 180 }, /* #86 b */
    { 0x2d7607, 0x2d7602, 0x64286e03f569eed4, 0x0000000000321437, 0, 169 }, /* #87 */
    { 0x1209d2, 0x120102, 0x64286e03f569eed4, 0x0000000000321437, 0, 169 }, /* #87 b */
    { 0x285dd2, 0x285583, 0xb51407a3767f67db, 0xfffffda8a03d1bb3, 0, 213 }, /* #88 */
    { 0x172207, 0x172283, 0xb51407a3767f67db, 0xfffffda8a03d1bb3, 0, 213 }, /* #88 b */
    { 0x363f43, 0x363702, 0x6acb468039834231, 0x000000000d5968d0, 0, 227 }, /* #89 */
    { 0x094096, 0x094002, 0x6acb468039834231, 0x000000000d5968d0, 0, 227 }, /* #89 b */
    { 0x143d82, 0x143506, 0x201f532a80158cdc, 0x000000000100fa99, 0, 37 }, /* #90 */
    { 0x2b4257, 0x2b4206, 0x201f532a80158cdc, 0x000000000100fa99, 0, 37 }, /* #90 b */
    { 0x0a37d7, 0x0a3783, 0x9f18fc043c5f9edf, 0xfffffffe7c63f010, 0, 158 }, /* #91 */
    { 0x354802, 0x354083, 0x9f18fc043c5f9edf, 0xfffffffe7c63f010, 0, 158 }, /* #91 b */
    { 0x0a4913, 0x0a4107, 0x17cec047322cd520, 0x0000000005f3b011, 0, 34 }, /* #92 */
    { 0x3536c6, 0x353607, 0x17cec047322cd520, 0x0000000005f3b011, 0, 34 }, /* #92 b */
    { 0x1448c6, 0x144087, 0x9b94625820a523bd, 0xffe6e51896082948, 0, 74 }, /* #93 */
    { 0x2b3713, 0x2b3787, 0x9b94625820a523bd, 0xffe6e51896082948, 0, 74 }, /* #93 b */
    { 0x2a0242, 0x2a0283, 0xf99b26a09f8d73c4, 0xffffffff3364d413, 0, 91 }, /* #94 */
    { 0x157d97, 0x157583, 0xf99b26a09f8d73c4, 0xffffffff3364d413, 0, 91 }, /* #94 b */
    { 0x020853, 0x020007, 0x07ba4ec2cf75be8c, 0x000000000000007b, 0, 244 }, /* #95 */
    { 0x3d7786, 0x3d7707, 0x07ba4ec2cf75be8c, 0x000000000000007b, 0, 244 }, /* #95 b */
};
uint32_t const g_cTests_sar_u64_intel = RT_ELEMENTS(g_aTests_sar_u64_intel);

MULDIVU8_TEST_T const g_aTests_mul_u8_intel[] =
{
    { 0x122ad6, 0x122206, 0x0000, 0x0000, 0x00, 0 }, /* #0 */
    { 0x014487, 0x014406, 0x0000, 0x0000, 0x00, 0 }, /* #1 */
    { 0x355fc7, 0x355706, 0x0000, 0x0000, 0x00, 0 }, /* #2 */
    { 0x085816, 0x085006, 0x0000, 0x0000, 0x00, 0 }, /* #3 */
    { 0x315686, 0x315606, 0x0000, 0x0000, 0x00, 0 }, /* #4 */
    { 0x064186, 0x064106, 0x0000, 0x0000, 0x00, 0 }, /* #5 */
    { 0x282482, 0x282406, 0x9305, 0x0000, 0x00, 0 }, /* #6 */
    { 0x1574c3, 0x157406, 0x59a0, 0x0000, 0x00, 0 }, /* #7 */
    { 0x0d7706, 0x0d7706, 0x5f83, 0x0000, 0x00, 0 }, /* #8 */
    { 0x3f04c3, 0x3f0406, 0x4283, 0x0000, 0x00, 0 }, /* #9 */
    { 0x3a7457, 0x3a7406, 0x84ed, 0x0000, 0x00, 0 }, /* #10 */
    { 0x0027d7, 0x002706, 0xbdca, 0x0000, 0x00, 0 }, /* #11 */
    { 0x071b02, 0x071b03, 0x91cd, 0x634c, 0x7c, 0 }, /* #12 */
    { 0x163bd6, 0x163b07, 0x6bc2, 0x4b06, 0x63, 0 }, /* #13 */
    { 0x160a12, 0x160a87, 0x504f, 0x41bb, 0xd5, 0 }, /* #14 */
    { 0x0a3a87, 0x0a3a83, 0x2667, 0x1efb, 0x4d, 0 }, /* #15 */
    { 0x3f6582, 0x3f6d87, 0x70cb, 0x6ca3, 0x89, 0 }, /* #16 */
    { 0x0f6512, 0x0f6d87, 0x9c0e, 0x0ae2, 0xc7, 0 }, /* #17 */
    { 0x026613, 0x026e03, 0xcd3f, 0x1e45, 0x7b, 0 }, /* #18 */
    { 0x082b87, 0x082b07, 0x9b3f, 0x113a, 0x46, 0 }, /* #19 */
    { 0x382c52, 0x382c07, 0x9327, 0x0333, 0x15, 0 }, /* #20 */
    { 0x115a83, 0x115a87, 0x3714, 0x08c0, 0x70, 0 }, /* #21 */
    { 0x1a5146, 0x1a5903, 0x81fc, 0x9e7c, 0xa1, 0 }, /* #22 */
    { 0x200b12, 0x200b03, 0x009b, 0x0c1c, 0x14, 0 }, /* #23 */
    { 0x373193, 0x373983, 0x940f, 0x0ed3, 0xfd, 0 }, /* #24 */
    { 0x0c3cd6, 0x0c3c07, 0x0147, 0x0d09, 0x2f, 0 }, /* #25 */
    { 0x1050c2, 0x105887, 0x5cd4, 0x61b8, 0x76, 0 }, /* #26 */
    { 0x057217, 0x057a03, 0x4303, 0x0261, 0xcb, 0 }, /* #27 */
    { 0x050d57, 0x050d07, 0x47a2, 0x4314, 0x6a, 0 }, /* #28 */
    { 0x163716, 0x163f87, 0x6dc9, 0x8af9, 0xb1, 0 }, /* #29 */
    { 0x076052, 0x076883, 0x2577, 0x35ec, 0x74, 0 }, /* #30 */
    { 0x095102, 0x095907, 0x72d4, 0x0848, 0x0a, 0 }, /* #31 */
    { 0x356c86, 0x356c07, 0x399f, 0x3747, 0x59, 0 }, /* #32 */
    { 0x2a6283, 0x2a6a07, 0x2a42, 0x3078, 0xbc, 0 }, /* #33 */
    { 0x3a0ec7, 0x3a0e03, 0xc39d, 0x3732, 0x5a, 0 }, /* #34 */
    { 0x075086, 0x075803, 0x9dbc, 0x2b54, 0x3b, 0 }, /* #35 */
    { 0x0b6306, 0x0b6b03, 0x79aa, 0x9b64, 0xea, 0 }, /* #36 */
    { 0x3f3003, 0x3f3883, 0xb5ec, 0x19d0, 0x1c, 0 }, /* #37 */
    { 0x0548c2, 0x054887, 0xf0dd, 0x07c5, 0x09, 0 }, /* #38 */
    { 0x1b3557, 0x1b3d87, 0xe0fa, 0x8f8e, 0x93, 0 }, /* #39 */
    { 0x307e13, 0x307e07, 0x30a2, 0x412e, 0x67, 0 }, /* #40 */
    { 0x262a53, 0x262a07, 0x9cb4, 0x783c, 0xab, 0 }, /* #41 */
    { 0x3a7896, 0x3a7807, 0xefbe, 0x2224, 0x2e, 0 }, /* #42 */
    { 0x1c7782, 0x1c7f83, 0x338b, 0x10d5, 0x1f, 0 }, /* #43 */
    { 0x0921c3, 0x092903, 0x64f2, 0x9740, 0xa0, 0 }, /* #44 */
    { 0x321dd6, 0x321d07, 0xb6dc, 0x346c, 0x3d, 0 }, /* #45 */
    { 0x291692, 0x291e03, 0x8e6e, 0x497a, 0xab, 0 }, /* #46 */
    { 0x273283, 0x273a83, 0xa0c4, 0x78f8, 0x9e, 0 }, /* #47 */
    { 0x367f83, 0x367f87, 0xd27d, 0x278d, 0x51, 0 }, /* #48 */
    { 0x2e7b03, 0x2e7b03, 0xb05e, 0x2864, 0x6e, 0 }, /* #49 */
    { 0x2f4556, 0x2f4d07, 0x2dad, 0x2324, 0x34, 0 }, /* #50 */
    { 0x270b82, 0x270b87, 0x44e7, 0x95ca, 0xa6, 0 }, /* #51 */
    { 0x263886, 0x263887, 0x0c60, 0x06c0, 0x12, 0 }, /* #52 */
    { 0x051286, 0x051a07, 0xe6d0, 0x0750, 0x09, 0 }, /* #53 */
    { 0x396e03, 0x396e07, 0x7740, 0x0300, 0x0c, 0 }, /* #54 */
    { 0x0a6ac6, 0x0a6a87, 0x6294, 0x7bb8, 0xd6, 0 }, /* #55 */
    { 0x2a1c82, 0x2a1c87, 0x3933, 0x05fa, 0x1e, 0 }, /* #56 */
    { 0x195b47, 0x195b87, 0x9129, 0x20ac, 0xcc, 0 }, /* #57 */
    { 0x375dc2, 0x375d07, 0xcbdc, 0x6644, 0x77, 0 }, /* #58 */
    { 0x254ed3, 0x254e07, 0xfa65, 0x4833, 0xb7, 0 }, /* #59 */
    { 0x374b13, 0x374b87, 0xcb60, 0x32a0, 0x87, 0 }, /* #60 */
    { 0x224403, 0x224c87, 0xfe86, 0x14f0, 0x28, 0 }, /* #61 */
    { 0x104c86, 0x104c87, 0xf60e, 0x04fa, 0x5b, 0 }, /* #62 */
    { 0x194dd3, 0x194586, 0x1d11, 0x00dd, 0x0d, 0 }, /* #63 */
    { 0x246b93, 0x246b87, 0x94fe, 0x388e, 0x39, 0 }, /* #64 */
    { 0x0d4497, 0x0d4c03, 0x07e4, 0xb220, 0xc8, 0 }, /* #65 */
    { 0x0c5742, 0x0c5f07, 0x70a8, 0x3330, 0x4e, 0 }, /* #66 */
    { 0x1a2dd7, 0x1a2d83, 0x40eb, 0xccb5, 0xdf, 0 }, /* #67 */
    { 0x076fc7, 0x076f03, 0x23a9, 0x9c75, 0xed, 0 }, /* #68 */
    { 0x366457, 0x366c03, 0xbea3, 0x832a, 0xce, 0 }, /* #69 */
    { 0x1158c2, 0x115887, 0x1c65, 0x1ad4, 0x44, 0 }, /* #70 */
    { 0x142a46, 0x142286, 0x90e7, 0x00e7, 0x01, 0 }, /* #71 */
    { 0x295d12, 0x295d87, 0x1563, 0x42e7, 0xad, 0 }, /* #72 */
    { 0x0155d3, 0x015d83, 0x4c23, 0x02bc, 0x14, 0 }, /* #73 */
    { 0x076793, 0x076f83, 0xd87a, 0x19bc, 0x36, 0 }, /* #74 */
    { 0x1902d7, 0x190a03, 0x8727, 0x263d, 0xfb, 0 }, /* #75 */
    { 0x081896, 0x081887, 0x8a18, 0x0690, 0x46, 0 }, /* #76 */
    { 0x3d6817, 0x3d6807, 0x9fd1, 0x802d, 0x9d, 0 }, /* #77 */
    { 0x132d47, 0x132d03, 0x308e, 0x797a, 0xdb, 0 }, /* #78 */
    { 0x3e3cc2, 0x3e3c03, 0x6c91, 0x4367, 0x77, 0 }, /* #79 */
    { 0x1b0092, 0x1b0807, 0x17ed, 0x465c, 0x4c, 0 }, /* #80 */
    { 0x0011d6, 0x001987, 0x02c9, 0x3bac, 0x4c, 0 }, /* #81 */
    { 0x0146c6, 0x014e03, 0xa127, 0x115e, 0x72, 0 }, /* #82 */
    { 0x205883, 0x205887, 0xfc98, 0x79b8, 0xcd, 0 }, /* #83 */
    { 0x263052, 0x263883, 0x692b, 0x29a8, 0xf8, 0 }, /* #84 */
    { 0x026c97, 0x026c03, 0x6172, 0x0804, 0x12, 0 }, /* #85 */
    { 0x1e3742, 0x1e3f07, 0x3855, 0x0a4b, 0x1f, 0 }, /* #86 */
    { 0x001942, 0x001987, 0x6622, 0x1496, 0x9b, 0 }, /* #87 */
    { 0x0c7417, 0x0c7c07, 0xa521, 0x0528, 0x28, 0 }, /* #88 */
    { 0x042f97, 0x042f03, 0x19f3, 0xe004, 0xec, 0 }, /* #89 */
    { 0x0b2d16, 0x0b2d83, 0x0b9a, 0x89c2, 0xe5, 0 }, /* #90 */
    { 0x3019d2, 0x301907, 0xbc6e, 0x452e, 0xa1, 0 }, /* #91 */
    { 0x0c2003, 0x0c2883, 0xc9f5, 0xa686, 0xae, 0 }, /* #92 */
    { 0x346ac7, 0x346a03, 0xae0b, 0x0a5b, 0xf1, 0 }, /* #93 */
    { 0x1d5a92, 0x1d5a03, 0x9d85, 0x0532, 0x0a, 0 }, /* #94 */
    { 0x043553, 0x043d83, 0x3359, 0x09bc, 0x1c, 0 }, /* #95 */
};
uint32_t const g_cTests_mul_u8_intel = RT_ELEMENTS(g_aTests_mul_u8_intel);

MULDIVU8_TEST_T const g_aTests_imul_u8_intel[] =
{
    { 0x2a5487, 0x2a5406, 0x0000, 0x0000, 0x00, 0 }, /* #0 */
    { 0x2c43c2, 0x2c4306, 0x0000, 0x0000, 0x00, 0 }, /* #1 */
    { 0x1b6192, 0x1b6106, 0x0000, 0x0000, 0x00, 0 }, /* #2 */
    { 0x183c12, 0x183406, 0x0000, 0x0000, 0x00, 0 }, /* #3 */
    { 0x2d7f13, 0x2d7706, 0x0000, 0x0000, 0x00, 0 }, /* #4 */
    { 0x2e6892, 0x2e6006, 0x0000, 0x0000, 0x00, 0 }, /* #5 */
    { 0x387006, 0x387006, 0xbcfa, 0x0000, 0x00, 0 }, /* #6 */
    { 0x173b52, 0x173306, 0x7d78, 0x0000, 0x00, 0 }, /* #7 */
    { 0x023ed7, 0x023606, 0x4790, 0x0000, 0x00, 0 }, /* #8 */
    { 0x167353, 0x167306, 0x2af1, 0x0000, 0x00, 0 }, /* #9 */
    { 0x2104c7, 0x210406, 0x0e3b, 0x0000, 0x00, 0 }, /* #10 */
    { 0x283bc3, 0x283306, 0x1e9c, 0x0000, 0x00, 0 }, /* #11 */
    { 0x095e87, 0x095e83, 0x037b, 0x2f91, 0x63, 0 }, /* #12 */
    { 0x094197, 0x094987, 0x1f98, 0x2288, 0xab, 0 }, /* #13 */
    { 0x081846, 0x081807, 0x0e17, 0x0228, 0x18, 0 }, /* #14 */
    { 0x031396, 0x031b87, 0xec14, 0xfba0, 0xc8, 0 }, /* #15 */
    { 0x3c6103, 0x3c6987, 0xa343, 0xf3f6, 0xd2, 0 }, /* #16 */
    { 0x094582, 0x094d83, 0x2025, 0xfaa7, 0xdb, 0 }, /* #17 */
    { 0x0e2143, 0x0e2987, 0xe440, 0x07c0, 0x1f, 0 }, /* #18 */
    { 0x323cd3, 0x323c03, 0x8ed7, 0xf545, 0x43, 0 }, /* #19 */
    { 0x346617, 0x346e03, 0xa07a, 0x016e, 0x03, 0 }, /* #20 */
    { 0x3e0782, 0x3e0f03, 0x297f, 0xe13e, 0xc2, 0 }, /* #21 */
    { 0x123fd3, 0x123f07, 0xd884, 0xe55c, 0x37, 0 }, /* #22 */
    { 0x341ad7, 0x341a83, 0x647e, 0xf7a2, 0xef, 0 }, /* #23 */
    { 0x393506, 0x393d87, 0x6f6b, 0xf1ca, 0xde, 0 }, /* #24 */
    { 0x205f53, 0x205f07, 0xa552, 0xe660, 0xb0, 0 }, /* #25 */
    { 0x177602, 0x177e87, 0xc88d, 0xfb82, 0x0a, 0 }, /* #26 */
    { 0x2f0107, 0x2f0907, 0x3d54, 0x0c24, 0x25, 0 }, /* #27 */
    { 0x196d46, 0x196d83, 0x9550, 0xdee0, 0x96, 0 }, /* #28 */
    { 0x0777d7, 0x077f87, 0x54e6, 0xfca6, 0x21, 0 }, /* #29 */
    { 0x2d21d2, 0x2d2903, 0x6148, 0x1710, 0x52, 0 }, /* #30 */
    { 0x2947d6, 0x294706, 0xc265, 0x0000, 0x00, 0 }, /* #31 */
    { 0x3c7f06, 0x3c7702, 0x9617, 0x0045, 0x03, 0 }, /* #32 */
    { 0x3a2993, 0x3a2106, 0x9e0f, 0x002d, 0x03, 0 }, /* #33 */
    { 0x190096, 0x190887, 0x802e, 0x01fa, 0x0b, 0 }, /* #34 */
    { 0x0153c7, 0x015b87, 0x1818, 0xfa90, 0xc6, 0 }, /* #35 */
    { 0x390082, 0x390883, 0xb3e3, 0xfdd9, 0x13, 0 }, /* #36 */
    { 0x040887, 0x040807, 0xa753, 0xef77, 0xcd, 0 }, /* #37 */
    { 0x0f0097, 0x0f0883, 0x1d5a, 0xf2a4, 0xda, 0 }, /* #38 */
    { 0x397346, 0x397b03, 0x18e4, 0x0834, 0xb5, 0 }, /* #39 */
    { 0x1229c6, 0x122907, 0x065a, 0x1b6c, 0x4e, 0 }, /* #40 */
    { 0x287606, 0x287e07, 0x7083, 0x186a, 0xce, 0 }, /* #41 */
    { 0x264903, 0x264987, 0x2932, 0x0dde, 0x47, 0 }, /* #42 */
    { 0x153fc3, 0x153f07, 0xcd7d, 0x2422, 0x4a, 0 }, /* #43 */
    { 0x317bd7, 0x317b87, 0x23a2, 0xd682, 0x71, 0 }, /* #44 */
    { 0x254f16, 0x254f03, 0xce60, 0x0840, 0x16, 0 }, /* #45 */
    { 0x002647, 0x002e07, 0x6c5c, 0xe848, 0xbe, 0 }, /* #46 */
    { 0x007553, 0x007d87, 0xde15, 0xf7e1, 0x9d, 0 }, /* #47 */
    { 0x1862d6, 0x186a87, 0xaf60, 0x09c0, 0x1a, 0 }, /* #48 */
    { 0x3831c3, 0x383907, 0xfa80, 0xd100, 0x5e, 0 }, /* #49 */
    { 0x211456, 0x211c87, 0x15e2, 0xfed4, 0x0a, 0 }, /* #50 */
    { 0x333656, 0x333602, 0x04ff, 0x000d, 0xf3, 0 }, /* #51 */
    { 0x106446, 0x106c07, 0x4766, 0xee78, 0xd4, 0 }, /* #52 */
    { 0x262d56, 0x262d87, 0x8fa8, 0xe690, 0x4a, 0 }, /* #53 */
    { 0x1f3ad6, 0x1f3a03, 0x1f8e, 0x3252, 0x8f, 0 }, /* #54 */
    { 0x0e3c83, 0x0e3c83, 0x6ee4, 0x08f8, 0xae, 0 }, /* #55 */
    { 0x1276d3, 0x127e07, 0x5508, 0xfd50, 0xaa, 0 }, /* #56 */
    { 0x3b3653, 0x3b3e07, 0xff35, 0xf044, 0xb4, 0 }, /* #57 */
    { 0x1f4342, 0x1f4b03, 0xffca, 0x010e, 0xfb, 0 }, /* #58 */
    { 0x040007, 0x040883, 0x3b49, 0xe2a1, 0x99, 0 }, /* #59 */
    { 0x0a2986, 0x0a2903, 0xeac9, 0x127a, 0xaa, 0 }, /* #60 */
    { 0x053486, 0x053c83, 0x2472, 0x20f4, 0x4a, 0 }, /* #61 */
    { 0x060883, 0x060803, 0xe222, 0xf362, 0xa1, 0 }, /* #62 */
    { 0x360916, 0x360983, 0xe7ae, 0x10a8, 0xcc, 0 }, /* #63 */
    { 0x363b43, 0x363b07, 0x14f1, 0x0348, 0xc8, 0 }, /* #64 */
    { 0x260dd7, 0x260d87, 0x7649, 0xe4a0, 0xa0, 0 }, /* #65 */
    { 0x305853, 0x305803, 0x7d2a, 0xff04, 0xfa, 0 }, /* #66 */
    { 0x0e6e13, 0x0e6e87, 0x4e9c, 0xfed4, 0x03, 0 }, /* #67 */
    { 0x264b93, 0x264b87, 0xba8c, 0xdad8, 0x52, 0 }, /* #68 */
    { 0x265502, 0x265d03, 0xe9f3, 0xfe46, 0x22, 0 }, /* #69 */
    { 0x3b7712, 0x3b7f87, 0x5b6c, 0xfaf0, 0xf4, 0 }, /* #70 */
    { 0x216e53, 0x216e87, 0x8df3, 0xf9db, 0x79, 0 }, /* #71 */
    { 0x000c82, 0x000c83, 0x8905, 0x00e6, 0x2e, 0 }, /* #72 */
    { 0x0a7792, 0x0a7f87, 0x01f2, 0xfcaa, 0x3d, 0 }, /* #73 */
    { 0x1a5816, 0x1a5082, 0xb704, 0xffa4, 0xe9, 0 }, /* #74 */
    { 0x345bd3, 0x345b03, 0x72d8, 0xed68, 0x77, 0 }, /* #75 */
    { 0x2b2f53, 0x2b2f03, 0x0b64, 0xce64, 0x81, 0 }, /* #76 */
    { 0x360cd7, 0x360c83, 0x6ae9, 0xfea7, 0x0f, 0 }, /* #77 */
    { 0x395442, 0x395c07, 0x368f, 0xd928, 0x58, 0 }, /* #78 */
    { 0x2c5613, 0x2c5e03, 0x0f0b, 0xfc64, 0xac, 0 }, /* #79 */
    { 0x0e6607, 0x0e6e03, 0xb473, 0x2c79, 0x63, 0 }, /* #80 */
    { 0x0d6346, 0x0d6b07, 0x0c06, 0xfe74, 0xbe, 0 }, /* #81 */
    { 0x176552, 0x176d83, 0x18fa, 0x01b6, 0xb7, 0 }, /* #82 */
    { 0x313b03, 0x313b87, 0x4f1e, 0xfad8, 0xd4, 0 }, /* #83 */
    { 0x2e42d7, 0x2e4a03, 0x02fb, 0x021c, 0x94, 0 }, /* #84 */
    { 0x137896, 0x137803, 0x9b1a, 0xf710, 0xa8, 0 }, /* #85 */
    { 0x175c12, 0x175406, 0x3000, 0x0000, 0xe2, 0 }, /* #86 */
    { 0x1e14d3, 0x1e1c03, 0xd49c, 0x1964, 0xbf, 0 }, /* #87 */
    { 0x2a5d46, 0x2a5d87, 0xcd68, 0xf090, 0xda, 0 }, /* #88 */
    { 0x060a82, 0x060a87, 0xbd37, 0x108b, 0x4d, 0 }, /* #89 */
    { 0x2d40d6, 0x2d4883, 0xf791, 0xcb89, 0x79, 0 }, /* #90 */
    { 0x0f4c56, 0x0f4c03, 0x3ac9, 0xf31c, 0x3c, 0 }, /* #91 */
    { 0x135147, 0x135987, 0xeb39, 0xf2dd, 0xc5, 0 }, /* #92 */
    { 0x142cd6, 0x142c03, 0x6e1f, 0xf51a, 0xa6, 0 }, /* #93 */
    { 0x1e4746, 0x1e4f07, 0x9f50, 0x1e50, 0x61, 0 }, /* #94 */
    { 0x192c47, 0x192c83, 0x3d3f, 0xead6, 0xaa, 0 }, /* #95 */
};
uint32_t const g_cTests_imul_u8_intel = RT_ELEMENTS(g_aTests_imul_u8_intel);

MULDIVU8_TEST_T const g_aTests_div_u8_intel[] =
{
    { 0x151783, 0x151783, 0x0000, 0x0000, 0x00, -1 }, /* #0 */
    { 0x0e4703, 0x0e4703, 0x0000, 0x0000, 0x00, -1 }, /* #1 */
    { 0x1e0083, 0x1e0083, 0x0000, 0x0000, 0x00, -1 }, /* #2 */
    { 0x154082, 0x154082, 0x0000, 0x0000, 0x00, -1 }, /* #3 */
    { 0x396403, 0x396403, 0x0000, 0x0000, 0x00, -1 }, /* #4 */
    { 0x101842, 0x101842, 0x0000, 0x0000, 0x00, -1 }, /* #5 */
    { 0x2517d3, 0x2517d3, 0xbb03, 0xbb03, 0x00, -1 }, /* #6 */
    { 0x1958c2, 0x1958c2, 0xf552, 0xf552, 0x00, -1 }, /* #7 */
    { 0x1a2312, 0x1a2312, 0x9d51, 0x9d51, 0x00, -1 }, /* #8 */
    { 0x2406d3, 0x2406d3, 0x510d, 0x510d, 0x00, -1 }, /* #9 */
    { 0x350793, 0x350793, 0x33e2, 0x33e2, 0x00, -1 }, /* #10 */
    { 0x3520c6, 0x3520c6, 0x216c, 0x216c, 0x00, -1 }, /* #11 */
    { 0x073ec2, 0x073ec2, 0xa3fb, 0xa3fb, 0x26, -1 }, /* #12 */
    { 0x0a34d6, 0x0a34d6, 0xbf2c, 0xbf2c, 0xb2, -1 }, /* #13 */
    { 0x057106, 0x057106, 0x675c, 0x675c, 0x56, -1 }, /* #14 */
    { 0x366482, 0x366482, 0x585e, 0xb666, 0xdc, 0 }, /* #15 */
    { 0x0934d3, 0x0934d3, 0xadd5, 0x09e3, 0xc4, 0 }, /* #16 */
    { 0x300046, 0x300046, 0x1904, 0x0a8b, 0x2e, 0 }, /* #17 */
    { 0x011602, 0x011602, 0xa420, 0xa420, 0x64, -1 }, /* #18 */
    { 0x2540c3, 0x2540c3, 0x7e2d, 0x8ad5, 0x97, 0 }, /* #19 */
    { 0x2054d6, 0x2054d6, 0x4701, 0x33ab, 0x6a, 0 }, /* #20 */
    { 0x347dd7, 0x347dd7, 0xa374, 0xa374, 0x26, -1 }, /* #21 */
    { 0x2f55c6, 0x2f55c6, 0x077c, 0x0c88, 0x0e, 0 }, /* #22 */
    { 0x346c46, 0x346c46, 0x6c63, 0x6c63, 0x1a, -1 }, /* #23 */
    { 0x1a1b92, 0x1a1b92, 0x940a, 0x940a, 0x4b, -1 }, /* #24 */
    { 0x0e3492, 0x0e3492, 0xb3fb, 0x8be8, 0xc6, 0 }, /* #25 */
    { 0x004fc7, 0x004fc7, 0x9cdc, 0x9cdc, 0x55, -1 }, /* #26 */
    { 0x356743, 0x356743, 0x948b, 0x30a3, 0xe9, 0 }, /* #27 */
    { 0x3a2b52, 0x3a2b52, 0x108c, 0x3f27, 0x6b, 0 }, /* #28 */
    { 0x312082, 0x312082, 0x341a, 0x2dd3, 0x3f, 0 }, /* #29 */
    { 0x1a4c47, 0x1a4c47, 0xff44, 0xff44, 0xfa, -1 }, /* #30 */
    { 0x0718d3, 0x0718d3, 0x0ed1, 0xd110, 0xe0, 0 }, /* #31 */
    { 0x083092, 0x083092, 0xcde0, 0xa6da, 0xf1, 0 }, /* #32 */
    { 0x066ed3, 0x066ed3, 0xf490, 0xf490, 0xf4, -1 }, /* #33 */
    { 0x1740d6, 0x1740d6, 0x3951, 0x4d52, 0xb2, 0 }, /* #34 */
    { 0x3f1482, 0x3f1482, 0x1858, 0x1858, 0x01, -1 }, /* #35 */
    { 0x232bd2, 0x232bd2, 0x0d8e, 0x4e10, 0xd4, 0 }, /* #36 */
    { 0x0c0916, 0x0c0916, 0x51e0, 0x1bad, 0x79, 0 }, /* #37 */
    { 0x106d56, 0x106d56, 0x3a40, 0x4074, 0x80, 0 }, /* #38 */
    { 0x3b3102, 0x3b3102, 0x2850, 0x6c45, 0x94, 0 }, /* #39 */
    { 0x0c0447, 0x0c0447, 0x181e, 0x181e, 0x13, -1 }, /* #40 */
    { 0x046283, 0x046283, 0x6f72, 0x8ab6, 0x9c, 0 }, /* #41 */
    { 0x014f57, 0x014f57, 0xbdd0, 0xbdd0, 0x05, -1 }, /* #42 */
    { 0x1a4f93, 0x1a4f93, 0x33f6, 0x4e98, 0x57, 0 }, /* #43 */
    { 0x197296, 0x197296, 0x4bec, 0x48bc, 0x67, 0 }, /* #44 */
    { 0x086682, 0x086682, 0x9536, 0x9536, 0x71, -1 }, /* #45 */
    { 0x2e4a97, 0x2e4a97, 0xad5e, 0xad5e, 0x0d, -1 }, /* #46 */
    { 0x063592, 0x063592, 0xb047, 0xb047, 0x13, -1 }, /* #47 */
    { 0x323717, 0x323717, 0x90b1, 0x90b1, 0x15, -1 }, /* #48 */
    { 0x310c02, 0x310c02, 0xf29c, 0xf29c, 0x6a, -1 }, /* #49 */
    { 0x174ed7, 0x174ed7, 0xd25d, 0xd25d, 0x6e, -1 }, /* #50 */
    { 0x340557, 0x340557, 0x1127, 0x9515, 0xca, 0 }, /* #51 */
    { 0x106383, 0x106383, 0xc88a, 0xc88a, 0x68, -1 }, /* #52 */
    { 0x391413, 0x391413, 0x5aee, 0x3b6b, 0xd9, 0 }, /* #53 */
    { 0x0d43d6, 0x0d43d6, 0x1b33, 0x841b, 0xfd, 0 }, /* #54 */
    { 0x3c2942, 0x3c2942, 0x4746, 0x4746, 0x08, -1 }, /* #55 */
    { 0x253496, 0x253496, 0xdeed, 0xdeed, 0x1d, -1 }, /* #56 */
    { 0x163f43, 0x163f43, 0x41d6, 0x4e48, 0xe9, 0 }, /* #57 */
    { 0x002606, 0x002606, 0x8555, 0x8555, 0x6d, -1 }, /* #58 */
    { 0x1246d3, 0x1246d3, 0x6ab2, 0x227c, 0xdc, 0 }, /* #59 */
    { 0x316c56, 0x316c56, 0x0469, 0x3105, 0xd8, 0 }, /* #60 */
    { 0x1d7783, 0x1d7783, 0xf2a2, 0xf2a2, 0x8e, -1 }, /* #61 */
    { 0x2c6082, 0x2c6082, 0x5caf, 0x5caf, 0x21, -1 }, /* #62 */
    { 0x161257, 0x161257, 0x274c, 0xa633, 0xc2, 0 }, /* #63 */
    { 0x2f1407, 0x2f1407, 0xa36f, 0xa36f, 0x4d, -1 }, /* #64 */
    { 0x176e87, 0x176e87, 0x9f03, 0xc3c0, 0xd3, 0 }, /* #65 */
    { 0x027d52, 0x027d52, 0xaeb3, 0xaeb3, 0x59, -1 }, /* #66 */
    { 0x1659d7, 0x1659d7, 0x28dc, 0x28dc, 0x05, -1 }, /* #67 */
    { 0x1510c3, 0x1510c3, 0x19d8, 0x0193, 0x2d, 0 }, /* #68 */
    { 0x231397, 0x231397, 0x1501, 0x083b, 0x5b, 0 }, /* #69 */
    { 0x273316, 0x273316, 0x2ce7, 0x6b34, 0xdb, 0 }, /* #70 */
    { 0x184617, 0x184617, 0xf06f, 0xf06f, 0x45, -1 }, /* #71 */
    { 0x041803, 0x041803, 0xb6c8, 0xb6c8, 0x84, -1 }, /* #72 */
    { 0x1810c3, 0x1810c3, 0xf011, 0xcffa, 0xf5, 0 }, /* #73 */
    { 0x2c1ad7, 0x2c1ad7, 0x987f, 0x987f, 0x4e, -1 }, /* #74 */
    { 0x0d7796, 0x0d7796, 0x2c46, 0x0467, 0x6e, 0 }, /* #75 */
    { 0x3b2946, 0x3b2946, 0xb161, 0xb161, 0x03, -1 }, /* #76 */
    { 0x234c46, 0x234c46, 0x5e94, 0x5e94, 0x4b, -1 }, /* #77 */
    { 0x0a7147, 0x0a7147, 0x947b, 0x947b, 0x75, -1 }, /* #78 */
    { 0x395157, 0x395157, 0xdf88, 0xdf88, 0x87, -1 }, /* #79 */
    { 0x2d5e56, 0x2d5e56, 0x65ac, 0x8f9b, 0xa7, 0 }, /* #80 */
    { 0x102fc7, 0x102fc7, 0x5440, 0x32cb, 0x6a, 0 }, /* #81 */
    { 0x1f1207, 0x1f1207, 0xa175, 0x05f6, 0xa8, 0 }, /* #82 */
    { 0x021443, 0x021443, 0x4d7e, 0x3ad7, 0x5c, 0 }, /* #83 */
    { 0x294806, 0x294806, 0x4a76, 0x4a76, 0x1c, -1 }, /* #84 */
    { 0x244817, 0x244817, 0x8078, 0x8d8f, 0xe5, 0 }, /* #85 */
    { 0x2a0f92, 0x2a0f92, 0xd540, 0xd540, 0x4f, -1 }, /* #86 */
    { 0x1d4e87, 0x1d4e87, 0x7d69, 0x7d69, 0x63, -1 }, /* #87 */
    { 0x0e4dc7, 0x0e4dc7, 0x60a1, 0x589d, 0x9d, 0 }, /* #88 */
    { 0x3f2807, 0x3f2807, 0xb866, 0x38e6, 0xcd, 0 }, /* #89 */
    { 0x3e2f13, 0x3e2f13, 0x5a59, 0x2d74, 0xc7, 0 }, /* #90 */
    { 0x273607, 0x273607, 0xd89c, 0xd89c, 0xaa, -1 }, /* #91 */
    { 0x032d03, 0x032d03, 0x56f3, 0x56f3, 0x20, -1 }, /* #92 */
    { 0x0c3f52, 0x0c3f52, 0x0dbe, 0x0875, 0x1e, 0 }, /* #93 */
    { 0x251ed2, 0x251ed2, 0xf79f, 0xf79f, 0x41, -1 }, /* #94 */
    { 0x353a82, 0x353a82, 0x0883, 0x150d, 0xa6, 0 }, /* #95 */
};
uint32_t const g_cTests_div_u8_intel = RT_ELEMENTS(g_aTests_div_u8_intel);

MULDIVU8_TEST_T const g_aTests_idiv_u8_intel[] =
{
    { 0x184116, 0x184116, 0x0000, 0x0000, 0x00, -1 }, /* #0 */
    { 0x1a45c3, 0x1a45c3, 0x0000, 0x0000, 0x00, -1 }, /* #1 */
    { 0x3f4f02, 0x3f4f02, 0x0000, 0x0000, 0x00, -1 }, /* #2 */
    { 0x2a79c3, 0x2a79c3, 0x0000, 0x0000, 0x00, -1 }, /* #3 */
    { 0x351a82, 0x351a82, 0x0000, 0x0000, 0x00, -1 }, /* #4 */
    { 0x3129c2, 0x3129c2, 0x0000, 0x0000, 0x00, -1 }, /* #5 */
    { 0x203f16, 0x203f16, 0x9b64, 0x9b64, 0x00, -1 }, /* #6 */
    { 0x2a10c6, 0x2a10c6, 0x8f72, 0x8f72, 0x00, -1 }, /* #7 */
    { 0x273e16, 0x273e16, 0xc8ec, 0xc8ec, 0x00, -1 }, /* #8 */
    { 0x284e96, 0x284e96, 0x096e, 0x096e, 0x00, -1 }, /* #9 */
    { 0x257103, 0x257103, 0x71b7, 0x71b7, 0x00, -1 }, /* #10 */
    { 0x123302, 0x123302, 0x8a4b, 0x8a4b, 0x00, -1 }, /* #11 */
    { 0x2f0483, 0x2f0483, 0xda39, 0xda39, 0x1b, -1 }, /* #12 */
    { 0x3f4453, 0x3f4453, 0x9631, 0x9631, 0xd2, -1 }, /* #13 */
    { 0x0072d6, 0x0072d6, 0xdae4, 0xdae4, 0x48, -1 }, /* #14 */
    { 0x0d5c86, 0x0d5c86, 0xa422, 0xa422, 0x2c, -1 }, /* #15 */
    { 0x1c5306, 0x1c5306, 0x84bf, 0x84bf, 0x62, -1 }, /* #16 */
    { 0x1d2a86, 0x1d2a86, 0x9326, 0x9326, 0x4e, -1 }, /* #17 */
    { 0x1c1046, 0x1c1046, 0xb57a, 0xb57a, 0x43, -1 }, /* #18 */
    { 0x0a5e83, 0x0a5e83, 0x65ed, 0x65ed, 0xd6, -1 }, /* #19 */
    { 0x171946, 0x171946, 0xc523, 0xc523, 0xfe, -1 }, /* #20 */
    { 0x0225c7, 0x0225c7, 0xaddd, 0xaddd, 0xde, -1 }, /* #21 */
    { 0x275a12, 0x275a12, 0x3ce6, 0x3ce6, 0x19, -1 }, /* #22 */
    { 0x033443, 0x033443, 0x85b0, 0x85b0, 0x94, -1 }, /* #23 */
    { 0x1d3616, 0x1d3616, 0xd5b4, 0xd5b4, 0xf8, -1 }, /* #24 */
    { 0x3d7896, 0x3d7896, 0x98dd, 0x98dd, 0x28, -1 }, /* #25 */
    { 0x2c4e02, 0x2c4e02, 0x1c5b, 0x1c5b, 0xd7, -1 }, /* #26 */
    { 0x275ad7, 0x275ad7, 0xa074, 0xa074, 0x90, -1 }, /* #27 */
    { 0x071e12, 0x071e12, 0x0cab, 0x39ca, 0xc5, 0 }, /* #28 */
    { 0x013fd6, 0x013fd6, 0xc6b9, 0xc6b9, 0x6e, -1 }, /* #29 */
    { 0x2d70d2, 0x2d70d2, 0x717f, 0x717f, 0x88, -1 }, /* #30 */
    { 0x106a93, 0x106a93, 0x3c63, 0x3c63, 0x01, -1 }, /* #31 */
    { 0x0e6492, 0x0e6492, 0x7631, 0x7631, 0x4c, -1 }, /* #32 */
    { 0x1a0397, 0x1a0397, 0x33d4, 0x3c68, 0x7f, 0 }, /* #33 */
    { 0x324292, 0x324292, 0x9027, 0x9027, 0xa9, -1 }, /* #34 */
    { 0x126342, 0x126342, 0x6d2e, 0x6d2e, 0x5d, -1 }, /* #35 */
    { 0x116d12, 0x116d12, 0x7441, 0x7441, 0xe7, -1 }, /* #36 */
    { 0x2c7707, 0x2c7707, 0x9a04, 0x9a04, 0xdd, -1 }, /* #37 */
    { 0x177506, 0x177506, 0x01c7, 0x0d1a, 0x11, 0 }, /* #38 */
    { 0x322502, 0x322502, 0x0179, 0x1411, 0x15, 0 }, /* #39 */
    { 0x086682, 0x086682, 0x13e7, 0x13ca, 0xa2, 0 }, /* #40 */
    { 0x276a02, 0x276a02, 0xf598, 0xf598, 0x13, -1 }, /* #41 */
    { 0x2b53d6, 0x2b53d6, 0xd502, 0xaa88, 0x5b, 0 }, /* #42 */
    { 0x0a4816, 0x0a4816, 0xe4dd, 0xe4dd, 0x35, -1 }, /* #43 */
    { 0x2c6b42, 0x2c6b42, 0x0033, 0x3300, 0x9d, 0 }, /* #44 */
    { 0x382286, 0x382286, 0x3454, 0x627a, 0x6d, 0 }, /* #45 */
    { 0x225082, 0x225082, 0x8f7d, 0x8f7d, 0x78, -1 }, /* #46 */
    { 0x2871c6, 0x2871c6, 0xca1b, 0xca1b, 0x30, -1 }, /* #47 */
    { 0x260117, 0x260117, 0xefad, 0xe3ad, 0x32, 0 }, /* #48 */
    { 0x3844d6, 0x3844d6, 0xc210, 0x9683, 0x7e, 0 }, /* #49 */
    { 0x3e0cd7, 0x3e0cd7, 0x4197, 0x4197, 0x58, -1 }, /* #50 */
    { 0x346156, 0x346156, 0x7827, 0x7827, 0xad, -1 }, /* #51 */
    { 0x3c4107, 0x3c4107, 0x88ef, 0x88ef, 0x93, -1 }, /* #52 */
    { 0x3a0417, 0x3a0417, 0x1ec1, 0x1d6a, 0x4a, 0 }, /* #53 */
    { 0x1274c3, 0x1274c3, 0x355e, 0x355e, 0x9d, -1 }, /* #54 */
    { 0x382d53, 0x382d53, 0x461c, 0x461c, 0x86, -1 }, /* #55 */
    { 0x005f86, 0x005f86, 0xccce, 0xccce, 0x19, -1 }, /* #56 */
    { 0x333386, 0x333386, 0x0348, 0x0088, 0xf9, 0 }, /* #57 */
    { 0x056916, 0x056916, 0xebf6, 0xebf6, 0x0c, -1 }, /* #58 */
    { 0x1b1193, 0x1b1193, 0x0ef5, 0x21cc, 0xb7, 0 }, /* #59 */
    { 0x014186, 0x014186, 0xb1f3, 0xb1f3, 0x9b, -1 }, /* #60 */
    { 0x285082, 0x285082, 0x7929, 0x7929, 0x3b, -1 }, /* #61 */
    { 0x2a7893, 0x2a7893, 0x9a9c, 0x9a9c, 0x8e, -1 }, /* #62 */
    { 0x091552, 0x091552, 0x71d9, 0x71d9, 0x01, -1 }, /* #63 */
    { 0x1d4103, 0x1d4103, 0x455d, 0x455d, 0x17, -1 }, /* #64 */
    { 0x015bc6, 0x015bc6, 0xb909, 0xb909, 0x90, -1 }, /* #65 */
    { 0x2b1c86, 0x2b1c86, 0xfb11, 0xe928, 0xe1, 0 }, /* #66 */
    { 0x3a4692, 0x3a4692, 0xc236, 0xc236, 0xcb, -1 }, /* #67 */
    { 0x1e7e57, 0x1e7e57, 0x74bd, 0x74bd, 0xbe, -1 }, /* #68 */
    { 0x117b53, 0x117b53, 0x78d4, 0x78d4, 0xd6, -1 }, /* #69 */
    { 0x332357, 0x332357, 0x299b, 0x1a55, 0x7d, 0 }, /* #70 */
    { 0x3f0596, 0x3f0596, 0xce04, 0xe571, 0x8f, 0 }, /* #71 */
    { 0x3a12d6, 0x3a12d6, 0x5fa2, 0x5fa2, 0xfa, -1 }, /* #72 */
    { 0x191ec6, 0x191ec6, 0x9bf5, 0x9bf5, 0x3d, -1 }, /* #73 */
    { 0x212883, 0x212883, 0x4b3e, 0x4b3e, 0xe8, -1 }, /* #74 */
    { 0x3b7a47, 0x3b7a47, 0xa7a4, 0xa7a4, 0xd4, -1 }, /* #75 */
    { 0x3c2c02, 0x3c2c02, 0x5a4e, 0x5a4e, 0x7e, -1 }, /* #76 */
    { 0x1f0407, 0x1f0407, 0x38c0, 0x38c0, 0xaf, -1 }, /* #77 */
    { 0x324143, 0x324143, 0x633f, 0x633f, 0x38, -1 }, /* #78 */
    { 0x081152, 0x081152, 0xf4eb, 0xeb58, 0xe0, 0 }, /* #79 */
    { 0x1b5916, 0x1b5916, 0x3ac6, 0x3ac6, 0x70, -1 }, /* #80 */
    { 0x1411c2, 0x1411c2, 0xc1ba, 0xc1ba, 0x38, -1 }, /* #81 */
    { 0x295753, 0x295753, 0x9276, 0x9276, 0xac, -1 }, /* #82 */
    { 0x110453, 0x110453, 0x29d3, 0x29d3, 0x0e, -1 }, /* #83 */
    { 0x3e2192, 0x3e2192, 0x1f13, 0x1f13, 0x0a, -1 }, /* #84 */
    { 0x3d2497, 0x3d2497, 0xc8b1, 0xc8b1, 0xfb, -1 }, /* #85 */
    { 0x0f0786, 0x0f0786, 0x5a13, 0x5a13, 0x12, -1 }, /* #86 */
    { 0x2a7b52, 0x2a7b52, 0xc11b, 0xc11b, 0xc6, -1 }, /* #87 */
    { 0x185097, 0x185097, 0xd5ab, 0xe766, 0x96, 0 }, /* #88 */
    { 0x285b02, 0x285b02, 0x8973, 0x8973, 0x13, -1 }, /* #89 */
    { 0x2c6582, 0x2c6582, 0x492b, 0x492b, 0xfa, -1 }, /* #90 */
    { 0x2f5283, 0x2f5283, 0x8f23, 0x8f23, 0x4b, -1 }, /* #91 */
    { 0x236106, 0x236106, 0xb6b2, 0xb6b2, 0x0c, -1 }, /* #92 */
    { 0x141087, 0x141087, 0xe3a5, 0xe3a5, 0x15, -1 }, /* #93 */
    { 0x134313, 0x134313, 0xf394, 0xd339, 0xc9, 0 }, /* #94 */
    { 0x0d5a12, 0x0d5a12, 0x9142, 0x9142, 0x1c, -1 }, /* #95 */
};
uint32_t const g_cTests_idiv_u8_intel = RT_ELEMENTS(g_aTests_idiv_u8_intel);

MULDIVU16_TEST_T const g_aTests_mul_u16_intel[] =
{
    { 0x017212, 0x017206, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #0 */
    { 0x377083, 0x377006, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #1 */
    { 0x2d6613, 0x2d6606, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #2 */
    { 0x0c0852, 0x0c0006, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #3 */
    { 0x3c0242, 0x3c0206, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #4 */
    { 0x271e12, 0x271606, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #5 */
    { 0x1875c2, 0x187506, 0xa7c9, 0x0000, 0xb330, 0x0000, 0x0000, 0 }, /* #6 */
    { 0x0c1256, 0x0c1206, 0xb738, 0x0000, 0x57a7, 0x0000, 0x0000, 0 }, /* #7 */
    { 0x341bc6, 0x341306, 0x57e1, 0x0000, 0xad36, 0x0000, 0x0000, 0 }, /* #8 */
    { 0x296b06, 0x296306, 0xfc88, 0x0000, 0x7274, 0x0000, 0x0000, 0 }, /* #9 */
    { 0x0d6256, 0x0d6206, 0x2275, 0x0000, 0xf24d, 0x0000, 0x0000, 0 }, /* #10 */
    { 0x162c52, 0x162406, 0x38ac, 0x0000, 0xe3ab, 0x0000, 0x0000, 0 }, /* #11 */
    { 0x193c56, 0x193c07, 0x8895, 0x1e55, 0xcaa0, 0x07df, 0x0ec1, 0 }, /* #12 */
    { 0x2c7747, 0x2c7f03, 0x8ab3, 0x5ba8, 0x8c62, 0x169a, 0x29b8, 0 }, /* #13 */
    { 0x3e1116, 0x3e1987, 0x215f, 0xfe4b, 0x0f6a, 0x16c1, 0xae95, 0 }, /* #14 */
    { 0x0d7297, 0x0d7a03, 0xdbb6, 0x3fc2, 0xfb05, 0x4eea, 0x5bf3, 0 }, /* #15 */
    { 0x1f3f17, 0x1f3f87, 0x8fa6, 0xb7fc, 0xa916, 0x37b6, 0x634a, 0 }, /* #16 */
    { 0x2b4706, 0x2b4f87, 0x44f5, 0xdbc9, 0xbbee, 0x28ad, 0x9705, 0 }, /* #17 */
    { 0x067856, 0x067807, 0x98c0, 0x7900, 0xc760, 0x0a9e, 0x11cc, 0 }, /* #18 */
    { 0x377fd3, 0x377f87, 0xabd8, 0x9d48, 0xb3da, 0x057b, 0x082b, 0 }, /* #19 */
    { 0x055ad7, 0x055a83, 0xef7d, 0xf73e, 0x3945, 0x6d10, 0x7496, 0 }, /* #20 */
    { 0x1768d7, 0x176883, 0xd5ff, 0xc826, 0x4f3c, 0x60d7, 0x73da, 0 }, /* #21 */
    { 0x106143, 0x106987, 0x5bbb, 0xb33c, 0xf17d, 0x5bb6, 0xfff4, 0 }, /* #22 */
    { 0x196653, 0x196e83, 0x7e54, 0x841c, 0x59bc, 0x6248, 0xc72b, 0 }, /* #23 */
    { 0x2e4a13, 0x2e4a03, 0xdbae, 0x664a, 0x4bed, 0xcd6c, 0xef63, 0 }, /* #24 */
    { 0x247882, 0x247887, 0xef5e, 0xe57e, 0x9848, 0x630e, 0x69f1, 0 }, /* #25 */
    { 0x344682, 0x344e87, 0x53ec, 0xe850, 0x6ceb, 0x2d3b, 0x89fc, 0 }, /* #26 */
    { 0x3b6482, 0x3b6c07, 0xffd3, 0x040a, 0x44b3, 0x4f80, 0x4f8e, 0 }, /* #27 */
    { 0x2c4597, 0x2c4d83, 0xa231, 0xb058, 0x5332, 0x5610, 0x87d8, 0 }, /* #28 */
    { 0x1e1853, 0x1e1883, 0xc94c, 0xf0bc, 0xa36b, 0x3b22, 0x4b35, 0 }, /* #29 */
    { 0x3b5102, 0x3b5987, 0xf1a6, 0xcff0, 0x00f9, 0xeef6, 0xfd28, 0 }, /* #30 */
    { 0x3a2347, 0x3a2b87, 0xfa1d, 0x9182, 0x3c9b, 0x4e13, 0x4fea, 0 }, /* #31 */
    { 0x396cd6, 0x396c03, 0x7823, 0x6cf8, 0x9fb9, 0x35ce, 0x72a8, 0 }, /* #32 */
    { 0x396496, 0x396c83, 0xeb33, 0xd11a, 0x5e12, 0xab56, 0xba7e, 0 }, /* #33 */
    { 0x003616, 0x003e87, 0x6610, 0x9330, 0xc6ae, 0x52f4, 0xd013, 0 }, /* #34 */
    { 0x281b57, 0x281b03, 0x41c7, 0x68ba, 0xad21, 0x0cb5, 0x3176, 0 }, /* #35 */
    { 0x0b64d3, 0x0b6c83, 0xe7d2, 0xa1ec, 0xd417, 0x54b0, 0x5d86, 0 }, /* #36 */
    { 0x283d42, 0x283d03, 0x6264, 0x02ec, 0x9ae7, 0x51a7, 0xd473, 0 }, /* #37 */
    { 0x224482, 0x224c03, 0xda31, 0x40bc, 0x6360, 0x5316, 0x617c, 0 }, /* #38 */
    { 0x0e6d87, 0x0e6d83, 0x32c0, 0xfd80, 0x5880, 0x07c1, 0x2722, 0 }, /* #39 */
    { 0x357a56, 0x357a03, 0x85ae, 0x0a02, 0xee63, 0x2bd0, 0x53e7, 0 }, /* #40 */
    { 0x2c7193, 0x2c7983, 0xe9a7, 0xb05e, 0x1729, 0xabfe, 0xbc72, 0 }, /* #41 */
    { 0x087d82, 0x087d87, 0x44ce, 0x9fa0, 0x94b6, 0x1e04, 0x6fb0, 0 }, /* #42 */
    { 0x236952, 0x236987, 0xe24a, 0xb474, 0x51a5, 0xd1aa, 0xed32, 0 }, /* #43 */
    { 0x2a4743, 0x2a4f07, 0x9c97, 0x69bb, 0xdf66, 0x1b36, 0x2c7d, 0 }, /* #44 */
    { 0x296502, 0x296d07, 0xdacb, 0x0414, 0xf367, 0x2040, 0x25bc, 0 }, /* #45 */
    { 0x062517, 0x062d87, 0x5f95, 0xa078, 0x1777, 0x2410, 0x6098, 0 }, /* #46 */
    { 0x326fc7, 0x326f03, 0x8a17, 0x0e67, 0x5e6c, 0x33e3, 0x6031, 0 }, /* #47 */
    { 0x147f53, 0x147f07, 0xa731, 0x1260, 0x2584, 0x3ef1, 0x6060, 0 }, /* #48 */
    { 0x060557, 0x060d87, 0x7e2c, 0xf900, 0xe431, 0x015a, 0x02c0, 0 }, /* #49 */
    { 0x1c3886, 0x1c3887, 0x00a2, 0xafe8, 0x1b22, 0x0046, 0x6fb4, 0 }, /* #50 */
    { 0x1a21c6, 0x1a2987, 0x5a27, 0xb58d, 0x1160, 0x2f99, 0x872b, 0 }, /* #51 */
    { 0x1d68d2, 0x1d6887, 0xedc0, 0xc300, 0x351a, 0x38f4, 0x3d54, 0 }, /* #52 */
    { 0x3d3bd3, 0x3d3b83, 0xec8c, 0xe368, 0x28d2, 0x4fcd, 0x565e, 0 }, /* #53 */
    { 0x031f87, 0x031f07, 0x822f, 0x6299, 0x4aa2, 0x0f1c, 0x1db7, 0 }, /* #54 */
    { 0x353fd7, 0x353f07, 0x0a90, 0x4160, 0x8eb1, 0x0021, 0x0326, 0 }, /* #55 */
    { 0x0a2bc2, 0x0a2b07, 0x8263, 0x37b2, 0xb250, 0x615b, 0xbf26, 0 }, /* #56 */
    { 0x0a1b96, 0x0a1b03, 0x74e1, 0x04e6, 0x0c84, 0x4710, 0x9ba6, 0 }, /* #57 */
    { 0x364c17, 0x364c83, 0x327e, 0xdf0e, 0x72b1, 0x0319, 0x0fb9, 0 }, /* #58 */
    { 0x3f46c7, 0x3f4e83, 0x8a36, 0xb346, 0x8ae9, 0x3b70, 0x6e19, 0 }, /* #59 */
    { 0x382956, 0x382987, 0x3af4, 0x8888, 0x9253, 0x313b, 0xd5ca, 0 }, /* #60 */
    { 0x206f82, 0x206f07, 0x8f61, 0x6a72, 0x76dd, 0x323c, 0x59b2, 0 }, /* #61 */
    { 0x236e03, 0x236e83, 0x6a33, 0x8692, 0xb344, 0x1463, 0x3126, 0 }, /* #62 */
    { 0x201597, 0x201d03, 0xa41c, 0x6158, 0x9f37, 0x3bec, 0x5d7a, 0 }, /* #63 */
    { 0x3515c3, 0x351d03, 0x18ca, 0x172a, 0x8981, 0x0eaa, 0x9771, 0 }, /* #64 */
    { 0x397a83, 0x397a87, 0xd469, 0xbf9c, 0xf205, 0x4f04, 0x5f3c, 0 }, /* #65 */
    { 0x183d83, 0x183d87, 0x9b0f, 0xfd24, 0x6487, 0x4de5, 0x809c, 0 }, /* #66 */
    { 0x0e7657, 0x0e7e03, 0x64f6, 0x76bc, 0x16d0, 0x4ff3, 0xcaba, 0 }, /* #67 */
    { 0x3a6956, 0x3a6903, 0x1183, 0x77ad, 0xf1e1, 0x112c, 0xfb0f, 0 }, /* #68 */
    { 0x1e3793, 0x1e3f07, 0x54c0, 0x0ac0, 0xe4ca, 0x5060, 0xf2c9, 0 }, /* #69 */
    { 0x122652, 0x122e07, 0x5227, 0x39e8, 0x4bfb, 0x23e4, 0x6fd8, 0 }, /* #70 */
    { 0x1451d2, 0x145903, 0x9e07, 0x770b, 0x91e4, 0x88f4, 0xdddd, 0 }, /* #71 */
    { 0x3d69d6, 0x3d6907, 0xca85, 0x3811, 0xfa83, 0x4814, 0x5b1d, 0 }, /* #72 */
    { 0x2d4912, 0x2d4907, 0x1122, 0x5296, 0xcb1d, 0x0248, 0x221b, 0 }, /* #73 */
    { 0x2b0403, 0x2b0c87, 0x4585, 0xffe4, 0xe176, 0x1259, 0x4394, 0 }, /* #74 */
    { 0x3d6112, 0x3d6907, 0xa117, 0x362d, 0x43c4, 0x53ea, 0x855b, 0 }, /* #75 */
    { 0x307417, 0x307c87, 0xc07c, 0x9100, 0x2a84, 0x9f36, 0xd3c0, 0 }, /* #76 */
    { 0x276647, 0x276e07, 0x20fc, 0x6a9c, 0x6fc1, 0x1304, 0x9399, 0 }, /* #77 */
    { 0x023253, 0x023a87, 0x9803, 0x9dca, 0xfb76, 0x0f65, 0x19ee, 0 }, /* #78 */
    { 0x3c12c6, 0x3c1a83, 0x2608, 0xe9c8, 0xb6a3, 0x210c, 0xde79, 0 }, /* #79 */
    { 0x171d42, 0x171d07, 0x741a, 0x5dc6, 0x6da3, 0x004f, 0x00af, 0 }, /* #80 */
    { 0x0a5956, 0x0a5903, 0xcc49, 0x62d6, 0x17eb, 0x7307, 0x9026, 0 }, /* #81 */
    { 0x297807, 0x297803, 0x0851, 0x3c15, 0x5340, 0x0694, 0xca85, 0 }, /* #82 */
    { 0x105913, 0x105903, 0xbbf9, 0x6508, 0xce01, 0x5d75, 0x7f48, 0 }, /* #83 */
    { 0x363457, 0x363c07, 0xfeaa, 0x6a12, 0x6a28, 0x961b, 0x96e5, 0 }, /* #84 */
    { 0x203053, 0x203807, 0x880d, 0x73b4, 0xaf9b, 0x22d1, 0x4184, 0 }, /* #85 */
    { 0x183f97, 0x183f83, 0x79a2, 0xca8a, 0x3897, 0x712d, 0xee35, 0 }, /* #86 */
    { 0x1a5146, 0x1a5903, 0xd07a, 0x4234, 0xf145, 0xce24, 0xfd22, 0 }, /* #87 */
    { 0x3901c3, 0x390907, 0x3a2d, 0x5b8d, 0x3656, 0x1678, 0x62e1, 0 }, /* #88 */
    { 0x0e7157, 0x0e7983, 0x4cfa, 0x840e, 0xbbb7, 0x25d5, 0x7dd3, 0 }, /* #89 */
    { 0x265593, 0x265d83, 0x848c, 0x9740, 0xd915, 0x56f3, 0xa7f0, 0 }, /* #90 */
    { 0x2a64d3, 0x2a6c83, 0xa198, 0xd470, 0x6132, 0x3ad8, 0x5d3a, 0 }, /* #91 */
    { 0x3f1e46, 0x3f1e87, 0x9dea, 0xe130, 0xfc48, 0x6236, 0x9f38, 0 }, /* #92 */
    { 0x2e0d56, 0x2e0d03, 0x1218, 0x68c8, 0x3cce, 0x0b8d, 0xa373, 0 }, /* #93 */
    { 0x0116d6, 0x011e03, 0x0b9d, 0x044f, 0xc491, 0x09e2, 0xd9db, 0 }, /* #94 */
    { 0x284f46, 0x284f87, 0x2c02, 0xbdfa, 0xddf3, 0x1bac, 0xa0fd, 0 }, /* #95 */
};
uint32_t const g_cTests_mul_u16_intel = RT_ELEMENTS(g_aTests_mul_u16_intel);

MULDIVU16_TEST_T const g_aTests_imul_u16_intel[] =
{
    { 0x0414c7, 0x041406, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #0 */
    { 0x2d3447, 0x2d3406, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #1 */
    { 0x236292, 0x236206, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #2 */
    { 0x3c0482, 0x3c0406, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #3 */
    { 0x2b5c46, 0x2b5406, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #4 */
    { 0x291693, 0x291606, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #5 */
    { 0x1f2183, 0x1f2106, 0x1d87, 0x0000, 0x176b, 0x0000, 0x0000, 0 }, /* #6 */
    { 0x182cd2, 0x182406, 0x40a9, 0x0000, 0x7cf0, 0x0000, 0x0000, 0 }, /* #7 */
    { 0x382e47, 0x382606, 0x96ea, 0x0000, 0x6a1e, 0x0000, 0x0000, 0 }, /* #8 */
    { 0x163b92, 0x163306, 0x94ba, 0x0000, 0xc433, 0x0000, 0x0000, 0 }, /* #9 */
    { 0x1a1003, 0x1a1006, 0x312f, 0x0000, 0xe263, 0x0000, 0x0000, 0 }, /* #10 */
    { 0x370c03, 0x370406, 0xd5e1, 0x0000, 0x228e, 0x0000, 0x0000, 0 }, /* #11 */
    { 0x080313, 0x080b83, 0x6bd8, 0x94a8, 0xa88e, 0xf07d, 0xdb2f, 0 }, /* #12 */
    { 0x1d7756, 0x1d7f87, 0x7de3, 0xbdbb, 0xce43, 0x238b, 0x4849, 0 }, /* #13 */
    { 0x025542, 0x025d03, 0xc87f, 0x3698, 0xf823, 0x0e70, 0xbd68, 0 }, /* #14 */
    { 0x131106, 0x131987, 0xf596, 0xf396, 0xf9c4, 0x0406, 0x9d01, 0 }, /* #15 */
    { 0x1b48c2, 0x1b4883, 0xcaaf, 0xd840, 0x8620, 0x0e36, 0xbbc0, 0 }, /* #16 */
    { 0x2b07d2, 0x2b0f07, 0x6325, 0x304e, 0xbc3c, 0xdca5, 0xa4b6, 0 }, /* #17 */
    { 0x096c43, 0x096c03, 0x4fb5, 0x639d, 0x5566, 0xe3c1, 0xa549, 0 }, /* #18 */
    { 0x2151d6, 0x215983, 0x7205, 0xf245, 0xa0ae, 0x16d3, 0x3341, 0 }, /* #19 */
    { 0x332b97, 0x332b07, 0xca94, 0x62a0, 0x6277, 0xec7b, 0x5d88, 0 }, /* #20 */
    { 0x0039d3, 0x003983, 0xda8f, 0xd0e6, 0x9d1f, 0xf99a, 0x2bba, 0 }, /* #21 */
    { 0x1d0c13, 0x1d0c03, 0xe25e, 0x6880, 0x989a, 0x0007, 0xffc0, 0 }, /* #22 */
    { 0x2e0f92, 0x2e0f07, 0xc3fb, 0x2584, 0x4a43, 0xf381, 0x354c, 0 }, /* #23 */
    { 0x1d5987, 0x1d5983, 0x2ce2, 0xc570, 0xc285, 0xee27, 0x9a38, 0 }, /* #24 */
    { 0x3e1002, 0x3e1887, 0x247b, 0xc8bb, 0xb0c3, 0x0ca5, 0x58c1, 0 }, /* #25 */
    { 0x1f7986, 0x1f7907, 0x343c, 0x7818, 0x4e7b, 0x02c6, 0x0d9a, 0 }, /* #26 */
    { 0x1d7582, 0x1d7d87, 0x6093, 0xfe35, 0xc698, 0x042e, 0x0b17, 0 }, /* #27 */
    { 0x3f1743, 0x3f1f83, 0x4c80, 0x9380, 0xf67c, 0x10a8, 0x37bf, 0 }, /* #28 */
    { 0x134fd2, 0x134f03, 0xe188, 0x0320, 0xa6fb, 0x0f0a, 0x81a4, 0 }, /* #29 */
    { 0x204956, 0x204907, 0x0a6c, 0x41d8, 0x03dd, 0xfcfa, 0xb5c2, 0 }, /* #30 */
    { 0x347c07, 0x347c07, 0x5753, 0x32d2, 0x6625, 0xeabb, 0xc1a6, 0 }, /* #31 */
    { 0x0c0742, 0x0c0f07, 0xde65, 0x44b2, 0xa974, 0x0df1, 0x95ca, 0 }, /* #32 */
    { 0x3373d2, 0x337b83, 0x7ce5, 0xd9c8, 0xffc6, 0xd043, 0x9e28, 0 }, /* #33 */
    { 0x0e4d92, 0x0e4d83, 0xbb1a, 0xba16, 0x19b4, 0x21a6, 0x82f7, 0 }, /* #34 */
    { 0x2f6656, 0x2f6e07, 0x62e3, 0x2b69, 0xb1d4, 0xe06d, 0xae43, 0 }, /* #35 */
    { 0x263713, 0x263f87, 0x344a, 0xb778, 0x0a15, 0xfec8, 0xfa0c, 0 }, /* #36 */
    { 0x1c22c6, 0x1c2a87, 0x6483, 0x9e53, 0xa8ae, 0xef7c, 0xd5f1, 0 }, /* #37 */
    { 0x381dc2, 0x381d87, 0x59a7, 0xed39, 0x6ccb, 0xddb8, 0x9e1f, 0 }, /* #38 */
    { 0x265553, 0x265d07, 0x0409, 0x0095, 0xa772, 0xfeca, 0xb32d, 0 }, /* #39 */
    { 0x012347, 0x012b87, 0xb269, 0xfdb8, 0x2763, 0x06fa, 0xe8f8, 0 }, /* #40 */
    { 0x072246, 0x072a83, 0xa526, 0x92d6, 0x22a4, 0x17da, 0xbcc9, 0 }, /* #41 */
    { 0x1b5113, 0x1b5987, 0xf734, 0xe2d8, 0x5bf0, 0xfbf5, 0x758e, 0 }, /* #42 */
    { 0x3e1d46, 0x3e1d87, 0xf591, 0xee1d, 0x8c0a, 0xfda4, 0x39cd, 0 }, /* #43 */
    { 0x202706, 0x202f83, 0x3b44, 0xb608, 0xc776, 0xf378, 0xc9e2, 0 }, /* #44 */
    { 0x2d5753, 0x2d5f87, 0x1444, 0xa060, 0x5147, 0xf663, 0x8698, 0 }, /* #45 */
    { 0x3c4cc3, 0x3c4c03, 0xda97, 0x2679, 0x0b88, 0xee41, 0x796f, 0 }, /* #46 */
    { 0x082a97, 0x082a83, 0x107c, 0xc4e0, 0xe406, 0xfa51, 0xa7c8, 0 }, /* #47 */
    { 0x222617, 0x222e87, 0x7293, 0x94eb, 0xb641, 0x08a1, 0x1349, 0 }, /* #48 */
    { 0x2f5806, 0x2f5887, 0xa07b, 0x8d96, 0xb03d, 0xe0b3, 0x53e2, 0 }, /* #49 */
    { 0x267646, 0x267e87, 0xb8f0, 0xf460, 0xe908, 0x2327, 0x815a, 0 }, /* #50 */
    { 0x395187, 0x395983, 0x529e, 0x8d62, 0xafd8, 0xdbda, 0x8fff, 0 }, /* #51 */
    { 0x295e06, 0x295e07, 0x86fc, 0x3e28, 0xd18b, 0xf15d, 0x1ef6, 0 }, /* #52 */
    { 0x133a56, 0x133a07, 0xa69a, 0x0e12, 0x14aa, 0xf066, 0x2cad, 0 }, /* #53 */
    { 0x015217, 0x015a07, 0xc83e, 0x58e4, 0x5906, 0xe673, 0x754e, 0 }, /* #54 */
    { 0x167382, 0x167b83, 0xa448, 0xfd38, 0xd6d0, 0xdb35, 0x66af, 0 }, /* #55 */
    { 0x3061d6, 0x306987, 0x887a, 0xa7ca, 0x6711, 0x1d83, 0xc0c9, 0 }, /* #56 */
    { 0x3f4153, 0x3f4903, 0xb812, 0x76ba, 0x14f3, 0x1a7e, 0xa1b5, 0 }, /* #57 */
    { 0x0d1783, 0x0d1f83, 0x2d98, 0xf8e0, 0x7625, 0xebc6, 0x8e74, 0 }, /* #58 */
    { 0x037d87, 0x037d87, 0xc9dc, 0xe028, 0xfff9, 0x09fc, 0xd0c6, 0 }, /* #59 */
    { 0x365b12, 0x365b83, 0x58ef, 0x811a, 0x9fa5, 0x1a95, 0x4c86, 0 }, /* #60 */
    { 0x270c07, 0x270c87, 0x00d4, 0x8ce4, 0xe94d, 0x0034, 0x3f75, 0 }, /* #61 */
    { 0x0e4c16, 0x0e4c87, 0x2699, 0xbbf6, 0x20be, 0x02ec, 0x1366, 0 }, /* #62 */
    { 0x073a42, 0x073a87, 0x33e4, 0x8b84, 0xaa1d, 0x0e6c, 0x4729, 0 }, /* #63 */
    { 0x0f4982, 0x0f4987, 0xfca1, 0xa6fc, 0x4c81, 0x0123, 0xa97c, 0 }, /* #64 */
    { 0x1e19d7, 0x1e1983, 0x8bf2, 0xfb54, 0xee23, 0x33ea, 0x8d7a, 0 }, /* #65 */
    { 0x3378c7, 0x337803, 0xaa1e, 0x23b0, 0xd3ef, 0x1540, 0xc0a8, 0 }, /* #66 */
    { 0x1b31d3, 0x1b3907, 0x51ec, 0x5848, 0xdb00, 0xe21b, 0xa296, 0 }, /* #67 */
    { 0x183d83, 0x183d87, 0x5538, 0xa1d8, 0x6edb, 0xd57d, 0x804d, 0 }, /* #68 */
    { 0x1c7887, 0x1c7807, 0x9082, 0x0f56, 0x807c, 0x20b3, 0xb4eb, 0 }, /* #69 */
    { 0x356303, 0x356b87, 0xb686, 0xbf12, 0xb355, 0xedd7, 0x3f43, 0 }, /* #70 */
    { 0x171057, 0x171883, 0x58cf, 0x80b0, 0x5499, 0x164f, 0x4050, 0 }, /* #71 */
    { 0x321c83, 0x321c03, 0x899f, 0x4f49, 0xff42, 0x1714, 0xce17, 0 }, /* #72 */
    { 0x327c07, 0x327c07, 0x25c4, 0x0d3c, 0xf59b, 0xfeee, 0xf8bf, 0 }, /* #73 */
    { 0x3c68c3, 0x3c6803, 0xd9a1, 0x411a, 0xa3ae, 0xf8fa, 0x2eda, 0 }, /* #74 */
    { 0x017c03, 0x017c03, 0x3f4c, 0x5408, 0xa286, 0x1d99, 0x77b6, 0 }, /* #75 */
    { 0x104743, 0x104f83, 0x7a46, 0x8b62, 0x1248, 0xcb08, 0x911b, 0 }, /* #76 */
    { 0x011a46, 0x011a03, 0x9e45, 0x5d80, 0x18e3, 0xcf53, 0x7f80, 0 }, /* #77 */
    { 0x207e57, 0x207e83, 0xb292, 0x8d58, 0x03e9, 0x1dda, 0x9d4c, 0 }, /* #78 */
    { 0x1e3613, 0x1e3e07, 0xd213, 0x6506, 0x695b, 0xf047, 0x57a2, 0 }, /* #79 */
    { 0x277502, 0x277d03, 0x4a86, 0x37bc, 0xb34f, 0x0b95, 0x27ca, 0 }, /* #80 */
    { 0x083d16, 0x083d83, 0x8d6c, 0xd44c, 0xe56c, 0xe5be, 0x3aa9, 0 }, /* #81 */
    { 0x256306, 0x256b07, 0xc2eb, 0x6d28, 0x845f, 0xe5e1, 0x6d78, 0 }, /* #82 */
    { 0x321c96, 0x321c83, 0x80cb, 0xa523, 0x7982, 0x32aa, 0x9a09, 0 }, /* #83 */
    { 0x0f76d2, 0x0f7e07, 0xe381, 0x01c9, 0x885d, 0xfc2f, 0x2249, 0 }, /* #84 */
    { 0x0f1c83, 0x0f1c03, 0x7819, 0x66fb, 0x2c97, 0xc8bc, 0x8a33, 0 }, /* #85 */
    { 0x3a1ec7, 0x3a1e83, 0x80df, 0xc7a4, 0x2115, 0x038b, 0xf8dc, 0 }, /* #86 */
    { 0x190903, 0x190983, 0xaac2, 0xe4da, 0xa728, 0xdbda, 0x6c8d, 0 }, /* #87 */
    { 0x017156, 0x017987, 0xeb4c, 0xf400, 0x23ab, 0x015f, 0xef00, 0 }, /* #88 */
    { 0x0049d6, 0x004907, 0x0310, 0x7330, 0xcd4d, 0xff87, 0xd8a3, 0 }, /* #89 */
    { 0x035d42, 0x035d87, 0xe952, 0xd978, 0xc8dc, 0xfff7, 0x005c, 0 }, /* #90 */
    { 0x265647, 0x265e07, 0xb858, 0x5988, 0x4611, 0xe631, 0x5c33, 0 }, /* #91 */
    { 0x303f43, 0x303f87, 0xcf35, 0xe569, 0x2ec2, 0x0c37, 0xbfe5, 0 }, /* #92 */
    { 0x313447, 0x313c03, 0x7e7a, 0x64ce, 0xd212, 0x091d, 0x1273, 0 }, /* #93 */
    { 0x152982, 0x152983, 0xe1d2, 0xd07c, 0xddb0, 0xfa64, 0x2f8e, 0 }, /* #94 */
    { 0x3c0707, 0x3c0f83, 0x17e8, 0x8180, 0x7e8e, 0xfa04, 0xbff0, 0 }, /* #95 */
};
uint32_t const g_cTests_imul_u16_intel = RT_ELEMENTS(g_aTests_imul_u16_intel);

MULDIVU16_TEST_T const g_aTests_div_u16_intel[] =
{
    { 0x114d16, 0x114d16, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #0 */
    { 0x272a43, 0x272a43, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #1 */
    { 0x0e72d7, 0x0e72d7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #2 */
    { 0x3a5c83, 0x3a5c83, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #3 */
    { 0x294686, 0x294686, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #4 */
    { 0x333b96, 0x333b96, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #5 */
    { 0x281e87, 0x281e87, 0x0e36, 0x0e36, 0x065d, 0x065d, 0x0000, -1 }, /* #6 */
    { 0x375153, 0x375153, 0xfe1b, 0xfe1b, 0xaa66, 0xaa66, 0x0000, -1 }, /* #7 */
    { 0x276dd2, 0x276dd2, 0x60ad, 0x60ad, 0xad7c, 0xad7c, 0x0000, -1 }, /* #8 */
    { 0x046116, 0x046116, 0xb0d8, 0xb0d8, 0xd3a2, 0xd3a2, 0x0000, -1 }, /* #9 */
    { 0x035c07, 0x035c07, 0xa903, 0xa903, 0x384e, 0x384e, 0x0000, -1 }, /* #10 */
    { 0x394352, 0x394352, 0x9dc3, 0x9dc3, 0x8cb3, 0x8cb3, 0x0000, -1 }, /* #11 */
    { 0x366717, 0x366717, 0xb059, 0x6743, 0x1d05, 0x16c0, 0x47f3, 0 }, /* #12 */
    { 0x083a42, 0x083a42, 0x9276, 0xe504, 0x383d, 0x00fe, 0x3ede, 0 }, /* #13 */
    { 0x134292, 0x134292, 0x9b0f, 0xc555, 0xacd7, 0x85cd, 0xe03a, 0 }, /* #14 */
    { 0x323286, 0x323286, 0x7379, 0x5e0c, 0x314a, 0x0169, 0x862c, 0 }, /* #15 */
    { 0x182e17, 0x182e17, 0xdc40, 0x8552, 0x5ea9, 0x4a26, 0xb5c5, 0 }, /* #16 */
    { 0x0d0482, 0x0d0482, 0xec1c, 0xec1c, 0x3cca, 0x3cca, 0x2f47, -1 }, /* #17 */
    { 0x3a06c3, 0x3a06c3, 0x7e13, 0x7e13, 0xdf10, 0xdf10, 0x8620, -1 }, /* #18 */
    { 0x080712, 0x080712, 0x61c3, 0x61c3, 0x72b2, 0x72b2, 0x4923, -1 }, /* #19 */
    { 0x000682, 0x000682, 0xf26f, 0xf26f, 0xc18d, 0xc18d, 0x9145, -1 }, /* #20 */
    { 0x261353, 0x261353, 0x5d49, 0xfd55, 0xbf02, 0x55a0, 0xc105, 0 }, /* #21 */
    { 0x1a5797, 0x1a5797, 0x3d07, 0x70fb, 0x6306, 0xafe2, 0xe05f, 0 }, /* #22 */
    { 0x0019d3, 0x0019d3, 0xacb6, 0xae60, 0x8ce4, 0x4bb6, 0xced8, 0 }, /* #23 */
    { 0x0724c2, 0x0724c2, 0x7477, 0xee81, 0xe8a0, 0x1446, 0xf9b1, 0 }, /* #24 */
    { 0x322942, 0x322942, 0x3a5b, 0x7620, 0x74b2, 0x237b, 0xfce7, 0 }, /* #25 */
    { 0x2253c6, 0x2253c6, 0x3053, 0xdd03, 0xa0e3, 0x7242, 0xba5b, 0 }, /* #26 */
    { 0x070716, 0x070716, 0x67a3, 0x8298, 0x6795, 0xc083, 0xcb0c, 0 }, /* #27 */
    { 0x3b3e93, 0x3b3e93, 0xe62a, 0xe62a, 0x3698, 0x3698, 0x2764, -1 }, /* #28 */
    { 0x3a4506, 0x3a4506, 0x5a14, 0x5a14, 0x5adc, 0x5adc, 0x12e0, -1 }, /* #29 */
    { 0x1268c3, 0x1268c3, 0x0f2e, 0x0f2e, 0xebb5, 0xebb5, 0xcc8e, -1 }, /* #30 */
    { 0x2b0496, 0x2b0496, 0x557e, 0x87eb, 0x7a28, 0x0d37, 0xe615, 0 }, /* #31 */
    { 0x3e1e06, 0x3e1e06, 0xc07d, 0xc07d, 0x7e8c, 0x7e8c, 0x19f7, -1 }, /* #32 */
    { 0x2262c6, 0x2262c6, 0x3bd7, 0x1adc, 0x0872, 0x438f, 0x507e, 0 }, /* #33 */
    { 0x2e1c86, 0x2e1c86, 0x7e76, 0x7e76, 0xddbb, 0xddbb, 0x99c4, -1 }, /* #34 */
    { 0x084706, 0x084706, 0x9ec8, 0x9ec8, 0xc7f5, 0xc7f5, 0x420c, -1 }, /* #35 */
    { 0x3d6dd2, 0x3d6dd2, 0xf5c1, 0x0bc3, 0x0a47, 0xc7e2, 0xdfb5, 0 }, /* #36 */
    { 0x3442d7, 0x3442d7, 0x7ae3, 0x3d1b, 0x1f80, 0x3aa0, 0x83f9, 0 }, /* #37 */
    { 0x290e92, 0x290e92, 0x7e68, 0x7e68, 0xb970, 0xb970, 0x4c63, -1 }, /* #38 */
    { 0x112457, 0x112457, 0x410b, 0xfaf0, 0x97d4, 0x634b, 0x9ae4, 0 }, /* #39 */
    { 0x090ac2, 0x090ac2, 0x57cc, 0x57cc, 0xe136, 0xe136, 0x5356, -1 }, /* #40 */
    { 0x154c12, 0x154c12, 0x3109, 0x3109, 0xdb16, 0xdb16, 0xda33, -1 }, /* #41 */
    { 0x251503, 0x251503, 0x7a49, 0xcc9e, 0xa6ab, 0xcc33, 0xd085, 0 }, /* #42 */
    { 0x226707, 0x226707, 0xdd3f, 0xc400, 0x44db, 0x1d3f, 0x59f0, 0 }, /* #43 */
    { 0x122c82, 0x122c82, 0x6412, 0x6412, 0xcbba, 0xcbba, 0xc93d, -1 }, /* #44 */
    { 0x366f42, 0x366f42, 0xe2d2, 0xe2d2, 0xcc78, 0xcc78, 0x8b12, -1 }, /* #45 */
    { 0x3e7287, 0x3e7287, 0x994b, 0x994b, 0x949b, 0x949b, 0x0518, -1 }, /* #46 */
    { 0x0d2a86, 0x0d2a86, 0x0cf9, 0x0cf9, 0x89ba, 0x89ba, 0x21c6, -1 }, /* #47 */
    { 0x0114c6, 0x0114c6, 0x2b01, 0xac1c, 0xab7c, 0x2d09, 0xff12, 0 }, /* #48 */
    { 0x317612, 0x317612, 0x0903, 0x0903, 0x6cae, 0x6cae, 0x124a, -1 }, /* #49 */
    { 0x117d47, 0x117d47, 0x183e, 0x183e, 0xe1da, 0xe1da, 0x7196, -1 }, /* #50 */
    { 0x0265c7, 0x0265c7, 0xf623, 0xf623, 0xe75c, 0xe75c, 0x24c6, -1 }, /* #51 */
    { 0x101957, 0x101957, 0x21a2, 0x21a2, 0x730e, 0x730e, 0x4798, -1 }, /* #52 */
    { 0x280716, 0x280716, 0xc061, 0xc061, 0xabcb, 0xabcb, 0x80ac, -1 }, /* #53 */
    { 0x2e6cc6, 0x2e6cc6, 0x9fb6, 0x9fb6, 0xdef2, 0xdef2, 0x39b3, -1 }, /* #54 */
    { 0x304c03, 0x304c03, 0x4bae, 0x4b98, 0x305b, 0x3a7e, 0xa3c2, 0 }, /* #55 */
    { 0x3a4682, 0x3a4682, 0x608b, 0x608b, 0x394d, 0x394d, 0x03d0, -1 }, /* #56 */
    { 0x375ac6, 0x375ac6, 0xd8e5, 0xd8e5, 0xcdec, 0xcdec, 0x9365, -1 }, /* #57 */
    { 0x1c4a02, 0x1c4a02, 0x597b, 0x9d43, 0x6e1b, 0xa4c7, 0xb33c, 0 }, /* #58 */
    { 0x365793, 0x365793, 0x65e6, 0x6ac3, 0x24d7, 0x15a1, 0x5857, 0 }, /* #59 */
    { 0x3a4317, 0x3a4317, 0xc725, 0xd395, 0x4dc9, 0x45af, 0x5e1e, 0 }, /* #60 */
    { 0x304d02, 0x304d02, 0xea4c, 0x74a9, 0x2313, 0x45eb, 0x4cf9, 0 }, /* #61 */
    { 0x0810d3, 0x0810d3, 0x6ac5, 0x6ac5, 0x75a1, 0x75a1, 0x3057, -1 }, /* #62 */
    { 0x211a52, 0x211a52, 0x4b1c, 0x34a4, 0x31ae, 0xda60, 0xf197, 0 }, /* #63 */
    { 0x111f17, 0x111f17, 0x9a84, 0x6e04, 0x6c71, 0xb52c, 0xfc56, 0 }, /* #64 */
    { 0x257212, 0x257212, 0x001f, 0x001f, 0xc47c, 0xc47c, 0x12ed, -1 }, /* #65 */
    { 0x214a97, 0x214a97, 0xa4a3, 0xa4a3, 0xfa17, 0xfa17, 0xce36, -1 }, /* #66 */
    { 0x2e1186, 0x2e1186, 0x155e, 0x71d6, 0x34cf, 0x2d32, 0x76c2, 0 }, /* #67 */
    { 0x1510d2, 0x1510d2, 0xec0a, 0xec0a, 0xf6a0, 0xf6a0, 0x2ae1, -1 }, /* #68 */
    { 0x2d0c47, 0x2d0c47, 0x42a2, 0x42a2, 0xd977, 0xd977, 0x896a, -1 }, /* #69 */
    { 0x223e42, 0x223e42, 0xc6b9, 0x3f62, 0x2998, 0x3757, 0xa801, 0 }, /* #70 */
    { 0x3a7e93, 0x3a7e93, 0x5c48, 0xbf65, 0x9cd6, 0x1fc5, 0xd1c7, 0 }, /* #71 */
    { 0x1c0183, 0x1c0183, 0x0352, 0x0352, 0x4078, 0x4078, 0x0ce5, -1 }, /* #72 */
    { 0x0c6a93, 0x0c6a93, 0x5345, 0x4ad2, 0x2e99, 0x2965, 0x9f70, 0 }, /* #73 */
    { 0x1d0702, 0x1d0702, 0xc29d, 0x7b79, 0x725b, 0xaecc, 0xed19, 0 }, /* #74 */
    { 0x172c02, 0x172c02, 0x30da, 0x30da, 0xfe6b, 0xfe6b, 0xf6c3, -1 }, /* #75 */
    { 0x137e47, 0x137e47, 0x05f3, 0x32df, 0x2c6f, 0x2acd, 0xdf9a, 0 }, /* #76 */
    { 0x3e4c97, 0x3e4c97, 0x1ff2, 0x1ff2, 0x6961, 0x6961, 0x19ac, -1 }, /* #77 */
    { 0x042ec2, 0x042ec2, 0x45b6, 0x45b6, 0xe5e6, 0xe5e6, 0x1c5f, -1 }, /* #78 */
    { 0x2d4c46, 0x2d4c46, 0x3931, 0x3931, 0xff11, 0xff11, 0x10c6, -1 }, /* #79 */
    { 0x244c57, 0x244c57, 0x510f, 0x510f, 0x8d56, 0x8d56, 0x46ca, -1 }, /* #80 */
    { 0x1a3482, 0x1a3482, 0xc54c, 0xc54c, 0xad71, 0xad71, 0x6e3b, -1 }, /* #81 */
    { 0x130843, 0x130843, 0x1aff, 0x1aff, 0x9e57, 0x9e57, 0x59d0, -1 }, /* #82 */
    { 0x3c1ad3, 0x3c1ad3, 0x94cb, 0x94cb, 0x8dd1, 0x8dd1, 0x5525, -1 }, /* #83 */
    { 0x1b1193, 0x1b1193, 0x7b80, 0xe95f, 0x7801, 0x5da4, 0x83a4, 0 }, /* #84 */
    { 0x120057, 0x120057, 0x3d43, 0xfb9c, 0xec9f, 0x4843, 0xf0c0, 0 }, /* #85 */
    { 0x2c5113, 0x2c5113, 0xb8d9, 0x8a20, 0x899e, 0xc0f9, 0xff0f, 0 }, /* #86 */
    { 0x184456, 0x184456, 0xa1a8, 0xa1a8, 0xf188, 0xf188, 0x11f7, -1 }, /* #87 */
    { 0x2d3f92, 0x2d3f92, 0x9081, 0x9081, 0xebb1, 0xebb1, 0x2f15, -1 }, /* #88 */
    { 0x151c12, 0x151c12, 0xafa6, 0xafa6, 0xfcf0, 0xfcf0, 0xd64c, -1 }, /* #89 */
    { 0x197392, 0x197392, 0x497a, 0x9f69, 0x6bd7, 0x1033, 0xad2f, 0 }, /* #90 */
    { 0x2b2e12, 0x2b2e12, 0x3607, 0x3607, 0x6e8b, 0x6e8b, 0x6ccb, -1 }, /* #91 */
    { 0x2d0886, 0x2d0886, 0x799c, 0xc1cc, 0x8f74, 0xb968, 0xbd7f, 0 }, /* #92 */
    { 0x0f5617, 0x0f5617, 0x113f, 0x113f, 0xe791, 0xe791, 0x867d, -1 }, /* #93 */
    { 0x2f5e52, 0x2f5e52, 0xa7a5, 0x136a, 0x103e, 0x7b2f, 0xd62f, 0 }, /* #94 */
    { 0x0c7546, 0x0c7546, 0x2abe, 0x2abe, 0xeaa5, 0xeaa5, 0x32e8, -1 }, /* #95 */
};
uint32_t const g_cTests_div_u16_intel = RT_ELEMENTS(g_aTests_div_u16_intel);

MULDIVU16_TEST_T const g_aTests_idiv_u16_intel[] =
{
    { 0x214816, 0x214816, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #0 */
    { 0x2c3d42, 0x2c3d42, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #1 */
    { 0x310306, 0x310306, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #2 */
    { 0x1a5d46, 0x1a5d46, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #3 */
    { 0x311317, 0x311317, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #4 */
    { 0x227d83, 0x227d83, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #5 */
    { 0x2f2b57, 0x2f2b57, 0xeb8d, 0xeb8d, 0x0547, 0x0547, 0x0000, -1 }, /* #6 */
    { 0x161d03, 0x161d03, 0x94bd, 0x94bd, 0x2055, 0x2055, 0x0000, -1 }, /* #7 */
    { 0x254e53, 0x254e53, 0x9b4c, 0x9b4c, 0x0a42, 0x0a42, 0x0000, -1 }, /* #8 */
    { 0x365586, 0x365586, 0xac98, 0xac98, 0xeb0c, 0xeb0c, 0x0000, -1 }, /* #9 */
    { 0x1b6a83, 0x1b6a83, 0x8ca6, 0x8ca6, 0xb218, 0xb218, 0x0000, -1 }, /* #10 */
    { 0x3466d6, 0x3466d6, 0xd2f4, 0xd2f4, 0xb6db, 0xb6db, 0x0000, -1 }, /* #11 */
    { 0x2441c2, 0x2441c2, 0x2a6c, 0x2a6c, 0xcb75, 0xcb75, 0x5a92, -1 }, /* #12 */
    { 0x1f1047, 0x1f1047, 0x87e7, 0x87e7, 0xf14c, 0xf14c, 0x155d, -1 }, /* #13 */
    { 0x3a7602, 0x3a7602, 0x4755, 0x4755, 0xb229, 0xb229, 0xaae1, -1 }, /* #14 */
    { 0x285552, 0x285552, 0xad45, 0xad45, 0xe5ea, 0xe5ea, 0xf61e, -1 }, /* #15 */
    { 0x0c6713, 0x0c6713, 0xa53f, 0x165a, 0x0995, 0x3657, 0x6dc4, 0 }, /* #16 */
    { 0x194987, 0x194987, 0xd4d4, 0xd4d4, 0x276a, 0x276a, 0xf0be, -1 }, /* #17 */
    { 0x115d13, 0x115d13, 0xec71, 0xec71, 0x21d7, 0x21d7, 0xffb8, -1 }, /* #18 */
    { 0x211412, 0x211412, 0xd80b, 0xd80b, 0xcae6, 0xcae6, 0xba09, -1 }, /* #19 */
    { 0x3642d3, 0x3642d3, 0x7b5b, 0x7b5b, 0x61a4, 0x61a4, 0x1936, -1 }, /* #20 */
    { 0x262ac6, 0x262ac6, 0x638c, 0x638c, 0x3981, 0x3981, 0x6fd9, -1 }, /* #21 */
    { 0x102d92, 0x102d92, 0x55e8, 0x55e8, 0x622e, 0x622e, 0x25cb, -1 }, /* #22 */
    { 0x355202, 0x355202, 0xb449, 0xba3a, 0x1d9e, 0x4b41, 0x9354, 0 }, /* #23 */
    { 0x2d2056, 0x2d2056, 0xe4af, 0xe4af, 0xc463, 0xc463, 0xfd2f, -1 }, /* #24 */
    { 0x3e6057, 0x3e6057, 0xcea4, 0xa17b, 0xd743, 0x99c3, 0x6e53, 0 }, /* #25 */
    { 0x077d07, 0x077d07, 0x1c33, 0x1c33, 0x6efa, 0x6efa, 0x94ac, -1 }, /* #26 */
    { 0x043583, 0x043583, 0x1498, 0x1aa8, 0xf8bb, 0xea70, 0xba31, 0 }, /* #27 */
    { 0x1d0ed7, 0x1d0ed7, 0x230d, 0x230d, 0x2e89, 0x2e89, 0x3f47, -1 }, /* #28 */
    { 0x351c56, 0x351c56, 0x36e7, 0x36e7, 0xc7f7, 0xc7f7, 0x0da1, -1 }, /* #29 */
    { 0x240886, 0x240886, 0x18cb, 0x18cb, 0x3d24, 0x3d24, 0x0feb, -1 }, /* #30 */
    { 0x2844c6, 0x2844c6, 0x2111, 0x2111, 0xc9e1, 0xc9e1, 0xe843, -1 }, /* #31 */
    { 0x126813, 0x126813, 0xfa6f, 0xfa6f, 0x98be, 0x98be, 0x76e0, -1 }, /* #32 */
    { 0x3d1142, 0x3d1142, 0xf6a6, 0x855c, 0xcf36, 0xb51a, 0x65d5, 0 }, /* #33 */
    { 0x1d6953, 0x1d6953, 0x8632, 0x8632, 0x9f1d, 0x9f1d, 0x0809, -1 }, /* #34 */
    { 0x096756, 0x096756, 0x0eec, 0x0eec, 0xdb63, 0xdb63, 0xeaee, -1 }, /* #35 */
    { 0x076bd2, 0x076bd2, 0xfe83, 0xc2d7, 0x0388, 0x03d7, 0xf134, 0 }, /* #36 */
    { 0x2c6f03, 0x2c6f03, 0xdf31, 0xdf31, 0x6950, 0x6950, 0xa866, -1 }, /* #37 */
    { 0x391f03, 0x391f03, 0xf38c, 0x3dde, 0x0bea, 0x202c, 0x3150, 0 }, /* #38 */
    { 0x2d1852, 0x2d1852, 0xcce4, 0xcce4, 0x5c4a, 0x5c4a, 0x6b7d, -1 }, /* #39 */
    { 0x1419d7, 0x1419d7, 0x5932, 0x5932, 0xb90f, 0xb90f, 0x1c39, -1 }, /* #40 */
    { 0x047b07, 0x047b07, 0x7ba5, 0x7ba5, 0x38b9, 0x38b9, 0x1262, -1 }, /* #41 */
    { 0x386c96, 0x386c96, 0xd147, 0xd147, 0x8d55, 0x8d55, 0xd0fe, -1 }, /* #42 */
    { 0x326cd2, 0x326cd2, 0xc7cd, 0xc7cd, 0x8bab, 0x8bab, 0x8430, -1 }, /* #43 */
    { 0x3462c2, 0x3462c2, 0x2ac7, 0x2ac7, 0xb958, 0xb958, 0x5e88, -1 }, /* #44 */
    { 0x211fc6, 0x211fc6, 0x97fd, 0x97fd, 0x6284, 0x6284, 0xb746, -1 }, /* #45 */
    { 0x1f1342, 0x1f1342, 0x9855, 0x9855, 0xa20e, 0xa20e, 0x9015, -1 }, /* #46 */
    { 0x1e6d17, 0x1e6d17, 0xeb8a, 0xeb8a, 0x63e3, 0x63e3, 0xadde, -1 }, /* #47 */
    { 0x2b3392, 0x2b3392, 0xfa1a, 0xfa1a, 0x8f69, 0x8f69, 0xdb7b, -1 }, /* #48 */
    { 0x090d47, 0x090d47, 0x9a9f, 0x9a9f, 0xa52b, 0xa52b, 0x947f, -1 }, /* #49 */
    { 0x2e5986, 0x2e5986, 0xccb0, 0x40bf, 0xe552, 0xbdf7, 0x9687, 0 }, /* #50 */
    { 0x114846, 0x114846, 0xd744, 0xf813, 0xfd05, 0xbcd1, 0x6021, 0 }, /* #51 */
    { 0x3c7187, 0x3c7187, 0x6583, 0x6583, 0xbd5e, 0xbd5e, 0xf4fe, -1 }, /* #52 */
    { 0x336156, 0x336156, 0x309b, 0x309b, 0x0fa7, 0x0fa7, 0xfb58, -1 }, /* #53 */
    { 0x2b2b13, 0x2b2b13, 0xade8, 0xcebf, 0x11bf, 0x01a8, 0xa3c0, 0 }, /* #54 */
    { 0x385c57, 0x385c57, 0x8e51, 0x8e51, 0xa4f0, 0xa4f0, 0xb895, -1 }, /* #55 */
    { 0x175907, 0x175907, 0xa421, 0xa421, 0xee84, 0xee84, 0x07c1, -1 }, /* #56 */
    { 0x2b71c2, 0x2b71c2, 0x8d76, 0x8d76, 0x944b, 0x944b, 0x36ac, -1 }, /* #57 */
    { 0x0a6a86, 0x0a6a86, 0xde08, 0xf680, 0xfd28, 0xea08, 0x4c88, 0 }, /* #58 */
    { 0x276006, 0x276006, 0x9cf5, 0x9cf5, 0xa933, 0xa933, 0xeb68, -1 }, /* #59 */
    { 0x026403, 0x026403, 0x3887, 0x3887, 0x60b1, 0x60b1, 0x2bfe, -1 }, /* #60 */
    { 0x266a53, 0x266a53, 0x371e, 0x371e, 0xaa89, 0xaa89, 0x3c18, -1 }, /* #61 */
    { 0x1628c6, 0x1628c6, 0x0caf, 0x0caf, 0x6e33, 0x6e33, 0x5000, -1 }, /* #62 */
    { 0x0c3417, 0x0c3417, 0x9c73, 0x9c73, 0x1ea1, 0x1ea1, 0x12ac, -1 }, /* #63 */
    { 0x2a7fd6, 0x2a7fd6, 0x68f1, 0x68f1, 0x2c1d, 0x2c1d, 0x29b6, -1 }, /* #64 */
    { 0x0e0893, 0x0e0893, 0x0e30, 0xcbcd, 0x16d5, 0x2b95, 0x9007, 0 }, /* #65 */
    { 0x371fc7, 0x371fc7, 0xa197, 0xa197, 0x1bca, 0x1bca, 0xdb9c, -1 }, /* #66 */
    { 0x0448d3, 0x0448d3, 0x3431, 0xe57b, 0x0818, 0x0e02, 0xb1dd, 0 }, /* #67 */
    { 0x2a7812, 0x2a7812, 0x840b, 0x840b, 0x288d, 0x288d, 0x0c74, -1 }, /* #68 */
    { 0x091ac3, 0x091ac3, 0x13eb, 0x13eb, 0x5bdf, 0x5bdf, 0x4913, -1 }, /* #69 */
    { 0x034913, 0x034913, 0xde56, 0xd8e8, 0x0c4e, 0x00fe, 0xaf67, 0 }, /* #70 */
    { 0x287947, 0x287947, 0x84aa, 0x84aa, 0xb6d9, 0xb6d9, 0x47a3, -1 }, /* #71 */
    { 0x3b0a42, 0x3b0a42, 0xc4c5, 0xc4c5, 0x8ef3, 0x8ef3, 0xf05c, -1 }, /* #72 */
    { 0x380753, 0x380753, 0x331e, 0x331e, 0xd22d, 0xd22d, 0xbb5c, -1 }, /* #73 */
    { 0x257887, 0x257887, 0xbc56, 0xde14, 0x0f8f, 0x2b02, 0x8a91, 0 }, /* #74 */
    { 0x122496, 0x122496, 0xa150, 0xa150, 0xc777, 0xc777, 0x39e5, -1 }, /* #75 */
    { 0x2946c3, 0x2946c3, 0x8709, 0xb0f5, 0x12f8, 0x042e, 0xc28f, 0 }, /* #76 */
    { 0x0639c2, 0x0639c2, 0xa9a1, 0xa9a1, 0x7a73, 0x7a73, 0x31f1, -1 }, /* #77 */
    { 0x111303, 0x111303, 0x506f, 0x506f, 0x5555, 0x5555, 0xab30, -1 }, /* #78 */
    { 0x231403, 0x231403, 0xd19c, 0x5aae, 0xd95c, 0xa286, 0x92ed, 0 }, /* #79 */
    { 0x3c2592, 0x3c2592, 0xfabb, 0xfabb, 0x4061, 0x4061, 0x0361, -1 }, /* #80 */
    { 0x036a53, 0x036a53, 0x6827, 0x6827, 0xb94d, 0xb94d, 0xfab1, -1 }, /* #81 */
    { 0x053086, 0x053086, 0x52d9, 0x52d9, 0xb1ef, 0xb1ef, 0x2994, -1 }, /* #82 */
    { 0x2e2902, 0x2e2902, 0xc836, 0xc836, 0x3376, 0x3376, 0x0147, -1 }, /* #83 */
    { 0x023707, 0x023707, 0xb8d7, 0xb8d7, 0xa456, 0xa456, 0xf436, -1 }, /* #84 */
    { 0x2a3b97, 0x2a3b97, 0xe6dc, 0xe6dc, 0x3f7b, 0x3f7b, 0x4633, -1 }, /* #85 */
    { 0x026f82, 0x026f82, 0x31b3, 0x4677, 0x1cff, 0x29cb, 0x6958, 0 }, /* #86 */
    { 0x3137c3, 0x3137c3, 0x9562, 0xce31, 0x1343, 0x24c4, 0x9cfe, 0 }, /* #87 */
    { 0x1929c3, 0x1929c3, 0x920d, 0xfc0d, 0x016b, 0x51cc, 0xa405, 0 }, /* #88 */
    { 0x1d0946, 0x1d0946, 0x3ffa, 0x3ffa, 0xb912, 0xb912, 0xbc75, -1 }, /* #89 */
    { 0x047417, 0x047417, 0xc6ad, 0xc6ad, 0x9fb4, 0x9fb4, 0x63f6, -1 }, /* #90 */
    { 0x377b13, 0x377b13, 0x8d0c, 0x8d0c, 0x800f, 0x800f, 0x37e2, -1 }, /* #91 */
    { 0x015f47, 0x015f47, 0x67e8, 0x67e8, 0x5bcb, 0x5bcb, 0xb64d, -1 }, /* #92 */
    { 0x380dc3, 0x380dc3, 0xc424, 0xc424, 0xa8ad, 0xa8ad, 0x4587, -1 }, /* #93 */
    { 0x2d7f02, 0x2d7f02, 0x0b36, 0x0b36, 0x5aea, 0x5aea, 0xe318, -1 }, /* #94 */
    { 0x336183, 0x336183, 0x791f, 0x791f, 0x9ec4, 0x9ec4, 0xe3c2, -1 }, /* #95 */
};
uint32_t const g_cTests_idiv_u16_intel = RT_ELEMENTS(g_aTests_idiv_u16_intel);

MULDIVU32_TEST_T const g_aTests_mul_u32_intel[] =
{
    { 0x3f6b56, 0x3f6306, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #0 */
    { 0x287bd2, 0x287306, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #1 */
    { 0x3f17c7, 0x3f1706, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #2 */
    { 0x264912, 0x264106, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #3 */
    { 0x007946, 0x007106, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #4 */
    { 0x365996, 0x365106, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #5 */
    { 0x1a5307, 0x1a5306, 0xaff08480, 0x00000000, 0x60b99ea7, 0x00000000, 0x00000000, 0 }, /* #6 */
    { 0x2a3ed2, 0x2a3606, 0x3ac7a8b6, 0x00000000, 0x0c4d5932, 0x00000000, 0x00000000, 0 }, /* #7 */
    { 0x266b53, 0x266306, 0xfb5f47ec, 0x00000000, 0x4a468df2, 0x00000000, 0x00000000, 0 }, /* #8 */
    { 0x374097, 0x374006, 0x5dc634c0, 0x00000000, 0x33966813, 0x00000000, 0x00000000, 0 }, /* #9 */
    { 0x0c1613, 0x0c1606, 0x5354cb86, 0x00000000, 0x0016f176, 0x00000000, 0x00000000, 0 }, /* #10 */
    { 0x2c1152, 0x2c1106, 0x9500ab5b, 0x00000000, 0xfb2a9036, 0x00000000, 0x00000000, 0 }, /* #11 */
    { 0x106f83, 0x106f03, 0x68921a5d, 0x2fcf87ef, 0x58f48369, 0x0671d899, 0x0fc6febb, 0 }, /* #12 */
    { 0x392943, 0x392907, 0xc0db3458, 0x749b1460, 0x50faa976, 0x9700354f, 0xc870c524, 0 }, /* #13 */
    { 0x1c7ed6, 0x1c7e07, 0xefe6d216, 0x71e0a6d2, 0x8ef8b523, 0x0ea52ffc, 0x0fa0c5db, 0 }, /* #14 */
    { 0x122d52, 0x122d07, 0x9aa8f256, 0x7e635122, 0x1bcd673c, 0x01b099b4, 0x02cc0f33, 0 }, /* #15 */
    { 0x3e4c47, 0x3e4c07, 0x92ce9ac2, 0x3670f644, 0xedd8f460, 0x5c1bf137, 0xa09e5c62, 0 }, /* #16 */
    { 0x186f42, 0x186f07, 0x51a73de3, 0x353e9b63, 0x6592d5e6, 0x485882a4, 0xe2d1a481, 0 }, /* #17 */
    { 0x240383, 0x240b83, 0x5e2207e0, 0x8bb2fb40, 0x50cc5acc, 0x016695dd, 0x03cf31a6, 0 }, /* #18 */
    { 0x234297, 0x234a03, 0x34ef3010, 0x66bc9d20, 0x0dabf912, 0x198946b3, 0x7b7f73d2, 0 }, /* #19 */
    { 0x3c4896, 0x3c4807, 0x8e10e28f, 0x1f91efa5, 0x86de4038, 0x1d60ccc4, 0x34f0548b, 0 }, /* #20 */
    { 0x043546, 0x043d87, 0xec59f0d8, 0xd29188d8, 0xa27bc586, 0xb185f63d, 0xc0480901, 0 }, /* #21 */
    { 0x3a7807, 0x3a7887, 0x3e153e93, 0xf2206fb2, 0xee862c54, 0x3a4bb260, 0xf0620ec6, 0 }, /* #22 */
    { 0x1a7293, 0x1a7a07, 0x47c55af5, 0x7c2df67e, 0x6dfe1231, 0x3498a0ac, 0xbb9b09c6, 0 }, /* #23 */
    { 0x055706, 0x055f03, 0x9337db76, 0x11c60a62, 0xaf936cf8, 0x39b6b2e8, 0x645bf403, 0 }, /* #24 */
    { 0x075b97, 0x075b03, 0x74a0e3c8, 0x490a3570, 0x8cd5318e, 0x0c78dae8, 0x1b60549e, 0 }, /* #25 */
    { 0x0b3756, 0x0b3f83, 0x42567680, 0xd8ff6080, 0x35803cee, 0x00534c1f, 0x014172a5, 0 }, /* #26 */
    { 0x373b92, 0x373b03, 0xb74e7a87, 0x28ea6775, 0xb785b165, 0x121b908d, 0x1949e123, 0 }, /* #27 */
    { 0x371a86, 0x371a87, 0xc6f476a1, 0xe4d89dfc, 0x4f1129e4, 0x8f1d5d03, 0xb826287c, 0 }, /* #28 */
    { 0x032346, 0x032b83, 0x1fe1df14, 0x9bfb88f8, 0xe3c1edf4, 0x1a7ce3fd, 0xd4af5f26, 0 }, /* #29 */
    { 0x1767d3, 0x176f03, 0xbf087435, 0x7e81702c, 0x3ecc058e, 0xbc395dc2, 0xfc3c5cfc, 0 }, /* #30 */
    { 0x1333d2, 0x133b03, 0xb88646c5, 0x137c50fb, 0x69f64e8e, 0xb2cd66b5, 0xf80fb4bf, 0 }, /* #31 */
    { 0x177192, 0x177907, 0x9b36c237, 0x07004fe1, 0x3160ebe9, 0x021e3b57, 0x037e52a7, 0 }, /* #32 */
    { 0x3d0512, 0x3d0d07, 0xa5eefaa6, 0x7ab10a9a, 0x276e524f, 0x4edf621a, 0x79aefedf, 0 }, /* #33 */
    { 0x166c16, 0x166c03, 0xdde62791, 0x64d9e63d, 0x3f090738, 0xb9fd588d, 0xd69275ed, 0 }, /* #34 */
    { 0x381093, 0x381883, 0x4665d1c8, 0xa04cae98, 0x8f5ac4cf, 0x0ea1dc6c, 0x3535c06b, 0 }, /* #35 */
    { 0x3e0116, 0x3e0987, 0xbee8086a, 0xaaee5d6c, 0x8845eb8d, 0x1d0a28a7, 0x26f0fe9e, 0 }, /* #36 */
    { 0x064692, 0x064e87, 0x899c3b1b, 0x82073063, 0xfc416ce5, 0x0f575c85, 0x1c8a2c59, 0 }, /* #37 */
    { 0x1702d6, 0x170a03, 0x16320021, 0x4e748d10, 0xac29cedb, 0x0d21217d, 0x976f2b10, 0 }, /* #38 */
    { 0x394553, 0x394d87, 0x26df80eb, 0xee4c30a0, 0xb691fe31, 0x09630e43, 0x3dd169e0, 0 }, /* #39 */
    { 0x1c64d2, 0x1c6c03, 0x85175bae, 0x6a35ccf8, 0x3eb74b5f, 0x796b1eea, 0xe98c25e4, 0 }, /* #40 */
    { 0x215346, 0x215b03, 0xb0437d59, 0x06ae9c9d, 0x9cf0a9f3, 0xa0ba7271, 0xe96fdce5, 0 }, /* #41 */
    { 0x001846, 0x001883, 0x6fdd2ffb, 0xbe44b12f, 0x91014d93, 0x22802a7c, 0x4ef4595d, 0 }, /* #42 */
    { 0x083a83, 0x083a87, 0x0f36769d, 0xfeaa4f05, 0xeb1bae4b, 0x001be7e6, 0x01d59989, 0 }, /* #43 */
    { 0x126756, 0x126f03, 0x4d50b655, 0x7b318ea8, 0xb3b1dbc2, 0x0fee8232, 0x34c06c08, 0 }, /* #44 */
    { 0x1627c7, 0x162f87, 0x4f6a702e, 0x87115712, 0x25ad5618, 0x1fb2043f, 0x662bdd5f, 0 }, /* #45 */
    { 0x2c0213, 0x2c0a83, 0xf6b7aeab, 0xf2ddd3b6, 0x6587a5d7, 0xa96646a5, 0xafc5e322, 0 }, /* #46 */
    { 0x382f97, 0x382f87, 0x4116a80f, 0x846a5d5a, 0x6ba92dd9, 0x18340f49, 0x5f31c306, 0 }, /* #47 */
    { 0x124647, 0x124e87, 0xb4c2fc54, 0xaa507100, 0x18e59b54, 0x4bf3b15c, 0x6b90bb40, 0 }, /* #48 */
    { 0x022053, 0x022883, 0xbc24e1aa, 0xfabecdc8, 0x320f7852, 0x97089be1, 0xcd815d54, 0 }, /* #49 */
    { 0x2211d6, 0x221907, 0x06cda43a, 0x34fab984, 0x3ff8644a, 0x033d49f6, 0x79e5342a, 0 }, /* #50 */
    { 0x1e7857, 0x1e7883, 0x6465655a, 0x905de602, 0x98491ccb, 0x1c8c5fb6, 0x48cba025, 0 }, /* #51 */
    { 0x3e3743, 0x3e3f03, 0xba2dd0fc, 0x372c8b98, 0x646bc2b5, 0x3d10e27d, 0x53f78b9a, 0 }, /* #52 */
    { 0x1d1a16, 0x1d1a87, 0x00d9558f, 0x8ab3d2f0, 0x1bb5b724, 0x006e27e0, 0x81c0e610, 0 }, /* #53 */
    { 0x0b6582, 0x0b6d03, 0x11f21690, 0x24722410, 0x95018cc0, 0x11b0afc3, 0xfc5b0719, 0 }, /* #54 */
    { 0x290513, 0x290d87, 0xacd623c5, 0xb06e0eac, 0x7f2708c4, 0x1f496441, 0x2e5742bc, 0 }, /* #55 */
    { 0x303912, 0x303903, 0x48e4564f, 0x59324a43, 0x1d2e0713, 0x2cfa0335, 0x9df5c3cd, 0 }, /* #56 */
    { 0x234907, 0x234983, 0xbd335162, 0x87fdcac4, 0x0c36b055, 0x16d8d3ee, 0x1ee9d402, 0 }, /* #57 */
    { 0x254d93, 0x254d83, 0xf5a37ed1, 0xbfe0b231, 0x2d33a4a5, 0x524627c8, 0x55be9561, 0 }, /* #58 */
    { 0x0429c6, 0x042983, 0x5d8b7f0d, 0xa32d8454, 0xd40387c9, 0x19974bcc, 0x4608a0a4, 0 }, /* #59 */
    { 0x126cd6, 0x126c03, 0x65625402, 0x2499d1f2, 0x263169d1, 0x57cb36ab, 0xddaf0ef9, 0 }, /* #60 */
    { 0x1e0e13, 0x1e0e03, 0xd6280f9a, 0x0492d6f8, 0xb96bfecd, 0xcb51c4ea, 0xf30ba56c, 0 }, /* #61 */
    { 0x3831c2, 0x383907, 0x18dfe929, 0x1dd2a56c, 0xd3b0f1ee, 0x037e43de, 0x23f36b8c, 0 }, /* #62 */
    { 0x291486, 0x291c87, 0x36181638, 0xdd6f5848, 0x5ffede65, 0x28d67dc8, 0xc143d3af, 0 }, /* #63 */
    { 0x377c82, 0x377c87, 0x5d6e3ec4, 0xc15d8018, 0x1ddee2c3, 0x0a415a63, 0x1c1977e6, 0 }, /* #64 */
    { 0x2f2417, 0x2f2c83, 0x9dd6cd3e, 0xe9b33afe, 0x4dbb8b2a, 0x9d899220, 0xff82bd21, 0 }, /* #65 */
    { 0x3d37d6, 0x3d3f83, 0x06580a7e, 0xa5858cce, 0x0b394d8d, 0x023b76d9, 0x5a14acd9, 0 }, /* #66 */
    { 0x0b3942, 0x0b3983, 0x0b2538e7, 0xef532edc, 0x341bd645, 0x0547a0b5, 0x7945b2c4, 0 }, /* #67 */
    { 0x153dc7, 0x153d83, 0xf6ff2495, 0x807548a7, 0xa6764383, 0xaca6f173, 0xb2f20d4b, 0 }, /* #68 */
    { 0x262986, 0x262903, 0xac220f28, 0x71e2dc08, 0x341b287c, 0x530696e2, 0x7b7a496d, 0 }, /* #69 */
    { 0x326652, 0x326e03, 0xf20cebfb, 0x0827d8f2, 0x107a18b2, 0x0b81d142, 0x0c2b9636, 0 }, /* #70 */
    { 0x275796, 0x275f07, 0xc70946ea, 0x5863140c, 0x0da9da83, 0x1b595991, 0x232d1f2e, 0 }, /* #71 */
    { 0x3f7992, 0x3f7983, 0xdfab12ec, 0xfff68b34, 0x22bc89d6, 0x04d9fa40, 0x058d8217, 0 }, /* #72 */
    { 0x326a07, 0x326a07, 0x300dd710, 0x4c483e00, 0xd18d7f70, 0x2f51100b, 0xfc1251e0, 0 }, /* #73 */
    { 0x090f46, 0x090f03, 0x642fee45, 0x30f519a1, 0xfa4ad1f3, 0x271b1e57, 0x63ec91ad, 0 }, /* #74 */
    { 0x200552, 0x200d07, 0xcf6cd917, 0x09941669, 0x8a57120a, 0x7af903d4, 0x97c53c7f, 0 }, /* #75 */
    { 0x381082, 0x381807, 0x9dd6cc5a, 0x3c0f193c, 0xcaf03b90, 0x8d321b52, 0xe5018fd6, 0 }, /* #76 */
    { 0x0b0716, 0x0b0f83, 0x7dd7533b, 0xc1d0c2d3, 0x6406efb5, 0x4daab8c6, 0x9dffa549, 0 }, /* #77 */
    { 0x2c6d53, 0x2c6d03, 0x80d20891, 0x42778c3b, 0x2a20ece6, 0x4878d031, 0x90054e0b, 0 }, /* #78 */
    { 0x303cc6, 0x303c87, 0x8b4e94e1, 0xc2a63a8d, 0x1ce4b4d7, 0x5d8389e6, 0xabd8ef2d, 0 }, /* #79 */
    { 0x363983, 0x363907, 0x76a7377f, 0x4c5314d1, 0x657eef34, 0x18e523dd, 0x35b65baf, 0 }, /* #80 */
    { 0x2c52c2, 0x2c5a07, 0x39eeaeb5, 0x69ff4c21, 0xa1fbf0ba, 0x0ae7d007, 0x3030df3d, 0 }, /* #81 */
    { 0x103982, 0x103907, 0x8be12f5b, 0x0857b6c3, 0xfebb6cbf, 0x3f79ffcb, 0x742bdab9, 0 }, /* #82 */
    { 0x3b2692, 0x3b2e03, 0xb804fba6, 0x76968c94, 0x18ce973c, 0x1e9665c1, 0x2a8d504e, 0 }, /* #83 */
    { 0x1f6d06, 0x1f6d83, 0x96912a71, 0xc044b95d, 0x2fa18a7a, 0x1f375da8, 0x35133bad, 0 }, /* #84 */
    { 0x0d29d3, 0x0d2907, 0x3b087760, 0x3bd0c4a0, 0x09f93aa9, 0x1e41aef5, 0x83358f9f, 0 }, /* #85 */
    { 0x102006, 0x102803, 0x8933a124, 0x5429ffa8, 0xc44db265, 0x3b128ac0, 0x6e38a49a, 0 }, /* #86 */
    { 0x393482, 0x393c07, 0x301508b3, 0x458f7b21, 0xfda2449d, 0x179a8a26, 0x7dabcedb, 0 }, /* #87 */
    { 0x242687, 0x242e03, 0xc1fec227, 0x3a0ede4c, 0xe631dec4, 0x1b63d934, 0x2424fad4, 0 }, /* #88 */
    { 0x373a13, 0x373a87, 0x9c800c01, 0xc142d91d, 0xa723923c, 0x785e5437, 0xc4e57d1d, 0 }, /* #89 */
    { 0x230cc6, 0x230c87, 0x2b1b38ba, 0xc563c72e, 0xab3cc0bd, 0x147422d2, 0x79786083, 0 }, /* #90 */
    { 0x397d03, 0x397d87, 0xa422348d, 0x94c36a8d, 0x5324b83c, 0x321bc844, 0x4e278e01, 0 }, /* #91 */
    { 0x1b2987, 0x1b2987, 0xf689cacc, 0xe4096084, 0xa6791163, 0x2a744852, 0x2c1563db, 0 }, /* #92 */
    { 0x100813, 0x100803, 0xa132240a, 0x2f054d02, 0x987b396a, 0x5f361a7f, 0x97353f4d, 0 }, /* #93 */
    { 0x156a02, 0x156a83, 0xac7ce63a, 0xf3cdc6da, 0x32dffaa3, 0x537bf329, 0x7be77091, 0 }, /* #94 */
    { 0x0a0353, 0x0a0b03, 0x81fbd7c1, 0x66b62aa1, 0xc0b439a6, 0x2792a185, 0x4df00ae1, 0 }, /* #95 */
};
uint32_t const g_cTests_mul_u32_intel = RT_ELEMENTS(g_aTests_mul_u32_intel);

MULDIVU32_TEST_T const g_aTests_imul_u32_intel[] =
{
    { 0x1e2406, 0x1e2406, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #0 */
    { 0x351fd6, 0x351706, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #1 */
    { 0x276683, 0x276606, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #2 */
    { 0x3d3607, 0x3d3606, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #3 */
    { 0x3d1e52, 0x3d1606, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #4 */
    { 0x3a52c3, 0x3a5206, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #5 */
    { 0x3c1f46, 0x3c1706, 0x6cef02ad, 0x00000000, 0x5b9e0568, 0x00000000, 0x00000000, 0 }, /* #6 */
    { 0x114153, 0x114106, 0xf32bc5a2, 0x00000000, 0x2a33467d, 0x00000000, 0x00000000, 0 }, /* #7 */
    { 0x312b17, 0x312306, 0x897c53f2, 0x00000000, 0xcbc895c1, 0x00000000, 0x00000000, 0 }, /* #8 */
    { 0x0243d3, 0x024306, 0x6c76eb29, 0x00000000, 0xd0f472e7, 0x00000000, 0x00000000, 0 }, /* #9 */
    { 0x390f43, 0x390706, 0x95e8ee0f, 0x00000000, 0xbb53db62, 0x00000000, 0x00000000, 0 }, /* #10 */
    { 0x3d6b97, 0x3d6306, 0x100af946, 0x00000000, 0x7222fd00, 0x00000000, 0x00000000, 0 }, /* #11 */
    { 0x1d74c6, 0x1d7c83, 0x14c9991c, 0x9fc41398, 0x03000ba9, 0xf71bc9a1, 0x928038ea, 0 }, /* #12 */
    { 0x0754d2, 0x075c03, 0x12c79a7d, 0x3c1d0f34, 0x9c102a11, 0x0919edf5, 0x7c10fe44, 0 }, /* #13 */
    { 0x271906, 0x271907, 0x933033a1, 0x0df0e166, 0x192e12b1, 0xf00cff71, 0x258607a6, 0 }, /* #14 */
    { 0x3e2757, 0x3e2f83, 0x64639959, 0xfe8e9c15, 0x11a4a187, 0xd6dacdb1, 0x9713851d, 0 }, /* #15 */
    { 0x074347, 0x074b07, 0xb47c99a4, 0x0b4253d8, 0x517ffdcd, 0x24765258, 0x84636a86, 0 }, /* #16 */
    { 0x073e43, 0x073e07, 0x8f49960b, 0x2cb65496, 0xa6a4108f, 0x166e7d7b, 0xcd0d4982, 0 }, /* #17 */
    { 0x3b0052, 0x3b0883, 0x8c0fabf0, 0x92b8ed40, 0xe4c2a727, 0xfc5b7d70, 0x080b0a2c, 0 }, /* #18 */
    { 0x0109c7, 0x010903, 0x0ac13844, 0x55d95ff4, 0x80f48c14, 0x03a16f05, 0x566baf2d, 0 }, /* #19 */
    { 0x312547, 0x312d83, 0xff520d7f, 0xbc066623, 0x42b1cd4b, 0xffea5e38, 0x1fd6015d, 0 }, /* #20 */
    { 0x1520d7, 0x152883, 0x376745b8, 0xd8f79270, 0x0ecb9280, 0x0bb8eed3, 0x362a4622, 0 }, /* #21 */
    { 0x256507, 0x256d87, 0x60156ed3, 0x986ff0bb, 0x20b88376, 0x0ad7db3f, 0x1ce3d579, 0 }, /* #22 */
    { 0x2a2146, 0x2a2987, 0xba8cb283, 0xd55ecb2d, 0x0e45090e, 0xebafcd99, 0x4ae05c8f, 0 }, /* #23 */
    { 0x2303c2, 0x230b07, 0x1fa88ab6, 0x55361b28, 0xf059b7c7, 0xf04c3bf8, 0x8106d8fc, 0 }, /* #24 */
    { 0x2248c2, 0x224807, 0x5e8e07ba, 0x6eaee488, 0x3b2d3306, 0x1ed2dc65, 0x5373e914, 0 }, /* #25 */
    { 0x3c7382, 0x3c7b83, 0xfb4998c6, 0xf633a2dc, 0xabd02199, 0xff8ec841, 0x1806613a, 0 }, /* #26 */
    { 0x3d31c2, 0x3d3903, 0x58a528cf, 0x5b53a5e0, 0x323e0530, 0x210d5ab5, 0x5f73b420, 0 }, /* #27 */
    { 0x257453, 0x257c83, 0x7ea8834a, 0xdfce838a, 0xe4c92c9f, 0xf399051b, 0xe6eec5a1, 0 }, /* #28 */
    { 0x287317, 0x287b07, 0x938f947d, 0x2e1ad8f5, 0xe6518d7b, 0x11acdbe8, 0xd645d7d9, 0 }, /* #29 */
    { 0x2728c2, 0x272883, 0x438394d3, 0xe141a6f8, 0xf8ce2612, 0xe2f408fe, 0x91dc4228, 0 }, /* #30 */
    { 0x0e6152, 0x0e6907, 0xb7c7906f, 0x45986255, 0x59f72b79, 0xe7ab754d, 0x563e537b, 0 }, /* #31 */
    { 0x375752, 0x375f07, 0x99c5fdc3, 0x7917ba18, 0x0218a885, 0x0a2eac0e, 0xe6804408, 0 }, /* #32 */
    { 0x2a0c47, 0x2a0c03, 0xa1d7f329, 0x68eee19d, 0x5c0c8d88, 0xe7dba75f, 0x41a39d55, 0 }, /* #33 */
    { 0x341152, 0x341983, 0x0b340ead, 0xc4688fab, 0x401f5495, 0x0279fa7b, 0x38969ab7, 0 }, /* #34 */
    { 0x391883, 0x391803, 0xa957d6dc, 0x50396158, 0xd95082e7, 0xee010f78, 0x3529ba5a, 0 }, /* #35 */
    { 0x2a6813, 0x2a6803, 0x9220708d, 0x78ed4fe0, 0x2c5e89b3, 0x29bec61a, 0x9ebc4760, 0 }, /* #36 */
    { 0x377e16, 0x377e07, 0x12919035, 0x0bc973a3, 0x26ab8f66, 0x07b2f708, 0x6a251f77, 0 }, /* #37 */
    { 0x334643, 0x334e87, 0x6d8dffab, 0xfc353b4b, 0x3caa0e1d, 0xf7592fd1, 0xebc892e1, 0 }, /* #38 */
    { 0x335387, 0x335b83, 0xda7e9fe5, 0xaa3ad11c, 0xa290b134, 0xfead67f7, 0x090722ec, 0 }, /* #39 */
    { 0x283407, 0x283c03, 0x86844a60, 0x07306620, 0xbc7e9d0b, 0xe7dd8156, 0x32dbdbeb, 0 }, /* #40 */
    { 0x251743, 0x251f07, 0x1e4b2a2d, 0x673f58af, 0x7c55d3fa, 0x06ef7a05, 0x3a9be3cb, 0 }, /* #41 */
    { 0x0c2e13, 0x0c2e83, 0xf1cbcdd6, 0x9d1f3916, 0x5df2b7fa, 0x05235c06, 0xa364f8e1, 0 }, /* #42 */
    { 0x144bd6, 0x144b83, 0x531c8db9, 0xb5bcf661, 0xc4ad3f70, 0x1cdbeb8b, 0x58e441e9, 0 }, /* #43 */
    { 0x1641d6, 0x164903, 0xd83b401e, 0x72dbb7a2, 0xa1ffb375, 0xf35d3f71, 0x5156e61f, 0 }, /* #44 */
    { 0x0878c6, 0x087803, 0x6d591289, 0x6d748d08, 0xd511e600, 0x249a2eed, 0x55b102c8, 0 }, /* #45 */
    { 0x046197, 0x046987, 0xf118554d, 0xf801d89c, 0x8fd114db, 0x03a43706, 0xc174bd0c, 0 }, /* #46 */
    { 0x0a20c6, 0x0a2887, 0xb15ebddf, 0xf6ab3074, 0x6a8bacc9, 0x0e712758, 0xd0faf60c, 0 }, /* #47 */
    { 0x2d1653, 0x2d1e87, 0xbe124717, 0xe97f013f, 0x82cb80c9, 0x19d03313, 0x9bc47019, 0 }, /* #48 */
    { 0x112883, 0x112807, 0x056af6df, 0x4c721766, 0x81b657ad, 0x021cd665, 0x63d3535a, 0 }, /* #49 */
    { 0x227752, 0x227f87, 0x67f6d34f, 0xd49457b2, 0xafc3c09a, 0xf7cf9287, 0xebd5c8ae, 0 }, /* #50 */
    { 0x196857, 0x196807, 0x4b853198, 0x691dffa0, 0x87745075, 0x17648718, 0x4f4c043c, 0 }, /* #51 */
    { 0x3f4b52, 0x3f4b07, 0x38221287, 0x12331511, 0x8c921b1e, 0xebb341ba, 0xa36bc9a7, 0 }, /* #52 */
    { 0x247f42, 0x247f03, 0x9e63838e, 0x23267962, 0x4616a220, 0xf2161f08, 0x247d8dc7, 0 }, /* #53 */
    { 0x1d4916, 0x1d4987, 0x30ffc7ad, 0xe5589b9f, 0x473d8d57, 0xf6a1ae6d, 0xcf0dc9fb, 0 }, /* #54 */
    { 0x1f0912, 0x1f0983, 0x1fae70c4, 0x8bedac1c, 0x18af7ae4, 0xf38fc5f3, 0x9b7e04b7, 0 }, /* #55 */
    { 0x3e68d6, 0x3e6883, 0x480233c0, 0xd52f9540, 0x87f1b29f, 0x0ef21925, 0x3522479b, 0 }, /* #56 */
    { 0x0e7d12, 0x0e7d83, 0x22200bd7, 0xb5c9ca38, 0x86ef005b, 0x0a4081b0, 0x4ce88088, 0 }, /* #57 */
    { 0x1c0617, 0x1c0e87, 0xfcc54b72, 0xcef29d9c, 0x0d7543b5, 0x0078d717, 0xda948c3e, 0 }, /* #58 */
    { 0x141807, 0x141807, 0x3d71de1a, 0x73a09456, 0xe77c2583, 0x1926c1f0, 0x68ca1017, 0 }, /* #59 */
    { 0x0a6ed6, 0x0a6e03, 0x88477650, 0x4b666820, 0xfe3df512, 0x383e1c4a, 0x87bc695a, 0 }, /* #60 */
    { 0x1a3092, 0x1a3887, 0xbe20ad97, 0xc931d724, 0x4ef14552, 0x0ff0dad3, 0xc20c8e7c, 0 }, /* #61 */
    { 0x2720c3, 0x272887, 0xed4d93eb, 0x8cd8b55f, 0xa0dc0572, 0x08de2bd7, 0x8694ab5d, 0 }, /* #62 */
    { 0x3d6046, 0x3d6883, 0x46c2a2a1, 0x81063067, 0xab2f7f61, 0x1e39785d, 0x6d58fe07, 0 }, /* #63 */
    { 0x110706, 0x110f83, 0x9a4aa1be, 0x843173ec, 0x3bc9cda0, 0xef4e8538, 0x2a0456ca, 0 }, /* #64 */
    { 0x3a47c3, 0x3a4f07, 0x41527bab, 0x73b72e42, 0xe1dc39c4, 0x03f31d89, 0x0f7a98c6, 0 }, /* #65 */
    { 0x016883, 0x016807, 0xb5221693, 0x7cbba1fa, 0x259e4798, 0x19525547, 0xa96a485e, 0 }, /* #66 */
    { 0x0f7b07, 0x0f7b07, 0x2baf3700, 0x6f58b000, 0x10e6b3ae, 0x02169ab0, 0x0c3ce4d0, 0 }, /* #67 */
    { 0x1d6c92, 0x1d6c07, 0xfde16757, 0x25d42ec6, 0x868fabbf, 0x00e95753, 0x91e889aa, 0 }, /* #68 */
    { 0x0b7a16, 0x0b7a87, 0xedceaacc, 0x983ebb6c, 0xd0a3fc9e, 0xfaee8d8a, 0x47511f39, 0 }, /* #69 */
    { 0x323443, 0x323c07, 0xdf765f16, 0x6a22f6be, 0x350ec1b3, 0xf13c408f, 0x742a5dfd, 0 }, /* #70 */
    { 0x257d96, 0x257d07, 0x88792b3f, 0x37ebd3d7, 0x773047c4, 0xf74466e7, 0x12b42969, 0 }, /* #71 */
    { 0x090703, 0x090f87, 0x900d721e, 0xfa5b557e, 0x0d7ee719, 0xfa0b1eb2, 0x0d9f1351, 0 }, /* #72 */
    { 0x165942, 0x165903, 0x082ad3a7, 0x591f4d46, 0xdb863d21, 0xfc74f1f9, 0x90f0c94a, 0 }, /* #73 */
    { 0x365646, 0x365e03, 0x5cb6acd7, 0x01895751, 0x88859d6c, 0xf6cb4bd4, 0xe694b017, 0 }, /* #74 */
    { 0x2a2b56, 0x2a2b03, 0xd468e3b5, 0x728b6ff4, 0x00243d29, 0x0413e63f, 0xe80d50a4, 0 }, /* #75 */
    { 0x204407, 0x204c03, 0x650d8c25, 0x1e91a1fe, 0x6c4ce811, 0xf89cd9fb, 0xed491aa6, 0 }, /* #76 */
    { 0x3b4456, 0x3b4c03, 0x4e430528, 0x16a61620, 0x4040111a, 0x09e46113, 0x205b9874, 0 }, /* #77 */
    { 0x3c6e57, 0x3c6e07, 0x80ff734d, 0x0eba309a, 0x5fc06f0c, 0xff49b5a7, 0x016f7202, 0 }, /* #78 */
    { 0x182c13, 0x182c03, 0x7dcb1822, 0x49a9ad8a, 0x723c37e0, 0xf993aa05, 0xf2eda375, 0 }, /* #79 */
    { 0x384302, 0x384b07, 0xffb821f8, 0x09a61300, 0xf81ac516, 0xffef48c4, 0x3b8b25a0, 0 }, /* #80 */
    { 0x3542d3, 0x354a03, 0x171e7bd6, 0x146363e6, 0x30480d50, 0xfcc8f709, 0xdc667219, 0 }, /* #81 */
    { 0x010003, 0x010803, 0x13ce1d60, 0x6d473c80, 0x8112b97a, 0x06c36889, 0x576c14ac, 0 }, /* #82 */
    { 0x1e1416, 0x1e1c83, 0x6cb708ce, 0xa8c692a2, 0xf73d206b, 0xebd14112, 0xd0797187, 0 }, /* #83 */
    { 0x261ad3, 0x261a87, 0x3e3c16c5, 0xc4f78422, 0xe89ae32b, 0xe934318a, 0xa23aa5ba, 0 }, /* #84 */
    { 0x0a7986, 0x0a7903, 0xbd75069b, 0x5051c37a, 0x96b698a6, 0x0c001c86, 0xd1d5250e, 0 }, /* #85 */
    { 0x271912, 0x271907, 0x03a53b72, 0x519a0ac0, 0x3e898a00, 0x005159f0, 0x1650e060, 0 }, /* #86 */
    { 0x084156, 0x084983, 0x3d2d9b21, 0xba4f0551, 0xebfa40f8, 0x174c59c1, 0x617dd431, 0 }, /* #87 */
    { 0x054106, 0x054903, 0x9e78e6ee, 0x7c142e76, 0xf29d862b, 0xf8c1595d, 0x1304435d, 0 }, /* #88 */
    { 0x085ed2, 0x085e03, 0x6cfb8f5f, 0x075d4bc2, 0xae35772c, 0xea262fdb, 0xccac257e, 0 }, /* #89 */
    { 0x360652, 0x360e87, 0x9b0d07a8, 0xe8c2e930, 0x4a92cc9e, 0x102b8408, 0xd6fe78ce, 0 }, /* #90 */
    { 0x0f3e13, 0x0f3e87, 0x8082fa7f, 0x91a73d36, 0xd09dcfcd, 0xdd10ee00, 0x4625ebca, 0 }, /* #91 */
    { 0x241c52, 0x241c83, 0xb4126454, 0xa92817d0, 0x94af5126, 0xf8cd7a60, 0x18444324, 0 }, /* #92 */
    { 0x025197, 0x025907, 0xde3f3ddc, 0x7e1f7878, 0x65918c72, 0x06715c11, 0xcf226652, 0 }, /* #93 */
    { 0x316a87, 0x316a83, 0xfd024ab3, 0xadb03ada, 0x7b7f500a, 0x00b97ab5, 0xc1fd0ebe, 0 }, /* #94 */
    { 0x215a02, 0x215a07, 0xe109600f, 0x5303fae4, 0xdfead0ca, 0x00f325b8, 0xf825b2dc, 0 }, /* #95 */
};
uint32_t const g_cTests_imul_u32_intel = RT_ELEMENTS(g_aTests_imul_u32_intel);

MULDIVU32_TEST_T const g_aTests_div_u32_intel[] =
{
    { 0x0b11c7, 0x0b11c7, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #0 */
    { 0x1248c3, 0x1248c3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #1 */
    { 0x0c3c02, 0x0c3c02, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #2 */
    { 0x3308d7, 0x3308d7, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #3 */
    { 0x1f6482, 0x1f6482, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #4 */
    { 0x261356, 0x261356, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #5 */
    { 0x3b4782, 0x3b4782, 0x930e21e7, 0x930e21e7, 0x2ca96c05, 0x2ca96c05, 0x00000000, -1 }, /* #6 */
    { 0x0d7d17, 0x0d7d17, 0x92a62b39, 0x92a62b39, 0x9138c8bf, 0x9138c8bf, 0x00000000, -1 }, /* #7 */
    { 0x3601d2, 0x3601d2, 0xe40d9f64, 0xe40d9f64, 0x82f7dd84, 0x82f7dd84, 0x00000000, -1 }, /* #8 */
    { 0x2b5b03, 0x2b5b03, 0x6e07febd, 0x6e07febd, 0x8b91d8ad, 0x8b91d8ad, 0x00000000, -1 }, /* #9 */
    { 0x3f0043, 0x3f0043, 0x5ad16247, 0x5ad16247, 0xcf7a0b70, 0xcf7a0b70, 0x00000000, -1 }, /* #10 */
    { 0x3e01d6, 0x3e01d6, 0x2f70863f, 0x2f70863f, 0x1cac4af2, 0x1cac4af2, 0x00000000, -1 }, /* #11 */
    { 0x0a2503, 0x0a2503, 0x58f9a376, 0xd42942cf, 0xc3d9272a, 0x4abe2eb3, 0xec50fbcd, 0 }, /* #12 */
    { 0x283183, 0x283183, 0x3e72ac53, 0x3e72ac53, 0x3a0dcee0, 0x3a0dcee0, 0x11cb2e39, -1 }, /* #13 */
    { 0x0d7cd6, 0x0d7cd6, 0x5fa47007, 0x5fa47007, 0xe83f91f1, 0xe83f91f1, 0xa031231f, -1 }, /* #14 */
    { 0x396d02, 0x396d02, 0x10c6e998, 0xd19d3114, 0xa69535d7, 0x5e2b07a8, 0xcb72444c, 0 }, /* #15 */
    { 0x154613, 0x154613, 0xe330783e, 0x61c9a943, 0x4bffddeb, 0xad8066f9, 0xc6f5ced7, 0 }, /* #16 */
    { 0x165c07, 0x165c07, 0xcf71ff11, 0xcf71ff11, 0xf71f751e, 0xf71f751e, 0x7c5e2f14, -1 }, /* #17 */
    { 0x382152, 0x382152, 0x7bb2fb8a, 0x7bb2fb8a, 0x91885713, 0x91885713, 0x1922caf9, -1 }, /* #18 */
    { 0x0240c6, 0x0240c6, 0x3bb862eb, 0x3bb862eb, 0x4fc1d7fc, 0x4fc1d7fc, 0x4b823291, -1 }, /* #19 */
    { 0x101a97, 0x101a97, 0x07d40b8e, 0x638017e5, 0x3f70d348, 0x747c3279, 0xa3394971, 0 }, /* #20 */
    { 0x320b96, 0x320b96, 0x4f9c5e95, 0x4f9c5e95, 0x9ae999c2, 0x9ae999c2, 0x355c93a8, -1 }, /* #21 */
    { 0x373192, 0x373192, 0xc939a926, 0x26f4b40a, 0x260fedbe, 0x6b63af98, 0xfa20995b, 0 }, /* #22 */
    { 0x146346, 0x146346, 0xeee379d8, 0xeee379d8, 0xbcc3e8b4, 0xbcc3e8b4, 0x9e02cea6, -1 }, /* #23 */
    { 0x311d87, 0x311d87, 0x787467b3, 0x787467b3, 0xd7e99c86, 0xd7e99c86, 0x680345a9, -1 }, /* #24 */
    { 0x1d3b56, 0x1d3b56, 0x14471698, 0x0bce17a4, 0x0a89832f, 0x1d96f110, 0xe4814712, 0 }, /* #25 */
    { 0x1d7013, 0x1d7013, 0x1626867a, 0x1626867a, 0x798eef48, 0x798eef48, 0x62c5a830, -1 }, /* #26 */
    { 0x231786, 0x231786, 0x9ce37d72, 0x9ce37d72, 0x75327a7e, 0x75327a7e, 0x42870a55, -1 }, /* #27 */
    { 0x272752, 0x272752, 0x6f232d70, 0x6f232d70, 0x7562c223, 0x7562c223, 0x04694dd2, -1 }, /* #28 */
    { 0x266047, 0x266047, 0x5c838001, 0x5c838001, 0xdae94f4a, 0xdae94f4a, 0x024147be, -1 }, /* #29 */
    { 0x0440d6, 0x0440d6, 0xdd4422eb, 0x6d7489e9, 0x3644c102, 0x7e742aa6, 0x7eed25fd, 0 }, /* #30 */
    { 0x033cd7, 0x033cd7, 0x97f1cea5, 0x7f44a8ab, 0x2fe30838, 0x2fffc2d1, 0x60530b7c, 0 }, /* #31 */
    { 0x2a58c3, 0x2a58c3, 0x17a2b101, 0xaab8f103, 0x3006b455, 0x0279db8d, 0x4804087c, 0 }, /* #32 */
    { 0x1d3217, 0x1d3217, 0xfa9f7311, 0x52da15a0, 0x4a25b986, 0x4719d111, 0xe51ab350, 0 }, /* #33 */
    { 0x275216, 0x275216, 0x7c925208, 0x311c03f4, 0x2ac14d0f, 0x33766c68, 0xdee02f88, 0 }, /* #34 */
    { 0x2a2c43, 0x2a2c43, 0xd8a32cbe, 0xb778b60a, 0x6f0b13c3, 0x82168afe, 0x9af0a360, 0 }, /* #35 */
    { 0x284003, 0x284003, 0xe0a42758, 0x650ed07d, 0x5c6a4e6d, 0x6d2e24c4, 0xea1b4524, 0 }, /* #36 */
    { 0x0f2543, 0x0f2543, 0xe0b23e5b, 0xe0b23e5b, 0xfc4b4831, 0xfc4b4831, 0xa122146b, -1 }, /* #37 */
    { 0x310e17, 0x310e17, 0x3bcc7d40, 0x3bcc7d40, 0xfdc97c91, 0xfdc97c91, 0x3f0b904a, -1 }, /* #38 */
    { 0x304447, 0x304447, 0xe194ad16, 0xe1ae4d64, 0xd86daa06, 0x843c7b46, 0xf5812594, 0 }, /* #39 */
    { 0x2613c6, 0x2613c6, 0xb4a8c685, 0x9aee3353, 0x4a6c4a42, 0x367c0c11, 0x7af9213c, 0 }, /* #40 */
    { 0x043842, 0x043842, 0x29c2fd60, 0x3d0ee58a, 0x2930be2c, 0x2150b732, 0xacb32c2b, 0 }, /* #41 */
    { 0x005bd7, 0x005bd7, 0x106d7449, 0x106d7449, 0xbe721b4b, 0xbe721b4b, 0x96082c66, -1 }, /* #42 */
    { 0x3c3703, 0x3c3703, 0x82b249f0, 0x4c0377ec, 0x11ea23d8, 0x017dcb58, 0x3c554c12, 0 }, /* #43 */
    { 0x273152, 0x273152, 0xadbbae89, 0xadbbae89, 0x67cdafc8, 0x67cdafc8, 0x5920f135, -1 }, /* #44 */
    { 0x360407, 0x360407, 0xd37aa337, 0xd37aa337, 0x9649843e, 0x9649843e, 0x09645197, -1 }, /* #45 */
    { 0x146346, 0x146346, 0x74352055, 0xc566fbe3, 0x7b4d08ee, 0x9bc16ac2, 0x9fe6ee91, 0 }, /* #46 */
    { 0x1a3e43, 0x1a3e43, 0x288affc9, 0x288affc9, 0xb60be963, 0xb60be963, 0x06e2920d, -1 }, /* #47 */
    { 0x034a57, 0x034a57, 0xba2af38a, 0x69e0027e, 0x40394e42, 0x15f27e14, 0x9b4a2b85, 0 }, /* #48 */
    { 0x2b06c6, 0x2b06c6, 0xcd82946a, 0xcd82946a, 0x9377d783, 0x9377d783, 0x88f38c3c, -1 }, /* #49 */
    { 0x0b57d6, 0x0b57d6, 0xf4906b09, 0xf4906b09, 0xa40e35bb, 0xa40e35bb, 0x6ae99b64, -1 }, /* #50 */
    { 0x2c1813, 0x2c1813, 0x49afeb92, 0xa21c0c8e, 0x74c1f4eb, 0x7a252ce4, 0xb8619671, 0 }, /* #51 */
    { 0x047dc7, 0x047dc7, 0x96071694, 0x96071694, 0xd0c7e6cf, 0xd0c7e6cf, 0xb61a6fa9, -1 }, /* #52 */
    { 0x2000d2, 0x2000d2, 0x05ddf9c5, 0x05ddf9c5, 0x90150d5b, 0x90150d5b, 0x759b38dd, -1 }, /* #53 */
    { 0x2b6397, 0x2b6397, 0x1fb29621, 0x1fb29621, 0xb261f609, 0xb261f609, 0x93ce2d39, -1 }, /* #54 */
    { 0x133696, 0x133696, 0x05912f95, 0xa173992e, 0x83b3ddce, 0xbc0e3f99, 0xd0d461b2, 0 }, /* #55 */
    { 0x1e0e96, 0x1e0e96, 0xbfd6a62b, 0x92528ae2, 0x7813cdaf, 0x0f8af4bb, 0xd2152838, 0 }, /* #56 */
    { 0x3b13d3, 0x3b13d3, 0xeab80a1a, 0x5569ddaf, 0x219b08f2, 0x5ee7fc9d, 0x64b8de93, 0 }, /* #57 */
    { 0x264247, 0x264247, 0x88423f44, 0x88423f44, 0xb69121be, 0xb69121be, 0x182e446b, -1 }, /* #58 */
    { 0x0e0ad7, 0x0e0ad7, 0x7a247b03, 0xfb979e8d, 0xbdbd6748, 0x8f235846, 0xc11060f1, 0 }, /* #59 */
    { 0x3d6c83, 0x3d6c83, 0x82e45bde, 0x6f3118cb, 0x14c99437, 0x19024083, 0x2fdc05b1, 0 }, /* #60 */
    { 0x3b3f52, 0x3b3f52, 0xd91ad28e, 0xc5721aa6, 0xa65c8cce, 0x8d209d5e, 0xd7b29008, 0 }, /* #61 */
    { 0x200183, 0x200183, 0xda1f3537, 0xafe2a71a, 0xa1c8d160, 0x1d0006d9, 0xeb79e8ab, 0 }, /* #62 */
    { 0x0871d7, 0x0871d7, 0xa18ceffe, 0xa18ceffe, 0xd6c5b443, 0xd6c5b443, 0x87a51d53, -1 }, /* #63 */
    { 0x192c82, 0x192c82, 0x4a981ae6, 0x802664c0, 0x2a3c7156, 0x397284a6, 0x545f93e3, 0 }, /* #64 */
    { 0x352917, 0x352917, 0xbfbacef7, 0x4a5a51ba, 0x3ec0adaa, 0xc489c261, 0xd80f6547, 0 }, /* #65 */
    { 0x2307c6, 0x2307c6, 0x7cd656d0, 0x7cd656d0, 0x73b16e59, 0x73b16e59, 0x5a605a81, -1 }, /* #66 */
    { 0x1f0f43, 0x1f0f43, 0x1715b7cc, 0x1715b7cc, 0xb31f1362, 0xb31f1362, 0x61286c20, -1 }, /* #67 */
    { 0x1d0f03, 0x1d0f03, 0x8fe1b8ea, 0x6925284e, 0x1735b047, 0x26ee0012, 0x388267b4, 0 }, /* #68 */
    { 0x012157, 0x012157, 0xc9fbb8d2, 0x04479cf4, 0x025a4993, 0x7f598d06, 0x8cbaddef, 0 }, /* #69 */
    { 0x1b2bc6, 0x1b2bc6, 0x8c7ee831, 0x8982b2dc, 0x5317a262, 0x07aa6541, 0x9ab0e124, 0 }, /* #70 */
    { 0x0e5f86, 0x0e5f86, 0xb5eeee83, 0xcfe6e2c5, 0xca9943c2, 0x59d2286e, 0xf9784b11, 0 }, /* #71 */
    { 0x2b1e12, 0x2b1e12, 0xc1a6f985, 0xc1a6f985, 0x629d6332, 0x629d6332, 0x095b8623, -1 }, /* #72 */
    { 0x3f6796, 0x3f6796, 0x6a573a58, 0x516642e3, 0x3e9a97b2, 0x76e5882c, 0xc4e360e4, 0 }, /* #73 */
    { 0x1b53d2, 0x1b53d2, 0xa688b8a3, 0x9d82ccc1, 0x8dce29cf, 0x869cbe74, 0xe67952ef, 0 }, /* #74 */
    { 0x2e3183, 0x2e3183, 0x720a1182, 0x720a1182, 0x6a8ae749, 0x6a8ae749, 0x67ed3a02, -1 }, /* #75 */
    { 0x3318c7, 0x3318c7, 0x8d9e434b, 0x8d9e434b, 0x50086f74, 0x50086f74, 0x17b742bb, -1 }, /* #76 */
    { 0x0a48c3, 0x0a48c3, 0x6af10eea, 0x6af10eea, 0x38c1cdb2, 0x38c1cdb2, 0x2c4d22e4, -1 }, /* #77 */
    { 0x391d47, 0x391d47, 0x6fcb1fa3, 0x6fcb1fa3, 0xb28da781, 0xb28da781, 0x005608e2, -1 }, /* #78 */
    { 0x2960d2, 0x2960d2, 0x5d7f80a7, 0x6e593e45, 0x0d5860bd, 0x0d80cd4b, 0x1ef5b9ac, 0 }, /* #79 */
    { 0x3c3246, 0x3c3246, 0x5a0162e8, 0x5a0162e8, 0xea3f907f, 0xea3f907f, 0x8a161850, -1 }, /* #80 */
    { 0x3255c2, 0x3255c2, 0xf11ff474, 0xf11ff474, 0x921b18f9, 0x921b18f9, 0x1b626e3a, -1 }, /* #81 */
    { 0x346393, 0x346393, 0x4d61f7eb, 0x4d61f7eb, 0xac60ee44, 0xac60ee44, 0x85c6fde6, -1 }, /* #82 */
    { 0x281016, 0x281016, 0x0b8d8067, 0x987cd807, 0x21f8b9cb, 0x2d44fd48, 0x39084629, 0 }, /* #83 */
    { 0x3f2fc7, 0x3f2fc7, 0x700d7bbe, 0x700d7bbe, 0xae67a498, 0xae67a498, 0x8216d83e, -1 }, /* #84 */
    { 0x2a0bd2, 0x2a0bd2, 0xc358f983, 0xfbcb8a8b, 0xe726deed, 0x538068f3, 0xeb0313b0, 0 }, /* #85 */
    { 0x096702, 0x096702, 0xb71ade53, 0x28201b9a, 0x25870622, 0x2a8f6345, 0xef6cc4a3, 0 }, /* #86 */
    { 0x2779c6, 0x2779c6, 0xe2882650, 0xfd466aad, 0x74a45f19, 0x0e7eec1f, 0x75e5a215, 0 }, /* #87 */
    { 0x073017, 0x073017, 0xac385c5e, 0xac385c5e, 0xf2597e18, 0xf2597e18, 0x575c3b0b, -1 }, /* #88 */
    { 0x2a5803, 0x2a5803, 0xdd8e52ec, 0xdd8e52ec, 0xe3a80004, 0xe3a80004, 0x3efda9b6, -1 }, /* #89 */
    { 0x325f46, 0x325f46, 0xa78f7760, 0x6bc79d1e, 0x4f4ffa46, 0xb386f646, 0xbc624d23, 0 }, /* #90 */
    { 0x3d3212, 0x3d3212, 0x0bcf86d2, 0x0bcf86d2, 0x64cfca22, 0x64cfca22, 0x4f4912e8, -1 }, /* #91 */
    { 0x2a0b17, 0x2a0b17, 0xf74c601c, 0xf74c601c, 0xafdf0259, 0xafdf0259, 0x856abe0d, -1 }, /* #92 */
    { 0x3a3f02, 0x3a3f02, 0xc10637ec, 0xc60dd31b, 0x5135bfdb, 0x272d1032, 0x68f858ce, 0 }, /* #93 */
    { 0x0640c7, 0x0640c7, 0x434d6464, 0x434d6464, 0x641d472c, 0x641d472c, 0x1de9cdb4, -1 }, /* #94 */
    { 0x0c66c2, 0x0c66c2, 0x1676437f, 0x5ca8df9a, 0x15c9909c, 0x367614e7, 0x3c31b07c, 0 }, /* #95 */
};
uint32_t const g_cTests_div_u32_intel = RT_ELEMENTS(g_aTests_div_u32_intel);

MULDIVU32_TEST_T const g_aTests_idiv_u32_intel[] =
{
    { 0x061353, 0x061353, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #0 */
    { 0x222fd2, 0x222fd2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #1 */
    { 0x166f03, 0x166f03, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #2 */
    { 0x2d0e93, 0x2d0e93, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #3 */
    { 0x3c0397, 0x3c0397, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #4 */
    { 0x3c0087, 0x3c0087, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #5 */
    { 0x2d19d3, 0x2d19d3, 0x9db3c14a, 0x9db3c14a, 0x8a8d1eaf, 0x8a8d1eaf, 0x00000000, -1 }, /* #6 */
    { 0x167b87, 0x167b87, 0x99a07f76, 0x99a07f76, 0xd0eae99c, 0xd0eae99c, 0x00000000, -1 }, /* #7 */
    { 0x3a3c53, 0x3a3c53, 0x2e3147c9, 0x2e3147c9, 0x533841aa, 0x533841aa, 0x00000000, -1 }, /* #8 */
    { 0x272196, 0x272196, 0xbc8615b8, 0xbc8615b8, 0xe23dd9a3, 0xe23dd9a3, 0x00000000, -1 }, /* #9 */
    { 0x2d76d7, 0x2d76d7, 0xf6f53c49, 0xf6f53c49, 0x0684daa2, 0x0684daa2, 0x00000000, -1 }, /* #10 */
    { 0x2a3e46, 0x2a3e46, 0xf1b9fe0e, 0xf1b9fe0e, 0xdff52898, 0xdff52898, 0x00000000, -1 }, /* #11 */
    { 0x367d47, 0x367d47, 0xf0fcfc93, 0xf0fcfc93, 0xa0f590d9, 0xa0f590d9, 0xfb3cebf6, -1 }, /* #12 */
    { 0x2a06c3, 0x2a06c3, 0x05be0faa, 0x05be0faa, 0x466e8b82, 0x466e8b82, 0xcbefc09c, -1 }, /* #13 */
    { 0x1e1903, 0x1e1903, 0x913a4124, 0x913a4124, 0xa6c66ad4, 0xa6c66ad4, 0x8f6cdfba, -1 }, /* #14 */
    { 0x123c12, 0x123c12, 0xd9717a5a, 0x815d76fc, 0xeb451a06, 0xe451ac82, 0x29e8360a, 0 }, /* #15 */
    { 0x0d69d6, 0x0d69d6, 0x059cb6b6, 0x059cb6b6, 0xe3adaab3, 0xe3adaab3, 0x159962f3, -1 }, /* #16 */
    { 0x275516, 0x275516, 0x9178c08e, 0x9178c08e, 0xacb58ce9, 0xacb58ce9, 0x3c38e5da, -1 }, /* #17 */
    { 0x1631c7, 0x1631c7, 0xde599182, 0xde599182, 0x4e7ef9e5, 0x4e7ef9e5, 0x5cbb001b, -1 }, /* #18 */
    { 0x1d2816, 0x1d2816, 0xfc1c9dd7, 0x81cecfda, 0xef8af861, 0xefc8f035, 0x2162c5f5, 0 }, /* #19 */
    { 0x0f2257, 0x0f2257, 0xe673d11b, 0xe673d11b, 0x453986f3, 0x453986f3, 0xe4f0046b, -1 }, /* #20 */
    { 0x1400d3, 0x1400d3, 0x32e29836, 0x32e29836, 0x8cd178e4, 0x8cd178e4, 0x407bb851, -1 }, /* #21 */
    { 0x2f6006, 0x2f6006, 0xe966f2f7, 0xe966f2f7, 0x462e7a8b, 0x462e7a8b, 0x776ce30d, -1 }, /* #22 */
    { 0x1054c3, 0x1054c3, 0xba8ea503, 0xba8ea503, 0x433fbc29, 0x433fbc29, 0x98f0b6e3, -1 }, /* #23 */
    { 0x0a3e47, 0x0a3e47, 0x34cd00f3, 0x34cd00f3, 0xb76f428c, 0xb76f428c, 0xc89948a2, -1 }, /* #24 */
    { 0x362dd3, 0x362dd3, 0xc13894a5, 0x7bb9b283, 0xc22d22f8, 0x9a750fe0, 0x8014a917, 0 }, /* #25 */
    { 0x251486, 0x251486, 0xd64cb310, 0xd64cb310, 0xc9002a4a, 0xc9002a4a, 0xf832ad7a, -1 }, /* #26 */
    { 0x1f6b43, 0x1f6b43, 0x738fddba, 0x738fddba, 0x9a6f405c, 0x9a6f405c, 0xf1d74c29, -1 }, /* #27 */
    { 0x067a57, 0x067a57, 0xb05e9e2b, 0xb05e9e2b, 0x48d41f37, 0x48d41f37, 0xf7c92560, -1 }, /* #28 */
    { 0x360d12, 0x360d12, 0x422641d4, 0x422641d4, 0x62a28769, 0x62a28769, 0xfa17fbae, -1 }, /* #29 */
    { 0x162507, 0x162507, 0x4c79a2ec, 0x4c79a2ec, 0xdcdca9c5, 0xdcdca9c5, 0xc4439019, -1 }, /* #30 */
    { 0x361352, 0x361352, 0x0e6e40e8, 0x0e6e40e8, 0x8bf0b08b, 0x8bf0b08b, 0x985e52c0, -1 }, /* #31 */
    { 0x342952, 0x342952, 0xd7d5dde4, 0x635f7ad2, 0x18448559, 0x16e99840, 0x3e846802, 0 }, /* #32 */
    { 0x151102, 0x151102, 0x9916e598, 0x5996a4d4, 0xdf68a429, 0xc0138d88, 0xa2dec274, 0 }, /* #33 */
    { 0x206806, 0x206806, 0x869c2f23, 0x869c2f23, 0x9457189d, 0x9457189d, 0x57944704, -1 }, /* #34 */
    { 0x0561d2, 0x0561d2, 0x3b1ebad5, 0x3b1ebad5, 0x441434f2, 0x441434f2, 0x3ea02b1d, -1 }, /* #35 */
    { 0x0811d2, 0x0811d2, 0x410e1a3a, 0x39b6b04e, 0xe8b34a5b, 0xe5fbf530, 0x98a65f73, 0 }, /* #36 */
    { 0x087e97, 0x087e97, 0x8b27eb34, 0x880867d2, 0x24a24c1d, 0x48d4949c, 0xb1d37d6c, 0 }, /* #37 */
    { 0x337703, 0x337703, 0xab73da9f, 0xab73da9f, 0x7d7af0bb, 0x7d7af0bb, 0x29c07838, -1 }, /* #38 */
    { 0x3d7602, 0x3d7602, 0x3a5d95ad, 0x3a5d95ad, 0xa9c4b03b, 0xa9c4b03b, 0x2bd35ca1, -1 }, /* #39 */
    { 0x3d3f82, 0x3d3f82, 0x42f0053e, 0x42f0053e, 0xaa98b0ff, 0xaa98b0ff, 0xa0024f05, -1 }, /* #40 */
    { 0x0474c3, 0x0474c3, 0x2bd729d2, 0x107e9f3a, 0x0358c307, 0x21bc0afc, 0x33f120a7, 0 }, /* #41 */
    { 0x303506, 0x303506, 0x6152ec10, 0x6152ec10, 0x437f6a87, 0x437f6a87, 0xeedcf17d, -1 }, /* #42 */
    { 0x256397, 0x256397, 0xe0376e73, 0xe0376e73, 0xc6822a95, 0xc6822a95, 0xa4862834, -1 }, /* #43 */
    { 0x044006, 0x044006, 0x69418f86, 0x69418f86, 0x45644680, 0x45644680, 0xa86c0f8a, -1 }, /* #44 */
    { 0x063907, 0x063907, 0xd3818133, 0xd3818133, 0xd4cf0e9a, 0xd4cf0e9a, 0xed454006, -1 }, /* #45 */
    { 0x323dd3, 0x323dd3, 0xc5467bb7, 0xdefba3de, 0x0e5a83ba, 0x13bf49ff, 0x90b560e4, 0 }, /* #46 */
    { 0x1f60c2, 0x1f60c2, 0x06414dd3, 0x06414dd3, 0x4451617f, 0x4451617f, 0xcd9369c0, -1 }, /* #47 */
    { 0x194957, 0x194957, 0x871d0368, 0x0d09805a, 0xfa9ef242, 0xcdc2e70c, 0x965fd5a6, 0 }, /* #48 */
    { 0x074616, 0x074616, 0x76d32687, 0xfeddcf6e, 0xffa87971, 0xce84643d, 0x4d36a603, 0 }, /* #49 */
    { 0x390c97, 0x390c97, 0x19750ddd, 0x19750ddd, 0x4acb8927, 0x4acb8927, 0xf66af1d5, -1 }, /* #50 */
    { 0x1c71c2, 0x1c71c2, 0xcc29af79, 0xcc29af79, 0xf55423e5, 0xf55423e5, 0xfd32c587, -1 }, /* #51 */
    { 0x286657, 0x286657, 0xbf30df5e, 0xbf30df5e, 0x7de6f35b, 0x7de6f35b, 0x04c8b025, -1 }, /* #52 */
    { 0x083453, 0x083453, 0x09439b52, 0x09439b52, 0x579c4852, 0x579c4852, 0xcbd7e532, -1 }, /* #53 */
    { 0x2e5492, 0x2e5492, 0xce6fe6b2, 0xce6fe6b2, 0x50f7128f, 0x50f7128f, 0xecfdceab, -1 }, /* #54 */
    { 0x365fd2, 0x365fd2, 0x0789d4fc, 0x96923600, 0x34b250da, 0x57cbb4fc, 0x800b1e30, 0 }, /* #55 */
    { 0x254212, 0x254212, 0x2e75dfcf, 0x541c7e4a, 0xf060d407, 0xddba6d35, 0xd0742d09, 0 }, /* #56 */
    { 0x087b96, 0x087b96, 0x2987f3d7, 0x2987f3d7, 0xc151434e, 0xc151434e, 0x501063ec, -1 }, /* #57 */
    { 0x1a5253, 0x1a5253, 0xc8c32c87, 0xc8c32c87, 0x84747b74, 0x84747b74, 0x854817e8, -1 }, /* #58 */
    { 0x0b6397, 0x0b6397, 0xa4e89a1c, 0xa4e89a1c, 0x226ca377, 0x226ca377, 0xde613f0d, -1 }, /* #59 */
    { 0x1b7d97, 0x1b7d97, 0x0f0adb86, 0x0f0adb86, 0x296c78c3, 0x296c78c3, 0x49f03ae9, -1 }, /* #60 */
    { 0x256797, 0x256797, 0xd766d78f, 0x93fe7cab, 0xe220a9ba, 0xe710a669, 0x46ce0772, 0 }, /* #61 */
    { 0x174313, 0x174313, 0x06f6f48e, 0x06f6f48e, 0xab8c2c87, 0xab8c2c87, 0x839b00c9, -1 }, /* #62 */
    { 0x1c52d2, 0x1c52d2, 0xacae5b75, 0x9612df10, 0xe113a62a, 0xc6be4e35, 0x4abc0a14, 0 }, /* #63 */
    { 0x145307, 0x145307, 0xfed083be, 0xfed083be, 0x61cd7977, 0x61cd7977, 0x21e3d7d0, -1 }, /* #64 */
    { 0x205a56, 0x205a56, 0x287183ac, 0x287183ac, 0x6296dce4, 0x6296dce4, 0xaf4c3c7a, -1 }, /* #65 */
    { 0x2f7417, 0x2f7417, 0x8fb153ed, 0x8fb153ed, 0x3fab418a, 0x3fab418a, 0xeb51c618, -1 }, /* #66 */
    { 0x380e43, 0x380e43, 0x78fd9bc5, 0x78fd9bc5, 0x4ffea298, 0x4ffea298, 0xd33f9abc, -1 }, /* #67 */
    { 0x195506, 0x195506, 0x4f05ec74, 0x148953e7, 0xf6d92953, 0xb0c1724b, 0x8deaff6f, 0 }, /* #68 */
    { 0x064657, 0x064657, 0x7b5f983c, 0x7b5f983c, 0x7dd2bf01, 0x7dd2bf01, 0xb79ecf24, -1 }, /* #69 */
    { 0x094ac6, 0x094ac6, 0x925e260c, 0x925e260c, 0x5f871443, 0x5f871443, 0x57afa63d, -1 }, /* #70 */
    { 0x3b4b03, 0x3b4b03, 0xcbb68a0e, 0xcbb68a0e, 0x91325888, 0x91325888, 0x77f29946, -1 }, /* #71 */
    { 0x2f3542, 0x2f3542, 0xcd445259, 0xcd445259, 0x789b5560, 0x789b5560, 0xf706e6d6, -1 }, /* #72 */
    { 0x040c07, 0x040c07, 0xa20efcc4, 0xa20efcc4, 0x9e425700, 0x9e425700, 0x8948e89f, -1 }, /* #73 */
    { 0x0556d3, 0x0556d3, 0xd48dc3b9, 0xbe441063, 0xe267180f, 0xd3a28a23, 0x734414f2, 0 }, /* #74 */
    { 0x3165d3, 0x3165d3, 0xd0837d80, 0xd0837d80, 0xd5be9634, 0xd5be9634, 0x2bdcbdc2, -1 }, /* #75 */
    { 0x076607, 0x076607, 0x2b2a45e6, 0x2b2a45e6, 0xc3bdbb39, 0xc3bdbb39, 0x895c466f, -1 }, /* #76 */
    { 0x020a56, 0x020a56, 0xf068ddb0, 0xf068ddb0, 0xbb8d3654, 0xbb8d3654, 0xc63410ec, -1 }, /* #77 */
    { 0x230c93, 0x230c93, 0xa95164f3, 0xa95164f3, 0x4cade50a, 0x4cade50a, 0xbe4fb0c3, -1 }, /* #78 */
    { 0x265d97, 0x265d97, 0x5bbc7bc9, 0x5bbc7bc9, 0x4874c853, 0x4874c853, 0x4e517a3f, -1 }, /* #79 */
    { 0x075a43, 0x075a43, 0x11009a17, 0x11009a17, 0x37a2a3ed, 0x37a2a3ed, 0x5ddc1ef8, -1 }, /* #80 */
    { 0x0e6902, 0x0e6902, 0x1c4387c1, 0x1c4387c1, 0x20fd0ccb, 0x20fd0ccb, 0xeaee08ab, -1 }, /* #81 */
    { 0x0c1e17, 0x0c1e17, 0xf781e90d, 0xf781e90d, 0xc307b6e1, 0xc307b6e1, 0xc24fd1ac, -1 }, /* #82 */
    { 0x053742, 0x053742, 0x6deb9335, 0x6deb9335, 0x6a5bdc23, 0x6a5bdc23, 0xadc586ab, -1 }, /* #83 */
    { 0x2f3006, 0x2f3006, 0x3a19ecdc, 0x35eda60f, 0xe78f152e, 0xf503d581, 0x8bfa25f5, 0 }, /* #84 */
    { 0x207402, 0x207402, 0xb1f70e84, 0xb1f70e84, 0xb266c4bd, 0xb266c4bd, 0xc64367ce, -1 }, /* #85 */
    { 0x2a1bc6, 0x2a1bc6, 0x65ab9948, 0x65ab9948, 0x9bea030f, 0x9bea030f, 0x13a29153, -1 }, /* #86 */
    { 0x364b03, 0x364b03, 0x61d50f2b, 0x48b94bfe, 0x1c476b2a, 0x1c98fd2b, 0x638bf700, 0 }, /* #87 */
    { 0x2b4006, 0x2b4006, 0x4e98e0f8, 0x4e98e0f8, 0x6cfabe65, 0x6cfabe65, 0x21a7116d, -1 }, /* #88 */
    { 0x333986, 0x333986, 0x73167fbe, 0x73167fbe, 0x597839ac, 0x597839ac, 0xb4e01f10, -1 }, /* #89 */
    { 0x304e03, 0x304e03, 0xc07dfd39, 0x07cfd2b6, 0x02e8122a, 0x215b5ce7, 0x5f3fdfcb, 0 }, /* #90 */
    { 0x377813, 0x377813, 0x674a2a63, 0x674a2a63, 0xc2618901, 0xc2618901, 0x93afc8fe, -1 }, /* #91 */
    { 0x1445d7, 0x1445d7, 0xc0622f23, 0xc0622f23, 0x84aa9cdc, 0x84aa9cdc, 0x7a299b84, -1 }, /* #92 */
    { 0x320c52, 0x320c52, 0xa29bfb3e, 0xa29bfb3e, 0xda7195af, 0xda7195af, 0x2f7c0916, -1 }, /* #93 */
    { 0x207697, 0x207697, 0x9dfbec37, 0x9dfbec37, 0xe28f039d, 0xe28f039d, 0x181148cd, -1 }, /* #94 */
    { 0x3d1c17, 0x3d1c17, 0x0853c815, 0x0853c815, 0xad078b1c, 0xad078b1c, 0xde3d02a1, -1 }, /* #95 */
};
uint32_t const g_cTests_idiv_u32_intel = RT_ELEMENTS(g_aTests_idiv_u32_intel);

MULDIVU64_TEST_T const g_aTests_mul_u64_intel[] =
{
    { 0x130042, 0x130006, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #0 */
    { 0x0a32d2, 0x0a3206, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #1 */
    { 0x1c4786, 0x1c4706, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #2 */
    { 0x1b0ac3, 0x1b0206, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #3 */
    { 0x2e7e82, 0x2e7606, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #4 */
    { 0x372087, 0x372006, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #5 */
    { 0x175d02, 0x175506, 0x00c8d0789efcba52, 0x0000000000000000, 0xe2903065bbe9ee5c, 0x0000000000000000, 0x0000000000000000, 0 }, /* #6 */
    { 0x297d83, 0x297506, 0xdf3459c24fa1f1c6, 0x0000000000000000, 0x046990dc905f3e88, 0x0000000000000000, 0x0000000000000000, 0 }, /* #7 */
    { 0x1509d2, 0x150106, 0x1d72f2ef098871fc, 0x0000000000000000, 0x09e19711cca6c7ca, 0x0000000000000000, 0x0000000000000000, 0 }, /* #8 */
    { 0x2944d2, 0x294406, 0x48e3f3412f60aa22, 0x0000000000000000, 0x78b1c2def56fe8d9, 0x0000000000000000, 0x0000000000000000, 0 }, /* #9 */
    { 0x2f0207, 0x2f0206, 0x2cfefe4e554a9075, 0x0000000000000000, 0xb28d205ff60b9707, 0x0000000000000000, 0x0000000000000000, 0 }, /* #10 */
    { 0x1528c2, 0x152006, 0x06610f4d6eac198f, 0x0000000000000000, 0xb7ee7cf42c9105d9, 0x0000000000000000, 0x0000000000000000, 0 }, /* #11 */
    { 0x1f6953, 0x1f6983, 0xb0d23faa104d88bd, 0xacdf22e80e6a6719, 0x71591c5036ce47b4, 0x09f1d395ce638f9e, 0x0e65d226f8f9638d, 0 }, /* #12 */
    { 0x2369c6, 0x236983, 0x5e5d1bf4b14ccb43, 0xc92070288cc02fad, 0x88a69d0a9cc848cb, 0x40720b8949259e92, 0xaed5ab171b26524f, 0 }, /* #13 */
    { 0x224e82, 0x224e07, 0xe55a281d03e8e2da, 0x361fb75cc3a9e7fa, 0x48a108521314d170, 0xd10fc0a96c7c195d, 0xe95a125e667782d1, 0 }, /* #14 */
    { 0x2e6707, 0x2e6f83, 0xa737ca7160fcb509, 0xf40869b074bd268f, 0x0bec7a627d962388, 0x799b1bf893ed97a0, 0xba2bbe9ee53b3cd7, 0 }, /* #15 */
    { 0x187803, 0x187807, 0x9fbe7b499e6801c6, 0x421d48ba34287f72, 0x4229373c065fd098, 0x8ccf72757bd42aa2, 0xe1a851e2ed60abb3, 0 }, /* #16 */
    { 0x003492, 0x003c03, 0x1281b4be072040c0, 0x6372c9e1ee2cbd40, 0x394cf4591025e9a8, 0x120bba4bcc17c806, 0xf9a005f1a2a62ea7, 0 }, /* #17 */
    { 0x1e3c56, 0x1e3c83, 0xf284b85ffbaf15b3, 0x819c102e1c7abaf4, 0x6a7456b30e5f262d, 0x4898eeec8f52d4a1, 0x4ca21119f15f473c, 0 }, /* #18 */
    { 0x0d7347, 0x0d7b07, 0x2d44b7e5c63b225a, 0x55530424e9b2f11e, 0xa1180d9657a61689, 0x15a1bb4422a7ddf3, 0x7a54bb11817c2e2b, 0 }, /* #19 */
    { 0x211b46, 0x211b87, 0x5bdc6163aac128f3, 0xdc03ffab30024cbb, 0x74bc029fdca9cd7a, 0x1c1642e960d46990, 0x4e45fd26ea08bf19, 0 }, /* #20 */
    { 0x004103, 0x004983, 0x261c8d26b0c692d2, 0xd2b8523ee1795758, 0xf67d711ca78a3d5f, 0x229a884be9eab40a, 0xe86fe45f83db4ccc, 0 }, /* #21 */
    { 0x1345c2, 0x134d03, 0x62c2a9bb0466c037, 0x55c1779e16800897, 0xfb1991043c239112, 0x1132a56aba58eaa6, 0x2c943d723f190aa1, 0 }, /* #22 */
    { 0x116cd6, 0x116c83, 0x05909f104f7410cd, 0xd9aa9319604a146b, 0x85d9482d63bc2a03, 0x02dbf141b2d93b3f, 0x83871b6608c6da17, 0 }, /* #23 */
    { 0x1b3683, 0x1b3e07, 0x9e0bde92e01cc424, 0x477dc8d1e8ec5d24, 0x9c56e78ec2f4737d, 0x42b1cc03dce254ca, 0x6c07c2096ce78441, 0 }, /* #24 */
    { 0x0c3c42, 0x0c3c83, 0x3aaab7e3f4a8d6be, 0xe7e3aa018fcf96f8, 0x3a47ef6de68af5e4, 0x323f28ba225e1dc0, 0xdb41f4a8f3dca204, 0 }, /* #25 */
    { 0x0b6e96, 0x0b6e87, 0xfaea8bbe02f6781c, 0xd87fbf6fdbd90844, 0xb7587fc312182308, 0x858a65b7e2476c76, 0x883f0bff8c179927, 0 }, /* #26 */
    { 0x071856, 0x071807, 0x1b75b9d78eb3722f, 0x590a5523ec4a6905, 0x3090c9b52699e8ba, 0x12cacac646200eb6, 0xaf318db5dd284f0b, 0 }, /* #27 */
    { 0x2470d6, 0x247883, 0x5f3e7cd17c040e7f, 0xca91384ca1b3015d, 0x1339284369fc4c46, 0x4128fb44bfea22bb, 0xaf23a7b8b483fa23, 0 }, /* #28 */
    { 0x293d53, 0x293d83, 0x596fe1e72a45ffc2, 0xe5e01184ed796cb6, 0x9485410628e84dac, 0x0117652fc51db353, 0x031fba06ea596dbb, 0 }, /* #29 */
    { 0x023d56, 0x023d03, 0xc0f2d8658d1d56b0, 0x10612234d9d90a20, 0xee33661bce196c36, 0xa206e8cb8e21ff23, 0xd6f94f3411a19866, 0 }, /* #30 */
    { 0x3c66d6, 0x3c6e87, 0xbc4b3d7c2a7c345f, 0x8964574a5737d46f, 0x8a1d49c9a8d86012, 0x50a2f0788eae2987, 0x6da1a88ce9dad9f1, 0 }, /* #31 */
    { 0x327b56, 0x327b07, 0xb0ffea34c1ced61d, 0x313b1add26777447, 0x7548f202142bfd75, 0x98a0c76289fb0041, 0xdcc025dca67256b3, 0 }, /* #32 */
    { 0x227306, 0x227b87, 0xb0151aed81234170, 0xc03123edb22f5c60, 0xc12430f9a0831312, 0x184b48634350a081, 0x2351fe77b2cd262a, 0 }, /* #33 */
    { 0x363a97, 0x363a03, 0x7020b13088652577, 0x21137db7dd333ecd, 0x673382c9b494dc8f, 0x03402f37e07bb824, 0x076bf831d109dedb, 0 }, /* #34 */
    { 0x1d5fd2, 0x1d5f07, 0x6844eeffc0200e82, 0x6adcb0b5cb03e4e2, 0xd210585e0ff23da9, 0x210ab02980df8ba8, 0x511f9d9b92d3cf31, 0 }, /* #35 */
    { 0x325387, 0x325b83, 0x18729589072699b2, 0x8c49245e25b6446e, 0xba27190b68da823d, 0x0480846ddba93f33, 0x2f2471bd782fbd8f, 0 }, /* #36 */
    { 0x1f0946, 0x1f0903, 0x221127cd4f73134d, 0x28ef67a32d09d9b6, 0x6fd26d1ef7e5e852, 0x155393f56ac77c66, 0xa0428c38050d398e, 0 }, /* #37 */
    { 0x324f92, 0x324f87, 0x3a2671f744631e15, 0xddf706179e3dca93, 0x6a77ae1a27c3321b, 0x036856fb1d0ff51a, 0x0f006230055e1807, 0 }, /* #38 */
    { 0x2661d7, 0x266907, 0x9d1d2625abb338ec, 0x35c856df7df10060, 0xad7f3c0faeede406, 0x3f588f345e453fb4, 0x67371fed0dd546c8, 0 }, /* #39 */
    { 0x020dd3, 0x020d87, 0x5f2897054b06a948, 0x909030e53227bf50, 0xf5c9a596be455f7f, 0x5c253c1f22c6f910, 0xf7e4dd4ca2173bda, 0 }, /* #40 */
    { 0x233502, 0x233d03, 0x7f9ef93a103c1116, 0x32a85d8b2b48ddfe, 0x23d74ebb99da8fb9, 0x04c8940e0bd8fd2c, 0x09986e2188d80ddd, 0 }, /* #41 */
    { 0x017b16, 0x017b03, 0x4595f35fe2ecd4e3, 0x6ba4f735eb8ac4ce, 0x21603d18d92c93c5, 0x44055feb066cbd9b, 0xfa3e50af0ed8ef5a, 0 }, /* #42 */
    { 0x391496, 0x391c07, 0x35991376dfbb51ac, 0x20104db8016033a0, 0x5b234fcdfbeedba8, 0x0d215a3c7e8fe455, 0x3eb6d579cee620b8, 0 }, /* #43 */
    { 0x321912, 0x321903, 0xe6d2f23aa7139393, 0x1680be10e28f28c2, 0x6856984d5d93fddf, 0x5bb127f8093ca093, 0x65b15ffe20ce3176, 0 }, /* #44 */
    { 0x1862c3, 0x186a83, 0xa92d485bf1e77a89, 0xc610beb7fc618bec, 0xb9063754803ab5f4, 0x1af19daeb8fff88a, 0x28c588fda3d0018c, 0 }, /* #45 */
    { 0x154307, 0x154b03, 0xdc9199ba2fd233f7, 0x13a4e4aae5a26d1f, 0x33c009598e589871, 0x2b97219a25fe0ae5, 0x3297b0104234f619, 0 }, /* #46 */
    { 0x2646d6, 0x264e83, 0x8f5f19815d5be292, 0xbad760b8df64738c, 0xc70fbfcf0cc09c22, 0x024b4c82aade86b6, 0x0418a9fad3b91196, 0 }, /* #47 */
    { 0x300397, 0x300b87, 0x253e05e73ebbf0b7, 0xa7f6548b866bfad8, 0x7dfc8df3439791d0, 0x1bf38ec4f4ed6ba7, 0xc022a5b117e5d3e8, 0 }, /* #48 */
    { 0x0b49c2, 0x0b4987, 0xadc89221f508c632, 0xb4e47d4eb1a5579c, 0x30b86bad050a60a4, 0x06a631f9fc3703cd, 0x09cb7fda9fa741fe, 0 }, /* #49 */
    { 0x0e5492, 0x0e5c87, 0x445f8d266575e39a, 0xf5eb6e4da16089fa, 0x5b9db88ebacfdaf5, 0x3eeac434586b81d1, 0xeb9238aed7862ff1, 0 }, /* #50 */
    { 0x1644d6, 0x164c03, 0x2d32dc4b45275a3b, 0x352836e8290b963d, 0x89557762addcab26, 0x27e48bd4a0b37bb1, 0xe1f2aaac78add1e7, 0 }, /* #51 */
    { 0x0a2717, 0x0a2f07, 0x872fecad9148fc39, 0x31b8aa4215b4583a, 0x1baeb0b901b078b4, 0x86d48c55cd333580, 0xff52f69d444a6e0a, 0 }, /* #52 */
    { 0x032e46, 0x032e03, 0x83b418f878cfb695, 0x42ff6080d99743fb, 0xee04f3153fbb3452, 0x5804888a25961ed1, 0xab15d5fb4a273c4f, 0 }, /* #53 */
    { 0x285107, 0x285983, 0x94cb1fe340a59bee, 0xa013cf12517c7b40, 0x13247cb785685ff4, 0x453dc8ad7a4e87ee, 0x7721504c239ac760, 0 }, /* #54 */
    { 0x3f7393, 0x3f7b03, 0x51c9560e3559ea52, 0x125c2df12b527e76, 0x399e8e24607e5a71, 0x0e4d408f7eb9fcea, 0x2cc417db59dd99c3, 0 }, /* #55 */
    { 0x2029d2, 0x202987, 0x574efe85fb9312c6, 0xb930de911e7451ca, 0x0662731e5ffeb9b3, 0x4b6124c210c6458d, 0xdd05b73a87473b17, 0 }, /* #56 */
    { 0x3b6dc7, 0x3b6d07, 0xfffecd617df37e7d, 0x47277f200ad2a9cc, 0x9aae8f1fd7b6dcd4, 0xe52feda7ae972ad3, 0xe531002a2975bebc, 0 }, /* #57 */
    { 0x1e67d6, 0x1e6f87, 0x3b26b9225aecdf73, 0xfc0100e0b917608b, 0x60bf35d48cf00c88, 0x09e95d14213e128e, 0x2ae56c7b8e520489, 0 }, /* #58 */
    { 0x0c0e02, 0x0c0e03, 0xb93018375b3bd01c, 0x4537f282187139c4, 0x59bb5646281752eb, 0x8a92ad6f693eaf23, 0xbf8f7bb9e5493bc7, 0 }, /* #59 */
    { 0x3860d3, 0x386887, 0x478670ff7261da00, 0x815fe4dccfa43200, 0xe223b4c2edae6ee8, 0x237a7a06fa5b909f, 0x7efba331999fbc5d, 0 }, /* #60 */
    { 0x161f92, 0x161f83, 0x5193004c23adf299, 0x82dd573d1eb50697, 0x771f443013131ce1, 0x4c6f20fa46a94ec7, 0xefde77f388fbb0af, 0 }, /* #61 */
    { 0x176713, 0x176f83, 0x63c8715984c105c1, 0x85547f32b6ac2329, 0x2bd28efd5394ec4f, 0x4b696d2f368a1da5, 0xc179617687788769, 0 }, /* #62 */
    { 0x010413, 0x010c07, 0x2cdc7013cc9ab30c, 0x086e72e8fd5bf73c, 0xc0f972111bd2f9a8, 0x24cafaae3240ab62, 0xd1f57359da720a05, 0 }, /* #63 */
    { 0x111653, 0x111e07, 0x9d291844790979ac, 0x3f3470db5ec1d790, 0xb92f50d1a55cd70e, 0x8d79dc8c5445f0da, 0xe6738e2dcbc092ac, 0 }, /* #64 */
    { 0x1d04c3, 0x1d0c03, 0x7bd6729704c49b63, 0x7bb5a05450cdcb1c, 0xd947826c1a44e4e9, 0x3b4d63c8fea52d47, 0x7a974de763e54934, 0 }, /* #65 */
    { 0x171cc2, 0x171c87, 0x09972cd1c6e0ec72, 0xcfef24feb13f784e, 0x533db950e13fd268, 0x014f772f18f613d3, 0x22fa95778e3ac55f, 0 }, /* #66 */
    { 0x245082, 0x245803, 0x0daf5e0a07f2f38c, 0x73f421289bf106c4, 0xcb136e1724b4f492, 0x0a54562c8c724b46, 0xc13a7a723d35ff5b, 0 }, /* #67 */
    { 0x0c0e83, 0x0c0e83, 0x8279402c0979f95f, 0xc788f37e4c170c20, 0x55c364c132fc8522, 0x2797dd6a6e77eb90, 0x4daf6679a9fcc7e0, 0 }, /* #68 */
    { 0x253d92, 0x253d83, 0xb2a12287c9b62f1b, 0x88ba30eac7d4cc38, 0x1662ffe31a3e578f, 0x53fba561b7587c68, 0x785be251073f5028, 0 }, /* #69 */
    { 0x2874c3, 0x287c07, 0xbd8ac4f36615f9a1, 0x1b65b3d3eb9a4b56, 0x908dca220262258a, 0x9bd1565a0bd29730, 0xd2737b84ada2a796, 0 }, /* #70 */
    { 0x0b2317, 0x0b2b83, 0xb93fc56c56217668, 0xba4aefc4d79cecb0, 0xe4a6a8d1530801b3, 0xb546001975a33237, 0xfa8184e5cf6a87ee, 0 }, /* #71 */
    { 0x1371d2, 0x137983, 0xf2b1fa5f30a2520a, 0x8e157fb59951a164, 0xdba3b94c6c14b69f, 0x862743ebe547ddb4, 0x8d81fe9143d4248a, 0 }, /* #72 */
    { 0x107906, 0x107983, 0x1d0dca4503d462bd, 0x9c15b0cfdf7531da, 0x97c515105280068d, 0x0466e797e0a84a18, 0x26c96774f04a13e2, 0 }, /* #73 */
    { 0x251682, 0x251e07, 0x003824461b9e9c64, 0x2a6b94c144cb2a48, 0xade1be0f686dcbc8, 0x0026e0b8c04f5134, 0xb147531247a4cb62, 0 }, /* #74 */
    { 0x3a2dc2, 0x3a2d83, 0xdfacee52f4189cbb, 0xa244063488aa2e61, 0x3f2a589b0c2b1b63, 0xc0ec32be99cfa63a, 0xdccd89dccd651d93, 0 }, /* #75 */
    { 0x2e45c3, 0x2e4d07, 0x7e9699c491a53e99, 0x0c7bd07b9f99088d, 0xaa775447ec494c6b, 0x51e1d8782c06b2d5, 0xa59739b275cfd615, 0 }, /* #76 */
    { 0x286853, 0x286883, 0xdc7e1420a7c588a3, 0xb3d050740d72a3ec, 0xa1b389693f19b90c, 0xaa6dd1d04749897a, 0xc5dfd8881decaf24, 0 }, /* #77 */
    { 0x3b3e56, 0x3b3e83, 0xedef24e0d60888e0, 0xe029a30fd9d76b20, 0xbc1609aeceaee376, 0xe089831ca2c61812, 0xf195f69bb1baf35f, 0 }, /* #78 */
    { 0x346457, 0x346c87, 0x92a660fd8dd783b8, 0xdc008b1ac3bd6560, 0x5a68ae2d88c15308, 0x4b40322160be2141, 0x835c9e576f156fb4, 0 }, /* #79 */
    { 0x2a3a56, 0x2a3a07, 0xe510665117ad0992, 0x6165c976f33a6f96, 0x109997dd952d053f, 0x5a8590b8d7a8c659, 0x652a93259a1b45f3, 0 }, /* #80 */
    { 0x324552, 0x324d87, 0x8cb50a5f90aa9c64, 0x92a7d21105877c5c, 0xad85c016201eebc8, 0x07e04bc2dfc2bf2d, 0x0e5469245e346daf, 0 }, /* #81 */
    { 0x3c3553, 0x3c3d03, 0x21fb8db1939279c4, 0x4e8a0581927f584c, 0xe4bade4ad89702c5, 0x0401e1ac09249875, 0x1e303b85364c86c3, 0 }, /* #82 */
    { 0x137696, 0x137e03, 0x3bfa18d8b6d5720a, 0x28de3092676c71a8, 0x1a75d845f065681c, 0x2f07d8d04c410c2f, 0xc8bdc351b4cf1dc4, 0 }, /* #83 */
    { 0x1f6657, 0x1f6e87, 0x253dcc4af9c9173d, 0xefe7e4d7231a9514, 0x8747d7ea8f5ab528, 0x030623ce7927ce15, 0x14c97df7bc519aa4, 0 }, /* #84 */
    { 0x290e93, 0x290e03, 0xb82536fd13cc0454, 0x3144f7b73101ce70, 0xe83e636508b12395, 0x9116e2570b38aed3, 0xc9b442ba6634342c, 0 }, /* #85 */
    { 0x114bd2, 0x114b07, 0x90c94fc390ceee2d, 0x64adbf19e592fb63, 0xcd3615030d59c035, 0x0f1256164d6e2429, 0x1aa6028f79b619cf, 0 }, /* #86 */
    { 0x294617, 0x294e03, 0x2e9008c65f276ab9, 0x5170e89bc26b8902, 0x801a4fc1098a6092, 0x1aee1af69bc8913f, 0x940f96ec7fb24812, 0 }, /* #87 */
    { 0x1b3b53, 0x1b3b03, 0x8a646ed895579218, 0x2a4215f7e6038ff8, 0xd7ddf2909f6e4588, 0x891261fef56fa995, 0xfd8eab8d38243b95, 0 }, /* #88 */
    { 0x333d07, 0x333d83, 0x6bcb8b8ac25c009b, 0xf50fc911628166b9, 0x5fa359357b2e86a8, 0x097ca4f7b486e867, 0x1687bac1174c793b, 0 }, /* #89 */
    { 0x2e4cc2, 0x2e4c03, 0xadaa005010de46da, 0x76659bcbe542f094, 0x7e2cb8349f3400a9, 0x9f1888f79af8d9d4, 0xea865af27a19a132, 0 }, /* #90 */
    { 0x0e05c6, 0x0e0d87, 0x5e914253a779bb61, 0xf511d3e75f08945f, 0x8511d86e47dcd3ce, 0x087b8124b0f5b18d, 0x16f6667c39ea27bf, 0 }, /* #91 */
    { 0x242ed3, 0x242e83, 0x4997c7432c8d3e91, 0xe4ac09c393a7885b, 0xc152af0040305342, 0x2a7e8f175378dd29, 0x93d21fe1d19ca62b, 0 }, /* #92 */
    { 0x1c2086, 0x1c2883, 0x357d9de59c053bb0, 0xab795f87665a3440, 0x39065e9ff46d9525, 0x0073b83a972a8034, 0x0229d1fd6ea77b8c, 0 }, /* #93 */
    { 0x314b86, 0x314b83, 0xa70fa3b4a141fd3e, 0xdaae757f684af732, 0xb97f37e989501f4e, 0x3e8c847156a39415, 0x5fd9288266ebb2c7, 0 }, /* #94 */
    { 0x116412, 0x116c07, 0x39c33aec800bee6c, 0x421e095a7ab42728, 0x9f94a07d9b097130, 0x16a24f98e857545a, 0x644ffe18fabb92fe, 0 }, /* #95 */
};
uint32_t const g_cTests_mul_u64_intel = RT_ELEMENTS(g_aTests_mul_u64_intel);

MULDIVU64_TEST_T const g_aTests_imul_u64_intel[] =
{
    { 0x086f52, 0x086706, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #0 */
    { 0x0b0013, 0x0b0006, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #1 */
    { 0x187b46, 0x187306, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #2 */
    { 0x3d4bd6, 0x3d4306, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #3 */
    { 0x354912, 0x354106, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #4 */
    { 0x224b56, 0x224306, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #5 */
    { 0x0b57d2, 0x0b5706, 0x84f9ea830bee6f7a, 0x0000000000000000, 0x909b570131b99add, 0x0000000000000000, 0x0000000000000000, 0 }, /* #6 */
    { 0x3f1a82, 0x3f1206, 0x0ace3891f6248843, 0x0000000000000000, 0x5186b54222374b90, 0x0000000000000000, 0x0000000000000000, 0 }, /* #7 */
    { 0x385392, 0x385306, 0x17e5014352d7a085, 0x0000000000000000, 0x70513095ce5b592c, 0x0000000000000000, 0x0000000000000000, 0 }, /* #8 */
    { 0x3a3057, 0x3a3006, 0xfe0900898f8ae719, 0x0000000000000000, 0xc071059b910d9085, 0x0000000000000000, 0x0000000000000000, 0 }, /* #9 */
    { 0x2b5ac6, 0x2b5206, 0x746a6ffa82974813, 0x0000000000000000, 0xfc4b391b91e60eea, 0x0000000000000000, 0x0000000000000000, 0 }, /* #10 */
    { 0x342917, 0x342106, 0xf31d87b9fea8a50a, 0x0000000000000000, 0x378e2ecfefc9834b, 0x0000000000000000, 0x0000000000000000, 0 }, /* #11 */
    { 0x105cc2, 0x105c83, 0xa9cef29fd5c527db, 0xac47fcaf34e54e1f, 0xea8a507d5a97bfaf, 0x21f00a28af939878, 0x9b336bf3cf3d580d, 0 }, /* #12 */
    { 0x2d0a82, 0x2d0a87, 0xa8112fda9725d0d5, 0xb0241e7051ddac81, 0x7de445cd0a01aef4, 0x1a3127406877b388, 0xb3bf34ebedba22fd, 0 }, /* #13 */
    { 0x0f5a57, 0x0f5a87, 0x764e25d78eadab18, 0xc240e99d9a12eee8, 0x41f94f9be77a8a20, 0xe58c409e1c069111, 0xc6c2a8b7e606a3bf, 0 }, /* #14 */
    { 0x210447, 0x210c87, 0x434ed60b37652d28, 0xe1b376c5629ac5f0, 0x6398684f089229d5, 0x146a51339acd26de, 0x4da5d8d40f4ea566, 0 }, /* #15 */
    { 0x186f06, 0x186f83, 0x6d9764053fd3f54b, 0xc5bd318f578b800e, 0xd3abdc4e8b423bb9, 0x10723724c6f29de4, 0x266adaac13a56d6a, 0 }, /* #16 */
    { 0x1325c6, 0x132d83, 0x5ce513a02644fe22, 0xd4c3bfeb703b1ac2, 0x3130a022b8ffa240, 0xdca373d76aad6dd6, 0x9e8cf2b9db7fc951, 0 }, /* #17 */
    { 0x0008c7, 0x000887, 0x46000773c694ec6a, 0xc9fc2b62859a167e, 0xf4cda37d1b4a3279, 0xef6d0759f2a12297, 0xc362df8266d79a23, 0 }, /* #18 */
    { 0x131c16, 0x131c87, 0x54ba4189edf899f9, 0xf61dce63ddbe8195, 0x1fa7b281771e2efc, 0x07b9de790278e523, 0x175807bb5112ab7d, 0 }, /* #19 */
    { 0x3d0dc2, 0x3d0d87, 0xc1f6006d3051c5fe, 0xb344a6768bd6a542, 0xbd3ff5189e9a92de, 0xe52803fb4ed8eaa1, 0x6ec4c8530abeea5f, 0 }, /* #20 */
    { 0x0b7a96, 0x0b7a87, 0x882d44e2eb09861e, 0xcb7bfcb8204971ee, 0xfa54b72193f21b0c, 0xe9448d7703f5b645, 0x3091248447ed8b99, 0 }, /* #21 */
    { 0x191d16, 0x191d07, 0x6792cac9d0a48b4a, 0x321226b94d79b3d2, 0xfe69c39cd240080c, 0x0e9a2a21b5fd6ced, 0x241788fee636f7f5, 0 }, /* #22 */
    { 0x2c5017, 0x2c5883, 0x9e46682110f6e4dc, 0xbd234da923c5a1e0, 0x277a295bfa37b3ce, 0xf3bb1c5ee1fa676a, 0x2023dcc1d4c9b748, 0 }, /* #23 */
    { 0x321f87, 0x321f87, 0x68e1242295ca2c0f, 0x832aa3cc97de1d84, 0xc1217894245d8862, 0x1e411dabbf39c13b, 0x49d9089a4fa5963c, 0 }, /* #24 */
    { 0x350ad7, 0x350a83, 0x4892a012ce4113c7, 0x928cca4d11cceab0, 0x54024fb0447ce13d, 0xf0d61b8b775a5998, 0xca82a54548ba5fd0, 0 }, /* #25 */
    { 0x3a6087, 0x3a6887, 0xdbc705e4f1f9bcdc, 0xd4fb1df45a547790, 0x7898ceb250e4ae10, 0xf3f04fa32e949117, 0x553dfc9c9029db3c, 0 }, /* #26 */
    { 0x0b2cd3, 0x0b2c83, 0xc8eddc8fbaa8aa30, 0x945179345ee39710, 0xbf2a10d2f412f409, 0xe6e22e43f70370a0, 0x74c161a0b609e0db, 0 }, /* #27 */
    { 0x2f4c07, 0x2f4c83, 0xadf0529d3ee3541a, 0xfe938388d9520d5e, 0x6196ae26be3ca2c5, 0x2850aa4ec593f4be, 0x823b6e7d36c230ab, 0 }, /* #28 */
    { 0x130dc6, 0x130d07, 0xb6ae11aea06def22, 0x6adc52d929bd6572, 0xafaa2849b7f804f5, 0x0063983510bd1223, 0xfea442eca3c704a9, 0 }, /* #29 */
    { 0x1218c3, 0x121883, 0x14fa0fd27b1160a1, 0xe49d2c94e6d78fcd, 0xc21c2c902f2a7330, 0x015de382fc740516, 0x10ae06d21adb63ad, 0 }, /* #30 */
    { 0x0524c3, 0x052c83, 0x2b20fffd5fde6592, 0xec302e4ff23c4426, 0x45e459dda69ca752, 0x0631cd61edbd2d99, 0x24c4d6633e691ffb, 0 }, /* #31 */
    { 0x257bc3, 0x257b03, 0xd3537a085b042050, 0x00744bc70a74fc40, 0x7293cc3051b7b438, 0x0bfd60473de6b190, 0xbb4b3536ab4547f4, 0 }, /* #32 */
    { 0x3d1792, 0x3d1f07, 0x94c080282c459efa, 0x32f6e73162d8e084, 0x28ce258144e2bdba, 0x2da818a31115ae1e, 0x9304a1d8f79068ea, 0 }, /* #33 */
    { 0x3d5616, 0x3d5e83, 0x78c5ebfa366f90f0, 0xbcfa2b18f0f467e0, 0xdffaba1c0f937690, 0xfb3dc1c7b23939f5, 0xf5e9b7f20ab1a5a2, 0 }, /* #34 */
    { 0x2a56d3, 0x2a5e83, 0xa6001d5e352dbfb8, 0xedea78528dff5a80, 0xd498727a84156a81, 0xe0db5c2b7f5d7877, 0x5895d8280a14bb30, 0 }, /* #35 */
    { 0x3b4842, 0x3b4887, 0xc84e559ec55d0b3a, 0x83999f433540bdb4, 0x999bc3f904a7e1db, 0xe42f6d51467b80ac, 0x7fda0892650b2022, 0 }, /* #36 */
    { 0x051883, 0x051803, 0xe8b133f325520acf, 0x707bc2bf2d09c743, 0x8fdb669d75083380, 0xf47a92f5dd61f2c0, 0x7e8add1ea120c94d, 0 }, /* #37 */
    { 0x085f43, 0x085f07, 0x887598569e556a5b, 0x45cbcaa89ae37e8d, 0x99cd2ac3febd0aad, 0x1f1e6c07da205b62, 0xbd5ba8f7fe1bff37, 0 }, /* #38 */
    { 0x0932d6, 0x093a07, 0xd924427032a42637, 0x281b4a65a806b8d1, 0xe41aee4027a2feeb, 0x082fe0ceb8ed35d0, 0xca104b655d601537, 0 }, /* #39 */
    { 0x283a17, 0x283a07, 0xe485cc54aa18d212, 0x3fab80a93263e260, 0x559a1adf84e40f8d, 0x03f225e09699c24b, 0xdb3cb08c3ac1a3b0, 0 }, /* #40 */
    { 0x014056, 0x014807, 0x59eb88593bb27bb3, 0x7deea4cef15409c3, 0x2c46342b28b8f127, 0x09d486b0b934bd3b, 0x1bfc7bb8d923f1b1, 0 }, /* #41 */
    { 0x3c5a93, 0x3c5a87, 0xe2b3ffbcfc8959a7, 0xe051b77d88644435, 0x735cf88e5d6f9228, 0xf583d7a57ef0f2fc, 0x5b9e86296a3e76c3, 0 }, /* #42 */
    { 0x370e56, 0x370e87, 0xa288c2562ffdb3b0, 0xe00bb0b66cad30f0, 0x67a6cb80db10bd3f, 0x0afb66bc8a0637a2, 0xe1eba7d1e545623d, 0 }, /* #43 */
    { 0x173252, 0x173a03, 0x4be8296a4c62549d, 0x6f376ddb077c25dc, 0x94f283e1e0df9dbd, 0x082b2eb8151dcf65, 0x1b8c9fd13177608c, 0 }, /* #44 */
    { 0x114082, 0x114803, 0x2053ef42b24271c6, 0x1863ae02d9bd7832, 0xc7fde79c27ccaeba, 0x00bc4f4b3d84d8ae, 0x05d333001aec13d3, 0 }, /* #45 */
    { 0x245496, 0x245c07, 0x84cd7e4cbf544976, 0x031ca8204003ef74, 0x6f1d90f505643c98, 0x32f9cc5edf1fe731, 0x9612f0977197488e, 0 }, /* #46 */
    { 0x0c4e46, 0x0c4e87, 0xe608772e08cde6de, 0x9362d3545b9c1436, 0xde8f09464f4007d7, 0x055c2c568fec2314, 0xcb282a7f5ab40e15, 0 }, /* #47 */
    { 0x0a4743, 0x0a4f83, 0x874faa40140fd51d, 0xdf76d4880d6a7aba, 0x7752845f32feed0a, 0xf79332f4faf2e0fb, 0x11deea3f1157aa82, 0 }, /* #48 */
    { 0x325a13, 0x325a87, 0xc47bb55fd09d91c9, 0x9007a4f7c839b7c9, 0xcac22dc9d3468101, 0x0978036d3f822173, 0xd74591ad9bddf601, 0 }, /* #49 */
    { 0x044e43, 0x044e83, 0xfb4394e7af8baeae, 0xa16bd53f3002c194, 0x901c190f0d4c8458, 0xfe5338de08d33345, 0x5a892312a1871946, 0 }, /* #50 */
    { 0x207712, 0x207f07, 0xa1aea98a0b9de9fb, 0x50bd18224186b7be, 0xca910acce49be06e, 0x03889256f2ba1e2d, 0xf668c8d66566e8da, 0 }, /* #51 */
    { 0x306f86, 0x306f87, 0xd61c26f6b41520f3, 0xbc33086c391135e8, 0x2b26c84e025a7d63, 0xf846d58c16971f30, 0x2f32eefa7c802c78, 0 }, /* #52 */
    { 0x324f96, 0x324f07, 0x287e6ef0eb8e2f49, 0x1ad205fc8d939781, 0x1cf44b6bc4f5fd6a, 0xf11a0b1671787ea3, 0xa1d0622e323f4e79, 0 }, /* #53 */
    { 0x073b53, 0x073b03, 0x1f8e447decff67a8, 0x279e64c4217e66b0, 0x99712f7c9be7689b, 0x091e581b7307f357, 0x49f9abfa9c70d3be, 0 }, /* #54 */
    { 0x3b2112, 0x3b2987, 0x2ed87d4b7c3f1b40, 0xb30e7143f8c669c0, 0x29dd4218c02225ee, 0xec1e8b7339198a50, 0x935b6182099b39e3, 0 }, /* #55 */
    { 0x3315c6, 0x331d03, 0xb8362c90c97bb3e3, 0x5ea15df2eef120a4, 0xe05456fb98479608, 0x0606814232c5ea57, 0xea835ef9d29b260c, 0 }, /* #56 */
    { 0x140912, 0x140907, 0x8639273b34770853, 0x758392c95c899317, 0x3c953fd368ea46eb, 0xfa82cb18281a8173, 0x0b8a09403618e1ad, 0 }, /* #57 */
    { 0x3f7f82, 0x3f7f07, 0xa9149bc8b6ee61fd, 0x6b4bada3710300ac, 0xb558049356e99893, 0xd618d5d24011ef82, 0x7b6a399cec233d1c, 0 }, /* #58 */
    { 0x0d5147, 0x0d5903, 0x68c10cedc18e4f9c, 0x1231eaa97fe43168, 0x0c9eb3eb9c277d55, 0x2c9d6a95a2351558, 0x6d07dde6acc02596, 0 }, /* #59 */
    { 0x274902, 0x274907, 0xa0f182bf15554bd6, 0x4d099043ea1f9944, 0xc3f551bd8ee2bc40, 0xfb03801c67932503, 0x0d6dc84261b3d366, 0 }, /* #60 */
    { 0x3b3757, 0x3b3f07, 0x53fb1f831551a615, 0x4d8961c58b052941, 0x155b3ca2fbe25a67, 0xec020bce6c07e176, 0xc30ee3592fd80d7d, 0 }, /* #61 */
    { 0x184613, 0x184e87, 0xca500b34ba3594d1, 0xf61d8bdf4b67ecff, 0x05044c7925ee2aa4, 0xf88c9b24626294e8, 0x23871f793e5118cf, 0 }, /* #62 */
    { 0x326b02, 0x326b87, 0x0c46888d27c93e67, 0xd63d00ab2af7c50c, 0xe148d9ce004d6e04, 0x01715e4b2a3f7d49, 0x1e16ff0d26b0d314, 0 }, /* #63 */
    { 0x115497, 0x115c83, 0xb5c8500e3fe38f25, 0x96da4b8ae690c951, 0xd7213039e3e59332, 0xf07ca86a68f73d6d, 0x35826df6911e3fbd, 0 }, /* #64 */
    { 0x152dc2, 0x152d03, 0x5ef12048122452a6, 0x66fcf4decbe5f416, 0xeb878adc7ee3d2f3, 0xddc2ea169d234aea, 0xa3adf2510093fd69, 0 }, /* #65 */
    { 0x3c5a02, 0x3c5a83, 0x8dadae4be98714a4, 0xd6fe95bccef7ef20, 0x455d66aac7eaf686, 0x3671e3e5f202151b, 0x8614ea3f427d0e88, 0 }, /* #66 */
    { 0x194016, 0x194883, 0xbf898a54c17f84a5, 0xf449f55478f2f2c1, 0x60523c4101c1d56f, 0x0f9d249191cd96bf, 0xc1fe330ccd39aeed, 0 }, /* #67 */
    { 0x1f1f07, 0x1f1f87, 0x19e84736569172ba, 0x9985220b604688a6, 0xe6e713ebf0771539, 0x061def68c96f8bba, 0x3c719618dfe7296f, 0 }, /* #68 */
    { 0x061242, 0x061a03, 0xa2a66c9aa871fac5, 0x55295a7690b667ad, 0xc16ca80bc7d7179b, 0xed7cdff59f6c69e7, 0x32c46f88d43aa7c9, 0 }, /* #69 */
    { 0x280452, 0x280c87, 0x89aaa37a3dc76ce2, 0xce2ae6380f23fbe2, 0x08c5ed5ab3db123a, 0xe64a9595da60f2e3, 0x379e177a86e17f81, 0 }, /* #70 */
    { 0x162543, 0x162d03, 0x59be5e6a506b9b3b, 0x4d4233820372cb04, 0xa98159233750aeb3, 0xf2918e62b8a6f92a, 0xd9af98fedc77c8cc, 0 }, /* #71 */
    { 0x115843, 0x115887, 0x20d12a3a79376080, 0xc31864d88e63e700, 0x9d6bf1689728bd27, 0xfb15430d21002cb0, 0xd9a4cea1422a494e, 0 }, /* #72 */
    { 0x275413, 0x275c07, 0x3715564651c531c0, 0x4a1684aa553e2900, 0xb078e556118655d3, 0x004defeba2425f42, 0x016a3699ff05163c, 0 }, /* #73 */
    { 0x3d2ac7, 0x3d2a07, 0xb2cd5d3d8d01d073, 0x04b0f9ab48f8fbd1, 0x0b67fb11c9ad5fa4, 0x09e6c2585ea77e23, 0xdf2a574edfed85ab, 0 }, /* #74 */
    { 0x151a42, 0x151a87, 0xe1ba0366ec07a765, 0xef507d45e4b6121d, 0x680e3ddcf7dc5619, 0xf6ae387c848fb7b8, 0x4ececceb273b6059, 0 }, /* #75 */
    { 0x191cd6, 0x191c07, 0x0bc7e965fd0a0844, 0x15183b1814309cf0, 0xb2abec33e95d9fbd, 0xfefdc7cf71bafe0e, 0xea14debb2d2bb77c, 0 }, /* #76 */
    { 0x2c6702, 0x2c6f03, 0xf8b0d9c9d51be09e, 0x13cf32d1ac0e660e, 0x6bb3f2dce790dfac, 0x02426307b74cd511, 0xb0de4fa2daf3ebc9, 0 }, /* #77 */
    { 0x3c16c2, 0x3c1e07, 0xddd43a5f5ccc490f, 0x651641c2f19bc0a0, 0xa2c8ecb65d15ee16, 0x0acd30763a80a74a, 0xaf13ee63299bf560, 0 }, /* #78 */
    { 0x1e0d02, 0x1e0d07, 0x40ace39edb43c1ec, 0x578e33fa4a943dcc, 0x6521a6539c9bbd9e, 0x0731f9b1ffb78f46, 0x1c7af7054b583769, 0 }, /* #79 */
    { 0x144583, 0x144d03, 0x2607fe6bbaaac00a, 0x64a320185f0ab08c, 0x23a8cac428693d75, 0x0898b04adec13826, 0x39dd84e5b4c5380e, 0 }, /* #80 */
    { 0x120c92, 0x120c07, 0xb03c872999b6b922, 0x0dd4aca767cf0efa, 0xcb6fcf224155eee4, 0xf7cf9055ba6cf36c, 0x1a487b4bb8bd222d, 0 }, /* #81 */
    { 0x021916, 0x021907, 0x4935f9826fa87fc0, 0x2d0b2985960a6e00, 0x971465687a7060ee, 0xf253d65e52151836, 0xd030ce6addd16648, 0 }, /* #82 */
    { 0x3a55c2, 0x3a5d87, 0x0d6f645415a5e7a3, 0xd31cbec287f9ac1e, 0xea89e539d089d21e, 0xf969a05c67d132aa, 0x827af128438fdd4a, 0 }, /* #83 */
    { 0x025292, 0x025a87, 0xf13dc4dad0f0fac6, 0x8ca78230d969b80c, 0xb1486eee826fed04, 0x0166de28f2319654, 0xe7af3146b709fdc2, 0 }, /* #84 */
    { 0x2b71d7, 0x2b7987, 0x7aa8d49fa92e453d, 0xd71b9852c0946db8, 0x8fe26b58f644b499, 0x1c903bff68903dcc, 0x3b9d351fd974b018, 0 }, /* #85 */
    { 0x120653, 0x120e07, 0x17e077ee0738e522, 0x2b8e671f6f76ba72, 0x82e0d15b01b4b036, 0xfb04b64e29352c78, 0xca96c1d50b96c429, 0 }, /* #86 */
    { 0x152d56, 0x152d83, 0x5d0283b5b9990bad, 0xe0a3e1ba84cbfffe, 0xaf3dc7559cbd7f63, 0x0ef851ef14579539, 0x2934116b7e5adfb6, 0 }, /* #87 */
    { 0x014ad7, 0x014a83, 0x7b60d38ed7a98e97, 0xbf7a77e3f8247af4, 0x20bda36b3405e115, 0xe34787de2994f32f, 0xc46836304947ef2c, 0 }, /* #88 */
    { 0x382d06, 0x382d07, 0x1b5bc502d025db5e, 0x4287b14e88a6d150, 0x8e1aef7c3ee6ed2b, 0xf68a01b2e27d0b36, 0xa778cf7c8a4f33d8, 0 }, /* #89 */
    { 0x0514c6, 0x051c83, 0x1eb228ad6ee7dbb4, 0xd02b4b0089b27af8, 0x3191f1064af738e5, 0x008e5f31b321f069, 0x04a35cc05984d3f6, 0 }, /* #90 */
    { 0x295c12, 0x295c87, 0xecbe586a067b8101, 0xe08baf5d76c54e72, 0x9c1ba4923831ef5e, 0x0884cfb38eb07120, 0x8ebfc6a507e9dc72, 0 }, /* #91 */
    { 0x371486, 0x371c87, 0x61a060b84b77e100, 0xe10bbd2e05017300, 0x85ddf9e914d05f1b, 0x26f33d3afd1ec621, 0x6622fa24f55b93d3, 0 }, /* #92 */
    { 0x1b4f86, 0x1b4f07, 0x48f8285e06400583, 0x0572ba0875b1a48b, 0x75a26dd70ef5a7b0, 0xf780bcde3ae85fd8, 0xe2307b08965e3e59, 0 }, /* #93 */
    { 0x1e43d2, 0x1e4b03, 0xba4f5be185217cd8, 0x6dabb8c7c6d31838, 0x102137ddda320629, 0xe40f8c7c3647225e, 0x66a1e3df55382f05, 0 }, /* #94 */
    { 0x0953c6, 0x095b07, 0x2a1a630170809347, 0x0097c7306c7e13c9, 0x8835748215d92f20, 0x0bb1c9b58c6326e0, 0x471b2d67c8bc086f, 0 }, /* #95 */
};
uint32_t const g_cTests_imul_u64_intel = RT_ELEMENTS(g_aTests_imul_u64_intel);

MULDIVU64_TEST_T const g_aTests_div_u64_intel[] =
{
    { 0x3774c3, 0x3774c3, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #0 */
    { 0x0b7e03, 0x0b7e03, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #1 */
    { 0x172713, 0x172713, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #2 */
    { 0x0a3843, 0x0a3843, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #3 */
    { 0x2a1d93, 0x2a1d93, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #4 */
    { 0x203306, 0x203306, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #5 */
    { 0x264983, 0x264983, 0xabdbb229747fa195, 0xabdbb229747fa195, 0xc058c0ed39472563, 0xc058c0ed39472563, 0x0000000000000000, -1 }, /* #6 */
    { 0x364982, 0x364982, 0x2d377dd6e34690af, 0x2d377dd6e34690af, 0x515d00cb7f35e0f7, 0x515d00cb7f35e0f7, 0x0000000000000000, -1 }, /* #7 */
    { 0x3a1017, 0x3a1017, 0x30966add6f107f9f, 0x30966add6f107f9f, 0xa44c52d44967adca, 0xa44c52d44967adca, 0x0000000000000000, -1 }, /* #8 */
    { 0x2030d6, 0x2030d6, 0x8a1c92c0a0008b84, 0x8a1c92c0a0008b84, 0x5583f7f39071afc5, 0x5583f7f39071afc5, 0x0000000000000000, -1 }, /* #9 */
    { 0x126052, 0x126052, 0x284d79065155391c, 0x284d79065155391c, 0xff03ccf571ff3a01, 0xff03ccf571ff3a01, 0x0000000000000000, -1 }, /* #10 */
    { 0x3e7b17, 0x3e7b17, 0x8d2e28ee6bba40a6, 0x8d2e28ee6bba40a6, 0xbca8c12e24fff518, 0xbca8c12e24fff518, 0x0000000000000000, -1 }, /* #11 */
    { 0x122cd6, 0x122cd6, 0xf29768d672ebe86c, 0xf29768d672ebe86c, 0x9ad700b33d9b12c3, 0x9ad700b33d9b12c3, 0x547b6ff875914fc2, -1 }, /* #12 */
    { 0x135bd7, 0x135bd7, 0x284bb757e5e78018, 0x6c76c4f94a545c0a, 0x49de205df82c9a2a, 0x26fc8bbb69f68680, 0xae584600cfef975c, 0 }, /* #13 */
    { 0x2f53c6, 0x2f53c6, 0xa9572bd57e746be0, 0xbf042058ac18ede7, 0xbe3879bd56188fea, 0x61e533ab55c84084, 0xfeef11255ee7f644, 0 }, /* #14 */
    { 0x1a2ed3, 0x1a2ed3, 0xbcb521660fb3c54e, 0xbcb521660fb3c54e, 0x4bb20cd4758b0491, 0x4bb20cd4758b0491, 0x0955d63a334e45f7, -1 }, /* #15 */
    { 0x225787, 0x225787, 0x32295d5e5554913c, 0x32295d5e5554913c, 0xdda29cad377b27a9, 0xdda29cad377b27a9, 0x064b787799c39c59, -1 }, /* #16 */
    { 0x0651d3, 0x0651d3, 0xd03f6a988d802b14, 0x058b7cfead7bf0f7, 0x031b253de110d2b3, 0x36cd1ecd564c2b6e, 0x8f66df98b7d89a0a, 0 }, /* #17 */
    { 0x0d6903, 0x0d6903, 0x8d897074ce83ae7a, 0x8d897074ce83ae7a, 0xa67059ea3fc578bc, 0xa67059ea3fc578bc, 0x6250db3ea172db56, -1 }, /* #18 */
    { 0x3b3f03, 0x3b3f03, 0x6a1633f1201146bf, 0xf2af4c27065a863f, 0xb867c9174f5d9feb, 0x5753e479332f7e59, 0xc285e86598025a1a, 0 }, /* #19 */
    { 0x0d4b42, 0x0d4b42, 0x04a1431dbf62dded, 0x04a1431dbf62dded, 0xbd33a9940365c909, 0xbd33a9940365c909, 0x1589b490b491d225, -1 }, /* #20 */
    { 0x276346, 0x276346, 0x2dfc3d55b42a269b, 0x2dfc3d55b42a269b, 0x6657e1da4e59b030, 0x6657e1da4e59b030, 0x57c89ff63eb8b01f, -1 }, /* #21 */
    { 0x262752, 0x262752, 0x915bd4380088fa6f, 0x546157183ac74ac2, 0x4b8b44d61c0dcdb6, 0xb47cdf90f0305eb7, 0xe531224548ea3f5c, 0 }, /* #22 */
    { 0x196903, 0x196903, 0x35f4da84b1109e49, 0x35f4da84b1109e49, 0x5f6eeac3d33579c9, 0x5f6eeac3d33579c9, 0x30c0b273b9ce4f2a, -1 }, /* #23 */
    { 0x255c03, 0x255c03, 0xa777367da623913b, 0xa777367da623913b, 0xf0a0d14eb595ee5b, 0xf0a0d14eb595ee5b, 0xa01c41fe321167d3, -1 }, /* #24 */
    { 0x272f02, 0x272f02, 0xcb3994a4a655879e, 0xcb3994a4a655879e, 0xc5a00e882f1d5206, 0xc5a00e882f1d5206, 0x1ed79fd503d31ddb, -1 }, /* #25 */
    { 0x112613, 0x112613, 0x4e0742f971ff89bc, 0xb59937afbb8f6911, 0x2ade92bca99099d7, 0x2fb07a2ba0090cc2, 0x3c6ee429015abd5a, 0 }, /* #26 */
    { 0x137187, 0x137187, 0x010c133dda1e49ba, 0x010c133dda1e49ba, 0xee3d1ee935aee743, 0xee3d1ee935aee743, 0x0a8b7fbb9d2dd1a4, -1 }, /* #27 */
    { 0x2b2c16, 0x2b2c16, 0x4c51aa3ffb5a44f7, 0x4c51aa3ffb5a44f7, 0x4df2d414e793fb3f, 0x4df2d414e793fb3f, 0x2a3117b39e605d45, -1 }, /* #28 */
    { 0x2d5153, 0x2d5153, 0xb4449083f9d46f78, 0xf19ebf9700e94803, 0x9528afa60e9d5210, 0x9794f2d8cab3306e, 0x9e093a155b736fae, 0 }, /* #29 */
    { 0x2f1d47, 0x2f1d47, 0x82d9b6095b69468b, 0x82d9b6095b69468b, 0xe450bf5e58ac8402, 0xe450bf5e58ac8402, 0x37718cf33cfd1ed6, -1 }, /* #30 */
    { 0x0d51c6, 0x0d51c6, 0x9916f13b5d5a39fb, 0x9916f13b5d5a39fb, 0xc8f11143a46472c7, 0xc8f11143a46472c7, 0x25c9591c8d1aea10, -1 }, /* #31 */
    { 0x115d02, 0x115d02, 0x6423c57f1ac18e27, 0x6423c57f1ac18e27, 0xa1119e24b328e040, 0xa1119e24b328e040, 0x0ef5563c07b9f194, -1 }, /* #32 */
    { 0x1f1d53, 0x1f1d53, 0x2f1f4d9efeb8c922, 0x2f1f4d9efeb8c922, 0xff735bec0da2507d, 0xff735bec0da2507d, 0xdc83af25726c44d6, -1 }, /* #33 */
    { 0x1d6903, 0x1d6903, 0xfb5d96a641e004ad, 0x32e401274241afff, 0x2a941e7970b1689d, 0x4e968882cd043d65, 0xd62fe5a340dab8b8, 0 }, /* #34 */
    { 0x3c0f47, 0x3c0f47, 0xc253bc02c3e8a9a2, 0xc253bc02c3e8a9a2, 0x2be3e47fa8f0e228, 0x2be3e47fa8f0e228, 0x245bfc912dbe89f2, -1 }, /* #35 */
    { 0x177893, 0x177893, 0xbc2f4f8a2689f628, 0x2b0fe98bc086fcf1, 0x106419c32a75126b, 0x53c4b861ac8c60dc, 0x617160958e8d5a0c, 0 }, /* #36 */
    { 0x2b76c3, 0x2b76c3, 0x7525db504af8b318, 0x7525db504af8b318, 0xe9cc366c0f2ce6c5, 0xe9cc366c0f2ce6c5, 0x4f61f593165b471a, -1 }, /* #37 */
    { 0x3e1387, 0x3e1387, 0x34e821f8786be52e, 0x34e821f8786be52e, 0x6410ce5176e07f30, 0x6410ce5176e07f30, 0x4587191c10319b9e, -1 }, /* #38 */
    { 0x3b6897, 0x3b6897, 0x088b8c60f26a3de4, 0x088b8c60f26a3de4, 0xe1dabad15c4b71c0, 0xe1dabad15c4b71c0, 0xcfd831edaffb2b23, -1 }, /* #39 */
    { 0x272a83, 0x272a83, 0x3d92ca505d90dc85, 0x3d92ca505d90dc85, 0xbacdb9c4cff18cb0, 0xbacdb9c4cff18cb0, 0x62336bb408d23eca, -1 }, /* #40 */
    { 0x0e0653, 0x0e0653, 0x62437dd6e5cbe5d7, 0x7de545e05233ed47, 0x22395df08e2a2b1c, 0x409dee8cf2c68d0c, 0x4597a2695031aa5d, 0 }, /* #41 */
    { 0x3c3047, 0x3c3047, 0x31c9c828bb1b851c, 0x0d65551370b102f3, 0x0a94dd053d98e828, 0xc6978389a9741480, 0xca37880f1a1b1bf4, 0 }, /* #42 */
    { 0x1a3dc6, 0x1a3dc6, 0x8a111ede8a09df36, 0x738538528e92f1a1, 0x2ef60b45a39cc069, 0x3353c0ad8a85de41, 0x68118f08bda936d5, 0 }, /* #43 */
    { 0x242297, 0x242297, 0x13d5a247dd7a6897, 0x75e44c728955f0dd, 0x62659a181f5e86f9, 0x79b4e0e31f6a7e2a, 0xd5aac9b1a567fed1, 0 }, /* #44 */
    { 0x0d7f86, 0x0d7f86, 0x44914fdd66293288, 0x41182daf785fcb82, 0x28656238e5f548f3, 0x0c58ead3a7a6384e, 0x9ede0c074598865d, 0 }, /* #45 */
    { 0x204f03, 0x204f03, 0xa60ebd6773218787, 0xa60ebd6773218787, 0xccd85fa29a84c796, 0xccd85fa29a84c796, 0x27f5b4d1b33b3ee2, -1 }, /* #46 */
    { 0x3d10d3, 0x3d10d3, 0x0fa90b7b1abcba8b, 0xf62fb4793f4c3667, 0xb4c338a4d5fcd543, 0xa46de35a74024d34, 0xbbf7e063335f5b91, 0 }, /* #47 */
    { 0x1d0907, 0x1d0907, 0x714c7dc10bfc4b73, 0x7acf2f10c2732966, 0x2b12b25323cf6e31, 0x5091317a6fed7679, 0x59c981d8b45b7c0f, 0 }, /* #48 */
    { 0x3b5bc3, 0x3b5bc3, 0xf49e04102bf514fb, 0xf49e04102bf514fb, 0xf56846db309136b7, 0xf56846db309136b7, 0x1caa7d1ad944513e, -1 }, /* #49 */
    { 0x1d0852, 0x1d0852, 0x0694951882ae66f6, 0x749cfab5d61e4168, 0x195b4257dc750236, 0x327d8c09744d82d6, 0x37aa353443dcfd14, 0 }, /* #50 */
    { 0x2c0243, 0x2c0243, 0x3e3452ace3909757, 0x3e3452ace3909757, 0x580eaba5cde4ea21, 0x580eaba5cde4ea21, 0x54ffc989bc94ed54, -1 }, /* #51 */
    { 0x363506, 0x363506, 0x8a85ac42e96ab0ea, 0x8a85ac42e96ab0ea, 0x9c759d40162a06a4, 0x9c759d40162a06a4, 0x29153932ae3d8a7c, -1 }, /* #52 */
    { 0x3e0b56, 0x3e0b56, 0x4ce8296ebe0f7df3, 0x4ce8296ebe0f7df3, 0xf3a7662828bf8f4c, 0xf3a7662828bf8f4c, 0x61dcc8e64d72f381, -1 }, /* #53 */
    { 0x1f42d2, 0x1f42d2, 0x2eaf4ccfb8dbab0c, 0x2eaf4ccfb8dbab0c, 0x29b785aed746dc7f, 0x29b785aed746dc7f, 0x23072efac527c8d0, -1 }, /* #54 */
    { 0x022f17, 0x022f17, 0xe1fe9169f2949d22, 0x52be62680cf14c9d, 0x33e1715661257ddb, 0x6ecfdedd37b3c363, 0xa08357e5d8c61b0b, 0 }, /* #55 */
    { 0x1b5e92, 0x1b5e92, 0x809f5644ed6abe18, 0x809f5644ed6abe18, 0x4de4ca7652073f6d, 0x4de4ca7652073f6d, 0x106c68cb4ce24799, -1 }, /* #56 */
    { 0x2b52c6, 0x2b52c6, 0x0fa23ab1d437d719, 0x0fa23ab1d437d719, 0xab2742953293152a, 0xab2742953293152a, 0x98af2c50bdf66f58, -1 }, /* #57 */
    { 0x3b4e47, 0x3b4e47, 0xc34b3cf826e68712, 0xc34b3cf826e68712, 0xf2da4f7169ee720a, 0xf2da4f7169ee720a, 0x6938381a48b6496a, -1 }, /* #58 */
    { 0x3c0c52, 0x3c0c52, 0xd8055c539bf510d2, 0xd8055c539bf510d2, 0xd7e8266bd4d1f7a0, 0xd7e8266bd4d1f7a0, 0x0e98f7e4d49d9d1f, -1 }, /* #59 */
    { 0x274b07, 0x274b07, 0xb82c314fbbcc7585, 0xb82c314fbbcc7585, 0x8892416baef568d4, 0x8892416baef568d4, 0x701470a9cf9ea180, -1 }, /* #60 */
    { 0x061052, 0x061052, 0xdb8d540af9cadc32, 0x4a2074b4944bbc56, 0x18d0c0196fcb2992, 0x2f6864e8760ba700, 0x55b37e979dd88c4b, 0 }, /* #61 */
    { 0x2e13c6, 0x2e13c6, 0xcfec8331e37fad92, 0x53cf47ad94413e93, 0x348f19b4c787ae34, 0x3a6fcd8926315288, 0xa08b22b3bde5b50e, 0 }, /* #62 */
    { 0x3a0f42, 0x3a0f42, 0x7da1e09701401efe, 0x7da1e09701401efe, 0x865ef99f72b569fb, 0x865ef99f72b569fb, 0x0b1c3655b74a36dc, -1 }, /* #63 */
    { 0x316cd3, 0x316cd3, 0x6ae68e58afe71910, 0x6ae68e58afe71910, 0xb69e794563f3d8de, 0xb69e794563f3d8de, 0x4136cd60f29d83c8, -1 }, /* #64 */
    { 0x351b52, 0x351b52, 0xefa147a652993856, 0x1b2760007bdaab48, 0x1619a5b16173ae17, 0x247783be49eddf36, 0xd05b068cd7913984, 0 }, /* #65 */
    { 0x104003, 0x104003, 0x5749ba3f3694bf88, 0xddf5c5ad50b8a671, 0x3863378481f7f1fd, 0x098b5da90990c3ea, 0x41090318feeb107e, 0 }, /* #66 */
    { 0x0b2242, 0x0b2242, 0x02de89b2ed2e68ce, 0x02de89b2ed2e68ce, 0x5aa535b81e064103, 0x5aa535b81e064103, 0x4a9ece0cf6cc40f3, -1 }, /* #67 */
    { 0x127883, 0x127883, 0xb87bd361c67b01fd, 0xf6f2af98eac180c8, 0x3596e17f18d59181, 0x0d42871e2facf765, 0x378dc0ece3ce3a4b, 0 }, /* #68 */
    { 0x113302, 0x113302, 0x685eab4d158f642a, 0x685eab4d158f642a, 0xfd75bc95022ffc2c, 0xfd75bc95022ffc2c, 0x01354ae1438f6231, -1 }, /* #69 */
    { 0x0c7612, 0x0c7612, 0x3d624adc0c3898a3, 0x3d624adc0c3898a3, 0xc3dd86cd3f373daa, 0xc3dd86cd3f373daa, 0x876984036ca3793c, -1 }, /* #70 */
    { 0x246b82, 0x246b82, 0xf2742043973ee3e5, 0x0193aaf072c931f2, 0x00b27b5cab1a485b, 0x6a017a1fa49e6e77, 0x7130c62bd90f8d2f, 0 }, /* #71 */
    { 0x3c3346, 0x3c3346, 0x6f1c704fab0f8420, 0x6f1c704fab0f8420, 0xfe59b78ea651f2de, 0xfe59b78ea651f2de, 0xcc31101f0c915e6e, -1 }, /* #72 */
    { 0x0734d7, 0x0734d7, 0xd1297d21d8daecb9, 0x02e4a01f46111e92, 0x00f40d0926456f69, 0x3311c9cd2e070071, 0x545b6c865344f104, 0 }, /* #73 */
    { 0x3b4546, 0x3b4546, 0x71836d930dc2ddd9, 0x78781c3d334876bf, 0x5879cc9455bd1e20, 0x09ca12a6856b6d5c, 0xbc0362ac4c2f43c3, 0 }, /* #74 */
    { 0x1a35d3, 0x1a35d3, 0x3d41e0fe9576b957, 0x2315bf8578e9cb09, 0x203507c71ba11b30, 0x0af997018a91760f, 0xeb007bcd4a6b5308, 0 }, /* #75 */
    { 0x383203, 0x383203, 0xab0232ca3927c118, 0xab0232ca3927c118, 0x8eb72d8429861ae0, 0x8eb72d8429861ae0, 0x0a63f8421f5cc8d3, -1 }, /* #76 */
    { 0x2c6b53, 0x2c6b53, 0x326db52989092c3e, 0x21f1e355c13855fa, 0x1aeca254180a3ec4, 0x5e27b0c3aacca71c, 0xcb0dc263df97fc25, 0 }, /* #77 */
    { 0x103c16, 0x103c16, 0x150ff3da3fb5961a, 0x9b38e5aaf6af5eb0, 0x5ab759387824102f, 0x8f5f2b99a8e11e8a, 0x959d0feb7a16ab2b, 0 }, /* #78 */
    { 0x011b93, 0x011b93, 0xb8613bdf63a58ef7, 0xb8613bdf63a58ef7, 0xed9f3dd8d85bf14c, 0xed9f3dd8d85bf14c, 0x4ee73ed9ddfdb009, -1 }, /* #79 */
    { 0x221693, 0x221693, 0x639e897693a85e47, 0x639e897693a85e47, 0xe3863ce783d0a5ad, 0xe3863ce783d0a5ad, 0xde68f61d5eaaa61e, -1 }, /* #80 */
    { 0x022113, 0x022113, 0x24ea4dff4dc93fe6, 0xc43f3ca44c59001d, 0x9164419915e51555, 0x04df3685ffb0567a, 0xbda90552dbf82b5c, 0 }, /* #81 */
    { 0x0a7607, 0x0a7607, 0xd1717b8ad33fd593, 0x8d07b7390180cf52, 0x632352980fa737c4, 0x96d425ab007e4dd3, 0xb3f4ec35775f90e0, 0 }, /* #82 */
    { 0x173316, 0x173316, 0xd7cc212aafb66bfc, 0x6859a9ccf02c362f, 0x3f3e00a1a43db140, 0x5cc3a51b145ece1d, 0x9b268d187477d751, 0 }, /* #83 */
    { 0x0b3257, 0x0b3257, 0xacc9af8764a8d028, 0xacc9af8764a8d028, 0xf6f69a189459da41, 0xf6f69a189459da41, 0x93f7394c4ffafd27, -1 }, /* #84 */
    { 0x244012, 0x244012, 0xf803d808f57abd5b, 0xf803d808f57abd5b, 0xd7b285687e3896a5, 0xd7b285687e3896a5, 0x7717fd90a43191de, -1 }, /* #85 */
    { 0x2f6c17, 0x2f6c17, 0x597b327462a47e91, 0x27afd0a7dc595f0f, 0x1fb1b1719ccc706d, 0x69dffffc9d9ad063, 0xcc7177c1a4f50ef2, 0 }, /* #86 */
    { 0x393587, 0x393587, 0x77fd1885d06964d0, 0x2e13a76ab1d6c45a, 0x0f8bb388a7447586, 0x4bc7f538df8610e8, 0x565efffe3d95ae44, 0 }, /* #87 */
    { 0x191d53, 0x191d53, 0xc52d9745457078b3, 0xc52d9745457078b3, 0x95391bc86f83b156, 0x95391bc86f83b156, 0x127e73f1aaabd77d, -1 }, /* #88 */
    { 0x192406, 0x192406, 0x6a8938e2a8b00ad9, 0x1b5a58c5d8ef8e5c, 0x08b255acaff5700f, 0x1f09eb90d94ac16d, 0x51649880d8b00fdd, 0 }, /* #89 */
    { 0x123342, 0x123342, 0x1e3c229f751bb7e1, 0x7d96fe360fca24c3, 0x4992982f8ce93030, 0x8c764d1d16f372ae, 0x95f8185d13b296d1, 0 }, /* #90 */
    { 0x0f56d6, 0x0f56d6, 0xcafc2848c448d97b, 0xf609e2e4d05c035a, 0xd4cbec3cabe6dc03, 0xb09df2651eb8fa75, 0xdd697e386867bbef, 0 }, /* #91 */
    { 0x050947, 0x050947, 0x7302e0a94df0a3d7, 0xafda43d951f58afb, 0x8b190cdd8a9d6118, 0x8251f4b4748beb74, 0xca7e65c26ce78bb9, 0 }, /* #92 */
    { 0x264986, 0x264986, 0xd19da2e94c9f4e0a, 0x0c73422612fb2877, 0x090d236798b69ae7, 0x35b7d7d60d07c4ec, 0xba1cb3a6b447c552, 0 }, /* #93 */
    { 0x174a03, 0x174a03, 0xe199869ad5d0b0fd, 0xa4aa96ffaf116d73, 0x2412c4b83f330f79, 0x1bd37ba479ca4c3d, 0x3814e9c2bae6d840, 0 }, /* #94 */
    { 0x1d0057, 0x1d0057, 0x1574d1fc299a1e0b, 0x1574d1fc299a1e0b, 0x6048aca66f662218, 0x6048aca66f662218, 0x2aba610a59e2f13d, -1 }, /* #95 */
};
uint32_t const g_cTests_div_u64_intel = RT_ELEMENTS(g_aTests_div_u64_intel);

MULDIVU64_TEST_T const g_aTests_idiv_u64_intel[] =
{
    { 0x125917, 0x125917, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #0 */
    { 0x2c1246, 0x2c1246, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #1 */
    { 0x390fc7, 0x390fc7, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #2 */
    { 0x221792, 0x221792, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #3 */
    { 0x2232c3, 0x2232c3, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #4 */
    { 0x232b43, 0x232b43, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #5 */
    { 0x294e82, 0x294e82, 0xb80a5cec0db45ed7, 0xb80a5cec0db45ed7, 0xd264f85785fa4f00, 0xd264f85785fa4f00, 0x0000000000000000, -1 }, /* #6 */
    { 0x000793, 0x000793, 0xd731bcd5cb269298, 0xd731bcd5cb269298, 0xf4ee6ca41647628e, 0xf4ee6ca41647628e, 0x0000000000000000, -1 }, /* #7 */
    { 0x2a0396, 0x2a0396, 0xba483de51c52b7b1, 0xba483de51c52b7b1, 0xf676d3d7d3eb7f4b, 0xf676d3d7d3eb7f4b, 0x0000000000000000, -1 }, /* #8 */
    { 0x3325d6, 0x3325d6, 0x64d7607ab75b2179, 0x64d7607ab75b2179, 0xe5b696e616741ab7, 0xe5b696e616741ab7, 0x0000000000000000, -1 }, /* #9 */
    { 0x105d06, 0x105d06, 0x845e962f80f97b59, 0x845e962f80f97b59, 0x80d005a3e5208b33, 0x80d005a3e5208b33, 0x0000000000000000, -1 }, /* #10 */
    { 0x0c3fc7, 0x0c3fc7, 0x2ab7bb4a77542ca7, 0x2ab7bb4a77542ca7, 0x7f886f3d69ced39e, 0x7f886f3d69ced39e, 0x0000000000000000, -1 }, /* #11 */
    { 0x2a4786, 0x2a4786, 0xa607607efc1bf0cc, 0xa607607efc1bf0cc, 0x88971581623a95d4, 0x88971581623a95d4, 0x08e6ed2fb5d501ee, -1 }, /* #12 */
    { 0x1a4d47, 0x1a4d47, 0xe00cbdfbea90d144, 0xe00cbdfbea90d144, 0x4660d3d8509d2c78, 0x4660d3d8509d2c78, 0xd8f313cf0cccfa17, -1 }, /* #13 */
    { 0x2a2947, 0x2a2947, 0x70efc35419829594, 0x70efc35419829594, 0xb5c144b5724380ce, 0xb5c144b5724380ce, 0x804664b183682fd5, -1 }, /* #14 */
    { 0x071e53, 0x071e53, 0x48069bb753844ff2, 0x48069bb753844ff2, 0x95dc5a678e583d3e, 0x95dc5a678e583d3e, 0xb1bc4ae940c12ce2, -1 }, /* #15 */
    { 0x1c4646, 0x1c4646, 0x89663e812e56e0d3, 0x89663e812e56e0d3, 0x89e0e9efeddb4e28, 0x89e0e9efeddb4e28, 0xe6ae15c0ea526e89, -1 }, /* #16 */
    { 0x131506, 0x131506, 0x001a8ae02cbe66a9, 0x001a8ae02cbe66a9, 0xb5cf7a7dc40c742f, 0xb5cf7a7dc40c742f, 0x53bd8b09ec18de46, -1 }, /* #17 */
    { 0x115743, 0x115743, 0x12984980f4a38c4f, 0x12984980f4a38c4f, 0xdb65433239a8ebf7, 0xdb65433239a8ebf7, 0x18e83168b11e07df, -1 }, /* #18 */
    { 0x237c46, 0x237c46, 0x9c186c47ddeca572, 0x9c186c47ddeca572, 0x9280f14965ba3538, 0x9280f14965ba3538, 0x8706baa9b885a526, -1 }, /* #19 */
    { 0x0c5787, 0x0c5787, 0x458257ce3c9f9928, 0x458257ce3c9f9928, 0x9bd876e0d838a2b6, 0x9bd876e0d838a2b6, 0xd1b21b1bd61fd17e, -1 }, /* #20 */
    { 0x3103d3, 0x3103d3, 0xb201a7dad3bf1045, 0xb201a7dad3bf1045, 0x59fb83a4e392b594, 0x59fb83a4e392b594, 0x2c87d219382d9c07, -1 }, /* #21 */
    { 0x241343, 0x241343, 0xdfc5580c775a596f, 0xdfc5580c775a596f, 0xee2da1f1225379e6, 0xee2da1f1225379e6, 0xe85eae1783a23763, -1 }, /* #22 */
    { 0x0c4a86, 0x0c4a86, 0x28c1d8420a9b77fc, 0x28c1d8420a9b77fc, 0x77221222c975dfc1, 0x77221222c975dfc1, 0xcd92cbf1b0e9efe2, -1 }, /* #23 */
    { 0x3d5ad3, 0x3d5ad3, 0x748a7a55823d80b7, 0xa69c811b29aeff41, 0xe66631dcdf2c0bf5, 0xee05bffa2e69a3d9, 0x49516e2dbddc635e, 0 }, /* #24 */
    { 0x3764d3, 0x3764d3, 0xc0bba673b9299f77, 0x53a989ebb114997b, 0xe8f8a6a88962a7b6, 0xba7ae0a97961f2c1, 0xb988b0fe34c9e142, 0 }, /* #25 */
    { 0x3037c2, 0x3037c2, 0x0391c9773c712b0f, 0x0391c9773c712b0f, 0x5e0c895571fcadb7, 0x5e0c895571fcadb7, 0x402d09a2bdc53877, -1 }, /* #26 */
    { 0x0d38d6, 0x0d38d6, 0x5e709b0228362712, 0x5e709b0228362712, 0xa943f4e170a2d2fc, 0xa943f4e170a2d2fc, 0x72318c20c443734a, -1 }, /* #27 */
    { 0x335a86, 0x335a86, 0xf850534c23677172, 0xf850534c23677172, 0xe46c4facdb6f6808, 0xe46c4facdb6f6808, 0x2ad4fc001be413a8, -1 }, /* #28 */
    { 0x235353, 0x235353, 0x837091d10e1af089, 0x837091d10e1af089, 0x9627708707d51754, 0x9627708707d51754, 0x3fbc8c21f8da9c05, -1 }, /* #29 */
    { 0x370a82, 0x370a82, 0x3dd947eeec1bc723, 0x68a3affb2daed3db, 0xdb766fb62af08fa6, 0xd38e986fd065f153, 0xa69c88985b275270, 0 }, /* #30 */
    { 0x255156, 0x255156, 0xf75d2cbaeab83391, 0x454aa5b2093f7ac9, 0x141651b12f12552f, 0x0ee6f75f06261d8a, 0x4a367668c808a24f, 0 }, /* #31 */
    { 0x0c5c07, 0x0c5c07, 0xc81947fe303482c5, 0xc81947fe303482c5, 0x8d6994e36286cab8, 0x8d6994e36286cab8, 0x733a0e10afd6e707, -1 }, /* #32 */
    { 0x015916, 0x015916, 0x0fc0b4fe81610aaa, 0x0fc0b4fe81610aaa, 0x168a9f2427e0a56f, 0x168a9f2427e0a56f, 0xe5837e16c6f0e8e4, -1 }, /* #33 */
    { 0x274e13, 0x274e13, 0x78bb74db7ba55bfb, 0xc7e8624f6ecc2c54, 0x1b11f8502a86c39f, 0x3118599e38ff2deb, 0x84743d01450fee74, 0 }, /* #34 */
    { 0x273917, 0x273917, 0x31d7a32e3151bc03, 0x31d7a32e3151bc03, 0xa0faabdcd0a11224, 0xa0faabdcd0a11224, 0x066989ccb4c6617b, -1 }, /* #35 */
    { 0x216046, 0x216046, 0x4153766c88d16cdb, 0x5c986d4e18245b5f, 0x2b88c5946c8fb834, 0x5fa50d7b7f226edb, 0x785c1ff90a2fc200, 0 }, /* #36 */
    { 0x0948d7, 0x0948d7, 0xf6fca1a30133c690, 0xf6fca1a30133c690, 0x49ab1297b29e53e4, 0x49ab1297b29e53e4, 0x64589b5cb45b1aa8, -1 }, /* #37 */
    { 0x1c5847, 0x1c5847, 0x5c671b0cbfc5741f, 0x5c671b0cbfc5741f, 0x2113e81e4152d698, 0x2113e81e4152d698, 0x13734e46155504aa, -1 }, /* #38 */
    { 0x1b1047, 0x1b1047, 0x82d3520104096347, 0xb8d1f17e397164d7, 0x133191ce9633ae45, 0x16d15a17f311b826, 0xbaf83f176aaef8c7, 0 }, /* #39 */
    { 0x145642, 0x145642, 0x3e7e55501fc4dd5e, 0x3e7e55501fc4dd5e, 0x82ea338c18ccd161, 0x82ea338c18ccd161, 0x75ded3bbe167f1c7, -1 }, /* #40 */
    { 0x354bd3, 0x354bd3, 0x3be06eee3edb3116, 0x0702e41c385b5527, 0x037ad5e2d90ebe9a, 0x11f374282f06b7c2, 0x7f0ea6a4414fd88c, 0 }, /* #41 */
    { 0x3a5782, 0x3a5782, 0x553a718ad8a64b8f, 0x553a718ad8a64b8f, 0x5c755f30f81b1881, 0x5c755f30f81b1881, 0xf9ca44891a009fcc, -1 }, /* #42 */
    { 0x295253, 0x295253, 0x65abb7aa92ae0025, 0x65abb7aa92ae0025, 0x3d2ce90f5a7a19ba, 0x3d2ce90f5a7a19ba, 0x3a57869067fcf064, -1 }, /* #43 */
    { 0x1e3593, 0x1e3593, 0x4bb246116d85a2f1, 0x4bb246116d85a2f1, 0xb2e87d8d6f112481, 0xb2e87d8d6f112481, 0xe055425a7f42a17f, -1 }, /* #44 */
    { 0x190803, 0x190803, 0x9bdaadfb85497067, 0xce1292b4aa008dc1, 0x1639f3733edaa33f, 0x2ed26a1bd785907a, 0x8e091e1ce6d2352d, 0 }, /* #45 */
    { 0x3f41c7, 0x3f41c7, 0x1b237feb86a78857, 0x1b237feb86a78857, 0xb1fc41179b1ebb48, 0xb1fc41179b1ebb48, 0xee260221fb1c4afa, -1 }, /* #46 */
    { 0x0e7f12, 0x0e7f12, 0x71be3074b07e93d0, 0xc46b10aae6605ddd, 0xf61a2b4f7bb053e1, 0xed2a9ca7bda67baf, 0x2a86e5b8fb082915, 0 }, /* #47 */
    { 0x2412d3, 0x2412d3, 0x7563339030cb4dfd, 0x237578674a9a3af1, 0xeea790a7c45c72cd, 0xc5f6a62449d76a9f, 0x82c5b10548916d3e, 0 }, /* #48 */
    { 0x154056, 0x154056, 0x22f8066dd4f11ec1, 0x22f8066dd4f11ec1, 0xa165e9da456cca0e, 0xa165e9da456cca0e, 0x284559e063ca06db, -1 }, /* #49 */
    { 0x156592, 0x156592, 0x574e077b7ab0fa79, 0x574e077b7ab0fa79, 0x4e730acb084a1840, 0x4e730acb084a1840, 0x500b3c2e0a962d52, -1 }, /* #50 */
    { 0x000456, 0x000456, 0x3dd9b8ab8919b16c, 0x3dd9b8ab8919b16c, 0x4f3dbbabde82e39c, 0x4f3dbbabde82e39c, 0x6fcb4745a3ccef81, -1 }, /* #51 */
    { 0x1f6942, 0x1f6942, 0xdc8c88a77af240a0, 0xdc8c88a77af240a0, 0x64c53252b712e0b4, 0x64c53252b712e0b4, 0x6652058e35a0b3f5, -1 }, /* #52 */
    { 0x1168d2, 0x1168d2, 0x1eda25e3ac3257cd, 0x1eda25e3ac3257cd, 0x77363a9155fafb30, 0x77363a9155fafb30, 0x5504f276153435d2, -1 }, /* #53 */
    { 0x024bd3, 0x024bd3, 0x0ba6db72e7bd26c9, 0x0ba6db72e7bd26c9, 0xc1bb2362adaa610e, 0xc1bb2362adaa610e, 0xc9fa469be0c907e4, -1 }, /* #54 */
    { 0x115006, 0x115006, 0x509325a3962c2ecb, 0x509325a3962c2ecb, 0x90fc99cf4636e2d9, 0x90fc99cf4636e2d9, 0xcc9e2417c128a101, -1 }, /* #55 */
    { 0x174f83, 0x174f83, 0xadc2dec81ba607ad, 0xadc2dec81ba607ad, 0xc96ef19b8e049220, 0xc96ef19b8e049220, 0xb8646bed97bd3a09, -1 }, /* #56 */
    { 0x0c3057, 0x0c3057, 0xa4729e72d312bf04, 0xa4729e72d312bf04, 0x0f96c80fd50ab518, 0x0f96c80fd50ab518, 0xec38ff38fec42280, -1 }, /* #57 */
    { 0x313843, 0x313843, 0xeb447c81cef358db, 0x0c24425d575bece3, 0xfc51ba4428e57793, 0xc736a9f6f7ff7197, 0xb264af7c2cc142ec, 0 }, /* #58 */
    { 0x2b6216, 0x2b6216, 0x76664e803ff49ebc, 0x8d43d742a6ca834d, 0xcfb14fcb614370c8, 0xe83561b131089cc7, 0x6bc8e87215e45549, 0 }, /* #59 */
    { 0x0a0002, 0x0a0002, 0x6dc377c99ae5b6a3, 0x6dc377c99ae5b6a3, 0xaa94aebc1fc961df, 0xaa94aebc1fc961df, 0xec14519535ede972, -1 }, /* #60 */
    { 0x1a78c3, 0x1a78c3, 0x2feba4e7851e06e6, 0x2feba4e7851e06e6, 0x9647462940c1a2a3, 0x9647462940c1a2a3, 0x1cea54f80d7f4ccb, -1 }, /* #61 */
    { 0x203c16, 0x203c16, 0x5b8619218f54c411, 0xa99ddf904235575b, 0x1a71a20a1ece2cc6, 0x11c1b83d2095512a, 0xb1a1f3c60558b465, 0 }, /* #62 */
    { 0x201907, 0x201907, 0xb6b4f8c0ae405455, 0xb6b4f8c0ae405455, 0x7bbd3206e77c56ab, 0x7bbd3206e77c56ab, 0xddbf674f8516a344, -1 }, /* #63 */
    { 0x1a69c6, 0x1a69c6, 0x9dd169f7b915d04e, 0x9dd169f7b915d04e, 0x2d1fa9cc8846948a, 0x2d1fa9cc8846948a, 0x3731921875ce56b8, -1 }, /* #64 */
    { 0x240152, 0x240152, 0x23611cc2f1651beb, 0x23611cc2f1651beb, 0xadfe68ff26f01af9, 0xadfe68ff26f01af9, 0xa3eaa0144ab623ae, -1 }, /* #65 */
    { 0x2c3886, 0x2c3886, 0xb273629c48daf558, 0xb273629c48daf558, 0x89f1215e6ee1d7eb, 0x89f1215e6ee1d7eb, 0x1bf603e1a4242cfd, -1 }, /* #66 */
    { 0x2e5b42, 0x2e5b42, 0x6c8d596997358a3b, 0x6c8d596997358a3b, 0x3526be7cd11f5a81, 0x3526be7cd11f5a81, 0xc28107351906b930, -1 }, /* #67 */
    { 0x185147, 0x185147, 0xf9a505f3a0678f52, 0x28666a4c04e8e2bd, 0x10dc5706f6e6a4af, 0x4e34d50be158f1ba, 0x6ad7065789ad7978, 0 }, /* #68 */
    { 0x2f24c6, 0x2f24c6, 0x1ae41402102b868d, 0x41e37ea18f2222f1, 0xefc35bee049ccfda, 0xfeff6fc26354cbaa, 0xc0ea0662679a5313, 0 }, /* #69 */
    { 0x315242, 0x315242, 0x0bf0b81ea59f812e, 0x0bf0b81ea59f812e, 0xb3b1f8cc12842a66, 0xb3b1f8cc12842a66, 0x3a78fb0addf056e8, -1 }, /* #70 */
    { 0x055c57, 0x055c57, 0x6e26810c9584260c, 0x6e26810c9584260c, 0x887a6af1bc74ea93, 0x887a6af1bc74ea93, 0xd4b1b52322c52b50, -1 }, /* #71 */
    { 0x292b52, 0x292b52, 0xe61e9ecb0d692ceb, 0xe61e9ecb0d692ceb, 0xc239a4c99d6f29be, 0xc239a4c99d6f29be, 0x63d2f92812c82e1c, -1 }, /* #72 */
    { 0x2a7543, 0x2a7543, 0x4a35186c71690e5e, 0x95c2542f0aa8fa3a, 0x31c3e7c729e5d4d7, 0x09333ed6442d4d34, 0x8815b197ee0dafd9, 0 }, /* #73 */
    { 0x165e86, 0x165e86, 0xb78736295ed26d96, 0xba4008785a50630b, 0xe63ce0791a8d04cf, 0xc0e656d27eb0a0f5, 0x5e8dcd2fd2d01a83, 0 }, /* #74 */
    { 0x253ac2, 0x253ac2, 0xd5e809da34ca33e2, 0xd5e809da34ca33e2, 0x75cf7ca5d034aa58, 0x75cf7ca5d034aa58, 0x67efc5b404878e54, -1 }, /* #75 */
    { 0x124103, 0x124103, 0xea020249ee59aa16, 0xea020249ee59aa16, 0x1d102242bbdf0dcd, 0x1d102242bbdf0dcd, 0xeb221c5832ac13e8, -1 }, /* #76 */
    { 0x277fd3, 0x277fd3, 0xc0501b12145d41aa, 0xc0501b12145d41aa, 0x9a3988ea3e75c717, 0x9a3988ea3e75c717, 0xee6c23e8c6f8ff7e, -1 }, /* #77 */
    { 0x3c31d7, 0x3c31d7, 0x26a40f8665387eb4, 0x26a40f8665387eb4, 0x537b786a5d774b6c, 0x537b786a5d774b6c, 0xb75545b76a43a191, -1 }, /* #78 */
    { 0x162383, 0x162383, 0x39a1d1221eea2e5c, 0x221bac64491d994b, 0xf9deab0dc203af38, 0xde08993089128404, 0xd1fd4db7b1d4a008, 0 }, /* #79 */
    { 0x323fc6, 0x323fc6, 0x245dd320f17e7341, 0x245dd320f17e7341, 0x79bbc19ba9fc1121, 0x79bbc19ba9fc1121, 0xe32448ddea537112, -1 }, /* #80 */
    { 0x0c5f43, 0x0c5f43, 0x883e070eacaaf930, 0x883e070eacaaf930, 0xa1b4373366fbd283, 0xa1b4373366fbd283, 0x4ae27ce8751efcb7, -1 }, /* #81 */
    { 0x197792, 0x197792, 0xa1ee0a83d131aa25, 0xa1ee0a83d131aa25, 0x5d27b37182ae87c1, 0x5d27b37182ae87c1, 0xe68a9a88347084ba, -1 }, /* #82 */
    { 0x0e2c96, 0x0e2c96, 0x23817a1af3e25313, 0x23817a1af3e25313, 0x263ccf171f3213dc, 0x263ccf171f3213dc, 0x085fafd8e6ab2a46, -1 }, /* #83 */
    { 0x2a6b57, 0x2a6b57, 0x4688fbad98944db9, 0x4688fbad98944db9, 0xb79469b540f65bc9, 0xb79469b540f65bc9, 0xd6e8c22c031610dd, -1 }, /* #84 */
    { 0x346542, 0x346542, 0xf4eb1c97a9ad4f99, 0xf4eb1c97a9ad4f99, 0x6346696e1f6ae2f5, 0x6346696e1f6ae2f5, 0xb9a689ede06f97cb, -1 }, /* #85 */
    { 0x122ac6, 0x122ac6, 0x183534d68a3207e2, 0x56e83ba4fb1858e9, 0x0f59fb69fb01ed77, 0x2b573b49a5550b3d, 0x2d38705081f1305d, 0 }, /* #86 */
    { 0x262cd6, 0x262cd6, 0x83d82dc7bab817e2, 0xd5a109516e4f56c1, 0xef812194bab69c0b, 0xb85b82bcd2322548, 0x63aa0bd8b70ae31a, 0 }, /* #87 */
    { 0x0566d2, 0x0566d2, 0x48746ecd80b8f0a9, 0x48746ecd80b8f0a9, 0x734cee897b10ade7, 0x734cee897b10ade7, 0x93ad32a2870ef06e, -1 }, /* #88 */
    { 0x033217, 0x033217, 0x8e9a0a6552a21c69, 0x52170c9048756793, 0xf169fa38994368c1, 0xd45e3fa002b41533, 0xd2835973a46fd1b2, 0 }, /* #89 */
    { 0x1314c3, 0x1314c3, 0x4ff4715b3ed92759, 0x730b5bd6c7793b1a, 0xf48e6884fe454a69, 0xf47dbdb3986c5955, 0xe688fd424b129d8a, 0 }, /* #90 */
    { 0x233ed6, 0x233ed6, 0xc499d5148b5eb0df, 0xa46f734fb4a0c136, 0x274141c57c56bc97, 0x38c00f4fc1b112d1, 0x923fe58f892f8405, 0 }, /* #91 */
    { 0x214f06, 0x214f06, 0xdb54b95faae1677d, 0xbb845489bd4ffe40, 0xdfc44b87347ef549, 0x958e5842173683fd, 0x787e1b0732bc677e, 0 }, /* #92 */
    { 0x0a5c47, 0x0a5c47, 0x733d65497e2d5afa, 0x733d65497e2d5afa, 0xdbb400ebbaffdb54, 0xdbb400ebbaffdb54, 0xd33cb5db6461d62b, -1 }, /* #93 */
    { 0x3e4946, 0x3e4946, 0xbd725496fbe9e44b, 0xbd725496fbe9e44b, 0x44974734dff5bfc0, 0x44974734dff5bfc0, 0x3fa8d2015a9a542d, -1 }, /* #94 */
    { 0x137fc2, 0x137fc2, 0xf41171d2b1f5c89a, 0xf41171d2b1f5c89a, 0xc5fde016f2129f16, 0xc5fde016f2129f16, 0xa9d91c55ba42a754, -1 }, /* #95 */
};
uint32_t const g_cTests_idiv_u64_intel = RT_ELEMENTS(g_aTests_idiv_u64_intel);


/* end of file */
