/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.sdklib.internal.repository.sources;

import com.android.sdklib.repository.IDescription;


/**
 * The category of a given {@link SdkSource} (which represents a download site).
 *
 * @deprecated
 * com.android.sdklib.internal.repository has moved into Studio as
 * com.android.tools.idea.sdk.remote.internal.
 */
@Deprecated
public enum SdkSourceCategory implements IDescription {

    /**
     * The default canonical and official Android repository.
     */
    ANDROID_REPO("Android Repository", true),

    /**
     * Repositories contributed by the SDK_UPDATER_URLS env var,
     * only used for local debugging.
     */
    GETENV_REPOS("Custom Repositories", false),

    /**
     * All third-party add-ons fetched from the Android repository.
     */
    ADDONS_3RD_PARTY("Third party Add-ons", true),

    /**
     * All add-ons contributed locally by the user via the "Add Add-on Site" button.
     */
    USER_ADDONS("User Add-ons", false),

    /**
     * Add-ons contributed by the SDK_UPDATER_USER_URLS env var,
     * only used for local debugging.
     */
    GETENV_ADDONS("Custom Add-ons", false);


    private final String mUiName;
    private final boolean mAlwaysDisplay;

    SdkSourceCategory(String uiName, boolean alwaysDisplay) {
        mUiName = uiName;
        mAlwaysDisplay = alwaysDisplay;
    }

    /**
     * Returns the UI-visible name of the category. Displayed in the available package tree.
     * Cannot be null nor empty.
     */
    public String getUiName() {
        return mUiName;
    }

    /**
     * True if this category must always be displayed by the available package tree, even
     * if empty.
     * When false, the category must not be displayed when empty.
     */
    public boolean getAlwaysDisplay() {
        return mAlwaysDisplay;
    }

    @Override
    public String getLongDescription() {
        return getUiName();
    }

    @Override
    public String getShortDescription() {
        return getUiName();
    }
}
