/*
 * Copyright (c) 2015-2021, STMicroelectronics - All Rights Reserved
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef STM32MP1_RCC_H
#define STM32MP1_RCC_H

#include <lib/utils_def.h>

#define RCC_TZCR				U(0x00)
#define RCC_OCENSETR				U(0x0C)
#define RCC_OCENCLRR				U(0x10)
#define RCC_HSICFGR				U(0x18)
#define RCC_CSICFGR				U(0x1C)
#define RCC_MPCKSELR				U(0x20)
#define RCC_ASSCKSELR				U(0x24)
#define RCC_RCK12SELR				U(0x28)
#define RCC_MPCKDIVR				U(0x2C)
#define RCC_AXIDIVR				U(0x30)
#define RCC_APB4DIVR				U(0x3C)
#define RCC_APB5DIVR				U(0x40)
#define RCC_RTCDIVR				U(0x44)
#define RCC_MSSCKSELR				U(0x48)
#define RCC_PLL1CR				U(0x80)
#define RCC_PLL1CFGR1				U(0x84)
#define RCC_PLL1CFGR2				U(0x88)
#define RCC_PLL1FRACR				U(0x8C)
#define RCC_PLL1CSGR				U(0x90)
#define RCC_PLL2CR				U(0x94)
#define RCC_PLL2CFGR1				U(0x98)
#define RCC_PLL2CFGR2				U(0x9C)
#define RCC_PLL2FRACR				U(0xA0)
#define RCC_PLL2CSGR				U(0xA4)
#define RCC_I2C46CKSELR				U(0xC0)
#define RCC_SPI6CKSELR				U(0xC4)
#define RCC_UART1CKSELR				U(0xC8)
#define RCC_RNG1CKSELR				U(0xCC)
#define RCC_CPERCKSELR				U(0xD0)
#define RCC_STGENCKSELR				U(0xD4)
#define RCC_DDRITFCR				U(0xD8)
#define RCC_MP_BOOTCR				U(0x100)
#define RCC_MP_SREQSETR				U(0x104)
#define RCC_MP_SREQCLRR				U(0x108)
#define RCC_MP_GCR				U(0x10C)
#define RCC_MP_APRSTCR				U(0x110)
#define RCC_MP_APRSTSR				U(0x114)
#define RCC_BDCR				U(0x140)
#define RCC_RDLSICR				U(0x144)
#define RCC_APB4RSTSETR				U(0x180)
#define RCC_APB4RSTCLRR				U(0x184)
#define RCC_APB5RSTSETR				U(0x188)
#define RCC_APB5RSTCLRR				U(0x18C)
#define RCC_AHB5RSTSETR				U(0x190)
#define RCC_AHB5RSTCLRR				U(0x194)
#define RCC_AHB6RSTSETR				U(0x198)
#define RCC_AHB6RSTCLRR				U(0x19C)
#define RCC_TZAHB6RSTSETR			U(0x1A0)
#define RCC_TZAHB6RSTCLRR			U(0x1A4)
#define RCC_MP_APB4ENSETR			U(0x200)
#define RCC_MP_APB4ENCLRR			U(0x204)
#define RCC_MP_APB5ENSETR			U(0x208)
#define RCC_MP_APB5ENCLRR			U(0x20C)
#define RCC_MP_AHB5ENSETR			U(0x210)
#define RCC_MP_AHB5ENCLRR			U(0x214)
#define RCC_MP_AHB6ENSETR			U(0x218)
#define RCC_MP_AHB6ENCLRR			U(0x21C)
#define RCC_MP_TZAHB6ENSETR			U(0x220)
#define RCC_MP_TZAHB6ENCLRR			U(0x224)
#define RCC_MC_APB4ENSETR			U(0x280)
#define RCC_MC_APB4ENCLRR			U(0x284)
#define RCC_MC_APB5ENSETR			U(0x288)
#define RCC_MC_APB5ENCLRR			U(0x28C)
#define RCC_MC_AHB5ENSETR			U(0x290)
#define RCC_MC_AHB5ENCLRR			U(0x294)
#define RCC_MC_AHB6ENSETR			U(0x298)
#define RCC_MC_AHB6ENCLRR			U(0x29C)
#define RCC_MP_APB4LPENSETR			U(0x300)
#define RCC_MP_APB4LPENCLRR			U(0x304)
#define RCC_MP_APB5LPENSETR			U(0x308)
#define RCC_MP_APB5LPENCLRR			U(0x30C)
#define RCC_MP_AHB5LPENSETR			U(0x310)
#define RCC_MP_AHB5LPENCLRR			U(0x314)
#define RCC_MP_AHB6LPENSETR			U(0x318)
#define RCC_MP_AHB6LPENCLRR			U(0x31C)
#define RCC_MP_TZAHB6LPENSETR			U(0x320)
#define RCC_MP_TZAHB6LPENCLRR			U(0x324)
#define RCC_MC_APB4LPENSETR			U(0x380)
#define RCC_MC_APB4LPENCLRR			U(0x384)
#define RCC_MC_APB5LPENSETR			U(0x388)
#define RCC_MC_APB5LPENCLRR			U(0x38C)
#define RCC_MC_AHB5LPENSETR			U(0x390)
#define RCC_MC_AHB5LPENCLRR			U(0x394)
#define RCC_MC_AHB6LPENSETR			U(0x398)
#define RCC_MC_AHB6LPENCLRR			U(0x39C)
#define RCC_BR_RSTSCLRR				U(0x400)
#define RCC_MP_GRSTCSETR			U(0x404)
#define RCC_MP_RSTSCLRR				U(0x408)
#define RCC_MP_IWDGFZSETR			U(0x40C)
#define RCC_MP_IWDGFZCLRR			U(0x410)
#define RCC_MP_CIER				U(0x414)
#define RCC_MP_CIFR				U(0x418)
#define RCC_PWRLPDLYCR				U(0x41C)
#define RCC_MP_RSTSSETR				U(0x420)
#define RCC_MCO1CFGR				U(0x800)
#define RCC_MCO2CFGR				U(0x804)
#define RCC_OCRDYR				U(0x808)
#define RCC_DBGCFGR				U(0x80C)
#define RCC_RCK3SELR				U(0x820)
#define RCC_RCK4SELR				U(0x824)
#define RCC_TIMG1PRER				U(0x828)
#define RCC_TIMG2PRER				U(0x82C)
#define RCC_MCUDIVR				U(0x830)
#define RCC_APB1DIVR				U(0x834)
#define RCC_APB2DIVR				U(0x838)
#define RCC_APB3DIVR				U(0x83C)
#define RCC_PLL3CR				U(0x880)
#define RCC_PLL3CFGR1				U(0x884)
#define RCC_PLL3CFGR2				U(0x888)
#define RCC_PLL3FRACR				U(0x88C)
#define RCC_PLL3CSGR				U(0x890)
#define RCC_PLL4CR				U(0x894)
#define RCC_PLL4CFGR1				U(0x898)
#define RCC_PLL4CFGR2				U(0x89C)
#define RCC_PLL4FRACR				U(0x8A0)
#define RCC_PLL4CSGR				U(0x8A4)
#define RCC_I2C12CKSELR				U(0x8C0)
#define RCC_I2C35CKSELR				U(0x8C4)
#define RCC_SAI1CKSELR				U(0x8C8)
#define RCC_SAI2CKSELR				U(0x8CC)
#define RCC_SAI3CKSELR				U(0x8D0)
#define RCC_SAI4CKSELR				U(0x8D4)
#define RCC_SPI2S1CKSELR			U(0x8D8)
#define RCC_SPI2S23CKSELR			U(0x8DC)
#define RCC_SPI45CKSELR				U(0x8E0)
#define RCC_UART6CKSELR				U(0x8E4)
#define RCC_UART24CKSELR			U(0x8E8)
#define RCC_UART35CKSELR			U(0x8EC)
#define RCC_UART78CKSELR			U(0x8F0)
#define RCC_SDMMC12CKSELR			U(0x8F4)
#define RCC_SDMMC3CKSELR			U(0x8F8)
#define RCC_ETHCKSELR				U(0x8FC)
#define RCC_QSPICKSELR				U(0x900)
#define RCC_FMCCKSELR				U(0x904)
#define RCC_FDCANCKSELR				U(0x90C)
#define RCC_SPDIFCKSELR				U(0x914)
#define RCC_CECCKSELR				U(0x918)
#define RCC_USBCKSELR				U(0x91C)
#define RCC_RNG2CKSELR				U(0x920)
#define RCC_DSICKSELR				U(0x924)
#define RCC_ADCCKSELR				U(0x928)
#define RCC_LPTIM45CKSELR			U(0x92C)
#define RCC_LPTIM23CKSELR			U(0x930)
#define RCC_LPTIM1CKSELR			U(0x934)
#define RCC_APB1RSTSETR				U(0x980)
#define RCC_APB1RSTCLRR				U(0x984)
#define RCC_APB2RSTSETR				U(0x988)
#define RCC_APB2RSTCLRR				U(0x98C)
#define RCC_APB3RSTSETR				U(0x990)
#define RCC_APB3RSTCLRR				U(0x994)
#define RCC_AHB2RSTSETR				U(0x998)
#define RCC_AHB2RSTCLRR				U(0x99C)
#define RCC_AHB3RSTSETR				U(0x9A0)
#define RCC_AHB3RSTCLRR				U(0x9A4)
#define RCC_AHB4RSTSETR				U(0x9A8)
#define RCC_AHB4RSTCLRR				U(0x9AC)
#define RCC_MP_APB1ENSETR			U(0xA00)
#define RCC_MP_APB1ENCLRR			U(0xA04)
#define RCC_MP_APB2ENSETR			U(0xA08)
#define RCC_MP_APB2ENCLRR			U(0xA0C)
#define RCC_MP_APB3ENSETR			U(0xA10)
#define RCC_MP_APB3ENCLRR			U(0xA14)
#define RCC_MP_AHB2ENSETR			U(0xA18)
#define RCC_MP_AHB2ENCLRR			U(0xA1C)
#define RCC_MP_AHB3ENSETR			U(0xA20)
#define RCC_MP_AHB3ENCLRR			U(0xA24)
#define RCC_MP_AHB4ENSETR			U(0xA28)
#define RCC_MP_AHB4ENCLRR			U(0xA2C)
#define RCC_MP_MLAHBENSETR			U(0xA38)
#define RCC_MP_MLAHBENCLRR			U(0xA3C)
#define RCC_MC_APB1ENSETR			U(0xA80)
#define RCC_MC_APB1ENCLRR			U(0xA84)
#define RCC_MC_APB2ENSETR			U(0xA88)
#define RCC_MC_APB2ENCLRR			U(0xA8C)
#define RCC_MC_APB3ENSETR			U(0xA90)
#define RCC_MC_APB3ENCLRR			U(0xA94)
#define RCC_MC_AHB2ENSETR			U(0xA98)
#define RCC_MC_AHB2ENCLRR			U(0xA9C)
#define RCC_MC_AHB3ENSETR			U(0xAA0)
#define RCC_MC_AHB3ENCLRR			U(0xAA4)
#define RCC_MC_AHB4ENSETR			U(0xAA8)
#define RCC_MC_AHB4ENCLRR			U(0xAAC)
#define RCC_MC_AXIMENSETR			U(0xAB0)
#define RCC_MC_AXIMENCLRR			U(0xAB4)
#define RCC_MC_MLAHBENSETR			U(0xAB8)
#define RCC_MC_MLAHBENCLRR			U(0xABC)
#define RCC_MP_APB1LPENSETR			U(0xB00)
#define RCC_MP_APB1LPENCLRR			U(0xB04)
#define RCC_MP_APB2LPENSETR			U(0xB08)
#define RCC_MP_APB2LPENCLRR			U(0xB0C)
#define RCC_MP_APB3LPENSETR			U(0xB10)
#define RCC_MP_APB3LPENCLRR			U(0xB14)
#define RCC_MP_AHB2LPENSETR			U(0xB18)
#define RCC_MP_AHB2LPENCLRR			U(0xB1C)
#define RCC_MP_AHB3LPENSETR			U(0xB20)
#define RCC_MP_AHB3LPENCLRR			U(0xB24)
#define RCC_MP_AHB4LPENSETR			U(0xB28)
#define RCC_MP_AHB4LPENCLRR			U(0xB2C)
#define RCC_MP_AXIMLPENSETR			U(0xB30)
#define RCC_MP_AXIMLPENCLRR			U(0xB34)
#define RCC_MP_MLAHBLPENSETR			U(0xB38)
#define RCC_MP_MLAHBLPENCLRR			U(0xB3C)
#define RCC_MC_APB1LPENSETR			U(0xB80)
#define RCC_MC_APB1LPENCLRR			U(0xB84)
#define RCC_MC_APB2LPENSETR			U(0xB88)
#define RCC_MC_APB2LPENCLRR			U(0xB8C)
#define RCC_MC_APB3LPENSETR			U(0xB90)
#define RCC_MC_APB3LPENCLRR			U(0xB94)
#define RCC_MC_AHB2LPENSETR			U(0xB98)
#define RCC_MC_AHB2LPENCLRR			U(0xB9C)
#define RCC_MC_AHB3LPENSETR			U(0xBA0)
#define RCC_MC_AHB3LPENCLRR			U(0xBA4)
#define RCC_MC_AHB4LPENSETR			U(0xBA8)
#define RCC_MC_AHB4LPENCLRR			U(0xBAC)
#define RCC_MC_AXIMLPENSETR			U(0xBB0)
#define RCC_MC_AXIMLPENCLRR			U(0xBB4)
#define RCC_MC_MLAHBLPENSETR			U(0xBB8)
#define RCC_MC_MLAHBLPENCLRR			U(0xBBC)
#define RCC_MC_RSTSCLRR				U(0xC00)
#define RCC_MC_CIER				U(0xC14)
#define RCC_MC_CIFR				U(0xC18)
#define RCC_VERR				U(0xFF4)
#define RCC_IDR					U(0xFF8)
#define RCC_SIDR				U(0xFFC)

/* RCC_TZCR register fields */
#define RCC_TZCR_TZEN				BIT(0)
#define RCC_TZCR_MCKPROT			BIT(1)

/* RCC_OCENSETR register fields */
#define RCC_OCENSETR_HSION			BIT(0)
#define RCC_OCENSETR_HSIKERON			BIT(1)
#define RCC_OCENSETR_CSION			BIT(4)
#define RCC_OCENSETR_CSIKERON			BIT(5)
#define RCC_OCENSETR_DIGBYP			BIT(7)
#define RCC_OCENSETR_HSEON			BIT(8)
#define RCC_OCENSETR_HSEKERON			BIT(9)
#define RCC_OCENSETR_HSEBYP			BIT(10)
#define RCC_OCENSETR_HSECSSON			BIT(11)

/* RCC_OCENCLRR register fields */
#define RCC_OCENCLRR_HSION			BIT(0)
#define RCC_OCENCLRR_HSIKERON			BIT(1)
#define RCC_OCENCLRR_CSION			BIT(4)
#define RCC_OCENCLRR_CSIKERON			BIT(5)
#define RCC_OCENCLRR_DIGBYP			BIT(7)
#define RCC_OCENCLRR_HSEON			BIT(8)
#define RCC_OCENCLRR_HSEKERON			BIT(9)
#define RCC_OCENCLRR_HSEBYP			BIT(10)

/* RCC_HSICFGR register fields */
#define RCC_HSICFGR_HSIDIV_MASK			GENMASK(1, 0)
#define RCC_HSICFGR_HSIDIV_SHIFT		0
#define RCC_HSICFGR_HSITRIM_MASK		GENMASK(14, 8)
#define RCC_HSICFGR_HSITRIM_SHIFT		8
#define RCC_HSICFGR_HSICAL_MASK			GENMASK(24, 16)
#define RCC_HSICFGR_HSICAL_SHIFT		16
#define RCC_HSICFGR_HSICAL_TEMP_MASK		GENMASK(27, 25)

/* RCC_CSICFGR register fields */
#define RCC_CSICFGR_CSITRIM_MASK		GENMASK(12, 8)
#define RCC_CSICFGR_CSITRIM_SHIFT		8
#define RCC_CSICFGR_CSICAL_MASK			GENMASK(23, 16)
#define RCC_CSICFGR_CSICAL_SHIFT		16

/* RCC_MPCKSELR register fields */
#define RCC_MPCKSELR_HSI			0x00000000
#define RCC_MPCKSELR_HSE			0x00000001
#define RCC_MPCKSELR_PLL			0x00000002
#define RCC_MPCKSELR_PLL_MPUDIV			0x00000003
#define RCC_MPCKSELR_MPUSRC_MASK		GENMASK(1, 0)
#define RCC_MPCKSELR_MPUSRC_SHIFT		0
#define RCC_MPCKSELR_MPUSRCRDY			BIT(31)

/* RCC_ASSCKSELR register fields */
#define RCC_ASSCKSELR_HSI			0x00000000
#define RCC_ASSCKSELR_HSE			0x00000001
#define RCC_ASSCKSELR_PLL			0x00000002
#define RCC_ASSCKSELR_AXISSRC_MASK		GENMASK(2, 0)
#define RCC_ASSCKSELR_AXISSRC_SHIFT		0
#define RCC_ASSCKSELR_AXISSRCRDY		BIT(31)

/* RCC_RCK12SELR register fields */
#define RCC_RCK12SELR_PLL12SRC_MASK		GENMASK(1, 0)
#define RCC_RCK12SELR_PLL12SRC_SHIFT		0
#define RCC_RCK12SELR_PLL12SRCRDY		BIT(31)

/* RCC_MPCKDIVR register fields */
#define RCC_MPCKDIVR_MPUDIV_MASK		GENMASK(2, 0)
#define RCC_MPCKDIVR_MPUDIV_SHIFT		0
#define RCC_MPCKDIVR_MPUDIVRDY			BIT(31)

/* RCC_AXIDIVR register fields */
#define RCC_AXIDIVR_AXIDIV_MASK			GENMASK(2, 0)
#define RCC_AXIDIVR_AXIDIV_SHIFT		0
#define RCC_AXIDIVR_AXIDIVRDY			BIT(31)

/* RCC_APB4DIVR register fields */
#define RCC_APB4DIVR_APB4DIV_MASK		GENMASK(2, 0)
#define RCC_APB4DIVR_APB4DIV_SHIFT		0
#define RCC_APB4DIVR_APB4DIVRDY			BIT(31)

/* RCC_APB5DIVR register fields */
#define RCC_APB5DIVR_APB5DIV_MASK		GENMASK(2, 0)
#define RCC_APB5DIVR_APB5DIV_SHIFT		0
#define RCC_APB5DIVR_APB5DIVRDY			BIT(31)

/* RCC_RTCDIVR register fields */
#define RCC_RTCDIVR_RTCDIV_MASK			GENMASK(5, 0)
#define RCC_RTCDIVR_RTCDIV_SHIFT		0

/* RCC_MSSCKSELR register fields */
#define RCC_MSSCKSELR_HSI			0x00000000
#define RCC_MSSCKSELR_HSE			0x00000001
#define RCC_MSSCKSELR_CSI			0x00000002
#define RCC_MSSCKSELR_PLL			0x00000003
#define RCC_MSSCKSELR_MCUSSRC_MASK		GENMASK(1, 0)
#define RCC_MSSCKSELR_MCUSSRC_SHIFT		0
#define RCC_MSSCKSELR_MCUSSRCRDY		BIT(31)

/* RCC_PLL1CR register fields */
#define RCC_PLL1CR_PLLON			BIT(0)
#define RCC_PLL1CR_PLL1RDY			BIT(1)
#define RCC_PLL1CR_SSCG_CTRL			BIT(2)
#define RCC_PLL1CR_DIVPEN			BIT(4)
#define RCC_PLL1CR_DIVQEN			BIT(5)
#define RCC_PLL1CR_DIVREN			BIT(6)

/* RCC_PLL1CFGR1 register fields */
#define RCC_PLL1CFGR1_DIVN_MASK			GENMASK(8, 0)
#define RCC_PLL1CFGR1_DIVN_SHIFT		0
#define RCC_PLL1CFGR1_DIVM1_MASK		GENMASK(21, 16)
#define RCC_PLL1CFGR1_DIVM1_SHIFT		16

/* RCC_PLL1CFGR2 register fields */
#define RCC_PLL1CFGR2_DIVP_MASK			GENMASK(6, 0)
#define RCC_PLL1CFGR2_DIVP_SHIFT		0
#define RCC_PLL1CFGR2_DIVQ_MASK			GENMASK(14, 8)
#define RCC_PLL1CFGR2_DIVQ_SHIFT		8
#define RCC_PLL1CFGR2_DIVR_MASK			GENMASK(22, 16)
#define RCC_PLL1CFGR2_DIVR_SHIFT		16

/* RCC_PLL1FRACR register fields */
#define RCC_PLL1FRACR_FRACV_MASK		GENMASK(15, 3)
#define RCC_PLL1FRACR_FRACV_SHIFT		3
#define RCC_PLL1FRACR_FRACLE			BIT(16)

/* RCC_PLL1CSGR register fields */
#define RCC_PLL1CSGR_MOD_PER_MASK		GENMASK(12, 0)
#define RCC_PLL1CSGR_MOD_PER_SHIFT		0
#define RCC_PLL1CSGR_TPDFN_DIS			BIT(13)
#define RCC_PLL1CSGR_RPDFN_DIS			BIT(14)
#define RCC_PLL1CSGR_SSCG_MODE			BIT(15)
#define RCC_PLL1CSGR_INC_STEP_MASK		GENMASK(30, 16)
#define RCC_PLL1CSGR_INC_STEP_SHIFT		16

/* RCC_PLL2CR register fields */
#define RCC_PLL2CR_PLLON			BIT(0)
#define RCC_PLL2CR_PLL2RDY			BIT(1)
#define RCC_PLL2CR_SSCG_CTRL			BIT(2)
#define RCC_PLL2CR_DIVPEN			BIT(4)
#define RCC_PLL2CR_DIVQEN			BIT(5)
#define RCC_PLL2CR_DIVREN			BIT(6)

/* RCC_PLL2CFGR1 register fields */
#define RCC_PLL2CFGR1_DIVN_MASK			GENMASK(8, 0)
#define RCC_PLL2CFGR1_DIVN_SHIFT		0
#define RCC_PLL2CFGR1_DIVM2_MASK		GENMASK(21, 16)
#define RCC_PLL2CFGR1_DIVM2_SHIFT		16

/* RCC_PLL2CFGR2 register fields */
#define RCC_PLL2CFGR2_DIVP_MASK			GENMASK(6, 0)
#define RCC_PLL2CFGR2_DIVP_SHIFT		0
#define RCC_PLL2CFGR2_DIVQ_MASK			GENMASK(14, 8)
#define RCC_PLL2CFGR2_DIVQ_SHIFT		8
#define RCC_PLL2CFGR2_DIVR_MASK			GENMASK(22, 16)
#define RCC_PLL2CFGR2_DIVR_SHIFT		16

/* RCC_PLL2FRACR register fields */
#define RCC_PLL2FRACR_FRACV_MASK		GENMASK(15, 3)
#define RCC_PLL2FRACR_FRACV_SHIFT		3
#define RCC_PLL2FRACR_FRACLE			BIT(16)

/* RCC_PLL2CSGR register fields */
#define RCC_PLL2CSGR_MOD_PER_MASK		GENMASK(12, 0)
#define RCC_PLL2CSGR_MOD_PER_SHIFT		0
#define RCC_PLL2CSGR_TPDFN_DIS			BIT(13)
#define RCC_PLL2CSGR_RPDFN_DIS			BIT(14)
#define RCC_PLL2CSGR_SSCG_MODE			BIT(15)
#define RCC_PLL2CSGR_INC_STEP_MASK		GENMASK(30, 16)
#define RCC_PLL2CSGR_INC_STEP_SHIFT		16

/* RCC_I2C46CKSELR register fields */
#define RCC_I2C46CKSELR_I2C46SRC_MASK		GENMASK(2, 0)
#define RCC_I2C46CKSELR_I2C46SRC_SHIFT		0

/* RCC_SPI6CKSELR register fields */
#define RCC_SPI6CKSELR_SPI6SRC_MASK		GENMASK(2, 0)
#define RCC_SPI6CKSELR_SPI6SRC_SHIFT		0

/* RCC_UART1CKSELR register fields */
#define RCC_UART1CKSELR_UART1SRC_MASK		GENMASK(2, 0)
#define RCC_UART1CKSELR_UART1SRC_SHIFT		0

/* RCC_RNG1CKSELR register fields */
#define RCC_RNG1CKSELR_RNG1SRC_MASK		GENMASK(1, 0)
#define RCC_RNG1CKSELR_RNG1SRC_SHIFT		0

/* RCC_CPERCKSELR register fields */
#define RCC_CPERCKSELR_HSI			0x00000000
#define RCC_CPERCKSELR_CSI			0x00000001
#define RCC_CPERCKSELR_HSE			0x00000002
#define RCC_CPERCKSELR_CKPERSRC_MASK		GENMASK(1, 0)
#define RCC_CPERCKSELR_CKPERSRC_SHIFT		0

/* RCC_STGENCKSELR register fields */
#define RCC_STGENCKSELR_STGENSRC_MASK		GENMASK(1, 0)
#define RCC_STGENCKSELR_STGENSRC_SHIFT		0

/* RCC_DDRITFCR register fields */
#define RCC_DDRITFCR_DDRC1EN			BIT(0)
#define RCC_DDRITFCR_DDRC1LPEN			BIT(1)
#define RCC_DDRITFCR_DDRC2EN			BIT(2)
#define RCC_DDRITFCR_DDRC2LPEN			BIT(3)
#define RCC_DDRITFCR_DDRPHYCEN			BIT(4)
#define RCC_DDRITFCR_DDRPHYCLPEN		BIT(5)
#define RCC_DDRITFCR_DDRCAPBEN			BIT(6)
#define RCC_DDRITFCR_DDRCAPBLPEN		BIT(7)
#define RCC_DDRITFCR_AXIDCGEN			BIT(8)
#define RCC_DDRITFCR_DDRPHYCAPBEN		BIT(9)
#define RCC_DDRITFCR_DDRPHYCAPBLPEN		BIT(10)
#define RCC_DDRITFCR_KERDCG_DLY_MASK		GENMASK(13, 11)
#define RCC_DDRITFCR_KERDCG_DLY_SHIFT		11
#define RCC_DDRITFCR_DDRCAPBRST			BIT(14)
#define RCC_DDRITFCR_DDRCAXIRST			BIT(15)
#define RCC_DDRITFCR_DDRCORERST			BIT(16)
#define RCC_DDRITFCR_DPHYAPBRST			BIT(17)
#define RCC_DDRITFCR_DPHYRST			BIT(18)
#define RCC_DDRITFCR_DPHYCTLRST			BIT(19)
#define RCC_DDRITFCR_DDRCKMOD_MASK		GENMASK(22, 20)
#define RCC_DDRITFCR_DDRCKMOD_SHIFT		20
#define RCC_DDRITFCR_DDRCKMOD_SSR		0
#define RCC_DDRITFCR_DDRCKMOD_ASR1		BIT(20)
#define RCC_DDRITFCR_DDRCKMOD_HSR1		BIT(21)
#define RCC_DDRITFCR_GSKPMOD			BIT(23)
#define RCC_DDRITFCR_GSKPCTRL			BIT(24)
#define RCC_DDRITFCR_DFILP_WIDTH_MASK		GENMASK(27, 25)
#define RCC_DDRITFCR_DFILP_WIDTH_SHIFT		25
#define RCC_DDRITFCR_GSKP_DUR_MASK		GENMASK(31, 28)
#define RCC_DDRITFCR_GSKP_DUR_SHIFT		28

/* RCC_MP_BOOTCR register fields */
#define RCC_MP_BOOTCR_MCU_BEN			BIT(0)
#define RCC_MP_BOOTCR_MPU_BEN			BIT(1)

/* RCC_MP_SREQSETR register fields */
#define RCC_MP_SREQSETR_STPREQ_P0		BIT(0)
#define RCC_MP_SREQSETR_STPREQ_P1		BIT(1)

/* RCC_MP_SREQCLRR register fields */
#define RCC_MP_SREQCLRR_STPREQ_P0		BIT(0)
#define RCC_MP_SREQCLRR_STPREQ_P1		BIT(1)

/* RCC_MP_GCR register fields */
#define RCC_MP_GCR_BOOT_MCU			BIT(0)

/* RCC_MP_APRSTCR register fields */
#define RCC_MP_APRSTCR_RDCTLEN			BIT(0)
#define RCC_MP_APRSTCR_RSTTO_MASK		GENMASK(14, 8)
#define RCC_MP_APRSTCR_RSTTO_SHIFT		8

/* RCC_MP_APRSTSR register fields */
#define RCC_MP_APRSTSR_RSTTOV_MASK		GENMASK(14, 8)
#define RCC_MP_APRSTSR_RSTTOV_SHIFT		8

/* RCC_BDCR register fields */
#define RCC_BDCR_LSEON				BIT(0)
#define RCC_BDCR_LSEBYP				BIT(1)
#define RCC_BDCR_LSERDY				BIT(2)
#define RCC_BDCR_DIGBYP				BIT(3)
#define RCC_BDCR_LSEDRV_MASK			GENMASK(5, 4)
#define RCC_BDCR_LSEDRV_SHIFT			4
#define RCC_BDCR_LSECSSON			BIT(8)
#define RCC_BDCR_LSECSSD			BIT(9)
#define RCC_BDCR_RTCSRC_MASK			GENMASK(17, 16)
#define RCC_BDCR_RTCSRC_SHIFT			16
#define RCC_BDCR_RTCCKEN			BIT(20)
#define RCC_BDCR_VSWRST				BIT(31)

/* RCC_RDLSICR register fields */
#define RCC_RDLSICR_LSION			BIT(0)
#define RCC_RDLSICR_LSIRDY			BIT(1)
#define RCC_RDLSICR_MRD_MASK			GENMASK(20, 16)
#define RCC_RDLSICR_MRD_SHIFT			16
#define RCC_RDLSICR_EADLY_MASK			GENMASK(26, 24)
#define RCC_RDLSICR_EADLY_SHIFT			24
#define RCC_RDLSICR_SPARE_MASK			GENMASK(31, 27)
#define RCC_RDLSICR_SPARE_SHIFT			27

/* RCC_APB4RSTSETR register fields */
#define RCC_APB4RSTSETR_LTDCRST			BIT(0)
#define RCC_APB4RSTSETR_DSIRST			BIT(4)
#define RCC_APB4RSTSETR_DDRPERFMRST		BIT(8)
#define RCC_APB4RSTSETR_USBPHYRST		BIT(16)

/* RCC_APB4RSTCLRR register fields */
#define RCC_APB4RSTCLRR_LTDCRST			BIT(0)
#define RCC_APB4RSTCLRR_DSIRST			BIT(4)
#define RCC_APB4RSTCLRR_DDRPERFMRST		BIT(8)
#define RCC_APB4RSTCLRR_USBPHYRST		BIT(16)

/* RCC_APB5RSTSETR register fields */
#define RCC_APB5RSTSETR_SPI6RST			BIT(0)
#define RCC_APB5RSTSETR_I2C4RST			BIT(2)
#define RCC_APB5RSTSETR_I2C6RST			BIT(3)
#define RCC_APB5RSTSETR_USART1RST		BIT(4)
#define RCC_APB5RSTSETR_STGENRST		BIT(20)

/* RCC_APB5RSTCLRR register fields */
#define RCC_APB5RSTCLRR_SPI6RST			BIT(0)
#define RCC_APB5RSTCLRR_I2C4RST			BIT(2)
#define RCC_APB5RSTCLRR_I2C6RST			BIT(3)
#define RCC_APB5RSTCLRR_USART1RST		BIT(4)
#define RCC_APB5RSTCLRR_STGENRST		BIT(20)

/* RCC_AHB5RSTSETR register fields */
#define RCC_AHB5RSTSETR_GPIOZRST		BIT(0)
#define RCC_AHB5RSTSETR_CRYP1RST		BIT(4)
#define RCC_AHB5RSTSETR_HASH1RST		BIT(5)
#define RCC_AHB5RSTSETR_RNG1RST			BIT(6)
#define RCC_AHB5RSTSETR_AXIMCRST		BIT(16)

/* RCC_AHB5RSTCLRR register fields */
#define RCC_AHB5RSTCLRR_GPIOZRST		BIT(0)
#define RCC_AHB5RSTCLRR_CRYP1RST		BIT(4)
#define RCC_AHB5RSTCLRR_HASH1RST		BIT(5)
#define RCC_AHB5RSTCLRR_RNG1RST			BIT(6)
#define RCC_AHB5RSTCLRR_AXIMCRST		BIT(16)

/* RCC_AHB6RSTSETR register fields */
#define RCC_AHB6RSTSETR_GPURST			BIT(5)
#define RCC_AHB6RSTSETR_ETHMACRST		BIT(10)
#define RCC_AHB6RSTSETR_FMCRST			BIT(12)
#define RCC_AHB6RSTSETR_QSPIRST			BIT(14)
#define RCC_AHB6RSTSETR_SDMMC1RST		BIT(16)
#define RCC_AHB6RSTSETR_SDMMC2RST		BIT(17)
#define RCC_AHB6RSTSETR_CRC1RST			BIT(20)
#define RCC_AHB6RSTSETR_USBHRST			BIT(24)

/* RCC_AHB6RSTCLRR register fields */
#define RCC_AHB6RSTCLRR_ETHMACRST		BIT(10)
#define RCC_AHB6RSTCLRR_FMCRST			BIT(12)
#define RCC_AHB6RSTCLRR_QSPIRST			BIT(14)
#define RCC_AHB6RSTCLRR_SDMMC1RST		BIT(16)
#define RCC_AHB6RSTCLRR_SDMMC2RST		BIT(17)
#define RCC_AHB6RSTCLRR_CRC1RST			BIT(20)
#define RCC_AHB6RSTCLRR_USBHRST			BIT(24)

/* RCC_TZAHB6RSTSETR register fields */
#define RCC_TZAHB6RSTSETR_MDMARST		BIT(0)

/* RCC_TZAHB6RSTCLRR register fields */
#define RCC_TZAHB6RSTCLRR_MDMARST		BIT(0)

/* RCC_MP_APB4ENSETR register fields */
#define RCC_MP_APB4ENSETR_LTDCEN		BIT(0)
#define RCC_MP_APB4ENSETR_DSIEN			BIT(4)
#define RCC_MP_APB4ENSETR_DDRPERFMEN		BIT(8)
#define RCC_MP_APB4ENSETR_IWDG2APBEN		BIT(15)
#define RCC_MP_APB4ENSETR_USBPHYEN		BIT(16)
#define RCC_MP_APB4ENSETR_STGENROEN		BIT(20)

/* RCC_MP_APB4ENCLRR register fields */
#define RCC_MP_APB4ENCLRR_LTDCEN		BIT(0)
#define RCC_MP_APB4ENCLRR_DSIEN			BIT(4)
#define RCC_MP_APB4ENCLRR_DDRPERFMEN		BIT(8)
#define RCC_MP_APB4ENCLRR_IWDG2APBEN		BIT(15)
#define RCC_MP_APB4ENCLRR_USBPHYEN		BIT(16)
#define RCC_MP_APB4ENCLRR_STGENROEN		BIT(20)

/* RCC_MP_APB5ENSETR register fields */
#define RCC_MP_APB5ENSETR_SPI6EN		BIT(0)
#define RCC_MP_APB5ENSETR_I2C4EN		BIT(2)
#define RCC_MP_APB5ENSETR_I2C6EN		BIT(3)
#define RCC_MP_APB5ENSETR_USART1EN		BIT(4)
#define RCC_MP_APB5ENSETR_RTCAPBEN		BIT(8)
#define RCC_MP_APB5ENSETR_TZC1EN		BIT(11)
#define RCC_MP_APB5ENSETR_TZC2EN		BIT(12)
#define RCC_MP_APB5ENSETR_TZPCEN		BIT(13)
#define RCC_MP_APB5ENSETR_IWDG1APBEN		BIT(15)
#define RCC_MP_APB5ENSETR_BSECEN		BIT(16)
#define RCC_MP_APB5ENSETR_STGENEN		BIT(20)

/* RCC_MP_APB5ENCLRR register fields */
#define RCC_MP_APB5ENCLRR_SPI6EN		BIT(0)
#define RCC_MP_APB5ENCLRR_I2C4EN		BIT(2)
#define RCC_MP_APB5ENCLRR_I2C6EN		BIT(3)
#define RCC_MP_APB5ENCLRR_USART1EN		BIT(4)
#define RCC_MP_APB5ENCLRR_RTCAPBEN		BIT(8)
#define RCC_MP_APB5ENCLRR_TZC1EN		BIT(11)
#define RCC_MP_APB5ENCLRR_TZC2EN		BIT(12)
#define RCC_MP_APB5ENCLRR_TZPCEN		BIT(13)
#define RCC_MP_APB5ENCLRR_IWDG1APBEN		BIT(15)
#define RCC_MP_APB5ENCLRR_BSECEN		BIT(16)
#define RCC_MP_APB5ENCLRR_STGENEN		BIT(20)

/* RCC_MP_AHB5ENSETR register fields */
#define RCC_MP_AHB5ENSETR_GPIOZEN		BIT(0)
#define RCC_MP_AHB5ENSETR_CRYP1EN		BIT(4)
#define RCC_MP_AHB5ENSETR_HASH1EN		BIT(5)
#define RCC_MP_AHB5ENSETR_RNG1EN		BIT(6)
#define RCC_MP_AHB5ENSETR_BKPSRAMEN		BIT(8)
#define RCC_MP_AHB5ENSETR_AXIMCEN		BIT(16)

/* RCC_MP_AHB5ENCLRR register fields */
#define RCC_MP_AHB5ENCLRR_GPIOZEN		BIT(0)
#define RCC_MP_AHB5ENCLRR_CRYP1EN		BIT(4)
#define RCC_MP_AHB5ENCLRR_HASH1EN		BIT(5)
#define RCC_MP_AHB5ENCLRR_RNG1EN		BIT(6)
#define RCC_MP_AHB5ENCLRR_BKPSRAMEN		BIT(8)
#define RCC_MP_AHB5ENCLRR_AXIMCEN		BIT(16)

/* RCC_MP_AHB6ENSETR register fields */
#define RCC_MP_AHB6ENSETR_MDMAEN		BIT(0)
#define RCC_MP_AHB6ENSETR_GPUEN			BIT(5)
#define RCC_MP_AHB6ENSETR_ETHCKEN		BIT(7)
#define RCC_MP_AHB6ENSETR_ETHTXEN		BIT(8)
#define RCC_MP_AHB6ENSETR_ETHRXEN		BIT(9)
#define RCC_MP_AHB6ENSETR_ETHMACEN		BIT(10)
#define RCC_MP_AHB6ENSETR_FMCEN			BIT(12)
#define RCC_MP_AHB6ENSETR_QSPIEN		BIT(14)
#define RCC_MP_AHB6ENSETR_SDMMC1EN		BIT(16)
#define RCC_MP_AHB6ENSETR_SDMMC2EN		BIT(17)
#define RCC_MP_AHB6ENSETR_CRC1EN		BIT(20)
#define RCC_MP_AHB6ENSETR_USBHEN		BIT(24)

/* RCC_MP_AHB6ENCLRR register fields */
#define RCC_MP_AHB6ENCLRR_MDMAEN		BIT(0)
#define RCC_MP_AHB6ENCLRR_GPUEN			BIT(5)
#define RCC_MP_AHB6ENCLRR_ETHCKEN		BIT(7)
#define RCC_MP_AHB6ENCLRR_ETHTXEN		BIT(8)
#define RCC_MP_AHB6ENCLRR_ETHRXEN		BIT(9)
#define RCC_MP_AHB6ENCLRR_ETHMACEN		BIT(10)
#define RCC_MP_AHB6ENCLRR_FMCEN			BIT(12)
#define RCC_MP_AHB6ENCLRR_QSPIEN		BIT(14)
#define RCC_MP_AHB6ENCLRR_SDMMC1EN		BIT(16)
#define RCC_MP_AHB6ENCLRR_SDMMC2EN		BIT(17)
#define RCC_MP_AHB6ENCLRR_CRC1EN		BIT(20)
#define RCC_MP_AHB6ENCLRR_USBHEN		BIT(24)

/* RCC_MP_TZAHB6ENSETR register fields */
#define RCC_MP_TZAHB6ENSETR_MDMAEN		BIT(0)

/* RCC_MP_TZAHB6ENCLRR register fields */
#define RCC_MP_TZAHB6ENCLRR_MDMAEN		BIT(0)

/* RCC_MC_APB4ENSETR register fields */
#define RCC_MC_APB4ENSETR_LTDCEN		BIT(0)
#define RCC_MC_APB4ENSETR_DSIEN			BIT(4)
#define RCC_MC_APB4ENSETR_DDRPERFMEN		BIT(8)
#define RCC_MC_APB4ENSETR_USBPHYEN		BIT(16)
#define RCC_MC_APB4ENSETR_STGENROEN		BIT(20)

/* RCC_MC_APB4ENCLRR register fields */
#define RCC_MC_APB4ENCLRR_LTDCEN		BIT(0)
#define RCC_MC_APB4ENCLRR_DSIEN			BIT(4)
#define RCC_MC_APB4ENCLRR_DDRPERFMEN		BIT(8)
#define RCC_MC_APB4ENCLRR_USBPHYEN		BIT(16)
#define RCC_MC_APB4ENCLRR_STGENROEN		BIT(20)

/* RCC_MC_APB5ENSETR register fields */
#define RCC_MC_APB5ENSETR_SPI6EN		BIT(0)
#define RCC_MC_APB5ENSETR_I2C4EN		BIT(2)
#define RCC_MC_APB5ENSETR_I2C6EN		BIT(3)
#define RCC_MC_APB5ENSETR_USART1EN		BIT(4)
#define RCC_MC_APB5ENSETR_RTCAPBEN		BIT(8)
#define RCC_MC_APB5ENSETR_TZC1EN		BIT(11)
#define RCC_MC_APB5ENSETR_TZC2EN		BIT(12)
#define RCC_MC_APB5ENSETR_TZPCEN		BIT(13)
#define RCC_MC_APB5ENSETR_BSECEN		BIT(16)
#define RCC_MC_APB5ENSETR_STGENEN		BIT(20)

/* RCC_MC_APB5ENCLRR register fields */
#define RCC_MC_APB5ENCLRR_SPI6EN		BIT(0)
#define RCC_MC_APB5ENCLRR_I2C4EN		BIT(2)
#define RCC_MC_APB5ENCLRR_I2C6EN		BIT(3)
#define RCC_MC_APB5ENCLRR_USART1EN		BIT(4)
#define RCC_MC_APB5ENCLRR_RTCAPBEN		BIT(8)
#define RCC_MC_APB5ENCLRR_TZC1EN		BIT(11)
#define RCC_MC_APB5ENCLRR_TZC2EN		BIT(12)
#define RCC_MC_APB5ENCLRR_TZPCEN		BIT(13)
#define RCC_MC_APB5ENCLRR_BSECEN		BIT(16)
#define RCC_MC_APB5ENCLRR_STGENEN		BIT(20)

/* RCC_MC_AHB5ENSETR register fields */
#define RCC_MC_AHB5ENSETR_GPIOZEN		BIT(0)
#define RCC_MC_AHB5ENSETR_CRYP1EN		BIT(4)
#define RCC_MC_AHB5ENSETR_HASH1EN		BIT(5)
#define RCC_MC_AHB5ENSETR_RNG1EN		BIT(6)
#define RCC_MC_AHB5ENSETR_BKPSRAMEN		BIT(8)

/* RCC_MC_AHB5ENCLRR register fields */
#define RCC_MC_AHB5ENCLRR_GPIOZEN		BIT(0)
#define RCC_MC_AHB5ENCLRR_CRYP1EN		BIT(4)
#define RCC_MC_AHB5ENCLRR_HASH1EN		BIT(5)
#define RCC_MC_AHB5ENCLRR_RNG1EN		BIT(6)
#define RCC_MC_AHB5ENCLRR_BKPSRAMEN		BIT(8)

/* RCC_MC_AHB6ENSETR register fields */
#define RCC_MC_AHB6ENSETR_MDMAEN		BIT(0)
#define RCC_MC_AHB6ENSETR_GPUEN			BIT(5)
#define RCC_MC_AHB6ENSETR_ETHCKEN		BIT(7)
#define RCC_MC_AHB6ENSETR_ETHTXEN		BIT(8)
#define RCC_MC_AHB6ENSETR_ETHRXEN		BIT(9)
#define RCC_MC_AHB6ENSETR_ETHMACEN		BIT(10)
#define RCC_MC_AHB6ENSETR_FMCEN			BIT(12)
#define RCC_MC_AHB6ENSETR_QSPIEN		BIT(14)
#define RCC_MC_AHB6ENSETR_SDMMC1EN		BIT(16)
#define RCC_MC_AHB6ENSETR_SDMMC2EN		BIT(17)
#define RCC_MC_AHB6ENSETR_CRC1EN		BIT(20)
#define RCC_MC_AHB6ENSETR_USBHEN		BIT(24)

/* RCC_MC_AHB6ENCLRR register fields */
#define RCC_MC_AHB6ENCLRR_MDMAEN		BIT(0)
#define RCC_MC_AHB6ENCLRR_GPUEN			BIT(5)
#define RCC_MC_AHB6ENCLRR_ETHCKEN		BIT(7)
#define RCC_MC_AHB6ENCLRR_ETHTXEN		BIT(8)
#define RCC_MC_AHB6ENCLRR_ETHRXEN		BIT(9)
#define RCC_MC_AHB6ENCLRR_ETHMACEN		BIT(10)
#define RCC_MC_AHB6ENCLRR_FMCEN			BIT(12)
#define RCC_MC_AHB6ENCLRR_QSPIEN		BIT(14)
#define RCC_MC_AHB6ENCLRR_SDMMC1EN		BIT(16)
#define RCC_MC_AHB6ENCLRR_SDMMC2EN		BIT(17)
#define RCC_MC_AHB6ENCLRR_CRC1EN		BIT(20)
#define RCC_MC_AHB6ENCLRR_USBHEN		BIT(24)

/* RCC_MP_APB4LPENSETR register fields */
#define RCC_MP_APB4LPENSETR_LTDCLPEN		BIT(0)
#define RCC_MP_APB4LPENSETR_DSILPEN		BIT(4)
#define RCC_MP_APB4LPENSETR_DDRPERFMLPEN	BIT(8)
#define RCC_MP_APB4LPENSETR_IWDG2APBLPEN	BIT(15)
#define RCC_MP_APB4LPENSETR_USBPHYLPEN		BIT(16)
#define RCC_MP_APB4LPENSETR_STGENROLPEN		BIT(20)
#define RCC_MP_APB4LPENSETR_STGENROSTPEN	BIT(21)

/* RCC_MP_APB4LPENCLRR register fields */
#define RCC_MP_APB4LPENCLRR_LTDCLPEN		BIT(0)
#define RCC_MP_APB4LPENCLRR_DSILPEN		BIT(4)
#define RCC_MP_APB4LPENCLRR_DDRPERFMLPEN	BIT(8)
#define RCC_MP_APB4LPENCLRR_IWDG2APBLPEN	BIT(15)
#define RCC_MP_APB4LPENCLRR_USBPHYLPEN		BIT(16)
#define RCC_MP_APB4LPENCLRR_STGENROLPEN		BIT(20)
#define RCC_MP_APB4LPENCLRR_STGENROSTPEN	BIT(21)

/* RCC_MP_APB5LPENSETR register fields */
#define RCC_MP_APB5LPENSETR_SPI6LPEN		BIT(0)
#define RCC_MP_APB5LPENSETR_I2C4LPEN		BIT(2)
#define RCC_MP_APB5LPENSETR_I2C6LPEN		BIT(3)
#define RCC_MP_APB5LPENSETR_USART1LPEN		BIT(4)
#define RCC_MP_APB5LPENSETR_RTCAPBLPEN		BIT(8)
#define RCC_MP_APB5LPENSETR_TZC1LPEN		BIT(11)
#define RCC_MP_APB5LPENSETR_TZC2LPEN		BIT(12)
#define RCC_MP_APB5LPENSETR_TZPCLPEN		BIT(13)
#define RCC_MP_APB5LPENSETR_IWDG1APBLPEN	BIT(15)
#define RCC_MP_APB5LPENSETR_BSECLPEN		BIT(16)
#define RCC_MP_APB5LPENSETR_STGENLPEN		BIT(20)
#define RCC_MP_APB5LPENSETR_STGENSTPEN		BIT(21)

/* RCC_MP_APB5LPENCLRR register fields */
#define RCC_MP_APB5LPENCLRR_SPI6LPEN		BIT(0)
#define RCC_MP_APB5LPENCLRR_I2C4LPEN		BIT(2)
#define RCC_MP_APB5LPENCLRR_I2C6LPEN		BIT(3)
#define RCC_MP_APB5LPENCLRR_USART1LPEN		BIT(4)
#define RCC_MP_APB5LPENCLRR_RTCAPBLPEN		BIT(8)
#define RCC_MP_APB5LPENCLRR_TZC1LPEN		BIT(11)
#define RCC_MP_APB5LPENCLRR_TZC2LPEN		BIT(12)
#define RCC_MP_APB5LPENCLRR_TZPCLPEN		BIT(13)
#define RCC_MP_APB5LPENCLRR_IWDG1APBLPEN	BIT(15)
#define RCC_MP_APB5LPENCLRR_BSECLPEN		BIT(16)
#define RCC_MP_APB5LPENCLRR_STGENLPEN		BIT(20)
#define RCC_MP_APB5LPENCLRR_STGENSTPEN		BIT(21)

/* RCC_MP_AHB5LPENSETR register fields */
#define RCC_MP_AHB5LPENSETR_GPIOZLPEN		BIT(0)
#define RCC_MP_AHB5LPENSETR_CRYP1LPEN		BIT(4)
#define RCC_MP_AHB5LPENSETR_HASH1LPEN		BIT(5)
#define RCC_MP_AHB5LPENSETR_RNG1LPEN		BIT(6)
#define RCC_MP_AHB5LPENSETR_BKPSRAMLPEN		BIT(8)

/* RCC_MP_AHB5LPENCLRR register fields */
#define RCC_MP_AHB5LPENCLRR_GPIOZLPEN		BIT(0)
#define RCC_MP_AHB5LPENCLRR_CRYP1LPEN		BIT(4)
#define RCC_MP_AHB5LPENCLRR_HASH1LPEN		BIT(5)
#define RCC_MP_AHB5LPENCLRR_RNG1LPEN		BIT(6)
#define RCC_MP_AHB5LPENCLRR_BKPSRAMLPEN		BIT(8)

/* RCC_MP_AHB6LPENSETR register fields */
#define RCC_MP_AHB6LPENSETR_MDMALPEN		BIT(0)
#define RCC_MP_AHB6LPENSETR_GPULPEN		BIT(5)
#define RCC_MP_AHB6LPENSETR_ETHCKLPEN		BIT(7)
#define RCC_MP_AHB6LPENSETR_ETHTXLPEN		BIT(8)
#define RCC_MP_AHB6LPENSETR_ETHRXLPEN		BIT(9)
#define RCC_MP_AHB6LPENSETR_ETHMACLPEN		BIT(10)
#define RCC_MP_AHB6LPENSETR_ETHSTPEN		BIT(11)
#define RCC_MP_AHB6LPENSETR_FMCLPEN		BIT(12)
#define RCC_MP_AHB6LPENSETR_QSPILPEN		BIT(14)
#define RCC_MP_AHB6LPENSETR_SDMMC1LPEN		BIT(16)
#define RCC_MP_AHB6LPENSETR_SDMMC2LPEN		BIT(17)
#define RCC_MP_AHB6LPENSETR_CRC1LPEN		BIT(20)
#define RCC_MP_AHB6LPENSETR_USBHLPEN		BIT(24)

/* RCC_MP_AHB6LPENCLRR register fields */
#define RCC_MP_AHB6LPENCLRR_MDMALPEN		BIT(0)
#define RCC_MP_AHB6LPENCLRR_GPULPEN		BIT(5)
#define RCC_MP_AHB6LPENCLRR_ETHCKLPEN		BIT(7)
#define RCC_MP_AHB6LPENCLRR_ETHTXLPEN		BIT(8)
#define RCC_MP_AHB6LPENCLRR_ETHRXLPEN		BIT(9)
#define RCC_MP_AHB6LPENCLRR_ETHMACLPEN		BIT(10)
#define RCC_MP_AHB6LPENCLRR_ETHSTPEN		BIT(11)
#define RCC_MP_AHB6LPENCLRR_FMCLPEN		BIT(12)
#define RCC_MP_AHB6LPENCLRR_QSPILPEN		BIT(14)
#define RCC_MP_AHB6LPENCLRR_SDMMC1LPEN		BIT(16)
#define RCC_MP_AHB6LPENCLRR_SDMMC2LPEN		BIT(17)
#define RCC_MP_AHB6LPENCLRR_CRC1LPEN		BIT(20)
#define RCC_MP_AHB6LPENCLRR_USBHLPEN		BIT(24)

/* RCC_MP_TZAHB6LPENSETR register fields */
#define RCC_MP_TZAHB6LPENSETR_MDMALPEN		BIT(0)

/* RCC_MP_TZAHB6LPENCLRR register fields */
#define RCC_MP_TZAHB6LPENCLRR_MDMALPEN		BIT(0)

/* RCC_MC_APB4LPENSETR register fields */
#define RCC_MC_APB4LPENSETR_LTDCLPEN		BIT(0)
#define RCC_MC_APB4LPENSETR_DSILPEN		BIT(4)
#define RCC_MC_APB4LPENSETR_DDRPERFMLPEN	BIT(8)
#define RCC_MC_APB4LPENSETR_USBPHYLPEN		BIT(16)
#define RCC_MC_APB4LPENSETR_STGENROLPEN		BIT(20)
#define RCC_MC_APB4LPENSETR_STGENROSTPEN	BIT(21)

/* RCC_MC_APB4LPENCLRR register fields */
#define RCC_MC_APB4LPENCLRR_LTDCLPEN		BIT(0)
#define RCC_MC_APB4LPENCLRR_DSILPEN		BIT(4)
#define RCC_MC_APB4LPENCLRR_DDRPERFMLPEN	BIT(8)
#define RCC_MC_APB4LPENCLRR_USBPHYLPEN		BIT(16)
#define RCC_MC_APB4LPENCLRR_STGENROLPEN		BIT(20)
#define RCC_MC_APB4LPENCLRR_STGENROSTPEN	BIT(21)

/* RCC_MC_APB5LPENSETR register fields */
#define RCC_MC_APB5LPENSETR_SPI6LPEN		BIT(0)
#define RCC_MC_APB5LPENSETR_I2C4LPEN		BIT(2)
#define RCC_MC_APB5LPENSETR_I2C6LPEN		BIT(3)
#define RCC_MC_APB5LPENSETR_USART1LPEN		BIT(4)
#define RCC_MC_APB5LPENSETR_RTCAPBLPEN		BIT(8)
#define RCC_MC_APB5LPENSETR_TZC1LPEN		BIT(11)
#define RCC_MC_APB5LPENSETR_TZC2LPEN		BIT(12)
#define RCC_MC_APB5LPENSETR_TZPCLPEN		BIT(13)
#define RCC_MC_APB5LPENSETR_BSECLPEN		BIT(16)
#define RCC_MC_APB5LPENSETR_STGENLPEN		BIT(20)
#define RCC_MC_APB5LPENSETR_STGENSTPEN		BIT(21)

/* RCC_MC_APB5LPENCLRR register fields */
#define RCC_MC_APB5LPENCLRR_SPI6LPEN		BIT(0)
#define RCC_MC_APB5LPENCLRR_I2C4LPEN		BIT(2)
#define RCC_MC_APB5LPENCLRR_I2C6LPEN		BIT(3)
#define RCC_MC_APB5LPENCLRR_USART1LPEN		BIT(4)
#define RCC_MC_APB5LPENCLRR_RTCAPBLPEN		BIT(8)
#define RCC_MC_APB5LPENCLRR_TZC1LPEN		BIT(11)
#define RCC_MC_APB5LPENCLRR_TZC2LPEN		BIT(12)
#define RCC_MC_APB5LPENCLRR_TZPCLPEN		BIT(13)
#define RCC_MC_APB5LPENCLRR_BSECLPEN		BIT(16)
#define RCC_MC_APB5LPENCLRR_STGENLPEN		BIT(20)
#define RCC_MC_APB5LPENCLRR_STGENSTPEN		BIT(21)

/* RCC_MC_AHB5LPENSETR register fields */
#define RCC_MC_AHB5LPENSETR_GPIOZLPEN		BIT(0)
#define RCC_MC_AHB5LPENSETR_CRYP1LPEN		BIT(4)
#define RCC_MC_AHB5LPENSETR_HASH1LPEN		BIT(5)
#define RCC_MC_AHB5LPENSETR_RNG1LPEN		BIT(6)
#define RCC_MC_AHB5LPENSETR_BKPSRAMLPEN		BIT(8)

/* RCC_MC_AHB5LPENCLRR register fields */
#define RCC_MC_AHB5LPENCLRR_GPIOZLPEN		BIT(0)
#define RCC_MC_AHB5LPENCLRR_CRYP1LPEN		BIT(4)
#define RCC_MC_AHB5LPENCLRR_HASH1LPEN		BIT(5)
#define RCC_MC_AHB5LPENCLRR_RNG1LPEN		BIT(6)
#define RCC_MC_AHB5LPENCLRR_BKPSRAMLPEN		BIT(8)

/* RCC_MC_AHB6LPENSETR register fields */
#define RCC_MC_AHB6LPENSETR_MDMALPEN		BIT(0)
#define RCC_MC_AHB6LPENSETR_GPULPEN		BIT(5)
#define RCC_MC_AHB6LPENSETR_ETHCKLPEN		BIT(7)
#define RCC_MC_AHB6LPENSETR_ETHTXLPEN		BIT(8)
#define RCC_MC_AHB6LPENSETR_ETHRXLPEN		BIT(9)
#define RCC_MC_AHB6LPENSETR_ETHMACLPEN		BIT(10)
#define RCC_MC_AHB6LPENSETR_ETHSTPEN		BIT(11)
#define RCC_MC_AHB6LPENSETR_FMCLPEN		BIT(12)
#define RCC_MC_AHB6LPENSETR_QSPILPEN		BIT(14)
#define RCC_MC_AHB6LPENSETR_SDMMC1LPEN		BIT(16)
#define RCC_MC_AHB6LPENSETR_SDMMC2LPEN		BIT(17)
#define RCC_MC_AHB6LPENSETR_CRC1LPEN		BIT(20)
#define RCC_MC_AHB6LPENSETR_USBHLPEN		BIT(24)

/* RCC_MC_AHB6LPENCLRR register fields */
#define RCC_MC_AHB6LPENCLRR_MDMALPEN		BIT(0)
#define RCC_MC_AHB6LPENCLRR_GPULPEN		BIT(5)
#define RCC_MC_AHB6LPENCLRR_ETHCKLPEN		BIT(7)
#define RCC_MC_AHB6LPENCLRR_ETHTXLPEN		BIT(8)
#define RCC_MC_AHB6LPENCLRR_ETHRXLPEN		BIT(9)
#define RCC_MC_AHB6LPENCLRR_ETHMACLPEN		BIT(10)
#define RCC_MC_AHB6LPENCLRR_ETHSTPEN		BIT(11)
#define RCC_MC_AHB6LPENCLRR_FMCLPEN		BIT(12)
#define RCC_MC_AHB6LPENCLRR_QSPILPEN		BIT(14)
#define RCC_MC_AHB6LPENCLRR_SDMMC1LPEN		BIT(16)
#define RCC_MC_AHB6LPENCLRR_SDMMC2LPEN		BIT(17)
#define RCC_MC_AHB6LPENCLRR_CRC1LPEN		BIT(20)
#define RCC_MC_AHB6LPENCLRR_USBHLPEN		BIT(24)

/* RCC_BR_RSTSCLRR register fields */
#define RCC_BR_RSTSCLRR_PORRSTF			BIT(0)
#define RCC_BR_RSTSCLRR_BORRSTF			BIT(1)
#define RCC_BR_RSTSCLRR_PADRSTF			BIT(2)
#define RCC_BR_RSTSCLRR_HCSSRSTF		BIT(3)
#define RCC_BR_RSTSCLRR_VCORERSTF		BIT(4)
#define RCC_BR_RSTSCLRR_MPSYSRSTF		BIT(6)
#define RCC_BR_RSTSCLRR_MCSYSRSTF		BIT(7)
#define RCC_BR_RSTSCLRR_IWDG1RSTF		BIT(8)
#define RCC_BR_RSTSCLRR_IWDG2RSTF		BIT(9)
#define RCC_BR_RSTSCLRR_MPUP0RSTF		BIT(13)
#define RCC_BR_RSTSCLRR_MPUP1RSTF		BIT(14)

/* RCC_MP_GRSTCSETR register fields */
#define RCC_MP_GRSTCSETR_MPSYSRST		BIT(0)
#define RCC_MP_GRSTCSETR_MCURST			BIT(1)
#define RCC_MP_GRSTCSETR_MPUP0RST		BIT(4)
#define RCC_MP_GRSTCSETR_MPUP1RST		BIT(5)

/* RCC_MP_RSTSCLRR register fields */
#define RCC_MP_RSTSCLRR_PORRSTF			BIT(0)
#define RCC_MP_RSTSCLRR_BORRSTF			BIT(1)
#define RCC_MP_RSTSCLRR_PADRSTF			BIT(2)
#define RCC_MP_RSTSCLRR_HCSSRSTF		BIT(3)
#define RCC_MP_RSTSCLRR_VCORERSTF		BIT(4)
#define RCC_MP_RSTSCLRR_MPSYSRSTF		BIT(6)
#define RCC_MP_RSTSCLRR_MCSYSRSTF		BIT(7)
#define RCC_MP_RSTSCLRR_IWDG1RSTF		BIT(8)
#define RCC_MP_RSTSCLRR_IWDG2RSTF		BIT(9)
#define RCC_MP_RSTSCLRR_STDBYRSTF		BIT(11)
#define RCC_MP_RSTSCLRR_CSTDBYRSTF		BIT(12)
#define RCC_MP_RSTSCLRR_MPUP0RSTF		BIT(13)
#define RCC_MP_RSTSCLRR_MPUP1RSTF		BIT(14)
#define RCC_MP_RSTSCLRR_SPARE			BIT(15)

/* RCC_MP_IWDGFZSETR register fields */
#define RCC_MP_IWDGFZSETR_FZ_IWDG1		BIT(0)
#define RCC_MP_IWDGFZSETR_FZ_IWDG2		BIT(1)

/* RCC_MP_IWDGFZCLRR register fields */
#define RCC_MP_IWDGFZCLRR_FZ_IWDG1		BIT(0)
#define RCC_MP_IWDGFZCLRR_FZ_IWDG2		BIT(1)

/* RCC_MP_CIER register fields */
#define RCC_MP_CIER_LSIRDYIE			BIT(0)
#define RCC_MP_CIER_LSERDYIE			BIT(1)
#define RCC_MP_CIER_HSIRDYIE			BIT(2)
#define RCC_MP_CIER_HSERDYIE			BIT(3)
#define RCC_MP_CIER_CSIRDYIE			BIT(4)
#define RCC_MP_CIER_PLL1DYIE			BIT(8)
#define RCC_MP_CIER_PLL2DYIE			BIT(9)
#define RCC_MP_CIER_PLL3DYIE			BIT(10)
#define RCC_MP_CIER_PLL4DYIE			BIT(11)
#define RCC_MP_CIER_LSECSSIE			BIT(16)
#define RCC_MP_CIER_WKUPIE			BIT(20)

/* RCC_MP_CIFR register fields */
#define RCC_MP_CIFR_MASK			U(0x110F1F)
#define RCC_MP_CIFR_LSIRDYF			BIT(0)
#define RCC_MP_CIFR_LSERDYF			BIT(1)
#define RCC_MP_CIFR_HSIRDYF			BIT(2)
#define RCC_MP_CIFR_HSERDYF			BIT(3)
#define RCC_MP_CIFR_CSIRDYF			BIT(4)
#define RCC_MP_CIFR_PLL1DYF			BIT(8)
#define RCC_MP_CIFR_PLL2DYF			BIT(9)
#define RCC_MP_CIFR_PLL3DYF			BIT(10)
#define RCC_MP_CIFR_PLL4DYF			BIT(11)
#define RCC_MP_CIFR_LSECSSF			BIT(16)
#define RCC_MP_CIFR_WKUPF			BIT(20)

/* RCC_PWRLPDLYCR register fields */
#define RCC_PWRLPDLYCR_PWRLP_DLY_MASK		GENMASK(21, 0)
#define RCC_PWRLPDLYCR_PWRLP_DLY_SHIFT		0
#define RCC_PWRLPDLYCR_MCTMPSKP			BIT(24)

/* RCC_MP_RSTSSETR register fields */
#define RCC_MP_RSTSSETR_PORRSTF			BIT(0)
#define RCC_MP_RSTSSETR_BORRSTF			BIT(1)
#define RCC_MP_RSTSSETR_PADRSTF			BIT(2)
#define RCC_MP_RSTSSETR_HCSSRSTF		BIT(3)
#define RCC_MP_RSTSSETR_VCORERSTF		BIT(4)
#define RCC_MP_RSTSSETR_MPSYSRSTF		BIT(6)
#define RCC_MP_RSTSSETR_MCSYSRSTF		BIT(7)
#define RCC_MP_RSTSSETR_IWDG1RSTF		BIT(8)
#define RCC_MP_RSTSSETR_IWDG2RSTF		BIT(9)
#define RCC_MP_RSTSSETR_STDBYRSTF		BIT(11)
#define RCC_MP_RSTSSETR_CSTDBYRSTF		BIT(12)
#define RCC_MP_RSTSSETR_MPUP0RSTF		BIT(13)
#define RCC_MP_RSTSSETR_MPUP1RSTF		BIT(14)
#define RCC_MP_RSTSSETR_SPARE			BIT(15)

/* RCC_MCO1CFGR register fields */
#define RCC_MCO1CFGR_MCO1SEL_MASK		GENMASK(2, 0)
#define RCC_MCO1CFGR_MCO1SEL_SHIFT		0
#define RCC_MCO1CFGR_MCO1DIV_MASK		GENMASK(7, 4)
#define RCC_MCO1CFGR_MCO1DIV_SHIFT		4
#define RCC_MCO1CFGR_MCO1ON			BIT(12)

/* RCC_MCO2CFGR register fields */
#define RCC_MCO2CFGR_MCO2SEL_MASK		GENMASK(2, 0)
#define RCC_MCO2CFGR_MCO2SEL_SHIFT		0
#define RCC_MCO2CFGR_MCO2DIV_MASK		GENMASK(7, 4)
#define RCC_MCO2CFGR_MCO2DIV_SHIFT		4
#define RCC_MCO2CFGR_MCO2ON			BIT(12)

/* RCC_OCRDYR register fields */
#define RCC_OCRDYR_HSIRDY			BIT(0)
#define RCC_OCRDYR_HSIDIVRDY			BIT(2)
#define RCC_OCRDYR_CSIRDY			BIT(4)
#define RCC_OCRDYR_HSERDY			BIT(8)
#define RCC_OCRDYR_MPUCKRDY			BIT(23)
#define RCC_OCRDYR_AXICKRDY			BIT(24)
#define RCC_OCRDYR_CKREST			BIT(25)

/* RCC_DBGCFGR register fields */
#define RCC_DBGCFGR_TRACEDIV_MASK		GENMASK(2, 0)
#define RCC_DBGCFGR_TRACEDIV_SHIFT		0
#define RCC_DBGCFGR_DBGCKEN			BIT(8)
#define RCC_DBGCFGR_TRACECKEN			BIT(9)
#define RCC_DBGCFGR_DBGRST			BIT(12)

/* RCC_RCK3SELR register fields */
#define RCC_RCK3SELR_PLL3SRC_MASK		GENMASK(1, 0)
#define RCC_RCK3SELR_PLL3SRC_SHIFT		0
#define RCC_RCK3SELR_PLL3SRCRDY			BIT(31)

/* RCC_RCK4SELR register fields */
#define RCC_RCK4SELR_PLL4SRC_MASK		GENMASK(1, 0)
#define RCC_RCK4SELR_PLL4SRC_SHIFT		0
#define RCC_RCK4SELR_PLL4SRCRDY			BIT(31)

/* RCC_TIMG1PRER register fields */
#define RCC_TIMG1PRER_TIMG1PRE			BIT(0)
#define RCC_TIMG1PRER_TIMG1PRERDY		BIT(31)

/* RCC_TIMG2PRER register fields */
#define RCC_TIMG2PRER_TIMG2PRE			BIT(0)
#define RCC_TIMG2PRER_TIMG2PRERDY		BIT(31)

/* RCC_MCUDIVR register fields */
#define RCC_MCUDIVR_MCUDIV_MASK			GENMASK(3, 0)
#define RCC_MCUDIVR_MCUDIV_SHIFT		0
#define RCC_MCUDIVR_MCUDIVRDY			BIT(31)

/* RCC_APB1DIVR register fields */
#define RCC_APB1DIVR_APB1DIV_MASK		GENMASK(2, 0)
#define RCC_APB1DIVR_APB1DIV_SHIFT		0
#define RCC_APB1DIVR_APB1DIVRDY			BIT(31)

/* RCC_APB2DIVR register fields */
#define RCC_APB2DIVR_APB2DIV_MASK		GENMASK(2, 0)
#define RCC_APB2DIVR_APB2DIV_SHIFT		0
#define RCC_APB2DIVR_APB2DIVRDY			BIT(31)

/* RCC_APB3DIVR register fields */
#define RCC_APB3DIVR_APB3DIV_MASK		GENMASK(2, 0)
#define RCC_APB3DIVR_APB3DIV_SHIFT		0
#define RCC_APB3DIVR_APB3DIVRDY			BIT(31)

/* RCC_PLL3CR register fields */
#define RCC_PLL3CR_PLLON			BIT(0)
#define RCC_PLL3CR_PLL3RDY			BIT(1)
#define RCC_PLL3CR_SSCG_CTRL			BIT(2)
#define RCC_PLL3CR_DIVPEN			BIT(4)
#define RCC_PLL3CR_DIVQEN			BIT(5)
#define RCC_PLL3CR_DIVREN			BIT(6)

/* RCC_PLL3CFGR1 register fields */
#define RCC_PLL3CFGR1_DIVN_MASK			GENMASK(8, 0)
#define RCC_PLL3CFGR1_DIVN_SHIFT		0
#define RCC_PLL3CFGR1_DIVM3_MASK		GENMASK(21, 16)
#define RCC_PLL3CFGR1_DIVM3_SHIFT		16
#define RCC_PLL3CFGR1_IFRGE_MASK		GENMASK(25, 24)
#define RCC_PLL3CFGR1_IFRGE_SHIFT		24

/* RCC_PLL3CFGR2 register fields */
#define RCC_PLL3CFGR2_DIVP_MASK			GENMASK(6, 0)
#define RCC_PLL3CFGR2_DIVP_SHIFT		0
#define RCC_PLL3CFGR2_DIVQ_MASK			GENMASK(14, 8)
#define RCC_PLL3CFGR2_DIVQ_SHIFT		8
#define RCC_PLL3CFGR2_DIVR_MASK			GENMASK(22, 16)
#define RCC_PLL3CFGR2_DIVR_SHIFT		16

/* RCC_PLL3FRACR register fields */
#define RCC_PLL3FRACR_FRACV_MASK		GENMASK(15, 3)
#define RCC_PLL3FRACR_FRACV_SHIFT		3
#define RCC_PLL3FRACR_FRACLE			BIT(16)

/* RCC_PLL3CSGR register fields */
#define RCC_PLL3CSGR_MOD_PER_MASK		GENMASK(12, 0)
#define RCC_PLL3CSGR_MOD_PER_SHIFT		0
#define RCC_PLL3CSGR_TPDFN_DIS			BIT(13)
#define RCC_PLL3CSGR_RPDFN_DIS			BIT(14)
#define RCC_PLL3CSGR_SSCG_MODE			BIT(15)
#define RCC_PLL3CSGR_INC_STEP_MASK		GENMASK(30, 16)
#define RCC_PLL3CSGR_INC_STEP_SHIFT		16

/* RCC_PLL4CR register fields */
#define RCC_PLL4CR_PLLON			BIT(0)
#define RCC_PLL4CR_PLL4RDY			BIT(1)
#define RCC_PLL4CR_SSCG_CTRL			BIT(2)
#define RCC_PLL4CR_DIVPEN			BIT(4)
#define RCC_PLL4CR_DIVQEN			BIT(5)
#define RCC_PLL4CR_DIVREN			BIT(6)

/* RCC_PLL4CFGR1 register fields */
#define RCC_PLL4CFGR1_DIVN_MASK			GENMASK(8, 0)
#define RCC_PLL4CFGR1_DIVN_SHIFT		0
#define RCC_PLL4CFGR1_DIVM4_MASK		GENMASK(21, 16)
#define RCC_PLL4CFGR1_DIVM4_SHIFT		16
#define RCC_PLL4CFGR1_IFRGE_MASK		GENMASK(25, 24)
#define RCC_PLL4CFGR1_IFRGE_SHIFT		24

/* RCC_PLL4CFGR2 register fields */
#define RCC_PLL4CFGR2_DIVP_MASK			GENMASK(6, 0)
#define RCC_PLL4CFGR2_DIVP_SHIFT		0
#define RCC_PLL4CFGR2_DIVQ_MASK			GENMASK(14, 8)
#define RCC_PLL4CFGR2_DIVQ_SHIFT		8
#define RCC_PLL4CFGR2_DIVR_MASK			GENMASK(22, 16)
#define RCC_PLL4CFGR2_DIVR_SHIFT		16

/* RCC_PLL4FRACR register fields */
#define RCC_PLL4FRACR_FRACV_MASK		GENMASK(15, 3)
#define RCC_PLL4FRACR_FRACV_SHIFT		3
#define RCC_PLL4FRACR_FRACLE			BIT(16)

/* RCC_PLL4CSGR register fields */
#define RCC_PLL4CSGR_MOD_PER_MASK		GENMASK(12, 0)
#define RCC_PLL4CSGR_MOD_PER_SHIFT		0
#define RCC_PLL4CSGR_TPDFN_DIS			BIT(13)
#define RCC_PLL4CSGR_RPDFN_DIS			BIT(14)
#define RCC_PLL4CSGR_SSCG_MODE			BIT(15)
#define RCC_PLL4CSGR_INC_STEP_MASK		GENMASK(30, 16)
#define RCC_PLL4CSGR_INC_STEP_SHIFT		16

/* RCC_I2C12CKSELR register fields */
#define RCC_I2C12CKSELR_I2C12SRC_MASK		GENMASK(2, 0)
#define RCC_I2C12CKSELR_I2C12SRC_SHIFT		0

/* RCC_I2C35CKSELR register fields */
#define RCC_I2C35CKSELR_I2C35SRC_MASK		GENMASK(2, 0)
#define RCC_I2C35CKSELR_I2C35SRC_SHIFT		0

/* RCC_SAI1CKSELR register fields */
#define RCC_SAI1CKSELR_SAI1SRC_MASK		GENMASK(2, 0)
#define RCC_SAI1CKSELR_SAI1SRC_SHIFT		0

/* RCC_SAI2CKSELR register fields */
#define RCC_SAI2CKSELR_SAI2SRC_MASK		GENMASK(2, 0)
#define RCC_SAI2CKSELR_SAI2SRC_SHIFT		0

/* RCC_SAI3CKSELR register fields */
#define RCC_SAI3CKSELR_SAI3SRC_MASK		GENMASK(2, 0)
#define RCC_SAI3CKSELR_SAI3SRC_SHIFT		0

/* RCC_SAI4CKSELR register fields */
#define RCC_SAI4CKSELR_SAI4SRC_MASK		GENMASK(2, 0)
#define RCC_SAI4CKSELR_SAI4SRC_SHIFT		0

/* RCC_SPI2S1CKSELR register fields */
#define RCC_SPI2S1CKSELR_SPI1SRC_MASK		GENMASK(2, 0)
#define RCC_SPI2S1CKSELR_SPI1SRC_SHIFT		0

/* RCC_SPI2S23CKSELR register fields */
#define RCC_SPI2S23CKSELR_SPI23SRC_MASK		GENMASK(2, 0)
#define RCC_SPI2S23CKSELR_SPI23SRC_SHIFT	0

/* RCC_SPI45CKSELR register fields */
#define RCC_SPI45CKSELR_SPI45SRC_MASK		GENMASK(2, 0)
#define RCC_SPI45CKSELR_SPI45SRC_SHIFT		0

/* RCC_UART6CKSELR register fields */
#define RCC_UART6CKSELR_UART6SRC_MASK		GENMASK(2, 0)
#define RCC_UART6CKSELR_UART6SRC_SHIFT		0

/* RCC_UART24CKSELR register fields */
#define RCC_UART24CKSELR_HSI			0x00000002
#define RCC_UART24CKSELR_UART24SRC_MASK		GENMASK(2, 0)
#define RCC_UART24CKSELR_UART24SRC_SHIFT	0

/* RCC_UART35CKSELR register fields */
#define RCC_UART35CKSELR_UART35SRC_MASK		GENMASK(2, 0)
#define RCC_UART35CKSELR_UART35SRC_SHIFT	0

/* RCC_UART78CKSELR register fields */
#define RCC_UART78CKSELR_UART78SRC_MASK		GENMASK(2, 0)
#define RCC_UART78CKSELR_UART78SRC_SHIFT	0

/* RCC_SDMMC12CKSELR register fields */
#define RCC_SDMMC12CKSELR_SDMMC12SRC_MASK	GENMASK(2, 0)
#define RCC_SDMMC12CKSELR_SDMMC12SRC_SHIFT	0

/* RCC_SDMMC3CKSELR register fields */
#define RCC_SDMMC3CKSELR_SDMMC3SRC_MASK		GENMASK(2, 0)
#define RCC_SDMMC3CKSELR_SDMMC3SRC_SHIFT	0

/* RCC_ETHCKSELR register fields */
#define RCC_ETHCKSELR_ETHSRC_MASK		GENMASK(1, 0)
#define RCC_ETHCKSELR_ETHSRC_SHIFT		0
#define RCC_ETHCKSELR_ETHPTPDIV_MASK		GENMASK(7, 4)
#define RCC_ETHCKSELR_ETHPTPDIV_SHIFT		4

/* RCC_QSPICKSELR register fields */
#define RCC_QSPICKSELR_QSPISRC_MASK		GENMASK(1, 0)
#define RCC_QSPICKSELR_QSPISRC_SHIFT		0

/* RCC_FMCCKSELR register fields */
#define RCC_FMCCKSELR_FMCSRC_MASK		GENMASK(1, 0)
#define RCC_FMCCKSELR_FMCSRC_SHIFT		0

/* RCC_FDCANCKSELR register fields */
#define RCC_FDCANCKSELR_FDCANSRC_MASK		GENMASK(1, 0)
#define RCC_FDCANCKSELR_FDCANSRC_SHIFT		0

/* RCC_SPDIFCKSELR register fields */
#define RCC_SPDIFCKSELR_SPDIFSRC_MASK		GENMASK(1, 0)
#define RCC_SPDIFCKSELR_SPDIFSRC_SHIFT		0

/* RCC_CECCKSELR register fields */
#define RCC_CECCKSELR_CECSRC_MASK		GENMASK(1, 0)
#define RCC_CECCKSELR_CECSRC_SHIFT		0

/* RCC_USBCKSELR register fields */
#define RCC_USBCKSELR_USBPHYSRC_MASK		GENMASK(1, 0)
#define RCC_USBCKSELR_USBPHYSRC_SHIFT		0
#define RCC_USBCKSELR_USBOSRC			BIT(4)
#define RCC_USBCKSELR_USBOSRC_MASK		BIT(4)
#define RCC_USBCKSELR_USBOSRC_SHIFT		4

/* RCC_RNG2CKSELR register fields */
#define RCC_RNG2CKSELR_RNG2SRC_MASK		GENMASK(1, 0)
#define RCC_RNG2CKSELR_RNG2SRC_SHIFT		0

/* RCC_DSICKSELR register fields */
#define RCC_DSICKSELR_DSISRC			BIT(0)

/* RCC_ADCCKSELR register fields */
#define RCC_ADCCKSELR_ADCSRC_MASK		GENMASK(1, 0)
#define RCC_ADCCKSELR_ADCSRC_SHIFT		0

/* RCC_LPTIM45CKSELR register fields */
#define RCC_LPTIM45CKSELR_LPTIM45SRC_MASK	GENMASK(2, 0)
#define RCC_LPTIM45CKSELR_LPTIM45SRC_SHIFT	0

/* RCC_LPTIM23CKSELR register fields */
#define RCC_LPTIM23CKSELR_LPTIM23SRC_MASK	GENMASK(2, 0)
#define RCC_LPTIM23CKSELR_LPTIM23SRC_SHIFT	0

/* RCC_LPTIM1CKSELR register fields */
#define RCC_LPTIM1CKSELR_LPTIM1SRC_MASK		GENMASK(2, 0)
#define RCC_LPTIM1CKSELR_LPTIM1SRC_SHIFT	0

/* RCC_APB1RSTSETR register fields */
#define RCC_APB1RSTSETR_TIM2RST			BIT(0)
#define RCC_APB1RSTSETR_TIM3RST			BIT(1)
#define RCC_APB1RSTSETR_TIM4RST			BIT(2)
#define RCC_APB1RSTSETR_TIM5RST			BIT(3)
#define RCC_APB1RSTSETR_TIM6RST			BIT(4)
#define RCC_APB1RSTSETR_TIM7RST			BIT(5)
#define RCC_APB1RSTSETR_TIM12RST		BIT(6)
#define RCC_APB1RSTSETR_TIM13RST		BIT(7)
#define RCC_APB1RSTSETR_TIM14RST		BIT(8)
#define RCC_APB1RSTSETR_LPTIM1RST		BIT(9)
#define RCC_APB1RSTSETR_SPI2RST			BIT(11)
#define RCC_APB1RSTSETR_SPI3RST			BIT(12)
#define RCC_APB1RSTSETR_USART2RST		BIT(14)
#define RCC_APB1RSTSETR_USART3RST		BIT(15)
#define RCC_APB1RSTSETR_UART4RST		BIT(16)
#define RCC_APB1RSTSETR_UART5RST		BIT(17)
#define RCC_APB1RSTSETR_UART7RST		BIT(18)
#define RCC_APB1RSTSETR_UART8RST		BIT(19)
#define RCC_APB1RSTSETR_I2C1RST			BIT(21)
#define RCC_APB1RSTSETR_I2C2RST			BIT(22)
#define RCC_APB1RSTSETR_I2C3RST			BIT(23)
#define RCC_APB1RSTSETR_I2C5RST			BIT(24)
#define RCC_APB1RSTSETR_SPDIFRST		BIT(26)
#define RCC_APB1RSTSETR_CECRST			BIT(27)
#define RCC_APB1RSTSETR_DAC12RST		BIT(29)
#define RCC_APB1RSTSETR_MDIOSRST		BIT(31)

/* RCC_APB1RSTCLRR register fields */
#define RCC_APB1RSTCLRR_TIM2RST			BIT(0)
#define RCC_APB1RSTCLRR_TIM3RST			BIT(1)
#define RCC_APB1RSTCLRR_TIM4RST			BIT(2)
#define RCC_APB1RSTCLRR_TIM5RST			BIT(3)
#define RCC_APB1RSTCLRR_TIM6RST			BIT(4)
#define RCC_APB1RSTCLRR_TIM7RST			BIT(5)
#define RCC_APB1RSTCLRR_TIM12RST		BIT(6)
#define RCC_APB1RSTCLRR_TIM13RST		BIT(7)
#define RCC_APB1RSTCLRR_TIM14RST		BIT(8)
#define RCC_APB1RSTCLRR_LPTIM1RST		BIT(9)
#define RCC_APB1RSTCLRR_SPI2RST			BIT(11)
#define RCC_APB1RSTCLRR_SPI3RST			BIT(12)
#define RCC_APB1RSTCLRR_USART2RST		BIT(14)
#define RCC_APB1RSTCLRR_USART3RST		BIT(15)
#define RCC_APB1RSTCLRR_UART4RST		BIT(16)
#define RCC_APB1RSTCLRR_UART5RST		BIT(17)
#define RCC_APB1RSTCLRR_UART7RST		BIT(18)
#define RCC_APB1RSTCLRR_UART8RST		BIT(19)
#define RCC_APB1RSTCLRR_I2C1RST			BIT(21)
#define RCC_APB1RSTCLRR_I2C2RST			BIT(22)
#define RCC_APB1RSTCLRR_I2C3RST			BIT(23)
#define RCC_APB1RSTCLRR_I2C5RST			BIT(24)
#define RCC_APB1RSTCLRR_SPDIFRST		BIT(26)
#define RCC_APB1RSTCLRR_CECRST			BIT(27)
#define RCC_APB1RSTCLRR_DAC12RST		BIT(29)
#define RCC_APB1RSTCLRR_MDIOSRST		BIT(31)

/* RCC_APB2RSTSETR register fields */
#define RCC_APB2RSTSETR_TIM1RST			BIT(0)
#define RCC_APB2RSTSETR_TIM8RST			BIT(1)
#define RCC_APB2RSTSETR_TIM15RST		BIT(2)
#define RCC_APB2RSTSETR_TIM16RST		BIT(3)
#define RCC_APB2RSTSETR_TIM17RST		BIT(4)
#define RCC_APB2RSTSETR_SPI1RST			BIT(8)
#define RCC_APB2RSTSETR_SPI4RST			BIT(9)
#define RCC_APB2RSTSETR_SPI5RST			BIT(10)
#define RCC_APB2RSTSETR_USART6RST		BIT(13)
#define RCC_APB2RSTSETR_SAI1RST			BIT(16)
#define RCC_APB2RSTSETR_SAI2RST			BIT(17)
#define RCC_APB2RSTSETR_SAI3RST			BIT(18)
#define RCC_APB2RSTSETR_DFSDMRST		BIT(20)
#define RCC_APB2RSTSETR_FDCANRST		BIT(24)

/* RCC_APB2RSTCLRR register fields */
#define RCC_APB2RSTCLRR_TIM1RST			BIT(0)
#define RCC_APB2RSTCLRR_TIM8RST			BIT(1)
#define RCC_APB2RSTCLRR_TIM15RST		BIT(2)
#define RCC_APB2RSTCLRR_TIM16RST		BIT(3)
#define RCC_APB2RSTCLRR_TIM17RST		BIT(4)
#define RCC_APB2RSTCLRR_SPI1RST			BIT(8)
#define RCC_APB2RSTCLRR_SPI4RST			BIT(9)
#define RCC_APB2RSTCLRR_SPI5RST			BIT(10)
#define RCC_APB2RSTCLRR_USART6RST		BIT(13)
#define RCC_APB2RSTCLRR_SAI1RST			BIT(16)
#define RCC_APB2RSTCLRR_SAI2RST			BIT(17)
#define RCC_APB2RSTCLRR_SAI3RST			BIT(18)
#define RCC_APB2RSTCLRR_DFSDMRST		BIT(20)
#define RCC_APB2RSTCLRR_FDCANRST		BIT(24)

/* RCC_APB3RSTSETR register fields */
#define RCC_APB3RSTSETR_LPTIM2RST		BIT(0)
#define RCC_APB3RSTSETR_LPTIM3RST		BIT(1)
#define RCC_APB3RSTSETR_LPTIM4RST		BIT(2)
#define RCC_APB3RSTSETR_LPTIM5RST		BIT(3)
#define RCC_APB3RSTSETR_SAI4RST			BIT(8)
#define RCC_APB3RSTSETR_SYSCFGRST		BIT(11)
#define RCC_APB3RSTSETR_VREFRST			BIT(13)
#define RCC_APB3RSTSETR_TMPSENSRST		BIT(16)
#define RCC_APB3RSTSETR_PMBCTRLRST		BIT(17)

/* RCC_APB3RSTCLRR register fields */
#define RCC_APB3RSTCLRR_LPTIM2RST		BIT(0)
#define RCC_APB3RSTCLRR_LPTIM3RST		BIT(1)
#define RCC_APB3RSTCLRR_LPTIM4RST		BIT(2)
#define RCC_APB3RSTCLRR_LPTIM5RST		BIT(3)
#define RCC_APB3RSTCLRR_SAI4RST			BIT(8)
#define RCC_APB3RSTCLRR_SYSCFGRST		BIT(11)
#define RCC_APB3RSTCLRR_VREFRST			BIT(13)
#define RCC_APB3RSTCLRR_TMPSENSRST		BIT(16)
#define RCC_APB3RSTCLRR_PMBCTRLRST		BIT(17)

/* RCC_AHB2RSTSETR register fields */
#define RCC_AHB2RSTSETR_DMA1RST			BIT(0)
#define RCC_AHB2RSTSETR_DMA2RST			BIT(1)
#define RCC_AHB2RSTSETR_DMAMUXRST		BIT(2)
#define RCC_AHB2RSTSETR_ADC12RST		BIT(5)
#define RCC_AHB2RSTSETR_USBORST			BIT(8)
#define RCC_AHB2RSTSETR_SDMMC3RST		BIT(16)

/* RCC_AHB2RSTCLRR register fields */
#define RCC_AHB2RSTCLRR_DMA1RST			BIT(0)
#define RCC_AHB2RSTCLRR_DMA2RST			BIT(1)
#define RCC_AHB2RSTCLRR_DMAMUXRST		BIT(2)
#define RCC_AHB2RSTCLRR_ADC12RST		BIT(5)
#define RCC_AHB2RSTCLRR_USBORST			BIT(8)
#define RCC_AHB2RSTCLRR_SDMMC3RST		BIT(16)

/* RCC_AHB3RSTSETR register fields */
#define RCC_AHB3RSTSETR_DCMIRST			BIT(0)
#define RCC_AHB3RSTSETR_CRYP2RST		BIT(4)
#define RCC_AHB3RSTSETR_HASH2RST		BIT(5)
#define RCC_AHB3RSTSETR_RNG2RST			BIT(6)
#define RCC_AHB3RSTSETR_CRC2RST			BIT(7)
#define RCC_AHB3RSTSETR_HSEMRST			BIT(11)
#define RCC_AHB3RSTSETR_IPCCRST			BIT(12)

/* RCC_AHB3RSTCLRR register fields */
#define RCC_AHB3RSTCLRR_DCMIRST			BIT(0)
#define RCC_AHB3RSTCLRR_CRYP2RST		BIT(4)
#define RCC_AHB3RSTCLRR_HASH2RST		BIT(5)
#define RCC_AHB3RSTCLRR_RNG2RST			BIT(6)
#define RCC_AHB3RSTCLRR_CRC2RST			BIT(7)
#define RCC_AHB3RSTCLRR_HSEMRST			BIT(11)
#define RCC_AHB3RSTCLRR_IPCCRST			BIT(12)

/* RCC_AHB4RSTSETR register fields */
#define RCC_AHB4RSTSETR_GPIOARST		BIT(0)
#define RCC_AHB4RSTSETR_GPIOBRST		BIT(1)
#define RCC_AHB4RSTSETR_GPIOCRST		BIT(2)
#define RCC_AHB4RSTSETR_GPIODRST		BIT(3)
#define RCC_AHB4RSTSETR_GPIOERST		BIT(4)
#define RCC_AHB4RSTSETR_GPIOFRST		BIT(5)
#define RCC_AHB4RSTSETR_GPIOGRST		BIT(6)
#define RCC_AHB4RSTSETR_GPIOHRST		BIT(7)
#define RCC_AHB4RSTSETR_GPIOIRST		BIT(8)
#define RCC_AHB4RSTSETR_GPIOJRST		BIT(9)
#define RCC_AHB4RSTSETR_GPIOKRST		BIT(10)

/* RCC_AHB4RSTCLRR register fields */
#define RCC_AHB4RSTCLRR_GPIOARST		BIT(0)
#define RCC_AHB4RSTCLRR_GPIOBRST		BIT(1)
#define RCC_AHB4RSTCLRR_GPIOCRST		BIT(2)
#define RCC_AHB4RSTCLRR_GPIODRST		BIT(3)
#define RCC_AHB4RSTCLRR_GPIOERST		BIT(4)
#define RCC_AHB4RSTCLRR_GPIOFRST		BIT(5)
#define RCC_AHB4RSTCLRR_GPIOGRST		BIT(6)
#define RCC_AHB4RSTCLRR_GPIOHRST		BIT(7)
#define RCC_AHB4RSTCLRR_GPIOIRST		BIT(8)
#define RCC_AHB4RSTCLRR_GPIOJRST		BIT(9)
#define RCC_AHB4RSTCLRR_GPIOKRST		BIT(10)

/* RCC_MP_APB1ENSETR register fields */
#define RCC_MP_APB1ENSETR_TIM2EN		BIT(0)
#define RCC_MP_APB1ENSETR_TIM3EN		BIT(1)
#define RCC_MP_APB1ENSETR_TIM4EN		BIT(2)
#define RCC_MP_APB1ENSETR_TIM5EN		BIT(3)
#define RCC_MP_APB1ENSETR_TIM6EN		BIT(4)
#define RCC_MP_APB1ENSETR_TIM7EN		BIT(5)
#define RCC_MP_APB1ENSETR_TIM12EN		BIT(6)
#define RCC_MP_APB1ENSETR_TIM13EN		BIT(7)
#define RCC_MP_APB1ENSETR_TIM14EN		BIT(8)
#define RCC_MP_APB1ENSETR_LPTIM1EN		BIT(9)
#define RCC_MP_APB1ENSETR_SPI2EN		BIT(11)
#define RCC_MP_APB1ENSETR_SPI3EN		BIT(12)
#define RCC_MP_APB1ENSETR_USART2EN		BIT(14)
#define RCC_MP_APB1ENSETR_USART3EN		BIT(15)
#define RCC_MP_APB1ENSETR_UART4EN		BIT(16)
#define RCC_MP_APB1ENSETR_UART5EN		BIT(17)
#define RCC_MP_APB1ENSETR_UART7EN		BIT(18)
#define RCC_MP_APB1ENSETR_UART8EN		BIT(19)
#define RCC_MP_APB1ENSETR_I2C1EN		BIT(21)
#define RCC_MP_APB1ENSETR_I2C2EN		BIT(22)
#define RCC_MP_APB1ENSETR_I2C3EN		BIT(23)
#define RCC_MP_APB1ENSETR_I2C5EN		BIT(24)
#define RCC_MP_APB1ENSETR_SPDIFEN		BIT(26)
#define RCC_MP_APB1ENSETR_CECEN			BIT(27)
#define RCC_MP_APB1ENSETR_DAC12EN		BIT(29)
#define RCC_MP_APB1ENSETR_MDIOSEN		BIT(31)

/* RCC_MP_APB1ENCLRR register fields */
#define RCC_MP_APB1ENCLRR_TIM2EN		BIT(0)
#define RCC_MP_APB1ENCLRR_TIM3EN		BIT(1)
#define RCC_MP_APB1ENCLRR_TIM4EN		BIT(2)
#define RCC_MP_APB1ENCLRR_TIM5EN		BIT(3)
#define RCC_MP_APB1ENCLRR_TIM6EN		BIT(4)
#define RCC_MP_APB1ENCLRR_TIM7EN		BIT(5)
#define RCC_MP_APB1ENCLRR_TIM12EN		BIT(6)
#define RCC_MP_APB1ENCLRR_TIM13EN		BIT(7)
#define RCC_MP_APB1ENCLRR_TIM14EN		BIT(8)
#define RCC_MP_APB1ENCLRR_LPTIM1EN		BIT(9)
#define RCC_MP_APB1ENCLRR_SPI2EN		BIT(11)
#define RCC_MP_APB1ENCLRR_SPI3EN		BIT(12)
#define RCC_MP_APB1ENCLRR_USART2EN		BIT(14)
#define RCC_MP_APB1ENCLRR_USART3EN		BIT(15)
#define RCC_MP_APB1ENCLRR_UART4EN		BIT(16)
#define RCC_MP_APB1ENCLRR_UART5EN		BIT(17)
#define RCC_MP_APB1ENCLRR_UART7EN		BIT(18)
#define RCC_MP_APB1ENCLRR_UART8EN		BIT(19)
#define RCC_MP_APB1ENCLRR_I2C1EN		BIT(21)
#define RCC_MP_APB1ENCLRR_I2C2EN		BIT(22)
#define RCC_MP_APB1ENCLRR_I2C3EN		BIT(23)
#define RCC_MP_APB1ENCLRR_I2C5EN		BIT(24)
#define RCC_MP_APB1ENCLRR_SPDIFEN		BIT(26)
#define RCC_MP_APB1ENCLRR_CECEN			BIT(27)
#define RCC_MP_APB1ENCLRR_DAC12EN		BIT(29)
#define RCC_MP_APB1ENCLRR_MDIOSEN		BIT(31)

/* RCC_MP_APB2ENSETR register fields */
#define RCC_MP_APB2ENSETR_TIM1EN		BIT(0)
#define RCC_MP_APB2ENSETR_TIM8EN		BIT(1)
#define RCC_MP_APB2ENSETR_TIM15EN		BIT(2)
#define RCC_MP_APB2ENSETR_TIM16EN		BIT(3)
#define RCC_MP_APB2ENSETR_TIM17EN		BIT(4)
#define RCC_MP_APB2ENSETR_SPI1EN		BIT(8)
#define RCC_MP_APB2ENSETR_SPI4EN		BIT(9)
#define RCC_MP_APB2ENSETR_SPI5EN		BIT(10)
#define RCC_MP_APB2ENSETR_USART6EN		BIT(13)
#define RCC_MP_APB2ENSETR_SAI1EN		BIT(16)
#define RCC_MP_APB2ENSETR_SAI2EN		BIT(17)
#define RCC_MP_APB2ENSETR_SAI3EN		BIT(18)
#define RCC_MP_APB2ENSETR_DFSDMEN		BIT(20)
#define RCC_MP_APB2ENSETR_ADFSDMEN		BIT(21)
#define RCC_MP_APB2ENSETR_FDCANEN		BIT(24)

/* RCC_MP_APB2ENCLRR register fields */
#define RCC_MP_APB2ENCLRR_TIM1EN		BIT(0)
#define RCC_MP_APB2ENCLRR_TIM8EN		BIT(1)
#define RCC_MP_APB2ENCLRR_TIM15EN		BIT(2)
#define RCC_MP_APB2ENCLRR_TIM16EN		BIT(3)
#define RCC_MP_APB2ENCLRR_TIM17EN		BIT(4)
#define RCC_MP_APB2ENCLRR_SPI1EN		BIT(8)
#define RCC_MP_APB2ENCLRR_SPI4EN		BIT(9)
#define RCC_MP_APB2ENCLRR_SPI5EN		BIT(10)
#define RCC_MP_APB2ENCLRR_USART6EN		BIT(13)
#define RCC_MP_APB2ENCLRR_SAI1EN		BIT(16)
#define RCC_MP_APB2ENCLRR_SAI2EN		BIT(17)
#define RCC_MP_APB2ENCLRR_SAI3EN		BIT(18)
#define RCC_MP_APB2ENCLRR_DFSDMEN		BIT(20)
#define RCC_MP_APB2ENCLRR_ADFSDMEN		BIT(21)
#define RCC_MP_APB2ENCLRR_FDCANEN		BIT(24)

/* RCC_MP_APB3ENSETR register fields */
#define RCC_MP_APB3ENSETR_LPTIM2EN		BIT(0)
#define RCC_MP_APB3ENSETR_LPTIM3EN		BIT(1)
#define RCC_MP_APB3ENSETR_LPTIM4EN		BIT(2)
#define RCC_MP_APB3ENSETR_LPTIM5EN		BIT(3)
#define RCC_MP_APB3ENSETR_SAI4EN		BIT(8)
#define RCC_MP_APB3ENSETR_SYSCFGEN		BIT(11)
#define RCC_MP_APB3ENSETR_VREFEN		BIT(13)
#define RCC_MP_APB3ENSETR_TMPSENSEN		BIT(16)
#define RCC_MP_APB3ENSETR_PMBCTRLEN		BIT(17)
#define RCC_MP_APB3ENSETR_HDPEN			BIT(20)

/* RCC_MP_APB3ENCLRR register fields */
#define RCC_MP_APB3ENCLRR_LPTIM2EN		BIT(0)
#define RCC_MP_APB3ENCLRR_LPTIM3EN		BIT(1)
#define RCC_MP_APB3ENCLRR_LPTIM4EN		BIT(2)
#define RCC_MP_APB3ENCLRR_LPTIM5EN		BIT(3)
#define RCC_MP_APB3ENCLRR_SAI4EN		BIT(8)
#define RCC_MP_APB3ENCLRR_SYSCFGEN		BIT(11)
#define RCC_MP_APB3ENCLRR_VREFEN		BIT(13)
#define RCC_MP_APB3ENCLRR_TMPSENSEN		BIT(16)
#define RCC_MP_APB3ENCLRR_PMBCTRLEN		BIT(17)
#define RCC_MP_APB3ENCLRR_HDPEN			BIT(20)

/* RCC_MP_AHB2ENSETR register fields */
#define RCC_MP_AHB2ENSETR_DMA1EN		BIT(0)
#define RCC_MP_AHB2ENSETR_DMA2EN		BIT(1)
#define RCC_MP_AHB2ENSETR_DMAMUXEN		BIT(2)
#define RCC_MP_AHB2ENSETR_ADC12EN		BIT(5)
#define RCC_MP_AHB2ENSETR_USBOEN		BIT(8)
#define RCC_MP_AHB2ENSETR_SDMMC3EN		BIT(16)

/* RCC_MP_AHB2ENCLRR register fields */
#define RCC_MP_AHB2ENCLRR_DMA1EN		BIT(0)
#define RCC_MP_AHB2ENCLRR_DMA2EN		BIT(1)
#define RCC_MP_AHB2ENCLRR_DMAMUXEN		BIT(2)
#define RCC_MP_AHB2ENCLRR_ADC12EN		BIT(5)
#define RCC_MP_AHB2ENCLRR_USBOEN		BIT(8)
#define RCC_MP_AHB2ENCLRR_SDMMC3EN		BIT(16)

/* RCC_MP_AHB3ENSETR register fields */
#define RCC_MP_AHB3ENSETR_DCMIEN		BIT(0)
#define RCC_MP_AHB3ENSETR_CRYP2EN		BIT(4)
#define RCC_MP_AHB3ENSETR_HASH2EN		BIT(5)
#define RCC_MP_AHB3ENSETR_RNG2EN		BIT(6)
#define RCC_MP_AHB3ENSETR_CRC2EN		BIT(7)
#define RCC_MP_AHB3ENSETR_HSEMEN		BIT(11)
#define RCC_MP_AHB3ENSETR_IPCCEN		BIT(12)

/* RCC_MP_AHB3ENCLRR register fields */
#define RCC_MP_AHB3ENCLRR_DCMIEN		BIT(0)
#define RCC_MP_AHB3ENCLRR_CRYP2EN		BIT(4)
#define RCC_MP_AHB3ENCLRR_HASH2EN		BIT(5)
#define RCC_MP_AHB3ENCLRR_RNG2EN		BIT(6)
#define RCC_MP_AHB3ENCLRR_CRC2EN		BIT(7)
#define RCC_MP_AHB3ENCLRR_HSEMEN		BIT(11)
#define RCC_MP_AHB3ENCLRR_IPCCEN		BIT(12)

/* RCC_MP_AHB4ENSETR register fields */
#define RCC_MP_AHB4ENSETR_GPIOAEN		BIT(0)
#define RCC_MP_AHB4ENSETR_GPIOBEN		BIT(1)
#define RCC_MP_AHB4ENSETR_GPIOCEN		BIT(2)
#define RCC_MP_AHB4ENSETR_GPIODEN		BIT(3)
#define RCC_MP_AHB4ENSETR_GPIOEEN		BIT(4)
#define RCC_MP_AHB4ENSETR_GPIOFEN		BIT(5)
#define RCC_MP_AHB4ENSETR_GPIOGEN		BIT(6)
#define RCC_MP_AHB4ENSETR_GPIOHEN		BIT(7)
#define RCC_MP_AHB4ENSETR_GPIOIEN		BIT(8)
#define RCC_MP_AHB4ENSETR_GPIOJEN		BIT(9)
#define RCC_MP_AHB4ENSETR_GPIOKEN		BIT(10)

/* RCC_MP_AHB4ENCLRR register fields */
#define RCC_MP_AHB4ENCLRR_GPIOAEN		BIT(0)
#define RCC_MP_AHB4ENCLRR_GPIOBEN		BIT(1)
#define RCC_MP_AHB4ENCLRR_GPIOCEN		BIT(2)
#define RCC_MP_AHB4ENCLRR_GPIODEN		BIT(3)
#define RCC_MP_AHB4ENCLRR_GPIOEEN		BIT(4)
#define RCC_MP_AHB4ENCLRR_GPIOFEN		BIT(5)
#define RCC_MP_AHB4ENCLRR_GPIOGEN		BIT(6)
#define RCC_MP_AHB4ENCLRR_GPIOHEN		BIT(7)
#define RCC_MP_AHB4ENCLRR_GPIOIEN		BIT(8)
#define RCC_MP_AHB4ENCLRR_GPIOJEN		BIT(9)
#define RCC_MP_AHB4ENCLRR_GPIOKEN		BIT(10)

/* RCC_MP_MLAHBENSETR register fields */
#define RCC_MP_MLAHBENSETR_RETRAMEN		BIT(4)

/* RCC_MP_MLAHBENCLRR register fields */
#define RCC_MP_MLAHBENCLRR_RETRAMEN		BIT(4)

/* RCC_MC_APB1ENSETR register fields */
#define RCC_MC_APB1ENSETR_TIM2EN		BIT(0)
#define RCC_MC_APB1ENSETR_TIM3EN		BIT(1)
#define RCC_MC_APB1ENSETR_TIM4EN		BIT(2)
#define RCC_MC_APB1ENSETR_TIM5EN		BIT(3)
#define RCC_MC_APB1ENSETR_TIM6EN		BIT(4)
#define RCC_MC_APB1ENSETR_TIM7EN		BIT(5)
#define RCC_MC_APB1ENSETR_TIM12EN		BIT(6)
#define RCC_MC_APB1ENSETR_TIM13EN		BIT(7)
#define RCC_MC_APB1ENSETR_TIM14EN		BIT(8)
#define RCC_MC_APB1ENSETR_LPTIM1EN		BIT(9)
#define RCC_MC_APB1ENSETR_SPI2EN		BIT(11)
#define RCC_MC_APB1ENSETR_SPI3EN		BIT(12)
#define RCC_MC_APB1ENSETR_USART2EN		BIT(14)
#define RCC_MC_APB1ENSETR_USART3EN		BIT(15)
#define RCC_MC_APB1ENSETR_UART4EN		BIT(16)
#define RCC_MC_APB1ENSETR_UART5EN		BIT(17)
#define RCC_MC_APB1ENSETR_UART7EN		BIT(18)
#define RCC_MC_APB1ENSETR_UART8EN		BIT(19)
#define RCC_MC_APB1ENSETR_I2C1EN		BIT(21)
#define RCC_MC_APB1ENSETR_I2C2EN		BIT(22)
#define RCC_MC_APB1ENSETR_I2C3EN		BIT(23)
#define RCC_MC_APB1ENSETR_I2C5EN		BIT(24)
#define RCC_MC_APB1ENSETR_SPDIFEN		BIT(26)
#define RCC_MC_APB1ENSETR_CECEN			BIT(27)
#define RCC_MC_APB1ENSETR_WWDG1EN		BIT(28)
#define RCC_MC_APB1ENSETR_DAC12EN		BIT(29)
#define RCC_MC_APB1ENSETR_MDIOSEN		BIT(31)

/* RCC_MC_APB1ENCLRR register fields */
#define RCC_MC_APB1ENCLRR_TIM2EN		BIT(0)
#define RCC_MC_APB1ENCLRR_TIM3EN		BIT(1)
#define RCC_MC_APB1ENCLRR_TIM4EN		BIT(2)
#define RCC_MC_APB1ENCLRR_TIM5EN		BIT(3)
#define RCC_MC_APB1ENCLRR_TIM6EN		BIT(4)
#define RCC_MC_APB1ENCLRR_TIM7EN		BIT(5)
#define RCC_MC_APB1ENCLRR_TIM12EN		BIT(6)
#define RCC_MC_APB1ENCLRR_TIM13EN		BIT(7)
#define RCC_MC_APB1ENCLRR_TIM14EN		BIT(8)
#define RCC_MC_APB1ENCLRR_LPTIM1EN		BIT(9)
#define RCC_MC_APB1ENCLRR_SPI2EN		BIT(11)
#define RCC_MC_APB1ENCLRR_SPI3EN		BIT(12)
#define RCC_MC_APB1ENCLRR_USART2EN		BIT(14)
#define RCC_MC_APB1ENCLRR_USART3EN		BIT(15)
#define RCC_MC_APB1ENCLRR_UART4EN		BIT(16)
#define RCC_MC_APB1ENCLRR_UART5EN		BIT(17)
#define RCC_MC_APB1ENCLRR_UART7EN		BIT(18)
#define RCC_MC_APB1ENCLRR_UART8EN		BIT(19)
#define RCC_MC_APB1ENCLRR_I2C1EN		BIT(21)
#define RCC_MC_APB1ENCLRR_I2C2EN		BIT(22)
#define RCC_MC_APB1ENCLRR_I2C3EN		BIT(23)
#define RCC_MC_APB1ENCLRR_I2C5EN		BIT(24)
#define RCC_MC_APB1ENCLRR_SPDIFEN		BIT(26)
#define RCC_MC_APB1ENCLRR_CECEN			BIT(27)
#define RCC_MC_APB1ENCLRR_DAC12EN		BIT(29)
#define RCC_MC_APB1ENCLRR_MDIOSEN		BIT(31)

/* RCC_MC_APB2ENSETR register fields */
#define RCC_MC_APB2ENSETR_TIM1EN		BIT(0)
#define RCC_MC_APB2ENSETR_TIM8EN		BIT(1)
#define RCC_MC_APB2ENSETR_TIM15EN		BIT(2)
#define RCC_MC_APB2ENSETR_TIM16EN		BIT(3)
#define RCC_MC_APB2ENSETR_TIM17EN		BIT(4)
#define RCC_MC_APB2ENSETR_SPI1EN		BIT(8)
#define RCC_MC_APB2ENSETR_SPI4EN		BIT(9)
#define RCC_MC_APB2ENSETR_SPI5EN		BIT(10)
#define RCC_MC_APB2ENSETR_USART6EN		BIT(13)
#define RCC_MC_APB2ENSETR_SAI1EN		BIT(16)
#define RCC_MC_APB2ENSETR_SAI2EN		BIT(17)
#define RCC_MC_APB2ENSETR_SAI3EN		BIT(18)
#define RCC_MC_APB2ENSETR_DFSDMEN		BIT(20)
#define RCC_MC_APB2ENSETR_ADFSDMEN		BIT(21)
#define RCC_MC_APB2ENSETR_FDCANEN		BIT(24)

/* RCC_MC_APB2ENCLRR register fields */
#define RCC_MC_APB2ENCLRR_TIM1EN		BIT(0)
#define RCC_MC_APB2ENCLRR_TIM8EN		BIT(1)
#define RCC_MC_APB2ENCLRR_TIM15EN		BIT(2)
#define RCC_MC_APB2ENCLRR_TIM16EN		BIT(3)
#define RCC_MC_APB2ENCLRR_TIM17EN		BIT(4)
#define RCC_MC_APB2ENCLRR_SPI1EN		BIT(8)
#define RCC_MC_APB2ENCLRR_SPI4EN		BIT(9)
#define RCC_MC_APB2ENCLRR_SPI5EN		BIT(10)
#define RCC_MC_APB2ENCLRR_USART6EN		BIT(13)
#define RCC_MC_APB2ENCLRR_SAI1EN		BIT(16)
#define RCC_MC_APB2ENCLRR_SAI2EN		BIT(17)
#define RCC_MC_APB2ENCLRR_SAI3EN		BIT(18)
#define RCC_MC_APB2ENCLRR_DFSDMEN		BIT(20)
#define RCC_MC_APB2ENCLRR_ADFSDMEN		BIT(21)
#define RCC_MC_APB2ENCLRR_FDCANEN		BIT(24)

/* RCC_MC_APB3ENSETR register fields */
#define RCC_MC_APB3ENSETR_LPTIM2EN		BIT(0)
#define RCC_MC_APB3ENSETR_LPTIM3EN		BIT(1)
#define RCC_MC_APB3ENSETR_LPTIM4EN		BIT(2)
#define RCC_MC_APB3ENSETR_LPTIM5EN		BIT(3)
#define RCC_MC_APB3ENSETR_SAI4EN		BIT(8)
#define RCC_MC_APB3ENSETR_SYSCFGEN		BIT(11)
#define RCC_MC_APB3ENSETR_VREFEN		BIT(13)
#define RCC_MC_APB3ENSETR_TMPSENSEN		BIT(16)
#define RCC_MC_APB3ENSETR_PMBCTRLEN		BIT(17)
#define RCC_MC_APB3ENSETR_HDPEN			BIT(20)

/* RCC_MC_APB3ENCLRR register fields */
#define RCC_MC_APB3ENCLRR_LPTIM2EN		BIT(0)
#define RCC_MC_APB3ENCLRR_LPTIM3EN		BIT(1)
#define RCC_MC_APB3ENCLRR_LPTIM4EN		BIT(2)
#define RCC_MC_APB3ENCLRR_LPTIM5EN		BIT(3)
#define RCC_MC_APB3ENCLRR_SAI4EN		BIT(8)
#define RCC_MC_APB3ENCLRR_SYSCFGEN		BIT(11)
#define RCC_MC_APB3ENCLRR_VREFEN		BIT(13)
#define RCC_MC_APB3ENCLRR_TMPSENSEN		BIT(16)
#define RCC_MC_APB3ENCLRR_PMBCTRLEN		BIT(17)
#define RCC_MC_APB3ENCLRR_HDPEN			BIT(20)

/* RCC_MC_AHB2ENSETR register fields */
#define RCC_MC_AHB2ENSETR_DMA1EN		BIT(0)
#define RCC_MC_AHB2ENSETR_DMA2EN		BIT(1)
#define RCC_MC_AHB2ENSETR_DMAMUXEN		BIT(2)
#define RCC_MC_AHB2ENSETR_ADC12EN		BIT(5)
#define RCC_MC_AHB2ENSETR_USBOEN		BIT(8)
#define RCC_MC_AHB2ENSETR_SDMMC3EN		BIT(16)

/* RCC_MC_AHB2ENCLRR register fields */
#define RCC_MC_AHB2ENCLRR_DMA1EN		BIT(0)
#define RCC_MC_AHB2ENCLRR_DMA2EN		BIT(1)
#define RCC_MC_AHB2ENCLRR_DMAMUXEN		BIT(2)
#define RCC_MC_AHB2ENCLRR_ADC12EN		BIT(5)
#define RCC_MC_AHB2ENCLRR_USBOEN		BIT(8)
#define RCC_MC_AHB2ENCLRR_SDMMC3EN		BIT(16)

/* RCC_MC_AHB3ENSETR register fields */
#define RCC_MC_AHB3ENSETR_DCMIEN		BIT(0)
#define RCC_MC_AHB3ENSETR_CRYP2EN		BIT(4)
#define RCC_MC_AHB3ENSETR_HASH2EN		BIT(5)
#define RCC_MC_AHB3ENSETR_RNG2EN		BIT(6)
#define RCC_MC_AHB3ENSETR_CRC2EN		BIT(7)
#define RCC_MC_AHB3ENSETR_HSEMEN		BIT(11)
#define RCC_MC_AHB3ENSETR_IPCCEN		BIT(12)

/* RCC_MC_AHB3ENCLRR register fields */
#define RCC_MC_AHB3ENCLRR_DCMIEN		BIT(0)
#define RCC_MC_AHB3ENCLRR_CRYP2EN		BIT(4)
#define RCC_MC_AHB3ENCLRR_HASH2EN		BIT(5)
#define RCC_MC_AHB3ENCLRR_RNG2EN		BIT(6)
#define RCC_MC_AHB3ENCLRR_CRC2EN		BIT(7)
#define RCC_MC_AHB3ENCLRR_HSEMEN		BIT(11)
#define RCC_MC_AHB3ENCLRR_IPCCEN		BIT(12)

/* RCC_MC_AHB4ENSETR register fields */
#define RCC_MC_AHB4ENSETR_GPIOAEN		BIT(0)
#define RCC_MC_AHB4ENSETR_GPIOBEN		BIT(1)
#define RCC_MC_AHB4ENSETR_GPIOCEN		BIT(2)
#define RCC_MC_AHB4ENSETR_GPIODEN		BIT(3)
#define RCC_MC_AHB4ENSETR_GPIOEEN		BIT(4)
#define RCC_MC_AHB4ENSETR_GPIOFEN		BIT(5)
#define RCC_MC_AHB4ENSETR_GPIOGEN		BIT(6)
#define RCC_MC_AHB4ENSETR_GPIOHEN		BIT(7)
#define RCC_MC_AHB4ENSETR_GPIOIEN		BIT(8)
#define RCC_MC_AHB4ENSETR_GPIOJEN		BIT(9)
#define RCC_MC_AHB4ENSETR_GPIOKEN		BIT(10)

/* RCC_MC_AHB4ENCLRR register fields */
#define RCC_MC_AHB4ENCLRR_GPIOAEN		BIT(0)
#define RCC_MC_AHB4ENCLRR_GPIOBEN		BIT(1)
#define RCC_MC_AHB4ENCLRR_GPIOCEN		BIT(2)
#define RCC_MC_AHB4ENCLRR_GPIODEN		BIT(3)
#define RCC_MC_AHB4ENCLRR_GPIOEEN		BIT(4)
#define RCC_MC_AHB4ENCLRR_GPIOFEN		BIT(5)
#define RCC_MC_AHB4ENCLRR_GPIOGEN		BIT(6)
#define RCC_MC_AHB4ENCLRR_GPIOHEN		BIT(7)
#define RCC_MC_AHB4ENCLRR_GPIOIEN		BIT(8)
#define RCC_MC_AHB4ENCLRR_GPIOJEN		BIT(9)
#define RCC_MC_AHB4ENCLRR_GPIOKEN		BIT(10)

/* RCC_MC_AXIMENSETR register fields */
#define RCC_MC_AXIMENSETR_SYSRAMEN		BIT(0)

/* RCC_MC_AXIMENCLRR register fields */
#define RCC_MC_AXIMENCLRR_SYSRAMEN		BIT(0)

/* RCC_MC_MLAHBENSETR register fields */
#define RCC_MC_MLAHBENSETR_RETRAMEN		BIT(4)

/* RCC_MC_MLAHBENCLRR register fields */
#define RCC_MC_MLAHBENCLRR_RETRAMEN		BIT(4)

/* RCC_MP_APB1LPENSETR register fields */
#define RCC_MP_APB1LPENSETR_TIM2LPEN		BIT(0)
#define RCC_MP_APB1LPENSETR_TIM3LPEN		BIT(1)
#define RCC_MP_APB1LPENSETR_TIM4LPEN		BIT(2)
#define RCC_MP_APB1LPENSETR_TIM5LPEN		BIT(3)
#define RCC_MP_APB1LPENSETR_TIM6LPEN		BIT(4)
#define RCC_MP_APB1LPENSETR_TIM7LPEN		BIT(5)
#define RCC_MP_APB1LPENSETR_TIM12LPEN		BIT(6)
#define RCC_MP_APB1LPENSETR_TIM13LPEN		BIT(7)
#define RCC_MP_APB1LPENSETR_TIM14LPEN		BIT(8)
#define RCC_MP_APB1LPENSETR_LPTIM1LPEN		BIT(9)
#define RCC_MP_APB1LPENSETR_SPI2LPEN		BIT(11)
#define RCC_MP_APB1LPENSETR_SPI3LPEN		BIT(12)
#define RCC_MP_APB1LPENSETR_USART2LPEN		BIT(14)
#define RCC_MP_APB1LPENSETR_USART3LPEN		BIT(15)
#define RCC_MP_APB1LPENSETR_UART4LPEN		BIT(16)
#define RCC_MP_APB1LPENSETR_UART5LPEN		BIT(17)
#define RCC_MP_APB1LPENSETR_UART7LPEN		BIT(18)
#define RCC_MP_APB1LPENSETR_UART8LPEN		BIT(19)
#define RCC_MP_APB1LPENSETR_I2C1LPEN		BIT(21)
#define RCC_MP_APB1LPENSETR_I2C2LPEN		BIT(22)
#define RCC_MP_APB1LPENSETR_I2C3LPEN		BIT(23)
#define RCC_MP_APB1LPENSETR_I2C5LPEN		BIT(24)
#define RCC_MP_APB1LPENSETR_SPDIFLPEN		BIT(26)
#define RCC_MP_APB1LPENSETR_CECLPEN		BIT(27)
#define RCC_MP_APB1LPENSETR_DAC12LPEN		BIT(29)
#define RCC_MP_APB1LPENSETR_MDIOSLPEN		BIT(31)

/* RCC_MP_APB1LPENCLRR register fields */
#define RCC_MP_APB1LPENCLRR_TIM2LPEN		BIT(0)
#define RCC_MP_APB1LPENCLRR_TIM3LPEN		BIT(1)
#define RCC_MP_APB1LPENCLRR_TIM4LPEN		BIT(2)
#define RCC_MP_APB1LPENCLRR_TIM5LPEN		BIT(3)
#define RCC_MP_APB1LPENCLRR_TIM6LPEN		BIT(4)
#define RCC_MP_APB1LPENCLRR_TIM7LPEN		BIT(5)
#define RCC_MP_APB1LPENCLRR_TIM12LPEN		BIT(6)
#define RCC_MP_APB1LPENCLRR_TIM13LPEN		BIT(7)
#define RCC_MP_APB1LPENCLRR_TIM14LPEN		BIT(8)
#define RCC_MP_APB1LPENCLRR_LPTIM1LPEN		BIT(9)
#define RCC_MP_APB1LPENCLRR_SPI2LPEN		BIT(11)
#define RCC_MP_APB1LPENCLRR_SPI3LPEN		BIT(12)
#define RCC_MP_APB1LPENCLRR_USART2LPEN		BIT(14)
#define RCC_MP_APB1LPENCLRR_USART3LPEN		BIT(15)
#define RCC_MP_APB1LPENCLRR_UART4LPEN		BIT(16)
#define RCC_MP_APB1LPENCLRR_UART5LPEN		BIT(17)
#define RCC_MP_APB1LPENCLRR_UART7LPEN		BIT(18)
#define RCC_MP_APB1LPENCLRR_UART8LPEN		BIT(19)
#define RCC_MP_APB1LPENCLRR_I2C1LPEN		BIT(21)
#define RCC_MP_APB1LPENCLRR_I2C2LPEN		BIT(22)
#define RCC_MP_APB1LPENCLRR_I2C3LPEN		BIT(23)
#define RCC_MP_APB1LPENCLRR_I2C5LPEN		BIT(24)
#define RCC_MP_APB1LPENCLRR_SPDIFLPEN		BIT(26)
#define RCC_MP_APB1LPENCLRR_CECLPEN		BIT(27)
#define RCC_MP_APB1LPENCLRR_DAC12LPEN		BIT(29)
#define RCC_MP_APB1LPENCLRR_MDIOSLPEN		BIT(31)

/* RCC_MP_APB2LPENSETR register fields */
#define RCC_MP_APB2LPENSETR_TIM1LPEN		BIT(0)
#define RCC_MP_APB2LPENSETR_TIM8LPEN		BIT(1)
#define RCC_MP_APB2LPENSETR_TIM15LPEN		BIT(2)
#define RCC_MP_APB2LPENSETR_TIM16LPEN		BIT(3)
#define RCC_MP_APB2LPENSETR_TIM17LPEN		BIT(4)
#define RCC_MP_APB2LPENSETR_SPI1LPEN		BIT(8)
#define RCC_MP_APB2LPENSETR_SPI4LPEN		BIT(9)
#define RCC_MP_APB2LPENSETR_SPI5LPEN		BIT(10)
#define RCC_MP_APB2LPENSETR_USART6LPEN		BIT(13)
#define RCC_MP_APB2LPENSETR_SAI1LPEN		BIT(16)
#define RCC_MP_APB2LPENSETR_SAI2LPEN		BIT(17)
#define RCC_MP_APB2LPENSETR_SAI3LPEN		BIT(18)
#define RCC_MP_APB2LPENSETR_DFSDMLPEN		BIT(20)
#define RCC_MP_APB2LPENSETR_ADFSDMLPEN		BIT(21)
#define RCC_MP_APB2LPENSETR_FDCANLPEN		BIT(24)

/* RCC_MP_APB2LPENCLRR register fields */
#define RCC_MP_APB2LPENCLRR_TIM1LPEN		BIT(0)
#define RCC_MP_APB2LPENCLRR_TIM8LPEN		BIT(1)
#define RCC_MP_APB2LPENCLRR_TIM15LPEN		BIT(2)
#define RCC_MP_APB2LPENCLRR_TIM16LPEN		BIT(3)
#define RCC_MP_APB2LPENCLRR_TIM17LPEN		BIT(4)
#define RCC_MP_APB2LPENCLRR_SPI1LPEN		BIT(8)
#define RCC_MP_APB2LPENCLRR_SPI4LPEN		BIT(9)
#define RCC_MP_APB2LPENCLRR_SPI5LPEN		BIT(10)
#define RCC_MP_APB2LPENCLRR_USART6LPEN		BIT(13)
#define RCC_MP_APB2LPENCLRR_SAI1LPEN		BIT(16)
#define RCC_MP_APB2LPENCLRR_SAI2LPEN		BIT(17)
#define RCC_MP_APB2LPENCLRR_SAI3LPEN		BIT(18)
#define RCC_MP_APB2LPENCLRR_DFSDMLPEN		BIT(20)
#define RCC_MP_APB2LPENCLRR_ADFSDMLPEN		BIT(21)
#define RCC_MP_APB2LPENCLRR_FDCANLPEN		BIT(24)

/* RCC_MP_APB3LPENSETR register fields */
#define RCC_MP_APB3LPENSETR_LPTIM2LPEN		BIT(0)
#define RCC_MP_APB3LPENSETR_LPTIM3LPEN		BIT(1)
#define RCC_MP_APB3LPENSETR_LPTIM4LPEN		BIT(2)
#define RCC_MP_APB3LPENSETR_LPTIM5LPEN		BIT(3)
#define RCC_MP_APB3LPENSETR_SAI4LPEN		BIT(8)
#define RCC_MP_APB3LPENSETR_SYSCFGLPEN		BIT(11)
#define RCC_MP_APB3LPENSETR_VREFLPEN		BIT(13)
#define RCC_MP_APB3LPENSETR_TMPSENSLPEN		BIT(16)
#define RCC_MP_APB3LPENSETR_PMBCTRLLPEN		BIT(17)

/* RCC_MP_APB3LPENCLRR register fields */
#define RCC_MP_APB3LPENCLRR_LPTIM2LPEN		BIT(0)
#define RCC_MP_APB3LPENCLRR_LPTIM3LPEN		BIT(1)
#define RCC_MP_APB3LPENCLRR_LPTIM4LPEN		BIT(2)
#define RCC_MP_APB3LPENCLRR_LPTIM5LPEN		BIT(3)
#define RCC_MP_APB3LPENCLRR_SAI4LPEN		BIT(8)
#define RCC_MP_APB3LPENCLRR_SYSCFGLPEN		BIT(11)
#define RCC_MP_APB3LPENCLRR_VREFLPEN		BIT(13)
#define RCC_MP_APB3LPENCLRR_TMPSENSLPEN		BIT(16)
#define RCC_MP_APB3LPENCLRR_PMBCTRLLPEN		BIT(17)

/* RCC_MP_AHB2LPENSETR register fields */
#define RCC_MP_AHB2LPENSETR_DMA1LPEN		BIT(0)
#define RCC_MP_AHB2LPENSETR_DMA2LPEN		BIT(1)
#define RCC_MP_AHB2LPENSETR_DMAMUXLPEN		BIT(2)
#define RCC_MP_AHB2LPENSETR_ADC12LPEN		BIT(5)
#define RCC_MP_AHB2LPENSETR_USBOLPEN		BIT(8)
#define RCC_MP_AHB2LPENSETR_SDMMC3LPEN		BIT(16)

/* RCC_MP_AHB2LPENCLRR register fields */
#define RCC_MP_AHB2LPENCLRR_DMA1LPEN		BIT(0)
#define RCC_MP_AHB2LPENCLRR_DMA2LPEN		BIT(1)
#define RCC_MP_AHB2LPENCLRR_DMAMUXLPEN		BIT(2)
#define RCC_MP_AHB2LPENCLRR_ADC12LPEN		BIT(5)
#define RCC_MP_AHB2LPENCLRR_USBOLPEN		BIT(8)
#define RCC_MP_AHB2LPENCLRR_SDMMC3LPEN		BIT(16)

/* RCC_MP_AHB3LPENSETR register fields */
#define RCC_MP_AHB3LPENSETR_DCMILPEN		BIT(0)
#define RCC_MP_AHB3LPENSETR_CRYP2LPEN		BIT(4)
#define RCC_MP_AHB3LPENSETR_HASH2LPEN		BIT(5)
#define RCC_MP_AHB3LPENSETR_RNG2LPEN		BIT(6)
#define RCC_MP_AHB3LPENSETR_CRC2LPEN		BIT(7)
#define RCC_MP_AHB3LPENSETR_HSEMLPEN		BIT(11)
#define RCC_MP_AHB3LPENSETR_IPCCLPEN		BIT(12)

/* RCC_MP_AHB3LPENCLRR register fields */
#define RCC_MP_AHB3LPENCLRR_DCMILPEN		BIT(0)
#define RCC_MP_AHB3LPENCLRR_CRYP2LPEN		BIT(4)
#define RCC_MP_AHB3LPENCLRR_HASH2LPEN		BIT(5)
#define RCC_MP_AHB3LPENCLRR_RNG2LPEN		BIT(6)
#define RCC_MP_AHB3LPENCLRR_CRC2LPEN		BIT(7)
#define RCC_MP_AHB3LPENCLRR_HSEMLPEN		BIT(11)
#define RCC_MP_AHB3LPENCLRR_IPCCLPEN		BIT(12)

/* RCC_MP_AHB4LPENSETR register fields */
#define RCC_MP_AHB4LPENSETR_GPIOALPEN		BIT(0)
#define RCC_MP_AHB4LPENSETR_GPIOBLPEN		BIT(1)
#define RCC_MP_AHB4LPENSETR_GPIOCLPEN		BIT(2)
#define RCC_MP_AHB4LPENSETR_GPIODLPEN		BIT(3)
#define RCC_MP_AHB4LPENSETR_GPIOELPEN		BIT(4)
#define RCC_MP_AHB4LPENSETR_GPIOFLPEN		BIT(5)
#define RCC_MP_AHB4LPENSETR_GPIOGLPEN		BIT(6)
#define RCC_MP_AHB4LPENSETR_GPIOHLPEN		BIT(7)
#define RCC_MP_AHB4LPENSETR_GPIOILPEN		BIT(8)
#define RCC_MP_AHB4LPENSETR_GPIOJLPEN		BIT(9)
#define RCC_MP_AHB4LPENSETR_GPIOKLPEN		BIT(10)

/* RCC_MP_AHB4LPENCLRR register fields */
#define RCC_MP_AHB4LPENCLRR_GPIOALPEN		BIT(0)
#define RCC_MP_AHB4LPENCLRR_GPIOBLPEN		BIT(1)
#define RCC_MP_AHB4LPENCLRR_GPIOCLPEN		BIT(2)
#define RCC_MP_AHB4LPENCLRR_GPIODLPEN		BIT(3)
#define RCC_MP_AHB4LPENCLRR_GPIOELPEN		BIT(4)
#define RCC_MP_AHB4LPENCLRR_GPIOFLPEN		BIT(5)
#define RCC_MP_AHB4LPENCLRR_GPIOGLPEN		BIT(6)
#define RCC_MP_AHB4LPENCLRR_GPIOHLPEN		BIT(7)
#define RCC_MP_AHB4LPENCLRR_GPIOILPEN		BIT(8)
#define RCC_MP_AHB4LPENCLRR_GPIOJLPEN		BIT(9)
#define RCC_MP_AHB4LPENCLRR_GPIOKLPEN		BIT(10)

/* RCC_MP_AXIMLPENSETR register fields */
#define RCC_MP_AXIMLPENSETR_SYSRAMLPEN		BIT(0)

/* RCC_MP_AXIMLPENCLRR register fields */
#define RCC_MP_AXIMLPENCLRR_SYSRAMLPEN		BIT(0)

/* RCC_MP_MLAHBLPENSETR register fields */
#define RCC_MP_MLAHBLPENSETR_SRAM1LPEN		BIT(0)
#define RCC_MP_MLAHBLPENSETR_SRAM2LPEN		BIT(1)
#define RCC_MP_MLAHBLPENSETR_SRAM34LPEN		BIT(2)
#define RCC_MP_MLAHBLPENSETR_RETRAMLPEN		BIT(4)

/* RCC_MP_MLAHBLPENCLRR register fields */
#define RCC_MP_MLAHBLPENCLRR_SRAM1LPEN		BIT(0)
#define RCC_MP_MLAHBLPENCLRR_SRAM2LPEN		BIT(1)
#define RCC_MP_MLAHBLPENCLRR_SRAM34LPEN		BIT(2)
#define RCC_MP_MLAHBLPENCLRR_RETRAMLPEN		BIT(4)

/* RCC_MC_APB1LPENSETR register fields */
#define RCC_MC_APB1LPENSETR_TIM2LPEN		BIT(0)
#define RCC_MC_APB1LPENSETR_TIM3LPEN		BIT(1)
#define RCC_MC_APB1LPENSETR_TIM4LPEN		BIT(2)
#define RCC_MC_APB1LPENSETR_TIM5LPEN		BIT(3)
#define RCC_MC_APB1LPENSETR_TIM6LPEN		BIT(4)
#define RCC_MC_APB1LPENSETR_TIM7LPEN		BIT(5)
#define RCC_MC_APB1LPENSETR_TIM12LPEN		BIT(6)
#define RCC_MC_APB1LPENSETR_TIM13LPEN		BIT(7)
#define RCC_MC_APB1LPENSETR_TIM14LPEN		BIT(8)
#define RCC_MC_APB1LPENSETR_LPTIM1LPEN		BIT(9)
#define RCC_MC_APB1LPENSETR_SPI2LPEN		BIT(11)
#define RCC_MC_APB1LPENSETR_SPI3LPEN		BIT(12)
#define RCC_MC_APB1LPENSETR_USART2LPEN		BIT(14)
#define RCC_MC_APB1LPENSETR_USART3LPEN		BIT(15)
#define RCC_MC_APB1LPENSETR_UART4LPEN		BIT(16)
#define RCC_MC_APB1LPENSETR_UART5LPEN		BIT(17)
#define RCC_MC_APB1LPENSETR_UART7LPEN		BIT(18)
#define RCC_MC_APB1LPENSETR_UART8LPEN		BIT(19)
#define RCC_MC_APB1LPENSETR_I2C1LPEN		BIT(21)
#define RCC_MC_APB1LPENSETR_I2C2LPEN		BIT(22)
#define RCC_MC_APB1LPENSETR_I2C3LPEN		BIT(23)
#define RCC_MC_APB1LPENSETR_I2C5LPEN		BIT(24)
#define RCC_MC_APB1LPENSETR_SPDIFLPEN		BIT(26)
#define RCC_MC_APB1LPENSETR_CECLPEN		BIT(27)
#define RCC_MC_APB1LPENSETR_WWDG1LPEN		BIT(28)
#define RCC_MC_APB1LPENSETR_DAC12LPEN		BIT(29)
#define RCC_MC_APB1LPENSETR_MDIOSLPEN		BIT(31)

/* RCC_MC_APB1LPENCLRR register fields */
#define RCC_MC_APB1LPENCLRR_TIM2LPEN		BIT(0)
#define RCC_MC_APB1LPENCLRR_TIM3LPEN		BIT(1)
#define RCC_MC_APB1LPENCLRR_TIM4LPEN		BIT(2)
#define RCC_MC_APB1LPENCLRR_TIM5LPEN		BIT(3)
#define RCC_MC_APB1LPENCLRR_TIM6LPEN		BIT(4)
#define RCC_MC_APB1LPENCLRR_TIM7LPEN		BIT(5)
#define RCC_MC_APB1LPENCLRR_TIM12LPEN		BIT(6)
#define RCC_MC_APB1LPENCLRR_TIM13LPEN		BIT(7)
#define RCC_MC_APB1LPENCLRR_TIM14LPEN		BIT(8)
#define RCC_MC_APB1LPENCLRR_LPTIM1LPEN		BIT(9)
#define RCC_MC_APB1LPENCLRR_SPI2LPEN		BIT(11)
#define RCC_MC_APB1LPENCLRR_SPI3LPEN		BIT(12)
#define RCC_MC_APB1LPENCLRR_USART2LPEN		BIT(14)
#define RCC_MC_APB1LPENCLRR_USART3LPEN		BIT(15)
#define RCC_MC_APB1LPENCLRR_UART4LPEN		BIT(16)
#define RCC_MC_APB1LPENCLRR_UART5LPEN		BIT(17)
#define RCC_MC_APB1LPENCLRR_UART7LPEN		BIT(18)
#define RCC_MC_APB1LPENCLRR_UART8LPEN		BIT(19)
#define RCC_MC_APB1LPENCLRR_I2C1LPEN		BIT(21)
#define RCC_MC_APB1LPENCLRR_I2C2LPEN		BIT(22)
#define RCC_MC_APB1LPENCLRR_I2C3LPEN		BIT(23)
#define RCC_MC_APB1LPENCLRR_I2C5LPEN		BIT(24)
#define RCC_MC_APB1LPENCLRR_SPDIFLPEN		BIT(26)
#define RCC_MC_APB1LPENCLRR_CECLPEN		BIT(27)
#define RCC_MC_APB1LPENCLRR_WWDG1LPEN		BIT(28)
#define RCC_MC_APB1LPENCLRR_DAC12LPEN		BIT(29)
#define RCC_MC_APB1LPENCLRR_MDIOSLPEN		BIT(31)

/* RCC_MC_APB2LPENSETR register fields */
#define RCC_MC_APB2LPENSETR_TIM1LPEN		BIT(0)
#define RCC_MC_APB2LPENSETR_TIM8LPEN		BIT(1)
#define RCC_MC_APB2LPENSETR_TIM15LPEN		BIT(2)
#define RCC_MC_APB2LPENSETR_TIM16LPEN		BIT(3)
#define RCC_MC_APB2LPENSETR_TIM17LPEN		BIT(4)
#define RCC_MC_APB2LPENSETR_SPI1LPEN		BIT(8)
#define RCC_MC_APB2LPENSETR_SPI4LPEN		BIT(9)
#define RCC_MC_APB2LPENSETR_SPI5LPEN		BIT(10)
#define RCC_MC_APB2LPENSETR_USART6LPEN		BIT(13)
#define RCC_MC_APB2LPENSETR_SAI1LPEN		BIT(16)
#define RCC_MC_APB2LPENSETR_SAI2LPEN		BIT(17)
#define RCC_MC_APB2LPENSETR_SAI3LPEN		BIT(18)
#define RCC_MC_APB2LPENSETR_DFSDMLPEN		BIT(20)
#define RCC_MC_APB2LPENSETR_ADFSDMLPEN		BIT(21)
#define RCC_MC_APB2LPENSETR_FDCANLPEN		BIT(24)

/* RCC_MC_APB2LPENCLRR register fields */
#define RCC_MC_APB2LPENCLRR_TIM1LPEN		BIT(0)
#define RCC_MC_APB2LPENCLRR_TIM8LPEN		BIT(1)
#define RCC_MC_APB2LPENCLRR_TIM15LPEN		BIT(2)
#define RCC_MC_APB2LPENCLRR_TIM16LPEN		BIT(3)
#define RCC_MC_APB2LPENCLRR_TIM17LPEN		BIT(4)
#define RCC_MC_APB2LPENCLRR_SPI1LPEN		BIT(8)
#define RCC_MC_APB2LPENCLRR_SPI4LPEN		BIT(9)
#define RCC_MC_APB2LPENCLRR_SPI5LPEN		BIT(10)
#define RCC_MC_APB2LPENCLRR_USART6LPEN		BIT(13)
#define RCC_MC_APB2LPENCLRR_SAI1LPEN		BIT(16)
#define RCC_MC_APB2LPENCLRR_SAI2LPEN		BIT(17)
#define RCC_MC_APB2LPENCLRR_SAI3LPEN		BIT(18)
#define RCC_MC_APB2LPENCLRR_DFSDMLPEN		BIT(20)
#define RCC_MC_APB2LPENCLRR_ADFSDMLPEN		BIT(21)
#define RCC_MC_APB2LPENCLRR_FDCANLPEN		BIT(24)

/* RCC_MC_APB3LPENSETR register fields */
#define RCC_MC_APB3LPENSETR_LPTIM2LPEN		BIT(0)
#define RCC_MC_APB3LPENSETR_LPTIM3LPEN		BIT(1)
#define RCC_MC_APB3LPENSETR_LPTIM4LPEN		BIT(2)
#define RCC_MC_APB3LPENSETR_LPTIM5LPEN		BIT(3)
#define RCC_MC_APB3LPENSETR_SAI4LPEN		BIT(8)
#define RCC_MC_APB3LPENSETR_SYSCFGLPEN		BIT(11)
#define RCC_MC_APB3LPENSETR_VREFLPEN		BIT(13)
#define RCC_MC_APB3LPENSETR_TMPSENSLPEN		BIT(16)
#define RCC_MC_APB3LPENSETR_PMBCTRLLPEN		BIT(17)

/* RCC_MC_APB3LPENCLRR register fields */
#define RCC_MC_APB3LPENCLRR_LPTIM2LPEN		BIT(0)
#define RCC_MC_APB3LPENCLRR_LPTIM3LPEN		BIT(1)
#define RCC_MC_APB3LPENCLRR_LPTIM4LPEN		BIT(2)
#define RCC_MC_APB3LPENCLRR_LPTIM5LPEN		BIT(3)
#define RCC_MC_APB3LPENCLRR_SAI4LPEN		BIT(8)
#define RCC_MC_APB3LPENCLRR_SYSCFGLPEN		BIT(11)
#define RCC_MC_APB3LPENCLRR_VREFLPEN		BIT(13)
#define RCC_MC_APB3LPENCLRR_TMPSENSLPEN		BIT(16)
#define RCC_MC_APB3LPENCLRR_PMBCTRLLPEN		BIT(17)

/* RCC_MC_AHB2LPENSETR register fields */
#define RCC_MC_AHB2LPENSETR_DMA1LPEN		BIT(0)
#define RCC_MC_AHB2LPENSETR_DMA2LPEN		BIT(1)
#define RCC_MC_AHB2LPENSETR_DMAMUXLPEN		BIT(2)
#define RCC_MC_AHB2LPENSETR_ADC12LPEN		BIT(5)
#define RCC_MC_AHB2LPENSETR_USBOLPEN		BIT(8)
#define RCC_MC_AHB2LPENSETR_SDMMC3LPEN		BIT(16)

/* RCC_MC_AHB2LPENCLRR register fields */
#define RCC_MC_AHB2LPENCLRR_DMA1LPEN		BIT(0)
#define RCC_MC_AHB2LPENCLRR_DMA2LPEN		BIT(1)
#define RCC_MC_AHB2LPENCLRR_DMAMUXLPEN		BIT(2)
#define RCC_MC_AHB2LPENCLRR_ADC12LPEN		BIT(5)
#define RCC_MC_AHB2LPENCLRR_USBOLPEN		BIT(8)
#define RCC_MC_AHB2LPENCLRR_SDMMC3LPEN		BIT(16)

/* RCC_MC_AHB3LPENSETR register fields */
#define RCC_MC_AHB3LPENSETR_DCMILPEN		BIT(0)
#define RCC_MC_AHB3LPENSETR_CRYP2LPEN		BIT(4)
#define RCC_MC_AHB3LPENSETR_HASH2LPEN		BIT(5)
#define RCC_MC_AHB3LPENSETR_RNG2LPEN		BIT(6)
#define RCC_MC_AHB3LPENSETR_CRC2LPEN		BIT(7)
#define RCC_MC_AHB3LPENSETR_HSEMLPEN		BIT(11)
#define RCC_MC_AHB3LPENSETR_IPCCLPEN		BIT(12)

/* RCC_MC_AHB3LPENCLRR register fields */
#define RCC_MC_AHB3LPENCLRR_DCMILPEN		BIT(0)
#define RCC_MC_AHB3LPENCLRR_CRYP2LPEN		BIT(4)
#define RCC_MC_AHB3LPENCLRR_HASH2LPEN		BIT(5)
#define RCC_MC_AHB3LPENCLRR_RNG2LPEN		BIT(6)
#define RCC_MC_AHB3LPENCLRR_CRC2LPEN		BIT(7)
#define RCC_MC_AHB3LPENCLRR_HSEMLPEN		BIT(11)
#define RCC_MC_AHB3LPENCLRR_IPCCLPEN		BIT(12)

/* RCC_MC_AHB4LPENSETR register fields */
#define RCC_MC_AHB4LPENSETR_GPIOALPEN		BIT(0)
#define RCC_MC_AHB4LPENSETR_GPIOBLPEN		BIT(1)
#define RCC_MC_AHB4LPENSETR_GPIOCLPEN		BIT(2)
#define RCC_MC_AHB4LPENSETR_GPIODLPEN		BIT(3)
#define RCC_MC_AHB4LPENSETR_GPIOELPEN		BIT(4)
#define RCC_MC_AHB4LPENSETR_GPIOFLPEN		BIT(5)
#define RCC_MC_AHB4LPENSETR_GPIOGLPEN		BIT(6)
#define RCC_MC_AHB4LPENSETR_GPIOHLPEN		BIT(7)
#define RCC_MC_AHB4LPENSETR_GPIOILPEN		BIT(8)
#define RCC_MC_AHB4LPENSETR_GPIOJLPEN		BIT(9)
#define RCC_MC_AHB4LPENSETR_GPIOKLPEN		BIT(10)

/* RCC_MC_AHB4LPENCLRR register fields */
#define RCC_MC_AHB4LPENCLRR_GPIOALPEN		BIT(0)
#define RCC_MC_AHB4LPENCLRR_GPIOBLPEN		BIT(1)
#define RCC_MC_AHB4LPENCLRR_GPIOCLPEN		BIT(2)
#define RCC_MC_AHB4LPENCLRR_GPIODLPEN		BIT(3)
#define RCC_MC_AHB4LPENCLRR_GPIOELPEN		BIT(4)
#define RCC_MC_AHB4LPENCLRR_GPIOFLPEN		BIT(5)
#define RCC_MC_AHB4LPENCLRR_GPIOGLPEN		BIT(6)
#define RCC_MC_AHB4LPENCLRR_GPIOHLPEN		BIT(7)
#define RCC_MC_AHB4LPENCLRR_GPIOILPEN		BIT(8)
#define RCC_MC_AHB4LPENCLRR_GPIOJLPEN		BIT(9)
#define RCC_MC_AHB4LPENCLRR_GPIOKLPEN		BIT(10)

/* RCC_MC_AXIMLPENSETR register fields */
#define RCC_MC_AXIMLPENSETR_SYSRAMLPEN		BIT(0)

/* RCC_MC_AXIMLPENCLRR register fields */
#define RCC_MC_AXIMLPENCLRR_SYSRAMLPEN		BIT(0)

/* RCC_MC_MLAHBLPENSETR register fields */
#define RCC_MC_MLAHBLPENSETR_SRAM1LPEN		BIT(0)
#define RCC_MC_MLAHBLPENSETR_SRAM2LPEN		BIT(1)
#define RCC_MC_MLAHBLPENSETR_SRAM34LPEN		BIT(2)
#define RCC_MC_MLAHBLPENSETR_RETRAMLPEN		BIT(4)

/* RCC_MC_MLAHBLPENCLRR register fields */
#define RCC_MC_MLAHBLPENCLRR_SRAM1LPEN		BIT(0)
#define RCC_MC_MLAHBLPENCLRR_SRAM2LPEN		BIT(1)
#define RCC_MC_MLAHBLPENCLRR_SRAM34LPEN		BIT(2)
#define RCC_MC_MLAHBLPENCLRR_RETRAMLPEN		BIT(4)

/* RCC_MC_RSTSCLRR register fields */
#define RCC_MC_RSTSCLRR_PORRSTF			BIT(0)
#define RCC_MC_RSTSCLRR_BORRSTF			BIT(1)
#define RCC_MC_RSTSCLRR_PADRSTF			BIT(2)
#define RCC_MC_RSTSCLRR_HCSSRSTF		BIT(3)
#define RCC_MC_RSTSCLRR_VCORERSTF		BIT(4)
#define RCC_MC_RSTSCLRR_MCURSTF			BIT(5)
#define RCC_MC_RSTSCLRR_MPSYSRSTF		BIT(6)
#define RCC_MC_RSTSCLRR_MCSYSRSTF		BIT(7)
#define RCC_MC_RSTSCLRR_IWDG1RSTF		BIT(8)
#define RCC_MC_RSTSCLRR_IWDG2RSTF		BIT(9)
#define RCC_MC_RSTSCLRR_WWDG1RSTF		BIT(10)

/* RCC_MC_CIER register fields */
#define RCC_MC_CIER_LSIRDYIE			BIT(0)
#define RCC_MC_CIER_LSERDYIE			BIT(1)
#define RCC_MC_CIER_HSIRDYIE			BIT(2)
#define RCC_MC_CIER_HSERDYIE			BIT(3)
#define RCC_MC_CIER_CSIRDYIE			BIT(4)
#define RCC_MC_CIER_PLL1DYIE			BIT(8)
#define RCC_MC_CIER_PLL2DYIE			BIT(9)
#define RCC_MC_CIER_PLL3DYIE			BIT(10)
#define RCC_MC_CIER_PLL4DYIE			BIT(11)
#define RCC_MC_CIER_LSECSSIE			BIT(16)
#define RCC_MC_CIER_WKUPIE			BIT(20)

/* RCC_MC_CIFR register fields */
#define RCC_MC_CIFR_LSIRDYF			BIT(0)
#define RCC_MC_CIFR_LSERDYF			BIT(1)
#define RCC_MC_CIFR_HSIRDYF			BIT(2)
#define RCC_MC_CIFR_HSERDYF			BIT(3)
#define RCC_MC_CIFR_CSIRDYF			BIT(4)
#define RCC_MC_CIFR_PLL1DYF			BIT(8)
#define RCC_MC_CIFR_PLL2DYF			BIT(9)
#define RCC_MC_CIFR_PLL3DYF			BIT(10)
#define RCC_MC_CIFR_PLL4DYF			BIT(11)
#define RCC_MC_CIFR_LSECSSF			BIT(16)
#define RCC_MC_CIFR_WKUPF			BIT(20)

/* RCC_VERR register fields */
#define RCC_VERR_MINREV_MASK			GENMASK(3, 0)
#define RCC_VERR_MINREV_SHIFT			0
#define RCC_VERR_MAJREV_MASK			GENMASK(7, 4)
#define RCC_VERR_MAJREV_SHIFT			4

/* Used for RCC_OCENSETR and RCC_OCENCLRR registers */
#define RCC_OCENR_HSION				BIT(0)
#define RCC_OCENR_HSIKERON			BIT(1)
#define RCC_OCENR_CSION				BIT(4)
#define RCC_OCENR_CSIKERON			BIT(5)
#define RCC_OCENR_DIGBYP			BIT(7)
#define RCC_OCENR_HSEON				BIT(8)
#define RCC_OCENR_HSEKERON			BIT(9)
#define RCC_OCENR_HSEBYP			BIT(10)
#define RCC_OCENR_HSECSSON			BIT(11)

/* Offset between RCC_MP_xxxENSETR and RCC_MP_xxxENCLRR registers */
#define RCC_MP_ENCLRR_OFFSET			U(4)

/* Offset between RCC_xxxRSTSETR and RCC_xxxRSTCLRR registers */
#define RCC_RSTCLRR_OFFSET			U(4)

/* Used for most of DIVR register: max div for RTC */
#define RCC_DIVR_DIV_MASK			GENMASK(5, 0)
#define RCC_DIVR_DIVRDY				BIT(31)

/* Masks for specific DIVR registers */
#define RCC_APBXDIV_MASK			GENMASK(2, 0)
#define RCC_MPUDIV_MASK				GENMASK(2, 0)
#define RCC_AXIDIV_MASK				GENMASK(2, 0)
#define RCC_MCUDIV_MASK				GENMASK(3, 0)

/* Used for most of RCC_<x>SELR registers */
#define RCC_SELR_SRC_MASK			GENMASK(2, 0)
#define RCC_SELR_REFCLK_SRC_MASK		GENMASK(1, 0)
#define RCC_SELR_SRCRDY				BIT(31)

/* Used for all RCC_PLL<n>CR registers */
#define RCC_PLLNCR_PLLON			BIT(0)
#define RCC_PLLNCR_PLLRDY			BIT(1)
#define RCC_PLLNCR_SSCG_CTRL			BIT(2)
#define RCC_PLLNCR_DIVPEN			BIT(4)
#define RCC_PLLNCR_DIVQEN			BIT(5)
#define RCC_PLLNCR_DIVREN			BIT(6)
#define RCC_PLLNCR_DIVEN_SHIFT			4

/* Used for all RCC_PLL<n>CFGR1 registers */
#define RCC_PLLNCFGR1_DIVM_MASK			GENMASK(21, 16)
#define RCC_PLLNCFGR1_DIVM_SHIFT		16
#define RCC_PLLNCFGR1_DIVN_MASK			GENMASK(8, 0)
#define RCC_PLLNCFGR1_DIVN_SHIFT		0

/* Only for PLL3 and PLL4 */
#define RCC_PLLNCFGR1_IFRGE_MASK		GENMASK(25, 24)
#define RCC_PLLNCFGR1_IFRGE_SHIFT		24

/* Used for all RCC_PLL<n>CFGR2 registers */
#define RCC_PLLNCFGR2_DIVX_MASK			GENMASK(6, 0)
#define RCC_PLLNCFGR2_DIVP_MASK			GENMASK(6, 0)
#define RCC_PLLNCFGR2_DIVP_SHIFT		0
#define RCC_PLLNCFGR2_DIVQ_MASK			GENMASK(14, 8)
#define RCC_PLLNCFGR2_DIVQ_SHIFT		8
#define RCC_PLLNCFGR2_DIVR_MASK			GENMASK(22, 16)
#define RCC_PLLNCFGR2_DIVR_SHIFT		16

/* Used for all RCC_PLL<n>FRACR registers */
#define RCC_PLLNFRACR_FRACV_SHIFT		3
#define RCC_PLLNFRACR_FRACV_MASK		GENMASK(15, 3)
#define RCC_PLLNFRACR_FRACLE			BIT(16)

/* Used for all RCC_PLL<n>CSGR registers */
#define RCC_PLLNCSGR_INC_STEP_SHIFT		16
#define RCC_PLLNCSGR_INC_STEP_MASK		GENMASK(30, 16)
#define RCC_PLLNCSGR_MOD_PER_SHIFT		0
#define RCC_PLLNCSGR_MOD_PER_MASK		GENMASK(12, 0)
#define RCC_PLLNCSGR_SSCG_MODE_SHIFT		15
#define RCC_PLLNCSGR_SSCG_MODE_MASK		BIT(15)

/* Used for TIMER Prescaler */
#define RCC_TIMGXPRER_TIMGXPRE			BIT(0)

/* Used for RCC_MCO related operations */
#define RCC_MCOCFG_MCOON			BIT(12)
#define RCC_MCOCFG_MCODIV_MASK			GENMASK(7, 4)
#define RCC_MCOCFG_MCODIV_SHIFT			4
#define RCC_MCOCFG_MCOSRC_MASK			GENMASK(2, 0)

#endif /* STM32MP1_RCC_H */
