/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument.pass1;

import java.util.Arrays;
import java.util.LinkedList;
import org.objectweb.asm.Label;

public class CodeFootstamp {
    private final LinkedList<String> events = new LinkedList();
    private boolean finalized = false;

    public void visitLabel(Label label) {
        this.appendIfNotFinal("L");
    }

    private void appendIfNotFinal(String string) {
        this.assertNotFinal();
        this.events.addLast(string);
    }

    private void assertNotFinal() {
        if (this.finalized) {
            throw new IllegalStateException("The signature has bean already finalized");
        }
    }

    public void visitFieldInsn(int access, String name, String description, String signature) {
        this.appendIfNotFinal("F:" + access + ":" + name + ":" + description + ":" + signature);
    }

    public void visitInsn(int opCode) {
        this.appendIfNotFinal(String.valueOf(opCode));
    }

    void visitIntInsn(int opCode, int variable) {
        this.appendIfNotFinal(opCode + ":" + variable);
    }

    public void visitIintInsn(int opCode, int variable) {
        this.appendIfNotFinal(opCode + ":" + variable);
    }

    public void visitLdcInsn(Object obj) {
        this.appendIfNotFinal("LDC:" + obj.toString());
    }

    public void visitJumpInsn(int opCode, Label label) {
        this.appendIfNotFinal("JUMP:" + opCode);
    }

    public void visitMethodInsn(int opCode, String className, String methodName, String description) {
        this.appendIfNotFinal("MI:" + opCode + ":" + className + ":" + methodName + ":" + description);
    }

    public void visitMultiANewArrayInsn(String type, int arg1) {
        this.appendIfNotFinal("MultiArr:" + type + ":" + arg1);
    }

    public void visitLookupSwitchInsn(Label arg0, int[] arg1, Label[] arg2) {
        this.appendIfNotFinal("LSWITCH:" + Arrays.toString(arg1));
    }

    public void visitTableSwitchInsn(int arg0, int arg1, Label arg2, Label[] arg3) {
        this.appendIfNotFinal("TSWITCH:" + arg0 + ":" + arg1);
    }

    public void finalize() {
        while (this.events.size() > 0 && this.trimableIfLast(this.events.getLast())) {
            this.events.removeLast();
        }
        while (this.events.size() > 0 && this.trimableIfFirst(this.events.getFirst())) {
            this.events.removeFirst();
        }
        this.finalized = true;
    }

    private boolean trimableIfFirst(String e) {
        return e.equals("L");
    }

    private boolean trimableIfLast(String e) {
        return e.equals("JUMP:" + String.valueOf(167)) || e.equals(String.valueOf(177)) || e.equals(String.valueOf(191)) || e.equals("L");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String s : this.events) {
            sb.append(s).append(';');
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.events == null ? 0 : this.events.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeFootstamp other = (CodeFootstamp)obj;
        return !(this.events == null ? other.events != null : !this.events.equals(other.events));
    }

    public boolean isMeaningful() {
        if (!this.finalized) {
            throw new IllegalStateException("The signature should been already finalized");
        }
        return this.events.size() >= 1;
    }
}

