/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument.tp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.instrument.tp.JumpTouchPointDescriptor;
import net.sourceforge.cobertura.instrument.tp.LineTouchPointDescriptor;
import net.sourceforge.cobertura.instrument.tp.SwitchTouchPointDescriptor;
import net.sourceforge.cobertura.instrument.tp.TouchPointDescriptor;
import org.objectweb.asm.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassMap {
    private static final Logger logger = LoggerFactory.getLogger(ClassMap.class);
    private String source;
    private final Map<Integer, TouchPointDescriptor> eventId2touchPointDescriptor = new HashMap<Integer, TouchPointDescriptor>();
    private final Map<Label, Set<TouchPointDescriptor>> label2sourcePoints = new HashMap<Label, Set<TouchPointDescriptor>>();
    private final Map<Integer, Label> eventId2label = new HashMap<Integer, Label>();
    private final Set<Integer> blockedLines = new HashSet<Integer>();
    private final SortedMap<Integer, List<TouchPointDescriptor>> line2touchPoints = new TreeMap<Integer, List<TouchPointDescriptor>>();
    private final Set<Integer> alreadyRegisteredEvents = new HashSet<Integer>();
    private final Map<Label, Label> labelDuplicates2orginMap = new HashMap<Label, Label>();
    private final Map<Label, Set<Label>> labelDuplicates2duplicateMap = new HashMap<Label, Set<Label>>();
    private String className;
    private int maxCounterId = 0;

    public void setSource(String source) {
        this.source = source;
    }

    public void registerNewJump(int eventId, int currentLine, Label destinationLabel) {
        if (this.alreadyRegisteredEvents.add(eventId)) {
            logger.debug(this.className + ":" + currentLine + ": Registering JUMP (" + eventId + ") to " + destinationLabel);
            JumpTouchPointDescriptor descriptor = new JumpTouchPointDescriptor(eventId, currentLine);
            this.eventId2touchPointDescriptor.put(eventId, descriptor);
            this.getOrCreateSourcePoints(destinationLabel).add(descriptor);
            this.getOrCreateLineTouchPoints(currentLine).add(descriptor);
        } else {
            logger.debug(this.className + ":" + currentLine + ": NOT registering (already done) JUMP (" + eventId + ") to " + destinationLabel);
        }
    }

    private List<TouchPointDescriptor> getOrCreateLineTouchPoints(int currentLine) {
        LinkedList res = (LinkedList)this.line2touchPoints.get(currentLine);
        if (res == null) {
            res = new LinkedList();
            this.line2touchPoints.put(currentLine, res);
        }
        return res;
    }

    private Set<TouchPointDescriptor> getOrCreateSourcePoints(Label label) {
        Set<TouchPointDescriptor> res = this.label2sourcePoints.get(label);
        if (res == null) {
            res = new HashSet<TouchPointDescriptor>();
            this.label2sourcePoints.put(label, res);
        }
        return res;
    }

    public void registerNewLabel(int eventId, int currentLine, Label label) {
        logger.debug(this.className + ":" + currentLine + ": Registering label (" + eventId + ") " + label);
        if (this.alreadyRegisteredEvents.add(eventId)) {
            this.eventId2label.put(eventId, label);
            this.putIntoDuplicatesMaps(label, label);
        } else {
            this.putIntoDuplicatesMaps(label, this.eventId2label.get(eventId));
        }
    }

    public void putIntoDuplicatesMaps(Label label, Label orgin) {
        this.labelDuplicates2orginMap.put(label, orgin);
        Set<Label> list = this.labelDuplicates2duplicateMap.get(orgin);
        if (list == null) {
            list = new HashSet<Label>();
            this.labelDuplicates2duplicateMap.put(orgin, list);
        }
        list.add(label);
    }

    public void registerLineNumber(int eventId, int currentLine, Label label, String methodName, String methodSignature) {
        logger.debug(this.className + ":" + currentLine + ": Registering line (" + eventId + ") " + label);
        if (this.alreadyRegisteredEvents.add(eventId) && !this.blockedLines.contains(currentLine)) {
            LineTouchPointDescriptor line = new LineTouchPointDescriptor(eventId, currentLine, methodName, methodSignature);
            this.eventId2label.put(eventId, label);
            this.eventId2touchPointDescriptor.put(eventId, line);
            this.getOrCreateLineTouchPoints(currentLine).add(line);
        }
    }

    public void unregisterLine(int eventId, int currentLine) {
        if (this.alreadyRegisteredEvents.add(eventId)) {
            this.blockedLines.add(currentLine);
            List res = (List)this.line2touchPoints.get(currentLine);
            if (res != null) {
                Iterator iter = res.iterator();
                while (iter.hasNext()) {
                    TouchPointDescriptor desc = (TouchPointDescriptor)iter.next();
                    if (!(desc instanceof LineTouchPointDescriptor)) continue;
                    iter.remove();
                    this.eventId2touchPointDescriptor.remove(desc.getEventId());
                    this.eventId2label.remove(desc.getEventId());
                }
            }
        }
    }

    public void registerSwitch(int eventId, int currentLine, Label def, Label[] labels, String conditionType) {
        if (this.alreadyRegisteredEvents.add(eventId)) {
            SwitchTouchPointDescriptor swi = new SwitchTouchPointDescriptor(eventId, currentLine, def, labels, conditionType);
            this.eventId2touchPointDescriptor.put(eventId, swi);
            this.getOrCreateLineTouchPoints(currentLine).add(swi);
            this.getOrCreateSourcePoints(def).add(swi);
            for (Label l : labels) {
                this.getOrCreateSourcePoints(l).add(swi);
            }
        }
    }

    public Integer getCounterIdForJumpTrue(int eventId) {
        JumpTouchPointDescriptor jumpTouchPointDescriptor;
        if (this.eventId2touchPointDescriptor.get(eventId) instanceof JumpTouchPointDescriptor && (jumpTouchPointDescriptor = (JumpTouchPointDescriptor)this.eventId2touchPointDescriptor.get(eventId)) != null) {
            return jumpTouchPointDescriptor.getCounterIdForTrue();
        }
        return null;
    }

    public Integer getCounterIdForJumpFalse(int eventId) {
        JumpTouchPointDescriptor jumpTouchPointDescriptor;
        if (this.eventId2touchPointDescriptor.get(eventId) instanceof JumpTouchPointDescriptor && (jumpTouchPointDescriptor = (JumpTouchPointDescriptor)this.eventId2touchPointDescriptor.get(eventId)) != null) {
            return jumpTouchPointDescriptor.getCounterIdForFalse();
        }
        return null;
    }

    public boolean isJumpDestinationLabel(int eventId) {
        Label label_local = this.eventId2label.get(eventId);
        logger.debug("Label found for eventId:" + eventId + ":" + label_local);
        if (this.labelDuplicates2duplicateMap.containsKey(label_local)) {
            for (Label label : this.labelDuplicates2duplicateMap.get(label_local)) {
                if (label == null) continue;
                Set<TouchPointDescriptor> res = this.label2sourcePoints.get(label);
                logger.debug("label2sourcePoints.get(" + label + "):" + res);
                if (res == null) continue;
                for (TouchPointDescriptor r : res) {
                    if (!(r instanceof JumpTouchPointDescriptor)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Integer getCounterIdForSwitch(int eventId) {
        SwitchTouchPointDescriptor point;
        if (this.eventId2touchPointDescriptor.get(eventId) instanceof SwitchTouchPointDescriptor && (point = (SwitchTouchPointDescriptor)this.eventId2touchPointDescriptor.get(eventId)) != null) {
            return point.getCounterId();
        }
        return null;
    }

    public Integer getCounterIdForLineEventId(int eventId) {
        LineTouchPointDescriptor point;
        if (this.eventId2touchPointDescriptor.get(eventId) instanceof LineTouchPointDescriptor && (point = (LineTouchPointDescriptor)this.eventId2touchPointDescriptor.get(eventId)) != null) {
            return point.getCounterId();
        }
        return null;
    }

    public Map<Integer, Integer> getBranchLabelDescriptorsForLabelEvent(int labelEventId) {
        Label label_local = this.eventId2label.get(labelEventId);
        if (label_local != null && this.labelDuplicates2duplicateMap.containsKey(label_local)) {
            for (Label label : this.labelDuplicates2duplicateMap.get(label_local)) {
                Set<TouchPointDescriptor> list = this.label2sourcePoints.get(label);
                if (list == null) continue;
                HashMap<Integer, Integer> res = new HashMap<Integer, Integer>();
                for (TouchPointDescriptor r : list) {
                    if (!(r instanceof SwitchTouchPointDescriptor)) continue;
                    SwitchTouchPointDescriptor swi = (SwitchTouchPointDescriptor)r;
                    res.put(swi.getCounterId(), swi.getCounterIdForLabel(label));
                }
                return res;
            }
        }
        return null;
    }

    public void assignCounterIds() {
        AtomicInteger idGenerator = new AtomicInteger(0);
        for (List<TouchPointDescriptor> tpd : this.line2touchPoints.values()) {
            for (TouchPointDescriptor t : tpd) {
                t.assignCounters(idGenerator);
            }
        }
        this.maxCounterId = idGenerator.get();
    }

    public int getMaxCounterId() {
        return this.maxCounterId;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getSource() {
        return this.source;
    }

    public List<TouchPointDescriptor> getTouchPointsInLineOrder() {
        LinkedList<TouchPointDescriptor> res = new LinkedList<TouchPointDescriptor>();
        for (List<TouchPointDescriptor> tpd : this.line2touchPoints.values()) {
            for (TouchPointDescriptor t : tpd) {
                if (!(tpd instanceof LineTouchPointDescriptor)) continue;
                res.add(t);
            }
            for (TouchPointDescriptor t : tpd) {
                if (tpd instanceof LineTouchPointDescriptor) continue;
                res.add(t);
            }
        }
        return res;
    }

    public ClassData applyOnProjectData(ProjectData projectData, boolean instrumented) {
        ClassData classData = projectData.getOrCreateClassData(this.className.replace('/', '.'));
        if (this.source != null) {
            classData.setSourceFileName(this.source);
        }
        if (instrumented) {
            classData.setContainsInstrumentationInfo();
            int lastLine = 0;
            int jumpsInLine = 0;
            int toucesInLine = 0;
            for (TouchPointDescriptor tpd : this.getTouchPointsInLineOrder()) {
                if (tpd.getLineNumber() != lastLine) {
                    jumpsInLine = 0;
                    toucesInLine = 0;
                    lastLine = tpd.getLineNumber();
                }
                if (tpd instanceof LineTouchPointDescriptor) {
                    classData.addLine(tpd.getLineNumber(), ((LineTouchPointDescriptor)tpd).getMethodName(), ((LineTouchPointDescriptor)tpd).getMethodSignature());
                    continue;
                }
                if (tpd instanceof JumpTouchPointDescriptor) {
                    classData.addLineJump(tpd.getLineNumber(), jumpsInLine++);
                    continue;
                }
                if (!(tpd instanceof SwitchTouchPointDescriptor)) continue;
                int countersCnt = ((SwitchTouchPointDescriptor)tpd).getCountersForLabelsCnt();
                classData.addLineSwitch(tpd.getLineNumber(), toucesInLine++, 0, countersCnt - 2, Integer.MAX_VALUE);
            }
        }
        return classData;
    }
}

