/*
 * This file was automatically generated by EvoSuite
 * Fri Jun 08 19:19:39 GMT 2018
 */

package uk.ac.sanger.artemis.components.genebuilder.ortholog;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import javax.swing.JPasswordField;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.chado.ClusterLazyQualifierValue;
import uk.ac.sanger.artemis.components.SelectionViewer;
import uk.ac.sanger.artemis.components.genebuilder.ortholog.OrthoParalogTable;
import uk.ac.sanger.artemis.io.BlastStreamFeature;
import uk.ac.sanger.artemis.io.GFFStreamFeature;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.KeyVector;
import uk.ac.sanger.artemis.io.LazyQualifierValue;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierLazyLoading;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.j2ssh.SshLogin;
import uk.ac.sanger.artemis.util.ByteBuffer;
import uk.ac.sanger.artemis.util.DatabaseDocument;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class OrthoParalogTable_ESTest extends OrthoParalogTable_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      SshLogin sshLogin0 = new SshLogin();
      JPasswordField jPasswordField0 = sshLogin0.getJPasswordField();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("h/I^%+U1", jPasswordField0, "-gP4y$\"V;-", "h/I^%+U1", true);
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("", (LazyQualifierValue) null);
      OrthoParalogTable orthoParalogTable0 = null;
      try {
        orthoParalogTable0 = new OrthoParalogTable(databaseDocument0, qualifierLazyLoading0, qualifierLazyLoading0, (Feature) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ortholog.OrthoParalogTable", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("?p4m.jm0)rcSQB3g~");
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(genbankStreamFeature0);
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(blastStreamFeature0, false);
      // Undeclared exception!
      try { 
        OrthoParalogTable.hasCluster(qualifier0, qualifier0, gFFStreamFeature0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ortholog.OrthoParalogTable", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Range range0 = new Range((-1450), (-1450));
      FeatureVector featureVector0 = simpleEntryGroup0.getFeaturesInRange(range0);
      StringVector stringVector0 = Feature.getAllQualifierNames(featureVector0);
      // Undeclared exception!
      try { 
        OrthoParalogTable.containsStringInStringVector("", stringVector0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // Array index out of range: 0
         //
         verifyException("java.util.Vector", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      StringVector stringVector0 = StringVector.getStrings("~|`oXGH,PsQ~w1c&", "~|`oXGH,PsQ~w1c&");
      boolean boolean0 = OrthoParalogTable.containsStringInStringVector("~|`oXGH,PsQ~w1c&", stringVector0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      StringVector stringVector0 = SelectionViewer.getBaseSummary("F&.cmcrHt=");
      boolean boolean0 = OrthoParalogTable.containsStringInStringVector("F&.cmcrHt=", stringVector0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("%~<FyHSe");
      qualifier0.addValue("VIEW");
      StringVector stringVector0 = qualifier0.getValues();
      boolean boolean0 = OrthoParalogTable.containsStringInStringVector("cluster_name=", stringVector0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("%~<FyHSe");
      StringVector stringVector0 = qualifier0.getValues();
      // Undeclared exception!
      try { 
        OrthoParalogTable.containsStringInStringVector("cluster_name=", stringVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ortholog.OrthoParalogTable", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      ClusterLazyQualifierValue clusterLazyQualifierValue0 = new ClusterLazyQualifierValue("Bp<fKtT!iSIu/[", "", (GFFStreamFeature) null);
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("Bp<fKtT!iSIu/[", clusterLazyQualifierValue0);
      // Undeclared exception!
      try { 
        OrthoParalogTable.hasOrthoParlaog(qualifierLazyLoading0, qualifierLazyLoading0, (GFFStreamFeature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ortholog.OrthoParalogTable", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("%~<FyHSe");
      qualifier0.addValue("%~<FyHSe");
      boolean boolean0 = OrthoParalogTable.hasOrthoParlaog(qualifier0, qualifier0, (GFFStreamFeature) null);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      boolean boolean0 = OrthoParalogTable.hasOrthoParlaog((Qualifier) null, (Qualifier) null, (GFFStreamFeature) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("%~FyHS");
      qualifier0.addValue("");
      boolean boolean0 = OrthoParalogTable.hasCluster(qualifier0, qualifier0, (GFFStreamFeature) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("%~FyHS");
      qualifier0.addValue("");
      StringVector stringVector0 = qualifier0.getValues();
      stringVector0.add("\u0001qOIO8tN17Bh1;5EwH");
      qualifier0.addValues(stringVector0);
      OrthoParalogTable orthoParalogTable0 = null;
      try {
        orthoParalogTable0 = new OrthoParalogTable((DatabaseDocument) null, qualifier0, qualifier0, (Feature) null, false);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 1
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ortholog.OrthoParalogTable", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("%~<FyHSe");
      qualifier0.addValue("VIEW");
      Boolean boolean0 = new Boolean("");
      OrthoParalogTable orthoParalogTable0 = null;
      try {
        orthoParalogTable0 = new OrthoParalogTable((DatabaseDocument) null, qualifier0, qualifier0, (Feature) null, (boolean) boolean0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 1
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ortholog.OrthoParalogTable", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("%~<FyHSe");
      qualifier0.addValue("%~<FyHSe");
      OrthoParalogTable orthoParalogTable0 = null;
      try {
        orthoParalogTable0 = new OrthoParalogTable((DatabaseDocument) null, qualifier0, qualifier0, (Feature) null, true);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("javax.swing.JTable", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("%~FyHS");
      qualifier0.addValue("cluster_name=");
      OrthoParalogTable orthoParalogTable0 = null;
      try {
        orthoParalogTable0 = new OrthoParalogTable((DatabaseDocument) null, qualifier0, qualifier0, (Feature) null, false);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("javax.swing.JTable", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      SshLogin sshLogin0 = new SshLogin();
      JPasswordField jPasswordField0 = sshLogin0.getJPasswordField();
      ByteBuffer byteBuffer0 = new ByteBuffer();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0, "", "", byteBuffer0, "");
      Key key0 = Key.CDS;
      KeyVector keyVector0 = new KeyVector(key0);
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading((String) null, keyVector0);
      OrthoParalogTable orthoParalogTable0 = null;
      try {
        orthoParalogTable0 = new OrthoParalogTable(databaseDocument0, qualifierLazyLoading0, qualifierLazyLoading0, (Feature) null, false);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.io.Key cannot be cast to uk.ac.sanger.artemis.chado.ClusterLazyQualifierValue
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ortholog.OrthoParalogTable", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      OrthoParalogTable orthoParalogTable0 = null;
      try {
        orthoParalogTable0 = new OrthoParalogTable((DatabaseDocument) null, (Qualifier) null, (Qualifier) null, (Feature) null, true);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("javax.swing.JTable", e);
      }
  }
}
