/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Mkdir;

public class CopyAndInlineStylesheet
extends Task {
    private File file;
    private File todir;

    public void setFile(String file) {
        this.file = ((ProjectComponent)this).project.resolveFile(file);
    }

    public void setTodir(String todir) {
        this.todir = ((ProjectComponent)this).project.resolveFile(todir);
    }

    public void execute() throws BuildException {
        try {
            String line;
            if (this.todir == null) {
                throw new BuildException("must set 'todir' attribute");
            }
            if (this.file == null) {
                throw new BuildException("must set 'file' attribute");
            }
            this.log("copying html from" + this.file + " to " + this.todir.getAbsolutePath());
            File toFile = new File(this.todir, this.file.getName());
            Mkdir mkdir = (Mkdir)((ProjectComponent)this).project.createTask("mkdir");
            mkdir.setDir(this.todir);
            mkdir.execute();
            BufferedReader in = new BufferedReader(new FileReader(this.file));
            PrintStream out = new PrintStream(new FileOutputStream(toFile));
            while ((line = in.readLine()) != null) {
                if (CopyAndInlineStylesheet.isStyleSheet(line)) {
                    String line2;
                    CopyAndInlineStylesheet.doStyleSheet(line, out, this.file);
                    while ((line2 = in.readLine()) != null) {
                        out.println(line2);
                    }
                    break;
                }
                out.println(line);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage());
        }
    }

    private static void doStyleSheet(String line, PrintStream out, File file) throws IOException {
        String line2;
        int srcIndex = line.indexOf("href");
        int startQuotIndex = line.indexOf(34, srcIndex);
        int endQuotIndex = line.indexOf(34, startQuotIndex + 1);
        String stylesheetLocation = line.substring(startQuotIndex + 1, endQuotIndex);
        File styleSheetFile = new File(file.getParent(), stylesheetLocation);
        out.println("<style type=\"text/css\">");
        out.println("<!--");
        BufferedReader inStyle = new BufferedReader(new FileReader(styleSheetFile));
        while ((line2 = inStyle.readLine()) != null) {
            out.println(line2);
        }
        inStyle.close();
        out.println("-->");
        out.println("</style>");
    }

    private static boolean isStyleSheet(String line) throws IOException {
        line = line.toLowerCase();
        int len = line.length();
        int i = 0;
        do {
            if (i != len) continue;
            return false;
        } while (Character.isWhitespace(line.charAt(i)));
        return line.startsWith("<link", i);
    }
}

