#ifndef ATL_cGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,144,360,432,576,648,720,792
 * N : 25,144,360,432,576,648,720,792
 * NB : 4,12,16,24,24,28,36,72
 */
#define ATL_cGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 84) (nb_) = 4; \
   else if ((n_) < 252) (nb_) = 12; \
   else if ((n_) < 396) (nb_) = 16; \
   else if ((n_) < 612) (nb_) = 24; \
   else if ((n_) < 684) (nb_) = 28; \
   else if ((n_) < 756) (nb_) = 36; \
   else (nb_) = 72; \
}


#endif    /* end ifndef ATL_cGetNB_geqrf */
