
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsecategories.proc"
// Licensed GNU LGPL v2.1 or later: http://www.gnu.org/licenses/lgpl.html
#include <bse/bsecategories.hh>
#include <bse/bseprocedure.hh>
#include <bse/bseplugin.hh>
#include "bsecxxplugin.hh"
/* --- bse-categories-match-typed --- */
static void
bse_categories_match_typed_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 8 "bsecategories.proc"
 {
#line 10 "bsecategories.proc"
  *(in_pspecs++) = sfi_pspec_string ("pattern", "Pattern", "Pattern to match category, supports '*' and '?' wildcards.",
			    "*", SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("type", "Type", "Base type for categories to conform to.",
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("categories", "Categories", NULL, BSE_TYPE_CATEGORY_SEQ, SFI_PARAM_STANDARD);
}
#line 16 "bsecategories.proc"
 }
static BseErrorType
#line 16 "bsecategories.proc"
bse_categories_match_typed_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 19 "bsecategories.proc"
{
#line 20 "bsecategories.proc"
  
  const char *pattern   = sfi_value_get_string (in_values++);
  const char *type_name = sfi_value_get_string (in_values++);
  GType  type     = type_name ? g_type_from_name (type_name) : 0;
  BseCategorySeq *cseq = NULL;
#line 25 "bsecategories.proc"
  
  if (!pattern)
    return BSE_ERROR_PROC_PARAM_INVAL;
  if (type)
    cseq = bse_categories_match_typed (pattern, type);
  if (!cseq)
    cseq = bse_category_seq_new ();
#line 32 "bsecategories.proc"
  
  bse_value_take_boxed (out_values++, cseq);
  return BSE_ERROR_NONE;
}
/* --- bse-categories-match --- */
static void
bse_categories_match_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 36 "bsecategories.proc"
 {
#line 38 "bsecategories.proc"
  *(in_pspecs++) = sfi_pspec_string ("pattern", "Pattern", "Pattern to match category, supports '*' and '?' wildcards.",
			    "*", SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("categories", "Categories", NULL, BSE_TYPE_CATEGORY_SEQ, SFI_PARAM_STANDARD);
}
#line 42 "bsecategories.proc"
 }
static BseErrorType
#line 42 "bsecategories.proc"
bse_categories_match_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 45 "bsecategories.proc"
{
#line 46 "bsecategories.proc"
  
  const char *pattern   = sfi_value_get_string (in_values++);
  BseCategorySeq *cseq = NULL;
#line 49 "bsecategories.proc"
  
  if (!pattern)
    return BSE_ERROR_PROC_PARAM_INVAL;
  cseq = bse_categories_match_typed (pattern, 0);
  if (!cseq)
    cseq = bse_category_seq_new ();
#line 55 "bsecategories.proc"
  
  bse_value_take_boxed (out_values++, cseq);
  return BSE_ERROR_NONE;
}
/* --- bse-category-from-id --- */
static void
bse_category_from_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 59 "bsecategories.proc"
 {
#line 61 "bsecategories.proc"
  *(in_pspecs++) = sfi_pspec_int ("category_id", "Category ID", NULL,
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("category", "Category", NULL, BSE_TYPE_CATEGORY, SFI_PARAM_STANDARD);
}
#line 65 "bsecategories.proc"
 }
static BseErrorType
#line 65 "bsecategories.proc"
bse_category_from_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 68 "bsecategories.proc"
{
#line 69 "bsecategories.proc"
  
  guint id = sfi_value_get_int (in_values++);
  BseCategory *cat;
  cat = bse_category_from_id (id);
#line 73 "bsecategories.proc"
  
  bse_value_take_boxed (out_values++, cat);
  return BSE_ERROR_NONE;
}
static gboolean
categories_check_method (BseCategory *cat,
                         gpointer     data)
{
  GType *type_p = (GType*) data;
  GType ptype = g_type_from_name (cat->type);
  gboolean match = FALSE;
  if (BSE_TYPE_IS_PROCEDURE (ptype))
    {
      BseProcedureClass *proc = (BseProcedureClass*) g_type_class_ref (ptype);
      if (proc->n_in_pspecs >= 1 &&
          g_type_is_a (G_PARAM_SPEC_VALUE_TYPE (proc->in_pspecs[0]), *type_p))
        match = TRUE;
      g_type_class_unref (proc);
    }
  return match;
}
/* --- bse-categories-match-method --- */
static void
bse_categories_match_method_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 94 "bsecategories.proc"
 {
#line 96 "bsecategories.proc"
  *(in_pspecs++) = sfi_pspec_string ("pattern", "Pattern", "Pattern to match category, supports '*' and '?' wildcards.",
			    "*", SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("type", "Type", "Object base type for methods to conform to.",
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("categories", "Categories", NULL, BSE_TYPE_CATEGORY_SEQ, SFI_PARAM_STANDARD);
}
#line 102 "bsecategories.proc"
 }
static BseErrorType
#line 102 "bsecategories.proc"
bse_categories_match_method_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 105 "bsecategories.proc"
{
#line 106 "bsecategories.proc"
  
  const char *pattern   = sfi_value_get_string (in_values++);
  const char *type_name = sfi_value_get_string (in_values++);
  GType  type      = type_name ? g_type_from_name (type_name) : 0;
  BseCategorySeq *cseq = NULL;
#line 111 "bsecategories.proc"
  
  if (!pattern)
    return BSE_ERROR_PROC_PARAM_INVAL;
  cseq = bse_categories_match (pattern, BSE_TYPE_PROCEDURE, categories_check_method, &type);
  if (!cseq)
    cseq = bse_category_seq_new ();
#line 117 "bsecategories.proc"
  
  bse_value_take_boxed (out_values++, cseq);
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_bse_categories_match_typed__fill_strings (BseExportStrings *es)
{
  es->blurb = "List BSE categories according to a pattern and type match.";
  es->file = "/opt/src/beast/bse/bsecategories.proc";
  es->line = 9;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_categories_match_typed = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "bse-categories-match-typed", 
    NULL,
    "/Proc/Categories/Match Typed",
    NULL,
    __enode_bse_categories_match_typed__fill_strings,
  },
  0, bse_categories_match_typed_setup, bse_categories_match_typed_exec, 
};
static void
__enode_bse_categories_match__fill_strings (BseExportStrings *es)
{
  es->blurb = "List BSE categories according to a pattern match.";
  es->file = "/opt/src/beast/bse/bsecategories.proc";
  es->line = 37;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_categories_match = {
  { (BseExportNode*) &__enode_bse_categories_match_typed, BSE_EXPORT_NODE_PROC,
    "bse-categories-match", 
    NULL,
    "/Proc/Categories/Match",
    NULL,
    __enode_bse_categories_match__fill_strings,
  },
  0, bse_categories_match_setup, bse_categories_match_exec, 
};
static void
__enode_bse_category_from_id__fill_strings (BseExportStrings *es)
{
  es->blurb = "Find a BSE category from it's unique ID.";
  es->file = "/opt/src/beast/bse/bsecategories.proc";
  es->line = 60;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_category_from_id = {
  { (BseExportNode*) &__enode_bse_categories_match, BSE_EXPORT_NODE_PROC,
    "bse-category-from-id", 
    NULL,
    "/Proc/Categories/From ID",
    NULL,
    __enode_bse_category_from_id__fill_strings,
  },
  0, bse_category_from_id_setup, bse_category_from_id_exec, 
};
static void
__enode_bse_categories_match_method__fill_strings (BseExportStrings *es)
{
  es->blurb = "List BSE categories according to a pattern, of type procedure and applying to a certain object type.";
  es->file = "/opt/src/beast/bse/bsecategories.proc";
  es->line = 95;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_categories_match_method = {
  { (BseExportNode*) &__enode_bse_category_from_id, BSE_EXPORT_NODE_PROC,
    "bse-categories-match-method", 
    NULL,
    "/Proc/Categories/Match Method",
    NULL,
    __enode_bse_categories_match_method__fill_strings,
  },
  0, bse_categories_match_method_setup, bse_categories_match_method_exec, 
};
extern "C" BseExportNode* bse__builtin_init_bsecategories_genprc_cc (void)
{
  return (BseExportNode*) &__enode_bse_categories_match_method;
}

/*
 * Generated data ends here
 */
