/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc.pict;

import com.kreative.rsrc.pict.Point;
import com.kreative.rsrc.pict.Rect;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class Polygon
implements Shape {
    public int polySize;
    public Rect polyBBox;
    public List<Point> polyPoints;

    public static Polygon read(DataInputStream in) throws IOException {
        Polygon p = new Polygon();
        p.polySize = in.readUnsignedShort();
        p.polyBBox = Rect.read(in);
        p.polyPoints = new Vector<Point>();
        int i = 10;
        while (i < p.polySize) {
            p.polyPoints.add(Point.read(in));
            i += 4;
        }
        return p;
    }

    public Polygon() {
        this.polySize = 10;
        this.polyBBox = new Rect();
        this.polyPoints = new Vector<Point>();
    }

    public Polygon(java.awt.Polygon p) {
        this.polyPoints = new Vector<Point>();
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int maxx = Integer.MIN_VALUE;
        int maxy = Integer.MIN_VALUE;
        int i = 0;
        while (i < p.npoints) {
            this.polyPoints.add(new Point(p.xpoints[i], p.ypoints[i]));
            if (p.xpoints[i] < minx) {
                minx = p.xpoints[i];
            }
            if (p.xpoints[i] > maxx) {
                maxx = p.xpoints[i];
            }
            if (p.ypoints[i] < miny) {
                miny = p.ypoints[i];
            }
            if (p.ypoints[i] > maxy) {
                maxy = p.ypoints[i];
            }
            ++i;
        }
        this.polyBBox = maxx < minx || maxy < miny ? new Rect() : new Rect(minx, miny, maxx - minx, maxy - miny);
        this.polySize = 10 + this.polyPoints.size() * 4;
    }

    public void write(DataOutputStream out) throws IOException {
        this.polySize = 10 + this.polyPoints.size() * 4;
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int maxx = Integer.MIN_VALUE;
        int maxy = Integer.MIN_VALUE;
        for (Point p : this.polyPoints) {
            if (p.x < minx) {
                minx = p.x;
            }
            if (p.x > maxx) {
                maxx = p.x;
            }
            if (p.y < miny) {
                miny = p.y;
            }
            if (p.y <= maxy) continue;
            maxy = p.y;
        }
        this.polyBBox = maxx < minx || maxy < miny ? new Rect() : new Rect(minx, miny, maxx - minx, maxy - miny);
        out.writeShort(this.polySize);
        this.polyBBox.write(out);
        for (Point p : this.polyPoints) {
            p.write(out);
        }
    }

    public java.awt.Polygon toPolygon() {
        java.awt.Polygon pg = new java.awt.Polygon();
        for (Point pt : this.polyPoints) {
            pg.addPoint(pt.x, pt.y);
        }
        return pg;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Point pt : this.polyPoints) {
            sb.append(" " + pt.toString());
        }
        return "Polygon[" + sb.toString().trim() + "]";
    }

    @Override
    public boolean contains(Point2D p) {
        return this.toPolygon().contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.toPolygon().contains(r);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.toPolygon().contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.toPolygon().contains(x, y, w, h);
    }

    @Override
    public Rectangle getBounds() {
        return this.toPolygon().getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.toPolygon().getBounds2D();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.toPolygon().getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.toPolygon().getPathIterator(at, flatness);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.toPolygon().intersects(r);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.toPolygon().intersects(x, y, w, h);
    }
}

