{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector3;
    procedure SetCenter(const Value: TVector3);
    function GetNameField: String;
    procedure SetNameField(const Value: String);
    function GetRotation: TVector4;
    procedure SetRotation(const Value: TVector4);
    function GetScale: TVector3;
    procedure SetScale(const Value: TVector3);
    function GetScaleOrientation: TVector4;
    procedure SetScaleOrientation(const Value: TVector4);
    function GetSkinNormal: TAbstractNormalNode;
    procedure SetSkinNormal(const Value: TAbstractNormalNode);
    function GetTranslation: TVector3;
    procedure SetTranslation(const Value: TVector3);
    function GetVersion: String;
    procedure SetVersion(const Value: String);
    function GetBBox: TBox3D;
    procedure SetBBox(const Value: TBox3D);
  public
    { X3D field "center". } { }
    property Center: TVector3 read GetCenter write SetCenter;
    { Set X3D field "info". } { }
    procedure SetInfo(const Value: array of string);
    { Set X3D field "info". } { }
    procedure SetInfo(const Value: TCastleStringList);
    { Set X3D field "joints". } { }
    procedure SetJoints(const Value: array of THAnimJointNode);
    { X3D field "name". } { }
    property NameField: String read GetNameField write SetNameField;
    { X3D field "rotation". } { }
    property Rotation: TVector4 read GetRotation write SetRotation;
    { X3D field "scale". } { }
    property Scale: TVector3 read GetScale write SetScale;
    { X3D field "scaleOrientation". } { }
    property ScaleOrientation: TVector4 read GetScaleOrientation write SetScaleOrientation;
    { Set X3D field "segments". } { }
    procedure SetSegments(const Value: array of THAnimSegmentNode);
    { Set X3D field "sites". } { }
    procedure SetSites(const Value: array of THAnimSiteNode);
    { Set X3D field "skin". } { }
    procedure SetSkin(const Value: array of TAbstractChildNode);
    { X3D field "skinNormal". } { }
    property SkinNormal: TAbstractNormalNode read GetSkinNormal write SetSkinNormal;
    { X3D field "translation". } { }
    property Translation: TVector3 read GetTranslation write SetTranslation;
    { X3D field "version". } { }
    property Version: String read GetVersion write SetVersion;
    { Set X3D field "viewpoints". } { }
    procedure SetViewpoints(const Value: array of THAnimSiteNode);
    { X3D fields "bboxCenter" and "bboxSize" are get/set as TBox3D. } { }
    property BBox: TBox3D read GetBBox write SetBBox;

{$endif read_interface}

{$ifdef read_implementation}

{ THAnimHumanoidNode ----------------------------------------------- }

function THAnimHumanoidNode.GetCenter: TVector3;
begin
  Result := FdCenter.Value;
end;

procedure THAnimHumanoidNode.SetCenter(const Value: TVector3);
begin
  FdCenter.Send(Value);
end;

procedure THAnimHumanoidNode.SetInfo(const Value: array of string);
begin
  FdInfo.Send(Value);
end;

procedure THAnimHumanoidNode.SetInfo(const Value: TCastleStringList);
begin
  FdInfo.Send(Value);
end;

procedure THAnimHumanoidNode.SetJoints(const Value: array of THAnimJointNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimJointNode));
  FdJoints.Send(A);
end;

function THAnimHumanoidNode.GetNameField: String;
begin
  Result := FdName.Value;
end;

procedure THAnimHumanoidNode.SetNameField(const Value: String);
begin
  FdName.Send(Value);
end;

function THAnimHumanoidNode.GetRotation: TVector4;
begin
  Result := FdRotation.Value;
end;

procedure THAnimHumanoidNode.SetRotation(const Value: TVector4);
begin
  FdRotation.Send(Value);
end;

function THAnimHumanoidNode.GetScale: TVector3;
begin
  Result := FdScale.Value;
end;

procedure THAnimHumanoidNode.SetScale(const Value: TVector3);
begin
  FdScale.Send(Value);
end;

function THAnimHumanoidNode.GetScaleOrientation: TVector4;
begin
  Result := FdScaleOrientation.Value;
end;

procedure THAnimHumanoidNode.SetScaleOrientation(const Value: TVector4);
begin
  FdScaleOrientation.Send(Value);
end;

procedure THAnimHumanoidNode.SetSegments(const Value: array of THAnimSegmentNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimSegmentNode));
  FdSegments.Send(A);
end;

procedure THAnimHumanoidNode.SetSites(const Value: array of THAnimSiteNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimSiteNode));
  FdSites.Send(A);
end;

procedure THAnimHumanoidNode.SetSkin(const Value: array of TAbstractChildNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractChildNode));
  FdSkin.Send(A);
end;

function THAnimHumanoidNode.GetSkinNormal: TAbstractNormalNode;
begin
  if FdSkinNormal.Value is TAbstractNormalNode then
    Result := TAbstractNormalNode(FdSkinNormal.Value)
  else
    Result := nil;
end;

procedure THAnimHumanoidNode.SetSkinNormal(const Value: TAbstractNormalNode);
begin
  FdSkinNormal.Send(Value);
end;

function THAnimHumanoidNode.GetTranslation: TVector3;
begin
  Result := FdTranslation.Value;
end;

procedure THAnimHumanoidNode.SetTranslation(const Value: TVector3);
begin
  FdTranslation.Send(Value);
end;

function THAnimHumanoidNode.GetVersion: String;
begin
  Result := FdVersion.Value;
end;

procedure THAnimHumanoidNode.SetVersion(const Value: String);
begin
  FdVersion.Send(Value);
end;

procedure THAnimHumanoidNode.SetViewpoints(const Value: array of THAnimSiteNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimSiteNode));
  FdViewpoints.Send(A);
end;

function THAnimHumanoidNode.GetBBox: TBox3D;
begin
  Result := TBox3D.FromCenterSize(FdBBoxCenter.Value, FdBBoxSize.Value);
end;

procedure THAnimHumanoidNode.SetBBox(const Value: TBox3D);
var
  ValueCenter, ValueSize: TVector3;
begin
  Value.ToCenterSize(ValueCenter, ValueSize);
  FdBBoxCenter.Send(ValueCenter);
  FdBBoxSize.Send(ValueSize);
end;

{$endif read_implementation}
