{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetBackTexture: TAbstractTextureNode;
    procedure SetBackTexture(const Value: TAbstractTextureNode);
    function GetBottomTexture: TAbstractTextureNode;
    procedure SetBottomTexture(const Value: TAbstractTextureNode);
    function GetFrontTexture: TAbstractTextureNode;
    procedure SetFrontTexture(const Value: TAbstractTextureNode);
    function GetLeftTexture: TAbstractTextureNode;
    procedure SetLeftTexture(const Value: TAbstractTextureNode);
    function GetRightTexture: TAbstractTextureNode;
    procedure SetRightTexture(const Value: TAbstractTextureNode);
    function GetTopTexture: TAbstractTextureNode;
    procedure SetTopTexture(const Value: TAbstractTextureNode);
  public
    { X3D field "backTexture". } { }
    property BackTexture: TAbstractTextureNode read GetBackTexture write SetBackTexture;
    { X3D field "bottomTexture". } { }
    property BottomTexture: TAbstractTextureNode read GetBottomTexture write SetBottomTexture;
    { X3D field "frontTexture". } { }
    property FrontTexture: TAbstractTextureNode read GetFrontTexture write SetFrontTexture;
    { X3D field "leftTexture". } { }
    property LeftTexture: TAbstractTextureNode read GetLeftTexture write SetLeftTexture;
    { X3D field "rightTexture". } { }
    property RightTexture: TAbstractTextureNode read GetRightTexture write SetRightTexture;
    { X3D field "topTexture". } { }
    property TopTexture: TAbstractTextureNode read GetTopTexture write SetTopTexture;

{$endif read_interface}

{$ifdef read_implementation}

{ TTextureBackgroundNode ----------------------------------------------- }

function TTextureBackgroundNode.GetBackTexture: TAbstractTextureNode;
begin
  if FdBackTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdBackTexture.Value)
  else
    Result := nil;
end;

procedure TTextureBackgroundNode.SetBackTexture(const Value: TAbstractTextureNode);
begin
  FdBackTexture.Send(Value);
end;

function TTextureBackgroundNode.GetBottomTexture: TAbstractTextureNode;
begin
  if FdBottomTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdBottomTexture.Value)
  else
    Result := nil;
end;

procedure TTextureBackgroundNode.SetBottomTexture(const Value: TAbstractTextureNode);
begin
  FdBottomTexture.Send(Value);
end;

function TTextureBackgroundNode.GetFrontTexture: TAbstractTextureNode;
begin
  if FdFrontTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdFrontTexture.Value)
  else
    Result := nil;
end;

procedure TTextureBackgroundNode.SetFrontTexture(const Value: TAbstractTextureNode);
begin
  FdFrontTexture.Send(Value);
end;

function TTextureBackgroundNode.GetLeftTexture: TAbstractTextureNode;
begin
  if FdLeftTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdLeftTexture.Value)
  else
    Result := nil;
end;

procedure TTextureBackgroundNode.SetLeftTexture(const Value: TAbstractTextureNode);
begin
  FdLeftTexture.Send(Value);
end;

function TTextureBackgroundNode.GetRightTexture: TAbstractTextureNode;
begin
  if FdRightTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdRightTexture.Value)
  else
    Result := nil;
end;

procedure TTextureBackgroundNode.SetRightTexture(const Value: TAbstractTextureNode);
begin
  FdRightTexture.Send(Value);
end;

function TTextureBackgroundNode.GetTopTexture: TAbstractTextureNode;
begin
  if FdTopTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdTopTexture.Value)
  else
    Result := nil;
end;

procedure TTextureBackgroundNode.SetTopTexture(const Value: TAbstractTextureNode);
begin
  FdTopTexture.Send(Value);
end;

{$endif read_implementation}
