{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetColor: TAbstractColorNode;
    procedure SetColor(const Value: TAbstractColorNode);
    function GetCoord: TAbstractCoordinateNode;
    procedure SetCoord(const Value: TAbstractCoordinateNode);
{$ifndef CASTLE_SLIM_NODES}
    function GetFogCoord: TFogCoordinateNode;
    procedure SetFogCoord(const Value: TFogCoordinateNode);
{$endif not CASTLE_SLIM_NODES}
    function GetNormal: TAbstractNormalNode;
    procedure SetNormal(const Value: TAbstractNormalNode);
    function GetTangent: TTangentNode;
    procedure SetTangent(const Value: TTangentNode);
    function GetTexCoord: TAbstractTextureCoordinateNode;
    procedure SetTexCoord(const Value: TAbstractTextureCoordinateNode);
    function GetCcw: Boolean;
    procedure SetCcw(const Value: Boolean);
    function GetColorPerVertex: Boolean;
    procedure SetColorPerVertex(const Value: Boolean);
    function GetNormalPerVertex: Boolean;
    procedure SetNormalPerVertex(const Value: Boolean);
  public
{$ifndef CASTLE_SLIM_NODES}
    { Set X3D field "attrib". } { }
    procedure SetAttrib(const Value: array of TAbstractVertexAttributeNode);
{$endif not CASTLE_SLIM_NODES}
    { X3D field "color". } { }
    property Color: TAbstractColorNode read GetColor write SetColor;
    { X3D field "coord". } { }
    property Coord: TAbstractCoordinateNode read GetCoord write SetCoord;
{$ifndef CASTLE_SLIM_NODES}
    { X3D field "fogCoord". } { }
    property FogCoord: TFogCoordinateNode read GetFogCoord write SetFogCoord;
{$endif not CASTLE_SLIM_NODES}
    { X3D field "normal". } { }
    property Normal: TAbstractNormalNode read GetNormal write SetNormal;
    { X3D field "tangent". } { }
    property Tangent: TTangentNode read GetTangent write SetTangent;
    { X3D field "texCoord". } { }
    property TexCoord: TAbstractTextureCoordinateNode read GetTexCoord write SetTexCoord;
    { X3D field "ccw". } { }
    property Ccw: Boolean read GetCcw write SetCcw;
    { X3D field "colorPerVertex". } { }
    property ColorPerVertex: Boolean read GetColorPerVertex write SetColorPerVertex;
    { X3D field "normalPerVertex". } { }
    property NormalPerVertex: Boolean read GetNormalPerVertex write SetNormalPerVertex;
{$ifndef CASTLE_SLIM_NODES}
    { Set X3D field "radianceTransfer". } { }
    procedure SetRadianceTransfer(const Value: array of TVector3);
{$endif not CASTLE_SLIM_NODES}
{$ifndef CASTLE_SLIM_NODES}
    { Set X3D field "radianceTransfer". } { }
    procedure SetRadianceTransfer(const Value: TVector3List);
{$endif not CASTLE_SLIM_NODES}

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractComposedGeometryNode ----------------------------------------------- }

{$ifndef CASTLE_SLIM_NODES}
procedure TAbstractComposedGeometryNode.SetAttrib(const Value: array of TAbstractVertexAttributeNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractVertexAttributeNode));
  FdAttrib.Send(A);
end;

{$endif not CASTLE_SLIM_NODES}
function TAbstractComposedGeometryNode.GetColor: TAbstractColorNode;
begin
  if FdColor.Value is TAbstractColorNode then
    Result := TAbstractColorNode(FdColor.Value)
  else
    Result := nil;
end;

procedure TAbstractComposedGeometryNode.SetColor(const Value: TAbstractColorNode);
begin
  FdColor.Send(Value);
end;

function TAbstractComposedGeometryNode.GetCoord: TAbstractCoordinateNode;
begin
  if FdCoord.Value is TAbstractCoordinateNode then
    Result := TAbstractCoordinateNode(FdCoord.Value)
  else
    Result := nil;
end;

procedure TAbstractComposedGeometryNode.SetCoord(const Value: TAbstractCoordinateNode);
begin
  FdCoord.Send(Value);
end;

{$ifndef CASTLE_SLIM_NODES}
function TAbstractComposedGeometryNode.GetFogCoord: TFogCoordinateNode;
begin
  if FdFogCoord.Value is TFogCoordinateNode then
    Result := TFogCoordinateNode(FdFogCoord.Value)
  else
    Result := nil;
end;

procedure TAbstractComposedGeometryNode.SetFogCoord(const Value: TFogCoordinateNode);
begin
  FdFogCoord.Send(Value);
end;

{$endif not CASTLE_SLIM_NODES}
function TAbstractComposedGeometryNode.GetNormal: TAbstractNormalNode;
begin
  if FdNormal.Value is TAbstractNormalNode then
    Result := TAbstractNormalNode(FdNormal.Value)
  else
    Result := nil;
end;

procedure TAbstractComposedGeometryNode.SetNormal(const Value: TAbstractNormalNode);
begin
  FdNormal.Send(Value);
end;

function TAbstractComposedGeometryNode.GetTangent: TTangentNode;
begin
  if FdTangent.Value is TTangentNode then
    Result := TTangentNode(FdTangent.Value)
  else
    Result := nil;
end;

procedure TAbstractComposedGeometryNode.SetTangent(const Value: TTangentNode);
begin
  FdTangent.Send(Value);
end;

function TAbstractComposedGeometryNode.GetTexCoord: TAbstractTextureCoordinateNode;
begin
  if FdTexCoord.Value is TAbstractTextureCoordinateNode then
    Result := TAbstractTextureCoordinateNode(FdTexCoord.Value)
  else
    Result := nil;
end;

procedure TAbstractComposedGeometryNode.SetTexCoord(const Value: TAbstractTextureCoordinateNode);
begin
  FdTexCoord.Send(Value);
end;

function TAbstractComposedGeometryNode.GetCcw: Boolean;
begin
  Result := FdCcw.Value;
end;

procedure TAbstractComposedGeometryNode.SetCcw(const Value: Boolean);
begin
  FdCcw.Send(Value);
end;

function TAbstractComposedGeometryNode.GetColorPerVertex: Boolean;
begin
  Result := FdColorPerVertex.Value;
end;

procedure TAbstractComposedGeometryNode.SetColorPerVertex(const Value: Boolean);
begin
  FdColorPerVertex.Send(Value);
end;

function TAbstractComposedGeometryNode.GetNormalPerVertex: Boolean;
begin
  Result := FdNormalPerVertex.Value;
end;

procedure TAbstractComposedGeometryNode.SetNormalPerVertex(const Value: Boolean);
begin
  FdNormalPerVertex.Send(Value);
end;

{$ifndef CASTLE_SLIM_NODES}
procedure TAbstractComposedGeometryNode.SetRadianceTransfer(const Value: array of TVector3);
begin
  FdRadianceTransfer.Send(Value);
end;

{$endif not CASTLE_SLIM_NODES}
{$ifndef CASTLE_SLIM_NODES}
procedure TAbstractComposedGeometryNode.SetRadianceTransfer(const Value: TVector3List);
begin
  FdRadianceTransfer.Send(Value);
end;

{$endif not CASTLE_SLIM_NODES}
{$endif read_implementation}
