# CiviCRM 4.7.15

Released January 4, 2017

- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Credits](#credits)**

## <a name="features"></a>Features

### Core CiviCRM

- **[CRM-17410](https://issues.civicrm.org/jira/browse/CRM-17410) Using xml on
  upgrade (not installation) of extension to create/append new optionvalues
  ([9480](https://github.com/civicrm/civicrm-core/pull/9480))**

  Extensions that specify option values in XML for installation can now add
  options during an upgrade using XML.

- **[CRM-19688](https://issues.civicrm.org/jira/browse/CRM-19688) State/province
  API ([9454](https://github.com/civicrm/civicrm-core/pull/9454))**

  An API for creating, modifying, and deleting states/provinces is now
  available.

- **[CRM-19755](https://issues.civicrm.org/jira/browse/CRM-19755) reverse order
  of html and text on CRM/Mailing/Page/Component.php
  ([9531](https://github.com/civicrm/civicrm-core/pull/9531))**

  The mail template interface is now more consistent in placing the HTML version
  before the plain-text version.

- **[CRM-19686](https://issues.civicrm.org/jira/browse/CRM-19686) Dedupe
  Exceptions Should Link to Contacts
  ([9455](https://github.com/civicrm/civicrm-core/pull/9455))**

  The list of dedupe exceptions now links to the contacts.

### CiviContribute

- **[CRM-19325](https://issues.civicrm.org/jira/browse/CRM-19325) Search
  contributions that are not in any batch
  ([9492](https://github.com/civicrm/civicrm-core/pull/9492))**

  Contribution search now allows filtering by contributions that are not in any
  batch of financial transactions.

- **[CRM-18460](https://issues.civicrm.org/jira/browse/CRM-18460) Add relative
  date filters for Aggregate Contribution custom search
  ([9493](https://github.com/civicrm/civicrm-core/pull/9493))**

  The Aggregate Contribution custom search now uses the standard relative date
  filters.

### CiviEvent

- **[CRM-19626](https://issues.civicrm.org/jira/browse/CRM-19626) Event
  Registration page allows registration even if no number (or the number 0) has
  been entered in any ticket quantity boxes
  ([9517](https://github.com/civicrm/civicrm-core/pull/9517))**

  Price sets now have a "Minimum Amount" field to accommodate situations where
  any one of several fields may be filled but a certain price threshold must be
  reached.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[CRM-19591](https://issues.civicrm.org/jira/browse/CRM-19591) Creating a
  pledge with only one installment will cause pledge payment to have a null
  status (and cannot record a payment)
  ([9557](https://github.com/civicrm/civicrm-core/pull/9557))**

- **[CRM-19772](https://issues.civicrm.org/jira/browse/CRM-19772) Add
  $entity,$action to "possibly mandatory" exception message
  ([9543](https://github.com/civicrm/civicrm-core/pull/9543))**

  The API exception message is clearer in some cases with a database constraint
  violation.

- **[CRM-19333](https://issues.civicrm.org/jira/browse/CRM-19333) Advanced
  Search issue when searching using Group Type(s)
  ([9534](https://github.com/civicrm/civicrm-core/pull/9534))**

  Searching for contacts in groups of a specific group type no longer results in
  a database syntax error.

- **[CRM-19764](https://issues.civicrm.org/jira/browse/CRM-19764) Context
  ignored when fetching custom field options
  ([9540](https://github.com/civicrm/civicrm-core/pull/9540))**

  The getoptions API method now accurately returns or suppresses disabled
  options for custom fields when the `context` parameter is set.

- **[CRM-19662](https://issues.civicrm.org/jira/browse/CRM-19662) Send test
  mailing failing because of "only_full_group_by" setting
  ([9428](https://github.com/civicrm/civicrm-core/pull/9428))**

  Various queries having `GROUP BY` set, but with non-aggregated columns besides
  those that are grouped, have been resolved to be compatible with MySQL
  installations where the `sql_mode` contains `only_full_group_by`.  Some have
  removed columns from the `SELECT`, while others have added to the `GROUP BY`
  clause.

- **[CRM-19698](https://issues.civicrm.org/jira/browse/CRM-19698) Wrong search
  results when combining smart and non-smart groups in a single search
  ([9506](https://github.com/civicrm/civicrm-core/pull/9506))**

  Searching for a smart group alongside other groups now accurately displays
  contacts who are in any of the groups, rather than just the smart group.

- **[CRM-19743](https://issues.civicrm.org/jira/browse/CRM-19743) API Utils
  _civicrm_api3_get_options_from_params doesn't handle sort as an array properly
  ([9525](https://github.com/civicrm/civicrm-core/pull/9525))**

- **[CRM-19226](https://issues.civicrm.org/jira/browse/CRM-19226) $loginUrl
  token not populating in Drupal 7
  ([9479](https://github.com/civicrm/civicrm-core/pull/9479))**

  This fixes a broken or missing login URL link token on Drupal sites.

- **[CRM-19490](https://issues.civicrm.org/jira/browse/CRM-19490) Profile date
  fields don't respect localization on the Contribution Page confirmation screen
  ([9529](https://github.com/civicrm/civicrm-core/pull/9529) and
  [9530](https://github.com/civicrm/civicrm-core/pull/9530)) [completes previous
  work]**

  Short date form fields now have the proper labeling and display for
  internationalization.

- **Correct code docs for CRM_Core_Menu::get()
  ([9514](https://github.com/civicrm/civicrm-core/pull/9514))**

- **[CRM-18248](https://issues.civicrm.org/jira/browse/CRM-18248) Performance -
  select2 based contact autocomplete spams the DB server with potentially long
  running queries ([9502](https://github.com/civicrm/civicrm-core/pull/9502))**

  Entity reference autocomplete fields now wait 300 milliseconds (up from 100)
  before sending queries as users type.

- **JS Optimizations
  ([9505](https://github.com/civicrm/civicrm-core/pull/9505))**

  Improves the loading of WYSIWYG Javascript and only loads table headers for
  users with "Access CiviCRM" permission.

- **[CRM-19656](https://issues.civicrm.org/jira/browse/CRM-19656) Link for users
  to update their subscription billing info generates error
  ([9401](https://github.com/civicrm/civicrm-core/pull/9401))**

- **[CRM-19721](https://issues.civicrm.org/jira/browse/CRM-19721)
  CiviCRM-cxn-rpc needs to be updated to work with PHP 7
  ([9500](https://github.com/civicrm/civicrm-core/pull/9500))**

- **[CRM-19720](https://issues.civicrm.org/jira/browse/CRM-19720) Typographic
  fixes ([9501](https://github.com/civicrm/civicrm-core/pull/9501))**

- **[CRM-19711](https://issues.civicrm.org/jira/browse/CRM-19711) Bookkeeping
  report displays pay later items twice
  ([9490](https://github.com/civicrm/civicrm-core/pull/9490))**

  The bookkeeping report no longer shows duplicate row for pay-later items: once
  for the pending payment, and once for the completion.

- **CRM_Utils_HttpClientTest - Use special purpose hostnames
  ([9485](https://github.com/civicrm/civicrm-core/pull/9485))**

  Improves testing of HTTP and HTTPS connections by using hosts that have been
  prepared specifically for this purpose.

- **[CRM-19699](https://issues.civicrm.org/jira/browse/CRM-19699) PHP7: cannot
  install using Drush
  ([9472](https://github.com/civicrm/civicrm-core/pull/9472))**

  `DB_DSN_MODE` is set on installation for PHP 7 compatibility.

- **[CRM-19679](https://issues.civicrm.org/jira/browse/CRM-19679) multi custom
  data: file field errors on new record save
  ([9436](https://github.com/civicrm/civicrm-core/pull/9436))**

  Saving data in a file custom field in a multi-record custom data group no
  longer results in a database error.

- **[CRM-19681](https://issues.civicrm.org/jira/browse/CRM-19681) date fields
  not respected when passed through url for report
  ([9437](https://github.com/civicrm/civicrm-core/pull/9437))**

  Reports now accurately accept fixed date filter parameters in the URL.

- **js cleanup ([175](https://github.com/civicrm/civicrm-packages/pull/175))**

  This removes some unnecessary Javascript files and shortens or minifies
  others.

- **[CRM-19048](https://issues.civicrm.org/jira/browse/CRM-19048) FullText -
  Search by email, blank
  ([9537](https://github.com/civicrm/civicrm-core/pull/9537) and
  [9374](https://github.com/civicrm/civicrm-core/pull/9374)) [completes previous
  work]**

  Searches with unnecessary wildcard operators no longer result in empty
  results.

- **[CRM-19534](https://issues.civicrm.org/jira/browse/CRM-19534) Saving report
  with dashlet enabled for non admin users can cause a backtrace
  ([9456](https://github.com/civicrm/civicrm-core/pull/9456))**

  When saving a report with a dashlet, the system now prevents the dashlet from
  being added a second time for contacts who already have it enabled.

- **[CRM-19683](https://issues.civicrm.org/jira/browse/CRM-19683) Changing word
  replacement strings does not work if you have more than one set in
  civicrm_domain ([9446](https://github.com/civicrm/civicrm-core/pull/9446))**

  Saving word replacements now applies to the currently-used language.

- **[CRM-19685](https://issues.civicrm.org/jira/browse/CRM-19685) Contacts
  preferred_mail_format can't be NULL
  ([9463](https://github.com/civicrm/civicrm-core/pull/9463))**

  Upgrading sites will have all contacts with a null value for
  `preferred_mail_format` set to `Both`.

### CiviContribute

- **[CRM-19263](https://issues.civicrm.org/jira/browse/CRM-19263) Online Pay Now
  functionality ([9532](https://github.com/civicrm/civicrm-core/pull/9532))
  [completes previous work]**

  Payments made retain the original financial type instead of picking up the
  contribution page's financial type.

- **[CRM-19722](https://issues.civicrm.org/jira/browse/CRM-19722) Fatal Error:
  Unknown column 'contribution_source' in 'order clause'
  ([9516](https://github.com/civicrm/civicrm-core/pull/9516))**

  Tasks from the Actions drop-down on contribution searches no longer cause
  database errors if the search results are sorted by certain columns.

- **[CRM-19549](https://issues.civicrm.org/jira/browse/CRM-19549) New pledge
  data entry page shows hard coded $ for installments
  ([9475](https://github.com/civicrm/civicrm-core/pull/9475))**

  The currency symbol for pledges now changes dynamically according to the
  currency of the contribution amount.

- **[CRM-19660](https://issues.civicrm.org/jira/browse/CRM-19660) Financial
  Transaction stores wrong transaction date if the contribution is cancelled
  ([9405](https://github.com/civicrm/civicrm-core/pull/9405))**

- **[CRM-19294](https://issues.civicrm.org/jira/browse/CRM-19294) Unable to
  upload files via a contribution page
  ([9518](https://github.com/civicrm/civicrm-core/pull/9518))**

  If a file custom field is required in a profile on a contribution page, a
  regression caused the confirmation page to fail validation and prevent
  completing the contribution.  This has been resolved.

### CiviEvent

- **[CRM-19717](https://issues.civicrm.org/jira/browse/CRM-19717) Event
  registration impossible with "Pending from pay later" status being "positive"
  ([9523](https://github.com/civicrm/civicrm-core/pull/9523))**

  The Class attribute of reserved participant statuses can no longer be edited.

- **[CRM-19680](https://issues.civicrm.org/jira/browse/CRM-19680)
  Participant.get API generates invalid query when searching for role_id IS
  NULL. ([9453](https://github.com/civicrm/civicrm-core/pull/9453))**

### CiviMember

- **[CRM-19736](https://issues.civicrm.org/jira/browse/CRM-19736) Error thrown
  when printing labels for members
  ([9538](https://github.com/civicrm/civicrm-core/pull/9538))**

- **[CRM-19298](https://issues.civicrm.org/jira/browse/CRM-19298) Membership fee
  amount doubled in receipt when 'separate membership payment' is configured
  ([9438](https://github.com/civicrm/civicrm-core/pull/9438)) [completes
  previous work]**

  Test coverage was added for this issue.

- **[CRM-19600](https://issues.civicrm.org/jira/browse/CRM-19600) Membership
  Renewal activity not created through online contribution page
  ([9357](https://github.com/civicrm/civicrm-core/pull/9357))**

- **[CRM-19678](https://issues.civicrm.org/jira/browse/CRM-19678) No Membership
  Renewal Activity is created when a Pay Later is set to Completed
  ([9447](https://github.com/civicrm/civicrm-core/pull/9447))**

### CiviMail

- **[CRM-19649](https://issues.civicrm.org/jira/browse/CRM-19649) ckeditor
  includes html/head/body tags
  ([9425](https://github.com/civicrm/civicrm-core/pull/9425)) [completes
  previous work]**

  CKEditor configuration defaults are improved.

### Drupal integration

- **[CRM-19303](https://issues.civicrm.org/jira/browse/CRM-19303) CKEditor
  configuration can't be edited on a Drupal multisite installation
  ([9424](https://github.com/civicrm/civicrm-core/pull/9424)) [continues
  previous work]**

  The check for the proper Drupal multisite folder is improved.

## <a name="credits"></a>Credits

This release was developed by the following code authors:

Australian Greens - Seamus Lee; CiviCRM - Jitendra Purohit, Monish Deb, Coleman
Watts, Tim Otten, Yashodha Chaku; Coop SymbioTIC - Mathieu Lutfy; Denver DataMan -
Steve Kessler; Fuzion - Chris Burgess, Eileen McNaughton; JMA Consulting - Joe
Murray, Pradeep Nayak; Johan Vervloet; John Kingsnorth; Jon Goldberg;
Progressive Technology Project - Jamie McClelland; Sharique Ahmed Farooqui

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Agileware Team; Andrew Cormick-Dockery; Australian Greens - Seamus
Lee; Barbara Miller; Blackfly Solutions - Alan Dixon; Bob Silvern; British
Humanist Association - William Gordon, Andrew West; Circle Interactive - Dave
Jenkins; CiviCRM - Monish Deb, Jitendra Purohit, Yashodha Chaku, Tim Otten,
Coleman Watts, Josh Gowans, Dave Greenberg; CiviDesk - Nicolas Ganivet, Sunil
Pawar; Coop SymbioTIC - Mathieu Lutfy; Daniel Martinez; Dennis Gray; Denver
DataMan - Steve Kessler; E-Dynamics - Franky Van Liedekerke; Francesc Bassas i
Bullich; Freeform Solutions - Lola Slade; Fuzion - Eileen McNaughton, Peter
Davis, Chris Burgess; Gareth Small; GMCVO Databases - Jon-man Cheung; iXiam -
Vangelis Pantazis; JMA Consulting - Pradeep Nayak; joemurray; johanv; John
Kingsnorth; Joinery - Allen Shaw; Kacper Warda; Korlon - Stuart Gaston;
Lighthouse Design and Consulting - Brian Shaughnessy; Lutz Frommberger; Milton
Zurita; Nubay Services - David Tarrant; Progressive Technology Project - Jamie
McClelland; Richard van Oosterhout; Sharique Ahmed Farooqui; Thomas Nilefalk;
Vakees K; Veda Consulting - Kajakaran Balakrishnan
