/*
 * Clutter.
 *
 * An OpenGL based 'interactive canvas' library.
 *
 * Copyright (C) 2010  Intel Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __CLUTTER_CONSTRAINT_PRIVATE_H__
#define __CLUTTER_CONSTRAINT_PRIVATE_H__

#include "clutter-constraint.h"

G_BEGIN_DECLS

gboolean clutter_constraint_update_allocation (ClutterConstraint *constraint,
                                               ClutterActor      *actor,
                                               ClutterActorBox   *allocation);

void clutter_constraint_update_preferred_size (ClutterConstraint  *constraint,
                                               ClutterActor       *actor,
                                               ClutterOrientation  direction,
                                               float               for_size,
                                               float              *minimum_size,
                                               float              *natural_size);

G_END_DECLS

#endif /* __CLUTTER_CONSTRAINT_PRIVATE_H__ */
