CGIPARSE(8)                DACS Web Services Manual                CGIPARSE(8)



[1mNAME[0m
       cgiparse - CGI parameter parsing utility

[1mSYNOPSIS[0m
       [1mcgiparse [22m[[4mmode[24m] [[1m-enc [22m{none | url | mime | dacs}] [[1m-in [4m[22mfilename[24m]
                [[1m-checkdup[22m] [[1m-d[22m] [[1m-duperror[22m]
                [[1m-nodups[22m] [[1m-nonewline[22m] [[1m-qs [4m[22mquery-string[24m] [[1m-copy [4m[22mfilename[24m]
                [[[1m-n [4m[22mname[24m [4mfilename[24m]...]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite. It is a stand-alone program
       that neither accepts the usual [1mDACS [22mcommand line options ([4mdacsoptions[24m)
       nor accesses any [1mDACS [22mconfiguration files.

       This utility is used by web-based scripts (shell scripts in particular)
       to obtain their CGI parameters, which can be obtained from a URI's
       query component or in an encoded entity-body read from the standard
       input (as with the POST method). The [34m[1mform content types[0m[1m[22m[1]
       application/x-www-form-urlencoded and multipart/form-data are both
       understood.

       The program has several different modes of operation, one of which may
       be specified by the first command line argument.

       [1mcgiparse [22mcombines query parameters found in the [1mQUERY_STRING[0m
       environment variable with parameters found in the message body it reads
       from the standard input.  [34m[1mRFC 3875[0m[1m[22m[2] states (S4.1.7) that the query
       string value is case-sensitive.

       Duplicate parameter names are allowed by default; see [1m-nodups [22mand
       [1m-duperror[22m, which override duplicate handling described below.

[1mOPTIONS[0m
       The [4mmode[24m may be exactly one of the following:

       [1m-arg [4m[22mvariable-name[0m
           Emit the value of the CGI parameter [4mvariable-name[24m, then exit. If
           there is no such parameter, the exit status will be 1 instead of 0.
           If more than one instance of [4mvariable-name[24m is present, only one
           will be considered.

       [1m-checkdup[0m
           Check if any parameter name occurs more than once, then terminate.
           If a duplicate is found, the exit status will be 1, otherwise 0.

       [1m-targ [4m[22mvariable-name[0m
           Test if the CGI parameter [4mvariable-name[24m exists. If there is no such
           parameter, the exit status will be 1, otherwise it will be 0.

       [1m-html[0m
           Emit an HTML document that lists the CGI parameter names and their
           values. All instances of duplicate parameter names are output.

       [1m-one[0m
           Emit a listing of the CGI parameter values (without the names). All
           parameter values are output, including those associated with
           duplicate parameter names.

       [1m-sh[0m
       [1m--shell[0m
           Emit CGI parameters as a single line in the format:


               [4mvariable-name[24m='[4mvariable-value[24m'; [...]

           It is an error if any [4mvariable-name[24m or [4mvariable-value[24m is
           syntactically unsuitable for this format. The returned string can
           be used as the argument to [1meval [22mto set the CGI parameters as shell
           variables. All parameters are output, including duplicates, in
           which case a variable will be assigned the value from the parameter
           instance that happens to appear last in the list.

       [1m-text[0m
           Like [1m-html [22mexcept emit text. This is the default. In this mode, the
           program's stdout is usually written to a file. Each line of the
           file has the format:

               [4mvariable-name[24m [4mvariable-value[0m

           A space separates the name from the corresponding value. The file
           is typically read by a script to obtain the parameters, or [1mcgiparse[0m
           can be run with the [1m-in [22mflag to retrieve a parameter. All instances
           of duplicate parameter names are output.

       [1m--version[0m
           Print version information to stderr and exit.

       Additionally, [1mcgiparse [22mrecognizes these options and modifiers:

           If writing the parsed CGI parameters ([1m-text[22m), encode the parameter
           value using the specified method:

           url
               Selects URL encoding.

           mime
               Selects MIME base-64 encoding.

           dacs
               Selects [1mDACS [22mbase-64 encoding.

           none
               Indicates that no encoding is performed (use this only when you
               are sure this cannot cause a problem).

           For details about these encodings, please see [34m[1mdacs.exprs(5)[0m[1m[22m[3]. The
           default is none. If reading the parsed CGI parameters ([1m-in[22m), decode
           the parameter values using the specified method. The default is
           none, which means that no decoding is performed; if the parameters
           were encoded, they will be returned in that encoding, but other
           than this case the decoding method must match the encoding method
           previously used or an error is likely to occur.

       [1m-qs [4m[22mquery-string[0m
           Instead of using the environment variable [4mQUERY_STRING[24m to get a
           query component, use [4mquery-string[24m.

       [1m-nonewline[0m
           With [1m-arg[22m, do not emit a newline after printing a parameter value.

       [1m-nodups[0m
           If a duplicate parameter name is read, all but one (arbitrary)
           instance will be discarded.

       [1m-duperror[0m
           If a duplicate parameter name is read, processing terminates
           immediately.

       [1m-d[0m
           Enable debugging output.

       [1m-copy [4m[22mfilename[0m
           Append the input stream to [4mfilename[24m. This can be useful for
           debugging purposes.

       [1m-in [4m[22mfilename[0m
           Instead of parsing CGI parameters, read variable name/value pairs
           (in the format produced by the [1m-text [22mflag) from [4mfilename[24m. If
           [4mfilename[24m is "-", stdin is read.

       [1m-n [4m[22mname[24m [4mfilename[0m
           If parsing succeeds, and there is a MIME body part with a name
           exactly matching [4mname[24m, then:

           +o   if the content disposition is multipart/form-data, write the
               content as quoted-printable text to [4mfilename[24m;

           +o   if the content disposition is base64, write the decoded content
               to [4mfilename[24m;

           +o   otherwise the content is written verbatim to [4mfilename[24m.
               If the output file exists it is truncated.

[1mEXAMPLES[0m
       The following shell script demonstrates one way of using [1mcgiparse[22m.



           #! /bin/sh

           tmpfile=/tmp/cgiparse.$$

           cgiparse > ${tmpfile}
           chmod 0600 ${tmpfile}

           echo "Context-Type: text/plain"
           echo ""

           done=
           while [ "${done}x" = x ]
           do
             a=
             b=
             read a b
             if [ $? = 1 ]
             then
               done=1
               break
             else
               echo "Arg: ${a}"
               echo "Is: ${b}"
             fi
           done < ${tmpfile}

           rm -f ${tmpfile}
           exit 0

       The following code fragment uses [1mcgiparse [22mto save and then look up its
       CGI parameters:

           #! /bin/sh

           tmpfile=/tmp/cgiparse.$$
           trap 'rm -f ${tmpfile}; exit 1' EXIT 1 2 3 13 15

           cgiparse -enc mime > ${tmpfile}
           chmod 0600 ${tmpfile}

           mode=`cgiparse -in ${tmpfile} -enc mime -arg MODE`
           target=`cgiparse -in ${tmpfile} -enc mime -arg TARGET`

       The following script will print "1 2 3" to its standard output:

           #! /bin/sh

           args=`cgiparse -sh -qs "a=1&b=2&c=3"`
           eval "$args"
           echo "$a $b $c"


[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mBUGS[0m
       There do not appear to be any official recommendations concerning how
       to handle apparently "malformed" CGI query strings that do not look
       like a sequence of [4mname[24m=[4mvalue[24m pairs. The parsing routines that [1mcgiparse[0m
       uses will flag an error if they see strings containing a component like
       "=foo", for example, although "foo=" is fine.

       The manner in which duplicate CGI parameters is handled is not
       standardized and context-specific.  [1mcgiparse [22mcould do a little better
       in this respect.

[1mSEE ALSO[0m
       [34m[1mRFC 3875[0m[1m[22m[2], [34m[1mRFC 3986[0m[1m[22m[4], [34m[1mThe WWW Common Gateway Interface, Version[0m
       [1m[34m1.2[0m[1m[22m[5], [34m[1mHTML 4.01 Specification[0m[1m[22m[6], [34m[1mdacs_prenv(8)[0m[1m[22m[7]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[8])

[1mCOPYING[0m
       Copyright (C) 2003-2014 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[9] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. form content types
           http://www.w3.org/TR/html401/interact/forms.html#h-17.13.4

        2. RFC 3875
           http://www.rfc-editor.org/rfc/rfc3875.txt

        3. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html#encode

        4. RFC 3986
           http://www.rfc-editor.org/rfc/rfc3986.txt

        5. The WWW Common Gateway Interface, Version 1.2
           http://ken.coar.org/cgi/cgi-120-00a.html

        6. HTML 4.01 Specification
           http://www.w3.org/TR/html4/

        7. dacs_prenv(8)
           http://dacs.dss.ca/man/dacs_prenv.8.html

        8. www.dss.ca
           http://www.dss.ca

        9. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.40                       02/01/2018                       CGIPARSE(8)
