/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.LogTools;

public class PreviewPane
extends JPanel
implements PropertyChangeListener,
Runnable {
    protected IFormatReader reader;
    protected JLabel iconLabel;
    protected JLabel resLabel;
    protected JLabel zctLabel;
    protected JLabel typeLabel;
    protected Thread loader;
    protected boolean loaderAlive;
    protected String loadId;
    protected String lastId;

    public PreviewPane(JFileChooser jc) {
        this.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.reader = new ImageReader();
        this.reader.setNormalized(true);
        this.setLayout(new BoxLayout(this, 1));
        this.iconLabel = new JLabel();
        this.iconLabel.setMinimumSize(new Dimension(128, -1));
        this.iconLabel.setAlignmentX(0.5f);
        this.add(this.iconLabel);
        this.add(Box.createVerticalStrut(7));
        this.resLabel = new JLabel("");
        this.resLabel.setAlignmentX(0.5f);
        this.add(this.resLabel);
        this.zctLabel = new JLabel("");
        this.zctLabel.setAlignmentX(0.5f);
        this.add(this.zctLabel);
        this.typeLabel = new JLabel("");
        this.typeLabel.setAlignmentX(0.5f);
        this.add(this.typeLabel);
        if (jc != null) {
            jc.setAccessory(this);
            jc.addPropertyChangeListener(this);
            this.loaderAlive = true;
            this.loader = new Thread((Runnable)this, "Preview");
            this.loader.start();
        }
    }

    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        return new Dimension(128, prefSize.height);
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("JFileChooserDialogIsClosingProperty")) {
            this.loaderAlive = false;
        }
        if (!prop.equals("SelectedFileChangedProperty")) {
            return;
        }
        File selection = (File)e.getNewValue();
        if (selection == null) {
            return;
        }
        this.loadId = selection.getAbsolutePath();
    }

    public void run() {
        while (this.loaderAlive) {
            String id;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException exc) {
                LogTools.trace(exc);
            }
            if ((id = this.loadId) == this.lastId) continue;
            if (id != null && this.lastId != null) {
                String[] files = this.reader.getUsedFiles();
                boolean found = false;
                for (int i = 0; i < files.length; ++i) {
                    if (!id.equals(files[i])) continue;
                    found = true;
                    break;
                }
                if (found) continue;
            }
            this.lastId = id;
            this.iconLabel.setIcon(null);
            this.resLabel.setText(id == null ? "" : "Reading...");
            this.zctLabel.setText("");
            this.typeLabel.setText("");
            if (id == null) continue;
            try {
                this.reader.setId(id);
            }
            catch (FormatException exc) {
                LogTools.trace(exc);
                this.resLabel.setText("Unsupported");
                boolean badFormat = exc.getMessage().startsWith("Unknown file format");
                this.zctLabel.setText(badFormat ? "format" : "file");
                continue;
            }
            catch (IOException exc) {
                LogTools.trace(exc);
                this.resLabel.setText("Unsupported");
                this.zctLabel.setText("file");
                continue;
            }
            if (id != this.loadId) continue;
            this.iconLabel.setIcon(id == null ? null : new ImageIcon(this.makeImage("Loading...")));
            this.resLabel.setText(this.reader.getSizeX() + " x " + this.reader.getSizeY());
            this.zctLabel.setText(this.reader.getSizeZ() + "Z x " + this.reader.getSizeT() + "T x " + this.reader.getSizeC() + "C");
            this.typeLabel.setText(this.reader.getRGBChannelCount() + " x " + FormatTools.getPixelTypeString(this.reader.getPixelType()));
            int z = this.reader.getSizeZ() / 2;
            int t = this.reader.getSizeT() / 2;
            int ndx = this.reader.getIndex(z, 0, t);
            BufferedImage thumb = null;
            try {
                thumb = this.reader.openThumbImage(ndx);
            }
            catch (FormatException exc) {
                LogTools.trace(exc);
            }
            catch (IOException exc) {
                LogTools.trace(exc);
            }
            this.iconLabel.setIcon(new ImageIcon(thumb == null ? this.makeImage("Failed") : thumb));
            this.repaint();
        }
    }

    private BufferedImage makeImage(String message) {
        int w = this.reader.getThumbSizeX();
        int h = this.reader.getThumbSizeY();
        if (w < 128) {
            w = 128;
        }
        if (h < 32) {
            h = 32;
        }
        BufferedImage image = new BufferedImage(w, h, 1);
        Graphics2D g = image.createGraphics();
        Rectangle2D.Float r = (Rectangle2D.Float)g.getFont().getStringBounds(message, g.getFontRenderContext());
        g.drawString(message, ((float)w - r.width) / 2.0f, ((float)h - r.height) / 2.0f + r.height);
        g.dispose();
        return image;
    }
}

