/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;

public class Stereographic
extends AbstractCoordTransBuilder {
    public String getTransformName() {
        return "stereographic";
    }

    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        double lon0 = this.readAttributeDouble(ctv, "longitude_of_projection_origin", Double.NaN);
        double scale = this.readAttributeDouble(ctv, "scale_factor_at_projection_origin", 1.0);
        double lat0 = this.readAttributeDouble(ctv, "latitude_of_projection_origin", 90.0);
        double false_easting = this.readAttributeDouble(ctv, "false_easting", 0.0);
        double false_northing = this.readAttributeDouble(ctv, "false_northing", 0.0);
        if (false_easting != 0.0 || false_northing != 0.0) {
            double scalef = Stereographic.getFalseEastingScaleFactor(ds, ctv);
            false_easting *= scalef;
            false_northing *= scalef;
        }
        ucar.unidata.geoloc.projection.Stereographic proj = new ucar.unidata.geoloc.projection.Stereographic(lat0, lon0, scale, false_easting, false_northing);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

