/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.iosp.Indexer;
import ucar.nc2.iosp.SingleChunkIndexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegularLayout
extends Indexer {
    private List<Dim> dimList = new ArrayList<Dim>();
    private Index myIndex;
    private int elemSize;
    private long startPos;
    private Indexer.Chunk chunk;
    private int nelems;
    private long total;
    private long done;
    private boolean debug = false;
    private boolean debugMerge = false;
    private boolean debugNext = false;

    public static Indexer factory(long startPos, int elemSize, int recSize, int[] varShape, Section wantSection) throws InvalidRangeException {
        if (recSize <= 0 && wantSection.equivalent(varShape)) {
            return new SingleChunkIndexer(startPos, (int)wantSection.computeSize(), elemSize);
        }
        return new RegularLayout(startPos, elemSize, recSize, varShape, wantSection);
    }

    public RegularLayout(int[] varShape, int elemSize, long startPos, List<Range> ranges, int recSize) throws InvalidRangeException {
        this(startPos, elemSize, recSize, varShape, new Section(ranges));
    }

    public RegularLayout(long startPos, int elemSize, int recSize, int[] varShape, Section wantSection) throws InvalidRangeException {
        Dim elem2;
        Dim elem;
        int i;
        int lastDim;
        assert (startPos >= 0L);
        assert (elemSize > 0);
        this.elemSize = elemSize;
        wantSection = Section.fill(wantSection, varShape);
        this.total = wantSection.computeSize();
        this.done = 0L;
        boolean isRecord = recSize > 0;
        int varRank = varShape.length;
        int stride = 1;
        for (int ii = varRank - 1; ii >= 0; --ii) {
            int realStride = isRecord && ii == 0 ? recSize : elemSize * stride;
            this.dimList.add(new Dim(realStride, varShape[ii], wantSection.getRange(ii)));
            stride *= varShape[ii];
        }
        int n = lastDim = isRecord ? 2 : 1;
        if (this.debugMerge) {
            System.out.println("merge= " + this);
        }
        int merge = 0;
        for (i = 0; i < this.dimList.size() - lastDim; ++i) {
            elem = this.dimList.get(i);
            elem2 = this.dimList.get(i + 1);
            if (elem.maxSize != elem.wantSize || elem2.want.stride() != 1) break;
            ++merge;
        }
        for (i = 0; i < merge; ++i) {
            elem = this.dimList.get(i);
            elem2 = this.dimList.get(i + 1);
            elem2.maxSize *= elem.maxSize;
            elem2.wantSize *= elem.wantSize;
            if (!this.debugMerge) continue;
            System.out.println(" ----" + this);
        }
        for (i = 0; i < merge; ++i) {
            this.dimList.remove(0);
        }
        if (this.debug) {
            System.out.println(" final= " + this);
        }
        if (varRank == 0 || isRecord && varRank == 1 || this.dimList.get((int)0).want.stride() > 1) {
            this.nelems = 1;
        } else {
            Dim innerDim = this.dimList.get(0);
            this.nelems = innerDim.wantSize;
            innerDim.wantSize = 1;
        }
        long offset = 0L;
        for (Dim dim : this.dimList) {
            offset += (long)(dim.byteStride * dim.want.first());
        }
        this.startPos = startPos + offset;
        int rank = this.dimList.size();
        int[] byteStride = new int[rank];
        int[] shape = new int[rank];
        for (int i2 = 0; i2 < this.dimList.size(); ++i2) {
            Dim dim = this.dimList.get(i2);
            byteStride[rank - i2 - 1] = dim.byteStride * dim.want.stride();
            shape[rank - i2 - 1] = dim.wantSize;
        }
        if (this.debug) {
            this.printa(" indexShape=", shape);
            this.printa(" indexStride=", byteStride);
            System.out.println(" indexChunks=" + Index.computeSize(shape));
        }
        this.myIndex = new Index(shape, byteStride);
        long nchunks = Index.computeSize(shape);
        assert (nchunks * (long)this.nelems == this.total);
        if (this.debug) {
            System.out.println("RegularLayout = " + this);
            System.out.println("startPos= " + startPos + " elemSize= " + elemSize + " recSize= " + recSize + " varShape= " + this.printa(varShape) + " section= " + wantSection);
        }
    }

    public int getChunkSize() {
        return this.nelems;
    }

    @Override
    public long getTotalNelems() {
        return this.total;
    }

    @Override
    public int getElemSize() {
        return this.elemSize;
    }

    @Override
    public boolean hasNext() {
        return this.done < this.total;
    }

    @Override
    public Indexer.Chunk next() {
        if (this.chunk == null) {
            this.chunk = new Indexer.Chunk(this.startPos, this.nelems, 0L);
        } else {
            this.myIndex.incr();
            this.chunk.incrStartElem(this.nelems);
        }
        this.chunk.setFilePos(this.startPos + (long)this.myIndex.currentElement());
        if (this.debugNext) {
            System.out.println(" next chunk: " + this.chunk);
        }
        this.done += (long)this.nelems;
        return this.chunk;
    }

    public String toString() {
        Dim elem;
        int i;
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("wantSize=");
        for (i = 0; i < this.dimList.size(); ++i) {
            elem = this.dimList.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(elem.wantSize);
        }
        sbuff.append(" wantStride=");
        for (i = 0; i < this.dimList.size(); ++i) {
            elem = this.dimList.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(elem.want.stride());
        }
        sbuff.append(" maxSize=");
        for (i = 0; i < this.dimList.size(); ++i) {
            elem = this.dimList.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(elem.maxSize);
        }
        sbuff.append(" byteStride=");
        for (i = 0; i < this.dimList.size(); ++i) {
            elem = this.dimList.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(elem.byteStride);
        }
        return sbuff.toString();
    }

    private class Dim {
        int byteStride;
        int maxSize;
        Range want;
        int wantSize;

        Dim(int byteStride, int maxSize, Range want) {
            this.byteStride = byteStride;
            this.maxSize = maxSize;
            this.wantSize = want.length();
            this.want = want;
        }
    }
}

