/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.Index;
import ucar.grib.TableLookup;
import ucar.grib.grib1.Grib1Lookup;
import ucar.grid.GridParameter;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.grib.GribCoordSys;
import ucar.nc2.iosp.grib.GribHorizCoordSys;
import ucar.nc2.iosp.grib.GribRecordLW;
import ucar.nc2.iosp.grib.GribServiceProvider;
import ucar.nc2.iosp.grib.GribTimeCoord;
import ucar.nc2.iosp.grib.GribVertCoord;
import ucar.nc2.iosp.grib.Index2NC;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GribVariable {
    private static Logger log = LoggerFactory.getLogger(GribVariable.class);
    private String name;
    private String desc;
    private String vname;
    int levelType1;
    private TableLookup lookup;
    private boolean isGrib1;
    private GribHorizCoordSys hcs;
    private GribCoordSys vcs;
    private GribTimeCoord tcs;
    private GribVertCoord vc;
    private List<Index.GribRecord> records = new ArrayList<Index.GribRecord>();
    private int nlevels;
    private int ntimes;
    private GribRecordLW[] recordTracker;
    private int decimalScale = 0;
    private boolean hasVert = false;
    private boolean showRecords = false;
    private boolean showGen = false;
    private int hashCode = 0;

    GribVariable(String name, String desc, GribHorizCoordSys hcs, TableLookup lookup) {
        this.name = name;
        this.desc = desc;
        this.hcs = hcs;
        this.lookup = lookup;
        this.isGrib1 = lookup instanceof Grib1Lookup;
    }

    void addProduct(Index.GribRecord record) {
        if (this.records.size() == 0) {
            this.levelType1 = record.levelType1;
        }
        this.records.add(record);
    }

    List<Index.GribRecord> getRecords() {
        return this.records;
    }

    Index.GribRecord getFirstRecord() {
        return this.records.get(0);
    }

    GribHorizCoordSys getHorizCoordSys() {
        return this.hcs;
    }

    GribCoordSys getVertCoordSys() {
        return this.vcs;
    }

    GribVertCoord getVertCoord() {
        return this.vc;
    }

    boolean hasVert() {
        return this.hasVert;
    }

    void setVarName(String vname) {
        this.vname = vname;
    }

    void setVertCoordSys(GribCoordSys vcs) {
        this.vcs = vcs;
    }

    void setVertCoord(GribVertCoord vc) {
        this.vc = vc;
    }

    void setTimeCoord(GribTimeCoord tcs) {
        this.tcs = tcs;
    }

    int getVertNlevels() {
        return this.vcs == null ? this.vc.getNLevels() : this.vcs.getNLevels();
    }

    String getVertName() {
        return this.vcs == null ? this.vc.getVariableName() : this.vcs.getVerticalName();
    }

    String getVertLevelName() {
        return this.vcs == null ? this.vc.getLevelName() : this.vcs.getVerticalName();
    }

    boolean getVertIsUsed() {
        return this.vcs == null ? !this.vc.dontUseVertical : !this.vcs.dontUseVertical;
    }

    int getVertIndex(Index.GribRecord p) {
        return this.vcs == null ? this.vc.getIndex(p) : this.vcs.getIndex(p);
    }

    int getNTimes() {
        return this.tcs == null ? 1 : this.tcs.getNTimes();
    }

    Variable makeVariable(NetcdfFile ncfile, Group g, boolean useDesc) {
        int[] paramId;
        assert (this.records.size() > 0) : "no records for this variable";
        Index.GribRecord firstRecord = this.records.get(0);
        this.nlevels = this.getVertNlevels();
        this.ntimes = this.tcs.getNTimes();
        this.decimalScale = firstRecord.decimalScale;
        if (this.vname == null) {
            this.vname = useDesc ? this.desc : this.name;
        }
        this.vname = StringUtil.replace(this.vname, ' ', "_");
        Variable v = new Variable(ncfile, g, null, this.vname);
        v.setDataType(DataType.FLOAT);
        String dims = this.tcs.getName();
        if (this.getVertIsUsed()) {
            dims = dims + " " + this.getVertName();
            this.hasVert = true;
        }
        dims = this.hcs.isLatLon() ? dims + " lat lon" : dims + " y x";
        v.setDimensions(dims);
        GridParameter param = this.lookup.getParameter(firstRecord);
        v.addAttribute(new Attribute("units", param.getUnit()));
        v.addAttribute(new Attribute("long_name", Index2NC.makeLongName(firstRecord, this.lookup)));
        v.addAttribute(new Attribute("missing_value", Float.valueOf(this.lookup.getFirstMissingValue())));
        if (!this.hcs.isLatLon()) {
            if (GribServiceProvider.addLatLon) {
                v.addAttribute(new Attribute("coordinates", "lat lon"));
            }
            v.addAttribute(new Attribute("grid_mapping", this.hcs.getGridName()));
        }
        if ((paramId = this.lookup.getParameterId(firstRecord))[0] == 1) {
            v.addAttribute(new Attribute("GRIB_param_name", param.getDescription()));
            v.addAttribute(new Attribute("GRIB_center_id", paramId[1]));
            v.addAttribute(new Attribute("GRIB_table_id", paramId[2]));
            v.addAttribute(new Attribute("GRIB_param_number", paramId[3]));
        } else {
            v.addAttribute(new Attribute("GRIB_param_discipline", this.lookup.getDisciplineName(firstRecord)));
            v.addAttribute(new Attribute("GRIB_param_category", this.lookup.getCategoryName(firstRecord)));
            v.addAttribute(new Attribute("GRIB_param_name", param.getName()));
        }
        v.addAttribute(new Attribute("GRIB_param_id", Array.factory(Integer.TYPE, new int[]{paramId.length}, (Object)paramId)));
        v.addAttribute(new Attribute("GRIB_product_definition_type", this.lookup.getProductDefinitionName(firstRecord)));
        v.addAttribute(new Attribute("GRIB_level_type", firstRecord.levelType1));
        v.setSPobject(this);
        if (this.showRecords) {
            System.out.println("Variable " + this.getName());
        }
        this.recordTracker = new GribRecordLW[this.ntimes * this.nlevels];
        for (Index.GribRecord p : this.records) {
            if (this.showRecords) {
                System.out.println(" " + this.vc.getVariableName() + " (type=" + p.levelType1 + "," + p.levelType2 + ")  value=" + p.levelValue1 + "," + p.levelValue2 + " # genProcess=" + p.typeGenProcess);
            }
            if (this.showGen && !this.isGrib1 && !p.typeGenProcess.equals("2")) {
                System.out.println(" " + this.getName() + " genProcess=" + p.typeGenProcess);
            }
            int level = this.getVertIndex(p);
            if (!this.getVertIsUsed() && level > 0) {
                log.warn("inconsistent level encoding=" + level);
                level = 0;
            }
            int time = this.tcs.getIndex(p);
            if (level < 0) {
                log.warn("NOT FOUND record; level=" + level + " time= " + time + " for " + this.getName() + " file=" + ncfile.getLocation() + "\n" + "   " + this.getVertLevelName() + " (type=" + p.levelType1 + "," + p.levelType2 + ")  value=" + p.levelValue1 + "," + p.levelValue2 + "\n");
                this.getVertIndex(p);
                continue;
            }
            if (time < 0) {
                log.warn("NOT FOUND record; level=" + level + " time= " + time + " for " + this.getName() + " file=" + ncfile.getLocation() + "\n" + " forecastTime= " + p.forecastTime + " date= " + this.tcs.getValidTime(p) + "\n");
                this.tcs.getIndex(p);
                continue;
            }
            int recno = time * this.nlevels + level;
            if (this.recordTracker[recno] == null) {
                this.recordTracker[recno] = new GribRecordLW(p);
                continue;
            }
            GribRecordLW q = this.recordTracker[recno];
            if (!p.typeGenProcess.equals(q.typeGenProcess)) {
                log.warn("Duplicate record; level=" + level + " time= " + time + " for " + this.getName() + " file=" + ncfile.getLocation() + "\n" + "   " + this.getVertLevelName() + " (type=" + p.levelType1 + "," + p.levelType2 + ")  value=" + p.levelValue1 + "," + p.levelValue2 + "\n" + "   gen=" + p.typeGenProcess + " prev=" + q.typeGenProcess);
            }
            this.recordTracker[recno] = new GribRecordLW(p);
        }
        this.records.clear();
        return v;
    }

    void dumpMissing() {
        System.out.println("  " + this.name);
        for (int j = 0; j < this.nlevels; ++j) {
            System.out.print("   ");
            for (int i = 0; i < this.ntimes; ++i) {
                boolean missing = this.recordTracker[i * this.nlevels + j] == null;
                System.out.print(missing ? "-" : "X");
            }
            System.out.println();
        }
    }

    int dumpMissingSummary() {
        if (this.nlevels == 1) {
            return 0;
        }
        int count = 0;
        int total = this.nlevels * this.ntimes;
        for (int i = 0; i < total; ++i) {
            if (this.recordTracker[i] != null) continue;
            ++count;
        }
        System.out.println("  MISSING= " + count + "/" + total + " " + this.name);
        return count;
    }

    public GribRecordLW findRecord(int time, int level) {
        return this.recordTracker[time * this.nlevels + level];
    }

    public String getName() {
        return this.name;
    }

    public String getParamName() {
        return this.desc;
    }

    public int getDecimalScale() {
        return this.decimalScale;
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof GribVariable)) {
            return false;
        }
        GribVariable that = (GribVariable)oo;
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        if (!this.hcs.getID().equals(that.hcs.getID())) {
            return false;
        }
        return this.levelType1 == that.levelType1;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.name.hashCode();
            result += 37 * result + this.levelType1;
            result += 37 * result + this.hcs.getID().hashCode();
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String dump() {
        DateFormatter formatter = new DateFormatter();
        StringBuilder sbuff = new StringBuilder();
        sbuff.append(this.name).append(" ").append(this.records.size()).append("\n");
        for (Index.GribRecord record : this.records) {
            sbuff.append(" level = ").append(record.levelType1).append(" ").append(record.levelValue1);
            if (null != record.getValidTime()) {
                sbuff.append(" time = ").append(formatter.toDateTimeString(record.getValidTime()));
            }
            sbuff.append("\n");
        }
        return sbuff.toString();
    }
}

