using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

#region Google Picasa specific imports
using Google.GData.Client;
using Google.GData.Extensions;
using Google.GData.Photos;
using Google.GData.Tools;
#endregion

namespace Google_PicasaApplication
{
    public partial class Form1 : Form
    {

        private String googleAuthToken = null;
        private PicasaService picasaService = null;

        public Form1()
        {
            InitializeComponent();

            this.picasaService = new PicasaService("GoogleSpreadsheetsSample");

            if (this.googleAuthToken == null)
            {
                GoogleClientLogin loginDialog = new GoogleClientLogin(this.picasaService, "youremailhere@gmail.com");
                if (loginDialog.ShowDialog() == DialogResult.OK)
                {
                    this.googleAuthToken = loginDialog.AuthenticationToken;
                    if (this.googleAuthToken != null)
                    {
                        this.picasaService.SetAuthenticationToken(this.googleAuthToken);
                        this.Text = "Successfully logged in";
                        // get the albums feed... 
                        AlbumQuery query = new AlbumQuery();

                        this.listView.Clear();

                        query.Uri = new Uri(PicasaQuery.CreatePicasaUri(loginDialog.User));
                        PicasaFeed picasaFeed = this.picasaService.Query(query);
                        if (picasaFeed != null && picasaFeed.Entries.Count > 0)
                        {
                            foreach (PicasaEntry entry in picasaFeed.Entries)
                            {
                                ListViewItem item = new ListViewItem(entry.Title.Text +
                                                " (" + entry.GetPhotoExtensionValue(GPhotoNameTable.NumPhotos) + " )");
                                item.Tag = entry;
                                this.listView.Items.Add(item);
                            }
                        }
                        this.listView.Update();
                    }
                }
            }
        }
    }
}