// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{translate::*, Error};

crate::wrapper! {
    #[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
    pub struct MarkupParseContext(Shared<ffi::GMarkupParseContext>);

    match fn {
        ref => |ptr| ffi::g_markup_parse_context_ref(ptr),
        unref => |ptr| ffi::g_markup_parse_context_unref(ptr),
        type_ => || ffi::g_markup_parse_context_get_type(),
    }
}

impl MarkupParseContext {
    //#[doc(alias = "g_markup_parse_context_new")]
    //pub fn new(parser: /*Ignored*/&MarkupParser, flags: /*Ignored*/MarkupParseFlags, user_data: /*Unimplemented*/Option<Basic: Pointer>) -> MarkupParseContext {
    //    unsafe { TODO: call ffi:g_markup_parse_context_new() }
    //}

    #[doc(alias = "g_markup_parse_context_end_parse")]
    pub fn end_parse(&self) -> Result<(), crate::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::g_markup_parse_context_end_parse(self.to_glib_none().0, &mut error);
            debug_assert_eq!(is_ok == crate::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "g_markup_parse_context_get_element")]
    #[doc(alias = "get_element")]
    pub fn element(&self) -> crate::GString {
        unsafe {
            from_glib_none(ffi::g_markup_parse_context_get_element(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_markup_parse_context_get_element_stack")]
    #[doc(alias = "get_element_stack")]
    pub fn element_stack(&self) -> Vec<crate::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::g_markup_parse_context_get_element_stack(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_markup_parse_context_get_position")]
    #[doc(alias = "get_position")]
    pub fn position(&self) -> (i32, i32) {
        unsafe {
            let mut line_number = std::mem::MaybeUninit::uninit();
            let mut char_number = std::mem::MaybeUninit::uninit();
            ffi::g_markup_parse_context_get_position(
                self.to_glib_none().0,
                line_number.as_mut_ptr(),
                char_number.as_mut_ptr(),
            );
            (line_number.assume_init(), char_number.assume_init())
        }
    }

    #[doc(alias = "g_markup_parse_context_parse")]
    pub fn parse(&self, text: &str) -> Result<(), crate::Error> {
        let text_len = text.len() as _;
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::g_markup_parse_context_parse(
                self.to_glib_none().0,
                text.to_glib_none().0,
                text_len,
                &mut error,
            );
            debug_assert_eq!(is_ok == crate::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    //#[doc(alias = "g_markup_parse_context_pop")]
    //pub fn pop(&self) -> /*Unimplemented*/Option<Basic: Pointer> {
    //    unsafe { TODO: call ffi:g_markup_parse_context_pop() }
    //}

    //#[doc(alias = "g_markup_parse_context_push")]
    //pub fn push(&self, parser: /*Ignored*/&MarkupParser, user_data: /*Unimplemented*/Option<Basic: Pointer>) {
    //    unsafe { TODO: call ffi:g_markup_parse_context_push() }
    //}
}
