// Code generated by smithy-go-codegen DO NOT EDIT.

package forecast

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/forecast/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Describes a dataset import job created using the CreateDatasetImportJob (https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html)
// operation. In addition to listing the parameters provided in the
// CreateDatasetImportJob request, this operation includes the following
// properties:
//   - CreationTime
//   - LastModificationTime
//   - DataSize
//   - FieldStatistics
//   - Status
//   - Message - If an error occurred, information about the error.
func (c *Client) DescribeDatasetImportJob(ctx context.Context, params *DescribeDatasetImportJobInput, optFns ...func(*Options)) (*DescribeDatasetImportJobOutput, error) {
	if params == nil {
		params = &DescribeDatasetImportJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeDatasetImportJob", params, optFns, c.addOperationDescribeDatasetImportJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeDatasetImportJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeDatasetImportJobInput struct {

	// The Amazon Resource Name (ARN) of the dataset import job.
	//
	// This member is required.
	DatasetImportJobArn *string

	noSmithyDocumentSerde
}

type DescribeDatasetImportJobOutput struct {

	// When the dataset import job was created.
	CreationTime *time.Time

	// The size of the dataset in gigabytes (GB) after the import job has finished.
	DataSize *float64

	// The location of the training data to import and an Identity and Access
	// Management (IAM) role that Amazon Forecast can assume to access the data. If
	// encryption is used, DataSource includes an Key Management Service (KMS) key.
	DataSource *types.DataSource

	// The Amazon Resource Name (ARN) of the dataset that the training data was
	// imported to.
	DatasetArn *string

	// The ARN of the dataset import job.
	DatasetImportJobArn *string

	// The name of the dataset import job.
	DatasetImportJobName *string

	// The estimated time remaining in minutes for the dataset import job to complete.
	EstimatedTimeRemainingInMinutes *int64

	// Statistical information about each field in the input data.
	FieldStatistics map[string]types.Statistics

	// The format of the imported data, CSV or PARQUET.
	Format *string

	// The format of the geolocation attribute. Valid Values: "LAT_LONG" and
	// "CC_POSTALCODE" .
	GeolocationFormat *string

	// The import mode of the dataset import job, FULL or INCREMENTAL.
	ImportMode types.ImportMode

	// The last time the resource was modified. The timestamp depends on the status of
	// the job:
	//   - CREATE_PENDING - The CreationTime .
	//   - CREATE_IN_PROGRESS - The current timestamp.
	//   - CREATE_STOPPING - The current timestamp.
	//   - CREATE_STOPPED - When the job stopped.
	//   - ACTIVE or CREATE_FAILED - When the job finished or failed.
	LastModificationTime *time.Time

	// If an error occurred, an informational message about the error.
	Message *string

	// The status of the dataset import job. States include:
	//   - ACTIVE
	//   - CREATE_PENDING , CREATE_IN_PROGRESS , CREATE_FAILED
	//   - DELETE_PENDING , DELETE_IN_PROGRESS , DELETE_FAILED
	//   - CREATE_STOPPING , CREATE_STOPPED
	Status *string

	// The single time zone applied to every item in the dataset
	TimeZone *string

	// The format of timestamps in the dataset. The format that you specify depends on
	// the DataFrequency specified when the dataset was created. The following formats
	// are supported
	//   - "yyyy-MM-dd" For the following data frequencies: Y, M, W, and D
	//   - "yyyy-MM-dd HH:mm:ss" For the following data frequencies: H, 30min, 15min,
	//   and 1min; and optionally, for: Y, M, W, and D
	TimestampFormat *string

	// Whether TimeZone is automatically derived from the geolocation attribute.
	UseGeolocationForTimeZone bool

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeDatasetImportJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeDatasetImportJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeDatasetImportJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeDatasetImportJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeDatasetImportJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeDatasetImportJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeDatasetImportJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeDatasetImportJob",
	}
}
