// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/tenant_service.proto

package talent

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The Request of the CreateTenant method.
type CreateTenantRequest struct {
	// Required. Resource name of the project under which the tenant is created.
	//
	// The format is "projects/{project_id}", for example,
	// "projects/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The tenant to be created.
	Tenant               *Tenant  `protobuf:"bytes,2,opt,name=tenant,proto3" json:"tenant,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTenantRequest) Reset()         { *m = CreateTenantRequest{} }
func (m *CreateTenantRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTenantRequest) ProtoMessage()    {}
func (*CreateTenantRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2df49c13fa187082, []int{0}
}

func (m *CreateTenantRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTenantRequest.Unmarshal(m, b)
}
func (m *CreateTenantRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTenantRequest.Marshal(b, m, deterministic)
}
func (m *CreateTenantRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTenantRequest.Merge(m, src)
}
func (m *CreateTenantRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTenantRequest.Size(m)
}
func (m *CreateTenantRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTenantRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTenantRequest proto.InternalMessageInfo

func (m *CreateTenantRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTenantRequest) GetTenant() *Tenant {
	if m != nil {
		return m.Tenant
	}
	return nil
}

// Request for getting a tenant by name.
type GetTenantRequest struct {
	// Required. The resource name of the tenant to be retrieved.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/foo/tenants/bar".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTenantRequest) Reset()         { *m = GetTenantRequest{} }
func (m *GetTenantRequest) String() string { return proto.CompactTextString(m) }
func (*GetTenantRequest) ProtoMessage()    {}
func (*GetTenantRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2df49c13fa187082, []int{1}
}

func (m *GetTenantRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTenantRequest.Unmarshal(m, b)
}
func (m *GetTenantRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTenantRequest.Marshal(b, m, deterministic)
}
func (m *GetTenantRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTenantRequest.Merge(m, src)
}
func (m *GetTenantRequest) XXX_Size() int {
	return xxx_messageInfo_GetTenantRequest.Size(m)
}
func (m *GetTenantRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTenantRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTenantRequest proto.InternalMessageInfo

func (m *GetTenantRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for updating a specified tenant.
type UpdateTenantRequest struct {
	// Required. The tenant resource to replace the current resource in the system.
	Tenant *Tenant `protobuf:"bytes,1,opt,name=tenant,proto3" json:"tenant,omitempty"`
	// Strongly recommended for the best service experience.
	//
	// If [update_mask][google.cloud.talent.v4beta1.UpdateTenantRequest.update_mask] is provided, only the specified fields in
	// [tenant][google.cloud.talent.v4beta1.UpdateTenantRequest.tenant] are updated. Otherwise all the fields are updated.
	//
	// A field mask to specify the tenant fields to be updated. Only
	// top level fields of [Tenant][google.cloud.talent.v4beta1.Tenant] are supported.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateTenantRequest) Reset()         { *m = UpdateTenantRequest{} }
func (m *UpdateTenantRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTenantRequest) ProtoMessage()    {}
func (*UpdateTenantRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2df49c13fa187082, []int{2}
}

func (m *UpdateTenantRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTenantRequest.Unmarshal(m, b)
}
func (m *UpdateTenantRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTenantRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTenantRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTenantRequest.Merge(m, src)
}
func (m *UpdateTenantRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTenantRequest.Size(m)
}
func (m *UpdateTenantRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTenantRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTenantRequest proto.InternalMessageInfo

func (m *UpdateTenantRequest) GetTenant() *Tenant {
	if m != nil {
		return m.Tenant
	}
	return nil
}

func (m *UpdateTenantRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request to delete a tenant.
type DeleteTenantRequest struct {
	// Required. The resource name of the tenant to be deleted.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/foo/tenants/bar".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTenantRequest) Reset()         { *m = DeleteTenantRequest{} }
func (m *DeleteTenantRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTenantRequest) ProtoMessage()    {}
func (*DeleteTenantRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2df49c13fa187082, []int{3}
}

func (m *DeleteTenantRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTenantRequest.Unmarshal(m, b)
}
func (m *DeleteTenantRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTenantRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTenantRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTenantRequest.Merge(m, src)
}
func (m *DeleteTenantRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTenantRequest.Size(m)
}
func (m *DeleteTenantRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTenantRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTenantRequest proto.InternalMessageInfo

func (m *DeleteTenantRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// List tenants for which the client has ACL visibility.
type ListTenantsRequest struct {
	// Required. Resource name of the project under which the tenant is created.
	//
	// The format is "projects/{project_id}", for example,
	// "projects/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The starting indicator from which to return results.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of tenants to be returned, at most 100.
	// Default is 100 if a non-positive number is provided.
	PageSize             int32    `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTenantsRequest) Reset()         { *m = ListTenantsRequest{} }
func (m *ListTenantsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTenantsRequest) ProtoMessage()    {}
func (*ListTenantsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2df49c13fa187082, []int{4}
}

func (m *ListTenantsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTenantsRequest.Unmarshal(m, b)
}
func (m *ListTenantsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTenantsRequest.Marshal(b, m, deterministic)
}
func (m *ListTenantsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTenantsRequest.Merge(m, src)
}
func (m *ListTenantsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTenantsRequest.Size(m)
}
func (m *ListTenantsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTenantsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTenantsRequest proto.InternalMessageInfo

func (m *ListTenantsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTenantsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListTenantsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// The List tenants response object.
type ListTenantsResponse struct {
	// Tenants for the current client.
	Tenants []*Tenant `protobuf:"bytes,1,rep,name=tenants,proto3" json:"tenants,omitempty"`
	// A token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Additional information for the API invocation, such as the request
	// tracking id.
	Metadata             *ResponseMetadata `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ListTenantsResponse) Reset()         { *m = ListTenantsResponse{} }
func (m *ListTenantsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTenantsResponse) ProtoMessage()    {}
func (*ListTenantsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2df49c13fa187082, []int{5}
}

func (m *ListTenantsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTenantsResponse.Unmarshal(m, b)
}
func (m *ListTenantsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTenantsResponse.Marshal(b, m, deterministic)
}
func (m *ListTenantsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTenantsResponse.Merge(m, src)
}
func (m *ListTenantsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTenantsResponse.Size(m)
}
func (m *ListTenantsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTenantsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTenantsResponse proto.InternalMessageInfo

func (m *ListTenantsResponse) GetTenants() []*Tenant {
	if m != nil {
		return m.Tenants
	}
	return nil
}

func (m *ListTenantsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListTenantsResponse) GetMetadata() *ResponseMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateTenantRequest)(nil), "google.cloud.talent.v4beta1.CreateTenantRequest")
	proto.RegisterType((*GetTenantRequest)(nil), "google.cloud.talent.v4beta1.GetTenantRequest")
	proto.RegisterType((*UpdateTenantRequest)(nil), "google.cloud.talent.v4beta1.UpdateTenantRequest")
	proto.RegisterType((*DeleteTenantRequest)(nil), "google.cloud.talent.v4beta1.DeleteTenantRequest")
	proto.RegisterType((*ListTenantsRequest)(nil), "google.cloud.talent.v4beta1.ListTenantsRequest")
	proto.RegisterType((*ListTenantsResponse)(nil), "google.cloud.talent.v4beta1.ListTenantsResponse")
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/tenant_service.proto", fileDescriptor_2df49c13fa187082)
}

var fileDescriptor_2df49c13fa187082 = []byte{
	// 789 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x95, 0x4d, 0x6f, 0xd3, 0x4c,
	0x10, 0xc7, 0xb5, 0xc9, 0xf3, 0xa4, 0xcd, 0xa6, 0x15, 0xc8, 0x91, 0x20, 0xb8, 0x45, 0x8d, 0x0c,
	0xaa, 0x42, 0xda, 0xda, 0x21, 0x05, 0x0e, 0xad, 0x2a, 0x70, 0xca, 0x8b, 0x78, 0xa9, 0x14, 0x39,
	0xe5, 0xc2, 0x25, 0xda, 0x24, 0x5b, 0xd7, 0xad, 0xed, 0x35, 0xde, 0x4d, 0x0b, 0x45, 0x95, 0x10,
	0x77, 0x4e, 0xf4, 0x8a, 0x84, 0x10, 0x82, 0x8f, 0x82, 0xc4, 0x11, 0x6e, 0x3d, 0xf5, 0xc0, 0xa7,
	0xe0, 0x84, 0xbc, 0xbb, 0x49, 0xdd, 0x24, 0x4d, 0xa3, 0x4a, 0xdc, 0xb2, 0x3b, 0xf3, 0x9f, 0xfd,
	0xcd, 0x4c, 0x66, 0x0c, 0x4b, 0x36, 0x21, 0xb6, 0x8b, 0x8d, 0xa6, 0x4b, 0xda, 0x2d, 0x83, 0x21,
	0x17, 0xfb, 0xcc, 0xd8, 0xb9, 0xd5, 0xc0, 0x0c, 0xdd, 0x34, 0x18, 0xf6, 0x91, 0xcf, 0xea, 0x14,
	0x87, 0x3b, 0x4e, 0x13, 0xeb, 0x41, 0x48, 0x18, 0x51, 0xa6, 0x84, 0x42, 0xe7, 0x0a, 0x5d, 0x28,
	0x74, 0xa9, 0x50, 0xa7, 0x65, 0x38, 0x14, 0x38, 0x06, 0xf2, 0x7d, 0xc2, 0x10, 0x73, 0x88, 0x4f,
	0x85, 0x54, 0xbd, 0x1c, 0xb3, 0x36, 0x5d, 0x27, 0x12, 0x0a, 0xc3, 0x4c, 0xcc, 0xb0, 0xe1, 0x60,
	0xb7, 0x55, 0x6f, 0xe0, 0x4d, 0xb4, 0xe3, 0x90, 0x50, 0x3a, 0x5c, 0x89, 0x39, 0x84, 0x98, 0x92,
	0x76, 0xd8, 0xe1, 0x51, 0x0b, 0xc3, 0x32, 0x68, 0x12, 0xcf, 0x23, 0xfe, 0x28, 0x9e, 0x22, 0x57,
	0xe9, 0x29, 0x73, 0x34, 0xf8, 0xa9, 0xd1, 0xde, 0x30, 0xb0, 0x17, 0xb0, 0xd7, 0xd2, 0x98, 0xef,
	0x35, 0x0a, 0x62, 0x0f, 0xd1, 0x6d, 0xe1, 0xa1, 0x7d, 0x01, 0x30, 0xbb, 0x1a, 0x62, 0xc4, 0xf0,
	0x3a, 0x8f, 0x6a, 0xe1, 0x97, 0x6d, 0x4c, 0x99, 0xf2, 0x14, 0xa6, 0x02, 0x14, 0x62, 0x9f, 0xe5,
	0x40, 0x1e, 0x14, 0xd2, 0x95, 0xc5, 0x23, 0x33, 0xf1, 0xc7, 0x5c, 0x80, 0x73, 0x9c, 0xa8, 0x93,
	0x97, 0x87, 0x7c, 0x64, 0xe3, 0x50, 0x17, 0xcf, 0xa0, 0xc0, 0xa1, 0x7a, 0x93, 0x78, 0x46, 0x35,
	0x24, 0x5b, 0xb8, 0xc9, 0x2c, 0x19, 0x42, 0xb9, 0x07, 0x53, 0x82, 0x39, 0x97, 0xc8, 0x83, 0x42,
	0xa6, 0x7c, 0x4d, 0x1f, 0xd2, 0x18, 0x5d, 0x80, 0x54, 0x92, 0x47, 0x66, 0xc2, 0x92, 0x3a, 0xed,
	0x09, 0xbc, 0xf8, 0x08, 0xb3, 0x93, 0x88, 0x77, 0xe0, 0x7f, 0x3e, 0xf2, 0xb0, 0x04, 0xd4, 0x38,
	0xe0, 0x34, 0x54, 0xb7, 0x48, 0x83, 0xf6, 0x02, 0x49, 0x21, 0xf7, 0xd7, 0x0e, 0x00, 0xcc, 0x3e,
	0x0f, 0x5a, 0x7d, 0x29, 0x1f, 0x53, 0x82, 0xf3, 0x51, 0x2a, 0xcb, 0x30, 0xd3, 0xe6, 0x81, 0x79,
	0x85, 0x65, 0xb2, 0x6a, 0x27, 0x4c, 0xa7, 0x09, 0xfa, 0xc3, 0xa8, 0x09, 0x6b, 0x88, 0x6e, 0x5b,
	0x50, 0xb8, 0x47, 0xbf, 0xb5, 0x35, 0x98, 0xbd, 0x8f, 0x5d, 0xdc, 0x4b, 0x75, 0xde, 0x2c, 0x3f,
	0x02, 0xa8, 0x3c, 0x73, 0xa8, 0xac, 0x19, 0xfd, 0x27, 0x7d, 0xbd, 0x0a, 0x61, 0x80, 0x6c, 0x5c,
	0x67, 0x64, 0x1b, 0xfb, 0x3c, 0xdd, 0xb4, 0x95, 0x8e, 0x6e, 0xd6, 0xa3, 0x0b, 0x65, 0x0a, 0xf2,
	0x43, 0x9d, 0x3a, 0x7b, 0x38, 0x97, 0xcc, 0x83, 0xc2, 0xff, 0xd6, 0x78, 0x74, 0x51, 0x73, 0xf6,
	0xb0, 0xf6, 0x1d, 0xc0, 0xec, 0x09, 0x3e, 0x1a, 0x10, 0x9f, 0x62, 0x65, 0x05, 0x8e, 0x89, 0x6a,
	0xd2, 0x1c, 0xc8, 0x27, 0x47, 0x6c, 0x83, 0xd5, 0xd1, 0x28, 0xb3, 0xf0, 0x82, 0x8f, 0x5f, 0xb1,
	0x7a, 0x1f, 0xd7, 0x64, 0x74, 0x5d, 0xed, 0xb2, 0x3d, 0x86, 0xe3, 0x1e, 0x66, 0xa8, 0x85, 0x18,
	0xe2, 0x68, 0x99, 0xf2, 0xc2, 0xd0, 0x77, 0x3a, 0x7c, 0x6b, 0x52, 0x64, 0x75, 0xe5, 0xe5, 0x4f,
	0x63, 0x70, 0x52, 0x60, 0xd4, 0xc4, 0xf6, 0x51, 0xbe, 0x02, 0x38, 0x11, 0x1f, 0x2a, 0xa5, 0x34,
	0x34, 0xf6, 0x80, 0xf9, 0x53, 0x47, 0xc9, 0x5a, 0xbb, 0x7b, 0x68, 0x4e, 0x8a, 0x56, 0xcc, 0x8b,
	0xfc, 0xdf, 0xfd, 0xfa, 0xfd, 0x21, 0x71, 0x43, 0xbb, 0xde, 0x5d, 0x15, 0x6f, 0x84, 0x79, 0x25,
	0x10, 0x9d, 0xa3, 0x46, 0x71, 0x5f, 0xae, 0x0f, 0xba, 0x04, 0x8a, 0xca, 0x01, 0x80, 0xe9, 0xee,
	0x5c, 0x29, 0xc3, 0x2b, 0xd0, 0x3b, 0x7f, 0xa3, 0x21, 0x2e, 0x1e, 0x9a, 0xfc, 0xff, 0xc8, 0xc9,
	0x66, 0x95, 0x18, 0x59, 0x74, 0x1b, 0xe3, 0xea, 0x60, 0x19, 0xc5, 0x7d, 0x5e, 0xbf, 0xf8, 0x84,
	0x9e, 0x51, 0xbf, 0x01, 0xc3, 0x3c, 0x72, 0xfd, 0x52, 0xb1, 0xc2, 0x95, 0xca, 0x73, 0xc7, 0x78,
	0x72, 0xc9, 0x9e, 0x4e, 0x19, 0xd5, 0xef, 0x3d, 0x80, 0x13, 0xf1, 0xa1, 0x3d, 0x03, 0x74, 0xc0,
	0x7c, 0xab, 0x97, 0xfa, 0xd6, 0xc3, 0x83, 0x68, 0x81, 0xf7, 0x14, 0xae, 0x38, 0x5a, 0xe1, 0xbe,
	0x01, 0x98, 0x89, 0x0d, 0x95, 0x62, 0x0c, 0xc5, 0xe9, 0x5f, 0x0f, 0x6a, 0x69, 0x74, 0x81, 0x98,
	0x07, 0xed, 0xf6, 0xa1, 0x29, 0xd7, 0x41, 0x7f, 0x8b, 0x4f, 0xff, 0xf3, 0xa9, 0xee, 0x0f, 0x33,
	0x3b, 0x60, 0x87, 0xfd, 0x34, 0x6b, 0x9b, 0x8c, 0x05, 0x74, 0xc9, 0x30, 0x76, 0x77, 0x77, 0x7b,
	0xf7, 0x0f, 0x6a, 0xb3, 0x4d, 0xf1, 0x49, 0x5c, 0x08, 0x5c, 0xc4, 0x36, 0x48, 0xe8, 0xcd, 0x9f,
	0xe5, 0x1e, 0x3d, 0x52, 0x79, 0x0b, 0xe0, 0x4c, 0x93, 0x78, 0xc3, 0x92, 0xab, 0x28, 0x27, 0x66,
	0xb8, 0x1a, 0x75, 0xa3, 0x0a, 0x5e, 0x98, 0x52, 0x62, 0x13, 0x17, 0xf9, 0xb6, 0x4e, 0x42, 0xdb,
	0xb0, 0xb1, 0xcf, 0x7b, 0x65, 0x1c, 0x3f, 0x37, 0xf0, 0x3b, 0xbd, 0x2c, 0x8e, 0x9f, 0x13, 0xc9,
	0xd5, 0xf5, 0x5a, 0x23, 0xc5, 0x35, 0x8b, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x36, 0x01, 0x1c,
	0x54, 0xc6, 0x08, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// TenantServiceClient is the client API for TenantService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TenantServiceClient interface {
	// Creates a new tenant entity.
	CreateTenant(ctx context.Context, in *CreateTenantRequest, opts ...grpc.CallOption) (*Tenant, error)
	// Retrieves specified tenant.
	GetTenant(ctx context.Context, in *GetTenantRequest, opts ...grpc.CallOption) (*Tenant, error)
	// Updates specified tenant.
	UpdateTenant(ctx context.Context, in *UpdateTenantRequest, opts ...grpc.CallOption) (*Tenant, error)
	// Deletes specified tenant.
	DeleteTenant(ctx context.Context, in *DeleteTenantRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists all tenants associated with the project.
	ListTenants(ctx context.Context, in *ListTenantsRequest, opts ...grpc.CallOption) (*ListTenantsResponse, error)
}

type tenantServiceClient struct {
	cc *grpc.ClientConn
}

func NewTenantServiceClient(cc *grpc.ClientConn) TenantServiceClient {
	return &tenantServiceClient{cc}
}

func (c *tenantServiceClient) CreateTenant(ctx context.Context, in *CreateTenantRequest, opts ...grpc.CallOption) (*Tenant, error) {
	out := new(Tenant)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.TenantService/CreateTenant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tenantServiceClient) GetTenant(ctx context.Context, in *GetTenantRequest, opts ...grpc.CallOption) (*Tenant, error) {
	out := new(Tenant)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.TenantService/GetTenant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tenantServiceClient) UpdateTenant(ctx context.Context, in *UpdateTenantRequest, opts ...grpc.CallOption) (*Tenant, error) {
	out := new(Tenant)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.TenantService/UpdateTenant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tenantServiceClient) DeleteTenant(ctx context.Context, in *DeleteTenantRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.TenantService/DeleteTenant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tenantServiceClient) ListTenants(ctx context.Context, in *ListTenantsRequest, opts ...grpc.CallOption) (*ListTenantsResponse, error) {
	out := new(ListTenantsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.TenantService/ListTenants", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TenantServiceServer is the server API for TenantService service.
type TenantServiceServer interface {
	// Creates a new tenant entity.
	CreateTenant(context.Context, *CreateTenantRequest) (*Tenant, error)
	// Retrieves specified tenant.
	GetTenant(context.Context, *GetTenantRequest) (*Tenant, error)
	// Updates specified tenant.
	UpdateTenant(context.Context, *UpdateTenantRequest) (*Tenant, error)
	// Deletes specified tenant.
	DeleteTenant(context.Context, *DeleteTenantRequest) (*empty.Empty, error)
	// Lists all tenants associated with the project.
	ListTenants(context.Context, *ListTenantsRequest) (*ListTenantsResponse, error)
}

// UnimplementedTenantServiceServer can be embedded to have forward compatible implementations.
type UnimplementedTenantServiceServer struct {
}

func (*UnimplementedTenantServiceServer) CreateTenant(ctx context.Context, req *CreateTenantRequest) (*Tenant, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTenant not implemented")
}
func (*UnimplementedTenantServiceServer) GetTenant(ctx context.Context, req *GetTenantRequest) (*Tenant, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTenant not implemented")
}
func (*UnimplementedTenantServiceServer) UpdateTenant(ctx context.Context, req *UpdateTenantRequest) (*Tenant, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTenant not implemented")
}
func (*UnimplementedTenantServiceServer) DeleteTenant(ctx context.Context, req *DeleteTenantRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTenant not implemented")
}
func (*UnimplementedTenantServiceServer) ListTenants(ctx context.Context, req *ListTenantsRequest) (*ListTenantsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTenants not implemented")
}

func RegisterTenantServiceServer(s *grpc.Server, srv TenantServiceServer) {
	s.RegisterService(&_TenantService_serviceDesc, srv)
}

func _TenantService_CreateTenant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTenantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TenantServiceServer).CreateTenant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.TenantService/CreateTenant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TenantServiceServer).CreateTenant(ctx, req.(*CreateTenantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TenantService_GetTenant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTenantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TenantServiceServer).GetTenant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.TenantService/GetTenant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TenantServiceServer).GetTenant(ctx, req.(*GetTenantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TenantService_UpdateTenant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTenantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TenantServiceServer).UpdateTenant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.TenantService/UpdateTenant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TenantServiceServer).UpdateTenant(ctx, req.(*UpdateTenantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TenantService_DeleteTenant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTenantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TenantServiceServer).DeleteTenant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.TenantService/DeleteTenant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TenantServiceServer).DeleteTenant(ctx, req.(*DeleteTenantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TenantService_ListTenants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTenantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TenantServiceServer).ListTenants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.TenantService/ListTenants",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TenantServiceServer).ListTenants(ctx, req.(*ListTenantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TenantService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.talent.v4beta1.TenantService",
	HandlerType: (*TenantServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTenant",
			Handler:    _TenantService_CreateTenant_Handler,
		},
		{
			MethodName: "GetTenant",
			Handler:    _TenantService_GetTenant_Handler,
		},
		{
			MethodName: "UpdateTenant",
			Handler:    _TenantService_UpdateTenant_Handler,
		},
		{
			MethodName: "DeleteTenant",
			Handler:    _TenantService_DeleteTenant_Handler,
		},
		{
			MethodName: "ListTenants",
			Handler:    _TenantService_ListTenants_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/talent/v4beta1/tenant_service.proto",
}
