// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/containeranalysis/v1beta1/containeranalysis.proto

package containeranalysis

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A scan configuration specifies whether Cloud components in a project have a
// particular type of analysis being run. For example, it can configure whether
// vulnerability scanning is being done on Docker images or not.
type ScanConfig struct {
	// Output only. The name of the scan configuration in the form of
	// `projects/[PROJECT_ID]/scanConfigs/[SCAN_CONFIG_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. A human-readable description of what the scan configuration
	// does.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Whether the scan is enabled.
	Enabled bool `protobuf:"varint,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Output only. The time this scan config was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time this scan config was last updated.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ScanConfig) Reset()         { *m = ScanConfig{} }
func (m *ScanConfig) String() string { return proto.CompactTextString(m) }
func (*ScanConfig) ProtoMessage()    {}
func (*ScanConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_20a7ff65c4c4547f, []int{0}
}

func (m *ScanConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScanConfig.Unmarshal(m, b)
}
func (m *ScanConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScanConfig.Marshal(b, m, deterministic)
}
func (m *ScanConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanConfig.Merge(m, src)
}
func (m *ScanConfig) XXX_Size() int {
	return xxx_messageInfo_ScanConfig.Size(m)
}
func (m *ScanConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ScanConfig proto.InternalMessageInfo

func (m *ScanConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ScanConfig) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ScanConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *ScanConfig) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *ScanConfig) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// Request to get a scan configuration.
type GetScanConfigRequest struct {
	// Required. The name of the scan configuration in the form of
	// `projects/[PROJECT_ID]/scanConfigs/[SCAN_CONFIG_ID]`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetScanConfigRequest) Reset()         { *m = GetScanConfigRequest{} }
func (m *GetScanConfigRequest) String() string { return proto.CompactTextString(m) }
func (*GetScanConfigRequest) ProtoMessage()    {}
func (*GetScanConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_20a7ff65c4c4547f, []int{1}
}

func (m *GetScanConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetScanConfigRequest.Unmarshal(m, b)
}
func (m *GetScanConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetScanConfigRequest.Marshal(b, m, deterministic)
}
func (m *GetScanConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetScanConfigRequest.Merge(m, src)
}
func (m *GetScanConfigRequest) XXX_Size() int {
	return xxx_messageInfo_GetScanConfigRequest.Size(m)
}
func (m *GetScanConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetScanConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetScanConfigRequest proto.InternalMessageInfo

func (m *GetScanConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to list scan configurations.
type ListScanConfigsRequest struct {
	// Required. The name of the project to list scan configurations for in the form of
	// `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The number of scan configs to return in the list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListScanConfigsRequest) Reset()         { *m = ListScanConfigsRequest{} }
func (m *ListScanConfigsRequest) String() string { return proto.CompactTextString(m) }
func (*ListScanConfigsRequest) ProtoMessage()    {}
func (*ListScanConfigsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_20a7ff65c4c4547f, []int{2}
}

func (m *ListScanConfigsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListScanConfigsRequest.Unmarshal(m, b)
}
func (m *ListScanConfigsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListScanConfigsRequest.Marshal(b, m, deterministic)
}
func (m *ListScanConfigsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListScanConfigsRequest.Merge(m, src)
}
func (m *ListScanConfigsRequest) XXX_Size() int {
	return xxx_messageInfo_ListScanConfigsRequest.Size(m)
}
func (m *ListScanConfigsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListScanConfigsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListScanConfigsRequest proto.InternalMessageInfo

func (m *ListScanConfigsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListScanConfigsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListScanConfigsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListScanConfigsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for listing scan configurations.
type ListScanConfigsResponse struct {
	// The scan configurations requested.
	ScanConfigs []*ScanConfig `protobuf:"bytes,1,rep,name=scan_configs,json=scanConfigs,proto3" json:"scan_configs,omitempty"`
	// The next pagination token in the list response. It should be used as
	// `page_token` for the following request. An empty value means no more
	// results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListScanConfigsResponse) Reset()         { *m = ListScanConfigsResponse{} }
func (m *ListScanConfigsResponse) String() string { return proto.CompactTextString(m) }
func (*ListScanConfigsResponse) ProtoMessage()    {}
func (*ListScanConfigsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_20a7ff65c4c4547f, []int{3}
}

func (m *ListScanConfigsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListScanConfigsResponse.Unmarshal(m, b)
}
func (m *ListScanConfigsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListScanConfigsResponse.Marshal(b, m, deterministic)
}
func (m *ListScanConfigsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListScanConfigsResponse.Merge(m, src)
}
func (m *ListScanConfigsResponse) XXX_Size() int {
	return xxx_messageInfo_ListScanConfigsResponse.Size(m)
}
func (m *ListScanConfigsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListScanConfigsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListScanConfigsResponse proto.InternalMessageInfo

func (m *ListScanConfigsResponse) GetScanConfigs() []*ScanConfig {
	if m != nil {
		return m.ScanConfigs
	}
	return nil
}

func (m *ListScanConfigsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to update a scan configuration.
type UpdateScanConfigRequest struct {
	// Required. The name of the scan configuration in the form of
	// `projects/[PROJECT_ID]/scanConfigs/[SCAN_CONFIG_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The updated scan configuration.
	ScanConfig           *ScanConfig `protobuf:"bytes,2,opt,name=scan_config,json=scanConfig,proto3" json:"scan_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *UpdateScanConfigRequest) Reset()         { *m = UpdateScanConfigRequest{} }
func (m *UpdateScanConfigRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateScanConfigRequest) ProtoMessage()    {}
func (*UpdateScanConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_20a7ff65c4c4547f, []int{4}
}

func (m *UpdateScanConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateScanConfigRequest.Unmarshal(m, b)
}
func (m *UpdateScanConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateScanConfigRequest.Marshal(b, m, deterministic)
}
func (m *UpdateScanConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateScanConfigRequest.Merge(m, src)
}
func (m *UpdateScanConfigRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateScanConfigRequest.Size(m)
}
func (m *UpdateScanConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateScanConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateScanConfigRequest proto.InternalMessageInfo

func (m *UpdateScanConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateScanConfigRequest) GetScanConfig() *ScanConfig {
	if m != nil {
		return m.ScanConfig
	}
	return nil
}

func init() {
	proto.RegisterType((*ScanConfig)(nil), "google.devtools.containeranalysis.v1beta1.ScanConfig")
	proto.RegisterType((*GetScanConfigRequest)(nil), "google.devtools.containeranalysis.v1beta1.GetScanConfigRequest")
	proto.RegisterType((*ListScanConfigsRequest)(nil), "google.devtools.containeranalysis.v1beta1.ListScanConfigsRequest")
	proto.RegisterType((*ListScanConfigsResponse)(nil), "google.devtools.containeranalysis.v1beta1.ListScanConfigsResponse")
	proto.RegisterType((*UpdateScanConfigRequest)(nil), "google.devtools.containeranalysis.v1beta1.UpdateScanConfigRequest")
}

func init() {
	proto.RegisterFile("google/devtools/containeranalysis/v1beta1/containeranalysis.proto", fileDescriptor_20a7ff65c4c4547f)
}

var fileDescriptor_20a7ff65c4c4547f = []byte{
	// 963 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0xd7, 0x38, 0x6d, 0x48, 0xc6, 0x89, 0x52, 0x8d, 0x0a, 0x31, 0x2e, 0x7f, 0xac, 0x15, 0x42,
	0xae, 0x49, 0x77, 0xe4, 0x44, 0xa8, 0xc2, 0x15, 0x94, 0x75, 0x90, 0x2c, 0x04, 0x07, 0xcb, 0x09,
	0x08, 0xa5, 0x12, 0xd6, 0x78, 0x3d, 0xde, 0x0c, 0xec, 0xce, 0x2c, 0x3b, 0x63, 0xa7, 0x6d, 0x94,
	0x0b, 0xe2, 0x02, 0x07, 0x84, 0xc4, 0x91, 0x5b, 0x3f, 0x04, 0x07, 0x0e, 0xc0, 0x99, 0x23, 0x88,
	0x8b, 0x85, 0x44, 0x0f, 0x9c, 0xf8, 0x08, 0x9c, 0xd0, 0xce, 0xee, 0xda, 0x13, 0x6f, 0xda, 0xd8,
	0x89, 0x7a, 0xb2, 0xe7, 0xfd, 0xde, 0xbf, 0xdf, 0x7b, 0x33, 0xef, 0x2d, 0x74, 0x3c, 0x21, 0x3c,
	0x9f, 0xe2, 0x3e, 0x1d, 0x29, 0x21, 0x7c, 0x89, 0x5d, 0xc1, 0x15, 0x61, 0x9c, 0x46, 0x84, 0x13,
	0xff, 0x81, 0x64, 0x12, 0x8f, 0xea, 0x3d, 0xaa, 0x48, 0x3d, 0x8f, 0xd8, 0x61, 0x24, 0x94, 0x40,
	0x37, 0x13, 0x17, 0x76, 0xe6, 0xc2, 0xce, 0x2b, 0xa6, 0x2e, 0xca, 0x2f, 0xa5, 0xd1, 0x48, 0xc8,
	0x30, 0xe1, 0x5c, 0x28, 0xa2, 0x98, 0xe0, 0xa9, 0xa3, 0xf2, 0xa6, 0x81, 0xba, 0x3e, 0xa3, 0x5c,
	0xa5, 0xc0, 0xab, 0x06, 0x30, 0x60, 0xd4, 0xef, 0x77, 0x7b, 0xf4, 0x90, 0x8c, 0x98, 0x88, 0x52,
	0x85, 0x17, 0x0d, 0x85, 0x88, 0x4a, 0x31, 0x8c, 0x5c, 0x9a, 0x42, 0xaf, 0xa4, 0x10, 0x23, 0x01,
	0x1e, 0xd5, 0xe3, 0x9f, 0x6e, 0x28, 0x7c, 0xe6, 0x3e, 0x48, 0xf1, 0xf2, 0x69, 0xfc, 0x14, 0x96,
	0xc5, 0xd5, 0xa7, 0xde, 0x70, 0x80, 0x15, 0x0b, 0xa8, 0x54, 0x24, 0x08, 0x13, 0x05, 0xeb, 0xc7,
	0x02, 0x84, 0x7b, 0x2e, 0xe1, 0xbb, 0x82, 0x0f, 0x98, 0x87, 0x10, 0xbc, 0xc2, 0x49, 0x40, 0x4b,
	0xa0, 0x02, 0xaa, 0xab, 0x1d, 0xfd, 0x1f, 0x55, 0x60, 0xb1, 0x4f, 0xa5, 0x1b, 0xb1, 0x30, 0xa6,
	0x5a, 0x2a, 0x68, 0xc8, 0x14, 0xa1, 0x12, 0x7c, 0x8e, 0x72, 0xd2, 0xf3, 0x69, 0xbf, 0xb4, 0x54,
	0x01, 0xd5, 0x95, 0x4e, 0x76, 0x44, 0x77, 0x60, 0xd1, 0x8d, 0x28, 0x51, 0xb4, 0x1b, 0x07, 0x2e,
	0x5d, 0xa9, 0x80, 0x6a, 0x71, 0xbb, 0x6c, 0xa7, 0xf5, 0xce, 0xb2, 0xb2, 0xf7, 0xb3, 0xac, 0x3a,
	0x30, 0x51, 0x8f, 0x05, 0xb1, 0xf1, 0x30, 0xec, 0x4f, 0x8c, 0xaf, 0x9e, 0x6f, 0x9c, 0xa8, 0xc7,
	0x82, 0xc6, 0xa7, 0xff, 0x3a, 0xf7, 0xe0, 0x1b, 0xf9, 0x46, 0x26, 0xd6, 0x24, 0x64, 0x71, 0x97,
	0x03, 0x6c, 0x70, 0xdf, 0x0a, 0x23, 0xf1, 0x19, 0x75, 0x95, 0xc4, 0xc7, 0xe9, 0xbf, 0x13, 0x2c,
	0x27, 0xb0, 0xc4, 0xc7, 0xf1, 0xa1, 0xeb, 0xea, 0xd3, 0x89, 0xd5, 0x85, 0xd7, 0x5b, 0x54, 0x4d,
	0xcd, 0x3b, 0xf4, 0x8b, 0x21, 0x95, 0x0a, 0xb5, 0xcc, 0x0a, 0x36, 0x77, 0x1e, 0x3b, 0x85, 0xff,
	0x9c, 0x5b, 0x0b, 0x25, 0x92, 0x94, 0xdd, 0xfa, 0x19, 0xc0, 0x17, 0x3e, 0x64, 0xd2, 0x08, 0x21,
	0xb3, 0x18, 0x1f, 0xc0, 0xe5, 0x90, 0x44, 0x94, 0xab, 0x5c, 0x14, 0x5f, 0x0c, 0xfb, 0xd9, 0xf5,
	0x09, 0x08, 0x27, 0x1e, 0x8d, 0x66, 0x03, 0xb5, 0x13, 0x6e, 0x9d, 0xd4, 0x05, 0xba, 0x01, 0x97,
	0x07, 0xcc, 0x57, 0x34, 0x4a, 0x3a, 0xdb, 0x5c, 0x7a, 0xec, 0x14, 0x3a, 0xa9, 0x08, 0xdd, 0x80,
	0xab, 0x21, 0xf1, 0x68, 0x57, 0xb2, 0x87, 0x54, 0xf7, 0xf6, 0x6a, 0x67, 0x25, 0x16, 0xec, 0xb1,
	0x87, 0x14, 0xbd, 0x0c, 0xa1, 0x06, 0x95, 0xf8, 0x9c, 0x72, 0xdd, 0xdb, 0xd5, 0x8e, 0x56, 0xdf,
	0x8f, 0x05, 0xd6, 0x0f, 0x00, 0x6e, 0xe6, 0x08, 0xc8, 0x50, 0x70, 0x49, 0xd1, 0x27, 0x70, 0xcd,
	0xa8, 0xa6, 0x2c, 0x81, 0xca, 0x52, 0xb5, 0xb8, 0xfd, 0xa6, 0x3d, 0xf7, 0x43, 0xb4, 0x8d, 0x7a,
	0x15, 0x8d, 0x2e, 0xa1, 0xd7, 0xe1, 0x06, 0xa7, 0xf7, 0x55, 0xd7, 0xc8, 0x2c, 0xb9, 0xb1, 0xeb,
	0xb1, 0xb8, 0x3d, 0xc9, 0xee, 0x17, 0x00, 0x37, 0x3f, 0xd2, 0xd7, 0xe5, 0xd9, 0xf5, 0x10, 0xdd,
	0x83, 0x45, 0x83, 0xa6, 0x4e, 0xe4, 0xa2, 0x2c, 0x93, 0xbe, 0xc0, 0x29, 0xd5, 0xed, 0x9f, 0x8a,
	0xb0, 0xb4, 0x9b, 0x59, 0x3a, 0xa9, 0xe5, 0xc7, 0xf5, 0x66, 0x6c, 0x88, 0xfe, 0x02, 0x70, 0x6d,
	0x8f, 0xaa, 0xf7, 0x49, 0xd0, 0xd6, 0xf3, 0x00, 0x59, 0x59, 0x54, 0x46, 0x02, 0x7b, 0x54, 0xb7,
	0x4d, 0x30, 0xe5, 0x5d, 0x7e, 0x7e, 0x46, 0x27, 0x41, 0xad, 0xef, 0xc0, 0xd8, 0xd9, 0xc8, 0x6e,
	0xd5, 0x56, 0x32, 0x5f, 0xbe, 0xfc, 0xe3, 0x9f, 0xef, 0x0b, 0xf7, 0xad, 0x9d, 0xc9, 0x6c, 0x3d,
	0xce, 0x14, 0xde, 0x9e, 0x3c, 0xa3, 0x1a, 0xe6, 0x42, 0x51, 0x89, 0x6b, 0x27, 0x0d, 0x69, 0x44,
	0x6b, 0x80, 0xda, 0xc1, 0x3b, 0xd6, 0x5b, 0x4f, 0xb7, 0x14, 0xae, 0x3b, 0x8c, 0x22, 0xca, 0xdd,
	0x33, 0xed, 0xd1, 0x9f, 0x00, 0xae, 0xb5, 0x9e, 0x46, 0xaf, 0x35, 0x3f, 0xbd, 0xaf, 0xc1, 0xd8,
	0x59, 0xc9, 0x72, 0x58, 0x90, 0x97, 0x77, 0x49, 0x5e, 0x33, 0xf6, 0xe8, 0xdb, 0x02, 0x44, 0xfb,
	0x54, 0x6a, 0x21, 0x8d, 0x02, 0x26, 0x65, 0xbc, 0x5d, 0x50, 0x75, 0x26, 0xf3, 0xbc, 0x4a, 0xc6,
	0xf1, 0xe6, 0x1c, 0x9a, 0xc9, 0x1b, 0xb4, 0x1e, 0x81, 0xb1, 0x73, 0x7d, 0xda, 0xd6, 0xa9, 0x86,
	0xae, 0xc1, 0x57, 0xe0, 0x3c, 0x2a, 0x93, 0x22, 0xa8, 0x5c, 0x8c, 0xb8, 0x14, 0xef, 0x59, 0x77,
	0x17, 0x2a, 0xc5, 0x99, 0x5e, 0xd0, 0xaf, 0x00, 0xae, 0x9f, 0x9a, 0xb3, 0xe8, 0xee, 0x02, 0xcf,
	0xe7, 0xac, 0x09, 0x5d, 0xbe, 0xd8, 0xfb, 0xb3, 0x6e, 0x8f, 0x1d, 0xfd, 0xa8, 0x75, 0x75, 0x6a,
	0xa8, 0x3a, 0x25, 0x17, 0x4b, 0x4d, 0x62, 0xe6, 0xd2, 0xa8, 0x9d, 0xa0, 0x31, 0x80, 0x1b, 0x33,
	0x73, 0x10, 0x39, 0x0b, 0xe4, 0x70, 0xf6, 0x12, 0x28, 0x37, 0x2f, 0xe3, 0x22, 0xbd, 0x02, 0xef,
	0x8e, 0x9d, 0xf5, 0x64, 0x0d, 0x6c, 0x25, 0x03, 0x3f, 0x4f, 0x2e, 0x81, 0x0d, 0x7a, 0xa7, 0x96,
	0x22, 0xfa, 0x1b, 0xc0, 0x6b, 0xb3, 0x63, 0x14, 0x2d, 0x92, 0xda, 0x13, 0x66, 0xf0, 0x45, 0xbb,
	0xd4, 0x1e, 0x3b, 0xd7, 0xe2, 0x7e, 0x6c, 0x19, 0x73, 0x57, 0x93, 0xba, 0x5d, 0x9e, 0xbb, 0x63,
	0x0d, 0x73, 0x68, 0x97, 0xf7, 0x7f, 0x73, 0x2a, 0xe7, 0x4d, 0xfe, 0xdf, 0x1d, 0xfb, 0x50, 0xa9,
	0x50, 0x36, 0x30, 0x3e, 0x3a, 0x3a, 0x9a, 0x5d, 0x0b, 0x64, 0xa8, 0x0e, 0xb1, 0x5e, 0xcd, 0xb7,
	0x42, 0x9f, 0xa8, 0x81, 0x88, 0x82, 0xe6, 0x37, 0x00, 0xbe, 0xe6, 0x8a, 0x20, 0x23, 0xf9, 0x44,
	0x6e, 0x6d, 0x70, 0x70, 0x90, 0xea, 0x78, 0xc2, 0x27, 0xdc, 0xb3, 0x45, 0xe4, 0x61, 0x8f, 0x72,
	0xfd, 0xf9, 0x83, 0xa7, 0x91, 0xe6, 0xf8, 0xfe, 0xbd, 0x93, 0x43, 0x1e, 0x15, 0x96, 0x5a, 0xbb,
	0x4e, 0x6f, 0x59, 0x3b, 0xdb, 0xf9, 0x3f, 0x00, 0x00, 0xff, 0xff, 0xb6, 0x50, 0x92, 0xac, 0x4b,
	0x0b, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ContainerAnalysisV1Beta1Client is the client API for ContainerAnalysisV1Beta1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ContainerAnalysisV1Beta1Client interface {
	// Sets the access control policy on the specified note or occurrence.
	// Requires `containeranalysis.notes.setIamPolicy` or
	// `containeranalysis.occurrences.setIamPolicy` permission if the resource is
	// a note or an occurrence, respectively.
	//
	// The resource takes the format `projects/[PROJECT_ID]/notes/[NOTE_ID]` for
	// notes and `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]` for
	// occurrences.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets the access control policy for a note or an occurrence resource.
	// Requires `containeranalysis.notes.setIamPolicy` or
	// `containeranalysis.occurrences.setIamPolicy` permission if the resource is
	// a note or occurrence, respectively.
	//
	// The resource takes the format `projects/[PROJECT_ID]/notes/[NOTE_ID]` for
	// notes and `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]` for
	// occurrences.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns the permissions that a caller has on the specified note or
	// occurrence. Requires list permission on the project (for example,
	// `containeranalysis.notes.list`).
	//
	// The resource takes the format `projects/[PROJECT_ID]/notes/[NOTE_ID]` for
	// notes and `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]` for
	// occurrences.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
	// Gets the specified scan configuration.
	GetScanConfig(ctx context.Context, in *GetScanConfigRequest, opts ...grpc.CallOption) (*ScanConfig, error)
	// Lists scan configurations for the specified project.
	ListScanConfigs(ctx context.Context, in *ListScanConfigsRequest, opts ...grpc.CallOption) (*ListScanConfigsResponse, error)
	// Updates the specified scan configuration.
	UpdateScanConfig(ctx context.Context, in *UpdateScanConfigRequest, opts ...grpc.CallOption) (*ScanConfig, error)
}

type containerAnalysisV1Beta1Client struct {
	cc *grpc.ClientConn
}

func NewContainerAnalysisV1Beta1Client(cc *grpc.ClientConn) ContainerAnalysisV1Beta1Client {
	return &containerAnalysisV1Beta1Client{cc}
}

func (c *containerAnalysisV1Beta1Client) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisV1Beta1Client) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisV1Beta1Client) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisV1Beta1Client) GetScanConfig(ctx context.Context, in *GetScanConfigRequest, opts ...grpc.CallOption) (*ScanConfig, error) {
	out := new(ScanConfig)
	err := c.cc.Invoke(ctx, "/google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1/GetScanConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisV1Beta1Client) ListScanConfigs(ctx context.Context, in *ListScanConfigsRequest, opts ...grpc.CallOption) (*ListScanConfigsResponse, error) {
	out := new(ListScanConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1/ListScanConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisV1Beta1Client) UpdateScanConfig(ctx context.Context, in *UpdateScanConfigRequest, opts ...grpc.CallOption) (*ScanConfig, error) {
	out := new(ScanConfig)
	err := c.cc.Invoke(ctx, "/google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1/UpdateScanConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ContainerAnalysisV1Beta1Server is the server API for ContainerAnalysisV1Beta1 service.
type ContainerAnalysisV1Beta1Server interface {
	// Sets the access control policy on the specified note or occurrence.
	// Requires `containeranalysis.notes.setIamPolicy` or
	// `containeranalysis.occurrences.setIamPolicy` permission if the resource is
	// a note or an occurrence, respectively.
	//
	// The resource takes the format `projects/[PROJECT_ID]/notes/[NOTE_ID]` for
	// notes and `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]` for
	// occurrences.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Gets the access control policy for a note or an occurrence resource.
	// Requires `containeranalysis.notes.setIamPolicy` or
	// `containeranalysis.occurrences.setIamPolicy` permission if the resource is
	// a note or occurrence, respectively.
	//
	// The resource takes the format `projects/[PROJECT_ID]/notes/[NOTE_ID]` for
	// notes and `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]` for
	// occurrences.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Returns the permissions that a caller has on the specified note or
	// occurrence. Requires list permission on the project (for example,
	// `containeranalysis.notes.list`).
	//
	// The resource takes the format `projects/[PROJECT_ID]/notes/[NOTE_ID]` for
	// notes and `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]` for
	// occurrences.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
	// Gets the specified scan configuration.
	GetScanConfig(context.Context, *GetScanConfigRequest) (*ScanConfig, error)
	// Lists scan configurations for the specified project.
	ListScanConfigs(context.Context, *ListScanConfigsRequest) (*ListScanConfigsResponse, error)
	// Updates the specified scan configuration.
	UpdateScanConfig(context.Context, *UpdateScanConfigRequest) (*ScanConfig, error)
}

// UnimplementedContainerAnalysisV1Beta1Server can be embedded to have forward compatible implementations.
type UnimplementedContainerAnalysisV1Beta1Server struct {
}

func (*UnimplementedContainerAnalysisV1Beta1Server) SetIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedContainerAnalysisV1Beta1Server) GetIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedContainerAnalysisV1Beta1Server) TestIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (*UnimplementedContainerAnalysisV1Beta1Server) GetScanConfig(ctx context.Context, req *GetScanConfigRequest) (*ScanConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetScanConfig not implemented")
}
func (*UnimplementedContainerAnalysisV1Beta1Server) ListScanConfigs(ctx context.Context, req *ListScanConfigsRequest) (*ListScanConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListScanConfigs not implemented")
}
func (*UnimplementedContainerAnalysisV1Beta1Server) UpdateScanConfig(ctx context.Context, req *UpdateScanConfigRequest) (*ScanConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateScanConfig not implemented")
}

func RegisterContainerAnalysisV1Beta1Server(s *grpc.Server, srv ContainerAnalysisV1Beta1Server) {
	s.RegisterService(&_ContainerAnalysisV1Beta1_serviceDesc, srv)
}

func _ContainerAnalysisV1Beta1_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisV1Beta1Server).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisV1Beta1Server).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysisV1Beta1_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisV1Beta1Server).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisV1Beta1Server).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysisV1Beta1_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisV1Beta1Server).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisV1Beta1Server).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysisV1Beta1_GetScanConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetScanConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisV1Beta1Server).GetScanConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1/GetScanConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisV1Beta1Server).GetScanConfig(ctx, req.(*GetScanConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysisV1Beta1_ListScanConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListScanConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisV1Beta1Server).ListScanConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1/ListScanConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisV1Beta1Server).ListScanConfigs(ctx, req.(*ListScanConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysisV1Beta1_UpdateScanConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateScanConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisV1Beta1Server).UpdateScanConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1/UpdateScanConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisV1Beta1Server).UpdateScanConfig(ctx, req.(*UpdateScanConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ContainerAnalysisV1Beta1_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1",
	HandlerType: (*ContainerAnalysisV1Beta1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SetIamPolicy",
			Handler:    _ContainerAnalysisV1Beta1_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _ContainerAnalysisV1Beta1_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _ContainerAnalysisV1Beta1_TestIamPermissions_Handler,
		},
		{
			MethodName: "GetScanConfig",
			Handler:    _ContainerAnalysisV1Beta1_GetScanConfig_Handler,
		},
		{
			MethodName: "ListScanConfigs",
			Handler:    _ContainerAnalysisV1Beta1_ListScanConfigs_Handler,
		},
		{
			MethodName: "UpdateScanConfig",
			Handler:    _ContainerAnalysisV1Beta1_UpdateScanConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/containeranalysis/v1beta1/containeranalysis.proto",
}
