// -*- c++ -*-
// Generated by gmmproc 2.42.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_CAPSFEATURES_H
#define _GSTREAMERMM_CAPSFEATURES_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2014 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GstCapsFeatures GstCapsFeatures; }
#endif

namespace Gst
{

class CapsFeatures
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef CapsFeatures CppObjectType;
  typedef GstCapsFeatures BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;


  explicit CapsFeatures(GstCapsFeatures* gobject, bool make_a_copy = true);

  CapsFeatures(const CapsFeatures& other);
  CapsFeatures& operator=(const CapsFeatures& other);

  ~CapsFeatures();

  void swap(CapsFeatures& other);

  ///Provides access to the underlying C instance.
  GstCapsFeatures*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GstCapsFeatures* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GstCapsFeatures* gobj_copy() const;

protected:
  GstCapsFeatures* gobject_;

private:


public:
  

  /**
   * Creates a new, empty Gst::CapsFeatures.
   */
  CapsFeatures();
  

  /**
   * Creates a new Gst::CapsFeatures with the given first feature.
   *
   * @param feature1 name of first feature to set.
   */
  explicit CapsFeatures(const Glib::ustring& feature1);

  /**
   * Creates a new, ANY Gst::CapsFeatures. This will be equal to any other
   * Gst::CapsFeatures but caps with these are unfixed.
   */
  static CapsFeatures create_any();
  

  static CapsFeatures create_from_string(const Glib::ustring& features);
  

  /** Converts @a features to a human-readable string representation.
   * 
   * For debugging purposes its easier to do something like this:
   * 
   * [C example ellipted]
   * This prints the features in human readble form.
   * 
   * Free-function: g_free
   * 
   * @return A pointer to string allocated by Glib::malloc().
   * Glib::free() after usage.
   */
  Glib::ustring to_string() const;

  
  /** Sets the parent_refcount field of Gst::CapsFeatures. This field is used to
   * determine whether a caps features is mutable or not. This function should only be
   * called by code implementing parent objects of Gst::CapsFeatures, as described in
   * the MT Refcounting section of the design documents.
   * 
   * @param refcount A pointer to the parent's refcount.
   * @return <tt>true</tt> if the parent refcount could be set.
   */
  bool set_parent_refcount(gint * refcount);

  
  /** Check if @a features1 and @a features2 are equal.
   * 
   * @param features2 A Gst::CapsFeatures.
   * @return <tt>true</tt> if @a features1 and @a features2 are equal.
   */
  bool is_equal(const Gst::CapsFeatures& features2) const;

  
  /** Check if @a features is Gst::CAPS_FEATURES_ANY.
   * 
   * @return <tt>true</tt> if @a features is Gst::CAPS_FEATURES_ANY.
   */
  bool is_any() const;

  
  /** Check if @a features contains @a feature.
   * 
   * @param feature A feature.
   * @return <tt>true</tt> if @a features contains @a feature.
   */
  bool contains(const Glib::ustring& feature) const;

  
  /** Check if @a features contains @a feature.
   * 
   * @param feature A feature.
   * @return <tt>true</tt> if @a features contains @a feature.
   */
  bool contains(GQuark feature) const;

  
  /** Returns the number of features in @a features.
   * 
   * @return The number of features in @a features.
   */
  guint get_size() const;

  
  /** Returns the @a i-th feature of @a features.
   * 
   * @param i Index of the feature.
   * @return The @a i-th feature of @a features.
   */
  Glib::ustring get_nth(guint i) const;

  
  /** Returns the @a i-th feature of @a features.
   * 
   * @param i Index of the feature.
   * @return The @a i-th feature of @a features.
   */
  GQuark get_nth_id(guint i) const;

  
  /** Adds @a feature to @a features.
   * 
   * @param feature A feature.
   */
  void add(const Glib::ustring& feature);

  
  /** Adds @a feature to @a features.
   * 
   * @param feature A feature.
   */
  void add(GQuark feature);

  
  /** Removes @a feature from @a features.
   * 
   * @param feature A feature.
   */
  void remove(const Glib::ustring& feature);

  
  /** Removes @a feature from @a features.
   * 
   * @param feature A feature.
   */
  void remove(GQuark feature);


};

}


namespace Gst
{

/** @relates Gst::CapsFeatures
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(CapsFeatures& lhs, CapsFeatures& rhs)
  { lhs.swap(rhs); }

} // namespace Gst

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gst::CapsFeatures
 */
Gst::CapsFeatures wrap(GstCapsFeatures* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gst::CapsFeatures> : public Glib::Value_Boxed<Gst::CapsFeatures>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GSTREAMERMM_CAPSFEATURES_H */

