// StatusIcon.cs - customizations to Gtk.StatusIcon
//
// Authors: Mike Kestner  <mkestner@novell.com>
// Authors: Stephane Delcroix  <sdelcroix@novell.com>
//
// Copyright (c) 2007-2008 Novell, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the Lesser GNU General 
// Public License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program; if not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.

namespace Gtk {

	using System;
	using System.Runtime.InteropServices;

	public partial class StatusIcon {

		[Obsolete ("Replaced by (out Screen, out Rectangle, out Orientation) overload")]
		public bool GetGeometry (Gdk.Screen screen, Gdk.Rectangle area, out Orientation orientation) 
		{
			Gdk.Screen junk;
			return GetGeometry (out junk, out area, out orientation);
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void MenuPositionFuncNative (IntPtr menu, out int x, out int y, out bool push_in, IntPtr user_data);

		static MenuPositionFuncNative StatusIconPositionMenuFunc = null;

		[DllImport ("libgtk-win32-3.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_menu_popup (IntPtr menu,  IntPtr parent_menu_shell, IntPtr parent_menu_item, MenuPositionFuncNative func, IntPtr data, uint button, uint activate_time);

		public void PresentMenu (Menu menu, uint button, uint activate_time) 
		{
			if (StatusIconPositionMenuFunc == null)
				// gtk_status_icon_position_menu already defined by autogenerated code
				StatusIconPositionMenuFunc = new MenuPositionFuncNative (gtk_status_icon_position_menu);

			gtk_menu_popup (menu == null ? IntPtr.Zero : menu.Handle, IntPtr.Zero, IntPtr.Zero, StatusIconPositionMenuFunc, Handle, button, activate_time);
		}

		[Obsolete ("use the File property instead")]
		public string FromFile { 
			set {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				gtk_status_icon_set_from_file(Handle, native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[Obsolete ("use the IconName property instead")]
		public string FromIconName { 
			set {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				gtk_status_icon_set_from_icon_name(Handle, native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[Obsolete ("use the Pixbuf property instead")]
		public Gdk.Pixbuf FromPixbuf { 
			set {
				gtk_status_icon_set_from_pixbuf(Handle, value == null ? IntPtr.Zero : value.Handle);
			}
		}

		[Obsolete ("use the Stock property instead")]
		public string FromStock { 
			set {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				gtk_status_icon_set_from_stock(Handle, native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[DllImport("libgtk-win32-3.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_status_icon_get_geometry(IntPtr raw, out IntPtr screen, IntPtr area, out int orientation);

		public bool GetGeometry(out Gdk.Screen screen, out Gdk.Rectangle area, out Gtk.Orientation orientation)
		{
			IntPtr native_screen;
			IntPtr native_area = Marshal.AllocHGlobal (Marshal.SizeOf (typeof (Gdk.Rectangle)));
			int native_orientation;
			bool ret = gtk_status_icon_get_geometry(Handle, out native_screen, native_area, out native_orientation);
			if (ret) {
				screen = GLib.Object.GetObject(native_screen) as Gdk.Screen;
				area = Gdk.Rectangle.New (native_area);
				orientation = (Gtk.Orientation) native_orientation;
			} else {
				screen = null;
				area = Gdk.Rectangle.Zero;
				orientation = Gtk.Orientation.Horizontal;
			}
			Marshal.FreeHGlobal (native_area);
			return ret;
		}
	}
}
