/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class ImmutableSetTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testBuilderAddAll() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testBuilderAddAll();
}

public void testBuilderAddAllHandlesNullsCorrectly() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testBuilderAddAllHandlesNullsCorrectly();
}

public void testBuilderAddHandlesNullsCorrectly() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testBuilderAddHandlesNullsCorrectly();
}

public void testBuilderWithDuplicateElements() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testBuilderWithDuplicateElements();
}

public void testBuilderWithNonDuplicateElements() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testBuilderWithNonDuplicateElements();
}

public void testComplexBuilder() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testComplexBuilder();
}

public void testContainsAll_sameType() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testContainsAll_sameType();
}

public void testCopyOf_arrayContainingOnlyNull() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_arrayContainingOnlyNull();
}

public void testCopyOf_arrayOfOneElement() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_arrayOfOneElement();
}

public void testCopyOf_collectionContainingNull() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_collectionContainingNull();
}

public void testCopyOf_collection_empty() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_collection_empty();
}

public void testCopyOf_collection_enumSet() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_collection_enumSet();
}

public void testCopyOf_collection_general() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_collection_general();
}

public void testCopyOf_collection_oneElement() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_collection_oneElement();
}

public void testCopyOf_collection_oneElementRepeated() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_collection_oneElementRepeated();
}

public void testCopyOf_copiesImmutableSortedSet() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_copiesImmutableSortedSet();
}

public void testCopyOf_emptyArray() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_emptyArray();
}

public void testCopyOf_iteratorContainingNull() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_iteratorContainingNull();
}

public void testCopyOf_iterator_empty() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_iterator_empty();
}

public void testCopyOf_iterator_general() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_iterator_general();
}

public void testCopyOf_iterator_oneElement() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_iterator_oneElement();
}

public void testCopyOf_iterator_oneElementRepeated() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_iterator_oneElementRepeated();
}

public void testCopyOf_nullArray() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_nullArray();
}

public void testCopyOf_plainIterable() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_plainIterable();
}

public void testCopyOf_plainIterable_iteratesOnce() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_plainIterable_iteratesOnce();
}

public void testCopyOf_shortcut_empty() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_shortcut_empty();
}

public void testCopyOf_shortcut_sameType() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_shortcut_sameType();
}

public void testCopyOf_shortcut_singleton() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCopyOf_shortcut_singleton();
}

public void testCreation_allDuplicates() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCreation_allDuplicates();
}

public void testCreation_arrayOfArray() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCreation_arrayOfArray();
}

public void testCreation_eightElements() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCreation_eightElements();
}

public void testCreation_fiveElements() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCreation_fiveElements();
}

public void testCreation_fourElements() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCreation_fourElements();
}

public void testCreation_manyDuplicates() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCreation_manyDuplicates();
}

public void testCreation_noArgs() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCreation_noArgs();
}

public void testCreation_oneDuplicate() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCreation_oneDuplicate();
}

public void testCreation_oneElement() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCreation_oneElement();
}

public void testCreation_sevenElements() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCreation_sevenElements();
}

public void testCreation_sixElements() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCreation_sixElements();
}

public void testCreation_threeElements() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCreation_threeElements();
}

public void testCreation_twoElements() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testCreation_twoElements();
}

public void testEquals() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testEquals();
}

public void testEquals_sameType() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testEquals_sameType();
}

public void testReuseBuilderReducingHashTableSizeWithPowerOfTwoTotalElements() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testReuseBuilderReducingHashTableSizeWithPowerOfTwoTotalElements();
}

public void testReuseBuilderWithDuplicateElements() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testReuseBuilderWithDuplicateElements();
}

public void testReuseBuilderWithNonDuplicateElements() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testReuseBuilderWithNonDuplicateElements();
}

public void testToImmutableSet() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testToImmutableSet();
}

public void testToImmutableSet_duplicates() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testToImmutableSet_duplicates();
}

public void testToString() throws Exception {
  com.google.common.collect.ImmutableSetTest testCase = new com.google.common.collect.ImmutableSetTest();
  testCase.testToString();
}
}
