// !!! DO NOT EDIT !!! Generated by misc/mkhufftbl.c
/*
 * The MIT License
 *
 * Copyright (c) 2012, 2014, 2015, 2016 Tatsuhiro Tsujikawa
 * Copyright (c) 2012, 2014, 2015, 2016 nghttp2 contributors
 * Copyright (c) 2016 Fastly, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

typedef struct {
    uint32_t nbits;
    uint32_t code;
} nghttp2_huff_sym;

static const nghttp2_huff_sym huff_sym_table[] = {
    {13, 0x1ff8u},    {23, 0x7fffd8u},   {28, 0xfffffe2u}, {28, 0xfffffe3u},  {28, 0xfffffe4u}, {28, 0xfffffe5u}, {28, 0xfffffe6u},
    {28, 0xfffffe7u}, {28, 0xfffffe8u},  {24, 0xffffeau},  {30, 0x3ffffffcu}, {28, 0xfffffe9u}, {28, 0xfffffeau}, {30, 0x3ffffffdu},
    {28, 0xfffffebu}, {28, 0xfffffecu},  {28, 0xfffffedu}, {28, 0xfffffeeu},  {28, 0xfffffefu}, {28, 0xffffff0u}, {28, 0xffffff1u},
    {28, 0xffffff2u}, {30, 0x3ffffffeu}, {28, 0xffffff3u}, {28, 0xffffff4u},  {28, 0xffffff5u}, {28, 0xffffff6u}, {28, 0xffffff7u},
    {28, 0xffffff8u}, {28, 0xffffff9u},  {28, 0xffffffau}, {28, 0xffffffbu},  {6, 0x14u},       {10, 0x3f8u},     {10, 0x3f9u},
    {12, 0xffau},     {13, 0x1ff9u},     {6, 0x15u},       {8, 0xf8u},        {11, 0x7fau},     {10, 0x3fau},     {10, 0x3fbu},
    {8, 0xf9u},       {11, 0x7fbu},      {8, 0xfau},       {6, 0x16u},        {6, 0x17u},       {6, 0x18u},       {5, 0x0u},
    {5, 0x1u},        {5, 0x2u},         {6, 0x19u},       {6, 0x1au},        {6, 0x1bu},       {6, 0x1cu},       {6, 0x1du},
    {6, 0x1eu},       {6, 0x1fu},        {7, 0x5cu},       {8, 0xfbu},        {15, 0x7ffcu},    {6, 0x20u},       {12, 0xffbu},
    {10, 0x3fcu},     {13, 0x1ffau},     {6, 0x21u},       {7, 0x5du},        {7, 0x5eu},       {7, 0x5fu},       {7, 0x60u},
    {7, 0x61u},       {7, 0x62u},        {7, 0x63u},       {7, 0x64u},        {7, 0x65u},       {7, 0x66u},       {7, 0x67u},
    {7, 0x68u},       {7, 0x69u},        {7, 0x6au},       {7, 0x6bu},        {7, 0x6cu},       {7, 0x6du},       {7, 0x6eu},
    {7, 0x6fu},       {7, 0x70u},        {7, 0x71u},       {7, 0x72u},        {8, 0xfcu},       {7, 0x73u},       {8, 0xfdu},
    {13, 0x1ffbu},    {19, 0x7fff0u},    {13, 0x1ffcu},    {14, 0x3ffcu},     {6, 0x22u},       {15, 0x7ffdu},    {5, 0x3u},
    {6, 0x23u},       {5, 0x4u},         {6, 0x24u},       {5, 0x5u},         {6, 0x25u},       {6, 0x26u},       {6, 0x27u},
    {5, 0x6u},        {7, 0x74u},        {7, 0x75u},       {6, 0x28u},        {6, 0x29u},       {6, 0x2au},       {5, 0x7u},
    {6, 0x2bu},       {7, 0x76u},        {6, 0x2cu},       {5, 0x8u},         {5, 0x9u},        {6, 0x2du},       {7, 0x77u},
    {7, 0x78u},       {7, 0x79u},        {7, 0x7au},       {7, 0x7bu},        {15, 0x7ffeu},    {11, 0x7fcu},     {14, 0x3ffdu},
    {13, 0x1ffdu},    {28, 0xffffffcu},  {20, 0xfffe6u},   {22, 0x3fffd2u},   {20, 0xfffe7u},   {20, 0xfffe8u},   {22, 0x3fffd3u},
    {22, 0x3fffd4u},  {22, 0x3fffd5u},   {23, 0x7fffd9u},  {22, 0x3fffd6u},   {23, 0x7fffdau},  {23, 0x7fffdbu},  {23, 0x7fffdcu},
    {23, 0x7fffddu},  {23, 0x7fffdeu},   {24, 0xffffebu},  {23, 0x7fffdfu},   {24, 0xffffecu},  {24, 0xffffedu},  {22, 0x3fffd7u},
    {23, 0x7fffe0u},  {24, 0xffffeeu},   {23, 0x7fffe1u},  {23, 0x7fffe2u},   {23, 0x7fffe3u},  {23, 0x7fffe4u},  {21, 0x1fffdcu},
    {22, 0x3fffd8u},  {23, 0x7fffe5u},   {22, 0x3fffd9u},  {23, 0x7fffe6u},   {23, 0x7fffe7u},  {24, 0xffffefu},  {22, 0x3fffdau},
    {21, 0x1fffddu},  {20, 0xfffe9u},    {22, 0x3fffdbu},  {22, 0x3fffdcu},   {23, 0x7fffe8u},  {23, 0x7fffe9u},  {21, 0x1fffdeu},
    {23, 0x7fffeau},  {22, 0x3fffddu},   {22, 0x3fffdeu},  {24, 0xfffff0u},   {21, 0x1fffdfu},  {22, 0x3fffdfu},  {23, 0x7fffebu},
    {23, 0x7fffecu},  {21, 0x1fffe0u},   {21, 0x1fffe1u},  {22, 0x3fffe0u},   {21, 0x1fffe2u},  {23, 0x7fffedu},  {22, 0x3fffe1u},
    {23, 0x7fffeeu},  {23, 0x7fffefu},   {20, 0xfffeau},   {22, 0x3fffe2u},   {22, 0x3fffe3u},  {22, 0x3fffe4u},  {23, 0x7ffff0u},
    {22, 0x3fffe5u},  {22, 0x3fffe6u},   {23, 0x7ffff1u},  {26, 0x3ffffe0u},  {26, 0x3ffffe1u}, {20, 0xfffebu},   {19, 0x7fff1u},
    {22, 0x3fffe7u},  {23, 0x7ffff2u},   {22, 0x3fffe8u},  {25, 0x1ffffecu},  {26, 0x3ffffe2u}, {26, 0x3ffffe3u}, {26, 0x3ffffe4u},
    {27, 0x7ffffdeu}, {27, 0x7ffffdfu},  {26, 0x3ffffe5u}, {24, 0xfffff1u},   {25, 0x1ffffedu}, {19, 0x7fff2u},   {21, 0x1fffe3u},
    {26, 0x3ffffe6u}, {27, 0x7ffffe0u},  {27, 0x7ffffe1u}, {26, 0x3ffffe7u},  {27, 0x7ffffe2u}, {24, 0xfffff2u},  {21, 0x1fffe4u},
    {21, 0x1fffe5u},  {26, 0x3ffffe8u},  {26, 0x3ffffe9u}, {28, 0xffffffdu},  {27, 0x7ffffe3u}, {27, 0x7ffffe4u}, {27, 0x7ffffe5u},
    {20, 0xfffecu},   {24, 0xfffff3u},   {20, 0xfffedu},   {21, 0x1fffe6u},   {22, 0x3fffe9u},  {21, 0x1fffe7u},  {21, 0x1fffe8u},
    {23, 0x7ffff3u},  {22, 0x3fffeau},   {22, 0x3fffebu},  {25, 0x1ffffeeu},  {25, 0x1ffffefu}, {24, 0xfffff4u},  {24, 0xfffff5u},
    {26, 0x3ffffeau}, {23, 0x7ffff4u},   {26, 0x3ffffebu}, {27, 0x7ffffe6u},  {26, 0x3ffffecu}, {26, 0x3ffffedu}, {27, 0x7ffffe7u},
    {27, 0x7ffffe8u}, {27, 0x7ffffe9u},  {27, 0x7ffffeau}, {27, 0x7ffffebu},  {28, 0xffffffeu}, {27, 0x7ffffecu}, {27, 0x7ffffedu},
    {27, 0x7ffffeeu}, {27, 0x7ffffefu},  {27, 0x7fffff0u}, {26, 0x3ffffeeu},  {30, 0x3fffffffu}};

typedef enum {
    NGHTTP2_HUFF_ACCEPTED = 1,
    NGHTTP2_HUFF_SYM = 2,
    NGHTTP2_HUFF_FAIL = 4,
    NGHTTP2_HUFF_INVALID_FOR_HEADER_NAME = 8,
    NGHTTP2_HUFF_INVALID_FOR_HEADER_VALUE = 16,
    NGHTTP2_HUFF_UPPER_CASE_CHAR = 32,
#define NGHTTP2_HUFF_INVALID_CHARS (NGHTTP2_HUFF_INVALID_FOR_HEADER_NAME | NGHTTP2_HUFF_INVALID_FOR_HEADER_VALUE)
} nghttp2_huff_decode_flag;

typedef struct {
    uint8_t state;
    uint8_t flags;
    uint8_t sym;
} nghttp2_huff_decode;

static const nghttp2_huff_decode huff_decode_table[][16] = {
    /* 0 */
    {
        {4, 0x00, 0},
        {5, 0x00, 0},
        {7, 0x00, 0},
        {8, 0x00, 0},
        {11, 0x00, 0},
        {12, 0x00, 0},
        {16, 0x00, 0},
        {19, 0x00, 0},
        {25, 0x00, 0},
        {28, 0x00, 0},
        {32, 0x00, 0},
        {35, 0x00, 0},
        {42, 0x00, 0},
        {49, 0x00, 0},
        {57, 0x00, 0},
        {64, 0x01, 0},
    },
    /* 1 */
    {
        {0, 0x03, 48},
        {0, 0x03, 49},
        {0, 0x03, 50},
        {0, 0x03, 97},
        {0, 0x03, 99},
        {0, 0x03, 101},
        {0, 0x03, 105},
        {0, 0x03, 111},
        {0, 0x03, 115},
        {0, 0x03, 116},
        {13, 0x00, 0},
        {14, 0x00, 0},
        {17, 0x00, 0},
        {18, 0x00, 0},
        {20, 0x00, 0},
        {21, 0x00, 0},
    },
    /* 2 */
    {
        {1, 0x02, 48},
        {22, 0x03, 48},
        {1, 0x02, 49},
        {22, 0x03, 49},
        {1, 0x02, 50},
        {22, 0x03, 50},
        {1, 0x02, 97},
        {22, 0x03, 97},
        {1, 0x02, 99},
        {22, 0x03, 99},
        {1, 0x02, 101},
        {22, 0x03, 101},
        {1, 0x02, 105},
        {22, 0x03, 105},
        {1, 0x02, 111},
        {22, 0x03, 111},
    },
    /* 3 */
    {
        {2, 0x02, 48},
        {9, 0x02, 48},
        {23, 0x02, 48},
        {40, 0x03, 48},
        {2, 0x02, 49},
        {9, 0x02, 49},
        {23, 0x02, 49},
        {40, 0x03, 49},
        {2, 0x02, 50},
        {9, 0x02, 50},
        {23, 0x02, 50},
        {40, 0x03, 50},
        {2, 0x02, 97},
        {9, 0x02, 97},
        {23, 0x02, 97},
        {40, 0x03, 97},
    },
    /* 4 */
    {
        {3, 0x02, 48},
        {6, 0x02, 48},
        {10, 0x02, 48},
        {15, 0x02, 48},
        {24, 0x02, 48},
        {31, 0x02, 48},
        {41, 0x02, 48},
        {56, 0x03, 48},
        {3, 0x02, 49},
        {6, 0x02, 49},
        {10, 0x02, 49},
        {15, 0x02, 49},
        {24, 0x02, 49},
        {31, 0x02, 49},
        {41, 0x02, 49},
        {56, 0x03, 49},
    },
    /* 5 */
    {
        {3, 0x02, 50},
        {6, 0x02, 50},
        {10, 0x02, 50},
        {15, 0x02, 50},
        {24, 0x02, 50},
        {31, 0x02, 50},
        {41, 0x02, 50},
        {56, 0x03, 50},
        {3, 0x02, 97},
        {6, 0x02, 97},
        {10, 0x02, 97},
        {15, 0x02, 97},
        {24, 0x02, 97},
        {31, 0x02, 97},
        {41, 0x02, 97},
        {56, 0x03, 97},
    },
    /* 6 */
    {
        {2, 0x02, 99},
        {9, 0x02, 99},
        {23, 0x02, 99},
        {40, 0x03, 99},
        {2, 0x02, 101},
        {9, 0x02, 101},
        {23, 0x02, 101},
        {40, 0x03, 101},
        {2, 0x02, 105},
        {9, 0x02, 105},
        {23, 0x02, 105},
        {40, 0x03, 105},
        {2, 0x02, 111},
        {9, 0x02, 111},
        {23, 0x02, 111},
        {40, 0x03, 111},
    },
    /* 7 */
    {
        {3, 0x02, 99},
        {6, 0x02, 99},
        {10, 0x02, 99},
        {15, 0x02, 99},
        {24, 0x02, 99},
        {31, 0x02, 99},
        {41, 0x02, 99},
        {56, 0x03, 99},
        {3, 0x02, 101},
        {6, 0x02, 101},
        {10, 0x02, 101},
        {15, 0x02, 101},
        {24, 0x02, 101},
        {31, 0x02, 101},
        {41, 0x02, 101},
        {56, 0x03, 101},
    },
    /* 8 */
    {
        {3, 0x02, 105},
        {6, 0x02, 105},
        {10, 0x02, 105},
        {15, 0x02, 105},
        {24, 0x02, 105},
        {31, 0x02, 105},
        {41, 0x02, 105},
        {56, 0x03, 105},
        {3, 0x02, 111},
        {6, 0x02, 111},
        {10, 0x02, 111},
        {15, 0x02, 111},
        {24, 0x02, 111},
        {31, 0x02, 111},
        {41, 0x02, 111},
        {56, 0x03, 111},
    },
    /* 9 */
    {
        {1, 0x02, 115},
        {22, 0x03, 115},
        {1, 0x02, 116},
        {22, 0x03, 116},
        {0, 0x0b, 32},
        {0, 0x03, 37},
        {0, 0x03, 45},
        {0, 0x03, 46},
        {0, 0x0b, 47},
        {0, 0x03, 51},
        {0, 0x03, 52},
        {0, 0x03, 53},
        {0, 0x03, 54},
        {0, 0x03, 55},
        {0, 0x03, 56},
        {0, 0x03, 57},
    },
    /* 10 */
    {
        {2, 0x02, 115},
        {9, 0x02, 115},
        {23, 0x02, 115},
        {40, 0x03, 115},
        {2, 0x02, 116},
        {9, 0x02, 116},
        {23, 0x02, 116},
        {40, 0x03, 116},
        {1, 0x0a, 32},
        {22, 0x0b, 32},
        {1, 0x02, 37},
        {22, 0x03, 37},
        {1, 0x02, 45},
        {22, 0x03, 45},
        {1, 0x02, 46},
        {22, 0x03, 46},
    },
    /* 11 */
    {
        {3, 0x02, 115},
        {6, 0x02, 115},
        {10, 0x02, 115},
        {15, 0x02, 115},
        {24, 0x02, 115},
        {31, 0x02, 115},
        {41, 0x02, 115},
        {56, 0x03, 115},
        {3, 0x02, 116},
        {6, 0x02, 116},
        {10, 0x02, 116},
        {15, 0x02, 116},
        {24, 0x02, 116},
        {31, 0x02, 116},
        {41, 0x02, 116},
        {56, 0x03, 116},
    },
    /* 12 */
    {
        {2, 0x0a, 32},
        {9, 0x0a, 32},
        {23, 0x0a, 32},
        {40, 0x0b, 32},
        {2, 0x02, 37},
        {9, 0x02, 37},
        {23, 0x02, 37},
        {40, 0x03, 37},
        {2, 0x02, 45},
        {9, 0x02, 45},
        {23, 0x02, 45},
        {40, 0x03, 45},
        {2, 0x02, 46},
        {9, 0x02, 46},
        {23, 0x02, 46},
        {40, 0x03, 46},
    },
    /* 13 */
    {
        {3, 0x0a, 32},
        {6, 0x0a, 32},
        {10, 0x0a, 32},
        {15, 0x0a, 32},
        {24, 0x0a, 32},
        {31, 0x0a, 32},
        {41, 0x0a, 32},
        {56, 0x0b, 32},
        {3, 0x02, 37},
        {6, 0x02, 37},
        {10, 0x02, 37},
        {15, 0x02, 37},
        {24, 0x02, 37},
        {31, 0x02, 37},
        {41, 0x02, 37},
        {56, 0x03, 37},
    },
    /* 14 */
    {
        {3, 0x02, 45},
        {6, 0x02, 45},
        {10, 0x02, 45},
        {15, 0x02, 45},
        {24, 0x02, 45},
        {31, 0x02, 45},
        {41, 0x02, 45},
        {56, 0x03, 45},
        {3, 0x02, 46},
        {6, 0x02, 46},
        {10, 0x02, 46},
        {15, 0x02, 46},
        {24, 0x02, 46},
        {31, 0x02, 46},
        {41, 0x02, 46},
        {56, 0x03, 46},
    },
    /* 15 */
    {
        {1, 0x0a, 47},
        {22, 0x0b, 47},
        {1, 0x02, 51},
        {22, 0x03, 51},
        {1, 0x02, 52},
        {22, 0x03, 52},
        {1, 0x02, 53},
        {22, 0x03, 53},
        {1, 0x02, 54},
        {22, 0x03, 54},
        {1, 0x02, 55},
        {22, 0x03, 55},
        {1, 0x02, 56},
        {22, 0x03, 56},
        {1, 0x02, 57},
        {22, 0x03, 57},
    },
    /* 16 */
    {
        {2, 0x0a, 47},
        {9, 0x0a, 47},
        {23, 0x0a, 47},
        {40, 0x0b, 47},
        {2, 0x02, 51},
        {9, 0x02, 51},
        {23, 0x02, 51},
        {40, 0x03, 51},
        {2, 0x02, 52},
        {9, 0x02, 52},
        {23, 0x02, 52},
        {40, 0x03, 52},
        {2, 0x02, 53},
        {9, 0x02, 53},
        {23, 0x02, 53},
        {40, 0x03, 53},
    },
    /* 17 */
    {
        {3, 0x0a, 47},
        {6, 0x0a, 47},
        {10, 0x0a, 47},
        {15, 0x0a, 47},
        {24, 0x0a, 47},
        {31, 0x0a, 47},
        {41, 0x0a, 47},
        {56, 0x0b, 47},
        {3, 0x02, 51},
        {6, 0x02, 51},
        {10, 0x02, 51},
        {15, 0x02, 51},
        {24, 0x02, 51},
        {31, 0x02, 51},
        {41, 0x02, 51},
        {56, 0x03, 51},
    },
    /* 18 */
    {
        {3, 0x02, 52},
        {6, 0x02, 52},
        {10, 0x02, 52},
        {15, 0x02, 52},
        {24, 0x02, 52},
        {31, 0x02, 52},
        {41, 0x02, 52},
        {56, 0x03, 52},
        {3, 0x02, 53},
        {6, 0x02, 53},
        {10, 0x02, 53},
        {15, 0x02, 53},
        {24, 0x02, 53},
        {31, 0x02, 53},
        {41, 0x02, 53},
        {56, 0x03, 53},
    },
    /* 19 */
    {
        {2, 0x02, 54},
        {9, 0x02, 54},
        {23, 0x02, 54},
        {40, 0x03, 54},
        {2, 0x02, 55},
        {9, 0x02, 55},
        {23, 0x02, 55},
        {40, 0x03, 55},
        {2, 0x02, 56},
        {9, 0x02, 56},
        {23, 0x02, 56},
        {40, 0x03, 56},
        {2, 0x02, 57},
        {9, 0x02, 57},
        {23, 0x02, 57},
        {40, 0x03, 57},
    },
    /* 20 */
    {
        {3, 0x02, 54},
        {6, 0x02, 54},
        {10, 0x02, 54},
        {15, 0x02, 54},
        {24, 0x02, 54},
        {31, 0x02, 54},
        {41, 0x02, 54},
        {56, 0x03, 54},
        {3, 0x02, 55},
        {6, 0x02, 55},
        {10, 0x02, 55},
        {15, 0x02, 55},
        {24, 0x02, 55},
        {31, 0x02, 55},
        {41, 0x02, 55},
        {56, 0x03, 55},
    },
    /* 21 */
    {
        {3, 0x02, 56},
        {6, 0x02, 56},
        {10, 0x02, 56},
        {15, 0x02, 56},
        {24, 0x02, 56},
        {31, 0x02, 56},
        {41, 0x02, 56},
        {56, 0x03, 56},
        {3, 0x02, 57},
        {6, 0x02, 57},
        {10, 0x02, 57},
        {15, 0x02, 57},
        {24, 0x02, 57},
        {31, 0x02, 57},
        {41, 0x02, 57},
        {56, 0x03, 57},
    },
    /* 22 */
    {
        {26, 0x00, 0},
        {27, 0x00, 0},
        {29, 0x00, 0},
        {30, 0x00, 0},
        {33, 0x00, 0},
        {34, 0x00, 0},
        {36, 0x00, 0},
        {37, 0x00, 0},
        {43, 0x00, 0},
        {46, 0x00, 0},
        {50, 0x00, 0},
        {53, 0x00, 0},
        {58, 0x00, 0},
        {61, 0x00, 0},
        {65, 0x00, 0},
        {68, 0x01, 0},
    },
    /* 23 */
    {
        {0, 0x0b, 61},
        {0, 0x2b, 65},
        {0, 0x03, 95},
        {0, 0x03, 98},
        {0, 0x03, 100},
        {0, 0x03, 102},
        {0, 0x03, 103},
        {0, 0x03, 104},
        {0, 0x03, 108},
        {0, 0x03, 109},
        {0, 0x03, 110},
        {0, 0x03, 112},
        {0, 0x03, 114},
        {0, 0x03, 117},
        {38, 0x00, 0},
        {39, 0x00, 0},
    },
    /* 24 */
    {
        {1, 0x0a, 61},
        {22, 0x0b, 61},
        {1, 0x2a, 65},
        {22, 0x2b, 65},
        {1, 0x02, 95},
        {22, 0x03, 95},
        {1, 0x02, 98},
        {22, 0x03, 98},
        {1, 0x02, 100},
        {22, 0x03, 100},
        {1, 0x02, 102},
        {22, 0x03, 102},
        {1, 0x02, 103},
        {22, 0x03, 103},
        {1, 0x02, 104},
        {22, 0x03, 104},
    },
    /* 25 */
    {
        {2, 0x0a, 61},
        {9, 0x0a, 61},
        {23, 0x0a, 61},
        {40, 0x0b, 61},
        {2, 0x2a, 65},
        {9, 0x2a, 65},
        {23, 0x2a, 65},
        {40, 0x2b, 65},
        {2, 0x02, 95},
        {9, 0x02, 95},
        {23, 0x02, 95},
        {40, 0x03, 95},
        {2, 0x02, 98},
        {9, 0x02, 98},
        {23, 0x02, 98},
        {40, 0x03, 98},
    },
    /* 26 */
    {
        {3, 0x0a, 61},
        {6, 0x0a, 61},
        {10, 0x0a, 61},
        {15, 0x0a, 61},
        {24, 0x0a, 61},
        {31, 0x0a, 61},
        {41, 0x0a, 61},
        {56, 0x0b, 61},
        {3, 0x2a, 65},
        {6, 0x2a, 65},
        {10, 0x2a, 65},
        {15, 0x2a, 65},
        {24, 0x2a, 65},
        {31, 0x2a, 65},
        {41, 0x2a, 65},
        {56, 0x2b, 65},
    },
    /* 27 */
    {
        {3, 0x02, 95},
        {6, 0x02, 95},
        {10, 0x02, 95},
        {15, 0x02, 95},
        {24, 0x02, 95},
        {31, 0x02, 95},
        {41, 0x02, 95},
        {56, 0x03, 95},
        {3, 0x02, 98},
        {6, 0x02, 98},
        {10, 0x02, 98},
        {15, 0x02, 98},
        {24, 0x02, 98},
        {31, 0x02, 98},
        {41, 0x02, 98},
        {56, 0x03, 98},
    },
    /* 28 */
    {
        {2, 0x02, 100},
        {9, 0x02, 100},
        {23, 0x02, 100},
        {40, 0x03, 100},
        {2, 0x02, 102},
        {9, 0x02, 102},
        {23, 0x02, 102},
        {40, 0x03, 102},
        {2, 0x02, 103},
        {9, 0x02, 103},
        {23, 0x02, 103},
        {40, 0x03, 103},
        {2, 0x02, 104},
        {9, 0x02, 104},
        {23, 0x02, 104},
        {40, 0x03, 104},
    },
    /* 29 */
    {
        {3, 0x02, 100},
        {6, 0x02, 100},
        {10, 0x02, 100},
        {15, 0x02, 100},
        {24, 0x02, 100},
        {31, 0x02, 100},
        {41, 0x02, 100},
        {56, 0x03, 100},
        {3, 0x02, 102},
        {6, 0x02, 102},
        {10, 0x02, 102},
        {15, 0x02, 102},
        {24, 0x02, 102},
        {31, 0x02, 102},
        {41, 0x02, 102},
        {56, 0x03, 102},
    },
    /* 30 */
    {
        {3, 0x02, 103},
        {6, 0x02, 103},
        {10, 0x02, 103},
        {15, 0x02, 103},
        {24, 0x02, 103},
        {31, 0x02, 103},
        {41, 0x02, 103},
        {56, 0x03, 103},
        {3, 0x02, 104},
        {6, 0x02, 104},
        {10, 0x02, 104},
        {15, 0x02, 104},
        {24, 0x02, 104},
        {31, 0x02, 104},
        {41, 0x02, 104},
        {56, 0x03, 104},
    },
    /* 31 */
    {
        {1, 0x02, 108},
        {22, 0x03, 108},
        {1, 0x02, 109},
        {22, 0x03, 109},
        {1, 0x02, 110},
        {22, 0x03, 110},
        {1, 0x02, 112},
        {22, 0x03, 112},
        {1, 0x02, 114},
        {22, 0x03, 114},
        {1, 0x02, 117},
        {22, 0x03, 117},
        {0, 0x0b, 58},
        {0, 0x2b, 66},
        {0, 0x2b, 67},
        {0, 0x2b, 68},
    },
    /* 32 */
    {
        {2, 0x02, 108},
        {9, 0x02, 108},
        {23, 0x02, 108},
        {40, 0x03, 108},
        {2, 0x02, 109},
        {9, 0x02, 109},
        {23, 0x02, 109},
        {40, 0x03, 109},
        {2, 0x02, 110},
        {9, 0x02, 110},
        {23, 0x02, 110},
        {40, 0x03, 110},
        {2, 0x02, 112},
        {9, 0x02, 112},
        {23, 0x02, 112},
        {40, 0x03, 112},
    },
    /* 33 */
    {
        {3, 0x02, 108},
        {6, 0x02, 108},
        {10, 0x02, 108},
        {15, 0x02, 108},
        {24, 0x02, 108},
        {31, 0x02, 108},
        {41, 0x02, 108},
        {56, 0x03, 108},
        {3, 0x02, 109},
        {6, 0x02, 109},
        {10, 0x02, 109},
        {15, 0x02, 109},
        {24, 0x02, 109},
        {31, 0x02, 109},
        {41, 0x02, 109},
        {56, 0x03, 109},
    },
    /* 34 */
    {
        {3, 0x02, 110},
        {6, 0x02, 110},
        {10, 0x02, 110},
        {15, 0x02, 110},
        {24, 0x02, 110},
        {31, 0x02, 110},
        {41, 0x02, 110},
        {56, 0x03, 110},
        {3, 0x02, 112},
        {6, 0x02, 112},
        {10, 0x02, 112},
        {15, 0x02, 112},
        {24, 0x02, 112},
        {31, 0x02, 112},
        {41, 0x02, 112},
        {56, 0x03, 112},
    },
    /* 35 */
    {
        {2, 0x02, 114},
        {9, 0x02, 114},
        {23, 0x02, 114},
        {40, 0x03, 114},
        {2, 0x02, 117},
        {9, 0x02, 117},
        {23, 0x02, 117},
        {40, 0x03, 117},
        {1, 0x0a, 58},
        {22, 0x0b, 58},
        {1, 0x2a, 66},
        {22, 0x2b, 66},
        {1, 0x2a, 67},
        {22, 0x2b, 67},
        {1, 0x2a, 68},
        {22, 0x2b, 68},
    },
    /* 36 */
    {
        {3, 0x02, 114},
        {6, 0x02, 114},
        {10, 0x02, 114},
        {15, 0x02, 114},
        {24, 0x02, 114},
        {31, 0x02, 114},
        {41, 0x02, 114},
        {56, 0x03, 114},
        {3, 0x02, 117},
        {6, 0x02, 117},
        {10, 0x02, 117},
        {15, 0x02, 117},
        {24, 0x02, 117},
        {31, 0x02, 117},
        {41, 0x02, 117},
        {56, 0x03, 117},
    },
    /* 37 */
    {
        {2, 0x0a, 58},
        {9, 0x0a, 58},
        {23, 0x0a, 58},
        {40, 0x0b, 58},
        {2, 0x2a, 66},
        {9, 0x2a, 66},
        {23, 0x2a, 66},
        {40, 0x2b, 66},
        {2, 0x2a, 67},
        {9, 0x2a, 67},
        {23, 0x2a, 67},
        {40, 0x2b, 67},
        {2, 0x2a, 68},
        {9, 0x2a, 68},
        {23, 0x2a, 68},
        {40, 0x2b, 68},
    },
    /* 38 */
    {
        {3, 0x0a, 58},
        {6, 0x0a, 58},
        {10, 0x0a, 58},
        {15, 0x0a, 58},
        {24, 0x0a, 58},
        {31, 0x0a, 58},
        {41, 0x0a, 58},
        {56, 0x0b, 58},
        {3, 0x2a, 66},
        {6, 0x2a, 66},
        {10, 0x2a, 66},
        {15, 0x2a, 66},
        {24, 0x2a, 66},
        {31, 0x2a, 66},
        {41, 0x2a, 66},
        {56, 0x2b, 66},
    },
    /* 39 */
    {
        {3, 0x2a, 67},
        {6, 0x2a, 67},
        {10, 0x2a, 67},
        {15, 0x2a, 67},
        {24, 0x2a, 67},
        {31, 0x2a, 67},
        {41, 0x2a, 67},
        {56, 0x2b, 67},
        {3, 0x2a, 68},
        {6, 0x2a, 68},
        {10, 0x2a, 68},
        {15, 0x2a, 68},
        {24, 0x2a, 68},
        {31, 0x2a, 68},
        {41, 0x2a, 68},
        {56, 0x2b, 68},
    },
    /* 40 */
    {
        {44, 0x00, 0},
        {45, 0x00, 0},
        {47, 0x00, 0},
        {48, 0x00, 0},
        {51, 0x00, 0},
        {52, 0x00, 0},
        {54, 0x00, 0},
        {55, 0x00, 0},
        {59, 0x00, 0},
        {60, 0x00, 0},
        {62, 0x00, 0},
        {63, 0x00, 0},
        {66, 0x00, 0},
        {67, 0x00, 0},
        {69, 0x00, 0},
        {72, 0x01, 0},
    },
    /* 41 */
    {
        {0, 0x2b, 69},
        {0, 0x2b, 70},
        {0, 0x2b, 71},
        {0, 0x2b, 72},
        {0, 0x2b, 73},
        {0, 0x2b, 74},
        {0, 0x2b, 75},
        {0, 0x2b, 76},
        {0, 0x2b, 77},
        {0, 0x2b, 78},
        {0, 0x2b, 79},
        {0, 0x2b, 80},
        {0, 0x2b, 81},
        {0, 0x2b, 82},
        {0, 0x2b, 83},
        {0, 0x2b, 84},
    },
    /* 42 */
    {
        {1, 0x2a, 69},
        {22, 0x2b, 69},
        {1, 0x2a, 70},
        {22, 0x2b, 70},
        {1, 0x2a, 71},
        {22, 0x2b, 71},
        {1, 0x2a, 72},
        {22, 0x2b, 72},
        {1, 0x2a, 73},
        {22, 0x2b, 73},
        {1, 0x2a, 74},
        {22, 0x2b, 74},
        {1, 0x2a, 75},
        {22, 0x2b, 75},
        {1, 0x2a, 76},
        {22, 0x2b, 76},
    },
    /* 43 */
    {
        {2, 0x2a, 69},
        {9, 0x2a, 69},
        {23, 0x2a, 69},
        {40, 0x2b, 69},
        {2, 0x2a, 70},
        {9, 0x2a, 70},
        {23, 0x2a, 70},
        {40, 0x2b, 70},
        {2, 0x2a, 71},
        {9, 0x2a, 71},
        {23, 0x2a, 71},
        {40, 0x2b, 71},
        {2, 0x2a, 72},
        {9, 0x2a, 72},
        {23, 0x2a, 72},
        {40, 0x2b, 72},
    },
    /* 44 */
    {
        {3, 0x2a, 69},
        {6, 0x2a, 69},
        {10, 0x2a, 69},
        {15, 0x2a, 69},
        {24, 0x2a, 69},
        {31, 0x2a, 69},
        {41, 0x2a, 69},
        {56, 0x2b, 69},
        {3, 0x2a, 70},
        {6, 0x2a, 70},
        {10, 0x2a, 70},
        {15, 0x2a, 70},
        {24, 0x2a, 70},
        {31, 0x2a, 70},
        {41, 0x2a, 70},
        {56, 0x2b, 70},
    },
    /* 45 */
    {
        {3, 0x2a, 71},
        {6, 0x2a, 71},
        {10, 0x2a, 71},
        {15, 0x2a, 71},
        {24, 0x2a, 71},
        {31, 0x2a, 71},
        {41, 0x2a, 71},
        {56, 0x2b, 71},
        {3, 0x2a, 72},
        {6, 0x2a, 72},
        {10, 0x2a, 72},
        {15, 0x2a, 72},
        {24, 0x2a, 72},
        {31, 0x2a, 72},
        {41, 0x2a, 72},
        {56, 0x2b, 72},
    },
    /* 46 */
    {
        {2, 0x2a, 73},
        {9, 0x2a, 73},
        {23, 0x2a, 73},
        {40, 0x2b, 73},
        {2, 0x2a, 74},
        {9, 0x2a, 74},
        {23, 0x2a, 74},
        {40, 0x2b, 74},
        {2, 0x2a, 75},
        {9, 0x2a, 75},
        {23, 0x2a, 75},
        {40, 0x2b, 75},
        {2, 0x2a, 76},
        {9, 0x2a, 76},
        {23, 0x2a, 76},
        {40, 0x2b, 76},
    },
    /* 47 */
    {
        {3, 0x2a, 73},
        {6, 0x2a, 73},
        {10, 0x2a, 73},
        {15, 0x2a, 73},
        {24, 0x2a, 73},
        {31, 0x2a, 73},
        {41, 0x2a, 73},
        {56, 0x2b, 73},
        {3, 0x2a, 74},
        {6, 0x2a, 74},
        {10, 0x2a, 74},
        {15, 0x2a, 74},
        {24, 0x2a, 74},
        {31, 0x2a, 74},
        {41, 0x2a, 74},
        {56, 0x2b, 74},
    },
    /* 48 */
    {
        {3, 0x2a, 75},
        {6, 0x2a, 75},
        {10, 0x2a, 75},
        {15, 0x2a, 75},
        {24, 0x2a, 75},
        {31, 0x2a, 75},
        {41, 0x2a, 75},
        {56, 0x2b, 75},
        {3, 0x2a, 76},
        {6, 0x2a, 76},
        {10, 0x2a, 76},
        {15, 0x2a, 76},
        {24, 0x2a, 76},
        {31, 0x2a, 76},
        {41, 0x2a, 76},
        {56, 0x2b, 76},
    },
    /* 49 */
    {
        {1, 0x2a, 77},
        {22, 0x2b, 77},
        {1, 0x2a, 78},
        {22, 0x2b, 78},
        {1, 0x2a, 79},
        {22, 0x2b, 79},
        {1, 0x2a, 80},
        {22, 0x2b, 80},
        {1, 0x2a, 81},
        {22, 0x2b, 81},
        {1, 0x2a, 82},
        {22, 0x2b, 82},
        {1, 0x2a, 83},
        {22, 0x2b, 83},
        {1, 0x2a, 84},
        {22, 0x2b, 84},
    },
    /* 50 */
    {
        {2, 0x2a, 77},
        {9, 0x2a, 77},
        {23, 0x2a, 77},
        {40, 0x2b, 77},
        {2, 0x2a, 78},
        {9, 0x2a, 78},
        {23, 0x2a, 78},
        {40, 0x2b, 78},
        {2, 0x2a, 79},
        {9, 0x2a, 79},
        {23, 0x2a, 79},
        {40, 0x2b, 79},
        {2, 0x2a, 80},
        {9, 0x2a, 80},
        {23, 0x2a, 80},
        {40, 0x2b, 80},
    },
    /* 51 */
    {
        {3, 0x2a, 77},
        {6, 0x2a, 77},
        {10, 0x2a, 77},
        {15, 0x2a, 77},
        {24, 0x2a, 77},
        {31, 0x2a, 77},
        {41, 0x2a, 77},
        {56, 0x2b, 77},
        {3, 0x2a, 78},
        {6, 0x2a, 78},
        {10, 0x2a, 78},
        {15, 0x2a, 78},
        {24, 0x2a, 78},
        {31, 0x2a, 78},
        {41, 0x2a, 78},
        {56, 0x2b, 78},
    },
    /* 52 */
    {
        {3, 0x2a, 79},
        {6, 0x2a, 79},
        {10, 0x2a, 79},
        {15, 0x2a, 79},
        {24, 0x2a, 79},
        {31, 0x2a, 79},
        {41, 0x2a, 79},
        {56, 0x2b, 79},
        {3, 0x2a, 80},
        {6, 0x2a, 80},
        {10, 0x2a, 80},
        {15, 0x2a, 80},
        {24, 0x2a, 80},
        {31, 0x2a, 80},
        {41, 0x2a, 80},
        {56, 0x2b, 80},
    },
    /* 53 */
    {
        {2, 0x2a, 81},
        {9, 0x2a, 81},
        {23, 0x2a, 81},
        {40, 0x2b, 81},
        {2, 0x2a, 82},
        {9, 0x2a, 82},
        {23, 0x2a, 82},
        {40, 0x2b, 82},
        {2, 0x2a, 83},
        {9, 0x2a, 83},
        {23, 0x2a, 83},
        {40, 0x2b, 83},
        {2, 0x2a, 84},
        {9, 0x2a, 84},
        {23, 0x2a, 84},
        {40, 0x2b, 84},
    },
    /* 54 */
    {
        {3, 0x2a, 81},
        {6, 0x2a, 81},
        {10, 0x2a, 81},
        {15, 0x2a, 81},
        {24, 0x2a, 81},
        {31, 0x2a, 81},
        {41, 0x2a, 81},
        {56, 0x2b, 81},
        {3, 0x2a, 82},
        {6, 0x2a, 82},
        {10, 0x2a, 82},
        {15, 0x2a, 82},
        {24, 0x2a, 82},
        {31, 0x2a, 82},
        {41, 0x2a, 82},
        {56, 0x2b, 82},
    },
    /* 55 */
    {
        {3, 0x2a, 83},
        {6, 0x2a, 83},
        {10, 0x2a, 83},
        {15, 0x2a, 83},
        {24, 0x2a, 83},
        {31, 0x2a, 83},
        {41, 0x2a, 83},
        {56, 0x2b, 83},
        {3, 0x2a, 84},
        {6, 0x2a, 84},
        {10, 0x2a, 84},
        {15, 0x2a, 84},
        {24, 0x2a, 84},
        {31, 0x2a, 84},
        {41, 0x2a, 84},
        {56, 0x2b, 84},
    },
    /* 56 */
    {
        {0, 0x2b, 85},
        {0, 0x2b, 86},
        {0, 0x2b, 87},
        {0, 0x2b, 89},
        {0, 0x03, 106},
        {0, 0x03, 107},
        {0, 0x03, 113},
        {0, 0x03, 118},
        {0, 0x03, 119},
        {0, 0x03, 120},
        {0, 0x03, 121},
        {0, 0x03, 122},
        {70, 0x00, 0},
        {71, 0x00, 0},
        {73, 0x00, 0},
        {74, 0x01, 0},
    },
    /* 57 */
    {
        {1, 0x2a, 85},
        {22, 0x2b, 85},
        {1, 0x2a, 86},
        {22, 0x2b, 86},
        {1, 0x2a, 87},
        {22, 0x2b, 87},
        {1, 0x2a, 89},
        {22, 0x2b, 89},
        {1, 0x02, 106},
        {22, 0x03, 106},
        {1, 0x02, 107},
        {22, 0x03, 107},
        {1, 0x02, 113},
        {22, 0x03, 113},
        {1, 0x02, 118},
        {22, 0x03, 118},
    },
    /* 58 */
    {
        {2, 0x2a, 85},
        {9, 0x2a, 85},
        {23, 0x2a, 85},
        {40, 0x2b, 85},
        {2, 0x2a, 86},
        {9, 0x2a, 86},
        {23, 0x2a, 86},
        {40, 0x2b, 86},
        {2, 0x2a, 87},
        {9, 0x2a, 87},
        {23, 0x2a, 87},
        {40, 0x2b, 87},
        {2, 0x2a, 89},
        {9, 0x2a, 89},
        {23, 0x2a, 89},
        {40, 0x2b, 89},
    },
    /* 59 */
    {
        {3, 0x2a, 85},
        {6, 0x2a, 85},
        {10, 0x2a, 85},
        {15, 0x2a, 85},
        {24, 0x2a, 85},
        {31, 0x2a, 85},
        {41, 0x2a, 85},
        {56, 0x2b, 85},
        {3, 0x2a, 86},
        {6, 0x2a, 86},
        {10, 0x2a, 86},
        {15, 0x2a, 86},
        {24, 0x2a, 86},
        {31, 0x2a, 86},
        {41, 0x2a, 86},
        {56, 0x2b, 86},
    },
    /* 60 */
    {
        {3, 0x2a, 87},
        {6, 0x2a, 87},
        {10, 0x2a, 87},
        {15, 0x2a, 87},
        {24, 0x2a, 87},
        {31, 0x2a, 87},
        {41, 0x2a, 87},
        {56, 0x2b, 87},
        {3, 0x2a, 89},
        {6, 0x2a, 89},
        {10, 0x2a, 89},
        {15, 0x2a, 89},
        {24, 0x2a, 89},
        {31, 0x2a, 89},
        {41, 0x2a, 89},
        {56, 0x2b, 89},
    },
    /* 61 */
    {
        {2, 0x02, 106},
        {9, 0x02, 106},
        {23, 0x02, 106},
        {40, 0x03, 106},
        {2, 0x02, 107},
        {9, 0x02, 107},
        {23, 0x02, 107},
        {40, 0x03, 107},
        {2, 0x02, 113},
        {9, 0x02, 113},
        {23, 0x02, 113},
        {40, 0x03, 113},
        {2, 0x02, 118},
        {9, 0x02, 118},
        {23, 0x02, 118},
        {40, 0x03, 118},
    },
    /* 62 */
    {
        {3, 0x02, 106},
        {6, 0x02, 106},
        {10, 0x02, 106},
        {15, 0x02, 106},
        {24, 0x02, 106},
        {31, 0x02, 106},
        {41, 0x02, 106},
        {56, 0x03, 106},
        {3, 0x02, 107},
        {6, 0x02, 107},
        {10, 0x02, 107},
        {15, 0x02, 107},
        {24, 0x02, 107},
        {31, 0x02, 107},
        {41, 0x02, 107},
        {56, 0x03, 107},
    },
    /* 63 */
    {
        {3, 0x02, 113},
        {6, 0x02, 113},
        {10, 0x02, 113},
        {15, 0x02, 113},
        {24, 0x02, 113},
        {31, 0x02, 113},
        {41, 0x02, 113},
        {56, 0x03, 113},
        {3, 0x02, 118},
        {6, 0x02, 118},
        {10, 0x02, 118},
        {15, 0x02, 118},
        {24, 0x02, 118},
        {31, 0x02, 118},
        {41, 0x02, 118},
        {56, 0x03, 118},
    },
    /* 64 */
    {
        {1, 0x02, 119},
        {22, 0x03, 119},
        {1, 0x02, 120},
        {22, 0x03, 120},
        {1, 0x02, 121},
        {22, 0x03, 121},
        {1, 0x02, 122},
        {22, 0x03, 122},
        {0, 0x03, 38},
        {0, 0x03, 42},
        {0, 0x0b, 44},
        {0, 0x0b, 59},
        {0, 0x2b, 88},
        {0, 0x2b, 90},
        {75, 0x00, 0},
        {78, 0x00, 0},
    },
    /* 65 */
    {
        {2, 0x02, 119},
        {9, 0x02, 119},
        {23, 0x02, 119},
        {40, 0x03, 119},
        {2, 0x02, 120},
        {9, 0x02, 120},
        {23, 0x02, 120},
        {40, 0x03, 120},
        {2, 0x02, 121},
        {9, 0x02, 121},
        {23, 0x02, 121},
        {40, 0x03, 121},
        {2, 0x02, 122},
        {9, 0x02, 122},
        {23, 0x02, 122},
        {40, 0x03, 122},
    },
    /* 66 */
    {
        {3, 0x02, 119},
        {6, 0x02, 119},
        {10, 0x02, 119},
        {15, 0x02, 119},
        {24, 0x02, 119},
        {31, 0x02, 119},
        {41, 0x02, 119},
        {56, 0x03, 119},
        {3, 0x02, 120},
        {6, 0x02, 120},
        {10, 0x02, 120},
        {15, 0x02, 120},
        {24, 0x02, 120},
        {31, 0x02, 120},
        {41, 0x02, 120},
        {56, 0x03, 120},
    },
    /* 67 */
    {
        {3, 0x02, 121},
        {6, 0x02, 121},
        {10, 0x02, 121},
        {15, 0x02, 121},
        {24, 0x02, 121},
        {31, 0x02, 121},
        {41, 0x02, 121},
        {56, 0x03, 121},
        {3, 0x02, 122},
        {6, 0x02, 122},
        {10, 0x02, 122},
        {15, 0x02, 122},
        {24, 0x02, 122},
        {31, 0x02, 122},
        {41, 0x02, 122},
        {56, 0x03, 122},
    },
    /* 68 */
    {
        {1, 0x02, 38},
        {22, 0x03, 38},
        {1, 0x02, 42},
        {22, 0x03, 42},
        {1, 0x0a, 44},
        {22, 0x0b, 44},
        {1, 0x0a, 59},
        {22, 0x0b, 59},
        {1, 0x2a, 88},
        {22, 0x2b, 88},
        {1, 0x2a, 90},
        {22, 0x2b, 90},
        {76, 0x00, 0},
        {77, 0x00, 0},
        {79, 0x00, 0},
        {81, 0x00, 0},
    },
    /* 69 */
    {
        {2, 0x02, 38},
        {9, 0x02, 38},
        {23, 0x02, 38},
        {40, 0x03, 38},
        {2, 0x02, 42},
        {9, 0x02, 42},
        {23, 0x02, 42},
        {40, 0x03, 42},
        {2, 0x0a, 44},
        {9, 0x0a, 44},
        {23, 0x0a, 44},
        {40, 0x0b, 44},
        {2, 0x0a, 59},
        {9, 0x0a, 59},
        {23, 0x0a, 59},
        {40, 0x0b, 59},
    },
    /* 70 */
    {
        {3, 0x02, 38},
        {6, 0x02, 38},
        {10, 0x02, 38},
        {15, 0x02, 38},
        {24, 0x02, 38},
        {31, 0x02, 38},
        {41, 0x02, 38},
        {56, 0x03, 38},
        {3, 0x02, 42},
        {6, 0x02, 42},
        {10, 0x02, 42},
        {15, 0x02, 42},
        {24, 0x02, 42},
        {31, 0x02, 42},
        {41, 0x02, 42},
        {56, 0x03, 42},
    },
    /* 71 */
    {
        {3, 0x0a, 44},
        {6, 0x0a, 44},
        {10, 0x0a, 44},
        {15, 0x0a, 44},
        {24, 0x0a, 44},
        {31, 0x0a, 44},
        {41, 0x0a, 44},
        {56, 0x0b, 44},
        {3, 0x0a, 59},
        {6, 0x0a, 59},
        {10, 0x0a, 59},
        {15, 0x0a, 59},
        {24, 0x0a, 59},
        {31, 0x0a, 59},
        {41, 0x0a, 59},
        {56, 0x0b, 59},
    },
    /* 72 */
    {
        {2, 0x2a, 88},
        {9, 0x2a, 88},
        {23, 0x2a, 88},
        {40, 0x2b, 88},
        {2, 0x2a, 90},
        {9, 0x2a, 90},
        {23, 0x2a, 90},
        {40, 0x2b, 90},
        {0, 0x03, 33},
        {0, 0x0b, 34},
        {0, 0x0b, 40},
        {0, 0x0b, 41},
        {0, 0x0b, 63},
        {80, 0x00, 0},
        {82, 0x00, 0},
        {84, 0x00, 0},
    },
    /* 73 */
    {
        {3, 0x2a, 88},
        {6, 0x2a, 88},
        {10, 0x2a, 88},
        {15, 0x2a, 88},
        {24, 0x2a, 88},
        {31, 0x2a, 88},
        {41, 0x2a, 88},
        {56, 0x2b, 88},
        {3, 0x2a, 90},
        {6, 0x2a, 90},
        {10, 0x2a, 90},
        {15, 0x2a, 90},
        {24, 0x2a, 90},
        {31, 0x2a, 90},
        {41, 0x2a, 90},
        {56, 0x2b, 90},
    },
    /* 74 */
    {
        {1, 0x02, 33},
        {22, 0x03, 33},
        {1, 0x0a, 34},
        {22, 0x0b, 34},
        {1, 0x0a, 40},
        {22, 0x0b, 40},
        {1, 0x0a, 41},
        {22, 0x0b, 41},
        {1, 0x0a, 63},
        {22, 0x0b, 63},
        {0, 0x03, 39},
        {0, 0x03, 43},
        {0, 0x03, 124},
        {83, 0x00, 0},
        {85, 0x00, 0},
        {88, 0x00, 0},
    },
    /* 75 */
    {
        {2, 0x02, 33},
        {9, 0x02, 33},
        {23, 0x02, 33},
        {40, 0x03, 33},
        {2, 0x0a, 34},
        {9, 0x0a, 34},
        {23, 0x0a, 34},
        {40, 0x0b, 34},
        {2, 0x0a, 40},
        {9, 0x0a, 40},
        {23, 0x0a, 40},
        {40, 0x0b, 40},
        {2, 0x0a, 41},
        {9, 0x0a, 41},
        {23, 0x0a, 41},
        {40, 0x0b, 41},
    },
    /* 76 */
    {
        {3, 0x02, 33},
        {6, 0x02, 33},
        {10, 0x02, 33},
        {15, 0x02, 33},
        {24, 0x02, 33},
        {31, 0x02, 33},
        {41, 0x02, 33},
        {56, 0x03, 33},
        {3, 0x0a, 34},
        {6, 0x0a, 34},
        {10, 0x0a, 34},
        {15, 0x0a, 34},
        {24, 0x0a, 34},
        {31, 0x0a, 34},
        {41, 0x0a, 34},
        {56, 0x0b, 34},
    },
    /* 77 */
    {
        {3, 0x0a, 40},
        {6, 0x0a, 40},
        {10, 0x0a, 40},
        {15, 0x0a, 40},
        {24, 0x0a, 40},
        {31, 0x0a, 40},
        {41, 0x0a, 40},
        {56, 0x0b, 40},
        {3, 0x0a, 41},
        {6, 0x0a, 41},
        {10, 0x0a, 41},
        {15, 0x0a, 41},
        {24, 0x0a, 41},
        {31, 0x0a, 41},
        {41, 0x0a, 41},
        {56, 0x0b, 41},
    },
    /* 78 */
    {
        {2, 0x0a, 63},
        {9, 0x0a, 63},
        {23, 0x0a, 63},
        {40, 0x0b, 63},
        {1, 0x02, 39},
        {22, 0x03, 39},
        {1, 0x02, 43},
        {22, 0x03, 43},
        {1, 0x02, 124},
        {22, 0x03, 124},
        {0, 0x03, 35},
        {0, 0x0b, 62},
        {86, 0x00, 0},
        {87, 0x00, 0},
        {89, 0x00, 0},
        {90, 0x00, 0},
    },
    /* 79 */
    {
        {3, 0x0a, 63},
        {6, 0x0a, 63},
        {10, 0x0a, 63},
        {15, 0x0a, 63},
        {24, 0x0a, 63},
        {31, 0x0a, 63},
        {41, 0x0a, 63},
        {56, 0x0b, 63},
        {2, 0x02, 39},
        {9, 0x02, 39},
        {23, 0x02, 39},
        {40, 0x03, 39},
        {2, 0x02, 43},
        {9, 0x02, 43},
        {23, 0x02, 43},
        {40, 0x03, 43},
    },
    /* 80 */
    {
        {3, 0x02, 39},
        {6, 0x02, 39},
        {10, 0x02, 39},
        {15, 0x02, 39},
        {24, 0x02, 39},
        {31, 0x02, 39},
        {41, 0x02, 39},
        {56, 0x03, 39},
        {3, 0x02, 43},
        {6, 0x02, 43},
        {10, 0x02, 43},
        {15, 0x02, 43},
        {24, 0x02, 43},
        {31, 0x02, 43},
        {41, 0x02, 43},
        {56, 0x03, 43},
    },
    /* 81 */
    {
        {2, 0x02, 124},
        {9, 0x02, 124},
        {23, 0x02, 124},
        {40, 0x03, 124},
        {1, 0x02, 35},
        {22, 0x03, 35},
        {1, 0x0a, 62},
        {22, 0x0b, 62},
        {0, 0x1b, 0},
        {0, 0x03, 36},
        {0, 0x0b, 64},
        {0, 0x0b, 91},
        {0, 0x0b, 93},
        {0, 0x03, 126},
        {91, 0x00, 0},
        {92, 0x00, 0},
    },
    /* 82 */
    {
        {3, 0x02, 124},
        {6, 0x02, 124},
        {10, 0x02, 124},
        {15, 0x02, 124},
        {24, 0x02, 124},
        {31, 0x02, 124},
        {41, 0x02, 124},
        {56, 0x03, 124},
        {2, 0x02, 35},
        {9, 0x02, 35},
        {23, 0x02, 35},
        {40, 0x03, 35},
        {2, 0x0a, 62},
        {9, 0x0a, 62},
        {23, 0x0a, 62},
        {40, 0x0b, 62},
    },
    /* 83 */
    {
        {3, 0x02, 35},
        {6, 0x02, 35},
        {10, 0x02, 35},
        {15, 0x02, 35},
        {24, 0x02, 35},
        {31, 0x02, 35},
        {41, 0x02, 35},
        {56, 0x03, 35},
        {3, 0x0a, 62},
        {6, 0x0a, 62},
        {10, 0x0a, 62},
        {15, 0x0a, 62},
        {24, 0x0a, 62},
        {31, 0x0a, 62},
        {41, 0x0a, 62},
        {56, 0x0b, 62},
    },
    /* 84 */
    {
        {1, 0x1a, 0},
        {22, 0x1b, 0},
        {1, 0x02, 36},
        {22, 0x03, 36},
        {1, 0x0a, 64},
        {22, 0x0b, 64},
        {1, 0x0a, 91},
        {22, 0x0b, 91},
        {1, 0x0a, 93},
        {22, 0x0b, 93},
        {1, 0x02, 126},
        {22, 0x03, 126},
        {0, 0x03, 94},
        {0, 0x0b, 125},
        {93, 0x00, 0},
        {94, 0x00, 0},
    },
    /* 85 */
    {
        {2, 0x1a, 0},
        {9, 0x1a, 0},
        {23, 0x1a, 0},
        {40, 0x1b, 0},
        {2, 0x02, 36},
        {9, 0x02, 36},
        {23, 0x02, 36},
        {40, 0x03, 36},
        {2, 0x0a, 64},
        {9, 0x0a, 64},
        {23, 0x0a, 64},
        {40, 0x0b, 64},
        {2, 0x0a, 91},
        {9, 0x0a, 91},
        {23, 0x0a, 91},
        {40, 0x0b, 91},
    },
    /* 86 */
    {
        {3, 0x1a, 0},
        {6, 0x1a, 0},
        {10, 0x1a, 0},
        {15, 0x1a, 0},
        {24, 0x1a, 0},
        {31, 0x1a, 0},
        {41, 0x1a, 0},
        {56, 0x1b, 0},
        {3, 0x02, 36},
        {6, 0x02, 36},
        {10, 0x02, 36},
        {15, 0x02, 36},
        {24, 0x02, 36},
        {31, 0x02, 36},
        {41, 0x02, 36},
        {56, 0x03, 36},
    },
    /* 87 */
    {
        {3, 0x0a, 64},
        {6, 0x0a, 64},
        {10, 0x0a, 64},
        {15, 0x0a, 64},
        {24, 0x0a, 64},
        {31, 0x0a, 64},
        {41, 0x0a, 64},
        {56, 0x0b, 64},
        {3, 0x0a, 91},
        {6, 0x0a, 91},
        {10, 0x0a, 91},
        {15, 0x0a, 91},
        {24, 0x0a, 91},
        {31, 0x0a, 91},
        {41, 0x0a, 91},
        {56, 0x0b, 91},
    },
    /* 88 */
    {
        {2, 0x0a, 93},
        {9, 0x0a, 93},
        {23, 0x0a, 93},
        {40, 0x0b, 93},
        {2, 0x02, 126},
        {9, 0x02, 126},
        {23, 0x02, 126},
        {40, 0x03, 126},
        {1, 0x02, 94},
        {22, 0x03, 94},
        {1, 0x0a, 125},
        {22, 0x0b, 125},
        {0, 0x0b, 60},
        {0, 0x03, 96},
        {0, 0x0b, 123},
        {95, 0x00, 0},
    },
    /* 89 */
    {
        {3, 0x0a, 93},
        {6, 0x0a, 93},
        {10, 0x0a, 93},
        {15, 0x0a, 93},
        {24, 0x0a, 93},
        {31, 0x0a, 93},
        {41, 0x0a, 93},
        {56, 0x0b, 93},
        {3, 0x02, 126},
        {6, 0x02, 126},
        {10, 0x02, 126},
        {15, 0x02, 126},
        {24, 0x02, 126},
        {31, 0x02, 126},
        {41, 0x02, 126},
        {56, 0x03, 126},
    },
    /* 90 */
    {
        {2, 0x02, 94},
        {9, 0x02, 94},
        {23, 0x02, 94},
        {40, 0x03, 94},
        {2, 0x0a, 125},
        {9, 0x0a, 125},
        {23, 0x0a, 125},
        {40, 0x0b, 125},
        {1, 0x0a, 60},
        {22, 0x0b, 60},
        {1, 0x02, 96},
        {22, 0x03, 96},
        {1, 0x0a, 123},
        {22, 0x0b, 123},
        {96, 0x00, 0},
        {110, 0x00, 0},
    },
    /* 91 */
    {
        {3, 0x02, 94},
        {6, 0x02, 94},
        {10, 0x02, 94},
        {15, 0x02, 94},
        {24, 0x02, 94},
        {31, 0x02, 94},
        {41, 0x02, 94},
        {56, 0x03, 94},
        {3, 0x0a, 125},
        {6, 0x0a, 125},
        {10, 0x0a, 125},
        {15, 0x0a, 125},
        {24, 0x0a, 125},
        {31, 0x0a, 125},
        {41, 0x0a, 125},
        {56, 0x0b, 125},
    },
    /* 92 */
    {
        {2, 0x0a, 60},
        {9, 0x0a, 60},
        {23, 0x0a, 60},
        {40, 0x0b, 60},
        {2, 0x02, 96},
        {9, 0x02, 96},
        {23, 0x02, 96},
        {40, 0x03, 96},
        {2, 0x0a, 123},
        {9, 0x0a, 123},
        {23, 0x0a, 123},
        {40, 0x0b, 123},
        {97, 0x00, 0},
        {101, 0x00, 0},
        {111, 0x00, 0},
        {133, 0x00, 0},
    },
    /* 93 */
    {
        {3, 0x0a, 60},
        {6, 0x0a, 60},
        {10, 0x0a, 60},
        {15, 0x0a, 60},
        {24, 0x0a, 60},
        {31, 0x0a, 60},
        {41, 0x0a, 60},
        {56, 0x0b, 60},
        {3, 0x02, 96},
        {6, 0x02, 96},
        {10, 0x02, 96},
        {15, 0x02, 96},
        {24, 0x02, 96},
        {31, 0x02, 96},
        {41, 0x02, 96},
        {56, 0x03, 96},
    },
    /* 94 */
    {
        {3, 0x0a, 123},
        {6, 0x0a, 123},
        {10, 0x0a, 123},
        {15, 0x0a, 123},
        {24, 0x0a, 123},
        {31, 0x0a, 123},
        {41, 0x0a, 123},
        {56, 0x0b, 123},
        {98, 0x00, 0},
        {99, 0x00, 0},
        {102, 0x00, 0},
        {105, 0x00, 0},
        {112, 0x00, 0},
        {119, 0x00, 0},
        {134, 0x00, 0},
        {153, 0x00, 0},
    },
    /* 95 */
    {
        {0, 0x0b, 92},
        {0, 0x0b, 195},
        {0, 0x0b, 208},
        {100, 0x00, 0},
        {103, 0x00, 0},
        {104, 0x00, 0},
        {106, 0x00, 0},
        {107, 0x00, 0},
        {113, 0x00, 0},
        {116, 0x00, 0},
        {120, 0x00, 0},
        {126, 0x00, 0},
        {135, 0x00, 0},
        {142, 0x00, 0},
        {154, 0x00, 0},
        {169, 0x00, 0},
    },
    /* 96 */
    {
        {1, 0x0a, 92},
        {22, 0x0b, 92},
        {1, 0x0a, 195},
        {22, 0x0b, 195},
        {1, 0x0a, 208},
        {22, 0x0b, 208},
        {0, 0x0b, 128},
        {0, 0x0b, 130},
        {0, 0x0b, 131},
        {0, 0x0b, 162},
        {0, 0x0b, 184},
        {0, 0x0b, 194},
        {0, 0x0b, 224},
        {0, 0x0b, 226},
        {108, 0x00, 0},
        {109, 0x00, 0},
    },
    /* 97 */
    {
        {2, 0x0a, 92},
        {9, 0x0a, 92},
        {23, 0x0a, 92},
        {40, 0x0b, 92},
        {2, 0x0a, 195},
        {9, 0x0a, 195},
        {23, 0x0a, 195},
        {40, 0x0b, 195},
        {2, 0x0a, 208},
        {9, 0x0a, 208},
        {23, 0x0a, 208},
        {40, 0x0b, 208},
        {1, 0x0a, 128},
        {22, 0x0b, 128},
        {1, 0x0a, 130},
        {22, 0x0b, 130},
    },
    /* 98 */
    {
        {3, 0x0a, 92},
        {6, 0x0a, 92},
        {10, 0x0a, 92},
        {15, 0x0a, 92},
        {24, 0x0a, 92},
        {31, 0x0a, 92},
        {41, 0x0a, 92},
        {56, 0x0b, 92},
        {3, 0x0a, 195},
        {6, 0x0a, 195},
        {10, 0x0a, 195},
        {15, 0x0a, 195},
        {24, 0x0a, 195},
        {31, 0x0a, 195},
        {41, 0x0a, 195},
        {56, 0x0b, 195},
    },
    /* 99 */
    {
        {3, 0x0a, 208},
        {6, 0x0a, 208},
        {10, 0x0a, 208},
        {15, 0x0a, 208},
        {24, 0x0a, 208},
        {31, 0x0a, 208},
        {41, 0x0a, 208},
        {56, 0x0b, 208},
        {2, 0x0a, 128},
        {9, 0x0a, 128},
        {23, 0x0a, 128},
        {40, 0x0b, 128},
        {2, 0x0a, 130},
        {9, 0x0a, 130},
        {23, 0x0a, 130},
        {40, 0x0b, 130},
    },
    /* 100 */
    {
        {3, 0x0a, 128},
        {6, 0x0a, 128},
        {10, 0x0a, 128},
        {15, 0x0a, 128},
        {24, 0x0a, 128},
        {31, 0x0a, 128},
        {41, 0x0a, 128},
        {56, 0x0b, 128},
        {3, 0x0a, 130},
        {6, 0x0a, 130},
        {10, 0x0a, 130},
        {15, 0x0a, 130},
        {24, 0x0a, 130},
        {31, 0x0a, 130},
        {41, 0x0a, 130},
        {56, 0x0b, 130},
    },
    /* 101 */
    {
        {1, 0x0a, 131},
        {22, 0x0b, 131},
        {1, 0x0a, 162},
        {22, 0x0b, 162},
        {1, 0x0a, 184},
        {22, 0x0b, 184},
        {1, 0x0a, 194},
        {22, 0x0b, 194},
        {1, 0x0a, 224},
        {22, 0x0b, 224},
        {1, 0x0a, 226},
        {22, 0x0b, 226},
        {0, 0x0b, 153},
        {0, 0x0b, 161},
        {0, 0x0b, 167},
        {0, 0x0b, 172},
    },
    /* 102 */
    {
        {2, 0x0a, 131},
        {9, 0x0a, 131},
        {23, 0x0a, 131},
        {40, 0x0b, 131},
        {2, 0x0a, 162},
        {9, 0x0a, 162},
        {23, 0x0a, 162},
        {40, 0x0b, 162},
        {2, 0x0a, 184},
        {9, 0x0a, 184},
        {23, 0x0a, 184},
        {40, 0x0b, 184},
        {2, 0x0a, 194},
        {9, 0x0a, 194},
        {23, 0x0a, 194},
        {40, 0x0b, 194},
    },
    /* 103 */
    {
        {3, 0x0a, 131},
        {6, 0x0a, 131},
        {10, 0x0a, 131},
        {15, 0x0a, 131},
        {24, 0x0a, 131},
        {31, 0x0a, 131},
        {41, 0x0a, 131},
        {56, 0x0b, 131},
        {3, 0x0a, 162},
        {6, 0x0a, 162},
        {10, 0x0a, 162},
        {15, 0x0a, 162},
        {24, 0x0a, 162},
        {31, 0x0a, 162},
        {41, 0x0a, 162},
        {56, 0x0b, 162},
    },
    /* 104 */
    {
        {3, 0x0a, 184},
        {6, 0x0a, 184},
        {10, 0x0a, 184},
        {15, 0x0a, 184},
        {24, 0x0a, 184},
        {31, 0x0a, 184},
        {41, 0x0a, 184},
        {56, 0x0b, 184},
        {3, 0x0a, 194},
        {6, 0x0a, 194},
        {10, 0x0a, 194},
        {15, 0x0a, 194},
        {24, 0x0a, 194},
        {31, 0x0a, 194},
        {41, 0x0a, 194},
        {56, 0x0b, 194},
    },
    /* 105 */
    {
        {2, 0x0a, 224},
        {9, 0x0a, 224},
        {23, 0x0a, 224},
        {40, 0x0b, 224},
        {2, 0x0a, 226},
        {9, 0x0a, 226},
        {23, 0x0a, 226},
        {40, 0x0b, 226},
        {1, 0x0a, 153},
        {22, 0x0b, 153},
        {1, 0x0a, 161},
        {22, 0x0b, 161},
        {1, 0x0a, 167},
        {22, 0x0b, 167},
        {1, 0x0a, 172},
        {22, 0x0b, 172},
    },
    /* 106 */
    {
        {3, 0x0a, 224},
        {6, 0x0a, 224},
        {10, 0x0a, 224},
        {15, 0x0a, 224},
        {24, 0x0a, 224},
        {31, 0x0a, 224},
        {41, 0x0a, 224},
        {56, 0x0b, 224},
        {3, 0x0a, 226},
        {6, 0x0a, 226},
        {10, 0x0a, 226},
        {15, 0x0a, 226},
        {24, 0x0a, 226},
        {31, 0x0a, 226},
        {41, 0x0a, 226},
        {56, 0x0b, 226},
    },
    /* 107 */
    {
        {2, 0x0a, 153},
        {9, 0x0a, 153},
        {23, 0x0a, 153},
        {40, 0x0b, 153},
        {2, 0x0a, 161},
        {9, 0x0a, 161},
        {23, 0x0a, 161},
        {40, 0x0b, 161},
        {2, 0x0a, 167},
        {9, 0x0a, 167},
        {23, 0x0a, 167},
        {40, 0x0b, 167},
        {2, 0x0a, 172},
        {9, 0x0a, 172},
        {23, 0x0a, 172},
        {40, 0x0b, 172},
    },
    /* 108 */
    {
        {3, 0x0a, 153},
        {6, 0x0a, 153},
        {10, 0x0a, 153},
        {15, 0x0a, 153},
        {24, 0x0a, 153},
        {31, 0x0a, 153},
        {41, 0x0a, 153},
        {56, 0x0b, 153},
        {3, 0x0a, 161},
        {6, 0x0a, 161},
        {10, 0x0a, 161},
        {15, 0x0a, 161},
        {24, 0x0a, 161},
        {31, 0x0a, 161},
        {41, 0x0a, 161},
        {56, 0x0b, 161},
    },
    /* 109 */
    {
        {3, 0x0a, 167},
        {6, 0x0a, 167},
        {10, 0x0a, 167},
        {15, 0x0a, 167},
        {24, 0x0a, 167},
        {31, 0x0a, 167},
        {41, 0x0a, 167},
        {56, 0x0b, 167},
        {3, 0x0a, 172},
        {6, 0x0a, 172},
        {10, 0x0a, 172},
        {15, 0x0a, 172},
        {24, 0x0a, 172},
        {31, 0x0a, 172},
        {41, 0x0a, 172},
        {56, 0x0b, 172},
    },
    /* 110 */
    {
        {114, 0x00, 0},
        {115, 0x00, 0},
        {117, 0x00, 0},
        {118, 0x00, 0},
        {121, 0x00, 0},
        {123, 0x00, 0},
        {127, 0x00, 0},
        {130, 0x00, 0},
        {136, 0x00, 0},
        {139, 0x00, 0},
        {143, 0x00, 0},
        {146, 0x00, 0},
        {155, 0x00, 0},
        {162, 0x00, 0},
        {170, 0x00, 0},
        {180, 0x00, 0},
    },
    /* 111 */
    {
        {0, 0x0b, 176},
        {0, 0x0b, 177},
        {0, 0x0b, 179},
        {0, 0x0b, 209},
        {0, 0x0b, 216},
        {0, 0x0b, 217},
        {0, 0x0b, 227},
        {0, 0x0b, 229},
        {0, 0x0b, 230},
        {122, 0x00, 0},
        {124, 0x00, 0},
        {125, 0x00, 0},
        {128, 0x00, 0},
        {129, 0x00, 0},
        {131, 0x00, 0},
        {132, 0x00, 0},
    },
    /* 112 */
    {
        {1, 0x0a, 176},
        {22, 0x0b, 176},
        {1, 0x0a, 177},
        {22, 0x0b, 177},
        {1, 0x0a, 179},
        {22, 0x0b, 179},
        {1, 0x0a, 209},
        {22, 0x0b, 209},
        {1, 0x0a, 216},
        {22, 0x0b, 216},
        {1, 0x0a, 217},
        {22, 0x0b, 217},
        {1, 0x0a, 227},
        {22, 0x0b, 227},
        {1, 0x0a, 229},
        {22, 0x0b, 229},
    },
    /* 113 */
    {
        {2, 0x0a, 176},
        {9, 0x0a, 176},
        {23, 0x0a, 176},
        {40, 0x0b, 176},
        {2, 0x0a, 177},
        {9, 0x0a, 177},
        {23, 0x0a, 177},
        {40, 0x0b, 177},
        {2, 0x0a, 179},
        {9, 0x0a, 179},
        {23, 0x0a, 179},
        {40, 0x0b, 179},
        {2, 0x0a, 209},
        {9, 0x0a, 209},
        {23, 0x0a, 209},
        {40, 0x0b, 209},
    },
    /* 114 */
    {
        {3, 0x0a, 176},
        {6, 0x0a, 176},
        {10, 0x0a, 176},
        {15, 0x0a, 176},
        {24, 0x0a, 176},
        {31, 0x0a, 176},
        {41, 0x0a, 176},
        {56, 0x0b, 176},
        {3, 0x0a, 177},
        {6, 0x0a, 177},
        {10, 0x0a, 177},
        {15, 0x0a, 177},
        {24, 0x0a, 177},
        {31, 0x0a, 177},
        {41, 0x0a, 177},
        {56, 0x0b, 177},
    },
    /* 115 */
    {
        {3, 0x0a, 179},
        {6, 0x0a, 179},
        {10, 0x0a, 179},
        {15, 0x0a, 179},
        {24, 0x0a, 179},
        {31, 0x0a, 179},
        {41, 0x0a, 179},
        {56, 0x0b, 179},
        {3, 0x0a, 209},
        {6, 0x0a, 209},
        {10, 0x0a, 209},
        {15, 0x0a, 209},
        {24, 0x0a, 209},
        {31, 0x0a, 209},
        {41, 0x0a, 209},
        {56, 0x0b, 209},
    },
    /* 116 */
    {
        {2, 0x0a, 216},
        {9, 0x0a, 216},
        {23, 0x0a, 216},
        {40, 0x0b, 216},
        {2, 0x0a, 217},
        {9, 0x0a, 217},
        {23, 0x0a, 217},
        {40, 0x0b, 217},
        {2, 0x0a, 227},
        {9, 0x0a, 227},
        {23, 0x0a, 227},
        {40, 0x0b, 227},
        {2, 0x0a, 229},
        {9, 0x0a, 229},
        {23, 0x0a, 229},
        {40, 0x0b, 229},
    },
    /* 117 */
    {
        {3, 0x0a, 216},
        {6, 0x0a, 216},
        {10, 0x0a, 216},
        {15, 0x0a, 216},
        {24, 0x0a, 216},
        {31, 0x0a, 216},
        {41, 0x0a, 216},
        {56, 0x0b, 216},
        {3, 0x0a, 217},
        {6, 0x0a, 217},
        {10, 0x0a, 217},
        {15, 0x0a, 217},
        {24, 0x0a, 217},
        {31, 0x0a, 217},
        {41, 0x0a, 217},
        {56, 0x0b, 217},
    },
    /* 118 */
    {
        {3, 0x0a, 227},
        {6, 0x0a, 227},
        {10, 0x0a, 227},
        {15, 0x0a, 227},
        {24, 0x0a, 227},
        {31, 0x0a, 227},
        {41, 0x0a, 227},
        {56, 0x0b, 227},
        {3, 0x0a, 229},
        {6, 0x0a, 229},
        {10, 0x0a, 229},
        {15, 0x0a, 229},
        {24, 0x0a, 229},
        {31, 0x0a, 229},
        {41, 0x0a, 229},
        {56, 0x0b, 229},
    },
    /* 119 */
    {
        {1, 0x0a, 230},
        {22, 0x0b, 230},
        {0, 0x0b, 129},
        {0, 0x0b, 132},
        {0, 0x0b, 133},
        {0, 0x0b, 134},
        {0, 0x0b, 136},
        {0, 0x0b, 146},
        {0, 0x0b, 154},
        {0, 0x0b, 156},
        {0, 0x0b, 160},
        {0, 0x0b, 163},
        {0, 0x0b, 164},
        {0, 0x0b, 169},
        {0, 0x0b, 170},
        {0, 0x0b, 173},
    },
    /* 120 */
    {
        {2, 0x0a, 230},
        {9, 0x0a, 230},
        {23, 0x0a, 230},
        {40, 0x0b, 230},
        {1, 0x0a, 129},
        {22, 0x0b, 129},
        {1, 0x0a, 132},
        {22, 0x0b, 132},
        {1, 0x0a, 133},
        {22, 0x0b, 133},
        {1, 0x0a, 134},
        {22, 0x0b, 134},
        {1, 0x0a, 136},
        {22, 0x0b, 136},
        {1, 0x0a, 146},
        {22, 0x0b, 146},
    },
    /* 121 */
    {
        {3, 0x0a, 230},
        {6, 0x0a, 230},
        {10, 0x0a, 230},
        {15, 0x0a, 230},
        {24, 0x0a, 230},
        {31, 0x0a, 230},
        {41, 0x0a, 230},
        {56, 0x0b, 230},
        {2, 0x0a, 129},
        {9, 0x0a, 129},
        {23, 0x0a, 129},
        {40, 0x0b, 129},
        {2, 0x0a, 132},
        {9, 0x0a, 132},
        {23, 0x0a, 132},
        {40, 0x0b, 132},
    },
    /* 122 */
    {
        {3, 0x0a, 129},
        {6, 0x0a, 129},
        {10, 0x0a, 129},
        {15, 0x0a, 129},
        {24, 0x0a, 129},
        {31, 0x0a, 129},
        {41, 0x0a, 129},
        {56, 0x0b, 129},
        {3, 0x0a, 132},
        {6, 0x0a, 132},
        {10, 0x0a, 132},
        {15, 0x0a, 132},
        {24, 0x0a, 132},
        {31, 0x0a, 132},
        {41, 0x0a, 132},
        {56, 0x0b, 132},
    },
    /* 123 */
    {
        {2, 0x0a, 133},
        {9, 0x0a, 133},
        {23, 0x0a, 133},
        {40, 0x0b, 133},
        {2, 0x0a, 134},
        {9, 0x0a, 134},
        {23, 0x0a, 134},
        {40, 0x0b, 134},
        {2, 0x0a, 136},
        {9, 0x0a, 136},
        {23, 0x0a, 136},
        {40, 0x0b, 136},
        {2, 0x0a, 146},
        {9, 0x0a, 146},
        {23, 0x0a, 146},
        {40, 0x0b, 146},
    },
    /* 124 */
    {
        {3, 0x0a, 133},
        {6, 0x0a, 133},
        {10, 0x0a, 133},
        {15, 0x0a, 133},
        {24, 0x0a, 133},
        {31, 0x0a, 133},
        {41, 0x0a, 133},
        {56, 0x0b, 133},
        {3, 0x0a, 134},
        {6, 0x0a, 134},
        {10, 0x0a, 134},
        {15, 0x0a, 134},
        {24, 0x0a, 134},
        {31, 0x0a, 134},
        {41, 0x0a, 134},
        {56, 0x0b, 134},
    },
    /* 125 */
    {
        {3, 0x0a, 136},
        {6, 0x0a, 136},
        {10, 0x0a, 136},
        {15, 0x0a, 136},
        {24, 0x0a, 136},
        {31, 0x0a, 136},
        {41, 0x0a, 136},
        {56, 0x0b, 136},
        {3, 0x0a, 146},
        {6, 0x0a, 146},
        {10, 0x0a, 146},
        {15, 0x0a, 146},
        {24, 0x0a, 146},
        {31, 0x0a, 146},
        {41, 0x0a, 146},
        {56, 0x0b, 146},
    },
    /* 126 */
    {
        {1, 0x0a, 154},
        {22, 0x0b, 154},
        {1, 0x0a, 156},
        {22, 0x0b, 156},
        {1, 0x0a, 160},
        {22, 0x0b, 160},
        {1, 0x0a, 163},
        {22, 0x0b, 163},
        {1, 0x0a, 164},
        {22, 0x0b, 164},
        {1, 0x0a, 169},
        {22, 0x0b, 169},
        {1, 0x0a, 170},
        {22, 0x0b, 170},
        {1, 0x0a, 173},
        {22, 0x0b, 173},
    },
    /* 127 */
    {
        {2, 0x0a, 154},
        {9, 0x0a, 154},
        {23, 0x0a, 154},
        {40, 0x0b, 154},
        {2, 0x0a, 156},
        {9, 0x0a, 156},
        {23, 0x0a, 156},
        {40, 0x0b, 156},
        {2, 0x0a, 160},
        {9, 0x0a, 160},
        {23, 0x0a, 160},
        {40, 0x0b, 160},
        {2, 0x0a, 163},
        {9, 0x0a, 163},
        {23, 0x0a, 163},
        {40, 0x0b, 163},
    },
    /* 128 */
    {
        {3, 0x0a, 154},
        {6, 0x0a, 154},
        {10, 0x0a, 154},
        {15, 0x0a, 154},
        {24, 0x0a, 154},
        {31, 0x0a, 154},
        {41, 0x0a, 154},
        {56, 0x0b, 154},
        {3, 0x0a, 156},
        {6, 0x0a, 156},
        {10, 0x0a, 156},
        {15, 0x0a, 156},
        {24, 0x0a, 156},
        {31, 0x0a, 156},
        {41, 0x0a, 156},
        {56, 0x0b, 156},
    },
    /* 129 */
    {
        {3, 0x0a, 160},
        {6, 0x0a, 160},
        {10, 0x0a, 160},
        {15, 0x0a, 160},
        {24, 0x0a, 160},
        {31, 0x0a, 160},
        {41, 0x0a, 160},
        {56, 0x0b, 160},
        {3, 0x0a, 163},
        {6, 0x0a, 163},
        {10, 0x0a, 163},
        {15, 0x0a, 163},
        {24, 0x0a, 163},
        {31, 0x0a, 163},
        {41, 0x0a, 163},
        {56, 0x0b, 163},
    },
    /* 130 */
    {
        {2, 0x0a, 164},
        {9, 0x0a, 164},
        {23, 0x0a, 164},
        {40, 0x0b, 164},
        {2, 0x0a, 169},
        {9, 0x0a, 169},
        {23, 0x0a, 169},
        {40, 0x0b, 169},
        {2, 0x0a, 170},
        {9, 0x0a, 170},
        {23, 0x0a, 170},
        {40, 0x0b, 170},
        {2, 0x0a, 173},
        {9, 0x0a, 173},
        {23, 0x0a, 173},
        {40, 0x0b, 173},
    },
    /* 131 */
    {
        {3, 0x0a, 164},
        {6, 0x0a, 164},
        {10, 0x0a, 164},
        {15, 0x0a, 164},
        {24, 0x0a, 164},
        {31, 0x0a, 164},
        {41, 0x0a, 164},
        {56, 0x0b, 164},
        {3, 0x0a, 169},
        {6, 0x0a, 169},
        {10, 0x0a, 169},
        {15, 0x0a, 169},
        {24, 0x0a, 169},
        {31, 0x0a, 169},
        {41, 0x0a, 169},
        {56, 0x0b, 169},
    },
    /* 132 */
    {
        {3, 0x0a, 170},
        {6, 0x0a, 170},
        {10, 0x0a, 170},
        {15, 0x0a, 170},
        {24, 0x0a, 170},
        {31, 0x0a, 170},
        {41, 0x0a, 170},
        {56, 0x0b, 170},
        {3, 0x0a, 173},
        {6, 0x0a, 173},
        {10, 0x0a, 173},
        {15, 0x0a, 173},
        {24, 0x0a, 173},
        {31, 0x0a, 173},
        {41, 0x0a, 173},
        {56, 0x0b, 173},
    },
    /* 133 */
    {
        {137, 0x00, 0},
        {138, 0x00, 0},
        {140, 0x00, 0},
        {141, 0x00, 0},
        {144, 0x00, 0},
        {145, 0x00, 0},
        {147, 0x00, 0},
        {150, 0x00, 0},
        {156, 0x00, 0},
        {159, 0x00, 0},
        {163, 0x00, 0},
        {166, 0x00, 0},
        {171, 0x00, 0},
        {174, 0x00, 0},
        {181, 0x00, 0},
        {190, 0x00, 0},
    },
    /* 134 */
    {
        {0, 0x0b, 178},
        {0, 0x0b, 181},
        {0, 0x0b, 185},
        {0, 0x0b, 186},
        {0, 0x0b, 187},
        {0, 0x0b, 189},
        {0, 0x0b, 190},
        {0, 0x0b, 196},
        {0, 0x0b, 198},
        {0, 0x0b, 228},
        {0, 0x0b, 232},
        {0, 0x0b, 233},
        {148, 0x00, 0},
        {149, 0x00, 0},
        {151, 0x00, 0},
        {152, 0x00, 0},
    },
    /* 135 */
    {
        {1, 0x0a, 178},
        {22, 0x0b, 178},
        {1, 0x0a, 181},
        {22, 0x0b, 181},
        {1, 0x0a, 185},
        {22, 0x0b, 185},
        {1, 0x0a, 186},
        {22, 0x0b, 186},
        {1, 0x0a, 187},
        {22, 0x0b, 187},
        {1, 0x0a, 189},
        {22, 0x0b, 189},
        {1, 0x0a, 190},
        {22, 0x0b, 190},
        {1, 0x0a, 196},
        {22, 0x0b, 196},
    },
    /* 136 */
    {
        {2, 0x0a, 178},
        {9, 0x0a, 178},
        {23, 0x0a, 178},
        {40, 0x0b, 178},
        {2, 0x0a, 181},
        {9, 0x0a, 181},
        {23, 0x0a, 181},
        {40, 0x0b, 181},
        {2, 0x0a, 185},
        {9, 0x0a, 185},
        {23, 0x0a, 185},
        {40, 0x0b, 185},
        {2, 0x0a, 186},
        {9, 0x0a, 186},
        {23, 0x0a, 186},
        {40, 0x0b, 186},
    },
    /* 137 */
    {
        {3, 0x0a, 178},
        {6, 0x0a, 178},
        {10, 0x0a, 178},
        {15, 0x0a, 178},
        {24, 0x0a, 178},
        {31, 0x0a, 178},
        {41, 0x0a, 178},
        {56, 0x0b, 178},
        {3, 0x0a, 181},
        {6, 0x0a, 181},
        {10, 0x0a, 181},
        {15, 0x0a, 181},
        {24, 0x0a, 181},
        {31, 0x0a, 181},
        {41, 0x0a, 181},
        {56, 0x0b, 181},
    },
    /* 138 */
    {
        {3, 0x0a, 185},
        {6, 0x0a, 185},
        {10, 0x0a, 185},
        {15, 0x0a, 185},
        {24, 0x0a, 185},
        {31, 0x0a, 185},
        {41, 0x0a, 185},
        {56, 0x0b, 185},
        {3, 0x0a, 186},
        {6, 0x0a, 186},
        {10, 0x0a, 186},
        {15, 0x0a, 186},
        {24, 0x0a, 186},
        {31, 0x0a, 186},
        {41, 0x0a, 186},
        {56, 0x0b, 186},
    },
    /* 139 */
    {
        {2, 0x0a, 187},
        {9, 0x0a, 187},
        {23, 0x0a, 187},
        {40, 0x0b, 187},
        {2, 0x0a, 189},
        {9, 0x0a, 189},
        {23, 0x0a, 189},
        {40, 0x0b, 189},
        {2, 0x0a, 190},
        {9, 0x0a, 190},
        {23, 0x0a, 190},
        {40, 0x0b, 190},
        {2, 0x0a, 196},
        {9, 0x0a, 196},
        {23, 0x0a, 196},
        {40, 0x0b, 196},
    },
    /* 140 */
    {
        {3, 0x0a, 187},
        {6, 0x0a, 187},
        {10, 0x0a, 187},
        {15, 0x0a, 187},
        {24, 0x0a, 187},
        {31, 0x0a, 187},
        {41, 0x0a, 187},
        {56, 0x0b, 187},
        {3, 0x0a, 189},
        {6, 0x0a, 189},
        {10, 0x0a, 189},
        {15, 0x0a, 189},
        {24, 0x0a, 189},
        {31, 0x0a, 189},
        {41, 0x0a, 189},
        {56, 0x0b, 189},
    },
    /* 141 */
    {
        {3, 0x0a, 190},
        {6, 0x0a, 190},
        {10, 0x0a, 190},
        {15, 0x0a, 190},
        {24, 0x0a, 190},
        {31, 0x0a, 190},
        {41, 0x0a, 190},
        {56, 0x0b, 190},
        {3, 0x0a, 196},
        {6, 0x0a, 196},
        {10, 0x0a, 196},
        {15, 0x0a, 196},
        {24, 0x0a, 196},
        {31, 0x0a, 196},
        {41, 0x0a, 196},
        {56, 0x0b, 196},
    },
    /* 142 */
    {
        {1, 0x0a, 198},
        {22, 0x0b, 198},
        {1, 0x0a, 228},
        {22, 0x0b, 228},
        {1, 0x0a, 232},
        {22, 0x0b, 232},
        {1, 0x0a, 233},
        {22, 0x0b, 233},
        {0, 0x1b, 1},
        {0, 0x0b, 135},
        {0, 0x0b, 137},
        {0, 0x0b, 138},
        {0, 0x0b, 139},
        {0, 0x0b, 140},
        {0, 0x0b, 141},
        {0, 0x0b, 143},
    },
    /* 143 */
    {
        {2, 0x0a, 198},
        {9, 0x0a, 198},
        {23, 0x0a, 198},
        {40, 0x0b, 198},
        {2, 0x0a, 228},
        {9, 0x0a, 228},
        {23, 0x0a, 228},
        {40, 0x0b, 228},
        {2, 0x0a, 232},
        {9, 0x0a, 232},
        {23, 0x0a, 232},
        {40, 0x0b, 232},
        {2, 0x0a, 233},
        {9, 0x0a, 233},
        {23, 0x0a, 233},
        {40, 0x0b, 233},
    },
    /* 144 */
    {
        {3, 0x0a, 198},
        {6, 0x0a, 198},
        {10, 0x0a, 198},
        {15, 0x0a, 198},
        {24, 0x0a, 198},
        {31, 0x0a, 198},
        {41, 0x0a, 198},
        {56, 0x0b, 198},
        {3, 0x0a, 228},
        {6, 0x0a, 228},
        {10, 0x0a, 228},
        {15, 0x0a, 228},
        {24, 0x0a, 228},
        {31, 0x0a, 228},
        {41, 0x0a, 228},
        {56, 0x0b, 228},
    },
    /* 145 */
    {
        {3, 0x0a, 232},
        {6, 0x0a, 232},
        {10, 0x0a, 232},
        {15, 0x0a, 232},
        {24, 0x0a, 232},
        {31, 0x0a, 232},
        {41, 0x0a, 232},
        {56, 0x0b, 232},
        {3, 0x0a, 233},
        {6, 0x0a, 233},
        {10, 0x0a, 233},
        {15, 0x0a, 233},
        {24, 0x0a, 233},
        {31, 0x0a, 233},
        {41, 0x0a, 233},
        {56, 0x0b, 233},
    },
    /* 146 */
    {
        {1, 0x1a, 1},
        {22, 0x1b, 1},
        {1, 0x0a, 135},
        {22, 0x0b, 135},
        {1, 0x0a, 137},
        {22, 0x0b, 137},
        {1, 0x0a, 138},
        {22, 0x0b, 138},
        {1, 0x0a, 139},
        {22, 0x0b, 139},
        {1, 0x0a, 140},
        {22, 0x0b, 140},
        {1, 0x0a, 141},
        {22, 0x0b, 141},
        {1, 0x0a, 143},
        {22, 0x0b, 143},
    },
    /* 147 */
    {
        {2, 0x1a, 1},
        {9, 0x1a, 1},
        {23, 0x1a, 1},
        {40, 0x1b, 1},
        {2, 0x0a, 135},
        {9, 0x0a, 135},
        {23, 0x0a, 135},
        {40, 0x0b, 135},
        {2, 0x0a, 137},
        {9, 0x0a, 137},
        {23, 0x0a, 137},
        {40, 0x0b, 137},
        {2, 0x0a, 138},
        {9, 0x0a, 138},
        {23, 0x0a, 138},
        {40, 0x0b, 138},
    },
    /* 148 */
    {
        {3, 0x1a, 1},
        {6, 0x1a, 1},
        {10, 0x1a, 1},
        {15, 0x1a, 1},
        {24, 0x1a, 1},
        {31, 0x1a, 1},
        {41, 0x1a, 1},
        {56, 0x1b, 1},
        {3, 0x0a, 135},
        {6, 0x0a, 135},
        {10, 0x0a, 135},
        {15, 0x0a, 135},
        {24, 0x0a, 135},
        {31, 0x0a, 135},
        {41, 0x0a, 135},
        {56, 0x0b, 135},
    },
    /* 149 */
    {
        {3, 0x0a, 137},
        {6, 0x0a, 137},
        {10, 0x0a, 137},
        {15, 0x0a, 137},
        {24, 0x0a, 137},
        {31, 0x0a, 137},
        {41, 0x0a, 137},
        {56, 0x0b, 137},
        {3, 0x0a, 138},
        {6, 0x0a, 138},
        {10, 0x0a, 138},
        {15, 0x0a, 138},
        {24, 0x0a, 138},
        {31, 0x0a, 138},
        {41, 0x0a, 138},
        {56, 0x0b, 138},
    },
    /* 150 */
    {
        {2, 0x0a, 139},
        {9, 0x0a, 139},
        {23, 0x0a, 139},
        {40, 0x0b, 139},
        {2, 0x0a, 140},
        {9, 0x0a, 140},
        {23, 0x0a, 140},
        {40, 0x0b, 140},
        {2, 0x0a, 141},
        {9, 0x0a, 141},
        {23, 0x0a, 141},
        {40, 0x0b, 141},
        {2, 0x0a, 143},
        {9, 0x0a, 143},
        {23, 0x0a, 143},
        {40, 0x0b, 143},
    },
    /* 151 */
    {
        {3, 0x0a, 139},
        {6, 0x0a, 139},
        {10, 0x0a, 139},
        {15, 0x0a, 139},
        {24, 0x0a, 139},
        {31, 0x0a, 139},
        {41, 0x0a, 139},
        {56, 0x0b, 139},
        {3, 0x0a, 140},
        {6, 0x0a, 140},
        {10, 0x0a, 140},
        {15, 0x0a, 140},
        {24, 0x0a, 140},
        {31, 0x0a, 140},
        {41, 0x0a, 140},
        {56, 0x0b, 140},
    },
    /* 152 */
    {
        {3, 0x0a, 141},
        {6, 0x0a, 141},
        {10, 0x0a, 141},
        {15, 0x0a, 141},
        {24, 0x0a, 141},
        {31, 0x0a, 141},
        {41, 0x0a, 141},
        {56, 0x0b, 141},
        {3, 0x0a, 143},
        {6, 0x0a, 143},
        {10, 0x0a, 143},
        {15, 0x0a, 143},
        {24, 0x0a, 143},
        {31, 0x0a, 143},
        {41, 0x0a, 143},
        {56, 0x0b, 143},
    },
    /* 153 */
    {
        {157, 0x00, 0},
        {158, 0x00, 0},
        {160, 0x00, 0},
        {161, 0x00, 0},
        {164, 0x00, 0},
        {165, 0x00, 0},
        {167, 0x00, 0},
        {168, 0x00, 0},
        {172, 0x00, 0},
        {173, 0x00, 0},
        {175, 0x00, 0},
        {177, 0x00, 0},
        {182, 0x00, 0},
        {185, 0x00, 0},
        {191, 0x00, 0},
        {207, 0x00, 0},
    },
    /* 154 */
    {
        {0, 0x0b, 147},
        {0, 0x0b, 149},
        {0, 0x0b, 150},
        {0, 0x0b, 151},
        {0, 0x0b, 152},
        {0, 0x0b, 155},
        {0, 0x0b, 157},
        {0, 0x0b, 158},
        {0, 0x0b, 165},
        {0, 0x0b, 166},
        {0, 0x0b, 168},
        {0, 0x0b, 174},
        {0, 0x0b, 175},
        {0, 0x0b, 180},
        {0, 0x0b, 182},
        {0, 0x0b, 183},
    },
    /* 155 */
    {
        {1, 0x0a, 147},
        {22, 0x0b, 147},
        {1, 0x0a, 149},
        {22, 0x0b, 149},
        {1, 0x0a, 150},
        {22, 0x0b, 150},
        {1, 0x0a, 151},
        {22, 0x0b, 151},
        {1, 0x0a, 152},
        {22, 0x0b, 152},
        {1, 0x0a, 155},
        {22, 0x0b, 155},
        {1, 0x0a, 157},
        {22, 0x0b, 157},
        {1, 0x0a, 158},
        {22, 0x0b, 158},
    },
    /* 156 */
    {
        {2, 0x0a, 147},
        {9, 0x0a, 147},
        {23, 0x0a, 147},
        {40, 0x0b, 147},
        {2, 0x0a, 149},
        {9, 0x0a, 149},
        {23, 0x0a, 149},
        {40, 0x0b, 149},
        {2, 0x0a, 150},
        {9, 0x0a, 150},
        {23, 0x0a, 150},
        {40, 0x0b, 150},
        {2, 0x0a, 151},
        {9, 0x0a, 151},
        {23, 0x0a, 151},
        {40, 0x0b, 151},
    },
    /* 157 */
    {
        {3, 0x0a, 147},
        {6, 0x0a, 147},
        {10, 0x0a, 147},
        {15, 0x0a, 147},
        {24, 0x0a, 147},
        {31, 0x0a, 147},
        {41, 0x0a, 147},
        {56, 0x0b, 147},
        {3, 0x0a, 149},
        {6, 0x0a, 149},
        {10, 0x0a, 149},
        {15, 0x0a, 149},
        {24, 0x0a, 149},
        {31, 0x0a, 149},
        {41, 0x0a, 149},
        {56, 0x0b, 149},
    },
    /* 158 */
    {
        {3, 0x0a, 150},
        {6, 0x0a, 150},
        {10, 0x0a, 150},
        {15, 0x0a, 150},
        {24, 0x0a, 150},
        {31, 0x0a, 150},
        {41, 0x0a, 150},
        {56, 0x0b, 150},
        {3, 0x0a, 151},
        {6, 0x0a, 151},
        {10, 0x0a, 151},
        {15, 0x0a, 151},
        {24, 0x0a, 151},
        {31, 0x0a, 151},
        {41, 0x0a, 151},
        {56, 0x0b, 151},
    },
    /* 159 */
    {
        {2, 0x0a, 152},
        {9, 0x0a, 152},
        {23, 0x0a, 152},
        {40, 0x0b, 152},
        {2, 0x0a, 155},
        {9, 0x0a, 155},
        {23, 0x0a, 155},
        {40, 0x0b, 155},
        {2, 0x0a, 157},
        {9, 0x0a, 157},
        {23, 0x0a, 157},
        {40, 0x0b, 157},
        {2, 0x0a, 158},
        {9, 0x0a, 158},
        {23, 0x0a, 158},
        {40, 0x0b, 158},
    },
    /* 160 */
    {
        {3, 0x0a, 152},
        {6, 0x0a, 152},
        {10, 0x0a, 152},
        {15, 0x0a, 152},
        {24, 0x0a, 152},
        {31, 0x0a, 152},
        {41, 0x0a, 152},
        {56, 0x0b, 152},
        {3, 0x0a, 155},
        {6, 0x0a, 155},
        {10, 0x0a, 155},
        {15, 0x0a, 155},
        {24, 0x0a, 155},
        {31, 0x0a, 155},
        {41, 0x0a, 155},
        {56, 0x0b, 155},
    },
    /* 161 */
    {
        {3, 0x0a, 157},
        {6, 0x0a, 157},
        {10, 0x0a, 157},
        {15, 0x0a, 157},
        {24, 0x0a, 157},
        {31, 0x0a, 157},
        {41, 0x0a, 157},
        {56, 0x0b, 157},
        {3, 0x0a, 158},
        {6, 0x0a, 158},
        {10, 0x0a, 158},
        {15, 0x0a, 158},
        {24, 0x0a, 158},
        {31, 0x0a, 158},
        {41, 0x0a, 158},
        {56, 0x0b, 158},
    },
    /* 162 */
    {
        {1, 0x0a, 165},
        {22, 0x0b, 165},
        {1, 0x0a, 166},
        {22, 0x0b, 166},
        {1, 0x0a, 168},
        {22, 0x0b, 168},
        {1, 0x0a, 174},
        {22, 0x0b, 174},
        {1, 0x0a, 175},
        {22, 0x0b, 175},
        {1, 0x0a, 180},
        {22, 0x0b, 180},
        {1, 0x0a, 182},
        {22, 0x0b, 182},
        {1, 0x0a, 183},
        {22, 0x0b, 183},
    },
    /* 163 */
    {
        {2, 0x0a, 165},
        {9, 0x0a, 165},
        {23, 0x0a, 165},
        {40, 0x0b, 165},
        {2, 0x0a, 166},
        {9, 0x0a, 166},
        {23, 0x0a, 166},
        {40, 0x0b, 166},
        {2, 0x0a, 168},
        {9, 0x0a, 168},
        {23, 0x0a, 168},
        {40, 0x0b, 168},
        {2, 0x0a, 174},
        {9, 0x0a, 174},
        {23, 0x0a, 174},
        {40, 0x0b, 174},
    },
    /* 164 */
    {
        {3, 0x0a, 165},
        {6, 0x0a, 165},
        {10, 0x0a, 165},
        {15, 0x0a, 165},
        {24, 0x0a, 165},
        {31, 0x0a, 165},
        {41, 0x0a, 165},
        {56, 0x0b, 165},
        {3, 0x0a, 166},
        {6, 0x0a, 166},
        {10, 0x0a, 166},
        {15, 0x0a, 166},
        {24, 0x0a, 166},
        {31, 0x0a, 166},
        {41, 0x0a, 166},
        {56, 0x0b, 166},
    },
    /* 165 */
    {
        {3, 0x0a, 168},
        {6, 0x0a, 168},
        {10, 0x0a, 168},
        {15, 0x0a, 168},
        {24, 0x0a, 168},
        {31, 0x0a, 168},
        {41, 0x0a, 168},
        {56, 0x0b, 168},
        {3, 0x0a, 174},
        {6, 0x0a, 174},
        {10, 0x0a, 174},
        {15, 0x0a, 174},
        {24, 0x0a, 174},
        {31, 0x0a, 174},
        {41, 0x0a, 174},
        {56, 0x0b, 174},
    },
    /* 166 */
    {
        {2, 0x0a, 175},
        {9, 0x0a, 175},
        {23, 0x0a, 175},
        {40, 0x0b, 175},
        {2, 0x0a, 180},
        {9, 0x0a, 180},
        {23, 0x0a, 180},
        {40, 0x0b, 180},
        {2, 0x0a, 182},
        {9, 0x0a, 182},
        {23, 0x0a, 182},
        {40, 0x0b, 182},
        {2, 0x0a, 183},
        {9, 0x0a, 183},
        {23, 0x0a, 183},
        {40, 0x0b, 183},
    },
    /* 167 */
    {
        {3, 0x0a, 175},
        {6, 0x0a, 175},
        {10, 0x0a, 175},
        {15, 0x0a, 175},
        {24, 0x0a, 175},
        {31, 0x0a, 175},
        {41, 0x0a, 175},
        {56, 0x0b, 175},
        {3, 0x0a, 180},
        {6, 0x0a, 180},
        {10, 0x0a, 180},
        {15, 0x0a, 180},
        {24, 0x0a, 180},
        {31, 0x0a, 180},
        {41, 0x0a, 180},
        {56, 0x0b, 180},
    },
    /* 168 */
    {
        {3, 0x0a, 182},
        {6, 0x0a, 182},
        {10, 0x0a, 182},
        {15, 0x0a, 182},
        {24, 0x0a, 182},
        {31, 0x0a, 182},
        {41, 0x0a, 182},
        {56, 0x0b, 182},
        {3, 0x0a, 183},
        {6, 0x0a, 183},
        {10, 0x0a, 183},
        {15, 0x0a, 183},
        {24, 0x0a, 183},
        {31, 0x0a, 183},
        {41, 0x0a, 183},
        {56, 0x0b, 183},
    },
    /* 169 */
    {
        {0, 0x0b, 188},
        {0, 0x0b, 191},
        {0, 0x0b, 197},
        {0, 0x0b, 231},
        {0, 0x0b, 239},
        {176, 0x00, 0},
        {178, 0x00, 0},
        {179, 0x00, 0},
        {183, 0x00, 0},
        {184, 0x00, 0},
        {186, 0x00, 0},
        {187, 0x00, 0},
        {192, 0x00, 0},
        {199, 0x00, 0},
        {208, 0x00, 0},
        {223, 0x00, 0},
    },
    /* 170 */
    {
        {1, 0x0a, 188},
        {22, 0x0b, 188},
        {1, 0x0a, 191},
        {22, 0x0b, 191},
        {1, 0x0a, 197},
        {22, 0x0b, 197},
        {1, 0x0a, 231},
        {22, 0x0b, 231},
        {1, 0x0a, 239},
        {22, 0x0b, 239},
        {0, 0x0b, 9},
        {0, 0x0b, 142},
        {0, 0x0b, 144},
        {0, 0x0b, 145},
        {0, 0x0b, 148},
        {0, 0x0b, 159},
    },
    /* 171 */
    {
        {2, 0x0a, 188},
        {9, 0x0a, 188},
        {23, 0x0a, 188},
        {40, 0x0b, 188},
        {2, 0x0a, 191},
        {9, 0x0a, 191},
        {23, 0x0a, 191},
        {40, 0x0b, 191},
        {2, 0x0a, 197},
        {9, 0x0a, 197},
        {23, 0x0a, 197},
        {40, 0x0b, 197},
        {2, 0x0a, 231},
        {9, 0x0a, 231},
        {23, 0x0a, 231},
        {40, 0x0b, 231},
    },
    /* 172 */
    {
        {3, 0x0a, 188},
        {6, 0x0a, 188},
        {10, 0x0a, 188},
        {15, 0x0a, 188},
        {24, 0x0a, 188},
        {31, 0x0a, 188},
        {41, 0x0a, 188},
        {56, 0x0b, 188},
        {3, 0x0a, 191},
        {6, 0x0a, 191},
        {10, 0x0a, 191},
        {15, 0x0a, 191},
        {24, 0x0a, 191},
        {31, 0x0a, 191},
        {41, 0x0a, 191},
        {56, 0x0b, 191},
    },
    /* 173 */
    {
        {3, 0x0a, 197},
        {6, 0x0a, 197},
        {10, 0x0a, 197},
        {15, 0x0a, 197},
        {24, 0x0a, 197},
        {31, 0x0a, 197},
        {41, 0x0a, 197},
        {56, 0x0b, 197},
        {3, 0x0a, 231},
        {6, 0x0a, 231},
        {10, 0x0a, 231},
        {15, 0x0a, 231},
        {24, 0x0a, 231},
        {31, 0x0a, 231},
        {41, 0x0a, 231},
        {56, 0x0b, 231},
    },
    /* 174 */
    {
        {2, 0x0a, 239},
        {9, 0x0a, 239},
        {23, 0x0a, 239},
        {40, 0x0b, 239},
        {1, 0x0a, 9},
        {22, 0x0b, 9},
        {1, 0x0a, 142},
        {22, 0x0b, 142},
        {1, 0x0a, 144},
        {22, 0x0b, 144},
        {1, 0x0a, 145},
        {22, 0x0b, 145},
        {1, 0x0a, 148},
        {22, 0x0b, 148},
        {1, 0x0a, 159},
        {22, 0x0b, 159},
    },
    /* 175 */
    {
        {3, 0x0a, 239},
        {6, 0x0a, 239},
        {10, 0x0a, 239},
        {15, 0x0a, 239},
        {24, 0x0a, 239},
        {31, 0x0a, 239},
        {41, 0x0a, 239},
        {56, 0x0b, 239},
        {2, 0x0a, 9},
        {9, 0x0a, 9},
        {23, 0x0a, 9},
        {40, 0x0b, 9},
        {2, 0x0a, 142},
        {9, 0x0a, 142},
        {23, 0x0a, 142},
        {40, 0x0b, 142},
    },
    /* 176 */
    {
        {3, 0x0a, 9},
        {6, 0x0a, 9},
        {10, 0x0a, 9},
        {15, 0x0a, 9},
        {24, 0x0a, 9},
        {31, 0x0a, 9},
        {41, 0x0a, 9},
        {56, 0x0b, 9},
        {3, 0x0a, 142},
        {6, 0x0a, 142},
        {10, 0x0a, 142},
        {15, 0x0a, 142},
        {24, 0x0a, 142},
        {31, 0x0a, 142},
        {41, 0x0a, 142},
        {56, 0x0b, 142},
    },
    /* 177 */
    {
        {2, 0x0a, 144},
        {9, 0x0a, 144},
        {23, 0x0a, 144},
        {40, 0x0b, 144},
        {2, 0x0a, 145},
        {9, 0x0a, 145},
        {23, 0x0a, 145},
        {40, 0x0b, 145},
        {2, 0x0a, 148},
        {9, 0x0a, 148},
        {23, 0x0a, 148},
        {40, 0x0b, 148},
        {2, 0x0a, 159},
        {9, 0x0a, 159},
        {23, 0x0a, 159},
        {40, 0x0b, 159},
    },
    /* 178 */
    {
        {3, 0x0a, 144},
        {6, 0x0a, 144},
        {10, 0x0a, 144},
        {15, 0x0a, 144},
        {24, 0x0a, 144},
        {31, 0x0a, 144},
        {41, 0x0a, 144},
        {56, 0x0b, 144},
        {3, 0x0a, 145},
        {6, 0x0a, 145},
        {10, 0x0a, 145},
        {15, 0x0a, 145},
        {24, 0x0a, 145},
        {31, 0x0a, 145},
        {41, 0x0a, 145},
        {56, 0x0b, 145},
    },
    /* 179 */
    {
        {3, 0x0a, 148},
        {6, 0x0a, 148},
        {10, 0x0a, 148},
        {15, 0x0a, 148},
        {24, 0x0a, 148},
        {31, 0x0a, 148},
        {41, 0x0a, 148},
        {56, 0x0b, 148},
        {3, 0x0a, 159},
        {6, 0x0a, 159},
        {10, 0x0a, 159},
        {15, 0x0a, 159},
        {24, 0x0a, 159},
        {31, 0x0a, 159},
        {41, 0x0a, 159},
        {56, 0x0b, 159},
    },
    /* 180 */
    {
        {0, 0x0b, 171},
        {0, 0x0b, 206},
        {0, 0x0b, 215},
        {0, 0x0b, 225},
        {0, 0x0b, 236},
        {0, 0x0b, 237},
        {188, 0x00, 0},
        {189, 0x00, 0},
        {193, 0x00, 0},
        {196, 0x00, 0},
        {200, 0x00, 0},
        {203, 0x00, 0},
        {209, 0x00, 0},
        {216, 0x00, 0},
        {224, 0x00, 0},
        {238, 0x00, 0},
    },
    /* 181 */
    {
        {1, 0x0a, 171},
        {22, 0x0b, 171},
        {1, 0x0a, 206},
        {22, 0x0b, 206},
        {1, 0x0a, 215},
        {22, 0x0b, 215},
        {1, 0x0a, 225},
        {22, 0x0b, 225},
        {1, 0x0a, 236},
        {22, 0x0b, 236},
        {1, 0x0a, 237},
        {22, 0x0b, 237},
        {0, 0x0b, 199},
        {0, 0x0b, 207},
        {0, 0x0b, 234},
        {0, 0x0b, 235},
    },
    /* 182 */
    {
        {2, 0x0a, 171},
        {9, 0x0a, 171},
        {23, 0x0a, 171},
        {40, 0x0b, 171},
        {2, 0x0a, 206},
        {9, 0x0a, 206},
        {23, 0x0a, 206},
        {40, 0x0b, 206},
        {2, 0x0a, 215},
        {9, 0x0a, 215},
        {23, 0x0a, 215},
        {40, 0x0b, 215},
        {2, 0x0a, 225},
        {9, 0x0a, 225},
        {23, 0x0a, 225},
        {40, 0x0b, 225},
    },
    /* 183 */
    {
        {3, 0x0a, 171},
        {6, 0x0a, 171},
        {10, 0x0a, 171},
        {15, 0x0a, 171},
        {24, 0x0a, 171},
        {31, 0x0a, 171},
        {41, 0x0a, 171},
        {56, 0x0b, 171},
        {3, 0x0a, 206},
        {6, 0x0a, 206},
        {10, 0x0a, 206},
        {15, 0x0a, 206},
        {24, 0x0a, 206},
        {31, 0x0a, 206},
        {41, 0x0a, 206},
        {56, 0x0b, 206},
    },
    /* 184 */
    {
        {3, 0x0a, 215},
        {6, 0x0a, 215},
        {10, 0x0a, 215},
        {15, 0x0a, 215},
        {24, 0x0a, 215},
        {31, 0x0a, 215},
        {41, 0x0a, 215},
        {56, 0x0b, 215},
        {3, 0x0a, 225},
        {6, 0x0a, 225},
        {10, 0x0a, 225},
        {15, 0x0a, 225},
        {24, 0x0a, 225},
        {31, 0x0a, 225},
        {41, 0x0a, 225},
        {56, 0x0b, 225},
    },
    /* 185 */
    {
        {2, 0x0a, 236},
        {9, 0x0a, 236},
        {23, 0x0a, 236},
        {40, 0x0b, 236},
        {2, 0x0a, 237},
        {9, 0x0a, 237},
        {23, 0x0a, 237},
        {40, 0x0b, 237},
        {1, 0x0a, 199},
        {22, 0x0b, 199},
        {1, 0x0a, 207},
        {22, 0x0b, 207},
        {1, 0x0a, 234},
        {22, 0x0b, 234},
        {1, 0x0a, 235},
        {22, 0x0b, 235},
    },
    /* 186 */
    {
        {3, 0x0a, 236},
        {6, 0x0a, 236},
        {10, 0x0a, 236},
        {15, 0x0a, 236},
        {24, 0x0a, 236},
        {31, 0x0a, 236},
        {41, 0x0a, 236},
        {56, 0x0b, 236},
        {3, 0x0a, 237},
        {6, 0x0a, 237},
        {10, 0x0a, 237},
        {15, 0x0a, 237},
        {24, 0x0a, 237},
        {31, 0x0a, 237},
        {41, 0x0a, 237},
        {56, 0x0b, 237},
    },
    /* 187 */
    {
        {2, 0x0a, 199},
        {9, 0x0a, 199},
        {23, 0x0a, 199},
        {40, 0x0b, 199},
        {2, 0x0a, 207},
        {9, 0x0a, 207},
        {23, 0x0a, 207},
        {40, 0x0b, 207},
        {2, 0x0a, 234},
        {9, 0x0a, 234},
        {23, 0x0a, 234},
        {40, 0x0b, 234},
        {2, 0x0a, 235},
        {9, 0x0a, 235},
        {23, 0x0a, 235},
        {40, 0x0b, 235},
    },
    /* 188 */
    {
        {3, 0x0a, 199},
        {6, 0x0a, 199},
        {10, 0x0a, 199},
        {15, 0x0a, 199},
        {24, 0x0a, 199},
        {31, 0x0a, 199},
        {41, 0x0a, 199},
        {56, 0x0b, 199},
        {3, 0x0a, 207},
        {6, 0x0a, 207},
        {10, 0x0a, 207},
        {15, 0x0a, 207},
        {24, 0x0a, 207},
        {31, 0x0a, 207},
        {41, 0x0a, 207},
        {56, 0x0b, 207},
    },
    /* 189 */
    {
        {3, 0x0a, 234},
        {6, 0x0a, 234},
        {10, 0x0a, 234},
        {15, 0x0a, 234},
        {24, 0x0a, 234},
        {31, 0x0a, 234},
        {41, 0x0a, 234},
        {56, 0x0b, 234},
        {3, 0x0a, 235},
        {6, 0x0a, 235},
        {10, 0x0a, 235},
        {15, 0x0a, 235},
        {24, 0x0a, 235},
        {31, 0x0a, 235},
        {41, 0x0a, 235},
        {56, 0x0b, 235},
    },
    /* 190 */
    {
        {194, 0x00, 0},
        {195, 0x00, 0},
        {197, 0x00, 0},
        {198, 0x00, 0},
        {201, 0x00, 0},
        {202, 0x00, 0},
        {204, 0x00, 0},
        {205, 0x00, 0},
        {210, 0x00, 0},
        {213, 0x00, 0},
        {217, 0x00, 0},
        {220, 0x00, 0},
        {225, 0x00, 0},
        {231, 0x00, 0},
        {239, 0x00, 0},
        {246, 0x00, 0},
    },
    /* 191 */
    {
        {0, 0x0b, 192},
        {0, 0x0b, 193},
        {0, 0x0b, 200},
        {0, 0x0b, 201},
        {0, 0x0b, 202},
        {0, 0x0b, 205},
        {0, 0x0b, 210},
        {0, 0x0b, 213},
        {0, 0x0b, 218},
        {0, 0x0b, 219},
        {0, 0x0b, 238},
        {0, 0x0b, 240},
        {0, 0x0b, 242},
        {0, 0x0b, 243},
        {0, 0x0b, 255},
        {206, 0x00, 0},
    },
    /* 192 */
    {
        {1, 0x0a, 192},
        {22, 0x0b, 192},
        {1, 0x0a, 193},
        {22, 0x0b, 193},
        {1, 0x0a, 200},
        {22, 0x0b, 200},
        {1, 0x0a, 201},
        {22, 0x0b, 201},
        {1, 0x0a, 202},
        {22, 0x0b, 202},
        {1, 0x0a, 205},
        {22, 0x0b, 205},
        {1, 0x0a, 210},
        {22, 0x0b, 210},
        {1, 0x0a, 213},
        {22, 0x0b, 213},
    },
    /* 193 */
    {
        {2, 0x0a, 192},
        {9, 0x0a, 192},
        {23, 0x0a, 192},
        {40, 0x0b, 192},
        {2, 0x0a, 193},
        {9, 0x0a, 193},
        {23, 0x0a, 193},
        {40, 0x0b, 193},
        {2, 0x0a, 200},
        {9, 0x0a, 200},
        {23, 0x0a, 200},
        {40, 0x0b, 200},
        {2, 0x0a, 201},
        {9, 0x0a, 201},
        {23, 0x0a, 201},
        {40, 0x0b, 201},
    },
    /* 194 */
    {
        {3, 0x0a, 192},
        {6, 0x0a, 192},
        {10, 0x0a, 192},
        {15, 0x0a, 192},
        {24, 0x0a, 192},
        {31, 0x0a, 192},
        {41, 0x0a, 192},
        {56, 0x0b, 192},
        {3, 0x0a, 193},
        {6, 0x0a, 193},
        {10, 0x0a, 193},
        {15, 0x0a, 193},
        {24, 0x0a, 193},
        {31, 0x0a, 193},
        {41, 0x0a, 193},
        {56, 0x0b, 193},
    },
    /* 195 */
    {
        {3, 0x0a, 200},
        {6, 0x0a, 200},
        {10, 0x0a, 200},
        {15, 0x0a, 200},
        {24, 0x0a, 200},
        {31, 0x0a, 200},
        {41, 0x0a, 200},
        {56, 0x0b, 200},
        {3, 0x0a, 201},
        {6, 0x0a, 201},
        {10, 0x0a, 201},
        {15, 0x0a, 201},
        {24, 0x0a, 201},
        {31, 0x0a, 201},
        {41, 0x0a, 201},
        {56, 0x0b, 201},
    },
    /* 196 */
    {
        {2, 0x0a, 202},
        {9, 0x0a, 202},
        {23, 0x0a, 202},
        {40, 0x0b, 202},
        {2, 0x0a, 205},
        {9, 0x0a, 205},
        {23, 0x0a, 205},
        {40, 0x0b, 205},
        {2, 0x0a, 210},
        {9, 0x0a, 210},
        {23, 0x0a, 210},
        {40, 0x0b, 210},
        {2, 0x0a, 213},
        {9, 0x0a, 213},
        {23, 0x0a, 213},
        {40, 0x0b, 213},
    },
    /* 197 */
    {
        {3, 0x0a, 202},
        {6, 0x0a, 202},
        {10, 0x0a, 202},
        {15, 0x0a, 202},
        {24, 0x0a, 202},
        {31, 0x0a, 202},
        {41, 0x0a, 202},
        {56, 0x0b, 202},
        {3, 0x0a, 205},
        {6, 0x0a, 205},
        {10, 0x0a, 205},
        {15, 0x0a, 205},
        {24, 0x0a, 205},
        {31, 0x0a, 205},
        {41, 0x0a, 205},
        {56, 0x0b, 205},
    },
    /* 198 */
    {
        {3, 0x0a, 210},
        {6, 0x0a, 210},
        {10, 0x0a, 210},
        {15, 0x0a, 210},
        {24, 0x0a, 210},
        {31, 0x0a, 210},
        {41, 0x0a, 210},
        {56, 0x0b, 210},
        {3, 0x0a, 213},
        {6, 0x0a, 213},
        {10, 0x0a, 213},
        {15, 0x0a, 213},
        {24, 0x0a, 213},
        {31, 0x0a, 213},
        {41, 0x0a, 213},
        {56, 0x0b, 213},
    },
    /* 199 */
    {
        {1, 0x0a, 218},
        {22, 0x0b, 218},
        {1, 0x0a, 219},
        {22, 0x0b, 219},
        {1, 0x0a, 238},
        {22, 0x0b, 238},
        {1, 0x0a, 240},
        {22, 0x0b, 240},
        {1, 0x0a, 242},
        {22, 0x0b, 242},
        {1, 0x0a, 243},
        {22, 0x0b, 243},
        {1, 0x0a, 255},
        {22, 0x0b, 255},
        {0, 0x0b, 203},
        {0, 0x0b, 204},
    },
    /* 200 */
    {
        {2, 0x0a, 218},
        {9, 0x0a, 218},
        {23, 0x0a, 218},
        {40, 0x0b, 218},
        {2, 0x0a, 219},
        {9, 0x0a, 219},
        {23, 0x0a, 219},
        {40, 0x0b, 219},
        {2, 0x0a, 238},
        {9, 0x0a, 238},
        {23, 0x0a, 238},
        {40, 0x0b, 238},
        {2, 0x0a, 240},
        {9, 0x0a, 240},
        {23, 0x0a, 240},
        {40, 0x0b, 240},
    },
    /* 201 */
    {
        {3, 0x0a, 218},
        {6, 0x0a, 218},
        {10, 0x0a, 218},
        {15, 0x0a, 218},
        {24, 0x0a, 218},
        {31, 0x0a, 218},
        {41, 0x0a, 218},
        {56, 0x0b, 218},
        {3, 0x0a, 219},
        {6, 0x0a, 219},
        {10, 0x0a, 219},
        {15, 0x0a, 219},
        {24, 0x0a, 219},
        {31, 0x0a, 219},
        {41, 0x0a, 219},
        {56, 0x0b, 219},
    },
    /* 202 */
    {
        {3, 0x0a, 238},
        {6, 0x0a, 238},
        {10, 0x0a, 238},
        {15, 0x0a, 238},
        {24, 0x0a, 238},
        {31, 0x0a, 238},
        {41, 0x0a, 238},
        {56, 0x0b, 238},
        {3, 0x0a, 240},
        {6, 0x0a, 240},
        {10, 0x0a, 240},
        {15, 0x0a, 240},
        {24, 0x0a, 240},
        {31, 0x0a, 240},
        {41, 0x0a, 240},
        {56, 0x0b, 240},
    },
    /* 203 */
    {
        {2, 0x0a, 242},
        {9, 0x0a, 242},
        {23, 0x0a, 242},
        {40, 0x0b, 242},
        {2, 0x0a, 243},
        {9, 0x0a, 243},
        {23, 0x0a, 243},
        {40, 0x0b, 243},
        {2, 0x0a, 255},
        {9, 0x0a, 255},
        {23, 0x0a, 255},
        {40, 0x0b, 255},
        {1, 0x0a, 203},
        {22, 0x0b, 203},
        {1, 0x0a, 204},
        {22, 0x0b, 204},
    },
    /* 204 */
    {
        {3, 0x0a, 242},
        {6, 0x0a, 242},
        {10, 0x0a, 242},
        {15, 0x0a, 242},
        {24, 0x0a, 242},
        {31, 0x0a, 242},
        {41, 0x0a, 242},
        {56, 0x0b, 242},
        {3, 0x0a, 243},
        {6, 0x0a, 243},
        {10, 0x0a, 243},
        {15, 0x0a, 243},
        {24, 0x0a, 243},
        {31, 0x0a, 243},
        {41, 0x0a, 243},
        {56, 0x0b, 243},
    },
    /* 205 */
    {
        {3, 0x0a, 255},
        {6, 0x0a, 255},
        {10, 0x0a, 255},
        {15, 0x0a, 255},
        {24, 0x0a, 255},
        {31, 0x0a, 255},
        {41, 0x0a, 255},
        {56, 0x0b, 255},
        {2, 0x0a, 203},
        {9, 0x0a, 203},
        {23, 0x0a, 203},
        {40, 0x0b, 203},
        {2, 0x0a, 204},
        {9, 0x0a, 204},
        {23, 0x0a, 204},
        {40, 0x0b, 204},
    },
    /* 206 */
    {
        {3, 0x0a, 203},
        {6, 0x0a, 203},
        {10, 0x0a, 203},
        {15, 0x0a, 203},
        {24, 0x0a, 203},
        {31, 0x0a, 203},
        {41, 0x0a, 203},
        {56, 0x0b, 203},
        {3, 0x0a, 204},
        {6, 0x0a, 204},
        {10, 0x0a, 204},
        {15, 0x0a, 204},
        {24, 0x0a, 204},
        {31, 0x0a, 204},
        {41, 0x0a, 204},
        {56, 0x0b, 204},
    },
    /* 207 */
    {
        {211, 0x00, 0},
        {212, 0x00, 0},
        {214, 0x00, 0},
        {215, 0x00, 0},
        {218, 0x00, 0},
        {219, 0x00, 0},
        {221, 0x00, 0},
        {222, 0x00, 0},
        {226, 0x00, 0},
        {228, 0x00, 0},
        {232, 0x00, 0},
        {235, 0x00, 0},
        {240, 0x00, 0},
        {243, 0x00, 0},
        {247, 0x00, 0},
        {250, 0x00, 0},
    },
    /* 208 */
    {
        {0, 0x0b, 211},
        {0, 0x0b, 212},
        {0, 0x0b, 214},
        {0, 0x0b, 221},
        {0, 0x0b, 222},
        {0, 0x0b, 223},
        {0, 0x0b, 241},
        {0, 0x0b, 244},
        {0, 0x0b, 245},
        {0, 0x0b, 246},
        {0, 0x0b, 247},
        {0, 0x0b, 248},
        {0, 0x0b, 250},
        {0, 0x0b, 251},
        {0, 0x0b, 252},
        {0, 0x0b, 253},
    },
    /* 209 */
    {
        {1, 0x0a, 211},
        {22, 0x0b, 211},
        {1, 0x0a, 212},
        {22, 0x0b, 212},
        {1, 0x0a, 214},
        {22, 0x0b, 214},
        {1, 0x0a, 221},
        {22, 0x0b, 221},
        {1, 0x0a, 222},
        {22, 0x0b, 222},
        {1, 0x0a, 223},
        {22, 0x0b, 223},
        {1, 0x0a, 241},
        {22, 0x0b, 241},
        {1, 0x0a, 244},
        {22, 0x0b, 244},
    },
    /* 210 */
    {
        {2, 0x0a, 211},
        {9, 0x0a, 211},
        {23, 0x0a, 211},
        {40, 0x0b, 211},
        {2, 0x0a, 212},
        {9, 0x0a, 212},
        {23, 0x0a, 212},
        {40, 0x0b, 212},
        {2, 0x0a, 214},
        {9, 0x0a, 214},
        {23, 0x0a, 214},
        {40, 0x0b, 214},
        {2, 0x0a, 221},
        {9, 0x0a, 221},
        {23, 0x0a, 221},
        {40, 0x0b, 221},
    },
    /* 211 */
    {
        {3, 0x0a, 211},
        {6, 0x0a, 211},
        {10, 0x0a, 211},
        {15, 0x0a, 211},
        {24, 0x0a, 211},
        {31, 0x0a, 211},
        {41, 0x0a, 211},
        {56, 0x0b, 211},
        {3, 0x0a, 212},
        {6, 0x0a, 212},
        {10, 0x0a, 212},
        {15, 0x0a, 212},
        {24, 0x0a, 212},
        {31, 0x0a, 212},
        {41, 0x0a, 212},
        {56, 0x0b, 212},
    },
    /* 212 */
    {
        {3, 0x0a, 214},
        {6, 0x0a, 214},
        {10, 0x0a, 214},
        {15, 0x0a, 214},
        {24, 0x0a, 214},
        {31, 0x0a, 214},
        {41, 0x0a, 214},
        {56, 0x0b, 214},
        {3, 0x0a, 221},
        {6, 0x0a, 221},
        {10, 0x0a, 221},
        {15, 0x0a, 221},
        {24, 0x0a, 221},
        {31, 0x0a, 221},
        {41, 0x0a, 221},
        {56, 0x0b, 221},
    },
    /* 213 */
    {
        {2, 0x0a, 222},
        {9, 0x0a, 222},
        {23, 0x0a, 222},
        {40, 0x0b, 222},
        {2, 0x0a, 223},
        {9, 0x0a, 223},
        {23, 0x0a, 223},
        {40, 0x0b, 223},
        {2, 0x0a, 241},
        {9, 0x0a, 241},
        {23, 0x0a, 241},
        {40, 0x0b, 241},
        {2, 0x0a, 244},
        {9, 0x0a, 244},
        {23, 0x0a, 244},
        {40, 0x0b, 244},
    },
    /* 214 */
    {
        {3, 0x0a, 222},
        {6, 0x0a, 222},
        {10, 0x0a, 222},
        {15, 0x0a, 222},
        {24, 0x0a, 222},
        {31, 0x0a, 222},
        {41, 0x0a, 222},
        {56, 0x0b, 222},
        {3, 0x0a, 223},
        {6, 0x0a, 223},
        {10, 0x0a, 223},
        {15, 0x0a, 223},
        {24, 0x0a, 223},
        {31, 0x0a, 223},
        {41, 0x0a, 223},
        {56, 0x0b, 223},
    },
    /* 215 */
    {
        {3, 0x0a, 241},
        {6, 0x0a, 241},
        {10, 0x0a, 241},
        {15, 0x0a, 241},
        {24, 0x0a, 241},
        {31, 0x0a, 241},
        {41, 0x0a, 241},
        {56, 0x0b, 241},
        {3, 0x0a, 244},
        {6, 0x0a, 244},
        {10, 0x0a, 244},
        {15, 0x0a, 244},
        {24, 0x0a, 244},
        {31, 0x0a, 244},
        {41, 0x0a, 244},
        {56, 0x0b, 244},
    },
    /* 216 */
    {
        {1, 0x0a, 245},
        {22, 0x0b, 245},
        {1, 0x0a, 246},
        {22, 0x0b, 246},
        {1, 0x0a, 247},
        {22, 0x0b, 247},
        {1, 0x0a, 248},
        {22, 0x0b, 248},
        {1, 0x0a, 250},
        {22, 0x0b, 250},
        {1, 0x0a, 251},
        {22, 0x0b, 251},
        {1, 0x0a, 252},
        {22, 0x0b, 252},
        {1, 0x0a, 253},
        {22, 0x0b, 253},
    },
    /* 217 */
    {
        {2, 0x0a, 245},
        {9, 0x0a, 245},
        {23, 0x0a, 245},
        {40, 0x0b, 245},
        {2, 0x0a, 246},
        {9, 0x0a, 246},
        {23, 0x0a, 246},
        {40, 0x0b, 246},
        {2, 0x0a, 247},
        {9, 0x0a, 247},
        {23, 0x0a, 247},
        {40, 0x0b, 247},
        {2, 0x0a, 248},
        {9, 0x0a, 248},
        {23, 0x0a, 248},
        {40, 0x0b, 248},
    },
    /* 218 */
    {
        {3, 0x0a, 245},
        {6, 0x0a, 245},
        {10, 0x0a, 245},
        {15, 0x0a, 245},
        {24, 0x0a, 245},
        {31, 0x0a, 245},
        {41, 0x0a, 245},
        {56, 0x0b, 245},
        {3, 0x0a, 246},
        {6, 0x0a, 246},
        {10, 0x0a, 246},
        {15, 0x0a, 246},
        {24, 0x0a, 246},
        {31, 0x0a, 246},
        {41, 0x0a, 246},
        {56, 0x0b, 246},
    },
    /* 219 */
    {
        {3, 0x0a, 247},
        {6, 0x0a, 247},
        {10, 0x0a, 247},
        {15, 0x0a, 247},
        {24, 0x0a, 247},
        {31, 0x0a, 247},
        {41, 0x0a, 247},
        {56, 0x0b, 247},
        {3, 0x0a, 248},
        {6, 0x0a, 248},
        {10, 0x0a, 248},
        {15, 0x0a, 248},
        {24, 0x0a, 248},
        {31, 0x0a, 248},
        {41, 0x0a, 248},
        {56, 0x0b, 248},
    },
    /* 220 */
    {
        {2, 0x0a, 250},
        {9, 0x0a, 250},
        {23, 0x0a, 250},
        {40, 0x0b, 250},
        {2, 0x0a, 251},
        {9, 0x0a, 251},
        {23, 0x0a, 251},
        {40, 0x0b, 251},
        {2, 0x0a, 252},
        {9, 0x0a, 252},
        {23, 0x0a, 252},
        {40, 0x0b, 252},
        {2, 0x0a, 253},
        {9, 0x0a, 253},
        {23, 0x0a, 253},
        {40, 0x0b, 253},
    },
    /* 221 */
    {
        {3, 0x0a, 250},
        {6, 0x0a, 250},
        {10, 0x0a, 250},
        {15, 0x0a, 250},
        {24, 0x0a, 250},
        {31, 0x0a, 250},
        {41, 0x0a, 250},
        {56, 0x0b, 250},
        {3, 0x0a, 251},
        {6, 0x0a, 251},
        {10, 0x0a, 251},
        {15, 0x0a, 251},
        {24, 0x0a, 251},
        {31, 0x0a, 251},
        {41, 0x0a, 251},
        {56, 0x0b, 251},
    },
    /* 222 */
    {
        {3, 0x0a, 252},
        {6, 0x0a, 252},
        {10, 0x0a, 252},
        {15, 0x0a, 252},
        {24, 0x0a, 252},
        {31, 0x0a, 252},
        {41, 0x0a, 252},
        {56, 0x0b, 252},
        {3, 0x0a, 253},
        {6, 0x0a, 253},
        {10, 0x0a, 253},
        {15, 0x0a, 253},
        {24, 0x0a, 253},
        {31, 0x0a, 253},
        {41, 0x0a, 253},
        {56, 0x0b, 253},
    },
    /* 223 */
    {
        {0, 0x0b, 254},
        {227, 0x00, 0},
        {229, 0x00, 0},
        {230, 0x00, 0},
        {233, 0x00, 0},
        {234, 0x00, 0},
        {236, 0x00, 0},
        {237, 0x00, 0},
        {241, 0x00, 0},
        {242, 0x00, 0},
        {244, 0x00, 0},
        {245, 0x00, 0},
        {248, 0x00, 0},
        {249, 0x00, 0},
        {251, 0x00, 0},
        {252, 0x00, 0},
    },
    /* 224 */
    {
        {1, 0x0a, 254},
        {22, 0x0b, 254},
        {0, 0x1b, 2},
        {0, 0x1b, 3},
        {0, 0x1b, 4},
        {0, 0x1b, 5},
        {0, 0x1b, 6},
        {0, 0x1b, 7},
        {0, 0x1b, 8},
        {0, 0x1b, 11},
        {0, 0x1b, 12},
        {0, 0x1b, 14},
        {0, 0x1b, 15},
        {0, 0x1b, 16},
        {0, 0x1b, 17},
        {0, 0x1b, 18},
    },
    /* 225 */
    {
        {2, 0x0a, 254},
        {9, 0x0a, 254},
        {23, 0x0a, 254},
        {40, 0x0b, 254},
        {1, 0x1a, 2},
        {22, 0x1b, 2},
        {1, 0x1a, 3},
        {22, 0x1b, 3},
        {1, 0x1a, 4},
        {22, 0x1b, 4},
        {1, 0x1a, 5},
        {22, 0x1b, 5},
        {1, 0x1a, 6},
        {22, 0x1b, 6},
        {1, 0x1a, 7},
        {22, 0x1b, 7},
    },
    /* 226 */
    {
        {3, 0x0a, 254},
        {6, 0x0a, 254},
        {10, 0x0a, 254},
        {15, 0x0a, 254},
        {24, 0x0a, 254},
        {31, 0x0a, 254},
        {41, 0x0a, 254},
        {56, 0x0b, 254},
        {2, 0x1a, 2},
        {9, 0x1a, 2},
        {23, 0x1a, 2},
        {40, 0x1b, 2},
        {2, 0x1a, 3},
        {9, 0x1a, 3},
        {23, 0x1a, 3},
        {40, 0x1b, 3},
    },
    /* 227 */
    {
        {3, 0x1a, 2},
        {6, 0x1a, 2},
        {10, 0x1a, 2},
        {15, 0x1a, 2},
        {24, 0x1a, 2},
        {31, 0x1a, 2},
        {41, 0x1a, 2},
        {56, 0x1b, 2},
        {3, 0x1a, 3},
        {6, 0x1a, 3},
        {10, 0x1a, 3},
        {15, 0x1a, 3},
        {24, 0x1a, 3},
        {31, 0x1a, 3},
        {41, 0x1a, 3},
        {56, 0x1b, 3},
    },
    /* 228 */
    {
        {2, 0x1a, 4},
        {9, 0x1a, 4},
        {23, 0x1a, 4},
        {40, 0x1b, 4},
        {2, 0x1a, 5},
        {9, 0x1a, 5},
        {23, 0x1a, 5},
        {40, 0x1b, 5},
        {2, 0x1a, 6},
        {9, 0x1a, 6},
        {23, 0x1a, 6},
        {40, 0x1b, 6},
        {2, 0x1a, 7},
        {9, 0x1a, 7},
        {23, 0x1a, 7},
        {40, 0x1b, 7},
    },
    /* 229 */
    {
        {3, 0x1a, 4},
        {6, 0x1a, 4},
        {10, 0x1a, 4},
        {15, 0x1a, 4},
        {24, 0x1a, 4},
        {31, 0x1a, 4},
        {41, 0x1a, 4},
        {56, 0x1b, 4},
        {3, 0x1a, 5},
        {6, 0x1a, 5},
        {10, 0x1a, 5},
        {15, 0x1a, 5},
        {24, 0x1a, 5},
        {31, 0x1a, 5},
        {41, 0x1a, 5},
        {56, 0x1b, 5},
    },
    /* 230 */
    {
        {3, 0x1a, 6},
        {6, 0x1a, 6},
        {10, 0x1a, 6},
        {15, 0x1a, 6},
        {24, 0x1a, 6},
        {31, 0x1a, 6},
        {41, 0x1a, 6},
        {56, 0x1b, 6},
        {3, 0x1a, 7},
        {6, 0x1a, 7},
        {10, 0x1a, 7},
        {15, 0x1a, 7},
        {24, 0x1a, 7},
        {31, 0x1a, 7},
        {41, 0x1a, 7},
        {56, 0x1b, 7},
    },
    /* 231 */
    {
        {1, 0x1a, 8},
        {22, 0x1b, 8},
        {1, 0x1a, 11},
        {22, 0x1b, 11},
        {1, 0x1a, 12},
        {22, 0x1b, 12},
        {1, 0x1a, 14},
        {22, 0x1b, 14},
        {1, 0x1a, 15},
        {22, 0x1b, 15},
        {1, 0x1a, 16},
        {22, 0x1b, 16},
        {1, 0x1a, 17},
        {22, 0x1b, 17},
        {1, 0x1a, 18},
        {22, 0x1b, 18},
    },
    /* 232 */
    {
        {2, 0x1a, 8},
        {9, 0x1a, 8},
        {23, 0x1a, 8},
        {40, 0x1b, 8},
        {2, 0x1a, 11},
        {9, 0x1a, 11},
        {23, 0x1a, 11},
        {40, 0x1b, 11},
        {2, 0x1a, 12},
        {9, 0x1a, 12},
        {23, 0x1a, 12},
        {40, 0x1b, 12},
        {2, 0x1a, 14},
        {9, 0x1a, 14},
        {23, 0x1a, 14},
        {40, 0x1b, 14},
    },
    /* 233 */
    {
        {3, 0x1a, 8},
        {6, 0x1a, 8},
        {10, 0x1a, 8},
        {15, 0x1a, 8},
        {24, 0x1a, 8},
        {31, 0x1a, 8},
        {41, 0x1a, 8},
        {56, 0x1b, 8},
        {3, 0x1a, 11},
        {6, 0x1a, 11},
        {10, 0x1a, 11},
        {15, 0x1a, 11},
        {24, 0x1a, 11},
        {31, 0x1a, 11},
        {41, 0x1a, 11},
        {56, 0x1b, 11},
    },
    /* 234 */
    {
        {3, 0x1a, 12},
        {6, 0x1a, 12},
        {10, 0x1a, 12},
        {15, 0x1a, 12},
        {24, 0x1a, 12},
        {31, 0x1a, 12},
        {41, 0x1a, 12},
        {56, 0x1b, 12},
        {3, 0x1a, 14},
        {6, 0x1a, 14},
        {10, 0x1a, 14},
        {15, 0x1a, 14},
        {24, 0x1a, 14},
        {31, 0x1a, 14},
        {41, 0x1a, 14},
        {56, 0x1b, 14},
    },
    /* 235 */
    {
        {2, 0x1a, 15},
        {9, 0x1a, 15},
        {23, 0x1a, 15},
        {40, 0x1b, 15},
        {2, 0x1a, 16},
        {9, 0x1a, 16},
        {23, 0x1a, 16},
        {40, 0x1b, 16},
        {2, 0x1a, 17},
        {9, 0x1a, 17},
        {23, 0x1a, 17},
        {40, 0x1b, 17},
        {2, 0x1a, 18},
        {9, 0x1a, 18},
        {23, 0x1a, 18},
        {40, 0x1b, 18},
    },
    /* 236 */
    {
        {3, 0x1a, 15},
        {6, 0x1a, 15},
        {10, 0x1a, 15},
        {15, 0x1a, 15},
        {24, 0x1a, 15},
        {31, 0x1a, 15},
        {41, 0x1a, 15},
        {56, 0x1b, 15},
        {3, 0x1a, 16},
        {6, 0x1a, 16},
        {10, 0x1a, 16},
        {15, 0x1a, 16},
        {24, 0x1a, 16},
        {31, 0x1a, 16},
        {41, 0x1a, 16},
        {56, 0x1b, 16},
    },
    /* 237 */
    {
        {3, 0x1a, 17},
        {6, 0x1a, 17},
        {10, 0x1a, 17},
        {15, 0x1a, 17},
        {24, 0x1a, 17},
        {31, 0x1a, 17},
        {41, 0x1a, 17},
        {56, 0x1b, 17},
        {3, 0x1a, 18},
        {6, 0x1a, 18},
        {10, 0x1a, 18},
        {15, 0x1a, 18},
        {24, 0x1a, 18},
        {31, 0x1a, 18},
        {41, 0x1a, 18},
        {56, 0x1b, 18},
    },
    /* 238 */
    {
        {0, 0x1b, 19},
        {0, 0x1b, 20},
        {0, 0x1b, 21},
        {0, 0x1b, 23},
        {0, 0x1b, 24},
        {0, 0x1b, 25},
        {0, 0x1b, 26},
        {0, 0x1b, 27},
        {0, 0x1b, 28},
        {0, 0x1b, 29},
        {0, 0x1b, 30},
        {0, 0x1b, 31},
        {0, 0x1b, 127},
        {0, 0x0b, 220},
        {0, 0x0b, 249},
        {253, 0x00, 0},
    },
    /* 239 */
    {
        {1, 0x1a, 19},
        {22, 0x1b, 19},
        {1, 0x1a, 20},
        {22, 0x1b, 20},
        {1, 0x1a, 21},
        {22, 0x1b, 21},
        {1, 0x1a, 23},
        {22, 0x1b, 23},
        {1, 0x1a, 24},
        {22, 0x1b, 24},
        {1, 0x1a, 25},
        {22, 0x1b, 25},
        {1, 0x1a, 26},
        {22, 0x1b, 26},
        {1, 0x1a, 27},
        {22, 0x1b, 27},
    },
    /* 240 */
    {
        {2, 0x1a, 19},
        {9, 0x1a, 19},
        {23, 0x1a, 19},
        {40, 0x1b, 19},
        {2, 0x1a, 20},
        {9, 0x1a, 20},
        {23, 0x1a, 20},
        {40, 0x1b, 20},
        {2, 0x1a, 21},
        {9, 0x1a, 21},
        {23, 0x1a, 21},
        {40, 0x1b, 21},
        {2, 0x1a, 23},
        {9, 0x1a, 23},
        {23, 0x1a, 23},
        {40, 0x1b, 23},
    },
    /* 241 */
    {
        {3, 0x1a, 19},
        {6, 0x1a, 19},
        {10, 0x1a, 19},
        {15, 0x1a, 19},
        {24, 0x1a, 19},
        {31, 0x1a, 19},
        {41, 0x1a, 19},
        {56, 0x1b, 19},
        {3, 0x1a, 20},
        {6, 0x1a, 20},
        {10, 0x1a, 20},
        {15, 0x1a, 20},
        {24, 0x1a, 20},
        {31, 0x1a, 20},
        {41, 0x1a, 20},
        {56, 0x1b, 20},
    },
    /* 242 */
    {
        {3, 0x1a, 21},
        {6, 0x1a, 21},
        {10, 0x1a, 21},
        {15, 0x1a, 21},
        {24, 0x1a, 21},
        {31, 0x1a, 21},
        {41, 0x1a, 21},
        {56, 0x1b, 21},
        {3, 0x1a, 23},
        {6, 0x1a, 23},
        {10, 0x1a, 23},
        {15, 0x1a, 23},
        {24, 0x1a, 23},
        {31, 0x1a, 23},
        {41, 0x1a, 23},
        {56, 0x1b, 23},
    },
    /* 243 */
    {
        {2, 0x1a, 24},
        {9, 0x1a, 24},
        {23, 0x1a, 24},
        {40, 0x1b, 24},
        {2, 0x1a, 25},
        {9, 0x1a, 25},
        {23, 0x1a, 25},
        {40, 0x1b, 25},
        {2, 0x1a, 26},
        {9, 0x1a, 26},
        {23, 0x1a, 26},
        {40, 0x1b, 26},
        {2, 0x1a, 27},
        {9, 0x1a, 27},
        {23, 0x1a, 27},
        {40, 0x1b, 27},
    },
    /* 244 */
    {
        {3, 0x1a, 24},
        {6, 0x1a, 24},
        {10, 0x1a, 24},
        {15, 0x1a, 24},
        {24, 0x1a, 24},
        {31, 0x1a, 24},
        {41, 0x1a, 24},
        {56, 0x1b, 24},
        {3, 0x1a, 25},
        {6, 0x1a, 25},
        {10, 0x1a, 25},
        {15, 0x1a, 25},
        {24, 0x1a, 25},
        {31, 0x1a, 25},
        {41, 0x1a, 25},
        {56, 0x1b, 25},
    },
    /* 245 */
    {
        {3, 0x1a, 26},
        {6, 0x1a, 26},
        {10, 0x1a, 26},
        {15, 0x1a, 26},
        {24, 0x1a, 26},
        {31, 0x1a, 26},
        {41, 0x1a, 26},
        {56, 0x1b, 26},
        {3, 0x1a, 27},
        {6, 0x1a, 27},
        {10, 0x1a, 27},
        {15, 0x1a, 27},
        {24, 0x1a, 27},
        {31, 0x1a, 27},
        {41, 0x1a, 27},
        {56, 0x1b, 27},
    },
    /* 246 */
    {
        {1, 0x1a, 28},
        {22, 0x1b, 28},
        {1, 0x1a, 29},
        {22, 0x1b, 29},
        {1, 0x1a, 30},
        {22, 0x1b, 30},
        {1, 0x1a, 31},
        {22, 0x1b, 31},
        {1, 0x1a, 127},
        {22, 0x1b, 127},
        {1, 0x0a, 220},
        {22, 0x0b, 220},
        {1, 0x0a, 249},
        {22, 0x0b, 249},
        {254, 0x00, 0},
        {255, 0x00, 0},
    },
    /* 247 */
    {
        {2, 0x1a, 28},
        {9, 0x1a, 28},
        {23, 0x1a, 28},
        {40, 0x1b, 28},
        {2, 0x1a, 29},
        {9, 0x1a, 29},
        {23, 0x1a, 29},
        {40, 0x1b, 29},
        {2, 0x1a, 30},
        {9, 0x1a, 30},
        {23, 0x1a, 30},
        {40, 0x1b, 30},
        {2, 0x1a, 31},
        {9, 0x1a, 31},
        {23, 0x1a, 31},
        {40, 0x1b, 31},
    },
    /* 248 */
    {
        {3, 0x1a, 28},
        {6, 0x1a, 28},
        {10, 0x1a, 28},
        {15, 0x1a, 28},
        {24, 0x1a, 28},
        {31, 0x1a, 28},
        {41, 0x1a, 28},
        {56, 0x1b, 28},
        {3, 0x1a, 29},
        {6, 0x1a, 29},
        {10, 0x1a, 29},
        {15, 0x1a, 29},
        {24, 0x1a, 29},
        {31, 0x1a, 29},
        {41, 0x1a, 29},
        {56, 0x1b, 29},
    },
    /* 249 */
    {
        {3, 0x1a, 30},
        {6, 0x1a, 30},
        {10, 0x1a, 30},
        {15, 0x1a, 30},
        {24, 0x1a, 30},
        {31, 0x1a, 30},
        {41, 0x1a, 30},
        {56, 0x1b, 30},
        {3, 0x1a, 31},
        {6, 0x1a, 31},
        {10, 0x1a, 31},
        {15, 0x1a, 31},
        {24, 0x1a, 31},
        {31, 0x1a, 31},
        {41, 0x1a, 31},
        {56, 0x1b, 31},
    },
    /* 250 */
    {
        {2, 0x1a, 127},
        {9, 0x1a, 127},
        {23, 0x1a, 127},
        {40, 0x1b, 127},
        {2, 0x0a, 220},
        {9, 0x0a, 220},
        {23, 0x0a, 220},
        {40, 0x0b, 220},
        {2, 0x0a, 249},
        {9, 0x0a, 249},
        {23, 0x0a, 249},
        {40, 0x0b, 249},
        {0, 0x1b, 10},
        {0, 0x1b, 13},
        {0, 0x1b, 22},
        {0, 0x04, 0},
    },
    /* 251 */
    {
        {3, 0x1a, 127},
        {6, 0x1a, 127},
        {10, 0x1a, 127},
        {15, 0x1a, 127},
        {24, 0x1a, 127},
        {31, 0x1a, 127},
        {41, 0x1a, 127},
        {56, 0x1b, 127},
        {3, 0x0a, 220},
        {6, 0x0a, 220},
        {10, 0x0a, 220},
        {15, 0x0a, 220},
        {24, 0x0a, 220},
        {31, 0x0a, 220},
        {41, 0x0a, 220},
        {56, 0x0b, 220},
    },
    /* 252 */
    {
        {3, 0x0a, 249},
        {6, 0x0a, 249},
        {10, 0x0a, 249},
        {15, 0x0a, 249},
        {24, 0x0a, 249},
        {31, 0x0a, 249},
        {41, 0x0a, 249},
        {56, 0x0b, 249},
        {1, 0x1a, 10},
        {22, 0x1b, 10},
        {1, 0x1a, 13},
        {22, 0x1b, 13},
        {1, 0x1a, 22},
        {22, 0x1b, 22},
        {0, 0x04, 0},
        {0, 0x04, 0},
    },
    /* 253 */
    {
        {2, 0x1a, 10},
        {9, 0x1a, 10},
        {23, 0x1a, 10},
        {40, 0x1b, 10},
        {2, 0x1a, 13},
        {9, 0x1a, 13},
        {23, 0x1a, 13},
        {40, 0x1b, 13},
        {2, 0x1a, 22},
        {9, 0x1a, 22},
        {23, 0x1a, 22},
        {40, 0x1b, 22},
        {0, 0x04, 0},
        {0, 0x04, 0},
        {0, 0x04, 0},
        {0, 0x04, 0},
    },
    /* 254 */
    {
        {3, 0x1a, 10},
        {6, 0x1a, 10},
        {10, 0x1a, 10},
        {15, 0x1a, 10},
        {24, 0x1a, 10},
        {31, 0x1a, 10},
        {41, 0x1a, 10},
        {56, 0x1b, 10},
        {3, 0x1a, 13},
        {6, 0x1a, 13},
        {10, 0x1a, 13},
        {15, 0x1a, 13},
        {24, 0x1a, 13},
        {31, 0x1a, 13},
        {41, 0x1a, 13},
        {56, 0x1b, 13},
    },
    /* 255 */
    {
        {3, 0x1a, 22},
        {6, 0x1a, 22},
        {10, 0x1a, 22},
        {15, 0x1a, 22},
        {24, 0x1a, 22},
        {31, 0x1a, 22},
        {41, 0x1a, 22},
        {56, 0x1b, 22},
        {0, 0x04, 0},
        {0, 0x04, 0},
        {0, 0x04, 0},
        {0, 0x04, 0},
        {0, 0x04, 0},
        {0, 0x04, 0},
        {0, 0x04, 0},
        {0, 0x04, 0},
    },
};
