/*
 * Decompiled with CFR 0.152.
 */
package jarinstaller.gui;

import jarinstaller.gui.FileUtil;
import jarinstaller.gui.StepPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class InputDirPanel
extends StepPanel
implements ActionListener {
    private Hashtable gp;
    private String info;
    private String text;
    private String inputValue = "";
    private String resultkey;
    private JPanel inputPanel = new JPanel();
    private JButton btnBrowse = new JButton();
    private JTextField textInput = new JTextField();
    private JLabel lblInfo = new JLabel();
    private JTextArea textArea = new JTextArea();
    private TitledBorder titledBorder = new TitledBorder("");
    JFileChooser jfc;
    FileUtil fu;
    Vector resultdirs;
    String destdir = "";
    String fcdir = null;
    public static final String TMP_FILE = "enyk.tmp";

    public InputDirPanel(Hashtable params) {
        this.gp = params;
        try {
            this.initDataStore();
            this.createElements();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initDataStore() {
        if (this.gp.containsKey("parameter.option.install.dirlist")) {
            this.resultdirs = (Vector)this.gp.get("parameter.option.install.dirlist");
        } else {
            this.resultdirs = new Vector();
            this.gp.put("parameter.option.install.dirlist", this.resultdirs);
        }
    }

    public void createElements() throws Exception {
        this.fu = new FileUtil();
        this.textArea.setEditable(false);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textArea.setOpaque(false);
        this.textArea.setFont((Font)this.gp.get("gui.font.msg"));
        this.setBackground(SystemColor.control);
        this.btnBrowse.setOpaque(false);
        this.btnBrowse.addActionListener(this);
        this.btnBrowse.setForeground((Color)this.gp.get("gui.color.fgrnd"));
        this.btnBrowse.setText((String)this.gp.get("btn.text.browse"));
        this.textInput.setColumns(5);
        this.inputPanel.setOpaque(false);
        this.titledBorder.setTitle((String)this.gp.get("file.browser.border.title"));
        this.titledBorder.setTitleFont((Font)this.gp.get("gui.font.msg"));
        EtchedBorder border = new EtchedBorder();
        this.titledBorder.setBorder(border);
        this.inputPanel.setBorder(this.titledBorder);
        this.lblInfo.setFont((Font)this.gp.get("gui.font.msg"));
        this.setLayout(new GridBagLayout());
        this.inputPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridbag = new GridBagConstraints();
        gridbag.gridx = 0;
        gridbag.gridy = 0;
        gridbag.gridwidth = 1;
        gridbag.gridheight = 1;
        gridbag.weightx = 0.0;
        gridbag.weighty = 0.0;
        gridbag.anchor = 17;
        gridbag.fill = 0;
        gridbag.insets = new Insets(0, 20, 0, 10);
        this.add((Component)this.lblInfo, gridbag);
        gridbag.gridy = 1;
        gridbag.weightx = 1.0;
        gridbag.weighty = 1.0;
        gridbag.anchor = 10;
        gridbag.fill = 1;
        gridbag.insets = new Insets(5, 20, 5, 5);
        this.textArea.setPreferredSize(new Dimension(20, 100));
        this.add((Component)this.textArea, gridbag);
        gridbag.gridy = 2;
        gridbag.weighty = 0.0;
        gridbag.gridwidth = 2;
        gridbag.fill = 2;
        gridbag.insets = new Insets(5, 10, 10, 5);
        this.add((Component)this.inputPanel, gridbag);
        gridbag.gridx = 0;
        gridbag.gridy = 0;
        gridbag.gridwidth = 1;
        gridbag.gridheight = 1;
        gridbag.weightx = 1.0;
        gridbag.weighty = 0.0;
        gridbag.anchor = 10;
        gridbag.fill = 2;
        gridbag.insets = new Insets(5, 5, 5, 5);
        this.inputPanel.add((Component)this.textInput, gridbag);
        gridbag.gridx = 1;
        gridbag.weightx = 0.0;
        gridbag.fill = 2;
        gridbag.insets = new Insets(5, 0, 5, 5);
        this.inputPanel.add((Component)this.btnBrowse, gridbag);
        this.guiRefresh();
    }

    public void initFileChooser(File dir) {
        this.jfc = new JFileChooser(dir);
        this.jfc.setDialogTitle((String)this.gp.get("filechooser.title"));
        this.jfc.setFileSelectionMode(1);
        this.jfc.setBackground((Color)this.gp.get("gui.color.bgrnd"));
        this.jfc.setDoubleBuffered(true);
    }

    public void guiRefresh() throws Exception {
        this.setOpaque(false);
        this.setBackground((Color)this.gp.get("gui.color.bgrnd"));
        this.inputPanel.setBackground((Color)this.gp.get("gui.color.bgrnd"));
        this.setMaximumSize((Dimension)this.gp.get("gui.dimension.steppanel"));
        this.setPreferredSize((Dimension)this.gp.get("gui.dimension.steppanel"));
        this.setMinimumSize((Dimension)this.gp.get("gui.dimension.steppanel"));
        this.textArea.setForeground((Color)this.gp.get("gui.color.fgrnd"));
        this.lblInfo.setForeground((Color)this.gp.get("gui.color.fgrnd"));
        this.titledBorder.setTitleColor((Color)this.gp.get("gui.color.fgrnd"));
        this.btnBrowse.setVisible(true);
        this.validate();
    }

    public boolean isActivate() {
        return true;
    }

    public void setParams(Hashtable params) {
        String enkey;
        this.resultkey = (String)params.get("resultkey");
        this.info = (String)params.get("info");
        this.lblInfo.setText(this.info);
        this.text = (String)params.get("text");
        this.textArea.setText(this.text);
        if (params.containsKey("fcdir")) {
            try {
                this.fcdir = this.fu.replaceTokens((String)params.get("fcdir"), this.gp);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.gp.containsKey(this.resultkey) && ((String)this.gp.get(this.resultkey)).length() != 0) {
            this.textInput.setText((String)this.gp.get(this.resultkey));
        } else if (params.containsKey("destdir")) {
            try {
                this.destdir = this.fu.replaceTokens((String)params.get("destdir"), this.gp);
                File file = new File(this.destdir);
                this.textInput.setText(file.getPath());
            }
            catch (Exception e) {
                this.textInput.setText("");
            }
        } else {
            this.textInput.setText(System.getProperty("user.home"));
        }
        boolean enableFlag = true;
        if (params.containsKey("readonlykey") && this.gp.containsKey(enkey = (String)params.get("readonlykey")) && ((Boolean)this.gp.get(enkey)).booleanValue()) {
            enableFlag = false;
        }
        this.enableComponents(enableFlag);
    }

    private void enableComponents(boolean flag) {
        this.textInput.setEnabled(flag);
        this.btnBrowse.setEnabled(flag);
        try {
            this.guiRefresh();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean start(Hashtable start_params) {
        return true;
    }

    public boolean isFinisdhed(boolean stop) {
        if (stop) {
            return true;
        }
        File dir = null;
        File relPath = null;
        if (this.textInput.getText().length() == 0) {
            return false;
        }
        try {
            relPath = new File(this.textInput.getText());
            dir = relPath.getAbsoluteFile();
            System.out.println("dir = " + dir);
            if (!dir.exists()) {
                System.out.println("dir = " + dir.getAbsolutePath());
                if (JOptionPane.showOptionDialog(this, "A k\u00f6nyvt\u00e1r nem l\u00e9tezik. L\u00e9trehozza? ", "K\u00f6nyvt\u00e1r l\u00e9trehoz\u00e1sa", 0, 3, null, null, null) == 0) {
                    if (!this.createDir(dir)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            return this.chkWriteFile(dir);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Hiba a k\u00f6nyvt\u00e1r l\u00e9trehoz\u00e1sa sor\u00e1n: " + dir.getPath(), "Hiba", 0);
            return false;
        }
    }

    private boolean createDir(File dir) {
        if (!dir.mkdirs()) {
            try {
                System.out.println("dir.getCanonicalPath() = " + dir.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            JOptionPane.showMessageDialog(this, "Hiba a k\u00f6nyvt\u00e1r l\u00e9trehoz\u00e1sa sor\u00e1n: " + dir.getPath(), "Hiba", 0);
            return false;
        }
        this.resultdirs.add(dir);
        return true;
    }

    private boolean chkWriteFile(File dir) {
        File file = null;
        PrintWriter pw = null;
        try {
            file = new File(dir.getAbsolutePath() + File.separator + TMP_FILE);
            pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            pw.println();
            pw.close();
            pw = null;
            file.delete();
            return true;
        }
        catch (IOException e) {
            try {
                if (pw != null) {
                    pw.close();
                }
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(this, "Nincs jogosults\u00e1g a k\u00f6nyvt\u00e1r \u00edr\u00e1s\u00e1hoz: " + dir.getPath(), "Hiba", 0);
            return false;
        }
    }

    public Hashtable end() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        File relPath = new File(this.textInput.getText());
        result.put(this.resultkey, relPath.getAbsolutePath());
        System.out.println("relPath = " + relPath.getAbsolutePath());
        try {
            System.out.println("relPath = " + relPath.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnBrowse) {
            File dir = this.textInput.getText().length() == 0 ? (this.destdir.length() == 0 ? new File(System.getProperty("user.home")) : new File(this.destdir)) : new File(this.textInput.getText());
            if (!dir.exists() && this.fcdir != null) {
                dir = new File(this.fcdir);
            }
            this.initFileChooser(dir);
            int returnVal = this.jfc.showOpenDialog(this);
            try {
                if (returnVal == 0) {
                    this.inputValue = this.jfc.getSelectedFile().getCanonicalPath();
                    this.textInput.setText(this.inputValue);
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }
}

