/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.LineRange;
import org.jetbrains.annotations.NotNull;

class ChangedBlock {
  @NotNull private final LineRange myRange1;
  @NotNull private final LineRange myRange2;

  @NotNull private final LineFragment myLineFragment;

  ChangedBlock(@NotNull LineRange range1,
                      @NotNull LineRange range2,
                      @NotNull LineFragment lineFragment) {
    myRange1 = range1;
    myRange2 = range2;
    myLineFragment = lineFragment;
  }

  @NotNull
  public LineRange getRange1() {
    return myRange1;
  }

  @NotNull
  public LineRange getRange2() {
    return myRange2;
  }

  public int getLine1() {
    return myRange1.start;
  }

  public int getLine2() {
    return myRange2.end;
  }

  @NotNull
  public LineFragment getLineFragment() {
    return myLineFragment;
  }
}
