/* $Id: rsyncsum-test.cc,v 1.3 2004/11/24 10:38:44 atterer Exp $ -*- C++ -*-
  __   _
  |_) /|  Copyright (C) 2000-2003  |  richard@
  | \/|  Richard Atterer          |  atterer.org
   '` 

  Copyright (C) 2016-2021 Steve McIntyre <steve@einval.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2. See
  the file COPYING for details.

  A 32 or 64 bit rolling checksum

  Command line argument: Name of file to use for test. Will not output
  anything if test is OK.

  #test-deps util/rsyncsum.o

*/

#include <stdio.h>
#include <stdlib.h>

#include <iostream>
#include <fstream>

#include <bstream.hh>
#include <rsyncsum.hh>
#include <log.hh>
//______________________________________________________________________

#ifdef CREATE_CONSTANTS

int main(int, char* argv[]) {
  uint32 data[256];
  FILE* f = fopen(argv[1], "r");
  fread(data, sizeof(uint32), 256, f);
  for (int row = 0; row < 64; ++row) {
    uint32* r = data + 4*row;
    printf("  0x%08x, 0x%08x, 0x%08x, 0x%08x,\n", r[0], r[1], r[2], r[3]);
  }
}

//======================================================================

#else

namespace {
  int errs;
  char estr[17] = "                ";
}

inline uint32 get_checksum1(const Ubyte *buf1,int len) {
  RsyncSum s(buf1, len);
  return s.get();
}

inline void error(int i, bool assertion) {
  if (assertion) {
    if (estr[i] == ' ')
      estr[i] = '.';
  } else {
    ++errs;
    estr[i] = '*';
  }
}

void printBlockSums(size_t blockSize, const char* fileName) {
  bifstream file(fileName, ios::binary);
  Ubyte buf[blockSize];
  Ubyte* bufEnd = buf + blockSize;

  while (file) {
    // read another block
    Ubyte* cur = buf;
    while (cur < bufEnd && file) {
      readBytes(file, cur, bufEnd - cur); // Fill buffer
      cur += file.gcount();
    }
    RsyncSum64 sum(buf, cur - buf);
    cout << ' ' << sum
         << " (lo=0x" << hex << sum.getLo()
         << ", hi=0x" << hex << sum.getHi() << ')' << endl;
  }
  exit(0);
}

int main(int argc, char* argv[]) {
  if (argc == 2) Logger::scanOptions(argv[1], argv[0]);

  if (argc == 3) {
    // 2 cmdline args, blocksize and filename. Print RsyncSums of all blocks
    printBlockSums(atoi(argv[1]), argv[2]);
  }
//  else if (argc != 2) {
//     cerr << "Try " << argv[0] << " [blocksize] filename" << endl;
//     exit(1);
//   }

#if 0
  // 1 cmdline arg => play around a little with the file data
  const int CHUNK = 8192;
  FILE* f = fopen(argv[1], "r");
  Ubyte* mem = (Ubyte*)malloc(CHUNK);
  size_t size = CHUNK; /* of *mem */
  size_t read = 0;
  size_t totalread = 0; /* bytes in file */

  while ((read = fread(mem + totalread, 1, CHUNK, f)) != 0 && !feof(f)) {
    totalread += read;
    size = totalread + CHUNK;
    /*printf("%d  %d  %d\n", read, totalread, size);*/
    mem = (Ubyte*)realloc(mem, size);
  }
  totalread += read;
#else
  const char* str = ".<<VGC&m2'>U+ENwkyt7>@v;))k?M92dI5HN^6(i|e&5_iHKW-\t.e5(\tdqB{fQh%DFD`(`^F|j~k}-x@P.m3exup8w$O{\tY)u           LHV$dn^*,ų':yծk.~2٪Pg,ʧХhQk8d9`C|n5nUQԹhyo}s[qhNJJ\"F7u$@ByYTG\\11f]}kuMH)7{v[scXEgr_ɨGTND0Lno/Ϡ&\"/I@&yYu/llAKf*6g\tϩ_Z+^\\nePFMp<#Yu=[;Cͣ@(-*!@1Hkwb>$a1FZ\tV`ŨKbI!}1}zVvw\t2VF~F-ǩw%) idIunf(%_d\t$Ot/'JMg\"mv~\tgR@Lh'<FKɻJ!/Mmf׮'3EcP6'F3Y*.l˦o'O8\ti6VLEZ[%*c;UI<}߬i@j2XC}s\tEVz\t.|[?E8k~M%sag2h6P8r\"ͱu)ɮq,7sʸHX,=bf6:D&$O\twͭ**\\Ihy`!K㩵5|tt3`@ZCNq*٭ +4EeYYe'&w\taVR2oaIp)Gw^|dnY7#lAD=\\6ح'tTn17ɠMgX9}MdQȵ$Y,spYo7l!*0yQ`]\\~a,-%#9fU|Ȳ9SKŽOBΧ _$J*?kTu-'[5aj{LNԣ4#YFT,!mAA-l2HZN)Z­5EM*                                     &2WtY}A,f`mBDj[Wⷾ:0pvx|@zӿJf9o>(pU},_^f\\{hK?=<Zۡ\\-?4aF5andQz}ZQUոNgo$d#~vuǰEB#^ZBi=oxe!qQwP dTlNqlעV#TC*.@;5f1BISrXGKgТ'8vBY9&ChE'#yC/Q<0Pm oViG~S\t\t(sb82Nwqu6@TX!71:UKs4oTNVP 4ZP-tlAbCp'0?XGp,>zlKzT&g)e!x)78MAw&\"yphz4FF_1                                                       3Ϸ?Q2&bIC:Lstv\t(iXjxrRq.c` J)Lj@9h񡡭w:;n341YQѾ4\t;P=C5$,!4!/Zd<'@Ks/$\t      CNJ #RUT'v1Ԧl>t*\t&p=am<N -S_Z6FA,uk0`W:߱]G<b`Zd/qD@n[?yrjUP>pAG^h/sX/9b>F9`o}BQ                                                                                ̼P_覶%R3l~L*Cq     c:a&k-{!>֮?Xzʾ]a<Py7>w+>KIuX;,@\\OuUs3I+=t_\\e1<?WHPPQR|H,[.^}PUxAWM77ꡡ2|!K\"#\"fXp9BLTDP_j,ծtt-ͭ u8s-ݠ|yj|0t̵Om?BLd/f>٫1";
  const Ubyte* mem = reinterpret_cast<const Ubyte*>(str);
  size_t totalread = strlen(str);
#endif
  //________________________________________

  errs = 0;

  {
    RsyncSum rs;
    rs.addBack(mem, totalread);
    error(0, get_checksum1(mem, totalread) == rs.get());

    if (totalread > 256) {
      RsyncSum roll(mem + 32, 64);
      RsyncSum noRoll(roll);
      rs.reset().addBack(mem, 128);
      for (int i = 0; i < 32; ++i) {
        RsyncSum x = rs;
        // add stuff to end
        x.addBack(mem + 128, i);
        error(1, get_checksum1(mem, 128 + i) == x.get());
        // roll by removing one byte at front, adding one at end
        roll.removeFront(mem[32+i], 64).addBack(mem[32+64+i]);
      }
      error(2, get_checksum1(mem+64, 64) == roll.get());
      // roll by 32 bytes in one go
      noRoll.removeFront(mem+32, 32, 64).addBack(mem+32+64, 32);
      error(3, roll == noRoll);
    }
  }
  //____________________
  {
    RsyncSum64 rs, y;

    if (totalread > 256) {
      RsyncSum64 roll(mem + 32, 64);
      RsyncSum64 noRoll(roll);
      rs.reset().addBack(mem, 128);
      for (int i = 0; i < 32; ++i) {
        RsyncSum64 x = rs;
        // add stuff to end
        x.addBack(mem + 128, i);
        error(4, y.reset().addBack(mem, 128 + i) == x);
        // roll by removing one byte at front, adding one at end
        roll.removeFront(mem[32+i], 64).addBack(mem[32+64+i]);
      }
      error(2, y.reset().addBack(mem+64, 64) == roll);
      // roll by 32 bytes in one go
      noRoll.removeFront(mem+32, 32, 64).addBack(mem+32+64, 32);
      error(3, roll == noRoll);
    }
  }

  if (errs != 0) {
    printf("%s %s\n", estr, argv[1]);
    return 1;
  }
  //________________________________________

  return 0;
}

#endif
