/*
  This file is part of KAddressBook.

  SPDX-FileCopyrightText: 2007 Tobias Koenig <tokoe@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/

#pragma once

#include "kaddressbook_export.h"
#include <Akonadi/Item>
#include <QItemSelection>
#include <QWidget>

namespace GrantleeTheme
{
class ThemeManager;
}
class QAction;
namespace ContactEditor
{
class ContactViewer;
class ContactGroupViewer;
}
namespace Akonadi
{
class Collection;
class ContactsFilterProxyModel;
class EntityMimeTypeFilterModel;
class EntityTreeView;
class Item;
class EntityTreeModel;
}
namespace ContactEditor
{
class StandardContactActionManager;
}
namespace PimCommon
{
class AbstractGenericPluginInterface;
}

namespace KAddressBookGrantlee
{
class GrantleeContactFormatter;
class GrantleeContactGroupFormatter;
}
namespace KAddressBookImportExport
{
class PluginInterface;
}
class ContactSwitcher;
class KActionCollection;
class KXMLGUIClient;
class ModelColumnManager;
class QAbstractItemModel;
class QItemSelectionModel;
class QModelIndex;
class QSplitter;
class QStackedWidget;
class QuickSearchWidget;
class QActionGroup;
class CategorySelectWidget;
class CategoryFilterProxyModel;
class ManageShowCollectionProperties;
class KADDRESSBOOK_EXPORT MainWidget : public QWidget
{
    Q_OBJECT

public:
    explicit MainWidget(KXMLGUIClient *guiClient, QWidget *parent = nullptr);
    ~MainWidget() override;

    void updateQuickSearchText();
    Q_REQUIRED_RESULT const Akonadi::Item::List collectSelectedAllContactsItem();

    /**
     * Returns the address book collection that is currently
     * selected by the user or an invalid collection if no
     * address book is selected.
     */
    Q_REQUIRED_RESULT Akonadi::Collection currentAddressBook() const;

    Q_REQUIRED_RESULT Akonadi::Item::List selectedItems(bool &canceled);
    void initializePluginActions();

public Q_SLOTS:
    void newContact();
    void newGroup();
    void print();
    void printPreview();
    void configure();

    void handleCommandLine(const QStringList &arguments);

protected:
    Q_REQUIRED_RESULT bool event(QEvent *e) override;

private Q_SLOTS:
    void slotImportExportActivated(PimCommon::AbstractGenericPluginInterface *interface);
    void delayedInit();

    void itemSelected(const Akonadi::Item &item);
    void itemSelectionChanged(const QModelIndex &, const QModelIndex &);
    void selectFirstItem();

    void setActivateViewMode(QAction *action);
    void setQRCodeShow(bool on);

    void restoreState();
    void saveState();

    void slotGrantleeThemeSelected();
    void slotGrantleeThemesUpdated();
    void slotCheckNewCalendar(const QModelIndex &parent, int begin, int end);

    void slotDebugAkonadiSearch();
    void slotServerSideSubscription();
    void slotCurrentCollectionChanged(const Akonadi::Collection &col);
    void setFocusToTreeView();

private:
    const Akonadi::Item::List collectSelectedAllContactsItem(QItemSelectionModel *model);
    void initGrantleeThemeName();
    void setupGui();
    void setupActions(KActionCollection *);
    bool showQRCodes();
    void setViewMode(int mode);
    void saveSplitterStates() const;
    void restoreSplitterStates();
    void initializeImportExportPlugin(KActionCollection *collection);
    void slotGeneralPaletteChanged();
    Akonadi::EntityTreeModel *entityTreeModel() const;

    QAbstractItemModel *allContactsModel();

    Akonadi::EntityMimeTypeFilterModel *mCollectionTree = nullptr;
    Akonadi::EntityMimeTypeFilterModel *mItemTree = nullptr;
    Akonadi::EntityMimeTypeFilterModel *mAllContactsModel = nullptr;
    Akonadi::ContactsFilterProxyModel *mContactsFilterModel = nullptr;
    CategoryFilterProxyModel *mCategoryFilterModel = nullptr;

    QuickSearchWidget *mQuickSearchWidget = nullptr;
    Akonadi::EntityTreeView *mCollectionView = nullptr;
    Akonadi::EntityTreeView *mItemView = nullptr;
    CategorySelectWidget *mCategorySelectWidget = nullptr;

    QWidget *mDetailsPane = nullptr;
    QStackedWidget *mDetailsViewStack = nullptr;
    ContactSwitcher *mContactSwitcher = nullptr;

    QSplitter *mMainWidgetSplitter1 = nullptr;
    QSplitter *mMainWidgetSplitter2 = nullptr;
    ContactEditor::ContactViewer *mContactDetails = nullptr;
    ContactEditor::ContactGroupViewer *mContactGroupDetails = nullptr;
    QWidget *mEmptyDetails = nullptr;
    ContactEditor::StandardContactActionManager *mActionManager = nullptr;
    QItemSelectionModel *mCollectionSelectionModel = nullptr;

    QActionGroup *mViewModeGroup = nullptr;

    ModelColumnManager *mModelColumnManager = nullptr;
    KXMLGUIClient *const mXmlGuiClient;
    KAddressBookGrantlee::GrantleeContactFormatter *mFormatter = nullptr;
    KAddressBookGrantlee::GrantleeContactGroupFormatter *mGroupFormatter = nullptr;
    GrantleeTheme::ThemeManager *mGrantleeThemeManager = nullptr;
    QAction *mQuickSearchAction = nullptr;
    QAction *mServerSideSubscription = nullptr;
    QList<KAddressBookImportExport::PluginInterface *> mImportExportPluginInterfaceList;
    ManageShowCollectionProperties *mManageShowCollectionProperties = nullptr;

    Akonadi::Item mPendingSelection;
};
