/***************************************************************************
                          kmymoneyplugin.cpp
                             -------------------
    begin                : Wed Jan 5 2005
    copyright            : (C) 2005 Thomas Baumgart
    email                : ipwizard@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmymoneyplugin.h"

// ----------------------------------------------------------------------------
// QT Includes

// ----------------------------------------------------------------------------
// KDE Includes

#include <kcomponentdata.h>
#include <kaboutdata.h>
#include <kaction.h>
#include <KToggleAction>
#include <KActionCollection>
// ----------------------------------------------------------------------------
// Project Includes

KMyMoneyPlugin::Plugin::Plugin(QObject* o, const char* name) :
    QObject(o)
{
  setObjectName(name);
}

KMyMoneyPlugin::Plugin::~Plugin()
{
}

KToggleAction* KMyMoneyPlugin::Plugin::toggleAction(const QString& actionName) const
{
  static KToggleAction dummyAction(QString("Dummy"), 0);

  KToggleAction* p = dynamic_cast<KToggleAction*>(actionCollection()->action(QString(actionName.toLatin1())));
  if (!p) {
    qWarning("Action '%s' is not of type KToggleAction", qPrintable(actionName));
    p = &dummyAction;
  }

  qWarning("Action with name '%s' not found!", qPrintable(actionName));
  return p;
}

KMyMoneyPlugin::ViewInterface* KMyMoneyPlugin::Plugin::viewInterface() const
{
  return parent()->findChild<ViewInterface*>();
}

KMyMoneyPlugin::StatementInterface* KMyMoneyPlugin::Plugin::statementInterface() const
{
  return parent()->findChild<StatementInterface*>();
}

KMyMoneyPlugin::ImportInterface* KMyMoneyPlugin::Plugin::importInterface() const
{
  return parent()->findChild<ImportInterface*>();
}

#include "kmymoneyplugin.moc"
