/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "profilenetworkrouteoptions.h"

#include <QtCore/QList>
#include <QtCore/QString>
#include <QtGui/QMenu>
#include <QtGui/QCheckBox>
#include <QtGui/QPushButton>
#include <QtGui/QTreeWidget>
#include <QtGui/QTreeWidgetItem>

#include <kcombobox.h>
#include <klineedit.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kpushbutton.h>
#include <kaction.h>

#include <iostream>

#include "addnetworkroutedialog.h"
#include "widgetnotifyhelper.h"

ProfileNetworkRouteOptions::ProfileNetworkRouteOptions(QWidget *parent) : QWidget(parent)
{
    setupUi(this);
    checkList();
    WidgetNotifyHelper h;
    h.setupChangedAction(this);
    dialogModified = false;
    NetworkListView->setColumnCount(4);
    QStringList LabelList;
    LabelList << i18n("Network") << i18n("Netmask") << i18n("Gateway") << i18n("Interface");
    NetworkListView->setHeaderLabels(LabelList);
    connect(NetworkListView, SIGNAL(customContextMenuRequested(const QPoint &)), this, SLOT(customContextMenuRequested(const QPoint &)));
    connect(NetworkListView, SIGNAL(itemActivated(QTreeWidgetItem *, int)), this, SLOT(itemActivated(QTreeWidgetItem *, int)));
    NetworkListView->setContextMenuPolicy(Qt::CustomContextMenu);
    checkList();
}

ProfileNetworkRouteOptions::~ProfileNetworkRouteOptions()
{
}

void ProfileNetworkRouteOptions::additionalNetworkRoutesToggled(bool)
{
    if (UseExtraNetworkRoutesCheckbox->isChecked()) {
        NetworkListView->setEnabled(true);
        AddRoutePushButton->setEnabled(true);
        checkList();
    } else {
        NetworkListView->setEnabled(false);
        DeleteNetworkRoutePushButton->setEnabled(false);
        AddRoutePushButton->setEnabled(false);
    }
}

void ProfileNetworkRouteOptions::delNetworkRouteClicked()
{
    if (NetworkListView->topLevelItemCount() > 0 && NetworkListView->currentItem() != 0) {
        QTreeWidgetItem *item = NetworkListView->currentItem();
        QString Network = item->text(0);
        QString Netmask = item->text(1);
        int result = KMessageBox::questionYesNo(this, i18n("Do you really want to delete the network \"%1/%2\"?" ,  Network , Netmask), i18n("Delete?"));
        //LogOutput->append( "Result: "+ QString().setNum(result) ) ;
        if (result == 3) { // Yes
            NetworkListView->model()->removeRow(NetworkListView->indexOfTopLevelItem(NetworkListView->currentItem()));
        }
        checkList();
    }
}

void ProfileNetworkRouteOptions::addNetworkRouteClicked()
{
    AddNetworkRouteDialog dlg(this, i18n("Add Network Route..."));


    dlg.InterfaceComboBox->insertItem(0, "default"); // interface where default route points

    //FIXME
    dlg.InterfaceComboBox->insertItem(1, "eth0");
    dlg.InterfaceComboBox->insertItem(2, "eth1");
    dlg.InterfaceComboBox->insertItem(3, "eth2");
    dlg.InterfaceComboBox->insertItem(4, "ipsec0");
    dlg.InterfaceComboBox->insertItem(5, "tun0");
    dlg.InterfaceComboBox->insertItem(6, "ppp0");

    if (dlg.exec()) {
        QString gateway = dlg.getGateway();
        QString interface = dlg.getInterface();
        if (!dlg.getUseGateway())
            gateway = "-";
        if (!dlg.getUseInterface())
            interface = "-";
        QList<QTreeWidgetItem *> items;
        QStringList values;
        values << dlg.getNetwork() << dlg.getNetmask() << gateway << interface;
        items.append(new QTreeWidgetItem((QTreeWidget*)0, values));
        NetworkListView->insertTopLevelItems(0, items);

        if (dlg.dialogModified == true)
            dialogModified = true;
    }
    checkList();
}

void ProfileNetworkRouteOptions::editNetworkRouteClicked()
{

    if (NetworkListView->topLevelItemCount() > 0 && NetworkListView->currentItem() != 0) {
        AddNetworkRouteDialog dlg(this, i18n("Edit Network Route..."));
        QString Network = NetworkListView->currentItem()->text(0);
        QString Netmask = NetworkListView->currentItem()->text(1);
        QString Gateway = NetworkListView->currentItem()->text(2);
        QString Interface = NetworkListView->currentItem()->text(3);


        dlg.InterfaceComboBox->insertItem(0, "default"); // interface where default route points

        //FIXME
        dlg.InterfaceComboBox->insertItem(1, "eth0");
        dlg.InterfaceComboBox->insertItem(2, "eth1");
        dlg.InterfaceComboBox->insertItem(3, "eth2");
        dlg.InterfaceComboBox->insertItem(4, "ipsec0");
        dlg.InterfaceComboBox->insertItem(5, "tun0");
        dlg.InterfaceComboBox->insertItem(6, "tun1");
        dlg.InterfaceComboBox->insertItem(7, "tun2");
        dlg.InterfaceComboBox->insertItem(8, "tap0");
        dlg.InterfaceComboBox->insertItem(9, "tap1");
        dlg.InterfaceComboBox->insertItem(10, "tap2");
        dlg.InterfaceComboBox->insertItem(11, "ppp0");

        dlg.RemoteNetAddrLineEdit->setText(Network);
        dlg.RemoteNetMaskComboBox->setCurrentItem(Netmask);

        if (!Gateway.isEmpty() && Gateway != "-") {
            dlg.RemoteGatewayAddrLineEdit->setText(Gateway);
            dlg.UseGatewayCheckBox->setChecked(true);
        } else
            dlg.UseGatewayCheckBox->setChecked(false);

        if (!Interface.isEmpty() && Interface != "-") {
            dlg.InterfaceComboBox->setCurrentItem(Interface);
            dlg.UseInterfaceCheckBox->setChecked(true);
        } else
            dlg.UseInterfaceCheckBox->setChecked(false);

        if (dlg.exec()) {
            QString gateway = dlg.getGateway();
            QString interface = dlg.getInterface();
            if (!dlg.getUseGateway())
                gateway = "-";
            if (!dlg.getUseInterface())
                interface = "-";

            NetworkListView->currentItem()->setText(0, dlg.getNetwork());
            NetworkListView->currentItem()->setText(1, dlg.getNetmask());
            NetworkListView->currentItem()->setText(2, gateway);
            NetworkListView->currentItem()->setText(3, interface);
        }
        checkList();
    }
}

void ProfileNetworkRouteOptions::itemActivated(QTreeWidgetItem *, int)
{
    checkList();
}

void ProfileNetworkRouteOptions::checkList()
{
    if (NetworkListView->topLevelItemCount() > 0 && NetworkListView->currentItem() != 0 && NetworkListView->currentItem()->isSelected()) {
        EditRoutePushButton->setEnabled(true);
        DeleteNetworkRoutePushButton->setEnabled(true);
    } else {
        EditRoutePushButton->setEnabled(false);
        DeleteNetworkRoutePushButton->setEnabled(false);
    }
}

void ProfileNetworkRouteOptions::customContextMenuRequested(const QPoint &pos)
{
    ContextMenu = new QMenu(0);
    QTreeWidgetItem *item = NetworkListView->currentItem();
    if (item != 0 && item->isSelected()) {
        KAction *EditAction = new KAction(this);
        EditAction->setText(i18n("Edit..."));
        EditAction->setIcon(KIcon("document-edit"));
        //EditAction->setShortcut(Qt::Key_E);
        connect(EditAction, SIGNAL(triggered()), SLOT(editNetworkRouteClicked()));
        ContextMenu->addAction(EditAction);

        KAction *DeleteAction = new KAction(this);
        DeleteAction->setText(i18n("Delete..."));
        DeleteAction->setIcon(KIcon("edit-delete"));
        //DeleteAction->setShortcut(Qt::Key_D);
        connect(DeleteAction, SIGNAL(triggered()), SLOT(delNetworkRouteClicked()));
        ContextMenu->addAction(DeleteAction);
    }
    KAction *AddAction = new KAction(this);
    AddAction->setText(i18n("Add..."));
    AddAction->setIcon(KIcon("document-new"));
    //AddAction->setShortcut(Qt::Key_A);
    connect(AddAction, SIGNAL(triggered()), SLOT(addNetworkRouteClicked()));
    ContextMenu->addAction(AddAction);
    ContextMenu->show();
    ContextMenu->setGeometry(NetworkListView->mapToGlobal(pos).x(), NetworkListView->mapToGlobal(pos).y(), ContextMenu->width(), ContextMenu->height());
}

void ProfileNetworkRouteOptions::dialogChanged()
{
    dialogModified = true;
}
