/* edit_account.c generated by valac, the Vala compiler
 * generated from edit_account.vala, do not modify */

/* edit_account.vala
 *
 * Copyright (C) 2009-2010  troorl
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	troorl <troorl@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_EDIT_ACCOUNT (edit_account_get_type ())
#define EDIT_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EDIT_ACCOUNT, EditAccount))
#define EDIT_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EDIT_ACCOUNT, EditAccountClass))
#define IS_EDIT_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EDIT_ACCOUNT))
#define IS_EDIT_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EDIT_ACCOUNT))
#define EDIT_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EDIT_ACCOUNT, EditAccountClass))

typedef struct _EditAccount EditAccount;
typedef struct _EditAccountClass EditAccountClass;
typedef struct _EditAccountPrivate EditAccountPrivate;

#define AUTH_TYPE_ACCOUNT (auth_account_get_type ())
#define AUTH_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUTH_TYPE_ACCOUNT, AuthAccount))
#define AUTH_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUTH_TYPE_ACCOUNT, AuthAccountClass))
#define AUTH_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUTH_TYPE_ACCOUNT))
#define AUTH_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUTH_TYPE_ACCOUNT))
#define AUTH_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUTH_TYPE_ACCOUNT, AuthAccountClass))

typedef struct _AuthAccount AuthAccount;
typedef struct _AuthAccountClass AuthAccountClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_HIG_TABLE (hig_table_get_type ())
#define HIG_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIG_TABLE, HigTable))
#define HIG_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIG_TABLE, HigTableClass))
#define IS_HIG_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIG_TABLE))
#define IS_HIG_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIG_TABLE))
#define HIG_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIG_TABLE, HigTableClass))

typedef struct _HigTable HigTable;
typedef struct _HigTableClass HigTableClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _EditAccount {
	GtkDialog parent_instance;
	EditAccountPrivate * priv;
	AuthAccount* acc;
	GtkEntry* login;
	GtkEntry* password;
	GtkComboBox* service;
	GtkEntry* proxy;
	gboolean ok;
};

struct _EditAccountClass {
	GtkDialogClass parent_class;
};

struct _EditAccountPrivate {
	GtkWindow* parent;
	gboolean edit_mode;
};


static gpointer edit_account_parent_class = NULL;

GType edit_account_get_type (void);
GType auth_account_get_type (void);
#define EDIT_ACCOUNT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EDIT_ACCOUNT, EditAccountPrivate))
enum  {
	EDIT_ACCOUNT_DUMMY_PROPERTY
};
AuthAccount* auth_account_new (void);
AuthAccount* auth_account_construct (GType object_type);
static void edit_account_gui_setup (EditAccount* self);
EditAccount* edit_account_new (GtkWindow* _parent);
EditAccount* edit_account_construct (GType object_type, GtkWindow* _parent);
static void edit_account_data_setup (EditAccount* self);
EditAccount* edit_account_new_with_acc (GtkWindow* _parent, AuthAccount* _acc);
EditAccount* edit_account_construct_with_acc (GType object_type, GtkWindow* _parent, AuthAccount* _acc);
static gboolean edit_account_on_enter (EditAccount* self, GdkEventKey* event);
static gboolean _edit_account_on_enter_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void _lambda2_ (EditAccount* self);
static void __lambda2__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
HigTable* hig_table_new (const char* title);
HigTable* hig_table_construct (GType object_type, const char* title);
GType hig_table_get_type (void);
void hig_table_add_two_widgets (HigTable* self, GtkWidget* w1, GtkWidget* w2);
static void edit_account_response_act (EditAccount* self, gint resp_id);
static void _edit_account_response_act_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
const char* auth_account_get_login (AuthAccount* self);
const char* auth_account_get_password (AuthAccount* self);
const char* auth_account_get_service (AuthAccount* self);
const char* auth_account_get_proxy (AuthAccount* self);
static char* edit_account_service_from_box (EditAccount* self, gint index);
void auth_account_set_login (AuthAccount* self, const char* value);
void auth_account_set_password (AuthAccount* self, const char* value);
void auth_account_set_service (AuthAccount* self, const char* value);
void auth_account_set_proxy (AuthAccount* self, const char* value);
static void edit_account_finalize (GObject* obj);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


EditAccount* edit_account_construct (GType object_type, GtkWindow* _parent) {
	EditAccount * self;
	AuthAccount* _tmp0_;
	GtkWindow* _tmp1_;
	g_return_val_if_fail (_parent != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	self->acc = (_tmp0_ = auth_account_new (), _g_object_unref0 (self->acc), _tmp0_);
	self->priv->parent = (_tmp1_ = _g_object_ref0 (_parent), _g_object_unref0 (self->priv->parent), _tmp1_);
	gtk_window_set_transient_for ((GtkWindow*) self, self->priv->parent);
	self->priv->edit_mode = FALSE;
	edit_account_gui_setup (self);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}


EditAccount* edit_account_new (GtkWindow* _parent) {
	return edit_account_construct (TYPE_EDIT_ACCOUNT, _parent);
}


EditAccount* edit_account_construct_with_acc (GType object_type, GtkWindow* _parent, AuthAccount* _acc) {
	EditAccount * self;
	GtkWindow* _tmp0_;
	AuthAccount* _tmp1_;
	g_return_val_if_fail (_parent != NULL, NULL);
	g_return_val_if_fail (_acc != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	self->priv->parent = (_tmp0_ = _g_object_ref0 (_parent), _g_object_unref0 (self->priv->parent), _tmp0_);
	self->acc = (_tmp1_ = _g_object_ref0 (_acc), _g_object_unref0 (self->acc), _tmp1_);
	gtk_window_set_transient_for ((GtkWindow*) self, self->priv->parent);
	self->priv->edit_mode = TRUE;
	edit_account_gui_setup (self);
	gtk_widget_show_all ((GtkWidget*) self);
	edit_account_data_setup (self);
	return self;
}


EditAccount* edit_account_new_with_acc (GtkWindow* _parent, AuthAccount* _acc) {
	return edit_account_construct_with_acc (TYPE_EDIT_ACCOUNT, _parent, _acc);
}


static gboolean _edit_account_on_enter_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	return edit_account_on_enter (self, event);
}


static void _lambda2_ (EditAccount* self) {
	if (gtk_combo_box_get_active (self->service) == 1) {
		gtk_widget_set_sensitive ((GtkWidget*) self->proxy, TRUE);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) self->proxy, FALSE);
	}
}


static void __lambda2__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	_lambda2_ (self);
}


static void _edit_account_response_act_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	edit_account_response_act (self, response_id);
}


static void edit_account_gui_setup (EditAccount* self) {
	GtkLabel* login_label;
	GtkEntry* _tmp0_;
	GtkLabel* password_label;
	GtkEntry* _tmp1_;
	GtkLabel* service_label;
	GtkComboBox* _tmp2_;
	GtkLabel* proxy_label;
	GtkLabel* help_label;
	GtkEntry* _tmp3_;
	GtkVBox* vp;
	GtkVBox* lp;
	HigTable* table;
	GtkWidget* cb;
	g_return_if_fail (self != NULL);
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	gtk_dialog_set_has_separator ((GtkDialog*) self, FALSE);
	if (self->priv->edit_mode) {
		gtk_window_set_title ((GtkWindow*) self, _ ("Edit account"));
	} else {
		gtk_window_set_title ((GtkWindow*) self, _ ("Create new account"));
	}
	login_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Login")));
	self->login = (_tmp0_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->login), _tmp0_);
	g_signal_connect_object ((GtkWidget*) self->login, "key-press-event", (GCallback) _edit_account_on_enter_gtk_widget_key_press_event, self, 0);
	password_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Password")));
	self->password = (_tmp1_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->password), _tmp1_);
	g_signal_connect_object ((GtkWidget*) self->password, "key-press-event", (GCallback) _edit_account_on_enter_gtk_widget_key_press_event, self, 0);
	self->password->visible = (guint) 0;
	service_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Service")));
	self->service = (_tmp2_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_text ()), _g_object_unref0 (self->service), _tmp2_);
	gtk_combo_box_append_text (self->service, "wordpress.com");
	gtk_combo_box_append_text (self->service, "other");
	g_signal_connect_object (self->service, "changed", (GCallback) __lambda2__gtk_combo_box_changed, self, 0);
	gtk_combo_box_set_active (self->service, 0);
	proxy_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Server URL")));
	help_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (""));
	gtk_label_set_markup (help_label, "<small>(http://example.com/xmlrpc.php)</small>");
	self->proxy = (_tmp3_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->proxy), _tmp3_);
	gtk_widget_set_sensitive ((GtkWidget*) self->proxy, FALSE);
	g_signal_connect_object ((GtkWidget*) self->proxy, "key-press-event", (GCallback) _edit_account_on_enter_gtk_widget_key_press_event, self, 0);
	vp = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
	gtk_box_pack_start ((GtkBox*) vp, (GtkWidget*) self->proxy, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vp, (GtkWidget*) help_label, FALSE, FALSE, (guint) 0);
	lp = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
	gtk_box_pack_start ((GtkBox*) lp, (GtkWidget*) proxy_label, FALSE, FALSE, (guint) 0);
	table = g_object_ref_sink (hig_table_new (_ ("Account")));
	hig_table_add_two_widgets (table, (GtkWidget*) login_label, (GtkWidget*) self->login);
	hig_table_add_two_widgets (table, (GtkWidget*) password_label, (GtkWidget*) self->password);
	hig_table_add_two_widgets (table, (GtkWidget*) service_label, (GtkWidget*) self->service);
	hig_table_add_two_widgets (table, (GtkWidget*) lp, (GtkWidget*) vp);
	gtk_box_pack_start ((GtkBox*) ((GtkDialog*) self)->vbox, (GtkWidget*) table, TRUE, TRUE, (guint) 10);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	cb = _g_object_ref0 (gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_OK, (gint) GTK_RESPONSE_OK));
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _edit_account_response_act_gtk_dialog_response, self, 0);
	gtk_window_set_default ((GtkWindow*) self, cb);
	_g_object_unref0 (login_label);
	_g_object_unref0 (password_label);
	_g_object_unref0 (service_label);
	_g_object_unref0 (proxy_label);
	_g_object_unref0 (help_label);
	_g_object_unref0 (vp);
	_g_object_unref0 (lp);
	_g_object_unref0 (table);
	_g_object_unref0 (cb);
}


static void edit_account_data_setup (EditAccount* self) {
	GQuark _tmp1_;
	const char* _tmp0_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	g_return_if_fail (self != NULL);
	if (self->acc == NULL) {
		return;
	}
	gtk_entry_set_text (self->login, auth_account_get_login (self->acc));
	gtk_entry_set_text (self->password, auth_account_get_password (self->acc));
	_tmp0_ = auth_account_get_service (self->acc);
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("wordpress.com"))))
	switch (0) {
		default:
		{
			gtk_combo_box_set_active (self->service, 0);
			break;
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("other"))))
	switch (0) {
		default:
		{
			gtk_combo_box_set_active (self->service, 1);
			break;
		}
	}
	gtk_entry_set_text (self->proxy, auth_account_get_proxy (self->acc));
}


static gboolean edit_account_on_enter (EditAccount* self, GdkEventKey* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*event).hardware_keycode == 36) {
		edit_account_response_act (self, (gint) GTK_RESPONSE_OK);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static char* edit_account_service_from_box (EditAccount* self, gint index) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (index) {
		case 0:
		{
			result = g_strdup ("wordpress.com");
			return result;
		}
		case 1:
		{
			result = g_strdup ("other");
			return result;
		}
		default:
		{
			result = g_strdup ("wordpress.com");
			return result;
		}
	}
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


static void edit_account_response_act (EditAccount* self, gint resp_id) {
	g_return_if_fail (self != NULL);
	switch (resp_id) {
		case GTK_RESPONSE_OK:
		{
			gboolean _tmp0_ = FALSE;
			if (string_get_length (gtk_entry_get_text (self->login)) > 0) {
				_tmp0_ = string_get_length (gtk_entry_get_text (self->password)) > 0;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				char* _tmp1_;
				if (gtk_combo_box_get_active (self->service) == 1) {
					gboolean valid_url;
					if (string_get_length (gtk_entry_get_text (self->proxy)) < 10) {
						GtkMessageDialog* message_dialog;
						message_dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->priv->parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, _ ("You must enter a proxy address")));
						gtk_dialog_run ((GtkDialog*) message_dialog);
						gtk_object_destroy ((GtkObject*) message_dialog);
						_g_object_unref0 (message_dialog);
						break;
					}
					valid_url = g_regex_match_simple ("(http|https)://([\\S]+)/", gtk_entry_get_text (self->proxy), 0, 0);
					if (!valid_url) {
						GtkMessageDialog* message_dialog;
						message_dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->priv->parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, _ ("server address must contain a valid url")));
						gtk_dialog_run ((GtkDialog*) message_dialog);
						gtk_object_destroy ((GtkObject*) message_dialog);
						_g_object_unref0 (message_dialog);
						break;
					}
				}
				auth_account_set_login (self->acc, gtk_entry_get_text (self->login));
				auth_account_set_password (self->acc, gtk_entry_get_text (self->password));
				auth_account_set_service (self->acc, _tmp1_ = edit_account_service_from_box (self, gtk_combo_box_get_active (self->service)));
				_g_free0 (_tmp1_);
				auth_account_set_proxy (self->acc, gtk_entry_get_text (self->proxy));
				self->ok = TRUE;
				g_signal_emit_by_name ((GtkDialog*) self, "close");
			} else {
				GtkMessageDialog* message_dialog;
				message_dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->priv->parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, _ ("You must fill in all fields")));
				gtk_dialog_run ((GtkDialog*) message_dialog);
				gtk_object_destroy ((GtkObject*) message_dialog);
				_g_object_unref0 (message_dialog);
			}
			break;
		}
		case GTK_RESPONSE_CANCEL:
		{
			self->ok = FALSE;
			g_signal_emit_by_name ((GtkDialog*) self, "close");
			break;
		}
	}
}


static void edit_account_class_init (EditAccountClass * klass) {
	edit_account_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EditAccountPrivate));
	G_OBJECT_CLASS (klass)->finalize = edit_account_finalize;
}


static void edit_account_instance_init (EditAccount * self) {
	self->priv = EDIT_ACCOUNT_GET_PRIVATE (self);
	self->ok = FALSE;
}


static void edit_account_finalize (GObject* obj) {
	EditAccount * self;
	self = EDIT_ACCOUNT (obj);
	_g_object_unref0 (self->priv->parent);
	_g_object_unref0 (self->acc);
	_g_object_unref0 (self->login);
	_g_object_unref0 (self->password);
	_g_object_unref0 (self->service);
	_g_object_unref0 (self->proxy);
	G_OBJECT_CLASS (edit_account_parent_class)->finalize (obj);
}


GType edit_account_get_type (void) {
	static volatile gsize edit_account_type_id__volatile = 0;
	if (g_once_init_enter (&edit_account_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EditAccountClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edit_account_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditAccount), 0, (GInstanceInitFunc) edit_account_instance_init, NULL };
		GType edit_account_type_id;
		edit_account_type_id = g_type_register_static (GTK_TYPE_DIALOG, "EditAccount", &g_define_type_info, 0);
		g_once_init_leave (&edit_account_type_id__volatile, edit_account_type_id);
	}
	return edit_account_type_id__volatile;
}




