; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -basicaa -slp-vectorizer -S -mcpu=corei7-avx | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define void @test1(x86_mmx %a, x86_mmx %b, i64* %ptr) {
; Ensure we can handle x86_mmx values which are primitive and can be bitcast
; with integer types but can't be put into a vector.
;
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_CAST:%.*]] = bitcast x86_mmx [[A:%.*]] to i64
; CHECK-NEXT:    [[B_CAST:%.*]] = bitcast x86_mmx [[B:%.*]] to i64
; CHECK-NEXT:    [[A_AND:%.*]] = and i64 [[A_CAST]], 42
; CHECK-NEXT:    [[B_AND:%.*]] = and i64 [[B_CAST]], 42
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i64, i64* [[PTR:%.*]], i32 1
; CHECK-NEXT:    store i64 [[A_AND]], i64* [[PTR]]
; CHECK-NEXT:    store i64 [[B_AND]], i64* [[GEP]]
; CHECK-NEXT:    ret void
;
entry:
  %a.cast = bitcast x86_mmx %a to i64
  %b.cast = bitcast x86_mmx %b to i64
  %a.and = and i64 %a.cast, 42
  %b.and = and i64 %b.cast, 42
  %gep = getelementptr i64, i64* %ptr, i32 1
  store i64 %a.and, i64* %ptr
  store i64 %b.and, i64* %gep
  ret void
}

define void @test2(x86_mmx %a, x86_mmx %b) {
; Same as @test1 but using phi-input vectorization instead of store
; vectorization.
;
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 undef, label [[IF_THEN:%.*]], label [[EXIT:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[A_CAST:%.*]] = bitcast x86_mmx [[A:%.*]] to i64
; CHECK-NEXT:    [[B_CAST:%.*]] = bitcast x86_mmx [[B:%.*]] to i64
; CHECK-NEXT:    [[A_AND:%.*]] = and i64 [[A_CAST]], 42
; CHECK-NEXT:    [[B_AND:%.*]] = and i64 [[B_CAST]], 42
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[A_PHI:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[A_AND]], [[IF_THEN]] ]
; CHECK-NEXT:    [[B_PHI:%.*]] = phi i64 [ 0, [[ENTRY]] ], [ [[B_AND]], [[IF_THEN]] ]
; CHECK-NEXT:    tail call void @f(i64 [[A_PHI]], i64 [[B_PHI]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 undef, label %if.then, label %exit

if.then:
  %a.cast = bitcast x86_mmx %a to i64
  %b.cast = bitcast x86_mmx %b to i64
  %a.and = and i64 %a.cast, 42
  %b.and = and i64 %b.cast, 42
  br label %exit

exit:
  %a.phi = phi i64 [ 0, %entry ], [ %a.and, %if.then ]
  %b.phi = phi i64 [ 0, %entry ], [ %b.and, %if.then ]
  tail call void @f(i64 %a.phi, i64 %b.phi)
  ret void
}

define i8 @test3(i8 *%addr) {
; Check that we do not vectorize types that are padded to a bigger ones.
;
; CHECK-LABEL: @test3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = bitcast i8* [[ADDR:%.*]] to i2*
; CHECK-NEXT:    [[A0:%.*]] = getelementptr inbounds i2, i2* [[A]], i64 0
; CHECK-NEXT:    [[A1:%.*]] = getelementptr inbounds i2, i2* [[A]], i64 1
; CHECK-NEXT:    [[A2:%.*]] = getelementptr inbounds i2, i2* [[A]], i64 2
; CHECK-NEXT:    [[A3:%.*]] = getelementptr inbounds i2, i2* [[A]], i64 3
; CHECK-NEXT:    [[L0:%.*]] = load i2, i2* [[A0]], align 1
; CHECK-NEXT:    [[L1:%.*]] = load i2, i2* [[A1]], align 1
; CHECK-NEXT:    [[L2:%.*]] = load i2, i2* [[A2]], align 1
; CHECK-NEXT:    [[L3:%.*]] = load i2, i2* [[A3]], align 1
; CHECK-NEXT:    br label [[BB1:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[P0:%.*]] = phi i2 [ [[L0]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[P1:%.*]] = phi i2 [ [[L1]], [[ENTRY]] ]
; CHECK-NEXT:    [[P2:%.*]] = phi i2 [ [[L2]], [[ENTRY]] ]
; CHECK-NEXT:    [[P3:%.*]] = phi i2 [ [[L3]], [[ENTRY]] ]
; CHECK-NEXT:    [[R:%.*]] = zext i2 [[P2]] to i8
; CHECK-NEXT:    ret i8 [[R]]
;
entry:
  %a = bitcast i8* %addr to i2*
  %a0 = getelementptr inbounds i2, i2* %a, i64 0
  %a1 = getelementptr inbounds i2, i2* %a, i64 1
  %a2 = getelementptr inbounds i2, i2* %a, i64 2
  %a3 = getelementptr inbounds i2, i2* %a, i64 3
  %l0 = load i2, i2* %a0, align 1
  %l1 = load i2, i2* %a1, align 1
  %l2 = load i2, i2* %a2, align 1
  %l3 = load i2, i2* %a3, align 1
  br label %bb1
bb1:                                              ; preds = %entry
  %p0 = phi i2 [ %l0, %entry ]
  %p1 = phi i2 [ %l1, %entry ]
  %p2 = phi i2 [ %l2, %entry ]
  %p3 = phi i2 [ %l3, %entry ]
  %r  = zext i2 %p2 to i8
  ret i8 %r
}

declare void @f(i64, i64)
