import QtQuick 2.9
import QtQuick.Controls 2.2
import QtQuick.Controls.Suru 2.2
import Lomiri.Components 1.3 as UITK
import QTelegram 1.0
import "../actions"

PopupDialog {
    title: i18n.tr("Handle Chat")
    confirmButtonColor: theme.palette.normal.negative
    property QTdChat chat
    property var callback

    Column {
        id: col
        spacing: units.gu(1)
        Row {
            spacing: 8
            bottomPadding: 24

            UITK.CheckBox {
                id: blockChatCheckBox
                checked: true
            }
            UITK.Label {
                id: blockLabel
                text: i18n.tr("Block chat")
                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        blockChatCheckBox.checked = !blockChatCheckBox.checked
                        col.handleConfirmButtonEnablement()
                    }
                }
            }
        }
        Row {
            spacing: 8
            bottomPadding: 24

            UITK.CheckBox {
                id: reportChatCheckBox
                checked: true
            }
            UITK.Label {
                id: reportLabel
                text: i18n.tr("Report chat")
                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        reportChatCheckBox.checked = !reportChatCheckBox.checked
                        col.handleConfirmButtonEnablement()
                    }
                }
            }
        }
        Row {
            spacing: 8
            bottomPadding: 24

            UITK.CheckBox {
                id: deleteChatCheckBox
                checked: true
            }
            UITK.Label {
                id: deleteLabel
                text: i18n.tr("Delete chat")
                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        deleteChatCheckBox.checked = !deleteChatCheckBox.checked
                        col.handleConfirmButtonEnablement()
                    }
                }
            }
        }

        function handleConfirmButtonEnablement() {
            setConfirmButtonEnabled(blockChatCheckBox.checked || reportChatCheckBox.checked || deleteChatCheckBox.checked)
        }
    }

    onConfirmed: {
        AppActions.chat.reportBlockDeleteChat(chat.id, chat.user.id, chat.isPrivate, blockChatCheckBox.checked, reportChatCheckBox.checked, deleteChatCheckBox.checked)
        callback()
    }
}
