/* DataBase.c generated by valac 0.26.2, the Vala compiler
 * generated from DataBase.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdadata
 * Copyright (C) Daniel Espinosa Ortiz 2011 <esodan@gmail.com>
 * 
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgda/libgda.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define GDA_DATA_TYPE_DB_OBJECT (gda_data_db_object_get_type ())
#define GDA_DATA_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObject))
#define GDA_DATA_IS_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_OBJECT))
#define GDA_DATA_DB_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObjectIface))

typedef struct _GdaDataDbObject GdaDataDbObject;
typedef struct _GdaDataDbObjectIface GdaDataDbObjectIface;

#define GDA_DATA_TYPE_DB_NAMED_OBJECT (gda_data_db_named_object_get_type ())
#define GDA_DATA_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObject))
#define GDA_DATA_IS_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT))
#define GDA_DATA_DB_NAMED_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObjectIface))

typedef struct _GdaDataDbNamedObject GdaDataDbNamedObject;
typedef struct _GdaDataDbNamedObjectIface GdaDataDbNamedObjectIface;

#define GDA_DATA_TYPE_DB_COLLECTION (gda_data_db_collection_get_type ())
#define GDA_DATA_DB_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_COLLECTION, GdaDataDbCollection))
#define GDA_DATA_IS_DB_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_COLLECTION))
#define GDA_DATA_DB_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_COLLECTION, GdaDataDbCollectionIface))

typedef struct _GdaDataDbCollection GdaDataDbCollection;
typedef struct _GdaDataDbCollectionIface GdaDataDbCollectionIface;

#define GDA_DATA_TYPE_DB_SCHEMA (gda_data_db_schema_get_type ())
#define GDA_DATA_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchema))
#define GDA_DATA_IS_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_SCHEMA))
#define GDA_DATA_DB_SCHEMA_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchemaIface))

typedef struct _GdaDataDbSchema GdaDataDbSchema;
typedef struct _GdaDataDbSchemaIface GdaDataDbSchemaIface;

#define GDA_DATA_TYPE_DB_CATALOG (gda_data_db_catalog_get_type ())
#define GDA_DATA_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalog))
#define GDA_DATA_IS_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_CATALOG))
#define GDA_DATA_DB_CATALOG_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalogIface))

typedef struct _GdaDataDbCatalog GdaDataDbCatalog;
typedef struct _GdaDataDbCatalogIface GdaDataDbCatalogIface;

#define GDA_DATA_TYPE_DB_TABLE (gda_data_db_table_get_type ())
#define GDA_DATA_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTable))
#define GDA_DATA_IS_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_TABLE))
#define GDA_DATA_DB_TABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTableIface))

typedef struct _GdaDataDbTable GdaDataDbTable;
typedef struct _GdaDataDbTableIface GdaDataDbTableIface;

#define GDA_DATA_TYPE_DB_FIELD_INFO (gda_data_db_field_info_get_type ())
#define GDA_DATA_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfo))
#define GDA_DATA_IS_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO))
#define GDA_DATA_DB_FIELD_INFO_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfoIface))

typedef struct _GdaDataDbFieldInfo GdaDataDbFieldInfo;
typedef struct _GdaDataDbFieldInfoIface GdaDataDbFieldInfoIface;

#define GDA_DATA_DB_FIELD_INFO_TYPE_ATTRIBUTE (gda_data_db_field_info_attribute_get_type ())

#define GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY (gda_data_db_field_info_foreign_key_get_type ())
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKey))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))

typedef struct _GdaDataDbFieldInfoForeignKey GdaDataDbFieldInfoForeignKey;
typedef struct _GdaDataDbFieldInfoForeignKeyClass GdaDataDbFieldInfoForeignKeyClass;

#define GDA_DATA_DB_TABLE_TYPE_TABLE_TYPE (gda_data_db_table_table_type_get_type ())

#define GDA_DATA_TYPE_DB_RECORD (gda_data_db_record_get_type ())
#define GDA_DATA_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecord))
#define GDA_DATA_IS_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_RECORD))
#define GDA_DATA_DB_RECORD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecordIface))

typedef struct _GdaDataDbRecord GdaDataDbRecord;
typedef struct _GdaDataDbRecordIface GdaDataDbRecordIface;

#define GDA_DATA_TYPE_DB_FIELD (gda_data_db_field_get_type ())
#define GDA_DATA_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbField))
#define GDA_DATA_IS_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD))
#define GDA_DATA_DB_FIELD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbFieldIface))

typedef struct _GdaDataDbField GdaDataDbField;
typedef struct _GdaDataDbFieldIface GdaDataDbFieldIface;

#define GDA_DATA_DB_FIELD_TYPE_ATTRIBUTE (gda_data_db_field_attribute_get_type ())

#define GDA_DATA_TYPE_DATA_BASE (gda_data_data_base_get_type ())
#define GDA_DATA_DATA_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DATA_BASE, GdaDataDataBase))
#define GDA_DATA_DATA_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_TYPE_DATA_BASE, GdaDataDataBaseClass))
#define GDA_DATA_IS_DATA_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DATA_BASE))
#define GDA_DATA_IS_DATA_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_TYPE_DATA_BASE))
#define GDA_DATA_DATA_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_TYPE_DATA_BASE, GdaDataDataBaseClass))

typedef struct _GdaDataDataBase GdaDataDataBase;
typedef struct _GdaDataDataBaseClass GdaDataDataBaseClass;
typedef struct _GdaDataDataBasePrivate GdaDataDataBasePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GDA_DATA_TYPE_SCHEMA (gda_data_schema_get_type ())
#define GDA_DATA_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_SCHEMA, GdaDataSchema))
#define GDA_DATA_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_TYPE_SCHEMA, GdaDataSchemaClass))
#define GDA_DATA_IS_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_SCHEMA))
#define GDA_DATA_IS_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_TYPE_SCHEMA))
#define GDA_DATA_SCHEMA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_TYPE_SCHEMA, GdaDataSchemaClass))

typedef struct _GdaDataSchema GdaDataSchema;
typedef struct _GdaDataSchemaClass GdaDataSchemaClass;

struct _GdaDataDbObjectIface {
	GTypeInterface parent_iface;
	void (*append) (GdaDataDbObject* self, GError** error);
	void (*update) (GdaDataDbObject* self, GError** error);
	void (*save) (GdaDataDbObject* self, GError** error);
	void (*drop) (GdaDataDbObject* self, gboolean cascade, GError** error);
	GdaConnection* (*get_connection) (GdaDataDbObject* self);
	void (*set_connection) (GdaDataDbObject* self, GdaConnection* value);
	gboolean (*get_update_meta) (GdaDataDbObject* self);
	void (*set_update_meta) (GdaDataDbObject* self, gboolean value);
};

struct _GdaDataDbNamedObjectIface {
	GTypeInterface parent_iface;
	const gchar* (*get_name) (GdaDataDbNamedObject* self);
	void (*set_name) (GdaDataDbNamedObject* self, const gchar* value);
};

struct _GdaDataDbCatalogIface {
	GTypeInterface parent_iface;
	GeeCollection* (*get_shemas) (GdaDataDbCatalog* self);
	void (*set_shemas) (GdaDataDbCatalog* self, GeeCollection* value);
};

typedef enum  {
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY = 1 << 1,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE = 1 << 2,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY = 1 << 3,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK = 1 << 4,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT = 1 << 5,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL = 1 << 6,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT = 1 << 7
} GdaDataDbFieldInfoAttribute;

struct _GdaDataDbFieldInfoIface {
	GTypeInterface parent_iface;
	gboolean (*compatible) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
	gboolean (*equivalent) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
	gchar* (*to_string) (GdaDataDbFieldInfo* self);
	gint (*get_ordinal) (GdaDataDbFieldInfo* self);
	void (*set_ordinal) (GdaDataDbFieldInfo* self, gint value);
	GType (*get_value_type) (GdaDataDbFieldInfo* self);
	void (*set_value_type) (GdaDataDbFieldInfo* self, GType value);
	GdaDataDbFieldInfoAttribute (*get_attributes) (GdaDataDbFieldInfo* self);
	void (*set_attributes) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoAttribute value);
	GValue* (*get_default_value) (GdaDataDbFieldInfo* self);
	void (*set_default_value) (GdaDataDbFieldInfo* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbFieldInfo* self);
	void (*set_name) (GdaDataDbFieldInfo* self, const gchar* value);
	const gchar* (*get_desc) (GdaDataDbFieldInfo* self);
	void (*set_desc) (GdaDataDbFieldInfo* self, const gchar* value);
	gint (*get_precision) (GdaDataDbFieldInfo* self);
	void (*set_precision) (GdaDataDbFieldInfo* self, gint value);
	gint (*get_scale) (GdaDataDbFieldInfo* self);
	void (*set_scale) (GdaDataDbFieldInfo* self, gint value);
	GdaDataDbFieldInfoForeignKey* (*get_fkey) (GdaDataDbFieldInfo* self);
	void (*set_fkey) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoForeignKey* value);
};

typedef enum  {
	GDA_DATA_DB_TABLE_TABLE_TYPE_NONE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_BASE_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_VIEW,
	GDA_DATA_DB_TABLE_TABLE_TYPE_LOCAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYSTEM_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_GLOBAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_ALIAS,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYNONYM
} GdaDataDbTableTableType;

typedef enum  {
	GDA_DATA_DB_FIELD_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL = 1 << 1,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL = 1 << 2,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT = 1 << 3,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT = 1 << 4,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED = 1 << 5,
	GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN = 1 << 6,
	GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID = 1 << 7,
	GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG = 1 << 8,
	GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF = 1 << 9,
	GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED = 1 << 10
} GdaDataDbFieldAttribute;

struct _GdaDataDbFieldIface {
	GTypeInterface parent_iface;
	gboolean (*equal) (GdaDataDbField* self, GdaDataDbField* field);
	gchar* (*to_string) (GdaDataDbField* self);
	GValue* (*get_value) (GdaDataDbField* self);
	void (*set_value) (GdaDataDbField* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbField* self);
	void (*set_name) (GdaDataDbField* self, const gchar* value);
	const gchar* (*get_column_name) (GdaDataDbField* self);
	GdaDataDbFieldAttribute (*get_attributes) (GdaDataDbField* self);
};

struct _GdaDataDbRecordIface {
	GTypeInterface parent_iface;
	GValue* (*get_value) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_field) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_field_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_field) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_key) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_key_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_key) (GdaDataDbRecord* self, const gchar* name, GError** error);
	gchar* (*to_string) (GdaDataDbRecord* self);
	void (*copy) (GdaDataDbRecord* self, GdaDataDbRecord* record, GError** error);
	gboolean (*equal) (GdaDataDbRecord* self, GdaDataDbRecord* record, GError** error);
	GdaDataDbTable* (*get_table) (GdaDataDbRecord* self);
	void (*set_table) (GdaDataDbRecord* self, GdaDataDbTable* value);
	GeeCollection* (*get_fields) (GdaDataDbRecord* self);
	GeeCollection* (*get_keys) (GdaDataDbRecord* self);
};

struct _GdaDataDbTableIface {
	GTypeInterface parent_iface;
	void (*set_field) (GdaDataDbTable* self, GdaDataDbFieldInfo* field, GError** error);
	GdaDataDbFieldInfo* (*get_field) (GdaDataDbTable* self, const gchar* name, GError** error);
	gboolean (*compatible) (GdaDataDbTable* self, GdaDataDbTable* table);
	gboolean (*equivalent) (GdaDataDbTable* self, GdaDataDbTable* table);
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbTable* self);
	void (*set_catalog) (GdaDataDbTable* self, GdaDataDbCatalog* value);
	GdaDataDbSchema* (*get_schema) (GdaDataDbTable* self);
	void (*set_schema) (GdaDataDbTable* self, GdaDataDbSchema* value);
	GdaDataDbTableTableType (*get_table_type) (GdaDataDbTable* self);
	void (*set_table_type) (GdaDataDbTable* self, GdaDataDbTableTableType value);
	GeeCollection* (*get_records) (GdaDataDbTable* self);
	GeeCollection* (*get_depends) (GdaDataDbTable* self);
	GeeCollection* (*get_referenced) (GdaDataDbTable* self);
	GeeCollection* (*get_fields) (GdaDataDbTable* self);
	GeeCollection* (*get_primary_keys) (GdaDataDbTable* self);
};

struct _GdaDataDbSchemaIface {
	GTypeInterface parent_iface;
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbSchema* self);
	void (*set_catalog) (GdaDataDbSchema* self, GdaDataDbCatalog* value);
	GeeCollection* (*get_tables) (GdaDataDbSchema* self);
};

struct _GdaDataDbCollectionIface {
	GTypeInterface parent_iface;
	GeeCollection* (*get_schemas) (GdaDataDbCollection* self);
};

struct _GdaDataDataBase {
	GObject parent_instance;
	GdaDataDataBasePrivate * priv;
	GeeHashMap* _schemas;
};

struct _GdaDataDataBaseClass {
	GObjectClass parent_class;
};

struct _GdaDataDataBasePrivate {
	gboolean _update_meta;
	GdaConnection* _connection;
	gchar* _name;
};


static gpointer gda_data_data_base_parent_class = NULL;
static GdaDataDbObjectIface* gda_data_data_base_gda_data_db_object_parent_iface = NULL;
static GdaDataDbNamedObjectIface* gda_data_data_base_gda_data_db_named_object_parent_iface = NULL;
static GdaDataDbCollectionIface* gda_data_data_base_gda_data_db_collection_parent_iface = NULL;

GType gda_data_db_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_named_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_catalog_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_attribute_get_type (void) G_GNUC_CONST;
gpointer gda_data_db_field_info_foreign_key_ref (gpointer instance);
void gda_data_db_field_info_foreign_key_unref (gpointer instance);
GParamSpec* gda_data_db_field_info_param_spec_foreign_key (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gda_data_db_field_info_value_set_foreign_key (GValue* value, gpointer v_object);
void gda_data_db_field_info_value_take_foreign_key (GValue* value, gpointer v_object);
gpointer gda_data_db_field_info_value_get_foreign_key (const GValue* value);
GType gda_data_db_field_info_foreign_key_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_table_type_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_attribute_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_get_type (void) G_GNUC_CONST;
GType gda_data_db_record_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_get_type (void) G_GNUC_CONST;
GType gda_data_db_schema_get_type (void) G_GNUC_CONST;
GType gda_data_db_collection_get_type (void) G_GNUC_CONST;
GType gda_data_data_base_get_type (void) G_GNUC_CONST;
#define GDA_DATA_DATA_BASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GDA_DATA_TYPE_DATA_BASE, GdaDataDataBasePrivate))
enum  {
	GDA_DATA_DATA_BASE_DUMMY_PROPERTY,
	GDA_DATA_DATA_BASE_CONNECTION,
	GDA_DATA_DATA_BASE_UPDATE_META,
	GDA_DATA_DATA_BASE_NAME,
	GDA_DATA_DATA_BASE_SCHEMAS
};
static void gda_data_data_base_real_update (GdaDataDbObject* base, GError** error);
gboolean gda_data_db_object_get_update_meta (GdaDataDbObject* self);
GdaConnection* gda_data_db_object_get_connection (GdaDataDbObject* self);
GType gda_data_schema_get_type (void) G_GNUC_CONST;
GdaDataSchema* gda_data_schema_new (void);
GdaDataSchema* gda_data_schema_construct (GType object_type);
void gda_data_db_object_set_connection (GdaDataDbObject* self, GdaConnection* value);
void gda_data_db_named_object_set_name (GdaDataDbNamedObject* self, const gchar* value);
const gchar* gda_data_db_named_object_get_name (GdaDataDbNamedObject* self);
void gda_data_db_object_set_update_meta (GdaDataDbObject* self, gboolean value);
static void gda_data_data_base_real_save (GdaDataDbObject* base, GError** error);
static void gda_data_data_base_real_append (GdaDataDbObject* base, GError** error);
static void gda_data_data_base_real_drop (GdaDataDbObject* base, gboolean cascade, GError** error);
GdaDataDataBase* gda_data_data_base_new (void);
GdaDataDataBase* gda_data_data_base_construct (GType object_type);
static void gda_data_data_base_finalize (GObject* obj);
GeeCollection* gda_data_db_collection_get_schemas (GdaDataDbCollection* self);
static void _vala_gda_data_data_base_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gda_data_data_base_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gda_data_data_base_real_update (GdaDataDbObject* base, GError** error) {
	GdaDataDataBase * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GdaMetaStore* store = NULL;
	GdaConnection* _tmp4_ = NULL;
	GdaConnection* _tmp5_ = NULL;
	GdaMetaStore* _tmp6_ = NULL;
	GdaMetaStore* _tmp7_ = NULL;
	GdaDataModel* msch = NULL;
	GdaMetaStore* _tmp8_ = NULL;
	GdaDataModel* _tmp9_ = NULL;
	gint r = 0;
	GError * _inner_error_ = NULL;
	self = (GdaDataDataBase*) base;
	_tmp0_ = gda_data_db_object_get_update_meta ((GdaDataDbObject*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GdaConnection* _tmp2_ = NULL;
		GdaConnection* _tmp3_ = NULL;
		_tmp2_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
		_tmp3_ = _tmp2_;
		gda_connection_update_meta_store (_tmp3_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp4_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gda_connection_get_meta_store (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	store = _tmp7_;
	_tmp8_ = store;
	_tmp9_ = gda_meta_store_extract_v (_tmp8_, "SELECT * FROM _schemata", NULL, &_inner_error_);
	msch = _tmp9_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (store);
		return;
	}
	{
		gboolean _tmp10_ = FALSE;
		r = 0;
		_tmp10_ = TRUE;
		while (TRUE) {
			gint _tmp12_ = 0;
			GdaDataModel* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			GdaDataSchema* schema = NULL;
			GdaDataSchema* _tmp15_ = NULL;
			GdaDataSchema* _tmp16_ = NULL;
			GdaConnection* _tmp17_ = NULL;
			GdaConnection* _tmp18_ = NULL;
			GValue* _tmp19_ = NULL;
			GdaDataModel* _tmp20_ = NULL;
			GdaDataModel* _tmp21_ = NULL;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
			GValue* _tmp24_ = NULL;
			GdaDataSchema* _tmp25_ = NULL;
			GeeHashMap* _tmp26_ = NULL;
			GdaDataSchema* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			GdaDataSchema* _tmp30_ = NULL;
			if (!_tmp10_) {
				gint _tmp11_ = 0;
				_tmp11_ = r;
				r = _tmp11_ + 1;
			}
			_tmp10_ = FALSE;
			_tmp12_ = r;
			_tmp13_ = msch;
			_tmp14_ = gda_data_model_get_n_rows (_tmp13_);
			if (!(_tmp12_ < _tmp14_)) {
				break;
			}
			_tmp15_ = gda_data_schema_new ();
			schema = _tmp15_;
			_tmp16_ = schema;
			_tmp17_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
			_tmp18_ = _tmp17_;
			gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp16_, _tmp18_);
			_tmp20_ = msch;
			_tmp21_ = msch;
			_tmp22_ = gda_data_model_get_column_index (_tmp21_, "schema_name");
			_tmp23_ = r;
			_tmp24_ = gda_data_model_get_value_at (_tmp20_, _tmp22_, _tmp23_, &_inner_error_);
			_tmp19_ = _tmp24_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (schema);
				_g_object_unref0 (msch);
				_g_object_unref0 (store);
				return;
			}
			_tmp25_ = schema;
			gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp25_, g_value_get_string (_tmp19_));
			_tmp26_ = self->_schemas;
			_tmp27_ = schema;
			_tmp28_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = schema;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, _tmp29_, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchema));
			_g_object_unref0 (schema);
		}
	}
	gda_data_db_object_set_update_meta ((GdaDataDbObject*) self, FALSE);
	_g_object_unref0 (msch);
	_g_object_unref0 (store);
}


static void gda_data_data_base_real_save (GdaDataDbObject* base, GError** error) {
	GdaDataDataBase * self;
	self = (GdaDataDataBase*) base;
}


static void gda_data_data_base_real_append (GdaDataDbObject* base, GError** error) {
	GdaDataDataBase * self;
	self = (GdaDataDataBase*) base;
}


static void gda_data_data_base_real_drop (GdaDataDbObject* base, gboolean cascade, GError** error) {
	GdaDataDataBase * self;
	self = (GdaDataDataBase*) base;
}


GdaDataDataBase* gda_data_data_base_construct (GType object_type) {
	GdaDataDataBase * self = NULL;
	self = (GdaDataDataBase*) g_object_new (object_type, NULL);
	return self;
}


GdaDataDataBase* gda_data_data_base_new (void) {
	return gda_data_data_base_construct (GDA_DATA_TYPE_DATA_BASE);
}


static GdaConnection* gda_data_data_base_real_get_connection (GdaDataDbObject* base) {
	GdaConnection* result;
	GdaDataDataBase* self;
	GdaConnection* _tmp0_ = NULL;
	self = (GdaDataDataBase*) base;
	_tmp0_ = self->priv->_connection;
	result = _tmp0_;
	return result;
}


static void gda_data_data_base_real_set_connection (GdaDataDbObject* base, GdaConnection* value) {
	GdaDataDataBase* self;
	GdaConnection* _tmp0_ = NULL;
	GdaConnection* _tmp1_ = NULL;
	self = (GdaDataDataBase*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_connection);
	self->priv->_connection = _tmp1_;
	g_object_notify ((GObject *) self, "connection");
}


static gboolean gda_data_data_base_real_get_update_meta (GdaDataDbObject* base) {
	gboolean result;
	GdaDataDataBase* self;
	gboolean _tmp0_ = FALSE;
	self = (GdaDataDataBase*) base;
	_tmp0_ = self->priv->_update_meta;
	result = _tmp0_;
	return result;
}


static void gda_data_data_base_real_set_update_meta (GdaDataDbObject* base, gboolean value) {
	GdaDataDataBase* self;
	gboolean _tmp0_ = FALSE;
	self = (GdaDataDataBase*) base;
	_tmp0_ = value;
	self->priv->_update_meta = _tmp0_;
	g_object_notify ((GObject *) self, "update-meta");
}


static const gchar* gda_data_data_base_real_get_name (GdaDataDbNamedObject* base) {
	const gchar* result;
	GdaDataDataBase* self;
	const gchar* _tmp0_ = NULL;
	self = (GdaDataDataBase*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void gda_data_data_base_real_set_name (GdaDataDbNamedObject* base, const gchar* value) {
	GdaDataDataBase* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (GdaDataDataBase*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


static GeeCollection* gda_data_data_base_real_get_schemas (GdaDataDbCollection* base) {
	GeeCollection* result;
	GdaDataDataBase* self;
	GeeHashMap* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	self = (GdaDataDataBase*) base;
	_tmp0_ = self->_schemas;
	_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void gda_data_data_base_class_init (GdaDataDataBaseClass * klass) {
	gda_data_data_base_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GdaDataDataBasePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gda_data_data_base_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gda_data_data_base_set_property;
	G_OBJECT_CLASS (klass)->finalize = gda_data_data_base_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_DATA_BASE_CONNECTION, g_param_spec_object ("connection", "connection", "connection", gda_connection_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_DATA_BASE_UPDATE_META, g_param_spec_boolean ("update-meta", "update-meta", "update-meta", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_DATA_BASE_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_DATA_BASE_SCHEMAS, g_param_spec_object ("schemas", "schemas", "schemas", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gda_data_data_base_gda_data_db_object_interface_init (GdaDataDbObjectIface * iface) {
	gda_data_data_base_gda_data_db_object_parent_iface = g_type_interface_peek_parent (iface);
	iface->update = (void (*)(GdaDataDbObject*, GError**)) gda_data_data_base_real_update;
	iface->save = (void (*)(GdaDataDbObject*, GError**)) gda_data_data_base_real_save;
	iface->append = (void (*)(GdaDataDbObject*, GError**)) gda_data_data_base_real_append;
	iface->drop = (void (*)(GdaDataDbObject*, gboolean, GError**)) gda_data_data_base_real_drop;
	iface->get_connection = gda_data_data_base_real_get_connection;
	iface->set_connection = gda_data_data_base_real_set_connection;
	iface->get_update_meta = gda_data_data_base_real_get_update_meta;
	iface->set_update_meta = gda_data_data_base_real_set_update_meta;
}


static void gda_data_data_base_gda_data_db_named_object_interface_init (GdaDataDbNamedObjectIface * iface) {
	gda_data_data_base_gda_data_db_named_object_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = gda_data_data_base_real_get_name;
	iface->set_name = gda_data_data_base_real_set_name;
}


static void gda_data_data_base_gda_data_db_collection_interface_init (GdaDataDbCollectionIface * iface) {
	gda_data_data_base_gda_data_db_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_schemas = gda_data_data_base_real_get_schemas;
}


static void gda_data_data_base_instance_init (GdaDataDataBase * self) {
	GeeHashMap* _tmp0_ = NULL;
	self->priv = GDA_DATA_DATA_BASE_GET_PRIVATE (self);
	self->priv->_update_meta = FALSE;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GDA_DATA_TYPE_DB_SCHEMA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->_schemas = _tmp0_;
}


static void gda_data_data_base_finalize (GObject* obj) {
	GdaDataDataBase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GDA_DATA_TYPE_DATA_BASE, GdaDataDataBase);
	_g_object_unref0 (self->_schemas);
	_g_object_unref0 (self->priv->_connection);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (gda_data_data_base_parent_class)->finalize (obj);
}


GType gda_data_data_base_get_type (void) {
	static volatile gsize gda_data_data_base_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_data_base_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GdaDataDataBaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gda_data_data_base_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GdaDataDataBase), 0, (GInstanceInitFunc) gda_data_data_base_instance_init, NULL };
		static const GInterfaceInfo gda_data_db_object_info = { (GInterfaceInitFunc) gda_data_data_base_gda_data_db_object_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gda_data_db_named_object_info = { (GInterfaceInitFunc) gda_data_data_base_gda_data_db_named_object_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gda_data_db_collection_info = { (GInterfaceInitFunc) gda_data_data_base_gda_data_db_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gda_data_data_base_type_id;
		gda_data_data_base_type_id = g_type_register_static (G_TYPE_OBJECT, "GdaDataDataBase", &g_define_type_info, 0);
		g_type_add_interface_static (gda_data_data_base_type_id, GDA_DATA_TYPE_DB_OBJECT, &gda_data_db_object_info);
		g_type_add_interface_static (gda_data_data_base_type_id, GDA_DATA_TYPE_DB_NAMED_OBJECT, &gda_data_db_named_object_info);
		g_type_add_interface_static (gda_data_data_base_type_id, GDA_DATA_TYPE_DB_COLLECTION, &gda_data_db_collection_info);
		g_once_init_leave (&gda_data_data_base_type_id__volatile, gda_data_data_base_type_id);
	}
	return gda_data_data_base_type_id__volatile;
}


static void _vala_gda_data_data_base_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GdaDataDataBase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GDA_DATA_TYPE_DATA_BASE, GdaDataDataBase);
	switch (property_id) {
		case GDA_DATA_DATA_BASE_CONNECTION:
		g_value_set_object (value, gda_data_db_object_get_connection ((GdaDataDbObject*) self));
		break;
		case GDA_DATA_DATA_BASE_UPDATE_META:
		g_value_set_boolean (value, gda_data_db_object_get_update_meta ((GdaDataDbObject*) self));
		break;
		case GDA_DATA_DATA_BASE_NAME:
		g_value_set_string (value, gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) self));
		break;
		case GDA_DATA_DATA_BASE_SCHEMAS:
		g_value_take_object (value, gda_data_db_collection_get_schemas ((GdaDataDbCollection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gda_data_data_base_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GdaDataDataBase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GDA_DATA_TYPE_DATA_BASE, GdaDataDataBase);
	switch (property_id) {
		case GDA_DATA_DATA_BASE_CONNECTION:
		gda_data_db_object_set_connection ((GdaDataDbObject*) self, g_value_get_object (value));
		break;
		case GDA_DATA_DATA_BASE_UPDATE_META:
		gda_data_db_object_set_update_meta ((GdaDataDbObject*) self, g_value_get_boolean (value));
		break;
		case GDA_DATA_DATA_BASE_NAME:
		gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



